/**
 * (c) Michel Weststrate 2015 - 2016
 * MIT Licensed
 *
 * Welcome to the mobx sources! To get an global overview of how MobX internally works,
 * this is a good place to start:
 * https://medium.com/@mweststrate/becoming-fully-reactive-an-in-depth-explanation-of-mobservable-55995262a254#.xvbh6qd74
 *
 * Source folders:
 * ===============
 *
 * - api/     Most of the public static methods exposed by the module can be found here.
 * - core/    Implementation of the MobX algorithm; atoms, derivations, reactions, dependency trees, optimizations. Cool stuff can be found here.
 * - types/   All the magic that is need to have observable objects, arrays and values is in this folder. Including the modifiers like `asFlat`.
 * - utils/   Utility stuff.
 *
 */
export { IObservable, IDepTreeNode } from "./core/observable";
export { Reaction, IReactionPublic, IReactionDisposer } from "./core/reaction";
export { IDerivation, untracked, IDerivationState } from "./core/derivation";
export { IAtom, Atom, BaseAtom } from "./core/atom";
export { useStrict, isStrictModeEnabled, IAction } from "./core/action";
export { spy } from "./core/spy";
export { IComputedValue } from "./core/computedvalue";
export { asReference, asFlat, asStructure, asMap } from "./types/modifiers-old";
export { IModifierDescriptor, IEnhancer, isModifierDescriptor } from "./types/modifiers";
export { IInterceptable, IInterceptor } from "./types/intercept-utils";
export { IListenable } from "./types/listen-utils";
export { IObjectWillChange, IObjectChange, IObservableObject, isObservableObject } from "./types/observableobject";
export { IValueDidChange, IValueWillChange, IObservableValue, isObservableValue as isBoxedObservable } from "./types/observablevalue";
export { IObservableArray, IArrayWillChange, IArrayWillSplice, IArrayChange, IArraySplice, isObservableArray } from "./types/observablearray";
export { IKeyValueMap, ObservableMap, IMapEntries, IMapEntry, IMapWillChange, IMapChange, IMapChangeUpdate, IMapChangeAdd, IMapChangeBase, IMapChangeDelete, isObservableMap, map, IObservableMapInitialValues, IMap } from "./types/observablemap";
export { transaction } from "./api/transaction";
export { observable, IObservableFactory, IObservableFactories } from "./api/observable";
export { computed, IComputed, IComputedValueOptions } from "./api/computed";
export { isObservable } from "./api/isobservable";
export { isComputed } from "./api/iscomputed";
export { extendObservable, extendShallowObservable } from "./api/extendobservable";
export { observe } from "./api/observe";
export { intercept } from "./api/intercept";
export { autorun, autorunAsync, when, reaction, IReactionOptions } from "./api/autorun";
export { action, isAction, runInAction, IActionFactory } from "./api/action";
export { expr } from "./api/expr";
export { toJS } from "./api/tojs";
export { ITransformer, createTransformer } from "./api/createtransformer";
export { whyRun } from "./api/whyrun";
export { Lambda, isArrayLike } from "./utils/utils";
export { Iterator } from "./utils/iterable";
export { IObserverTree, IDependencyTree } from "./api/extras";
import { IDerivation } from "./core/derivation";
import { IDepTreeNode } from "./core/observable";
import { IObserverTree, IDependencyTree } from "./api/extras";
export declare const extras: {
    allowStateChanges: <T>(allowStateChanges: boolean, func: () => T) => T;
    deepEqual: (a: any, b: any) => any;
    getAtom: (thing: any, property?: string | undefined) => IDepTreeNode;
    getDebugName: (thing: any, property?: string | undefined) => string;
    getDependencyTree: (thing: any, property?: string | undefined) => IDependencyTree;
    getAdministration: (thing: any, property?: string | undefined) => any;
    getGlobalState: () => any;
    getObserverTree: (thing: any, property?: string | undefined) => IObserverTree;
    isComputingDerivation: () => boolean;
    isSpyEnabled: () => boolean;
    onReactionError: (handler: (error: any, derivation: IDerivation) => void) => () => void;
    reserveArrayBuffer: (max: number) => void;
    resetGlobalState: () => void;
    shareGlobalState: () => void;
    spyReport: (event: any) => void;
    spyReportEnd: (change?: any) => void;
    spyReportStart: (event: any) => void;
    setReactionScheduler: (fn: (f: () => void) => void) => void;
};
declare var exports: any;
export default exports;
