import { IObservableArray, IArrayChange, IArraySplice } from "../types/observablearray";
import { ObservableMap, IMapChange } from "../types/observablemap";
import { IObjectChange } from "../types/observableobject";
import { IComputedValue } from "../core/computedvalue";
import { IObservableValue, IValueDidChange } from "../types/observablevalue";
import { Lambda } from "../utils/utils";
export declare function observe<T>(value: IObservableValue<T> | IComputedValue<T>, listener: (change: IValueDidChange<T>) => void, fireImmediately?: boolean): Lambda;
export declare function observe<T>(observableArray: IObservableArray<T>, listener: (change: IArrayChange<T> | IArraySplice<T>) => void, fireImmediately?: boolean): Lambda;
export declare function observe<T>(observableMap: ObservableMap<T>, listener: (change: IMapChange<T>) => void, fireImmediately?: boolean): Lambda;
export declare function observe<T>(observableMap: ObservableMap<T>, property: string, listener: (change: IValueDidChange<T>) => void, fireImmediately?: boolean): Lambda;
export declare function observe(object: Object, listener: (change: IObjectChange) => void, fireImmediately?: boolean): Lambda;
export declare function observe(object: Object, property: string, listener: (change: IValueDidChange<any>) => void, fireImmediately?: boolean): Lambda;
