import { ObservableValue } from "./observablevalue";
import { ComputedValue, IComputedValueOptions } from "../core/computedvalue";
import { Lambda } from "../utils/utils";
import { IInterceptable } from "./intercept-utils";
import { IListenable } from "./listen-utils";
import { IEnhancer } from "./modifiers";
import { IObservableArray } from "./observablearray";
export interface IObservableObject {
    "observable-object": IObservableObject;
}
export declare type IObjectDidChange = {
    name: string;
    object: any;
    type: "add";
    newValue: any;
} | {
    name: string;
    object: any;
    type: "update";
    oldValue: any;
    newValue: any;
} | {
    name: string;
    object: any;
    type: "remove";
    oldValue: any;
};
export declare type IObjectWillChange = {
    object: any;
    type: "update" | "add";
    name: string;
    newValue: any;
} | {
    object: any;
    type: "remove";
    name: string;
};
export declare class ObservableObjectAdministration implements IInterceptable<IObjectWillChange>, IListenable {
    target: any;
    name: string;
    defaultEnhancer: IEnhancer<any>;
    values: {
        [key: string]: ObservableValue<any> | ComputedValue<any>;
    };
    keys: undefined | IObservableArray<string>;
    changeListeners: any;
    interceptors: any;
    constructor(target: any, name: string, defaultEnhancer: IEnhancer<any>);
    read(owner: any, key: string): any;
    write(owner: any, key: string, newValue: any): void;
    remove(key: string): void;
    illegalAccess(owner: any, propName: any): never;
    /**
     * Observes this object. Triggers for the events 'add', 'update' and 'delete'.
     * See: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/observe
     * for callback details
     */
    observe(callback: (changes: IObjectDidChange) => void, fireImmediately?: boolean): Lambda;
    intercept(handler: any): Lambda;
    getKeys(): string[];
}
export interface IIsObservableObject {
    $mobx: ObservableObjectAdministration;
}
export declare function asObservableObject(target: any, name?: string, defaultEnhancer?: IEnhancer<any>): ObservableObjectAdministration;
export declare function defineObservableProperty(target: any, propName: string, newValue: any, enhancer: IEnhancer<any>): void;
export declare function defineComputedProperty(valueOwner: any, propertyOwner: any, propName: string, options: IComputedValueOptions<any>): void;
export declare function generateObservablePropConfig(propName: any): any;
export declare function generateComputedPropConfig(propName: any): any;
export declare function isObservableObject(thing: any): thing is IObservableObject;
