import { IEnhancer, IInterceptor, Lambda } from "../internal";
export interface IObservableArray<T = any> extends Array<T> {
    spliceWithArray(index: number, deleteCount?: number, newItems?: T[]): T[];
    observe(listener: (changeData: IArrayChange<T> | IArraySplice<T>) => void, fireImmediately?: boolean): Lambda;
    intercept(handler: IInterceptor<IArrayWillChange<T> | IArrayWillSplice<T>>): Lambda;
    clear(): T[];
    replace(newItems: T[]): T[];
    remove(value: T): boolean;
}
export interface IArrayChange<T = any> {
    type: "update";
    object: IObservableArray<T>;
    index: number;
    newValue: T;
    oldValue: T;
}
export interface IArraySplice<T = any> {
    type: "splice";
    object: IObservableArray<T>;
    index: number;
    added: T[];
    addedCount: number;
    removed: T[];
    removedCount: number;
}
export interface IArrayWillChange<T = any> {
    type: "update";
    object: IObservableArray<T>;
    index: number;
    newValue: T;
}
export interface IArrayWillSplice<T = any> {
    type: "splice";
    object: IObservableArray<T>;
    index: number;
    added: T[];
    removedCount: number;
}
export declare function createObservableArray<T>(initialValues: any[] | undefined, enhancer: IEnhancer<T>, name?: string, owned?: boolean): IObservableArray<T>;
export declare function isObservableArray(thing: any): thing is IObservableArray<any>;
