'use strict';

import { objToArr, reviverOrAsIs } from './U';
import AbstractMap from './AbstractMap';
import AsIs from './AsIs';
import Any from './Any';

const stringifyMapper = pair => ({key: pair[0], value: pair[1]});

const parseMapper = innerTypes => pairObject => [
  reviverOrAsIs(innerTypes.keyMetadata)('', pairObject.key),
  reviverOrAsIs(innerTypes.valueMetadata)('', pairObject.value)
];

const reviverFactory = innerTypes => (k, v) => {
  if (k !== '') {
    return v;
  }

  const innerMap = (v === null) ? null : new Map(v.map(parseMapper(innerTypes)));

  return new ModelicoMap(innerTypes.keyMetadata, innerTypes.valueMetadata, innerMap);
};

class ModelicoMap extends AbstractMap {
  constructor(keyMetadata, valueMetadata, innerMap) {
    super(ModelicoMap, keyMetadata, valueMetadata, innerMap);

    return Object.freeze(this);
  }

  set(enumerator, value) {
    return AbstractMap.set.call(this, ModelicoMap, enumerator, value);
  }

  toJSON() {
    const innerMap = this.fields().innerMap;

    return (innerMap === null) ? null : Array.from(innerMap).map(stringifyMapper);
  }

  static fromObject(obj) {
    return ModelicoMap.fromMap(new Map(objToArr(obj)));
  }

  static fromMap(map) {
    return new ModelicoMap(AsIs(String), AsIs(Any), map);
  }

  static metadata(keyMetadata, valueMetadata) {
    return AbstractMap.metadata(ModelicoMap, reviverFactory, keyMetadata, valueMetadata);
  }
}

export default Object.freeze(ModelicoMap);
