'use strict';

import { reviverOrAsIs } from './U';
import AbstractMap from './AbstractMap';

const stringifyReducer = (acc, pair) => {
  acc[pair[0].toJSON()] = pair[1];

  return acc;
};

const parseMapper = (keyMetadata, valueMetadata, object) => { return enumerator => {
  const reviveKey = reviverOrAsIs(keyMetadata);
  const key = reviveKey('', enumerator);

  const reviveVal = reviverOrAsIs(valueMetadata);
  const val = reviveVal('', object[enumerator]);

  return [key, val];
}};

const reviverFactory = (keyMetadata, valueMetadata) => { return (k, v) => {
  if (k !== '') {
    return v;
  }

  const innerMap = (v === null) ?
    null :
    new Map(Object.keys(v).map(parseMapper(keyMetadata, valueMetadata, v)));

  return new ModelicoEnumMap(innerMap);
}};

class ModelicoEnumMap extends AbstractMap {
  constructor(innerMap) {
    super(ModelicoEnumMap, innerMap);

    Object.freeze(this);
  }

  set(enumerator, value) {
    return AbstractMap.set.call(this, ModelicoEnumMap, enumerator, value);
  }

  toJSON() {
    return [...this.inner()].reduce(stringifyReducer, {});
  }

  static fromMap(map) {
    return new ModelicoEnumMap(map);
  }

  static metadata(keyMetadata, valueMetadata) {
    return AbstractMap.metadata(ModelicoEnumMap, reviverFactory(keyMetadata, valueMetadata));
  }
}

ModelicoEnumMap.EMPTY = ModelicoEnumMap.fromMap(new Map([]));

export default Object.freeze(ModelicoEnumMap);
