# MOD.UK Frontend

> **20 October 2023:** The Defence Developer Services (D2S) will shortly
> commence work on its re-use strategy and the discovery and delivery of a
> re-use components service. As part of this, we will commence a Discovery
> activity for the Design System Toolkit. During the Discovery Phase, the MOD.UK
> Frontend and Design Library will be in maintenance mode with no further
> enhancements being made during this time. Only high priority issues such as
> security fixes or outages will be completed.

MOD.UK Frontend contains the code for components you’ll need to build user
interfaces for Defence products and services.

See
[guidance on the components with coded examples](https://design-system.service.mod.gov.uk/components/).

## Support

You can
[report bugs or request new features](https://github.com/defencedigital/moduk-frontend/issues/new/choose).

Email [design-system@digital.mod.uk](mailto:design-system@digital.mod.uk) if you
have questions or any feedback. Please share examples of how you are using
MOD.UK Frontend.

## Get started

You need to install MOD.UK Frontend to use the components in the MOD.UK Design
System in your production environment.

See
[setup guide for developers](https://design-system.service.mod.gov.uk/get-started/setup-guide-for-developers/)
which shows you how to start using MOD.UK Frontend.

## Design library

Design and prototype your Defence project with our
[component design library in Figma](https://design-system.dev.service.mod.gov.uk/get-started/design-library/).

## Browser and assistive technology support

MOD.UK Frontend aims to support:

- [recommended browsers](https://www.gov.uk/service-manual/technology/designing-for-different-browsers-and-devices#browsers-to-test-in)
- [recommended assistive technologies](https://www.gov.uk/service-manual/technology/testing-with-assistive-technologies#which-assistive-technologies-to-test-with)
- your users overriding colours in Windows, Firefox and Chrome

## Accessibility

Using MOD.UK Frontend will help your service meet
[level AA of WCAG 2.1](https://www.gov.uk/service-manual/helping-people-to-use-your-service/understanding-wcag).
But you must still
[check that your service meets accessibility requirements](https://www.gov.uk/service-manual/helping-people-to-use-your-service/making-your-service-accessible-an-introduction),
especially if you extend or modify components.

You should also use the
[JavaScript from MOD.UK Frontend](https://design-system.service.mod.gov.uk/get-started/setup-guide-for-developers/#5.-load-the-javascript).

### Accessibility warnings: known issues

If you get a warning from a linter or accessibility checker, check a list of
[issues you should not need to fix](https://github.com/alphagov/govuk-frontend/issues/1280#issuecomment-509588851).

## Getting updates

To be notified when there’s a new release you can
[watch the moduk-frontend repository](https://docs.github.com/en/account-and-profile/managing-subscriptions-and-notifications-on-github/setting-up-notifications/configuring-notifications#configuring-your-watch-settings-for-an-individual-repository).
(After selecting ‘Watch’, choose the ‘Custom’ option and select ‘Releases’.)

## Security

If you have found a security vulnerability, please let us know so we can fix it.

[Report a vulnerability on an MOD system](https://www.gov.uk/guidance/report-a-vulnerability-on-an-mod-system).

## Licence

Unless stated otherwise, the codebase is released under the MIT License. This
covers both the codebase and any sample code in the documentation. The
documentation is © Crown copyright and available under the terms of the Open
Government 3.0 licence.
