import { type ConfigureOptions, type Environment } from 'nunjucks';
/**
 * Get the template paths that should be specified when manually creating a new
 * Nunjucks environment.
 */
export declare function getNunjucksPaths(): string[];
/**
 * Add MOD.UK extensions to an existing Nunjucks environment.
 * @param nunjucksEnv Nunjucks environment
 */
export declare function addNunjucksExtensions(nunjucksEnv: Environment): void;
/**
 * @deprecated Use addNunjucksExtensions instead.
 * Add MOD.UK filters to an existing Nunjucks environment.
 * @param nunjucksEnv Nunjucks environment
 */
export declare function addMODUKFilters(nunjucksEnv: Environment): void;
/**
 * Create a Nunjucks environment pre-configured with MOD.UK template paths and internal extensions.
 *
 * @param templatePaths Additional template paths to add
 * @param options Environment configuration options
 */
export declare function createNunjucksEnvironment(templatePaths?: string[], options?: ConfigureOptions | undefined): Environment;
//# sourceMappingURL=utils.d.ts.map