"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createNunjucksEnvironment = exports.addMODUKFilters = exports.addNunjucksExtensions = exports.getNunjucksPaths = void 0;
var lodash_1 = require("lodash");
var node_fs_1 = require("node:fs");
var node_path_1 = require("node:path");
var nunjucks_1 = require("nunjucks");
/**
 * Get the template paths that should be specified when manually creating a new
 * Nunjucks environment.
 */
function getNunjucksPaths() {
    var govukFrontendPath = (0, node_path_1.dirname)((0, node_path_1.dirname)(require.resolve('govuk-frontend')));
    return [
        (0, node_path_1.join)(__dirname, '..', 'nunjucks'),
        govukFrontendPath,
    ];
}
exports.getNunjucksPaths = getNunjucksPaths;
var addCustomMODUKClass = function (params, classToAdd, options) {
    var _a;
    var propertyPath = (_a = options === null || options === void 0 ? void 0 : options.path) !== null && _a !== void 0 ? _a : 'classes';
    var classesFromPath = (0, lodash_1.get)(params, propertyPath, '');
    var classes = classesFromPath.split(' ');
    var notRegex = options === null || options === void 0 ? void 0 : options.not;
    var hasNotClass = notRegex && classes.some(function (className) { return className.trim().match(notRegex); });
    if (hasNotClass) {
        return params;
    }
    return (0, lodash_1.set)(__assign({}, params), propertyPath, classesFromPath ? "".concat(classToAdd, " ").concat(classesFromPath) : "".concat(classToAdd));
};
/**
 * Add MOD.UK svg loader to an existing Nunjucks environment.
 * @param nunjucksEnv Nunjucks environment
 * Based from https://github.com/11ty/eleventy/blob/v2.0.1/src/Engines/Nunjucks.js#L166-L228
 * as https://mozilla.github.io/nunjucks/api.html#custom-tags
 */
function addSvgExtension(nunjucksEnv) {
    var SvgLoader = /** @class */ (function () {
        function SvgLoader() {
            this.tags = ['MODUKincludeSVG'];
        }
        /* eslint-disable-next-line @typescript-eslint/no-explicit-any */
        SvgLoader.prototype.parse = function (parser, nodes) {
            var tok = parser.nextToken();
            var args = parser.parseSignature(null, true);
            parser.advanceAfterBlockEnd(tok.value);
            return new nodes.CallExtension(this, 'run', args, null);
        };
        /* eslint-disable-next-line class-methods-use-this */
        SvgLoader.prototype.run = function (_context, fileName) {
            var svgPath = "".concat((0, node_path_1.join)(__dirname, '..', '/assets/svg', (0, node_path_1.basename)(fileName, '.svg')), ".svg");
            return new nunjucks_1.runtime.SafeString((0, node_fs_1.readFileSync)(svgPath, 'utf8'));
        };
        return SvgLoader;
    }());
    nunjucksEnv.addExtension('MODUKincludeSVG', new SvgLoader());
}
/**
 * Add MOD.UK extensions to an existing Nunjucks environment.
 * @param nunjucksEnv Nunjucks environment
 */
function addNunjucksExtensions(nunjucksEnv) {
    nunjucksEnv.addFilter('addCustomMODUKClass', addCustomMODUKClass);
    addSvgExtension(nunjucksEnv);
}
exports.addNunjucksExtensions = addNunjucksExtensions;
/**
 * @deprecated Use addNunjucksExtensions instead.
 * Add MOD.UK filters to an existing Nunjucks environment.
 * @param nunjucksEnv Nunjucks environment
 */
function addMODUKFilters(nunjucksEnv) {
    addNunjucksExtensions(nunjucksEnv);
}
exports.addMODUKFilters = addMODUKFilters;
/**
 * Create a Nunjucks environment pre-configured with MOD.UK template paths and internal extensions.
 *
 * @param templatePaths Additional template paths to add
 * @param options Environment configuration options
 */
function createNunjucksEnvironment(templatePaths, options) {
    if (templatePaths === void 0) { templatePaths = []; }
    if (options === void 0) { options = undefined; }
    var env = (0, nunjucks_1.configure)(__spreadArray(__spreadArray([], getNunjucksPaths(), true), templatePaths, true), options);
    addNunjucksExtensions(env);
    return env;
}
exports.createNunjucksEnvironment = createNunjucksEnvironment;
//# sourceMappingURL=utils.js.map