import { type ComponentPropsWithoutRef } from 'react';
import type { PermissiveChild } from '../internal/PermissiveChild';
import type { AccordionHeadingTag } from './AccordionHeadingTag';
import type { AccordionItemProps } from './AccordionItem';
export interface AccordionProps extends ComponentPropsWithoutRef<'div'> {
    /**
     * Instances of AccordionItem.
     */
    children: PermissiveChild<AccordionItemProps>;
    /**
     * HTML tag to use for item headings.
     */
    headingTag?: AccordionHeadingTag;
    /**
     * The text content of the 'Hide all sections' button at
     * the top of the accordion when all sections are expanded.
     */
    hideAllSectionsText?: string;
    /**
     * The text content of the 'Hide' button within each section
     * of the accordion, which is visible when the section is
     * expanded.
     */
    hideSectionText?: string;
    /**
     * Text made available to assistive technologies, like
     * screen readers, as the final part of the toggle's
     * accessible name when the section is expanded. Defaults
     * to 'Hide this section'.
     */
    hideSectionAriaLabelText?: string;
    /**
     * Unique identifier for the accordion.
     *
     * Must be unique across the domain of your service if
     * rememberExpanded is set.
     */
    id: string;
    /**
     * Whether the expanded/collapsed state of the accordion
     * should be saved when a user leaves the page and restored
     * when they return. Default is true.
     */
    rememberExpanded?: boolean;
    /**
     * The text content of the 'Show all sections' button at the
     * top of the accordion when at least one section is collapsed.
     */
    showAllSectionsText?: string;
    /**
     * Text made available to assistive technologies, like screen
     * readers, as the final part of the toggle's accessible name
     * when the section is collapsed. Defaults to 'Show this
     * section'.
     */
    showSectionAriaLabelText?: string;
    /**
     * The text content of the 'Show' button within each section
     * of the accordion, which is visible when the section is
     * collapsed.
     */
    showSectionText?: string;
}
/**
 * Accordion.
 *
 * @experimental React components are in alpha and subject to change.
 *
 * @example
 * <Accordion id='example-accordion'>
 *   <AccordionItem heading='Writing well for the web'>
 *     <p className='govuk-body'>This is the content for Writing well for the web.</p>
 *   </AccordionItem>
 *   <AccordionItem heading='Writing well for specialists'>
 *     <p className='govuk-body'>This is the content for Writing well for specialists.</p>
 *   </AccordionItem>
 *   <AccordionItem heading='Know your audience'>
 *     <p className='govuk-body'>This is the content for Know your audience.</p>
 *   </AccordionItem>
 *   <AccordionItem heading='How people read'>
 *     <p className='govuk-body'>This is the content for How people read.</p>
 *   </AccordionItem>
 * </Accordion>
 */
export declare const Accordion: import("react").ForwardRefExoticComponent<AccordionProps & import("react").RefAttributes<HTMLDivElement>>;
//# sourceMappingURL=Accordion.d.ts.map