import { type LinkComponent } from '../internal/Link/Link';
import type { PermissiveChild } from '../internal/PermissiveChild';
interface BackLinkProps {
    children: PermissiveChild;
    className?: string;
}
/**
 * A back link.
 *
 * @experimental React components are in alpha and subject to change.
 *
 * @example
 * <BackLink href='/previous-page'>Back</BackLink>
 *
 * @example
 * <BackLink component={Link} to='/previous-page'>Back</BackLink>
 */
export declare const BackLink: LinkComponent<BackLinkProps>;
export {};
//# sourceMappingURL=BackLink.d.ts.map