import { type TextareaProps } from '../textarea';
interface CharacterCountPluralMessage {
    /**
     * Message for when the count is exactly 1.
     */
    one: string;
    /**
     * Message for when the count is not 1.
     */
    other: string;
}
interface CharacterCountMessageConfig {
    /**
     * Message made available to assistive technologies to describe
     * that the component accepts only a limited amount of content.
     * It is visible on the page when JavaScript is unavailable. The
     * component will replace the `%{count}` placeholder with the
     * value of the `maxLength` or `maxWords` prop.
     */
    textareaDescriptionText?: string;
    /**
     * Message displayed when the number of characters is under the
     * configured maximum, `maxLength`. This message is displayed
     * visually and through assistive technologies. The component
     * will replace the `%{count}` placeholder with the number of
     * remaining characters.
     */
    charactersUnderLimitText?: Partial<CharacterCountPluralMessage>;
    /**
     * Message displayed when the number of characters reaches the
     * configured maximum, `maxLength`. This message is displayed
     * visually and through assistive technologies.
     */
    charactersAtLimitText?: string;
    /**
     * Message displayed when the number of characters is over the
     * configured maximum, `maxLength`. This message is displayed
     * visually and through assistive technologies. The component
     * will replace the `%{count}` placeholder with the number of
     * characters above the maximum.
     */
    charactersOverLimitText?: Partial<CharacterCountPluralMessage>;
    /**
     * Message displayed when the number of words is under the
     * configured maximum, `maxWords`. This message is displayed
     * visually and through assistive technologies. The component
     * will replace the `%{count}` placeholder with the number of
     * remaining words.
     */
    wordsUnderLimitText?: Partial<CharacterCountPluralMessage>;
    /**
     * Message displayed when the number of words reaches the
     * configured maximum, `maxWords`. This message is displayed
     * visually and through assistive technologies.
     */
    wordsAtLimitText?: string;
    /**
     * Message displayed when the number of words is over the
     * configured maximum, `maxWords`. This message is displayed
     * visually and through assistive technologies. The component
     * will replace the `%{count}` placeholder with the number of
     * characters above the maximum.
     */
    wordsOverLimitText?: Partial<CharacterCountPluralMessage>;
}
interface BaseCharacterCountProps extends TextareaProps, CharacterCountMessageConfig {
    /**
     * Defines a threshold that must be reached before the
     * character count message is displayed.
     * This is a value between 0 and 1, representing a percentage
     * of `maxLength` or `maxWords`.
     */
    threshold?: number;
    /**
     * CSS classes to add to the count message.
     */
    countMessageClassname?: string;
}
interface LengthCharacterCountProps extends BaseCharacterCountProps {
    /**
     * The maximum number of characters. Required if `maxWords`
     * is not set. Cannot be set if `maxWords` is set.
     */
    maxLength: number;
    maxWords?: never;
}
interface WordCharacterCountProps extends BaseCharacterCountProps {
    maxLength?: never;
    /**
     * The maximum number of words. Required if `maxLength`
     * is not set. Cannot be set if `maxLength` is set.
     */
    maxWords: number;
}
export type CharacterCountProps = LengthCharacterCountProps | WordCharacterCountProps;
/**
 * Character count.
 *
 * @experimental React components are in alpha and subject to change.
 *
 * @example
 * <CharacterCount
 *   label={
 *     <Label className='govuk-label--l' isPageHeading>
 *       Can you provide more detail?
 *     </Label>
 *   }
 *   hint={<Hint>Do not include personal information like your service number.</Hint>}
 *   maxLength={200}
 *   name='with-hint'
 * />
 */
export declare const CharacterCount: import("react").ForwardRefExoticComponent<CharacterCountProps & import("react").RefAttributes<HTMLTextAreaElement>>;
export {};
//# sourceMappingURL=CharacterCount.d.ts.map