import { type ComponentPropsWithoutRef, type ReactNode } from 'react';
export interface DetailsProps extends ComponentPropsWithoutRef<'details'> {
    /**
     * Content to be displayed when the details element is expanded.
     */
    children: ReactNode;
    /**
     * Content for the summary element.
     */
    summary: ReactNode;
}
/**
 * Details component.
 *
 * @experimental React components are in alpha and subject to change.
 *
 * @example
 * <Details summary='Help with organisation'>
 *   We need to know the organisation you work for so we can forward your request to the correct team.
 * </Details>
 */
export declare const Details: import("react").ForwardRefExoticComponent<DetailsProps & import("react").RefAttributes<HTMLDetailsElement>>;
//# sourceMappingURL=Details.d.ts.map