'use client';

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["children", "className", "headingTag", "hideAllSectionsText", "hideSectionText", "hideSectionAriaLabelText", "id", "rememberExpanded", "showAllSectionsText", "showSectionText", "showSectionAriaLabelText"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } } return target; }
import clsx from 'clsx';
import { isEqual, pick } from 'lodash';
import { forwardRef, isValidElement, useMemo, useRef } from 'react';
import flattenChildren from 'react-keyed-flatten-children';
import { mergeRefs } from 'react-merge-refs';
import { useMODUKComponent } from '../internal/hooks/useMODUKComponent';
import { usePrevious } from '../internal/hooks/usePrevious';
import { AccordionContext } from './AccordionContext';
import { AccordionItemIndexContext } from './AccordionItemIndexContext';
import { jsx as _jsx } from "react/jsx-runtime";
function getRemountProps(props) {
  var rootProps = pick(props, ['headingTag', 'hideAllSectionsText', 'hideSectionAriaLabelText', 'hideSectionText', 'rememberExpanded', 'showAllSectionsText', 'showSectionAriaLabelText', 'showSectionText']);
  var childrenProps = flattenChildren(props.children).filter(isValidElement).map(function (child) {
    return pick(child.props, ['heading', 'summary', 'expanded']);
  });
  return [rootProps, childrenProps];
}
export var Accordion = forwardRef(function (props, forwardedRef) {
  var _useMODUKComponent = useMODUKComponent('Accordion'),
    ref = _useMODUKComponent.ref;
  var key = useRef(0);
  var remountProps = getRemountProps(props);
  var previousRemountProps = usePrevious(remountProps);
  if (!isEqual(previousRemountProps, remountProps)) {
    key.current += 1;
  }
  var children = props.children,
    className = props.className,
    _props$headingTag = props.headingTag,
    headingTag = _props$headingTag === void 0 ? 'h2' : _props$headingTag,
    hideAllSectionsText = props.hideAllSectionsText,
    hideSectionText = props.hideSectionText,
    hideSectionAriaLabelText = props.hideSectionAriaLabelText,
    id = props.id,
    rememberExpanded = props.rememberExpanded,
    showAllSectionsText = props.showAllSectionsText,
    showSectionText = props.showSectionText,
    showSectionAriaLabelText = props.showSectionAriaLabelText,
    rest = _objectWithoutProperties(props, _excluded);
  var contextValue = useMemo(function () {
    return {
      headingTag: headingTag,
      id: id
    };
  }, [headingTag, id]);
  var i18nAttributes = {
    'data-i18n.hide-all-sections': hideAllSectionsText,
    'data-i18n.hide-section': hideSectionText,
    'data-i18n.hide-section-aria-label': hideSectionAriaLabelText,
    'data-i18n.show-all-sections': showAllSectionsText,
    'data-i18n.show-section': showSectionText,
    'data-i18n.show-section-aria-label': showSectionAriaLabelText
  };
  var flattenedChildren = flattenChildren(children).filter(isValidElement);
  return _jsx(AccordionContext.Provider, {
    value: contextValue,
    children: _jsx("div", _objectSpread(_objectSpread(_objectSpread({
      ref: mergeRefs([ref, forwardedRef])
    }, rest), {}, {
      className: clsx('govuk-accordion', className),
      "data-module": "govuk-accordion",
      "data-remember-expanded": rememberExpanded,
      id: id
    }, i18nAttributes), {}, {
      children: flattenedChildren.map(function (child, index) {
        return _jsx(AccordionItemIndexContext.Provider, {
          value: index,
          children: child
        }, child.key);
      })
    }), key.current)
  });
});
Accordion.displayName = 'Accordion';