'use client';

import clsx from 'clsx';
import { useContext } from 'react';
import { AccordionContext } from './AccordionContext';
import { AccordionItemIndexContext } from './AccordionItemIndexContext';
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
export function AccordionItem(_ref) {
  var children = _ref.children,
    expanded = _ref.expanded,
    heading = _ref.heading,
    summary = _ref.summary;
  var _useContext = useContext(AccordionContext),
    Heading = _useContext.headingTag,
    id = _useContext.id;
  var index = useContext(AccordionItemIndexContext);
  var headingId = "".concat(id, "-heading-").concat(index + 1);
  var contentId = "".concat(id, "-content-").concat(index + 1);
  return _jsxs("div", {
    className: clsx('govuk-accordion__section', expanded && 'govuk-accordion__section--expanded'),
    children: [_jsxs("div", {
      className: "govuk-accordion__section-header",
      children: [_jsx(Heading, {
        className: "govuk-accordion__section-heading",
        children: _jsx("span", {
          className: "govuk-accordion__section-button",
          id: headingId,
          children: heading
        })
      }), summary && _jsx("div", {
        className: "govuk-accordion__section-summary govuk-body",
        children: summary
      })]
    }), _jsxs("div", {
      id: contentId,
      className: "govuk-accordion__section-content",
      children: [typeof children === 'string' && _jsx("p", {
        className: "govuk-body",
        children: children
      }), typeof children !== 'string' && children]
    })]
  });
}