function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["charactersAtLimitText", "charactersOverLimitText", "charactersUnderLimitText", "className", "countMessageClassname", "maxLength", "maxWords", "onChange", "textareaDescriptionText", "threshold", "wordsAtLimitText", "wordsOverLimitText", "wordsUnderLimitText"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } } return target; }
import clsx from 'clsx';
import { isNil } from 'lodash';
import { forwardRef, useCallback, useEffect, useId, useState } from 'react';
import { mergeRefs } from 'react-merge-refs';
import { Textarea } from '../textarea';
import { useThrottledValue } from './useThrottledValue';
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
var DEFAULT_MESSAGES = {
  charactersUnderLimit: {
    one: 'You have %{count} character remaining',
    other: 'You have %{count} characters remaining'
  },
  charactersAtLimit: 'You have 0 characters remaining',
  charactersOverLimit: {
    one: 'You have %{count} character too many',
    other: 'You have %{count} characters too many'
  },
  textareaDescriptionCharacters: 'You can enter up to %{count} characters',
  textareaDescriptionWords: 'You can enter up to %{count} words',
  wordsUnderLimit: {
    one: 'You have %{count} word remaining',
    other: 'You have %{count} words remaining'
  },
  wordsAtLimit: 'You have 0 words remaining',
  wordsOverLimitText: {
    one: 'You have %{count} word too many',
    other: 'You have %{count} words too many'
  }
};
function getStatusMessageTemplate(countInUnits, maxUnits, isWords, messageOverrides) {
  var _messageOverrides$wor4, _messageOverrides$wor5, _messageOverrides$cha4, _messageOverrides$cha5;
  if (countInUnits > maxUnits) {
    var _messageOverrides$wor, _messageOverrides$wor2, _messageOverrides$cha, _messageOverrides$cha2;
    return isWords ? (_messageOverrides$wor = (_messageOverrides$wor2 = messageOverrides.wordsOverLimitText) === null || _messageOverrides$wor2 === void 0 ? void 0 : _messageOverrides$wor2.other) !== null && _messageOverrides$wor !== void 0 ? _messageOverrides$wor : DEFAULT_MESSAGES.wordsOverLimitText.other : (_messageOverrides$cha = (_messageOverrides$cha2 = messageOverrides.charactersOverLimitText) === null || _messageOverrides$cha2 === void 0 ? void 0 : _messageOverrides$cha2.other) !== null && _messageOverrides$cha !== void 0 ? _messageOverrides$cha : DEFAULT_MESSAGES.charactersOverLimit.other;
  }
  if (countInUnits === maxUnits) {
    var _messageOverrides$wor3, _messageOverrides$cha3;
    return isWords ? (_messageOverrides$wor3 = messageOverrides.wordsAtLimitText) !== null && _messageOverrides$wor3 !== void 0 ? _messageOverrides$wor3 : DEFAULT_MESSAGES.wordsAtLimit : (_messageOverrides$cha3 = messageOverrides.charactersAtLimitText) !== null && _messageOverrides$cha3 !== void 0 ? _messageOverrides$cha3 : DEFAULT_MESSAGES.charactersAtLimit;
  }
  return isWords ? (_messageOverrides$wor4 = (_messageOverrides$wor5 = messageOverrides.wordsUnderLimitText) === null || _messageOverrides$wor5 === void 0 ? void 0 : _messageOverrides$wor5.other) !== null && _messageOverrides$wor4 !== void 0 ? _messageOverrides$wor4 : DEFAULT_MESSAGES.wordsUnderLimit.other : (_messageOverrides$cha4 = (_messageOverrides$cha5 = messageOverrides.charactersUnderLimitText) === null || _messageOverrides$cha5 === void 0 ? void 0 : _messageOverrides$cha5.other) !== null && _messageOverrides$cha4 !== void 0 ? _messageOverrides$cha4 : DEFAULT_MESSAGES.charactersUnderLimit.other;
}
function formatMessage(message, count) {
  return message.replace('%{count}', count.toString());
}
function formatStatusMessage(countInUnits, maxUnits, isWords, messageOverrides) {
  var messageTemplate = getStatusMessageTemplate(countInUnits, maxUnits, isWords, messageOverrides);
  return formatMessage(messageTemplate, Math.abs(maxUnits - countInUnits));
}
function formatDescriptionMessage(maxUnits, isWords, textareaDescriptionText) {
  var descriptionMessageTemplate = textareaDescriptionText !== null && textareaDescriptionText !== void 0 ? textareaDescriptionText : isWords ? DEFAULT_MESSAGES.textareaDescriptionWords : DEFAULT_MESSAGES.textareaDescriptionCharacters;
  return formatMessage(descriptionMessageTemplate, maxUnits);
}
function getTextUnitCount(text, isWords) {
  return isWords ? (text.match(/\S+/g) || []).length : text.length;
}
export var CharacterCount = forwardRef(function (_ref, forwardedRef) {
  var _ref2;
  var charactersAtLimitText = _ref.charactersAtLimitText,
    charactersOverLimitText = _ref.charactersOverLimitText,
    charactersUnderLimitText = _ref.charactersUnderLimitText,
    className = _ref.className,
    countMessageClassname = _ref.countMessageClassname,
    maxLength = _ref.maxLength,
    maxWords = _ref.maxWords,
    onChange = _ref.onChange,
    textareaDescriptionText = _ref.textareaDescriptionText,
    threshold = _ref.threshold,
    wordsAtLimitText = _ref.wordsAtLimitText,
    wordsOverLimitText = _ref.wordsOverLimitText,
    wordsUnderLimitText = _ref.wordsUnderLimitText,
    rest = _objectWithoutProperties(_ref, _excluded);
  var messageOverrides = {
    charactersAtLimitText: charactersAtLimitText,
    charactersOverLimitText: charactersOverLimitText,
    charactersUnderLimitText: charactersUnderLimitText,
    textareaDescriptionText: textareaDescriptionText,
    wordsAtLimitText: wordsAtLimitText,
    wordsOverLimitText: wordsOverLimitText,
    wordsUnderLimitText: wordsUnderLimitText
  };
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isClient = _useState2[0],
    setClient = _useState2[1];
  var _useThrottledValue = useThrottledValue(),
    rawValue = _useThrottledValue.rawValue,
    setValue = _useThrottledValue.setValue,
    throttledValue = _useThrottledValue.throttledValue;
  var id = useId();
  useEffect(function () {
    setClient(true);
  }, []);
  var handleChange = useCallback(function (event) {
    setValue(event.currentTarget.value);
    onChange === null || onChange === void 0 || onChange(event);
  }, [onChange, setValue]);
  var isWords = !isNil(maxWords);
  var maxUnits = (_ref2 = isWords ? maxWords : maxLength) !== null && _ref2 !== void 0 ? _ref2 : 0;
  var rawValueUnitCount = getTextUnitCount(rawValue, isWords);
  var throttledValueUnitCount = getTextUnitCount(throttledValue, isWords);
  var isOverLimit = rawValueUnitCount > maxUnits;
  var isOverThreshold = isNil(threshold) || isOverLimit || rawValueUnitCount / maxUnits >= threshold;
  var visibleMessage = formatStatusMessage(rawValueUnitCount, maxUnits, isWords, messageOverrides);
  var screenReaderMessage = formatStatusMessage(throttledValueUnitCount, maxUnits, isWords, messageOverrides);
  var descriptionMessage = formatDescriptionMessage(maxUnits, isWords, textareaDescriptionText);
  var callbackRef = useCallback(function (element) {
    var _element$value;
    setValue((_element$value = element === null || element === void 0 ? void 0 : element.value) !== null && _element$value !== void 0 ? _element$value : '');
  }, [setValue]);
  return _jsxs("div", {
    className: "govuk-character-count",
    children: [_jsx(Textarea, _objectSpread(_objectSpread({
      ref: mergeRefs([callbackRef, forwardedRef]),
      className: clsx(className, isOverLimit && 'govuk-textarea--error'),
      id: id,
      onChange: handleChange
    }, rest), {}, {
      children: isClient && _jsxs(_Fragment, {
        children: [_jsx("div", {
          id: "".concat(id, "-info"),
          className: clsx('govuk-hint', 'govuk-character-count__message', 'govuk-visually-hidden', countMessageClassname),
          children: descriptionMessage
        }), _jsx("div", {
          className: clsx('govuk-character-count__message', 'govuk-character-count__status', !isOverLimit && 'govuk-hint', isOverLimit && 'govuk-error-message', !isOverThreshold && 'govuk-character-count__message--disabled', countMessageClassname),
          "aria-hidden": "true",
          children: visibleMessage
        }), _jsx("div", {
          className: "govuk-character-count__sr-status govuk-visually-hidden",
          "aria-hidden": !isOverThreshold,
          "aria-live": "polite",
          children: screenReaderMessage
        })]
      })
    })), !isClient && _jsx("div", {
      id: "".concat(id, "-info"),
      className: clsx('govuk-hint', 'govuk-character-count__message', countMessageClassname),
      children: descriptionMessage
    })]
  });
});
CharacterCount.displayName = 'CharacterCount';