function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["aria-describedby", "className", "errorMessage", "formGroupClassName", "hint", "id", "label", "prefix", "suffix", "type"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } } return target; }
import clsx from 'clsx';
import { forwardRef, useId } from 'react';
import { FormGroup } from '../internal/FormGroup';
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
function InputWrapper(_ref) {
  var children = _ref.children,
    hasPrefixOrSuffix = _ref.hasPrefixOrSuffix;
  if (hasPrefixOrSuffix) {
    return _jsx("div", {
      className: "govuk-input__wrapper",
      children: children
    });
  }
  return _jsx(_Fragment, {
    children: children
  });
}
export var Input = forwardRef(function (_ref2, ref) {
  var ariaDescribedBy = _ref2['aria-describedby'],
    className = _ref2.className,
    errorMessage = _ref2.errorMessage,
    formGroupClassName = _ref2.formGroupClassName,
    hint = _ref2.hint,
    id = _ref2.id,
    label = _ref2.label,
    prefix = _ref2.prefix,
    suffix = _ref2.suffix,
    _ref2$type = _ref2.type,
    type = _ref2$type === void 0 ? 'text' : _ref2$type,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var autoId = useId();
  var resolvedId = id || autoId;
  var resolvedAriaDescribedBy = [ariaDescribedBy !== null && ariaDescribedBy !== void 0 ? ariaDescribedBy : [], hint ? "".concat(resolvedId, "-hint") : [], errorMessage ? "".concat(resolvedId, "-error") : []].flat().join(' ');
  return _jsxs(FormGroup, {
    className: clsx(errorMessage && 'govuk-form-group--error', formGroupClassName),
    id: resolvedId,
    children: [label, hint, errorMessage, _jsxs(InputWrapper, {
      hasPrefixOrSuffix: Boolean(prefix || suffix),
      children: [prefix, _jsx("input", _objectSpread({
        ref: ref,
        "aria-describedby": resolvedAriaDescribedBy,
        className: clsx('govuk-input', errorMessage && 'govuk-input--error', className),
        id: resolvedId,
        type: type
      }, rest)), suffix]
    })]
  });
});
Input.displayName = 'Input';