import clsx from 'clsx';
import { useMemo } from 'react';
import { FormGroupContext } from './FormGroupContext';
import { jsx as _jsx } from "react/jsx-runtime";
export function FormGroup(_ref) {
  var children = _ref.children,
    className = _ref.className,
    id = _ref.id;
  var contextValue = useMemo(function () {
    return {
      id: id
    };
  }, [id]);
  return _jsx(FormGroupContext.Provider, {
    value: contextValue,
    children: _jsx("div", {
      className: clsx('govuk-form-group', className),
      children: children
    })
  });
}