function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["children", "disableAutoFocus", "onBlur", "role", "title", "titleHeadingTag", "titleId", "type"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } } return target; }
import clsx from 'clsx';
import { Children, forwardRef, isValidElement, useCallback, useEffect, useId, useRef } from 'react';
import { mergeRefs } from 'react-merge-refs';
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
var NotificationBannerTitle = function NotificationBannerTitle(_ref) {
  var children = _ref.children,
    Heading = _ref.headingTag,
    id = _ref.id;
  return _jsx(Heading, {
    className: clsx('govuk-notification-banner__title'),
    id: id,
    children: children
  });
};
export var NotificationBanner = forwardRef(function (_ref2, forwardedRef) {
  var children = _ref2.children,
    disableAutoFocus = _ref2.disableAutoFocus,
    onBlur = _ref2.onBlur,
    role = _ref2.role,
    title = _ref2.title,
    _ref2$titleHeadingTag = _ref2.titleHeadingTag,
    titleHeadingTag = _ref2$titleHeadingTag === void 0 ? 'h2' : _ref2$titleHeadingTag,
    titleId = _ref2.titleId,
    type = _ref2.type,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var autoTitleId = useId();
  var ref = useRef(null);
  var isFirstRender = useRef(true);
  var resolvedTitleId = titleId || autoTitleId;
  var isSuccess = type === 'success';
  var computedRole = role !== null && role !== void 0 ? role : isSuccess ? 'alert' : 'region';
  var computedTitle = title !== null && title !== void 0 ? title : isSuccess ? 'Success' : 'Important';
  var hasSimpleChildren = !Children.toArray(children).every(isValidElement);
  var content = hasSimpleChildren ? _jsx("p", {
    className: "govuk-notification-banner__heading",
    children: children
  }) : children;
  var handleBlur = useCallback(function (event) {
    var _ref$current;
    (_ref$current = ref.current) === null || _ref$current === void 0 || _ref$current.removeAttribute('tabindex');
    onBlur === null || onBlur === void 0 || onBlur(event);
  }, [onBlur]);
  useEffect(function () {
    if (!ref.current) {
      return;
    }
    var previousIsFirstRender = isFirstRender.current;
    isFirstRender.current = false;
    if (!previousIsFirstRender || disableAutoFocus || computedRole !== 'alert') {
      return;
    }
    if (!ref.current.getAttribute('tabindex')) {
      ref.current.setAttribute('tabindex', '-1');
    }
    ref.current.focus();
  }, [computedRole, disableAutoFocus]);
  return _jsxs("div", _objectSpread(_objectSpread({
    ref: mergeRefs([ref, forwardedRef]),
    "aria-labelledby": resolvedTitleId,
    className: clsx('govuk-notification-banner', isSuccess && 'govuk-notification-banner--success'),
    onBlur: handleBlur,
    role: computedRole
  }, rest), {}, {
    children: [_jsx("div", {
      className: "govuk-notification-banner__header",
      children: _jsx(NotificationBannerTitle, {
        id: resolvedTitleId,
        headingTag: titleHeadingTag,
        children: computedTitle
      })
    }), _jsx("div", {
      className: "govuk-notification-banner__content",
      children: content
    })]
  }));
});
NotificationBanner.displayName = 'NotificationBanner';