import clsx from 'clsx';
import { isValidElement } from 'react';
import flattenChildren from 'react-keyed-flatten-children';
import { jsx as _jsx } from "react/jsx-runtime";
export var SummaryCardActions = function SummaryCardActions(_ref) {
  var children = _ref.children,
    className = _ref.className;
  var flattenedChildren = flattenChildren(children).filter(isValidElement);
  if (flattenedChildren.length === 1) {
    return _jsx("div", {
      className: clsx('govuk-summary-card__actions', className),
      children: children
    });
  }
  return _jsx("ul", {
    className: clsx('govuk-summary-card__actions', className),
    children: flattenedChildren.map(function (child) {
      return _jsx("li", {
        className: "govuk-summary-card__action",
        children: child
      }, child.key);
    })
  });
};