import clsx from 'clsx';
import { isValidElement } from 'react';
import flattenChildren from 'react-keyed-flatten-children';
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
export var SummaryListActions = function SummaryListActions(_ref) {
  var children = _ref.children,
    className = _ref.className;
  var flattenedChildren = flattenChildren(children).filter(isValidElement);
  var links = flattenedChildren.length === 1 ? flattenedChildren : _jsx("ul", {
    className: "govuk-summary-list__actions-list",
    children: flattenedChildren.map(function (child) {
      return _jsxs(_Fragment, {
        children: [_jsx("li", {
          className: "govuk-summary-list__actions-list-item",
          children: child
        }, child.key), ' ']
      });
    })
  });
  return _jsx("dd", {
    className: clsx('govuk-summary-list__actions', className),
    children: links
  });
};