import { type ComponentPropsWithoutRef, type ReactNode } from 'react';
export interface FieldsetLegendProps extends ComponentPropsWithoutRef<'legend'> {
    /**
     * Content for the legend (normally text).
     */
    children: ReactNode;
    /**
     * Whether the legend also acts as the heading for the page.
     */
    isPageHeading?: boolean;
}
/**
 * Legend for the Fieldset component.
 *
 * @experimental React components are in alpha and subject to change.
 */
export declare const FieldsetLegend: import("react").ForwardRefExoticComponent<FieldsetLegendProps & import("react").RefAttributes<HTMLLegendElement>>;
//# sourceMappingURL=FieldsetLegend.d.ts.map