import { type ComponentPropsWithoutRef, type ReactElement } from 'react';
import type { FooterMetaProps } from './FooterMeta';
import type { FooterNavigationProps } from './FooterNavigation';
interface FooterProps extends ComponentPropsWithoutRef<'footer'> {
    /**
     * Classes that can be added to the inner container, useful if you want to make the footer full width.
     */
    containerClassName?: string;
    /**
     * The content licence text.
     */
    contentLicence?: ReactElement | string;
    /**
     * The copyright text.
     */
    copyright?: ReactElement | string;
    /**
     * Meta navigation. An instance of FooterMeta.
     */
    meta?: ReactElement<FooterMetaProps>;
    /**
     * Secondary navigation. An instance of FooterNavigation.
     */
    navigation?: ReactElement<FooterNavigationProps>;
}
/**
 * A page footer.
 *
 * @experimental React components are in alpha and subject to change.
 *
 * @example
 * <Footer
 *   meta={
 *     <FooterMeta>
 *       <FooterMetaLink href='#1'>Item 1</FooterMetaLink>
 *       <FooterMetaLink href='#2'>Item 2</FooterMetaLink>
 *       <FooterMetaLink href='#2'>Item 3</FooterMetaLink>
 *     </FooterMeta>
 *   }
 * />
 */
export declare const Footer: import("react").ForwardRefExoticComponent<FooterProps & import("react").RefAttributes<HTMLElement>>;
export {};
//# sourceMappingURL=Footer.d.ts.map