import { type ComponentPropsWithoutRef, type ReactElement } from 'react';
import type { ErrorMessageProps } from '../error-message';
import type { HintProps } from '../hint';
import type { LabelProps } from '../label';
import type { InputPrefixProps } from './InputPrefix';
import type { InputSuffixProps } from './InputSuffix';
export interface InputProps extends Omit<ComponentPropsWithoutRef<'input'>, 'children' | 'prefix'> {
    /**
     * Optional error message. This should be an instance of ErrorMessage.
     */
    errorMessage?: ReactElement<ErrorMessageProps>;
    /**
     * Classes to add to the form group (for example to show error state for the whole group).
     */
    formGroupClassName?: string;
    /**
     * Optional hint. This should be an instance of Hint.
     */
    hint?: ReactElement<HintProps>;
    /**
     * Label for the input. This should be an instance of Label.
     */
    label: ReactElement<LabelProps>;
    /**
     * Optional prefix to display before the input. This should be an instance of InputPrefix.
     */
    prefix?: ReactElement<InputPrefixProps>;
    /**
     * Optional suffix to display after the input. This should be an instance of InputSuffix.
     */
    suffix?: ReactElement<InputSuffixProps>;
}
/**
 * Text input.
 *
 * @experimental React components are in alpha and subject to change.
 *
 * @example
 * <Input
 *   hint={<Hint>The name you’ll use on promotional material</Hint>}
 *   label={
 *     <Label className='govuk-label--l' isPageHeading>
 *       What is the name of the event?
 *     </Label>
 *   }
 *   name='event-name-with-hint'
 * />
 */
export declare const Input: import("react").ForwardRefExoticComponent<InputProps & import("react").RefAttributes<HTMLInputElement>>;
//# sourceMappingURL=Input.d.ts.map