import { type ComponentPropsWithoutRef, type ReactNode } from 'react';
export interface InsetTextProps extends ComponentPropsWithoutRef<'div'> {
    /**
     * Inset text content.
     */
    children: ReactNode;
}
/**
 * Inset text.
 *
 * @experimental React components are in alpha and subject to change.
 *
 * @example
 * <InsetText>You’ll get confirmation that we have received your report within 5 working days.</InsetText>
 */
export declare const InsetText: import("react").ForwardRefExoticComponent<InsetTextProps & import("react").RefAttributes<HTMLDivElement>>;
//# sourceMappingURL=InsetText.d.ts.map