import { type ComponentPropsWithoutRef, type ComponentPropsWithRef, type ComponentType, type ElementType, type ExoticComponent } from 'react';
type LinkProps<T extends ElementType> = {
    /**
     * The component to use for links (for example, a Link component
     * from a routing library).
     *
     * Defaults to an anchor tag.
     */
    component?: T;
} & ComponentPropsWithoutRef<T>;
type LinksComponentType = Extract<ElementType, 'a' | ComponentType>;
export interface LinkComponent<Props = object> {
    <T extends LinksComponentType = 'a'>(props: LinkProps<T> & {
        ref?: ComponentPropsWithRef<T>['ref'];
    } & Props): ReturnType<ExoticComponent>;
    displayName?: string | undefined;
}
export declare const LinkBase: LinkComponent;
export {};
//# sourceMappingURL=Link.d.ts.map