import { type ComponentPropsWithoutRef, type ReactNode } from 'react';
export interface LabelProps extends ComponentPropsWithoutRef<'label'> {
    children: ReactNode;
    /**
     * Whether the label also acts as the heading for the page.
     */
    isPageHeading?: boolean;
}
/**
 * Label for a form element.
 *
 * @experimental React components are in alpha and subject to change.
 */
export declare const Label: import("react").ForwardRefExoticComponent<LabelProps & import("react").RefAttributes<HTMLLabelElement>>;
//# sourceMappingURL=Label.d.ts.map