import { type ComponentPropsWithoutRef, type ReactElement, type ReactNode } from 'react';
import type { PhaseTagProps } from './PhaseTag';
export interface PhaseBannerProps extends ComponentPropsWithoutRef<'div'> {
    /**
     * Main content for the phase banner.
     */
    children: ReactNode;
    /**
     * An instance of PhaseTag.
     *
     * @example
     * <PhaseTag>alpha</PhaseTag>
     */
    phaseTag: ReactElement<PhaseTagProps>;
}
/**
 * A phase banner.
 *
 * @experimental React components are in alpha and subject to change.
 *
 * @example
 * <PhaseBanner phaseTag={<PhaseTag>Alpha</PhaseTag>}>
 *   This is a new service – your <a className='govuk-link' href='#'>feedback</a> will help us to improve it.
 * </PhaseBanner>
 */
export declare const PhaseBanner: import("react").ForwardRefExoticComponent<PhaseBannerProps & import("react").RefAttributes<HTMLDivElement>>;
//# sourceMappingURL=PhaseBanner.d.ts.map