import { type ComponentPropsWithoutRef } from 'react';
export interface SkipLinkProps extends ComponentPropsWithoutRef<'a'> {
    /**
     * The value of the skip link’s href attribute.
     * Defaults to #content.
     */
    href?: string;
}
/**
 * Skip link.
 *
 * @experimental React components are in alpha and subject to change.
 *
 * @example
 * <SkipLink href='#content'>Skip to main content</SkipLink>
 */
export declare const SkipLink: import("react").ForwardRefExoticComponent<SkipLinkProps & import("react").RefAttributes<HTMLAnchorElement>>;
//# sourceMappingURL=SkipLink.d.ts.map