import { type ComponentPropsWithoutRef, type Key, type ReactElement } from 'react';
import type { SummaryCardActionsProps } from './SummaryCardActions';
import type { SummaryCardTitleProps } from './SummaryCardTitle';
import type { SummaryListActionsProps } from './SummaryListActions';
import type { SummaryListKeyProps } from './SummaryListKey';
import type { SummaryListValueProps } from './SummaryListValue';
export interface SummaryListRowObject {
    /**
     * Optional React key for the row. If not set for all
     * rows, the row index will be used.
     */
    reactKey?: Key;
    /**
     * CSS classes to add to the row.
     */
    className?: string;
    /**
     * An instance of SummaryListKey.
     */
    key: ReactElement<SummaryListKeyProps>;
    /**
     * An instance of SummaryListValue.
     */
    value: ReactElement<SummaryListValueProps>;
    /**
     * Optional instance of SummaryListActions.
     */
    actions?: ReactElement<SummaryListActionsProps>;
}
export interface SummaryListProps extends ComponentPropsWithoutRef<'dl'> {
    /**
     * Summary card options.
     *
     * If this prop is set, a summary card will wrap around the summary list
     */
    card?: {
        /**
         * CSS classes to add to the card container.
         */
        className?: string;
        /**
         * Optional card title – an instance of SummaryCardTitle.
         */
        title?: ReactElement<SummaryCardTitleProps>;
        /**
         * Optional card actions – an instance of SummaryCardActions.
         */
        actions?: ReactElement<SummaryCardActionsProps>;
    };
    /**
     * Summary list rows.
     */
    rows: SummaryListRowObject[];
}
/**
 * Summary list.
 *
 * @experimental React components are in alpha and subject to change.
 *
 * @example
 * <SummaryList
 *   rows={[
 *     {
 *       key: <SummaryListKey>Name</SummaryListKey>,
 *       value: <SummaryListValue>Sarah Philips</SummaryListValue>,
 *       actions: (
 *         <SummaryListActions>
 *           <SummaryListActionLink href='#'>
 *             Change <VisuallyHiddenText>name</VisuallyHiddenText>
 *           </SummaryListActionLink>
 *         </SummaryListActions>
 *       ),
 *     },
 *     {
 *       key: <SummaryListKey>Date of birth</SummaryListKey>,
 *       value: <SummaryListValue>5 January 1978</SummaryListValue>,
 *       actions: (
 *         <SummaryListActions>
 *           <SummaryListActionLink href='#'>
 *             Change <VisuallyHiddenText>date of birth</VisuallyHiddenText>
 *           </SummaryListActionLink>,
 *         </SummaryListActions>
 *       ),
 *     },
 *   ]}
 * />
 */
export declare const SummaryList: import("react").ForwardRefExoticComponent<SummaryListProps & import("react").RefAttributes<HTMLDListElement>>;
//# sourceMappingURL=SummaryList.d.ts.map