import { type ComponentPropsWithoutRef, type ReactNode } from 'react';
export interface TagProps extends ComponentPropsWithoutRef<'strong'> {
    children: ReactNode;
}
/**
 * A tag, used to show users the status of something.
 *
 * @experimental React components are in alpha and subject to change.
 *
 * @example
 * <Tag>Completed</Tag>
 *
 * @example
 * <Tag className='govuk-tag--green'>New</Tag>
 */
export declare const Tag: import("react").ForwardRefExoticComponent<TagProps & import("react").RefAttributes<HTMLElement>>;
//# sourceMappingURL=Tag.d.ts.map