import { type ComponentPropsWithoutRef, type ReactElement, type ReactNode } from 'react';
import type { ErrorMessageProps } from '../error-message';
import type { HintProps } from '../hint';
import type { LabelProps } from '../label';
export interface TextareaProps extends Omit<ComponentPropsWithoutRef<'textarea'>, 'children'> {
    /**
     * Additional content to be displayed below the <textarea>,
     * within the form group.
     */
    children?: ReactNode;
    /**
     * Optional error message. This should be an instance of ErrorMessage.
     */
    errorMessage?: ReactElement<ErrorMessageProps>;
    /**
     * Classes to add to the form group (for example to show error state for the whole group).
     */
    formGroupClassName?: string;
    /**
     * Optional hint. This should be an instance of Hint.
     */
    hint?: ReactElement<HintProps>;
    /**
     * Label for the textarea. This should be an instance of Label.
     */
    label: ReactElement<LabelProps>;
    /**
     * Optional number of textarea rows (default is 5 rows).
     */
    rows?: ComponentPropsWithoutRef<'textarea'>['rows'];
}
/**
 * Textarea.
 *
 * @experimental React components are in alpha and subject to change.
 *
 * @example
 * <Textarea
 *   label={
 *     <Label className='govuk-label--l' isPageHeading>
 *       What is the event about?
 *     </Label>
 *   }
 *   hint={<Hint>This will be shown on the public page for the event, below the event title</Hint>}
 *   name='event-description'
 * />
 */
export declare const Textarea: import("react").ForwardRefExoticComponent<TextareaProps & import("react").RefAttributes<HTMLTextAreaElement>>;
//# sourceMappingURL=Textarea.d.ts.map