import { type ComponentPropsWithoutRef, type ReactNode } from 'react';
export interface WarningTextProps extends ComponentPropsWithoutRef<'div'> {
    /**
     * Warning text content.
     */
    children: ReactNode;
    /**
     * The fallback text for the icon. Defaults to ‘Warning’
     */
    iconFallbackText?: string;
}
/**
 * Warning text.
 *
 * @experimental React components are in alpha and subject to change.
 *
 * @example
 * <WarningText>Completed</WarningText>
 */
export declare const WarningText: import("react").ForwardRefExoticComponent<WarningTextProps & import("react").RefAttributes<HTMLDivElement>>;
//# sourceMappingURL=WarningText.d.ts.map