/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import './selectBox.css';
import { dispose } from '../../../common/lifecycle.js';
import { Widget } from '../widget.js';
import { Color } from '../../../common/color.js';
import { deepClone, mixin } from '../../../common/objects.js';
import { SelectBoxNative } from './selectBoxNative.js';
import { SelectBoxList } from './selectBoxCustom.js';
import { isMacintosh } from '../../../common/platform.js';
export var defaultStyles = {
    selectBackground: Color.fromHex('#3C3C3C'),
    selectForeground: Color.fromHex('#F0F0F0'),
    selectBorder: Color.fromHex('#3C3C3C')
};
var SelectBox = /** @class */ (function (_super) {
    __extends(SelectBox, _super);
    function SelectBox(options, selected, contextViewProvider, styles) {
        if (styles === void 0) { styles = deepClone(defaultStyles); }
        var _this = _super.call(this) || this;
        _this.toDispose = [];
        mixin(_this.styles, defaultStyles, false);
        // Instantiate select implementation based on platform
        if (isMacintosh) {
            _this.selectBoxDelegate = new SelectBoxNative(options, selected, styles);
        }
        else {
            _this.selectBoxDelegate = new SelectBoxList(options, selected, contextViewProvider, styles);
        }
        _this.toDispose.push(_this.selectBoxDelegate);
        return _this;
    }
    Object.defineProperty(SelectBox.prototype, "onDidSelect", {
        // Public SelectBox Methods - routed through delegate interface
        get: function () {
            return this.selectBoxDelegate.onDidSelect;
        },
        enumerable: true,
        configurable: true
    });
    SelectBox.prototype.setOptions = function (options, selected, disabled) {
        this.selectBoxDelegate.setOptions(options, selected, disabled);
    };
    SelectBox.prototype.select = function (index) {
        this.selectBoxDelegate.select(index);
    };
    SelectBox.prototype.focus = function () {
        this.selectBoxDelegate.focus();
    };
    SelectBox.prototype.blur = function () {
        this.selectBoxDelegate.blur();
    };
    // Public Widget Methods - routed through delegate interface
    SelectBox.prototype.render = function (container) {
        this.selectBoxDelegate.render(container);
    };
    SelectBox.prototype.style = function (styles) {
        this.selectBoxDelegate.style(styles);
    };
    SelectBox.prototype.applyStyles = function () {
        this.selectBoxDelegate.applyStyles();
    };
    SelectBox.prototype.dispose = function () {
        this.toDispose = dispose(this.toDispose);
        _super.prototype.dispose.call(this);
    };
    return SelectBox;
}(Widget));
export { SelectBox };
