/*!-----------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.14.6(6c8f02b41db9ae5c4d15df767d47755e5c73b9d5)
 * Released under the MIT license
 * https://github.com/Microsoft/vscode/blob/master/LICENSE.txt
 *-----------------------------------------------------------*/

define("vs/editor/editor.main.nls.it", {
	"vs/base/browser/ui/actionbar/actionbar": [
		"{0} ({1})",
	],
	"vs/base/browser/ui/aria/aria": [
		"{0} (nuova occorrenza)",
		"{0} (occurred {1} times)",
	],
	"vs/base/browser/ui/findinput/findInput": [
		"input",
	],
	"vs/base/browser/ui/findinput/findInputCheckboxes": [
		"Maiuscole/minuscole",
		"Parola intera",
		"Usa espressione regolare",
	],
	"vs/base/browser/ui/inputbox/inputBox": [
		"Errore: {0}",
		"Avviso: {0}",
		"Info: {0}",
	],
	"vs/base/browser/ui/list/listWidget": [
		"{0}. Use the navigation keys to navigate.",
	],
	"vs/base/browser/ui/menu/menu": [
		"{0} ({1})",
	],
	"vs/base/common/keybindingLabels": [
		"CTRL",
		"MAIUSC",
		"ALT",
		"Windows",
		"CTRL",
		"MAIUSC",
		"ALT",
		"Super",
		"CTRL",
		"MAIUSC",
		"ALT",
		"Comando",
		"CTRL",
		"MAIUSC",
		"ALT",
		"Windows",
		"CTRL",
		"MAIUSC",
		"ALT",
		"Super",
	],
	"vs/base/common/severity": [
		"Errore",
		"Avviso",
		"Informazioni",
	],
	"vs/base/parts/quickopen/browser/quickOpenModel": [
		"{0}, selezione",
		"selezione",
	],
	"vs/base/parts/quickopen/browser/quickOpenWidget": [
		"Selezione rapida. Digitare per ridurre il numero di risultati.",
		"Selezione rapida",
		"{0} Results",
	],
	"vs/editor/browser/controller/coreCommands": [
		"&&Select All",
		"&&Undo",
		"&&Redo",
	],
	"vs/editor/browser/widget/codeEditorWidget": [
		"Il numero di cursori è stato limitato a {0}.",
	],
	"vs/editor/browser/widget/diffEditorWidget": [
		"Non è possibile confrontare i file perché uno è troppo grande.",
	],
	"vs/editor/browser/widget/diffReview": [
		"Chiudi",
		"nessuna linea",
		"1 linea",
		"{0} linee",
		"Differenza {0} di {1}: originale {2}, {3}, modificate {4}, {5}",
		"vuota",
		"originali {0}, modificate {1}: {2}",
		"+ modificate {0}: {1}",
		"- originali {0}: {1}",
		"Vai alla differenza successiva",
		"Vai alla differenza precedente",
	],
	"vs/editor/common/config/commonEditorConfig": [
		"Editor",
		"Controlla la famiglia di caratteri.",
		"Controlla lo spessore del carattere.",
		"Controlla le dimensioni del carattere in pixel.",
		"Controlla l\'altezza della riga. Usare 0 per calcolare l\'altezza della riga dalle dimensioni del carattere.",
		"Controlla la spaziatura tra le lettere in pixel.",
		"I numeri di riga non vengono visualizzati.",
		"I numeri di riga vengono visualizzati come numeri assoluti.",
		"I numeri di riga vengono visualizzati come distanza in linee alla posizione del cursore.",
		"I numeri di riga vengono visualizzati ogni 10 righe.",
		"Controlla la visualizzazione dei numeri di riga.",
		"Mostra righelli verticali dopo un certo numero di caratteri a spaziatura fissa. Utilizza più valori  per più righelli. Nessun righello viene disegnati se la matrice è vuota",
		"Caratteri che verranno usati come separatori di parola quando si eseguono operazioni o spostamenti correlati a parole",
		"Il numero di spazi corrispondenti ad un carattere Tab. Questa impostazione viene sottoposta a override in base al contenuto dei file quando \'editor.detectIndentation\' è \'on\'.",
		"È previsto \'number\'. Nota: il valore \"auto\" è stato sostituito dall\'impostazione `editor.detectIndentation`.",
		"Inserire spazi quando si preme Tab. Questa impostazione viene sottoposta a override in base al contenuto dei file quando è \'editor.detectIndentation\' è \'on\'.",
		"È previsto \'boolean\'. Nota: il valore \"auto\" è stato sostituito dall\'impostazione `editor.detectIndentation`.",
		"All\'apertura di un file, `editor.tabSize` e `editor.insertSpaces` verranno rilevati in base al contenuto del file.",
		"Controlla se gli angoli delle selezioni sono arrotondati",
		"Controlla se l\'editor scorrerà oltre l\'ultima riga",
		"Controlla il numero di caratteri aggiuntivi oltre il quale l\'editor scorrerà orizzontalmente",
		"Controlla se per lo scorrimento dell\'editor verrà usata un\'animazione.",
		"Controlla se la mini mappa è visualizzata",
		"Definisce il lato in cui eseguire il rendering della mini mappa.",
		"Controlla se lo slider della mini mappa viene nascosto automaticamente.",
		"Esegue il rendering dei caratteri effettivi di una riga (in contrapposizione ai blocchi colore)",
		"Limita la larghezza della mini mappa in modo da eseguire il rendering al massimo di un certo numero di colonne",
		"Controls whether the hover is shown.",
		"Time delay in milliseconds after which to the hover is shown.",
		"Controls whether the hover should remain visible when mouse is moved over it.",
		"Controlla se inizializzare la stringa di ricerca nel Widget Trova con il testo selezionato nell\'editor",
		"Controlla se l\'impostazione Trova nella selezione è attivata quando vengono selezionati più caratteri o righe di testo nell\'editor",
		"Controlla se il widget Trova debba leggere o modificare gli appunti ricerche condivise su macOS",
		"Il wrapping delle righe non viene eseguito.",
		"Verrà eseguito il wrapping delle righe in base alla larghezza del viewport.",
		"Verrà eseguito il wrapping delle righe alla posizione corrispondente a `editor.wordWrapColumn`.",
		"Verrà eseguito il wrapping delle righe alla posizione minima del viewport e di `editor.wordWrapColumn`.",
		"Controlla il wrapping delle righe. Valori possibili:\n - \'off\' (disabilita il wrapping),\n - \'on\' (wrapping del viewport),\n - \'wordWrapColumn\' (esegue il wrapping alla posizione corrispondente a `editor.wordWrapColumn`) o\n - \'bounded\' (esegue il wrapping alla posizione minima del viewport e di `editor.wordWrapColumn`).",
		"Controlla la colonna di wrapping dell\'editor quando il valore di `editor.wordWrap` è \'wordWrapColumn\' o \'bounded\'.",
		"No indentation. Wrapped lines begin at column 1.",
		"Wrapped lines get the same indentation as the parent.",
		"Wrapped lines get +1 indentation toward the parent.",
		"Wrapped lines get +2 indentation toward the parent.",
		"Controlla il rientro delle righe con ritorno a capo. Può essere uno dei valori seguenti: \'none\', \'same\', \'indent\' o \'deepIndent\'.",
		"Moltiplicatore da usare sui valori `deltaX` e `deltaY` degli eventi di scorrimento della rotellina del mouse",
		"Rappresenta il tasto \'Control\' (ctrl) su Windows e Linux e il tasto \'Comando\' (cmd) su OSX.",
		"Rappresenta il tasto \'Alt\' su Windows e Linux e il tasto \'Opzione\' su OSX.",
		"Il modificatore da utilizzare per aggiungere molteplici cursori con il mouse. \'ctrlCmd\' rappresenta il tasto \'Control\' su Windows e Linux e  il tasto \'Comando\' su OSX. I gesti del mouse Vai a definizione e Apri il Link si adatteranno in modo da non entrare in conflitto con il modificatore multi-cursore.",
		"Unire i cursori multipli se sovrapposti.",
		"Abilita i suggerimenti rapidi all\'interno di stringhe.",
		"Abilita i suggerimenti rapidi all\'interno di commenti.",
		"Abilita i suggerimenti rapidi all\'esterno di stringhe e commenti.",
		"Controlla se visualizzare automaticamente i suggerimenti durante la digitazione",
		"Controlla il ritardo in ms dopo il quale verranno visualizzati i suggerimenti rapidi",
		"Abilita un popup che mostra documentazione sui parametri e informazioni sui tipi mentre si digita",
		"Controlla se l\'editor deve chiudere automaticamente le parentesi quadre dopo che sono state aperte",
		"Controlla se l\'editor deve formattare automaticamente la riga dopo la digitazione",
		"Controlla se l\'editor deve formattare automaticamente il contenuto incollato. Deve essere disponibile un formattatore che deve essere in grado di formattare un intervallo in un documento.",
		"Controlla se l\'editor deve correggere automaticamente l\'indentazione mentre l\'utente digita, incolla o sposta delle righe. Devono essere disponibili le regole di indentazione del linguaggio.",
		"Controlla se i suggerimenti devono essere visualizzati automaticamente durante la digitazione dei caratteri trigger",
		"Only accept a suggestion with `Enter` when it makes a textual change.",
		"Controlla se i suggerimenti devono essere accettati con \'INVIO\' in aggiunta a \'TAB\'. In questo modo è possibile evitare ambiguità tra l\'inserimento di nuove righe e l\'accettazione di suggerimenti. Il valore \'smart\' indica di accettare un suggerimento con \'INVIO\' quando comporta una modifica al testo",
		"Controlla se accettare i suggerimenti con i caratteri di commit. Ad esempio, in JavaScript il punto e virgola (\';\') può essere un carattere di commit che accetta un suggerimento e digita tale carattere.",
		"Visualizza i suggerimenti dello snippet sopra gli altri suggerimenti.",
		"Visualizza i suggerimenti dello snippet sotto gli altri suggerimenti.",
		"Visualizza i suggerimenti degli snippet insieme agli altri suggerimenti.",
		"Non mostrare i suggerimenti sugli snippet.",
		"Controlla se i frammenti di codice sono visualizzati con altri suggerimenti e il modo in cui sono ordinati.",
		"Consente di controllare se, quando si copia senza aver effettuato una selezione, viene copiata la riga corrente.",
		"Controlla se calcolare i completamenti in base alle parole presenti nel documento.",
		"Consente di selezionare sempre il primo suggerimento.",
		"Consente di selezionare suggerimenti recenti a meno che continuando a digitare non ne venga selezionato uno, ad esempio `console.| -> console.log` perché `log` è stato completato di recente.",
		"Consente di selezionare i suggerimenti in base a prefissi precedenti che hanno completato tali suggerimenti, ad esempio `co -> console` e `con -> const`.",
		"Controlla la modalità di preselezione dei suggerimenti durante la visualizzazione degll\'elenco dei suggerimenti.",
		"Dimensioni del carattere per il widget dei suggerimenti",
		"Altezza della riga per il widget dei suggerimenti",
		"Controls whether filtering and sorting suggestions accounts for small typos.",
		"Control whether an active snippet prevents quick suggestions.",
		"Controlla se l\'editor deve evidenziare gli elementi corrispondenti simili alla selezione",
		"Controlla se l\'editor deve evidenziare le occorrenze di simboli semantici",
		"Controlla il numero di effetti che possono essere visualizzati nella stessa posizione nel righello delle annotazioni",
		"Controlla se deve essere disegnato un bordo intorno al righello delle annotazioni.",
		"Controllo dello stile di animazione del cursore.",
		"Ingrandisce il carattere dell\'editor quando si usa la rotellina del mouse e si tiene premuto CTRL",
		"Controlla lo stile del cursore. I valori accettati sono \'block\', \'block-outline\', \'line\', \'line-thin\', \'underline\' e \'underline-thin\'",
		"Controlla la larghezza del cursore quando editor.cursorSyle è impostato a \'line\'",
		"Abilita i caratteri legatura",
		"Controlla se il cursore deve essere nascosto nel righello delle annotazioni.",
		"Render whitespace characters except for single spaces between words.",
		"Consente di controllare in che modo l\'editor deve eseguire il rendering dei caratteri di spazio vuoto. Le opzioni possibili sono: \'none\', \'boundary\' e \'all\'. Con l\'opzione \'boundary\' non viene eseguito il rendering di singoli spazi tra le parole.",
		"Controlla se l\'editor deve eseguire il rendering dei caratteri di controllo",
		"Controlla se l\'editor deve eseguire il rendering delle guide con rientro",
		"Controls whether the editor should highlight the active indent guide.",
		"Highlights both the gutter and the current line.",
		"Consente di controllare in che modo l\'editor deve eseguire il rendering dell\'evidenziazione di riga corrente. Le opzioni possibili sono \'none\', \'gutter\', \'line\' e \'all\'.",
		"Controlla se nell\'editor è visualizzato CodeLens",
		"Controlla se per l\'editor è abilitata la riduzione del codice",
		"Controlla in che modo vengono calcolati gli intervalli di riduzione. Con \'auto\' viene usata l\'eventuale strategia di riduzione specifica disponibile. Con \'indentation\' viene usata forzatamente la strategia di riduzione basata sui rientri.",
		"Controlla se i controlli di riduzione sul margine della barra di scorrimento sono automaticamente nascosti.",
		"Evidenzia le parentesi corrispondenti quando se ne seleziona una.",
		"Controlla se l\'editor deve eseguire il rendering del margine verticale del glifo. Il margine del glifo viene usato principalmente per il debug.",
		"Inserimento ed eliminazione dello spazio vuoto dopo le tabulazioni",
		"Rimuovi lo spazio vuoto finale inserito automaticamente",
		"Mantiene aperti gli editor rapidi anche quando si fa doppio clic sul contenuto o si preme ESC.",
		"Controlla se l\'editor consentire lo spostamento di selezioni tramite trascinamento della selezione.",
		"L\'editor utilizzerà API della piattaforma per rilevare quando è collegata un\'utilità per la lettura dello schermo.",
		"L\'editor sarà definitivamente ottimizzato per l\'utilizzo con un\'utilità per la lettura dello schermo.",
		"L\'editor non sarà mai ottimizzato per l\'utilizzo con un\'utilità per la lettura dello schermo.",
		"Controlla se l\'editor deve essere eseguito in una modalità ottimizzata per le utilità per la lettura dello schermo.",
		"Controls fading out of unused code.",
		"Controlla se l\'editor deve individuare i collegamenti e renderli cliccabili",
		"Controlla se l\'editor deve eseguire il rendering del selettore di colore e degli elementi Decorator di tipo colore inline.",
		"Abilita il codice azione lightbulb",
		"Eseguire l\'organizzazione degli Imports durante il salvataggio?",
		"Tipi di azione codice da eseguire durante il salvataggio.",
		"Timeout per le azioni codice eseguite durante il salvataggio.",
		"Controlla se gli appunti primari di Linux devono essere supportati.",
		"Controlla se l\'editor diff mostra le differenze affiancate o incorporate",
		"Controlla se l\'editor diff mostra come differenze le modifiche relative a spazi vuoti iniziali e finali",
		"Gestione speciale dei file di grandi dimensioni per disabilitare alcune funzionalità che fanno un uso intensivo della memoria.",
		"Consente di controllare se l\'editor diff mostra gli indicatori +/- per le modifiche aggiunte/rimosse",
	],
	"vs/editor/common/config/editorOptions": [
		"L\'editor non è accessibile in questo momento. Premere Alt+F1 per le opzioni.",
		"Contenuto editor",
	],
	"vs/editor/common/controller/cursor": [
		"Eccezione imprevista durante l\'esecuzione del comando.",
	],
	"vs/editor/common/modes/modesRegistry": [
		"Testo normale",
	],
	"vs/editor/common/services/modelServiceImpl": [
		"[{0}]\n{1}",
		"[{0}] {1}",
	],
	"vs/editor/common/view/editorColorRegistry": [
		"Colore di sfondo per l\'evidenziazione della riga alla posizione del cursore.",
		"Colore di sfondo per il bordo intorno alla riga alla posizione del cursore.",
		"Colore di sfondo degli intervalli evidenziati, ad esempio dalle funzionalità Quick Open e Trova. il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore di sfondo del bordo intorno agli intervalli selezionati.",
		"Colore del cursore dell\'editor.",
		"Colore di sfondo del cursore editor. Permette di personalizzare il colore di un carattere quando sovrapposto da un blocco cursore.",
		"Colore dei caratteri di spazio vuoto nell\'editor.",
		"Colore delle guide per i rientri dell\'editor.",
		"Colore delle guide di indentazione dell\'editor attivo",
		"Colore dei numeri di riga dell\'editor.",
		"Colore dei numeri per la riga attiva dell\'editor",
		"Id è deprecato. In alternativa utilizzare \'editorLineNumber.activeForeground\'.",
		"Colore dei numeri per la riga attiva dell\'editor",
		"Colore dei righelli dell\'editor.",
		"Colore primo piano delle finestre di CodeLens dell\'editor",
		"Colore di sfondo delle parentesi corrispondenti",
		"Colore delle caselle di parentesi corrispondenti",
		"Colore del bordo del righello delle annotazioni.",
		"Colore di sfondo della barra di navigazione dell\'editor. La barra contiene i margini di glifo e i numeri di riga.",
		"Colore primo piano degli squiggle di errore nell\'editor.",
		"Colore del bordo degli squiggle di errore nell\'editor.",
		"Colore primo piano degli squiggle di avviso nell\'editor",
		"Colore del bordo degli squggle di avviso nell\'editor.",
		"Colore primo piano degli squiggle di informazione nell\'editor",
		"Colore del bordo degli squiggle di informazione nell\'editor",
		"Colore primo piano degli squiggle di suggerimento nell\'editor.",
		"Colore del bordo degli squiggle di suggerimento nell\'editor.",
		"Border of unnecessary code in the editor.",
		"Opacity of unnecessary code in the editor.",
		"Colore del marcatore del righello delle annotazioni per gli errori.",
		"Colore del marcatore del righello delle annotazioni per gli avvisi.",
		"Colore del marcatore del righello delle annotazioni per i messaggi di tipo informativo.",
	],
	"vs/editor/contrib/bracketMatching/bracketMatching": [
		"Colore del marcatore del righello delle annotazioni per la corrispondenza delle parentesi.",
		"Vai alla parentesi",
		"Seleziona fino alla parentesi",
	],
	"vs/editor/contrib/caretOperations/caretOperations": [
		"Sposta il punto di inserimento a sinistra",
		"Sposta il punto di inserimento a destra",
	],
	"vs/editor/contrib/caretOperations/transpose": [
		"Trasponi lettere",
	],
	"vs/editor/contrib/clipboard/clipboard": [
		"Taglia",
		"Cu&&t",
		"Copia",
		"&&Copy",
		"Incolla",
		"&&Paste",
		"Copia con evidenziazione sintassi",
	],
	"vs/editor/contrib/codeAction/codeActionCommands": [
		"Mostra correzioni ({0})",
		"Mostra correzioni",
		"Correzione rapida...",
		"Azioni codice non disponibili",
		"Azioni codice non disponibili",
		"Effettua refactoring...",
		"Refactoring non disponibili",
		"Azione origine...",
		"Azioni origine non disponibili",
		"Organizza gli Imports",
		"Azioni di organizzazione Imports non disponibili",
	],
	"vs/editor/contrib/comment/comment": [
		"Attiva/Disattiva commento per la riga",
		"&&Toggle Line Comment",
		"Aggiungi commento per la riga",
		"Rimuovi commento per la riga",
		"Attiva/Disattiva commento per il blocco",
		"Toggle &&Block Comment",
	],
	"vs/editor/contrib/contextmenu/contextmenu": [
		"Mostra il menu di scelta rapida editor",
	],
	"vs/editor/contrib/cursorUndo/cursorUndo": [
		"Soft Undo",
	],
	"vs/editor/contrib/find/findController": [
		"Trova",
		"&&Find",
		"Trova nella selezione",
		"Trova successivo",
		"Trova precedente",
		"Trova selezione successiva",
		"Trova selezione precedente",
		"Sostituisci",
		"&&Replace",
	],
	"vs/editor/contrib/find/findWidget": [
		"Trova",
		"Trova",
		"Risultato precedente",
		"Risultato successivo",
		"Trova nella selezione",
		"Chiudi",
		"Sostituisci",
		"Sostituisci",
		"Sostituisci",
		"Sostituisci tutto",
		"Attiva/Disattiva modalità sostituzione",
		"Solo i primi {0} risultati vengono evidenziati, ma tutte le operazioni di ricerca funzionano su tutto il testo.",
		"{0} di {1}",
		"Nessun risultato",
	],
	"vs/editor/contrib/folding/folding": [
		"Espandi",
		"Espandi in modo ricorsivo",
		"Riduci",
		"Riduci in modo ricorsivo",
		"Riduci tutti i blocchi commento",
		"Riduci tutte le regioni",
		"Espandi tutte le regioni",
		"Riduci tutto",
		"Espandi tutto",
		"Livello riduzione {0}",
	],
	"vs/editor/contrib/fontZoom/fontZoom": [
		"Zoom In del Font Editor",
		"Zoom Reset del Font Editor",
		"Reset dello Zoom del Font Editor",
	],
	"vs/editor/contrib/format/formatActions": [
		"È stata apportata 1 modifica di formattazione a riga {0}",
		"Sono state apportate {0} modifiche di formattazione a riga {1}",
		"È stata apportata 1 modifica di formattazione tra le righe {0} e {1}",
		"Sono state apportate {0} modifiche di formattazione tra le righe {1} e {2}",
		"Non c\'è alcun formattatore installato per i file \'{0}\'.",
		"Formatta documento",
		"Non è installato alcun formattatore di documenti per i file \'{0}\'.",
		"Formatta selezione",
		"Non è installato alcun formattatore di selezione per i file \'{0}\'.",
	],
	"vs/editor/contrib/goToDefinition/goToDefinitionCommands": [
		"Non è stata trovata alcuna definizione per \'{0}\'",
		"Non è stata trovata alcuna definizione",
		" - Definizioni di {0}",
		"Vai alla definizione",
		"Apri definizione lateralmente",
		"Visualizza la definizione",
		"Non sono state trovate implementazioni per \'{0}\'",
		"Non sono state trovate implementazioni",
		"- {0} implementazioni",
		"Vai all\'implementazione",
		"Anteprima implementazione",
		"Non sono state trovate definizioni di tipi per \'{0}\'",
		"Non sono state trovate definizioni di tipi",
		" - {0} definizioni di tipo",
		"Vai alla definizione di tipo",
		"Anteprima definizione di tipo",
	],
	"vs/editor/contrib/goToDefinition/goToDefinitionMouse": [
		"Fare clic per visualizzare {0} definizioni.",
	],
	"vs/editor/contrib/gotoError/gotoError": [
		"Vai al problema successivo (Errore, Avviso, Informazioni)",
		"Vai al problema precedente (Errore, Avviso, Info)",
		"Vai al Problema Successivo nei File (Error, Warning, Info)",
		"Vai al Problema Precedente nei File (Error, Warning, Info) ",
	],
	"vs/editor/contrib/gotoError/gotoErrorWidget": [
		"({0}/{1})",
		"Colore per gli errori del widget di spostamento tra marcatori dell\'editor.",
		"Colore per gli avvisi del widget di spostamento tra marcatori dell\'editor.",
		"Colore delle informazioni del widget di navigazione marcatori dell\'editor.",
		"Sfondo del widget di spostamento tra marcatori dell\'editor.",
	],
	"vs/editor/contrib/hover/hover": [
		"Visualizza passaggio del mouse",
	],
	"vs/editor/contrib/hover/modesContentHover": [
		"Caricamento...",
	],
	"vs/editor/contrib/inPlaceReplace/inPlaceReplace": [
		"Sostituisci con il valore precedente",
		"Sostituisci con il valore successivo",
	],
	"vs/editor/contrib/linesOperations/linesOperations": [
		"Copia la riga in alto",
		"&&Copy Line Up",
		"Copia la riga in basso",
		"Co&&py Line Down",
		"Sposta la riga in alto",
		"Mo&&ve Line Up",
		"Sposta la riga in basso",
		"Move &&Line Down",
		"Ordinamento righe crescente",
		"Ordinamento righe decrescente",
		"Taglia spazio vuoto finale",
		"Elimina la riga",
		"Imposta un rientro per la riga",
		"Riduci il rientro per la riga",
		"Inserisci la riga sopra",
		"Inserisci la riga sotto",
		"Elimina tutto a sinistra",
		"Elimina tutto a destra",
		"Unisci righe",
		"Trasponi caratteri intorno al cursore",
		"Converti in maiuscolo",
		"Converti in minuscolo",
	],
	"vs/editor/contrib/links/links": [
		"Cmd + clic per seguire il collegamento",
		"CTRL + clic per seguire il collegamento",
		"Cmd + click per eseguire il comando",
		"Ctrl + clic per eseguire il comando",
		"Opzione + clic per seguire il collegamento",
		"Alt + clic per seguire il collegamento",
		"Opzione + clic per eseguire il comando",
		"Alt + clic per eseguire il comando",
		"Non è stato possibile aprire questo collegamento perché il formato non è valido: {0}",
		"Non è stato possibile aprire questo collegamento perché manca la destinazione.",
		"Apri il collegamento",
	],
	"vs/editor/contrib/message/messageController": [
		"Impossibile modificare nell\'editor di sola lettura",
	],
	"vs/editor/contrib/multicursor/multicursor": [
		"Aggiungi cursore sopra",
		"&&Add Cursor Above",
		"Aggiungi cursore sotto",
		"A&&dd Cursor Below",
		"Aggiungi cursore alla fine delle righe",
		"Add C&&ursors to Line Ends",
		"Aggiungi selezione a risultato ricerca successivo",
		"Add &&Next Occurrence",
		"Aggiungi selezione a risultato ricerca precedente",
		"Add P&&revious Occurrence",
		"Sposta ultima selezione a risultato ricerca successivo",
		"Sposta ultima selezione a risultato ricerca precedente",
		"Seleziona tutte le occorrenze del risultato ricerca",
		"Select All &&Occurrences",
		"Cambia tutte le occorrenze",
	],
	"vs/editor/contrib/parameterHints/parameterHints": [
		"Attiva i suggerimenti per i parametri",
	],
	"vs/editor/contrib/parameterHints/parameterHintsWidget": [
		"{0}, suggerimento",
	],
	"vs/editor/contrib/referenceSearch/peekViewWidget": [
		"Chiudi",
	],
	"vs/editor/contrib/referenceSearch/referenceSearch": [
		" - Riferimenti di {0}",
		"Trova tutti i riferimenti",
	],
	"vs/editor/contrib/referenceSearch/referencesController": [
		"Caricamento...",
	],
	"vs/editor/contrib/referenceSearch/referencesModel": [
		"simbolo in {0} alla riga {1} colonna {2}",
		"1 simbolo in {0}, percorso completo {1}",
		"{0} simboli in {1}, percorso completo {2}",
		"Non sono stati trovati risultati",
		"Trovato 1 simbolo in {0}",
		"Trovati {0} simboli in {1}",
		"Trovati {0} simboli in {1} file",
	],
	"vs/editor/contrib/referenceSearch/referencesWidget": [
		"Non è stato possibile risolvere il file.",
		"{0} riferimenti",
		"{0} riferimento",
		"anteprima non disponibile",
		"Riferimenti",
		"Nessun risultato",
		"Riferimenti",
		"Colore di sfondo dell\'area del titolo della visualizzazione rapida.",
		"Colore del titolo della visualizzazione rapida.",
		"Colore delle informazioni del titolo della visualizzazione rapida.",
		"Colore dei bordi e della freccia della visualizzazione rapida.",
		"Colore di sfondo dell\'elenco risultati della visualizzazione rapida.",
		"Colore primo piano dei nodi riga nell\'elenco risultati della visualizzazione rapida.",
		"Colore primo piano dei nodi file nell\'elenco risultati della visualizzazione rapida.",
		"Colore di sfondo della voce selezionata nell\'elenco risultati della visualizzazione rapida.",
		"Colore primo piano della voce selezionata nell\'elenco risultati della visualizzazione rapida.",
		"Colore di sfondo dell\'editor di visualizzazioni rapide.",
		"Colore di sfondo della barra di navigazione nell\'editor visualizzazione rapida.",
		"Colore dell\'evidenziazione delle corrispondenze nell\'elenco risultati della visualizzazione rapida.",
		"Colore dell\'evidenziazione delle corrispondenze nell\'editor di visualizzazioni rapide.",
		"Bordo dell\'evidenziazione delle corrispondenze nell\'editor di visualizzazioni rapide.",
	],
	"vs/editor/contrib/rename/rename": [
		"Nessun risultato.",
		"Correttamente rinominato \'{0}\' in \'{1}\'. Sommario: {2}",
		"L\'esecuzione dell\'operazione di ridenominazione non è riuscita.",
		"Rinomina simbolo",
	],
	"vs/editor/contrib/rename/renameInputField": [
		"Consente di rinominare l\'input. Digitare il nuovo nome e premere INVIO per eseguire il commit.",
	],
	"vs/editor/contrib/smartSelect/smartSelect": [
		"Espandi SELECT",
		"&&Expand Selection",
		"Comprimi SELECT",
		"&&Shrink Selection",
	],
	"vs/editor/contrib/snippet/snippetVariables": [
		"Domenica",
		"Lunedì",
		"Martedì",
		"Mercoledì",
		"Giovedì",
		"Venerdì",
		"Sabato",
		"Dom",
		"Lun",
		"Mar",
		"Mer",
		"Gio",
		"Ven",
		"Sab",
		"Gennaio",
		"Febbraio",
		"Marzo",
		"Aprile",
		"Maggio",
		"Giugno",
		"Luglio",
		"Agosto",
		"Settembre",
		"Ottobre",
		"Novembre",
		"Dicembre",
		"Gen",
		"Feb",
		"Mar",
		"Apr",
		"Mag",
		"Giu",
		"Lug",
		"Ago",
		"Set",
		"Ott",
		"Nov",
		"Dic",
	],
	"vs/editor/contrib/suggest/suggestController": [
		"L\'accettazione di \'{0}\' ha inserito il seguente testo: {1}",
		"Attiva suggerimento",
	],
	"vs/editor/contrib/suggest/suggestWidget": [
		"Colore di sfondo del widget dei suggerimenti.",
		"Colore del bordo del widget dei suggerimenti.",
		"Colore primo piano del widget dei suggerimenti.",
		"Colore di sfondo della voce selezionata del widget dei suggerimenti.",
		"Colore delle evidenziazioni corrispondenze nel widget dei suggerimenti.",
		"Altre informazioni...{0}",
		"{0}, suggerimento, con dettagli",
		"{0}, suggerimento",
		"Meno informazioni... {0}",
		"Caricamento...",
		"Non ci sono suggerimenti.",
		"{0}, accettato",
		"{0}, suggerimento, con dettagli",
		"{0}, suggerimento",
	],
	"vs/editor/contrib/toggleTabFocusMode/toggleTabFocusMode": [
		"Attiva/Disattiva l\'uso di TAB per spostare lo stato attivo",
	],
	"vs/editor/contrib/wordHighlighter/wordHighlighter": [
		"Colore di sfondo di un simbolo durante l\'accesso in lettura, ad esempio durante la lettura di una variabile. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore di sfondo di un simbolo durante l\'accesso in scrittura, per esempio durante la scrittura di una variabile. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore del bordo di un simbolo durante l\'accesso in lettura, ad esempio durante la lettura di una variabile.",
		"Colore del bordo di un simbolo durante l\'accesso in scrittura, ad esempio durante la scrittura in una variabile.",
		"Colore del marcatore righello panoramica per evidenziazione simboli. Il colore non deve essere opaco per non nascondere decorazioni sottostanti.",
		"Colore del marcatore righello panoramica per evidenziazione simboli con accesso in scrittura. Il colore non deve essere opaco per non nascondere decorazioni sottostanti.",
		"Vai al prossimo simbolo evidenziato",
		"Vai al precedente simbolo evidenziato",
	],
	"vs/editor/standalone/browser/accessibilityHelp/accessibilityHelp": [
		"No selection",
		"Line {0}, Column {1} ({2} selected)",
		"Line {0}, Column {1}",
		"{0} selections ({1} characters selected)",
		"{0} selections",
		"Now changing the setting `accessibilitySupport` to \'on\'.",
		"Now opening the Editor Accessibility documentation page.",
		" in a read-only pane of a diff editor.",
		" in a pane of a diff editor.",
		" in a read-only code editor",
		" in a code editor",
		"To configure the editor to be optimized for usage with a Screen Reader press Command+E now.",
		"To configure the editor to be optimized for usage with a Screen Reader press Control+E now.",
		"The editor is configured to be optimized for usage with a Screen Reader.",
		"The editor is configured to never be optimized for usage with a Screen Reader, which is not the case at this time.",
		"Pressing Tab in the current editor will move focus to the next focusable element. Toggle this behavior by pressing {0}.",
		"Pressing Tab in the current editor will move focus to the next focusable element. The command {0} is currently not triggerable by a keybinding.",
		"Pressing Tab in the current editor will insert the tab character. Toggle this behavior by pressing {0}.",
		"Pressing Tab in the current editor will insert the tab character. The command {0} is currently not triggerable by a keybinding.",
		"Press Command+H now to open a browser window with more information related to editor accessibility.",
		"Press Control+H now to open a browser window with more information related to editor accessibility.",
		"You can dismiss this tooltip and return to the editor by pressing Escape or Shift+Escape.",
		"Show Accessibility Help",
	],
	"vs/editor/standalone/browser/inspectTokens/inspectTokens": [
		"Developer: Inspect Tokens",
	],
	"vs/editor/standalone/browser/quickOpen/gotoLine": [
		"Go to line {0} and character {1}",
		"Go to line {0}",
		"Type a line number between 1 and {0} to navigate to",
		"Type a character between 1 and {0} to navigate to",
		"Go to line {0}",
		"Type a line number, followed by an optional colon and a character number to navigate to",
		"Go to Line...",
	],
	"vs/editor/standalone/browser/quickOpen/quickCommand": [
		"{0}, commands",
		"Type the name of an action you want to execute",
		"Command Palette",
	],
	"vs/editor/standalone/browser/quickOpen/quickOutline": [
		"{0}, symbols",
		"Type the name of an identifier you wish to navigate to",
		"Go to Symbol...",
		"symbols ({0})",
		"modules ({0})",
		"classes ({0})",
		"interfaces ({0})",
		"methods ({0})",
		"functions ({0})",
		"properties ({0})",
		"variables ({0})",
		"variables ({0})",
		"constructors ({0})",
		"calls ({0})",
	],
	"vs/editor/standalone/browser/simpleServices": [
		"Made {0} edits in {1} files",
	],
	"vs/editor/standalone/browser/standaloneCodeEditor": [
		"Editor content",
		"Press Ctrl+F1 for Accessibility Options.",
		"Press Alt+F1 for Accessibility Options.",
	],
	"vs/editor/standalone/browser/toggleHighContrast/toggleHighContrast": [
		"Toggle High Contrast Theme",
	],
	"vs/platform/configuration/common/configurationRegistry": [
		"Override configurazione predefinita",
		"Consente di configurare le impostazioni dell\'editor di cui eseguire l\'override per il linguaggio {0}.",
		"Consente di configurare le impostazioni dell\'editor di cui eseguire l\'override per un linguaggio.",
		"Non è possibile registrare \'{0}\'. Corrisponde al criterio di proprietà \'\\\\[.*\\\\]$\' per la descrizione delle impostazioni dell\'editor specifiche del linguaggio. Usare il contributo \'configurationDefaults\'.",
		"Non è possibile registrare \'{0}\'. Questa proprietà è già registrata.",
	],
	"vs/platform/keybinding/common/abstractKeybindingService": [
		"È stato premuto ({0}). In attesa del secondo tasto...",
		"La combinazione di tasti ({0}, {1}) non è un comando.",
	],
	"vs/platform/list/browser/listService": [
		"Area di lavoro",
		"Rappresenta il tasto \'Control\' (ctrl) su Windows e Linux e il tasto \'Comando\' (cmd) su OSX.",
		"Rappresenta il tasto \'Alt\' su Windows e Linux e il tasto \'Opzione\' su OSX.",
		"Modificatore da usare per aggiungere un elemento in alberi ed elenchi a una selezione multipla con il mouse (ad esempio editor aperti e visualizzazione Gestione controllo servizi in Esplora risorse). \'ctrlCmd\' rappresenta il tasto \'CTRL\' in Windows e Linux e  il tasto \'Cmd\' in OSX. I gesti del mouse Apri lateralmente, se supportati, si adatteranno in modo da non entrare in conflitto con il modificatore di selezione multipla.",
		"Controlla la modalità di apertura degli elementi in alberi ed elenchi con il mouse, se supportata. Impostare su `singleClick` per aprire gli elementi con un unico clic del mouse e `doubleClick` per aprirli solo se viene fatto doppio clic. Per gli elementi padre con elementi figlio negli alberi, questa impostazione controllerà se per espandere l\'elemento padre è necessario fare clic una sola volta o fare doppio clic. Tenere presente che alcuni alberi ed elenchi potrebbero scegliere di ignorare questa impostazione se non è applicabile. ",
		"Controlla se gli alberi supportano lo scorrimento orizzontale in workbench.",
	],
	"vs/platform/markers/common/markers": [
		"Errore",
		"Avviso",
		"Informazioni",
	],
	"vs/platform/theme/common/colorRegistry": [
		"Colori usati nell\'area di lavoro.",
		"Colore primo piano. Questo colore è utilizzato solo se non viene sovrascritto da un componente.",
		"Colore primo piano globale per i messaggi di errore. Questo colore è utilizzato solamente se non viene sottoposto a override da un componente.",
		"Colore dei bordi degli elementi evidenziati. Questo colore è utilizzato solo se non viene sovrascritto da un componente.",
		"Un bordo supplementare attorno agli elementi per contrastarli maggiormente rispetto agli altri.",
		"Un bordo supplementare intorno agli elementi attivi per contrastarli maggiormente rispetto agli altri.",
		"Colore primo piano dei link nel testo.",
		"Colore sfondo per blocchi di codice nel testo.",
		"Colore ombreggiatura dei widget, ad es. Trova/Sostituisci all\'interno dell\'editor.",
		"Sfondo della casella di input.",
		"Primo piano della casella di input.",
		"Bordo della casella di input.",
		"Colore del bordo di opzioni attivate nei campi di input.",
		"Colore di sfondo di convalida dell\'input di tipo Informazione.",
		"Colore bordo di convalida dell\'input di tipo Informazione.",
		"Colore di sfondo di convalida dell\'input di tipo Avviso.",
		"Colore bordo di convalida dell\'input di tipo Avviso.",
		"Colore di sfondo di convalida dell\'input di tipo Errore.",
		"Colore bordo di convalida dell\'input di tipo Errore.",
		"Colore sfondo Elenco/Struttura ad albero per l\'elemento evidenziato quando l\'Elenco/Struttura ad albero è attivo. Un Elenco/Struttura ad albero attivo\nha il focus della tastiera, uno inattivo no.",
		"Colore primo piano Elenco/Struttura ad albero per l\'elemento con stato attivo quando l\'Elenco/Struttura ad albero è attivo. Un Elenco/Struttura ad albero attivo\nha il focus della tastiera, uno inattivo no.",
		"Colore sfondo Elenco/Struttura ad albero per l\'elemento selezionato quando l\'Elenco/Struttura ad albero è attivo. Un Elenco/Struttura ad albero attivo\nha il focus della tastiera, uno inattivo no.",
		"Colore primo piano Elenco/Struttura ad albero per l\'elemento selezionato quando l\'Elenco/Struttura ad albero è attivo. Un Elenco/Struttura ad albero attivo\nha il focus della tastiera, uno inattivo no.",
		"Colore sfondo Elenco/Struttura ad albero per l\'elemento selezionato quando l\'Elenco/Struttura ad albero è inattivo. Un Elenco/Struttura ad albero attivo\nha il focus della tastiera, uno inattivo no.",
		"Colore primo piano Elenco/Struttura ad albero per l\'elemento selezionato quando l\'Elenco/Struttura ad albero è inattivo. Un Elenco/Struttura ad albero attivo\nha il focus della tastiera, uno inattivo no.",
		"List/Tree background color for the focused item when the list/tree is inactive. An active list/tree has keyboard focus, an inactive does not.",
		"Sfondo Elenco/Struttura ad albero al passaggio del mouse sugli elementi.",
		"Primo piano Elenco/Struttura ad albero al passaggio del mouse sugli elementi.",
		"Sfondo Elenco/Struttura ad albero durante il trascinamento degli elementi selezionati.",
		"Colore primo piano Elenco/Struttura ad albero delle occorrenze trovate durante la ricerca nell\'Elenco/Struttura ad albero.",
		"Colore di selezione rapida per il raggruppamento delle etichette.",
		"Colore di selezione rapida per il raggruppamento dei bordi.",
		"Colore di sfondo del badge. I badge sono piccole etichette informative, ad esempio per mostrare il conteggio dei risultati di una ricerca.",
		"Colore primo piano del badge. I badge sono piccole etichette informative, ad esempio per mostrare il conteggio dei risultati di una ricerca.",
		"Ombra di ScrollBar per indicare lo scorrimento della visualizzazione.",
		"Colore di sfondo dello slider della barra di scorrimento.",
		"Colore di sfondo dello Slider della Barra di scorrimento al passaggio del mouse.",
		"Colore di sfondo del cursore della barra di scorrimento quando cliccata.",
		"Colore di sfondo dell\'indicatore di stato che può essere mostrato durante l\'esecuzione di operazioni lunghe.",
		"Colore di sfondo dell\'editor.",
		"Colore primo piano predefinito dell\'editor.",
		"Colore di sfondo dei widget dell\'editor, ad esempio Trova/Sostituisci.",
		"Colore bordo dei widget dell\'editor. Il colore viene utilizzato solo se il widget sceglie di avere un bordo e se il colore non è sottoposto a override da un widget.",
		"Border color of the resize bar of editor widgets. The color is only used if the widget chooses to have a resize border and if the color is not overridden by a widget.",
		"Colore della selezione dell\'editor.",
		"Colore del testo selezionato per il contrasto elevato.",
		"Colore della selezione in un editor non attivo. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore delle aree con lo stesso contenuto della selezione. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore del bordo delle regioni con lo stesso contenuto della selezione.",
		"Colore della corrispondenza di ricerca corrente.",
		"Colore degli altri risultati della ricerca. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore dell\'intervallo di limite della ricerca. Il colore non deve essere opaco per non nascondere decorazioni sottostanti.",
		"Colore del bordo della corrispondenza della ricerca corrente.",
		"Colore del bordo delle altre corrispondenze della ricerca.",
		"Colore del bordo dell\'intervallo di limite della ricerca. Il colore non deve essere opaco per non nascondere decorazioni sottostanti.",
		"Evidenziazione sotto la parola per cui è visualizzata un\'area sensibile al passaggio del mouse. Il colore non deve essere opaco per evitare di nascondere le decorazioni sottostanti.",
		"Colore di sfondo dell\'area sensibile al passaggio del mouse dell\'editor.",
		"Colore del bordo dell\'area sensibile al passaggio del mouse dell\'editor.",
		"Colore dei collegamenti attivi.",
		"Colore di sfondo per il testo che è stato inserito. Il colore non deve essere opaco per non nascondere le decorazioni sottostanti.",
		"Colore di sfondo per il testo che è stato rimosso. Il colore non deve essere opaco per non nascondere le decorazioni sottostanti.",
		"Colore del contorno del testo che è stato inserito.",
		"Colore del contorno del testo che è stato rimosso.",
		"Border color between the two text editors.",
		"Colore del marcatore righello panoramica per trovare corrispondenze. Il colore non deve essere opaco per non nascondere decorazioni sottostanti.",
		"Colore del marcatore righello panoramica per evidenziazione selezioni. Il colore non deve essere opaco per non nascondere decorazioni sottostanti.",
	]
});