/*!-----------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.14.6(6c8f02b41db9ae5c4d15df767d47755e5c73b9d5)
 * Released under the MIT license
 * https://github.com/Microsoft/vscode/blob/master/LICENSE.txt
 *-----------------------------------------------------------*/

define("vs/editor/editor.main.nls.ru", {
	"vs/base/browser/ui/actionbar/actionbar": [
		"{0} ({1})",
	],
	"vs/base/browser/ui/aria/aria": [
		"{0} (произошло снова)",
		"{0} (occurred {1} times)",
	],
	"vs/base/browser/ui/findinput/findInput": [
		"ввод",
	],
	"vs/base/browser/ui/findinput/findInputCheckboxes": [
		"С учетом регистра",
		"Слово целиком",
		"Использовать регулярное выражение",
	],
	"vs/base/browser/ui/inputbox/inputBox": [
		"Ошибка: {0}",
		"Предупреждение: {0}",
		"Сведения: {0}",
	],
	"vs/base/browser/ui/list/listWidget": [
		"{0}. Use the navigation keys to navigate.",
	],
	"vs/base/browser/ui/menu/menu": [
		"{0} ({1})",
	],
	"vs/base/common/keybindingLabels": [
		"CTRL",
		"SHIFT",
		"ALT",
		"Клавиша Windows",
		"CTRL",
		"SHIFT",
		"ALT",
		"Super",
		"CTRL",
		"SHIFT",
		"ALT",
		"Команда",
		"CTRL",
		"SHIFT",
		"ALT",
		"Клавиша Windows",
		"CTRL",
		"SHIFT",
		"ALT",
		"Super",
	],
	"vs/base/common/severity": [
		"Ошибка",
		"Предупреждение",
		"Сведения",
	],
	"vs/base/parts/quickopen/browser/quickOpenModel": [
		"{0}, средство выбора",
		"средство выбора",
	],
	"vs/base/parts/quickopen/browser/quickOpenWidget": [
		"Средство быстрого выбора. Введите, чтобы сузить результаты.",
		"Средство быстрого выбора",
		"{0} Results",
	],
	"vs/editor/browser/controller/coreCommands": [
		"&&Select All",
		"&&Undo",
		"&&Redo",
	],
	"vs/editor/browser/widget/codeEditorWidget": [
		"Количество курсоров ограничено {0}.",
	],
	"vs/editor/browser/widget/diffEditorWidget": [
		"Нельзя сравнить файлы, потому что один из файлов слишком большой.",
	],
	"vs/editor/browser/widget/diffReview": [
		"Закрыть",
		"строки отсутствуют",
		"1 строка",
		"строк: {0}",
		"Различие {0} из {1}; исходная версия: {2}, {3}, измененная версия: {4}, {5}",
		"пустой",
		"Исходная версия: {0}, измененная версия: {1}: {2}",
		"+ измененная версия: {0}: {1}",
		"- исходная версия: {0}: {1}",
		"Перейти к следующему различию",
		"Перейти к предыдущему различию",
	],
	"vs/editor/common/config/commonEditorConfig": [
		"Редактор",
		"Определяет семейство шрифтов.",
		"Управляет насыщенностью шрифта.",
		"Управляет размером шрифта в пикселях.",
		"Управляет высотой строк. Укажите 0 для вычисления высоты строки по размеру шрифта.",
		"Управляет интервалом между буквами в пикселях.",
		"Номера строк не отображаются.",
		"Отображаются абсолютные номера строк.",
		"Отображаемые номера строк вычисляются как расстояние в строках до положения курсора.",
		"Номера строк отображаются каждые 10 строк.",
		"Управляет отображением номеров строк.",
		"Отображать вертикальные линейки после определенного числа моноширинных символов. Для отображения нескольких линеек укажите несколько значений. Если не указано ни одного значения, вертикальные линейки отображаться не будут.",
		"Символы, которые будут использоваться как разделители слов при выполнении навигации или других операций, связанных со словами.",
		"Число пробелов в табуляции. Этот параметр переопределяется на основе содержимого файла, если установлен параметр \"editor.detectIndentation\".",
		"Ожидается число. Обратите внимание, что значение auto заменено параметром editor.detectIndentation.",
		"Вставлять пробелы при нажатии клавиши TAB. Этот параметр переопределяется на основе содержимого файла, если установлен параметр \"editor.detectIndentation\". ",
		"Ожидается логическое значение. Обратите внимание, что значение auto заменено параметром editor.detectIndentation.",
		"При открытии файла editor.tabSize и editor.insertSpaces будут определяться на основе содержимого файла.",
		"Определяет, будут ли выделения иметь скругленные углы.",
		"Определяет, будет ли содержимое редактора прокручиваться за последнюю строку.",
		"Управляет количеством дополнительных символов, на которое содержимое редактора будет прокручиваться по горизонтали.",
		"Определяет, будет ли использоваться анимация при прокрутке содержимого редактора",
		"Определяет, отображается ли мини-карта",
		"Определяет, с какой стороны будет отображаться мини-карта.",
		"Определяет, будет ли автоматически скрываться ползунок мини-карты",
		"Отображает фактические символы в строке вместо цветных блоков.",
		"Ограничивает ширину мини-карты для отображения числа столбцов не больше определенного.",
		"Controls whether the hover is shown.",
		"Time delay in milliseconds after which to the hover is shown.",
		"Controls whether the hover should remain visible when mouse is moved over it.",
		"Определяет, можно ли передать строку поиска в мини-приложение поиска из текста, выделенного в редакторе",
		"Определяет, будет ли снят флажок \"Поиск в выделенном\", когда в редакторе выбрано несколько символов или строк текста",
		"Определяет, должно ли мини-приложение поиска считывать или изменять общий буфер обмена поиска в macOS",
		"Строки не будут переноситься никогда.",
		"Строки будут переноситься по ширине окна просмотра.",
		"Строки будут переноситься по \"editor.wordWrapColumn\".",
		"Строки будут перенесены по минимальному значению из двух: ширина окна просмотра и \"editor.wordWrapColumn\".",
		"Определяет, как должны переноситься строки. Допустимые значения:\n - \"off\" (отключить перенос);\n - \"on\" (перенос окна просмотра);\n - \"wordWrapColumn\" (перенос в \"editor.wordWrapColumn\");\n - \"bounded\" (перенос при минимальной ширине окна просмотра и \"editor.wordWrapColumn\").",
		"Определяет столбец переноса редактора, если значение \"editor.wordWrap\" — \"wordWrapColumn\" или \"bounded\".",
		"No indentation. Wrapped lines begin at column 1.",
		"Wrapped lines get the same indentation as the parent.",
		"Wrapped lines get +1 indentation toward the parent.",
		"Wrapped lines get +2 indentation toward the parent.",
		"Управляет отступом строк с переносом по словам. Допустимые значения: \'none\', \'same\', \'indent\' и \'deepIndent\'.",
		"Множитель, используемый для параметров deltaX и deltaY событий прокрутки колесика мыши.",
		"Соответствует клавише CTRL в Windows и Linux и клавише COMMAND в macOS.",
		"Соответствует клавише ALT в Windows и Linux и клавише OPTION в macOS.",
		"Модификатор, который будет использоваться для добавления нескольких курсоров с помощью мыши. \"ctrlCmd\" соответствует клавише CTRL в Windows и Linux и клавише COMMAND в macOS. Жесты мыши \"Перейти к определению\" и \"Открыть ссылку\" будут изменены так, чтобы они не конфликтовали с несколькими курсорами.",
		"Объединить несколько курсоров, когда они перекрываются.",
		"Разрешение кратких предложений в строках.",
		"Разрешение кратких предложений в комментариях.",
		"Разрешение кратких предложений вне строк и комментариев.",
		"Определяет, должны ли при вводе текста автоматически отображаться предложения",
		"Управляет длительностью задержки (в мс), перед отображением кратких предложений.",
		"Включает всплывающее окно с документацией по параметру и сведениями о типе, которое отображается во время набора",
		"Определяет, должен ли редактор автоматически закрывать скобки после открытия.",
		"Управляет параметром, определяющим, должен ли редактор автоматически форматировать строку после ввода.",
		"Определяет, будет ли редактор автоматически форматировать вставленное содержимое. Модуль форматирования должен быть доступен и иметь возможность форматировать диапазон в документе.",
		"Определяет, должен ли редактор автоматически изменять отступ при вводе текста, вставке текста или перемещении строк. Для использования этого параметра должны быть доступны правила отступа для данного языка.",
		"Определяет, должны ли при вводе триггерных символов автоматически отображаться предложения.",
		"Only accept a suggestion with `Enter` when it makes a textual change.",
		"Определяет, будут ли предложения приниматься клавишей ВВОД в дополнение к клавише TAB. Это помогает избежать неоднозначности между вставкой новых строк и принятием предложений. Значение \"smart\" означает, что при изменении текста предложения будут приниматься только при нажатии клавиши ВВОД.",
		"Определяет, будут ли предложения приниматься символами фиксации. Например, в JavaScript точка с запятой (\";\") может быть символом фиксации, принимающим предложение и вводящим данный символ.",
		"Отображать предложения фрагментов поверх других предложений.",
		"Отображать предложения фрагментов под другими предложениями.",
		"Отображать предложения фрагментов рядом с другими предложениями.",
		"Не отображать предложения фрагментов.",
		"Управляет отображением фрагментов вместе с другими предложениями и их сортировкой.",
		"Управляет тем, копируется ли текущая строка при копировании без выделения.",
		"Определяет, следует ли оценивать завершения на основе слов в документе.",
		"Всегда выбирать первое предложение.",
		"Выбирать недавно использованные предложения, если введенному тексту не соответствует конкретное предложение, например, при вводе текста \"console.|\" будет выбрано предложение \"console.log\", так как \"log\" использовалось недавно.",
		"Выбирать предложения на основе предыдущих префиксов, которые завершали эти предложения, например, выбирать предложение \"console\" для \"co\" и предложение \"const\" для \"con\".",
		"Управляет предварительным выбором предложений при отображении списка предложений.",
		"Размер шрифта мини-приложения предложений",
		"Высота строки мини-приложения с предложениями",
		"Controls whether filtering and sorting suggestions accounts for small typos.",
		"Control whether an active snippet prevents quick suggestions.",
		"Определяет, будет ли редактор выделять фрагменты, совпадающие с выделенным текстом.",
		"Определяет, должен ли редактор выделять экземпляры семантических символов.",
		"Определяет, сколько украшений могут отображаться на одном месте в обзорной линейке.",
		"Определяет, следует ли рисовать границу на обзорной линейке.",
		"Управляет стилем анимации курсора.",
		"Изменение размера шрифта в редакторе при нажатой клавише CTRL и движении колесика мыши",
		"Определяет стиль курсора. Допустимые значения: \"block\", \"block-outline\", \"line\", \"line-thin\", \"underline\" и \"underline-thin\"",
		"Управляет шириной курсора, когда для параметра editor.cursorStyle установлено значение \'line\'",
		"Включает лигатуры шрифта.",
		"Управляет скрытием курсора в обзорной линейке.",
		"Render whitespace characters except for single spaces between words.",
		"Определяет, должен ли редактор обрабатывать символы пробела; возможные значения: \"none\", \"boundary\" и \"all\". Параметр \"boundary\" не обрабатывает единичные пробелы между словами.",
		"Определяет, должны ли в редакторе отображаться управляющие символы.",
		"Определяет, должны ли в редакторе отображаться направляющие отступа.",
		"Controls whether the editor should highlight the active indent guide.",
		"Highlights both the gutter and the current line.",
		"Определяет, должен ли редактор выделять текущую строку. Возможные значения: none, gutter, line и all.",
		"Управляет отображением CodeLens в редакторе",
		"Определяет, включено ли сворачивание кода в редакторе.",
		"Управляет тем, как вычисляются диапазоны сворачивания. При указании параметра \'auto\' используется стратегия сворачивания на основе языка, если она доступна. При указании параметра \'indentation\' принудительно используется стратегия на основе отступов.",
		"Определяет, будут ли автоматически скрываться элементы управления свертыванием на полях.",
		"Выделяет соответствующие скобки при выборе одной из них.",
		"Управляет отображением вертикальных полей глифа в редакторе. Поля глифа в основном используются для отладки.",
		"Вставка и удаление пробелов после позиции табуляции",
		"Удалить автоматически вставляемый конечный пробел",
		"Оставлять быстрые редакторы открытыми, даже если дважды щелкнуто их содержимое или нажата клавиша ESC.",
		"Определяет, следует ли редактору разрешить перемещение выделенных элементов с помощью перетаскивания.",
		"Редактор будет определять, подключено ли средство чтения с экрана, с помощью API-интерфейсов платформы.",
		"Редактор будет оптимизирован для использования со средством чтения с экрана в постоянном режиме.",
		"Редактор никогда не будет оптимизироваться для использования со средством чтения с экрана.",
		"Определяет, следует ли запустить редактор в режиме оптимизации для средства чтения с экрана.",
		"Controls fading out of unused code.",
		"Определяет, должен ли редактор определять ссылки и делать их доступными для щелчка",
		"Определяет, должны ли в редакторе отображаться внутренние декораторы цвета и средство выбора цвета.",
		"Включает индикатор действия кода",
		"Упорядочить импорты при сохранении?",
		"Типы действий кода, которые будут выполнены при сохранении.",
		"Время ожидания для действий кода, которые будут выполнены при сохранении.",
		"Контролирует, следует ли поддерживать первичный буфер обмена Linux.",
		"Определяет, как редактор несовпадений отображает отличия: рядом или в тексте.",
		"Определяет, должен ли редактор несовпадений трактовать несовпадения символов-разделителей как различия.",
		"Специальная обработка для больших файлов с отключением некоторых функций, которые интенсивно используют память.",
		"Определяет отображение редактором несовпадений индикаторов +/- для добавленных или удаленных изменений",
	],
	"vs/editor/common/config/editorOptions": [
		"Редактор сейчас недоступен. Чтобы открыть список действий, нажмите ALT+F1.",
		"Содержимое редактора",
	],
	"vs/editor/common/controller/cursor": [
		"Неожиданное исключение при выполнении команды.",
	],
	"vs/editor/common/modes/modesRegistry": [
		"Обычный текст",
	],
	"vs/editor/common/services/modelServiceImpl": [
		"[{0}]\n{1}",
		"[{0}] {1}",
	],
	"vs/editor/common/view/editorColorRegistry": [
		"Цвет фона для выделения строки в позиции курсора.",
		"Цвет фона границ вокруг строки в позиции курсора.",
		"Фоновый цвет выбранных диапазонов, например, в функциях быстрого открытия и поиска. Цвет должен быть прозрачным чтобы не перекрывать основных знаков отличия.",
		"Цвет фона обводки выделения.",
		"Цвет курсора редактора.",
		"Цвет фона курсора редактора. Позволяет настраивать цвет символа, перекрываемого прямоугольным курсором.",
		"Цвет пробелов в редакторе.",
		"Цвет направляющих для отступов редактора.",
		"Цвет активных направляющих для отступов редактора.",
		"Цвет номеров строк редактора.",
		"Цвет номера активной строки редактора",
		"Параметр \'Id\' является устаревшим. Используйте вместо него параметр \'editorLineNumber.activeForeground\'.",
		"Цвет номера активной строки редактора",
		"Цвет линейки редактора.",
		"Цвет переднего плана элемента CodeLens в редакторе",
		"Цвет фона парных скобок",
		"Цвет прямоугольников парных скобок",
		"Цвет границы для линейки в окне просмотра.",
		"Цвет фона поля в редакторе. В поле размещаются отступы глифов и номера строк.",
		"Цвет волнистой линии для выделения ошибок в редакторе.",
		"Цвет границ волнистой линии для выделения ошибок в редакторе.",
		"Цвет волнистой линии для выделения предупреждений в редакторе.",
		"Цвет границ волнистой линии для выделения предупреждений в редакторе.",
		"Цвет волнистой линии для выделения информационных сообщений в редакторе.",
		"Цвет границ волнистой линии для выделения информационных сообщений в редакторе. ",
		"Цвет волнистой линии для выделения подсказок в редакторе.",
		"Цвет границ волнистой линии для выделения подсказок в редакторе. ",
		"Border of unnecessary code in the editor.",
		"Opacity of unnecessary code in the editor.",
		"Цвет метки линейки в окне просмотра для ошибок.",
		"Цвет метки линейки в окне просмотра для предупреждений.",
		"Цвет метки линейки в окне просмотра для информационных сообщений.",
	],
	"vs/editor/contrib/bracketMatching/bracketMatching": [
		"Цвет метки линейки в окне просмотра для пар скобок.",
		"Перейти к скобке",
		"Выбрать скобку",
	],
	"vs/editor/contrib/caretOperations/caretOperations": [
		"Переместить курсор влево",
		"Переместить курсор вправо",
	],
	"vs/editor/contrib/caretOperations/transpose": [
		"Транспортировать буквы",
	],
	"vs/editor/contrib/clipboard/clipboard": [
		"Вырезать",
		"Cu&&t",
		"Копировать",
		"&&Copy",
		"Вставить",
		"&&Paste",
		"Копировать с выделением синтаксиса",
	],
	"vs/editor/contrib/codeAction/codeActionCommands": [
		"Показать исправления ({0})",
		"Показать исправления",
		"Быстрое исправление...",
		"Доступные действия кода отсутствуют",
		"Доступные действия кода отсутствуют",
		"Рефакторинг...",
		"Доступные операции рефакторинга отсутствуют",
		"Исходное действие...",
		"Доступные исходные действия отсутствуют",
		"Организация импортов",
		"Действие для упорядочения импортов отсутствует",
	],
	"vs/editor/contrib/comment/comment": [
		"Закомментировать или раскомментировать строку",
		"&&Toggle Line Comment",
		"Закомментировать строку",
		"Раскомментировать строку",
		"Закомментировать или раскомментировать блок",
		"Toggle &&Block Comment",
	],
	"vs/editor/contrib/contextmenu/contextmenu": [
		"Показать контекстное меню редактора",
	],
	"vs/editor/contrib/cursorUndo/cursorUndo": [
		"Soft Undo",
	],
	"vs/editor/contrib/find/findController": [
		"Найти",
		"&&Find",
		"Найти в выбранном",
		"Найти далее",
		"Найти ранее",
		"Найти следующее выделение",
		"Найти предыдущее выделение",
		"Заменить",
		"&&Replace",
	],
	"vs/editor/contrib/find/findWidget": [
		"Найти",
		"Найти",
		"Предыдущее соответствие",
		"Следующее соответствие",
		"Найти в выделении",
		"Закрыть",
		"Заменить",
		"Заменить",
		"Заменить",
		"Заменить все",
		"Режим \"Переключение замены\"",
		"Отображаются только первые {0} результатов, но все операции поиска выполняются со всем текстом.",
		"{0} из {1}",
		"Нет результатов",
	],
	"vs/editor/contrib/folding/folding": [
		"Развернуть",
		"Развернуть рекурсивно",
		"Свернуть",
		"Свернуть рекурсивно",
		"Свернуть все блоки комментариев",
		"Свернуть все регионы",
		"Развернуть все регионы",
		"Свернуть все",
		"Развернуть все",
		"Уровень папки {0}",
	],
	"vs/editor/contrib/fontZoom/fontZoom": [
		"Увеличить шрифт редактора",
		"Уменьшить шрифт редактора",
		"Сбросить масштаб шрифта редактора",
	],
	"vs/editor/contrib/format/formatActions": [
		"Внесена одна правка форматирования в строке {0}.",
		"Внесены правки форматирования ({0}) в строке {1}.",
		"Внесена одна правка форматирования между строками {0} и {1}.",
		"Внесены правки форматирования ({0}) между строками {1} и {2}.",
		"Модуль форматирования для файлов \'{0}\' не установлен.",
		"Форматировать документ",
		"Модуль форматирования документов для файлов \'{0}\' не установлен.",
		"Форматировать выбранный фрагмент",
		"Модуль форматирования выделения для файлов \'{0}\' не установлен. ",
	],
	"vs/editor/contrib/goToDefinition/goToDefinitionCommands": [
		"Определение для \"{0}\" не найдено.",
		"Определения не найдены.",
		" — определения {0}",
		"Перейти к определению",
		"Открыть определение сбоку",
		"Показать определение",
		"Не найдена реализация для \"{0}\".",
		"Не найдена реализация.",
		"— {0} реализаций",
		"Перейти к реализации",
		"Показать реализацию",
		"Не найдено определение типа для \"{0}\".",
		"Не найдено определение типа.",
		"— {0} определений типов",
		"Перейти к определению типа",
		"Показать определение типа",
	],
	"vs/editor/contrib/goToDefinition/goToDefinitionMouse": [
		"Щелкните, чтобы отобразить определения ({0}).",
	],
	"vs/editor/contrib/gotoError/gotoError": [
		"Перейти к Следующей Проблеме (Ошибке, Предупреждению, Информации)",
		"Перейти к Предыдущей Проблеме (Ошибке, Предупреждению, Информации)",
		"Перейти к следующей проблеме в файлах (ошибки, предупреждения, информационные сообщения)",
		"Перейти к предыдущей проблеме в файлах (ошибки, предупреждения, информационные сообщения)",
	],
	"vs/editor/contrib/gotoError/gotoErrorWidget": [
		"({0}/{1})",
		"Цвет ошибки в мини-приложении навигации по меткам редактора.",
		"Цвет предупреждения в мини-приложении навигации по меткам редактора.",
		"Цвет информационного сообщения в мини-приложении навигации по меткам редактора.",
		"Фон мини-приложения навигации по меткам редактора.",
	],
	"vs/editor/contrib/hover/hover": [
		"Показать при наведении",
	],
	"vs/editor/contrib/hover/modesContentHover": [
		"Идет загрузка...",
	],
	"vs/editor/contrib/inPlaceReplace/inPlaceReplace": [
		"Заменить предыдущим значением",
		"Заменить следующим значением",
	],
	"vs/editor/contrib/linesOperations/linesOperations": [
		"Копировать строку сверху",
		"&&Copy Line Up",
		"Копировать строку снизу",
		"Co&&py Line Down",
		"Переместить строку вверх",
		"Mo&&ve Line Up",
		"Переместить строку вниз",
		"Move &&Line Down",
		"Сортировка строк по возрастанию",
		"Сортировка строк по убыванию",
		"Удалить конечные символы-разделители",
		"Удалить строку",
		"Увеличить отступ",
		"Уменьшить отступ",
		"Вставить строку выше",
		"Вставить строку ниже",
		"Удалить все слева",
		"Удалить все справа",
		"_Объединить строки",
		"Транспонировать символы вокруг курсора",
		"Преобразовать в верхний регистр",
		"Преобразовать в нижний регистр",
	],
	"vs/editor/contrib/links/links": [
		"Щелкните с нажатой клавишей Cmd, чтобы перейти по ссылке",
		"Щелкните с нажатой клавишей Ctrl, чтобы перейти по ссылке",
		"Для выполнения команды щелкните ее, удерживая нажатой клавишу CMD",
		"Для выполнения команды щелкните ее, удерживая нажатой клавишу CTRL",
		"Чтобы перейти по ссылке, щелкните по ней, удерживая клавишу OPTION",
		"Щелкните с нажатой клавишей ALT, чтобы перейти по ссылке.",
		"Чтобы выполнить команду, щелкните по ней, удерживая клавишу OPTION ",
		"Для выполнения команды щелкните ее, удерживая нажатой клавишу ALT",
		"Не удалось открыть ссылку, так как она имеет неправильный формат: {0}",
		"Не удалось открыть ссылку, у нее отсутствует целевой объект.",
		"Открыть ссылку",
	],
	"vs/editor/contrib/message/messageController": [
		"Не удается выполнить изменение в редакторе только для чтения",
	],
	"vs/editor/contrib/multicursor/multicursor": [
		"Добавить курсор выше",
		"&&Add Cursor Above",
		"Добавить курсор ниже",
		"A&&dd Cursor Below",
		"Добавить курсоры к окончаниям строк",
		"Add C&&ursors to Line Ends",
		"Добавить выделение в следующее найденное совпадение",
		"Add &&Next Occurrence",
		"Добавить выделенный фрагмент в предыдущее найденное совпадение",
		"Add P&&revious Occurrence",
		"Переместить последнее выделение в следующее найденное совпадение",
		"Переместить последний выделенный фрагмент в предыдущее найденное совпадение",
		"Выбрать все вхождения найденных совпадений",
		"Select All &&Occurrences",
		"Изменить все вхождения",
	],
	"vs/editor/contrib/parameterHints/parameterHints": [
		"Переключить подсказки к параметрам",
	],
	"vs/editor/contrib/parameterHints/parameterHintsWidget": [
		"{0}, подсказка",
	],
	"vs/editor/contrib/referenceSearch/peekViewWidget": [
		"Закрыть",
	],
	"vs/editor/contrib/referenceSearch/referenceSearch": [
		" — ссылки {0}",
		"Найти все ссылки",
	],
	"vs/editor/contrib/referenceSearch/referencesController": [
		"Идет загрузка...",
	],
	"vs/editor/contrib/referenceSearch/referencesModel": [
		"ссылка в {0} в строке {1} и символе {2}",
		"1 символ в {0}, полный путь: {1}",
		"{0} символов в {1}, полный путь: {2} ",
		"Результаты не найдены",
		"Обнаружен 1 символ в {0}",
		"Обнаружено {0} символов в {1}",
		"Обнаружено {0} символов в {1} файлах",
	],
	"vs/editor/contrib/referenceSearch/referencesWidget": [
		"Не удалось разрешить файл.",
		"Ссылок: {0}",
		"{0} ссылка",
		"предварительный просмотр недоступен",
		"Ссылки",
		"Результаты отсутствуют",
		"Ссылки",
		"Цвет фона области заголовка быстрого редактора.",
		"Цвет заголовка быстрого редактора.",
		"Цвет сведений о заголовке быстрого редактора.",
		"Цвет границ быстрого редактора и массива.",
		"Цвет фона в списке результатов представления быстрого редактора.",
		"Цвет переднего плана узлов строки в списке результатов быстрого редактора.",
		"Цвет переднего плана узлов файла в списке результатов быстрого редактора.",
		"Цвет фона выбранной записи в списке результатов быстрого редактора.",
		"Цвет переднего плана выбранной записи в списке результатов быстрого редактора.",
		"Цвет фона быстрого редактора.",
		"Цвет фона поля в окне быстрого редактора.",
		"Цвет выделения совпадений в списке результатов быстрого редактора.",
		"Цвет выделения совпадений в быстром редакторе.",
		"Граница выделения совпадений в быстром редакторе.",
	],
	"vs/editor/contrib/rename/rename": [
		"Результаты отсутствуют.",
		"«{0}» успешно переименован в «{1}». Сводка: {2}",
		"Не удалось выполнить переименование.",
		"Переименовать символ",
	],
	"vs/editor/contrib/rename/renameInputField": [
		"Введите новое имя для входных данных и нажмите клавишу ВВОД для подтверждения.",
	],
	"vs/editor/contrib/smartSelect/smartSelect": [
		"Развернуть выделение",
		"&&Expand Selection",
		"Сжать выделение",
		"&&Shrink Selection",
	],
	"vs/editor/contrib/snippet/snippetVariables": [
		"Воскресенье",
		"Понедельник",
		"Вторник",
		"Среда",
		"Четверг",
		"Пятница",
		"Суббота",
		"Вс",
		"Пн",
		"Вт",
		"Ср",
		"Чт",
		"Пт",
		"Сб",
		"Январь",
		"Февраль",
		"Март",
		"Апрель",
		"Май",
		"Июнь",
		"Июль",
		"Август",
		"Сентябрь",
		"Октябрь",
		"Ноябрь",
		"Декабрь",
		"Янв",
		"Фев",
		"Мар",
		"Апр",
		"Май",
		"Июн",
		"Июл",
		"Авг",
		"Сен",
		"Окт",
		"Ноя",
		"Дек",
	],
	"vs/editor/contrib/suggest/suggestController": [
		"При принятии \"{0}\" был добавлен следующий текст: \"{1}\"",
		"Переключить предложение",
	],
	"vs/editor/contrib/suggest/suggestWidget": [
		"Цвет фона виджета подсказок.",
		"Цвет границ виджета подсказок.",
		"Цвет переднего плана мини-приложения предложений.",
		"Фоновый цвет выбранной записи в мини-приложении предложений.",
		"Цвет выделения соответствия в мини-приложении предложений.",
		"Подробнее...{0}",
		"{0}, предложение, содержит данные",
		"{0}, предложение",
		"Кратко...{0}",
		"Идет загрузка...",
		"Предложения отсутствуют.",
		"{0}, принято",
		"{0}, предложение, содержит данные",
		"{0}, предложение",
	],
	"vs/editor/contrib/toggleTabFocusMode/toggleTabFocusMode": [
		"Переключение клавиши TAB перемещает фокус.",
	],
	"vs/editor/contrib/wordHighlighter/wordHighlighter": [
		"Фон символа при доступе для чтения, например при чтении переменной. Цвет должен быть прозрачным чтобы не перекрывать основных знаков отличия.",
		"Фон символа при доступе для записи, например при записи переменной. Цвет должен быть прозрачным чтобы не перекрывать основных знаков отличия.",
		"Цвет границы символа при доступе на чтение, например, при считывании переменной.",
		"Цвет границы символа при доступе на запись, например, при записи переменной. ",
		"Цвет метки линейки в окне просмотра для выделения символов. Цвет не должен был прозрачным, чтобы не перекрывать основные знаки отличия.",
		"Цвет метки линейки в окне просмотра для выделения символов с доступом на запись. Цвет не должен был прозрачным, чтобы не перекрывать основные знаки отличия.",
		"Перейти к следующему выделению символов",
		"Перейти к предыдущему выделению символов",
	],
	"vs/editor/standalone/browser/accessibilityHelp/accessibilityHelp": [
		"No selection",
		"Line {0}, Column {1} ({2} selected)",
		"Line {0}, Column {1}",
		"{0} selections ({1} characters selected)",
		"{0} selections",
		"Now changing the setting `accessibilitySupport` to \'on\'.",
		"Now opening the Editor Accessibility documentation page.",
		" in a read-only pane of a diff editor.",
		" in a pane of a diff editor.",
		" in a read-only code editor",
		" in a code editor",
		"To configure the editor to be optimized for usage with a Screen Reader press Command+E now.",
		"To configure the editor to be optimized for usage with a Screen Reader press Control+E now.",
		"The editor is configured to be optimized for usage with a Screen Reader.",
		"The editor is configured to never be optimized for usage with a Screen Reader, which is not the case at this time.",
		"Pressing Tab in the current editor will move focus to the next focusable element. Toggle this behavior by pressing {0}.",
		"Pressing Tab in the current editor will move focus to the next focusable element. The command {0} is currently not triggerable by a keybinding.",
		"Pressing Tab in the current editor will insert the tab character. Toggle this behavior by pressing {0}.",
		"Pressing Tab in the current editor will insert the tab character. The command {0} is currently not triggerable by a keybinding.",
		"Press Command+H now to open a browser window with more information related to editor accessibility.",
		"Press Control+H now to open a browser window with more information related to editor accessibility.",
		"You can dismiss this tooltip and return to the editor by pressing Escape or Shift+Escape.",
		"Show Accessibility Help",
	],
	"vs/editor/standalone/browser/inspectTokens/inspectTokens": [
		"Developer: Inspect Tokens",
	],
	"vs/editor/standalone/browser/quickOpen/gotoLine": [
		"Go to line {0} and character {1}",
		"Go to line {0}",
		"Type a line number between 1 and {0} to navigate to",
		"Type a character between 1 and {0} to navigate to",
		"Go to line {0}",
		"Type a line number, followed by an optional colon and a character number to navigate to",
		"Go to Line...",
	],
	"vs/editor/standalone/browser/quickOpen/quickCommand": [
		"{0}, commands",
		"Type the name of an action you want to execute",
		"Command Palette",
	],
	"vs/editor/standalone/browser/quickOpen/quickOutline": [
		"{0}, symbols",
		"Type the name of an identifier you wish to navigate to",
		"Go to Symbol...",
		"symbols ({0})",
		"modules ({0})",
		"classes ({0})",
		"interfaces ({0})",
		"methods ({0})",
		"functions ({0})",
		"properties ({0})",
		"variables ({0})",
		"variables ({0})",
		"constructors ({0})",
		"calls ({0})",
	],
	"vs/editor/standalone/browser/simpleServices": [
		"Made {0} edits in {1} files",
	],
	"vs/editor/standalone/browser/standaloneCodeEditor": [
		"Editor content",
		"Press Ctrl+F1 for Accessibility Options.",
		"Press Alt+F1 for Accessibility Options.",
	],
	"vs/editor/standalone/browser/toggleHighContrast/toggleHighContrast": [
		"Toggle High Contrast Theme",
	],
	"vs/platform/configuration/common/configurationRegistry": [
		"Переопределения конфигурации по умолчанию",
		"Настройка переопределяемых параметров редактора для языка {0}.",
		"Настройка параметров редактора, переопределяемых для языка.",
		"Невозможно зарегистрировать \"{0}\". Оно соответствует шаблону свойства \'\\\\[.*\\\\]$\' для описания параметров редактора, определяемых языком. Используйте участие configurationDefaults.",
		"Невозможно зарегистрировать \"{0}\". Это свойство уже зарегистрировано.",
	],
	"vs/platform/keybinding/common/abstractKeybindingService": [
		"Была нажата клавиша ({0}). Ожидание нажатия второй клавиши сочетания...",
		"Сочетание клавиш ({0} и {1}) не является командой.",
	],
	"vs/platform/list/browser/listService": [
		"Рабочее место",
		"Соответствует клавише CTRL в Windows и Linux и клавише COMMAND в macOS.",
		"Соответствует клавише ALT в Windows и Linux и клавише OPTION в macOS.",
		"Модификатор, который будет использоваться для добавления элементов в деревьях и списках в элемент множественного выбора с помощью мыши (например, в проводнике, в открытых редакторах и в представлении scm). \"ctrlCmd\" соответствует клавише CTRL в Windows и Linux и клавише COMMAND в macOS. Жесты мыши  \"Открыть сбоку\" (если они поддерживаются), будут изменены таким образом, чтобы они не конфликтовали с модификатором элемента множественного выбора.",
		"Управляет тем, как открывать элементы в деревьях и списках с помощью мыши (если поддерживается). Укажите значение \"singleClick\", чтобы открывать элементы одним щелчком мыши, и \"doubleClick\", чтобы открывать их только двойным щелчком мыши. Для родительских элементов с дочерними элементами в деревьях этот параметр управляет тем, будет ли родительский элемент разворачиваться по одинарному или по двойному щелчку мыши. Обратите внимание, что этот параметр может игнорироваться в некоторых деревьях и списках, если он не применяется к ним. ",
		"Определяет, поддерживают ли древа горизонтальную прокрутку в рабочей области.",
	],
	"vs/platform/markers/common/markers": [
		"Ошибка",
		"Предупреждение",
		"Сведения",
	],
	"vs/platform/theme/common/colorRegistry": [
		"Цвета, используемые на рабочем месте.",
		"Общий цвет переднего плана. Этот цвет используется, только если его не переопределит компонент.",
		"Общий цвет переднего плана для сообщений об ошибках. Этот цвет используется только если его не переопределяет компонент.",
		"Общий цвет границ для элементов с фокусом. Этот цвет используется только в том случае, если не переопределен в компоненте.",
		"Дополнительная граница вокруг элементов, которая отделяет их от других элементов для улучшения контраста.",
		"Дополнительная граница вокруг активных элементов, которая отделяет их от других элементов для улучшения контраста.",
		"Цвет переднего плана для ссылок в тексте.",
		"Цвет фона для программного кода в тексте.",
		"Цвет тени мини-приложений редактора, таких как \"Найти/заменить\".",
		"Фон поля ввода.",
		"Передний план поля ввода.",
		"Граница поля ввода.",
		"Цвет границ активированных параметров в полях ввода.",
		"Фоновый цвет проверки ввода для уровня серьезности \"Сведения\".",
		"Цвет границы проверки ввода для уровня серьезности \"Сведения\".",
		"Фоновый цвет проверки ввода для уровня серьезности \"Предупреждение\".",
		"Цвет границы проверки ввода для уровня серьезности \"Предупреждение\".",
		"Фоновый цвет проверки ввода для уровня серьезности \"Ошибка\".",
		"Цвет границы проверки ввода для уровня серьезности \"Ошибка\".",
		"Фоновый цвет находящегося в фокусе элемента List/Tree, когда элемент List/Tree активен. На активном элементе List/Tree есть фокус клавиатуры, на неактивном — нет.",
		"Цвет переднего плана находящегося в фокусе элемента List/Tree, когда элемент List/Tree активен. На активном элементе List/Tree есть фокус клавиатуры, на неактивном — нет.",
		"Фоновый цвет выбранного элемента List/Tree, когда элемент List/Tree активен. На активном элементе List/Tree есть фокус клавиатуры, на неактивном — нет.",
		"Цвет переднего плана выбранного элемента List/Tree, когда элемент List/Tree активен. На активном элементе List/Tree есть фокус клавиатуры, на неактивном — нет.",
		"Фоновый цвет выбранного элемента List/Tree, когда элемент List/Tree неактивен. На активном элементе List/Tree есть фокус клавиатуры, на неактивном — нет.",
		"Цвет текста выбранного элемента List/Tree, когда элемент List/Tree неактивен. На активном элементе List/Tree есть фокус клавиатуры, на неактивном — нет.",
		"List/Tree background color for the focused item when the list/tree is inactive. An active list/tree has keyboard focus, an inactive does not.",
		"Фоновый цвет элементов List/Tree при наведении курсора мыши.",
		"Цвет переднего плана элементов List/Tree при наведении курсора мыши.",
		"Фоновый цвет элементов List/Tree при перемещении с помощью мыши.",
		"Цвет переднего плана для выделения соответствия при поиске по элементу List/Tree.",
		"Цвет средства быстрого выбора для группировки меток.",
		"Цвет средства быстрого выбора для группировки границ.",
		"Цвет фона бэджа. Бэджи - небольшие информационные элементы,  отображающие количество, например, результатов поиска.",
		"Цвет текста бэджа. Бэджи - небольшие информационные элементы, отображающие количество, например, результатов поиска.",
		"Цвет тени полосы прокрутки, которая свидетельствует о том, что содержимое прокручивается.",
		"Цвет фона ползунка полосы прокрутки.",
		"Цвет фона ползунка полосы прокрутки при наведении курсора.",
		"Цвет фона ползунка полосы прокрутки при щелчке по нему.",
		"Цвет фона индикатора выполнения, который может отображаться для длительных операций.",
		"Цвет фона редактора.",
		"Цвет переднего плана редактора по умолчанию.",
		"Цвет фона виджетов редактора, таких как найти/заменить.",
		"Цвет границы мини-приложений редактора. Этот цвет используется только в том случае, если у мини-приложения есть граница и если этот цвет не переопределен мини-приложением.",
		"Border color of the resize bar of editor widgets. The color is only used if the widget chooses to have a resize border and if the color is not overridden by a widget.",
		"Цвет выделения редактора.",
		"Цвет выделенного текста в режиме высокого контраста.",
		"Цвет выбора в не активном редакторе. Цвет должен быть прозрачным, чтобы не перекрывать основные знаки отличия.",
		"Цвет регионов с тем же содержимым, что и в выделении. Цвет должен быть прозрачным, чтобы не перекрывать основные знаки отличия.",
		"Цвет границы регионов с тем же содержимым, что и в выделении.",
		"Цвет текущего поиска совпадений.",
		"Цвет для других результатов поиска. Цвет должен быть прозрачным, чтобы не перекрывать основные знаки отличия.",
		"Цвет диапазона для ограничения поиска. Цвет должен быть прозрачным, чтобы не перекрывать основные знаки отличия.",
		"Цвет границы текущего результата поиска.",
		"Цвет границы других результатов поиска.",
		"Цвет границы диапазона для ограничения поиска. Цвет должен быть прозрачным, чтобы не перекрывать основные знаки отличия.",
		"Выделение под словом, для которого показано наведение. Цвет должен быть прозрачным, чтобы не перекрывать основные знаки отличия.",
		"Цвет фона при наведении указателя на редактор.",
		"Цвет границ при наведении указателя на редактор.",
		"Цвет активных ссылок.",
		"Цвет фона для вставленного текста. Цвет должен быть прозрачным, чтобы не перекрывать основные знаки отличия.",
		"Цвет фона для удаленного текста. Цвет должен быть прозрачным, чтобы не перекрывать основные знаки отличия. ",
		"Цвет контура для добавленных строк.",
		"Цвет контура для удаленных строк.",
		"Border color between the two text editors.",
		"Цвет метки линейки в окне просмотра для результатов поиска. Цвет не должен был прозрачным, чтобы не перекрывать основные знаки отличия.",
		"Цвет метки линейки в окне просмотра для выделения. Цвет не должен был прозрачным, чтобы не перекрывать основные знаки отличия.",
	]
});