/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
//
// **NOTE**: Do not edit directly! This file is generated using `npm run import-typescript`
//
/** Contains all the lib files */
export var libFileMap = {};
libFileMap['lib.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es5\" />\n/// <reference lib=\"dom\" />\n/// <reference lib=\"webworker.importscripts\" />\n/// <reference lib=\"scripthost\" />\n";
libFileMap['lib.dom.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/////////////////////////////\n/// DOM APIs\n/////////////////////////////\n\ninterface Account {\n    displayName: string;\n    id: string;\n    imageURL?: string;\n    name?: string;\n    rpDisplayName: string;\n}\n\ninterface AddEventListenerOptions extends EventListenerOptions {\n    once?: boolean;\n    passive?: boolean;\n}\n\ninterface AesCbcParams extends Algorithm {\n    iv: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer;\n}\n\ninterface AesCtrParams extends Algorithm {\n    counter: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer;\n    length: number;\n}\n\ninterface AesDerivedKeyParams extends Algorithm {\n    length: number;\n}\n\ninterface AesGcmParams extends Algorithm {\n    additionalData?: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer;\n    iv: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer;\n    tagLength?: number;\n}\n\ninterface AesKeyAlgorithm extends KeyAlgorithm {\n    length: number;\n}\n\ninterface AesKeyGenParams extends Algorithm {\n    length: number;\n}\n\ninterface Algorithm {\n    name: string;\n}\n\ninterface AnalyserOptions extends AudioNodeOptions {\n    fftSize?: number;\n    maxDecibels?: number;\n    minDecibels?: number;\n    smoothingTimeConstant?: number;\n}\n\ninterface AnimationEventInit extends EventInit {\n    animationName?: string;\n    elapsedTime?: number;\n    pseudoElement?: string;\n}\n\ninterface AnimationPlaybackEventInit extends EventInit {\n    currentTime?: number | null;\n    timelineTime?: number | null;\n}\n\ninterface AssertionOptions {\n    allowList?: ScopedCredentialDescriptor[];\n    extensions?: WebAuthnExtensions;\n    rpId?: string;\n    timeoutSeconds?: number;\n}\n\ninterface AssignedNodesOptions {\n    flatten?: boolean;\n}\n\ninterface AudioBufferOptions {\n    length: number;\n    numberOfChannels?: number;\n    sampleRate: number;\n}\n\ninterface AudioBufferSourceOptions {\n    buffer?: AudioBuffer | null;\n    detune?: number;\n    loop?: boolean;\n    loopEnd?: number;\n    loopStart?: number;\n    playbackRate?: number;\n}\n\ninterface AudioContextInfo {\n    currentTime?: number;\n    sampleRate?: number;\n}\n\ninterface AudioContextOptions {\n    latencyHint?: AudioContextLatencyCategory | number;\n    sampleRate?: number;\n}\n\ninterface AudioNodeOptions {\n    channelCount?: number;\n    channelCountMode?: ChannelCountMode;\n    channelInterpretation?: ChannelInterpretation;\n}\n\ninterface AudioParamDescriptor {\n    automationRate?: AutomationRate;\n    defaultValue?: number;\n    maxValue?: number;\n    minValue?: number;\n    name: string;\n}\n\ninterface AudioProcessingEventInit extends EventInit {\n    inputBuffer: AudioBuffer;\n    outputBuffer: AudioBuffer;\n    playbackTime: number;\n}\n\ninterface AudioTimestamp {\n    contextTime?: number;\n    performanceTime?: number;\n}\n\ninterface AudioWorkletNodeOptions extends AudioNodeOptions {\n    numberOfInputs?: number;\n    numberOfOutputs?: number;\n    outputChannelCount?: number[];\n    parameterData?: Record<string, number>;\n    processorOptions?: any;\n}\n\ninterface AuthenticationExtensionsClientInputs {\n    appid?: string;\n    appidExclude?: string;\n    credProps?: boolean;\n    uvm?: boolean;\n}\n\ninterface AuthenticationExtensionsClientOutputs {\n    appid?: boolean;\n    credProps?: CredentialPropertiesOutput;\n    uvm?: UvmEntries;\n}\n\ninterface AuthenticatorSelectionCriteria {\n    authenticatorAttachment?: AuthenticatorAttachment;\n    requireResidentKey?: boolean;\n    residentKey?: ResidentKeyRequirement;\n    userVerification?: UserVerificationRequirement;\n}\n\ninterface BiquadFilterOptions extends AudioNodeOptions {\n    Q?: number;\n    detune?: number;\n    frequency?: number;\n    gain?: number;\n    type?: BiquadFilterType;\n}\n\ninterface BlobPropertyBag {\n    endings?: EndingType;\n    type?: string;\n}\n\ninterface ByteLengthChunk {\n    byteLength?: number;\n}\n\ninterface CacheQueryOptions {\n    ignoreMethod?: boolean;\n    ignoreSearch?: boolean;\n    ignoreVary?: boolean;\n}\n\ninterface CanvasRenderingContext2DSettings {\n    alpha?: boolean;\n    desynchronized?: boolean;\n}\n\ninterface ChannelMergerOptions extends AudioNodeOptions {\n    numberOfInputs?: number;\n}\n\ninterface ChannelSplitterOptions extends AudioNodeOptions {\n    numberOfOutputs?: number;\n}\n\ninterface ClientData {\n    challenge: string;\n    extensions?: WebAuthnExtensions;\n    hashAlg: string | Algorithm;\n    origin: string;\n    rpId: string;\n    tokenBinding?: string;\n}\n\ninterface ClientQueryOptions {\n    includeUncontrolled?: boolean;\n    type?: ClientTypes;\n}\n\ninterface ClipboardEventInit extends EventInit {\n    clipboardData?: DataTransfer | null;\n}\n\ninterface CloseEventInit extends EventInit {\n    code?: number;\n    reason?: string;\n    wasClean?: boolean;\n}\n\ninterface CompositionEventInit extends UIEventInit {\n    data?: string;\n}\n\ninterface ComputedEffectTiming extends EffectTiming {\n    activeDuration?: number;\n    currentIteration?: number | null;\n    endTime?: number;\n    localTime?: number | null;\n    progress?: number | null;\n}\n\ninterface ComputedKeyframe {\n    composite: CompositeOperationOrAuto;\n    computedOffset: number;\n    easing: string;\n    offset: number | null;\n    [property: string]: string | number | null | undefined;\n}\n\ninterface ConfirmSiteSpecificExceptionsInformation extends ExceptionInformation {\n    arrayOfDomainStrings?: string[];\n}\n\ninterface ConstantSourceOptions {\n    offset?: number;\n}\n\ninterface ConstrainBooleanParameters {\n    exact?: boolean;\n    ideal?: boolean;\n}\n\ninterface ConstrainDOMStringParameters {\n    exact?: string | string[];\n    ideal?: string | string[];\n}\n\ninterface ConstrainDoubleRange extends DoubleRange {\n    exact?: number;\n    ideal?: number;\n}\n\ninterface ConstrainULongRange extends ULongRange {\n    exact?: number;\n    ideal?: number;\n}\n\ninterface ConstrainVideoFacingModeParameters {\n    exact?: VideoFacingModeEnum | VideoFacingModeEnum[];\n    ideal?: VideoFacingModeEnum | VideoFacingModeEnum[];\n}\n\ninterface ConvolverOptions extends AudioNodeOptions {\n    buffer?: AudioBuffer | null;\n    disableNormalization?: boolean;\n}\n\ninterface CredentialCreationOptions {\n    publicKey?: PublicKeyCredentialCreationOptions;\n    signal?: AbortSignal;\n}\n\ninterface CredentialPropertiesOutput {\n    rk?: boolean;\n}\n\ninterface CredentialRequestOptions {\n    mediation?: CredentialMediationRequirement;\n    publicKey?: PublicKeyCredentialRequestOptions;\n    signal?: AbortSignal;\n}\n\ninterface CustomEventInit<T = any> extends EventInit {\n    detail?: T;\n}\n\ninterface DOMMatrix2DInit {\n    a?: number;\n    b?: number;\n    c?: number;\n    d?: number;\n    e?: number;\n    f?: number;\n    m11?: number;\n    m12?: number;\n    m21?: number;\n    m22?: number;\n    m41?: number;\n    m42?: number;\n}\n\ninterface DOMMatrixInit extends DOMMatrix2DInit {\n    is2D?: boolean;\n    m13?: number;\n    m14?: number;\n    m23?: number;\n    m24?: number;\n    m31?: number;\n    m32?: number;\n    m33?: number;\n    m34?: number;\n    m43?: number;\n    m44?: number;\n}\n\ninterface DOMPointInit {\n    w?: number;\n    x?: number;\n    y?: number;\n    z?: number;\n}\n\ninterface DOMQuadInit {\n    p1?: DOMPointInit;\n    p2?: DOMPointInit;\n    p3?: DOMPointInit;\n    p4?: DOMPointInit;\n}\n\ninterface DOMRectInit {\n    height?: number;\n    width?: number;\n    x?: number;\n    y?: number;\n}\n\ninterface DelayOptions extends AudioNodeOptions {\n    delayTime?: number;\n    maxDelayTime?: number;\n}\n\ninterface DeviceLightEventInit extends EventInit {\n    value?: number;\n}\n\ninterface DeviceMotionEventAccelerationInit {\n    x?: number | null;\n    y?: number | null;\n    z?: number | null;\n}\n\ninterface DeviceMotionEventInit extends EventInit {\n    acceleration?: DeviceMotionEventAccelerationInit;\n    accelerationIncludingGravity?: DeviceMotionEventAccelerationInit;\n    interval?: number;\n    rotationRate?: DeviceMotionEventRotationRateInit;\n}\n\ninterface DeviceMotionEventRotationRateInit {\n    alpha?: number | null;\n    beta?: number | null;\n    gamma?: number | null;\n}\n\ninterface DeviceOrientationEventInit extends EventInit {\n    absolute?: boolean;\n    alpha?: number | null;\n    beta?: number | null;\n    gamma?: number | null;\n}\n\ninterface DevicePermissionDescriptor extends PermissionDescriptor {\n    deviceId?: string;\n    name: \"camera\" | \"microphone\" | \"speaker\";\n}\n\ninterface DocumentTimelineOptions {\n    originTime?: number;\n}\n\ninterface DoubleRange {\n    max?: number;\n    min?: number;\n}\n\ninterface DragEventInit extends MouseEventInit {\n    dataTransfer?: DataTransfer | null;\n}\n\ninterface DynamicsCompressorOptions extends AudioNodeOptions {\n    attack?: number;\n    knee?: number;\n    ratio?: number;\n    release?: number;\n    threshold?: number;\n}\n\ninterface EcKeyAlgorithm extends KeyAlgorithm {\n    namedCurve: NamedCurve;\n}\n\ninterface EcKeyGenParams extends Algorithm {\n    namedCurve: NamedCurve;\n}\n\ninterface EcKeyImportParams extends Algorithm {\n    namedCurve: NamedCurve;\n}\n\ninterface EcdhKeyDeriveParams extends Algorithm {\n    public: CryptoKey;\n}\n\ninterface EcdsaParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n}\n\ninterface EffectTiming {\n    delay?: number;\n    direction?: PlaybackDirection;\n    duration?: number | string;\n    easing?: string;\n    endDelay?: number;\n    fill?: FillMode;\n    iterationStart?: number;\n    iterations?: number;\n}\n\ninterface ElementCreationOptions {\n    is?: string;\n}\n\ninterface ElementDefinitionOptions {\n    extends?: string;\n}\n\ninterface ErrorEventInit extends EventInit {\n    colno?: number;\n    error?: any;\n    filename?: string;\n    lineno?: number;\n    message?: string;\n}\n\ninterface EventInit {\n    bubbles?: boolean;\n    cancelable?: boolean;\n    composed?: boolean;\n}\n\ninterface EventListenerOptions {\n    capture?: boolean;\n}\n\ninterface EventModifierInit extends UIEventInit {\n    altKey?: boolean;\n    ctrlKey?: boolean;\n    metaKey?: boolean;\n    modifierAltGraph?: boolean;\n    modifierCapsLock?: boolean;\n    modifierFn?: boolean;\n    modifierFnLock?: boolean;\n    modifierHyper?: boolean;\n    modifierNumLock?: boolean;\n    modifierScrollLock?: boolean;\n    modifierSuper?: boolean;\n    modifierSymbol?: boolean;\n    modifierSymbolLock?: boolean;\n    shiftKey?: boolean;\n}\n\ninterface EventSourceInit {\n    withCredentials?: boolean;\n}\n\ninterface ExceptionInformation {\n    domain?: string | null;\n}\n\ninterface FilePropertyBag extends BlobPropertyBag {\n    lastModified?: number;\n}\n\ninterface FocusEventInit extends UIEventInit {\n    relatedTarget?: EventTarget | null;\n}\n\ninterface FocusNavigationEventInit extends EventInit {\n    navigationReason?: string | null;\n    originHeight?: number;\n    originLeft?: number;\n    originTop?: number;\n    originWidth?: number;\n}\n\ninterface FocusNavigationOrigin {\n    originHeight?: number;\n    originLeft?: number;\n    originTop?: number;\n    originWidth?: number;\n}\n\ninterface FocusOptions {\n    preventScroll?: boolean;\n}\n\ninterface FullscreenOptions {\n    navigationUI?: FullscreenNavigationUI;\n}\n\ninterface GainOptions extends AudioNodeOptions {\n    gain?: number;\n}\n\ninterface GamepadEventInit extends EventInit {\n    gamepad: Gamepad;\n}\n\ninterface GetNotificationOptions {\n    tag?: string;\n}\n\ninterface GetRootNodeOptions {\n    composed?: boolean;\n}\n\ninterface HashChangeEventInit extends EventInit {\n    newURL?: string;\n    oldURL?: string;\n}\n\ninterface HkdfParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n    info: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer;\n    salt: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer;\n}\n\ninterface HmacImportParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n    length?: number;\n}\n\ninterface HmacKeyAlgorithm extends KeyAlgorithm {\n    hash: KeyAlgorithm;\n    length: number;\n}\n\ninterface HmacKeyGenParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n    length?: number;\n}\n\ninterface IDBIndexParameters {\n    multiEntry?: boolean;\n    unique?: boolean;\n}\n\ninterface IDBObjectStoreParameters {\n    autoIncrement?: boolean;\n    keyPath?: string | string[] | null;\n}\n\ninterface IDBVersionChangeEventInit extends EventInit {\n    newVersion?: number | null;\n    oldVersion?: number;\n}\n\ninterface IIRFilterOptions extends AudioNodeOptions {\n    feedback: number[];\n    feedforward: number[];\n}\n\ninterface ImageBitmapOptions {\n    colorSpaceConversion?: ColorSpaceConversion;\n    imageOrientation?: ImageOrientation;\n    premultiplyAlpha?: PremultiplyAlpha;\n    resizeHeight?: number;\n    resizeQuality?: ResizeQuality;\n    resizeWidth?: number;\n}\n\ninterface ImageBitmapRenderingContextSettings {\n    alpha?: boolean;\n}\n\ninterface ImageEncodeOptions {\n    quality?: number;\n    type?: string;\n}\n\ninterface InputEventInit extends UIEventInit {\n    data?: string | null;\n    inputType?: string;\n    isComposing?: boolean;\n}\n\ninterface IntersectionObserverEntryInit {\n    boundingClientRect: DOMRectInit;\n    intersectionRatio: number;\n    intersectionRect: DOMRectInit;\n    isIntersecting: boolean;\n    rootBounds: DOMRectInit | null;\n    target: Element;\n    time: number;\n}\n\ninterface IntersectionObserverInit {\n    root?: Element | null;\n    rootMargin?: string;\n    threshold?: number | number[];\n}\n\ninterface JsonWebKey {\n    alg?: string;\n    crv?: string;\n    d?: string;\n    dp?: string;\n    dq?: string;\n    e?: string;\n    ext?: boolean;\n    k?: string;\n    key_ops?: string[];\n    kty?: string;\n    n?: string;\n    oth?: RsaOtherPrimesInfo[];\n    p?: string;\n    q?: string;\n    qi?: string;\n    use?: string;\n    x?: string;\n    y?: string;\n}\n\ninterface KeyAlgorithm {\n    name: string;\n}\n\ninterface KeyboardEventInit extends EventModifierInit {\n    code?: string;\n    isComposing?: boolean;\n    key?: string;\n    /** @deprecated */\n    keyCode?: number;\n    location?: number;\n    repeat?: boolean;\n}\n\ninterface Keyframe {\n    composite?: CompositeOperationOrAuto;\n    easing?: string;\n    offset?: number | null;\n    [property: string]: string | number | null | undefined;\n}\n\ninterface KeyframeAnimationOptions extends KeyframeEffectOptions {\n    id?: string;\n}\n\ninterface KeyframeEffectOptions extends EffectTiming {\n    composite?: CompositeOperation;\n    iterationComposite?: IterationCompositeOperation;\n}\n\ninterface MediaElementAudioSourceOptions {\n    mediaElement: HTMLMediaElement;\n}\n\ninterface MediaEncryptedEventInit extends EventInit {\n    initData?: ArrayBuffer | null;\n    initDataType?: string;\n}\n\ninterface MediaKeyMessageEventInit extends EventInit {\n    message: ArrayBuffer;\n    messageType: MediaKeyMessageType;\n}\n\ninterface MediaKeySystemConfiguration {\n    audioCapabilities?: MediaKeySystemMediaCapability[];\n    distinctiveIdentifier?: MediaKeysRequirement;\n    initDataTypes?: string[];\n    label?: string;\n    persistentState?: MediaKeysRequirement;\n    sessionTypes?: string[];\n    videoCapabilities?: MediaKeySystemMediaCapability[];\n}\n\ninterface MediaKeySystemMediaCapability {\n    contentType?: string;\n    robustness?: string;\n}\n\ninterface MediaQueryListEventInit extends EventInit {\n    matches?: boolean;\n    media?: string;\n}\n\ninterface MediaStreamAudioSourceOptions {\n    mediaStream: MediaStream;\n}\n\ninterface MediaStreamConstraints {\n    audio?: boolean | MediaTrackConstraints;\n    peerIdentity?: string;\n    video?: boolean | MediaTrackConstraints;\n}\n\ninterface MediaStreamErrorEventInit extends EventInit {\n    error?: MediaStreamError | null;\n}\n\ninterface MediaStreamEventInit extends EventInit {\n    stream?: MediaStream;\n}\n\ninterface MediaStreamTrackAudioSourceOptions {\n    mediaStreamTrack: MediaStreamTrack;\n}\n\ninterface MediaStreamTrackEventInit extends EventInit {\n    track: MediaStreamTrack;\n}\n\ninterface MediaTrackCapabilities {\n    aspectRatio?: DoubleRange;\n    autoGainControl?: boolean[];\n    channelCount?: ULongRange;\n    deviceId?: string;\n    echoCancellation?: boolean[];\n    facingMode?: string[];\n    frameRate?: DoubleRange;\n    groupId?: string;\n    height?: ULongRange;\n    latency?: DoubleRange;\n    noiseSuppression?: boolean[];\n    resizeMode?: string[];\n    sampleRate?: ULongRange;\n    sampleSize?: ULongRange;\n    width?: ULongRange;\n}\n\ninterface MediaTrackConstraintSet {\n    aspectRatio?: ConstrainDouble;\n    autoGainControl?: ConstrainBoolean;\n    channelCount?: ConstrainULong;\n    deviceId?: ConstrainDOMString;\n    echoCancellation?: ConstrainBoolean;\n    facingMode?: ConstrainDOMString;\n    frameRate?: ConstrainDouble;\n    groupId?: ConstrainDOMString;\n    height?: ConstrainULong;\n    latency?: ConstrainDouble;\n    noiseSuppression?: ConstrainBoolean;\n    resizeMode?: ConstrainDOMString;\n    sampleRate?: ConstrainULong;\n    sampleSize?: ConstrainULong;\n    width?: ConstrainULong;\n}\n\ninterface MediaTrackConstraints extends MediaTrackConstraintSet {\n    advanced?: MediaTrackConstraintSet[];\n}\n\ninterface MediaTrackSettings {\n    aspectRatio?: number;\n    autoGainControl?: boolean;\n    channelCount?: number;\n    deviceId?: string;\n    echoCancellation?: boolean;\n    facingMode?: string;\n    frameRate?: number;\n    groupId?: string;\n    height?: number;\n    latency?: number;\n    noiseSuppression?: boolean;\n    resizeMode?: string;\n    sampleRate?: number;\n    sampleSize?: number;\n    width?: number;\n}\n\ninterface MediaTrackSupportedConstraints {\n    aspectRatio?: boolean;\n    autoGainControl?: boolean;\n    channelCount?: boolean;\n    deviceId?: boolean;\n    echoCancellation?: boolean;\n    facingMode?: boolean;\n    frameRate?: boolean;\n    groupId?: boolean;\n    height?: boolean;\n    latency?: boolean;\n    noiseSuppression?: boolean;\n    resizeMode?: boolean;\n    sampleRate?: boolean;\n    sampleSize?: boolean;\n    width?: boolean;\n}\n\ninterface MessageEventInit<T = any> extends EventInit {\n    data?: T;\n    lastEventId?: string;\n    origin?: string;\n    ports?: MessagePort[];\n    source?: MessageEventSource | null;\n}\n\ninterface MidiPermissionDescriptor extends PermissionDescriptor {\n    name: \"midi\";\n    sysex?: boolean;\n}\n\ninterface MouseEventInit extends EventModifierInit {\n    button?: number;\n    buttons?: number;\n    clientX?: number;\n    clientY?: number;\n    movementX?: number;\n    movementY?: number;\n    relatedTarget?: EventTarget | null;\n    screenX?: number;\n    screenY?: number;\n}\n\ninterface MultiCacheQueryOptions extends CacheQueryOptions {\n    cacheName?: string;\n}\n\ninterface MutationObserverInit {\n    /**\n     * Set to a list of attribute local names (without namespace) if not all attribute mutations need to be observed and attributes is true or omitted.\n     */\n    attributeFilter?: string[];\n    /**\n     * Set to true if attributes is true or omitted and target's attribute value before the mutation needs to be recorded.\n     */\n    attributeOldValue?: boolean;\n    /**\n     * Set to true if mutations to target's attributes are to be observed. Can be omitted if attributeOldValue or attributeFilter is specified.\n     */\n    attributes?: boolean;\n    /**\n     * Set to true if mutations to target's data are to be observed. Can be omitted if characterDataOldValue is specified.\n     */\n    characterData?: boolean;\n    /**\n     * Set to true if characterData is set to true or omitted and target's data before the mutation needs to be recorded.\n     */\n    characterDataOldValue?: boolean;\n    /**\n     * Set to true if mutations to target's children are to be observed.\n     */\n    childList?: boolean;\n    /**\n     * Set to true if mutations to not just target, but also target's descendants are to be observed.\n     */\n    subtree?: boolean;\n}\n\ninterface NavigationPreloadState {\n    enabled?: boolean;\n    headerValue?: string;\n}\n\ninterface NotificationAction {\n    action: string;\n    icon?: string;\n    title: string;\n}\n\ninterface NotificationOptions {\n    actions?: NotificationAction[];\n    badge?: string;\n    body?: string;\n    data?: any;\n    dir?: NotificationDirection;\n    icon?: string;\n    image?: string;\n    lang?: string;\n    renotify?: boolean;\n    requireInteraction?: boolean;\n    silent?: boolean;\n    tag?: string;\n    timestamp?: number;\n    vibrate?: VibratePattern;\n}\n\ninterface OfflineAudioCompletionEventInit extends EventInit {\n    renderedBuffer: AudioBuffer;\n}\n\ninterface OfflineAudioContextOptions {\n    length: number;\n    numberOfChannels?: number;\n    sampleRate: number;\n}\n\ninterface OptionalEffectTiming {\n    delay?: number;\n    direction?: PlaybackDirection;\n    duration?: number | string;\n    easing?: string;\n    endDelay?: number;\n    fill?: FillMode;\n    iterationStart?: number;\n    iterations?: number;\n}\n\ninterface OscillatorOptions extends AudioNodeOptions {\n    detune?: number;\n    frequency?: number;\n    periodicWave?: PeriodicWave;\n    type?: OscillatorType;\n}\n\ninterface PageTransitionEventInit extends EventInit {\n    persisted?: boolean;\n}\n\ninterface PannerOptions extends AudioNodeOptions {\n    coneInnerAngle?: number;\n    coneOuterAngle?: number;\n    coneOuterGain?: number;\n    distanceModel?: DistanceModelType;\n    maxDistance?: number;\n    orientationX?: number;\n    orientationY?: number;\n    orientationZ?: number;\n    panningModel?: PanningModelType;\n    positionX?: number;\n    positionY?: number;\n    positionZ?: number;\n    refDistance?: number;\n    rolloffFactor?: number;\n}\n\ninterface PaymentCurrencyAmount {\n    currency: string;\n    currencySystem?: string;\n    value: string;\n}\n\ninterface PaymentDetailsBase {\n    displayItems?: PaymentItem[];\n    modifiers?: PaymentDetailsModifier[];\n    shippingOptions?: PaymentShippingOption[];\n}\n\ninterface PaymentDetailsInit extends PaymentDetailsBase {\n    id?: string;\n    total: PaymentItem;\n}\n\ninterface PaymentDetailsModifier {\n    additionalDisplayItems?: PaymentItem[];\n    data?: any;\n    supportedMethods: string | string[];\n    total?: PaymentItem;\n}\n\ninterface PaymentDetailsUpdate extends PaymentDetailsBase {\n    error?: string;\n    total?: PaymentItem;\n}\n\ninterface PaymentItem {\n    amount: PaymentCurrencyAmount;\n    label: string;\n    pending?: boolean;\n}\n\ninterface PaymentMethodData {\n    data?: any;\n    supportedMethods: string | string[];\n}\n\ninterface PaymentOptions {\n    requestPayerEmail?: boolean;\n    requestPayerName?: boolean;\n    requestPayerPhone?: boolean;\n    requestShipping?: boolean;\n    shippingType?: string;\n}\n\ninterface PaymentRequestUpdateEventInit extends EventInit {\n}\n\ninterface PaymentShippingOption {\n    amount: PaymentCurrencyAmount;\n    id: string;\n    label: string;\n    selected?: boolean;\n}\n\ninterface Pbkdf2Params extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n    iterations: number;\n    salt: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer;\n}\n\ninterface PerformanceObserverInit {\n    buffered?: boolean;\n    entryTypes?: string[];\n    type?: string;\n}\n\ninterface PeriodicWaveConstraints {\n    disableNormalization?: boolean;\n}\n\ninterface PeriodicWaveOptions extends PeriodicWaveConstraints {\n    imag?: number[] | Float32Array;\n    real?: number[] | Float32Array;\n}\n\ninterface PermissionDescriptor {\n    name: PermissionName;\n}\n\ninterface PipeOptions {\n    preventAbort?: boolean;\n    preventCancel?: boolean;\n    preventClose?: boolean;\n    signal?: AbortSignal;\n}\n\ninterface PointerEventInit extends MouseEventInit {\n    height?: number;\n    isPrimary?: boolean;\n    pointerId?: number;\n    pointerType?: string;\n    pressure?: number;\n    tangentialPressure?: number;\n    tiltX?: number;\n    tiltY?: number;\n    twist?: number;\n    width?: number;\n}\n\ninterface PopStateEventInit extends EventInit {\n    state?: any;\n}\n\ninterface PositionOptions {\n    enableHighAccuracy?: boolean;\n    maximumAge?: number;\n    timeout?: number;\n}\n\ninterface PostMessageOptions {\n    transfer?: any[];\n}\n\ninterface ProgressEventInit extends EventInit {\n    lengthComputable?: boolean;\n    loaded?: number;\n    total?: number;\n}\n\ninterface PromiseRejectionEventInit extends EventInit {\n    promise: Promise<any>;\n    reason?: any;\n}\n\ninterface PropertyIndexedKeyframes {\n    composite?: CompositeOperationOrAuto | CompositeOperationOrAuto[];\n    easing?: string | string[];\n    offset?: number | (number | null)[];\n    [property: string]: string | string[] | number | null | (number | null)[] | undefined;\n}\n\ninterface PublicKeyCredentialCreationOptions {\n    attestation?: AttestationConveyancePreference;\n    authenticatorSelection?: AuthenticatorSelectionCriteria;\n    challenge: BufferSource;\n    excludeCredentials?: PublicKeyCredentialDescriptor[];\n    extensions?: AuthenticationExtensionsClientInputs;\n    pubKeyCredParams: PublicKeyCredentialParameters[];\n    rp: PublicKeyCredentialRpEntity;\n    timeout?: number;\n    user: PublicKeyCredentialUserEntity;\n}\n\ninterface PublicKeyCredentialDescriptor {\n    id: BufferSource;\n    transports?: AuthenticatorTransport[];\n    type: PublicKeyCredentialType;\n}\n\ninterface PublicKeyCredentialEntity {\n    name: string;\n}\n\ninterface PublicKeyCredentialParameters {\n    alg: COSEAlgorithmIdentifier;\n    type: PublicKeyCredentialType;\n}\n\ninterface PublicKeyCredentialRequestOptions {\n    allowCredentials?: PublicKeyCredentialDescriptor[];\n    challenge: BufferSource;\n    extensions?: AuthenticationExtensionsClientInputs;\n    rpId?: string;\n    timeout?: number;\n    userVerification?: UserVerificationRequirement;\n}\n\ninterface PublicKeyCredentialRpEntity extends PublicKeyCredentialEntity {\n    id?: string;\n}\n\ninterface PublicKeyCredentialUserEntity extends PublicKeyCredentialEntity {\n    displayName: string;\n    id: BufferSource;\n}\n\ninterface PushPermissionDescriptor extends PermissionDescriptor {\n    name: \"push\";\n    userVisibleOnly?: boolean;\n}\n\ninterface PushSubscriptionJSON {\n    endpoint?: string;\n    expirationTime?: number | null;\n    keys?: Record<string, string>;\n}\n\ninterface PushSubscriptionOptionsInit {\n    applicationServerKey?: BufferSource | string | null;\n    userVisibleOnly?: boolean;\n}\n\ninterface QueuingStrategy<T = any> {\n    highWaterMark?: number;\n    size?: QueuingStrategySizeCallback<T>;\n}\n\ninterface RTCAnswerOptions extends RTCOfferAnswerOptions {\n}\n\ninterface RTCCertificateExpiration {\n    expires?: number;\n}\n\ninterface RTCConfiguration {\n    bundlePolicy?: RTCBundlePolicy;\n    certificates?: RTCCertificate[];\n    iceCandidatePoolSize?: number;\n    iceServers?: RTCIceServer[];\n    iceTransportPolicy?: RTCIceTransportPolicy;\n    peerIdentity?: string;\n    rtcpMuxPolicy?: RTCRtcpMuxPolicy;\n}\n\ninterface RTCDTMFToneChangeEventInit extends EventInit {\n    tone: string;\n}\n\ninterface RTCDataChannelEventInit extends EventInit {\n    channel: RTCDataChannel;\n}\n\ninterface RTCDataChannelInit {\n    id?: number;\n    maxPacketLifeTime?: number;\n    maxRetransmits?: number;\n    negotiated?: boolean;\n    ordered?: boolean;\n    priority?: RTCPriorityType;\n    protocol?: string;\n}\n\ninterface RTCDtlsFingerprint {\n    algorithm?: string;\n    value?: string;\n}\n\ninterface RTCDtlsParameters {\n    fingerprints?: RTCDtlsFingerprint[];\n    role?: RTCDtlsRole;\n}\n\ninterface RTCErrorEventInit extends EventInit {\n    error: RTCError;\n}\n\ninterface RTCErrorInit {\n    errorDetail: RTCErrorDetailType;\n    httpRequestStatusCode?: number;\n    receivedAlert?: number;\n    sctpCauseCode?: number;\n    sdpLineNumber?: number;\n    sentAlert?: number;\n}\n\ninterface RTCIceCandidateAttributes extends RTCStats {\n    addressSourceUrl?: string;\n    candidateType?: RTCStatsIceCandidateType;\n    ipAddress?: string;\n    portNumber?: number;\n    priority?: number;\n    transport?: string;\n}\n\ninterface RTCIceCandidateComplete {\n}\n\ninterface RTCIceCandidateDictionary {\n    foundation?: string;\n    ip?: string;\n    msMTurnSessionId?: string;\n    port?: number;\n    priority?: number;\n    protocol?: RTCIceProtocol;\n    relatedAddress?: string;\n    relatedPort?: number;\n    tcpType?: RTCIceTcpCandidateType;\n    type?: RTCIceCandidateType;\n}\n\ninterface RTCIceCandidateInit {\n    candidate?: string;\n    sdpMLineIndex?: number | null;\n    sdpMid?: string | null;\n    usernameFragment?: string | null;\n}\n\ninterface RTCIceCandidatePair {\n    local?: RTCIceCandidate;\n    remote?: RTCIceCandidate;\n}\n\ninterface RTCIceCandidatePairStats extends RTCStats {\n    availableIncomingBitrate?: number;\n    availableOutgoingBitrate?: number;\n    bytesReceived?: number;\n    bytesSent?: number;\n    localCandidateId?: string;\n    nominated?: boolean;\n    priority?: number;\n    readable?: boolean;\n    remoteCandidateId?: string;\n    roundTripTime?: number;\n    state?: RTCStatsIceCandidatePairState;\n    transportId?: string;\n    writable?: boolean;\n}\n\ninterface RTCIceGatherOptions {\n    gatherPolicy?: RTCIceGatherPolicy;\n    iceservers?: RTCIceServer[];\n}\n\ninterface RTCIceParameters {\n    password?: string;\n    usernameFragment?: string;\n}\n\ninterface RTCIceServer {\n    credential?: string | RTCOAuthCredential;\n    credentialType?: RTCIceCredentialType;\n    urls: string | string[];\n    username?: string;\n}\n\ninterface RTCIdentityProviderOptions {\n    peerIdentity?: string;\n    protocol?: string;\n    usernameHint?: string;\n}\n\ninterface RTCInboundRTPStreamStats extends RTCRTPStreamStats {\n    bytesReceived?: number;\n    fractionLost?: number;\n    jitter?: number;\n    packetsLost?: number;\n    packetsReceived?: number;\n}\n\ninterface RTCMediaStreamTrackStats extends RTCStats {\n    audioLevel?: number;\n    echoReturnLoss?: number;\n    echoReturnLossEnhancement?: number;\n    frameHeight?: number;\n    frameWidth?: number;\n    framesCorrupted?: number;\n    framesDecoded?: number;\n    framesDropped?: number;\n    framesPerSecond?: number;\n    framesReceived?: number;\n    framesSent?: number;\n    remoteSource?: boolean;\n    ssrcIds?: string[];\n    trackIdentifier?: string;\n}\n\ninterface RTCOAuthCredential {\n    accessToken: string;\n    macKey: string;\n}\n\ninterface RTCOfferAnswerOptions {\n    voiceActivityDetection?: boolean;\n}\n\ninterface RTCOfferOptions extends RTCOfferAnswerOptions {\n    iceRestart?: boolean;\n    offerToReceiveAudio?: boolean;\n    offerToReceiveVideo?: boolean;\n}\n\ninterface RTCOutboundRTPStreamStats extends RTCRTPStreamStats {\n    bytesSent?: number;\n    packetsSent?: number;\n    roundTripTime?: number;\n    targetBitrate?: number;\n}\n\ninterface RTCPeerConnectionIceErrorEventInit extends EventInit {\n    errorCode: number;\n    hostCandidate?: string;\n    statusText?: string;\n    url?: string;\n}\n\ninterface RTCPeerConnectionIceEventInit extends EventInit {\n    candidate?: RTCIceCandidate | null;\n    url?: string | null;\n}\n\ninterface RTCRTPStreamStats extends RTCStats {\n    associateStatsId?: string;\n    codecId?: string;\n    firCount?: number;\n    isRemote?: boolean;\n    mediaTrackId?: string;\n    mediaType?: string;\n    nackCount?: number;\n    pliCount?: number;\n    sliCount?: number;\n    ssrc?: string;\n    transportId?: string;\n}\n\ninterface RTCRtcpFeedback {\n    parameter?: string;\n    type?: string;\n}\n\ninterface RTCRtcpParameters {\n    cname?: string;\n    reducedSize?: boolean;\n}\n\ninterface RTCRtpCapabilities {\n    codecs: RTCRtpCodecCapability[];\n    headerExtensions: RTCRtpHeaderExtensionCapability[];\n}\n\ninterface RTCRtpCodecCapability {\n    channels?: number;\n    clockRate: number;\n    mimeType: string;\n    sdpFmtpLine?: string;\n}\n\ninterface RTCRtpCodecParameters {\n    channels?: number;\n    clockRate: number;\n    mimeType: string;\n    payloadType: number;\n    sdpFmtpLine?: string;\n}\n\ninterface RTCRtpCodingParameters {\n    rid?: string;\n}\n\ninterface RTCRtpContributingSource {\n    audioLevel?: number;\n    rtpTimestamp: number;\n    source: number;\n    timestamp: number;\n}\n\ninterface RTCRtpDecodingParameters extends RTCRtpCodingParameters {\n}\n\ninterface RTCRtpEncodingParameters extends RTCRtpCodingParameters {\n    active?: boolean;\n    codecPayloadType?: number;\n    dtx?: RTCDtxStatus;\n    maxBitrate?: number;\n    maxFramerate?: number;\n    ptime?: number;\n    scaleResolutionDownBy?: number;\n}\n\ninterface RTCRtpFecParameters {\n    mechanism?: string;\n    ssrc?: number;\n}\n\ninterface RTCRtpHeaderExtension {\n    kind?: string;\n    preferredEncrypt?: boolean;\n    preferredId?: number;\n    uri?: string;\n}\n\ninterface RTCRtpHeaderExtensionCapability {\n    uri?: string;\n}\n\ninterface RTCRtpHeaderExtensionParameters {\n    encrypted?: boolean;\n    id: number;\n    uri: string;\n}\n\ninterface RTCRtpParameters {\n    codecs: RTCRtpCodecParameters[];\n    headerExtensions: RTCRtpHeaderExtensionParameters[];\n    rtcp: RTCRtcpParameters;\n}\n\ninterface RTCRtpReceiveParameters extends RTCRtpParameters {\n    encodings: RTCRtpDecodingParameters[];\n}\n\ninterface RTCRtpRtxParameters {\n    ssrc?: number;\n}\n\ninterface RTCRtpSendParameters extends RTCRtpParameters {\n    degradationPreference?: RTCDegradationPreference;\n    encodings: RTCRtpEncodingParameters[];\n    priority?: RTCPriorityType;\n    transactionId: string;\n}\n\ninterface RTCRtpSynchronizationSource extends RTCRtpContributingSource {\n    voiceActivityFlag?: boolean;\n}\n\ninterface RTCRtpTransceiverInit {\n    direction?: RTCRtpTransceiverDirection;\n    sendEncodings?: RTCRtpEncodingParameters[];\n    streams?: MediaStream[];\n}\n\ninterface RTCRtpUnhandled {\n    muxId?: string;\n    payloadType?: number;\n    ssrc?: number;\n}\n\ninterface RTCSessionDescriptionInit {\n    sdp?: string;\n    type?: RTCSdpType;\n}\n\ninterface RTCSrtpKeyParam {\n    keyMethod?: string;\n    keySalt?: string;\n    lifetime?: string;\n    mkiLength?: number;\n    mkiValue?: number;\n}\n\ninterface RTCSrtpSdesParameters {\n    cryptoSuite?: string;\n    keyParams?: RTCSrtpKeyParam[];\n    sessionParams?: string[];\n    tag?: number;\n}\n\ninterface RTCSsrcRange {\n    max?: number;\n    min?: number;\n}\n\ninterface RTCStats {\n    id: string;\n    timestamp: number;\n    type: RTCStatsType;\n}\n\ninterface RTCStatsEventInit extends EventInit {\n    report: RTCStatsReport;\n}\n\ninterface RTCStatsReport {\n}\n\ninterface RTCTrackEventInit extends EventInit {\n    receiver: RTCRtpReceiver;\n    streams?: MediaStream[];\n    track: MediaStreamTrack;\n    transceiver: RTCRtpTransceiver;\n}\n\ninterface RTCTransportStats extends RTCStats {\n    activeConnection?: boolean;\n    bytesReceived?: number;\n    bytesSent?: number;\n    localCertificateId?: string;\n    remoteCertificateId?: string;\n    rtcpTransportStatsId?: string;\n    selectedCandidatePairId?: string;\n}\n\ninterface ReadableStreamReadDoneResult<T> {\n    done: true;\n    value?: T;\n}\n\ninterface ReadableStreamReadValueResult<T> {\n    done: false;\n    value: T;\n}\n\ninterface RegistrationOptions {\n    scope?: string;\n    type?: WorkerType;\n    updateViaCache?: ServiceWorkerUpdateViaCache;\n}\n\ninterface RequestInit {\n    /**\n     * A BodyInit object or null to set request's body.\n     */\n    body?: BodyInit | null;\n    /**\n     * A string indicating how the request will interact with the browser's cache to set request's cache.\n     */\n    cache?: RequestCache;\n    /**\n     * A string indicating whether credentials will be sent with the request always, never, or only when sent to a same-origin URL. Sets request's credentials.\n     */\n    credentials?: RequestCredentials;\n    /**\n     * A Headers object, an object literal, or an array of two-item arrays to set request's headers.\n     */\n    headers?: HeadersInit;\n    /**\n     * A cryptographic hash of the resource to be fetched by request. Sets request's integrity.\n     */\n    integrity?: string;\n    /**\n     * A boolean to set request's keepalive.\n     */\n    keepalive?: boolean;\n    /**\n     * A string to set request's method.\n     */\n    method?: string;\n    /**\n     * A string to indicate whether the request will use CORS, or will be restricted to same-origin URLs. Sets request's mode.\n     */\n    mode?: RequestMode;\n    /**\n     * A string indicating whether request follows redirects, results in an error upon encountering a redirect, or returns the redirect (in an opaque fashion). Sets request's redirect.\n     */\n    redirect?: RequestRedirect;\n    /**\n     * A string whose value is a same-origin URL, \"about:client\", or the empty string, to set request's referrer.\n     */\n    referrer?: string;\n    /**\n     * A referrer policy to set request's referrerPolicy.\n     */\n    referrerPolicy?: ReferrerPolicy;\n    /**\n     * An AbortSignal to set request's signal.\n     */\n    signal?: AbortSignal | null;\n    /**\n     * Can only be null. Used to disassociate request from any Window.\n     */\n    window?: any;\n}\n\ninterface ResponseInit {\n    headers?: HeadersInit;\n    status?: number;\n    statusText?: string;\n}\n\ninterface RsaHashedImportParams extends Algorithm {\n    hash: HashAlgorithmIdentifier;\n}\n\ninterface RsaHashedKeyAlgorithm extends RsaKeyAlgorithm {\n    hash: KeyAlgorithm;\n}\n\ninterface RsaHashedKeyGenParams extends RsaKeyGenParams {\n    hash: HashAlgorithmIdentifier;\n}\n\ninterface RsaKeyAlgorithm extends KeyAlgorithm {\n    modulusLength: number;\n    publicExponent: BigInteger;\n}\n\ninterface RsaKeyGenParams extends Algorithm {\n    modulusLength: number;\n    publicExponent: BigInteger;\n}\n\ninterface RsaOaepParams extends Algorithm {\n    label?: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer;\n}\n\ninterface RsaOtherPrimesInfo {\n    d?: string;\n    r?: string;\n    t?: string;\n}\n\ninterface RsaPssParams extends Algorithm {\n    saltLength: number;\n}\n\ninterface SVGBoundingBoxOptions {\n    clipped?: boolean;\n    fill?: boolean;\n    markers?: boolean;\n    stroke?: boolean;\n}\n\ninterface ScopedCredentialDescriptor {\n    id: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer | null;\n    transports?: Transport[];\n    type: ScopedCredentialType;\n}\n\ninterface ScopedCredentialOptions {\n    excludeList?: ScopedCredentialDescriptor[];\n    extensions?: WebAuthnExtensions;\n    rpId?: string;\n    timeoutSeconds?: number;\n}\n\ninterface ScopedCredentialParameters {\n    algorithm: string | Algorithm;\n    type: ScopedCredentialType;\n}\n\ninterface ScrollIntoViewOptions extends ScrollOptions {\n    block?: ScrollLogicalPosition;\n    inline?: ScrollLogicalPosition;\n}\n\ninterface ScrollOptions {\n    behavior?: ScrollBehavior;\n}\n\ninterface ScrollToOptions extends ScrollOptions {\n    left?: number;\n    top?: number;\n}\n\ninterface SecurityPolicyViolationEventInit extends EventInit {\n    blockedURI?: string;\n    columnNumber?: number;\n    documentURI?: string;\n    effectiveDirective?: string;\n    lineNumber?: number;\n    originalPolicy?: string;\n    referrer?: string;\n    sourceFile?: string;\n    statusCode?: number;\n    violatedDirective?: string;\n}\n\ninterface ServiceWorkerMessageEventInit extends EventInit {\n    data?: any;\n    lastEventId?: string;\n    origin?: string;\n    ports?: MessagePort[] | null;\n    source?: ServiceWorker | MessagePort | null;\n}\n\ninterface ShadowRootInit {\n    delegatesFocus?: boolean;\n    mode: ShadowRootMode;\n}\n\ninterface ShareData {\n    text?: string;\n    title?: string;\n    url?: string;\n}\n\ninterface SpeechSynthesisErrorEventInit extends SpeechSynthesisEventInit {\n    error: SpeechSynthesisErrorCode;\n}\n\ninterface SpeechSynthesisEventInit extends EventInit {\n    charIndex?: number;\n    charLength?: number;\n    elapsedTime?: number;\n    name?: string;\n    utterance: SpeechSynthesisUtterance;\n}\n\ninterface StaticRangeInit {\n    endContainer: Node;\n    endOffset: number;\n    startContainer: Node;\n    startOffset: number;\n}\n\ninterface StereoPannerOptions extends AudioNodeOptions {\n    pan?: number;\n}\n\ninterface StorageEstimate {\n    quota?: number;\n    usage?: number;\n}\n\ninterface StorageEventInit extends EventInit {\n    key?: string | null;\n    newValue?: string | null;\n    oldValue?: string | null;\n    storageArea?: Storage | null;\n    url?: string;\n}\n\ninterface StoreExceptionsInformation extends ExceptionInformation {\n    detailURI?: string | null;\n    explanationString?: string | null;\n    siteName?: string | null;\n}\n\ninterface StoreSiteSpecificExceptionsInformation extends StoreExceptionsInformation {\n    arrayOfDomainStrings?: string[];\n}\n\ninterface TextDecodeOptions {\n    stream?: boolean;\n}\n\ninterface TextDecoderOptions {\n    fatal?: boolean;\n    ignoreBOM?: boolean;\n}\n\ninterface TextEncoderEncodeIntoResult {\n    read?: number;\n    written?: number;\n}\n\ninterface TouchEventInit extends EventModifierInit {\n    changedTouches?: Touch[];\n    targetTouches?: Touch[];\n    touches?: Touch[];\n}\n\ninterface TouchInit {\n    altitudeAngle?: number;\n    azimuthAngle?: number;\n    clientX?: number;\n    clientY?: number;\n    force?: number;\n    identifier: number;\n    pageX?: number;\n    pageY?: number;\n    radiusX?: number;\n    radiusY?: number;\n    rotationAngle?: number;\n    screenX?: number;\n    screenY?: number;\n    target: EventTarget;\n    touchType?: TouchType;\n}\n\ninterface TrackEventInit extends EventInit {\n    track?: TextTrack | null;\n}\n\ninterface Transformer<I = any, O = any> {\n    flush?: TransformStreamDefaultControllerCallback<O>;\n    readableType?: undefined;\n    start?: TransformStreamDefaultControllerCallback<O>;\n    transform?: TransformStreamDefaultControllerTransformCallback<I, O>;\n    writableType?: undefined;\n}\n\ninterface TransitionEventInit extends EventInit {\n    elapsedTime?: number;\n    propertyName?: string;\n    pseudoElement?: string;\n}\n\ninterface UIEventInit extends EventInit {\n    detail?: number;\n    view?: Window | null;\n}\n\ninterface ULongRange {\n    max?: number;\n    min?: number;\n}\n\ninterface UnderlyingByteSource {\n    autoAllocateChunkSize?: number;\n    cancel?: ReadableStreamErrorCallback;\n    pull?: ReadableByteStreamControllerCallback;\n    start?: ReadableByteStreamControllerCallback;\n    type: \"bytes\";\n}\n\ninterface UnderlyingSink<W = any> {\n    abort?: WritableStreamErrorCallback;\n    close?: WritableStreamDefaultControllerCloseCallback;\n    start?: WritableStreamDefaultControllerStartCallback;\n    type?: undefined;\n    write?: WritableStreamDefaultControllerWriteCallback<W>;\n}\n\ninterface UnderlyingSource<R = any> {\n    cancel?: ReadableStreamErrorCallback;\n    pull?: ReadableStreamDefaultControllerCallback<R>;\n    start?: ReadableStreamDefaultControllerCallback<R>;\n    type?: undefined;\n}\n\ninterface VRDisplayEventInit extends EventInit {\n    display: VRDisplay;\n    reason?: VRDisplayEventReason;\n}\n\ninterface VRLayer {\n    leftBounds?: number[] | Float32Array | null;\n    rightBounds?: number[] | Float32Array | null;\n    source?: HTMLCanvasElement | null;\n}\n\ninterface VRStageParameters {\n    sittingToStandingTransform?: Float32Array;\n    sizeX?: number;\n    sizeY?: number;\n}\n\ninterface WaveShaperOptions extends AudioNodeOptions {\n    curve?: number[] | Float32Array;\n    oversample?: OverSampleType;\n}\n\ninterface WebAuthnExtensions {\n}\n\ninterface WebGLContextAttributes {\n    alpha?: boolean;\n    antialias?: boolean;\n    depth?: boolean;\n    desynchronized?: boolean;\n    failIfMajorPerformanceCaveat?: boolean;\n    powerPreference?: WebGLPowerPreference;\n    premultipliedAlpha?: boolean;\n    preserveDrawingBuffer?: boolean;\n    stencil?: boolean;\n}\n\ninterface WebGLContextEventInit extends EventInit {\n    statusMessage?: string;\n}\n\ninterface WheelEventInit extends MouseEventInit {\n    deltaMode?: number;\n    deltaX?: number;\n    deltaY?: number;\n    deltaZ?: number;\n}\n\ninterface WorkerOptions {\n    credentials?: RequestCredentials;\n    name?: string;\n    type?: WorkerType;\n}\n\ninterface WorkletOptions {\n    credentials?: RequestCredentials;\n}\n\ninterface EventListener {\n    (evt: Event): void;\n}\n\ntype XPathNSResolver = ((prefix: string | null) => string | null) | { lookupNamespaceURI(prefix: string | null): string | null; };\n\n/** The ANGLE_instanced_arrays extension is part of the WebGL API and allows to draw the same object, or groups of similar objects multiple times, if they share the same vertex data, primitive count and type. */\ninterface ANGLE_instanced_arrays {\n    drawArraysInstancedANGLE(mode: GLenum, first: GLint, count: GLsizei, primcount: GLsizei): void;\n    drawElementsInstancedANGLE(mode: GLenum, count: GLsizei, type: GLenum, offset: GLintptr, primcount: GLsizei): void;\n    vertexAttribDivisorANGLE(index: GLuint, divisor: GLuint): void;\n    readonly VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE: GLenum;\n}\n\n/** A controller object that allows you to abort one or more DOM requests as and when desired. */\ninterface AbortController {\n    /**\n     * Returns the AbortSignal object associated with this object.\n     */\n    readonly signal: AbortSignal;\n    /**\n     * Invoking this method will set this object's AbortSignal's aborted flag and signal to any observers that the associated activity is to be aborted.\n     */\n    abort(): void;\n}\n\ndeclare var AbortController: {\n    prototype: AbortController;\n    new(): AbortController;\n};\n\ninterface AbortSignalEventMap {\n    \"abort\": Event;\n}\n\n/** A signal object that allows you to communicate with a DOM request (such as a Fetch) and abort it if required via an AbortController object. */\ninterface AbortSignal extends EventTarget {\n    /**\n     * Returns true if this AbortSignal's AbortController has signaled to abort, and false otherwise.\n     */\n    readonly aborted: boolean;\n    onabort: ((this: AbortSignal, ev: Event) => any) | null;\n    addEventListener<K extends keyof AbortSignalEventMap>(type: K, listener: (this: AbortSignal, ev: AbortSignalEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AbortSignalEventMap>(type: K, listener: (this: AbortSignal, ev: AbortSignalEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AbortSignal: {\n    prototype: AbortSignal;\n    new(): AbortSignal;\n};\n\ninterface AbstractRange {\n    /**\n     * Returns true if range is collapsed, and false otherwise.\n     */\n    readonly collapsed: boolean;\n    /**\n     * Returns range's end node.\n     */\n    readonly endContainer: Node;\n    /**\n     * Returns range's end offset.\n     */\n    readonly endOffset: number;\n    /**\n     * Returns range's start node.\n     */\n    readonly startContainer: Node;\n    /**\n     * Returns range's start offset.\n     */\n    readonly startOffset: number;\n}\n\ndeclare var AbstractRange: {\n    prototype: AbstractRange;\n    new(): AbstractRange;\n};\n\ninterface AbstractWorkerEventMap {\n    \"error\": ErrorEvent;\n}\n\ninterface AbstractWorker {\n    onerror: ((this: AbstractWorker, ev: ErrorEvent) => any) | null;\n    addEventListener<K extends keyof AbstractWorkerEventMap>(type: K, listener: (this: AbstractWorker, ev: AbstractWorkerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AbstractWorkerEventMap>(type: K, listener: (this: AbstractWorker, ev: AbstractWorkerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ninterface AesCfbParams extends Algorithm {\n    iv: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer;\n}\n\ninterface AesCmacParams extends Algorithm {\n    length: number;\n}\n\n/** A node able to provide real-time frequency and time-domain analysis information. It is an AudioNode that passes the audio stream unchanged from the input to the output, but allows you to take the generated data, process it, and create audio visualizations. */\ninterface AnalyserNode extends AudioNode {\n    fftSize: number;\n    readonly frequencyBinCount: number;\n    maxDecibels: number;\n    minDecibels: number;\n    smoothingTimeConstant: number;\n    getByteFrequencyData(array: Uint8Array): void;\n    getByteTimeDomainData(array: Uint8Array): void;\n    getFloatFrequencyData(array: Float32Array): void;\n    getFloatTimeDomainData(array: Float32Array): void;\n}\n\ndeclare var AnalyserNode: {\n    prototype: AnalyserNode;\n    new(context: BaseAudioContext, options?: AnalyserOptions): AnalyserNode;\n};\n\ninterface Animatable {\n    animate(keyframes: Keyframe[] | PropertyIndexedKeyframes | null, options?: number | KeyframeAnimationOptions): Animation;\n    getAnimations(): Animation[];\n}\n\ninterface AnimationEventMap {\n    \"cancel\": AnimationPlaybackEvent;\n    \"finish\": AnimationPlaybackEvent;\n}\n\ninterface Animation extends EventTarget {\n    currentTime: number | null;\n    effect: AnimationEffect | null;\n    readonly finished: Promise<Animation>;\n    id: string;\n    oncancel: ((this: Animation, ev: AnimationPlaybackEvent) => any) | null;\n    onfinish: ((this: Animation, ev: AnimationPlaybackEvent) => any) | null;\n    readonly pending: boolean;\n    readonly playState: AnimationPlayState;\n    playbackRate: number;\n    readonly ready: Promise<Animation>;\n    startTime: number | null;\n    timeline: AnimationTimeline | null;\n    cancel(): void;\n    finish(): void;\n    pause(): void;\n    play(): void;\n    reverse(): void;\n    updatePlaybackRate(playbackRate: number): void;\n    addEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: Animation, ev: AnimationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AnimationEventMap>(type: K, listener: (this: Animation, ev: AnimationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Animation: {\n    prototype: Animation;\n    new(effect?: AnimationEffect | null, timeline?: AnimationTimeline | null): Animation;\n};\n\ninterface AnimationEffect {\n    getComputedTiming(): ComputedEffectTiming;\n    getTiming(): EffectTiming;\n    updateTiming(timing?: OptionalEffectTiming): void;\n}\n\ndeclare var AnimationEffect: {\n    prototype: AnimationEffect;\n    new(): AnimationEffect;\n};\n\n/** Events providing information related to animations. */\ninterface AnimationEvent extends Event {\n    readonly animationName: string;\n    readonly elapsedTime: number;\n    readonly pseudoElement: string;\n}\n\ndeclare var AnimationEvent: {\n    prototype: AnimationEvent;\n    new(type: string, animationEventInitDict?: AnimationEventInit): AnimationEvent;\n};\n\ninterface AnimationFrameProvider {\n    cancelAnimationFrame(handle: number): void;\n    requestAnimationFrame(callback: FrameRequestCallback): number;\n}\n\ninterface AnimationPlaybackEvent extends Event {\n    readonly currentTime: number | null;\n    readonly timelineTime: number | null;\n}\n\ndeclare var AnimationPlaybackEvent: {\n    prototype: AnimationPlaybackEvent;\n    new(type: string, eventInitDict?: AnimationPlaybackEventInit): AnimationPlaybackEvent;\n};\n\ninterface AnimationTimeline {\n    readonly currentTime: number | null;\n}\n\ndeclare var AnimationTimeline: {\n    prototype: AnimationTimeline;\n    new(): AnimationTimeline;\n};\n\ninterface ApplicationCacheEventMap {\n    \"cached\": Event;\n    \"checking\": Event;\n    \"downloading\": Event;\n    \"error\": Event;\n    \"noupdate\": Event;\n    \"obsolete\": Event;\n    \"progress\": ProgressEvent<ApplicationCache>;\n    \"updateready\": Event;\n}\n\ninterface ApplicationCache extends EventTarget {\n    /** @deprecated */\n    oncached: ((this: ApplicationCache, ev: Event) => any) | null;\n    /** @deprecated */\n    onchecking: ((this: ApplicationCache, ev: Event) => any) | null;\n    /** @deprecated */\n    ondownloading: ((this: ApplicationCache, ev: Event) => any) | null;\n    /** @deprecated */\n    onerror: ((this: ApplicationCache, ev: Event) => any) | null;\n    /** @deprecated */\n    onnoupdate: ((this: ApplicationCache, ev: Event) => any) | null;\n    /** @deprecated */\n    onobsolete: ((this: ApplicationCache, ev: Event) => any) | null;\n    /** @deprecated */\n    onprogress: ((this: ApplicationCache, ev: ProgressEvent<ApplicationCache>) => any) | null;\n    /** @deprecated */\n    onupdateready: ((this: ApplicationCache, ev: Event) => any) | null;\n    /** @deprecated */\n    readonly status: number;\n    /** @deprecated */\n    abort(): void;\n    /** @deprecated */\n    swapCache(): void;\n    /** @deprecated */\n    update(): void;\n    readonly CHECKING: number;\n    readonly DOWNLOADING: number;\n    readonly IDLE: number;\n    readonly OBSOLETE: number;\n    readonly UNCACHED: number;\n    readonly UPDATEREADY: number;\n    addEventListener<K extends keyof ApplicationCacheEventMap>(type: K, listener: (this: ApplicationCache, ev: ApplicationCacheEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ApplicationCacheEventMap>(type: K, listener: (this: ApplicationCache, ev: ApplicationCacheEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var ApplicationCache: {\n    prototype: ApplicationCache;\n    new(): ApplicationCache;\n    readonly CHECKING: number;\n    readonly DOWNLOADING: number;\n    readonly IDLE: number;\n    readonly OBSOLETE: number;\n    readonly UNCACHED: number;\n    readonly UPDATEREADY: number;\n};\n\n/** A DOM element's attribute as an object. In most DOM methods, you will probably directly retrieve the attribute as a string (e.g., Element.getAttribute(), but certain functions (e.g., Element.getAttributeNode()) or means of iterating give Attr types. */\ninterface Attr extends Node {\n    readonly localName: string;\n    readonly name: string;\n    readonly namespaceURI: string | null;\n    readonly ownerDocument: Document;\n    readonly ownerElement: Element | null;\n    readonly prefix: string | null;\n    readonly specified: boolean;\n    value: string;\n}\n\ndeclare var Attr: {\n    prototype: Attr;\n    new(): Attr;\n};\n\n/** A short audio asset residing in memory, created from an audio file using the AudioContext.decodeAudioData() method, or from raw data using AudioContext.createBuffer(). Once put into an AudioBuffer, the audio can then be played by being passed into an AudioBufferSourceNode. */\ninterface AudioBuffer {\n    readonly duration: number;\n    readonly length: number;\n    readonly numberOfChannels: number;\n    readonly sampleRate: number;\n    copyFromChannel(destination: Float32Array, channelNumber: number, bufferOffset?: number): void;\n    copyToChannel(source: Float32Array, channelNumber: number, bufferOffset?: number): void;\n    getChannelData(channel: number): Float32Array;\n}\n\ndeclare var AudioBuffer: {\n    prototype: AudioBuffer;\n    new(options: AudioBufferOptions): AudioBuffer;\n};\n\n/** An AudioScheduledSourceNode which represents an audio source consisting of in-memory audio data, stored in an AudioBuffer. It's especially useful for playing back audio which has particularly stringent timing accuracy requirements, such as for sounds that must match a specific rhythm and can be kept in memory rather than being played from disk or the network. */\ninterface AudioBufferSourceNode extends AudioScheduledSourceNode {\n    buffer: AudioBuffer | null;\n    readonly detune: AudioParam;\n    loop: boolean;\n    loopEnd: number;\n    loopStart: number;\n    readonly playbackRate: AudioParam;\n    start(when?: number, offset?: number, duration?: number): void;\n    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioBufferSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioBufferSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AudioBufferSourceNode: {\n    prototype: AudioBufferSourceNode;\n    new(context: BaseAudioContext, options?: AudioBufferSourceOptions): AudioBufferSourceNode;\n};\n\n/** An audio-processing graph built from audio modules linked together, each represented by an AudioNode. */\ninterface AudioContext extends BaseAudioContext {\n    readonly baseLatency: number;\n    readonly outputLatency: number;\n    close(): Promise<void>;\n    createMediaElementSource(mediaElement: HTMLMediaElement): MediaElementAudioSourceNode;\n    createMediaStreamDestination(): MediaStreamAudioDestinationNode;\n    createMediaStreamSource(mediaStream: MediaStream): MediaStreamAudioSourceNode;\n    createMediaStreamTrackSource(mediaStreamTrack: MediaStreamTrack): MediaStreamTrackAudioSourceNode;\n    getOutputTimestamp(): AudioTimestamp;\n    resume(): Promise<void>;\n    suspend(): Promise<void>;\n    addEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: AudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: AudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AudioContext: {\n    prototype: AudioContext;\n    new(contextOptions?: AudioContextOptions): AudioContext;\n};\n\n/** AudioDestinationNode has no output (as it is the output, no more AudioNode can be linked after it in the audio graph) and one input. The number of channels in the input must be between 0 and the maxChannelCount value or an exception is raised. */\ninterface AudioDestinationNode extends AudioNode {\n    readonly maxChannelCount: number;\n}\n\ndeclare var AudioDestinationNode: {\n    prototype: AudioDestinationNode;\n    new(): AudioDestinationNode;\n};\n\n/** The position and orientation of the unique person listening to the audio scene, and is used in audio spatialization. All PannerNodes spatialize in relation to the AudioListener stored in the BaseAudioContext.listener attribute. */\ninterface AudioListener {\n    readonly forwardX: AudioParam;\n    readonly forwardY: AudioParam;\n    readonly forwardZ: AudioParam;\n    readonly positionX: AudioParam;\n    readonly positionY: AudioParam;\n    readonly positionZ: AudioParam;\n    readonly upX: AudioParam;\n    readonly upY: AudioParam;\n    readonly upZ: AudioParam;\n    /** @deprecated */\n    setOrientation(x: number, y: number, z: number, xUp: number, yUp: number, zUp: number): void;\n    /** @deprecated */\n    setPosition(x: number, y: number, z: number): void;\n}\n\ndeclare var AudioListener: {\n    prototype: AudioListener;\n    new(): AudioListener;\n};\n\n/** A generic interface for representing an audio processing module. Examples include: */\ninterface AudioNode extends EventTarget {\n    channelCount: number;\n    channelCountMode: ChannelCountMode;\n    channelInterpretation: ChannelInterpretation;\n    readonly context: BaseAudioContext;\n    readonly numberOfInputs: number;\n    readonly numberOfOutputs: number;\n    connect(destinationNode: AudioNode, output?: number, input?: number): AudioNode;\n    connect(destinationParam: AudioParam, output?: number): void;\n    disconnect(): void;\n    disconnect(output: number): void;\n    disconnect(destinationNode: AudioNode): void;\n    disconnect(destinationNode: AudioNode, output: number): void;\n    disconnect(destinationNode: AudioNode, output: number, input: number): void;\n    disconnect(destinationParam: AudioParam): void;\n    disconnect(destinationParam: AudioParam, output: number): void;\n}\n\ndeclare var AudioNode: {\n    prototype: AudioNode;\n    new(): AudioNode;\n};\n\n/** The Web Audio API's AudioParam interface represents an audio-related parameter, usually a parameter of an AudioNode (such as GainNode.gain). */\ninterface AudioParam {\n    automationRate: AutomationRate;\n    readonly defaultValue: number;\n    readonly maxValue: number;\n    readonly minValue: number;\n    value: number;\n    cancelAndHoldAtTime(cancelTime: number): AudioParam;\n    cancelScheduledValues(cancelTime: number): AudioParam;\n    exponentialRampToValueAtTime(value: number, endTime: number): AudioParam;\n    linearRampToValueAtTime(value: number, endTime: number): AudioParam;\n    setTargetAtTime(target: number, startTime: number, timeConstant: number): AudioParam;\n    setValueAtTime(value: number, startTime: number): AudioParam;\n    setValueCurveAtTime(values: number[] | Float32Array, startTime: number, duration: number): AudioParam;\n}\n\ndeclare var AudioParam: {\n    prototype: AudioParam;\n    new(): AudioParam;\n};\n\ninterface AudioParamMap {\n    forEach(callbackfn: (value: AudioParam, key: string, parent: AudioParamMap) => void, thisArg?: any): void;\n}\n\ndeclare var AudioParamMap: {\n    prototype: AudioParamMap;\n    new(): AudioParamMap;\n};\n\n/** The Web Audio API events that occur when a ScriptProcessorNode input buffer is ready to be processed. */\ninterface AudioProcessingEvent extends Event {\n    readonly inputBuffer: AudioBuffer;\n    readonly outputBuffer: AudioBuffer;\n    readonly playbackTime: number;\n}\n\ndeclare var AudioProcessingEvent: {\n    prototype: AudioProcessingEvent;\n    new(type: string, eventInitDict: AudioProcessingEventInit): AudioProcessingEvent;\n};\n\ninterface AudioScheduledSourceNodeEventMap {\n    \"ended\": Event;\n}\n\ninterface AudioScheduledSourceNode extends AudioNode {\n    onended: ((this: AudioScheduledSourceNode, ev: Event) => any) | null;\n    start(when?: number): void;\n    stop(when?: number): void;\n    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioScheduledSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: AudioScheduledSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AudioScheduledSourceNode: {\n    prototype: AudioScheduledSourceNode;\n    new(): AudioScheduledSourceNode;\n};\n\ninterface AudioWorklet extends Worklet {\n}\n\ndeclare var AudioWorklet: {\n    prototype: AudioWorklet;\n    new(): AudioWorklet;\n};\n\ninterface AudioWorkletNodeEventMap {\n    \"processorerror\": Event;\n}\n\ninterface AudioWorkletNode extends AudioNode {\n    onprocessorerror: ((this: AudioWorkletNode, ev: Event) => any) | null;\n    readonly parameters: AudioParamMap;\n    readonly port: MessagePort;\n    addEventListener<K extends keyof AudioWorkletNodeEventMap>(type: K, listener: (this: AudioWorkletNode, ev: AudioWorkletNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioWorkletNodeEventMap>(type: K, listener: (this: AudioWorkletNode, ev: AudioWorkletNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var AudioWorkletNode: {\n    prototype: AudioWorkletNode;\n    new(context: BaseAudioContext, name: string, options?: AudioWorkletNodeOptions): AudioWorkletNode;\n};\n\ninterface AuthenticatorAssertionResponse extends AuthenticatorResponse {\n    readonly authenticatorData: ArrayBuffer;\n    readonly signature: ArrayBuffer;\n    readonly userHandle: ArrayBuffer | null;\n}\n\ndeclare var AuthenticatorAssertionResponse: {\n    prototype: AuthenticatorAssertionResponse;\n    new(): AuthenticatorAssertionResponse;\n};\n\ninterface AuthenticatorAttestationResponse extends AuthenticatorResponse {\n    readonly attestationObject: ArrayBuffer;\n}\n\ndeclare var AuthenticatorAttestationResponse: {\n    prototype: AuthenticatorAttestationResponse;\n    new(): AuthenticatorAttestationResponse;\n};\n\ninterface AuthenticatorResponse {\n    readonly clientDataJSON: ArrayBuffer;\n}\n\ndeclare var AuthenticatorResponse: {\n    prototype: AuthenticatorResponse;\n    new(): AuthenticatorResponse;\n};\n\ninterface BarProp {\n    readonly visible: boolean;\n}\n\ndeclare var BarProp: {\n    prototype: BarProp;\n    new(): BarProp;\n};\n\ninterface BaseAudioContextEventMap {\n    \"statechange\": Event;\n}\n\ninterface BaseAudioContext extends EventTarget {\n    readonly audioWorklet: AudioWorklet;\n    readonly currentTime: number;\n    readonly destination: AudioDestinationNode;\n    readonly listener: AudioListener;\n    onstatechange: ((this: BaseAudioContext, ev: Event) => any) | null;\n    readonly sampleRate: number;\n    readonly state: AudioContextState;\n    createAnalyser(): AnalyserNode;\n    createBiquadFilter(): BiquadFilterNode;\n    createBuffer(numberOfChannels: number, length: number, sampleRate: number): AudioBuffer;\n    createBufferSource(): AudioBufferSourceNode;\n    createChannelMerger(numberOfInputs?: number): ChannelMergerNode;\n    createChannelSplitter(numberOfOutputs?: number): ChannelSplitterNode;\n    createConstantSource(): ConstantSourceNode;\n    createConvolver(): ConvolverNode;\n    createDelay(maxDelayTime?: number): DelayNode;\n    createDynamicsCompressor(): DynamicsCompressorNode;\n    createGain(): GainNode;\n    createIIRFilter(feedforward: number[], feedback: number[]): IIRFilterNode;\n    createOscillator(): OscillatorNode;\n    createPanner(): PannerNode;\n    createPeriodicWave(real: number[] | Float32Array, imag: number[] | Float32Array, constraints?: PeriodicWaveConstraints): PeriodicWave;\n    createScriptProcessor(bufferSize?: number, numberOfInputChannels?: number, numberOfOutputChannels?: number): ScriptProcessorNode;\n    createStereoPanner(): StereoPannerNode;\n    createWaveShaper(): WaveShaperNode;\n    decodeAudioData(audioData: ArrayBuffer, successCallback?: DecodeSuccessCallback | null, errorCallback?: DecodeErrorCallback | null): Promise<AudioBuffer>;\n    addEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: BaseAudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof BaseAudioContextEventMap>(type: K, listener: (this: BaseAudioContext, ev: BaseAudioContextEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var BaseAudioContext: {\n    prototype: BaseAudioContext;\n    new(): BaseAudioContext;\n};\n\n/** The beforeunload event is fired when the window, the document and its resources are about to be unloaded. */\ninterface BeforeUnloadEvent extends Event {\n    returnValue: any;\n}\n\ndeclare var BeforeUnloadEvent: {\n    prototype: BeforeUnloadEvent;\n    new(): BeforeUnloadEvent;\n};\n\ninterface BhxBrowser {\n    readonly lastError: DOMException;\n    checkMatchesGlobExpression(pattern: string, value: string): boolean;\n    checkMatchesUriExpression(pattern: string, value: string): boolean;\n    clearLastError(): void;\n    currentWindowId(): number;\n    fireExtensionApiTelemetry(functionName: string, isSucceeded: boolean, isSupported: boolean, errorString: string): void;\n    genericFunction(functionId: number, destination: any, parameters?: string, callbackId?: number): void;\n    genericSynchronousFunction(functionId: number, parameters?: string): string;\n    getExtensionId(): string;\n    getThisAddress(): any;\n    registerGenericFunctionCallbackHandler(callbackHandler: Function): void;\n    registerGenericListenerHandler(eventHandler: Function): void;\n    setLastError(parameters: string): void;\n    webPlatformGenericFunction(destination: any, parameters?: string, callbackId?: number): void;\n}\n\ndeclare var BhxBrowser: {\n    prototype: BhxBrowser;\n    new(): BhxBrowser;\n};\n\n/** A simple low-order filter, and is created using the AudioContext.createBiquadFilter() method. It is an AudioNode that can represent different kinds of filters, tone control devices, and graphic equalizers. */\ninterface BiquadFilterNode extends AudioNode {\n    readonly Q: AudioParam;\n    readonly detune: AudioParam;\n    readonly frequency: AudioParam;\n    readonly gain: AudioParam;\n    type: BiquadFilterType;\n    getFrequencyResponse(frequencyHz: Float32Array, magResponse: Float32Array, phaseResponse: Float32Array): void;\n}\n\ndeclare var BiquadFilterNode: {\n    prototype: BiquadFilterNode;\n    new(context: BaseAudioContext, options?: BiquadFilterOptions): BiquadFilterNode;\n};\n\n/** A file-like object of immutable, raw data. Blobs represent data that isn't necessarily in a JavaScript-native format. The File interface is based on Blob, inheriting blob functionality and expanding it to support files on the user's system. */\ninterface Blob {\n    readonly size: number;\n    readonly type: string;\n    arrayBuffer(): Promise<ArrayBuffer>;\n    slice(start?: number, end?: number, contentType?: string): Blob;\n    stream(): ReadableStream;\n    text(): Promise<string>;\n}\n\ndeclare var Blob: {\n    prototype: Blob;\n    new(blobParts?: BlobPart[], options?: BlobPropertyBag): Blob;\n};\n\ninterface Body {\n    readonly body: ReadableStream<Uint8Array> | null;\n    readonly bodyUsed: boolean;\n    arrayBuffer(): Promise<ArrayBuffer>;\n    blob(): Promise<Blob>;\n    formData(): Promise<FormData>;\n    json(): Promise<any>;\n    text(): Promise<string>;\n}\n\ninterface BroadcastChannelEventMap {\n    \"message\": MessageEvent;\n    \"messageerror\": MessageEvent;\n}\n\ninterface BroadcastChannel extends EventTarget {\n    /**\n     * Returns the channel name (as passed to the constructor).\n     */\n    readonly name: string;\n    onmessage: ((this: BroadcastChannel, ev: MessageEvent) => any) | null;\n    onmessageerror: ((this: BroadcastChannel, ev: MessageEvent) => any) | null;\n    /**\n     * Closes the BroadcastChannel object, opening it up to garbage collection.\n     */\n    close(): void;\n    /**\n     * Sends the given message to other BroadcastChannel objects set up for this channel. Messages can be structured objects, e.g. nested objects and arrays.\n     */\n    postMessage(message: any): void;\n    addEventListener<K extends keyof BroadcastChannelEventMap>(type: K, listener: (this: BroadcastChannel, ev: BroadcastChannelEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof BroadcastChannelEventMap>(type: K, listener: (this: BroadcastChannel, ev: BroadcastChannelEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var BroadcastChannel: {\n    prototype: BroadcastChannel;\n    new(name: string): BroadcastChannel;\n};\n\n/** This Streams API interface provides a built-in byte length queuing strategy that can be used when constructing streams. */\ninterface ByteLengthQueuingStrategy extends QueuingStrategy<ArrayBufferView> {\n    highWaterMark: number;\n    size(chunk: ArrayBufferView): number;\n}\n\ndeclare var ByteLengthQueuingStrategy: {\n    prototype: ByteLengthQueuingStrategy;\n    new(options: { highWaterMark: number }): ByteLengthQueuingStrategy;\n};\n\n/** A CDATA section that can be used within XML to include extended portions of unescaped text. The symbols < and & don’t need escaping as they normally do when inside a CDATA section. */\ninterface CDATASection extends Text {\n}\n\ndeclare var CDATASection: {\n    prototype: CDATASection;\n    new(): CDATASection;\n};\n\n/** A single condition CSS at-rule, which consists of a condition and a statement block. It is a child of CSSGroupingRule. */\ninterface CSSConditionRule extends CSSGroupingRule {\n    conditionText: string;\n}\n\ndeclare var CSSConditionRule: {\n    prototype: CSSConditionRule;\n    new(): CSSConditionRule;\n};\n\ninterface CSSFontFaceRule extends CSSRule {\n    readonly style: CSSStyleDeclaration;\n}\n\ndeclare var CSSFontFaceRule: {\n    prototype: CSSFontFaceRule;\n    new(): CSSFontFaceRule;\n};\n\n/** Any CSS at-rule that contains other rules nested within it. */\ninterface CSSGroupingRule extends CSSRule {\n    readonly cssRules: CSSRuleList;\n    deleteRule(index: number): void;\n    insertRule(rule: string, index?: number): number;\n}\n\ndeclare var CSSGroupingRule: {\n    prototype: CSSGroupingRule;\n    new(): CSSGroupingRule;\n};\n\ninterface CSSImportRule extends CSSRule {\n    readonly href: string;\n    readonly media: MediaList;\n    readonly styleSheet: CSSStyleSheet;\n}\n\ndeclare var CSSImportRule: {\n    prototype: CSSImportRule;\n    new(): CSSImportRule;\n};\n\n/** An object representing a set of style for a given keyframe. It corresponds to the contains of a single keyframe of a @keyframes at-rule. It implements the CSSRule interface with a type value of 8 (CSSRule.KEYFRAME_RULE). */\ninterface CSSKeyframeRule extends CSSRule {\n    keyText: string;\n    readonly style: CSSStyleDeclaration;\n}\n\ndeclare var CSSKeyframeRule: {\n    prototype: CSSKeyframeRule;\n    new(): CSSKeyframeRule;\n};\n\n/** An object representing a complete set of keyframes for a CSS animation. It corresponds to the contains of a whole @keyframes at-rule. It implements the CSSRule interface with a type value of 7 (CSSRule.KEYFRAMES_RULE). */\ninterface CSSKeyframesRule extends CSSRule {\n    readonly cssRules: CSSRuleList;\n    name: string;\n    appendRule(rule: string): void;\n    deleteRule(select: string): void;\n    findRule(select: string): CSSKeyframeRule | null;\n}\n\ndeclare var CSSKeyframesRule: {\n    prototype: CSSKeyframesRule;\n    new(): CSSKeyframesRule;\n};\n\n/** A single CSS @media rule. It implements the CSSConditionRule interface, and therefore the CSSGroupingRule and the CSSRule interface with a type value of 4 (CSSRule.MEDIA_RULE). */\ninterface CSSMediaRule extends CSSConditionRule {\n    readonly media: MediaList;\n}\n\ndeclare var CSSMediaRule: {\n    prototype: CSSMediaRule;\n    new(): CSSMediaRule;\n};\n\n/** An object representing a single CSS @namespace at-rule. It implements the CSSRule interface, with a type value of 10 (CSSRule.NAMESPACE_RULE). */\ninterface CSSNamespaceRule extends CSSRule {\n    readonly namespaceURI: string;\n    readonly prefix: string;\n}\n\ndeclare var CSSNamespaceRule: {\n    prototype: CSSNamespaceRule;\n    new(): CSSNamespaceRule;\n};\n\n/** CSSPageRule is an interface representing a single CSS @page rule. It implements the CSSRule interface with a type value of 6 (CSSRule.PAGE_RULE). */\ninterface CSSPageRule extends CSSGroupingRule {\n    selectorText: string;\n    readonly style: CSSStyleDeclaration;\n}\n\ndeclare var CSSPageRule: {\n    prototype: CSSPageRule;\n    new(): CSSPageRule;\n};\n\n/** A single CSS rule. There are several types of rules, listed in the Type constants section below. */\ninterface CSSRule {\n    cssText: string;\n    readonly parentRule: CSSRule | null;\n    readonly parentStyleSheet: CSSStyleSheet | null;\n    readonly type: number;\n    readonly CHARSET_RULE: number;\n    readonly FONT_FACE_RULE: number;\n    readonly IMPORT_RULE: number;\n    readonly KEYFRAMES_RULE: number;\n    readonly KEYFRAME_RULE: number;\n    readonly MEDIA_RULE: number;\n    readonly NAMESPACE_RULE: number;\n    readonly PAGE_RULE: number;\n    readonly STYLE_RULE: number;\n    readonly SUPPORTS_RULE: number;\n}\n\ndeclare var CSSRule: {\n    prototype: CSSRule;\n    new(): CSSRule;\n    readonly CHARSET_RULE: number;\n    readonly FONT_FACE_RULE: number;\n    readonly IMPORT_RULE: number;\n    readonly KEYFRAMES_RULE: number;\n    readonly KEYFRAME_RULE: number;\n    readonly MEDIA_RULE: number;\n    readonly NAMESPACE_RULE: number;\n    readonly PAGE_RULE: number;\n    readonly STYLE_RULE: number;\n    readonly SUPPORTS_RULE: number;\n};\n\n/** A CSSRuleList is an (indirect-modify only) array-like object containing an ordered collection of CSSRule objects. */\ninterface CSSRuleList {\n    readonly length: number;\n    item(index: number): CSSRule | null;\n    [index: number]: CSSRule;\n}\n\ndeclare var CSSRuleList: {\n    prototype: CSSRuleList;\n    new(): CSSRuleList;\n};\n\n/** An object that is a CSS declaration block, and exposes style information and various style-related methods and properties. */\ninterface CSSStyleDeclaration {\n    alignContent: string;\n    alignItems: string;\n    alignSelf: string;\n    alignmentBaseline: string;\n    all: string;\n    animation: string;\n    animationDelay: string;\n    animationDirection: string;\n    animationDuration: string;\n    animationFillMode: string;\n    animationIterationCount: string;\n    animationName: string;\n    animationPlayState: string;\n    animationTimingFunction: string;\n    backfaceVisibility: string;\n    background: string;\n    backgroundAttachment: string;\n    backgroundClip: string;\n    backgroundColor: string;\n    backgroundImage: string;\n    backgroundOrigin: string;\n    backgroundPosition: string;\n    backgroundPositionX: string;\n    backgroundPositionY: string;\n    backgroundRepeat: string;\n    backgroundSize: string;\n    baselineShift: string;\n    blockSize: string;\n    border: string;\n    borderBlockEnd: string;\n    borderBlockEndColor: string;\n    borderBlockEndStyle: string;\n    borderBlockEndWidth: string;\n    borderBlockStart: string;\n    borderBlockStartColor: string;\n    borderBlockStartStyle: string;\n    borderBlockStartWidth: string;\n    borderBottom: string;\n    borderBottomColor: string;\n    borderBottomLeftRadius: string;\n    borderBottomRightRadius: string;\n    borderBottomStyle: string;\n    borderBottomWidth: string;\n    borderCollapse: string;\n    borderColor: string;\n    borderImage: string;\n    borderImageOutset: string;\n    borderImageRepeat: string;\n    borderImageSlice: string;\n    borderImageSource: string;\n    borderImageWidth: string;\n    borderInlineEnd: string;\n    borderInlineEndColor: string;\n    borderInlineEndStyle: string;\n    borderInlineEndWidth: string;\n    borderInlineStart: string;\n    borderInlineStartColor: string;\n    borderInlineStartStyle: string;\n    borderInlineStartWidth: string;\n    borderLeft: string;\n    borderLeftColor: string;\n    borderLeftStyle: string;\n    borderLeftWidth: string;\n    borderRadius: string;\n    borderRight: string;\n    borderRightColor: string;\n    borderRightStyle: string;\n    borderRightWidth: string;\n    borderSpacing: string;\n    borderStyle: string;\n    borderTop: string;\n    borderTopColor: string;\n    borderTopLeftRadius: string;\n    borderTopRightRadius: string;\n    borderTopStyle: string;\n    borderTopWidth: string;\n    borderWidth: string;\n    bottom: string;\n    boxShadow: string;\n    boxSizing: string;\n    breakAfter: string;\n    breakBefore: string;\n    breakInside: string;\n    captionSide: string;\n    caretColor: string;\n    clear: string;\n    clip: string;\n    clipPath: string;\n    clipRule: string;\n    color: string;\n    colorInterpolation: string;\n    colorInterpolationFilters: string;\n    columnCount: string;\n    columnFill: string;\n    columnGap: string;\n    columnRule: string;\n    columnRuleColor: string;\n    columnRuleStyle: string;\n    columnRuleWidth: string;\n    columnSpan: string;\n    columnWidth: string;\n    columns: string;\n    content: string;\n    counterIncrement: string;\n    counterReset: string;\n    cssFloat: string;\n    cssText: string;\n    cursor: string;\n    direction: string;\n    display: string;\n    dominantBaseline: string;\n    emptyCells: string;\n    fill: string;\n    fillOpacity: string;\n    fillRule: string;\n    filter: string;\n    flex: string;\n    flexBasis: string;\n    flexDirection: string;\n    flexFlow: string;\n    flexGrow: string;\n    flexShrink: string;\n    flexWrap: string;\n    float: string;\n    floodColor: string;\n    floodOpacity: string;\n    font: string;\n    fontFamily: string;\n    fontFeatureSettings: string;\n    fontKerning: string;\n    fontSize: string;\n    fontSizeAdjust: string;\n    fontStretch: string;\n    fontStyle: string;\n    fontSynthesis: string;\n    fontVariant: string;\n    fontVariantCaps: string;\n    fontVariantEastAsian: string;\n    fontVariantLigatures: string;\n    fontVariantNumeric: string;\n    fontVariantPosition: string;\n    fontWeight: string;\n    gap: string;\n    glyphOrientationVertical: string;\n    grid: string;\n    gridArea: string;\n    gridAutoColumns: string;\n    gridAutoFlow: string;\n    gridAutoRows: string;\n    gridColumn: string;\n    gridColumnEnd: string;\n    gridColumnGap: string;\n    gridColumnStart: string;\n    gridGap: string;\n    gridRow: string;\n    gridRowEnd: string;\n    gridRowGap: string;\n    gridRowStart: string;\n    gridTemplate: string;\n    gridTemplateAreas: string;\n    gridTemplateColumns: string;\n    gridTemplateRows: string;\n    height: string;\n    hyphens: string;\n    imageOrientation: string;\n    imageRendering: string;\n    inlineSize: string;\n    justifyContent: string;\n    justifyItems: string;\n    justifySelf: string;\n    left: string;\n    readonly length: number;\n    letterSpacing: string;\n    lightingColor: string;\n    lineBreak: string;\n    lineHeight: string;\n    listStyle: string;\n    listStyleImage: string;\n    listStylePosition: string;\n    listStyleType: string;\n    margin: string;\n    marginBlockEnd: string;\n    marginBlockStart: string;\n    marginBottom: string;\n    marginInlineEnd: string;\n    marginInlineStart: string;\n    marginLeft: string;\n    marginRight: string;\n    marginTop: string;\n    marker: string;\n    markerEnd: string;\n    markerMid: string;\n    markerStart: string;\n    mask: string;\n    maskComposite: string;\n    maskImage: string;\n    maskPosition: string;\n    maskRepeat: string;\n    maskSize: string;\n    maskType: string;\n    maxBlockSize: string;\n    maxHeight: string;\n    maxInlineSize: string;\n    maxWidth: string;\n    minBlockSize: string;\n    minHeight: string;\n    minInlineSize: string;\n    minWidth: string;\n    objectFit: string;\n    objectPosition: string;\n    opacity: string;\n    order: string;\n    orphans: string;\n    outline: string;\n    outlineColor: string;\n    outlineOffset: string;\n    outlineStyle: string;\n    outlineWidth: string;\n    overflow: string;\n    overflowAnchor: string;\n    overflowWrap: string;\n    overflowX: string;\n    overflowY: string;\n    overscrollBehavior: string;\n    overscrollBehaviorBlock: string;\n    overscrollBehaviorInline: string;\n    overscrollBehaviorX: string;\n    overscrollBehaviorY: string;\n    padding: string;\n    paddingBlockEnd: string;\n    paddingBlockStart: string;\n    paddingBottom: string;\n    paddingInlineEnd: string;\n    paddingInlineStart: string;\n    paddingLeft: string;\n    paddingRight: string;\n    paddingTop: string;\n    pageBreakAfter: string;\n    pageBreakBefore: string;\n    pageBreakInside: string;\n    paintOrder: string;\n    readonly parentRule: CSSRule | null;\n    perspective: string;\n    perspectiveOrigin: string;\n    placeContent: string;\n    placeItems: string;\n    placeSelf: string;\n    pointerEvents: string;\n    position: string;\n    quotes: string;\n    resize: string;\n    right: string;\n    rotate: string;\n    rowGap: string;\n    rubyAlign: string;\n    rubyPosition: string;\n    scale: string;\n    scrollBehavior: string;\n    shapeRendering: string;\n    stopColor: string;\n    stopOpacity: string;\n    stroke: string;\n    strokeDasharray: string;\n    strokeDashoffset: string;\n    strokeLinecap: string;\n    strokeLinejoin: string;\n    strokeMiterlimit: string;\n    strokeOpacity: string;\n    strokeWidth: string;\n    tabSize: string;\n    tableLayout: string;\n    textAlign: string;\n    textAlignLast: string;\n    textAnchor: string;\n    textCombineUpright: string;\n    textDecoration: string;\n    textDecorationColor: string;\n    textDecorationLine: string;\n    textDecorationStyle: string;\n    textEmphasis: string;\n    textEmphasisColor: string;\n    textEmphasisPosition: string;\n    textEmphasisStyle: string;\n    textIndent: string;\n    textJustify: string;\n    textOrientation: string;\n    textOverflow: string;\n    textRendering: string;\n    textShadow: string;\n    textTransform: string;\n    textUnderlinePosition: string;\n    top: string;\n    touchAction: string;\n    transform: string;\n    transformBox: string;\n    transformOrigin: string;\n    transformStyle: string;\n    transition: string;\n    transitionDelay: string;\n    transitionDuration: string;\n    transitionProperty: string;\n    transitionTimingFunction: string;\n    translate: string;\n    unicodeBidi: string;\n    userSelect: string;\n    verticalAlign: string;\n    visibility: string;\n    /** @deprecated */\n    webkitAlignContent: string;\n    /** @deprecated */\n    webkitAlignItems: string;\n    /** @deprecated */\n    webkitAlignSelf: string;\n    /** @deprecated */\n    webkitAnimation: string;\n    /** @deprecated */\n    webkitAnimationDelay: string;\n    /** @deprecated */\n    webkitAnimationDirection: string;\n    /** @deprecated */\n    webkitAnimationDuration: string;\n    /** @deprecated */\n    webkitAnimationFillMode: string;\n    /** @deprecated */\n    webkitAnimationIterationCount: string;\n    /** @deprecated */\n    webkitAnimationName: string;\n    /** @deprecated */\n    webkitAnimationPlayState: string;\n    /** @deprecated */\n    webkitAnimationTimingFunction: string;\n    /** @deprecated */\n    webkitAppearance: string;\n    /** @deprecated */\n    webkitBackfaceVisibility: string;\n    /** @deprecated */\n    webkitBackgroundClip: string;\n    /** @deprecated */\n    webkitBackgroundOrigin: string;\n    /** @deprecated */\n    webkitBackgroundSize: string;\n    /** @deprecated */\n    webkitBorderBottomLeftRadius: string;\n    /** @deprecated */\n    webkitBorderBottomRightRadius: string;\n    /** @deprecated */\n    webkitBorderRadius: string;\n    /** @deprecated */\n    webkitBorderTopLeftRadius: string;\n    /** @deprecated */\n    webkitBorderTopRightRadius: string;\n    /** @deprecated */\n    webkitBoxAlign: string;\n    /** @deprecated */\n    webkitBoxFlex: string;\n    /** @deprecated */\n    webkitBoxOrdinalGroup: string;\n    /** @deprecated */\n    webkitBoxOrient: string;\n    /** @deprecated */\n    webkitBoxPack: string;\n    /** @deprecated */\n    webkitBoxShadow: string;\n    /** @deprecated */\n    webkitBoxSizing: string;\n    /** @deprecated */\n    webkitFilter: string;\n    /** @deprecated */\n    webkitFlex: string;\n    /** @deprecated */\n    webkitFlexBasis: string;\n    /** @deprecated */\n    webkitFlexDirection: string;\n    /** @deprecated */\n    webkitFlexFlow: string;\n    /** @deprecated */\n    webkitFlexGrow: string;\n    /** @deprecated */\n    webkitFlexShrink: string;\n    /** @deprecated */\n    webkitFlexWrap: string;\n    /** @deprecated */\n    webkitJustifyContent: string;\n    webkitLineClamp: string;\n    /** @deprecated */\n    webkitMask: string;\n    /** @deprecated */\n    webkitMaskBoxImage: string;\n    /** @deprecated */\n    webkitMaskBoxImageOutset: string;\n    /** @deprecated */\n    webkitMaskBoxImageRepeat: string;\n    /** @deprecated */\n    webkitMaskBoxImageSlice: string;\n    /** @deprecated */\n    webkitMaskBoxImageSource: string;\n    /** @deprecated */\n    webkitMaskBoxImageWidth: string;\n    /** @deprecated */\n    webkitMaskClip: string;\n    /** @deprecated */\n    webkitMaskComposite: string;\n    /** @deprecated */\n    webkitMaskImage: string;\n    /** @deprecated */\n    webkitMaskOrigin: string;\n    /** @deprecated */\n    webkitMaskPosition: string;\n    /** @deprecated */\n    webkitMaskRepeat: string;\n    /** @deprecated */\n    webkitMaskSize: string;\n    /** @deprecated */\n    webkitOrder: string;\n    /** @deprecated */\n    webkitPerspective: string;\n    /** @deprecated */\n    webkitPerspectiveOrigin: string;\n    webkitTapHighlightColor: string;\n    /** @deprecated */\n    webkitTextFillColor: string;\n    /** @deprecated */\n    webkitTextSizeAdjust: string;\n    /** @deprecated */\n    webkitTextStroke: string;\n    /** @deprecated */\n    webkitTextStrokeColor: string;\n    /** @deprecated */\n    webkitTextStrokeWidth: string;\n    /** @deprecated */\n    webkitTransform: string;\n    /** @deprecated */\n    webkitTransformOrigin: string;\n    /** @deprecated */\n    webkitTransformStyle: string;\n    /** @deprecated */\n    webkitTransition: string;\n    /** @deprecated */\n    webkitTransitionDelay: string;\n    /** @deprecated */\n    webkitTransitionDuration: string;\n    /** @deprecated */\n    webkitTransitionProperty: string;\n    /** @deprecated */\n    webkitTransitionTimingFunction: string;\n    /** @deprecated */\n    webkitUserSelect: string;\n    whiteSpace: string;\n    widows: string;\n    width: string;\n    willChange: string;\n    wordBreak: string;\n    wordSpacing: string;\n    wordWrap: string;\n    writingMode: string;\n    zIndex: string;\n    /** @deprecated */\n    zoom: string;\n    getPropertyPriority(property: string): string;\n    getPropertyValue(property: string): string;\n    item(index: number): string;\n    removeProperty(property: string): string;\n    setProperty(property: string, value: string | null, priority?: string): void;\n    [index: number]: string;\n}\n\ndeclare var CSSStyleDeclaration: {\n    prototype: CSSStyleDeclaration;\n    new(): CSSStyleDeclaration;\n};\n\n/** CSSStyleRule represents a single CSS style rule. It implements the CSSRule interface with a type value of 1 (CSSRule.STYLE_RULE). */\ninterface CSSStyleRule extends CSSRule {\n    selectorText: string;\n    readonly style: CSSStyleDeclaration;\n}\n\ndeclare var CSSStyleRule: {\n    prototype: CSSStyleRule;\n    new(): CSSStyleRule;\n};\n\n/** A single CSS style sheet. It inherits properties and methods from its parent, StyleSheet. */\ninterface CSSStyleSheet extends StyleSheet {\n    readonly cssRules: CSSRuleList;\n    readonly ownerRule: CSSRule | null;\n    readonly rules: CSSRuleList;\n    addRule(selector?: string, style?: string, index?: number): number;\n    deleteRule(index: number): void;\n    insertRule(rule: string, index?: number): number;\n    removeRule(index?: number): void;\n}\n\ndeclare var CSSStyleSheet: {\n    prototype: CSSStyleSheet;\n    new(): CSSStyleSheet;\n};\n\n/** An object representing a single CSS @supports at-rule. It implements the CSSConditionRule interface, and therefore the CSSRule and CSSGroupingRule interfaces with a type value of 12 (CSSRule.SUPPORTS_RULE). */\ninterface CSSSupportsRule extends CSSConditionRule {\n}\n\ndeclare var CSSSupportsRule: {\n    prototype: CSSSupportsRule;\n    new(): CSSSupportsRule;\n};\n\n/** Provides a storage mechanism for Request / Response object pairs that are cached, for example as part of the ServiceWorker life cycle. Note that the Cache interface is exposed to windowed scopes as well as workers. You don't have to use it in conjunction with service workers, even though it is defined in the service worker spec. */\ninterface Cache {\n    add(request: RequestInfo): Promise<void>;\n    addAll(requests: RequestInfo[]): Promise<void>;\n    delete(request: RequestInfo, options?: CacheQueryOptions): Promise<boolean>;\n    keys(request?: RequestInfo, options?: CacheQueryOptions): Promise<ReadonlyArray<Request>>;\n    match(request: RequestInfo, options?: CacheQueryOptions): Promise<Response | undefined>;\n    matchAll(request?: RequestInfo, options?: CacheQueryOptions): Promise<ReadonlyArray<Response>>;\n    put(request: RequestInfo, response: Response): Promise<void>;\n}\n\ndeclare var Cache: {\n    prototype: Cache;\n    new(): Cache;\n};\n\n/** The storage for Cache objects. */\ninterface CacheStorage {\n    delete(cacheName: string): Promise<boolean>;\n    has(cacheName: string): Promise<boolean>;\n    keys(): Promise<string[]>;\n    match(request: RequestInfo, options?: MultiCacheQueryOptions): Promise<Response | undefined>;\n    open(cacheName: string): Promise<Cache>;\n}\n\ndeclare var CacheStorage: {\n    prototype: CacheStorage;\n    new(): CacheStorage;\n};\n\ninterface CanvasCompositing {\n    globalAlpha: number;\n    globalCompositeOperation: string;\n}\n\ninterface CanvasDrawImage {\n    drawImage(image: CanvasImageSource, dx: number, dy: number): void;\n    drawImage(image: CanvasImageSource, dx: number, dy: number, dw: number, dh: number): void;\n    drawImage(image: CanvasImageSource, sx: number, sy: number, sw: number, sh: number, dx: number, dy: number, dw: number, dh: number): void;\n}\n\ninterface CanvasDrawPath {\n    beginPath(): void;\n    clip(fillRule?: CanvasFillRule): void;\n    clip(path: Path2D, fillRule?: CanvasFillRule): void;\n    fill(fillRule?: CanvasFillRule): void;\n    fill(path: Path2D, fillRule?: CanvasFillRule): void;\n    isPointInPath(x: number, y: number, fillRule?: CanvasFillRule): boolean;\n    isPointInPath(path: Path2D, x: number, y: number, fillRule?: CanvasFillRule): boolean;\n    isPointInStroke(x: number, y: number): boolean;\n    isPointInStroke(path: Path2D, x: number, y: number): boolean;\n    stroke(): void;\n    stroke(path: Path2D): void;\n}\n\ninterface CanvasFillStrokeStyles {\n    fillStyle: string | CanvasGradient | CanvasPattern;\n    strokeStyle: string | CanvasGradient | CanvasPattern;\n    createLinearGradient(x0: number, y0: number, x1: number, y1: number): CanvasGradient;\n    createPattern(image: CanvasImageSource, repetition: string | null): CanvasPattern | null;\n    createRadialGradient(x0: number, y0: number, r0: number, x1: number, y1: number, r1: number): CanvasGradient;\n}\n\ninterface CanvasFilters {\n    filter: string;\n}\n\n/** An opaque object describing a gradient. It is returned by the methods CanvasRenderingContext2D.createLinearGradient() or CanvasRenderingContext2D.createRadialGradient(). */\ninterface CanvasGradient {\n    /**\n     * Adds a color stop with the given color to the gradient at the given offset. 0.0 is the offset at one end of the gradient, 1.0 is the offset at the other end.\n     * \n     * Throws an \"IndexSizeError\" DOMException if the offset is out of range. Throws a \"SyntaxError\" DOMException if the color cannot be parsed.\n     */\n    addColorStop(offset: number, color: string): void;\n}\n\ndeclare var CanvasGradient: {\n    prototype: CanvasGradient;\n    new(): CanvasGradient;\n};\n\ninterface CanvasImageData {\n    createImageData(sw: number, sh: number): ImageData;\n    createImageData(imagedata: ImageData): ImageData;\n    getImageData(sx: number, sy: number, sw: number, sh: number): ImageData;\n    putImageData(imagedata: ImageData, dx: number, dy: number): void;\n    putImageData(imagedata: ImageData, dx: number, dy: number, dirtyX: number, dirtyY: number, dirtyWidth: number, dirtyHeight: number): void;\n}\n\ninterface CanvasImageSmoothing {\n    imageSmoothingEnabled: boolean;\n    imageSmoothingQuality: ImageSmoothingQuality;\n}\n\ninterface CanvasPath {\n    arc(x: number, y: number, radius: number, startAngle: number, endAngle: number, anticlockwise?: boolean): void;\n    arcTo(x1: number, y1: number, x2: number, y2: number, radius: number): void;\n    bezierCurveTo(cp1x: number, cp1y: number, cp2x: number, cp2y: number, x: number, y: number): void;\n    closePath(): void;\n    ellipse(x: number, y: number, radiusX: number, radiusY: number, rotation: number, startAngle: number, endAngle: number, anticlockwise?: boolean): void;\n    lineTo(x: number, y: number): void;\n    moveTo(x: number, y: number): void;\n    quadraticCurveTo(cpx: number, cpy: number, x: number, y: number): void;\n    rect(x: number, y: number, w: number, h: number): void;\n}\n\ninterface CanvasPathDrawingStyles {\n    lineCap: CanvasLineCap;\n    lineDashOffset: number;\n    lineJoin: CanvasLineJoin;\n    lineWidth: number;\n    miterLimit: number;\n    getLineDash(): number[];\n    setLineDash(segments: number[]): void;\n}\n\n/** An opaque object describing a pattern, based on an image, a canvas, or a video, created by the CanvasRenderingContext2D.createPattern() method. */\ninterface CanvasPattern {\n    /**\n     * Sets the transformation matrix that will be used when rendering the pattern during a fill or stroke painting operation.\n     */\n    setTransform(transform?: DOMMatrix2DInit): void;\n}\n\ndeclare var CanvasPattern: {\n    prototype: CanvasPattern;\n    new(): CanvasPattern;\n};\n\ninterface CanvasRect {\n    clearRect(x: number, y: number, w: number, h: number): void;\n    fillRect(x: number, y: number, w: number, h: number): void;\n    strokeRect(x: number, y: number, w: number, h: number): void;\n}\n\n/** The CanvasRenderingContext2D interface, part of the Canvas API, provides the 2D rendering context for the drawing surface of a <canvas> element. It is used for drawing shapes, text, images, and other objects. */\ninterface CanvasRenderingContext2D extends CanvasCompositing, CanvasDrawImage, CanvasDrawPath, CanvasFillStrokeStyles, CanvasFilters, CanvasImageData, CanvasImageSmoothing, CanvasPath, CanvasPathDrawingStyles, CanvasRect, CanvasShadowStyles, CanvasState, CanvasText, CanvasTextDrawingStyles, CanvasTransform, CanvasUserInterface {\n    readonly canvas: HTMLCanvasElement;\n}\n\ndeclare var CanvasRenderingContext2D: {\n    prototype: CanvasRenderingContext2D;\n    new(): CanvasRenderingContext2D;\n};\n\ninterface CanvasShadowStyles {\n    shadowBlur: number;\n    shadowColor: string;\n    shadowOffsetX: number;\n    shadowOffsetY: number;\n}\n\ninterface CanvasState {\n    restore(): void;\n    save(): void;\n}\n\ninterface CanvasText {\n    fillText(text: string, x: number, y: number, maxWidth?: number): void;\n    measureText(text: string): TextMetrics;\n    strokeText(text: string, x: number, y: number, maxWidth?: number): void;\n}\n\ninterface CanvasTextDrawingStyles {\n    direction: CanvasDirection;\n    font: string;\n    textAlign: CanvasTextAlign;\n    textBaseline: CanvasTextBaseline;\n}\n\ninterface CanvasTransform {\n    getTransform(): DOMMatrix;\n    resetTransform(): void;\n    rotate(angle: number): void;\n    scale(x: number, y: number): void;\n    setTransform(a: number, b: number, c: number, d: number, e: number, f: number): void;\n    setTransform(transform?: DOMMatrix2DInit): void;\n    transform(a: number, b: number, c: number, d: number, e: number, f: number): void;\n    translate(x: number, y: number): void;\n}\n\ninterface CanvasUserInterface {\n    drawFocusIfNeeded(element: Element): void;\n    drawFocusIfNeeded(path: Path2D, element: Element): void;\n    scrollPathIntoView(): void;\n    scrollPathIntoView(path: Path2D): void;\n}\n\ninterface CaretPosition {\n    readonly offset: number;\n    readonly offsetNode: Node;\n    getClientRect(): DOMRect | null;\n}\n\ndeclare var CaretPosition: {\n    prototype: CaretPosition;\n    new(): CaretPosition;\n};\n\n/** The ChannelMergerNode interface, often used in conjunction with its opposite, ChannelSplitterNode, reunites different mono inputs into a single output. Each input is used to fill a channel of the output. This is useful for accessing each channels separately, e.g. for performing channel mixing where gain must be separately controlled on each channel. */\ninterface ChannelMergerNode extends AudioNode {\n}\n\ndeclare var ChannelMergerNode: {\n    prototype: ChannelMergerNode;\n    new(context: BaseAudioContext, options?: ChannelMergerOptions): ChannelMergerNode;\n};\n\n/** The ChannelSplitterNode interface, often used in conjunction with its opposite, ChannelMergerNode, separates the different channels of an audio source into a set of mono outputs. This is useful for accessing each channel separately, e.g. for performing channel mixing where gain must be separately controlled on each channel. */\ninterface ChannelSplitterNode extends AudioNode {\n}\n\ndeclare var ChannelSplitterNode: {\n    prototype: ChannelSplitterNode;\n    new(context: BaseAudioContext, options?: ChannelSplitterOptions): ChannelSplitterNode;\n};\n\n/** The CharacterData abstract interface represents a Node object that contains characters. This is an abstract interface, meaning there aren't any object of type CharacterData: it is implemented by other interfaces, like Text, Comment, or ProcessingInstruction which aren't abstract. */\ninterface CharacterData extends Node, ChildNode, NonDocumentTypeChildNode {\n    data: string;\n    readonly length: number;\n    readonly ownerDocument: Document;\n    appendData(data: string): void;\n    deleteData(offset: number, count: number): void;\n    insertData(offset: number, data: string): void;\n    replaceData(offset: number, count: number, data: string): void;\n    substringData(offset: number, count: number): string;\n}\n\ndeclare var CharacterData: {\n    prototype: CharacterData;\n    new(): CharacterData;\n};\n\ninterface ChildNode extends Node {\n    /**\n     * Inserts nodes just after node, while replacing strings in nodes with equivalent Text nodes.\n     * \n     * Throws a \"HierarchyRequestError\" DOMException if the constraints of the node tree are violated.\n     */\n    after(...nodes: (Node | string)[]): void;\n    /**\n     * Inserts nodes just before node, while replacing strings in nodes with equivalent Text nodes.\n     * \n     * Throws a \"HierarchyRequestError\" DOMException if the constraints of the node tree are violated.\n     */\n    before(...nodes: (Node | string)[]): void;\n    /**\n     * Removes node.\n     */\n    remove(): void;\n    /**\n     * Replaces node with nodes, while replacing strings in nodes with equivalent Text nodes.\n     * \n     * Throws a \"HierarchyRequestError\" DOMException if the constraints of the node tree are violated.\n     */\n    replaceWith(...nodes: (Node | string)[]): void;\n}\n\ninterface ClientRect {\n    bottom: number;\n    readonly height: number;\n    left: number;\n    right: number;\n    top: number;\n    readonly width: number;\n}\n\ndeclare var ClientRect: {\n    prototype: ClientRect;\n    new(): ClientRect;\n};\n\ninterface ClientRectList {\n    readonly length: number;\n    item(index: number): ClientRect;\n    [index: number]: ClientRect;\n}\n\ndeclare var ClientRectList: {\n    prototype: ClientRectList;\n    new(): ClientRectList;\n};\n\ninterface Clipboard extends EventTarget {\n    readText(): Promise<string>;\n    writeText(data: string): Promise<void>;\n}\n\ndeclare var Clipboard: {\n    prototype: Clipboard;\n    new(): Clipboard;\n};\n\n/** Events providing information related to modification of the clipboard, that is cut, copy, and paste events. */\ninterface ClipboardEvent extends Event {\n    readonly clipboardData: DataTransfer | null;\n}\n\ndeclare var ClipboardEvent: {\n    prototype: ClipboardEvent;\n    new(type: string, eventInitDict?: ClipboardEventInit): ClipboardEvent;\n};\n\n/** A CloseEvent is sent to clients using WebSockets when the connection is closed. This is delivered to the listener indicated by the WebSocket object's onclose attribute. */\ninterface CloseEvent extends Event {\n    /**\n     * Returns the WebSocket connection close code provided by the server.\n     */\n    readonly code: number;\n    /**\n     * Returns the WebSocket connection close reason provided by the server.\n     */\n    readonly reason: string;\n    /**\n     * Returns true if the connection closed cleanly; false otherwise.\n     */\n    readonly wasClean: boolean;\n}\n\ndeclare var CloseEvent: {\n    prototype: CloseEvent;\n    new(type: string, eventInitDict?: CloseEventInit): CloseEvent;\n};\n\n/** Textual notations within markup; although it is generally not visually shown, such comments are available to be read in the source view. */\ninterface Comment extends CharacterData {\n}\n\ndeclare var Comment: {\n    prototype: Comment;\n    new(data?: string): Comment;\n};\n\n/** The DOM CompositionEvent represents events that occur due to the user indirectly entering text. */\ninterface CompositionEvent extends UIEvent {\n    readonly data: string;\n}\n\ndeclare var CompositionEvent: {\n    prototype: CompositionEvent;\n    new(type: string, eventInitDict?: CompositionEventInit): CompositionEvent;\n};\n\ninterface ConcatParams extends Algorithm {\n    algorithmId: Uint8Array;\n    hash?: string | Algorithm;\n    partyUInfo: Uint8Array;\n    partyVInfo: Uint8Array;\n    privateInfo?: Uint8Array;\n    publicInfo?: Uint8Array;\n}\n\ninterface ConstantSourceNode extends AudioScheduledSourceNode {\n    readonly offset: AudioParam;\n    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: ConstantSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: ConstantSourceNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var ConstantSourceNode: {\n    prototype: ConstantSourceNode;\n    new(context: BaseAudioContext, options?: ConstantSourceOptions): ConstantSourceNode;\n};\n\n/** An AudioNode that performs a Linear Convolution on a given AudioBuffer, often used to achieve a reverb effect. A ConvolverNode always has exactly one input and one output. */\ninterface ConvolverNode extends AudioNode {\n    buffer: AudioBuffer | null;\n    normalize: boolean;\n}\n\ndeclare var ConvolverNode: {\n    prototype: ConvolverNode;\n    new(context: BaseAudioContext, options?: ConvolverOptions): ConvolverNode;\n};\n\n/** This Streams API interface provides a built-in byte length queuing strategy that can be used when constructing streams. */\ninterface CountQueuingStrategy extends QueuingStrategy {\n    highWaterMark: number;\n    size(chunk: any): 1;\n}\n\ndeclare var CountQueuingStrategy: {\n    prototype: CountQueuingStrategy;\n    new(options: { highWaterMark: number }): CountQueuingStrategy;\n};\n\ninterface Credential {\n    readonly id: string;\n    readonly type: string;\n}\n\ndeclare var Credential: {\n    prototype: Credential;\n    new(): Credential;\n};\n\ninterface CredentialsContainer {\n    create(options?: CredentialCreationOptions): Promise<Credential | null>;\n    get(options?: CredentialRequestOptions): Promise<Credential | null>;\n    preventSilentAccess(): Promise<void>;\n    store(credential: Credential): Promise<Credential>;\n}\n\ndeclare var CredentialsContainer: {\n    prototype: CredentialsContainer;\n    new(): CredentialsContainer;\n};\n\n/** Basic cryptography features available in the current context. It allows access to a cryptographically strong random number generator and to cryptographic primitives. */\ninterface Crypto {\n    readonly subtle: SubtleCrypto;\n    getRandomValues<T extends Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | null>(array: T): T;\n}\n\ndeclare var Crypto: {\n    prototype: Crypto;\n    new(): Crypto;\n};\n\n/** The CryptoKey dictionary of the Web Crypto API represents a cryptographic key. */\ninterface CryptoKey {\n    readonly algorithm: KeyAlgorithm;\n    readonly extractable: boolean;\n    readonly type: KeyType;\n    readonly usages: KeyUsage[];\n}\n\ndeclare var CryptoKey: {\n    prototype: CryptoKey;\n    new(): CryptoKey;\n};\n\n/** The CryptoKeyPair dictionary of the Web Crypto API represents a key pair for an asymmetric cryptography algorithm, also known as a public-key algorithm. */\ninterface CryptoKeyPair {\n    privateKey: CryptoKey;\n    publicKey: CryptoKey;\n}\n\ndeclare var CryptoKeyPair: {\n    prototype: CryptoKeyPair;\n    new(): CryptoKeyPair;\n};\n\ninterface CustomElementRegistry {\n    define(name: string, constructor: CustomElementConstructor, options?: ElementDefinitionOptions): void;\n    get(name: string): any;\n    upgrade(root: Node): void;\n    whenDefined(name: string): Promise<void>;\n}\n\ndeclare var CustomElementRegistry: {\n    prototype: CustomElementRegistry;\n    new(): CustomElementRegistry;\n};\n\ninterface CustomEvent<T = any> extends Event {\n    /**\n     * Returns any custom data event was created with. Typically used for synthetic events.\n     */\n    readonly detail: T;\n    initCustomEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, detailArg: T): void;\n}\n\ndeclare var CustomEvent: {\n    prototype: CustomEvent;\n    new<T>(typeArg: string, eventInitDict?: CustomEventInit<T>): CustomEvent<T>;\n};\n\n/** An error object that contains an error name. */\ninterface DOMError {\n    readonly name: string;\n    toString(): string;\n}\n\ndeclare var DOMError: {\n    prototype: DOMError;\n    new(): DOMError;\n};\n\n/** An abnormal event (called an exception) which occurs as a result of calling a method or accessing a property of a web API. */\ninterface DOMException {\n    readonly code: number;\n    readonly message: string;\n    readonly name: string;\n    readonly ABORT_ERR: number;\n    readonly DATA_CLONE_ERR: number;\n    readonly DOMSTRING_SIZE_ERR: number;\n    readonly HIERARCHY_REQUEST_ERR: number;\n    readonly INDEX_SIZE_ERR: number;\n    readonly INUSE_ATTRIBUTE_ERR: number;\n    readonly INVALID_ACCESS_ERR: number;\n    readonly INVALID_CHARACTER_ERR: number;\n    readonly INVALID_MODIFICATION_ERR: number;\n    readonly INVALID_NODE_TYPE_ERR: number;\n    readonly INVALID_STATE_ERR: number;\n    readonly NAMESPACE_ERR: number;\n    readonly NETWORK_ERR: number;\n    readonly NOT_FOUND_ERR: number;\n    readonly NOT_SUPPORTED_ERR: number;\n    readonly NO_DATA_ALLOWED_ERR: number;\n    readonly NO_MODIFICATION_ALLOWED_ERR: number;\n    readonly QUOTA_EXCEEDED_ERR: number;\n    readonly SECURITY_ERR: number;\n    readonly SYNTAX_ERR: number;\n    readonly TIMEOUT_ERR: number;\n    readonly TYPE_MISMATCH_ERR: number;\n    readonly URL_MISMATCH_ERR: number;\n    readonly VALIDATION_ERR: number;\n    readonly WRONG_DOCUMENT_ERR: number;\n}\n\ndeclare var DOMException: {\n    prototype: DOMException;\n    new(message?: string, name?: string): DOMException;\n    readonly ABORT_ERR: number;\n    readonly DATA_CLONE_ERR: number;\n    readonly DOMSTRING_SIZE_ERR: number;\n    readonly HIERARCHY_REQUEST_ERR: number;\n    readonly INDEX_SIZE_ERR: number;\n    readonly INUSE_ATTRIBUTE_ERR: number;\n    readonly INVALID_ACCESS_ERR: number;\n    readonly INVALID_CHARACTER_ERR: number;\n    readonly INVALID_MODIFICATION_ERR: number;\n    readonly INVALID_NODE_TYPE_ERR: number;\n    readonly INVALID_STATE_ERR: number;\n    readonly NAMESPACE_ERR: number;\n    readonly NETWORK_ERR: number;\n    readonly NOT_FOUND_ERR: number;\n    readonly NOT_SUPPORTED_ERR: number;\n    readonly NO_DATA_ALLOWED_ERR: number;\n    readonly NO_MODIFICATION_ALLOWED_ERR: number;\n    readonly QUOTA_EXCEEDED_ERR: number;\n    readonly SECURITY_ERR: number;\n    readonly SYNTAX_ERR: number;\n    readonly TIMEOUT_ERR: number;\n    readonly TYPE_MISMATCH_ERR: number;\n    readonly URL_MISMATCH_ERR: number;\n    readonly VALIDATION_ERR: number;\n    readonly WRONG_DOCUMENT_ERR: number;\n};\n\n/** An object providing methods which are not dependent on any particular document. Such an object is returned by the Document.implementation property. */\ninterface DOMImplementation {\n    createDocument(namespace: string | null, qualifiedName: string | null, doctype?: DocumentType | null): XMLDocument;\n    createDocumentType(qualifiedName: string, publicId: string, systemId: string): DocumentType;\n    createHTMLDocument(title?: string): Document;\n    /** @deprecated */\n    hasFeature(...args: any[]): true;\n}\n\ndeclare var DOMImplementation: {\n    prototype: DOMImplementation;\n    new(): DOMImplementation;\n};\n\ninterface DOML2DeprecatedColorProperty {\n    color: string;\n}\n\ninterface DOMMatrix extends DOMMatrixReadOnly {\n    a: number;\n    b: number;\n    c: number;\n    d: number;\n    e: number;\n    f: number;\n    m11: number;\n    m12: number;\n    m13: number;\n    m14: number;\n    m21: number;\n    m22: number;\n    m23: number;\n    m24: number;\n    m31: number;\n    m32: number;\n    m33: number;\n    m34: number;\n    m41: number;\n    m42: number;\n    m43: number;\n    m44: number;\n    invertSelf(): DOMMatrix;\n    multiplySelf(other?: DOMMatrixInit): DOMMatrix;\n    preMultiplySelf(other?: DOMMatrixInit): DOMMatrix;\n    rotateAxisAngleSelf(x?: number, y?: number, z?: number, angle?: number): DOMMatrix;\n    rotateFromVectorSelf(x?: number, y?: number): DOMMatrix;\n    rotateSelf(rotX?: number, rotY?: number, rotZ?: number): DOMMatrix;\n    scale3dSelf(scale?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;\n    scaleSelf(scaleX?: number, scaleY?: number, scaleZ?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;\n    setMatrixValue(transformList: string): DOMMatrix;\n    skewXSelf(sx?: number): DOMMatrix;\n    skewYSelf(sy?: number): DOMMatrix;\n    translateSelf(tx?: number, ty?: number, tz?: number): DOMMatrix;\n}\n\ndeclare var DOMMatrix: {\n    prototype: DOMMatrix;\n    new(init?: string | number[]): DOMMatrix;\n    fromFloat32Array(array32: Float32Array): DOMMatrix;\n    fromFloat64Array(array64: Float64Array): DOMMatrix;\n    fromMatrix(other?: DOMMatrixInit): DOMMatrix;\n};\n\ntype SVGMatrix = DOMMatrix;\ndeclare var SVGMatrix: typeof DOMMatrix;\n\ntype WebKitCSSMatrix = DOMMatrix;\ndeclare var WebKitCSSMatrix: typeof DOMMatrix;\n\ninterface DOMMatrixReadOnly {\n    readonly a: number;\n    readonly b: number;\n    readonly c: number;\n    readonly d: number;\n    readonly e: number;\n    readonly f: number;\n    readonly is2D: boolean;\n    readonly isIdentity: boolean;\n    readonly m11: number;\n    readonly m12: number;\n    readonly m13: number;\n    readonly m14: number;\n    readonly m21: number;\n    readonly m22: number;\n    readonly m23: number;\n    readonly m24: number;\n    readonly m31: number;\n    readonly m32: number;\n    readonly m33: number;\n    readonly m34: number;\n    readonly m41: number;\n    readonly m42: number;\n    readonly m43: number;\n    readonly m44: number;\n    flipX(): DOMMatrix;\n    flipY(): DOMMatrix;\n    inverse(): DOMMatrix;\n    multiply(other?: DOMMatrixInit): DOMMatrix;\n    rotate(rotX?: number, rotY?: number, rotZ?: number): DOMMatrix;\n    rotateAxisAngle(x?: number, y?: number, z?: number, angle?: number): DOMMatrix;\n    rotateFromVector(x?: number, y?: number): DOMMatrix;\n    scale(scaleX?: number, scaleY?: number, scaleZ?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;\n    scale3d(scale?: number, originX?: number, originY?: number, originZ?: number): DOMMatrix;\n    /** @deprecated */\n    scaleNonUniform(scaleX?: number, scaleY?: number): DOMMatrix;\n    skewX(sx?: number): DOMMatrix;\n    skewY(sy?: number): DOMMatrix;\n    toFloat32Array(): Float32Array;\n    toFloat64Array(): Float64Array;\n    toJSON(): any;\n    transformPoint(point?: DOMPointInit): DOMPoint;\n    translate(tx?: number, ty?: number, tz?: number): DOMMatrix;\n    toString(): string;\n}\n\ndeclare var DOMMatrixReadOnly: {\n    prototype: DOMMatrixReadOnly;\n    new(init?: string | number[]): DOMMatrixReadOnly;\n    fromFloat32Array(array32: Float32Array): DOMMatrixReadOnly;\n    fromFloat64Array(array64: Float64Array): DOMMatrixReadOnly;\n    fromMatrix(other?: DOMMatrixInit): DOMMatrixReadOnly;\n    toString(): string;\n};\n\n/** Provides the ability to parse XML or HTML source code from a string into a DOM Document. */\ninterface DOMParser {\n    /**\n     * Parses string using either the HTML or XML parser, according to type, and returns the resulting Document. type can be \"text/html\" (which will invoke the HTML parser), or any of \"text/xml\", \"application/xml\", \"application/xhtml+xml\", or \"image/svg+xml\" (which will invoke the XML parser).\n     * \n     * For the XML parser, if string cannot be parsed, then the returned Document will contain elements describing the resulting error.\n     * \n     * Note that script elements are not evaluated during parsing, and the resulting document's encoding will always be UTF-8.\n     * \n     * Values other than the above for type will cause a TypeError exception to be thrown.\n     */\n    parseFromString(string: string, type: DOMParserSupportedType): Document;\n}\n\ndeclare var DOMParser: {\n    prototype: DOMParser;\n    new(): DOMParser;\n};\n\ninterface DOMPoint extends DOMPointReadOnly {\n    w: number;\n    x: number;\n    y: number;\n    z: number;\n}\n\ndeclare var DOMPoint: {\n    prototype: DOMPoint;\n    new(x?: number, y?: number, z?: number, w?: number): DOMPoint;\n    fromPoint(other?: DOMPointInit): DOMPoint;\n};\n\ntype SVGPoint = DOMPoint;\ndeclare var SVGPoint: typeof DOMPoint;\n\ninterface DOMPointReadOnly {\n    readonly w: number;\n    readonly x: number;\n    readonly y: number;\n    readonly z: number;\n    matrixTransform(matrix?: DOMMatrixInit): DOMPoint;\n    toJSON(): any;\n}\n\ndeclare var DOMPointReadOnly: {\n    prototype: DOMPointReadOnly;\n    new(x?: number, y?: number, z?: number, w?: number): DOMPointReadOnly;\n    fromPoint(other?: DOMPointInit): DOMPointReadOnly;\n};\n\ninterface DOMQuad {\n    readonly p1: DOMPoint;\n    readonly p2: DOMPoint;\n    readonly p3: DOMPoint;\n    readonly p4: DOMPoint;\n    getBounds(): DOMRect;\n    toJSON(): any;\n}\n\ndeclare var DOMQuad: {\n    prototype: DOMQuad;\n    new(p1?: DOMPointInit, p2?: DOMPointInit, p3?: DOMPointInit, p4?: DOMPointInit): DOMQuad;\n    fromQuad(other?: DOMQuadInit): DOMQuad;\n    fromRect(other?: DOMRectInit): DOMQuad;\n};\n\ninterface DOMRect extends DOMRectReadOnly {\n    height: number;\n    width: number;\n    x: number;\n    y: number;\n}\n\ndeclare var DOMRect: {\n    prototype: DOMRect;\n    new(x?: number, y?: number, width?: number, height?: number): DOMRect;\n    fromRect(other?: DOMRectInit): DOMRect;\n};\n\ntype SVGRect = DOMRect;\ndeclare var SVGRect: typeof DOMRect;\n\ninterface DOMRectList {\n    readonly length: number;\n    item(index: number): DOMRect | null;\n    [index: number]: DOMRect;\n}\n\ndeclare var DOMRectList: {\n    prototype: DOMRectList;\n    new(): DOMRectList;\n};\n\ninterface DOMRectReadOnly {\n    readonly bottom: number;\n    readonly height: number;\n    readonly left: number;\n    readonly right: number;\n    readonly top: number;\n    readonly width: number;\n    readonly x: number;\n    readonly y: number;\n    toJSON(): any;\n}\n\ndeclare var DOMRectReadOnly: {\n    prototype: DOMRectReadOnly;\n    new(x?: number, y?: number, width?: number, height?: number): DOMRectReadOnly;\n    fromRect(other?: DOMRectInit): DOMRectReadOnly;\n};\n\ninterface DOMSettableTokenList extends DOMTokenList {\n    value: string;\n}\n\ndeclare var DOMSettableTokenList: {\n    prototype: DOMSettableTokenList;\n    new(): DOMSettableTokenList;\n};\n\n/** A type returned by some APIs which contains a list of DOMString (strings). */\ninterface DOMStringList {\n    /**\n     * Returns the number of strings in strings.\n     */\n    readonly length: number;\n    /**\n     * Returns true if strings contains string, and false otherwise.\n     */\n    contains(string: string): boolean;\n    /**\n     * Returns the string with index index from strings.\n     */\n    item(index: number): string | null;\n    [index: number]: string;\n}\n\ndeclare var DOMStringList: {\n    prototype: DOMStringList;\n    new(): DOMStringList;\n};\n\n/** Used by the dataset HTML attribute to represent data for custom attributes added to elements. */\ninterface DOMStringMap {\n    [name: string]: string | undefined;\n}\n\ndeclare var DOMStringMap: {\n    prototype: DOMStringMap;\n    new(): DOMStringMap;\n};\n\n/** A set of space-separated tokens. Such a set is returned by Element.classList, HTMLLinkElement.relList, HTMLAnchorElement.relList, HTMLAreaElement.relList, HTMLIframeElement.sandbox, or HTMLOutputElement.htmlFor. It is indexed beginning with 0 as with JavaScript Array objects. DOMTokenList is always case-sensitive. */\ninterface DOMTokenList {\n    /**\n     * Returns the number of tokens.\n     */\n    readonly length: number;\n    /**\n     * Returns the associated set as string.\n     * \n     * Can be set, to change the associated attribute.\n     */\n    value: string;\n    toString(): string;\n    /**\n     * Adds all arguments passed, except those already present.\n     * \n     * Throws a \"SyntaxError\" DOMException if one of the arguments is the empty string.\n     * \n     * Throws an \"InvalidCharacterError\" DOMException if one of the arguments contains any ASCII whitespace.\n     */\n    add(...tokens: string[]): void;\n    /**\n     * Returns true if token is present, and false otherwise.\n     */\n    contains(token: string): boolean;\n    /**\n     * Returns the token with index index.\n     */\n    item(index: number): string | null;\n    /**\n     * Removes arguments passed, if they are present.\n     * \n     * Throws a \"SyntaxError\" DOMException if one of the arguments is the empty string.\n     * \n     * Throws an \"InvalidCharacterError\" DOMException if one of the arguments contains any ASCII whitespace.\n     */\n    remove(...tokens: string[]): void;\n    /**\n     * Replaces token with newToken.\n     * \n     * Returns true if token was replaced with newToken, and false otherwise.\n     * \n     * Throws a \"SyntaxError\" DOMException if one of the arguments is the empty string.\n     * \n     * Throws an \"InvalidCharacterError\" DOMException if one of the arguments contains any ASCII whitespace.\n     */\n    replace(oldToken: string, newToken: string): void;\n    /**\n     * Returns true if token is in the associated attribute's supported tokens. Returns false otherwise.\n     * \n     * Throws a TypeError if the associated attribute has no supported tokens defined.\n     */\n    supports(token: string): boolean;\n    /**\n     * If force is not given, \"toggles\" token, removing it if it's present and adding it if it's not present. If force is true, adds token (same as add()). If force is false, removes token (same as remove()).\n     * \n     * Returns true if token is now present, and false otherwise.\n     * \n     * Throws a \"SyntaxError\" DOMException if token is empty.\n     * \n     * Throws an \"InvalidCharacterError\" DOMException if token contains any spaces.\n     */\n    toggle(token: string, force?: boolean): boolean;\n    forEach(callbackfn: (value: string, key: number, parent: DOMTokenList) => void, thisArg?: any): void;\n    [index: number]: string;\n}\n\ndeclare var DOMTokenList: {\n    prototype: DOMTokenList;\n    new(): DOMTokenList;\n};\n\ninterface DataCue extends TextTrackCue {\n    data: ArrayBuffer;\n    addEventListener<K extends keyof TextTrackCueEventMap>(type: K, listener: (this: DataCue, ev: TextTrackCueEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof TextTrackCueEventMap>(type: K, listener: (this: DataCue, ev: TextTrackCueEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var DataCue: {\n    prototype: DataCue;\n    new(): DataCue;\n};\n\n/** Used to hold the data that is being dragged during a drag and drop operation. It may hold one or more data items, each of one or more data types. For more information about drag and drop, see HTML Drag and Drop API. */\ninterface DataTransfer {\n    /**\n     * Returns the kind of operation that is currently selected. If the kind of operation isn't one of those that is allowed by the effectAllowed attribute, then the operation will fail.\n     * \n     * Can be set, to change the selected operation.\n     * \n     * The possible values are \"none\", \"copy\", \"link\", and \"move\".\n     */\n    dropEffect: \"none\" | \"copy\" | \"link\" | \"move\";\n    /**\n     * Returns the kinds of operations that are to be allowed.\n     * \n     * Can be set (during the dragstart event), to change the allowed operations.\n     * \n     * The possible values are \"none\", \"copy\", \"copyLink\", \"copyMove\", \"link\", \"linkMove\", \"move\", \"all\", and \"uninitialized\",\n     */\n    effectAllowed: \"none\" | \"copy\" | \"copyLink\" | \"copyMove\" | \"link\" | \"linkMove\" | \"move\" | \"all\" | \"uninitialized\";\n    /**\n     * Returns a FileList of the files being dragged, if any.\n     */\n    readonly files: FileList;\n    /**\n     * Returns a DataTransferItemList object, with the drag data.\n     */\n    readonly items: DataTransferItemList;\n    /**\n     * Returns a frozen array listing the formats that were set in the dragstart event. In addition, if any files are being dragged, then one of the types will be the string \"Files\".\n     */\n    readonly types: ReadonlyArray<string>;\n    /**\n     * Removes the data of the specified formats. Removes all data if the argument is omitted.\n     */\n    clearData(format?: string): void;\n    /**\n     * Returns the specified data. If there is no such data, returns the empty string.\n     */\n    getData(format: string): string;\n    /**\n     * Adds the specified data.\n     */\n    setData(format: string, data: string): void;\n    /**\n     * Uses the given element to update the drag feedback, replacing any previously specified feedback.\n     */\n    setDragImage(image: Element, x: number, y: number): void;\n}\n\ndeclare var DataTransfer: {\n    prototype: DataTransfer;\n    new(): DataTransfer;\n};\n\n/** One drag data item. During a drag operation, each drag event has a dataTransfer property which contains a list of drag data items. Each item in the list is a DataTransferItem object. */\ninterface DataTransferItem {\n    /**\n     * Returns the drag data item kind, one of: \"string\", \"file\".\n     */\n    readonly kind: string;\n    /**\n     * Returns the drag data item type string.\n     */\n    readonly type: string;\n    /**\n     * Returns a File object, if the drag data item kind is File.\n     */\n    getAsFile(): File | null;\n    /**\n     * Invokes the callback with the string data as the argument, if the drag data item kind is text.\n     */\n    getAsString(callback: FunctionStringCallback | null): void;\n    webkitGetAsEntry(): any;\n}\n\ndeclare var DataTransferItem: {\n    prototype: DataTransferItem;\n    new(): DataTransferItem;\n};\n\n/** A list of DataTransferItem objects representing items being dragged. During a drag operation, each DragEvent has a dataTransfer property and that property is a DataTransferItemList. */\ninterface DataTransferItemList {\n    /**\n     * Returns the number of items in the drag data store.\n     */\n    readonly length: number;\n    /**\n     * Adds a new entry for the given data to the drag data store. If the data is plain text then a type string has to be provided also.\n     */\n    add(data: string, type: string): DataTransferItem | null;\n    add(data: File): DataTransferItem | null;\n    /**\n     * Removes all the entries in the drag data store.\n     */\n    clear(): void;\n    item(index: number): DataTransferItem;\n    /**\n     * Removes the indexth entry in the drag data store.\n     */\n    remove(index: number): void;\n    [name: number]: DataTransferItem;\n}\n\ndeclare var DataTransferItemList: {\n    prototype: DataTransferItemList;\n    new(): DataTransferItemList;\n};\n\ninterface DeferredPermissionRequest {\n    readonly id: number;\n    readonly type: MSWebViewPermissionType;\n    readonly uri: string;\n    allow(): void;\n    deny(): void;\n}\n\ndeclare var DeferredPermissionRequest: {\n    prototype: DeferredPermissionRequest;\n    new(): DeferredPermissionRequest;\n};\n\n/** A delay-line; an AudioNode audio-processing module that causes a delay between the arrival of an input data and its propagation to the output. */\ninterface DelayNode extends AudioNode {\n    readonly delayTime: AudioParam;\n}\n\ndeclare var DelayNode: {\n    prototype: DelayNode;\n    new(context: BaseAudioContext, options?: DelayOptions): DelayNode;\n};\n\n/** Provides information about the amount of acceleration the device is experiencing along all three axes. */\ninterface DeviceAcceleration {\n    readonly x: number | null;\n    readonly y: number | null;\n    readonly z: number | null;\n}\n\ndeclare var DeviceAcceleration: {\n    prototype: DeviceAcceleration;\n    new(): DeviceAcceleration;\n};\n\n/** The DeviceLightEvent provides web developers with information from photo sensors or similiar detectors about ambient light levels near the device. For example this may be useful to adjust the screen's brightness based on the current ambient light level in order to save energy or provide better readability. */\ninterface DeviceLightEvent extends Event {\n    readonly value: number;\n}\n\ndeclare var DeviceLightEvent: {\n    prototype: DeviceLightEvent;\n    new(typeArg: string, eventInitDict?: DeviceLightEventInit): DeviceLightEvent;\n};\n\n/** The DeviceMotionEvent provides web developers with information about the speed of changes for the device's position and orientation. */\ninterface DeviceMotionEvent extends Event {\n    readonly acceleration: DeviceMotionEventAcceleration | null;\n    readonly accelerationIncludingGravity: DeviceMotionEventAcceleration | null;\n    readonly interval: number;\n    readonly rotationRate: DeviceMotionEventRotationRate | null;\n}\n\ndeclare var DeviceMotionEvent: {\n    prototype: DeviceMotionEvent;\n    new(type: string, eventInitDict?: DeviceMotionEventInit): DeviceMotionEvent;\n    requestPermission(): Promise<PermissionState>;\n};\n\ninterface DeviceMotionEventAcceleration {\n    readonly x: number | null;\n    readonly y: number | null;\n    readonly z: number | null;\n}\n\ninterface DeviceMotionEventRotationRate {\n    readonly alpha: number | null;\n    readonly beta: number | null;\n    readonly gamma: number | null;\n}\n\n/** The DeviceOrientationEvent provides web developers with information from the physical orientation of the device running the web page. */\ninterface DeviceOrientationEvent extends Event {\n    readonly absolute: boolean;\n    readonly alpha: number | null;\n    readonly beta: number | null;\n    readonly gamma: number | null;\n}\n\ndeclare var DeviceOrientationEvent: {\n    prototype: DeviceOrientationEvent;\n    new(type: string, eventInitDict?: DeviceOrientationEventInit): DeviceOrientationEvent;\n    requestPermission(): Promise<PermissionState>;\n};\n\n/** Provides information about the rate at which the device is rotating around all three axes. */\ninterface DeviceRotationRate {\n    readonly alpha: number | null;\n    readonly beta: number | null;\n    readonly gamma: number | null;\n}\n\ndeclare var DeviceRotationRate: {\n    prototype: DeviceRotationRate;\n    new(): DeviceRotationRate;\n};\n\ninterface DhImportKeyParams extends Algorithm {\n    generator: Uint8Array;\n    prime: Uint8Array;\n}\n\ninterface DhKeyAlgorithm extends KeyAlgorithm {\n    generator: Uint8Array;\n    prime: Uint8Array;\n}\n\ninterface DhKeyDeriveParams extends Algorithm {\n    public: CryptoKey;\n}\n\ninterface DhKeyGenParams extends Algorithm {\n    generator: Uint8Array;\n    prime: Uint8Array;\n}\n\ninterface DocumentEventMap extends GlobalEventHandlersEventMap, DocumentAndElementEventHandlersEventMap {\n    \"fullscreenchange\": Event;\n    \"fullscreenerror\": Event;\n    \"pointerlockchange\": Event;\n    \"pointerlockerror\": Event;\n    \"readystatechange\": Event;\n    \"visibilitychange\": Event;\n}\n\n/** Any web page loaded in the browser and serves as an entry point into the web page's content, which is the DOM tree. */\ninterface Document extends Node, DocumentAndElementEventHandlers, DocumentOrShadowRoot, GlobalEventHandlers, NonElementParentNode, ParentNode, XPathEvaluatorBase {\n    /**\n     * Sets or gets the URL for the current document.\n     */\n    readonly URL: string;\n    /**\n     * Sets or gets the color of all active links in the document.\n     */\n    /** @deprecated */\n    alinkColor: string;\n    /**\n     * Returns a reference to the collection of elements contained by the object.\n     */\n    /** @deprecated */\n    readonly all: HTMLAllCollection;\n    /**\n     * Retrieves a collection of all a objects that have a name and/or id property. Objects in this collection are in HTML source order.\n     */\n    /** @deprecated */\n    readonly anchors: HTMLCollectionOf<HTMLAnchorElement>;\n    /**\n     * Retrieves a collection of all applet objects in the document.\n     */\n    /** @deprecated */\n    readonly applets: HTMLCollectionOf<HTMLAppletElement>;\n    /**\n     * Deprecated. Sets or retrieves a value that indicates the background color behind the object.\n     */\n    /** @deprecated */\n    bgColor: string;\n    /**\n     * Specifies the beginning and end of the document body.\n     */\n    body: HTMLElement;\n    /**\n     * Returns document's encoding.\n     */\n    readonly characterSet: string;\n    /**\n     * Gets or sets the character set used to encode the object.\n     */\n    readonly charset: string;\n    /**\n     * Gets a value that indicates whether standards-compliant mode is switched on for the object.\n     */\n    readonly compatMode: string;\n    /**\n     * Returns document's content type.\n     */\n    readonly contentType: string;\n    /**\n     * Returns the HTTP cookies that apply to the Document. If there are no cookies or cookies can't be applied to this resource, the empty string will be returned.\n     * \n     * Can be set, to add a new cookie to the element's set of HTTP cookies.\n     * \n     * If the contents are sandboxed into a unique origin (e.g. in an iframe with the sandbox attribute), a \"SecurityError\" DOMException will be thrown on getting and setting.\n     */\n    cookie: string;\n    /**\n     * Returns the script element, or the SVG script element, that is currently executing, as long as the element represents a classic script. In the case of reentrant script execution, returns the one that most recently started executing amongst those that have not yet finished executing.\n     * \n     * Returns null if the Document is not currently executing a script or SVG script element (e.g., because the running script is an event handler, or a timeout), or if the currently executing script or SVG script element represents a module script.\n     */\n    readonly currentScript: HTMLOrSVGScriptElement | null;\n    readonly defaultView: (WindowProxy & typeof globalThis) | null;\n    /**\n     * Sets or gets a value that indicates whether the document can be edited.\n     */\n    designMode: string;\n    /**\n     * Sets or retrieves a value that indicates the reading order of the object.\n     */\n    dir: string;\n    /**\n     * Gets an object representing the document type declaration associated with the current document.\n     */\n    readonly doctype: DocumentType | null;\n    /**\n     * Gets a reference to the root node of the document.\n     */\n    readonly documentElement: HTMLElement;\n    /**\n     * Returns document's URL.\n     */\n    readonly documentURI: string;\n    /**\n     * Sets or gets the security domain of the document.\n     */\n    domain: string;\n    /**\n     * Retrieves a collection of all embed objects in the document.\n     */\n    readonly embeds: HTMLCollectionOf<HTMLEmbedElement>;\n    /**\n     * Sets or gets the foreground (text) color of the document.\n     */\n    /** @deprecated */\n    fgColor: string;\n    /**\n     * Retrieves a collection, in source order, of all form objects in the document.\n     */\n    readonly forms: HTMLCollectionOf<HTMLFormElement>;\n    /** @deprecated */\n    readonly fullscreen: boolean;\n    /**\n     * Returns true if document has the ability to display elements fullscreen and fullscreen is supported, or false otherwise.\n     */\n    readonly fullscreenEnabled: boolean;\n    /**\n     * Returns the head element.\n     */\n    readonly head: HTMLHeadElement;\n    readonly hidden: boolean;\n    /**\n     * Retrieves a collection, in source order, of img objects in the document.\n     */\n    readonly images: HTMLCollectionOf<HTMLImageElement>;\n    /**\n     * Gets the implementation object of the current document.\n     */\n    readonly implementation: DOMImplementation;\n    /**\n     * Returns the character encoding used to create the webpage that is loaded into the document object.\n     */\n    readonly inputEncoding: string;\n    /**\n     * Gets the date that the page was last modified, if the page supplies one.\n     */\n    readonly lastModified: string;\n    /**\n     * Sets or gets the color of the document links.\n     */\n    /** @deprecated */\n    linkColor: string;\n    /**\n     * Retrieves a collection of all a objects that specify the href property and all area objects in the document.\n     */\n    readonly links: HTMLCollectionOf<HTMLAnchorElement | HTMLAreaElement>;\n    /**\n     * Contains information about the current URL.\n     */\n    location: Location;\n    onfullscreenchange: ((this: Document, ev: Event) => any) | null;\n    onfullscreenerror: ((this: Document, ev: Event) => any) | null;\n    onpointerlockchange: ((this: Document, ev: Event) => any) | null;\n    onpointerlockerror: ((this: Document, ev: Event) => any) | null;\n    /**\n     * Fires when the state of the object has changed.\n     * @param ev The event\n     */\n    onreadystatechange: ((this: Document, ev: Event) => any) | null;\n    onvisibilitychange: ((this: Document, ev: Event) => any) | null;\n    readonly ownerDocument: null;\n    /**\n     * Return an HTMLCollection of the embed elements in the Document.\n     */\n    readonly plugins: HTMLCollectionOf<HTMLEmbedElement>;\n    /**\n     * Retrieves a value that indicates the current state of the object.\n     */\n    readonly readyState: DocumentReadyState;\n    /**\n     * Gets the URL of the location that referred the user to the current page.\n     */\n    readonly referrer: string;\n    /**\n     * Retrieves a collection of all script objects in the document.\n     */\n    readonly scripts: HTMLCollectionOf<HTMLScriptElement>;\n    readonly scrollingElement: Element | null;\n    readonly timeline: DocumentTimeline;\n    /**\n     * Contains the title of the document.\n     */\n    title: string;\n    readonly visibilityState: VisibilityState;\n    /**\n     * Sets or gets the color of the links that the user has visited.\n     */\n    /** @deprecated */\n    vlinkColor: string;\n    /**\n     * Moves node from another document and returns it.\n     * \n     * If node is a document, throws a \"NotSupportedError\" DOMException or, if node is a shadow root, throws a \"HierarchyRequestError\" DOMException.\n     */\n    adoptNode<T extends Node>(source: T): T;\n    /** @deprecated */\n    captureEvents(): void;\n    caretPositionFromPoint(x: number, y: number): CaretPosition | null;\n    /** @deprecated */\n    caretRangeFromPoint(x: number, y: number): Range;\n    /** @deprecated */\n    clear(): void;\n    /**\n     * Closes an output stream and forces the sent data to display.\n     */\n    close(): void;\n    /**\n     * Creates an attribute object with a specified name.\n     * @param name String that sets the attribute object's name.\n     */\n    createAttribute(localName: string): Attr;\n    createAttributeNS(namespace: string | null, qualifiedName: string): Attr;\n    /**\n     * Returns a CDATASection node whose data is data.\n     */\n    createCDATASection(data: string): CDATASection;\n    /**\n     * Creates a comment object with the specified data.\n     * @param data Sets the comment object's data.\n     */\n    createComment(data: string): Comment;\n    /**\n     * Creates a new document.\n     */\n    createDocumentFragment(): DocumentFragment;\n    /**\n     * Creates an instance of the element for the specified tag.\n     * @param tagName The name of an element.\n     */\n    createElement<K extends keyof HTMLElementTagNameMap>(tagName: K, options?: ElementCreationOptions): HTMLElementTagNameMap[K];\n    /** @deprecated */\n    createElement<K extends keyof HTMLElementDeprecatedTagNameMap>(tagName: K, options?: ElementCreationOptions): HTMLElementDeprecatedTagNameMap[K];\n    createElement(tagName: string, options?: ElementCreationOptions): HTMLElement;\n    /**\n     * Returns an element with namespace namespace. Its namespace prefix will be everything before \":\" (U+003E) in qualifiedName or null. Its local name will be everything after \":\" (U+003E) in qualifiedName or qualifiedName.\n     * \n     * If localName does not match the Name production an \"InvalidCharacterError\" DOMException will be thrown.\n     * \n     * If one of the following conditions is true a \"NamespaceError\" DOMException will be thrown:\n     * \n     * localName does not match the QName production.\n     * Namespace prefix is not null and namespace is the empty string.\n     * Namespace prefix is \"xml\" and namespace is not the XML namespace.\n     * qualifiedName or namespace prefix is \"xmlns\" and namespace is not the XMLNS namespace.\n     * namespace is the XMLNS namespace and neither qualifiedName nor namespace prefix is \"xmlns\".\n     * \n     * When supplied, options's is can be used to create a customized built-in element.\n     */\n    createElementNS(namespaceURI: \"http://www.w3.org/1999/xhtml\", qualifiedName: string): HTMLElement;\n    createElementNS<K extends keyof SVGElementTagNameMap>(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: K): SVGElementTagNameMap[K];\n    createElementNS(namespaceURI: \"http://www.w3.org/2000/svg\", qualifiedName: string): SVGElement;\n    createElementNS(namespaceURI: string | null, qualifiedName: string, options?: ElementCreationOptions): Element;\n    createElementNS(namespace: string | null, qualifiedName: string, options?: string | ElementCreationOptions): Element;\n    createEvent(eventInterface: \"AnimationEvent\"): AnimationEvent;\n    createEvent(eventInterface: \"AnimationPlaybackEvent\"): AnimationPlaybackEvent;\n    createEvent(eventInterface: \"AudioProcessingEvent\"): AudioProcessingEvent;\n    createEvent(eventInterface: \"BeforeUnloadEvent\"): BeforeUnloadEvent;\n    createEvent(eventInterface: \"ClipboardEvent\"): ClipboardEvent;\n    createEvent(eventInterface: \"CloseEvent\"): CloseEvent;\n    createEvent(eventInterface: \"CompositionEvent\"): CompositionEvent;\n    createEvent(eventInterface: \"CustomEvent\"): CustomEvent;\n    createEvent(eventInterface: \"DeviceLightEvent\"): DeviceLightEvent;\n    createEvent(eventInterface: \"DeviceMotionEvent\"): DeviceMotionEvent;\n    createEvent(eventInterface: \"DeviceOrientationEvent\"): DeviceOrientationEvent;\n    createEvent(eventInterface: \"DragEvent\"): DragEvent;\n    createEvent(eventInterface: \"ErrorEvent\"): ErrorEvent;\n    createEvent(eventInterface: \"Event\"): Event;\n    createEvent(eventInterface: \"Events\"): Event;\n    createEvent(eventInterface: \"FocusEvent\"): FocusEvent;\n    createEvent(eventInterface: \"FocusNavigationEvent\"): FocusNavigationEvent;\n    createEvent(eventInterface: \"GamepadEvent\"): GamepadEvent;\n    createEvent(eventInterface: \"HashChangeEvent\"): HashChangeEvent;\n    createEvent(eventInterface: \"IDBVersionChangeEvent\"): IDBVersionChangeEvent;\n    createEvent(eventInterface: \"InputEvent\"): InputEvent;\n    createEvent(eventInterface: \"KeyboardEvent\"): KeyboardEvent;\n    createEvent(eventInterface: \"ListeningStateChangedEvent\"): ListeningStateChangedEvent;\n    createEvent(eventInterface: \"MSGestureEvent\"): MSGestureEvent;\n    createEvent(eventInterface: \"MSMediaKeyMessageEvent\"): MSMediaKeyMessageEvent;\n    createEvent(eventInterface: \"MSMediaKeyNeededEvent\"): MSMediaKeyNeededEvent;\n    createEvent(eventInterface: \"MSPointerEvent\"): MSPointerEvent;\n    createEvent(eventInterface: \"MediaEncryptedEvent\"): MediaEncryptedEvent;\n    createEvent(eventInterface: \"MediaKeyMessageEvent\"): MediaKeyMessageEvent;\n    createEvent(eventInterface: \"MediaQueryListEvent\"): MediaQueryListEvent;\n    createEvent(eventInterface: \"MediaStreamErrorEvent\"): MediaStreamErrorEvent;\n    createEvent(eventInterface: \"MediaStreamEvent\"): MediaStreamEvent;\n    createEvent(eventInterface: \"MediaStreamTrackEvent\"): MediaStreamTrackEvent;\n    createEvent(eventInterface: \"MessageEvent\"): MessageEvent;\n    createEvent(eventInterface: \"MouseEvent\"): MouseEvent;\n    createEvent(eventInterface: \"MouseEvents\"): MouseEvent;\n    createEvent(eventInterface: \"MutationEvent\"): MutationEvent;\n    createEvent(eventInterface: \"MutationEvents\"): MutationEvent;\n    createEvent(eventInterface: \"OfflineAudioCompletionEvent\"): OfflineAudioCompletionEvent;\n    createEvent(eventInterface: \"OverflowEvent\"): OverflowEvent;\n    createEvent(eventInterface: \"PageTransitionEvent\"): PageTransitionEvent;\n    createEvent(eventInterface: \"PaymentRequestUpdateEvent\"): PaymentRequestUpdateEvent;\n    createEvent(eventInterface: \"PermissionRequestedEvent\"): PermissionRequestedEvent;\n    createEvent(eventInterface: \"PointerEvent\"): PointerEvent;\n    createEvent(eventInterface: \"PopStateEvent\"): PopStateEvent;\n    createEvent(eventInterface: \"ProgressEvent\"): ProgressEvent;\n    createEvent(eventInterface: \"PromiseRejectionEvent\"): PromiseRejectionEvent;\n    createEvent(eventInterface: \"RTCDTMFToneChangeEvent\"): RTCDTMFToneChangeEvent;\n    createEvent(eventInterface: \"RTCDataChannelEvent\"): RTCDataChannelEvent;\n    createEvent(eventInterface: \"RTCDtlsTransportStateChangedEvent\"): RTCDtlsTransportStateChangedEvent;\n    createEvent(eventInterface: \"RTCErrorEvent\"): RTCErrorEvent;\n    createEvent(eventInterface: \"RTCIceCandidatePairChangedEvent\"): RTCIceCandidatePairChangedEvent;\n    createEvent(eventInterface: \"RTCIceGathererEvent\"): RTCIceGathererEvent;\n    createEvent(eventInterface: \"RTCIceTransportStateChangedEvent\"): RTCIceTransportStateChangedEvent;\n    createEvent(eventInterface: \"RTCPeerConnectionIceErrorEvent\"): RTCPeerConnectionIceErrorEvent;\n    createEvent(eventInterface: \"RTCPeerConnectionIceEvent\"): RTCPeerConnectionIceEvent;\n    createEvent(eventInterface: \"RTCSsrcConflictEvent\"): RTCSsrcConflictEvent;\n    createEvent(eventInterface: \"RTCStatsEvent\"): RTCStatsEvent;\n    createEvent(eventInterface: \"RTCTrackEvent\"): RTCTrackEvent;\n    createEvent(eventInterface: \"SVGZoomEvent\"): SVGZoomEvent;\n    createEvent(eventInterface: \"SVGZoomEvents\"): SVGZoomEvent;\n    createEvent(eventInterface: \"SecurityPolicyViolationEvent\"): SecurityPolicyViolationEvent;\n    createEvent(eventInterface: \"ServiceWorkerMessageEvent\"): ServiceWorkerMessageEvent;\n    createEvent(eventInterface: \"SpeechRecognitionEvent\"): SpeechRecognitionEvent;\n    createEvent(eventInterface: \"SpeechSynthesisErrorEvent\"): SpeechSynthesisErrorEvent;\n    createEvent(eventInterface: \"SpeechSynthesisEvent\"): SpeechSynthesisEvent;\n    createEvent(eventInterface: \"StorageEvent\"): StorageEvent;\n    createEvent(eventInterface: \"TextEvent\"): TextEvent;\n    createEvent(eventInterface: \"TouchEvent\"): TouchEvent;\n    createEvent(eventInterface: \"TrackEvent\"): TrackEvent;\n    createEvent(eventInterface: \"TransitionEvent\"): TransitionEvent;\n    createEvent(eventInterface: \"UIEvent\"): UIEvent;\n    createEvent(eventInterface: \"UIEvents\"): UIEvent;\n    createEvent(eventInterface: \"VRDisplayEvent\"): VRDisplayEvent;\n    createEvent(eventInterface: \"VRDisplayEvent \"): VRDisplayEvent ;\n    createEvent(eventInterface: \"WebGLContextEvent\"): WebGLContextEvent;\n    createEvent(eventInterface: \"WheelEvent\"): WheelEvent;\n    createEvent(eventInterface: string): Event;\n    /**\n     * Creates a NodeIterator object that you can use to traverse filtered lists of nodes or elements in a document.\n     * @param root The root element or node to start traversing on.\n     * @param whatToShow The type of nodes or elements to appear in the node list\n     * @param filter A custom NodeFilter function to use. For more information, see filter. Use null for no filter.\n     * @param entityReferenceExpansion A flag that specifies whether entity reference nodes are expanded.\n     */\n    createNodeIterator(root: Node, whatToShow?: number, filter?: NodeFilter | null): NodeIterator;\n    /**\n     * Returns a ProcessingInstruction node whose target is target and data is data. If target does not match the Name production an \"InvalidCharacterError\" DOMException will be thrown. If data contains \"?>\" an \"InvalidCharacterError\" DOMException will be thrown.\n     */\n    createProcessingInstruction(target: string, data: string): ProcessingInstruction;\n    /**\n     *  Returns an empty range object that has both of its boundary points positioned at the beginning of the document.\n     */\n    createRange(): Range;\n    /**\n     * Creates a text string from the specified value.\n     * @param data String that specifies the nodeValue property of the text node.\n     */\n    createTextNode(data: string): Text;\n    /**\n     * Creates a TreeWalker object that you can use to traverse filtered lists of nodes or elements in a document.\n     * @param root The root element or node to start traversing on.\n     * @param whatToShow The type of nodes or elements to appear in the node list. For more information, see whatToShow.\n     * @param filter A custom NodeFilter function to use.\n     * @param entityReferenceExpansion A flag that specifies whether entity reference nodes are expanded.\n     */\n    createTreeWalker(root: Node, whatToShow?: number, filter?: NodeFilter | null): TreeWalker;\n    /** @deprecated */\n    createTreeWalker(root: Node, whatToShow: number, filter: NodeFilter | null, entityReferenceExpansion?: boolean): TreeWalker;\n    /**\n     * Returns the element for the specified x coordinate and the specified y coordinate.\n     * @param x The x-offset\n     * @param y The y-offset\n     */\n    elementFromPoint(x: number, y: number): Element | null;\n    elementsFromPoint(x: number, y: number): Element[];\n    /**\n     * Executes a command on the current document, current selection, or the given range.\n     * @param commandId String that specifies the command to execute. This command can be any of the command identifiers that can be executed in script.\n     * @param showUI Display the user interface, defaults to false.\n     * @param value Value to assign.\n     */\n    execCommand(commandId: string, showUI?: boolean, value?: string): boolean;\n    /**\n     * Stops document's fullscreen element from being displayed fullscreen and resolves promise when done.\n     */\n    exitFullscreen(): Promise<void>;\n    exitPointerLock(): void;\n    getAnimations(): Animation[];\n    /**\n     * Returns a reference to the first object with the specified value of the ID or NAME attribute.\n     * @param elementId String that specifies the ID value. Case-insensitive.\n     */\n    getElementById(elementId: string): HTMLElement | null;\n    /**\n     * Returns a HTMLCollection of the elements in the object on which the method was invoked (a document or an element) that have all the classes given by classNames. The classNames argument is interpreted as a space-separated list of classes.\n     */\n    getElementsByClassName(classNames: string): HTMLCollectionOf<Element>;\n    /**\n     * Gets a collection of objects based on the value of the NAME or ID attribute.\n     * @param elementName Gets a collection of objects based on the value of the NAME or ID attribute.\n     */\n    getElementsByName(elementName: string): NodeListOf<HTMLElement>;\n    /**\n     * Retrieves a collection of objects based on the specified element name.\n     * @param name Specifies the name of an element.\n     */\n    getElementsByTagName<K extends keyof HTMLElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<HTMLElementTagNameMap[K]>;\n    getElementsByTagName<K extends keyof SVGElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<SVGElementTagNameMap[K]>;\n    getElementsByTagName(qualifiedName: string): HTMLCollectionOf<Element>;\n    /**\n     * If namespace and localName are \"*\" returns a HTMLCollection of all descendant elements.\n     * \n     * If only namespace is \"*\" returns a HTMLCollection of all descendant elements whose local name is localName.\n     * \n     * If only localName is \"*\" returns a HTMLCollection of all descendant elements whose namespace is namespace.\n     * \n     * Otherwise, returns a HTMLCollection of all descendant elements whose namespace is namespace and local name is localName.\n     */\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/1999/xhtml\", localName: string): HTMLCollectionOf<HTMLElement>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/2000/svg\", localName: string): HTMLCollectionOf<SVGElement>;\n    getElementsByTagNameNS(namespaceURI: string, localName: string): HTMLCollectionOf<Element>;\n    /**\n     * Returns an object representing the current selection of the document that is loaded into the object displaying a webpage.\n     */\n    getSelection(): Selection | null;\n    /**\n     * Gets a value indicating whether the object currently has focus.\n     */\n    hasFocus(): boolean;\n    /**\n     * Returns a copy of node. If deep is true, the copy also includes the node's descendants.\n     * \n     * If node is a document or a shadow root, throws a \"NotSupportedError\" DOMException.\n     */\n    importNode<T extends Node>(importedNode: T, deep: boolean): T;\n    /**\n     * Opens a new window and loads a document specified by a given URL. Also, opens a new window that uses the url parameter and the name parameter to collect the output of the write method and the writeln method.\n     * @param url Specifies a MIME type for the document.\n     * @param name Specifies the name of the window. This name is used as the value for the TARGET attribute on a form or an anchor element.\n     * @param features Contains a list of items separated by commas. Each item consists of an option and a value, separated by an equals sign (for example, \"fullscreen=yes, toolbar=yes\"). The following values are supported.\n     * @param replace Specifies whether the existing entry for the document is replaced in the history list.\n     */\n    open(url?: string, name?: string, features?: string, replace?: boolean): Document;\n    /**\n     * Returns a Boolean value that indicates whether a specified command can be successfully executed using execCommand, given the current state of the document.\n     * @param commandId Specifies a command identifier.\n     */\n    queryCommandEnabled(commandId: string): boolean;\n    /**\n     * Returns a Boolean value that indicates whether the specified command is in the indeterminate state.\n     * @param commandId String that specifies a command identifier.\n     */\n    queryCommandIndeterm(commandId: string): boolean;\n    /**\n     * Returns a Boolean value that indicates the current state of the command.\n     * @param commandId String that specifies a command identifier.\n     */\n    queryCommandState(commandId: string): boolean;\n    /**\n     * Returns a Boolean value that indicates whether the current command is supported on the current range.\n     * @param commandId Specifies a command identifier.\n     */\n    queryCommandSupported(commandId: string): boolean;\n    /**\n     * Returns the current value of the document, range, or current selection for the given command.\n     * @param commandId String that specifies a command identifier.\n     */\n    queryCommandValue(commandId: string): string;\n    /** @deprecated */\n    releaseEvents(): void;\n    /**\n     * Writes one or more HTML expressions to a document in the specified window.\n     * @param content Specifies the text and HTML tags to write.\n     */\n    write(...text: string[]): void;\n    /**\n     * Writes one or more HTML expressions, followed by a carriage return, to a document in the specified window.\n     * @param content The text and HTML tags to write.\n     */\n    writeln(...text: string[]): void;\n    addEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: Document, ev: DocumentEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: Document, ev: DocumentEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Document: {\n    prototype: Document;\n    new(): Document;\n};\n\ninterface DocumentAndElementEventHandlersEventMap {\n    \"copy\": ClipboardEvent;\n    \"cut\": ClipboardEvent;\n    \"paste\": ClipboardEvent;\n}\n\ninterface DocumentAndElementEventHandlers {\n    oncopy: ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null;\n    oncut: ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null;\n    onpaste: ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null;\n    addEventListener<K extends keyof DocumentAndElementEventHandlersEventMap>(type: K, listener: (this: DocumentAndElementEventHandlers, ev: DocumentAndElementEventHandlersEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof DocumentAndElementEventHandlersEventMap>(type: K, listener: (this: DocumentAndElementEventHandlers, ev: DocumentAndElementEventHandlersEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ninterface DocumentEvent {\n    createEvent(eventInterface: \"AnimationEvent\"): AnimationEvent;\n    createEvent(eventInterface: \"AnimationPlaybackEvent\"): AnimationPlaybackEvent;\n    createEvent(eventInterface: \"AudioProcessingEvent\"): AudioProcessingEvent;\n    createEvent(eventInterface: \"BeforeUnloadEvent\"): BeforeUnloadEvent;\n    createEvent(eventInterface: \"ClipboardEvent\"): ClipboardEvent;\n    createEvent(eventInterface: \"CloseEvent\"): CloseEvent;\n    createEvent(eventInterface: \"CompositionEvent\"): CompositionEvent;\n    createEvent(eventInterface: \"CustomEvent\"): CustomEvent;\n    createEvent(eventInterface: \"DeviceLightEvent\"): DeviceLightEvent;\n    createEvent(eventInterface: \"DeviceMotionEvent\"): DeviceMotionEvent;\n    createEvent(eventInterface: \"DeviceOrientationEvent\"): DeviceOrientationEvent;\n    createEvent(eventInterface: \"DragEvent\"): DragEvent;\n    createEvent(eventInterface: \"ErrorEvent\"): ErrorEvent;\n    createEvent(eventInterface: \"Event\"): Event;\n    createEvent(eventInterface: \"Events\"): Event;\n    createEvent(eventInterface: \"FocusEvent\"): FocusEvent;\n    createEvent(eventInterface: \"FocusNavigationEvent\"): FocusNavigationEvent;\n    createEvent(eventInterface: \"GamepadEvent\"): GamepadEvent;\n    createEvent(eventInterface: \"HashChangeEvent\"): HashChangeEvent;\n    createEvent(eventInterface: \"IDBVersionChangeEvent\"): IDBVersionChangeEvent;\n    createEvent(eventInterface: \"InputEvent\"): InputEvent;\n    createEvent(eventInterface: \"KeyboardEvent\"): KeyboardEvent;\n    createEvent(eventInterface: \"ListeningStateChangedEvent\"): ListeningStateChangedEvent;\n    createEvent(eventInterface: \"MSGestureEvent\"): MSGestureEvent;\n    createEvent(eventInterface: \"MSMediaKeyMessageEvent\"): MSMediaKeyMessageEvent;\n    createEvent(eventInterface: \"MSMediaKeyNeededEvent\"): MSMediaKeyNeededEvent;\n    createEvent(eventInterface: \"MSPointerEvent\"): MSPointerEvent;\n    createEvent(eventInterface: \"MediaEncryptedEvent\"): MediaEncryptedEvent;\n    createEvent(eventInterface: \"MediaKeyMessageEvent\"): MediaKeyMessageEvent;\n    createEvent(eventInterface: \"MediaQueryListEvent\"): MediaQueryListEvent;\n    createEvent(eventInterface: \"MediaStreamErrorEvent\"): MediaStreamErrorEvent;\n    createEvent(eventInterface: \"MediaStreamEvent\"): MediaStreamEvent;\n    createEvent(eventInterface: \"MediaStreamTrackEvent\"): MediaStreamTrackEvent;\n    createEvent(eventInterface: \"MessageEvent\"): MessageEvent;\n    createEvent(eventInterface: \"MouseEvent\"): MouseEvent;\n    createEvent(eventInterface: \"MouseEvents\"): MouseEvent;\n    createEvent(eventInterface: \"MutationEvent\"): MutationEvent;\n    createEvent(eventInterface: \"MutationEvents\"): MutationEvent;\n    createEvent(eventInterface: \"OfflineAudioCompletionEvent\"): OfflineAudioCompletionEvent;\n    createEvent(eventInterface: \"OverflowEvent\"): OverflowEvent;\n    createEvent(eventInterface: \"PageTransitionEvent\"): PageTransitionEvent;\n    createEvent(eventInterface: \"PaymentRequestUpdateEvent\"): PaymentRequestUpdateEvent;\n    createEvent(eventInterface: \"PermissionRequestedEvent\"): PermissionRequestedEvent;\n    createEvent(eventInterface: \"PointerEvent\"): PointerEvent;\n    createEvent(eventInterface: \"PopStateEvent\"): PopStateEvent;\n    createEvent(eventInterface: \"ProgressEvent\"): ProgressEvent;\n    createEvent(eventInterface: \"PromiseRejectionEvent\"): PromiseRejectionEvent;\n    createEvent(eventInterface: \"RTCDTMFToneChangeEvent\"): RTCDTMFToneChangeEvent;\n    createEvent(eventInterface: \"RTCDataChannelEvent\"): RTCDataChannelEvent;\n    createEvent(eventInterface: \"RTCDtlsTransportStateChangedEvent\"): RTCDtlsTransportStateChangedEvent;\n    createEvent(eventInterface: \"RTCErrorEvent\"): RTCErrorEvent;\n    createEvent(eventInterface: \"RTCIceCandidatePairChangedEvent\"): RTCIceCandidatePairChangedEvent;\n    createEvent(eventInterface: \"RTCIceGathererEvent\"): RTCIceGathererEvent;\n    createEvent(eventInterface: \"RTCIceTransportStateChangedEvent\"): RTCIceTransportStateChangedEvent;\n    createEvent(eventInterface: \"RTCPeerConnectionIceErrorEvent\"): RTCPeerConnectionIceErrorEvent;\n    createEvent(eventInterface: \"RTCPeerConnectionIceEvent\"): RTCPeerConnectionIceEvent;\n    createEvent(eventInterface: \"RTCSsrcConflictEvent\"): RTCSsrcConflictEvent;\n    createEvent(eventInterface: \"RTCStatsEvent\"): RTCStatsEvent;\n    createEvent(eventInterface: \"RTCTrackEvent\"): RTCTrackEvent;\n    createEvent(eventInterface: \"SVGZoomEvent\"): SVGZoomEvent;\n    createEvent(eventInterface: \"SVGZoomEvents\"): SVGZoomEvent;\n    createEvent(eventInterface: \"SecurityPolicyViolationEvent\"): SecurityPolicyViolationEvent;\n    createEvent(eventInterface: \"ServiceWorkerMessageEvent\"): ServiceWorkerMessageEvent;\n    createEvent(eventInterface: \"SpeechRecognitionEvent\"): SpeechRecognitionEvent;\n    createEvent(eventInterface: \"SpeechSynthesisErrorEvent\"): SpeechSynthesisErrorEvent;\n    createEvent(eventInterface: \"SpeechSynthesisEvent\"): SpeechSynthesisEvent;\n    createEvent(eventInterface: \"StorageEvent\"): StorageEvent;\n    createEvent(eventInterface: \"TextEvent\"): TextEvent;\n    createEvent(eventInterface: \"TouchEvent\"): TouchEvent;\n    createEvent(eventInterface: \"TrackEvent\"): TrackEvent;\n    createEvent(eventInterface: \"TransitionEvent\"): TransitionEvent;\n    createEvent(eventInterface: \"UIEvent\"): UIEvent;\n    createEvent(eventInterface: \"UIEvents\"): UIEvent;\n    createEvent(eventInterface: \"VRDisplayEvent\"): VRDisplayEvent;\n    createEvent(eventInterface: \"VRDisplayEvent \"): VRDisplayEvent ;\n    createEvent(eventInterface: \"WebGLContextEvent\"): WebGLContextEvent;\n    createEvent(eventInterface: \"WheelEvent\"): WheelEvent;\n    createEvent(eventInterface: string): Event;\n}\n\n/** A minimal document object that has no parent. It is used as a lightweight version of Document that stores a segment of a document structure comprised of nodes just like a standard document. The key difference is that because the document fragment isn't part of the active document tree structure, changes made to the fragment don't affect the document, cause reflow, or incur any performance impact that can occur when changes are made. */\ninterface DocumentFragment extends Node, NonElementParentNode, ParentNode {\n    readonly ownerDocument: Document;\n    getElementById(elementId: string): HTMLElement | null;\n}\n\ndeclare var DocumentFragment: {\n    prototype: DocumentFragment;\n    new(): DocumentFragment;\n};\n\ninterface DocumentOrShadowRoot {\n    readonly activeElement: Element | null;\n    /**\n     * Returns document's fullscreen element.\n     */\n    readonly fullscreenElement: Element | null;\n    readonly pointerLockElement: Element | null;\n    /**\n     * Retrieves a collection of styleSheet objects representing the style sheets that correspond to each instance of a link or style object in the document.\n     */\n    readonly styleSheets: StyleSheetList;\n    caretPositionFromPoint(x: number, y: number): CaretPosition | null;\n    /** @deprecated */\n    caretRangeFromPoint(x: number, y: number): Range;\n    elementFromPoint(x: number, y: number): Element | null;\n    elementsFromPoint(x: number, y: number): Element[];\n    getSelection(): Selection | null;\n}\n\ninterface DocumentTimeline extends AnimationTimeline {\n}\n\ndeclare var DocumentTimeline: {\n    prototype: DocumentTimeline;\n    new(options?: DocumentTimelineOptions): DocumentTimeline;\n};\n\n/** A Node containing a doctype. */\ninterface DocumentType extends Node, ChildNode {\n    readonly name: string;\n    readonly ownerDocument: Document;\n    readonly publicId: string;\n    readonly systemId: string;\n}\n\ndeclare var DocumentType: {\n    prototype: DocumentType;\n    new(): DocumentType;\n};\n\n/** A DOM event that represents a drag and drop interaction. The user initiates a drag by placing a pointer device (such as a mouse) on the touch surface and then dragging the pointer to a new location (such as another DOM element). Applications are free to interpret a drag and drop interaction in an application-specific way. */\ninterface DragEvent extends MouseEvent {\n    /**\n     * Returns the DataTransfer object for the event.\n     */\n    readonly dataTransfer: DataTransfer | null;\n}\n\ndeclare var DragEvent: {\n    prototype: DragEvent;\n    new(type: string, eventInitDict?: DragEventInit): DragEvent;\n};\n\n/** Inherits properties from its parent, AudioNode. */\ninterface DynamicsCompressorNode extends AudioNode {\n    readonly attack: AudioParam;\n    readonly knee: AudioParam;\n    readonly ratio: AudioParam;\n    readonly reduction: number;\n    readonly release: AudioParam;\n    readonly threshold: AudioParam;\n}\n\ndeclare var DynamicsCompressorNode: {\n    prototype: DynamicsCompressorNode;\n    new(context: BaseAudioContext, options?: DynamicsCompressorOptions): DynamicsCompressorNode;\n};\n\ninterface EXT_blend_minmax {\n    readonly MAX_EXT: GLenum;\n    readonly MIN_EXT: GLenum;\n}\n\n/** The EXT_frag_depth extension is part of the WebGL API and enables to set a depth value of a fragment from within the fragment shader. */\ninterface EXT_frag_depth {\n}\n\ninterface EXT_sRGB {\n    readonly FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT: GLenum;\n    readonly SRGB8_ALPHA8_EXT: GLenum;\n    readonly SRGB_ALPHA_EXT: GLenum;\n    readonly SRGB_EXT: GLenum;\n}\n\ninterface EXT_shader_texture_lod {\n}\n\n/** The EXT_texture_filter_anisotropic extension is part of the WebGL API and exposes two constants for anisotropic filtering (AF). */\ninterface EXT_texture_filter_anisotropic {\n    readonly MAX_TEXTURE_MAX_ANISOTROPY_EXT: GLenum;\n    readonly TEXTURE_MAX_ANISOTROPY_EXT: GLenum;\n}\n\ninterface ElementEventMap {\n    \"fullscreenchange\": Event;\n    \"fullscreenerror\": Event;\n}\n\n/** Element is the most general base class from which all objects in a Document inherit. It only has methods and properties common to all kinds of elements. More specific classes inherit from Element. */\ninterface Element extends Node, Animatable, ChildNode, InnerHTML, NonDocumentTypeChildNode, ParentNode, Slottable {\n    readonly assignedSlot: HTMLSlotElement | null;\n    readonly attributes: NamedNodeMap;\n    /**\n     * Allows for manipulation of element's class content attribute as a set of whitespace-separated tokens through a DOMTokenList object.\n     */\n    readonly classList: DOMTokenList;\n    /**\n     * Returns the value of element's class content attribute. Can be set to change it.\n     */\n    className: string;\n    readonly clientHeight: number;\n    readonly clientLeft: number;\n    readonly clientTop: number;\n    readonly clientWidth: number;\n    /**\n     * Returns the value of element's id content attribute. Can be set to change it.\n     */\n    id: string;\n    /**\n     * Returns the local name.\n     */\n    readonly localName: string;\n    /**\n     * Returns the namespace.\n     */\n    readonly namespaceURI: string | null;\n    onfullscreenchange: ((this: Element, ev: Event) => any) | null;\n    onfullscreenerror: ((this: Element, ev: Event) => any) | null;\n    outerHTML: string;\n    readonly ownerDocument: Document;\n    /**\n     * Returns the namespace prefix.\n     */\n    readonly prefix: string | null;\n    readonly scrollHeight: number;\n    scrollLeft: number;\n    scrollTop: number;\n    readonly scrollWidth: number;\n    /**\n     * Returns element's shadow root, if any, and if shadow root's mode is \"open\", and null otherwise.\n     */\n    readonly shadowRoot: ShadowRoot | null;\n    /**\n     * Returns the value of element's slot content attribute. Can be set to change it.\n     */\n    slot: string;\n    /**\n     * Returns the HTML-uppercased qualified name.\n     */\n    readonly tagName: string;\n    /**\n     * Creates a shadow root for element and returns it.\n     */\n    attachShadow(init: ShadowRootInit): ShadowRoot;\n    /**\n     * Returns the first (starting at element) inclusive ancestor that matches selectors, and null otherwise.\n     */\n    closest<K extends keyof HTMLElementTagNameMap>(selector: K): HTMLElementTagNameMap[K] | null;\n    closest<K extends keyof SVGElementTagNameMap>(selector: K): SVGElementTagNameMap[K] | null;\n    closest<E extends Element = Element>(selector: string): E | null;\n    /**\n     * Returns element's first attribute whose qualified name is qualifiedName, and null if there is no such attribute otherwise.\n     */\n    getAttribute(qualifiedName: string): string | null;\n    /**\n     * Returns element's attribute whose namespace is namespace and local name is localName, and null if there is no such attribute otherwise.\n     */\n    getAttributeNS(namespace: string | null, localName: string): string | null;\n    /**\n     * Returns the qualified names of all element's attributes. Can contain duplicates.\n     */\n    getAttributeNames(): string[];\n    getAttributeNode(qualifiedName: string): Attr | null;\n    getAttributeNodeNS(namespace: string | null, localName: string): Attr | null;\n    getBoundingClientRect(): DOMRect;\n    getClientRects(): DOMRectList;\n    /**\n     * Returns a HTMLCollection of the elements in the object on which the method was invoked (a document or an element) that have all the classes given by classNames. The classNames argument is interpreted as a space-separated list of classes.\n     */\n    getElementsByClassName(classNames: string): HTMLCollectionOf<Element>;\n    getElementsByTagName<K extends keyof HTMLElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<HTMLElementTagNameMap[K]>;\n    getElementsByTagName<K extends keyof SVGElementTagNameMap>(qualifiedName: K): HTMLCollectionOf<SVGElementTagNameMap[K]>;\n    getElementsByTagName(qualifiedName: string): HTMLCollectionOf<Element>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/1999/xhtml\", localName: string): HTMLCollectionOf<HTMLElement>;\n    getElementsByTagNameNS(namespaceURI: \"http://www.w3.org/2000/svg\", localName: string): HTMLCollectionOf<SVGElement>;\n    getElementsByTagNameNS(namespaceURI: string, localName: string): HTMLCollectionOf<Element>;\n    /**\n     * Returns true if element has an attribute whose qualified name is qualifiedName, and false otherwise.\n     */\n    hasAttribute(qualifiedName: string): boolean;\n    /**\n     * Returns true if element has an attribute whose namespace is namespace and local name is localName.\n     */\n    hasAttributeNS(namespace: string | null, localName: string): boolean;\n    /**\n     * Returns true if element has attributes, and false otherwise.\n     */\n    hasAttributes(): boolean;\n    hasPointerCapture(pointerId: number): boolean;\n    insertAdjacentElement(position: InsertPosition, insertedElement: Element): Element | null;\n    insertAdjacentHTML(where: InsertPosition, html: string): void;\n    insertAdjacentText(where: InsertPosition, text: string): void;\n    /**\n     * Returns true if matching selectors against element's root yields element, and false otherwise.\n     */\n    matches(selectors: string): boolean;\n    msGetRegionContent(): any;\n    releasePointerCapture(pointerId: number): void;\n    /**\n     * Removes element's first attribute whose qualified name is qualifiedName.\n     */\n    removeAttribute(qualifiedName: string): void;\n    /**\n     * Removes element's attribute whose namespace is namespace and local name is localName.\n     */\n    removeAttributeNS(namespace: string | null, localName: string): void;\n    removeAttributeNode(attr: Attr): Attr;\n    /**\n     * Displays element fullscreen and resolves promise when done.\n     * \n     * When supplied, options's navigationUI member indicates whether showing navigation UI while in fullscreen is preferred or not. If set to \"show\", navigation simplicity is preferred over screen space, and if set to \"hide\", more screen space is preferred. User agents are always free to honor user preference over the application's. The default value \"auto\" indicates no application preference.\n     */\n    requestFullscreen(options?: FullscreenOptions): Promise<void>;\n    requestPointerLock(): void;\n    scroll(options?: ScrollToOptions): void;\n    scroll(x: number, y: number): void;\n    scrollBy(options?: ScrollToOptions): void;\n    scrollBy(x: number, y: number): void;\n    scrollIntoView(arg?: boolean | ScrollIntoViewOptions): void;\n    scrollTo(options?: ScrollToOptions): void;\n    scrollTo(x: number, y: number): void;\n    /**\n     * Sets the value of element's first attribute whose qualified name is qualifiedName to value.\n     */\n    setAttribute(qualifiedName: string, value: string): void;\n    /**\n     * Sets the value of element's attribute whose namespace is namespace and local name is localName to value.\n     */\n    setAttributeNS(namespace: string | null, qualifiedName: string, value: string): void;\n    setAttributeNode(attr: Attr): Attr | null;\n    setAttributeNodeNS(attr: Attr): Attr | null;\n    setPointerCapture(pointerId: number): void;\n    /**\n     * If force is not given, \"toggles\" qualifiedName, removing it if it is present and adding it if it is not present. If force is true, adds qualifiedName. If force is false, removes qualifiedName.\n     * \n     * Returns true if qualifiedName is now present, and false otherwise.\n     */\n    toggleAttribute(qualifiedName: string, force?: boolean): boolean;\n    webkitMatchesSelector(selectors: string): boolean;\n    addEventListener<K extends keyof ElementEventMap>(type: K, listener: (this: Element, ev: ElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ElementEventMap>(type: K, listener: (this: Element, ev: ElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Element: {\n    prototype: Element;\n    new(): Element;\n};\n\ninterface ElementCSSInlineStyle {\n    readonly style: CSSStyleDeclaration;\n}\n\ninterface ElementContentEditable {\n    contentEditable: string;\n    enterKeyHint: string;\n    inputMode: string;\n    readonly isContentEditable: boolean;\n}\n\n/** Events providing information related to errors in scripts or in files. */\ninterface ErrorEvent extends Event {\n    readonly colno: number;\n    readonly error: any;\n    readonly filename: string;\n    readonly lineno: number;\n    readonly message: string;\n}\n\ndeclare var ErrorEvent: {\n    prototype: ErrorEvent;\n    new(type: string, eventInitDict?: ErrorEventInit): ErrorEvent;\n};\n\n/** An event which takes place in the DOM. */\ninterface Event {\n    /**\n     * Returns true or false depending on how event was initialized. True if event goes through its target's ancestors in reverse tree order, and false otherwise.\n     */\n    readonly bubbles: boolean;\n    cancelBubble: boolean;\n    /**\n     * Returns true or false depending on how event was initialized. Its return value does not always carry meaning, but true can indicate that part of the operation during which event was dispatched, can be canceled by invoking the preventDefault() method.\n     */\n    readonly cancelable: boolean;\n    /**\n     * Returns true or false depending on how event was initialized. True if event invokes listeners past a ShadowRoot node that is the root of its target, and false otherwise.\n     */\n    readonly composed: boolean;\n    /**\n     * Returns the object whose event listener's callback is currently being invoked.\n     */\n    readonly currentTarget: EventTarget | null;\n    /**\n     * Returns true if preventDefault() was invoked successfully to indicate cancelation, and false otherwise.\n     */\n    readonly defaultPrevented: boolean;\n    /**\n     * Returns the event's phase, which is one of NONE, CAPTURING_PHASE, AT_TARGET, and BUBBLING_PHASE.\n     */\n    readonly eventPhase: number;\n    /**\n     * Returns true if event was dispatched by the user agent, and false otherwise.\n     */\n    readonly isTrusted: boolean;\n    returnValue: boolean;\n    /** @deprecated */\n    readonly srcElement: EventTarget | null;\n    /**\n     * Returns the object to which event is dispatched (its target).\n     */\n    readonly target: EventTarget | null;\n    /**\n     * Returns the event's timestamp as the number of milliseconds measured relative to the time origin.\n     */\n    readonly timeStamp: number;\n    /**\n     * Returns the type of event, e.g. \"click\", \"hashchange\", or \"submit\".\n     */\n    readonly type: string;\n    /**\n     * Returns the invocation target objects of event's path (objects on which listeners will be invoked), except for any nodes in shadow trees of which the shadow root's mode is \"closed\" that are not reachable from event's currentTarget.\n     */\n    composedPath(): EventTarget[];\n    initEvent(type: string, bubbles?: boolean, cancelable?: boolean): void;\n    /**\n     * If invoked when the cancelable attribute value is true, and while executing a listener for the event with passive set to false, signals to the operation that caused event to be dispatched that it needs to be canceled.\n     */\n    preventDefault(): void;\n    /**\n     * Invoking this method prevents event from reaching any registered event listeners after the current one finishes running and, when dispatched in a tree, also prevents event from reaching any other objects.\n     */\n    stopImmediatePropagation(): void;\n    /**\n     * When dispatched in a tree, invoking this method prevents event from reaching any objects other than the current object.\n     */\n    stopPropagation(): void;\n    readonly AT_TARGET: number;\n    readonly BUBBLING_PHASE: number;\n    readonly CAPTURING_PHASE: number;\n    readonly NONE: number;\n}\n\ndeclare var Event: {\n    prototype: Event;\n    new(type: string, eventInitDict?: EventInit): Event;\n    readonly AT_TARGET: number;\n    readonly BUBBLING_PHASE: number;\n    readonly CAPTURING_PHASE: number;\n    readonly NONE: number;\n};\n\ninterface EventListenerObject {\n    handleEvent(evt: Event): void;\n}\n\ninterface EventSourceEventMap {\n    \"error\": Event;\n    \"message\": MessageEvent;\n    \"open\": Event;\n}\n\ninterface EventSource extends EventTarget {\n    onerror: ((this: EventSource, ev: Event) => any) | null;\n    onmessage: ((this: EventSource, ev: MessageEvent) => any) | null;\n    onopen: ((this: EventSource, ev: Event) => any) | null;\n    /**\n     * Returns the state of this EventSource object's connection. It can have the values described below.\n     */\n    readonly readyState: number;\n    /**\n     * Returns the URL providing the event stream.\n     */\n    readonly url: string;\n    /**\n     * Returns true if the credentials mode for connection requests to the URL providing the event stream is set to \"include\", and false otherwise.\n     */\n    readonly withCredentials: boolean;\n    /**\n     * Aborts any instances of the fetch algorithm started for this EventSource object, and sets the readyState attribute to CLOSED.\n     */\n    close(): void;\n    readonly CLOSED: number;\n    readonly CONNECTING: number;\n    readonly OPEN: number;\n    addEventListener<K extends keyof EventSourceEventMap>(type: K, listener: (this: EventSource, ev: EventSourceEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof EventSourceEventMap>(type: K, listener: (this: EventSource, ev: EventSourceEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var EventSource: {\n    prototype: EventSource;\n    new(url: string, eventSourceInitDict?: EventSourceInit): EventSource;\n    readonly CLOSED: number;\n    readonly CONNECTING: number;\n    readonly OPEN: number;\n};\n\n/** EventTarget is a DOM interface implemented by objects that can receive events and may have listeners for them. */\ninterface EventTarget {\n    /**\n     * Appends an event listener for events whose type attribute value is type. The callback argument sets the callback that will be invoked when the event is dispatched.\n     * \n     * The options argument sets listener-specific options. For compatibility this can be a boolean, in which case the method behaves exactly as if the value was specified as options's capture.\n     * \n     * When set to true, options's capture prevents callback from being invoked when the event's eventPhase attribute value is BUBBLING_PHASE. When false (or not present), callback will not be invoked when event's eventPhase attribute value is CAPTURING_PHASE. Either way, callback will be invoked if event's eventPhase attribute value is AT_TARGET.\n     * \n     * When set to true, options's passive indicates that the callback will not cancel the event by invoking preventDefault(). This is used to enable performance optimizations described in § 2.8 Observing event listeners.\n     * \n     * When set to true, options's once indicates that the callback will only be invoked once after which the event listener will be removed.\n     * \n     * The event listener is appended to target's event listener list and is not appended if it has the same type, callback, and capture.\n     */\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject | null, options?: boolean | AddEventListenerOptions): void;\n    /**\n     * Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.\n     */\n    dispatchEvent(event: Event): boolean;\n    /**\n     * Removes the event listener in target's event listener list with the same type, callback, and options.\n     */\n    removeEventListener(type: string, callback: EventListenerOrEventListenerObject | null, options?: EventListenerOptions | boolean): void;\n}\n\ndeclare var EventTarget: {\n    prototype: EventTarget;\n    new(): EventTarget;\n};\n\ninterface ExtensionScriptApis {\n    extensionIdToShortId(extensionId: string): number;\n    fireExtensionApiTelemetry(functionName: string, isSucceeded: boolean, isSupported: boolean, errorString: string): void;\n    genericFunction(routerAddress: any, parameters?: string, callbackId?: number): void;\n    genericSynchronousFunction(functionId: number, parameters?: string): string;\n    genericWebRuntimeCallout(to: any, from: any, payload: string): void;\n    getExtensionId(): string;\n    registerGenericFunctionCallbackHandler(callbackHandler: Function): void;\n    registerGenericPersistentCallbackHandler(callbackHandler: Function): void;\n    registerWebRuntimeCallbackHandler(handler: Function): any;\n}\n\ndeclare var ExtensionScriptApis: {\n    prototype: ExtensionScriptApis;\n    new(): ExtensionScriptApis;\n};\n\ninterface External {\n    /** @deprecated */\n    AddSearchProvider(): void;\n    /** @deprecated */\n    IsSearchProviderInstalled(): void;\n}\n\ndeclare var External: {\n    prototype: External;\n    new(): External;\n};\n\n/** Provides information about files and allows JavaScript in a web page to access their content. */\ninterface File extends Blob {\n    readonly lastModified: number;\n    readonly name: string;\n}\n\ndeclare var File: {\n    prototype: File;\n    new(fileBits: BlobPart[], fileName: string, options?: FilePropertyBag): File;\n};\n\n/** An object of this type is returned by the files property of the HTML <input> element; this lets you access the list of files selected with the <input type=\"file\"> element. It's also used for a list of files dropped into web content when using the drag and drop API; see the DataTransfer object for details on this usage. */\ninterface FileList {\n    readonly length: number;\n    item(index: number): File | null;\n    [index: number]: File;\n}\n\ndeclare var FileList: {\n    prototype: FileList;\n    new(): FileList;\n};\n\ninterface FileReaderEventMap {\n    \"abort\": ProgressEvent<FileReader>;\n    \"error\": ProgressEvent<FileReader>;\n    \"load\": ProgressEvent<FileReader>;\n    \"loadend\": ProgressEvent<FileReader>;\n    \"loadstart\": ProgressEvent<FileReader>;\n    \"progress\": ProgressEvent<FileReader>;\n}\n\n/** Lets web applications asynchronously read the contents of files (or raw data buffers) stored on the user's computer, using File or Blob objects to specify the file or data to read. */\ninterface FileReader extends EventTarget {\n    readonly error: DOMException | null;\n    onabort: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    onerror: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    onload: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    onloadend: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    onloadstart: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    onprogress: ((this: FileReader, ev: ProgressEvent<FileReader>) => any) | null;\n    readonly readyState: number;\n    readonly result: string | ArrayBuffer | null;\n    abort(): void;\n    readAsArrayBuffer(blob: Blob): void;\n    readAsBinaryString(blob: Blob): void;\n    readAsDataURL(blob: Blob): void;\n    readAsText(blob: Blob, encoding?: string): void;\n    readonly DONE: number;\n    readonly EMPTY: number;\n    readonly LOADING: number;\n    addEventListener<K extends keyof FileReaderEventMap>(type: K, listener: (this: FileReader, ev: FileReaderEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof FileReaderEventMap>(type: K, listener: (this: FileReader, ev: FileReaderEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var FileReader: {\n    prototype: FileReader;\n    new(): FileReader;\n    readonly DONE: number;\n    readonly EMPTY: number;\n    readonly LOADING: number;\n};\n\n/** Focus-related events like focus, blur, focusin, or focusout. */\ninterface FocusEvent extends UIEvent {\n    readonly relatedTarget: EventTarget | null;\n}\n\ndeclare var FocusEvent: {\n    prototype: FocusEvent;\n    new(type: string, eventInitDict?: FocusEventInit): FocusEvent;\n};\n\ninterface FocusNavigationEvent extends Event {\n    readonly navigationReason: NavigationReason;\n    readonly originHeight: number;\n    readonly originLeft: number;\n    readonly originTop: number;\n    readonly originWidth: number;\n    requestFocus(): void;\n}\n\ndeclare var FocusNavigationEvent: {\n    prototype: FocusNavigationEvent;\n    new(type: string, eventInitDict?: FocusNavigationEventInit): FocusNavigationEvent;\n};\n\n/** Provides a way to easily construct a set of key/value pairs representing form fields and their values, which can then be easily sent using the XMLHttpRequest.send() method. It uses the same format a form would use if the encoding type were set to \"multipart/form-data\". */\ninterface FormData {\n    append(name: string, value: string | Blob, fileName?: string): void;\n    delete(name: string): void;\n    get(name: string): FormDataEntryValue | null;\n    getAll(name: string): FormDataEntryValue[];\n    has(name: string): boolean;\n    set(name: string, value: string | Blob, fileName?: string): void;\n    forEach(callbackfn: (value: FormDataEntryValue, key: string, parent: FormData) => void, thisArg?: any): void;\n}\n\ndeclare var FormData: {\n    prototype: FormData;\n    new(form?: HTMLFormElement): FormData;\n};\n\n/** A change in volume. It is an AudioNode audio-processing module that causes a given gain to be applied to the input data before its propagation to the output. A GainNode always has exactly one input and one output, both with the same number of channels. */\ninterface GainNode extends AudioNode {\n    readonly gain: AudioParam;\n}\n\ndeclare var GainNode: {\n    prototype: GainNode;\n    new(context: BaseAudioContext, options?: GainOptions): GainNode;\n};\n\n/** This Gamepad API interface defines an individual gamepad or other controller, allowing access to information such as button presses, axis positions, and id. */\ninterface Gamepad {\n    readonly axes: ReadonlyArray<number>;\n    readonly buttons: ReadonlyArray<GamepadButton>;\n    readonly connected: boolean;\n    readonly hand: GamepadHand;\n    readonly hapticActuators: ReadonlyArray<GamepadHapticActuator>;\n    readonly id: string;\n    readonly index: number;\n    readonly mapping: GamepadMappingType;\n    readonly pose: GamepadPose | null;\n    readonly timestamp: number;\n}\n\ndeclare var Gamepad: {\n    prototype: Gamepad;\n    new(): Gamepad;\n};\n\n/** An individual button of a gamepad or other controller, allowing access to the current state of different types of buttons available on the control device. */\ninterface GamepadButton {\n    readonly pressed: boolean;\n    readonly touched: boolean;\n    readonly value: number;\n}\n\ndeclare var GamepadButton: {\n    prototype: GamepadButton;\n    new(): GamepadButton;\n};\n\n/** This Gamepad API interface contains references to gamepads connected to the system, which is what the gamepad events Window.gamepadconnected and Window.gamepaddisconnected are fired in response to. */\ninterface GamepadEvent extends Event {\n    readonly gamepad: Gamepad;\n}\n\ndeclare var GamepadEvent: {\n    prototype: GamepadEvent;\n    new(type: string, eventInitDict: GamepadEventInit): GamepadEvent;\n};\n\n/** This Gamepad API interface represents hardware in the controller designed to provide haptic feedback to the user (if available), most commonly vibration hardware. */\ninterface GamepadHapticActuator {\n    readonly type: GamepadHapticActuatorType;\n    pulse(value: number, duration: number): Promise<boolean>;\n}\n\ndeclare var GamepadHapticActuator: {\n    prototype: GamepadHapticActuator;\n    new(): GamepadHapticActuator;\n};\n\n/** This Gamepad API interface represents the pose of a WebVR controller at a given timestamp (which includes orientation, position, velocity, and acceleration information.) */\ninterface GamepadPose {\n    readonly angularAcceleration: Float32Array | null;\n    readonly angularVelocity: Float32Array | null;\n    readonly hasOrientation: boolean;\n    readonly hasPosition: boolean;\n    readonly linearAcceleration: Float32Array | null;\n    readonly linearVelocity: Float32Array | null;\n    readonly orientation: Float32Array | null;\n    readonly position: Float32Array | null;\n}\n\ndeclare var GamepadPose: {\n    prototype: GamepadPose;\n    new(): GamepadPose;\n};\n\ninterface GenericTransformStream {\n    /**\n     * Returns a readable stream whose chunks are strings resulting from running encoding's decoder on the chunks written to writable.\n     */\n    readonly readable: ReadableStream;\n    /**\n     * Returns a writable stream which accepts [AllowShared] BufferSource chunks and runs them through encoding's decoder before making them available to readable.\n     * \n     * Typically this will be used via the pipeThrough() method on a ReadableStream source.\n     * \n     * ```\n     * var decoder = new TextDecoderStream(encoding);\n     * byteReadable\n     *   .pipeThrough(decoder)\n     *   .pipeTo(textWritable);\n     * ```\n     * \n     * If the error mode is \"fatal\" and encoding's decoder returns error, both readable and writable will be errored with a TypeError.\n     */\n    readonly writable: WritableStream;\n}\n\n/** An object able to programmatically obtain the position of the device. It gives Web content access to the location of the device. This allows a Web site or app to offer customized results based on the user's location. */\ninterface Geolocation {\n    clearWatch(watchId: number): void;\n    getCurrentPosition(successCallback: PositionCallback, errorCallback?: PositionErrorCallback, options?: PositionOptions): void;\n    watchPosition(successCallback: PositionCallback, errorCallback?: PositionErrorCallback, options?: PositionOptions): number;\n}\n\ndeclare var Geolocation: {\n    prototype: Geolocation;\n    new(): Geolocation;\n};\n\ninterface GeolocationCoordinates {\n    readonly accuracy: number;\n    readonly altitude: number | null;\n    readonly altitudeAccuracy: number | null;\n    readonly heading: number | null;\n    readonly latitude: number;\n    readonly longitude: number;\n    readonly speed: number | null;\n}\n\ndeclare var GeolocationCoordinates: {\n    prototype: GeolocationCoordinates;\n    new(): GeolocationCoordinates;\n};\n\ninterface GeolocationPosition {\n    readonly coords: GeolocationCoordinates;\n    readonly timestamp: number;\n}\n\ndeclare var GeolocationPosition: {\n    prototype: GeolocationPosition;\n    new(): GeolocationPosition;\n};\n\ninterface GeolocationPositionError {\n    readonly code: number;\n    readonly message: string;\n    readonly PERMISSION_DENIED: number;\n    readonly POSITION_UNAVAILABLE: number;\n    readonly TIMEOUT: number;\n}\n\ndeclare var GeolocationPositionError: {\n    prototype: GeolocationPositionError;\n    new(): GeolocationPositionError;\n    readonly PERMISSION_DENIED: number;\n    readonly POSITION_UNAVAILABLE: number;\n    readonly TIMEOUT: number;\n};\n\ninterface GlobalEventHandlersEventMap {\n    \"abort\": UIEvent;\n    \"animationcancel\": AnimationEvent;\n    \"animationend\": AnimationEvent;\n    \"animationiteration\": AnimationEvent;\n    \"animationstart\": AnimationEvent;\n    \"auxclick\": MouseEvent;\n    \"blur\": FocusEvent;\n    \"cancel\": Event;\n    \"canplay\": Event;\n    \"canplaythrough\": Event;\n    \"change\": Event;\n    \"click\": MouseEvent;\n    \"close\": Event;\n    \"contextmenu\": MouseEvent;\n    \"cuechange\": Event;\n    \"dblclick\": MouseEvent;\n    \"drag\": DragEvent;\n    \"dragend\": DragEvent;\n    \"dragenter\": DragEvent;\n    \"dragexit\": Event;\n    \"dragleave\": DragEvent;\n    \"dragover\": DragEvent;\n    \"dragstart\": DragEvent;\n    \"drop\": DragEvent;\n    \"durationchange\": Event;\n    \"emptied\": Event;\n    \"ended\": Event;\n    \"error\": ErrorEvent;\n    \"focus\": FocusEvent;\n    \"focusin\": FocusEvent;\n    \"focusout\": FocusEvent;\n    \"gotpointercapture\": PointerEvent;\n    \"input\": Event;\n    \"invalid\": Event;\n    \"keydown\": KeyboardEvent;\n    \"keypress\": KeyboardEvent;\n    \"keyup\": KeyboardEvent;\n    \"load\": Event;\n    \"loadeddata\": Event;\n    \"loadedmetadata\": Event;\n    \"loadstart\": Event;\n    \"lostpointercapture\": PointerEvent;\n    \"mousedown\": MouseEvent;\n    \"mouseenter\": MouseEvent;\n    \"mouseleave\": MouseEvent;\n    \"mousemove\": MouseEvent;\n    \"mouseout\": MouseEvent;\n    \"mouseover\": MouseEvent;\n    \"mouseup\": MouseEvent;\n    \"pause\": Event;\n    \"play\": Event;\n    \"playing\": Event;\n    \"pointercancel\": PointerEvent;\n    \"pointerdown\": PointerEvent;\n    \"pointerenter\": PointerEvent;\n    \"pointerleave\": PointerEvent;\n    \"pointermove\": PointerEvent;\n    \"pointerout\": PointerEvent;\n    \"pointerover\": PointerEvent;\n    \"pointerup\": PointerEvent;\n    \"progress\": ProgressEvent;\n    \"ratechange\": Event;\n    \"reset\": Event;\n    \"resize\": UIEvent;\n    \"scroll\": Event;\n    \"securitypolicyviolation\": SecurityPolicyViolationEvent;\n    \"seeked\": Event;\n    \"seeking\": Event;\n    \"select\": Event;\n    \"selectionchange\": Event;\n    \"selectstart\": Event;\n    \"stalled\": Event;\n    \"submit\": Event;\n    \"suspend\": Event;\n    \"timeupdate\": Event;\n    \"toggle\": Event;\n    \"touchcancel\": TouchEvent;\n    \"touchend\": TouchEvent;\n    \"touchmove\": TouchEvent;\n    \"touchstart\": TouchEvent;\n    \"transitioncancel\": TransitionEvent;\n    \"transitionend\": TransitionEvent;\n    \"transitionrun\": TransitionEvent;\n    \"transitionstart\": TransitionEvent;\n    \"volumechange\": Event;\n    \"waiting\": Event;\n    \"wheel\": WheelEvent;\n}\n\ninterface GlobalEventHandlers {\n    /**\n     * Fires when the user aborts the download.\n     * @param ev The event.\n     */\n    onabort: ((this: GlobalEventHandlers, ev: UIEvent) => any) | null;\n    onanimationcancel: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;\n    onanimationend: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;\n    onanimationiteration: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;\n    onanimationstart: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;\n    onauxclick: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /**\n     * Fires when the object loses the input focus.\n     * @param ev The focus event.\n     */\n    onblur: ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null;\n    oncancel: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when playback is possible, but would require further buffering.\n     * @param ev The event.\n     */\n    oncanplay: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    oncanplaythrough: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when the contents of the object or selection have changed.\n     * @param ev The event.\n     */\n    onchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when the user clicks the left mouse button on the object\n     * @param ev The mouse event.\n     */\n    onclick: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    onclose: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when the user clicks the right mouse button in the client area, opening the context menu.\n     * @param ev The mouse event.\n     */\n    oncontextmenu: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    oncuechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when the user double-clicks the object.\n     * @param ev The mouse event.\n     */\n    ondblclick: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /**\n     * Fires on the source object continuously during a drag operation.\n     * @param ev The event.\n     */\n    ondrag: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /**\n     * Fires on the source object when the user releases the mouse at the close of a drag operation.\n     * @param ev The event.\n     */\n    ondragend: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /**\n     * Fires on the target element when the user drags the object to a valid drop target.\n     * @param ev The drag event.\n     */\n    ondragenter: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    ondragexit: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires on the target object when the user moves the mouse out of a valid drop target during a drag operation.\n     * @param ev The drag event.\n     */\n    ondragleave: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /**\n     * Fires on the target element continuously while the user drags the object over a valid drop target.\n     * @param ev The event.\n     */\n    ondragover: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /**\n     * Fires on the source object when the user starts to drag a text selection or selected object.\n     * @param ev The event.\n     */\n    ondragstart: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    ondrop: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;\n    /**\n     * Occurs when the duration attribute is updated.\n     * @param ev The event.\n     */\n    ondurationchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when the media element is reset to its initial state.\n     * @param ev The event.\n     */\n    onemptied: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when the end of playback is reached.\n     * @param ev The event\n     */\n    onended: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when an error occurs during object loading.\n     * @param ev The event.\n     */\n    onerror: OnErrorEventHandler;\n    /**\n     * Fires when the object receives focus.\n     * @param ev The event.\n     */\n    onfocus: ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null;\n    ongotpointercapture: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    oninput: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    oninvalid: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when the user presses a key.\n     * @param ev The keyboard event\n     */\n    onkeydown: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;\n    /**\n     * Fires when the user presses an alphanumeric key.\n     * @param ev The event.\n     */\n    onkeypress: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;\n    /**\n     * Fires when the user releases a key.\n     * @param ev The keyboard event\n     */\n    onkeyup: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;\n    /**\n     * Fires immediately after the browser loads the object.\n     * @param ev The event.\n     */\n    onload: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when media data is loaded at the current playback position.\n     * @param ev The event.\n     */\n    onloadeddata: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when the duration and dimensions of the media have been determined.\n     * @param ev The event.\n     */\n    onloadedmetadata: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when Internet Explorer begins looking for media data.\n     * @param ev The event.\n     */\n    onloadstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onlostpointercapture: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /**\n     * Fires when the user clicks the object with either mouse button.\n     * @param ev The mouse event.\n     */\n    onmousedown: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    onmouseenter: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    onmouseleave: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /**\n     * Fires when the user moves the mouse over the object.\n     * @param ev The mouse event.\n     */\n    onmousemove: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /**\n     * Fires when the user moves the mouse pointer outside the boundaries of the object.\n     * @param ev The mouse event.\n     */\n    onmouseout: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /**\n     * Fires when the user moves the mouse pointer into the object.\n     * @param ev The mouse event.\n     */\n    onmouseover: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /**\n     * Fires when the user releases a mouse button while the mouse is over the object.\n     * @param ev The mouse event.\n     */\n    onmouseup: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;\n    /**\n     * Occurs when playback is paused.\n     * @param ev The event.\n     */\n    onpause: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when the play method is requested.\n     * @param ev The event.\n     */\n    onplay: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when the audio or video has started playing.\n     * @param ev The event.\n     */\n    onplaying: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onpointercancel: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    onpointerdown: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    onpointerenter: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    onpointerleave: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    onpointermove: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    onpointerout: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    onpointerover: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    onpointerup: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;\n    /**\n     * Occurs to indicate progress while downloading media data.\n     * @param ev The event.\n     */\n    onprogress: ((this: GlobalEventHandlers, ev: ProgressEvent) => any) | null;\n    /**\n     * Occurs when the playback rate is increased or decreased.\n     * @param ev The event.\n     */\n    onratechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when the user resets a form.\n     * @param ev The event.\n     */\n    onreset: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onresize: ((this: GlobalEventHandlers, ev: UIEvent) => any) | null;\n    /**\n     * Fires when the user repositions the scroll box in the scroll bar on the object.\n     * @param ev The event.\n     */\n    onscroll: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onsecuritypolicyviolation: ((this: GlobalEventHandlers, ev: SecurityPolicyViolationEvent) => any) | null;\n    /**\n     * Occurs when the seek operation ends.\n     * @param ev The event.\n     */\n    onseeked: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when the current playback position is moved.\n     * @param ev The event.\n     */\n    onseeking: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Fires when the current selection changes.\n     * @param ev The event.\n     */\n    onselect: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onselectionchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onselectstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when the download has stopped.\n     * @param ev The event.\n     */\n    onstalled: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onsubmit: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs if the load operation has been intentionally halted.\n     * @param ev The event.\n     */\n    onsuspend: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs to indicate the current playback position.\n     * @param ev The event.\n     */\n    ontimeupdate: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    ontoggle: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    ontouchcancel?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null;\n    ontouchend?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null;\n    ontouchmove?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null;\n    ontouchstart?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null;\n    ontransitioncancel: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;\n    ontransitionend: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;\n    ontransitionrun: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;\n    ontransitionstart: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;\n    /**\n     * Occurs when the volume is changed, or playback is muted or unmuted.\n     * @param ev The event.\n     */\n    onvolumechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    /**\n     * Occurs when playback stops because the next frame of a video resource is not available.\n     * @param ev The event.\n     */\n    onwaiting: ((this: GlobalEventHandlers, ev: Event) => any) | null;\n    onwheel: ((this: GlobalEventHandlers, ev: WheelEvent) => any) | null;\n    addEventListener<K extends keyof GlobalEventHandlersEventMap>(type: K, listener: (this: GlobalEventHandlers, ev: GlobalEventHandlersEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof GlobalEventHandlersEventMap>(type: K, listener: (this: GlobalEventHandlers, ev: GlobalEventHandlersEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ninterface HTMLAllCollection {\n    /**\n     * Returns the number of elements in the collection.\n     */\n    readonly length: number;\n    /**\n     * Returns the item with index index from the collection (determined by tree order).\n     */\n    item(nameOrIndex?: string): HTMLCollection | Element | null;\n    /**\n     * Returns the item with ID or name name from the collection.\n     * \n     * If there are multiple matching items, then an HTMLCollection object containing all those elements is returned.\n     * \n     * Only button, form, iframe, input, map, meta, object, select, and textarea elements can have a name for the purpose of this method; their name is given by the value of their name attribute.\n     */\n    namedItem(name: string): HTMLCollection | Element | null;\n    [index: number]: Element;\n}\n\ndeclare var HTMLAllCollection: {\n    prototype: HTMLAllCollection;\n    new(): HTMLAllCollection;\n};\n\n/** Hyperlink elements and provides special properties and methods (beyond those of the regular HTMLElement object interface that they inherit from) for manipulating the layout and presentation of such elements. */\ninterface HTMLAnchorElement extends HTMLElement, HTMLHyperlinkElementUtils {\n    /**\n     * Sets or retrieves the character set used to encode the object.\n     */\n    /** @deprecated */\n    charset: string;\n    /**\n     * Sets or retrieves the coordinates of the object.\n     */\n    /** @deprecated */\n    coords: string;\n    download: string;\n    /**\n     * Sets or retrieves the language code of the object.\n     */\n    hreflang: string;\n    /**\n     * Sets or retrieves the shape of the object.\n     */\n    /** @deprecated */\n    name: string;\n    ping: string;\n    referrerPolicy: string;\n    /**\n     * Sets or retrieves the relationship between the object and the destination of the link.\n     */\n    rel: string;\n    readonly relList: DOMTokenList;\n    /**\n     * Sets or retrieves the relationship between the object and the destination of the link.\n     */\n    /** @deprecated */\n    rev: string;\n    /**\n     * Sets or retrieves the shape of the object.\n     */\n    /** @deprecated */\n    shape: string;\n    /**\n     * Sets or retrieves the window or frame at which to target content.\n     */\n    target: string;\n    /**\n     * Retrieves or sets the text of the object as a string.\n     */\n    text: string;\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAnchorElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAnchorElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLAnchorElement: {\n    prototype: HTMLAnchorElement;\n    new(): HTMLAnchorElement;\n};\n\ninterface HTMLAppletElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    /**\n     * Sets or retrieves a text alternative to the graphic.\n     */\n    /** @deprecated */\n    alt: string;\n    /**\n     * Sets or retrieves a character string that can be used to implement your own archive functionality for the object.\n     */\n    /** @deprecated */\n    archive: string;\n    /** @deprecated */\n    code: string;\n    /**\n     * Sets or retrieves the URL of the component.\n     */\n    /** @deprecated */\n    codeBase: string;\n    readonly form: HTMLFormElement | null;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    /** @deprecated */\n    height: string;\n    /** @deprecated */\n    hspace: number;\n    /**\n     * Sets or retrieves the shape of the object.\n     */\n    /** @deprecated */\n    name: string;\n    /** @deprecated */\n    object: string;\n    /** @deprecated */\n    vspace: number;\n    /** @deprecated */\n    width: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAppletElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAppletElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLAppletElement: {\n    prototype: HTMLAppletElement;\n    new(): HTMLAppletElement;\n};\n\n/** Provides special properties and methods (beyond those of the regular object HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of <area> elements. */\ninterface HTMLAreaElement extends HTMLElement, HTMLHyperlinkElementUtils {\n    /**\n     * Sets or retrieves a text alternative to the graphic.\n     */\n    alt: string;\n    /**\n     * Sets or retrieves the coordinates of the object.\n     */\n    coords: string;\n    download: string;\n    /**\n     * Sets or gets whether clicks in this region cause action.\n     */\n    /** @deprecated */\n    noHref: boolean;\n    ping: string;\n    referrerPolicy: string;\n    rel: string;\n    readonly relList: DOMTokenList;\n    /**\n     * Sets or retrieves the shape of the object.\n     */\n    shape: string;\n    /**\n     * Sets or retrieves the window or frame at which to target content.\n     */\n    target: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLAreaElement: {\n    prototype: HTMLAreaElement;\n    new(): HTMLAreaElement;\n};\n\n/** Provides access to the properties of <audio> elements, as well as methods to manipulate them. It derives from the HTMLMediaElement interface. */\ninterface HTMLAudioElement extends HTMLMediaElement {\n    addEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLAudioElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLAudioElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLAudioElement: {\n    prototype: HTMLAudioElement;\n    new(): HTMLAudioElement;\n};\n\n/** A HTML line break element (<br>). It inherits from HTMLElement. */\ninterface HTMLBRElement extends HTMLElement {\n    /**\n     * Sets or retrieves the side on which floating objects are not to be positioned when any IHTMLBlockElement is inserted into the document.\n     */\n    /** @deprecated */\n    clear: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLBRElement: {\n    prototype: HTMLBRElement;\n    new(): HTMLBRElement;\n};\n\n/** Contains the base URI for a document. This object inherits all of the properties and methods as described in the HTMLElement interface. */\ninterface HTMLBaseElement extends HTMLElement {\n    /**\n     * Gets or sets the baseline URL on which relative links are based.\n     */\n    href: string;\n    /**\n     * Sets or retrieves the window or frame at which to target content.\n     */\n    target: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBaseElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBaseElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLBaseElement: {\n    prototype: HTMLBaseElement;\n    new(): HTMLBaseElement;\n};\n\n/** Provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <basefont> elements. */\ninterface HTMLBaseFontElement extends HTMLElement, DOML2DeprecatedColorProperty {\n    /**\n     * Sets or retrieves the current typeface family.\n     */\n    /** @deprecated */\n    face: string;\n    /**\n     * Sets or retrieves the font size of the object.\n     */\n    /** @deprecated */\n    size: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBaseFontElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLBaseFontElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLBaseFontElement: {\n    prototype: HTMLBaseFontElement;\n    new(): HTMLBaseFontElement;\n};\n\ninterface HTMLBodyElementEventMap extends HTMLElementEventMap, WindowEventHandlersEventMap {\n    \"orientationchange\": Event;\n}\n\n/** Provides special properties (beyond those inherited from the regular HTMLElement interface) for manipulating <body> elements. */\ninterface HTMLBodyElement extends HTMLElement, WindowEventHandlers {\n    /** @deprecated */\n    aLink: string;\n    /** @deprecated */\n    background: string;\n    /** @deprecated */\n    bgColor: string;\n    /** @deprecated */\n    link: string;\n    /** @deprecated */\n    onorientationchange: ((this: HTMLBodyElement, ev: Event) => any) | null;\n    /** @deprecated */\n    text: string;\n    /** @deprecated */\n    vLink: string;\n    addEventListener<K extends keyof HTMLBodyElementEventMap>(type: K, listener: (this: HTMLBodyElement, ev: HTMLBodyElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLBodyElementEventMap>(type: K, listener: (this: HTMLBodyElement, ev: HTMLBodyElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLBodyElement: {\n    prototype: HTMLBodyElement;\n    new(): HTMLBodyElement;\n};\n\n/** Provides properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <button> elements. */\ninterface HTMLButtonElement extends HTMLElement {\n    disabled: boolean;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * Overrides the action attribute (where the data on a form is sent) on the parent form element.\n     */\n    formAction: string;\n    /**\n     * Used to override the encoding (formEnctype attribute) specified on the form element.\n     */\n    formEnctype: string;\n    /**\n     * Overrides the submit method attribute previously specified on a form element.\n     */\n    formMethod: string;\n    /**\n     * Overrides any validation or required attributes on a form or form elements to allow it to be submitted without validation. This can be used to create a \"save draft\"-type submit option.\n     */\n    formNoValidate: boolean;\n    /**\n     * Overrides the target attribute on a form element.\n     */\n    formTarget: string;\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    /**\n     * Gets the classification and default behavior of the button.\n     */\n    type: string;\n    /**\n     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting.\n     */\n    readonly validationMessage: string;\n    /**\n     * Returns a  ValidityState object that represents the validity states of an element.\n     */\n    readonly validity: ValidityState;\n    /**\n     * Sets or retrieves the default or selected value of the control.\n     */\n    value: string;\n    /**\n     * Returns whether an element will successfully validate based on forms validation rules and constraints.\n     */\n    readonly willValidate: boolean;\n    /**\n     * Returns whether a form will validate when it is submitted, without having to submit it.\n     */\n    checkValidity(): boolean;\n    reportValidity(): boolean;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLButtonElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLButtonElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLButtonElement: {\n    prototype: HTMLButtonElement;\n    new(): HTMLButtonElement;\n};\n\n/** Provides properties and methods for manipulating the layout and presentation of <canvas> elements. The HTMLCanvasElement interface also inherits the properties and methods of the HTMLElement interface. */\ninterface HTMLCanvasElement extends HTMLElement {\n    /**\n     * Gets or sets the height of a canvas element on a document.\n     */\n    height: number;\n    /**\n     * Gets or sets the width of a canvas element on a document.\n     */\n    width: number;\n    /**\n     * Returns an object that provides methods and properties for drawing and manipulating images and graphics on a canvas element in a document. A context object includes information about colors, line widths, fonts, and other graphic parameters that can be drawn on a canvas.\n     * @param contextId The identifier (ID) of the type of canvas to create. Internet Explorer 9 and Internet Explorer 10 support only a 2-D context using canvas.getContext(\"2d\"); IE11 Preview also supports 3-D or WebGL context using canvas.getContext(\"experimental-webgl\");\n     */\n    getContext(contextId: \"2d\", options?: CanvasRenderingContext2DSettings): CanvasRenderingContext2D | null;\n    getContext(contextId: \"bitmaprenderer\", options?: ImageBitmapRenderingContextSettings): ImageBitmapRenderingContext | null;\n    getContext(contextId: \"webgl\", options?: WebGLContextAttributes): WebGLRenderingContext | null;\n    getContext(contextId: \"webgl2\", options?: WebGLContextAttributes): WebGL2RenderingContext | null;\n    getContext(contextId: string, options?: any): RenderingContext | null;\n    toBlob(callback: BlobCallback, type?: string, quality?: any): void;\n    /**\n     * Returns the content of the current canvas as an image that you can use as a source for another canvas or an HTML element.\n     * @param type The standard MIME type for the image format to return. If you do not specify this parameter, the default value is a PNG format image.\n     */\n    toDataURL(type?: string, quality?: any): string;\n    transferControlToOffscreen(): OffscreenCanvas;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLCanvasElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLCanvasElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLCanvasElement: {\n    prototype: HTMLCanvasElement;\n    new(): HTMLCanvasElement;\n};\n\n/** A generic collection (array-like object similar to arguments) of elements (in document order) and offers methods and properties for selecting from the list. */\ninterface HTMLCollectionBase {\n    /**\n     * Sets or retrieves the number of objects in a collection.\n     */\n    readonly length: number;\n    /**\n     * Retrieves an object from various collections.\n     */\n    item(index: number): Element | null;\n    [index: number]: Element;\n}\n\ninterface HTMLCollection extends HTMLCollectionBase {\n    /**\n     * Retrieves a select object or an object from an options collection.\n     */\n    namedItem(name: string): Element | null;\n}\n\ndeclare var HTMLCollection: {\n    prototype: HTMLCollection;\n    new(): HTMLCollection;\n};\n\ninterface HTMLCollectionOf<T extends Element> extends HTMLCollectionBase {\n    item(index: number): T | null;\n    namedItem(name: string): T | null;\n    [index: number]: T;\n}\n\n/** Provides special properties (beyond those of the regular HTMLElement interface it also has available to it by inheritance) for manipulating definition list (<dl>) elements. */\ninterface HTMLDListElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDListElement: {\n    prototype: HTMLDListElement;\n    new(): HTMLDListElement;\n};\n\n/** Provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <data> elements. */\ninterface HTMLDataElement extends HTMLElement {\n    value: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDataElement: {\n    prototype: HTMLDataElement;\n    new(): HTMLDataElement;\n};\n\n/** Provides special properties (beyond the HTMLElement object interface it also has available to it by inheritance) to manipulate <datalist> elements and their content. */\ninterface HTMLDataListElement extends HTMLElement {\n    readonly options: HTMLCollectionOf<HTMLOptionElement>;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDataListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDataListElement: {\n    prototype: HTMLDataListElement;\n    new(): HTMLDataListElement;\n};\n\ninterface HTMLDetailsElement extends HTMLElement {\n    open: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDetailsElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDetailsElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDetailsElement: {\n    prototype: HTMLDetailsElement;\n    new(): HTMLDetailsElement;\n};\n\ninterface HTMLDialogElement extends HTMLElement {\n    open: boolean;\n    returnValue: string;\n    close(returnValue?: string): void;\n    show(): void;\n    showModal(): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDialogElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDialogElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDialogElement: {\n    prototype: HTMLDialogElement;\n    new(): HTMLDialogElement;\n};\n\ninterface HTMLDirectoryElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDirectoryElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDirectoryElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDirectoryElement: {\n    prototype: HTMLDirectoryElement;\n    new(): HTMLDirectoryElement;\n};\n\n/** Provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <div> elements. */\ninterface HTMLDivElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    /** @deprecated */\n    align: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDivElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLDivElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDivElement: {\n    prototype: HTMLDivElement;\n    new(): HTMLDivElement;\n};\n\n/** The HTMLDocument property of Window objects is an alias that browsers expose for the Document interface object. */\ninterface HTMLDocument extends Document {\n    addEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: HTMLDocument, ev: DocumentEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: HTMLDocument, ev: DocumentEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLDocument: {\n    prototype: HTMLDocument;\n    new(): HTMLDocument;\n};\n\ninterface HTMLElementEventMap extends ElementEventMap, GlobalEventHandlersEventMap, DocumentAndElementEventHandlersEventMap {\n}\n\n/** Any HTML element. Some elements directly implement this interface, while others implement it via an interface that inherits it. */\ninterface HTMLElement extends Element, DocumentAndElementEventHandlers, ElementCSSInlineStyle, ElementCSSInlineStyle, ElementContentEditable, GlobalEventHandlers, HTMLOrSVGElement {\n    accessKey: string;\n    readonly accessKeyLabel: string;\n    autocapitalize: string;\n    dir: string;\n    draggable: boolean;\n    hidden: boolean;\n    innerText: string;\n    lang: string;\n    readonly offsetHeight: number;\n    readonly offsetLeft: number;\n    readonly offsetParent: Element | null;\n    readonly offsetTop: number;\n    readonly offsetWidth: number;\n    spellcheck: boolean;\n    title: string;\n    translate: boolean;\n    click(): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLElement: {\n    prototype: HTMLElement;\n    new(): HTMLElement;\n};\n\n/** Provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <embed> elements. */\ninterface HTMLEmbedElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: string;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    /** @deprecated */\n    name: string;\n    /**\n     * Sets or retrieves a URL to be loaded by the object.\n     */\n    src: string;\n    type: string;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: string;\n    getSVGDocument(): Document | null;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLEmbedElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLEmbedElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLEmbedElement: {\n    prototype: HTMLEmbedElement;\n    new(): HTMLEmbedElement;\n};\n\n/** Provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of <fieldset> elements. */\ninterface HTMLFieldSetElement extends HTMLElement {\n    disabled: boolean;\n    readonly elements: HTMLCollection;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement | null;\n    name: string;\n    readonly type: string;\n    /**\n     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting.\n     */\n    readonly validationMessage: string;\n    /**\n     * Returns a  ValidityState object that represents the validity states of an element.\n     */\n    readonly validity: ValidityState;\n    /**\n     * Returns whether an element will successfully validate based on forms validation rules and constraints.\n     */\n    readonly willValidate: boolean;\n    /**\n     * Returns whether a form will validate when it is submitted, without having to submit it.\n     */\n    checkValidity(): boolean;\n    reportValidity(): boolean;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFieldSetElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFieldSetElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLFieldSetElement: {\n    prototype: HTMLFieldSetElement;\n    new(): HTMLFieldSetElement;\n};\n\n/** Implements the document object model (DOM) representation of the font element. The HTML Font Element <font> defines the font size, font face and color of text. */\ninterface HTMLFontElement extends HTMLElement {\n    /** @deprecated */\n    color: string;\n    /**\n     * Sets or retrieves the current typeface family.\n     */\n    /** @deprecated */\n    face: string;\n    /** @deprecated */\n    size: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFontElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFontElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLFontElement: {\n    prototype: HTMLFontElement;\n    new(): HTMLFontElement;\n};\n\n/** A collection of HTML form control elements.  */\ninterface HTMLFormControlsCollection extends HTMLCollectionBase {\n    /**\n     * Returns the item with ID or name name from the collection.\n     * \n     * If there are multiple matching items, then a RadioNodeList object containing all those elements is returned.\n     */\n    namedItem(name: string): RadioNodeList | Element | null;\n}\n\ndeclare var HTMLFormControlsCollection: {\n    prototype: HTMLFormControlsCollection;\n    new(): HTMLFormControlsCollection;\n};\n\n/** A <form> element in the DOM; it allows access to and in some cases modification of aspects of the form, as well as access to its component elements. */\ninterface HTMLFormElement extends HTMLElement {\n    /**\n     * Sets or retrieves a list of character encodings for input data that must be accepted by the server processing the form.\n     */\n    acceptCharset: string;\n    /**\n     * Sets or retrieves the URL to which the form content is sent for processing.\n     */\n    action: string;\n    /**\n     * Specifies whether autocomplete is applied to an editable text field.\n     */\n    autocomplete: string;\n    /**\n     * Retrieves a collection, in source order, of all controls in a given form.\n     */\n    readonly elements: HTMLFormControlsCollection;\n    /**\n     * Sets or retrieves the MIME encoding for the form.\n     */\n    encoding: string;\n    /**\n     * Sets or retrieves the encoding type for the form.\n     */\n    enctype: string;\n    /**\n     * Sets or retrieves the number of objects in a collection.\n     */\n    readonly length: number;\n    /**\n     * Sets or retrieves how to send the form data to the server.\n     */\n    method: string;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    /**\n     * Designates a form that is not validated when submitted.\n     */\n    noValidate: boolean;\n    /**\n     * Sets or retrieves the window or frame at which to target content.\n     */\n    target: string;\n    /**\n     * Returns whether a form will validate when it is submitted, without having to submit it.\n     */\n    checkValidity(): boolean;\n    reportValidity(): boolean;\n    /**\n     * Fires when the user resets a form.\n     */\n    reset(): void;\n    /**\n     * Fires when a FORM is about to be submitted.\n     */\n    submit(): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFormElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFormElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n    [index: number]: Element;\n    [name: string]: any;\n}\n\ndeclare var HTMLFormElement: {\n    prototype: HTMLFormElement;\n    new(): HTMLFormElement;\n};\n\ninterface HTMLFrameElement extends HTMLElement {\n    /**\n     * Retrieves the document object of the page or frame.\n     */\n    /** @deprecated */\n    readonly contentDocument: Document | null;\n    /**\n     * Retrieves the object of the specified.\n     */\n    /** @deprecated */\n    readonly contentWindow: WindowProxy | null;\n    /**\n     * Sets or retrieves whether to display a border for the frame.\n     */\n    /** @deprecated */\n    frameBorder: string;\n    /**\n     * Sets or retrieves a URI to a long description of the object.\n     */\n    /** @deprecated */\n    longDesc: string;\n    /**\n     * Sets or retrieves the top and bottom margin heights before displaying the text in a frame.\n     */\n    /** @deprecated */\n    marginHeight: string;\n    /**\n     * Sets or retrieves the left and right margin widths before displaying the text in a frame.\n     */\n    /** @deprecated */\n    marginWidth: string;\n    /**\n     * Sets or retrieves the frame name.\n     */\n    /** @deprecated */\n    name: string;\n    /**\n     * Sets or retrieves whether the user can resize the frame.\n     */\n    /** @deprecated */\n    noResize: boolean;\n    /**\n     * Sets or retrieves whether the frame can be scrolled.\n     */\n    /** @deprecated */\n    scrolling: string;\n    /**\n     * Sets or retrieves a URL to be loaded by the object.\n     */\n    /** @deprecated */\n    src: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLFrameElement: {\n    prototype: HTMLFrameElement;\n    new(): HTMLFrameElement;\n};\n\ninterface HTMLFrameSetElementEventMap extends HTMLElementEventMap, WindowEventHandlersEventMap {\n}\n\n/** Provides special properties (beyond those of the regular HTMLElement interface they also inherit) for manipulating <frameset> elements. */\ninterface HTMLFrameSetElement extends HTMLElement, WindowEventHandlers {\n    /**\n     * Sets or retrieves the frame widths of the object.\n     */\n    /** @deprecated */\n    cols: string;\n    /**\n     * Sets or retrieves the frame heights of the object.\n     */\n    /** @deprecated */\n    rows: string;\n    addEventListener<K extends keyof HTMLFrameSetElementEventMap>(type: K, listener: (this: HTMLFrameSetElement, ev: HTMLFrameSetElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLFrameSetElementEventMap>(type: K, listener: (this: HTMLFrameSetElement, ev: HTMLFrameSetElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLFrameSetElement: {\n    prototype: HTMLFrameSetElement;\n    new(): HTMLFrameSetElement;\n};\n\n/** Provides special properties (beyond those of the HTMLElement interface it also has available to it by inheritance) for manipulating <hr> elements. */\ninterface HTMLHRElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    /** @deprecated */\n    align: string;\n    /** @deprecated */\n    color: string;\n    /**\n     * Sets or retrieves whether the horizontal rule is drawn with 3-D shading.\n     */\n    /** @deprecated */\n    noShade: boolean;\n    /** @deprecated */\n    size: string;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    /** @deprecated */\n    width: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHRElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLHRElement: {\n    prototype: HTMLHRElement;\n    new(): HTMLHRElement;\n};\n\n/** Contains the descriptive information, or metadata, for a document. This object inherits all of the properties and methods described in the HTMLElement interface. */\ninterface HTMLHeadElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLHeadElement: {\n    prototype: HTMLHeadElement;\n    new(): HTMLHeadElement;\n};\n\n/** The different heading elements. It inherits methods and properties from the HTMLElement interface. */\ninterface HTMLHeadingElement extends HTMLElement {\n    /**\n     * Sets or retrieves a value that indicates the table alignment.\n     */\n    /** @deprecated */\n    align: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadingElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHeadingElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLHeadingElement: {\n    prototype: HTMLHeadingElement;\n    new(): HTMLHeadingElement;\n};\n\n/** Serves as the root node for a given HTML document. This object inherits the properties and methods described in the HTMLElement interface. */\ninterface HTMLHtmlElement extends HTMLElement {\n    /**\n     * Sets or retrieves the DTD version that governs the current document.\n     */\n    /** @deprecated */\n    version: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHtmlElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLHtmlElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLHtmlElement: {\n    prototype: HTMLHtmlElement;\n    new(): HTMLHtmlElement;\n};\n\ninterface HTMLHyperlinkElementUtils {\n    hash: string;\n    host: string;\n    hostname: string;\n    href: string;\n    toString(): string;\n    readonly origin: string;\n    password: string;\n    pathname: string;\n    port: string;\n    protocol: string;\n    search: string;\n    username: string;\n}\n\n/** Provides special properties and methods (beyond those of the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of inline frame elements. */\ninterface HTMLIFrameElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    /** @deprecated */\n    align: string;\n    allow: string;\n    allowFullscreen: boolean;\n    allowPaymentRequest: boolean;\n    /**\n     * Retrieves the document object of the page or frame.\n     */\n    readonly contentDocument: Document | null;\n    /**\n     * Retrieves the object of the specified.\n     */\n    readonly contentWindow: WindowProxy | null;\n    /**\n     * Sets or retrieves whether to display a border for the frame.\n     */\n    /** @deprecated */\n    frameBorder: string;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: string;\n    /**\n     * Sets or retrieves a URI to a long description of the object.\n     */\n    /** @deprecated */\n    longDesc: string;\n    /**\n     * Sets or retrieves the top and bottom margin heights before displaying the text in a frame.\n     */\n    /** @deprecated */\n    marginHeight: string;\n    /**\n     * Sets or retrieves the left and right margin widths before displaying the text in a frame.\n     */\n    /** @deprecated */\n    marginWidth: string;\n    /**\n     * Sets or retrieves the frame name.\n     */\n    name: string;\n    referrerPolicy: ReferrerPolicy;\n    readonly sandbox: DOMTokenList;\n    /**\n     * Sets or retrieves whether the frame can be scrolled.\n     */\n    /** @deprecated */\n    scrolling: string;\n    /**\n     * Sets or retrieves a URL to be loaded by the object.\n     */\n    src: string;\n    /**\n     * Sets or retrives the content of the page that is to contain.\n     */\n    srcdoc: string;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: string;\n    getSVGDocument(): Document | null;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLIFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLIFrameElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLIFrameElement: {\n    prototype: HTMLIFrameElement;\n    new(): HTMLIFrameElement;\n};\n\n/** Provides special properties and methods for manipulating <img> elements. */\ninterface HTMLImageElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    /** @deprecated */\n    align: string;\n    /**\n     * Sets or retrieves a text alternative to the graphic.\n     */\n    alt: string;\n    /**\n     * Specifies the properties of a border drawn around an object.\n     */\n    /** @deprecated */\n    border: string;\n    /**\n     * Retrieves whether the object is fully loaded.\n     */\n    readonly complete: boolean;\n    crossOrigin: string | null;\n    readonly currentSrc: string;\n    decoding: \"async\" | \"sync\" | \"auto\";\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: number;\n    /**\n     * Sets or retrieves the width of the border to draw around the object.\n     */\n    /** @deprecated */\n    hspace: number;\n    /**\n     * Sets or retrieves whether the image is a server-side image map.\n     */\n    isMap: boolean;\n    loading: string;\n    /**\n     * Sets or retrieves a Uniform Resource Identifier (URI) to a long description of the object.\n     */\n    /** @deprecated */\n    longDesc: string;\n    /** @deprecated */\n    lowsrc: string;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    /** @deprecated */\n    name: string;\n    /**\n     * The original height of the image resource before sizing.\n     */\n    readonly naturalHeight: number;\n    /**\n     * The original width of the image resource before sizing.\n     */\n    readonly naturalWidth: number;\n    referrerPolicy: string;\n    sizes: string;\n    /**\n     * The address or URL of the a media resource that is to be considered.\n     */\n    src: string;\n    srcset: string;\n    /**\n     * Sets or retrieves the URL, often with a bookmark extension (#name), to use as a client-side image map.\n     */\n    useMap: string;\n    /**\n     * Sets or retrieves the vertical margin for the object.\n     */\n    /** @deprecated */\n    vspace: number;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: number;\n    readonly x: number;\n    readonly y: number;\n    decode(): Promise<void>;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLImageElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLImageElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLImageElement: {\n    prototype: HTMLImageElement;\n    new(): HTMLImageElement;\n};\n\n/** Provides special properties and methods for manipulating the options, layout, and presentation of <input> elements. */\ninterface HTMLInputElement extends HTMLElement {\n    /**\n     * Sets or retrieves a comma-separated list of content types.\n     */\n    accept: string;\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    /** @deprecated */\n    align: string;\n    /**\n     * Sets or retrieves a text alternative to the graphic.\n     */\n    alt: string;\n    /**\n     * Specifies whether autocomplete is applied to an editable text field.\n     */\n    autocomplete: string;\n    /**\n     * Sets or retrieves the state of the check box or radio button.\n     */\n    checked: boolean;\n    /**\n     * Sets or retrieves the state of the check box or radio button.\n     */\n    defaultChecked: boolean;\n    /**\n     * Sets or retrieves the initial contents of the object.\n     */\n    defaultValue: string;\n    dirName: string;\n    disabled: boolean;\n    /**\n     * Returns a FileList object on a file type input object.\n     */\n    files: FileList | null;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * Overrides the action attribute (where the data on a form is sent) on the parent form element.\n     */\n    formAction: string;\n    /**\n     * Used to override the encoding (formEnctype attribute) specified on the form element.\n     */\n    formEnctype: string;\n    /**\n     * Overrides the submit method attribute previously specified on a form element.\n     */\n    formMethod: string;\n    /**\n     * Overrides any validation or required attributes on a form or form elements to allow it to be submitted without validation. This can be used to create a \"save draft\"-type submit option.\n     */\n    formNoValidate: boolean;\n    /**\n     * Overrides the target attribute on a form element.\n     */\n    formTarget: string;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: number;\n    indeterminate: boolean;\n    readonly labels: NodeListOf<HTMLLabelElement> | null;\n    /**\n     * Specifies the ID of a pre-defined datalist of options for an input element.\n     */\n    readonly list: HTMLElement | null;\n    /**\n     * Defines the maximum acceptable value for an input element with type=\"number\".When used with the min and step attributes, lets you control the range and increment (such as only even numbers) that the user can enter into an input field.\n     */\n    max: string;\n    /**\n     * Sets or retrieves the maximum number of characters that the user can enter in a text control.\n     */\n    maxLength: number;\n    /**\n     * Defines the minimum acceptable value for an input element with type=\"number\". When used with the max and step attributes, lets you control the range and increment (such as even numbers only) that the user can enter into an input field.\n     */\n    min: string;\n    minLength: number;\n    /**\n     * Sets or retrieves the Boolean value indicating whether multiple items can be selected from a list.\n     */\n    multiple: boolean;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    /**\n     * Gets or sets a string containing a regular expression that the user's input must match.\n     */\n    pattern: string;\n    /**\n     * Gets or sets a text string that is displayed in an input field as a hint or prompt to users as the format or type of information they need to enter.The text appears in an input field until the user puts focus on the field.\n     */\n    placeholder: string;\n    readOnly: boolean;\n    /**\n     * When present, marks an element that can't be submitted without a value.\n     */\n    required: boolean;\n    selectionDirection: \"forward\" | \"backward\" | \"none\" | null;\n    /**\n     * Gets or sets the end position or offset of a text selection.\n     */\n    selectionEnd: number | null;\n    /**\n     * Gets or sets the starting position or offset of a text selection.\n     */\n    selectionStart: number | null;\n    size: number;\n    /**\n     * The address or URL of the a media resource that is to be considered.\n     */\n    src: string;\n    /**\n     * Defines an increment or jump between values that you want to allow the user to enter. When used with the max and min attributes, lets you control the range and increment (for example, allow only even numbers) that the user can enter into an input field.\n     */\n    step: string;\n    /**\n     * Returns the content type of the object.\n     */\n    type: string;\n    /**\n     * Sets or retrieves the URL, often with a bookmark extension (#name), to use as a client-side image map.\n     */\n    /** @deprecated */\n    useMap: string;\n    /**\n     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting.\n     */\n    readonly validationMessage: string;\n    /**\n     * Returns a  ValidityState object that represents the validity states of an element.\n     */\n    readonly validity: ValidityState;\n    /**\n     * Returns the value of the data at the cursor's current position.\n     */\n    value: string;\n    /**\n     * Returns a Date object representing the form control's value, if applicable; otherwise, returns null. Can be set, to change the value. Throws an \"InvalidStateError\" DOMException if the control isn't date- or time-based.\n     */\n    valueAsDate: Date | null;\n    /**\n     * Returns the input field value as a number.\n     */\n    valueAsNumber: number;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: number;\n    /**\n     * Returns whether an element will successfully validate based on forms validation rules and constraints.\n     */\n    readonly willValidate: boolean;\n    /**\n     * Returns whether a form will validate when it is submitted, without having to submit it.\n     */\n    checkValidity(): boolean;\n    reportValidity(): boolean;\n    /**\n     * Makes the selection equal to the current object.\n     */\n    select(): void;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    setRangeText(replacement: string): void;\n    setRangeText(replacement: string, start: number, end: number, selectionMode?: SelectionMode): void;\n    /**\n     * Sets the start and end positions of a selection in a text field.\n     * @param start The offset into the text field for the start of the selection.\n     * @param end The offset into the text field for the end of the selection.\n     * @param direction The direction in which the selection is performed.\n     */\n    setSelectionRange(start: number, end: number, direction?: \"forward\" | \"backward\" | \"none\"): void;\n    /**\n     * Decrements a range input control's value by the value given by the Step attribute. If the optional parameter is used, it will decrement the input control's step value multiplied by the parameter's value.\n     * @param n Value to decrement the value by.\n     */\n    stepDown(n?: number): void;\n    /**\n     * Increments a range input control's value by the value given by the Step attribute. If the optional parameter is used, will increment the input control's value by that value.\n     * @param n Value to increment the value by.\n     */\n    stepUp(n?: number): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLInputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLInputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLInputElement: {\n    prototype: HTMLInputElement;\n    new(): HTMLInputElement;\n};\n\n/** Exposes specific properties and methods (beyond those defined by regular HTMLElement interface it also has available to it by inheritance) for manipulating list elements. */\ninterface HTMLLIElement extends HTMLElement {\n    /** @deprecated */\n    type: string;\n    /**\n     * Sets or retrieves the value of a list item.\n     */\n    value: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLIElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLIElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLLIElement: {\n    prototype: HTMLLIElement;\n    new(): HTMLLIElement;\n};\n\n/** Gives access to properties specific to <label> elements. It inherits methods and properties from the base HTMLElement interface. */\ninterface HTMLLabelElement extends HTMLElement {\n    readonly control: HTMLElement | null;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * Sets or retrieves the object to which the given label object is assigned.\n     */\n    htmlFor: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLabelElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLabelElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLLabelElement: {\n    prototype: HTMLLabelElement;\n    new(): HTMLLabelElement;\n};\n\n/** The HTMLLegendElement is an interface allowing to access properties of the <legend> elements. It inherits properties and methods from the HTMLElement interface. */\ninterface HTMLLegendElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement | null;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLegendElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLegendElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLLegendElement: {\n    prototype: HTMLLegendElement;\n    new(): HTMLLegendElement;\n};\n\n/** Reference information for external resources and the relationship of those resources to a document and vice-versa. This object inherits all of the properties and methods of the HTMLElement interface. */\ninterface HTMLLinkElement extends HTMLElement, LinkStyle {\n    as: string;\n    /**\n     * Sets or retrieves the character set used to encode the object.\n     */\n    /** @deprecated */\n    charset: string;\n    crossOrigin: string | null;\n    disabled: boolean;\n    /**\n     * Sets or retrieves a destination URL or an anchor point.\n     */\n    href: string;\n    /**\n     * Sets or retrieves the language code of the object.\n     */\n    hreflang: string;\n    imageSizes: string;\n    imageSrcset: string;\n    integrity: string;\n    /**\n     * Sets or retrieves the media type.\n     */\n    media: string;\n    referrerPolicy: string;\n    /**\n     * Sets or retrieves the relationship between the object and the destination of the link.\n     */\n    rel: string;\n    readonly relList: DOMTokenList;\n    /**\n     * Sets or retrieves the relationship between the object and the destination of the link.\n     */\n    /** @deprecated */\n    rev: string;\n    readonly sizes: DOMTokenList;\n    /**\n     * Sets or retrieves the window or frame at which to target content.\n     */\n    /** @deprecated */\n    target: string;\n    /**\n     * Sets or retrieves the MIME type of the object.\n     */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLinkElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLLinkElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLLinkElement: {\n    prototype: HTMLLinkElement;\n    new(): HTMLLinkElement;\n};\n\n/** Provides special properties and methods (beyond those of the regular object HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of map elements. */\ninterface HTMLMapElement extends HTMLElement {\n    /**\n     * Retrieves a collection of the area objects defined for the given map object.\n     */\n    readonly areas: HTMLCollection;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMapElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMapElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMapElement: {\n    prototype: HTMLMapElement;\n    new(): HTMLMapElement;\n};\n\ninterface HTMLMarqueeElementEventMap extends HTMLElementEventMap {\n    \"bounce\": Event;\n    \"finish\": Event;\n    \"start\": Event;\n}\n\n/** Provides methods to manipulate <marquee> elements. */\ninterface HTMLMarqueeElement extends HTMLElement {\n    /** @deprecated */\n    behavior: string;\n    /** @deprecated */\n    bgColor: string;\n    /** @deprecated */\n    direction: string;\n    /** @deprecated */\n    height: string;\n    /** @deprecated */\n    hspace: number;\n    /** @deprecated */\n    loop: number;\n    /** @deprecated */\n    onbounce: ((this: HTMLMarqueeElement, ev: Event) => any) | null;\n    /** @deprecated */\n    onfinish: ((this: HTMLMarqueeElement, ev: Event) => any) | null;\n    /** @deprecated */\n    onstart: ((this: HTMLMarqueeElement, ev: Event) => any) | null;\n    /** @deprecated */\n    scrollAmount: number;\n    /** @deprecated */\n    scrollDelay: number;\n    /** @deprecated */\n    trueSpeed: boolean;\n    /** @deprecated */\n    vspace: number;\n    /** @deprecated */\n    width: string;\n    /** @deprecated */\n    start(): void;\n    /** @deprecated */\n    stop(): void;\n    addEventListener<K extends keyof HTMLMarqueeElementEventMap>(type: K, listener: (this: HTMLMarqueeElement, ev: HTMLMarqueeElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLMarqueeElementEventMap>(type: K, listener: (this: HTMLMarqueeElement, ev: HTMLMarqueeElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMarqueeElement: {\n    prototype: HTMLMarqueeElement;\n    new(): HTMLMarqueeElement;\n};\n\ninterface HTMLMediaElementEventMap extends HTMLElementEventMap {\n    \"encrypted\": MediaEncryptedEvent;\n    \"waitingforkey\": Event;\n}\n\n/** Adds to HTMLElement the properties and methods needed to support basic media-related capabilities that are common to audio and video. */\ninterface HTMLMediaElement extends HTMLElement {\n    /**\n     * Gets or sets a value that indicates whether to start playing the media automatically.\n     */\n    autoplay: boolean;\n    /**\n     * Gets a collection of buffered time ranges.\n     */\n    readonly buffered: TimeRanges;\n    /**\n     * Gets or sets a flag that indicates whether the client provides a set of controls for the media (in case the developer does not include controls for the player).\n     */\n    controls: boolean;\n    crossOrigin: string | null;\n    /**\n     * Gets the address or URL of the current media resource that is selected by IHTMLMediaElement.\n     */\n    readonly currentSrc: string;\n    /**\n     * Gets or sets the current playback position, in seconds.\n     */\n    currentTime: number;\n    defaultMuted: boolean;\n    /**\n     * Gets or sets the default playback rate when the user is not using fast forward or reverse for a video or audio resource.\n     */\n    defaultPlaybackRate: number;\n    /**\n     * Returns the duration in seconds of the current media resource. A NaN value is returned if duration is not available, or Infinity if the media resource is streaming.\n     */\n    readonly duration: number;\n    /**\n     * Gets information about whether the playback has ended or not.\n     */\n    readonly ended: boolean;\n    /**\n     * Returns an object representing the current error state of the audio or video element.\n     */\n    readonly error: MediaError | null;\n    /**\n     * Gets or sets a flag to specify whether playback should restart after it completes.\n     */\n    loop: boolean;\n    readonly mediaKeys: MediaKeys | null;\n    /**\n     * Gets or sets a flag that indicates whether the audio (either audio or the audio track on video media) is muted.\n     */\n    muted: boolean;\n    /**\n     * Gets the current network activity for the element.\n     */\n    readonly networkState: number;\n    onencrypted: ((this: HTMLMediaElement, ev: MediaEncryptedEvent) => any) | null;\n    onwaitingforkey: ((this: HTMLMediaElement, ev: Event) => any) | null;\n    /**\n     * Gets a flag that specifies whether playback is paused.\n     */\n    readonly paused: boolean;\n    /**\n     * Gets or sets the current rate of speed for the media resource to play. This speed is expressed as a multiple of the normal speed of the media resource.\n     */\n    playbackRate: number;\n    /**\n     * Gets TimeRanges for the current media resource that has been played.\n     */\n    readonly played: TimeRanges;\n    /**\n     * Gets or sets the current playback position, in seconds.\n     */\n    preload: string;\n    readonly readyState: number;\n    /**\n     * Returns a TimeRanges object that represents the ranges of the current media resource that can be seeked.\n     */\n    readonly seekable: TimeRanges;\n    /**\n     * Gets a flag that indicates whether the client is currently moving to a new playback position in the media resource.\n     */\n    readonly seeking: boolean;\n    /**\n     * The address or URL of the a media resource that is to be considered.\n     */\n    src: string;\n    srcObject: MediaProvider | null;\n    readonly textTracks: TextTrackList;\n    /**\n     * Gets or sets the volume level for audio portions of the media element.\n     */\n    volume: number;\n    addTextTrack(kind: TextTrackKind, label?: string, language?: string): TextTrack;\n    /**\n     * Returns a string that specifies whether the client can play a given media resource type.\n     */\n    canPlayType(type: string): CanPlayTypeResult;\n    fastSeek(time: number): void;\n    /**\n     * Resets the audio or video object and loads a new media resource.\n     */\n    load(): void;\n    /**\n     * Pauses the current playback and sets paused to TRUE. This can be used to test whether the media is playing or paused. You can also use the pause or play events to tell whether the media is playing or not.\n     */\n    pause(): void;\n    /**\n     * Loads and starts playback of a media resource.\n     */\n    play(): Promise<void>;\n    setMediaKeys(mediaKeys: MediaKeys | null): Promise<void>;\n    readonly HAVE_CURRENT_DATA: number;\n    readonly HAVE_ENOUGH_DATA: number;\n    readonly HAVE_FUTURE_DATA: number;\n    readonly HAVE_METADATA: number;\n    readonly HAVE_NOTHING: number;\n    readonly NETWORK_EMPTY: number;\n    readonly NETWORK_IDLE: number;\n    readonly NETWORK_LOADING: number;\n    readonly NETWORK_NO_SOURCE: number;\n    addEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLMediaElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLMediaElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMediaElement: {\n    prototype: HTMLMediaElement;\n    new(): HTMLMediaElement;\n    readonly HAVE_CURRENT_DATA: number;\n    readonly HAVE_ENOUGH_DATA: number;\n    readonly HAVE_FUTURE_DATA: number;\n    readonly HAVE_METADATA: number;\n    readonly HAVE_NOTHING: number;\n    readonly NETWORK_EMPTY: number;\n    readonly NETWORK_IDLE: number;\n    readonly NETWORK_LOADING: number;\n    readonly NETWORK_NO_SOURCE: number;\n};\n\ninterface HTMLMenuElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMenuElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMenuElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMenuElement: {\n    prototype: HTMLMenuElement;\n    new(): HTMLMenuElement;\n};\n\n/** Contains descriptive metadata about a document. It inherits all of the properties and methods described in the HTMLElement interface. */\ninterface HTMLMetaElement extends HTMLElement {\n    /**\n     * Gets or sets meta-information to associate with httpEquiv or name.\n     */\n    content: string;\n    /**\n     * Gets or sets information used to bind the value of a content attribute of a meta element to an HTTP response header.\n     */\n    httpEquiv: string;\n    /**\n     * Sets or retrieves the value specified in the content attribute of the meta object.\n     */\n    name: string;\n    /**\n     * Sets or retrieves a scheme to be used in interpreting the value of a property specified for the object.\n     */\n    /** @deprecated */\n    scheme: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMetaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMetaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMetaElement: {\n    prototype: HTMLMetaElement;\n    new(): HTMLMetaElement;\n};\n\n/** The HTML <meter> elements expose the HTMLMeterElement interface, which provides special properties and methods (beyond the HTMLElement object interface they also have available to them by inheritance) for manipulating the layout and presentation of <meter> elements. */\ninterface HTMLMeterElement extends HTMLElement {\n    high: number;\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    low: number;\n    max: number;\n    min: number;\n    optimum: number;\n    value: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMeterElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLMeterElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLMeterElement: {\n    prototype: HTMLMeterElement;\n    new(): HTMLMeterElement;\n};\n\n/** Provides special properties (beyond the regular methods and properties available through the HTMLElement interface they also have available to them by inheritance) for manipulating modification elements, that is <del> and <ins>. */\ninterface HTMLModElement extends HTMLElement {\n    /**\n     * Sets or retrieves reference information about the object.\n     */\n    cite: string;\n    /**\n     * Sets or retrieves the date and time of a modification to the object.\n     */\n    dateTime: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLModElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLModElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLModElement: {\n    prototype: HTMLModElement;\n    new(): HTMLModElement;\n};\n\n/** Provides special properties (beyond those defined on the regular HTMLElement interface it also has available to it by inheritance) for manipulating ordered list elements. */\ninterface HTMLOListElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    reversed: boolean;\n    /**\n     * The starting number.\n     */\n    start: number;\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLOListElement: {\n    prototype: HTMLOListElement;\n    new(): HTMLOListElement;\n};\n\n/** Provides special properties and methods (beyond those on the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of <object> element, representing external resources. */\ninterface HTMLObjectElement extends HTMLElement {\n    /** @deprecated */\n    align: string;\n    /**\n     * Sets or retrieves a character string that can be used to implement your own archive functionality for the object.\n     */\n    /** @deprecated */\n    archive: string;\n    /** @deprecated */\n    border: string;\n    /**\n     * Sets or retrieves the URL of the file containing the compiled Java class.\n     */\n    /** @deprecated */\n    code: string;\n    /**\n     * Sets or retrieves the URL of the component.\n     */\n    /** @deprecated */\n    codeBase: string;\n    /**\n     * Sets or retrieves the Internet media type for the code associated with the object.\n     */\n    /** @deprecated */\n    codeType: string;\n    /**\n     * Retrieves the document object of the page or frame.\n     */\n    readonly contentDocument: Document | null;\n    readonly contentWindow: WindowProxy | null;\n    /**\n     * Sets or retrieves the URL that references the data of the object.\n     */\n    data: string;\n    /** @deprecated */\n    declare: boolean;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    height: string;\n    /** @deprecated */\n    hspace: number;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    /**\n     * Sets or retrieves a message to be displayed while an object is loading.\n     */\n    /** @deprecated */\n    standby: string;\n    /**\n     * Sets or retrieves the MIME type of the object.\n     */\n    type: string;\n    /**\n     * Sets or retrieves the URL, often with a bookmark extension (#name), to use as a client-side image map.\n     */\n    useMap: string;\n    /**\n     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting.\n     */\n    readonly validationMessage: string;\n    /**\n     * Returns a  ValidityState object that represents the validity states of an element.\n     */\n    readonly validity: ValidityState;\n    /** @deprecated */\n    vspace: number;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    width: string;\n    /**\n     * Returns whether an element will successfully validate based on forms validation rules and constraints.\n     */\n    readonly willValidate: boolean;\n    /**\n     * Returns whether a form will validate when it is submitted, without having to submit it.\n     */\n    checkValidity(): boolean;\n    getSVGDocument(): Document | null;\n    reportValidity(): boolean;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLObjectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLObjectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLObjectElement: {\n    prototype: HTMLObjectElement;\n    new(): HTMLObjectElement;\n};\n\n/** Provides special properties and methods (beyond the regular HTMLElement object interface they also have available to them by inheritance) for manipulating the layout and presentation of <optgroup> elements. */\ninterface HTMLOptGroupElement extends HTMLElement {\n    disabled: boolean;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * Sets or retrieves a value that you can use to implement your own label functionality for the object.\n     */\n    label: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptGroupElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptGroupElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLOptGroupElement: {\n    prototype: HTMLOptGroupElement;\n    new(): HTMLOptGroupElement;\n};\n\n/** <option> elements and inherits all classes and methods of the HTMLElement interface. */\ninterface HTMLOptionElement extends HTMLElement {\n    /**\n     * Sets or retrieves the status of an option.\n     */\n    defaultSelected: boolean;\n    disabled: boolean;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement | null;\n    /**\n     * Sets or retrieves the ordinal position of an option in a list box.\n     */\n    readonly index: number;\n    /**\n     * Sets or retrieves a value that you can use to implement your own label functionality for the object.\n     */\n    label: string;\n    /**\n     * Sets or retrieves whether the option in the list box is the default item.\n     */\n    selected: boolean;\n    /**\n     * Sets or retrieves the text string specified by the option tag.\n     */\n    text: string;\n    /**\n     * Sets or retrieves the value which is returned to the server when the form control is submitted.\n     */\n    value: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLOptionElement: {\n    prototype: HTMLOptionElement;\n    new(): HTMLOptionElement;\n};\n\n/** HTMLOptionsCollection is an interface representing a collection of HTML option elements (in document order) and offers methods and properties for traversing the list as well as optionally altering its items. This type is returned solely by the \"options\" property of select. */\ninterface HTMLOptionsCollection extends HTMLCollectionOf<HTMLOptionElement> {\n    /**\n     * Returns the number of elements in the collection.\n     * \n     * When set to a smaller number, truncates the number of option elements in the corresponding container.\n     * \n     * When set to a greater number, adds new blank option elements to that container.\n     */\n    length: number;\n    /**\n     * Returns the index of the first selected item, if any, or −1 if there is no selected item.\n     * \n     * Can be set, to change the selection.\n     */\n    selectedIndex: number;\n    /**\n     * Inserts element before the node given by before.\n     * \n     * The before argument can be a number, in which case element is inserted before the item with that number, or an element from the collection, in which case element is inserted before that element.\n     * \n     * If before is omitted, null, or a number out of range, then element will be added at the end of the list.\n     * \n     * This method will throw a \"HierarchyRequestError\" DOMException if element is an ancestor of the element into which it is to be inserted.\n     */\n    add(element: HTMLOptionElement | HTMLOptGroupElement, before?: HTMLElement | number | null): void;\n    /**\n     * Removes the item with index index from the collection.\n     */\n    remove(index: number): void;\n}\n\ndeclare var HTMLOptionsCollection: {\n    prototype: HTMLOptionsCollection;\n    new(): HTMLOptionsCollection;\n};\n\ninterface HTMLOrSVGElement {\n    autofocus: boolean;\n    readonly dataset: DOMStringMap;\n    nonce?: string;\n    tabIndex: number;\n    blur(): void;\n    focus(options?: FocusOptions): void;\n}\n\n/** Provides properties and methods (beyond those inherited from HTMLElement) for manipulating the layout and presentation of <output> elements. */\ninterface HTMLOutputElement extends HTMLElement {\n    defaultValue: string;\n    readonly form: HTMLFormElement | null;\n    readonly htmlFor: DOMTokenList;\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    name: string;\n    readonly type: string;\n    readonly validationMessage: string;\n    readonly validity: ValidityState;\n    value: string;\n    readonly willValidate: boolean;\n    checkValidity(): boolean;\n    reportValidity(): boolean;\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOutputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLOutputElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLOutputElement: {\n    prototype: HTMLOutputElement;\n    new(): HTMLOutputElement;\n};\n\n/** Provides special properties (beyond those of the regular HTMLElement object interface it inherits) for manipulating <p> elements. */\ninterface HTMLParagraphElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    /** @deprecated */\n    align: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParagraphElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParagraphElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLParagraphElement: {\n    prototype: HTMLParagraphElement;\n    new(): HTMLParagraphElement;\n};\n\n/** Provides special properties (beyond those of the regular HTMLElement object interface it inherits) for manipulating <param> elements, representing a pair of a key and a value that acts as a parameter for an <object> element. */\ninterface HTMLParamElement extends HTMLElement {\n    /**\n     * Sets or retrieves the name of an input parameter for an element.\n     */\n    name: string;\n    /**\n     * Sets or retrieves the content type of the resource designated by the value attribute.\n     */\n    /** @deprecated */\n    type: string;\n    /**\n     * Sets or retrieves the value of an input parameter for an element.\n     */\n    value: string;\n    /**\n     * Sets or retrieves the data type of the value attribute.\n     */\n    /** @deprecated */\n    valueType: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParamElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLParamElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLParamElement: {\n    prototype: HTMLParamElement;\n    new(): HTMLParamElement;\n};\n\n/** A <picture> HTML element. It doesn't implement specific properties or methods. */\ninterface HTMLPictureElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPictureElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPictureElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLPictureElement: {\n    prototype: HTMLPictureElement;\n    new(): HTMLPictureElement;\n};\n\n/** Exposes specific properties and methods (beyond those of the HTMLElement interface it also has available to it by inheritance) for manipulating a block of preformatted text (<pre>). */\ninterface HTMLPreElement extends HTMLElement {\n    /**\n     * Sets or gets a value that you can use to implement your own width functionality for the object.\n     */\n    /** @deprecated */\n    width: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPreElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLPreElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLPreElement: {\n    prototype: HTMLPreElement;\n    new(): HTMLPreElement;\n};\n\n/** Provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of <progress> elements. */\ninterface HTMLProgressElement extends HTMLElement {\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    /**\n     * Defines the maximum, or \"done\" value for a progress element.\n     */\n    max: number;\n    /**\n     * Returns the quotient of value/max when the value attribute is set (determinate progress bar), or -1 when the value attribute is missing (indeterminate progress bar).\n     */\n    readonly position: number;\n    /**\n     * Sets or gets the current value of a progress element. The value must be a non-negative number between 0 and the max value.\n     */\n    value: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLProgressElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLProgressElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLProgressElement: {\n    prototype: HTMLProgressElement;\n    new(): HTMLProgressElement;\n};\n\n/** Provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating quoting elements, like <blockquote> and <q>, but not the <cite> element. */\ninterface HTMLQuoteElement extends HTMLElement {\n    /**\n     * Sets or retrieves reference information about the object.\n     */\n    cite: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLQuoteElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLQuoteElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLQuoteElement: {\n    prototype: HTMLQuoteElement;\n    new(): HTMLQuoteElement;\n};\n\n/** HTML <script> elements expose the HTMLScriptElement interface, which provides special properties and methods for manipulating the behavior and execution of <script> elements (beyond the inherited HTMLElement interface). */\ninterface HTMLScriptElement extends HTMLElement {\n    async: boolean;\n    /**\n     * Sets or retrieves the character set used to encode the object.\n     */\n    /** @deprecated */\n    charset: string;\n    crossOrigin: string | null;\n    /**\n     * Sets or retrieves the status of the script.\n     */\n    defer: boolean;\n    /**\n     * Sets or retrieves the event for which the script is written.\n     */\n    /** @deprecated */\n    event: string;\n    /**\n     * Sets or retrieves the object that is bound to the event script.\n     */\n    /** @deprecated */\n    htmlFor: string;\n    integrity: string;\n    noModule: boolean;\n    referrerPolicy: string;\n    /**\n     * Retrieves the URL to an external file that contains the source code or data.\n     */\n    src: string;\n    /**\n     * Retrieves or sets the text of the object as a string.\n     */\n    text: string;\n    /**\n     * Sets or retrieves the MIME type for the associated scripting engine.\n     */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLScriptElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLScriptElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLScriptElement: {\n    prototype: HTMLScriptElement;\n    new(): HTMLScriptElement;\n};\n\n/** A <select> HTML Element. These elements also share all of the properties and methods of other HTML elements via the HTMLElement interface. */\ninterface HTMLSelectElement extends HTMLElement {\n    autocomplete: string;\n    disabled: boolean;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement | null;\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    /**\n     * Sets or retrieves the number of objects in a collection.\n     */\n    length: number;\n    /**\n     * Sets or retrieves the Boolean value indicating whether multiple items can be selected from a list.\n     */\n    multiple: boolean;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    readonly options: HTMLOptionsCollection;\n    /**\n     * When present, marks an element that can't be submitted without a value.\n     */\n    required: boolean;\n    /**\n     * Sets or retrieves the index of the selected option in a select object.\n     */\n    selectedIndex: number;\n    readonly selectedOptions: HTMLCollectionOf<HTMLOptionElement>;\n    /**\n     * Sets or retrieves the number of rows in the list box.\n     */\n    size: number;\n    /**\n     * Retrieves the type of select control based on the value of the MULTIPLE attribute.\n     */\n    readonly type: string;\n    /**\n     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting.\n     */\n    readonly validationMessage: string;\n    /**\n     * Returns a  ValidityState object that represents the validity states of an element.\n     */\n    readonly validity: ValidityState;\n    /**\n     * Sets or retrieves the value which is returned to the server when the form control is submitted.\n     */\n    value: string;\n    /**\n     * Returns whether an element will successfully validate based on forms validation rules and constraints.\n     */\n    readonly willValidate: boolean;\n    /**\n     * Adds an element to the areas, controlRange, or options collection.\n     * @param element Variant of type Number that specifies the index position in the collection where the element is placed. If no value is given, the method places the element at the end of the collection.\n     * @param before Variant of type Object that specifies an element to insert before, or null to append the object to the collection.\n     */\n    add(element: HTMLOptionElement | HTMLOptGroupElement, before?: HTMLElement | number | null): void;\n    /**\n     * Returns whether a form will validate when it is submitted, without having to submit it.\n     */\n    checkValidity(): boolean;\n    /**\n     * Retrieves a select object or an object from an options collection.\n     * @param name Variant of type Number or String that specifies the object or collection to retrieve. If this parameter is an integer, it is the zero-based index of the object. If this parameter is a string, all objects with matching name or id properties are retrieved, and a collection is returned if more than one match is made.\n     * @param index Variant of type Number that specifies the zero-based index of the object to retrieve when a collection is returned.\n     */\n    item(index: number): Element | null;\n    /**\n     * Retrieves a select object or an object from an options collection.\n     * @param namedItem A String that specifies the name or id property of the object to retrieve. A collection is returned if more than one match is made.\n     */\n    namedItem(name: string): HTMLOptionElement | null;\n    /**\n     * Removes an element from the collection.\n     * @param index Number that specifies the zero-based index of the element to remove from the collection.\n     */\n    remove(): void;\n    remove(index: number): void;\n    reportValidity(): boolean;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSelectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSelectElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n    [name: number]: HTMLOptionElement | HTMLOptGroupElement;\n}\n\ndeclare var HTMLSelectElement: {\n    prototype: HTMLSelectElement;\n    new(): HTMLSelectElement;\n};\n\ninterface HTMLSlotElement extends HTMLElement {\n    name: string;\n    assignedElements(options?: AssignedNodesOptions): Element[];\n    assignedNodes(options?: AssignedNodesOptions): Node[];\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSlotElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSlotElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLSlotElement: {\n    prototype: HTMLSlotElement;\n    new(): HTMLSlotElement;\n};\n\n/** Provides special properties (beyond the regular HTMLElement object interface it also has available to it by inheritance) for manipulating <source> elements. */\ninterface HTMLSourceElement extends HTMLElement {\n    /**\n     * Gets or sets the intended media type of the media source.\n     */\n    media: string;\n    sizes: string;\n    /**\n     * The address or URL of the a media resource that is to be considered.\n     */\n    src: string;\n    srcset: string;\n    /**\n     * Gets or sets the MIME type of a media resource.\n     */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSourceElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSourceElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLSourceElement: {\n    prototype: HTMLSourceElement;\n    new(): HTMLSourceElement;\n};\n\n/** A <span> element and derives from the HTMLElement interface, but without implementing any additional properties or methods. */\ninterface HTMLSpanElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSpanElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLSpanElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLSpanElement: {\n    prototype: HTMLSpanElement;\n    new(): HTMLSpanElement;\n};\n\n/** A <style> element. It inherits properties and methods from its parent, HTMLElement, and from LinkStyle. */\ninterface HTMLStyleElement extends HTMLElement, LinkStyle {\n    /**\n     * Sets or retrieves the media type.\n     */\n    media: string;\n    /**\n     * Retrieves the CSS language in which the style sheet is written.\n     */\n    /** @deprecated */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLStyleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLStyleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLStyleElement: {\n    prototype: HTMLStyleElement;\n    new(): HTMLStyleElement;\n};\n\n/** Special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating table caption elements. */\ninterface HTMLTableCaptionElement extends HTMLElement {\n    /**\n     * Sets or retrieves the alignment of the caption or legend.\n     */\n    /** @deprecated */\n    align: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCaptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCaptionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableCaptionElement: {\n    prototype: HTMLTableCaptionElement;\n    new(): HTMLTableCaptionElement;\n};\n\n/** Provides special properties and methods (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of table cells, either header or data cells, in an HTML document. */\ninterface HTMLTableCellElement extends HTMLElement {\n    /**\n     * Sets or retrieves abbreviated text for the object.\n     */\n    abbr: string;\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    /** @deprecated */\n    align: string;\n    /**\n     * Sets or retrieves a comma-delimited list of conceptual categories associated with the object.\n     */\n    /** @deprecated */\n    axis: string;\n    /** @deprecated */\n    bgColor: string;\n    /**\n     * Retrieves the position of the object in the cells collection of a row.\n     */\n    readonly cellIndex: number;\n    /** @deprecated */\n    ch: string;\n    /** @deprecated */\n    chOff: string;\n    /**\n     * Sets or retrieves the number columns in the table that the object should span.\n     */\n    colSpan: number;\n    /**\n     * Sets or retrieves a list of header cells that provide information for the object.\n     */\n    headers: string;\n    /**\n     * Sets or retrieves the height of the object.\n     */\n    /** @deprecated */\n    height: string;\n    /**\n     * Sets or retrieves whether the browser automatically performs wordwrap.\n     */\n    /** @deprecated */\n    noWrap: boolean;\n    /**\n     * Sets or retrieves how many rows in a table the cell should span.\n     */\n    rowSpan: number;\n    /**\n     * Sets or retrieves the group of cells in a table to which the object's information applies.\n     */\n    scope: string;\n    /** @deprecated */\n    vAlign: string;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    /** @deprecated */\n    width: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableCellElement: {\n    prototype: HTMLTableCellElement;\n    new(): HTMLTableCellElement;\n};\n\n/** Provides special properties (beyond the HTMLElement interface it also has available to it inheritance) for manipulating single or grouped table column elements. */\ninterface HTMLTableColElement extends HTMLElement {\n    /**\n     * Sets or retrieves the alignment of the object relative to the display or table.\n     */\n    /** @deprecated */\n    align: string;\n    /** @deprecated */\n    ch: string;\n    /** @deprecated */\n    chOff: string;\n    /**\n     * Sets or retrieves the number of columns in the group.\n     */\n    span: number;\n    /** @deprecated */\n    vAlign: string;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    /** @deprecated */\n    width: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableColElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableColElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableColElement: {\n    prototype: HTMLTableColElement;\n    new(): HTMLTableColElement;\n};\n\ninterface HTMLTableDataCellElement extends HTMLTableCellElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableDataCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableDataCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableDataCellElement: {\n    prototype: HTMLTableDataCellElement;\n    new(): HTMLTableDataCellElement;\n};\n\n/** Provides special properties and methods (beyond the regular HTMLElement object interface it also has available to it by inheritance) for manipulating the layout and presentation of tables in an HTML document. */\ninterface HTMLTableElement extends HTMLElement {\n    /**\n     * Sets or retrieves a value that indicates the table alignment.\n     */\n    /** @deprecated */\n    align: string;\n    /** @deprecated */\n    bgColor: string;\n    /**\n     * Sets or retrieves the width of the border to draw around the object.\n     */\n    /** @deprecated */\n    border: string;\n    /**\n     * Retrieves the caption object of a table.\n     */\n    caption: HTMLTableCaptionElement | null;\n    /**\n     * Sets or retrieves the amount of space between the border of the cell and the content of the cell.\n     */\n    /** @deprecated */\n    cellPadding: string;\n    /**\n     * Sets or retrieves the amount of space between cells in a table.\n     */\n    /** @deprecated */\n    cellSpacing: string;\n    /**\n     * Sets or retrieves the way the border frame around the table is displayed.\n     */\n    /** @deprecated */\n    frame: string;\n    /**\n     * Sets or retrieves the number of horizontal rows contained in the object.\n     */\n    readonly rows: HTMLCollectionOf<HTMLTableRowElement>;\n    /**\n     * Sets or retrieves which dividing lines (inner borders) are displayed.\n     */\n    /** @deprecated */\n    rules: string;\n    /**\n     * Sets or retrieves a description and/or structure of the object.\n     */\n    /** @deprecated */\n    summary: string;\n    /**\n     * Retrieves a collection of all tBody objects in the table. Objects in this collection are in source order.\n     */\n    readonly tBodies: HTMLCollectionOf<HTMLTableSectionElement>;\n    /**\n     * Retrieves the tFoot object of the table.\n     */\n    tFoot: HTMLTableSectionElement | null;\n    /**\n     * Retrieves the tHead object of the table.\n     */\n    tHead: HTMLTableSectionElement | null;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    /** @deprecated */\n    width: string;\n    /**\n     * Creates an empty caption element in the table.\n     */\n    createCaption(): HTMLTableCaptionElement;\n    /**\n     * Creates an empty tBody element in the table.\n     */\n    createTBody(): HTMLTableSectionElement;\n    /**\n     * Creates an empty tFoot element in the table.\n     */\n    createTFoot(): HTMLTableSectionElement;\n    /**\n     * Returns the tHead element object if successful, or null otherwise.\n     */\n    createTHead(): HTMLTableSectionElement;\n    /**\n     * Deletes the caption element and its contents from the table.\n     */\n    deleteCaption(): void;\n    /**\n     * Removes the specified row (tr) from the element and from the rows collection.\n     * @param index Number that specifies the zero-based position in the rows collection of the row to remove.\n     */\n    deleteRow(index: number): void;\n    /**\n     * Deletes the tFoot element and its contents from the table.\n     */\n    deleteTFoot(): void;\n    /**\n     * Deletes the tHead element and its contents from the table.\n     */\n    deleteTHead(): void;\n    /**\n     * Creates a new row (tr) in the table, and adds the row to the rows collection.\n     * @param index Number that specifies where to insert the row in the rows collection. The default value is -1, which appends the new row to the end of the rows collection.\n     */\n    insertRow(index?: number): HTMLTableRowElement;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableElement: {\n    prototype: HTMLTableElement;\n    new(): HTMLTableElement;\n};\n\ninterface HTMLTableHeaderCellElement extends HTMLTableCellElement {\n    scope: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableHeaderCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableHeaderCellElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableHeaderCellElement: {\n    prototype: HTMLTableHeaderCellElement;\n    new(): HTMLTableHeaderCellElement;\n};\n\n/** Provides special properties and methods (beyond the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of rows in an HTML table. */\ninterface HTMLTableRowElement extends HTMLElement {\n    /**\n     * Sets or retrieves how the object is aligned with adjacent text.\n     */\n    /** @deprecated */\n    align: string;\n    /** @deprecated */\n    bgColor: string;\n    /**\n     * Retrieves a collection of all cells in the table row.\n     */\n    readonly cells: HTMLCollectionOf<HTMLTableDataCellElement | HTMLTableHeaderCellElement>;\n    /** @deprecated */\n    ch: string;\n    /** @deprecated */\n    chOff: string;\n    /**\n     * Retrieves the position of the object in the rows collection for the table.\n     */\n    readonly rowIndex: number;\n    /**\n     * Retrieves the position of the object in the collection.\n     */\n    readonly sectionRowIndex: number;\n    /** @deprecated */\n    vAlign: string;\n    /**\n     * Removes the specified cell from the table row, as well as from the cells collection.\n     * @param index Number that specifies the zero-based position of the cell to remove from the table row. If no value is provided, the last cell in the cells collection is deleted.\n     */\n    deleteCell(index: number): void;\n    /**\n     * Creates a new cell in the table row, and adds the cell to the cells collection.\n     * @param index Number that specifies where to insert the cell in the tr. The default value is -1, which appends the new cell to the end of the cells collection.\n     */\n    insertCell(index?: number): HTMLTableDataCellElement;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableRowElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableRowElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableRowElement: {\n    prototype: HTMLTableRowElement;\n    new(): HTMLTableRowElement;\n};\n\n/** Provides special properties and methods (beyond the HTMLElement interface it also has available to it by inheritance) for manipulating the layout and presentation of sections, that is headers, footers and bodies, in an HTML table. */\ninterface HTMLTableSectionElement extends HTMLElement {\n    /**\n     * Sets or retrieves a value that indicates the table alignment.\n     */\n    /** @deprecated */\n    align: string;\n    /** @deprecated */\n    ch: string;\n    /** @deprecated */\n    chOff: string;\n    /**\n     * Sets or retrieves the number of horizontal rows contained in the object.\n     */\n    readonly rows: HTMLCollectionOf<HTMLTableRowElement>;\n    /** @deprecated */\n    vAlign: string;\n    /**\n     * Removes the specified row (tr) from the element and from the rows collection.\n     * @param index Number that specifies the zero-based position in the rows collection of the row to remove.\n     */\n    deleteRow(index: number): void;\n    /**\n     * Creates a new row (tr) in the table, and adds the row to the rows collection.\n     * @param index Number that specifies where to insert the row in the rows collection. The default value is -1, which appends the new row to the end of the rows collection.\n     */\n    insertRow(index?: number): HTMLTableRowElement;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableSectionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTableSectionElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTableSectionElement: {\n    prototype: HTMLTableSectionElement;\n    new(): HTMLTableSectionElement;\n};\n\n/** Enables access to the contents of an HTML <template> element. */\ninterface HTMLTemplateElement extends HTMLElement {\n    readonly content: DocumentFragment;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTemplateElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTemplateElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTemplateElement: {\n    prototype: HTMLTemplateElement;\n    new(): HTMLTemplateElement;\n};\n\n/** Provides special properties and methods for manipulating the layout and presentation of <textarea> elements. */\ninterface HTMLTextAreaElement extends HTMLElement {\n    autocomplete: string;\n    /**\n     * Sets or retrieves the width of the object.\n     */\n    cols: number;\n    /**\n     * Sets or retrieves the initial contents of the object.\n     */\n    defaultValue: string;\n    dirName: string;\n    disabled: boolean;\n    /**\n     * Retrieves a reference to the form that the object is embedded in.\n     */\n    readonly form: HTMLFormElement | null;\n    readonly labels: NodeListOf<HTMLLabelElement>;\n    /**\n     * Sets or retrieves the maximum number of characters that the user can enter in a text control.\n     */\n    maxLength: number;\n    minLength: number;\n    /**\n     * Sets or retrieves the name of the object.\n     */\n    name: string;\n    /**\n     * Gets or sets a text string that is displayed in an input field as a hint or prompt to users as the format or type of information they need to enter.The text appears in an input field until the user puts focus on the field.\n     */\n    placeholder: string;\n    /**\n     * Sets or retrieves the value indicated whether the content of the object is read-only.\n     */\n    readOnly: boolean;\n    /**\n     * When present, marks an element that can't be submitted without a value.\n     */\n    required: boolean;\n    /**\n     * Sets or retrieves the number of horizontal rows contained in the object.\n     */\n    rows: number;\n    selectionDirection: \"forward\" | \"backward\" | \"none\";\n    /**\n     * Gets or sets the end position or offset of a text selection.\n     */\n    selectionEnd: number;\n    /**\n     * Gets or sets the starting position or offset of a text selection.\n     */\n    selectionStart: number;\n    readonly textLength: number;\n    /**\n     * Retrieves the type of control.\n     */\n    readonly type: string;\n    /**\n     * Returns the error message that would be displayed if the user submits the form, or an empty string if no error message. It also triggers the standard error message, such as \"this is a required field\". The result is that the user sees validation messages without actually submitting.\n     */\n    readonly validationMessage: string;\n    /**\n     * Returns a  ValidityState object that represents the validity states of an element.\n     */\n    readonly validity: ValidityState;\n    /**\n     * Retrieves or sets the text in the entry field of the textArea element.\n     */\n    value: string;\n    /**\n     * Returns whether an element will successfully validate based on forms validation rules and constraints.\n     */\n    readonly willValidate: boolean;\n    /**\n     * Sets or retrieves how to handle wordwrapping in the object.\n     */\n    wrap: string;\n    /**\n     * Returns whether a form will validate when it is submitted, without having to submit it.\n     */\n    checkValidity(): boolean;\n    reportValidity(): boolean;\n    /**\n     * Highlights the input area of a form element.\n     */\n    select(): void;\n    /**\n     * Sets a custom error message that is displayed when a form is submitted.\n     * @param error Sets a custom error message that is displayed when a form is submitted.\n     */\n    setCustomValidity(error: string): void;\n    setRangeText(replacement: string): void;\n    setRangeText(replacement: string, start: number, end: number, selectionMode?: SelectionMode): void;\n    /**\n     * Sets the start and end positions of a selection in a text field.\n     * @param start The offset into the text field for the start of the selection.\n     * @param end The offset into the text field for the end of the selection.\n     * @param direction The direction in which the selection is performed.\n     */\n    setSelectionRange(start: number, end: number, direction?: \"forward\" | \"backward\" | \"none\"): void;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTextAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTextAreaElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTextAreaElement: {\n    prototype: HTMLTextAreaElement;\n    new(): HTMLTextAreaElement;\n};\n\n/** Provides special properties (beyond the regular HTMLElement interface it also has available to it by inheritance) for manipulating <time> elements. */\ninterface HTMLTimeElement extends HTMLElement {\n    dateTime: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTimeElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTimeElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTimeElement: {\n    prototype: HTMLTimeElement;\n    new(): HTMLTimeElement;\n};\n\n/** Contains the title for a document. This element inherits all of the properties and methods of the HTMLElement interface. */\ninterface HTMLTitleElement extends HTMLElement {\n    /**\n     * Retrieves or sets the text of the object as a string.\n     */\n    text: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTitleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTitleElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTitleElement: {\n    prototype: HTMLTitleElement;\n    new(): HTMLTitleElement;\n};\n\n/** The HTMLTrackElement */\ninterface HTMLTrackElement extends HTMLElement {\n    default: boolean;\n    kind: string;\n    label: string;\n    readonly readyState: number;\n    src: string;\n    srclang: string;\n    readonly track: TextTrack;\n    readonly ERROR: number;\n    readonly LOADED: number;\n    readonly LOADING: number;\n    readonly NONE: number;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTrackElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLTrackElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLTrackElement: {\n    prototype: HTMLTrackElement;\n    new(): HTMLTrackElement;\n    readonly ERROR: number;\n    readonly LOADED: number;\n    readonly LOADING: number;\n    readonly NONE: number;\n};\n\n/** Provides special properties (beyond those defined on the regular HTMLElement interface it also has available to it by inheritance) for manipulating unordered list elements. */\ninterface HTMLUListElement extends HTMLElement {\n    /** @deprecated */\n    compact: boolean;\n    /** @deprecated */\n    type: string;\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUListElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLUListElement: {\n    prototype: HTMLUListElement;\n    new(): HTMLUListElement;\n};\n\n/** An invalid HTML element and derives from the HTMLElement interface, but without implementing any additional properties or methods. */\ninterface HTMLUnknownElement extends HTMLElement {\n    addEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUnknownElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLUnknownElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLUnknownElement: {\n    prototype: HTMLUnknownElement;\n    new(): HTMLUnknownElement;\n};\n\n/** Provides special properties and methods for manipulating video objects. It also inherits properties and methods of HTMLMediaElement and HTMLElement. */\ninterface HTMLVideoElement extends HTMLMediaElement {\n    /**\n     * Gets or sets the height of the video element.\n     */\n    height: number;\n    /**\n     * Gets or sets the playsinline of the video element. for example, On iPhone, video elements will now be allowed to play inline, and will not automatically enter fullscreen mode when playback begins.\n     */\n    playsInline: boolean;\n    /**\n     * Gets or sets a URL of an image to display, for example, like a movie poster. This can be a still frame from the video, or another image if no video data is available.\n     */\n    poster: string;\n    /**\n     * Gets the intrinsic height of a video in CSS pixels, or zero if the dimensions are not known.\n     */\n    readonly videoHeight: number;\n    /**\n     * Gets the intrinsic width of a video in CSS pixels, or zero if the dimensions are not known.\n     */\n    readonly videoWidth: number;\n    /**\n     * Gets or sets the width of the video element.\n     */\n    width: number;\n    getVideoPlaybackQuality(): VideoPlaybackQuality;\n    addEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLVideoElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof HTMLMediaElementEventMap>(type: K, listener: (this: HTMLVideoElement, ev: HTMLMediaElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var HTMLVideoElement: {\n    prototype: HTMLVideoElement;\n    new(): HTMLVideoElement;\n};\n\n/** Events that fire when the fragment identifier of the URL has changed. */\ninterface HashChangeEvent extends Event {\n    /**\n     * Returns the URL of the session history entry that is now current.\n     */\n    readonly newURL: string;\n    /**\n     * Returns the URL of the session history entry that was previously current.\n     */\n    readonly oldURL: string;\n}\n\ndeclare var HashChangeEvent: {\n    prototype: HashChangeEvent;\n    new(type: string, eventInitDict?: HashChangeEventInit): HashChangeEvent;\n};\n\n/** This Fetch API interface allows you to perform various actions on HTTP request and response headers. These actions include retrieving, setting, adding to, and removing. A Headers object has an associated header list, which is initially empty and consists of zero or more name and value pairs.  You can add to this using methods like append() (see Examples.) In all methods of this interface, header names are matched by case-insensitive byte sequence. */\ninterface Headers {\n    append(name: string, value: string): void;\n    delete(name: string): void;\n    get(name: string): string | null;\n    has(name: string): boolean;\n    set(name: string, value: string): void;\n    forEach(callbackfn: (value: string, key: string, parent: Headers) => void, thisArg?: any): void;\n}\n\ndeclare var Headers: {\n    prototype: Headers;\n    new(init?: HeadersInit): Headers;\n};\n\n/** Allows manipulation of the browser session history, that is the pages visited in the tab or frame that the current page is loaded in. */\ninterface History {\n    readonly length: number;\n    scrollRestoration: ScrollRestoration;\n    readonly state: any;\n    back(): void;\n    forward(): void;\n    go(delta?: number): void;\n    pushState(data: any, title: string, url?: string | null): void;\n    replaceState(data: any, title: string, url?: string | null): void;\n}\n\ndeclare var History: {\n    prototype: History;\n    new(): History;\n};\n\ninterface IDBArrayKey extends Array<IDBValidKey> {\n}\n\n/** This IndexedDB API interface represents a cursor for traversing or iterating over multiple records in a database. */\ninterface IDBCursor {\n    /**\n     * Returns the direction (\"next\", \"nextunique\", \"prev\" or \"prevunique\") of the cursor.\n     */\n    readonly direction: IDBCursorDirection;\n    /**\n     * Returns the key of the cursor. Throws a \"InvalidStateError\" DOMException if the cursor is advancing or is finished.\n     */\n    readonly key: IDBValidKey;\n    /**\n     * Returns the effective key of the cursor. Throws a \"InvalidStateError\" DOMException if the cursor is advancing or is finished.\n     */\n    readonly primaryKey: IDBValidKey;\n    /**\n     * Returns the IDBObjectStore or IDBIndex the cursor was opened from.\n     */\n    readonly source: IDBObjectStore | IDBIndex;\n    /**\n     * Advances the cursor through the next count records in range.\n     */\n    advance(count: number): void;\n    /**\n     * Advances the cursor to the next record in range.\n     */\n    continue(key?: IDBValidKey): void;\n    /**\n     * Advances the cursor to the next record in range matching or after key and primaryKey. Throws an \"InvalidAccessError\" DOMException if the source is not an index.\n     */\n    continuePrimaryKey(key: IDBValidKey, primaryKey: IDBValidKey): void;\n    /**\n     * Delete the record pointed at by the cursor with a new value.\n     * \n     * If successful, request's result will be undefined.\n     */\n    delete(): IDBRequest<undefined>;\n    /**\n     * Updated the record pointed at by the cursor with a new value.\n     * \n     * Throws a \"DataError\" DOMException if the effective object store uses in-line keys and the key would have changed.\n     * \n     * If successful, request's result will be the record's key.\n     */\n    update(value: any): IDBRequest<IDBValidKey>;\n}\n\ndeclare var IDBCursor: {\n    prototype: IDBCursor;\n    new(): IDBCursor;\n};\n\n/** This IndexedDB API interface represents a cursor for traversing or iterating over multiple records in a database. It is the same as the IDBCursor, except that it includes the value property. */\ninterface IDBCursorWithValue extends IDBCursor {\n    /**\n     * Returns the cursor's current value.\n     */\n    readonly value: any;\n}\n\ndeclare var IDBCursorWithValue: {\n    prototype: IDBCursorWithValue;\n    new(): IDBCursorWithValue;\n};\n\ninterface IDBDatabaseEventMap {\n    \"abort\": Event;\n    \"close\": Event;\n    \"error\": Event;\n    \"versionchange\": IDBVersionChangeEvent;\n}\n\n/** This IndexedDB API interface provides a connection to a database; you can use an IDBDatabase object to open a transaction on your database then create, manipulate, and delete objects (data) in that database. The interface provides the only way to get and manage versions of the database. */\ninterface IDBDatabase extends EventTarget {\n    /**\n     * Returns the name of the database.\n     */\n    readonly name: string;\n    /**\n     * Returns a list of the names of object stores in the database.\n     */\n    readonly objectStoreNames: DOMStringList;\n    onabort: ((this: IDBDatabase, ev: Event) => any) | null;\n    onclose: ((this: IDBDatabase, ev: Event) => any) | null;\n    onerror: ((this: IDBDatabase, ev: Event) => any) | null;\n    onversionchange: ((this: IDBDatabase, ev: IDBVersionChangeEvent) => any) | null;\n    /**\n     * Returns the version of the database.\n     */\n    readonly version: number;\n    /**\n     * Closes the connection once all running transactions have finished.\n     */\n    close(): void;\n    /**\n     * Creates a new object store with the given name and options and returns a new IDBObjectStore.\n     * \n     * Throws a \"InvalidStateError\" DOMException if not called within an upgrade transaction.\n     */\n    createObjectStore(name: string, options?: IDBObjectStoreParameters): IDBObjectStore;\n    /**\n     * Deletes the object store with the given name.\n     * \n     * Throws a \"InvalidStateError\" DOMException if not called within an upgrade transaction.\n     */\n    deleteObjectStore(name: string): void;\n    /**\n     * Returns a new transaction with the given mode (\"readonly\" or \"readwrite\") and scope which can be a single object store name or an array of names.\n     */\n    transaction(storeNames: string | string[], mode?: IDBTransactionMode): IDBTransaction;\n    addEventListener<K extends keyof IDBDatabaseEventMap>(type: K, listener: (this: IDBDatabase, ev: IDBDatabaseEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof IDBDatabaseEventMap>(type: K, listener: (this: IDBDatabase, ev: IDBDatabaseEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var IDBDatabase: {\n    prototype: IDBDatabase;\n    new(): IDBDatabase;\n};\n\n/** In the following code snippet, we make a request to open a database, and include handlers for the success and error cases. For a full working example, see our To-do Notifications app (view example live.) */\ninterface IDBFactory {\n    /**\n     * Compares two values as keys. Returns -1 if key1 precedes key2, 1 if key2 precedes key1, and 0 if the keys are equal.\n     * \n     * Throws a \"DataError\" DOMException if either input is not a valid key.\n     */\n    cmp(first: any, second: any): number;\n    /**\n     * Attempts to delete the named database. If the database already exists and there are open connections that don't close in response to a versionchange event, the request will be blocked until all they close. If the request is successful request's result will be null.\n     */\n    deleteDatabase(name: string): IDBOpenDBRequest;\n    /**\n     * Attempts to open a connection to the named database with the current version, or 1 if it does not already exist. If the request is successful request's result will be the connection.\n     */\n    open(name: string, version?: number): IDBOpenDBRequest;\n}\n\ndeclare var IDBFactory: {\n    prototype: IDBFactory;\n    new(): IDBFactory;\n};\n\n/** IDBIndex interface of the IndexedDB API provides asynchronous access to an index in a database. An index is a kind of object store for looking up records in another object store, called the referenced object store. You use this interface to retrieve data. */\ninterface IDBIndex {\n    readonly keyPath: string | string[];\n    readonly multiEntry: boolean;\n    /**\n     * Returns the name of the index.\n     */\n    name: string;\n    /**\n     * Returns the IDBObjectStore the index belongs to.\n     */\n    readonly objectStore: IDBObjectStore;\n    readonly unique: boolean;\n    /**\n     * Retrieves the number of records matching the given key or key range in query.\n     * \n     * If successful, request's result will be the count.\n     */\n    count(key?: IDBValidKey | IDBKeyRange): IDBRequest<number>;\n    /**\n     * Retrieves the value of the first record matching the given key or key range in query.\n     * \n     * If successful, request's result will be the value, or undefined if there was no matching record.\n     */\n    get(key: IDBValidKey | IDBKeyRange): IDBRequest<any | undefined>;\n    /**\n     * Retrieves the values of the records matching the given key or key range in query (up to count if given).\n     * \n     * If successful, request's result will be an Array of the values.\n     */\n    getAll(query?: IDBValidKey | IDBKeyRange | null, count?: number): IDBRequest<any[]>;\n    /**\n     * Retrieves the keys of records matching the given key or key range in query (up to count if given).\n     * \n     * If successful, request's result will be an Array of the keys.\n     */\n    getAllKeys(query?: IDBValidKey | IDBKeyRange | null, count?: number): IDBRequest<IDBValidKey[]>;\n    /**\n     * Retrieves the key of the first record matching the given key or key range in query.\n     * \n     * If successful, request's result will be the key, or undefined if there was no matching record.\n     */\n    getKey(key: IDBValidKey | IDBKeyRange): IDBRequest<IDBValidKey | undefined>;\n    /**\n     * Opens a cursor over the records matching query, ordered by direction. If query is null, all records in index are matched.\n     * \n     * If successful, request's result will be an IDBCursorWithValue, or null if there were no matching records.\n     */\n    openCursor(query?: IDBValidKey | IDBKeyRange | null, direction?: IDBCursorDirection): IDBRequest<IDBCursorWithValue | null>;\n    /**\n     * Opens a cursor with key only flag set over the records matching query, ordered by direction. If query is null, all records in index are matched.\n     * \n     * If successful, request's result will be an IDBCursor, or null if there were no matching records.\n     */\n    openKeyCursor(query?: IDBValidKey | IDBKeyRange | null, direction?: IDBCursorDirection): IDBRequest<IDBCursor | null>;\n}\n\ndeclare var IDBIndex: {\n    prototype: IDBIndex;\n    new(): IDBIndex;\n};\n\n/** A key range can be a single value or a range with upper and lower bounds or endpoints. If the key range has both upper and lower bounds, then it is bounded; if it has no bounds, it is unbounded. A bounded key range can either be open (the endpoints are excluded) or closed (the endpoints are included). To retrieve all keys within a certain range, you can use the following code constructs: */\ninterface IDBKeyRange {\n    /**\n     * Returns lower bound, or undefined if none.\n     */\n    readonly lower: any;\n    /**\n     * Returns true if the lower open flag is set, and false otherwise.\n     */\n    readonly lowerOpen: boolean;\n    /**\n     * Returns upper bound, or undefined if none.\n     */\n    readonly upper: any;\n    /**\n     * Returns true if the upper open flag is set, and false otherwise.\n     */\n    readonly upperOpen: boolean;\n    /**\n     * Returns true if key is included in the range, and false otherwise.\n     */\n    includes(key: any): boolean;\n}\n\ndeclare var IDBKeyRange: {\n    prototype: IDBKeyRange;\n    new(): IDBKeyRange;\n    /**\n     * Returns a new IDBKeyRange spanning from lower to upper. If lowerOpen is true, lower is not included in the range. If upperOpen is true, upper is not included in the range.\n     */\n    bound(lower: any, upper: any, lowerOpen?: boolean, upperOpen?: boolean): IDBKeyRange;\n    /**\n     * Returns a new IDBKeyRange starting at key with no upper bound. If open is true, key is not included in the range.\n     */\n    lowerBound(lower: any, open?: boolean): IDBKeyRange;\n    /**\n     * Returns a new IDBKeyRange spanning only key.\n     */\n    only(value: any): IDBKeyRange;\n    /**\n     * Returns a new IDBKeyRange with no lower bound and ending at key. If open is true, key is not included in the range.\n     */\n    upperBound(upper: any, open?: boolean): IDBKeyRange;\n};\n\n/** This example shows a variety of different uses of object stores, from updating the data structure with IDBObjectStore.createIndex inside an onupgradeneeded function, to adding a new item to our object store with IDBObjectStore.add. For a full working example, see our To-do Notifications app (view example live.) */\ninterface IDBObjectStore {\n    /**\n     * Returns true if the store has a key generator, and false otherwise.\n     */\n    readonly autoIncrement: boolean;\n    /**\n     * Returns a list of the names of indexes in the store.\n     */\n    readonly indexNames: DOMStringList;\n    /**\n     * Returns the key path of the store, or null if none.\n     */\n    readonly keyPath: string | string[];\n    /**\n     * Returns the name of the store.\n     */\n    name: string;\n    /**\n     * Returns the associated transaction.\n     */\n    readonly transaction: IDBTransaction;\n    /**\n     * Adds or updates a record in store with the given value and key.\n     * \n     * If the store uses in-line keys and key is specified a \"DataError\" DOMException will be thrown.\n     * \n     * If put() is used, any existing record with the key will be replaced. If add() is used, and if a record with the key already exists the request will fail, with request's error set to a \"ConstraintError\" DOMException.\n     * \n     * If successful, request's result will be the record's key.\n     */\n    add(value: any, key?: IDBValidKey): IDBRequest<IDBValidKey>;\n    /**\n     * Deletes all records in store.\n     * \n     * If successful, request's result will be undefined.\n     */\n    clear(): IDBRequest<undefined>;\n    /**\n     * Retrieves the number of records matching the given key or key range in query.\n     * \n     * If successful, request's result will be the count.\n     */\n    count(key?: IDBValidKey | IDBKeyRange): IDBRequest<number>;\n    /**\n     * Creates a new index in store with the given name, keyPath and options and returns a new IDBIndex. If the keyPath and options define constraints that cannot be satisfied with the data already in store the upgrade transaction will abort with a \"ConstraintError\" DOMException.\n     * \n     * Throws an \"InvalidStateError\" DOMException if not called within an upgrade transaction.\n     */\n    createIndex(name: string, keyPath: string | string[], options?: IDBIndexParameters): IDBIndex;\n    /**\n     * Deletes records in store with the given key or in the given key range in query.\n     * \n     * If successful, request's result will be undefined.\n     */\n    delete(key: IDBValidKey | IDBKeyRange): IDBRequest<undefined>;\n    /**\n     * Deletes the index in store with the given name.\n     * \n     * Throws an \"InvalidStateError\" DOMException if not called within an upgrade transaction.\n     */\n    deleteIndex(name: string): void;\n    /**\n     * Retrieves the value of the first record matching the given key or key range in query.\n     * \n     * If successful, request's result will be the value, or undefined if there was no matching record.\n     */\n    get(query: IDBValidKey | IDBKeyRange): IDBRequest<any | undefined>;\n    /**\n     * Retrieves the values of the records matching the given key or key range in query (up to count if given).\n     * \n     * If successful, request's result will be an Array of the values.\n     */\n    getAll(query?: IDBValidKey | IDBKeyRange | null, count?: number): IDBRequest<any[]>;\n    /**\n     * Retrieves the keys of records matching the given key or key range in query (up to count if given).\n     * \n     * If successful, request's result will be an Array of the keys.\n     */\n    getAllKeys(query?: IDBValidKey | IDBKeyRange | null, count?: number): IDBRequest<IDBValidKey[]>;\n    /**\n     * Retrieves the key of the first record matching the given key or key range in query.\n     * \n     * If successful, request's result will be the key, or undefined if there was no matching record.\n     */\n    getKey(query: IDBValidKey | IDBKeyRange): IDBRequest<IDBValidKey | undefined>;\n    index(name: string): IDBIndex;\n    /**\n     * Opens a cursor over the records matching query, ordered by direction. If query is null, all records in store are matched.\n     * \n     * If successful, request's result will be an IDBCursorWithValue pointing at the first matching record, or null if there were no matching records.\n     */\n    openCursor(query?: IDBValidKey | IDBKeyRange | null, direction?: IDBCursorDirection): IDBRequest<IDBCursorWithValue | null>;\n    /**\n     * Opens a cursor with key only flag set over the records matching query, ordered by direction. If query is null, all records in store are matched.\n     * \n     * If successful, request's result will be an IDBCursor pointing at the first matching record, or null if there were no matching records.\n     */\n    openKeyCursor(query?: IDBValidKey | IDBKeyRange | null, direction?: IDBCursorDirection): IDBRequest<IDBCursor | null>;\n    /**\n     * Adds or updates a record in store with the given value and key.\n     * \n     * If the store uses in-line keys and key is specified a \"DataError\" DOMException will be thrown.\n     * \n     * If put() is used, any existing record with the key will be replaced. If add() is used, and if a record with the key already exists the request will fail, with request's error set to a \"ConstraintError\" DOMException.\n     * \n     * If successful, request's result will be the record's key.\n     */\n    put(value: any, key?: IDBValidKey): IDBRequest<IDBValidKey>;\n}\n\ndeclare var IDBObjectStore: {\n    prototype: IDBObjectStore;\n    new(): IDBObjectStore;\n};\n\ninterface IDBOpenDBRequestEventMap extends IDBRequestEventMap {\n    \"blocked\": Event;\n    \"upgradeneeded\": IDBVersionChangeEvent;\n}\n\n/** Also inherits methods from its parents IDBRequest and EventTarget. */\ninterface IDBOpenDBRequest extends IDBRequest<IDBDatabase> {\n    onblocked: ((this: IDBOpenDBRequest, ev: Event) => any) | null;\n    onupgradeneeded: ((this: IDBOpenDBRequest, ev: IDBVersionChangeEvent) => any) | null;\n    addEventListener<K extends keyof IDBOpenDBRequestEventMap>(type: K, listener: (this: IDBOpenDBRequest, ev: IDBOpenDBRequestEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof IDBOpenDBRequestEventMap>(type: K, listener: (this: IDBOpenDBRequest, ev: IDBOpenDBRequestEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var IDBOpenDBRequest: {\n    prototype: IDBOpenDBRequest;\n    new(): IDBOpenDBRequest;\n};\n\ninterface IDBRequestEventMap {\n    \"error\": Event;\n    \"success\": Event;\n}\n\n/** The request object does not initially contain any information about the result of the operation, but once information becomes available, an event is fired on the request, and the information becomes available through the properties of the IDBRequest instance. */\ninterface IDBRequest<T = any> extends EventTarget {\n    /**\n     * When a request is completed, returns the error (a DOMException), or null if the request succeeded. Throws a \"InvalidStateError\" DOMException if the request is still pending.\n     */\n    readonly error: DOMException | null;\n    onerror: ((this: IDBRequest<T>, ev: Event) => any) | null;\n    onsuccess: ((this: IDBRequest<T>, ev: Event) => any) | null;\n    /**\n     * Returns \"pending\" until a request is complete, then returns \"done\".\n     */\n    readonly readyState: IDBRequestReadyState;\n    /**\n     * When a request is completed, returns the result, or undefined if the request failed. Throws a \"InvalidStateError\" DOMException if the request is still pending.\n     */\n    readonly result: T;\n    /**\n     * Returns the IDBObjectStore, IDBIndex, or IDBCursor the request was made against, or null if is was an open request.\n     */\n    readonly source: IDBObjectStore | IDBIndex | IDBCursor;\n    /**\n     * Returns the IDBTransaction the request was made within. If this as an open request, then it returns an upgrade transaction while it is running, or null otherwise.\n     */\n    readonly transaction: IDBTransaction | null;\n    addEventListener<K extends keyof IDBRequestEventMap>(type: K, listener: (this: IDBRequest<T>, ev: IDBRequestEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof IDBRequestEventMap>(type: K, listener: (this: IDBRequest<T>, ev: IDBRequestEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var IDBRequest: {\n    prototype: IDBRequest;\n    new(): IDBRequest;\n};\n\ninterface IDBTransactionEventMap {\n    \"abort\": Event;\n    \"complete\": Event;\n    \"error\": Event;\n}\n\ninterface IDBTransaction extends EventTarget {\n    /**\n     * Returns the transaction's connection.\n     */\n    readonly db: IDBDatabase;\n    /**\n     * If the transaction was aborted, returns the error (a DOMException) providing the reason.\n     */\n    readonly error: DOMException;\n    /**\n     * Returns the mode the transaction was created with (\"readonly\" or \"readwrite\"), or \"versionchange\" for an upgrade transaction.\n     */\n    readonly mode: IDBTransactionMode;\n    /**\n     * Returns a list of the names of object stores in the transaction's scope. For an upgrade transaction this is all object stores in the database.\n     */\n    readonly objectStoreNames: DOMStringList;\n    onabort: ((this: IDBTransaction, ev: Event) => any) | null;\n    oncomplete: ((this: IDBTransaction, ev: Event) => any) | null;\n    onerror: ((this: IDBTransaction, ev: Event) => any) | null;\n    /**\n     * Aborts the transaction. All pending requests will fail with a \"AbortError\" DOMException and all changes made to the database will be reverted.\n     */\n    abort(): void;\n    /**\n     * Returns an IDBObjectStore in the transaction's scope.\n     */\n    objectStore(name: string): IDBObjectStore;\n    addEventListener<K extends keyof IDBTransactionEventMap>(type: K, listener: (this: IDBTransaction, ev: IDBTransactionEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof IDBTransactionEventMap>(type: K, listener: (this: IDBTransaction, ev: IDBTransactionEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var IDBTransaction: {\n    prototype: IDBTransaction;\n    new(): IDBTransaction;\n};\n\n/** This IndexedDB API interface indicates that the version of the database has changed, as the result of an IDBOpenDBRequest.onupgradeneeded event handler function. */\ninterface IDBVersionChangeEvent extends Event {\n    readonly newVersion: number | null;\n    readonly oldVersion: number;\n}\n\ndeclare var IDBVersionChangeEvent: {\n    prototype: IDBVersionChangeEvent;\n    new(type: string, eventInitDict?: IDBVersionChangeEventInit): IDBVersionChangeEvent;\n};\n\n/** The IIRFilterNode interface of the Web Audio API is a AudioNode processor which implements a general infinite impulse response (IIR)  filter; this type of filter can be used to implement tone control devices and graphic equalizers as well. It lets the parameters of the filter response be specified, so that it can be tuned as needed. */\ninterface IIRFilterNode extends AudioNode {\n    getFrequencyResponse(frequencyHz: Float32Array, magResponse: Float32Array, phaseResponse: Float32Array): void;\n}\n\ndeclare var IIRFilterNode: {\n    prototype: IIRFilterNode;\n    new(context: BaseAudioContext, options: IIRFilterOptions): IIRFilterNode;\n};\n\ninterface ImageBitmap {\n    /**\n     * Returns the intrinsic height of the image, in CSS pixels.\n     */\n    readonly height: number;\n    /**\n     * Returns the intrinsic width of the image, in CSS pixels.\n     */\n    readonly width: number;\n    /**\n     * Releases imageBitmap's underlying bitmap data.\n     */\n    close(): void;\n}\n\ndeclare var ImageBitmap: {\n    prototype: ImageBitmap;\n    new(): ImageBitmap;\n};\n\ninterface ImageBitmapRenderingContext {\n    /**\n     * Returns the canvas element that the context is bound to.\n     */\n    readonly canvas: HTMLCanvasElement | OffscreenCanvas;\n    /**\n     * Transfers the underlying bitmap data from imageBitmap to context, and the bitmap becomes the contents of the canvas element to which context is bound.\n     */\n    transferFromImageBitmap(bitmap: ImageBitmap | null): void;\n}\n\ndeclare var ImageBitmapRenderingContext: {\n    prototype: ImageBitmapRenderingContext;\n    new(): ImageBitmapRenderingContext;\n};\n\n/** The underlying pixel data of an area of a <canvas> element. It is created using the ImageData() constructor or creator methods on the CanvasRenderingContext2D object associated with a canvas: createImageData() and getImageData(). It can also be used to set a part of the canvas by using putImageData(). */\ninterface ImageData {\n    /**\n     * Returns the one-dimensional array containing the data in RGBA order, as integers in the range 0 to 255.\n     */\n    readonly data: Uint8ClampedArray;\n    /**\n     * Returns the actual dimensions of the data in the ImageData object, in pixels.\n     */\n    readonly height: number;\n    /**\n     * Returns the actual dimensions of the data in the ImageData object, in pixels.\n     */\n    readonly width: number;\n}\n\ndeclare var ImageData: {\n    prototype: ImageData;\n    new(sw: number, sh: number): ImageData;\n    new(data: Uint8ClampedArray, sw: number, sh?: number): ImageData;\n};\n\ninterface InnerHTML {\n    innerHTML: string;\n}\n\ninterface InputDeviceInfo extends MediaDeviceInfo {\n    getCapabilities(): MediaTrackCapabilities;\n}\n\ndeclare var InputDeviceInfo: {\n    prototype: InputDeviceInfo;\n    new(): InputDeviceInfo;\n};\n\ninterface InputEvent extends UIEvent {\n    readonly data: string | null;\n    readonly inputType: string;\n    readonly isComposing: boolean;\n}\n\ndeclare var InputEvent: {\n    prototype: InputEvent;\n    new(type: string, eventInitDict?: InputEventInit): InputEvent;\n};\n\n/** provides a way to asynchronously observe changes in the intersection of a target element with an ancestor element or with a top-level document's viewport. */\ninterface IntersectionObserver {\n    readonly root: Element | null;\n    readonly rootMargin: string;\n    readonly thresholds: ReadonlyArray<number>;\n    disconnect(): void;\n    observe(target: Element): void;\n    takeRecords(): IntersectionObserverEntry[];\n    unobserve(target: Element): void;\n}\n\ndeclare var IntersectionObserver: {\n    prototype: IntersectionObserver;\n    new(callback: IntersectionObserverCallback, options?: IntersectionObserverInit): IntersectionObserver;\n};\n\n/** This Intersection Observer API interface describes the intersection between the target element and its root container at a specific moment of transition. */\ninterface IntersectionObserverEntry {\n    readonly boundingClientRect: DOMRectReadOnly;\n    readonly intersectionRatio: number;\n    readonly intersectionRect: DOMRectReadOnly;\n    readonly isIntersecting: boolean;\n    readonly rootBounds: DOMRectReadOnly | null;\n    readonly target: Element;\n    readonly time: number;\n}\n\ndeclare var IntersectionObserverEntry: {\n    prototype: IntersectionObserverEntry;\n    new(intersectionObserverEntryInit: IntersectionObserverEntryInit): IntersectionObserverEntry;\n};\n\n/** KeyboardEvent objects describe a user interaction with the keyboard; each event describes a single interaction between the user and a key (or combination of a key with modifier keys) on the keyboard. */\ninterface KeyboardEvent extends UIEvent {\n    readonly altKey: boolean;\n    /** @deprecated */\n    char: string;\n    /** @deprecated */\n    readonly charCode: number;\n    readonly code: string;\n    readonly ctrlKey: boolean;\n    readonly isComposing: boolean;\n    readonly key: string;\n    /** @deprecated */\n    readonly keyCode: number;\n    readonly location: number;\n    readonly metaKey: boolean;\n    readonly repeat: boolean;\n    readonly shiftKey: boolean;\n    getModifierState(keyArg: string): boolean;\n    readonly DOM_KEY_LOCATION_LEFT: number;\n    readonly DOM_KEY_LOCATION_NUMPAD: number;\n    readonly DOM_KEY_LOCATION_RIGHT: number;\n    readonly DOM_KEY_LOCATION_STANDARD: number;\n}\n\ndeclare var KeyboardEvent: {\n    prototype: KeyboardEvent;\n    new(type: string, eventInitDict?: KeyboardEventInit): KeyboardEvent;\n    readonly DOM_KEY_LOCATION_LEFT: number;\n    readonly DOM_KEY_LOCATION_NUMPAD: number;\n    readonly DOM_KEY_LOCATION_RIGHT: number;\n    readonly DOM_KEY_LOCATION_STANDARD: number;\n};\n\ninterface KeyframeEffect extends AnimationEffect {\n    composite: CompositeOperation;\n    iterationComposite: IterationCompositeOperation;\n    target: Element | null;\n    getKeyframes(): ComputedKeyframe[];\n    setKeyframes(keyframes: Keyframe[] | PropertyIndexedKeyframes | null): void;\n}\n\ndeclare var KeyframeEffect: {\n    prototype: KeyframeEffect;\n    new(target: Element | null, keyframes: Keyframe[] | PropertyIndexedKeyframes | null, options?: number | KeyframeEffectOptions): KeyframeEffect;\n    new(source: KeyframeEffect): KeyframeEffect;\n};\n\ninterface LinkStyle {\n    readonly sheet: CSSStyleSheet | null;\n}\n\ninterface ListeningStateChangedEvent extends Event {\n    readonly label: string;\n    readonly state: ListeningState;\n}\n\ndeclare var ListeningStateChangedEvent: {\n    prototype: ListeningStateChangedEvent;\n    new(): ListeningStateChangedEvent;\n};\n\n/** The location (URL) of the object it is linked to. Changes done on it are reflected on the object it relates to. Both the Document and Window interface have such a linked Location, accessible via Document.location and Window.location respectively. */\ninterface Location {\n    /**\n     * Returns a DOMStringList object listing the origins of the ancestor browsing contexts, from the parent browsing context to the top-level browsing context.\n     */\n    readonly ancestorOrigins: DOMStringList;\n    /**\n     * Returns the Location object's URL's fragment (includes leading \"#\" if non-empty).\n     * \n     * Can be set, to navigate to the same URL with a changed fragment (ignores leading \"#\").\n     */\n    hash: string;\n    /**\n     * Returns the Location object's URL's host and port (if different from the default port for the scheme).\n     * \n     * Can be set, to navigate to the same URL with a changed host and port.\n     */\n    host: string;\n    /**\n     * Returns the Location object's URL's host.\n     * \n     * Can be set, to navigate to the same URL with a changed host.\n     */\n    hostname: string;\n    /**\n     * Returns the Location object's URL.\n     * \n     * Can be set, to navigate to the given URL.\n     */\n    href: string;\n    toString(): string;\n    /**\n     * Returns the Location object's URL's origin.\n     */\n    readonly origin: string;\n    /**\n     * Returns the Location object's URL's path.\n     * \n     * Can be set, to navigate to the same URL with a changed path.\n     */\n    pathname: string;\n    /**\n     * Returns the Location object's URL's port.\n     * \n     * Can be set, to navigate to the same URL with a changed port.\n     */\n    port: string;\n    /**\n     * Returns the Location object's URL's scheme.\n     * \n     * Can be set, to navigate to the same URL with a changed scheme.\n     */\n    protocol: string;\n    /**\n     * Returns the Location object's URL's query (includes leading \"?\" if non-empty).\n     * \n     * Can be set, to navigate to the same URL with a changed query (ignores leading \"?\").\n     */\n    search: string;\n    /**\n     * Navigates to the given URL.\n     */\n    assign(url: string): void;\n    /**\n     * Reloads the current page.\n     */\n    reload(): void;\n    /** @deprecated */\n    reload(forcedReload: boolean): void;\n    /**\n     * Removes the current page from the session history and navigates to the given URL.\n     */\n    replace(url: string): void;\n}\n\ndeclare var Location: {\n    prototype: Location;\n    new(): Location;\n};\n\ninterface MSAssertion {\n    readonly id: string;\n    readonly type: MSCredentialType;\n}\n\ndeclare var MSAssertion: {\n    prototype: MSAssertion;\n    new(): MSAssertion;\n};\n\ninterface MSBlobBuilder {\n    append(data: any, endings?: string): void;\n    getBlob(contentType?: string): Blob;\n}\n\ndeclare var MSBlobBuilder: {\n    prototype: MSBlobBuilder;\n    new(): MSBlobBuilder;\n};\n\ninterface MSFIDOCredentialAssertion extends MSAssertion {\n    readonly algorithm: string | Algorithm;\n    readonly attestation: any;\n    readonly publicKey: string;\n    readonly transportHints: MSTransportType[];\n}\n\ndeclare var MSFIDOCredentialAssertion: {\n    prototype: MSFIDOCredentialAssertion;\n    new(): MSFIDOCredentialAssertion;\n};\n\ninterface MSFIDOSignature {\n    readonly authnrData: string;\n    readonly clientData: string;\n    readonly signature: string;\n}\n\ndeclare var MSFIDOSignature: {\n    prototype: MSFIDOSignature;\n    new(): MSFIDOSignature;\n};\n\ninterface MSFIDOSignatureAssertion extends MSAssertion {\n    readonly signature: MSFIDOSignature;\n}\n\ndeclare var MSFIDOSignatureAssertion: {\n    prototype: MSFIDOSignatureAssertion;\n    new(): MSFIDOSignatureAssertion;\n};\n\ninterface MSFileSaver {\n    msSaveBlob(blob: any, defaultName?: string): boolean;\n    msSaveOrOpenBlob(blob: any, defaultName?: string): boolean;\n}\n\ninterface MSGesture {\n    target: Element;\n    addPointer(pointerId: number): void;\n    stop(): void;\n}\n\ndeclare var MSGesture: {\n    prototype: MSGesture;\n    new(): MSGesture;\n};\n\n/** The MSGestureEvent is a proprietary interface specific to Internet Explorer and Microsoft Edge which represents events that occur due to touch gestures. Events using this interface include MSGestureStart, MSGestureEnd, MSGestureTap, MSGestureHold, MSGestureChange, and MSInertiaStart. */\ninterface MSGestureEvent extends UIEvent {\n    readonly clientX: number;\n    readonly clientY: number;\n    readonly expansion: number;\n    readonly gestureObject: any;\n    readonly hwTimestamp: number;\n    readonly offsetX: number;\n    readonly offsetY: number;\n    readonly rotation: number;\n    readonly scale: number;\n    readonly screenX: number;\n    readonly screenY: number;\n    readonly translationX: number;\n    readonly translationY: number;\n    readonly velocityAngular: number;\n    readonly velocityExpansion: number;\n    readonly velocityX: number;\n    readonly velocityY: number;\n    initGestureEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, detailArg: number, screenXArg: number, screenYArg: number, clientXArg: number, clientYArg: number, offsetXArg: number, offsetYArg: number, translationXArg: number, translationYArg: number, scaleArg: number, expansionArg: number, rotationArg: number, velocityXArg: number, velocityYArg: number, velocityExpansionArg: number, velocityAngularArg: number, hwTimestampArg: number): void;\n    readonly MSGESTURE_FLAG_BEGIN: number;\n    readonly MSGESTURE_FLAG_CANCEL: number;\n    readonly MSGESTURE_FLAG_END: number;\n    readonly MSGESTURE_FLAG_INERTIA: number;\n    readonly MSGESTURE_FLAG_NONE: number;\n}\n\ndeclare var MSGestureEvent: {\n    prototype: MSGestureEvent;\n    new(): MSGestureEvent;\n    readonly MSGESTURE_FLAG_BEGIN: number;\n    readonly MSGESTURE_FLAG_CANCEL: number;\n    readonly MSGESTURE_FLAG_END: number;\n    readonly MSGESTURE_FLAG_INERTIA: number;\n    readonly MSGESTURE_FLAG_NONE: number;\n};\n\n/** The msGraphicsTrust() constructor returns an object that provides properties for info on protected video playback. */\ninterface MSGraphicsTrust {\n    readonly constrictionActive: boolean;\n    readonly status: string;\n}\n\ndeclare var MSGraphicsTrust: {\n    prototype: MSGraphicsTrust;\n    new(): MSGraphicsTrust;\n};\n\ninterface MSInputMethodContextEventMap {\n    \"MSCandidateWindowHide\": Event;\n    \"MSCandidateWindowShow\": Event;\n    \"MSCandidateWindowUpdate\": Event;\n}\n\ninterface MSInputMethodContext extends EventTarget {\n    readonly compositionEndOffset: number;\n    readonly compositionStartOffset: number;\n    oncandidatewindowhide: ((this: MSInputMethodContext, ev: Event) => any) | null;\n    oncandidatewindowshow: ((this: MSInputMethodContext, ev: Event) => any) | null;\n    oncandidatewindowupdate: ((this: MSInputMethodContext, ev: Event) => any) | null;\n    readonly target: HTMLElement;\n    getCandidateWindowClientRect(): ClientRect;\n    getCompositionAlternatives(): string[];\n    hasComposition(): boolean;\n    isCandidateWindowVisible(): boolean;\n    addEventListener<K extends keyof MSInputMethodContextEventMap>(type: K, listener: (this: MSInputMethodContext, ev: MSInputMethodContextEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MSInputMethodContextEventMap>(type: K, listener: (this: MSInputMethodContext, ev: MSInputMethodContextEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MSInputMethodContext: {\n    prototype: MSInputMethodContext;\n    new(): MSInputMethodContext;\n};\n\ninterface MSMediaKeyError {\n    readonly code: number;\n    readonly systemCode: number;\n    readonly MS_MEDIA_KEYERR_CLIENT: number;\n    readonly MS_MEDIA_KEYERR_DOMAIN: number;\n    readonly MS_MEDIA_KEYERR_HARDWARECHANGE: number;\n    readonly MS_MEDIA_KEYERR_OUTPUT: number;\n    readonly MS_MEDIA_KEYERR_SERVICE: number;\n    readonly MS_MEDIA_KEYERR_UNKNOWN: number;\n}\n\ndeclare var MSMediaKeyError: {\n    prototype: MSMediaKeyError;\n    new(): MSMediaKeyError;\n    readonly MS_MEDIA_KEYERR_CLIENT: number;\n    readonly MS_MEDIA_KEYERR_DOMAIN: number;\n    readonly MS_MEDIA_KEYERR_HARDWARECHANGE: number;\n    readonly MS_MEDIA_KEYERR_OUTPUT: number;\n    readonly MS_MEDIA_KEYERR_SERVICE: number;\n    readonly MS_MEDIA_KEYERR_UNKNOWN: number;\n};\n\ninterface MSMediaKeyMessageEvent extends Event {\n    readonly destinationURL: string | null;\n    readonly message: Uint8Array;\n}\n\ndeclare var MSMediaKeyMessageEvent: {\n    prototype: MSMediaKeyMessageEvent;\n    new(): MSMediaKeyMessageEvent;\n};\n\ninterface MSMediaKeyNeededEvent extends Event {\n    readonly initData: Uint8Array | null;\n}\n\ndeclare var MSMediaKeyNeededEvent: {\n    prototype: MSMediaKeyNeededEvent;\n    new(): MSMediaKeyNeededEvent;\n};\n\ninterface MSMediaKeySession extends EventTarget {\n    readonly error: MSMediaKeyError | null;\n    readonly keySystem: string;\n    readonly sessionId: string;\n    close(): void;\n    update(key: Uint8Array): void;\n}\n\ndeclare var MSMediaKeySession: {\n    prototype: MSMediaKeySession;\n    new(): MSMediaKeySession;\n};\n\ninterface MSMediaKeys {\n    readonly keySystem: string;\n    createSession(type: string, initData: Uint8Array, cdmData?: Uint8Array | null): MSMediaKeySession;\n}\n\ndeclare var MSMediaKeys: {\n    prototype: MSMediaKeys;\n    new(keySystem: string): MSMediaKeys;\n    isTypeSupported(keySystem: string, type?: string | null): boolean;\n    isTypeSupportedWithFeatures(keySystem: string, type?: string | null): string;\n};\n\ninterface MSNavigatorDoNotTrack {\n    confirmSiteSpecificTrackingException(args: ConfirmSiteSpecificExceptionsInformation): boolean;\n    confirmWebWideTrackingException(args: ExceptionInformation): boolean;\n    removeSiteSpecificTrackingException(args: ExceptionInformation): void;\n    removeWebWideTrackingException(args: ExceptionInformation): void;\n    storeSiteSpecificTrackingException(args: StoreSiteSpecificExceptionsInformation): void;\n    storeWebWideTrackingException(args: StoreExceptionsInformation): void;\n}\n\ninterface MSPointerEvent extends MouseEvent {\n    readonly currentPoint: any;\n    readonly height: number;\n    readonly hwTimestamp: number;\n    readonly intermediatePoints: any;\n    readonly isPrimary: boolean;\n    readonly pointerId: number;\n    readonly pointerType: any;\n    readonly pressure: number;\n    readonly rotation: number;\n    readonly tiltX: number;\n    readonly tiltY: number;\n    readonly width: number;\n    getCurrentPoint(element: Element): void;\n    getIntermediatePoints(element: Element): void;\n    initPointerEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, detailArg: number, screenXArg: number, screenYArg: number, clientXArg: number, clientYArg: number, ctrlKeyArg: boolean, altKeyArg: boolean, shiftKeyArg: boolean, metaKeyArg: boolean, buttonArg: number, relatedTargetArg: EventTarget, offsetXArg: number, offsetYArg: number, widthArg: number, heightArg: number, pressure: number, rotation: number, tiltX: number, tiltY: number, pointerIdArg: number, pointerType: any, hwTimestampArg: number, isPrimary: boolean): void;\n}\n\ndeclare var MSPointerEvent: {\n    prototype: MSPointerEvent;\n    new(typeArg: string, eventInitDict?: PointerEventInit): MSPointerEvent;\n};\n\ninterface MSStream {\n    readonly type: string;\n    msClose(): void;\n    msDetachStream(): any;\n}\n\ndeclare var MSStream: {\n    prototype: MSStream;\n    new(): MSStream;\n};\n\n/** The MediaDevicesInfo interface contains information that describes a single media input or output device. */\ninterface MediaDeviceInfo {\n    readonly deviceId: string;\n    readonly groupId: string;\n    readonly kind: MediaDeviceKind;\n    readonly label: string;\n    toJSON(): any;\n}\n\ndeclare var MediaDeviceInfo: {\n    prototype: MediaDeviceInfo;\n    new(): MediaDeviceInfo;\n};\n\ninterface MediaDevicesEventMap {\n    \"devicechange\": Event;\n}\n\n/** Provides access to connected media input devices like cameras and microphones, as well as screen sharing. In essence, it lets you obtain access to any hardware source of media data. */\ninterface MediaDevices extends EventTarget {\n    ondevicechange: ((this: MediaDevices, ev: Event) => any) | null;\n    enumerateDevices(): Promise<MediaDeviceInfo[]>;\n    getSupportedConstraints(): MediaTrackSupportedConstraints;\n    getUserMedia(constraints?: MediaStreamConstraints): Promise<MediaStream>;\n    addEventListener<K extends keyof MediaDevicesEventMap>(type: K, listener: (this: MediaDevices, ev: MediaDevicesEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaDevicesEventMap>(type: K, listener: (this: MediaDevices, ev: MediaDevicesEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaDevices: {\n    prototype: MediaDevices;\n    new(): MediaDevices;\n};\n\n/** A MediaElementSourceNode has no inputs and exactly one output, and is created using the AudioContext.createMediaElementSource method. The amount of channels in the output equals the number of channels of the audio referenced by the HTMLMediaElement used in the creation of the node, or is 1 if the HTMLMediaElement has no audio. */\ninterface MediaElementAudioSourceNode extends AudioNode {\n    readonly mediaElement: HTMLMediaElement;\n}\n\ndeclare var MediaElementAudioSourceNode: {\n    prototype: MediaElementAudioSourceNode;\n    new(context: AudioContext, options: MediaElementAudioSourceOptions): MediaElementAudioSourceNode;\n};\n\ninterface MediaEncryptedEvent extends Event {\n    readonly initData: ArrayBuffer | null;\n    readonly initDataType: string;\n}\n\ndeclare var MediaEncryptedEvent: {\n    prototype: MediaEncryptedEvent;\n    new(type: string, eventInitDict?: MediaEncryptedEventInit): MediaEncryptedEvent;\n};\n\n/** An error which occurred while handling media in an HTML media element based on HTMLMediaElement, such as <audio> or <video>. */\ninterface MediaError {\n    readonly code: number;\n    readonly message: string;\n    readonly MEDIA_ERR_ABORTED: number;\n    readonly MEDIA_ERR_DECODE: number;\n    readonly MEDIA_ERR_NETWORK: number;\n    readonly MEDIA_ERR_SRC_NOT_SUPPORTED: number;\n}\n\ndeclare var MediaError: {\n    prototype: MediaError;\n    new(): MediaError;\n    readonly MEDIA_ERR_ABORTED: number;\n    readonly MEDIA_ERR_DECODE: number;\n    readonly MEDIA_ERR_NETWORK: number;\n    readonly MEDIA_ERR_SRC_NOT_SUPPORTED: number;\n};\n\n/** This EncryptedMediaExtensions API interface contains the content and related data when the content decryption module generates a message for the session. */\ninterface MediaKeyMessageEvent extends Event {\n    readonly message: ArrayBuffer;\n    readonly messageType: MediaKeyMessageType;\n}\n\ndeclare var MediaKeyMessageEvent: {\n    prototype: MediaKeyMessageEvent;\n    new(type: string, eventInitDict: MediaKeyMessageEventInit): MediaKeyMessageEvent;\n};\n\ninterface MediaKeySessionEventMap {\n    \"keystatuseschange\": Event;\n    \"message\": MediaKeyMessageEvent;\n}\n\n/** This EncryptedMediaExtensions API interface represents a context for message exchange with a content decryption module (CDM). */\ninterface MediaKeySession extends EventTarget {\n    readonly closed: Promise<void>;\n    readonly expiration: number;\n    readonly keyStatuses: MediaKeyStatusMap;\n    onkeystatuseschange: ((this: MediaKeySession, ev: Event) => any) | null;\n    onmessage: ((this: MediaKeySession, ev: MediaKeyMessageEvent) => any) | null;\n    readonly sessionId: string;\n    close(): Promise<void>;\n    generateRequest(initDataType: string, initData: BufferSource): Promise<void>;\n    load(sessionId: string): Promise<boolean>;\n    remove(): Promise<void>;\n    update(response: BufferSource): Promise<void>;\n    addEventListener<K extends keyof MediaKeySessionEventMap>(type: K, listener: (this: MediaKeySession, ev: MediaKeySessionEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaKeySessionEventMap>(type: K, listener: (this: MediaKeySession, ev: MediaKeySessionEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaKeySession: {\n    prototype: MediaKeySession;\n    new(): MediaKeySession;\n};\n\n/** This EncryptedMediaExtensions API interface is a read-only map of media key statuses by key IDs. */\ninterface MediaKeyStatusMap {\n    readonly size: number;\n    get(keyId: BufferSource): MediaKeyStatus | undefined;\n    has(keyId: BufferSource): boolean;\n    forEach(callbackfn: (value: MediaKeyStatus, key: BufferSource, parent: MediaKeyStatusMap) => void, thisArg?: any): void;\n}\n\ndeclare var MediaKeyStatusMap: {\n    prototype: MediaKeyStatusMap;\n    new(): MediaKeyStatusMap;\n};\n\n/** This EncryptedMediaExtensions API interface provides access to a Key System for decryption and/or a content protection provider. You can request an instance of this object using the Navigator.requestMediaKeySystemAccess method. */\ninterface MediaKeySystemAccess {\n    readonly keySystem: string;\n    createMediaKeys(): Promise<MediaKeys>;\n    getConfiguration(): MediaKeySystemConfiguration;\n}\n\ndeclare var MediaKeySystemAccess: {\n    prototype: MediaKeySystemAccess;\n    new(): MediaKeySystemAccess;\n};\n\n/** This EncryptedMediaExtensions API interface the represents a set of keys that an associated HTMLMediaElement can use for decryption of media data during playback. */\ninterface MediaKeys {\n    createSession(sessionType?: MediaKeySessionType): MediaKeySession;\n    setServerCertificate(serverCertificate: BufferSource): Promise<boolean>;\n}\n\ndeclare var MediaKeys: {\n    prototype: MediaKeys;\n    new(): MediaKeys;\n};\n\ninterface MediaList {\n    readonly length: number;\n    mediaText: string;\n    toString(): string;\n    appendMedium(medium: string): void;\n    deleteMedium(medium: string): void;\n    item(index: number): string | null;\n    [index: number]: string;\n}\n\ndeclare var MediaList: {\n    prototype: MediaList;\n    new(): MediaList;\n};\n\ninterface MediaQueryListEventMap {\n    \"change\": MediaQueryListEvent;\n}\n\n/** Stores information on a media query applied to a document, and handles sending notifications to listeners when the media query state change (i.e. when the media query test starts or stops evaluating to true). */\ninterface MediaQueryList extends EventTarget {\n    readonly matches: boolean;\n    readonly media: string;\n    onchange: ((this: MediaQueryList, ev: MediaQueryListEvent) => any) | null;\n    /** @deprecated */\n    addListener(listener: ((this: MediaQueryList, ev: MediaQueryListEvent) => any) | null): void;\n    /** @deprecated */\n    removeListener(listener: ((this: MediaQueryList, ev: MediaQueryListEvent) => any) | null): void;\n    addEventListener<K extends keyof MediaQueryListEventMap>(type: K, listener: (this: MediaQueryList, ev: MediaQueryListEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaQueryListEventMap>(type: K, listener: (this: MediaQueryList, ev: MediaQueryListEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaQueryList: {\n    prototype: MediaQueryList;\n    new(): MediaQueryList;\n};\n\ninterface MediaQueryListEvent extends Event {\n    readonly matches: boolean;\n    readonly media: string;\n}\n\ndeclare var MediaQueryListEvent: {\n    prototype: MediaQueryListEvent;\n    new(type: string, eventInitDict?: MediaQueryListEventInit): MediaQueryListEvent;\n};\n\ninterface MediaSourceEventMap {\n    \"sourceclose\": Event;\n    \"sourceended\": Event;\n    \"sourceopen\": Event;\n}\n\n/** This Media Source Extensions API interface represents a source of media data for an HTMLMediaElement object. A MediaSource object can be attached to a HTMLMediaElement to be played in the user agent. */\ninterface MediaSource extends EventTarget {\n    readonly activeSourceBuffers: SourceBufferList;\n    duration: number;\n    onsourceclose: ((this: MediaSource, ev: Event) => any) | null;\n    onsourceended: ((this: MediaSource, ev: Event) => any) | null;\n    onsourceopen: ((this: MediaSource, ev: Event) => any) | null;\n    readonly readyState: ReadyState;\n    readonly sourceBuffers: SourceBufferList;\n    addSourceBuffer(type: string): SourceBuffer;\n    clearLiveSeekableRange(): void;\n    endOfStream(error?: EndOfStreamError): void;\n    removeSourceBuffer(sourceBuffer: SourceBuffer): void;\n    setLiveSeekableRange(start: number, end: number): void;\n    addEventListener<K extends keyof MediaSourceEventMap>(type: K, listener: (this: MediaSource, ev: MediaSourceEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaSourceEventMap>(type: K, listener: (this: MediaSource, ev: MediaSourceEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaSource: {\n    prototype: MediaSource;\n    new(): MediaSource;\n    isTypeSupported(type: string): boolean;\n};\n\ninterface MediaStreamEventMap {\n    \"addtrack\": MediaStreamTrackEvent;\n    \"removetrack\": MediaStreamTrackEvent;\n}\n\n/** A stream of media content. A stream consists of several tracks such as video or audio tracks. Each track is specified as an instance of MediaStreamTrack. */\ninterface MediaStream extends EventTarget {\n    readonly active: boolean;\n    readonly id: string;\n    onaddtrack: ((this: MediaStream, ev: MediaStreamTrackEvent) => any) | null;\n    onremovetrack: ((this: MediaStream, ev: MediaStreamTrackEvent) => any) | null;\n    addTrack(track: MediaStreamTrack): void;\n    clone(): MediaStream;\n    getAudioTracks(): MediaStreamTrack[];\n    getTrackById(trackId: string): MediaStreamTrack | null;\n    getTracks(): MediaStreamTrack[];\n    getVideoTracks(): MediaStreamTrack[];\n    removeTrack(track: MediaStreamTrack): void;\n    addEventListener<K extends keyof MediaStreamEventMap>(type: K, listener: (this: MediaStream, ev: MediaStreamEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaStreamEventMap>(type: K, listener: (this: MediaStream, ev: MediaStreamEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaStream: {\n    prototype: MediaStream;\n    new(): MediaStream;\n    new(stream: MediaStream): MediaStream;\n    new(tracks: MediaStreamTrack[]): MediaStream;\n};\n\ninterface MediaStreamAudioDestinationNode extends AudioNode {\n    readonly stream: MediaStream;\n}\n\ndeclare var MediaStreamAudioDestinationNode: {\n    prototype: MediaStreamAudioDestinationNode;\n    new(context: AudioContext, options?: AudioNodeOptions): MediaStreamAudioDestinationNode;\n};\n\n/** A type of AudioNode which operates as an audio source whose media is received from a MediaStream obtained using the WebRTC or Media Capture and Streams APIs. */\ninterface MediaStreamAudioSourceNode extends AudioNode {\n    readonly mediaStream: MediaStream;\n}\n\ndeclare var MediaStreamAudioSourceNode: {\n    prototype: MediaStreamAudioSourceNode;\n    new(context: AudioContext, options: MediaStreamAudioSourceOptions): MediaStreamAudioSourceNode;\n};\n\ninterface MediaStreamError {\n    readonly constraintName: string | null;\n    readonly message: string | null;\n    readonly name: string;\n}\n\ndeclare var MediaStreamError: {\n    prototype: MediaStreamError;\n    new(): MediaStreamError;\n};\n\ninterface MediaStreamErrorEvent extends Event {\n    readonly error: MediaStreamError | null;\n}\n\ndeclare var MediaStreamErrorEvent: {\n    prototype: MediaStreamErrorEvent;\n    new(typeArg: string, eventInitDict?: MediaStreamErrorEventInit): MediaStreamErrorEvent;\n};\n\n/** Events that occurs in relation to a MediaStream. Two events of this type can be thrown: addstream and removestream. */\ninterface MediaStreamEvent extends Event {\n    readonly stream: MediaStream | null;\n}\n\ndeclare var MediaStreamEvent: {\n    prototype: MediaStreamEvent;\n    new(type: string, eventInitDict: MediaStreamEventInit): MediaStreamEvent;\n};\n\ninterface MediaStreamTrackEventMap {\n    \"ended\": Event;\n    \"isolationchange\": Event;\n    \"mute\": Event;\n    \"unmute\": Event;\n}\n\n/** A single media track within a stream; typically, these are audio or video tracks, but other track types may exist as well. */\ninterface MediaStreamTrack extends EventTarget {\n    enabled: boolean;\n    readonly id: string;\n    readonly isolated: boolean;\n    readonly kind: string;\n    readonly label: string;\n    readonly muted: boolean;\n    onended: ((this: MediaStreamTrack, ev: Event) => any) | null;\n    onisolationchange: ((this: MediaStreamTrack, ev: Event) => any) | null;\n    onmute: ((this: MediaStreamTrack, ev: Event) => any) | null;\n    onunmute: ((this: MediaStreamTrack, ev: Event) => any) | null;\n    readonly readyState: MediaStreamTrackState;\n    applyConstraints(constraints?: MediaTrackConstraints): Promise<void>;\n    clone(): MediaStreamTrack;\n    getCapabilities(): MediaTrackCapabilities;\n    getConstraints(): MediaTrackConstraints;\n    getSettings(): MediaTrackSettings;\n    stop(): void;\n    addEventListener<K extends keyof MediaStreamTrackEventMap>(type: K, listener: (this: MediaStreamTrack, ev: MediaStreamTrackEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MediaStreamTrackEventMap>(type: K, listener: (this: MediaStreamTrack, ev: MediaStreamTrackEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MediaStreamTrack: {\n    prototype: MediaStreamTrack;\n    new(): MediaStreamTrack;\n};\n\ninterface MediaStreamTrackAudioSourceNode extends AudioNode {\n}\n\ndeclare var MediaStreamTrackAudioSourceNode: {\n    prototype: MediaStreamTrackAudioSourceNode;\n    new(context: AudioContext, options: MediaStreamTrackAudioSourceOptions): MediaStreamTrackAudioSourceNode;\n};\n\n/** Events which indicate that a MediaStream has had tracks added to or removed from the stream through calls to Media Stream API methods. These events are sent to the stream when these changes occur. */\ninterface MediaStreamTrackEvent extends Event {\n    readonly track: MediaStreamTrack;\n}\n\ndeclare var MediaStreamTrackEvent: {\n    prototype: MediaStreamTrackEvent;\n    new(type: string, eventInitDict: MediaStreamTrackEventInit): MediaStreamTrackEvent;\n};\n\n/** This Channel Messaging API interface allows us to create a new message channel and send data through it via its two MessagePort properties. */\ninterface MessageChannel {\n    /**\n     * Returns the first MessagePort object.\n     */\n    readonly port1: MessagePort;\n    /**\n     * Returns the second MessagePort object.\n     */\n    readonly port2: MessagePort;\n}\n\ndeclare var MessageChannel: {\n    prototype: MessageChannel;\n    new(): MessageChannel;\n};\n\n/** A message received by a target object. */\ninterface MessageEvent<T = any> extends Event {\n    /**\n     * Returns the data of the message.\n     */\n    readonly data: T;\n    /**\n     * Returns the last event ID string, for server-sent events.\n     */\n    readonly lastEventId: string;\n    /**\n     * Returns the origin of the message, for server-sent events and cross-document messaging.\n     */\n    readonly origin: string;\n    /**\n     * Returns the MessagePort array sent with the message, for cross-document messaging and channel messaging.\n     */\n    readonly ports: ReadonlyArray<MessagePort>;\n    /**\n     * Returns the WindowProxy of the source window, for cross-document messaging, and the MessagePort being attached, in the connect event fired at SharedWorkerGlobalScope objects.\n     */\n    readonly source: MessageEventSource | null;\n}\n\ndeclare var MessageEvent: {\n    prototype: MessageEvent;\n    new<T>(type: string, eventInitDict?: MessageEventInit<T>): MessageEvent<T>;\n};\n\ninterface MessagePortEventMap {\n    \"message\": MessageEvent;\n    \"messageerror\": MessageEvent;\n}\n\n/** This Channel Messaging API interface represents one of the two ports of a MessageChannel, allowing messages to be sent from one port and listening out for them arriving at the other. */\ninterface MessagePort extends EventTarget {\n    onmessage: ((this: MessagePort, ev: MessageEvent) => any) | null;\n    onmessageerror: ((this: MessagePort, ev: MessageEvent) => any) | null;\n    /**\n     * Disconnects the port, so that it is no longer active.\n     */\n    close(): void;\n    /**\n     * Posts a message through the channel. Objects listed in transfer are transferred, not just cloned, meaning that they are no longer usable on the sending side.\n     * \n     * Throws a \"DataCloneError\" DOMException if transfer contains duplicate objects or port, or if message could not be cloned.\n     */\n    postMessage(message: any, transfer: Transferable[]): void;\n    postMessage(message: any, options?: PostMessageOptions): void;\n    /**\n     * Begins dispatching messages received on the port.\n     */\n    start(): void;\n    addEventListener<K extends keyof MessagePortEventMap>(type: K, listener: (this: MessagePort, ev: MessagePortEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof MessagePortEventMap>(type: K, listener: (this: MessagePort, ev: MessagePortEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var MessagePort: {\n    prototype: MessagePort;\n    new(): MessagePort;\n};\n\n/** Provides contains information about a MIME type associated with a particular plugin. NavigatorPlugins.mimeTypes returns an array of this object. */\ninterface MimeType {\n    /**\n     * Returns the MIME type's description.\n     */\n    readonly description: string;\n    /**\n     * Returns the Plugin object that implements this MIME type.\n     */\n    readonly enabledPlugin: Plugin;\n    /**\n     * Returns the MIME type's typical file extensions, in a comma-separated list.\n     */\n    readonly suffixes: string;\n    /**\n     * Returns the MIME type.\n     */\n    readonly type: string;\n}\n\ndeclare var MimeType: {\n    prototype: MimeType;\n    new(): MimeType;\n};\n\n/** Returns an array of MimeType instances, each of which contains information about a supported browser plugins. This object is returned by NavigatorPlugins.mimeTypes. */\ninterface MimeTypeArray {\n    readonly length: number;\n    item(index: number): MimeType | null;\n    namedItem(name: string): MimeType | null;\n    [index: number]: MimeType;\n}\n\ndeclare var MimeTypeArray: {\n    prototype: MimeTypeArray;\n    new(): MimeTypeArray;\n};\n\n/** Events that occur due to the user interacting with a pointing device (such as a mouse). Common events using this interface include click, dblclick, mouseup, mousedown. */\ninterface MouseEvent extends UIEvent {\n    readonly altKey: boolean;\n    readonly button: number;\n    readonly buttons: number;\n    readonly clientX: number;\n    readonly clientY: number;\n    readonly ctrlKey: boolean;\n    readonly metaKey: boolean;\n    readonly movementX: number;\n    readonly movementY: number;\n    readonly offsetX: number;\n    readonly offsetY: number;\n    readonly pageX: number;\n    readonly pageY: number;\n    readonly relatedTarget: EventTarget | null;\n    readonly screenX: number;\n    readonly screenY: number;\n    readonly shiftKey: boolean;\n    readonly x: number;\n    readonly y: number;\n    getModifierState(keyArg: string): boolean;\n    initMouseEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, detailArg: number, screenXArg: number, screenYArg: number, clientXArg: number, clientYArg: number, ctrlKeyArg: boolean, altKeyArg: boolean, shiftKeyArg: boolean, metaKeyArg: boolean, buttonArg: number, relatedTargetArg: EventTarget | null): void;\n}\n\ndeclare var MouseEvent: {\n    prototype: MouseEvent;\n    new(type: string, eventInitDict?: MouseEventInit): MouseEvent;\n};\n\n/** Provides event properties that are specific to modifications to the Document Object Model (DOM) hierarchy and nodes. */\ninterface MutationEvent extends Event {\n    readonly attrChange: number;\n    readonly attrName: string;\n    readonly newValue: string;\n    readonly prevValue: string;\n    readonly relatedNode: Node;\n    initMutationEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, relatedNodeArg: Node, prevValueArg: string, newValueArg: string, attrNameArg: string, attrChangeArg: number): void;\n    readonly ADDITION: number;\n    readonly MODIFICATION: number;\n    readonly REMOVAL: number;\n}\n\ndeclare var MutationEvent: {\n    prototype: MutationEvent;\n    new(): MutationEvent;\n    readonly ADDITION: number;\n    readonly MODIFICATION: number;\n    readonly REMOVAL: number;\n};\n\n/** Provides the ability to watch for changes being made to the DOM tree. It is designed as a replacement for the older Mutation Events feature which was part of the DOM3 Events specification. */\ninterface MutationObserver {\n    /**\n     * Stops observer from observing any mutations. Until the observe() method is used again, observer's callback will not be invoked.\n     */\n    disconnect(): void;\n    /**\n     * Instructs the user agent to observe a given target (a node) and report any mutations based on the criteria given by options (an object).\n     * \n     * The options argument allows for setting mutation observation options via object members.\n     */\n    observe(target: Node, options?: MutationObserverInit): void;\n    /**\n     * Empties the record queue and returns what was in there.\n     */\n    takeRecords(): MutationRecord[];\n}\n\ndeclare var MutationObserver: {\n    prototype: MutationObserver;\n    new(callback: MutationCallback): MutationObserver;\n};\n\n/** A MutationRecord represents an individual DOM mutation. It is the object that is passed to MutationObserver's callback. */\ninterface MutationRecord {\n    /**\n     * Return the nodes added and removed respectively.\n     */\n    readonly addedNodes: NodeList;\n    /**\n     * Returns the local name of the changed attribute, and null otherwise.\n     */\n    readonly attributeName: string | null;\n    /**\n     * Returns the namespace of the changed attribute, and null otherwise.\n     */\n    readonly attributeNamespace: string | null;\n    /**\n     * Return the previous and next sibling respectively of the added or removed nodes, and null otherwise.\n     */\n    readonly nextSibling: Node | null;\n    /**\n     * The return value depends on type. For \"attributes\", it is the value of the changed attribute before the change. For \"characterData\", it is the data of the changed node before the change. For \"childList\", it is null.\n     */\n    readonly oldValue: string | null;\n    /**\n     * Return the previous and next sibling respectively of the added or removed nodes, and null otherwise.\n     */\n    readonly previousSibling: Node | null;\n    /**\n     * Return the nodes added and removed respectively.\n     */\n    readonly removedNodes: NodeList;\n    /**\n     * Returns the node the mutation affected, depending on the type. For \"attributes\", it is the element whose attribute changed. For \"characterData\", it is the CharacterData node. For \"childList\", it is the node whose children changed.\n     */\n    readonly target: Node;\n    /**\n     * Returns \"attributes\" if it was an attribute mutation. \"characterData\" if it was a mutation to a CharacterData node. And \"childList\" if it was a mutation to the tree of nodes.\n     */\n    readonly type: MutationRecordType;\n}\n\ndeclare var MutationRecord: {\n    prototype: MutationRecord;\n    new(): MutationRecord;\n};\n\n/** A collection of Attr objects. Objects inside a NamedNodeMap are not in any particular order, unlike NodeList, although they may be accessed by an index as in an array. */\ninterface NamedNodeMap {\n    readonly length: number;\n    getNamedItem(qualifiedName: string): Attr | null;\n    getNamedItemNS(namespace: string | null, localName: string): Attr | null;\n    item(index: number): Attr | null;\n    removeNamedItem(qualifiedName: string): Attr;\n    removeNamedItemNS(namespace: string | null, localName: string): Attr;\n    setNamedItem(attr: Attr): Attr | null;\n    setNamedItemNS(attr: Attr): Attr | null;\n    [index: number]: Attr;\n}\n\ndeclare var NamedNodeMap: {\n    prototype: NamedNodeMap;\n    new(): NamedNodeMap;\n};\n\ninterface NavigationPreloadManager {\n    disable(): Promise<void>;\n    enable(): Promise<void>;\n    getState(): Promise<NavigationPreloadState>;\n    setHeaderValue(value: string): Promise<void>;\n}\n\ndeclare var NavigationPreloadManager: {\n    prototype: NavigationPreloadManager;\n    new(): NavigationPreloadManager;\n};\n\n/** The state and the identity of the user agent. It allows scripts to query it and to register themselves to carry on some activities. */\ninterface Navigator extends MSFileSaver, MSNavigatorDoNotTrack, NavigatorAutomationInformation, NavigatorBeacon, NavigatorConcurrentHardware, NavigatorContentUtils, NavigatorCookies, NavigatorID, NavigatorLanguage, NavigatorOnLine, NavigatorPlugins, NavigatorStorage {\n    readonly activeVRDisplays: ReadonlyArray<VRDisplay>;\n    readonly clipboard: Clipboard;\n    readonly credentials: CredentialsContainer;\n    readonly doNotTrack: string | null;\n    readonly geolocation: Geolocation;\n    readonly maxTouchPoints: number;\n    readonly mediaDevices: MediaDevices;\n    readonly msManipulationViewsEnabled: boolean;\n    readonly msMaxTouchPoints: number;\n    readonly msPointerEnabled: boolean;\n    readonly permissions: Permissions;\n    readonly pointerEnabled: boolean;\n    readonly serviceWorker: ServiceWorkerContainer;\n    getGamepads(): (Gamepad | null)[];\n    getUserMedia(constraints: MediaStreamConstraints, successCallback: NavigatorUserMediaSuccessCallback, errorCallback: NavigatorUserMediaErrorCallback): void;\n    getVRDisplays(): Promise<VRDisplay[]>;\n    msLaunchUri(uri: string, successCallback?: MSLaunchUriCallback, noHandlerCallback?: MSLaunchUriCallback): void;\n    requestMediaKeySystemAccess(keySystem: string, supportedConfigurations: MediaKeySystemConfiguration[]): Promise<MediaKeySystemAccess>;\n    sendBeacon(url: string, data?: BodyInit | null): boolean;\n    share(data?: ShareData): Promise<void>;\n    vibrate(pattern: number | number[]): boolean;\n}\n\ndeclare var Navigator: {\n    prototype: Navigator;\n    new(): Navigator;\n};\n\ninterface NavigatorAutomationInformation {\n    readonly webdriver: boolean;\n}\n\ninterface NavigatorBeacon {\n    sendBeacon(url: string, data?: Blob | Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer | FormData | string | null): boolean;\n}\n\ninterface NavigatorConcurrentHardware {\n    readonly hardwareConcurrency: number;\n}\n\ninterface NavigatorContentUtils {\n    registerProtocolHandler(scheme: string, url: string, title: string): void;\n    unregisterProtocolHandler(scheme: string, url: string): void;\n}\n\ninterface NavigatorCookies {\n    readonly cookieEnabled: boolean;\n}\n\ninterface NavigatorID {\n    readonly appCodeName: string;\n    readonly appName: string;\n    readonly appVersion: string;\n    readonly platform: string;\n    readonly product: string;\n    readonly productSub: string;\n    readonly userAgent: string;\n    readonly vendor: string;\n    readonly vendorSub: string;\n}\n\ninterface NavigatorLanguage {\n    readonly language: string;\n    readonly languages: ReadonlyArray<string>;\n}\n\ninterface NavigatorOnLine {\n    readonly onLine: boolean;\n}\n\ninterface NavigatorPlugins {\n    readonly mimeTypes: MimeTypeArray;\n    readonly plugins: PluginArray;\n    javaEnabled(): boolean;\n}\n\ninterface NavigatorStorage {\n    readonly storage: StorageManager;\n}\n\n/** Node is an interface from which a number of DOM API object types inherit. It allows those types to be treated similarly; for example, inheriting the same set of methods, or being tested in the same way. */\ninterface Node extends EventTarget {\n    /**\n     * Returns node's node document's document base URL.\n     */\n    readonly baseURI: string;\n    /**\n     * Returns the children.\n     */\n    readonly childNodes: NodeListOf<ChildNode>;\n    /**\n     * Returns the first child.\n     */\n    readonly firstChild: ChildNode | null;\n    /**\n     * Returns true if node is connected and false otherwise.\n     */\n    readonly isConnected: boolean;\n    /**\n     * Returns the last child.\n     */\n    readonly lastChild: ChildNode | null;\n    /** @deprecated */\n    readonly namespaceURI: string | null;\n    /**\n     * Returns the next sibling.\n     */\n    readonly nextSibling: ChildNode | null;\n    /**\n     * Returns a string appropriate for the type of node.\n     */\n    readonly nodeName: string;\n    /**\n     * Returns the type of node.\n     */\n    readonly nodeType: number;\n    nodeValue: string | null;\n    /**\n     * Returns the node document. Returns null for documents.\n     */\n    readonly ownerDocument: Document | null;\n    /**\n     * Returns the parent element.\n     */\n    readonly parentElement: HTMLElement | null;\n    /**\n     * Returns the parent.\n     */\n    readonly parentNode: Node & ParentNode | null;\n    /**\n     * Returns the previous sibling.\n     */\n    readonly previousSibling: ChildNode | null;\n    textContent: string | null;\n    appendChild<T extends Node>(newChild: T): T;\n    /**\n     * Returns a copy of node. If deep is true, the copy also includes the node's descendants.\n     */\n    cloneNode(deep?: boolean): Node;\n    /**\n     * Returns a bitmask indicating the position of other relative to node.\n     */\n    compareDocumentPosition(other: Node): number;\n    /**\n     * Returns true if other is an inclusive descendant of node, and false otherwise.\n     */\n    contains(other: Node | null): boolean;\n    /**\n     * Returns node's root.\n     */\n    getRootNode(options?: GetRootNodeOptions): Node;\n    /**\n     * Returns whether node has children.\n     */\n    hasChildNodes(): boolean;\n    insertBefore<T extends Node>(newChild: T, refChild: Node | null): T;\n    isDefaultNamespace(namespace: string | null): boolean;\n    /**\n     * Returns whether node and otherNode have the same properties.\n     */\n    isEqualNode(otherNode: Node | null): boolean;\n    isSameNode(otherNode: Node | null): boolean;\n    lookupNamespaceURI(prefix: string | null): string | null;\n    lookupPrefix(namespace: string | null): string | null;\n    /**\n     * Removes empty exclusive Text nodes and concatenates the data of remaining contiguous exclusive Text nodes into the first of their nodes.\n     */\n    normalize(): void;\n    removeChild<T extends Node>(oldChild: T): T;\n    replaceChild<T extends Node>(newChild: Node, oldChild: T): T;\n    readonly ATTRIBUTE_NODE: number;\n    /**\n     * node is a CDATASection node.\n     */\n    readonly CDATA_SECTION_NODE: number;\n    /**\n     * node is a Comment node.\n     */\n    readonly COMMENT_NODE: number;\n    /**\n     * node is a DocumentFragment node.\n     */\n    readonly DOCUMENT_FRAGMENT_NODE: number;\n    /**\n     * node is a document.\n     */\n    readonly DOCUMENT_NODE: number;\n    /**\n     * Set when other is a descendant of node.\n     */\n    readonly DOCUMENT_POSITION_CONTAINED_BY: number;\n    /**\n     * Set when other is an ancestor of node.\n     */\n    readonly DOCUMENT_POSITION_CONTAINS: number;\n    /**\n     * Set when node and other are not in the same tree.\n     */\n    readonly DOCUMENT_POSITION_DISCONNECTED: number;\n    /**\n     * Set when other is following node.\n     */\n    readonly DOCUMENT_POSITION_FOLLOWING: number;\n    readonly DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC: number;\n    /**\n     * Set when other is preceding node.\n     */\n    readonly DOCUMENT_POSITION_PRECEDING: number;\n    /**\n     * node is a doctype.\n     */\n    readonly DOCUMENT_TYPE_NODE: number;\n    /**\n     * node is an element.\n     */\n    readonly ELEMENT_NODE: number;\n    readonly ENTITY_NODE: number;\n    readonly ENTITY_REFERENCE_NODE: number;\n    readonly NOTATION_NODE: number;\n    /**\n     * node is a ProcessingInstruction node.\n     */\n    readonly PROCESSING_INSTRUCTION_NODE: number;\n    /**\n     * node is a Text node.\n     */\n    readonly TEXT_NODE: number;\n}\n\ndeclare var Node: {\n    prototype: Node;\n    new(): Node;\n    readonly ATTRIBUTE_NODE: number;\n    /**\n     * node is a CDATASection node.\n     */\n    readonly CDATA_SECTION_NODE: number;\n    /**\n     * node is a Comment node.\n     */\n    readonly COMMENT_NODE: number;\n    /**\n     * node is a DocumentFragment node.\n     */\n    readonly DOCUMENT_FRAGMENT_NODE: number;\n    /**\n     * node is a document.\n     */\n    readonly DOCUMENT_NODE: number;\n    /**\n     * Set when other is a descendant of node.\n     */\n    readonly DOCUMENT_POSITION_CONTAINED_BY: number;\n    /**\n     * Set when other is an ancestor of node.\n     */\n    readonly DOCUMENT_POSITION_CONTAINS: number;\n    /**\n     * Set when node and other are not in the same tree.\n     */\n    readonly DOCUMENT_POSITION_DISCONNECTED: number;\n    /**\n     * Set when other is following node.\n     */\n    readonly DOCUMENT_POSITION_FOLLOWING: number;\n    readonly DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC: number;\n    /**\n     * Set when other is preceding node.\n     */\n    readonly DOCUMENT_POSITION_PRECEDING: number;\n    /**\n     * node is a doctype.\n     */\n    readonly DOCUMENT_TYPE_NODE: number;\n    /**\n     * node is an element.\n     */\n    readonly ELEMENT_NODE: number;\n    readonly ENTITY_NODE: number;\n    readonly ENTITY_REFERENCE_NODE: number;\n    readonly NOTATION_NODE: number;\n    /**\n     * node is a ProcessingInstruction node.\n     */\n    readonly PROCESSING_INSTRUCTION_NODE: number;\n    /**\n     * node is a Text node.\n     */\n    readonly TEXT_NODE: number;\n};\n\n/** An object used to filter the nodes in a NodeIterator or TreeWalker. They don't know anything about the DOM or how to traverse nodes; they just know how to evaluate a single node against the provided filter. */\ninterface NodeFilter {\n    acceptNode(node: Node): number;\n}\n\ndeclare var NodeFilter: {\n    readonly FILTER_ACCEPT: number;\n    readonly FILTER_REJECT: number;\n    readonly FILTER_SKIP: number;\n    readonly SHOW_ALL: number;\n    readonly SHOW_ATTRIBUTE: number;\n    readonly SHOW_CDATA_SECTION: number;\n    readonly SHOW_COMMENT: number;\n    readonly SHOW_DOCUMENT: number;\n    readonly SHOW_DOCUMENT_FRAGMENT: number;\n    readonly SHOW_DOCUMENT_TYPE: number;\n    readonly SHOW_ELEMENT: number;\n    readonly SHOW_ENTITY: number;\n    readonly SHOW_ENTITY_REFERENCE: number;\n    readonly SHOW_NOTATION: number;\n    readonly SHOW_PROCESSING_INSTRUCTION: number;\n    readonly SHOW_TEXT: number;\n};\n\n/** An iterator over the members of a list of the nodes in a subtree of the DOM. The nodes will be returned in document order. */\ninterface NodeIterator {\n    readonly filter: NodeFilter | null;\n    readonly pointerBeforeReferenceNode: boolean;\n    readonly referenceNode: Node;\n    readonly root: Node;\n    readonly whatToShow: number;\n    detach(): void;\n    nextNode(): Node | null;\n    previousNode(): Node | null;\n}\n\ndeclare var NodeIterator: {\n    prototype: NodeIterator;\n    new(): NodeIterator;\n};\n\n/** NodeList objects are collections of nodes, usually returned by properties such as Node.childNodes and methods such as document.querySelectorAll(). */\ninterface NodeList {\n    /**\n     * Returns the number of nodes in the collection.\n     */\n    readonly length: number;\n    /**\n     * Returns the node with index index from the collection. The nodes are sorted in tree order.\n     */\n    item(index: number): Node | null;\n    /**\n     * Performs the specified action for each node in an list.\n     * @param callbackfn  A function that accepts up to three arguments. forEach calls the callbackfn function one time for each element in the list.\n     * @param thisArg  An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n     */\n    forEach(callbackfn: (value: Node, key: number, parent: NodeList) => void, thisArg?: any): void;\n    [index: number]: Node;\n}\n\ndeclare var NodeList: {\n    prototype: NodeList;\n    new(): NodeList;\n};\n\ninterface NodeListOf<TNode extends Node> extends NodeList {\n    length: number;\n    item(index: number): TNode;\n    /**\n     * Performs the specified action for each node in an list.\n     * @param callbackfn  A function that accepts up to three arguments. forEach calls the callbackfn function one time for each element in the list.\n     * @param thisArg  An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.\n     */\n    forEach(callbackfn: (value: TNode, key: number, parent: NodeListOf<TNode>) => void, thisArg?: any): void;\n    [index: number]: TNode;\n}\n\ninterface NonDocumentTypeChildNode {\n    /**\n     * Returns the first following sibling that is an element, and null otherwise.\n     */\n    readonly nextElementSibling: Element | null;\n    /**\n     * Returns the first preceding sibling that is an element, and null otherwise.\n     */\n    readonly previousElementSibling: Element | null;\n}\n\ninterface NonElementParentNode {\n    /**\n     * Returns the first element within node's descendants whose ID is elementId.\n     */\n    getElementById(elementId: string): Element | null;\n}\n\ninterface NotificationEventMap {\n    \"click\": Event;\n    \"close\": Event;\n    \"error\": Event;\n    \"show\": Event;\n}\n\n/** This Notifications API interface is used to configure and display desktop notifications to the user. */\ninterface Notification extends EventTarget {\n    readonly actions: ReadonlyArray<NotificationAction>;\n    readonly badge: string;\n    readonly body: string;\n    readonly data: any;\n    readonly dir: NotificationDirection;\n    readonly icon: string;\n    readonly image: string;\n    readonly lang: string;\n    onclick: ((this: Notification, ev: Event) => any) | null;\n    onclose: ((this: Notification, ev: Event) => any) | null;\n    onerror: ((this: Notification, ev: Event) => any) | null;\n    onshow: ((this: Notification, ev: Event) => any) | null;\n    readonly renotify: boolean;\n    readonly requireInteraction: boolean;\n    readonly silent: boolean;\n    readonly tag: string;\n    readonly timestamp: number;\n    readonly title: string;\n    readonly vibrate: ReadonlyArray<number>;\n    close(): void;\n    addEventListener<K extends keyof NotificationEventMap>(type: K, listener: (this: Notification, ev: NotificationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof NotificationEventMap>(type: K, listener: (this: Notification, ev: NotificationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Notification: {\n    prototype: Notification;\n    new(title: string, options?: NotificationOptions): Notification;\n    readonly maxActions: number;\n    readonly permission: NotificationPermission;\n    requestPermission(deprecatedCallback?: NotificationPermissionCallback): Promise<NotificationPermission>;\n};\n\n/** The OES_element_index_uint extension is part of the WebGL API and adds support for gl.UNSIGNED_INT types to WebGLRenderingContext.drawElements(). */\ninterface OES_element_index_uint {\n}\n\n/** The OES_standard_derivatives extension is part of the WebGL API and adds the GLSL derivative functions dFdx, dFdy, and fwidth. */\ninterface OES_standard_derivatives {\n    readonly FRAGMENT_SHADER_DERIVATIVE_HINT_OES: GLenum;\n}\n\n/** The OES_texture_float extension is part of the WebGL API and exposes floating-point pixel types for textures. */\ninterface OES_texture_float {\n}\n\n/** The OES_texture_float_linear extension is part of the WebGL API and allows linear filtering with floating-point pixel types for textures. */\ninterface OES_texture_float_linear {\n}\n\n/** The OES_texture_half_float extension is part of the WebGL API and adds texture formats with 16- (aka half float) and 32-bit floating-point components. */\ninterface OES_texture_half_float {\n    readonly HALF_FLOAT_OES: GLenum;\n}\n\n/** The OES_texture_half_float_linear extension is part of the WebGL API and allows linear filtering with half floating-point pixel types for textures. */\ninterface OES_texture_half_float_linear {\n}\n\ninterface OES_vertex_array_object {\n    bindVertexArrayOES(arrayObject: WebGLVertexArrayObjectOES | null): void;\n    createVertexArrayOES(): WebGLVertexArrayObjectOES | null;\n    deleteVertexArrayOES(arrayObject: WebGLVertexArrayObjectOES | null): void;\n    isVertexArrayOES(arrayObject: WebGLVertexArrayObjectOES | null): GLboolean;\n    readonly VERTEX_ARRAY_BINDING_OES: GLenum;\n}\n\n/** The Web Audio API OfflineAudioCompletionEvent interface represents events that occur when the processing of an OfflineAudioContext is terminated. The complete event implements this interface. */\ninterface OfflineAudioCompletionEvent extends Event {\n    readonly renderedBuffer: AudioBuffer;\n}\n\ndeclare var OfflineAudioCompletionEvent: {\n    prototype: OfflineAudioCompletionEvent;\n    new(type: string, eventInitDict: OfflineAudioCompletionEventInit): OfflineAudioCompletionEvent;\n};\n\ninterface OfflineAudioContextEventMap extends BaseAudioContextEventMap {\n    \"complete\": OfflineAudioCompletionEvent;\n}\n\n/** An AudioContext interface representing an audio-processing graph built from linked together AudioNodes. In contrast with a standard AudioContext, an OfflineAudioContext doesn't render the audio to the device hardware; instead, it generates it, as fast as it can, and outputs the result to an AudioBuffer. */\ninterface OfflineAudioContext extends BaseAudioContext {\n    readonly length: number;\n    oncomplete: ((this: OfflineAudioContext, ev: OfflineAudioCompletionEvent) => any) | null;\n    resume(): Promise<void>;\n    startRendering(): Promise<AudioBuffer>;\n    suspend(suspendTime: number): Promise<void>;\n    addEventListener<K extends keyof OfflineAudioContextEventMap>(type: K, listener: (this: OfflineAudioContext, ev: OfflineAudioContextEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof OfflineAudioContextEventMap>(type: K, listener: (this: OfflineAudioContext, ev: OfflineAudioContextEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var OfflineAudioContext: {\n    prototype: OfflineAudioContext;\n    new(contextOptions: OfflineAudioContextOptions): OfflineAudioContext;\n    new(numberOfChannels: number, length: number, sampleRate: number): OfflineAudioContext;\n};\n\ninterface OffscreenCanvas extends EventTarget {\n    /**\n     * These attributes return the dimensions of the OffscreenCanvas object's bitmap.\n     * \n     * They can be set, to replace the bitmap with a new, transparent black bitmap of the specified dimensions (effectively resizing it).\n     */\n    height: number;\n    /**\n     * These attributes return the dimensions of the OffscreenCanvas object's bitmap.\n     * \n     * They can be set, to replace the bitmap with a new, transparent black bitmap of the specified dimensions (effectively resizing it).\n     */\n    width: number;\n    /**\n     * Returns a promise that will fulfill with a new Blob object representing a file containing the image in the OffscreenCanvas object.\n     * \n     * The argument, if provided, is a dictionary that controls the encoding options of the image file to be created. The type field specifies the file format and has a default value of \"image/png\"; that type is also used if the requested type isn't supported. If the image format supports variable quality (such as \"image/jpeg\"), then the quality field is a number in the range 0.0 to 1.0 inclusive indicating the desired quality level for the resulting image.\n     */\n    convertToBlob(options?: ImageEncodeOptions): Promise<Blob>;\n    /**\n     * Returns an object that exposes an API for drawing on the OffscreenCanvas object. contextId specifies the desired API: \"2d\", \"bitmaprenderer\", \"webgl\", or \"webgl2\". options is handled by that API.\n     * \n     * This specification defines the \"2d\" context below, which is similar but distinct from the \"2d\" context that is created from a canvas element. The WebGL specifications define the \"webgl\" and \"webgl2\" contexts. [WEBGL]\n     * \n     * Returns null if the canvas has already been initialized with another context type (e.g., trying to get a \"2d\" context after getting a \"webgl\" context).\n     */\n    getContext(contextId: \"2d\", options?: CanvasRenderingContext2DSettings): OffscreenCanvasRenderingContext2D | null;\n    getContext(contextId: \"bitmaprenderer\", options?: ImageBitmapRenderingContextSettings): ImageBitmapRenderingContext | null;\n    getContext(contextId: \"webgl\", options?: WebGLContextAttributes): WebGLRenderingContext | null;\n    getContext(contextId: \"webgl2\", options?: WebGLContextAttributes): WebGL2RenderingContext | null;\n    getContext(contextId: OffscreenRenderingContextId, options?: any): OffscreenRenderingContext | null;\n    /**\n     * Returns a newly created ImageBitmap object with the image in the OffscreenCanvas object. The image in the OffscreenCanvas object is replaced with a new blank image.\n     */\n    transferToImageBitmap(): ImageBitmap;\n}\n\ndeclare var OffscreenCanvas: {\n    prototype: OffscreenCanvas;\n    new(width: number, height: number): OffscreenCanvas;\n};\n\ninterface OffscreenCanvasRenderingContext2D extends CanvasCompositing, CanvasDrawImage, CanvasDrawPath, CanvasFillStrokeStyles, CanvasFilters, CanvasImageData, CanvasImageSmoothing, CanvasPath, CanvasPathDrawingStyles, CanvasRect, CanvasShadowStyles, CanvasState, CanvasText, CanvasTextDrawingStyles, CanvasTransform {\n    readonly canvas: OffscreenCanvas;\n    commit(): void;\n}\n\ndeclare var OffscreenCanvasRenderingContext2D: {\n    prototype: OffscreenCanvasRenderingContext2D;\n    new(): OffscreenCanvasRenderingContext2D;\n};\n\n/** The OscillatorNode interface represents a periodic waveform, such as a sine wave. It is an AudioScheduledSourceNode audio-processing module that causes a specified frequency of a given wave to be created—in effect, a constant tone. */\ninterface OscillatorNode extends AudioScheduledSourceNode {\n    readonly detune: AudioParam;\n    readonly frequency: AudioParam;\n    type: OscillatorType;\n    setPeriodicWave(periodicWave: PeriodicWave): void;\n    addEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: OscillatorNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AudioScheduledSourceNodeEventMap>(type: K, listener: (this: OscillatorNode, ev: AudioScheduledSourceNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var OscillatorNode: {\n    prototype: OscillatorNode;\n    new(context: BaseAudioContext, options?: OscillatorOptions): OscillatorNode;\n};\n\ninterface OverconstrainedError extends Error {\n    constraint: string;\n}\n\ndeclare var OverconstrainedError: {\n    prototype: OverconstrainedError;\n    new(): OverconstrainedError;\n};\n\ninterface OverflowEvent extends UIEvent {\n    readonly horizontalOverflow: boolean;\n    readonly orient: number;\n    readonly verticalOverflow: boolean;\n    readonly BOTH: number;\n    readonly HORIZONTAL: number;\n    readonly VERTICAL: number;\n}\n\ndeclare var OverflowEvent: {\n    prototype: OverflowEvent;\n    new(): OverflowEvent;\n    readonly BOTH: number;\n    readonly HORIZONTAL: number;\n    readonly VERTICAL: number;\n};\n\n/** The PageTransitionEvent is fired when a document is being loaded or unloaded. */\ninterface PageTransitionEvent extends Event {\n    /**\n     * For the pageshow event, returns false if the page is newly being loaded (and the load event will fire). Otherwise, returns true.\n     * \n     * For the pagehide event, returns false if the page is going away for the last time. Otherwise, returns true, meaning that (if nothing conspires to make the page unsalvageable) the page might be reused if the user navigates back to this page.\n     * \n     * Things that can cause the page to be unsalvageable include:\n     * \n     * Listening for beforeunload events\n     * Listening for unload events\n     * Having iframes that are not salvageable\n     * Active WebSocket objects\n     * Aborting a Document\n     */\n    readonly persisted: boolean;\n}\n\ndeclare var PageTransitionEvent: {\n    prototype: PageTransitionEvent;\n    new(type: string, eventInitDict?: PageTransitionEventInit): PageTransitionEvent;\n};\n\n/** A PannerNode always has exactly one input and one output: the input can be mono or stereo but the output is always stereo (2 channels); you can't have panning effects without at least two audio channels! */\ninterface PannerNode extends AudioNode {\n    coneInnerAngle: number;\n    coneOuterAngle: number;\n    coneOuterGain: number;\n    distanceModel: DistanceModelType;\n    maxDistance: number;\n    readonly orientationX: AudioParam;\n    readonly orientationY: AudioParam;\n    readonly orientationZ: AudioParam;\n    panningModel: PanningModelType;\n    readonly positionX: AudioParam;\n    readonly positionY: AudioParam;\n    readonly positionZ: AudioParam;\n    refDistance: number;\n    rolloffFactor: number;\n    /** @deprecated */\n    setOrientation(x: number, y: number, z: number): void;\n    /** @deprecated */\n    setPosition(x: number, y: number, z: number): void;\n}\n\ndeclare var PannerNode: {\n    prototype: PannerNode;\n    new(context: BaseAudioContext, options?: PannerOptions): PannerNode;\n};\n\ninterface ParentNode {\n    readonly childElementCount: number;\n    /**\n     * Returns the child elements.\n     */\n    readonly children: HTMLCollection;\n    /**\n     * Returns the first child that is an element, and null otherwise.\n     */\n    readonly firstElementChild: Element | null;\n    /**\n     * Returns the last child that is an element, and null otherwise.\n     */\n    readonly lastElementChild: Element | null;\n    /**\n     * Inserts nodes after the last child of node, while replacing strings in nodes with equivalent Text nodes.\n     * \n     * Throws a \"HierarchyRequestError\" DOMException if the constraints of the node tree are violated.\n     */\n    append(...nodes: (Node | string)[]): void;\n    /**\n     * Inserts nodes before the first child of node, while replacing strings in nodes with equivalent Text nodes.\n     * \n     * Throws a \"HierarchyRequestError\" DOMException if the constraints of the node tree are violated.\n     */\n    prepend(...nodes: (Node | string)[]): void;\n    /**\n     * Returns the first element that is a descendant of node that matches selectors.\n     */\n    querySelector<K extends keyof HTMLElementTagNameMap>(selectors: K): HTMLElementTagNameMap[K] | null;\n    querySelector<K extends keyof SVGElementTagNameMap>(selectors: K): SVGElementTagNameMap[K] | null;\n    querySelector<E extends Element = Element>(selectors: string): E | null;\n    /**\n     * Returns all element descendants of node that match selectors.\n     */\n    querySelectorAll<K extends keyof HTMLElementTagNameMap>(selectors: K): NodeListOf<HTMLElementTagNameMap[K]>;\n    querySelectorAll<K extends keyof SVGElementTagNameMap>(selectors: K): NodeListOf<SVGElementTagNameMap[K]>;\n    querySelectorAll<E extends Element = Element>(selectors: string): NodeListOf<E>;\n}\n\n/** This Canvas 2D API interface is used to declare a path that can then be used on a CanvasRenderingContext2D object. The path methods of the CanvasRenderingContext2D interface are also present on this interface, which gives you the convenience of being able to retain and replay your path whenever desired. */\ninterface Path2D extends CanvasPath {\n    /**\n     * Adds to the path the path given by the argument.\n     */\n    addPath(path: Path2D, transform?: DOMMatrix2DInit): void;\n}\n\ndeclare var Path2D: {\n    prototype: Path2D;\n    new(path?: Path2D | string): Path2D;\n};\n\n/** This Payment Request API interface is used to store shipping or payment address information. */\ninterface PaymentAddress {\n    readonly addressLine: string[];\n    readonly city: string;\n    readonly country: string;\n    readonly dependentLocality: string;\n    readonly languageCode: string;\n    readonly organization: string;\n    readonly phone: string;\n    readonly postalCode: string;\n    readonly recipient: string;\n    readonly region: string;\n    readonly sortingCode: string;\n    toJSON(): any;\n}\n\ndeclare var PaymentAddress: {\n    prototype: PaymentAddress;\n    new(): PaymentAddress;\n};\n\ninterface PaymentRequestEventMap {\n    \"shippingaddresschange\": Event;\n    \"shippingoptionchange\": Event;\n}\n\n/** This Payment Request API interface is the primary access point into the API, and lets web content and apps accept payments from the end user. */\ninterface PaymentRequest extends EventTarget {\n    readonly id: string;\n    onshippingaddresschange: ((this: PaymentRequest, ev: Event) => any) | null;\n    onshippingoptionchange: ((this: PaymentRequest, ev: Event) => any) | null;\n    readonly shippingAddress: PaymentAddress | null;\n    readonly shippingOption: string | null;\n    readonly shippingType: PaymentShippingType | null;\n    abort(): Promise<void>;\n    canMakePayment(): Promise<boolean>;\n    show(): Promise<PaymentResponse>;\n    addEventListener<K extends keyof PaymentRequestEventMap>(type: K, listener: (this: PaymentRequest, ev: PaymentRequestEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof PaymentRequestEventMap>(type: K, listener: (this: PaymentRequest, ev: PaymentRequestEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var PaymentRequest: {\n    prototype: PaymentRequest;\n    new(methodData: PaymentMethodData[], details: PaymentDetailsInit, options?: PaymentOptions): PaymentRequest;\n};\n\n/** This Payment Request API interface enables a web page to update the details of a PaymentRequest in response to a user action. */\ninterface PaymentRequestUpdateEvent extends Event {\n    updateWith(detailsPromise: PaymentDetailsUpdate | Promise<PaymentDetailsUpdate>): void;\n}\n\ndeclare var PaymentRequestUpdateEvent: {\n    prototype: PaymentRequestUpdateEvent;\n    new(type: string, eventInitDict?: PaymentRequestUpdateEventInit): PaymentRequestUpdateEvent;\n};\n\n/** This Payment Request API interface is returned after a user selects a payment method and approves a payment request. */\ninterface PaymentResponse {\n    readonly details: any;\n    readonly methodName: string;\n    readonly payerEmail: string | null;\n    readonly payerName: string | null;\n    readonly payerPhone: string | null;\n    readonly requestId: string;\n    readonly shippingAddress: PaymentAddress | null;\n    readonly shippingOption: string | null;\n    complete(result?: PaymentComplete): Promise<void>;\n    toJSON(): any;\n}\n\ndeclare var PaymentResponse: {\n    prototype: PaymentResponse;\n    new(): PaymentResponse;\n};\n\ninterface PerfWidgetExternal {\n    readonly activeNetworkRequestCount: number;\n    readonly averageFrameTime: number;\n    readonly averagePaintTime: number;\n    readonly extraInformationEnabled: boolean;\n    readonly independentRenderingEnabled: boolean;\n    readonly irDisablingContentString: string;\n    readonly irStatusAvailable: boolean;\n    readonly maxCpuSpeed: number;\n    readonly paintRequestsPerSecond: number;\n    readonly performanceCounter: number;\n    readonly performanceCounterFrequency: number;\n    addEventListener(eventType: string, callback: Function): void;\n    getMemoryUsage(): number;\n    getProcessCpuUsage(): number;\n    getRecentCpuUsage(last: number | null): any;\n    getRecentFrames(last: number | null): any;\n    getRecentMemoryUsage(last: number | null): any;\n    getRecentPaintRequests(last: number | null): any;\n    removeEventListener(eventType: string, callback: Function): void;\n    repositionWindow(x: number, y: number): void;\n    resizeWindow(width: number, height: number): void;\n}\n\ndeclare var PerfWidgetExternal: {\n    prototype: PerfWidgetExternal;\n    new(): PerfWidgetExternal;\n};\n\ninterface PerformanceEventMap {\n    \"resourcetimingbufferfull\": Event;\n}\n\n/** Provides access to performance-related information for the current page. It's part of the High Resolution Time API, but is enhanced by the Performance Timeline API, the Navigation Timing API, the User Timing API, and the Resource Timing API. */\ninterface Performance extends EventTarget {\n    /** @deprecated */\n    readonly navigation: PerformanceNavigation;\n    onresourcetimingbufferfull: ((this: Performance, ev: Event) => any) | null;\n    readonly timeOrigin: number;\n    /** @deprecated */\n    readonly timing: PerformanceTiming;\n    clearMarks(markName?: string): void;\n    clearMeasures(measureName?: string): void;\n    clearResourceTimings(): void;\n    getEntries(): PerformanceEntryList;\n    getEntriesByName(name: string, type?: string): PerformanceEntryList;\n    getEntriesByType(type: string): PerformanceEntryList;\n    mark(markName: string): void;\n    measure(measureName: string, startMark?: string, endMark?: string): void;\n    now(): number;\n    setResourceTimingBufferSize(maxSize: number): void;\n    toJSON(): any;\n    addEventListener<K extends keyof PerformanceEventMap>(type: K, listener: (this: Performance, ev: PerformanceEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof PerformanceEventMap>(type: K, listener: (this: Performance, ev: PerformanceEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Performance: {\n    prototype: Performance;\n    new(): Performance;\n};\n\n/** Encapsulates a single performance metric that is part of the performance timeline. A performance entry can be directly created by making a performance mark or measure (for example by calling the mark() method) at an explicit point in an application. Performance entries are also created in indirect ways such as loading a resource (such as an image). */\ninterface PerformanceEntry {\n    readonly duration: number;\n    readonly entryType: string;\n    readonly name: string;\n    readonly startTime: number;\n    toJSON(): any;\n}\n\ndeclare var PerformanceEntry: {\n    prototype: PerformanceEntry;\n    new(): PerformanceEntry;\n};\n\n/** PerformanceMark is an abstract interface for PerformanceEntry objects with an entryType of \"mark\". Entries of this type are created by calling performance.mark() to add a named DOMHighResTimeStamp (the mark) to the browser's performance timeline. */\ninterface PerformanceMark extends PerformanceEntry {\n}\n\ndeclare var PerformanceMark: {\n    prototype: PerformanceMark;\n    new(): PerformanceMark;\n};\n\n/** PerformanceMeasure is an abstract interface for PerformanceEntry objects with an entryType of \"measure\". Entries of this type are created by calling performance.measure() to add a named DOMHighResTimeStamp (the measure) between two marks to the browser's performance timeline. */\ninterface PerformanceMeasure extends PerformanceEntry {\n}\n\ndeclare var PerformanceMeasure: {\n    prototype: PerformanceMeasure;\n    new(): PerformanceMeasure;\n};\n\n/** The legacy PerformanceNavigation interface represents information about how the navigation to the current document was done. */\ninterface PerformanceNavigation {\n    readonly redirectCount: number;\n    readonly type: number;\n    toJSON(): any;\n    readonly TYPE_BACK_FORWARD: number;\n    readonly TYPE_NAVIGATE: number;\n    readonly TYPE_RELOAD: number;\n    readonly TYPE_RESERVED: number;\n}\n\ndeclare var PerformanceNavigation: {\n    prototype: PerformanceNavigation;\n    new(): PerformanceNavigation;\n    readonly TYPE_BACK_FORWARD: number;\n    readonly TYPE_NAVIGATE: number;\n    readonly TYPE_RELOAD: number;\n    readonly TYPE_RESERVED: number;\n};\n\n/** Provides methods and properties to store and retrieve metrics regarding the browser's document navigation events. For example, this interface can be used to determine how much time it takes to load or unload a document. */\ninterface PerformanceNavigationTiming extends PerformanceResourceTiming {\n    readonly domComplete: number;\n    readonly domContentLoadedEventEnd: number;\n    readonly domContentLoadedEventStart: number;\n    readonly domInteractive: number;\n    readonly loadEventEnd: number;\n    readonly loadEventStart: number;\n    readonly redirectCount: number;\n    readonly type: NavigationType;\n    readonly unloadEventEnd: number;\n    readonly unloadEventStart: number;\n    toJSON(): any;\n}\n\ndeclare var PerformanceNavigationTiming: {\n    prototype: PerformanceNavigationTiming;\n    new(): PerformanceNavigationTiming;\n};\n\ninterface PerformanceObserver {\n    disconnect(): void;\n    observe(options?: PerformanceObserverInit): void;\n    takeRecords(): PerformanceEntryList;\n}\n\ndeclare var PerformanceObserver: {\n    prototype: PerformanceObserver;\n    new(callback: PerformanceObserverCallback): PerformanceObserver;\n    readonly supportedEntryTypes: ReadonlyArray<string>;\n};\n\ninterface PerformanceObserverEntryList {\n    getEntries(): PerformanceEntryList;\n    getEntriesByName(name: string, type?: string): PerformanceEntryList;\n    getEntriesByType(type: string): PerformanceEntryList;\n}\n\ndeclare var PerformanceObserverEntryList: {\n    prototype: PerformanceObserverEntryList;\n    new(): PerformanceObserverEntryList;\n};\n\n/** Enables retrieval and analysis of detailed network timing data regarding the loading of an application's resources. An application can use the timing metrics to determine, for example, the length of time it takes to fetch a specific resource, such as an XMLHttpRequest, <SVG>, image, or script. */\ninterface PerformanceResourceTiming extends PerformanceEntry {\n    readonly connectEnd: number;\n    readonly connectStart: number;\n    readonly decodedBodySize: number;\n    readonly domainLookupEnd: number;\n    readonly domainLookupStart: number;\n    readonly encodedBodySize: number;\n    readonly fetchStart: number;\n    readonly initiatorType: string;\n    readonly nextHopProtocol: string;\n    readonly redirectEnd: number;\n    readonly redirectStart: number;\n    readonly requestStart: number;\n    readonly responseEnd: number;\n    readonly responseStart: number;\n    readonly secureConnectionStart: number;\n    readonly transferSize: number;\n    readonly workerStart: number;\n    toJSON(): any;\n}\n\ndeclare var PerformanceResourceTiming: {\n    prototype: PerformanceResourceTiming;\n    new(): PerformanceResourceTiming;\n};\n\n/** A legacy interface kept for backwards compatibility and contains properties that offer performance timing information for various events which occur during the loading and use of the current page. You get a PerformanceTiming object describing your page using the window.performance.timing property. */\ninterface PerformanceTiming {\n    readonly connectEnd: number;\n    readonly connectStart: number;\n    readonly domComplete: number;\n    readonly domContentLoadedEventEnd: number;\n    readonly domContentLoadedEventStart: number;\n    readonly domInteractive: number;\n    readonly domLoading: number;\n    readonly domainLookupEnd: number;\n    readonly domainLookupStart: number;\n    readonly fetchStart: number;\n    readonly loadEventEnd: number;\n    readonly loadEventStart: number;\n    readonly navigationStart: number;\n    readonly redirectEnd: number;\n    readonly redirectStart: number;\n    readonly requestStart: number;\n    readonly responseEnd: number;\n    readonly responseStart: number;\n    readonly secureConnectionStart: number;\n    readonly unloadEventEnd: number;\n    readonly unloadEventStart: number;\n    toJSON(): any;\n}\n\ndeclare var PerformanceTiming: {\n    prototype: PerformanceTiming;\n    new(): PerformanceTiming;\n};\n\n/** PeriodicWave has no inputs or outputs; it is used to define custom oscillators when calling OscillatorNode.setPeriodicWave(). The PeriodicWave itself is created/returned by AudioContext.createPeriodicWave(). */\ninterface PeriodicWave {\n}\n\ndeclare var PeriodicWave: {\n    prototype: PeriodicWave;\n    new(context: BaseAudioContext, options?: PeriodicWaveOptions): PeriodicWave;\n};\n\ninterface PermissionRequest extends DeferredPermissionRequest {\n    readonly state: MSWebViewPermissionState;\n    defer(): void;\n}\n\ndeclare var PermissionRequest: {\n    prototype: PermissionRequest;\n    new(): PermissionRequest;\n};\n\ninterface PermissionRequestedEvent extends Event {\n    readonly permissionRequest: PermissionRequest;\n}\n\ndeclare var PermissionRequestedEvent: {\n    prototype: PermissionRequestedEvent;\n    new(): PermissionRequestedEvent;\n};\n\ninterface PermissionStatusEventMap {\n    \"change\": Event;\n}\n\ninterface PermissionStatus extends EventTarget {\n    onchange: ((this: PermissionStatus, ev: Event) => any) | null;\n    readonly state: PermissionState;\n    addEventListener<K extends keyof PermissionStatusEventMap>(type: K, listener: (this: PermissionStatus, ev: PermissionStatusEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof PermissionStatusEventMap>(type: K, listener: (this: PermissionStatus, ev: PermissionStatusEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var PermissionStatus: {\n    prototype: PermissionStatus;\n    new(): PermissionStatus;\n};\n\ninterface Permissions {\n    query(permissionDesc: PermissionDescriptor | DevicePermissionDescriptor | MidiPermissionDescriptor | PushPermissionDescriptor): Promise<PermissionStatus>;\n}\n\ndeclare var Permissions: {\n    prototype: Permissions;\n    new(): Permissions;\n};\n\n/** Provides information about a browser plugin. */\ninterface Plugin {\n    /**\n     * Returns the plugin's description.\n     */\n    readonly description: string;\n    /**\n     * Returns the plugin library's filename, if applicable on the current platform.\n     */\n    readonly filename: string;\n    /**\n     * Returns the number of MIME types, represented by MimeType objects, supported by the plugin.\n     */\n    readonly length: number;\n    /**\n     * Returns the plugin's name.\n     */\n    readonly name: string;\n    /**\n     * Returns the specified MimeType object.\n     */\n    item(index: number): MimeType | null;\n    namedItem(name: string): MimeType | null;\n    [index: number]: MimeType;\n}\n\ndeclare var Plugin: {\n    prototype: Plugin;\n    new(): Plugin;\n};\n\n/** Used to store a list of Plugin objects describing the available plugins; it's returned by the window.navigator.plugins property. The PluginArray is not a JavaScript array, but has the length property and supports accessing individual items using bracket notation (plugins[2]), as well as via item(index) and namedItem(\"name\") methods. */\ninterface PluginArray {\n    readonly length: number;\n    item(index: number): Plugin | null;\n    namedItem(name: string): Plugin | null;\n    refresh(reload?: boolean): void;\n    [index: number]: Plugin;\n}\n\ndeclare var PluginArray: {\n    prototype: PluginArray;\n    new(): PluginArray;\n};\n\n/** The state of a DOM event produced by a pointer such as the geometry of the contact point, the device type that generated the event, the amount of pressure that was applied on the contact surface, etc. */\ninterface PointerEvent extends MouseEvent {\n    readonly height: number;\n    readonly isPrimary: boolean;\n    readonly pointerId: number;\n    readonly pointerType: string;\n    readonly pressure: number;\n    readonly tangentialPressure: number;\n    readonly tiltX: number;\n    readonly tiltY: number;\n    readonly twist: number;\n    readonly width: number;\n}\n\ndeclare var PointerEvent: {\n    prototype: PointerEvent;\n    new(type: string, eventInitDict?: PointerEventInit): PointerEvent;\n};\n\n/** PopStateEvent is an event handler for the popstate event on the window. */\ninterface PopStateEvent extends Event {\n    /**\n     * Returns a copy of the information that was provided to pushState() or replaceState().\n     */\n    readonly state: any;\n}\n\ndeclare var PopStateEvent: {\n    prototype: PopStateEvent;\n    new(type: string, eventInitDict?: PopStateEventInit): PopStateEvent;\n};\n\n/** A processing instruction embeds application-specific instructions in XML which can be ignored by other applications that don't recognize them. */\ninterface ProcessingInstruction extends CharacterData, LinkStyle {\n    readonly ownerDocument: Document;\n    readonly target: string;\n}\n\ndeclare var ProcessingInstruction: {\n    prototype: ProcessingInstruction;\n    new(): ProcessingInstruction;\n};\n\n/** Events measuring progress of an underlying process, like an HTTP request (for an XMLHttpRequest, or the loading of the underlying resource of an <img>, <audio>, <video>, <style> or <link>). */\ninterface ProgressEvent<T extends EventTarget = EventTarget> extends Event {\n    readonly lengthComputable: boolean;\n    readonly loaded: number;\n    readonly target: T | null;\n    readonly total: number;\n}\n\ndeclare var ProgressEvent: {\n    prototype: ProgressEvent;\n    new(type: string, eventInitDict?: ProgressEventInit): ProgressEvent;\n};\n\ninterface PromiseRejectionEvent extends Event {\n    readonly promise: Promise<any>;\n    readonly reason: any;\n}\n\ndeclare var PromiseRejectionEvent: {\n    prototype: PromiseRejectionEvent;\n    new(type: string, eventInitDict: PromiseRejectionEventInit): PromiseRejectionEvent;\n};\n\ninterface PublicKeyCredential extends Credential {\n    readonly rawId: ArrayBuffer;\n    readonly response: AuthenticatorResponse;\n    getClientExtensionResults(): AuthenticationExtensionsClientOutputs;\n}\n\ndeclare var PublicKeyCredential: {\n    prototype: PublicKeyCredential;\n    new(): PublicKeyCredential;\n    isUserVerifyingPlatformAuthenticatorAvailable(): Promise<boolean>;\n};\n\n/** This Push API interface provides a way to receive notifications from third-party servers as well as request URLs for push notifications. */\ninterface PushManager {\n    getSubscription(): Promise<PushSubscription | null>;\n    permissionState(options?: PushSubscriptionOptionsInit): Promise<PushPermissionState>;\n    subscribe(options?: PushSubscriptionOptionsInit): Promise<PushSubscription>;\n}\n\ndeclare var PushManager: {\n    prototype: PushManager;\n    new(): PushManager;\n    readonly supportedContentEncodings: ReadonlyArray<string>;\n};\n\n/** This Push API interface provides a subcription's URL endpoint and allows unsubscription from a push service. */\ninterface PushSubscription {\n    readonly endpoint: string;\n    readonly expirationTime: number | null;\n    readonly options: PushSubscriptionOptions;\n    getKey(name: PushEncryptionKeyName): ArrayBuffer | null;\n    toJSON(): PushSubscriptionJSON;\n    unsubscribe(): Promise<boolean>;\n}\n\ndeclare var PushSubscription: {\n    prototype: PushSubscription;\n    new(): PushSubscription;\n};\n\ninterface PushSubscriptionOptions {\n    readonly applicationServerKey: ArrayBuffer | null;\n    readonly userVisibleOnly: boolean;\n}\n\ndeclare var PushSubscriptionOptions: {\n    prototype: PushSubscriptionOptions;\n    new(): PushSubscriptionOptions;\n};\n\ninterface RTCCertificate {\n    readonly expires: number;\n    getFingerprints(): RTCDtlsFingerprint[];\n}\n\ndeclare var RTCCertificate: {\n    prototype: RTCCertificate;\n    new(): RTCCertificate;\n    getSupportedAlgorithms(): AlgorithmIdentifier[];\n};\n\ninterface RTCDTMFSenderEventMap {\n    \"tonechange\": RTCDTMFToneChangeEvent;\n}\n\ninterface RTCDTMFSender extends EventTarget {\n    readonly canInsertDTMF: boolean;\n    ontonechange: ((this: RTCDTMFSender, ev: RTCDTMFToneChangeEvent) => any) | null;\n    readonly toneBuffer: string;\n    insertDTMF(tones: string, duration?: number, interToneGap?: number): void;\n    addEventListener<K extends keyof RTCDTMFSenderEventMap>(type: K, listener: (this: RTCDTMFSender, ev: RTCDTMFSenderEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCDTMFSenderEventMap>(type: K, listener: (this: RTCDTMFSender, ev: RTCDTMFSenderEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCDTMFSender: {\n    prototype: RTCDTMFSender;\n    new(): RTCDTMFSender;\n};\n\n/** Events sent to indicate that DTMF tones have started or finished playing. This interface is used by the tonechange event. */\ninterface RTCDTMFToneChangeEvent extends Event {\n    readonly tone: string;\n}\n\ndeclare var RTCDTMFToneChangeEvent: {\n    prototype: RTCDTMFToneChangeEvent;\n    new(type: string, eventInitDict: RTCDTMFToneChangeEventInit): RTCDTMFToneChangeEvent;\n};\n\ninterface RTCDataChannelEventMap {\n    \"bufferedamountlow\": Event;\n    \"close\": Event;\n    \"error\": RTCErrorEvent;\n    \"message\": MessageEvent;\n    \"open\": Event;\n}\n\ninterface RTCDataChannel extends EventTarget {\n    binaryType: string;\n    readonly bufferedAmount: number;\n    bufferedAmountLowThreshold: number;\n    readonly id: number | null;\n    readonly label: string;\n    readonly maxPacketLifeTime: number | null;\n    readonly maxRetransmits: number | null;\n    readonly negotiated: boolean;\n    onbufferedamountlow: ((this: RTCDataChannel, ev: Event) => any) | null;\n    onclose: ((this: RTCDataChannel, ev: Event) => any) | null;\n    onerror: ((this: RTCDataChannel, ev: RTCErrorEvent) => any) | null;\n    onmessage: ((this: RTCDataChannel, ev: MessageEvent) => any) | null;\n    onopen: ((this: RTCDataChannel, ev: Event) => any) | null;\n    readonly ordered: boolean;\n    readonly priority: RTCPriorityType;\n    readonly protocol: string;\n    readonly readyState: RTCDataChannelState;\n    close(): void;\n    send(data: string): void;\n    send(data: Blob): void;\n    send(data: ArrayBuffer): void;\n    send(data: ArrayBufferView): void;\n    addEventListener<K extends keyof RTCDataChannelEventMap>(type: K, listener: (this: RTCDataChannel, ev: RTCDataChannelEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCDataChannelEventMap>(type: K, listener: (this: RTCDataChannel, ev: RTCDataChannelEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCDataChannel: {\n    prototype: RTCDataChannel;\n    new(): RTCDataChannel;\n};\n\ninterface RTCDataChannelEvent extends Event {\n    readonly channel: RTCDataChannel;\n}\n\ndeclare var RTCDataChannelEvent: {\n    prototype: RTCDataChannelEvent;\n    new(type: string, eventInitDict: RTCDataChannelEventInit): RTCDataChannelEvent;\n};\n\ninterface RTCDtlsTransportEventMap {\n    \"error\": RTCErrorEvent;\n    \"statechange\": Event;\n}\n\ninterface RTCDtlsTransport extends EventTarget {\n    readonly iceTransport: RTCIceTransport;\n    onerror: ((this: RTCDtlsTransport, ev: RTCErrorEvent) => any) | null;\n    onstatechange: ((this: RTCDtlsTransport, ev: Event) => any) | null;\n    readonly state: RTCDtlsTransportState;\n    getRemoteCertificates(): ArrayBuffer[];\n    addEventListener<K extends keyof RTCDtlsTransportEventMap>(type: K, listener: (this: RTCDtlsTransport, ev: RTCDtlsTransportEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCDtlsTransportEventMap>(type: K, listener: (this: RTCDtlsTransport, ev: RTCDtlsTransportEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCDtlsTransport: {\n    prototype: RTCDtlsTransport;\n    new(): RTCDtlsTransport;\n};\n\ninterface RTCDtlsTransportStateChangedEvent extends Event {\n    readonly state: RTCDtlsTransportState;\n}\n\ndeclare var RTCDtlsTransportStateChangedEvent: {\n    prototype: RTCDtlsTransportStateChangedEvent;\n    new(): RTCDtlsTransportStateChangedEvent;\n};\n\ninterface RTCDtmfSenderEventMap {\n    \"tonechange\": RTCDTMFToneChangeEvent;\n}\n\ninterface RTCDtmfSender extends EventTarget {\n    readonly canInsertDTMF: boolean;\n    readonly duration: number;\n    readonly interToneGap: number;\n    ontonechange: ((this: RTCDtmfSender, ev: RTCDTMFToneChangeEvent) => any) | null;\n    readonly sender: RTCRtpSender;\n    readonly toneBuffer: string;\n    insertDTMF(tones: string, duration?: number, interToneGap?: number): void;\n    addEventListener<K extends keyof RTCDtmfSenderEventMap>(type: K, listener: (this: RTCDtmfSender, ev: RTCDtmfSenderEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCDtmfSenderEventMap>(type: K, listener: (this: RTCDtmfSender, ev: RTCDtmfSenderEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCDtmfSender: {\n    prototype: RTCDtmfSender;\n    new(sender: RTCRtpSender): RTCDtmfSender;\n};\n\ninterface RTCError extends DOMException {\n    readonly errorDetail: RTCErrorDetailType;\n    readonly httpRequestStatusCode: number | null;\n    readonly receivedAlert: number | null;\n    readonly sctpCauseCode: number | null;\n    readonly sdpLineNumber: number | null;\n    readonly sentAlert: number | null;\n}\n\ndeclare var RTCError: {\n    prototype: RTCError;\n    new(init: RTCErrorInit, message?: string): RTCError;\n};\n\ninterface RTCErrorEvent extends Event {\n    readonly error: RTCError;\n}\n\ndeclare var RTCErrorEvent: {\n    prototype: RTCErrorEvent;\n    new(type: string, eventInitDict: RTCErrorEventInit): RTCErrorEvent;\n};\n\n/** The RTCIceCandidate interface—part of the WebRTC API—represents a candidate Internet Connectivity Establishment (ICE) configuration which may be used to establish an RTCPeerConnection. */\ninterface RTCIceCandidate {\n    readonly candidate: string;\n    readonly component: RTCIceComponent | null;\n    readonly foundation: string | null;\n    readonly port: number | null;\n    readonly priority: number | null;\n    readonly protocol: RTCIceProtocol | null;\n    readonly relatedAddress: string | null;\n    readonly relatedPort: number | null;\n    readonly sdpMLineIndex: number | null;\n    readonly sdpMid: string | null;\n    readonly tcpType: RTCIceTcpCandidateType | null;\n    readonly type: RTCIceCandidateType | null;\n    readonly usernameFragment: string | null;\n    toJSON(): RTCIceCandidateInit;\n}\n\ndeclare var RTCIceCandidate: {\n    prototype: RTCIceCandidate;\n    new(candidateInitDict?: RTCIceCandidateInit): RTCIceCandidate;\n};\n\ninterface RTCIceCandidatePairChangedEvent extends Event {\n    readonly pair: RTCIceCandidatePair;\n}\n\ndeclare var RTCIceCandidatePairChangedEvent: {\n    prototype: RTCIceCandidatePairChangedEvent;\n    new(): RTCIceCandidatePairChangedEvent;\n};\n\ninterface RTCIceGathererEventMap {\n    \"error\": Event;\n    \"localcandidate\": RTCIceGathererEvent;\n}\n\ninterface RTCIceGatherer extends RTCStatsProvider {\n    readonly component: RTCIceComponent;\n    onerror: ((this: RTCIceGatherer, ev: Event) => any) | null;\n    onlocalcandidate: ((this: RTCIceGatherer, ev: RTCIceGathererEvent) => any) | null;\n    createAssociatedGatherer(): RTCIceGatherer;\n    getLocalCandidates(): RTCIceCandidateDictionary[];\n    getLocalParameters(): RTCIceParameters;\n    addEventListener<K extends keyof RTCIceGathererEventMap>(type: K, listener: (this: RTCIceGatherer, ev: RTCIceGathererEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCIceGathererEventMap>(type: K, listener: (this: RTCIceGatherer, ev: RTCIceGathererEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCIceGatherer: {\n    prototype: RTCIceGatherer;\n    new(options: RTCIceGatherOptions): RTCIceGatherer;\n};\n\ninterface RTCIceGathererEvent extends Event {\n    readonly candidate: RTCIceCandidateDictionary | RTCIceCandidateComplete;\n}\n\ndeclare var RTCIceGathererEvent: {\n    prototype: RTCIceGathererEvent;\n    new(): RTCIceGathererEvent;\n};\n\ninterface RTCIceTransportEventMap {\n    \"gatheringstatechange\": Event;\n    \"selectedcandidatepairchange\": Event;\n    \"statechange\": Event;\n}\n\n/** Provides access to information about the ICE transport layer over which the data is being sent and received. */\ninterface RTCIceTransport extends EventTarget {\n    readonly component: RTCIceComponent;\n    readonly gatheringState: RTCIceGathererState;\n    ongatheringstatechange: ((this: RTCIceTransport, ev: Event) => any) | null;\n    onselectedcandidatepairchange: ((this: RTCIceTransport, ev: Event) => any) | null;\n    onstatechange: ((this: RTCIceTransport, ev: Event) => any) | null;\n    readonly role: RTCIceRole;\n    readonly state: RTCIceTransportState;\n    getLocalCandidates(): RTCIceCandidate[];\n    getLocalParameters(): RTCIceParameters | null;\n    getRemoteCandidates(): RTCIceCandidate[];\n    getRemoteParameters(): RTCIceParameters | null;\n    getSelectedCandidatePair(): RTCIceCandidatePair | null;\n    addEventListener<K extends keyof RTCIceTransportEventMap>(type: K, listener: (this: RTCIceTransport, ev: RTCIceTransportEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCIceTransportEventMap>(type: K, listener: (this: RTCIceTransport, ev: RTCIceTransportEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCIceTransport: {\n    prototype: RTCIceTransport;\n    new(): RTCIceTransport;\n};\n\ninterface RTCIceTransportStateChangedEvent extends Event {\n    readonly state: RTCIceTransportState;\n}\n\ndeclare var RTCIceTransportStateChangedEvent: {\n    prototype: RTCIceTransportStateChangedEvent;\n    new(): RTCIceTransportStateChangedEvent;\n};\n\ninterface RTCIdentityAssertion {\n    idp: string;\n    name: string;\n}\n\ndeclare var RTCIdentityAssertion: {\n    prototype: RTCIdentityAssertion;\n    new(idp: string, name: string): RTCIdentityAssertion;\n};\n\ninterface RTCPeerConnectionEventMap {\n    \"connectionstatechange\": Event;\n    \"datachannel\": RTCDataChannelEvent;\n    \"icecandidate\": RTCPeerConnectionIceEvent;\n    \"icecandidateerror\": RTCPeerConnectionIceErrorEvent;\n    \"iceconnectionstatechange\": Event;\n    \"icegatheringstatechange\": Event;\n    \"negotiationneeded\": Event;\n    \"signalingstatechange\": Event;\n    \"statsended\": RTCStatsEvent;\n    \"track\": RTCTrackEvent;\n}\n\n/** A WebRTC connection between the local computer and a remote peer. It provides methods to connect to a remote peer, maintain and monitor the connection, and close the connection once it's no longer needed. */\ninterface RTCPeerConnection extends EventTarget {\n    readonly canTrickleIceCandidates: boolean | null;\n    readonly connectionState: RTCPeerConnectionState;\n    readonly currentLocalDescription: RTCSessionDescription | null;\n    readonly currentRemoteDescription: RTCSessionDescription | null;\n    readonly iceConnectionState: RTCIceConnectionState;\n    readonly iceGatheringState: RTCIceGatheringState;\n    readonly idpErrorInfo: string | null;\n    readonly idpLoginUrl: string | null;\n    readonly localDescription: RTCSessionDescription | null;\n    onconnectionstatechange: ((this: RTCPeerConnection, ev: Event) => any) | null;\n    ondatachannel: ((this: RTCPeerConnection, ev: RTCDataChannelEvent) => any) | null;\n    onicecandidate: ((this: RTCPeerConnection, ev: RTCPeerConnectionIceEvent) => any) | null;\n    onicecandidateerror: ((this: RTCPeerConnection, ev: RTCPeerConnectionIceErrorEvent) => any) | null;\n    oniceconnectionstatechange: ((this: RTCPeerConnection, ev: Event) => any) | null;\n    onicegatheringstatechange: ((this: RTCPeerConnection, ev: Event) => any) | null;\n    onnegotiationneeded: ((this: RTCPeerConnection, ev: Event) => any) | null;\n    onsignalingstatechange: ((this: RTCPeerConnection, ev: Event) => any) | null;\n    onstatsended: ((this: RTCPeerConnection, ev: RTCStatsEvent) => any) | null;\n    ontrack: ((this: RTCPeerConnection, ev: RTCTrackEvent) => any) | null;\n    readonly peerIdentity: Promise<RTCIdentityAssertion>;\n    readonly pendingLocalDescription: RTCSessionDescription | null;\n    readonly pendingRemoteDescription: RTCSessionDescription | null;\n    readonly remoteDescription: RTCSessionDescription | null;\n    readonly sctp: RTCSctpTransport | null;\n    readonly signalingState: RTCSignalingState;\n    addIceCandidate(candidate: RTCIceCandidateInit | RTCIceCandidate): Promise<void>;\n    addTrack(track: MediaStreamTrack, ...streams: MediaStream[]): RTCRtpSender;\n    addTransceiver(trackOrKind: MediaStreamTrack | string, init?: RTCRtpTransceiverInit): RTCRtpTransceiver;\n    close(): void;\n    createAnswer(options?: RTCOfferOptions): Promise<RTCSessionDescriptionInit>;\n    createDataChannel(label: string, dataChannelDict?: RTCDataChannelInit): RTCDataChannel;\n    createOffer(options?: RTCOfferOptions): Promise<RTCSessionDescriptionInit>;\n    getConfiguration(): RTCConfiguration;\n    getIdentityAssertion(): Promise<string>;\n    getReceivers(): RTCRtpReceiver[];\n    getSenders(): RTCRtpSender[];\n    getStats(selector?: MediaStreamTrack | null): Promise<RTCStatsReport>;\n    getTransceivers(): RTCRtpTransceiver[];\n    removeTrack(sender: RTCRtpSender): void;\n    setConfiguration(configuration: RTCConfiguration): void;\n    setIdentityProvider(provider: string, options?: RTCIdentityProviderOptions): void;\n    setLocalDescription(description: RTCSessionDescriptionInit): Promise<void>;\n    setRemoteDescription(description: RTCSessionDescriptionInit): Promise<void>;\n    addEventListener<K extends keyof RTCPeerConnectionEventMap>(type: K, listener: (this: RTCPeerConnection, ev: RTCPeerConnectionEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCPeerConnectionEventMap>(type: K, listener: (this: RTCPeerConnection, ev: RTCPeerConnectionEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCPeerConnection: {\n    prototype: RTCPeerConnection;\n    new(configuration?: RTCConfiguration): RTCPeerConnection;\n    generateCertificate(keygenAlgorithm: AlgorithmIdentifier): Promise<RTCCertificate>;\n    getDefaultIceServers(): RTCIceServer[];\n};\n\ninterface RTCPeerConnectionIceErrorEvent extends Event {\n    readonly errorCode: number;\n    readonly errorText: string;\n    readonly hostCandidate: string;\n    readonly url: string;\n}\n\ndeclare var RTCPeerConnectionIceErrorEvent: {\n    prototype: RTCPeerConnectionIceErrorEvent;\n    new(type: string, eventInitDict: RTCPeerConnectionIceErrorEventInit): RTCPeerConnectionIceErrorEvent;\n};\n\n/** Events that occurs in relation to ICE candidates with the target, usually an RTCPeerConnection. Only one event is of this type: icecandidate. */\ninterface RTCPeerConnectionIceEvent extends Event {\n    readonly candidate: RTCIceCandidate | null;\n    readonly url: string | null;\n}\n\ndeclare var RTCPeerConnectionIceEvent: {\n    prototype: RTCPeerConnectionIceEvent;\n    new(type: string, eventInitDict?: RTCPeerConnectionIceEventInit): RTCPeerConnectionIceEvent;\n};\n\n/** This WebRTC API interface manages the reception and decoding of data for a MediaStreamTrack on an RTCPeerConnection. */\ninterface RTCRtpReceiver {\n    readonly rtcpTransport: RTCDtlsTransport | null;\n    readonly track: MediaStreamTrack;\n    readonly transport: RTCDtlsTransport | null;\n    getContributingSources(): RTCRtpContributingSource[];\n    getParameters(): RTCRtpReceiveParameters;\n    getStats(): Promise<RTCStatsReport>;\n    getSynchronizationSources(): RTCRtpSynchronizationSource[];\n}\n\ndeclare var RTCRtpReceiver: {\n    prototype: RTCRtpReceiver;\n    new(): RTCRtpReceiver;\n    getCapabilities(kind: string): RTCRtpCapabilities | null;\n};\n\n/** Provides the ability to control and obtain details about how a particular MediaStreamTrack is encoded and sent to a remote peer. */\ninterface RTCRtpSender {\n    readonly dtmf: RTCDTMFSender | null;\n    readonly rtcpTransport: RTCDtlsTransport | null;\n    readonly track: MediaStreamTrack | null;\n    readonly transport: RTCDtlsTransport | null;\n    getParameters(): RTCRtpSendParameters;\n    getStats(): Promise<RTCStatsReport>;\n    replaceTrack(withTrack: MediaStreamTrack | null): Promise<void>;\n    setParameters(parameters: RTCRtpSendParameters): Promise<void>;\n    setStreams(...streams: MediaStream[]): void;\n}\n\ndeclare var RTCRtpSender: {\n    prototype: RTCRtpSender;\n    new(): RTCRtpSender;\n    getCapabilities(kind: string): RTCRtpCapabilities | null;\n};\n\ninterface RTCRtpTransceiver {\n    readonly currentDirection: RTCRtpTransceiverDirection | null;\n    direction: RTCRtpTransceiverDirection;\n    readonly mid: string | null;\n    readonly receiver: RTCRtpReceiver;\n    readonly sender: RTCRtpSender;\n    setCodecPreferences(codecs: RTCRtpCodecCapability[]): void;\n    stop(): void;\n}\n\ndeclare var RTCRtpTransceiver: {\n    prototype: RTCRtpTransceiver;\n    new(): RTCRtpTransceiver;\n};\n\ninterface RTCSctpTransportEventMap {\n    \"statechange\": Event;\n}\n\ninterface RTCSctpTransport extends EventTarget {\n    readonly maxChannels: number | null;\n    readonly maxMessageSize: number;\n    onstatechange: ((this: RTCSctpTransport, ev: Event) => any) | null;\n    readonly state: RTCSctpTransportState;\n    readonly transport: RTCDtlsTransport;\n    addEventListener<K extends keyof RTCSctpTransportEventMap>(type: K, listener: (this: RTCSctpTransport, ev: RTCSctpTransportEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCSctpTransportEventMap>(type: K, listener: (this: RTCSctpTransport, ev: RTCSctpTransportEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCSctpTransport: {\n    prototype: RTCSctpTransport;\n    new(): RTCSctpTransport;\n};\n\n/** One end of a connection—or potential connection—and how it's configured. Each RTCSessionDescription consists of a description type indicating which part of the offer/answer negotiation process it describes and of the SDP descriptor of the session. */\ninterface RTCSessionDescription {\n    readonly sdp: string;\n    readonly type: RTCSdpType;\n    toJSON(): any;\n}\n\ndeclare var RTCSessionDescription: {\n    prototype: RTCSessionDescription;\n    new(descriptionInitDict?: RTCSessionDescriptionInit): RTCSessionDescription;\n};\n\ninterface RTCSrtpSdesTransportEventMap {\n    \"error\": Event;\n}\n\ninterface RTCSrtpSdesTransport extends EventTarget {\n    onerror: ((this: RTCSrtpSdesTransport, ev: Event) => any) | null;\n    readonly transport: RTCIceTransport;\n    addEventListener<K extends keyof RTCSrtpSdesTransportEventMap>(type: K, listener: (this: RTCSrtpSdesTransport, ev: RTCSrtpSdesTransportEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCSrtpSdesTransportEventMap>(type: K, listener: (this: RTCSrtpSdesTransport, ev: RTCSrtpSdesTransportEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var RTCSrtpSdesTransport: {\n    prototype: RTCSrtpSdesTransport;\n    new(transport: RTCIceTransport, encryptParameters: RTCSrtpSdesParameters, decryptParameters: RTCSrtpSdesParameters): RTCSrtpSdesTransport;\n    getLocalParameters(): RTCSrtpSdesParameters[];\n};\n\ninterface RTCSsrcConflictEvent extends Event {\n    readonly ssrc: number;\n}\n\ndeclare var RTCSsrcConflictEvent: {\n    prototype: RTCSsrcConflictEvent;\n    new(): RTCSsrcConflictEvent;\n};\n\ninterface RTCStatsEvent extends Event {\n    readonly report: RTCStatsReport;\n}\n\ndeclare var RTCStatsEvent: {\n    prototype: RTCStatsEvent;\n    new(type: string, eventInitDict: RTCStatsEventInit): RTCStatsEvent;\n};\n\ninterface RTCStatsProvider extends EventTarget {\n    getStats(): Promise<RTCStatsReport>;\n    msGetStats(): Promise<RTCStatsReport>;\n}\n\ndeclare var RTCStatsProvider: {\n    prototype: RTCStatsProvider;\n    new(): RTCStatsProvider;\n};\n\ninterface RTCStatsReport {\n    forEach(callbackfn: (value: any, key: string, parent: RTCStatsReport) => void, thisArg?: any): void;\n}\n\ndeclare var RTCStatsReport: {\n    prototype: RTCStatsReport;\n    new(): RTCStatsReport;\n};\n\ninterface RTCTrackEvent extends Event {\n    readonly receiver: RTCRtpReceiver;\n    readonly streams: ReadonlyArray<MediaStream>;\n    readonly track: MediaStreamTrack;\n    readonly transceiver: RTCRtpTransceiver;\n}\n\ndeclare var RTCTrackEvent: {\n    prototype: RTCTrackEvent;\n    new(type: string, eventInitDict: RTCTrackEventInit): RTCTrackEvent;\n};\n\ninterface RadioNodeList extends NodeList {\n    value: string;\n}\n\ndeclare var RadioNodeList: {\n    prototype: RadioNodeList;\n    new(): RadioNodeList;\n};\n\ninterface RandomSource {\n    getRandomValues<T extends Int8Array | Uint8ClampedArray | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array>(array: T): T;\n}\n\ndeclare var RandomSource: {\n    prototype: RandomSource;\n    new(): RandomSource;\n};\n\n/** A fragment of a document that can contain nodes and parts of text nodes. */\ninterface Range extends AbstractRange {\n    /**\n     * Returns the node, furthest away from the document, that is an ancestor of both range's start node and end node.\n     */\n    readonly commonAncestorContainer: Node;\n    cloneContents(): DocumentFragment;\n    cloneRange(): Range;\n    collapse(toStart?: boolean): void;\n    compareBoundaryPoints(how: number, sourceRange: Range): number;\n    /**\n     * Returns −1 if the point is before the range, 0 if the point is in the range, and 1 if the point is after the range.\n     */\n    comparePoint(node: Node, offset: number): number;\n    createContextualFragment(fragment: string): DocumentFragment;\n    deleteContents(): void;\n    detach(): void;\n    extractContents(): DocumentFragment;\n    getBoundingClientRect(): DOMRect;\n    getClientRects(): DOMRectList;\n    insertNode(node: Node): void;\n    /**\n     * Returns whether range intersects node.\n     */\n    intersectsNode(node: Node): boolean;\n    isPointInRange(node: Node, offset: number): boolean;\n    selectNode(node: Node): void;\n    selectNodeContents(node: Node): void;\n    setEnd(node: Node, offset: number): void;\n    setEndAfter(node: Node): void;\n    setEndBefore(node: Node): void;\n    setStart(node: Node, offset: number): void;\n    setStartAfter(node: Node): void;\n    setStartBefore(node: Node): void;\n    surroundContents(newParent: Node): void;\n    toString(): string;\n    readonly END_TO_END: number;\n    readonly END_TO_START: number;\n    readonly START_TO_END: number;\n    readonly START_TO_START: number;\n}\n\ndeclare var Range: {\n    prototype: Range;\n    new(): Range;\n    readonly END_TO_END: number;\n    readonly END_TO_START: number;\n    readonly START_TO_END: number;\n    readonly START_TO_START: number;\n    toString(): string;\n};\n\ninterface ReadableByteStreamController {\n    readonly byobRequest: ReadableStreamBYOBRequest | undefined;\n    readonly desiredSize: number | null;\n    close(): void;\n    enqueue(chunk: ArrayBufferView): void;\n    error(error?: any): void;\n}\n\ndeclare var ReadableByteStreamController: {\n    prototype: ReadableByteStreamController;\n    new(): ReadableByteStreamController;\n};\n\n/** This Streams API interface represents a readable stream of byte data. The Fetch API offers a concrete instance of a ReadableStream through the body property of a Response object. */\ninterface ReadableStream<R = any> {\n    readonly locked: boolean;\n    cancel(reason?: any): Promise<void>;\n    getReader(options: { mode: \"byob\" }): ReadableStreamBYOBReader;\n    getReader(): ReadableStreamDefaultReader<R>;\n    pipeThrough<T>({ writable, readable }: { writable: WritableStream<R>, readable: ReadableStream<T> }, options?: PipeOptions): ReadableStream<T>;\n    pipeTo(dest: WritableStream<R>, options?: PipeOptions): Promise<void>;\n    tee(): [ReadableStream<R>, ReadableStream<R>];\n}\n\ndeclare var ReadableStream: {\n    prototype: ReadableStream;\n    new(underlyingSource: UnderlyingByteSource, strategy?: { highWaterMark?: number, size?: undefined }): ReadableStream<Uint8Array>;\n    new<R = any>(underlyingSource?: UnderlyingSource<R>, strategy?: QueuingStrategy<R>): ReadableStream<R>;\n};\n\ninterface ReadableStreamBYOBReader {\n    readonly closed: Promise<void>;\n    cancel(reason?: any): Promise<void>;\n    read<T extends ArrayBufferView>(view: T): Promise<ReadableStreamReadResult<T>>;\n    releaseLock(): void;\n}\n\ndeclare var ReadableStreamBYOBReader: {\n    prototype: ReadableStreamBYOBReader;\n    new(): ReadableStreamBYOBReader;\n};\n\ninterface ReadableStreamBYOBRequest {\n    readonly view: ArrayBufferView;\n    respond(bytesWritten: number): void;\n    respondWithNewView(view: ArrayBufferView): void;\n}\n\ndeclare var ReadableStreamBYOBRequest: {\n    prototype: ReadableStreamBYOBRequest;\n    new(): ReadableStreamBYOBRequest;\n};\n\ninterface ReadableStreamDefaultController<R = any> {\n    readonly desiredSize: number | null;\n    close(): void;\n    enqueue(chunk: R): void;\n    error(error?: any): void;\n}\n\ndeclare var ReadableStreamDefaultController: {\n    prototype: ReadableStreamDefaultController;\n    new(): ReadableStreamDefaultController;\n};\n\ninterface ReadableStreamDefaultReader<R = any> {\n    readonly closed: Promise<void>;\n    cancel(reason?: any): Promise<void>;\n    read(): Promise<ReadableStreamReadResult<R>>;\n    releaseLock(): void;\n}\n\ndeclare var ReadableStreamDefaultReader: {\n    prototype: ReadableStreamDefaultReader;\n    new(): ReadableStreamDefaultReader;\n};\n\ninterface ReadableStreamReader<R = any> {\n    cancel(): Promise<void>;\n    read(): Promise<ReadableStreamReadResult<R>>;\n    releaseLock(): void;\n}\n\ndeclare var ReadableStreamReader: {\n    prototype: ReadableStreamReader;\n    new(): ReadableStreamReader;\n};\n\n/** This Fetch API interface represents a resource request. */\ninterface Request extends Body {\n    /**\n     * Returns the cache mode associated with request, which is a string indicating how the request will interact with the browser's cache when fetching.\n     */\n    readonly cache: RequestCache;\n    /**\n     * Returns the credentials mode associated with request, which is a string indicating whether credentials will be sent with the request always, never, or only when sent to a same-origin URL.\n     */\n    readonly credentials: RequestCredentials;\n    /**\n     * Returns the kind of resource requested by request, e.g., \"document\" or \"script\".\n     */\n    readonly destination: RequestDestination;\n    /**\n     * Returns a Headers object consisting of the headers associated with request. Note that headers added in the network layer by the user agent will not be accounted for in this object, e.g., the \"Host\" header.\n     */\n    readonly headers: Headers;\n    /**\n     * Returns request's subresource integrity metadata, which is a cryptographic hash of the resource being fetched. Its value consists of multiple hashes separated by whitespace. [SRI]\n     */\n    readonly integrity: string;\n    /**\n     * Returns a boolean indicating whether or not request is for a history navigation (a.k.a. back-foward navigation).\n     */\n    readonly isHistoryNavigation: boolean;\n    /**\n     * Returns a boolean indicating whether or not request is for a reload navigation.\n     */\n    readonly isReloadNavigation: boolean;\n    /**\n     * Returns a boolean indicating whether or not request can outlive the global in which it was created.\n     */\n    readonly keepalive: boolean;\n    /**\n     * Returns request's HTTP method, which is \"GET\" by default.\n     */\n    readonly method: string;\n    /**\n     * Returns the mode associated with request, which is a string indicating whether the request will use CORS, or will be restricted to same-origin URLs.\n     */\n    readonly mode: RequestMode;\n    /**\n     * Returns the redirect mode associated with request, which is a string indicating how redirects for the request will be handled during fetching. A request will follow redirects by default.\n     */\n    readonly redirect: RequestRedirect;\n    /**\n     * Returns the referrer of request. Its value can be a same-origin URL if explicitly set in init, the empty string to indicate no referrer, and \"about:client\" when defaulting to the global's default. This is used during fetching to determine the value of the `Referer` header of the request being made.\n     */\n    readonly referrer: string;\n    /**\n     * Returns the referrer policy associated with request. This is used during fetching to compute the value of the request's referrer.\n     */\n    readonly referrerPolicy: ReferrerPolicy;\n    /**\n     * Returns the signal associated with request, which is an AbortSignal object indicating whether or not request has been aborted, and its abort event handler.\n     */\n    readonly signal: AbortSignal;\n    /**\n     * Returns the URL of request as a string.\n     */\n    readonly url: string;\n    clone(): Request;\n}\n\ndeclare var Request: {\n    prototype: Request;\n    new(input: RequestInfo, init?: RequestInit): Request;\n};\n\n/** This Fetch API interface represents the response to a request. */\ninterface Response extends Body {\n    readonly headers: Headers;\n    readonly ok: boolean;\n    readonly redirected: boolean;\n    readonly status: number;\n    readonly statusText: string;\n    readonly trailer: Promise<Headers>;\n    readonly type: ResponseType;\n    readonly url: string;\n    clone(): Response;\n}\n\ndeclare var Response: {\n    prototype: Response;\n    new(body?: BodyInit | null, init?: ResponseInit): Response;\n    error(): Response;\n    redirect(url: string, status?: number): Response;\n};\n\n/** Provides access to the properties of <a> element, as well as methods to manipulate them. */\ninterface SVGAElement extends SVGGraphicsElement, SVGURIReference {\n    readonly target: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGAElement: {\n    prototype: SVGAElement;\n    new(): SVGAElement;\n};\n\n/** Used to represent a value that can be an <angle> or <number> value. An SVGAngle reflected through the animVal attribute is always read only. */\ninterface SVGAngle {\n    readonly unitType: number;\n    value: number;\n    valueAsString: string;\n    valueInSpecifiedUnits: number;\n    convertToSpecifiedUnits(unitType: number): void;\n    newValueSpecifiedUnits(unitType: number, valueInSpecifiedUnits: number): void;\n    readonly SVG_ANGLETYPE_DEG: number;\n    readonly SVG_ANGLETYPE_GRAD: number;\n    readonly SVG_ANGLETYPE_RAD: number;\n    readonly SVG_ANGLETYPE_UNKNOWN: number;\n    readonly SVG_ANGLETYPE_UNSPECIFIED: number;\n}\n\ndeclare var SVGAngle: {\n    prototype: SVGAngle;\n    new(): SVGAngle;\n    readonly SVG_ANGLETYPE_DEG: number;\n    readonly SVG_ANGLETYPE_GRAD: number;\n    readonly SVG_ANGLETYPE_RAD: number;\n    readonly SVG_ANGLETYPE_UNKNOWN: number;\n    readonly SVG_ANGLETYPE_UNSPECIFIED: number;\n};\n\ninterface SVGAnimateElement extends SVGAnimationElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimateElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimateElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGAnimateElement: {\n    prototype: SVGAnimateElement;\n    new(): SVGAnimateElement;\n};\n\ninterface SVGAnimateMotionElement extends SVGAnimationElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimateMotionElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimateMotionElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGAnimateMotionElement: {\n    prototype: SVGAnimateMotionElement;\n    new(): SVGAnimateMotionElement;\n};\n\ninterface SVGAnimateTransformElement extends SVGAnimationElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimateTransformElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimateTransformElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGAnimateTransformElement: {\n    prototype: SVGAnimateTransformElement;\n    new(): SVGAnimateTransformElement;\n};\n\n/** Used for attributes of basic type <angle> which can be animated. */\ninterface SVGAnimatedAngle {\n    readonly animVal: SVGAngle;\n    readonly baseVal: SVGAngle;\n}\n\ndeclare var SVGAnimatedAngle: {\n    prototype: SVGAnimatedAngle;\n    new(): SVGAnimatedAngle;\n};\n\n/** Used for attributes of type boolean which can be animated. */\ninterface SVGAnimatedBoolean {\n    readonly animVal: boolean;\n    baseVal: boolean;\n}\n\ndeclare var SVGAnimatedBoolean: {\n    prototype: SVGAnimatedBoolean;\n    new(): SVGAnimatedBoolean;\n};\n\n/** Used for attributes whose value must be a constant from a particular enumeration and which can be animated. */\ninterface SVGAnimatedEnumeration {\n    readonly animVal: number;\n    baseVal: number;\n}\n\ndeclare var SVGAnimatedEnumeration: {\n    prototype: SVGAnimatedEnumeration;\n    new(): SVGAnimatedEnumeration;\n};\n\n/** Used for attributes of basic type <integer> which can be animated. */\ninterface SVGAnimatedInteger {\n    readonly animVal: number;\n    baseVal: number;\n}\n\ndeclare var SVGAnimatedInteger: {\n    prototype: SVGAnimatedInteger;\n    new(): SVGAnimatedInteger;\n};\n\n/** Used for attributes of basic type <length> which can be animated. */\ninterface SVGAnimatedLength {\n    readonly animVal: SVGLength;\n    readonly baseVal: SVGLength;\n}\n\ndeclare var SVGAnimatedLength: {\n    prototype: SVGAnimatedLength;\n    new(): SVGAnimatedLength;\n};\n\n/** Used for attributes of type SVGLengthList which can be animated. */\ninterface SVGAnimatedLengthList {\n    readonly animVal: SVGLengthList;\n    readonly baseVal: SVGLengthList;\n}\n\ndeclare var SVGAnimatedLengthList: {\n    prototype: SVGAnimatedLengthList;\n    new(): SVGAnimatedLengthList;\n};\n\n/** Used for attributes of basic type <Number> which can be animated. */\ninterface SVGAnimatedNumber {\n    readonly animVal: number;\n    baseVal: number;\n}\n\ndeclare var SVGAnimatedNumber: {\n    prototype: SVGAnimatedNumber;\n    new(): SVGAnimatedNumber;\n};\n\n/** The SVGAnimatedNumber interface is used for attributes which take a list of numbers and which can be animated. */\ninterface SVGAnimatedNumberList {\n    readonly animVal: SVGNumberList;\n    readonly baseVal: SVGNumberList;\n}\n\ndeclare var SVGAnimatedNumberList: {\n    prototype: SVGAnimatedNumberList;\n    new(): SVGAnimatedNumberList;\n};\n\ninterface SVGAnimatedPoints {\n    readonly animatedPoints: SVGPointList;\n    readonly points: SVGPointList;\n}\n\n/** Used for attributes of type SVGPreserveAspectRatio which can be animated. */\ninterface SVGAnimatedPreserveAspectRatio {\n    readonly animVal: SVGPreserveAspectRatio;\n    readonly baseVal: SVGPreserveAspectRatio;\n}\n\ndeclare var SVGAnimatedPreserveAspectRatio: {\n    prototype: SVGAnimatedPreserveAspectRatio;\n    new(): SVGAnimatedPreserveAspectRatio;\n};\n\n/** Used for attributes of basic SVGRect which can be animated. */\ninterface SVGAnimatedRect {\n    readonly animVal: DOMRectReadOnly;\n    readonly baseVal: DOMRect;\n}\n\ndeclare var SVGAnimatedRect: {\n    prototype: SVGAnimatedRect;\n    new(): SVGAnimatedRect;\n};\n\n/** The SVGAnimatedString interface represents string attributes which can be animated from each SVG declaration. You need to create SVG attribute before doing anything else, everything should be declared inside this. */\ninterface SVGAnimatedString {\n    readonly animVal: string;\n    baseVal: string;\n}\n\ndeclare var SVGAnimatedString: {\n    prototype: SVGAnimatedString;\n    new(): SVGAnimatedString;\n};\n\n/** Used for attributes which take a list of numbers and which can be animated. */\ninterface SVGAnimatedTransformList {\n    readonly animVal: SVGTransformList;\n    readonly baseVal: SVGTransformList;\n}\n\ndeclare var SVGAnimatedTransformList: {\n    prototype: SVGAnimatedTransformList;\n    new(): SVGAnimatedTransformList;\n};\n\ninterface SVGAnimationElement extends SVGElement {\n    readonly targetElement: SVGElement;\n    getCurrentTime(): number;\n    getSimpleDuration(): number;\n    getStartTime(): number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimationElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGAnimationElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGAnimationElement: {\n    prototype: SVGAnimationElement;\n    new(): SVGAnimationElement;\n};\n\n/** An interface for the <circle> element. The circle element is defined by the cx and cy attributes that denote the coordinates of the centre of the circle. */\ninterface SVGCircleElement extends SVGGeometryElement {\n    readonly cx: SVGAnimatedLength;\n    readonly cy: SVGAnimatedLength;\n    readonly r: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGCircleElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGCircleElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGCircleElement: {\n    prototype: SVGCircleElement;\n    new(): SVGCircleElement;\n};\n\n/** Provides access to the properties of <clipPath> elements, as well as methods to manipulate them. */\ninterface SVGClipPathElement extends SVGElement {\n    readonly clipPathUnits: SVGAnimatedEnumeration;\n    readonly transform: SVGAnimatedTransformList;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGClipPathElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGClipPathElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGClipPathElement: {\n    prototype: SVGClipPathElement;\n    new(): SVGClipPathElement;\n};\n\n/** A base interface used by the component transfer function interfaces. */\ninterface SVGComponentTransferFunctionElement extends SVGElement {\n    readonly amplitude: SVGAnimatedNumber;\n    readonly exponent: SVGAnimatedNumber;\n    readonly intercept: SVGAnimatedNumber;\n    readonly offset: SVGAnimatedNumber;\n    readonly slope: SVGAnimatedNumber;\n    readonly tableValues: SVGAnimatedNumberList;\n    readonly type: SVGAnimatedEnumeration;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_GAMMA: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_LINEAR: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_TABLE: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGComponentTransferFunctionElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGComponentTransferFunctionElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGComponentTransferFunctionElement: {\n    prototype: SVGComponentTransferFunctionElement;\n    new(): SVGComponentTransferFunctionElement;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_GAMMA: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_LINEAR: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_TABLE: number;\n    readonly SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN: number;\n};\n\ninterface SVGCursorElement extends SVGElement {\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGCursorElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGCursorElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGCursorElement: {\n    prototype: SVGCursorElement;\n    new(): SVGCursorElement;\n};\n\n/** Corresponds to the <defs> element. */\ninterface SVGDefsElement extends SVGGraphicsElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGDefsElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGDefsElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGDefsElement: {\n    prototype: SVGDefsElement;\n    new(): SVGDefsElement;\n};\n\n/** Corresponds to the <desc> element. */\ninterface SVGDescElement extends SVGElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGDescElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGDescElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGDescElement: {\n    prototype: SVGDescElement;\n    new(): SVGDescElement;\n};\n\ninterface SVGElementEventMap extends ElementEventMap, GlobalEventHandlersEventMap, DocumentAndElementEventHandlersEventMap {\n}\n\n/** All of the SVG DOM interfaces that correspond directly to elements in the SVG language derive from the SVGElement interface. */\ninterface SVGElement extends Element, DocumentAndElementEventHandlers, DocumentAndElementEventHandlers, ElementCSSInlineStyle, GlobalEventHandlers, GlobalEventHandlers, HTMLOrSVGElement, SVGElementInstance {\n    /** @deprecated */\n    readonly className: any;\n    readonly ownerSVGElement: SVGSVGElement | null;\n    readonly viewportElement: SVGElement | null;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGElement: {\n    prototype: SVGElement;\n    new(): SVGElement;\n};\n\ninterface SVGElementInstance extends EventTarget {\n    readonly correspondingElement: SVGElement;\n    readonly correspondingUseElement: SVGUseElement;\n}\n\ndeclare var SVGElementInstance: {\n    prototype: SVGElementInstance;\n    new(): SVGElementInstance;\n};\n\ninterface SVGElementInstanceList {\n    /** @deprecated */\n    readonly length: number;\n    /** @deprecated */\n    item(index: number): SVGElementInstance;\n}\n\ndeclare var SVGElementInstanceList: {\n    prototype: SVGElementInstanceList;\n    new(): SVGElementInstanceList;\n};\n\n/** Provides access to the properties of <ellipse> elements. */\ninterface SVGEllipseElement extends SVGGeometryElement {\n    readonly cx: SVGAnimatedLength;\n    readonly cy: SVGAnimatedLength;\n    readonly rx: SVGAnimatedLength;\n    readonly ry: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGEllipseElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGEllipseElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGEllipseElement: {\n    prototype: SVGEllipseElement;\n    new(): SVGEllipseElement;\n};\n\n/** Corresponds to the <feBlend> element. */\ninterface SVGFEBlendElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly in2: SVGAnimatedString;\n    readonly mode: SVGAnimatedEnumeration;\n    readonly SVG_FEBLEND_MODE_COLOR: number;\n    readonly SVG_FEBLEND_MODE_COLOR_BURN: number;\n    readonly SVG_FEBLEND_MODE_COLOR_DODGE: number;\n    readonly SVG_FEBLEND_MODE_DARKEN: number;\n    readonly SVG_FEBLEND_MODE_DIFFERENCE: number;\n    readonly SVG_FEBLEND_MODE_EXCLUSION: number;\n    readonly SVG_FEBLEND_MODE_HARD_LIGHT: number;\n    readonly SVG_FEBLEND_MODE_HUE: number;\n    readonly SVG_FEBLEND_MODE_LIGHTEN: number;\n    readonly SVG_FEBLEND_MODE_LUMINOSITY: number;\n    readonly SVG_FEBLEND_MODE_MULTIPLY: number;\n    readonly SVG_FEBLEND_MODE_NORMAL: number;\n    readonly SVG_FEBLEND_MODE_OVERLAY: number;\n    readonly SVG_FEBLEND_MODE_SATURATION: number;\n    readonly SVG_FEBLEND_MODE_SCREEN: number;\n    readonly SVG_FEBLEND_MODE_SOFT_LIGHT: number;\n    readonly SVG_FEBLEND_MODE_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEBlendElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEBlendElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEBlendElement: {\n    prototype: SVGFEBlendElement;\n    new(): SVGFEBlendElement;\n    readonly SVG_FEBLEND_MODE_COLOR: number;\n    readonly SVG_FEBLEND_MODE_COLOR_BURN: number;\n    readonly SVG_FEBLEND_MODE_COLOR_DODGE: number;\n    readonly SVG_FEBLEND_MODE_DARKEN: number;\n    readonly SVG_FEBLEND_MODE_DIFFERENCE: number;\n    readonly SVG_FEBLEND_MODE_EXCLUSION: number;\n    readonly SVG_FEBLEND_MODE_HARD_LIGHT: number;\n    readonly SVG_FEBLEND_MODE_HUE: number;\n    readonly SVG_FEBLEND_MODE_LIGHTEN: number;\n    readonly SVG_FEBLEND_MODE_LUMINOSITY: number;\n    readonly SVG_FEBLEND_MODE_MULTIPLY: number;\n    readonly SVG_FEBLEND_MODE_NORMAL: number;\n    readonly SVG_FEBLEND_MODE_OVERLAY: number;\n    readonly SVG_FEBLEND_MODE_SATURATION: number;\n    readonly SVG_FEBLEND_MODE_SCREEN: number;\n    readonly SVG_FEBLEND_MODE_SOFT_LIGHT: number;\n    readonly SVG_FEBLEND_MODE_UNKNOWN: number;\n};\n\n/** Corresponds to the <feColorMatrix> element. */\ninterface SVGFEColorMatrixElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly type: SVGAnimatedEnumeration;\n    readonly values: SVGAnimatedNumberList;\n    readonly SVG_FECOLORMATRIX_TYPE_HUEROTATE: number;\n    readonly SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA: number;\n    readonly SVG_FECOLORMATRIX_TYPE_MATRIX: number;\n    readonly SVG_FECOLORMATRIX_TYPE_SATURATE: number;\n    readonly SVG_FECOLORMATRIX_TYPE_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEColorMatrixElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEColorMatrixElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEColorMatrixElement: {\n    prototype: SVGFEColorMatrixElement;\n    new(): SVGFEColorMatrixElement;\n    readonly SVG_FECOLORMATRIX_TYPE_HUEROTATE: number;\n    readonly SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA: number;\n    readonly SVG_FECOLORMATRIX_TYPE_MATRIX: number;\n    readonly SVG_FECOLORMATRIX_TYPE_SATURATE: number;\n    readonly SVG_FECOLORMATRIX_TYPE_UNKNOWN: number;\n};\n\n/** Corresponds to the <feComponentTransfer> element. */\ninterface SVGFEComponentTransferElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEComponentTransferElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEComponentTransferElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEComponentTransferElement: {\n    prototype: SVGFEComponentTransferElement;\n    new(): SVGFEComponentTransferElement;\n};\n\n/** Corresponds to the <feComposite> element. */\ninterface SVGFECompositeElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly in2: SVGAnimatedString;\n    readonly k1: SVGAnimatedNumber;\n    readonly k2: SVGAnimatedNumber;\n    readonly k3: SVGAnimatedNumber;\n    readonly k4: SVGAnimatedNumber;\n    readonly operator: SVGAnimatedEnumeration;\n    readonly SVG_FECOMPOSITE_OPERATOR_ARITHMETIC: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_ATOP: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_IN: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_OUT: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_OVER: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_UNKNOWN: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_XOR: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFECompositeElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFECompositeElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFECompositeElement: {\n    prototype: SVGFECompositeElement;\n    new(): SVGFECompositeElement;\n    readonly SVG_FECOMPOSITE_OPERATOR_ARITHMETIC: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_ATOP: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_IN: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_OUT: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_OVER: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_UNKNOWN: number;\n    readonly SVG_FECOMPOSITE_OPERATOR_XOR: number;\n};\n\n/** Corresponds to the <feConvolveMatrix> element. */\ninterface SVGFEConvolveMatrixElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly bias: SVGAnimatedNumber;\n    readonly divisor: SVGAnimatedNumber;\n    readonly edgeMode: SVGAnimatedEnumeration;\n    readonly in1: SVGAnimatedString;\n    readonly kernelMatrix: SVGAnimatedNumberList;\n    readonly kernelUnitLengthX: SVGAnimatedNumber;\n    readonly kernelUnitLengthY: SVGAnimatedNumber;\n    readonly orderX: SVGAnimatedInteger;\n    readonly orderY: SVGAnimatedInteger;\n    readonly preserveAlpha: SVGAnimatedBoolean;\n    readonly targetX: SVGAnimatedInteger;\n    readonly targetY: SVGAnimatedInteger;\n    readonly SVG_EDGEMODE_DUPLICATE: number;\n    readonly SVG_EDGEMODE_NONE: number;\n    readonly SVG_EDGEMODE_UNKNOWN: number;\n    readonly SVG_EDGEMODE_WRAP: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEConvolveMatrixElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEConvolveMatrixElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEConvolveMatrixElement: {\n    prototype: SVGFEConvolveMatrixElement;\n    new(): SVGFEConvolveMatrixElement;\n    readonly SVG_EDGEMODE_DUPLICATE: number;\n    readonly SVG_EDGEMODE_NONE: number;\n    readonly SVG_EDGEMODE_UNKNOWN: number;\n    readonly SVG_EDGEMODE_WRAP: number;\n};\n\n/** Corresponds to the <feDiffuseLighting> element. */\ninterface SVGFEDiffuseLightingElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly diffuseConstant: SVGAnimatedNumber;\n    readonly in1: SVGAnimatedString;\n    readonly kernelUnitLengthX: SVGAnimatedNumber;\n    readonly kernelUnitLengthY: SVGAnimatedNumber;\n    readonly surfaceScale: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDiffuseLightingElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDiffuseLightingElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEDiffuseLightingElement: {\n    prototype: SVGFEDiffuseLightingElement;\n    new(): SVGFEDiffuseLightingElement;\n};\n\n/** Corresponds to the <feDisplacementMap> element. */\ninterface SVGFEDisplacementMapElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly in2: SVGAnimatedString;\n    readonly scale: SVGAnimatedNumber;\n    readonly xChannelSelector: SVGAnimatedEnumeration;\n    readonly yChannelSelector: SVGAnimatedEnumeration;\n    readonly SVG_CHANNEL_A: number;\n    readonly SVG_CHANNEL_B: number;\n    readonly SVG_CHANNEL_G: number;\n    readonly SVG_CHANNEL_R: number;\n    readonly SVG_CHANNEL_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDisplacementMapElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDisplacementMapElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEDisplacementMapElement: {\n    prototype: SVGFEDisplacementMapElement;\n    new(): SVGFEDisplacementMapElement;\n    readonly SVG_CHANNEL_A: number;\n    readonly SVG_CHANNEL_B: number;\n    readonly SVG_CHANNEL_G: number;\n    readonly SVG_CHANNEL_R: number;\n    readonly SVG_CHANNEL_UNKNOWN: number;\n};\n\n/** Corresponds to the <feDistantLight> element. */\ninterface SVGFEDistantLightElement extends SVGElement {\n    readonly azimuth: SVGAnimatedNumber;\n    readonly elevation: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDistantLightElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDistantLightElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEDistantLightElement: {\n    prototype: SVGFEDistantLightElement;\n    new(): SVGFEDistantLightElement;\n};\n\ninterface SVGFEDropShadowElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly dx: SVGAnimatedNumber;\n    readonly dy: SVGAnimatedNumber;\n    readonly in1: SVGAnimatedString;\n    readonly stdDeviationX: SVGAnimatedNumber;\n    readonly stdDeviationY: SVGAnimatedNumber;\n    setStdDeviation(stdDeviationX: number, stdDeviationY: number): void;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDropShadowElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEDropShadowElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEDropShadowElement: {\n    prototype: SVGFEDropShadowElement;\n    new(): SVGFEDropShadowElement;\n};\n\n/** Corresponds to the <feFlood> element. */\ninterface SVGFEFloodElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFloodElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFloodElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEFloodElement: {\n    prototype: SVGFEFloodElement;\n    new(): SVGFEFloodElement;\n};\n\n/** Corresponds to the <feFuncA> element. */\ninterface SVGFEFuncAElement extends SVGComponentTransferFunctionElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncAElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncAElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEFuncAElement: {\n    prototype: SVGFEFuncAElement;\n    new(): SVGFEFuncAElement;\n};\n\n/** Corresponds to the <feFuncB> element. */\ninterface SVGFEFuncBElement extends SVGComponentTransferFunctionElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncBElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncBElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEFuncBElement: {\n    prototype: SVGFEFuncBElement;\n    new(): SVGFEFuncBElement;\n};\n\n/** Corresponds to the <feFuncG> element. */\ninterface SVGFEFuncGElement extends SVGComponentTransferFunctionElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncGElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncGElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEFuncGElement: {\n    prototype: SVGFEFuncGElement;\n    new(): SVGFEFuncGElement;\n};\n\n/** Corresponds to the <feFuncR> element. */\ninterface SVGFEFuncRElement extends SVGComponentTransferFunctionElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncRElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEFuncRElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEFuncRElement: {\n    prototype: SVGFEFuncRElement;\n    new(): SVGFEFuncRElement;\n};\n\n/** Corresponds to the <feGaussianBlur> element. */\ninterface SVGFEGaussianBlurElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly stdDeviationX: SVGAnimatedNumber;\n    readonly stdDeviationY: SVGAnimatedNumber;\n    setStdDeviation(stdDeviationX: number, stdDeviationY: number): void;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEGaussianBlurElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEGaussianBlurElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEGaussianBlurElement: {\n    prototype: SVGFEGaussianBlurElement;\n    new(): SVGFEGaussianBlurElement;\n};\n\n/** Corresponds to the <feImage> element. */\ninterface SVGFEImageElement extends SVGElement, SVGFilterPrimitiveStandardAttributes, SVGURIReference {\n    readonly preserveAspectRatio: SVGAnimatedPreserveAspectRatio;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEImageElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEImageElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEImageElement: {\n    prototype: SVGFEImageElement;\n    new(): SVGFEImageElement;\n};\n\n/** Corresponds to the <feMerge> element. */\ninterface SVGFEMergeElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMergeElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMergeElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEMergeElement: {\n    prototype: SVGFEMergeElement;\n    new(): SVGFEMergeElement;\n};\n\n/** Corresponds to the <feMergeNode> element. */\ninterface SVGFEMergeNodeElement extends SVGElement {\n    readonly in1: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMergeNodeElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMergeNodeElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEMergeNodeElement: {\n    prototype: SVGFEMergeNodeElement;\n    new(): SVGFEMergeNodeElement;\n};\n\n/** Corresponds to the <feMorphology> element. */\ninterface SVGFEMorphologyElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly operator: SVGAnimatedEnumeration;\n    readonly radiusX: SVGAnimatedNumber;\n    readonly radiusY: SVGAnimatedNumber;\n    readonly SVG_MORPHOLOGY_OPERATOR_DILATE: number;\n    readonly SVG_MORPHOLOGY_OPERATOR_ERODE: number;\n    readonly SVG_MORPHOLOGY_OPERATOR_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMorphologyElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEMorphologyElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEMorphologyElement: {\n    prototype: SVGFEMorphologyElement;\n    new(): SVGFEMorphologyElement;\n    readonly SVG_MORPHOLOGY_OPERATOR_DILATE: number;\n    readonly SVG_MORPHOLOGY_OPERATOR_ERODE: number;\n    readonly SVG_MORPHOLOGY_OPERATOR_UNKNOWN: number;\n};\n\n/** Corresponds to the <feOffset> element. */\ninterface SVGFEOffsetElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly dx: SVGAnimatedNumber;\n    readonly dy: SVGAnimatedNumber;\n    readonly in1: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEOffsetElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEOffsetElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEOffsetElement: {\n    prototype: SVGFEOffsetElement;\n    new(): SVGFEOffsetElement;\n};\n\n/** Corresponds to the <fePointLight> element. */\ninterface SVGFEPointLightElement extends SVGElement {\n    readonly x: SVGAnimatedNumber;\n    readonly y: SVGAnimatedNumber;\n    readonly z: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEPointLightElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFEPointLightElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFEPointLightElement: {\n    prototype: SVGFEPointLightElement;\n    new(): SVGFEPointLightElement;\n};\n\n/** Corresponds to the <feSpecularLighting> element. */\ninterface SVGFESpecularLightingElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    readonly kernelUnitLengthX: SVGAnimatedNumber;\n    readonly kernelUnitLengthY: SVGAnimatedNumber;\n    readonly specularConstant: SVGAnimatedNumber;\n    readonly specularExponent: SVGAnimatedNumber;\n    readonly surfaceScale: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFESpecularLightingElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFESpecularLightingElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFESpecularLightingElement: {\n    prototype: SVGFESpecularLightingElement;\n    new(): SVGFESpecularLightingElement;\n};\n\n/** Corresponds to the <feSpotLight> element. */\ninterface SVGFESpotLightElement extends SVGElement {\n    readonly limitingConeAngle: SVGAnimatedNumber;\n    readonly pointsAtX: SVGAnimatedNumber;\n    readonly pointsAtY: SVGAnimatedNumber;\n    readonly pointsAtZ: SVGAnimatedNumber;\n    readonly specularExponent: SVGAnimatedNumber;\n    readonly x: SVGAnimatedNumber;\n    readonly y: SVGAnimatedNumber;\n    readonly z: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFESpotLightElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFESpotLightElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFESpotLightElement: {\n    prototype: SVGFESpotLightElement;\n    new(): SVGFESpotLightElement;\n};\n\n/** Corresponds to the <feTile> element. */\ninterface SVGFETileElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly in1: SVGAnimatedString;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFETileElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFETileElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFETileElement: {\n    prototype: SVGFETileElement;\n    new(): SVGFETileElement;\n};\n\n/** Corresponds to the <feTurbulence> element. */\ninterface SVGFETurbulenceElement extends SVGElement, SVGFilterPrimitiveStandardAttributes {\n    readonly baseFrequencyX: SVGAnimatedNumber;\n    readonly baseFrequencyY: SVGAnimatedNumber;\n    readonly numOctaves: SVGAnimatedInteger;\n    readonly seed: SVGAnimatedNumber;\n    readonly stitchTiles: SVGAnimatedEnumeration;\n    readonly type: SVGAnimatedEnumeration;\n    readonly SVG_STITCHTYPE_NOSTITCH: number;\n    readonly SVG_STITCHTYPE_STITCH: number;\n    readonly SVG_STITCHTYPE_UNKNOWN: number;\n    readonly SVG_TURBULENCE_TYPE_FRACTALNOISE: number;\n    readonly SVG_TURBULENCE_TYPE_TURBULENCE: number;\n    readonly SVG_TURBULENCE_TYPE_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFETurbulenceElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFETurbulenceElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFETurbulenceElement: {\n    prototype: SVGFETurbulenceElement;\n    new(): SVGFETurbulenceElement;\n    readonly SVG_STITCHTYPE_NOSTITCH: number;\n    readonly SVG_STITCHTYPE_STITCH: number;\n    readonly SVG_STITCHTYPE_UNKNOWN: number;\n    readonly SVG_TURBULENCE_TYPE_FRACTALNOISE: number;\n    readonly SVG_TURBULENCE_TYPE_TURBULENCE: number;\n    readonly SVG_TURBULENCE_TYPE_UNKNOWN: number;\n};\n\n/** Provides access to the properties of <filter> elements, as well as methods to manipulate them. */\ninterface SVGFilterElement extends SVGElement, SVGURIReference {\n    readonly filterUnits: SVGAnimatedEnumeration;\n    readonly height: SVGAnimatedLength;\n    readonly primitiveUnits: SVGAnimatedEnumeration;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFilterElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGFilterElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGFilterElement: {\n    prototype: SVGFilterElement;\n    new(): SVGFilterElement;\n};\n\ninterface SVGFilterPrimitiveStandardAttributes {\n    readonly height: SVGAnimatedLength;\n    readonly result: SVGAnimatedString;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n}\n\ninterface SVGFitToViewBox {\n    readonly preserveAspectRatio: SVGAnimatedPreserveAspectRatio;\n    readonly viewBox: SVGAnimatedRect;\n}\n\n/** Provides access to the properties of <foreignObject> elements, as well as methods to manipulate them. */\ninterface SVGForeignObjectElement extends SVGGraphicsElement {\n    readonly height: SVGAnimatedLength;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGForeignObjectElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGForeignObjectElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGForeignObjectElement: {\n    prototype: SVGForeignObjectElement;\n    new(): SVGForeignObjectElement;\n};\n\n/** Corresponds to the <g> element. */\ninterface SVGGElement extends SVGGraphicsElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGGElement: {\n    prototype: SVGGElement;\n    new(): SVGGElement;\n};\n\ninterface SVGGeometryElement extends SVGGraphicsElement {\n    readonly pathLength: SVGAnimatedNumber;\n    getPointAtLength(distance: number): DOMPoint;\n    getTotalLength(): number;\n    isPointInFill(point?: DOMPointInit): boolean;\n    isPointInStroke(point?: DOMPointInit): boolean;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGeometryElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGeometryElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGGeometryElement: {\n    prototype: SVGGeometryElement;\n    new(): SVGGeometryElement;\n};\n\n/** The SVGGradient interface is a base interface used by SVGLinearGradientElement and SVGRadialGradientElement. */\ninterface SVGGradientElement extends SVGElement, SVGURIReference {\n    readonly gradientTransform: SVGAnimatedTransformList;\n    readonly gradientUnits: SVGAnimatedEnumeration;\n    readonly spreadMethod: SVGAnimatedEnumeration;\n    readonly SVG_SPREADMETHOD_PAD: number;\n    readonly SVG_SPREADMETHOD_REFLECT: number;\n    readonly SVG_SPREADMETHOD_REPEAT: number;\n    readonly SVG_SPREADMETHOD_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGradientElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGradientElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGGradientElement: {\n    prototype: SVGGradientElement;\n    new(): SVGGradientElement;\n    readonly SVG_SPREADMETHOD_PAD: number;\n    readonly SVG_SPREADMETHOD_REFLECT: number;\n    readonly SVG_SPREADMETHOD_REPEAT: number;\n    readonly SVG_SPREADMETHOD_UNKNOWN: number;\n};\n\n/** SVG elements whose primary purpose is to directly render graphics into a group. */\ninterface SVGGraphicsElement extends SVGElement, SVGTests {\n    readonly transform: SVGAnimatedTransformList;\n    getBBox(options?: SVGBoundingBoxOptions): DOMRect;\n    getCTM(): DOMMatrix | null;\n    getScreenCTM(): DOMMatrix | null;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGraphicsElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGGraphicsElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGGraphicsElement: {\n    prototype: SVGGraphicsElement;\n    new(): SVGGraphicsElement;\n};\n\n/** Corresponds to the <image> element. */\ninterface SVGImageElement extends SVGGraphicsElement, SVGURIReference {\n    readonly height: SVGAnimatedLength;\n    readonly preserveAspectRatio: SVGAnimatedPreserveAspectRatio;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGImageElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGImageElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGImageElement: {\n    prototype: SVGImageElement;\n    new(): SVGImageElement;\n};\n\n/** Correspond to the <length> basic data type. */\ninterface SVGLength {\n    readonly unitType: number;\n    value: number;\n    valueAsString: string;\n    valueInSpecifiedUnits: number;\n    convertToSpecifiedUnits(unitType: number): void;\n    newValueSpecifiedUnits(unitType: number, valueInSpecifiedUnits: number): void;\n    readonly SVG_LENGTHTYPE_CM: number;\n    readonly SVG_LENGTHTYPE_EMS: number;\n    readonly SVG_LENGTHTYPE_EXS: number;\n    readonly SVG_LENGTHTYPE_IN: number;\n    readonly SVG_LENGTHTYPE_MM: number;\n    readonly SVG_LENGTHTYPE_NUMBER: number;\n    readonly SVG_LENGTHTYPE_PC: number;\n    readonly SVG_LENGTHTYPE_PERCENTAGE: number;\n    readonly SVG_LENGTHTYPE_PT: number;\n    readonly SVG_LENGTHTYPE_PX: number;\n    readonly SVG_LENGTHTYPE_UNKNOWN: number;\n}\n\ndeclare var SVGLength: {\n    prototype: SVGLength;\n    new(): SVGLength;\n    readonly SVG_LENGTHTYPE_CM: number;\n    readonly SVG_LENGTHTYPE_EMS: number;\n    readonly SVG_LENGTHTYPE_EXS: number;\n    readonly SVG_LENGTHTYPE_IN: number;\n    readonly SVG_LENGTHTYPE_MM: number;\n    readonly SVG_LENGTHTYPE_NUMBER: number;\n    readonly SVG_LENGTHTYPE_PC: number;\n    readonly SVG_LENGTHTYPE_PERCENTAGE: number;\n    readonly SVG_LENGTHTYPE_PT: number;\n    readonly SVG_LENGTHTYPE_PX: number;\n    readonly SVG_LENGTHTYPE_UNKNOWN: number;\n};\n\n/** The SVGLengthList defines a list of SVGLength objects. */\ninterface SVGLengthList {\n    readonly length: number;\n    readonly numberOfItems: number;\n    appendItem(newItem: SVGLength): SVGLength;\n    clear(): void;\n    getItem(index: number): SVGLength;\n    initialize(newItem: SVGLength): SVGLength;\n    insertItemBefore(newItem: SVGLength, index: number): SVGLength;\n    removeItem(index: number): SVGLength;\n    replaceItem(newItem: SVGLength, index: number): SVGLength;\n    [index: number]: SVGLength;\n}\n\ndeclare var SVGLengthList: {\n    prototype: SVGLengthList;\n    new(): SVGLengthList;\n};\n\n/** Provides access to the properties of <line> elements, as well as methods to manipulate them. */\ninterface SVGLineElement extends SVGGeometryElement {\n    readonly x1: SVGAnimatedLength;\n    readonly x2: SVGAnimatedLength;\n    readonly y1: SVGAnimatedLength;\n    readonly y2: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGLineElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGLineElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGLineElement: {\n    prototype: SVGLineElement;\n    new(): SVGLineElement;\n};\n\n/** Corresponds to the <linearGradient> element. */\ninterface SVGLinearGradientElement extends SVGGradientElement {\n    readonly x1: SVGAnimatedLength;\n    readonly x2: SVGAnimatedLength;\n    readonly y1: SVGAnimatedLength;\n    readonly y2: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGLinearGradientElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGLinearGradientElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGLinearGradientElement: {\n    prototype: SVGLinearGradientElement;\n    new(): SVGLinearGradientElement;\n};\n\ninterface SVGMarkerElement extends SVGElement, SVGFitToViewBox {\n    readonly markerHeight: SVGAnimatedLength;\n    readonly markerUnits: SVGAnimatedEnumeration;\n    readonly markerWidth: SVGAnimatedLength;\n    readonly orientAngle: SVGAnimatedAngle;\n    readonly orientType: SVGAnimatedEnumeration;\n    readonly refX: SVGAnimatedLength;\n    readonly refY: SVGAnimatedLength;\n    setOrientToAngle(angle: SVGAngle): void;\n    setOrientToAuto(): void;\n    readonly SVG_MARKERUNITS_STROKEWIDTH: number;\n    readonly SVG_MARKERUNITS_UNKNOWN: number;\n    readonly SVG_MARKERUNITS_USERSPACEONUSE: number;\n    readonly SVG_MARKER_ORIENT_ANGLE: number;\n    readonly SVG_MARKER_ORIENT_AUTO: number;\n    readonly SVG_MARKER_ORIENT_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMarkerElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMarkerElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGMarkerElement: {\n    prototype: SVGMarkerElement;\n    new(): SVGMarkerElement;\n    readonly SVG_MARKERUNITS_STROKEWIDTH: number;\n    readonly SVG_MARKERUNITS_UNKNOWN: number;\n    readonly SVG_MARKERUNITS_USERSPACEONUSE: number;\n    readonly SVG_MARKER_ORIENT_ANGLE: number;\n    readonly SVG_MARKER_ORIENT_AUTO: number;\n    readonly SVG_MARKER_ORIENT_UNKNOWN: number;\n};\n\n/** Provides access to the properties of <mask> elements, as well as methods to manipulate them. */\ninterface SVGMaskElement extends SVGElement {\n    readonly height: SVGAnimatedLength;\n    readonly maskContentUnits: SVGAnimatedEnumeration;\n    readonly maskUnits: SVGAnimatedEnumeration;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMaskElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMaskElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGMaskElement: {\n    prototype: SVGMaskElement;\n    new(): SVGMaskElement;\n};\n\n/** Corresponds to the <metadata> element. */\ninterface SVGMetadataElement extends SVGElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMetadataElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGMetadataElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGMetadataElement: {\n    prototype: SVGMetadataElement;\n    new(): SVGMetadataElement;\n};\n\n/** Corresponds to the <number> basic data type. */\ninterface SVGNumber {\n    value: number;\n}\n\ndeclare var SVGNumber: {\n    prototype: SVGNumber;\n    new(): SVGNumber;\n};\n\n/** The SVGNumberList defines a list of SVGNumber objects. */\ninterface SVGNumberList {\n    readonly length: number;\n    readonly numberOfItems: number;\n    appendItem(newItem: SVGNumber): SVGNumber;\n    clear(): void;\n    getItem(index: number): SVGNumber;\n    initialize(newItem: SVGNumber): SVGNumber;\n    insertItemBefore(newItem: SVGNumber, index: number): SVGNumber;\n    removeItem(index: number): SVGNumber;\n    replaceItem(newItem: SVGNumber, index: number): SVGNumber;\n    [index: number]: SVGNumber;\n}\n\ndeclare var SVGNumberList: {\n    prototype: SVGNumberList;\n    new(): SVGNumberList;\n};\n\n/** Corresponds to the <path> element. */\ninterface SVGPathElement extends SVGGraphicsElement {\n    /** @deprecated */\n    readonly pathSegList: SVGPathSegList;\n    /** @deprecated */\n    createSVGPathSegArcAbs(x: number, y: number, r1: number, r2: number, angle: number, largeArcFlag: boolean, sweepFlag: boolean): SVGPathSegArcAbs;\n    /** @deprecated */\n    createSVGPathSegArcRel(x: number, y: number, r1: number, r2: number, angle: number, largeArcFlag: boolean, sweepFlag: boolean): SVGPathSegArcRel;\n    /** @deprecated */\n    createSVGPathSegClosePath(): SVGPathSegClosePath;\n    /** @deprecated */\n    createSVGPathSegCurvetoCubicAbs(x: number, y: number, x1: number, y1: number, x2: number, y2: number): SVGPathSegCurvetoCubicAbs;\n    /** @deprecated */\n    createSVGPathSegCurvetoCubicRel(x: number, y: number, x1: number, y1: number, x2: number, y2: number): SVGPathSegCurvetoCubicRel;\n    /** @deprecated */\n    createSVGPathSegCurvetoCubicSmoothAbs(x: number, y: number, x2: number, y2: number): SVGPathSegCurvetoCubicSmoothAbs;\n    /** @deprecated */\n    createSVGPathSegCurvetoCubicSmoothRel(x: number, y: number, x2: number, y2: number): SVGPathSegCurvetoCubicSmoothRel;\n    /** @deprecated */\n    createSVGPathSegCurvetoQuadraticAbs(x: number, y: number, x1: number, y1: number): SVGPathSegCurvetoQuadraticAbs;\n    /** @deprecated */\n    createSVGPathSegCurvetoQuadraticRel(x: number, y: number, x1: number, y1: number): SVGPathSegCurvetoQuadraticRel;\n    /** @deprecated */\n    createSVGPathSegCurvetoQuadraticSmoothAbs(x: number, y: number): SVGPathSegCurvetoQuadraticSmoothAbs;\n    /** @deprecated */\n    createSVGPathSegCurvetoQuadraticSmoothRel(x: number, y: number): SVGPathSegCurvetoQuadraticSmoothRel;\n    /** @deprecated */\n    createSVGPathSegLinetoAbs(x: number, y: number): SVGPathSegLinetoAbs;\n    /** @deprecated */\n    createSVGPathSegLinetoHorizontalAbs(x: number): SVGPathSegLinetoHorizontalAbs;\n    /** @deprecated */\n    createSVGPathSegLinetoHorizontalRel(x: number): SVGPathSegLinetoHorizontalRel;\n    /** @deprecated */\n    createSVGPathSegLinetoRel(x: number, y: number): SVGPathSegLinetoRel;\n    /** @deprecated */\n    createSVGPathSegLinetoVerticalAbs(y: number): SVGPathSegLinetoVerticalAbs;\n    /** @deprecated */\n    createSVGPathSegLinetoVerticalRel(y: number): SVGPathSegLinetoVerticalRel;\n    /** @deprecated */\n    createSVGPathSegMovetoAbs(x: number, y: number): SVGPathSegMovetoAbs;\n    /** @deprecated */\n    createSVGPathSegMovetoRel(x: number, y: number): SVGPathSegMovetoRel;\n    /** @deprecated */\n    getPathSegAtLength(distance: number): number;\n    getPointAtLength(distance: number): SVGPoint;\n    getTotalLength(): number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPathElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPathElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGPathElement: {\n    prototype: SVGPathElement;\n    new(): SVGPathElement;\n};\n\ninterface SVGPathSeg {\n    readonly pathSegType: number;\n    readonly pathSegTypeAsLetter: string;\n    readonly PATHSEG_ARC_ABS: number;\n    readonly PATHSEG_ARC_REL: number;\n    readonly PATHSEG_CLOSEPATH: number;\n    readonly PATHSEG_CURVETO_CUBIC_ABS: number;\n    readonly PATHSEG_CURVETO_CUBIC_REL: number;\n    readonly PATHSEG_CURVETO_CUBIC_SMOOTH_ABS: number;\n    readonly PATHSEG_CURVETO_CUBIC_SMOOTH_REL: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_ABS: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_REL: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL: number;\n    readonly PATHSEG_LINETO_ABS: number;\n    readonly PATHSEG_LINETO_HORIZONTAL_ABS: number;\n    readonly PATHSEG_LINETO_HORIZONTAL_REL: number;\n    readonly PATHSEG_LINETO_REL: number;\n    readonly PATHSEG_LINETO_VERTICAL_ABS: number;\n    readonly PATHSEG_LINETO_VERTICAL_REL: number;\n    readonly PATHSEG_MOVETO_ABS: number;\n    readonly PATHSEG_MOVETO_REL: number;\n    readonly PATHSEG_UNKNOWN: number;\n}\n\ndeclare var SVGPathSeg: {\n    prototype: SVGPathSeg;\n    new(): SVGPathSeg;\n    readonly PATHSEG_ARC_ABS: number;\n    readonly PATHSEG_ARC_REL: number;\n    readonly PATHSEG_CLOSEPATH: number;\n    readonly PATHSEG_CURVETO_CUBIC_ABS: number;\n    readonly PATHSEG_CURVETO_CUBIC_REL: number;\n    readonly PATHSEG_CURVETO_CUBIC_SMOOTH_ABS: number;\n    readonly PATHSEG_CURVETO_CUBIC_SMOOTH_REL: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_ABS: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_REL: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS: number;\n    readonly PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL: number;\n    readonly PATHSEG_LINETO_ABS: number;\n    readonly PATHSEG_LINETO_HORIZONTAL_ABS: number;\n    readonly PATHSEG_LINETO_HORIZONTAL_REL: number;\n    readonly PATHSEG_LINETO_REL: number;\n    readonly PATHSEG_LINETO_VERTICAL_ABS: number;\n    readonly PATHSEG_LINETO_VERTICAL_REL: number;\n    readonly PATHSEG_MOVETO_ABS: number;\n    readonly PATHSEG_MOVETO_REL: number;\n    readonly PATHSEG_UNKNOWN: number;\n};\n\ninterface SVGPathSegArcAbs extends SVGPathSeg {\n    angle: number;\n    largeArcFlag: boolean;\n    r1: number;\n    r2: number;\n    sweepFlag: boolean;\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegArcAbs: {\n    prototype: SVGPathSegArcAbs;\n    new(): SVGPathSegArcAbs;\n};\n\ninterface SVGPathSegArcRel extends SVGPathSeg {\n    angle: number;\n    largeArcFlag: boolean;\n    r1: number;\n    r2: number;\n    sweepFlag: boolean;\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegArcRel: {\n    prototype: SVGPathSegArcRel;\n    new(): SVGPathSegArcRel;\n};\n\ninterface SVGPathSegClosePath extends SVGPathSeg {\n}\n\ndeclare var SVGPathSegClosePath: {\n    prototype: SVGPathSegClosePath;\n    new(): SVGPathSegClosePath;\n};\n\ninterface SVGPathSegCurvetoCubicAbs extends SVGPathSeg {\n    x: number;\n    x1: number;\n    x2: number;\n    y: number;\n    y1: number;\n    y2: number;\n}\n\ndeclare var SVGPathSegCurvetoCubicAbs: {\n    prototype: SVGPathSegCurvetoCubicAbs;\n    new(): SVGPathSegCurvetoCubicAbs;\n};\n\ninterface SVGPathSegCurvetoCubicRel extends SVGPathSeg {\n    x: number;\n    x1: number;\n    x2: number;\n    y: number;\n    y1: number;\n    y2: number;\n}\n\ndeclare var SVGPathSegCurvetoCubicRel: {\n    prototype: SVGPathSegCurvetoCubicRel;\n    new(): SVGPathSegCurvetoCubicRel;\n};\n\ninterface SVGPathSegCurvetoCubicSmoothAbs extends SVGPathSeg {\n    x: number;\n    x2: number;\n    y: number;\n    y2: number;\n}\n\ndeclare var SVGPathSegCurvetoCubicSmoothAbs: {\n    prototype: SVGPathSegCurvetoCubicSmoothAbs;\n    new(): SVGPathSegCurvetoCubicSmoothAbs;\n};\n\ninterface SVGPathSegCurvetoCubicSmoothRel extends SVGPathSeg {\n    x: number;\n    x2: number;\n    y: number;\n    y2: number;\n}\n\ndeclare var SVGPathSegCurvetoCubicSmoothRel: {\n    prototype: SVGPathSegCurvetoCubicSmoothRel;\n    new(): SVGPathSegCurvetoCubicSmoothRel;\n};\n\ninterface SVGPathSegCurvetoQuadraticAbs extends SVGPathSeg {\n    x: number;\n    x1: number;\n    y: number;\n    y1: number;\n}\n\ndeclare var SVGPathSegCurvetoQuadraticAbs: {\n    prototype: SVGPathSegCurvetoQuadraticAbs;\n    new(): SVGPathSegCurvetoQuadraticAbs;\n};\n\ninterface SVGPathSegCurvetoQuadraticRel extends SVGPathSeg {\n    x: number;\n    x1: number;\n    y: number;\n    y1: number;\n}\n\ndeclare var SVGPathSegCurvetoQuadraticRel: {\n    prototype: SVGPathSegCurvetoQuadraticRel;\n    new(): SVGPathSegCurvetoQuadraticRel;\n};\n\ninterface SVGPathSegCurvetoQuadraticSmoothAbs extends SVGPathSeg {\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegCurvetoQuadraticSmoothAbs: {\n    prototype: SVGPathSegCurvetoQuadraticSmoothAbs;\n    new(): SVGPathSegCurvetoQuadraticSmoothAbs;\n};\n\ninterface SVGPathSegCurvetoQuadraticSmoothRel extends SVGPathSeg {\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegCurvetoQuadraticSmoothRel: {\n    prototype: SVGPathSegCurvetoQuadraticSmoothRel;\n    new(): SVGPathSegCurvetoQuadraticSmoothRel;\n};\n\ninterface SVGPathSegLinetoAbs extends SVGPathSeg {\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegLinetoAbs: {\n    prototype: SVGPathSegLinetoAbs;\n    new(): SVGPathSegLinetoAbs;\n};\n\ninterface SVGPathSegLinetoHorizontalAbs extends SVGPathSeg {\n    x: number;\n}\n\ndeclare var SVGPathSegLinetoHorizontalAbs: {\n    prototype: SVGPathSegLinetoHorizontalAbs;\n    new(): SVGPathSegLinetoHorizontalAbs;\n};\n\ninterface SVGPathSegLinetoHorizontalRel extends SVGPathSeg {\n    x: number;\n}\n\ndeclare var SVGPathSegLinetoHorizontalRel: {\n    prototype: SVGPathSegLinetoHorizontalRel;\n    new(): SVGPathSegLinetoHorizontalRel;\n};\n\ninterface SVGPathSegLinetoRel extends SVGPathSeg {\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegLinetoRel: {\n    prototype: SVGPathSegLinetoRel;\n    new(): SVGPathSegLinetoRel;\n};\n\ninterface SVGPathSegLinetoVerticalAbs extends SVGPathSeg {\n    y: number;\n}\n\ndeclare var SVGPathSegLinetoVerticalAbs: {\n    prototype: SVGPathSegLinetoVerticalAbs;\n    new(): SVGPathSegLinetoVerticalAbs;\n};\n\ninterface SVGPathSegLinetoVerticalRel extends SVGPathSeg {\n    y: number;\n}\n\ndeclare var SVGPathSegLinetoVerticalRel: {\n    prototype: SVGPathSegLinetoVerticalRel;\n    new(): SVGPathSegLinetoVerticalRel;\n};\n\ninterface SVGPathSegList {\n    readonly numberOfItems: number;\n    appendItem(newItem: SVGPathSeg): SVGPathSeg;\n    clear(): void;\n    getItem(index: number): SVGPathSeg;\n    initialize(newItem: SVGPathSeg): SVGPathSeg;\n    insertItemBefore(newItem: SVGPathSeg, index: number): SVGPathSeg;\n    removeItem(index: number): SVGPathSeg;\n    replaceItem(newItem: SVGPathSeg, index: number): SVGPathSeg;\n}\n\ndeclare var SVGPathSegList: {\n    prototype: SVGPathSegList;\n    new(): SVGPathSegList;\n};\n\ninterface SVGPathSegMovetoAbs extends SVGPathSeg {\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegMovetoAbs: {\n    prototype: SVGPathSegMovetoAbs;\n    new(): SVGPathSegMovetoAbs;\n};\n\ninterface SVGPathSegMovetoRel extends SVGPathSeg {\n    x: number;\n    y: number;\n}\n\ndeclare var SVGPathSegMovetoRel: {\n    prototype: SVGPathSegMovetoRel;\n    new(): SVGPathSegMovetoRel;\n};\n\n/** Corresponds to the <pattern> element. */\ninterface SVGPatternElement extends SVGElement, SVGFitToViewBox, SVGURIReference {\n    readonly height: SVGAnimatedLength;\n    readonly patternContentUnits: SVGAnimatedEnumeration;\n    readonly patternTransform: SVGAnimatedTransformList;\n    readonly patternUnits: SVGAnimatedEnumeration;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPatternElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPatternElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGPatternElement: {\n    prototype: SVGPatternElement;\n    new(): SVGPatternElement;\n};\n\ninterface SVGPointList {\n    readonly length: number;\n    readonly numberOfItems: number;\n    appendItem(newItem: DOMPoint): DOMPoint;\n    clear(): void;\n    getItem(index: number): DOMPoint;\n    initialize(newItem: DOMPoint): DOMPoint;\n    insertItemBefore(newItem: DOMPoint, index: number): DOMPoint;\n    removeItem(index: number): DOMPoint;\n    replaceItem(newItem: DOMPoint, index: number): DOMPoint;\n    [index: number]: DOMPoint;\n}\n\ndeclare var SVGPointList: {\n    prototype: SVGPointList;\n    new(): SVGPointList;\n};\n\n/** Provides access to the properties of <polygon> elements, as well as methods to manipulate them. */\ninterface SVGPolygonElement extends SVGGeometryElement, SVGAnimatedPoints {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPolygonElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPolygonElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGPolygonElement: {\n    prototype: SVGPolygonElement;\n    new(): SVGPolygonElement;\n};\n\n/** Provides access to the properties of <polyline> elements, as well as methods to manipulate them. */\ninterface SVGPolylineElement extends SVGGeometryElement, SVGAnimatedPoints {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPolylineElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGPolylineElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGPolylineElement: {\n    prototype: SVGPolylineElement;\n    new(): SVGPolylineElement;\n};\n\n/** Corresponds to the preserveAspectRatio attribute, which is available for some of SVG's elements. */\ninterface SVGPreserveAspectRatio {\n    align: number;\n    meetOrSlice: number;\n    readonly SVG_MEETORSLICE_MEET: number;\n    readonly SVG_MEETORSLICE_SLICE: number;\n    readonly SVG_MEETORSLICE_UNKNOWN: number;\n    readonly SVG_PRESERVEASPECTRATIO_NONE: number;\n    readonly SVG_PRESERVEASPECTRATIO_UNKNOWN: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMAX: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMID: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMIN: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMAX: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMID: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMIN: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMAX: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMID: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMIN: number;\n}\n\ndeclare var SVGPreserveAspectRatio: {\n    prototype: SVGPreserveAspectRatio;\n    new(): SVGPreserveAspectRatio;\n    readonly SVG_MEETORSLICE_MEET: number;\n    readonly SVG_MEETORSLICE_SLICE: number;\n    readonly SVG_MEETORSLICE_UNKNOWN: number;\n    readonly SVG_PRESERVEASPECTRATIO_NONE: number;\n    readonly SVG_PRESERVEASPECTRATIO_UNKNOWN: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMAX: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMID: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMAXYMIN: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMAX: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMID: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMIDYMIN: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMAX: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMID: number;\n    readonly SVG_PRESERVEASPECTRATIO_XMINYMIN: number;\n};\n\n/** Corresponds to the <RadialGradient> element. */\ninterface SVGRadialGradientElement extends SVGGradientElement {\n    readonly cx: SVGAnimatedLength;\n    readonly cy: SVGAnimatedLength;\n    readonly fr: SVGAnimatedLength;\n    readonly fx: SVGAnimatedLength;\n    readonly fy: SVGAnimatedLength;\n    readonly r: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGRadialGradientElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGRadialGradientElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGRadialGradientElement: {\n    prototype: SVGRadialGradientElement;\n    new(): SVGRadialGradientElement;\n};\n\n/** Provides access to the properties of <rect> elements, as well as methods to manipulate them. */\ninterface SVGRectElement extends SVGGeometryElement {\n    readonly height: SVGAnimatedLength;\n    readonly rx: SVGAnimatedLength;\n    readonly ry: SVGAnimatedLength;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGRectElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGRectElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGRectElement: {\n    prototype: SVGRectElement;\n    new(): SVGRectElement;\n};\n\ninterface SVGSVGElementEventMap extends SVGElementEventMap {\n    \"SVGUnload\": Event;\n    \"SVGZoom\": SVGZoomEvent;\n}\n\n/** Provides access to the properties of <svg> elements, as well as methods to manipulate them. This interface contains also various miscellaneous commonly-used utility methods, such as matrix operations and the ability to control the time of redraw on visual rendering devices. */\ninterface SVGSVGElement extends SVGGraphicsElement, DocumentEvent, SVGFitToViewBox, SVGZoomAndPan {\n    /** @deprecated */\n    contentScriptType: string;\n    /** @deprecated */\n    contentStyleType: string;\n    currentScale: number;\n    readonly currentTranslate: SVGPoint;\n    readonly height: SVGAnimatedLength;\n    onunload: ((this: SVGSVGElement, ev: Event) => any) | null;\n    onzoom: ((this: SVGSVGElement, ev: SVGZoomEvent) => any) | null;\n    /** @deprecated */\n    readonly pixelUnitToMillimeterX: number;\n    /** @deprecated */\n    readonly pixelUnitToMillimeterY: number;\n    /** @deprecated */\n    readonly screenPixelToMillimeterX: number;\n    /** @deprecated */\n    readonly screenPixelToMillimeterY: number;\n    /** @deprecated */\n    readonly viewport: SVGRect;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    animationsPaused(): boolean;\n    checkEnclosure(element: SVGElement, rect: SVGRect): boolean;\n    checkIntersection(element: SVGElement, rect: SVGRect): boolean;\n    createSVGAngle(): SVGAngle;\n    createSVGLength(): SVGLength;\n    createSVGMatrix(): SVGMatrix;\n    createSVGNumber(): SVGNumber;\n    createSVGPoint(): SVGPoint;\n    createSVGRect(): SVGRect;\n    createSVGTransform(): SVGTransform;\n    createSVGTransformFromMatrix(matrix: SVGMatrix): SVGTransform;\n    deselectAll(): void;\n    /** @deprecated */\n    forceRedraw(): void;\n    getComputedStyle(elt: Element, pseudoElt?: string | null): CSSStyleDeclaration;\n    getCurrentTime(): number;\n    getElementById(elementId: string): Element;\n    getEnclosureList(rect: SVGRect, referenceElement: SVGElement | null): NodeListOf<SVGCircleElement | SVGEllipseElement | SVGImageElement | SVGLineElement | SVGPathElement | SVGPolygonElement | SVGPolylineElement | SVGRectElement | SVGTextElement | SVGUseElement>;\n    getIntersectionList(rect: SVGRect, referenceElement: SVGElement | null): NodeListOf<SVGCircleElement | SVGEllipseElement | SVGImageElement | SVGLineElement | SVGPathElement | SVGPolygonElement | SVGPolylineElement | SVGRectElement | SVGTextElement | SVGUseElement>;\n    pauseAnimations(): void;\n    setCurrentTime(seconds: number): void;\n    /** @deprecated */\n    suspendRedraw(maxWaitMilliseconds: number): number;\n    unpauseAnimations(): void;\n    /** @deprecated */\n    unsuspendRedraw(suspendHandleID: number): void;\n    /** @deprecated */\n    unsuspendRedrawAll(): void;\n    addEventListener<K extends keyof SVGSVGElementEventMap>(type: K, listener: (this: SVGSVGElement, ev: SVGSVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGSVGElementEventMap>(type: K, listener: (this: SVGSVGElement, ev: SVGSVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGSVGElement: {\n    prototype: SVGSVGElement;\n    new(): SVGSVGElement;\n    readonly SVG_ZOOMANDPAN_DISABLE: number;\n    readonly SVG_ZOOMANDPAN_MAGNIFY: number;\n    readonly SVG_ZOOMANDPAN_UNKNOWN: number;\n};\n\n/** Corresponds to the SVG <script> element. */\ninterface SVGScriptElement extends SVGElement, SVGURIReference {\n    type: string;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGScriptElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGScriptElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGScriptElement: {\n    prototype: SVGScriptElement;\n    new(): SVGScriptElement;\n};\n\n/** Corresponds to the <stop> element. */\ninterface SVGStopElement extends SVGElement {\n    readonly offset: SVGAnimatedNumber;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGStopElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGStopElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGStopElement: {\n    prototype: SVGStopElement;\n    new(): SVGStopElement;\n};\n\n/** The SVGStringList defines a list of DOMString objects. */\ninterface SVGStringList {\n    readonly length: number;\n    readonly numberOfItems: number;\n    appendItem(newItem: string): string;\n    clear(): void;\n    getItem(index: number): string;\n    initialize(newItem: string): string;\n    insertItemBefore(newItem: string, index: number): string;\n    removeItem(index: number): string;\n    replaceItem(newItem: string, index: number): string;\n    [index: number]: string;\n}\n\ndeclare var SVGStringList: {\n    prototype: SVGStringList;\n    new(): SVGStringList;\n};\n\n/** Corresponds to the SVG <style> element. */\ninterface SVGStyleElement extends SVGElement {\n    disabled: boolean;\n    media: string;\n    title: string;\n    type: string;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGStyleElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGStyleElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGStyleElement: {\n    prototype: SVGStyleElement;\n    new(): SVGStyleElement;\n};\n\n/** Corresponds to the <switch> element. */\ninterface SVGSwitchElement extends SVGGraphicsElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGSwitchElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGSwitchElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGSwitchElement: {\n    prototype: SVGSwitchElement;\n    new(): SVGSwitchElement;\n};\n\n/** Corresponds to the <symbol> element. */\ninterface SVGSymbolElement extends SVGElement, SVGFitToViewBox {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGSymbolElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGSymbolElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGSymbolElement: {\n    prototype: SVGSymbolElement;\n    new(): SVGSymbolElement;\n};\n\n/** A <tspan> element. */\ninterface SVGTSpanElement extends SVGTextPositioningElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTSpanElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTSpanElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGTSpanElement: {\n    prototype: SVGTSpanElement;\n    new(): SVGTSpanElement;\n};\n\ninterface SVGTests {\n    readonly requiredExtensions: SVGStringList;\n    readonly systemLanguage: SVGStringList;\n}\n\n/** Implemented by elements that support rendering child text content. It is inherited by various text-related interfaces, such as SVGTextElement, SVGTSpanElement, SVGTRefElement, SVGAltGlyphElement and SVGTextPathElement. */\ninterface SVGTextContentElement extends SVGGraphicsElement {\n    readonly lengthAdjust: SVGAnimatedEnumeration;\n    readonly textLength: SVGAnimatedLength;\n    getCharNumAtPosition(point?: DOMPointInit): number;\n    getComputedTextLength(): number;\n    getEndPositionOfChar(charnum: number): DOMPoint;\n    getExtentOfChar(charnum: number): DOMRect;\n    getNumberOfChars(): number;\n    getRotationOfChar(charnum: number): number;\n    getStartPositionOfChar(charnum: number): DOMPoint;\n    getSubStringLength(charnum: number, nchars: number): number;\n    selectSubString(charnum: number, nchars: number): void;\n    readonly LENGTHADJUST_SPACING: number;\n    readonly LENGTHADJUST_SPACINGANDGLYPHS: number;\n    readonly LENGTHADJUST_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextContentElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextContentElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGTextContentElement: {\n    prototype: SVGTextContentElement;\n    new(): SVGTextContentElement;\n    readonly LENGTHADJUST_SPACING: number;\n    readonly LENGTHADJUST_SPACINGANDGLYPHS: number;\n    readonly LENGTHADJUST_UNKNOWN: number;\n};\n\n/** Corresponds to the <text> elements. */\ninterface SVGTextElement extends SVGTextPositioningElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGTextElement: {\n    prototype: SVGTextElement;\n    new(): SVGTextElement;\n};\n\n/** Corresponds to the <textPath> element. */\ninterface SVGTextPathElement extends SVGTextContentElement, SVGURIReference {\n    readonly method: SVGAnimatedEnumeration;\n    readonly spacing: SVGAnimatedEnumeration;\n    readonly startOffset: SVGAnimatedLength;\n    readonly TEXTPATH_METHODTYPE_ALIGN: number;\n    readonly TEXTPATH_METHODTYPE_STRETCH: number;\n    readonly TEXTPATH_METHODTYPE_UNKNOWN: number;\n    readonly TEXTPATH_SPACINGTYPE_AUTO: number;\n    readonly TEXTPATH_SPACINGTYPE_EXACT: number;\n    readonly TEXTPATH_SPACINGTYPE_UNKNOWN: number;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextPathElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextPathElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGTextPathElement: {\n    prototype: SVGTextPathElement;\n    new(): SVGTextPathElement;\n    readonly TEXTPATH_METHODTYPE_ALIGN: number;\n    readonly TEXTPATH_METHODTYPE_STRETCH: number;\n    readonly TEXTPATH_METHODTYPE_UNKNOWN: number;\n    readonly TEXTPATH_SPACINGTYPE_AUTO: number;\n    readonly TEXTPATH_SPACINGTYPE_EXACT: number;\n    readonly TEXTPATH_SPACINGTYPE_UNKNOWN: number;\n};\n\n/** Implemented by elements that support attributes that position individual text glyphs. It is inherited by SVGTextElement, SVGTSpanElement, SVGTRefElement and SVGAltGlyphElement. */\ninterface SVGTextPositioningElement extends SVGTextContentElement {\n    readonly dx: SVGAnimatedLengthList;\n    readonly dy: SVGAnimatedLengthList;\n    readonly rotate: SVGAnimatedNumberList;\n    readonly x: SVGAnimatedLengthList;\n    readonly y: SVGAnimatedLengthList;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextPositioningElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTextPositioningElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGTextPositioningElement: {\n    prototype: SVGTextPositioningElement;\n    new(): SVGTextPositioningElement;\n};\n\n/** Corresponds to the <title> element. */\ninterface SVGTitleElement extends SVGElement {\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTitleElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGTitleElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGTitleElement: {\n    prototype: SVGTitleElement;\n    new(): SVGTitleElement;\n};\n\n/** SVGTransform is the interface for one of the component transformations within an SVGTransformList; thus, an SVGTransform object corresponds to a single component (e.g., scale(…) or matrix(…)) within a transform attribute. */\ninterface SVGTransform {\n    readonly angle: number;\n    readonly matrix: SVGMatrix;\n    readonly type: number;\n    setMatrix(matrix: SVGMatrix): void;\n    setRotate(angle: number, cx: number, cy: number): void;\n    setScale(sx: number, sy: number): void;\n    setSkewX(angle: number): void;\n    setSkewY(angle: number): void;\n    setTranslate(tx: number, ty: number): void;\n    readonly SVG_TRANSFORM_MATRIX: number;\n    readonly SVG_TRANSFORM_ROTATE: number;\n    readonly SVG_TRANSFORM_SCALE: number;\n    readonly SVG_TRANSFORM_SKEWX: number;\n    readonly SVG_TRANSFORM_SKEWY: number;\n    readonly SVG_TRANSFORM_TRANSLATE: number;\n    readonly SVG_TRANSFORM_UNKNOWN: number;\n}\n\ndeclare var SVGTransform: {\n    prototype: SVGTransform;\n    new(): SVGTransform;\n    readonly SVG_TRANSFORM_MATRIX: number;\n    readonly SVG_TRANSFORM_ROTATE: number;\n    readonly SVG_TRANSFORM_SCALE: number;\n    readonly SVG_TRANSFORM_SKEWX: number;\n    readonly SVG_TRANSFORM_SKEWY: number;\n    readonly SVG_TRANSFORM_TRANSLATE: number;\n    readonly SVG_TRANSFORM_UNKNOWN: number;\n};\n\n/** The SVGTransformList defines a list of SVGTransform objects. */\ninterface SVGTransformList {\n    readonly numberOfItems: number;\n    appendItem(newItem: SVGTransform): SVGTransform;\n    clear(): void;\n    consolidate(): SVGTransform;\n    createSVGTransformFromMatrix(matrix: SVGMatrix): SVGTransform;\n    getItem(index: number): SVGTransform;\n    initialize(newItem: SVGTransform): SVGTransform;\n    insertItemBefore(newItem: SVGTransform, index: number): SVGTransform;\n    removeItem(index: number): SVGTransform;\n    replaceItem(newItem: SVGTransform, index: number): SVGTransform;\n}\n\ndeclare var SVGTransformList: {\n    prototype: SVGTransformList;\n    new(): SVGTransformList;\n};\n\ninterface SVGURIReference {\n    readonly href: SVGAnimatedString;\n}\n\n/** A commonly used set of constants used for reflecting gradientUnits, patternContentUnits and other similar attributes. */\ninterface SVGUnitTypes {\n    readonly SVG_UNIT_TYPE_OBJECTBOUNDINGBOX: number;\n    readonly SVG_UNIT_TYPE_UNKNOWN: number;\n    readonly SVG_UNIT_TYPE_USERSPACEONUSE: number;\n}\n\ndeclare var SVGUnitTypes: {\n    prototype: SVGUnitTypes;\n    new(): SVGUnitTypes;\n    readonly SVG_UNIT_TYPE_OBJECTBOUNDINGBOX: number;\n    readonly SVG_UNIT_TYPE_UNKNOWN: number;\n    readonly SVG_UNIT_TYPE_USERSPACEONUSE: number;\n};\n\n/** Corresponds to the <use> element. */\ninterface SVGUseElement extends SVGGraphicsElement, SVGURIReference {\n    readonly animatedInstanceRoot: SVGElementInstance | null;\n    readonly height: SVGAnimatedLength;\n    readonly instanceRoot: SVGElementInstance | null;\n    readonly width: SVGAnimatedLength;\n    readonly x: SVGAnimatedLength;\n    readonly y: SVGAnimatedLength;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGUseElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGUseElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGUseElement: {\n    prototype: SVGUseElement;\n    new(): SVGUseElement;\n};\n\n/** Provides access to the properties of <view> elements, as well as methods to manipulate them. */\ninterface SVGViewElement extends SVGElement, SVGFitToViewBox, SVGZoomAndPan {\n    /** @deprecated */\n    readonly viewTarget: SVGStringList;\n    addEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGViewElement, ev: SVGElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SVGElementEventMap>(type: K, listener: (this: SVGViewElement, ev: SVGElementEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SVGViewElement: {\n    prototype: SVGViewElement;\n    new(): SVGViewElement;\n    readonly SVG_ZOOMANDPAN_DISABLE: number;\n    readonly SVG_ZOOMANDPAN_MAGNIFY: number;\n    readonly SVG_ZOOMANDPAN_UNKNOWN: number;\n};\n\n/** Used to reflect the zoomAndPan attribute, and is mixed in to other interfaces for elements that support this attribute. */\ninterface SVGZoomAndPan {\n    readonly zoomAndPan: number;\n}\n\ndeclare var SVGZoomAndPan: {\n    readonly SVG_ZOOMANDPAN_DISABLE: number;\n    readonly SVG_ZOOMANDPAN_MAGNIFY: number;\n    readonly SVG_ZOOMANDPAN_UNKNOWN: number;\n};\n\ninterface SVGZoomEvent extends UIEvent {\n    readonly newScale: number;\n    readonly newTranslate: SVGPoint;\n    readonly previousScale: number;\n    readonly previousTranslate: SVGPoint;\n    readonly zoomRectScreen: SVGRect;\n}\n\ndeclare var SVGZoomEvent: {\n    prototype: SVGZoomEvent;\n    new(): SVGZoomEvent;\n};\n\ninterface ScopedCredential {\n    readonly id: ArrayBuffer;\n    readonly type: ScopedCredentialType;\n}\n\ndeclare var ScopedCredential: {\n    prototype: ScopedCredential;\n    new(): ScopedCredential;\n};\n\ninterface ScopedCredentialInfo {\n    readonly credential: ScopedCredential;\n    readonly publicKey: CryptoKey;\n}\n\ndeclare var ScopedCredentialInfo: {\n    prototype: ScopedCredentialInfo;\n    new(): ScopedCredentialInfo;\n};\n\n/** A screen, usually the one on which the current window is being rendered, and is obtained using window.screen. */\ninterface Screen {\n    readonly availHeight: number;\n    readonly availWidth: number;\n    readonly colorDepth: number;\n    readonly height: number;\n    readonly orientation: ScreenOrientation;\n    readonly pixelDepth: number;\n    readonly width: number;\n}\n\ndeclare var Screen: {\n    prototype: Screen;\n    new(): Screen;\n};\n\ninterface ScreenOrientationEventMap {\n    \"change\": Event;\n}\n\ninterface ScreenOrientation extends EventTarget {\n    readonly angle: number;\n    onchange: ((this: ScreenOrientation, ev: Event) => any) | null;\n    readonly type: OrientationType;\n    lock(orientation: OrientationLockType): Promise<void>;\n    unlock(): void;\n    addEventListener<K extends keyof ScreenOrientationEventMap>(type: K, listener: (this: ScreenOrientation, ev: ScreenOrientationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ScreenOrientationEventMap>(type: K, listener: (this: ScreenOrientation, ev: ScreenOrientationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var ScreenOrientation: {\n    prototype: ScreenOrientation;\n    new(): ScreenOrientation;\n};\n\ninterface ScriptProcessorNodeEventMap {\n    \"audioprocess\": AudioProcessingEvent;\n}\n\n/** Allows the generation, processing, or analyzing of audio using JavaScript. */\ninterface ScriptProcessorNode extends AudioNode {\n    /** @deprecated */\n    readonly bufferSize: number;\n    /** @deprecated */\n    onaudioprocess: ((this: ScriptProcessorNode, ev: AudioProcessingEvent) => any) | null;\n    addEventListener<K extends keyof ScriptProcessorNodeEventMap>(type: K, listener: (this: ScriptProcessorNode, ev: ScriptProcessorNodeEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ScriptProcessorNodeEventMap>(type: K, listener: (this: ScriptProcessorNode, ev: ScriptProcessorNodeEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var ScriptProcessorNode: {\n    prototype: ScriptProcessorNode;\n    new(): ScriptProcessorNode;\n};\n\n/** Inherits from Event, and represents the event object of an event sent on a document or worker when its content security policy is violated. */\ninterface SecurityPolicyViolationEvent extends Event {\n    readonly blockedURI: string;\n    readonly columnNumber: number;\n    readonly documentURI: string;\n    readonly effectiveDirective: string;\n    readonly lineNumber: number;\n    readonly originalPolicy: string;\n    readonly referrer: string;\n    readonly sourceFile: string;\n    readonly statusCode: number;\n    readonly violatedDirective: string;\n}\n\ndeclare var SecurityPolicyViolationEvent: {\n    prototype: SecurityPolicyViolationEvent;\n    new(type: string, eventInitDict?: SecurityPolicyViolationEventInit): SecurityPolicyViolationEvent;\n};\n\n/** A Selection object represents the range of text selected by the user or the current position of the caret. To obtain a Selection object for examination or modification, call Window.getSelection(). */\ninterface Selection {\n    readonly anchorNode: Node | null;\n    readonly anchorOffset: number;\n    readonly focusNode: Node | null;\n    readonly focusOffset: number;\n    readonly isCollapsed: boolean;\n    readonly rangeCount: number;\n    readonly type: string;\n    addRange(range: Range): void;\n    collapse(node: Node | null, offset?: number): void;\n    collapseToEnd(): void;\n    collapseToStart(): void;\n    containsNode(node: Node, allowPartialContainment?: boolean): boolean;\n    deleteFromDocument(): void;\n    empty(): void;\n    extend(node: Node, offset?: number): void;\n    getRangeAt(index: number): Range;\n    removeAllRanges(): void;\n    removeRange(range: Range): void;\n    selectAllChildren(node: Node): void;\n    setBaseAndExtent(anchorNode: Node, anchorOffset: number, focusNode: Node, focusOffset: number): void;\n    setPosition(node: Node | null, offset?: number): void;\n    toString(): string;\n}\n\ndeclare var Selection: {\n    prototype: Selection;\n    new(): Selection;\n    toString(): string;\n};\n\ninterface ServiceUIFrameContext {\n    getCachedFrameMessage(key: string): string;\n    postFrameMessage(key: string, data: string): void;\n}\ndeclare var ServiceUIFrameContext: ServiceUIFrameContext;\n\ninterface ServiceWorkerEventMap extends AbstractWorkerEventMap {\n    \"statechange\": Event;\n}\n\n/** This ServiceWorker API interface provides a reference to a service worker. Multiple browsing contexts (e.g. pages, workers, etc.) can be associated with the same service worker, each through a unique ServiceWorker object. */\ninterface ServiceWorker extends EventTarget, AbstractWorker {\n    onstatechange: ((this: ServiceWorker, ev: Event) => any) | null;\n    readonly scriptURL: string;\n    readonly state: ServiceWorkerState;\n    postMessage(message: any, transfer: Transferable[]): void;\n    postMessage(message: any, options?: PostMessageOptions): void;\n    addEventListener<K extends keyof ServiceWorkerEventMap>(type: K, listener: (this: ServiceWorker, ev: ServiceWorkerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ServiceWorkerEventMap>(type: K, listener: (this: ServiceWorker, ev: ServiceWorkerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var ServiceWorker: {\n    prototype: ServiceWorker;\n    new(): ServiceWorker;\n};\n\ninterface ServiceWorkerContainerEventMap {\n    \"controllerchange\": Event;\n    \"message\": MessageEvent;\n    \"messageerror\": MessageEvent;\n}\n\n/** The ServiceWorkerContainer interface of the ServiceWorker API provides an object representing the service worker as an overall unit in the network ecosystem, including facilities to register, unregister and update service workers, and access the state of service workers and their registrations. */\ninterface ServiceWorkerContainer extends EventTarget {\n    readonly controller: ServiceWorker | null;\n    oncontrollerchange: ((this: ServiceWorkerContainer, ev: Event) => any) | null;\n    onmessage: ((this: ServiceWorkerContainer, ev: MessageEvent) => any) | null;\n    onmessageerror: ((this: ServiceWorkerContainer, ev: MessageEvent) => any) | null;\n    readonly ready: Promise<ServiceWorkerRegistration>;\n    getRegistration(clientURL?: string): Promise<ServiceWorkerRegistration | undefined>;\n    getRegistrations(): Promise<ReadonlyArray<ServiceWorkerRegistration>>;\n    register(scriptURL: string, options?: RegistrationOptions): Promise<ServiceWorkerRegistration>;\n    startMessages(): void;\n    addEventListener<K extends keyof ServiceWorkerContainerEventMap>(type: K, listener: (this: ServiceWorkerContainer, ev: ServiceWorkerContainerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ServiceWorkerContainerEventMap>(type: K, listener: (this: ServiceWorkerContainer, ev: ServiceWorkerContainerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var ServiceWorkerContainer: {\n    prototype: ServiceWorkerContainer;\n    new(): ServiceWorkerContainer;\n};\n\n/** This ServiceWorker API interface contains information about an event sent to a ServiceWorkerContainer target. This extends the default message event to allow setting a ServiceWorker object as the source of a message. The event object is accessed via the handler function of a message event, when fired by a message received from a service worker. */\ninterface ServiceWorkerMessageEvent extends Event {\n    readonly data: any;\n    readonly lastEventId: string;\n    readonly origin: string;\n    readonly ports: ReadonlyArray<MessagePort> | null;\n    readonly source: ServiceWorker | MessagePort | null;\n}\n\ndeclare var ServiceWorkerMessageEvent: {\n    prototype: ServiceWorkerMessageEvent;\n    new(type: string, eventInitDict?: ServiceWorkerMessageEventInit): ServiceWorkerMessageEvent;\n};\n\ninterface ServiceWorkerRegistrationEventMap {\n    \"updatefound\": Event;\n}\n\n/** This ServiceWorker API interface represents the service worker registration. You register a service worker to control one or more pages that share the same origin. */\ninterface ServiceWorkerRegistration extends EventTarget {\n    readonly active: ServiceWorker | null;\n    readonly installing: ServiceWorker | null;\n    readonly navigationPreload: NavigationPreloadManager;\n    onupdatefound: ((this: ServiceWorkerRegistration, ev: Event) => any) | null;\n    readonly pushManager: PushManager;\n    readonly scope: string;\n    readonly sync: SyncManager;\n    readonly updateViaCache: ServiceWorkerUpdateViaCache;\n    readonly waiting: ServiceWorker | null;\n    getNotifications(filter?: GetNotificationOptions): Promise<Notification[]>;\n    showNotification(title: string, options?: NotificationOptions): Promise<void>;\n    unregister(): Promise<boolean>;\n    update(): Promise<void>;\n    addEventListener<K extends keyof ServiceWorkerRegistrationEventMap>(type: K, listener: (this: ServiceWorkerRegistration, ev: ServiceWorkerRegistrationEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof ServiceWorkerRegistrationEventMap>(type: K, listener: (this: ServiceWorkerRegistration, ev: ServiceWorkerRegistrationEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var ServiceWorkerRegistration: {\n    prototype: ServiceWorkerRegistration;\n    new(): ServiceWorkerRegistration;\n};\n\ninterface ShadowRoot extends DocumentFragment, DocumentOrShadowRoot, InnerHTML {\n    readonly host: Element;\n    readonly mode: ShadowRootMode;\n    /**\n     * Throws a \"NotSupportedError\" DOMException if context object is a shadow root.\n     */\n}\n\ndeclare var ShadowRoot: {\n    prototype: ShadowRoot;\n    new(): ShadowRoot;\n};\n\ninterface SharedWorker extends EventTarget, AbstractWorker {\n    /**\n     * Returns sharedWorker's MessagePort object which can be used to communicate with the global environment.\n     */\n    readonly port: MessagePort;\n    addEventListener<K extends keyof AbstractWorkerEventMap>(type: K, listener: (this: SharedWorker, ev: AbstractWorkerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof AbstractWorkerEventMap>(type: K, listener: (this: SharedWorker, ev: AbstractWorkerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SharedWorker: {\n    prototype: SharedWorker;\n    new(scriptURL: string, options?: string | WorkerOptions): SharedWorker;\n};\n\ninterface Slottable {\n    readonly assignedSlot: HTMLSlotElement | null;\n}\n\ninterface SourceBufferEventMap {\n    \"abort\": Event;\n    \"error\": Event;\n    \"update\": Event;\n    \"updateend\": Event;\n    \"updatestart\": Event;\n}\n\n/** A chunk of media to be passed into an HTMLMediaElement and played, via a MediaSource object. This can be made up of one or several media segments. */\ninterface SourceBuffer extends EventTarget {\n    appendWindowEnd: number;\n    appendWindowStart: number;\n    readonly buffered: TimeRanges;\n    mode: AppendMode;\n    onabort: ((this: SourceBuffer, ev: Event) => any) | null;\n    onerror: ((this: SourceBuffer, ev: Event) => any) | null;\n    onupdate: ((this: SourceBuffer, ev: Event) => any) | null;\n    onupdateend: ((this: SourceBuffer, ev: Event) => any) | null;\n    onupdatestart: ((this: SourceBuffer, ev: Event) => any) | null;\n    timestampOffset: number;\n    readonly updating: boolean;\n    abort(): void;\n    appendBuffer(data: BufferSource): void;\n    remove(start: number, end: number): void;\n    addEventListener<K extends keyof SourceBufferEventMap>(type: K, listener: (this: SourceBuffer, ev: SourceBufferEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SourceBufferEventMap>(type: K, listener: (this: SourceBuffer, ev: SourceBufferEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SourceBuffer: {\n    prototype: SourceBuffer;\n    new(): SourceBuffer;\n};\n\ninterface SourceBufferListEventMap {\n    \"addsourcebuffer\": Event;\n    \"removesourcebuffer\": Event;\n}\n\n/** A simple container list for multiple SourceBuffer objects. */\ninterface SourceBufferList extends EventTarget {\n    readonly length: number;\n    onaddsourcebuffer: ((this: SourceBufferList, ev: Event) => any) | null;\n    onremovesourcebuffer: ((this: SourceBufferList, ev: Event) => any) | null;\n    addEventListener<K extends keyof SourceBufferListEventMap>(type: K, listener: (this: SourceBufferList, ev: SourceBufferListEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SourceBufferListEventMap>(type: K, listener: (this: SourceBufferList, ev: SourceBufferListEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n    [index: number]: SourceBuffer;\n}\n\ndeclare var SourceBufferList: {\n    prototype: SourceBufferList;\n    new(): SourceBufferList;\n};\n\ninterface SpeechGrammar {\n    src: string;\n    weight: number;\n}\n\ndeclare var SpeechGrammar: {\n    prototype: SpeechGrammar;\n    new(): SpeechGrammar;\n};\n\ninterface SpeechGrammarList {\n    readonly length: number;\n    addFromString(string: string, weight?: number): void;\n    addFromURI(src: string, weight?: number): void;\n    item(index: number): SpeechGrammar;\n    [index: number]: SpeechGrammar;\n}\n\ndeclare var SpeechGrammarList: {\n    prototype: SpeechGrammarList;\n    new(): SpeechGrammarList;\n};\n\ninterface SpeechRecognitionEventMap {\n    \"audioend\": Event;\n    \"audiostart\": Event;\n    \"end\": Event;\n    \"error\": ErrorEvent;\n    \"nomatch\": SpeechRecognitionEvent;\n    \"result\": SpeechRecognitionEvent;\n    \"soundend\": Event;\n    \"soundstart\": Event;\n    \"speechend\": Event;\n    \"speechstart\": Event;\n    \"start\": Event;\n}\n\ninterface SpeechRecognition extends EventTarget {\n    continuous: boolean;\n    grammars: SpeechGrammarList;\n    interimResults: boolean;\n    lang: string;\n    maxAlternatives: number;\n    onaudioend: ((this: SpeechRecognition, ev: Event) => any) | null;\n    onaudiostart: ((this: SpeechRecognition, ev: Event) => any) | null;\n    onend: ((this: SpeechRecognition, ev: Event) => any) | null;\n    onerror: ((this: SpeechRecognition, ev: ErrorEvent) => any) | null;\n    onnomatch: ((this: SpeechRecognition, ev: SpeechRecognitionEvent) => any) | null;\n    onresult: ((this: SpeechRecognition, ev: SpeechRecognitionEvent) => any) | null;\n    onsoundend: ((this: SpeechRecognition, ev: Event) => any) | null;\n    onsoundstart: ((this: SpeechRecognition, ev: Event) => any) | null;\n    onspeechend: ((this: SpeechRecognition, ev: Event) => any) | null;\n    onspeechstart: ((this: SpeechRecognition, ev: Event) => any) | null;\n    onstart: ((this: SpeechRecognition, ev: Event) => any) | null;\n    abort(): void;\n    start(): void;\n    stop(): void;\n    addEventListener<K extends keyof SpeechRecognitionEventMap>(type: K, listener: (this: SpeechRecognition, ev: SpeechRecognitionEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SpeechRecognitionEventMap>(type: K, listener: (this: SpeechRecognition, ev: SpeechRecognitionEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SpeechRecognition: {\n    prototype: SpeechRecognition;\n    new(): SpeechRecognition;\n};\n\ninterface SpeechRecognitionAlternative {\n    readonly confidence: number;\n    readonly transcript: string;\n}\n\ndeclare var SpeechRecognitionAlternative: {\n    prototype: SpeechRecognitionAlternative;\n    new(): SpeechRecognitionAlternative;\n};\n\ninterface SpeechRecognitionEvent extends Event {\n    readonly resultIndex: number;\n    readonly results: SpeechRecognitionResultList;\n}\n\ndeclare var SpeechRecognitionEvent: {\n    prototype: SpeechRecognitionEvent;\n    new(): SpeechRecognitionEvent;\n};\n\ninterface SpeechRecognitionResult {\n    readonly isFinal: boolean;\n    readonly length: number;\n    item(index: number): SpeechRecognitionAlternative;\n    [index: number]: SpeechRecognitionAlternative;\n}\n\ndeclare var SpeechRecognitionResult: {\n    prototype: SpeechRecognitionResult;\n    new(): SpeechRecognitionResult;\n};\n\ninterface SpeechRecognitionResultList {\n    readonly length: number;\n    item(index: number): SpeechRecognitionResult;\n    [index: number]: SpeechRecognitionResult;\n}\n\ndeclare var SpeechRecognitionResultList: {\n    prototype: SpeechRecognitionResultList;\n    new(): SpeechRecognitionResultList;\n};\n\ninterface SpeechSynthesisEventMap {\n    \"voiceschanged\": Event;\n}\n\n/** This Web Speech API interface is the controller interface for the speech service; this can be used to retrieve information about the synthesis voices available on the device, start and pause speech, and other commands besides. */\ninterface SpeechSynthesis extends EventTarget {\n    onvoiceschanged: ((this: SpeechSynthesis, ev: Event) => any) | null;\n    readonly paused: boolean;\n    readonly pending: boolean;\n    readonly speaking: boolean;\n    cancel(): void;\n    getVoices(): SpeechSynthesisVoice[];\n    pause(): void;\n    resume(): void;\n    speak(utterance: SpeechSynthesisUtterance): void;\n    addEventListener<K extends keyof SpeechSynthesisEventMap>(type: K, listener: (this: SpeechSynthesis, ev: SpeechSynthesisEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SpeechSynthesisEventMap>(type: K, listener: (this: SpeechSynthesis, ev: SpeechSynthesisEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SpeechSynthesis: {\n    prototype: SpeechSynthesis;\n    new(): SpeechSynthesis;\n};\n\ninterface SpeechSynthesisErrorEvent extends SpeechSynthesisEvent {\n    readonly error: SpeechSynthesisErrorCode;\n}\n\ndeclare var SpeechSynthesisErrorEvent: {\n    prototype: SpeechSynthesisErrorEvent;\n    new(type: string, eventInitDict: SpeechSynthesisErrorEventInit): SpeechSynthesisErrorEvent;\n};\n\n/** This Web Speech API interface contains information about the current state of SpeechSynthesisUtterance objects that have been processed in the speech service. */\ninterface SpeechSynthesisEvent extends Event {\n    readonly charIndex: number;\n    readonly charLength: number;\n    readonly elapsedTime: number;\n    readonly name: string;\n    readonly utterance: SpeechSynthesisUtterance;\n}\n\ndeclare var SpeechSynthesisEvent: {\n    prototype: SpeechSynthesisEvent;\n    new(type: string, eventInitDict: SpeechSynthesisEventInit): SpeechSynthesisEvent;\n};\n\ninterface SpeechSynthesisUtteranceEventMap {\n    \"boundary\": SpeechSynthesisEvent;\n    \"end\": SpeechSynthesisEvent;\n    \"error\": SpeechSynthesisErrorEvent;\n    \"mark\": SpeechSynthesisEvent;\n    \"pause\": SpeechSynthesisEvent;\n    \"resume\": SpeechSynthesisEvent;\n    \"start\": SpeechSynthesisEvent;\n}\n\n/** This Web Speech API interface represents a speech request. It contains the content the speech service should read and information about how to read it (e.g. language, pitch and volume.) */\ninterface SpeechSynthesisUtterance extends EventTarget {\n    lang: string;\n    onboundary: ((this: SpeechSynthesisUtterance, ev: SpeechSynthesisEvent) => any) | null;\n    onend: ((this: SpeechSynthesisUtterance, ev: SpeechSynthesisEvent) => any) | null;\n    onerror: ((this: SpeechSynthesisUtterance, ev: SpeechSynthesisErrorEvent) => any) | null;\n    onmark: ((this: SpeechSynthesisUtterance, ev: SpeechSynthesisEvent) => any) | null;\n    onpause: ((this: SpeechSynthesisUtterance, ev: SpeechSynthesisEvent) => any) | null;\n    onresume: ((this: SpeechSynthesisUtterance, ev: SpeechSynthesisEvent) => any) | null;\n    onstart: ((this: SpeechSynthesisUtterance, ev: SpeechSynthesisEvent) => any) | null;\n    pitch: number;\n    rate: number;\n    text: string;\n    voice: SpeechSynthesisVoice | null;\n    volume: number;\n    addEventListener<K extends keyof SpeechSynthesisUtteranceEventMap>(type: K, listener: (this: SpeechSynthesisUtterance, ev: SpeechSynthesisUtteranceEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof SpeechSynthesisUtteranceEventMap>(type: K, listener: (this: SpeechSynthesisUtterance, ev: SpeechSynthesisUtteranceEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var SpeechSynthesisUtterance: {\n    prototype: SpeechSynthesisUtterance;\n    new(text?: string): SpeechSynthesisUtterance;\n};\n\n/** This Web Speech API interface represents a voice that the system supports. Every SpeechSynthesisVoice has its own relative speech service including information about language, name and URI. */\ninterface SpeechSynthesisVoice {\n    readonly default: boolean;\n    readonly lang: string;\n    readonly localService: boolean;\n    readonly name: string;\n    readonly voiceURI: string;\n}\n\ndeclare var SpeechSynthesisVoice: {\n    prototype: SpeechSynthesisVoice;\n    new(): SpeechSynthesisVoice;\n};\n\ninterface StaticRange extends AbstractRange {\n}\n\ndeclare var StaticRange: {\n    prototype: StaticRange;\n    new(init: StaticRangeInit): StaticRange;\n};\n\n/** The pan property takes a unitless value between -1 (full left pan) and 1 (full right pan). This interface was introduced as a much simpler way to apply a simple panning effect than having to use a full PannerNode. */\ninterface StereoPannerNode extends AudioNode {\n    readonly pan: AudioParam;\n}\n\ndeclare var StereoPannerNode: {\n    prototype: StereoPannerNode;\n    new(context: BaseAudioContext, options?: StereoPannerOptions): StereoPannerNode;\n};\n\n/** This Web Storage API interface provides access to a particular domain's session or local storage. It allows, for example, the addition, modification, or deletion of stored data items. */\ninterface Storage {\n    /**\n     * Returns the number of key/value pairs currently present in the list associated with the object.\n     */\n    readonly length: number;\n    /**\n     * Empties the list associated with the object of all key/value pairs, if there are any.\n     */\n    clear(): void;\n    /**\n     * Returns the current value associated with the given key, or null if the given key does not exist in the list associated with the object.\n     */\n    getItem(key: string): string | null;\n    /**\n     * Returns the name of the nth key in the list, or null if n is greater than or equal to the number of key/value pairs in the object.\n     */\n    key(index: number): string | null;\n    /**\n     * Removes the key/value pair with the given key from the list associated with the object, if a key/value pair with the given key exists.\n     */\n    removeItem(key: string): void;\n    /**\n     * Sets the value of the pair identified by key to value, creating a new key/value pair if none existed for key previously.\n     * \n     * Throws a \"QuotaExceededError\" DOMException exception if the new value couldn't be set. (Setting could fail if, e.g., the user has disabled storage for the site, or if the quota has been exceeded.)\n     */\n    setItem(key: string, value: string): void;\n    [name: string]: any;\n}\n\ndeclare var Storage: {\n    prototype: Storage;\n    new(): Storage;\n};\n\n/** A StorageEvent is sent to a window when a storage area it has access to is changed within the context of another document. */\ninterface StorageEvent extends Event {\n    /**\n     * Returns the key of the storage item being changed.\n     */\n    readonly key: string | null;\n    /**\n     * Returns the new value of the key of the storage item whose value is being changed.\n     */\n    readonly newValue: string | null;\n    /**\n     * Returns the old value of the key of the storage item whose value is being changed.\n     */\n    readonly oldValue: string | null;\n    /**\n     * Returns the Storage object that was affected.\n     */\n    readonly storageArea: Storage | null;\n    /**\n     * Returns the URL of the document whose storage item changed.\n     */\n    readonly url: string;\n}\n\ndeclare var StorageEvent: {\n    prototype: StorageEvent;\n    new(type: string, eventInitDict?: StorageEventInit): StorageEvent;\n};\n\ninterface StorageManager {\n    estimate(): Promise<StorageEstimate>;\n    persist(): Promise<boolean>;\n    persisted(): Promise<boolean>;\n}\n\ndeclare var StorageManager: {\n    prototype: StorageManager;\n    new(): StorageManager;\n};\n\ninterface StyleMedia {\n    readonly type: string;\n    matchMedium(mediaquery: string): boolean;\n}\n\ndeclare var StyleMedia: {\n    prototype: StyleMedia;\n    new(): StyleMedia;\n};\n\n/** A single style sheet. CSS style sheets will further implement the more specialized CSSStyleSheet interface. */\ninterface StyleSheet {\n    disabled: boolean;\n    readonly href: string | null;\n    readonly media: MediaList;\n    readonly ownerNode: Element | ProcessingInstruction | null;\n    readonly parentStyleSheet: CSSStyleSheet | null;\n    readonly title: string | null;\n    readonly type: string;\n}\n\ndeclare var StyleSheet: {\n    prototype: StyleSheet;\n    new(): StyleSheet;\n};\n\n/** A list of StyleSheet. */\ninterface StyleSheetList {\n    readonly length: number;\n    item(index: number): CSSStyleSheet | null;\n    [index: number]: CSSStyleSheet;\n}\n\ndeclare var StyleSheetList: {\n    prototype: StyleSheetList;\n    new(): StyleSheetList;\n};\n\n/** This Web Crypto API interface provides a number of low-level cryptographic functions. It is accessed via the Crypto.subtle properties available in a window context (via Window.crypto). */\ninterface SubtleCrypto {\n    decrypt(algorithm: AlgorithmIdentifier | RsaOaepParams | AesCtrParams | AesCbcParams | AesCmacParams | AesGcmParams | AesCfbParams, key: CryptoKey, data: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer): Promise<ArrayBuffer>;\n    deriveBits(algorithm: AlgorithmIdentifier | EcdhKeyDeriveParams | DhKeyDeriveParams | ConcatParams | HkdfParams | Pbkdf2Params, baseKey: CryptoKey, length: number): Promise<ArrayBuffer>;\n    deriveKey(algorithm: AlgorithmIdentifier | EcdhKeyDeriveParams | DhKeyDeriveParams | ConcatParams | HkdfParams | Pbkdf2Params, baseKey: CryptoKey, derivedKeyType: string | AesDerivedKeyParams | HmacImportParams | ConcatParams | HkdfParams | Pbkdf2Params, extractable: boolean, keyUsages: KeyUsage[]): Promise<CryptoKey>;\n    digest(algorithm: AlgorithmIdentifier, data: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer): Promise<ArrayBuffer>;\n    encrypt(algorithm: AlgorithmIdentifier | RsaOaepParams | AesCtrParams | AesCbcParams | AesCmacParams | AesGcmParams | AesCfbParams, key: CryptoKey, data: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer): Promise<ArrayBuffer>;\n    exportKey(format: \"jwk\", key: CryptoKey): Promise<JsonWebKey>;\n    exportKey(format: \"raw\" | \"pkcs8\" | \"spki\", key: CryptoKey): Promise<ArrayBuffer>;\n    exportKey(format: string, key: CryptoKey): Promise<JsonWebKey | ArrayBuffer>;\n    generateKey(algorithm: RsaHashedKeyGenParams | EcKeyGenParams | DhKeyGenParams, extractable: boolean, keyUsages: KeyUsage[]): Promise<CryptoKeyPair>;\n    generateKey(algorithm: AesKeyGenParams | HmacKeyGenParams | Pbkdf2Params, extractable: boolean, keyUsages: KeyUsage[]): Promise<CryptoKey>;\n    generateKey(algorithm: AlgorithmIdentifier, extractable: boolean, keyUsages: KeyUsage[]): Promise<CryptoKeyPair | CryptoKey>;\n    importKey(format: \"jwk\", keyData: JsonWebKey, algorithm: AlgorithmIdentifier | RsaHashedImportParams | EcKeyImportParams | HmacImportParams | DhImportKeyParams | AesKeyAlgorithm, extractable: boolean, keyUsages: KeyUsage[]): Promise<CryptoKey>;\n    importKey(format: \"raw\" | \"pkcs8\" | \"spki\", keyData: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer, algorithm: AlgorithmIdentifier | RsaHashedImportParams | EcKeyImportParams | HmacImportParams | DhImportKeyParams | AesKeyAlgorithm, extractable: boolean, keyUsages: KeyUsage[]): Promise<CryptoKey>;\n    importKey(format: string, keyData: JsonWebKey | Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer, algorithm: AlgorithmIdentifier | RsaHashedImportParams | EcKeyImportParams | HmacImportParams | DhImportKeyParams | AesKeyAlgorithm, extractable: boolean, keyUsages: KeyUsage[]): Promise<CryptoKey>;\n    sign(algorithm: AlgorithmIdentifier | RsaPssParams | EcdsaParams | AesCmacParams, key: CryptoKey, data: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer): Promise<ArrayBuffer>;\n    unwrapKey(format: \"raw\" | \"pkcs8\" | \"spki\" | \"jwk\" | string, wrappedKey: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer, unwrappingKey: CryptoKey, unwrapAlgorithm: AlgorithmIdentifier | RsaOaepParams | AesCtrParams | AesCbcParams | AesCmacParams | AesGcmParams | AesCfbParams, unwrappedKeyAlgorithm: AlgorithmIdentifier | RsaHashedImportParams | EcKeyImportParams | HmacImportParams | DhImportKeyParams | AesKeyAlgorithm, extractable: boolean, keyUsages: KeyUsage[]): Promise<CryptoKey>;\n    verify(algorithm: AlgorithmIdentifier | RsaPssParams | EcdsaParams | AesCmacParams, key: CryptoKey, signature: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer, data: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer): Promise<boolean>;\n    wrapKey(format: \"raw\" | \"pkcs8\" | \"spki\" | \"jwk\" | string, key: CryptoKey, wrappingKey: CryptoKey, wrapAlgorithm: AlgorithmIdentifier | RsaOaepParams | AesCtrParams | AesCbcParams | AesCmacParams | AesGcmParams | AesCfbParams): Promise<ArrayBuffer>;\n}\n\ndeclare var SubtleCrypto: {\n    prototype: SubtleCrypto;\n    new(): SubtleCrypto;\n};\n\n/** This ServiceWorker API interface provides an interface for registering and listing sync registrations. */\ninterface SyncManager {\n    getTags(): Promise<string[]>;\n    register(tag: string): Promise<void>;\n}\n\ndeclare var SyncManager: {\n    prototype: SyncManager;\n    new(): SyncManager;\n};\n\n/** The textual content of Element or Attr. If an element has no markup within its content, it has a single child implementing Text that contains the element's text. However, if the element contains markup, it is parsed into information items and Text nodes that form its children. */\ninterface Text extends CharacterData, Slottable {\n    readonly assignedSlot: HTMLSlotElement | null;\n    /**\n     * Returns the combined data of all direct Text node siblings.\n     */\n    readonly wholeText: string;\n    /**\n     * Splits data at the given offset and returns the remainder as Text node.\n     */\n    splitText(offset: number): Text;\n}\n\ndeclare var Text: {\n    prototype: Text;\n    new(data?: string): Text;\n};\n\n/** A decoder for a specific method, that is a specific character encoding, like utf-8, iso-8859-2, koi8, cp1261, gbk, etc. A decoder takes a stream of bytes as input and emits a stream of code points. For a more scalable, non-native library, see StringView – a C-like representation of strings based on typed arrays. */\ninterface TextDecoder extends TextDecoderCommon {\n    /**\n     * Returns the result of running encoding's decoder. The method can be invoked zero or more times with options's stream set to true, and then once without options's stream (or set to false), to process a fragmented stream. If the invocation without options's stream (or set to false) has no input, it's clearest to omit both arguments.\n     * \n     * ```\n     * var string = \"\", decoder = new TextDecoder(encoding), buffer;\n     * while(buffer = next_chunk()) {\n     *   string += decoder.decode(buffer, {stream:true});\n     * }\n     * string += decoder.decode(); // end-of-stream\n     * ```\n     * \n     * If the error mode is \"fatal\" and encoding's decoder returns error, throws a TypeError.\n     */\n    decode(input?: BufferSource, options?: TextDecodeOptions): string;\n}\n\ndeclare var TextDecoder: {\n    prototype: TextDecoder;\n    new(label?: string, options?: TextDecoderOptions): TextDecoder;\n};\n\ninterface TextDecoderCommon {\n    /**\n     * Returns encoding's name, lowercased.\n     */\n    readonly encoding: string;\n    /**\n     * Returns true if error mode is \"fatal\", and false otherwise.\n     */\n    readonly fatal: boolean;\n    /**\n     * Returns true if ignore BOM flag is set, and false otherwise.\n     */\n    readonly ignoreBOM: boolean;\n}\n\ninterface TextDecoderStream extends GenericTransformStream, TextDecoderCommon {\n    readonly readable: ReadableStream<string>;\n    readonly writable: WritableStream<BufferSource>;\n}\n\ndeclare var TextDecoderStream: {\n    prototype: TextDecoderStream;\n    new(label?: string, options?: TextDecoderOptions): TextDecoderStream;\n};\n\n/** TextEncoder takes a stream of code points as input and emits a stream of bytes. For a more scalable, non-native library, see StringView – a C-like representation of strings based on typed arrays. */\ninterface TextEncoder extends TextEncoderCommon {\n    /**\n     * Returns the result of running UTF-8's encoder.\n     */\n    encode(input?: string): Uint8Array;\n    /**\n     * Runs the UTF-8 encoder on source, stores the result of that operation into destination, and returns the progress made as a dictionary whereby read is the number of converted code units of source and written is the number of bytes modified in destination.\n     */\n    encodeInto(source: string, destination: Uint8Array): TextEncoderEncodeIntoResult;\n}\n\ndeclare var TextEncoder: {\n    prototype: TextEncoder;\n    new(): TextEncoder;\n};\n\ninterface TextEncoderCommon {\n    /**\n     * Returns \"utf-8\".\n     */\n    readonly encoding: string;\n}\n\ninterface TextEncoderStream extends GenericTransformStream, TextEncoderCommon {\n    readonly readable: ReadableStream<Uint8Array>;\n    readonly writable: WritableStream<string>;\n}\n\ndeclare var TextEncoderStream: {\n    prototype: TextEncoderStream;\n    new(): TextEncoderStream;\n};\n\ninterface TextEvent extends UIEvent {\n    readonly data: string;\n    initTextEvent(typeArg: string, canBubbleArg: boolean, cancelableArg: boolean, viewArg: Window, dataArg: string, inputMethod: number, locale: string): void;\n    readonly DOM_INPUT_METHOD_DROP: number;\n    readonly DOM_INPUT_METHOD_HANDWRITING: number;\n    readonly DOM_INPUT_METHOD_IME: number;\n    readonly DOM_INPUT_METHOD_KEYBOARD: number;\n    readonly DOM_INPUT_METHOD_MULTIMODAL: number;\n    readonly DOM_INPUT_METHOD_OPTION: number;\n    readonly DOM_INPUT_METHOD_PASTE: number;\n    readonly DOM_INPUT_METHOD_SCRIPT: number;\n    readonly DOM_INPUT_METHOD_UNKNOWN: number;\n    readonly DOM_INPUT_METHOD_VOICE: number;\n}\n\ndeclare var TextEvent: {\n    prototype: TextEvent;\n    new(): TextEvent;\n    readonly DOM_INPUT_METHOD_DROP: number;\n    readonly DOM_INPUT_METHOD_HANDWRITING: number;\n    readonly DOM_INPUT_METHOD_IME: number;\n    readonly DOM_INPUT_METHOD_KEYBOARD: number;\n    readonly DOM_INPUT_METHOD_MULTIMODAL: number;\n    readonly DOM_INPUT_METHOD_OPTION: number;\n    readonly DOM_INPUT_METHOD_PASTE: number;\n    readonly DOM_INPUT_METHOD_SCRIPT: number;\n    readonly DOM_INPUT_METHOD_UNKNOWN: number;\n    readonly DOM_INPUT_METHOD_VOICE: number;\n};\n\n/** The dimensions of a piece of text in the canvas, as created by the CanvasRenderingContext2D.measureText() method. */\ninterface TextMetrics {\n    /**\n     * Returns the measurement described below.\n     */\n    readonly actualBoundingBoxAscent: number;\n    /**\n     * Returns the measurement described below.\n     */\n    readonly actualBoundingBoxDescent: number;\n    /**\n     * Returns the measurement described below.\n     */\n    readonly actualBoundingBoxLeft: number;\n    /**\n     * Returns the measurement described below.\n     */\n    readonly actualBoundingBoxRight: number;\n    /**\n     * Returns the measurement described below.\n     */\n    readonly alphabeticBaseline: number;\n    /**\n     * Returns the measurement described below.\n     */\n    readonly emHeightAscent: number;\n    /**\n     * Returns the measurement described below.\n     */\n    readonly emHeightDescent: number;\n    /**\n     * Returns the measurement described below.\n     */\n    readonly fontBoundingBoxAscent: number;\n    /**\n     * Returns the measurement described below.\n     */\n    readonly fontBoundingBoxDescent: number;\n    /**\n     * Returns the measurement described below.\n     */\n    readonly hangingBaseline: number;\n    /**\n     * Returns the measurement described below.\n     */\n    readonly ideographicBaseline: number;\n    /**\n     * Returns the measurement described below.\n     */\n    readonly width: number;\n}\n\ndeclare var TextMetrics: {\n    prototype: TextMetrics;\n    new(): TextMetrics;\n};\n\ninterface TextTrackEventMap {\n    \"cuechange\": Event;\n}\n\n/** This interface also inherits properties from EventTarget. */\ninterface TextTrack extends EventTarget {\n    /**\n     * Returns the text track cues from the text track list of cues that are currently active (i.e. that start before the current playback position and end after it), as a TextTrackCueList object.\n     */\n    readonly activeCues: TextTrackCueList | null;\n    /**\n     * Returns the text track list of cues, as a TextTrackCueList object.\n     */\n    readonly cues: TextTrackCueList | null;\n    /**\n     * Returns the ID of the given track.\n     * \n     * For in-band tracks, this is the ID that can be used with a fragment if the format supports media fragment syntax, and that can be used with the getTrackById() method.\n     * \n     * For TextTrack objects corresponding to track elements, this is the ID of the track element.\n     */\n    readonly id: string;\n    /**\n     * Returns the text track in-band metadata track dispatch type string.\n     */\n    readonly inBandMetadataTrackDispatchType: string;\n    /**\n     * Returns the text track kind string.\n     */\n    readonly kind: TextTrackKind;\n    /**\n     * Returns the text track label, if there is one, or the empty string otherwise (indicating that a custom label probably needs to be generated from the other attributes of the object if the object is exposed to the user).\n     */\n    readonly label: string;\n    /**\n     * Returns the text track language string.\n     */\n    readonly language: string;\n    /**\n     * Returns the text track mode, represented by a string from the following list:\n     * \n     * Can be set, to change the mode.\n     */\n    mode: TextTrackMode;\n    oncuechange: ((this: TextTrack, ev: Event) => any) | null;\n    readonly sourceBuffer: SourceBuffer | null;\n    /**\n     * Adds the given cue to textTrack's text track list of cues.\n     */\n    addCue(cue: TextTrackCue): void;\n    /**\n     * Removes the given cue from textTrack's text track list of cues.\n     */\n    removeCue(cue: TextTrackCue): void;\n    addEventListener<K extends keyof TextTrackEventMap>(type: K, listener: (this: TextTrack, ev: TextTrackEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof TextTrackEventMap>(type: K, listener: (this: TextTrack, ev: TextTrackEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var TextTrack: {\n    prototype: TextTrack;\n    new(): TextTrack;\n};\n\ninterface TextTrackCueEventMap {\n    \"enter\": Event;\n    \"exit\": Event;\n}\n\n/** TextTrackCues represent a string of text that will be displayed for some duration of time on a TextTrack. This includes the start and end times that the cue will be displayed. A TextTrackCue cannot be used directly, instead one of the derived types (e.g. VTTCue) must be used. */\ninterface TextTrackCue extends EventTarget {\n    /**\n     * Returns the text track cue end time, in seconds.\n     * \n     * Can be set.\n     */\n    endTime: number;\n    /**\n     * Returns the text track cue identifier.\n     * \n     * Can be set.\n     */\n    id: string;\n    onenter: ((this: TextTrackCue, ev: Event) => any) | null;\n    onexit: ((this: TextTrackCue, ev: Event) => any) | null;\n    /**\n     * Returns true if the text track cue pause-on-exit flag is set, false otherwise.\n     * \n     * Can be set.\n     */\n    pauseOnExit: boolean;\n    /**\n     * Returns the text track cue start time, in seconds.\n     * \n     * Can be set.\n     */\n    startTime: number;\n    /**\n     * Returns the TextTrack object to which this text track cue belongs, if any, or null otherwise.\n     */\n    readonly track: TextTrack | null;\n    addEventListener<K extends keyof TextTrackCueEventMap>(type: K, listener: (this: TextTrackCue, ev: TextTrackCueEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof TextTrackCueEventMap>(type: K, listener: (this: TextTrackCue, ev: TextTrackCueEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var TextTrackCue: {\n    prototype: TextTrackCue;\n    new(): TextTrackCue;\n};\n\ninterface TextTrackCueList {\n    /**\n     * Returns the number of cues in the list.\n     */\n    readonly length: number;\n    /**\n     * Returns the first text track cue (in text track cue order) with text track cue identifier id.\n     * \n     * Returns null if none of the cues have the given identifier or if the argument is the empty string.\n     */\n    getCueById(id: string): TextTrackCue | null;\n    [index: number]: TextTrackCue;\n}\n\ndeclare var TextTrackCueList: {\n    prototype: TextTrackCueList;\n    new(): TextTrackCueList;\n};\n\ninterface TextTrackListEventMap {\n    \"addtrack\": TrackEvent;\n    \"change\": Event;\n    \"removetrack\": TrackEvent;\n}\n\ninterface TextTrackList extends EventTarget {\n    readonly length: number;\n    onaddtrack: ((this: TextTrackList, ev: TrackEvent) => any) | null;\n    onchange: ((this: TextTrackList, ev: Event) => any) | null;\n    onremovetrack: ((this: TextTrackList, ev: TrackEvent) => any) | null;\n    getTrackById(id: string): TextTrack | null;\n    addEventListener<K extends keyof TextTrackListEventMap>(type: K, listener: (this: TextTrackList, ev: TextTrackListEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof TextTrackListEventMap>(type: K, listener: (this: TextTrackList, ev: TextTrackListEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n    [index: number]: TextTrack;\n}\n\ndeclare var TextTrackList: {\n    prototype: TextTrackList;\n    new(): TextTrackList;\n};\n\n/** Used to represent a set of time ranges, primarily for the purpose of tracking which portions of media have been buffered when loading it for use by the <audio> and <video> elements. */\ninterface TimeRanges {\n    /**\n     * Returns the number of ranges in the object.\n     */\n    readonly length: number;\n    /**\n     * Returns the time for the end of the range with the given index.\n     * \n     * Throws an \"IndexSizeError\" DOMException if the index is out of range.\n     */\n    end(index: number): number;\n    /**\n     * Returns the time for the start of the range with the given index.\n     * \n     * Throws an \"IndexSizeError\" DOMException if the index is out of range.\n     */\n    start(index: number): number;\n}\n\ndeclare var TimeRanges: {\n    prototype: TimeRanges;\n    new(): TimeRanges;\n};\n\n/** A single contact point on a touch-sensitive device. The contact point is commonly a finger or stylus and the device may be a touchscreen or trackpad. */\ninterface Touch {\n    readonly altitudeAngle: number;\n    readonly azimuthAngle: number;\n    readonly clientX: number;\n    readonly clientY: number;\n    readonly force: number;\n    readonly identifier: number;\n    readonly pageX: number;\n    readonly pageY: number;\n    readonly radiusX: number;\n    readonly radiusY: number;\n    readonly rotationAngle: number;\n    readonly screenX: number;\n    readonly screenY: number;\n    readonly target: EventTarget;\n    readonly touchType: TouchType;\n}\n\ndeclare var Touch: {\n    prototype: Touch;\n    new(touchInitDict: TouchInit): Touch;\n};\n\n/** An event sent when the state of contacts with a touch-sensitive surface changes. This surface can be a touch screen or trackpad, for example. The event can describe one or more points of contact with the screen and includes support for detecting movement, addition and removal of contact points, and so forth. */\ninterface TouchEvent extends UIEvent {\n    readonly altKey: boolean;\n    readonly changedTouches: TouchList;\n    readonly ctrlKey: boolean;\n    readonly metaKey: boolean;\n    readonly shiftKey: boolean;\n    readonly targetTouches: TouchList;\n    readonly touches: TouchList;\n}\n\ndeclare var TouchEvent: {\n    prototype: TouchEvent;\n    new(type: string, eventInitDict?: TouchEventInit): TouchEvent;\n};\n\n/** A list of contact points on a touch surface. For example, if the user has three fingers on the touch surface (such as a screen or trackpad), the corresponding TouchList object would have one Touch object for each finger, for a total of three entries. */\ninterface TouchList {\n    readonly length: number;\n    item(index: number): Touch | null;\n    [index: number]: Touch;\n}\n\ndeclare var TouchList: {\n    prototype: TouchList;\n    new(): TouchList;\n};\n\n/** The TrackEvent interface, part of the HTML DOM specification, is used for events which represent changes to the set of available tracks on an HTML media element; these events are addtrack and removetrack. */\ninterface TrackEvent extends Event {\n    /**\n     * Returns the track object (TextTrack, AudioTrack, or VideoTrack) to which the event relates.\n     */\n    readonly track: TextTrack | null;\n}\n\ndeclare var TrackEvent: {\n    prototype: TrackEvent;\n    new(type: string, eventInitDict?: TrackEventInit): TrackEvent;\n};\n\ninterface TransformStream<I = any, O = any> {\n    readonly readable: ReadableStream<O>;\n    readonly writable: WritableStream<I>;\n}\n\ndeclare var TransformStream: {\n    prototype: TransformStream;\n    new<I = any, O = any>(transformer?: Transformer<I, O>, writableStrategy?: QueuingStrategy<I>, readableStrategy?: QueuingStrategy<O>): TransformStream<I, O>;\n};\n\ninterface TransformStreamDefaultController<O = any> {\n    readonly desiredSize: number | null;\n    enqueue(chunk: O): void;\n    error(reason?: any): void;\n    terminate(): void;\n}\n\ndeclare var TransformStreamDefaultController: {\n    prototype: TransformStreamDefaultController;\n    new(): TransformStreamDefaultController;\n};\n\n/** Events providing information related to transitions. */\ninterface TransitionEvent extends Event {\n    readonly elapsedTime: number;\n    readonly propertyName: string;\n    readonly pseudoElement: string;\n}\n\ndeclare var TransitionEvent: {\n    prototype: TransitionEvent;\n    new(type: string, transitionEventInitDict?: TransitionEventInit): TransitionEvent;\n};\n\n/** The nodes of a document subtree and a position within them. */\ninterface TreeWalker {\n    currentNode: Node;\n    readonly filter: NodeFilter | null;\n    readonly root: Node;\n    readonly whatToShow: number;\n    firstChild(): Node | null;\n    lastChild(): Node | null;\n    nextNode(): Node | null;\n    nextSibling(): Node | null;\n    parentNode(): Node | null;\n    previousNode(): Node | null;\n    previousSibling(): Node | null;\n}\n\ndeclare var TreeWalker: {\n    prototype: TreeWalker;\n    new(): TreeWalker;\n};\n\n/** Simple user interface events. */\ninterface UIEvent extends Event {\n    readonly detail: number;\n    readonly view: Window | null;\n    /** @deprecated */\n    readonly which: number;\n}\n\ndeclare var UIEvent: {\n    prototype: UIEvent;\n    new(type: string, eventInitDict?: UIEventInit): UIEvent;\n};\n\n/** The URL interface represents an object providing static methods used for creating object URLs. */\ninterface URL {\n    hash: string;\n    host: string;\n    hostname: string;\n    href: string;\n    toString(): string;\n    readonly origin: string;\n    password: string;\n    pathname: string;\n    port: string;\n    protocol: string;\n    search: string;\n    readonly searchParams: URLSearchParams;\n    username: string;\n    toJSON(): string;\n}\n\ndeclare var URL: {\n    prototype: URL;\n    new(url: string, base?: string | URL): URL;\n    createObjectURL(object: any): string;\n    revokeObjectURL(url: string): void;\n};\n\ntype webkitURL = URL;\ndeclare var webkitURL: typeof URL;\n\ninterface URLSearchParams {\n    /**\n     * Appends a specified key/value pair as a new search parameter.\n     */\n    append(name: string, value: string): void;\n    /**\n     * Deletes the given search parameter, and its associated value, from the list of all search parameters.\n     */\n    delete(name: string): void;\n    /**\n     * Returns the first value associated to the given search parameter.\n     */\n    get(name: string): string | null;\n    /**\n     * Returns all the values association with a given search parameter.\n     */\n    getAll(name: string): string[];\n    /**\n     * Returns a Boolean indicating if such a search parameter exists.\n     */\n    has(name: string): boolean;\n    /**\n     * Sets the value associated to a given search parameter to the given value. If there were several values, delete the others.\n     */\n    set(name: string, value: string): void;\n    sort(): void;\n    /**\n     * Returns a string containing a query string suitable for use in a URL. Does not include the question mark.\n     */\n    toString(): string;\n    forEach(callbackfn: (value: string, key: string, parent: URLSearchParams) => void, thisArg?: any): void;\n}\n\ndeclare var URLSearchParams: {\n    prototype: URLSearchParams;\n    new(init?: string[][] | Record<string, string> | string | URLSearchParams): URLSearchParams;\n    toString(): string;\n};\n\n/** This WebVR API interface represents any VR device supported by this API. It includes generic information such as device IDs and descriptions, as well as methods for starting to present a VR scene, retrieving eye parameters and display capabilities, and other important functionality. */\ninterface VRDisplay extends EventTarget {\n    readonly capabilities: VRDisplayCapabilities;\n    depthFar: number;\n    depthNear: number;\n    readonly displayId: number;\n    readonly displayName: string;\n    readonly isConnected: boolean;\n    readonly isPresenting: boolean;\n    readonly stageParameters: VRStageParameters | null;\n    cancelAnimationFrame(handle: number): void;\n    exitPresent(): Promise<void>;\n    getEyeParameters(whichEye: string): VREyeParameters;\n    getFrameData(frameData: VRFrameData): boolean;\n    getLayers(): VRLayer[];\n    /** @deprecated */\n    getPose(): VRPose;\n    requestAnimationFrame(callback: FrameRequestCallback): number;\n    requestPresent(layers: VRLayer[]): Promise<void>;\n    resetPose(): void;\n    submitFrame(pose?: VRPose): void;\n}\n\ndeclare var VRDisplay: {\n    prototype: VRDisplay;\n    new(): VRDisplay;\n};\n\n/** This WebVR API interface describes the capabilities of a VRDisplay — its features can be used to perform VR device capability tests, for example can it return position information. */\ninterface VRDisplayCapabilities {\n    readonly canPresent: boolean;\n    readonly hasExternalDisplay: boolean;\n    readonly hasOrientation: boolean;\n    readonly hasPosition: boolean;\n    readonly maxLayers: number;\n}\n\ndeclare var VRDisplayCapabilities: {\n    prototype: VRDisplayCapabilities;\n    new(): VRDisplayCapabilities;\n};\n\n/** This WebVR API interface represents represents the event object of WebVR-related events (see the list of WebVR window extensions). */\ninterface VRDisplayEvent extends Event {\n    readonly display: VRDisplay;\n    readonly reason: VRDisplayEventReason | null;\n}\n\ndeclare var VRDisplayEvent: {\n    prototype: VRDisplayEvent;\n    new(type: string, eventInitDict: VRDisplayEventInit): VRDisplayEvent;\n};\n\n/** This WebVR API interface represents all the information required to correctly render a scene for a given eye, including field of view information. */\ninterface VREyeParameters {\n    /** @deprecated */\n    readonly fieldOfView: VRFieldOfView;\n    readonly offset: Float32Array;\n    readonly renderHeight: number;\n    readonly renderWidth: number;\n}\n\ndeclare var VREyeParameters: {\n    prototype: VREyeParameters;\n    new(): VREyeParameters;\n};\n\n/** This WebVR API interface represents a field of view defined by 4 different degree values describing the view from a center point. */\ninterface VRFieldOfView {\n    readonly downDegrees: number;\n    readonly leftDegrees: number;\n    readonly rightDegrees: number;\n    readonly upDegrees: number;\n}\n\ndeclare var VRFieldOfView: {\n    prototype: VRFieldOfView;\n    new(): VRFieldOfView;\n};\n\n/** This WebVR API interface represents all the information needed to render a single frame of a VR scene; constructed by VRDisplay.getFrameData(). */\ninterface VRFrameData {\n    readonly leftProjectionMatrix: Float32Array;\n    readonly leftViewMatrix: Float32Array;\n    readonly pose: VRPose;\n    readonly rightProjectionMatrix: Float32Array;\n    readonly rightViewMatrix: Float32Array;\n    readonly timestamp: number;\n}\n\ndeclare var VRFrameData: {\n    prototype: VRFrameData;\n    new(): VRFrameData;\n};\n\n/** This WebVR API interface represents the state of a VR sensor at a given timestamp (which includes orientation, position, velocity, and acceleration information.) */\ninterface VRPose {\n    readonly angularAcceleration: Float32Array | null;\n    readonly angularVelocity: Float32Array | null;\n    readonly linearAcceleration: Float32Array | null;\n    readonly linearVelocity: Float32Array | null;\n    readonly orientation: Float32Array | null;\n    readonly position: Float32Array | null;\n    readonly timestamp: number;\n}\n\ndeclare var VRPose: {\n    prototype: VRPose;\n    new(): VRPose;\n};\n\ninterface VTTCue extends TextTrackCue {\n    align: AlignSetting;\n    line: LineAndPositionSetting;\n    lineAlign: LineAlignSetting;\n    position: LineAndPositionSetting;\n    positionAlign: PositionAlignSetting;\n    region: VTTRegion | null;\n    size: number;\n    snapToLines: boolean;\n    text: string;\n    vertical: DirectionSetting;\n    getCueAsHTML(): DocumentFragment;\n    addEventListener<K extends keyof TextTrackCueEventMap>(type: K, listener: (this: VTTCue, ev: TextTrackCueEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof TextTrackCueEventMap>(type: K, listener: (this: VTTCue, ev: TextTrackCueEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var VTTCue: {\n    prototype: VTTCue;\n    new(startTime: number, endTime: number, text: string): VTTCue;\n};\n\ninterface VTTRegion {\n    id: string;\n    lines: number;\n    regionAnchorX: number;\n    regionAnchorY: number;\n    scroll: ScrollSetting;\n    viewportAnchorX: number;\n    viewportAnchorY: number;\n    width: number;\n}\n\ndeclare var VTTRegion: {\n    prototype: VTTRegion;\n    new(): VTTRegion;\n};\n\n/** The validity states that an element can be in, with respect to constraint validation. Together, they help explain why an element's value fails to validate, if it's not valid. */\ninterface ValidityState {\n    readonly badInput: boolean;\n    readonly customError: boolean;\n    readonly patternMismatch: boolean;\n    readonly rangeOverflow: boolean;\n    readonly rangeUnderflow: boolean;\n    readonly stepMismatch: boolean;\n    readonly tooLong: boolean;\n    readonly tooShort: boolean;\n    readonly typeMismatch: boolean;\n    readonly valid: boolean;\n    readonly valueMissing: boolean;\n}\n\ndeclare var ValidityState: {\n    prototype: ValidityState;\n    new(): ValidityState;\n};\n\n/** Returned by the HTMLVideoElement.getVideoPlaybackQuality() method and contains metrics that can be used to determine the playback quality of a video. */\ninterface VideoPlaybackQuality {\n    readonly creationTime: number;\n    readonly droppedVideoFrames: number;\n    readonly totalVideoFrames: number;\n}\n\ndeclare var VideoPlaybackQuality: {\n    prototype: VideoPlaybackQuality;\n    new(): VideoPlaybackQuality;\n};\n\ninterface VisualViewportEventMap {\n    \"resize\": UIEvent;\n    \"scroll\": Event;\n}\n\ninterface VisualViewport extends EventTarget {\n    readonly height: number;\n    readonly offsetLeft: number;\n    readonly offsetTop: number;\n    onresize: ((this: VisualViewport, ev: UIEvent) => any) | null;\n    onscroll: ((this: VisualViewport, ev: Event) => any) | null;\n    readonly pageLeft: number;\n    readonly pageTop: number;\n    readonly scale: number;\n    readonly width: number;\n    addEventListener<K extends keyof VisualViewportEventMap>(type: K, listener: (this: VisualViewport, ev: VisualViewportEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof VisualViewportEventMap>(type: K, listener: (this: VisualViewport, ev: VisualViewportEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var VisualViewport: {\n    prototype: VisualViewport;\n    new(): VisualViewport;\n};\n\ninterface WEBGL_color_buffer_float {\n    readonly FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT: GLenum;\n    readonly RGBA32F_EXT: GLenum;\n    readonly UNSIGNED_NORMALIZED_EXT: GLenum;\n}\n\ninterface WEBGL_compressed_texture_astc {\n    getSupportedProfiles(): string[];\n    readonly COMPRESSED_RGBA_ASTC_10x10_KHR: GLenum;\n    readonly COMPRESSED_RGBA_ASTC_10x5_KHR: GLenum;\n    readonly COMPRESSED_RGBA_ASTC_10x6_KHR: GLenum;\n    readonly COMPRESSED_RGBA_ASTC_10x8_KHR: GLenum;\n    readonly COMPRESSED_RGBA_ASTC_12x10_KHR: GLenum;\n    readonly COMPRESSED_RGBA_ASTC_12x12_KHR: GLenum;\n    readonly COMPRESSED_RGBA_ASTC_4x4_KHR: GLenum;\n    readonly COMPRESSED_RGBA_ASTC_5x4_KHR: GLenum;\n    readonly COMPRESSED_RGBA_ASTC_5x5_KHR: GLenum;\n    readonly COMPRESSED_RGBA_ASTC_6x5_KHR: GLenum;\n    readonly COMPRESSED_RGBA_ASTC_6x6_KHR: GLenum;\n    readonly COMPRESSED_RGBA_ASTC_8x5_KHR: GLenum;\n    readonly COMPRESSED_RGBA_ASTC_8x6_KHR: GLenum;\n    readonly COMPRESSED_RGBA_ASTC_8x8_KHR: GLenum;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR: GLenum;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR: GLenum;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR: GLenum;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR: GLenum;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR: GLenum;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR: GLenum;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR: GLenum;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR: GLenum;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR: GLenum;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR: GLenum;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR: GLenum;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR: GLenum;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR: GLenum;\n    readonly COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR: GLenum;\n}\n\n/** The WEBGL_compressed_texture_s3tc extension is part of the WebGL API and exposes four S3TC compressed texture formats. */\ninterface WEBGL_compressed_texture_s3tc {\n    readonly COMPRESSED_RGBA_S3TC_DXT1_EXT: GLenum;\n    readonly COMPRESSED_RGBA_S3TC_DXT3_EXT: GLenum;\n    readonly COMPRESSED_RGBA_S3TC_DXT5_EXT: GLenum;\n    readonly COMPRESSED_RGB_S3TC_DXT1_EXT: GLenum;\n}\n\ninterface WEBGL_compressed_texture_s3tc_srgb {\n    readonly COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT: GLenum;\n    readonly COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT: GLenum;\n    readonly COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT: GLenum;\n    readonly COMPRESSED_SRGB_S3TC_DXT1_EXT: GLenum;\n}\n\n/** The WEBGL_debug_renderer_info extension is part of the WebGL API and exposes two constants with information about the graphics driver for debugging purposes. */\ninterface WEBGL_debug_renderer_info {\n    readonly UNMASKED_RENDERER_WEBGL: GLenum;\n    readonly UNMASKED_VENDOR_WEBGL: GLenum;\n}\n\ninterface WEBGL_debug_shaders {\n    getTranslatedShaderSource(shader: WebGLShader): string;\n}\n\n/** The WEBGL_depth_texture extension is part of the WebGL API and defines 2D depth and depth-stencil textures. */\ninterface WEBGL_depth_texture {\n    readonly UNSIGNED_INT_24_8_WEBGL: GLenum;\n}\n\ninterface WEBGL_draw_buffers {\n    drawBuffersWEBGL(buffers: GLenum[]): void;\n    readonly COLOR_ATTACHMENT0_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT10_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT11_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT12_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT13_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT14_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT15_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT1_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT2_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT3_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT4_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT5_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT6_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT7_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT8_WEBGL: GLenum;\n    readonly COLOR_ATTACHMENT9_WEBGL: GLenum;\n    readonly DRAW_BUFFER0_WEBGL: GLenum;\n    readonly DRAW_BUFFER10_WEBGL: GLenum;\n    readonly DRAW_BUFFER11_WEBGL: GLenum;\n    readonly DRAW_BUFFER12_WEBGL: GLenum;\n    readonly DRAW_BUFFER13_WEBGL: GLenum;\n    readonly DRAW_BUFFER14_WEBGL: GLenum;\n    readonly DRAW_BUFFER15_WEBGL: GLenum;\n    readonly DRAW_BUFFER1_WEBGL: GLenum;\n    readonly DRAW_BUFFER2_WEBGL: GLenum;\n    readonly DRAW_BUFFER3_WEBGL: GLenum;\n    readonly DRAW_BUFFER4_WEBGL: GLenum;\n    readonly DRAW_BUFFER5_WEBGL: GLenum;\n    readonly DRAW_BUFFER6_WEBGL: GLenum;\n    readonly DRAW_BUFFER7_WEBGL: GLenum;\n    readonly DRAW_BUFFER8_WEBGL: GLenum;\n    readonly DRAW_BUFFER9_WEBGL: GLenum;\n    readonly MAX_COLOR_ATTACHMENTS_WEBGL: GLenum;\n    readonly MAX_DRAW_BUFFERS_WEBGL: GLenum;\n}\n\ninterface WEBGL_lose_context {\n    loseContext(): void;\n    restoreContext(): void;\n}\n\n/** A WaveShaperNode always has exactly one input and one output. */\ninterface WaveShaperNode extends AudioNode {\n    curve: Float32Array | null;\n    oversample: OverSampleType;\n}\n\ndeclare var WaveShaperNode: {\n    prototype: WaveShaperNode;\n    new(context: BaseAudioContext, options?: WaveShaperOptions): WaveShaperNode;\n};\n\ninterface WebAuthentication {\n    getAssertion(assertionChallenge: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer | null, options?: AssertionOptions): Promise<WebAuthnAssertion>;\n    makeCredential(accountInformation: Account, cryptoParameters: ScopedCredentialParameters[], attestationChallenge: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer | null, options?: ScopedCredentialOptions): Promise<ScopedCredentialInfo>;\n}\n\ndeclare var WebAuthentication: {\n    prototype: WebAuthentication;\n    new(): WebAuthentication;\n};\n\ninterface WebAuthnAssertion {\n    readonly authenticatorData: ArrayBuffer;\n    readonly clientData: ArrayBuffer;\n    readonly credential: ScopedCredential;\n    readonly signature: ArrayBuffer;\n}\n\ndeclare var WebAuthnAssertion: {\n    prototype: WebAuthnAssertion;\n    new(): WebAuthnAssertion;\n};\n\ninterface WebGL2RenderingContext extends WebGL2RenderingContextBase, WebGL2RenderingContextOverloads, WebGLRenderingContextBase {\n}\n\ndeclare var WebGL2RenderingContext: {\n    prototype: WebGL2RenderingContext;\n    new(): WebGL2RenderingContext;\n    readonly ACTIVE_ATTRIBUTES: GLenum;\n    readonly ACTIVE_TEXTURE: GLenum;\n    readonly ACTIVE_UNIFORMS: GLenum;\n    readonly ALIASED_LINE_WIDTH_RANGE: GLenum;\n    readonly ALIASED_POINT_SIZE_RANGE: GLenum;\n    readonly ALPHA: GLenum;\n    readonly ALPHA_BITS: GLenum;\n    readonly ALWAYS: GLenum;\n    readonly ARRAY_BUFFER: GLenum;\n    readonly ARRAY_BUFFER_BINDING: GLenum;\n    readonly ATTACHED_SHADERS: GLenum;\n    readonly BACK: GLenum;\n    readonly BLEND: GLenum;\n    readonly BLEND_COLOR: GLenum;\n    readonly BLEND_DST_ALPHA: GLenum;\n    readonly BLEND_DST_RGB: GLenum;\n    readonly BLEND_EQUATION: GLenum;\n    readonly BLEND_EQUATION_ALPHA: GLenum;\n    readonly BLEND_EQUATION_RGB: GLenum;\n    readonly BLEND_SRC_ALPHA: GLenum;\n    readonly BLEND_SRC_RGB: GLenum;\n    readonly BLUE_BITS: GLenum;\n    readonly BOOL: GLenum;\n    readonly BOOL_VEC2: GLenum;\n    readonly BOOL_VEC3: GLenum;\n    readonly BOOL_VEC4: GLenum;\n    readonly BROWSER_DEFAULT_WEBGL: GLenum;\n    readonly BUFFER_SIZE: GLenum;\n    readonly BUFFER_USAGE: GLenum;\n    readonly BYTE: GLenum;\n    readonly CCW: GLenum;\n    readonly CLAMP_TO_EDGE: GLenum;\n    readonly COLOR_ATTACHMENT0: GLenum;\n    readonly COLOR_BUFFER_BIT: GLenum;\n    readonly COLOR_CLEAR_VALUE: GLenum;\n    readonly COLOR_WRITEMASK: GLenum;\n    readonly COMPILE_STATUS: GLenum;\n    readonly COMPRESSED_TEXTURE_FORMATS: GLenum;\n    readonly CONSTANT_ALPHA: GLenum;\n    readonly CONSTANT_COLOR: GLenum;\n    readonly CONTEXT_LOST_WEBGL: GLenum;\n    readonly CULL_FACE: GLenum;\n    readonly CULL_FACE_MODE: GLenum;\n    readonly CURRENT_PROGRAM: GLenum;\n    readonly CURRENT_VERTEX_ATTRIB: GLenum;\n    readonly CW: GLenum;\n    readonly DECR: GLenum;\n    readonly DECR_WRAP: GLenum;\n    readonly DELETE_STATUS: GLenum;\n    readonly DEPTH_ATTACHMENT: GLenum;\n    readonly DEPTH_BITS: GLenum;\n    readonly DEPTH_BUFFER_BIT: GLenum;\n    readonly DEPTH_CLEAR_VALUE: GLenum;\n    readonly DEPTH_COMPONENT: GLenum;\n    readonly DEPTH_COMPONENT16: GLenum;\n    readonly DEPTH_FUNC: GLenum;\n    readonly DEPTH_RANGE: GLenum;\n    readonly DEPTH_STENCIL: GLenum;\n    readonly DEPTH_STENCIL_ATTACHMENT: GLenum;\n    readonly DEPTH_TEST: GLenum;\n    readonly DEPTH_WRITEMASK: GLenum;\n    readonly DITHER: GLenum;\n    readonly DONT_CARE: GLenum;\n    readonly DST_ALPHA: GLenum;\n    readonly DST_COLOR: GLenum;\n    readonly DYNAMIC_DRAW: GLenum;\n    readonly ELEMENT_ARRAY_BUFFER: GLenum;\n    readonly ELEMENT_ARRAY_BUFFER_BINDING: GLenum;\n    readonly EQUAL: GLenum;\n    readonly FASTEST: GLenum;\n    readonly FLOAT: GLenum;\n    readonly FLOAT_MAT2: GLenum;\n    readonly FLOAT_MAT3: GLenum;\n    readonly FLOAT_MAT4: GLenum;\n    readonly FLOAT_VEC2: GLenum;\n    readonly FLOAT_VEC3: GLenum;\n    readonly FLOAT_VEC4: GLenum;\n    readonly FRAGMENT_SHADER: GLenum;\n    readonly FRAMEBUFFER: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: GLenum;\n    readonly FRAMEBUFFER_BINDING: GLenum;\n    readonly FRAMEBUFFER_COMPLETE: GLenum;\n    readonly FRAMEBUFFER_INCOMPLETE_ATTACHMENT: GLenum;\n    readonly FRAMEBUFFER_INCOMPLETE_DIMENSIONS: GLenum;\n    readonly FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: GLenum;\n    readonly FRAMEBUFFER_UNSUPPORTED: GLenum;\n    readonly FRONT: GLenum;\n    readonly FRONT_AND_BACK: GLenum;\n    readonly FRONT_FACE: GLenum;\n    readonly FUNC_ADD: GLenum;\n    readonly FUNC_REVERSE_SUBTRACT: GLenum;\n    readonly FUNC_SUBTRACT: GLenum;\n    readonly GENERATE_MIPMAP_HINT: GLenum;\n    readonly GEQUAL: GLenum;\n    readonly GREATER: GLenum;\n    readonly GREEN_BITS: GLenum;\n    readonly HIGH_FLOAT: GLenum;\n    readonly HIGH_INT: GLenum;\n    readonly IMPLEMENTATION_COLOR_READ_FORMAT: GLenum;\n    readonly IMPLEMENTATION_COLOR_READ_TYPE: GLenum;\n    readonly INCR: GLenum;\n    readonly INCR_WRAP: GLenum;\n    readonly INT: GLenum;\n    readonly INT_VEC2: GLenum;\n    readonly INT_VEC3: GLenum;\n    readonly INT_VEC4: GLenum;\n    readonly INVALID_ENUM: GLenum;\n    readonly INVALID_FRAMEBUFFER_OPERATION: GLenum;\n    readonly INVALID_OPERATION: GLenum;\n    readonly INVALID_VALUE: GLenum;\n    readonly INVERT: GLenum;\n    readonly KEEP: GLenum;\n    readonly LEQUAL: GLenum;\n    readonly LESS: GLenum;\n    readonly LINEAR: GLenum;\n    readonly LINEAR_MIPMAP_LINEAR: GLenum;\n    readonly LINEAR_MIPMAP_NEAREST: GLenum;\n    readonly LINES: GLenum;\n    readonly LINE_LOOP: GLenum;\n    readonly LINE_STRIP: GLenum;\n    readonly LINE_WIDTH: GLenum;\n    readonly LINK_STATUS: GLenum;\n    readonly LOW_FLOAT: GLenum;\n    readonly LOW_INT: GLenum;\n    readonly LUMINANCE: GLenum;\n    readonly LUMINANCE_ALPHA: GLenum;\n    readonly MAX_COMBINED_TEXTURE_IMAGE_UNITS: GLenum;\n    readonly MAX_CUBE_MAP_TEXTURE_SIZE: GLenum;\n    readonly MAX_FRAGMENT_UNIFORM_VECTORS: GLenum;\n    readonly MAX_RENDERBUFFER_SIZE: GLenum;\n    readonly MAX_TEXTURE_IMAGE_UNITS: GLenum;\n    readonly MAX_TEXTURE_SIZE: GLenum;\n    readonly MAX_VARYING_VECTORS: GLenum;\n    readonly MAX_VERTEX_ATTRIBS: GLenum;\n    readonly MAX_VERTEX_TEXTURE_IMAGE_UNITS: GLenum;\n    readonly MAX_VERTEX_UNIFORM_VECTORS: GLenum;\n    readonly MAX_VIEWPORT_DIMS: GLenum;\n    readonly MEDIUM_FLOAT: GLenum;\n    readonly MEDIUM_INT: GLenum;\n    readonly MIRRORED_REPEAT: GLenum;\n    readonly NEAREST: GLenum;\n    readonly NEAREST_MIPMAP_LINEAR: GLenum;\n    readonly NEAREST_MIPMAP_NEAREST: GLenum;\n    readonly NEVER: GLenum;\n    readonly NICEST: GLenum;\n    readonly NONE: GLenum;\n    readonly NOTEQUAL: GLenum;\n    readonly NO_ERROR: GLenum;\n    readonly ONE: GLenum;\n    readonly ONE_MINUS_CONSTANT_ALPHA: GLenum;\n    readonly ONE_MINUS_CONSTANT_COLOR: GLenum;\n    readonly ONE_MINUS_DST_ALPHA: GLenum;\n    readonly ONE_MINUS_DST_COLOR: GLenum;\n    readonly ONE_MINUS_SRC_ALPHA: GLenum;\n    readonly ONE_MINUS_SRC_COLOR: GLenum;\n    readonly OUT_OF_MEMORY: GLenum;\n    readonly PACK_ALIGNMENT: GLenum;\n    readonly POINTS: GLenum;\n    readonly POLYGON_OFFSET_FACTOR: GLenum;\n    readonly POLYGON_OFFSET_FILL: GLenum;\n    readonly POLYGON_OFFSET_UNITS: GLenum;\n    readonly RED_BITS: GLenum;\n    readonly RENDERBUFFER: GLenum;\n    readonly RENDERBUFFER_ALPHA_SIZE: GLenum;\n    readonly RENDERBUFFER_BINDING: GLenum;\n    readonly RENDERBUFFER_BLUE_SIZE: GLenum;\n    readonly RENDERBUFFER_DEPTH_SIZE: GLenum;\n    readonly RENDERBUFFER_GREEN_SIZE: GLenum;\n    readonly RENDERBUFFER_HEIGHT: GLenum;\n    readonly RENDERBUFFER_INTERNAL_FORMAT: GLenum;\n    readonly RENDERBUFFER_RED_SIZE: GLenum;\n    readonly RENDERBUFFER_STENCIL_SIZE: GLenum;\n    readonly RENDERBUFFER_WIDTH: GLenum;\n    readonly RENDERER: GLenum;\n    readonly REPEAT: GLenum;\n    readonly REPLACE: GLenum;\n    readonly RGB: GLenum;\n    readonly RGB565: GLenum;\n    readonly RGB5_A1: GLenum;\n    readonly RGBA: GLenum;\n    readonly RGBA4: GLenum;\n    readonly SAMPLER_2D: GLenum;\n    readonly SAMPLER_CUBE: GLenum;\n    readonly SAMPLES: GLenum;\n    readonly SAMPLE_ALPHA_TO_COVERAGE: GLenum;\n    readonly SAMPLE_BUFFERS: GLenum;\n    readonly SAMPLE_COVERAGE: GLenum;\n    readonly SAMPLE_COVERAGE_INVERT: GLenum;\n    readonly SAMPLE_COVERAGE_VALUE: GLenum;\n    readonly SCISSOR_BOX: GLenum;\n    readonly SCISSOR_TEST: GLenum;\n    readonly SHADER_TYPE: GLenum;\n    readonly SHADING_LANGUAGE_VERSION: GLenum;\n    readonly SHORT: GLenum;\n    readonly SRC_ALPHA: GLenum;\n    readonly SRC_ALPHA_SATURATE: GLenum;\n    readonly SRC_COLOR: GLenum;\n    readonly STATIC_DRAW: GLenum;\n    readonly STENCIL_ATTACHMENT: GLenum;\n    readonly STENCIL_BACK_FAIL: GLenum;\n    readonly STENCIL_BACK_FUNC: GLenum;\n    readonly STENCIL_BACK_PASS_DEPTH_FAIL: GLenum;\n    readonly STENCIL_BACK_PASS_DEPTH_PASS: GLenum;\n    readonly STENCIL_BACK_REF: GLenum;\n    readonly STENCIL_BACK_VALUE_MASK: GLenum;\n    readonly STENCIL_BACK_WRITEMASK: GLenum;\n    readonly STENCIL_BITS: GLenum;\n    readonly STENCIL_BUFFER_BIT: GLenum;\n    readonly STENCIL_CLEAR_VALUE: GLenum;\n    readonly STENCIL_FAIL: GLenum;\n    readonly STENCIL_FUNC: GLenum;\n    readonly STENCIL_INDEX8: GLenum;\n    readonly STENCIL_PASS_DEPTH_FAIL: GLenum;\n    readonly STENCIL_PASS_DEPTH_PASS: GLenum;\n    readonly STENCIL_REF: GLenum;\n    readonly STENCIL_TEST: GLenum;\n    readonly STENCIL_VALUE_MASK: GLenum;\n    readonly STENCIL_WRITEMASK: GLenum;\n    readonly STREAM_DRAW: GLenum;\n    readonly SUBPIXEL_BITS: GLenum;\n    readonly TEXTURE: GLenum;\n    readonly TEXTURE0: GLenum;\n    readonly TEXTURE1: GLenum;\n    readonly TEXTURE10: GLenum;\n    readonly TEXTURE11: GLenum;\n    readonly TEXTURE12: GLenum;\n    readonly TEXTURE13: GLenum;\n    readonly TEXTURE14: GLenum;\n    readonly TEXTURE15: GLenum;\n    readonly TEXTURE16: GLenum;\n    readonly TEXTURE17: GLenum;\n    readonly TEXTURE18: GLenum;\n    readonly TEXTURE19: GLenum;\n    readonly TEXTURE2: GLenum;\n    readonly TEXTURE20: GLenum;\n    readonly TEXTURE21: GLenum;\n    readonly TEXTURE22: GLenum;\n    readonly TEXTURE23: GLenum;\n    readonly TEXTURE24: GLenum;\n    readonly TEXTURE25: GLenum;\n    readonly TEXTURE26: GLenum;\n    readonly TEXTURE27: GLenum;\n    readonly TEXTURE28: GLenum;\n    readonly TEXTURE29: GLenum;\n    readonly TEXTURE3: GLenum;\n    readonly TEXTURE30: GLenum;\n    readonly TEXTURE31: GLenum;\n    readonly TEXTURE4: GLenum;\n    readonly TEXTURE5: GLenum;\n    readonly TEXTURE6: GLenum;\n    readonly TEXTURE7: GLenum;\n    readonly TEXTURE8: GLenum;\n    readonly TEXTURE9: GLenum;\n    readonly TEXTURE_2D: GLenum;\n    readonly TEXTURE_BINDING_2D: GLenum;\n    readonly TEXTURE_BINDING_CUBE_MAP: GLenum;\n    readonly TEXTURE_CUBE_MAP: GLenum;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_X: GLenum;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Y: GLenum;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Z: GLenum;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_X: GLenum;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Y: GLenum;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Z: GLenum;\n    readonly TEXTURE_MAG_FILTER: GLenum;\n    readonly TEXTURE_MIN_FILTER: GLenum;\n    readonly TEXTURE_WRAP_S: GLenum;\n    readonly TEXTURE_WRAP_T: GLenum;\n    readonly TRIANGLES: GLenum;\n    readonly TRIANGLE_FAN: GLenum;\n    readonly TRIANGLE_STRIP: GLenum;\n    readonly UNPACK_ALIGNMENT: GLenum;\n    readonly UNPACK_COLORSPACE_CONVERSION_WEBGL: GLenum;\n    readonly UNPACK_FLIP_Y_WEBGL: GLenum;\n    readonly UNPACK_PREMULTIPLY_ALPHA_WEBGL: GLenum;\n    readonly UNSIGNED_BYTE: GLenum;\n    readonly UNSIGNED_INT: GLenum;\n    readonly UNSIGNED_SHORT: GLenum;\n    readonly UNSIGNED_SHORT_4_4_4_4: GLenum;\n    readonly UNSIGNED_SHORT_5_5_5_1: GLenum;\n    readonly UNSIGNED_SHORT_5_6_5: GLenum;\n    readonly VALIDATE_STATUS: GLenum;\n    readonly VENDOR: GLenum;\n    readonly VERSION: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_ENABLED: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_NORMALIZED: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_POINTER: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_SIZE: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_STRIDE: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_TYPE: GLenum;\n    readonly VERTEX_SHADER: GLenum;\n    readonly VIEWPORT: GLenum;\n    readonly ZERO: GLenum;\n    readonly ACTIVE_UNIFORM_BLOCKS: GLenum;\n    readonly ALREADY_SIGNALED: GLenum;\n    readonly ANY_SAMPLES_PASSED: GLenum;\n    readonly ANY_SAMPLES_PASSED_CONSERVATIVE: GLenum;\n    readonly COLOR: GLenum;\n    readonly COLOR_ATTACHMENT1: GLenum;\n    readonly COLOR_ATTACHMENT10: GLenum;\n    readonly COLOR_ATTACHMENT11: GLenum;\n    readonly COLOR_ATTACHMENT12: GLenum;\n    readonly COLOR_ATTACHMENT13: GLenum;\n    readonly COLOR_ATTACHMENT14: GLenum;\n    readonly COLOR_ATTACHMENT15: GLenum;\n    readonly COLOR_ATTACHMENT2: GLenum;\n    readonly COLOR_ATTACHMENT3: GLenum;\n    readonly COLOR_ATTACHMENT4: GLenum;\n    readonly COLOR_ATTACHMENT5: GLenum;\n    readonly COLOR_ATTACHMENT6: GLenum;\n    readonly COLOR_ATTACHMENT7: GLenum;\n    readonly COLOR_ATTACHMENT8: GLenum;\n    readonly COLOR_ATTACHMENT9: GLenum;\n    readonly COMPARE_REF_TO_TEXTURE: GLenum;\n    readonly CONDITION_SATISFIED: GLenum;\n    readonly COPY_READ_BUFFER: GLenum;\n    readonly COPY_READ_BUFFER_BINDING: GLenum;\n    readonly COPY_WRITE_BUFFER: GLenum;\n    readonly COPY_WRITE_BUFFER_BINDING: GLenum;\n    readonly CURRENT_QUERY: GLenum;\n    readonly DEPTH: GLenum;\n    readonly DEPTH24_STENCIL8: GLenum;\n    readonly DEPTH32F_STENCIL8: GLenum;\n    readonly DEPTH_COMPONENT24: GLenum;\n    readonly DEPTH_COMPONENT32F: GLenum;\n    readonly DRAW_BUFFER0: GLenum;\n    readonly DRAW_BUFFER1: GLenum;\n    readonly DRAW_BUFFER10: GLenum;\n    readonly DRAW_BUFFER11: GLenum;\n    readonly DRAW_BUFFER12: GLenum;\n    readonly DRAW_BUFFER13: GLenum;\n    readonly DRAW_BUFFER14: GLenum;\n    readonly DRAW_BUFFER15: GLenum;\n    readonly DRAW_BUFFER2: GLenum;\n    readonly DRAW_BUFFER3: GLenum;\n    readonly DRAW_BUFFER4: GLenum;\n    readonly DRAW_BUFFER5: GLenum;\n    readonly DRAW_BUFFER6: GLenum;\n    readonly DRAW_BUFFER7: GLenum;\n    readonly DRAW_BUFFER8: GLenum;\n    readonly DRAW_BUFFER9: GLenum;\n    readonly DRAW_FRAMEBUFFER: GLenum;\n    readonly DRAW_FRAMEBUFFER_BINDING: GLenum;\n    readonly DYNAMIC_COPY: GLenum;\n    readonly DYNAMIC_READ: GLenum;\n    readonly FLOAT_32_UNSIGNED_INT_24_8_REV: GLenum;\n    readonly FLOAT_MAT2x3: GLenum;\n    readonly FLOAT_MAT2x4: GLenum;\n    readonly FLOAT_MAT3x2: GLenum;\n    readonly FLOAT_MAT3x4: GLenum;\n    readonly FLOAT_MAT4x2: GLenum;\n    readonly FLOAT_MAT4x3: GLenum;\n    readonly FRAGMENT_SHADER_DERIVATIVE_HINT: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_BLUE_SIZE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_GREEN_SIZE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_RED_SIZE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER: GLenum;\n    readonly FRAMEBUFFER_DEFAULT: GLenum;\n    readonly FRAMEBUFFER_INCOMPLETE_MULTISAMPLE: GLenum;\n    readonly HALF_FLOAT: GLenum;\n    readonly INTERLEAVED_ATTRIBS: GLenum;\n    readonly INT_2_10_10_10_REV: GLenum;\n    readonly INT_SAMPLER_2D: GLenum;\n    readonly INT_SAMPLER_2D_ARRAY: GLenum;\n    readonly INT_SAMPLER_3D: GLenum;\n    readonly INT_SAMPLER_CUBE: GLenum;\n    readonly INVALID_INDEX: GLenum;\n    readonly MAX: GLenum;\n    readonly MAX_3D_TEXTURE_SIZE: GLenum;\n    readonly MAX_ARRAY_TEXTURE_LAYERS: GLenum;\n    readonly MAX_CLIENT_WAIT_TIMEOUT_WEBGL: GLenum;\n    readonly MAX_COLOR_ATTACHMENTS: GLenum;\n    readonly MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS: GLenum;\n    readonly MAX_COMBINED_UNIFORM_BLOCKS: GLenum;\n    readonly MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS: GLenum;\n    readonly MAX_DRAW_BUFFERS: GLenum;\n    readonly MAX_ELEMENTS_INDICES: GLenum;\n    readonly MAX_ELEMENTS_VERTICES: GLenum;\n    readonly MAX_ELEMENT_INDEX: GLenum;\n    readonly MAX_FRAGMENT_INPUT_COMPONENTS: GLenum;\n    readonly MAX_FRAGMENT_UNIFORM_BLOCKS: GLenum;\n    readonly MAX_FRAGMENT_UNIFORM_COMPONENTS: GLenum;\n    readonly MAX_PROGRAM_TEXEL_OFFSET: GLenum;\n    readonly MAX_SAMPLES: GLenum;\n    readonly MAX_SERVER_WAIT_TIMEOUT: GLenum;\n    readonly MAX_TEXTURE_LOD_BIAS: GLenum;\n    readonly MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS: GLenum;\n    readonly MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS: GLenum;\n    readonly MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS: GLenum;\n    readonly MAX_UNIFORM_BLOCK_SIZE: GLenum;\n    readonly MAX_UNIFORM_BUFFER_BINDINGS: GLenum;\n    readonly MAX_VARYING_COMPONENTS: GLenum;\n    readonly MAX_VERTEX_OUTPUT_COMPONENTS: GLenum;\n    readonly MAX_VERTEX_UNIFORM_BLOCKS: GLenum;\n    readonly MAX_VERTEX_UNIFORM_COMPONENTS: GLenum;\n    readonly MIN: GLenum;\n    readonly MIN_PROGRAM_TEXEL_OFFSET: GLenum;\n    readonly OBJECT_TYPE: GLenum;\n    readonly PACK_ROW_LENGTH: GLenum;\n    readonly PACK_SKIP_PIXELS: GLenum;\n    readonly PACK_SKIP_ROWS: GLenum;\n    readonly PIXEL_PACK_BUFFER: GLenum;\n    readonly PIXEL_PACK_BUFFER_BINDING: GLenum;\n    readonly PIXEL_UNPACK_BUFFER: GLenum;\n    readonly PIXEL_UNPACK_BUFFER_BINDING: GLenum;\n    readonly QUERY_RESULT: GLenum;\n    readonly QUERY_RESULT_AVAILABLE: GLenum;\n    readonly R11F_G11F_B10F: GLenum;\n    readonly R16F: GLenum;\n    readonly R16I: GLenum;\n    readonly R16UI: GLenum;\n    readonly R32F: GLenum;\n    readonly R32I: GLenum;\n    readonly R32UI: GLenum;\n    readonly R8: GLenum;\n    readonly R8I: GLenum;\n    readonly R8UI: GLenum;\n    readonly R8_SNORM: GLenum;\n    readonly RASTERIZER_DISCARD: GLenum;\n    readonly READ_BUFFER: GLenum;\n    readonly READ_FRAMEBUFFER: GLenum;\n    readonly READ_FRAMEBUFFER_BINDING: GLenum;\n    readonly RED: GLenum;\n    readonly RED_INTEGER: GLenum;\n    readonly RENDERBUFFER_SAMPLES: GLenum;\n    readonly RG: GLenum;\n    readonly RG16F: GLenum;\n    readonly RG16I: GLenum;\n    readonly RG16UI: GLenum;\n    readonly RG32F: GLenum;\n    readonly RG32I: GLenum;\n    readonly RG32UI: GLenum;\n    readonly RG8: GLenum;\n    readonly RG8I: GLenum;\n    readonly RG8UI: GLenum;\n    readonly RG8_SNORM: GLenum;\n    readonly RGB10_A2: GLenum;\n    readonly RGB10_A2UI: GLenum;\n    readonly RGB16F: GLenum;\n    readonly RGB16I: GLenum;\n    readonly RGB16UI: GLenum;\n    readonly RGB32F: GLenum;\n    readonly RGB32I: GLenum;\n    readonly RGB32UI: GLenum;\n    readonly RGB8: GLenum;\n    readonly RGB8I: GLenum;\n    readonly RGB8UI: GLenum;\n    readonly RGB8_SNORM: GLenum;\n    readonly RGB9_E5: GLenum;\n    readonly RGBA16F: GLenum;\n    readonly RGBA16I: GLenum;\n    readonly RGBA16UI: GLenum;\n    readonly RGBA32F: GLenum;\n    readonly RGBA32I: GLenum;\n    readonly RGBA32UI: GLenum;\n    readonly RGBA8: GLenum;\n    readonly RGBA8I: GLenum;\n    readonly RGBA8UI: GLenum;\n    readonly RGBA8_SNORM: GLenum;\n    readonly RGBA_INTEGER: GLenum;\n    readonly RGB_INTEGER: GLenum;\n    readonly RG_INTEGER: GLenum;\n    readonly SAMPLER_2D_ARRAY: GLenum;\n    readonly SAMPLER_2D_ARRAY_SHADOW: GLenum;\n    readonly SAMPLER_2D_SHADOW: GLenum;\n    readonly SAMPLER_3D: GLenum;\n    readonly SAMPLER_BINDING: GLenum;\n    readonly SAMPLER_CUBE_SHADOW: GLenum;\n    readonly SEPARATE_ATTRIBS: GLenum;\n    readonly SIGNALED: GLenum;\n    readonly SIGNED_NORMALIZED: GLenum;\n    readonly SRGB: GLenum;\n    readonly SRGB8: GLenum;\n    readonly SRGB8_ALPHA8: GLenum;\n    readonly STATIC_COPY: GLenum;\n    readonly STATIC_READ: GLenum;\n    readonly STENCIL: GLenum;\n    readonly STREAM_COPY: GLenum;\n    readonly STREAM_READ: GLenum;\n    readonly SYNC_CONDITION: GLenum;\n    readonly SYNC_FENCE: GLenum;\n    readonly SYNC_FLAGS: GLenum;\n    readonly SYNC_FLUSH_COMMANDS_BIT: GLenum;\n    readonly SYNC_GPU_COMMANDS_COMPLETE: GLenum;\n    readonly SYNC_STATUS: GLenum;\n    readonly TEXTURE_2D_ARRAY: GLenum;\n    readonly TEXTURE_3D: GLenum;\n    readonly TEXTURE_BASE_LEVEL: GLenum;\n    readonly TEXTURE_BINDING_2D_ARRAY: GLenum;\n    readonly TEXTURE_BINDING_3D: GLenum;\n    readonly TEXTURE_COMPARE_FUNC: GLenum;\n    readonly TEXTURE_COMPARE_MODE: GLenum;\n    readonly TEXTURE_IMMUTABLE_FORMAT: GLenum;\n    readonly TEXTURE_IMMUTABLE_LEVELS: GLenum;\n    readonly TEXTURE_MAX_LEVEL: GLenum;\n    readonly TEXTURE_MAX_LOD: GLenum;\n    readonly TEXTURE_MIN_LOD: GLenum;\n    readonly TEXTURE_WRAP_R: GLenum;\n    readonly TIMEOUT_EXPIRED: GLenum;\n    readonly TIMEOUT_IGNORED: GLint64;\n    readonly TRANSFORM_FEEDBACK: GLenum;\n    readonly TRANSFORM_FEEDBACK_ACTIVE: GLenum;\n    readonly TRANSFORM_FEEDBACK_BINDING: GLenum;\n    readonly TRANSFORM_FEEDBACK_BUFFER: GLenum;\n    readonly TRANSFORM_FEEDBACK_BUFFER_BINDING: GLenum;\n    readonly TRANSFORM_FEEDBACK_BUFFER_MODE: GLenum;\n    readonly TRANSFORM_FEEDBACK_BUFFER_SIZE: GLenum;\n    readonly TRANSFORM_FEEDBACK_BUFFER_START: GLenum;\n    readonly TRANSFORM_FEEDBACK_PAUSED: GLenum;\n    readonly TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN: GLenum;\n    readonly TRANSFORM_FEEDBACK_VARYINGS: GLenum;\n    readonly UNIFORM_ARRAY_STRIDE: GLenum;\n    readonly UNIFORM_BLOCK_ACTIVE_UNIFORMS: GLenum;\n    readonly UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES: GLenum;\n    readonly UNIFORM_BLOCK_BINDING: GLenum;\n    readonly UNIFORM_BLOCK_DATA_SIZE: GLenum;\n    readonly UNIFORM_BLOCK_INDEX: GLenum;\n    readonly UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER: GLenum;\n    readonly UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER: GLenum;\n    readonly UNIFORM_BUFFER: GLenum;\n    readonly UNIFORM_BUFFER_BINDING: GLenum;\n    readonly UNIFORM_BUFFER_OFFSET_ALIGNMENT: GLenum;\n    readonly UNIFORM_BUFFER_SIZE: GLenum;\n    readonly UNIFORM_BUFFER_START: GLenum;\n    readonly UNIFORM_IS_ROW_MAJOR: GLenum;\n    readonly UNIFORM_MATRIX_STRIDE: GLenum;\n    readonly UNIFORM_OFFSET: GLenum;\n    readonly UNIFORM_SIZE: GLenum;\n    readonly UNIFORM_TYPE: GLenum;\n    readonly UNPACK_IMAGE_HEIGHT: GLenum;\n    readonly UNPACK_ROW_LENGTH: GLenum;\n    readonly UNPACK_SKIP_IMAGES: GLenum;\n    readonly UNPACK_SKIP_PIXELS: GLenum;\n    readonly UNPACK_SKIP_ROWS: GLenum;\n    readonly UNSIGNALED: GLenum;\n    readonly UNSIGNED_INT_10F_11F_11F_REV: GLenum;\n    readonly UNSIGNED_INT_24_8: GLenum;\n    readonly UNSIGNED_INT_2_10_10_10_REV: GLenum;\n    readonly UNSIGNED_INT_5_9_9_9_REV: GLenum;\n    readonly UNSIGNED_INT_SAMPLER_2D: GLenum;\n    readonly UNSIGNED_INT_SAMPLER_2D_ARRAY: GLenum;\n    readonly UNSIGNED_INT_SAMPLER_3D: GLenum;\n    readonly UNSIGNED_INT_SAMPLER_CUBE: GLenum;\n    readonly UNSIGNED_INT_VEC2: GLenum;\n    readonly UNSIGNED_INT_VEC3: GLenum;\n    readonly UNSIGNED_INT_VEC4: GLenum;\n    readonly UNSIGNED_NORMALIZED: GLenum;\n    readonly VERTEX_ARRAY_BINDING: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_DIVISOR: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_INTEGER: GLenum;\n    readonly WAIT_FAILED: GLenum;\n};\n\ninterface WebGL2RenderingContextBase {\n    beginQuery(target: GLenum, query: WebGLQuery): void;\n    beginTransformFeedback(primitiveMode: GLenum): void;\n    bindBufferBase(target: GLenum, index: GLuint, buffer: WebGLBuffer | null): void;\n    bindBufferRange(target: GLenum, index: GLuint, buffer: WebGLBuffer | null, offset: GLintptr, size: GLsizeiptr): void;\n    bindSampler(unit: GLuint, sampler: WebGLSampler | null): void;\n    bindTransformFeedback(target: GLenum, tf: WebGLTransformFeedback | null): void;\n    bindVertexArray(array: WebGLVertexArrayObject | null): void;\n    blitFramebuffer(srcX0: GLint, srcY0: GLint, srcX1: GLint, srcY1: GLint, dstX0: GLint, dstY0: GLint, dstX1: GLint, dstY1: GLint, mask: GLbitfield, filter: GLenum): void;\n    clearBufferfi(buffer: GLenum, drawbuffer: GLint, depth: GLfloat, stencil: GLint): void;\n    clearBufferfv(buffer: GLenum, drawbuffer: GLint, values: Float32List, srcOffset?: GLuint): void;\n    clearBufferiv(buffer: GLenum, drawbuffer: GLint, values: Int32List, srcOffset?: GLuint): void;\n    clearBufferuiv(buffer: GLenum, drawbuffer: GLint, values: Uint32List, srcOffset?: GLuint): void;\n    clientWaitSync(sync: WebGLSync, flags: GLbitfield, timeout: GLuint64): GLenum;\n    compressedTexImage3D(target: GLenum, level: GLint, internalformat: GLenum, width: GLsizei, height: GLsizei, depth: GLsizei, border: GLint, imageSize: GLsizei, offset: GLintptr): void;\n    compressedTexImage3D(target: GLenum, level: GLint, internalformat: GLenum, width: GLsizei, height: GLsizei, depth: GLsizei, border: GLint, srcData: ArrayBufferView, srcOffset?: GLuint, srcLengthOverride?: GLuint): void;\n    compressedTexSubImage3D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, zoffset: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, format: GLenum, imageSize: GLsizei, offset: GLintptr): void;\n    compressedTexSubImage3D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, zoffset: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, format: GLenum, srcData: ArrayBufferView, srcOffset?: GLuint, srcLengthOverride?: GLuint): void;\n    copyBufferSubData(readTarget: GLenum, writeTarget: GLenum, readOffset: GLintptr, writeOffset: GLintptr, size: GLsizeiptr): void;\n    copyTexSubImage3D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, zoffset: GLint, x: GLint, y: GLint, width: GLsizei, height: GLsizei): void;\n    createQuery(): WebGLQuery | null;\n    createSampler(): WebGLSampler | null;\n    createTransformFeedback(): WebGLTransformFeedback | null;\n    createVertexArray(): WebGLVertexArrayObject | null;\n    deleteQuery(query: WebGLQuery | null): void;\n    deleteSampler(sampler: WebGLSampler | null): void;\n    deleteSync(sync: WebGLSync | null): void;\n    deleteTransformFeedback(tf: WebGLTransformFeedback | null): void;\n    deleteVertexArray(vertexArray: WebGLVertexArrayObject | null): void;\n    drawArraysInstanced(mode: GLenum, first: GLint, count: GLsizei, instanceCount: GLsizei): void;\n    drawBuffers(buffers: GLenum[]): void;\n    drawElementsInstanced(mode: GLenum, count: GLsizei, type: GLenum, offset: GLintptr, instanceCount: GLsizei): void;\n    drawRangeElements(mode: GLenum, start: GLuint, end: GLuint, count: GLsizei, type: GLenum, offset: GLintptr): void;\n    endQuery(target: GLenum): void;\n    endTransformFeedback(): void;\n    fenceSync(condition: GLenum, flags: GLbitfield): WebGLSync | null;\n    framebufferTextureLayer(target: GLenum, attachment: GLenum, texture: WebGLTexture | null, level: GLint, layer: GLint): void;\n    getActiveUniformBlockName(program: WebGLProgram, uniformBlockIndex: GLuint): string | null;\n    getActiveUniformBlockParameter(program: WebGLProgram, uniformBlockIndex: GLuint, pname: GLenum): any;\n    getActiveUniforms(program: WebGLProgram, uniformIndices: GLuint[], pname: GLenum): any;\n    getBufferSubData(target: GLenum, srcByteOffset: GLintptr, dstBuffer: ArrayBufferView, dstOffset?: GLuint, length?: GLuint): void;\n    getFragDataLocation(program: WebGLProgram, name: string): GLint;\n    getIndexedParameter(target: GLenum, index: GLuint): any;\n    getInternalformatParameter(target: GLenum, internalformat: GLenum, pname: GLenum): any;\n    getQuery(target: GLenum, pname: GLenum): WebGLQuery | null;\n    getQueryParameter(query: WebGLQuery, pname: GLenum): any;\n    getSamplerParameter(sampler: WebGLSampler, pname: GLenum): any;\n    getSyncParameter(sync: WebGLSync, pname: GLenum): any;\n    getTransformFeedbackVarying(program: WebGLProgram, index: GLuint): WebGLActiveInfo | null;\n    getUniformBlockIndex(program: WebGLProgram, uniformBlockName: string): GLuint;\n    getUniformIndices(program: WebGLProgram, uniformNames: string[]): GLuint[] | null;\n    invalidateFramebuffer(target: GLenum, attachments: GLenum[]): void;\n    invalidateSubFramebuffer(target: GLenum, attachments: GLenum[], x: GLint, y: GLint, width: GLsizei, height: GLsizei): void;\n    isQuery(query: WebGLQuery | null): GLboolean;\n    isSampler(sampler: WebGLSampler | null): GLboolean;\n    isSync(sync: WebGLSync | null): GLboolean;\n    isTransformFeedback(tf: WebGLTransformFeedback | null): GLboolean;\n    isVertexArray(vertexArray: WebGLVertexArrayObject | null): GLboolean;\n    pauseTransformFeedback(): void;\n    readBuffer(src: GLenum): void;\n    renderbufferStorageMultisample(target: GLenum, samples: GLsizei, internalformat: GLenum, width: GLsizei, height: GLsizei): void;\n    resumeTransformFeedback(): void;\n    samplerParameterf(sampler: WebGLSampler, pname: GLenum, param: GLfloat): void;\n    samplerParameteri(sampler: WebGLSampler, pname: GLenum, param: GLint): void;\n    texImage3D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, border: GLint, format: GLenum, type: GLenum, pboOffset: GLintptr): void;\n    texImage3D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, border: GLint, format: GLenum, type: GLenum, source: TexImageSource): void;\n    texImage3D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, border: GLint, format: GLenum, type: GLenum, srcData: ArrayBufferView | null): void;\n    texImage3D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, border: GLint, format: GLenum, type: GLenum, srcData: ArrayBufferView, srcOffset: GLuint): void;\n    texStorage2D(target: GLenum, levels: GLsizei, internalformat: GLenum, width: GLsizei, height: GLsizei): void;\n    texStorage3D(target: GLenum, levels: GLsizei, internalformat: GLenum, width: GLsizei, height: GLsizei, depth: GLsizei): void;\n    texSubImage3D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, zoffset: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, format: GLenum, type: GLenum, pboOffset: GLintptr): void;\n    texSubImage3D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, zoffset: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, format: GLenum, type: GLenum, source: TexImageSource): void;\n    texSubImage3D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, zoffset: GLint, width: GLsizei, height: GLsizei, depth: GLsizei, format: GLenum, type: GLenum, srcData: ArrayBufferView | null, srcOffset?: GLuint): void;\n    transformFeedbackVaryings(program: WebGLProgram, varyings: string[], bufferMode: GLenum): void;\n    uniform1ui(location: WebGLUniformLocation | null, v0: GLuint): void;\n    uniform1uiv(location: WebGLUniformLocation | null, data: Uint32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform2ui(location: WebGLUniformLocation | null, v0: GLuint, v1: GLuint): void;\n    uniform2uiv(location: WebGLUniformLocation | null, data: Uint32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform3ui(location: WebGLUniformLocation | null, v0: GLuint, v1: GLuint, v2: GLuint): void;\n    uniform3uiv(location: WebGLUniformLocation | null, data: Uint32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform4ui(location: WebGLUniformLocation | null, v0: GLuint, v1: GLuint, v2: GLuint, v3: GLuint): void;\n    uniform4uiv(location: WebGLUniformLocation | null, data: Uint32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformBlockBinding(program: WebGLProgram, uniformBlockIndex: GLuint, uniformBlockBinding: GLuint): void;\n    uniformMatrix2x3fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix2x4fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix3x2fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix3x4fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix4x2fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix4x3fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    vertexAttribDivisor(index: GLuint, divisor: GLuint): void;\n    vertexAttribI4i(index: GLuint, x: GLint, y: GLint, z: GLint, w: GLint): void;\n    vertexAttribI4iv(index: GLuint, values: Int32List): void;\n    vertexAttribI4ui(index: GLuint, x: GLuint, y: GLuint, z: GLuint, w: GLuint): void;\n    vertexAttribI4uiv(index: GLuint, values: Uint32List): void;\n    vertexAttribIPointer(index: GLuint, size: GLint, type: GLenum, stride: GLsizei, offset: GLintptr): void;\n    waitSync(sync: WebGLSync, flags: GLbitfield, timeout: GLint64): void;\n    readonly ACTIVE_UNIFORM_BLOCKS: GLenum;\n    readonly ALREADY_SIGNALED: GLenum;\n    readonly ANY_SAMPLES_PASSED: GLenum;\n    readonly ANY_SAMPLES_PASSED_CONSERVATIVE: GLenum;\n    readonly COLOR: GLenum;\n    readonly COLOR_ATTACHMENT1: GLenum;\n    readonly COLOR_ATTACHMENT10: GLenum;\n    readonly COLOR_ATTACHMENT11: GLenum;\n    readonly COLOR_ATTACHMENT12: GLenum;\n    readonly COLOR_ATTACHMENT13: GLenum;\n    readonly COLOR_ATTACHMENT14: GLenum;\n    readonly COLOR_ATTACHMENT15: GLenum;\n    readonly COLOR_ATTACHMENT2: GLenum;\n    readonly COLOR_ATTACHMENT3: GLenum;\n    readonly COLOR_ATTACHMENT4: GLenum;\n    readonly COLOR_ATTACHMENT5: GLenum;\n    readonly COLOR_ATTACHMENT6: GLenum;\n    readonly COLOR_ATTACHMENT7: GLenum;\n    readonly COLOR_ATTACHMENT8: GLenum;\n    readonly COLOR_ATTACHMENT9: GLenum;\n    readonly COMPARE_REF_TO_TEXTURE: GLenum;\n    readonly CONDITION_SATISFIED: GLenum;\n    readonly COPY_READ_BUFFER: GLenum;\n    readonly COPY_READ_BUFFER_BINDING: GLenum;\n    readonly COPY_WRITE_BUFFER: GLenum;\n    readonly COPY_WRITE_BUFFER_BINDING: GLenum;\n    readonly CURRENT_QUERY: GLenum;\n    readonly DEPTH: GLenum;\n    readonly DEPTH24_STENCIL8: GLenum;\n    readonly DEPTH32F_STENCIL8: GLenum;\n    readonly DEPTH_COMPONENT24: GLenum;\n    readonly DEPTH_COMPONENT32F: GLenum;\n    readonly DRAW_BUFFER0: GLenum;\n    readonly DRAW_BUFFER1: GLenum;\n    readonly DRAW_BUFFER10: GLenum;\n    readonly DRAW_BUFFER11: GLenum;\n    readonly DRAW_BUFFER12: GLenum;\n    readonly DRAW_BUFFER13: GLenum;\n    readonly DRAW_BUFFER14: GLenum;\n    readonly DRAW_BUFFER15: GLenum;\n    readonly DRAW_BUFFER2: GLenum;\n    readonly DRAW_BUFFER3: GLenum;\n    readonly DRAW_BUFFER4: GLenum;\n    readonly DRAW_BUFFER5: GLenum;\n    readonly DRAW_BUFFER6: GLenum;\n    readonly DRAW_BUFFER7: GLenum;\n    readonly DRAW_BUFFER8: GLenum;\n    readonly DRAW_BUFFER9: GLenum;\n    readonly DRAW_FRAMEBUFFER: GLenum;\n    readonly DRAW_FRAMEBUFFER_BINDING: GLenum;\n    readonly DYNAMIC_COPY: GLenum;\n    readonly DYNAMIC_READ: GLenum;\n    readonly FLOAT_32_UNSIGNED_INT_24_8_REV: GLenum;\n    readonly FLOAT_MAT2x3: GLenum;\n    readonly FLOAT_MAT2x4: GLenum;\n    readonly FLOAT_MAT3x2: GLenum;\n    readonly FLOAT_MAT3x4: GLenum;\n    readonly FLOAT_MAT4x2: GLenum;\n    readonly FLOAT_MAT4x3: GLenum;\n    readonly FRAGMENT_SHADER_DERIVATIVE_HINT: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_BLUE_SIZE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_GREEN_SIZE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_RED_SIZE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER: GLenum;\n    readonly FRAMEBUFFER_DEFAULT: GLenum;\n    readonly FRAMEBUFFER_INCOMPLETE_MULTISAMPLE: GLenum;\n    readonly HALF_FLOAT: GLenum;\n    readonly INTERLEAVED_ATTRIBS: GLenum;\n    readonly INT_2_10_10_10_REV: GLenum;\n    readonly INT_SAMPLER_2D: GLenum;\n    readonly INT_SAMPLER_2D_ARRAY: GLenum;\n    readonly INT_SAMPLER_3D: GLenum;\n    readonly INT_SAMPLER_CUBE: GLenum;\n    readonly INVALID_INDEX: GLenum;\n    readonly MAX: GLenum;\n    readonly MAX_3D_TEXTURE_SIZE: GLenum;\n    readonly MAX_ARRAY_TEXTURE_LAYERS: GLenum;\n    readonly MAX_CLIENT_WAIT_TIMEOUT_WEBGL: GLenum;\n    readonly MAX_COLOR_ATTACHMENTS: GLenum;\n    readonly MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS: GLenum;\n    readonly MAX_COMBINED_UNIFORM_BLOCKS: GLenum;\n    readonly MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS: GLenum;\n    readonly MAX_DRAW_BUFFERS: GLenum;\n    readonly MAX_ELEMENTS_INDICES: GLenum;\n    readonly MAX_ELEMENTS_VERTICES: GLenum;\n    readonly MAX_ELEMENT_INDEX: GLenum;\n    readonly MAX_FRAGMENT_INPUT_COMPONENTS: GLenum;\n    readonly MAX_FRAGMENT_UNIFORM_BLOCKS: GLenum;\n    readonly MAX_FRAGMENT_UNIFORM_COMPONENTS: GLenum;\n    readonly MAX_PROGRAM_TEXEL_OFFSET: GLenum;\n    readonly MAX_SAMPLES: GLenum;\n    readonly MAX_SERVER_WAIT_TIMEOUT: GLenum;\n    readonly MAX_TEXTURE_LOD_BIAS: GLenum;\n    readonly MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS: GLenum;\n    readonly MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS: GLenum;\n    readonly MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS: GLenum;\n    readonly MAX_UNIFORM_BLOCK_SIZE: GLenum;\n    readonly MAX_UNIFORM_BUFFER_BINDINGS: GLenum;\n    readonly MAX_VARYING_COMPONENTS: GLenum;\n    readonly MAX_VERTEX_OUTPUT_COMPONENTS: GLenum;\n    readonly MAX_VERTEX_UNIFORM_BLOCKS: GLenum;\n    readonly MAX_VERTEX_UNIFORM_COMPONENTS: GLenum;\n    readonly MIN: GLenum;\n    readonly MIN_PROGRAM_TEXEL_OFFSET: GLenum;\n    readonly OBJECT_TYPE: GLenum;\n    readonly PACK_ROW_LENGTH: GLenum;\n    readonly PACK_SKIP_PIXELS: GLenum;\n    readonly PACK_SKIP_ROWS: GLenum;\n    readonly PIXEL_PACK_BUFFER: GLenum;\n    readonly PIXEL_PACK_BUFFER_BINDING: GLenum;\n    readonly PIXEL_UNPACK_BUFFER: GLenum;\n    readonly PIXEL_UNPACK_BUFFER_BINDING: GLenum;\n    readonly QUERY_RESULT: GLenum;\n    readonly QUERY_RESULT_AVAILABLE: GLenum;\n    readonly R11F_G11F_B10F: GLenum;\n    readonly R16F: GLenum;\n    readonly R16I: GLenum;\n    readonly R16UI: GLenum;\n    readonly R32F: GLenum;\n    readonly R32I: GLenum;\n    readonly R32UI: GLenum;\n    readonly R8: GLenum;\n    readonly R8I: GLenum;\n    readonly R8UI: GLenum;\n    readonly R8_SNORM: GLenum;\n    readonly RASTERIZER_DISCARD: GLenum;\n    readonly READ_BUFFER: GLenum;\n    readonly READ_FRAMEBUFFER: GLenum;\n    readonly READ_FRAMEBUFFER_BINDING: GLenum;\n    readonly RED: GLenum;\n    readonly RED_INTEGER: GLenum;\n    readonly RENDERBUFFER_SAMPLES: GLenum;\n    readonly RG: GLenum;\n    readonly RG16F: GLenum;\n    readonly RG16I: GLenum;\n    readonly RG16UI: GLenum;\n    readonly RG32F: GLenum;\n    readonly RG32I: GLenum;\n    readonly RG32UI: GLenum;\n    readonly RG8: GLenum;\n    readonly RG8I: GLenum;\n    readonly RG8UI: GLenum;\n    readonly RG8_SNORM: GLenum;\n    readonly RGB10_A2: GLenum;\n    readonly RGB10_A2UI: GLenum;\n    readonly RGB16F: GLenum;\n    readonly RGB16I: GLenum;\n    readonly RGB16UI: GLenum;\n    readonly RGB32F: GLenum;\n    readonly RGB32I: GLenum;\n    readonly RGB32UI: GLenum;\n    readonly RGB8: GLenum;\n    readonly RGB8I: GLenum;\n    readonly RGB8UI: GLenum;\n    readonly RGB8_SNORM: GLenum;\n    readonly RGB9_E5: GLenum;\n    readonly RGBA16F: GLenum;\n    readonly RGBA16I: GLenum;\n    readonly RGBA16UI: GLenum;\n    readonly RGBA32F: GLenum;\n    readonly RGBA32I: GLenum;\n    readonly RGBA32UI: GLenum;\n    readonly RGBA8: GLenum;\n    readonly RGBA8I: GLenum;\n    readonly RGBA8UI: GLenum;\n    readonly RGBA8_SNORM: GLenum;\n    readonly RGBA_INTEGER: GLenum;\n    readonly RGB_INTEGER: GLenum;\n    readonly RG_INTEGER: GLenum;\n    readonly SAMPLER_2D_ARRAY: GLenum;\n    readonly SAMPLER_2D_ARRAY_SHADOW: GLenum;\n    readonly SAMPLER_2D_SHADOW: GLenum;\n    readonly SAMPLER_3D: GLenum;\n    readonly SAMPLER_BINDING: GLenum;\n    readonly SAMPLER_CUBE_SHADOW: GLenum;\n    readonly SEPARATE_ATTRIBS: GLenum;\n    readonly SIGNALED: GLenum;\n    readonly SIGNED_NORMALIZED: GLenum;\n    readonly SRGB: GLenum;\n    readonly SRGB8: GLenum;\n    readonly SRGB8_ALPHA8: GLenum;\n    readonly STATIC_COPY: GLenum;\n    readonly STATIC_READ: GLenum;\n    readonly STENCIL: GLenum;\n    readonly STREAM_COPY: GLenum;\n    readonly STREAM_READ: GLenum;\n    readonly SYNC_CONDITION: GLenum;\n    readonly SYNC_FENCE: GLenum;\n    readonly SYNC_FLAGS: GLenum;\n    readonly SYNC_FLUSH_COMMANDS_BIT: GLenum;\n    readonly SYNC_GPU_COMMANDS_COMPLETE: GLenum;\n    readonly SYNC_STATUS: GLenum;\n    readonly TEXTURE_2D_ARRAY: GLenum;\n    readonly TEXTURE_3D: GLenum;\n    readonly TEXTURE_BASE_LEVEL: GLenum;\n    readonly TEXTURE_BINDING_2D_ARRAY: GLenum;\n    readonly TEXTURE_BINDING_3D: GLenum;\n    readonly TEXTURE_COMPARE_FUNC: GLenum;\n    readonly TEXTURE_COMPARE_MODE: GLenum;\n    readonly TEXTURE_IMMUTABLE_FORMAT: GLenum;\n    readonly TEXTURE_IMMUTABLE_LEVELS: GLenum;\n    readonly TEXTURE_MAX_LEVEL: GLenum;\n    readonly TEXTURE_MAX_LOD: GLenum;\n    readonly TEXTURE_MIN_LOD: GLenum;\n    readonly TEXTURE_WRAP_R: GLenum;\n    readonly TIMEOUT_EXPIRED: GLenum;\n    readonly TIMEOUT_IGNORED: GLint64;\n    readonly TRANSFORM_FEEDBACK: GLenum;\n    readonly TRANSFORM_FEEDBACK_ACTIVE: GLenum;\n    readonly TRANSFORM_FEEDBACK_BINDING: GLenum;\n    readonly TRANSFORM_FEEDBACK_BUFFER: GLenum;\n    readonly TRANSFORM_FEEDBACK_BUFFER_BINDING: GLenum;\n    readonly TRANSFORM_FEEDBACK_BUFFER_MODE: GLenum;\n    readonly TRANSFORM_FEEDBACK_BUFFER_SIZE: GLenum;\n    readonly TRANSFORM_FEEDBACK_BUFFER_START: GLenum;\n    readonly TRANSFORM_FEEDBACK_PAUSED: GLenum;\n    readonly TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN: GLenum;\n    readonly TRANSFORM_FEEDBACK_VARYINGS: GLenum;\n    readonly UNIFORM_ARRAY_STRIDE: GLenum;\n    readonly UNIFORM_BLOCK_ACTIVE_UNIFORMS: GLenum;\n    readonly UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES: GLenum;\n    readonly UNIFORM_BLOCK_BINDING: GLenum;\n    readonly UNIFORM_BLOCK_DATA_SIZE: GLenum;\n    readonly UNIFORM_BLOCK_INDEX: GLenum;\n    readonly UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER: GLenum;\n    readonly UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER: GLenum;\n    readonly UNIFORM_BUFFER: GLenum;\n    readonly UNIFORM_BUFFER_BINDING: GLenum;\n    readonly UNIFORM_BUFFER_OFFSET_ALIGNMENT: GLenum;\n    readonly UNIFORM_BUFFER_SIZE: GLenum;\n    readonly UNIFORM_BUFFER_START: GLenum;\n    readonly UNIFORM_IS_ROW_MAJOR: GLenum;\n    readonly UNIFORM_MATRIX_STRIDE: GLenum;\n    readonly UNIFORM_OFFSET: GLenum;\n    readonly UNIFORM_SIZE: GLenum;\n    readonly UNIFORM_TYPE: GLenum;\n    readonly UNPACK_IMAGE_HEIGHT: GLenum;\n    readonly UNPACK_ROW_LENGTH: GLenum;\n    readonly UNPACK_SKIP_IMAGES: GLenum;\n    readonly UNPACK_SKIP_PIXELS: GLenum;\n    readonly UNPACK_SKIP_ROWS: GLenum;\n    readonly UNSIGNALED: GLenum;\n    readonly UNSIGNED_INT_10F_11F_11F_REV: GLenum;\n    readonly UNSIGNED_INT_24_8: GLenum;\n    readonly UNSIGNED_INT_2_10_10_10_REV: GLenum;\n    readonly UNSIGNED_INT_5_9_9_9_REV: GLenum;\n    readonly UNSIGNED_INT_SAMPLER_2D: GLenum;\n    readonly UNSIGNED_INT_SAMPLER_2D_ARRAY: GLenum;\n    readonly UNSIGNED_INT_SAMPLER_3D: GLenum;\n    readonly UNSIGNED_INT_SAMPLER_CUBE: GLenum;\n    readonly UNSIGNED_INT_VEC2: GLenum;\n    readonly UNSIGNED_INT_VEC3: GLenum;\n    readonly UNSIGNED_INT_VEC4: GLenum;\n    readonly UNSIGNED_NORMALIZED: GLenum;\n    readonly VERTEX_ARRAY_BINDING: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_DIVISOR: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_INTEGER: GLenum;\n    readonly WAIT_FAILED: GLenum;\n}\n\ninterface WebGL2RenderingContextOverloads {\n    bufferData(target: GLenum, size: GLsizeiptr, usage: GLenum): void;\n    bufferData(target: GLenum, srcData: BufferSource | null, usage: GLenum): void;\n    bufferData(target: GLenum, srcData: ArrayBufferView, usage: GLenum, srcOffset: GLuint, length?: GLuint): void;\n    bufferSubData(target: GLenum, dstByteOffset: GLintptr, srcData: BufferSource): void;\n    bufferSubData(target: GLenum, dstByteOffset: GLintptr, srcData: ArrayBufferView, srcOffset: GLuint, length?: GLuint): void;\n    compressedTexImage2D(target: GLenum, level: GLint, internalformat: GLenum, width: GLsizei, height: GLsizei, border: GLint, imageSize: GLsizei, offset: GLintptr): void;\n    compressedTexImage2D(target: GLenum, level: GLint, internalformat: GLenum, width: GLsizei, height: GLsizei, border: GLint, srcData: ArrayBufferView, srcOffset?: GLuint, srcLengthOverride?: GLuint): void;\n    compressedTexSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, imageSize: GLsizei, offset: GLintptr): void;\n    compressedTexSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, srcData: ArrayBufferView, srcOffset?: GLuint, srcLengthOverride?: GLuint): void;\n    readPixels(x: GLint, y: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, dstData: ArrayBufferView | null): void;\n    readPixels(x: GLint, y: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, offset: GLintptr): void;\n    readPixels(x: GLint, y: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, dstData: ArrayBufferView, dstOffset: GLuint): void;\n    texImage2D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, border: GLint, format: GLenum, type: GLenum, pixels: ArrayBufferView | null): void;\n    texImage2D(target: GLenum, level: GLint, internalformat: GLint, format: GLenum, type: GLenum, source: TexImageSource): void;\n    texImage2D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, border: GLint, format: GLenum, type: GLenum, pboOffset: GLintptr): void;\n    texImage2D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, border: GLint, format: GLenum, type: GLenum, source: TexImageSource): void;\n    texImage2D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, border: GLint, format: GLenum, type: GLenum, srcData: ArrayBufferView, srcOffset: GLuint): void;\n    texSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, pixels: ArrayBufferView | null): void;\n    texSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, format: GLenum, type: GLenum, source: TexImageSource): void;\n    texSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, pboOffset: GLintptr): void;\n    texSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, source: TexImageSource): void;\n    texSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, srcData: ArrayBufferView, srcOffset: GLuint): void;\n    uniform1fv(location: WebGLUniformLocation | null, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform1iv(location: WebGLUniformLocation | null, data: Int32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform2fv(location: WebGLUniformLocation | null, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform2iv(location: WebGLUniformLocation | null, data: Int32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform3fv(location: WebGLUniformLocation | null, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform3iv(location: WebGLUniformLocation | null, data: Int32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform4fv(location: WebGLUniformLocation | null, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform4iv(location: WebGLUniformLocation | null, data: Int32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix2fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix3fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix4fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Float32List, srcOffset?: GLuint, srcLength?: GLuint): void;\n}\n\n/** Part of the WebGL API and represents the information returned by calling the WebGLRenderingContext.getActiveAttrib() and WebGLRenderingContext.getActiveUniform() methods. */\ninterface WebGLActiveInfo {\n    readonly name: string;\n    readonly size: GLint;\n    readonly type: GLenum;\n}\n\ndeclare var WebGLActiveInfo: {\n    prototype: WebGLActiveInfo;\n    new(): WebGLActiveInfo;\n};\n\n/** Part of the WebGL API and represents an opaque buffer object storing data such as vertices or colors. */\ninterface WebGLBuffer extends WebGLObject {\n}\n\ndeclare var WebGLBuffer: {\n    prototype: WebGLBuffer;\n    new(): WebGLBuffer;\n};\n\n/** The WebContextEvent interface is part of the WebGL API and is an interface for an event that is generated in response to a status change to the WebGL rendering context. */\ninterface WebGLContextEvent extends Event {\n    readonly statusMessage: string;\n}\n\ndeclare var WebGLContextEvent: {\n    prototype: WebGLContextEvent;\n    new(type: string, eventInit?: WebGLContextEventInit): WebGLContextEvent;\n};\n\n/** Part of the WebGL API and represents a collection of buffers that serve as a rendering destination. */\ninterface WebGLFramebuffer extends WebGLObject {\n}\n\ndeclare var WebGLFramebuffer: {\n    prototype: WebGLFramebuffer;\n    new(): WebGLFramebuffer;\n};\n\ninterface WebGLObject {\n}\n\ndeclare var WebGLObject: {\n    prototype: WebGLObject;\n    new(): WebGLObject;\n};\n\n/** The WebGLProgram is part of the WebGL API and is a combination of two compiled WebGLShaders consisting of a vertex shader and a fragment shader (both written in GLSL). */\ninterface WebGLProgram extends WebGLObject {\n}\n\ndeclare var WebGLProgram: {\n    prototype: WebGLProgram;\n    new(): WebGLProgram;\n};\n\ninterface WebGLQuery extends WebGLObject {\n}\n\ndeclare var WebGLQuery: {\n    prototype: WebGLQuery;\n    new(): WebGLQuery;\n};\n\n/** Part of the WebGL API and represents a buffer that can contain an image, or can be source or target of an rendering operation. */\ninterface WebGLRenderbuffer extends WebGLObject {\n}\n\ndeclare var WebGLRenderbuffer: {\n    prototype: WebGLRenderbuffer;\n    new(): WebGLRenderbuffer;\n};\n\n/** Provides an interface to the OpenGL ES 2.0 graphics rendering context for the drawing surface of an HTML <canvas> element. */\ninterface WebGLRenderingContext extends WebGLRenderingContextBase, WebGLRenderingContextOverloads {\n}\n\ndeclare var WebGLRenderingContext: {\n    prototype: WebGLRenderingContext;\n    new(): WebGLRenderingContext;\n    readonly ACTIVE_ATTRIBUTES: GLenum;\n    readonly ACTIVE_TEXTURE: GLenum;\n    readonly ACTIVE_UNIFORMS: GLenum;\n    readonly ALIASED_LINE_WIDTH_RANGE: GLenum;\n    readonly ALIASED_POINT_SIZE_RANGE: GLenum;\n    readonly ALPHA: GLenum;\n    readonly ALPHA_BITS: GLenum;\n    readonly ALWAYS: GLenum;\n    readonly ARRAY_BUFFER: GLenum;\n    readonly ARRAY_BUFFER_BINDING: GLenum;\n    readonly ATTACHED_SHADERS: GLenum;\n    readonly BACK: GLenum;\n    readonly BLEND: GLenum;\n    readonly BLEND_COLOR: GLenum;\n    readonly BLEND_DST_ALPHA: GLenum;\n    readonly BLEND_DST_RGB: GLenum;\n    readonly BLEND_EQUATION: GLenum;\n    readonly BLEND_EQUATION_ALPHA: GLenum;\n    readonly BLEND_EQUATION_RGB: GLenum;\n    readonly BLEND_SRC_ALPHA: GLenum;\n    readonly BLEND_SRC_RGB: GLenum;\n    readonly BLUE_BITS: GLenum;\n    readonly BOOL: GLenum;\n    readonly BOOL_VEC2: GLenum;\n    readonly BOOL_VEC3: GLenum;\n    readonly BOOL_VEC4: GLenum;\n    readonly BROWSER_DEFAULT_WEBGL: GLenum;\n    readonly BUFFER_SIZE: GLenum;\n    readonly BUFFER_USAGE: GLenum;\n    readonly BYTE: GLenum;\n    readonly CCW: GLenum;\n    readonly CLAMP_TO_EDGE: GLenum;\n    readonly COLOR_ATTACHMENT0: GLenum;\n    readonly COLOR_BUFFER_BIT: GLenum;\n    readonly COLOR_CLEAR_VALUE: GLenum;\n    readonly COLOR_WRITEMASK: GLenum;\n    readonly COMPILE_STATUS: GLenum;\n    readonly COMPRESSED_TEXTURE_FORMATS: GLenum;\n    readonly CONSTANT_ALPHA: GLenum;\n    readonly CONSTANT_COLOR: GLenum;\n    readonly CONTEXT_LOST_WEBGL: GLenum;\n    readonly CULL_FACE: GLenum;\n    readonly CULL_FACE_MODE: GLenum;\n    readonly CURRENT_PROGRAM: GLenum;\n    readonly CURRENT_VERTEX_ATTRIB: GLenum;\n    readonly CW: GLenum;\n    readonly DECR: GLenum;\n    readonly DECR_WRAP: GLenum;\n    readonly DELETE_STATUS: GLenum;\n    readonly DEPTH_ATTACHMENT: GLenum;\n    readonly DEPTH_BITS: GLenum;\n    readonly DEPTH_BUFFER_BIT: GLenum;\n    readonly DEPTH_CLEAR_VALUE: GLenum;\n    readonly DEPTH_COMPONENT: GLenum;\n    readonly DEPTH_COMPONENT16: GLenum;\n    readonly DEPTH_FUNC: GLenum;\n    readonly DEPTH_RANGE: GLenum;\n    readonly DEPTH_STENCIL: GLenum;\n    readonly DEPTH_STENCIL_ATTACHMENT: GLenum;\n    readonly DEPTH_TEST: GLenum;\n    readonly DEPTH_WRITEMASK: GLenum;\n    readonly DITHER: GLenum;\n    readonly DONT_CARE: GLenum;\n    readonly DST_ALPHA: GLenum;\n    readonly DST_COLOR: GLenum;\n    readonly DYNAMIC_DRAW: GLenum;\n    readonly ELEMENT_ARRAY_BUFFER: GLenum;\n    readonly ELEMENT_ARRAY_BUFFER_BINDING: GLenum;\n    readonly EQUAL: GLenum;\n    readonly FASTEST: GLenum;\n    readonly FLOAT: GLenum;\n    readonly FLOAT_MAT2: GLenum;\n    readonly FLOAT_MAT3: GLenum;\n    readonly FLOAT_MAT4: GLenum;\n    readonly FLOAT_VEC2: GLenum;\n    readonly FLOAT_VEC3: GLenum;\n    readonly FLOAT_VEC4: GLenum;\n    readonly FRAGMENT_SHADER: GLenum;\n    readonly FRAMEBUFFER: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: GLenum;\n    readonly FRAMEBUFFER_BINDING: GLenum;\n    readonly FRAMEBUFFER_COMPLETE: GLenum;\n    readonly FRAMEBUFFER_INCOMPLETE_ATTACHMENT: GLenum;\n    readonly FRAMEBUFFER_INCOMPLETE_DIMENSIONS: GLenum;\n    readonly FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: GLenum;\n    readonly FRAMEBUFFER_UNSUPPORTED: GLenum;\n    readonly FRONT: GLenum;\n    readonly FRONT_AND_BACK: GLenum;\n    readonly FRONT_FACE: GLenum;\n    readonly FUNC_ADD: GLenum;\n    readonly FUNC_REVERSE_SUBTRACT: GLenum;\n    readonly FUNC_SUBTRACT: GLenum;\n    readonly GENERATE_MIPMAP_HINT: GLenum;\n    readonly GEQUAL: GLenum;\n    readonly GREATER: GLenum;\n    readonly GREEN_BITS: GLenum;\n    readonly HIGH_FLOAT: GLenum;\n    readonly HIGH_INT: GLenum;\n    readonly IMPLEMENTATION_COLOR_READ_FORMAT: GLenum;\n    readonly IMPLEMENTATION_COLOR_READ_TYPE: GLenum;\n    readonly INCR: GLenum;\n    readonly INCR_WRAP: GLenum;\n    readonly INT: GLenum;\n    readonly INT_VEC2: GLenum;\n    readonly INT_VEC3: GLenum;\n    readonly INT_VEC4: GLenum;\n    readonly INVALID_ENUM: GLenum;\n    readonly INVALID_FRAMEBUFFER_OPERATION: GLenum;\n    readonly INVALID_OPERATION: GLenum;\n    readonly INVALID_VALUE: GLenum;\n    readonly INVERT: GLenum;\n    readonly KEEP: GLenum;\n    readonly LEQUAL: GLenum;\n    readonly LESS: GLenum;\n    readonly LINEAR: GLenum;\n    readonly LINEAR_MIPMAP_LINEAR: GLenum;\n    readonly LINEAR_MIPMAP_NEAREST: GLenum;\n    readonly LINES: GLenum;\n    readonly LINE_LOOP: GLenum;\n    readonly LINE_STRIP: GLenum;\n    readonly LINE_WIDTH: GLenum;\n    readonly LINK_STATUS: GLenum;\n    readonly LOW_FLOAT: GLenum;\n    readonly LOW_INT: GLenum;\n    readonly LUMINANCE: GLenum;\n    readonly LUMINANCE_ALPHA: GLenum;\n    readonly MAX_COMBINED_TEXTURE_IMAGE_UNITS: GLenum;\n    readonly MAX_CUBE_MAP_TEXTURE_SIZE: GLenum;\n    readonly MAX_FRAGMENT_UNIFORM_VECTORS: GLenum;\n    readonly MAX_RENDERBUFFER_SIZE: GLenum;\n    readonly MAX_TEXTURE_IMAGE_UNITS: GLenum;\n    readonly MAX_TEXTURE_SIZE: GLenum;\n    readonly MAX_VARYING_VECTORS: GLenum;\n    readonly MAX_VERTEX_ATTRIBS: GLenum;\n    readonly MAX_VERTEX_TEXTURE_IMAGE_UNITS: GLenum;\n    readonly MAX_VERTEX_UNIFORM_VECTORS: GLenum;\n    readonly MAX_VIEWPORT_DIMS: GLenum;\n    readonly MEDIUM_FLOAT: GLenum;\n    readonly MEDIUM_INT: GLenum;\n    readonly MIRRORED_REPEAT: GLenum;\n    readonly NEAREST: GLenum;\n    readonly NEAREST_MIPMAP_LINEAR: GLenum;\n    readonly NEAREST_MIPMAP_NEAREST: GLenum;\n    readonly NEVER: GLenum;\n    readonly NICEST: GLenum;\n    readonly NONE: GLenum;\n    readonly NOTEQUAL: GLenum;\n    readonly NO_ERROR: GLenum;\n    readonly ONE: GLenum;\n    readonly ONE_MINUS_CONSTANT_ALPHA: GLenum;\n    readonly ONE_MINUS_CONSTANT_COLOR: GLenum;\n    readonly ONE_MINUS_DST_ALPHA: GLenum;\n    readonly ONE_MINUS_DST_COLOR: GLenum;\n    readonly ONE_MINUS_SRC_ALPHA: GLenum;\n    readonly ONE_MINUS_SRC_COLOR: GLenum;\n    readonly OUT_OF_MEMORY: GLenum;\n    readonly PACK_ALIGNMENT: GLenum;\n    readonly POINTS: GLenum;\n    readonly POLYGON_OFFSET_FACTOR: GLenum;\n    readonly POLYGON_OFFSET_FILL: GLenum;\n    readonly POLYGON_OFFSET_UNITS: GLenum;\n    readonly RED_BITS: GLenum;\n    readonly RENDERBUFFER: GLenum;\n    readonly RENDERBUFFER_ALPHA_SIZE: GLenum;\n    readonly RENDERBUFFER_BINDING: GLenum;\n    readonly RENDERBUFFER_BLUE_SIZE: GLenum;\n    readonly RENDERBUFFER_DEPTH_SIZE: GLenum;\n    readonly RENDERBUFFER_GREEN_SIZE: GLenum;\n    readonly RENDERBUFFER_HEIGHT: GLenum;\n    readonly RENDERBUFFER_INTERNAL_FORMAT: GLenum;\n    readonly RENDERBUFFER_RED_SIZE: GLenum;\n    readonly RENDERBUFFER_STENCIL_SIZE: GLenum;\n    readonly RENDERBUFFER_WIDTH: GLenum;\n    readonly RENDERER: GLenum;\n    readonly REPEAT: GLenum;\n    readonly REPLACE: GLenum;\n    readonly RGB: GLenum;\n    readonly RGB565: GLenum;\n    readonly RGB5_A1: GLenum;\n    readonly RGBA: GLenum;\n    readonly RGBA4: GLenum;\n    readonly SAMPLER_2D: GLenum;\n    readonly SAMPLER_CUBE: GLenum;\n    readonly SAMPLES: GLenum;\n    readonly SAMPLE_ALPHA_TO_COVERAGE: GLenum;\n    readonly SAMPLE_BUFFERS: GLenum;\n    readonly SAMPLE_COVERAGE: GLenum;\n    readonly SAMPLE_COVERAGE_INVERT: GLenum;\n    readonly SAMPLE_COVERAGE_VALUE: GLenum;\n    readonly SCISSOR_BOX: GLenum;\n    readonly SCISSOR_TEST: GLenum;\n    readonly SHADER_TYPE: GLenum;\n    readonly SHADING_LANGUAGE_VERSION: GLenum;\n    readonly SHORT: GLenum;\n    readonly SRC_ALPHA: GLenum;\n    readonly SRC_ALPHA_SATURATE: GLenum;\n    readonly SRC_COLOR: GLenum;\n    readonly STATIC_DRAW: GLenum;\n    readonly STENCIL_ATTACHMENT: GLenum;\n    readonly STENCIL_BACK_FAIL: GLenum;\n    readonly STENCIL_BACK_FUNC: GLenum;\n    readonly STENCIL_BACK_PASS_DEPTH_FAIL: GLenum;\n    readonly STENCIL_BACK_PASS_DEPTH_PASS: GLenum;\n    readonly STENCIL_BACK_REF: GLenum;\n    readonly STENCIL_BACK_VALUE_MASK: GLenum;\n    readonly STENCIL_BACK_WRITEMASK: GLenum;\n    readonly STENCIL_BITS: GLenum;\n    readonly STENCIL_BUFFER_BIT: GLenum;\n    readonly STENCIL_CLEAR_VALUE: GLenum;\n    readonly STENCIL_FAIL: GLenum;\n    readonly STENCIL_FUNC: GLenum;\n    readonly STENCIL_INDEX8: GLenum;\n    readonly STENCIL_PASS_DEPTH_FAIL: GLenum;\n    readonly STENCIL_PASS_DEPTH_PASS: GLenum;\n    readonly STENCIL_REF: GLenum;\n    readonly STENCIL_TEST: GLenum;\n    readonly STENCIL_VALUE_MASK: GLenum;\n    readonly STENCIL_WRITEMASK: GLenum;\n    readonly STREAM_DRAW: GLenum;\n    readonly SUBPIXEL_BITS: GLenum;\n    readonly TEXTURE: GLenum;\n    readonly TEXTURE0: GLenum;\n    readonly TEXTURE1: GLenum;\n    readonly TEXTURE10: GLenum;\n    readonly TEXTURE11: GLenum;\n    readonly TEXTURE12: GLenum;\n    readonly TEXTURE13: GLenum;\n    readonly TEXTURE14: GLenum;\n    readonly TEXTURE15: GLenum;\n    readonly TEXTURE16: GLenum;\n    readonly TEXTURE17: GLenum;\n    readonly TEXTURE18: GLenum;\n    readonly TEXTURE19: GLenum;\n    readonly TEXTURE2: GLenum;\n    readonly TEXTURE20: GLenum;\n    readonly TEXTURE21: GLenum;\n    readonly TEXTURE22: GLenum;\n    readonly TEXTURE23: GLenum;\n    readonly TEXTURE24: GLenum;\n    readonly TEXTURE25: GLenum;\n    readonly TEXTURE26: GLenum;\n    readonly TEXTURE27: GLenum;\n    readonly TEXTURE28: GLenum;\n    readonly TEXTURE29: GLenum;\n    readonly TEXTURE3: GLenum;\n    readonly TEXTURE30: GLenum;\n    readonly TEXTURE31: GLenum;\n    readonly TEXTURE4: GLenum;\n    readonly TEXTURE5: GLenum;\n    readonly TEXTURE6: GLenum;\n    readonly TEXTURE7: GLenum;\n    readonly TEXTURE8: GLenum;\n    readonly TEXTURE9: GLenum;\n    readonly TEXTURE_2D: GLenum;\n    readonly TEXTURE_BINDING_2D: GLenum;\n    readonly TEXTURE_BINDING_CUBE_MAP: GLenum;\n    readonly TEXTURE_CUBE_MAP: GLenum;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_X: GLenum;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Y: GLenum;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Z: GLenum;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_X: GLenum;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Y: GLenum;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Z: GLenum;\n    readonly TEXTURE_MAG_FILTER: GLenum;\n    readonly TEXTURE_MIN_FILTER: GLenum;\n    readonly TEXTURE_WRAP_S: GLenum;\n    readonly TEXTURE_WRAP_T: GLenum;\n    readonly TRIANGLES: GLenum;\n    readonly TRIANGLE_FAN: GLenum;\n    readonly TRIANGLE_STRIP: GLenum;\n    readonly UNPACK_ALIGNMENT: GLenum;\n    readonly UNPACK_COLORSPACE_CONVERSION_WEBGL: GLenum;\n    readonly UNPACK_FLIP_Y_WEBGL: GLenum;\n    readonly UNPACK_PREMULTIPLY_ALPHA_WEBGL: GLenum;\n    readonly UNSIGNED_BYTE: GLenum;\n    readonly UNSIGNED_INT: GLenum;\n    readonly UNSIGNED_SHORT: GLenum;\n    readonly UNSIGNED_SHORT_4_4_4_4: GLenum;\n    readonly UNSIGNED_SHORT_5_5_5_1: GLenum;\n    readonly UNSIGNED_SHORT_5_6_5: GLenum;\n    readonly VALIDATE_STATUS: GLenum;\n    readonly VENDOR: GLenum;\n    readonly VERSION: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_ENABLED: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_NORMALIZED: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_POINTER: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_SIZE: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_STRIDE: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_TYPE: GLenum;\n    readonly VERTEX_SHADER: GLenum;\n    readonly VIEWPORT: GLenum;\n    readonly ZERO: GLenum;\n};\n\ninterface WebGLRenderingContextBase {\n    readonly canvas: HTMLCanvasElement | OffscreenCanvas;\n    readonly drawingBufferHeight: GLsizei;\n    readonly drawingBufferWidth: GLsizei;\n    activeTexture(texture: GLenum): void;\n    attachShader(program: WebGLProgram, shader: WebGLShader): void;\n    bindAttribLocation(program: WebGLProgram, index: GLuint, name: string): void;\n    bindBuffer(target: GLenum, buffer: WebGLBuffer | null): void;\n    bindFramebuffer(target: GLenum, framebuffer: WebGLFramebuffer | null): void;\n    bindRenderbuffer(target: GLenum, renderbuffer: WebGLRenderbuffer | null): void;\n    bindTexture(target: GLenum, texture: WebGLTexture | null): void;\n    blendColor(red: GLclampf, green: GLclampf, blue: GLclampf, alpha: GLclampf): void;\n    blendEquation(mode: GLenum): void;\n    blendEquationSeparate(modeRGB: GLenum, modeAlpha: GLenum): void;\n    blendFunc(sfactor: GLenum, dfactor: GLenum): void;\n    blendFuncSeparate(srcRGB: GLenum, dstRGB: GLenum, srcAlpha: GLenum, dstAlpha: GLenum): void;\n    checkFramebufferStatus(target: GLenum): GLenum;\n    clear(mask: GLbitfield): void;\n    clearColor(red: GLclampf, green: GLclampf, blue: GLclampf, alpha: GLclampf): void;\n    clearDepth(depth: GLclampf): void;\n    clearStencil(s: GLint): void;\n    colorMask(red: GLboolean, green: GLboolean, blue: GLboolean, alpha: GLboolean): void;\n    compileShader(shader: WebGLShader): void;\n    copyTexImage2D(target: GLenum, level: GLint, internalformat: GLenum, x: GLint, y: GLint, width: GLsizei, height: GLsizei, border: GLint): void;\n    copyTexSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, x: GLint, y: GLint, width: GLsizei, height: GLsizei): void;\n    createBuffer(): WebGLBuffer | null;\n    createFramebuffer(): WebGLFramebuffer | null;\n    createProgram(): WebGLProgram | null;\n    createRenderbuffer(): WebGLRenderbuffer | null;\n    createShader(type: GLenum): WebGLShader | null;\n    createTexture(): WebGLTexture | null;\n    cullFace(mode: GLenum): void;\n    deleteBuffer(buffer: WebGLBuffer | null): void;\n    deleteFramebuffer(framebuffer: WebGLFramebuffer | null): void;\n    deleteProgram(program: WebGLProgram | null): void;\n    deleteRenderbuffer(renderbuffer: WebGLRenderbuffer | null): void;\n    deleteShader(shader: WebGLShader | null): void;\n    deleteTexture(texture: WebGLTexture | null): void;\n    depthFunc(func: GLenum): void;\n    depthMask(flag: GLboolean): void;\n    depthRange(zNear: GLclampf, zFar: GLclampf): void;\n    detachShader(program: WebGLProgram, shader: WebGLShader): void;\n    disable(cap: GLenum): void;\n    disableVertexAttribArray(index: GLuint): void;\n    drawArrays(mode: GLenum, first: GLint, count: GLsizei): void;\n    drawElements(mode: GLenum, count: GLsizei, type: GLenum, offset: GLintptr): void;\n    enable(cap: GLenum): void;\n    enableVertexAttribArray(index: GLuint): void;\n    finish(): void;\n    flush(): void;\n    framebufferRenderbuffer(target: GLenum, attachment: GLenum, renderbuffertarget: GLenum, renderbuffer: WebGLRenderbuffer | null): void;\n    framebufferTexture2D(target: GLenum, attachment: GLenum, textarget: GLenum, texture: WebGLTexture | null, level: GLint): void;\n    frontFace(mode: GLenum): void;\n    generateMipmap(target: GLenum): void;\n    getActiveAttrib(program: WebGLProgram, index: GLuint): WebGLActiveInfo | null;\n    getActiveUniform(program: WebGLProgram, index: GLuint): WebGLActiveInfo | null;\n    getAttachedShaders(program: WebGLProgram): WebGLShader[] | null;\n    getAttribLocation(program: WebGLProgram, name: string): GLint;\n    getBufferParameter(target: GLenum, pname: GLenum): any;\n    getContextAttributes(): WebGLContextAttributes | null;\n    getError(): GLenum;\n    getExtension(extensionName: \"EXT_blend_minmax\"): EXT_blend_minmax | null;\n    getExtension(extensionName: \"EXT_texture_filter_anisotropic\"): EXT_texture_filter_anisotropic | null;\n    getExtension(extensionName: \"EXT_frag_depth\"): EXT_frag_depth | null;\n    getExtension(extensionName: \"EXT_shader_texture_lod\"): EXT_shader_texture_lod | null;\n    getExtension(extensionName: \"EXT_sRGB\"): EXT_sRGB | null;\n    getExtension(extensionName: \"OES_vertex_array_object\"): OES_vertex_array_object | null;\n    getExtension(extensionName: \"WEBGL_color_buffer_float\"): WEBGL_color_buffer_float | null;\n    getExtension(extensionName: \"WEBGL_compressed_texture_astc\"): WEBGL_compressed_texture_astc | null;\n    getExtension(extensionName: \"WEBGL_compressed_texture_s3tc_srgb\"): WEBGL_compressed_texture_s3tc_srgb | null;\n    getExtension(extensionName: \"WEBGL_debug_shaders\"): WEBGL_debug_shaders | null;\n    getExtension(extensionName: \"WEBGL_draw_buffers\"): WEBGL_draw_buffers | null;\n    getExtension(extensionName: \"WEBGL_lose_context\"): WEBGL_lose_context | null;\n    getExtension(extensionName: \"WEBGL_depth_texture\"): WEBGL_depth_texture | null;\n    getExtension(extensionName: \"WEBGL_debug_renderer_info\"): WEBGL_debug_renderer_info | null;\n    getExtension(extensionName: \"WEBGL_compressed_texture_s3tc\"): WEBGL_compressed_texture_s3tc | null;\n    getExtension(extensionName: \"OES_texture_half_float_linear\"): OES_texture_half_float_linear | null;\n    getExtension(extensionName: \"OES_texture_half_float\"): OES_texture_half_float | null;\n    getExtension(extensionName: \"OES_texture_float_linear\"): OES_texture_float_linear | null;\n    getExtension(extensionName: \"OES_texture_float\"): OES_texture_float | null;\n    getExtension(extensionName: \"OES_standard_derivatives\"): OES_standard_derivatives | null;\n    getExtension(extensionName: \"OES_element_index_uint\"): OES_element_index_uint | null;\n    getExtension(extensionName: \"ANGLE_instanced_arrays\"): ANGLE_instanced_arrays | null;\n    getExtension(extensionName: string): any;\n    getFramebufferAttachmentParameter(target: GLenum, attachment: GLenum, pname: GLenum): any;\n    getParameter(pname: GLenum): any;\n    getProgramInfoLog(program: WebGLProgram): string | null;\n    getProgramParameter(program: WebGLProgram, pname: GLenum): any;\n    getRenderbufferParameter(target: GLenum, pname: GLenum): any;\n    getShaderInfoLog(shader: WebGLShader): string | null;\n    getShaderParameter(shader: WebGLShader, pname: GLenum): any;\n    getShaderPrecisionFormat(shadertype: GLenum, precisiontype: GLenum): WebGLShaderPrecisionFormat | null;\n    getShaderSource(shader: WebGLShader): string | null;\n    getSupportedExtensions(): string[] | null;\n    getTexParameter(target: GLenum, pname: GLenum): any;\n    getUniform(program: WebGLProgram, location: WebGLUniformLocation): any;\n    getUniformLocation(program: WebGLProgram, name: string): WebGLUniformLocation | null;\n    getVertexAttrib(index: GLuint, pname: GLenum): any;\n    getVertexAttribOffset(index: GLuint, pname: GLenum): GLintptr;\n    hint(target: GLenum, mode: GLenum): void;\n    isBuffer(buffer: WebGLBuffer | null): GLboolean;\n    isContextLost(): boolean;\n    isEnabled(cap: GLenum): GLboolean;\n    isFramebuffer(framebuffer: WebGLFramebuffer | null): GLboolean;\n    isProgram(program: WebGLProgram | null): GLboolean;\n    isRenderbuffer(renderbuffer: WebGLRenderbuffer | null): GLboolean;\n    isShader(shader: WebGLShader | null): GLboolean;\n    isTexture(texture: WebGLTexture | null): GLboolean;\n    lineWidth(width: GLfloat): void;\n    linkProgram(program: WebGLProgram): void;\n    pixelStorei(pname: GLenum, param: GLint | GLboolean): void;\n    polygonOffset(factor: GLfloat, units: GLfloat): void;\n    renderbufferStorage(target: GLenum, internalformat: GLenum, width: GLsizei, height: GLsizei): void;\n    sampleCoverage(value: GLclampf, invert: GLboolean): void;\n    scissor(x: GLint, y: GLint, width: GLsizei, height: GLsizei): void;\n    shaderSource(shader: WebGLShader, source: string): void;\n    stencilFunc(func: GLenum, ref: GLint, mask: GLuint): void;\n    stencilFuncSeparate(face: GLenum, func: GLenum, ref: GLint, mask: GLuint): void;\n    stencilMask(mask: GLuint): void;\n    stencilMaskSeparate(face: GLenum, mask: GLuint): void;\n    stencilOp(fail: GLenum, zfail: GLenum, zpass: GLenum): void;\n    stencilOpSeparate(face: GLenum, fail: GLenum, zfail: GLenum, zpass: GLenum): void;\n    texParameterf(target: GLenum, pname: GLenum, param: GLfloat): void;\n    texParameteri(target: GLenum, pname: GLenum, param: GLint): void;\n    uniform1f(location: WebGLUniformLocation | null, x: GLfloat): void;\n    uniform1i(location: WebGLUniformLocation | null, x: GLint): void;\n    uniform2f(location: WebGLUniformLocation | null, x: GLfloat, y: GLfloat): void;\n    uniform2i(location: WebGLUniformLocation | null, x: GLint, y: GLint): void;\n    uniform3f(location: WebGLUniformLocation | null, x: GLfloat, y: GLfloat, z: GLfloat): void;\n    uniform3i(location: WebGLUniformLocation | null, x: GLint, y: GLint, z: GLint): void;\n    uniform4f(location: WebGLUniformLocation | null, x: GLfloat, y: GLfloat, z: GLfloat, w: GLfloat): void;\n    uniform4i(location: WebGLUniformLocation | null, x: GLint, y: GLint, z: GLint, w: GLint): void;\n    useProgram(program: WebGLProgram | null): void;\n    validateProgram(program: WebGLProgram): void;\n    vertexAttrib1f(index: GLuint, x: GLfloat): void;\n    vertexAttrib1fv(index: GLuint, values: Float32List): void;\n    vertexAttrib2f(index: GLuint, x: GLfloat, y: GLfloat): void;\n    vertexAttrib2fv(index: GLuint, values: Float32List): void;\n    vertexAttrib3f(index: GLuint, x: GLfloat, y: GLfloat, z: GLfloat): void;\n    vertexAttrib3fv(index: GLuint, values: Float32List): void;\n    vertexAttrib4f(index: GLuint, x: GLfloat, y: GLfloat, z: GLfloat, w: GLfloat): void;\n    vertexAttrib4fv(index: GLuint, values: Float32List): void;\n    vertexAttribPointer(index: GLuint, size: GLint, type: GLenum, normalized: GLboolean, stride: GLsizei, offset: GLintptr): void;\n    viewport(x: GLint, y: GLint, width: GLsizei, height: GLsizei): void;\n    readonly ACTIVE_ATTRIBUTES: GLenum;\n    readonly ACTIVE_TEXTURE: GLenum;\n    readonly ACTIVE_UNIFORMS: GLenum;\n    readonly ALIASED_LINE_WIDTH_RANGE: GLenum;\n    readonly ALIASED_POINT_SIZE_RANGE: GLenum;\n    readonly ALPHA: GLenum;\n    readonly ALPHA_BITS: GLenum;\n    readonly ALWAYS: GLenum;\n    readonly ARRAY_BUFFER: GLenum;\n    readonly ARRAY_BUFFER_BINDING: GLenum;\n    readonly ATTACHED_SHADERS: GLenum;\n    readonly BACK: GLenum;\n    readonly BLEND: GLenum;\n    readonly BLEND_COLOR: GLenum;\n    readonly BLEND_DST_ALPHA: GLenum;\n    readonly BLEND_DST_RGB: GLenum;\n    readonly BLEND_EQUATION: GLenum;\n    readonly BLEND_EQUATION_ALPHA: GLenum;\n    readonly BLEND_EQUATION_RGB: GLenum;\n    readonly BLEND_SRC_ALPHA: GLenum;\n    readonly BLEND_SRC_RGB: GLenum;\n    readonly BLUE_BITS: GLenum;\n    readonly BOOL: GLenum;\n    readonly BOOL_VEC2: GLenum;\n    readonly BOOL_VEC3: GLenum;\n    readonly BOOL_VEC4: GLenum;\n    readonly BROWSER_DEFAULT_WEBGL: GLenum;\n    readonly BUFFER_SIZE: GLenum;\n    readonly BUFFER_USAGE: GLenum;\n    readonly BYTE: GLenum;\n    readonly CCW: GLenum;\n    readonly CLAMP_TO_EDGE: GLenum;\n    readonly COLOR_ATTACHMENT0: GLenum;\n    readonly COLOR_BUFFER_BIT: GLenum;\n    readonly COLOR_CLEAR_VALUE: GLenum;\n    readonly COLOR_WRITEMASK: GLenum;\n    readonly COMPILE_STATUS: GLenum;\n    readonly COMPRESSED_TEXTURE_FORMATS: GLenum;\n    readonly CONSTANT_ALPHA: GLenum;\n    readonly CONSTANT_COLOR: GLenum;\n    readonly CONTEXT_LOST_WEBGL: GLenum;\n    readonly CULL_FACE: GLenum;\n    readonly CULL_FACE_MODE: GLenum;\n    readonly CURRENT_PROGRAM: GLenum;\n    readonly CURRENT_VERTEX_ATTRIB: GLenum;\n    readonly CW: GLenum;\n    readonly DECR: GLenum;\n    readonly DECR_WRAP: GLenum;\n    readonly DELETE_STATUS: GLenum;\n    readonly DEPTH_ATTACHMENT: GLenum;\n    readonly DEPTH_BITS: GLenum;\n    readonly DEPTH_BUFFER_BIT: GLenum;\n    readonly DEPTH_CLEAR_VALUE: GLenum;\n    readonly DEPTH_COMPONENT: GLenum;\n    readonly DEPTH_COMPONENT16: GLenum;\n    readonly DEPTH_FUNC: GLenum;\n    readonly DEPTH_RANGE: GLenum;\n    readonly DEPTH_STENCIL: GLenum;\n    readonly DEPTH_STENCIL_ATTACHMENT: GLenum;\n    readonly DEPTH_TEST: GLenum;\n    readonly DEPTH_WRITEMASK: GLenum;\n    readonly DITHER: GLenum;\n    readonly DONT_CARE: GLenum;\n    readonly DST_ALPHA: GLenum;\n    readonly DST_COLOR: GLenum;\n    readonly DYNAMIC_DRAW: GLenum;\n    readonly ELEMENT_ARRAY_BUFFER: GLenum;\n    readonly ELEMENT_ARRAY_BUFFER_BINDING: GLenum;\n    readonly EQUAL: GLenum;\n    readonly FASTEST: GLenum;\n    readonly FLOAT: GLenum;\n    readonly FLOAT_MAT2: GLenum;\n    readonly FLOAT_MAT3: GLenum;\n    readonly FLOAT_MAT4: GLenum;\n    readonly FLOAT_VEC2: GLenum;\n    readonly FLOAT_VEC3: GLenum;\n    readonly FLOAT_VEC4: GLenum;\n    readonly FRAGMENT_SHADER: GLenum;\n    readonly FRAMEBUFFER: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: GLenum;\n    readonly FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: GLenum;\n    readonly FRAMEBUFFER_BINDING: GLenum;\n    readonly FRAMEBUFFER_COMPLETE: GLenum;\n    readonly FRAMEBUFFER_INCOMPLETE_ATTACHMENT: GLenum;\n    readonly FRAMEBUFFER_INCOMPLETE_DIMENSIONS: GLenum;\n    readonly FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: GLenum;\n    readonly FRAMEBUFFER_UNSUPPORTED: GLenum;\n    readonly FRONT: GLenum;\n    readonly FRONT_AND_BACK: GLenum;\n    readonly FRONT_FACE: GLenum;\n    readonly FUNC_ADD: GLenum;\n    readonly FUNC_REVERSE_SUBTRACT: GLenum;\n    readonly FUNC_SUBTRACT: GLenum;\n    readonly GENERATE_MIPMAP_HINT: GLenum;\n    readonly GEQUAL: GLenum;\n    readonly GREATER: GLenum;\n    readonly GREEN_BITS: GLenum;\n    readonly HIGH_FLOAT: GLenum;\n    readonly HIGH_INT: GLenum;\n    readonly IMPLEMENTATION_COLOR_READ_FORMAT: GLenum;\n    readonly IMPLEMENTATION_COLOR_READ_TYPE: GLenum;\n    readonly INCR: GLenum;\n    readonly INCR_WRAP: GLenum;\n    readonly INT: GLenum;\n    readonly INT_VEC2: GLenum;\n    readonly INT_VEC3: GLenum;\n    readonly INT_VEC4: GLenum;\n    readonly INVALID_ENUM: GLenum;\n    readonly INVALID_FRAMEBUFFER_OPERATION: GLenum;\n    readonly INVALID_OPERATION: GLenum;\n    readonly INVALID_VALUE: GLenum;\n    readonly INVERT: GLenum;\n    readonly KEEP: GLenum;\n    readonly LEQUAL: GLenum;\n    readonly LESS: GLenum;\n    readonly LINEAR: GLenum;\n    readonly LINEAR_MIPMAP_LINEAR: GLenum;\n    readonly LINEAR_MIPMAP_NEAREST: GLenum;\n    readonly LINES: GLenum;\n    readonly LINE_LOOP: GLenum;\n    readonly LINE_STRIP: GLenum;\n    readonly LINE_WIDTH: GLenum;\n    readonly LINK_STATUS: GLenum;\n    readonly LOW_FLOAT: GLenum;\n    readonly LOW_INT: GLenum;\n    readonly LUMINANCE: GLenum;\n    readonly LUMINANCE_ALPHA: GLenum;\n    readonly MAX_COMBINED_TEXTURE_IMAGE_UNITS: GLenum;\n    readonly MAX_CUBE_MAP_TEXTURE_SIZE: GLenum;\n    readonly MAX_FRAGMENT_UNIFORM_VECTORS: GLenum;\n    readonly MAX_RENDERBUFFER_SIZE: GLenum;\n    readonly MAX_TEXTURE_IMAGE_UNITS: GLenum;\n    readonly MAX_TEXTURE_SIZE: GLenum;\n    readonly MAX_VARYING_VECTORS: GLenum;\n    readonly MAX_VERTEX_ATTRIBS: GLenum;\n    readonly MAX_VERTEX_TEXTURE_IMAGE_UNITS: GLenum;\n    readonly MAX_VERTEX_UNIFORM_VECTORS: GLenum;\n    readonly MAX_VIEWPORT_DIMS: GLenum;\n    readonly MEDIUM_FLOAT: GLenum;\n    readonly MEDIUM_INT: GLenum;\n    readonly MIRRORED_REPEAT: GLenum;\n    readonly NEAREST: GLenum;\n    readonly NEAREST_MIPMAP_LINEAR: GLenum;\n    readonly NEAREST_MIPMAP_NEAREST: GLenum;\n    readonly NEVER: GLenum;\n    readonly NICEST: GLenum;\n    readonly NONE: GLenum;\n    readonly NOTEQUAL: GLenum;\n    readonly NO_ERROR: GLenum;\n    readonly ONE: GLenum;\n    readonly ONE_MINUS_CONSTANT_ALPHA: GLenum;\n    readonly ONE_MINUS_CONSTANT_COLOR: GLenum;\n    readonly ONE_MINUS_DST_ALPHA: GLenum;\n    readonly ONE_MINUS_DST_COLOR: GLenum;\n    readonly ONE_MINUS_SRC_ALPHA: GLenum;\n    readonly ONE_MINUS_SRC_COLOR: GLenum;\n    readonly OUT_OF_MEMORY: GLenum;\n    readonly PACK_ALIGNMENT: GLenum;\n    readonly POINTS: GLenum;\n    readonly POLYGON_OFFSET_FACTOR: GLenum;\n    readonly POLYGON_OFFSET_FILL: GLenum;\n    readonly POLYGON_OFFSET_UNITS: GLenum;\n    readonly RED_BITS: GLenum;\n    readonly RENDERBUFFER: GLenum;\n    readonly RENDERBUFFER_ALPHA_SIZE: GLenum;\n    readonly RENDERBUFFER_BINDING: GLenum;\n    readonly RENDERBUFFER_BLUE_SIZE: GLenum;\n    readonly RENDERBUFFER_DEPTH_SIZE: GLenum;\n    readonly RENDERBUFFER_GREEN_SIZE: GLenum;\n    readonly RENDERBUFFER_HEIGHT: GLenum;\n    readonly RENDERBUFFER_INTERNAL_FORMAT: GLenum;\n    readonly RENDERBUFFER_RED_SIZE: GLenum;\n    readonly RENDERBUFFER_STENCIL_SIZE: GLenum;\n    readonly RENDERBUFFER_WIDTH: GLenum;\n    readonly RENDERER: GLenum;\n    readonly REPEAT: GLenum;\n    readonly REPLACE: GLenum;\n    readonly RGB: GLenum;\n    readonly RGB565: GLenum;\n    readonly RGB5_A1: GLenum;\n    readonly RGBA: GLenum;\n    readonly RGBA4: GLenum;\n    readonly SAMPLER_2D: GLenum;\n    readonly SAMPLER_CUBE: GLenum;\n    readonly SAMPLES: GLenum;\n    readonly SAMPLE_ALPHA_TO_COVERAGE: GLenum;\n    readonly SAMPLE_BUFFERS: GLenum;\n    readonly SAMPLE_COVERAGE: GLenum;\n    readonly SAMPLE_COVERAGE_INVERT: GLenum;\n    readonly SAMPLE_COVERAGE_VALUE: GLenum;\n    readonly SCISSOR_BOX: GLenum;\n    readonly SCISSOR_TEST: GLenum;\n    readonly SHADER_TYPE: GLenum;\n    readonly SHADING_LANGUAGE_VERSION: GLenum;\n    readonly SHORT: GLenum;\n    readonly SRC_ALPHA: GLenum;\n    readonly SRC_ALPHA_SATURATE: GLenum;\n    readonly SRC_COLOR: GLenum;\n    readonly STATIC_DRAW: GLenum;\n    readonly STENCIL_ATTACHMENT: GLenum;\n    readonly STENCIL_BACK_FAIL: GLenum;\n    readonly STENCIL_BACK_FUNC: GLenum;\n    readonly STENCIL_BACK_PASS_DEPTH_FAIL: GLenum;\n    readonly STENCIL_BACK_PASS_DEPTH_PASS: GLenum;\n    readonly STENCIL_BACK_REF: GLenum;\n    readonly STENCIL_BACK_VALUE_MASK: GLenum;\n    readonly STENCIL_BACK_WRITEMASK: GLenum;\n    readonly STENCIL_BITS: GLenum;\n    readonly STENCIL_BUFFER_BIT: GLenum;\n    readonly STENCIL_CLEAR_VALUE: GLenum;\n    readonly STENCIL_FAIL: GLenum;\n    readonly STENCIL_FUNC: GLenum;\n    readonly STENCIL_INDEX8: GLenum;\n    readonly STENCIL_PASS_DEPTH_FAIL: GLenum;\n    readonly STENCIL_PASS_DEPTH_PASS: GLenum;\n    readonly STENCIL_REF: GLenum;\n    readonly STENCIL_TEST: GLenum;\n    readonly STENCIL_VALUE_MASK: GLenum;\n    readonly STENCIL_WRITEMASK: GLenum;\n    readonly STREAM_DRAW: GLenum;\n    readonly SUBPIXEL_BITS: GLenum;\n    readonly TEXTURE: GLenum;\n    readonly TEXTURE0: GLenum;\n    readonly TEXTURE1: GLenum;\n    readonly TEXTURE10: GLenum;\n    readonly TEXTURE11: GLenum;\n    readonly TEXTURE12: GLenum;\n    readonly TEXTURE13: GLenum;\n    readonly TEXTURE14: GLenum;\n    readonly TEXTURE15: GLenum;\n    readonly TEXTURE16: GLenum;\n    readonly TEXTURE17: GLenum;\n    readonly TEXTURE18: GLenum;\n    readonly TEXTURE19: GLenum;\n    readonly TEXTURE2: GLenum;\n    readonly TEXTURE20: GLenum;\n    readonly TEXTURE21: GLenum;\n    readonly TEXTURE22: GLenum;\n    readonly TEXTURE23: GLenum;\n    readonly TEXTURE24: GLenum;\n    readonly TEXTURE25: GLenum;\n    readonly TEXTURE26: GLenum;\n    readonly TEXTURE27: GLenum;\n    readonly TEXTURE28: GLenum;\n    readonly TEXTURE29: GLenum;\n    readonly TEXTURE3: GLenum;\n    readonly TEXTURE30: GLenum;\n    readonly TEXTURE31: GLenum;\n    readonly TEXTURE4: GLenum;\n    readonly TEXTURE5: GLenum;\n    readonly TEXTURE6: GLenum;\n    readonly TEXTURE7: GLenum;\n    readonly TEXTURE8: GLenum;\n    readonly TEXTURE9: GLenum;\n    readonly TEXTURE_2D: GLenum;\n    readonly TEXTURE_BINDING_2D: GLenum;\n    readonly TEXTURE_BINDING_CUBE_MAP: GLenum;\n    readonly TEXTURE_CUBE_MAP: GLenum;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_X: GLenum;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Y: GLenum;\n    readonly TEXTURE_CUBE_MAP_NEGATIVE_Z: GLenum;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_X: GLenum;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Y: GLenum;\n    readonly TEXTURE_CUBE_MAP_POSITIVE_Z: GLenum;\n    readonly TEXTURE_MAG_FILTER: GLenum;\n    readonly TEXTURE_MIN_FILTER: GLenum;\n    readonly TEXTURE_WRAP_S: GLenum;\n    readonly TEXTURE_WRAP_T: GLenum;\n    readonly TRIANGLES: GLenum;\n    readonly TRIANGLE_FAN: GLenum;\n    readonly TRIANGLE_STRIP: GLenum;\n    readonly UNPACK_ALIGNMENT: GLenum;\n    readonly UNPACK_COLORSPACE_CONVERSION_WEBGL: GLenum;\n    readonly UNPACK_FLIP_Y_WEBGL: GLenum;\n    readonly UNPACK_PREMULTIPLY_ALPHA_WEBGL: GLenum;\n    readonly UNSIGNED_BYTE: GLenum;\n    readonly UNSIGNED_INT: GLenum;\n    readonly UNSIGNED_SHORT: GLenum;\n    readonly UNSIGNED_SHORT_4_4_4_4: GLenum;\n    readonly UNSIGNED_SHORT_5_5_5_1: GLenum;\n    readonly UNSIGNED_SHORT_5_6_5: GLenum;\n    readonly VALIDATE_STATUS: GLenum;\n    readonly VENDOR: GLenum;\n    readonly VERSION: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_ENABLED: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_NORMALIZED: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_POINTER: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_SIZE: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_STRIDE: GLenum;\n    readonly VERTEX_ATTRIB_ARRAY_TYPE: GLenum;\n    readonly VERTEX_SHADER: GLenum;\n    readonly VIEWPORT: GLenum;\n    readonly ZERO: GLenum;\n}\n\ninterface WebGLRenderingContextOverloads {\n    bufferData(target: GLenum, size: GLsizeiptr, usage: GLenum): void;\n    bufferData(target: GLenum, data: BufferSource | null, usage: GLenum): void;\n    bufferSubData(target: GLenum, offset: GLintptr, data: BufferSource): void;\n    compressedTexImage2D(target: GLenum, level: GLint, internalformat: GLenum, width: GLsizei, height: GLsizei, border: GLint, data: ArrayBufferView): void;\n    compressedTexSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, data: ArrayBufferView): void;\n    readPixels(x: GLint, y: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, pixels: ArrayBufferView | null): void;\n    texImage2D(target: GLenum, level: GLint, internalformat: GLint, width: GLsizei, height: GLsizei, border: GLint, format: GLenum, type: GLenum, pixels: ArrayBufferView | null): void;\n    texImage2D(target: GLenum, level: GLint, internalformat: GLint, format: GLenum, type: GLenum, source: TexImageSource): void;\n    texSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, width: GLsizei, height: GLsizei, format: GLenum, type: GLenum, pixels: ArrayBufferView | null): void;\n    texSubImage2D(target: GLenum, level: GLint, xoffset: GLint, yoffset: GLint, format: GLenum, type: GLenum, source: TexImageSource): void;\n    uniform1fv(location: WebGLUniformLocation | null, v: Float32List): void;\n    uniform1iv(location: WebGLUniformLocation | null, v: Int32List): void;\n    uniform2fv(location: WebGLUniformLocation | null, v: Float32List): void;\n    uniform2iv(location: WebGLUniformLocation | null, v: Int32List): void;\n    uniform3fv(location: WebGLUniformLocation | null, v: Float32List): void;\n    uniform3iv(location: WebGLUniformLocation | null, v: Int32List): void;\n    uniform4fv(location: WebGLUniformLocation | null, v: Float32List): void;\n    uniform4iv(location: WebGLUniformLocation | null, v: Int32List): void;\n    uniformMatrix2fv(location: WebGLUniformLocation | null, transpose: GLboolean, value: Float32List): void;\n    uniformMatrix3fv(location: WebGLUniformLocation | null, transpose: GLboolean, value: Float32List): void;\n    uniformMatrix4fv(location: WebGLUniformLocation | null, transpose: GLboolean, value: Float32List): void;\n}\n\ninterface WebGLSampler extends WebGLObject {\n}\n\ndeclare var WebGLSampler: {\n    prototype: WebGLSampler;\n    new(): WebGLSampler;\n};\n\n/** The WebGLShader is part of the WebGL API and can either be a vertex or a fragment shader. A WebGLProgram requires both types of shaders. */\ninterface WebGLShader extends WebGLObject {\n}\n\ndeclare var WebGLShader: {\n    prototype: WebGLShader;\n    new(): WebGLShader;\n};\n\n/** Part of the WebGL API and represents the information returned by calling the WebGLRenderingContext.getShaderPrecisionFormat() method. */\ninterface WebGLShaderPrecisionFormat {\n    readonly precision: GLint;\n    readonly rangeMax: GLint;\n    readonly rangeMin: GLint;\n}\n\ndeclare var WebGLShaderPrecisionFormat: {\n    prototype: WebGLShaderPrecisionFormat;\n    new(): WebGLShaderPrecisionFormat;\n};\n\ninterface WebGLSync extends WebGLObject {\n}\n\ndeclare var WebGLSync: {\n    prototype: WebGLSync;\n    new(): WebGLSync;\n};\n\n/** Part of the WebGL API and represents an opaque texture object providing storage and state for texturing operations. */\ninterface WebGLTexture extends WebGLObject {\n}\n\ndeclare var WebGLTexture: {\n    prototype: WebGLTexture;\n    new(): WebGLTexture;\n};\n\ninterface WebGLTransformFeedback extends WebGLObject {\n}\n\ndeclare var WebGLTransformFeedback: {\n    prototype: WebGLTransformFeedback;\n    new(): WebGLTransformFeedback;\n};\n\n/** Part of the WebGL API and represents the location of a uniform variable in a shader program. */\ninterface WebGLUniformLocation {\n}\n\ndeclare var WebGLUniformLocation: {\n    prototype: WebGLUniformLocation;\n    new(): WebGLUniformLocation;\n};\n\ninterface WebGLVertexArrayObject extends WebGLObject {\n}\n\ndeclare var WebGLVertexArrayObject: {\n    prototype: WebGLVertexArrayObject;\n    new(): WebGLVertexArrayObject;\n};\n\ninterface WebGLVertexArrayObjectOES extends WebGLObject {\n}\n\ninterface WebKitPoint {\n    x: number;\n    y: number;\n}\n\ndeclare var WebKitPoint: {\n    prototype: WebKitPoint;\n    new(x?: number, y?: number): WebKitPoint;\n};\n\ninterface WebSocketEventMap {\n    \"close\": CloseEvent;\n    \"error\": Event;\n    \"message\": MessageEvent;\n    \"open\": Event;\n}\n\n/** Provides the API for creating and managing a WebSocket connection to a server, as well as for sending and receiving data on the connection. */\ninterface WebSocket extends EventTarget {\n    /**\n     * Returns a string that indicates how binary data from the WebSocket object is exposed to scripts:\n     * \n     * Can be set, to change how binary data is returned. The default is \"blob\".\n     */\n    binaryType: BinaryType;\n    /**\n     * Returns the number of bytes of application data (UTF-8 text and binary data) that have been queued using send() but not yet been transmitted to the network.\n     * \n     * If the WebSocket connection is closed, this attribute's value will only increase with each call to the send() method. (The number does not reset to zero once the connection closes.)\n     */\n    readonly bufferedAmount: number;\n    /**\n     * Returns the extensions selected by the server, if any.\n     */\n    readonly extensions: string;\n    onclose: ((this: WebSocket, ev: CloseEvent) => any) | null;\n    onerror: ((this: WebSocket, ev: Event) => any) | null;\n    onmessage: ((this: WebSocket, ev: MessageEvent) => any) | null;\n    onopen: ((this: WebSocket, ev: Event) => any) | null;\n    /**\n     * Returns the subprotocol selected by the server, if any. It can be used in conjunction with the array form of the constructor's second argument to perform subprotocol negotiation.\n     */\n    readonly protocol: string;\n    /**\n     * Returns the state of the WebSocket object's connection. It can have the values described below.\n     */\n    readonly readyState: number;\n    /**\n     * Returns the URL that was used to establish the WebSocket connection.\n     */\n    readonly url: string;\n    /**\n     * Closes the WebSocket connection, optionally using code as the the WebSocket connection close code and reason as the the WebSocket connection close reason.\n     */\n    close(code?: number, reason?: string): void;\n    /**\n     * Transmits data using the WebSocket connection. data can be a string, a Blob, an ArrayBuffer, or an ArrayBufferView.\n     */\n    send(data: string | ArrayBufferLike | Blob | ArrayBufferView): void;\n    readonly CLOSED: number;\n    readonly CLOSING: number;\n    readonly CONNECTING: number;\n    readonly OPEN: number;\n    addEventListener<K extends keyof WebSocketEventMap>(type: K, listener: (this: WebSocket, ev: WebSocketEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof WebSocketEventMap>(type: K, listener: (this: WebSocket, ev: WebSocketEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var WebSocket: {\n    prototype: WebSocket;\n    new(url: string, protocols?: string | string[]): WebSocket;\n    readonly CLOSED: number;\n    readonly CLOSING: number;\n    readonly CONNECTING: number;\n    readonly OPEN: number;\n};\n\n/** Events that occur due to the user moving a mouse wheel or similar input device. */\ninterface WheelEvent extends MouseEvent {\n    readonly deltaMode: number;\n    readonly deltaX: number;\n    readonly deltaY: number;\n    readonly deltaZ: number;\n    readonly DOM_DELTA_LINE: number;\n    readonly DOM_DELTA_PAGE: number;\n    readonly DOM_DELTA_PIXEL: number;\n}\n\ndeclare var WheelEvent: {\n    prototype: WheelEvent;\n    new(type: string, eventInitDict?: WheelEventInit): WheelEvent;\n    readonly DOM_DELTA_LINE: number;\n    readonly DOM_DELTA_PAGE: number;\n    readonly DOM_DELTA_PIXEL: number;\n};\n\ninterface WindowEventMap extends GlobalEventHandlersEventMap, WindowEventHandlersEventMap {\n    \"abort\": UIEvent;\n    \"afterprint\": Event;\n    \"beforeprint\": Event;\n    \"beforeunload\": BeforeUnloadEvent;\n    \"blur\": FocusEvent;\n    \"canplay\": Event;\n    \"canplaythrough\": Event;\n    \"change\": Event;\n    \"click\": MouseEvent;\n    \"compassneedscalibration\": Event;\n    \"contextmenu\": MouseEvent;\n    \"dblclick\": MouseEvent;\n    \"devicelight\": DeviceLightEvent;\n    \"devicemotion\": DeviceMotionEvent;\n    \"deviceorientation\": DeviceOrientationEvent;\n    \"deviceorientationabsolute\": DeviceOrientationEvent;\n    \"drag\": DragEvent;\n    \"dragend\": DragEvent;\n    \"dragenter\": DragEvent;\n    \"dragleave\": DragEvent;\n    \"dragover\": DragEvent;\n    \"dragstart\": DragEvent;\n    \"drop\": DragEvent;\n    \"durationchange\": Event;\n    \"emptied\": Event;\n    \"ended\": Event;\n    \"error\": ErrorEvent;\n    \"focus\": FocusEvent;\n    \"hashchange\": HashChangeEvent;\n    \"input\": Event;\n    \"invalid\": Event;\n    \"keydown\": KeyboardEvent;\n    \"keypress\": KeyboardEvent;\n    \"keyup\": KeyboardEvent;\n    \"load\": Event;\n    \"loadeddata\": Event;\n    \"loadedmetadata\": Event;\n    \"loadstart\": Event;\n    \"message\": MessageEvent;\n    \"mousedown\": MouseEvent;\n    \"mouseenter\": MouseEvent;\n    \"mouseleave\": MouseEvent;\n    \"mousemove\": MouseEvent;\n    \"mouseout\": MouseEvent;\n    \"mouseover\": MouseEvent;\n    \"mouseup\": MouseEvent;\n    \"mousewheel\": Event;\n    \"MSGestureChange\": Event;\n    \"MSGestureDoubleTap\": Event;\n    \"MSGestureEnd\": Event;\n    \"MSGestureHold\": Event;\n    \"MSGestureStart\": Event;\n    \"MSGestureTap\": Event;\n    \"MSInertiaStart\": Event;\n    \"MSPointerCancel\": Event;\n    \"MSPointerDown\": Event;\n    \"MSPointerEnter\": Event;\n    \"MSPointerLeave\": Event;\n    \"MSPointerMove\": Event;\n    \"MSPointerOut\": Event;\n    \"MSPointerOver\": Event;\n    \"MSPointerUp\": Event;\n    \"offline\": Event;\n    \"online\": Event;\n    \"orientationchange\": Event;\n    \"pagehide\": PageTransitionEvent;\n    \"pageshow\": PageTransitionEvent;\n    \"pause\": Event;\n    \"play\": Event;\n    \"playing\": Event;\n    \"popstate\": PopStateEvent;\n    \"progress\": ProgressEvent<Window>;\n    \"ratechange\": Event;\n    \"readystatechange\": ProgressEvent<Window>;\n    \"reset\": Event;\n    \"resize\": UIEvent;\n    \"scroll\": Event;\n    \"seeked\": Event;\n    \"seeking\": Event;\n    \"select\": Event;\n    \"stalled\": Event;\n    \"storage\": StorageEvent;\n    \"submit\": Event;\n    \"suspend\": Event;\n    \"timeupdate\": Event;\n    \"unload\": Event;\n    \"volumechange\": Event;\n    \"vrdisplayactivate\": Event;\n    \"vrdisplayblur\": Event;\n    \"vrdisplayconnect\": Event;\n    \"vrdisplaydeactivate\": Event;\n    \"vrdisplaydisconnect\": Event;\n    \"vrdisplayfocus\": Event;\n    \"vrdisplaypointerrestricted\": Event;\n    \"vrdisplaypointerunrestricted\": Event;\n    \"vrdisplaypresentchange\": Event;\n    \"waiting\": Event;\n}\n\n/** A window containing a DOM document; the document property points to the DOM document loaded in that window. */\ninterface Window extends EventTarget, AnimationFrameProvider, GlobalEventHandlers, WindowEventHandlers, WindowLocalStorage, WindowOrWorkerGlobalScope, WindowSessionStorage {\n    readonly applicationCache: ApplicationCache;\n    readonly clientInformation: Navigator;\n    readonly closed: boolean;\n    customElements: CustomElementRegistry;\n    defaultStatus: string;\n    readonly devicePixelRatio: number;\n    readonly doNotTrack: string;\n    readonly document: Document;\n    /** @deprecated */\n    readonly event: Event | undefined;\n    /** @deprecated */\n    readonly external: External;\n    readonly frameElement: Element;\n    readonly frames: Window;\n    readonly history: History;\n    readonly innerHeight: number;\n    readonly innerWidth: number;\n    readonly length: number;\n    location: Location;\n    readonly locationbar: BarProp;\n    readonly menubar: BarProp;\n    readonly msContentScript: ExtensionScriptApis;\n    name: string;\n    readonly navigator: Navigator;\n    offscreenBuffering: string | boolean;\n    oncompassneedscalibration: ((this: Window, ev: Event) => any) | null;\n    ondevicelight: ((this: Window, ev: DeviceLightEvent) => any) | null;\n    ondevicemotion: ((this: Window, ev: DeviceMotionEvent) => any) | null;\n    ondeviceorientation: ((this: Window, ev: DeviceOrientationEvent) => any) | null;\n    ondeviceorientationabsolute: ((this: Window, ev: DeviceOrientationEvent) => any) | null;\n    onmousewheel: ((this: Window, ev: Event) => any) | null;\n    onmsgesturechange: ((this: Window, ev: Event) => any) | null;\n    onmsgesturedoubletap: ((this: Window, ev: Event) => any) | null;\n    onmsgestureend: ((this: Window, ev: Event) => any) | null;\n    onmsgesturehold: ((this: Window, ev: Event) => any) | null;\n    onmsgesturestart: ((this: Window, ev: Event) => any) | null;\n    onmsgesturetap: ((this: Window, ev: Event) => any) | null;\n    onmsinertiastart: ((this: Window, ev: Event) => any) | null;\n    onmspointercancel: ((this: Window, ev: Event) => any) | null;\n    onmspointerdown: ((this: Window, ev: Event) => any) | null;\n    onmspointerenter: ((this: Window, ev: Event) => any) | null;\n    onmspointerleave: ((this: Window, ev: Event) => any) | null;\n    onmspointermove: ((this: Window, ev: Event) => any) | null;\n    onmspointerout: ((this: Window, ev: Event) => any) | null;\n    onmspointerover: ((this: Window, ev: Event) => any) | null;\n    onmspointerup: ((this: Window, ev: Event) => any) | null;\n    /** @deprecated */\n    onorientationchange: ((this: Window, ev: Event) => any) | null;\n    onreadystatechange: ((this: Window, ev: ProgressEvent<Window>) => any) | null;\n    onvrdisplayactivate: ((this: Window, ev: Event) => any) | null;\n    onvrdisplayblur: ((this: Window, ev: Event) => any) | null;\n    onvrdisplayconnect: ((this: Window, ev: Event) => any) | null;\n    onvrdisplaydeactivate: ((this: Window, ev: Event) => any) | null;\n    onvrdisplaydisconnect: ((this: Window, ev: Event) => any) | null;\n    onvrdisplayfocus: ((this: Window, ev: Event) => any) | null;\n    onvrdisplaypointerrestricted: ((this: Window, ev: Event) => any) | null;\n    onvrdisplaypointerunrestricted: ((this: Window, ev: Event) => any) | null;\n    onvrdisplaypresentchange: ((this: Window, ev: Event) => any) | null;\n    opener: any;\n    /** @deprecated */\n    readonly orientation: string | number;\n    readonly outerHeight: number;\n    readonly outerWidth: number;\n    readonly pageXOffset: number;\n    readonly pageYOffset: number;\n    readonly parent: Window;\n    readonly personalbar: BarProp;\n    readonly screen: Screen;\n    readonly screenLeft: number;\n    readonly screenTop: number;\n    readonly screenX: number;\n    readonly screenY: number;\n    readonly scrollX: number;\n    readonly scrollY: number;\n    readonly scrollbars: BarProp;\n    readonly self: Window & typeof globalThis;\n    readonly speechSynthesis: SpeechSynthesis;\n    status: string;\n    readonly statusbar: BarProp;\n    readonly styleMedia: StyleMedia;\n    readonly toolbar: BarProp;\n    readonly top: Window;\n    readonly visualViewport: VisualViewport;\n    readonly window: Window & typeof globalThis;\n    alert(message?: any): void;\n    blur(): void;\n    /** @deprecated */\n    captureEvents(): void;\n    close(): void;\n    confirm(message?: string): boolean;\n    departFocus(navigationReason: NavigationReason, origin: FocusNavigationOrigin): void;\n    focus(): void;\n    getComputedStyle(elt: Element, pseudoElt?: string | null): CSSStyleDeclaration;\n    getMatchedCSSRules(elt: Element, pseudoElt?: string | null): CSSRuleList;\n    getSelection(): Selection | null;\n    matchMedia(query: string): MediaQueryList;\n    moveBy(x: number, y: number): void;\n    moveTo(x: number, y: number): void;\n    msWriteProfilerMark(profilerMarkName: string): void;\n    open(url?: string, target?: string, features?: string, replace?: boolean): Window | null;\n    postMessage(message: any, targetOrigin: string, transfer?: Transferable[]): void;\n    print(): void;\n    prompt(message?: string, _default?: string): string | null;\n    /** @deprecated */\n    releaseEvents(): void;\n    resizeBy(x: number, y: number): void;\n    resizeTo(width: number, height: number): void;\n    scroll(options?: ScrollToOptions): void;\n    scroll(x: number, y: number): void;\n    scrollBy(options?: ScrollToOptions): void;\n    scrollBy(x: number, y: number): void;\n    scrollTo(options?: ScrollToOptions): void;\n    scrollTo(x: number, y: number): void;\n    stop(): void;\n    webkitCancelAnimationFrame(handle: number): void;\n    webkitConvertPointFromNodeToPage(node: Node, pt: WebKitPoint): WebKitPoint;\n    webkitConvertPointFromPageToNode(node: Node, pt: WebKitPoint): WebKitPoint;\n    webkitRequestAnimationFrame(callback: FrameRequestCallback): number;\n    addEventListener<K extends keyof WindowEventMap>(type: K, listener: (this: Window, ev: WindowEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof WindowEventMap>(type: K, listener: (this: Window, ev: WindowEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n    [index: number]: Window;\n}\n\ndeclare var Window: {\n    prototype: Window;\n    new(): Window;\n};\n\ninterface WindowEventHandlersEventMap {\n    \"afterprint\": Event;\n    \"beforeprint\": Event;\n    \"beforeunload\": BeforeUnloadEvent;\n    \"hashchange\": HashChangeEvent;\n    \"languagechange\": Event;\n    \"message\": MessageEvent;\n    \"messageerror\": MessageEvent;\n    \"offline\": Event;\n    \"online\": Event;\n    \"pagehide\": PageTransitionEvent;\n    \"pageshow\": PageTransitionEvent;\n    \"popstate\": PopStateEvent;\n    \"rejectionhandled\": PromiseRejectionEvent;\n    \"storage\": StorageEvent;\n    \"unhandledrejection\": PromiseRejectionEvent;\n    \"unload\": Event;\n}\n\ninterface WindowEventHandlers {\n    onafterprint: ((this: WindowEventHandlers, ev: Event) => any) | null;\n    onbeforeprint: ((this: WindowEventHandlers, ev: Event) => any) | null;\n    onbeforeunload: ((this: WindowEventHandlers, ev: BeforeUnloadEvent) => any) | null;\n    onhashchange: ((this: WindowEventHandlers, ev: HashChangeEvent) => any) | null;\n    onlanguagechange: ((this: WindowEventHandlers, ev: Event) => any) | null;\n    onmessage: ((this: WindowEventHandlers, ev: MessageEvent) => any) | null;\n    onmessageerror: ((this: WindowEventHandlers, ev: MessageEvent) => any) | null;\n    onoffline: ((this: WindowEventHandlers, ev: Event) => any) | null;\n    ononline: ((this: WindowEventHandlers, ev: Event) => any) | null;\n    onpagehide: ((this: WindowEventHandlers, ev: PageTransitionEvent) => any) | null;\n    onpageshow: ((this: WindowEventHandlers, ev: PageTransitionEvent) => any) | null;\n    onpopstate: ((this: WindowEventHandlers, ev: PopStateEvent) => any) | null;\n    onrejectionhandled: ((this: WindowEventHandlers, ev: PromiseRejectionEvent) => any) | null;\n    onstorage: ((this: WindowEventHandlers, ev: StorageEvent) => any) | null;\n    onunhandledrejection: ((this: WindowEventHandlers, ev: PromiseRejectionEvent) => any) | null;\n    onunload: ((this: WindowEventHandlers, ev: Event) => any) | null;\n    addEventListener<K extends keyof WindowEventHandlersEventMap>(type: K, listener: (this: WindowEventHandlers, ev: WindowEventHandlersEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof WindowEventHandlersEventMap>(type: K, listener: (this: WindowEventHandlers, ev: WindowEventHandlersEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ninterface WindowLocalStorage {\n    readonly localStorage: Storage;\n}\n\ninterface WindowOrWorkerGlobalScope {\n    readonly caches: CacheStorage;\n    readonly crypto: Crypto;\n    readonly indexedDB: IDBFactory;\n    readonly isSecureContext: boolean;\n    readonly origin: string;\n    readonly performance: Performance;\n    atob(data: string): string;\n    btoa(data: string): string;\n    clearInterval(handle?: number): void;\n    clearTimeout(handle?: number): void;\n    createImageBitmap(image: ImageBitmapSource, options?: ImageBitmapOptions): Promise<ImageBitmap>;\n    createImageBitmap(image: ImageBitmapSource, sx: number, sy: number, sw: number, sh: number, options?: ImageBitmapOptions): Promise<ImageBitmap>;\n    fetch(input: RequestInfo, init?: RequestInit): Promise<Response>;\n    queueMicrotask(callback: VoidFunction): void;\n    setInterval(handler: TimerHandler, timeout?: number, ...arguments: any[]): number;\n    setTimeout(handler: TimerHandler, timeout?: number, ...arguments: any[]): number;\n}\n\ninterface WindowSessionStorage {\n    readonly sessionStorage: Storage;\n}\n\ninterface WorkerEventMap extends AbstractWorkerEventMap {\n    \"message\": MessageEvent;\n    \"messageerror\": MessageEvent;\n}\n\n/** This Web Workers API interface represents a background task that can be easily created and can send messages back to its creator. Creating a worker is as simple as calling the Worker() constructor and specifying a script to be run in the worker thread. */\ninterface Worker extends EventTarget, AbstractWorker {\n    onmessage: ((this: Worker, ev: MessageEvent) => any) | null;\n    onmessageerror: ((this: Worker, ev: MessageEvent) => any) | null;\n    /**\n     * Clones message and transmits it to worker's global environment. transfer can be passed as a list of objects that are to be transferred rather than cloned.\n     */\n    postMessage(message: any, transfer: Transferable[]): void;\n    postMessage(message: any, options?: PostMessageOptions): void;\n    /**\n     * Aborts worker's associated global environment.\n     */\n    terminate(): void;\n    addEventListener<K extends keyof WorkerEventMap>(type: K, listener: (this: Worker, ev: WorkerEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof WorkerEventMap>(type: K, listener: (this: Worker, ev: WorkerEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var Worker: {\n    prototype: Worker;\n    new(stringUrl: string | URL, options?: WorkerOptions): Worker;\n};\n\ninterface Worklet {\n    addModule(moduleURL: string, options?: WorkletOptions): Promise<void>;\n}\n\ndeclare var Worklet: {\n    prototype: Worklet;\n    new(): Worklet;\n};\n\n/** This Streams API interface provides a standard abstraction for writing streaming data to a destination, known as a sink. This object comes with built-in backpressure and queuing. */\ninterface WritableStream<W = any> {\n    readonly locked: boolean;\n    abort(reason?: any): Promise<void>;\n    getWriter(): WritableStreamDefaultWriter<W>;\n}\n\ndeclare var WritableStream: {\n    prototype: WritableStream;\n    new<W = any>(underlyingSink?: UnderlyingSink<W>, strategy?: QueuingStrategy<W>): WritableStream<W>;\n};\n\n/** This Streams API interface represents a controller allowing control of a WritableStream's state. When constructing a WritableStream, the underlying sink is given a corresponding WritableStreamDefaultController instance to manipulate. */\ninterface WritableStreamDefaultController {\n    error(error?: any): void;\n}\n\ndeclare var WritableStreamDefaultController: {\n    prototype: WritableStreamDefaultController;\n    new(): WritableStreamDefaultController;\n};\n\n/** This Streams API interface is the object returned by WritableStream.getWriter() and once created locks the < writer to the WritableStream ensuring that no other streams can write to the underlying sink. */\ninterface WritableStreamDefaultWriter<W = any> {\n    readonly closed: Promise<void>;\n    readonly desiredSize: number | null;\n    readonly ready: Promise<void>;\n    abort(reason?: any): Promise<void>;\n    close(): Promise<void>;\n    releaseLock(): void;\n    write(chunk: W): Promise<void>;\n}\n\ndeclare var WritableStreamDefaultWriter: {\n    prototype: WritableStreamDefaultWriter;\n    new(): WritableStreamDefaultWriter;\n};\n\n/** An XML document. It inherits from the generic Document and does not add any specific methods or properties to it: nevertheless, several algorithms behave differently with the two types of documents. */\ninterface XMLDocument extends Document {\n    addEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: XMLDocument, ev: DocumentEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof DocumentEventMap>(type: K, listener: (this: XMLDocument, ev: DocumentEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var XMLDocument: {\n    prototype: XMLDocument;\n    new(): XMLDocument;\n};\n\ninterface XMLHttpRequestEventMap extends XMLHttpRequestEventTargetEventMap {\n    \"readystatechange\": Event;\n}\n\n/** Use XMLHttpRequest (XHR) objects to interact with servers. You can retrieve data from a URL without having to do a full page refresh. This enables a Web page to update just part of a page without disrupting what the user is doing. */\ninterface XMLHttpRequest extends XMLHttpRequestEventTarget {\n    onreadystatechange: ((this: XMLHttpRequest, ev: Event) => any) | null;\n    /**\n     * Returns client's state.\n     */\n    readonly readyState: number;\n    /**\n     * Returns the response's body.\n     */\n    readonly response: any;\n    /**\n     * Returns the text response.\n     * \n     * Throws an \"InvalidStateError\" DOMException if responseType is not the empty string or \"text\".\n     */\n    readonly responseText: string;\n    /**\n     * Returns the response type.\n     * \n     * Can be set to change the response type. Values are: the empty string (default), \"arraybuffer\", \"blob\", \"document\", \"json\", and \"text\".\n     * \n     * When set: setting to \"document\" is ignored if current global object is not a Window object.\n     * \n     * When set: throws an \"InvalidStateError\" DOMException if state is loading or done.\n     * \n     * When set: throws an \"InvalidAccessError\" DOMException if the synchronous flag is set and current global object is a Window object.\n     */\n    responseType: XMLHttpRequestResponseType;\n    readonly responseURL: string;\n    /**\n     * Returns the document response.\n     * \n     * Throws an \"InvalidStateError\" DOMException if responseType is not the empty string or \"document\".\n     */\n    readonly responseXML: Document | null;\n    readonly status: number;\n    readonly statusText: string;\n    /**\n     * Can be set to a time in milliseconds. When set to a non-zero value will cause fetching to terminate after the given time has passed. When the time has passed, the request has not yet completed, and the synchronous flag is unset, a timeout event will then be dispatched, or a \"TimeoutError\" DOMException will be thrown otherwise (for the send() method).\n     * \n     * When set: throws an \"InvalidAccessError\" DOMException if the synchronous flag is set and current global object is a Window object.\n     */\n    timeout: number;\n    /**\n     * Returns the associated XMLHttpRequestUpload object. It can be used to gather transmission information when data is transferred to a server.\n     */\n    readonly upload: XMLHttpRequestUpload;\n    /**\n     * True when credentials are to be included in a cross-origin request. False when they are to be excluded in a cross-origin request and when cookies are to be ignored in its response. Initially false.\n     * \n     * When set: throws an \"InvalidStateError\" DOMException if state is not unsent or opened, or if the send() flag is set.\n     */\n    withCredentials: boolean;\n    /**\n     * Cancels any network activity.\n     */\n    abort(): void;\n    getAllResponseHeaders(): string;\n    getResponseHeader(name: string): string | null;\n    /**\n     * Sets the request method, request URL, and synchronous flag.\n     * \n     * Throws a \"SyntaxError\" DOMException if either method is not a valid HTTP method or url cannot be parsed.\n     * \n     * Throws a \"SecurityError\" DOMException if method is a case-insensitive match for `CONNECT`, `TRACE`, or `TRACK`.\n     * \n     * Throws an \"InvalidAccessError\" DOMException if async is false, current global object is a Window object, and the timeout attribute is not zero or the responseType attribute is not the empty string.\n     */\n    open(method: string, url: string): void;\n    open(method: string, url: string, async: boolean, username?: string | null, password?: string | null): void;\n    /**\n     * Acts as if the `Content-Type` header value for response is mime. (It does not actually change the header though.)\n     * \n     * Throws an \"InvalidStateError\" DOMException if state is loading or done.\n     */\n    overrideMimeType(mime: string): void;\n    /**\n     * Initiates the request. The body argument provides the request body, if any, and is ignored if the request method is GET or HEAD.\n     * \n     * Throws an \"InvalidStateError\" DOMException if either state is not opened or the send() flag is set.\n     */\n    send(body?: Document | BodyInit | null): void;\n    /**\n     * Combines a header in author request headers.\n     * \n     * Throws an \"InvalidStateError\" DOMException if either state is not opened or the send() flag is set.\n     * \n     * Throws a \"SyntaxError\" DOMException if name is not a header name or if value is not a header value.\n     */\n    setRequestHeader(name: string, value: string): void;\n    readonly DONE: number;\n    readonly HEADERS_RECEIVED: number;\n    readonly LOADING: number;\n    readonly OPENED: number;\n    readonly UNSENT: number;\n    addEventListener<K extends keyof XMLHttpRequestEventMap>(type: K, listener: (this: XMLHttpRequest, ev: XMLHttpRequestEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof XMLHttpRequestEventMap>(type: K, listener: (this: XMLHttpRequest, ev: XMLHttpRequestEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var XMLHttpRequest: {\n    prototype: XMLHttpRequest;\n    new(): XMLHttpRequest;\n    readonly DONE: number;\n    readonly HEADERS_RECEIVED: number;\n    readonly LOADING: number;\n    readonly OPENED: number;\n    readonly UNSENT: number;\n};\n\ninterface XMLHttpRequestEventTargetEventMap {\n    \"abort\": ProgressEvent<XMLHttpRequestEventTarget>;\n    \"error\": ProgressEvent<XMLHttpRequestEventTarget>;\n    \"load\": ProgressEvent<XMLHttpRequestEventTarget>;\n    \"loadend\": ProgressEvent<XMLHttpRequestEventTarget>;\n    \"loadstart\": ProgressEvent<XMLHttpRequestEventTarget>;\n    \"progress\": ProgressEvent<XMLHttpRequestEventTarget>;\n    \"timeout\": ProgressEvent<XMLHttpRequestEventTarget>;\n}\n\ninterface XMLHttpRequestEventTarget extends EventTarget {\n    onabort: ((this: XMLHttpRequest, ev: ProgressEvent) => any) | null;\n    onerror: ((this: XMLHttpRequest, ev: ProgressEvent) => any) | null;\n    onload: ((this: XMLHttpRequest, ev: ProgressEvent) => any) | null;\n    onloadend: ((this: XMLHttpRequest, ev: ProgressEvent) => any) | null;\n    onloadstart: ((this: XMLHttpRequest, ev: ProgressEvent) => any) | null;\n    onprogress: ((this: XMLHttpRequest, ev: ProgressEvent) => any) | null;\n    ontimeout: ((this: XMLHttpRequest, ev: ProgressEvent) => any) | null;\n    addEventListener<K extends keyof XMLHttpRequestEventTargetEventMap>(type: K, listener: (this: XMLHttpRequestEventTarget, ev: XMLHttpRequestEventTargetEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof XMLHttpRequestEventTargetEventMap>(type: K, listener: (this: XMLHttpRequestEventTarget, ev: XMLHttpRequestEventTargetEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var XMLHttpRequestEventTarget: {\n    prototype: XMLHttpRequestEventTarget;\n    new(): XMLHttpRequestEventTarget;\n};\n\ninterface XMLHttpRequestUpload extends XMLHttpRequestEventTarget {\n    addEventListener<K extends keyof XMLHttpRequestEventTargetEventMap>(type: K, listener: (this: XMLHttpRequestUpload, ev: XMLHttpRequestEventTargetEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof XMLHttpRequestEventTargetEventMap>(type: K, listener: (this: XMLHttpRequestUpload, ev: XMLHttpRequestEventTargetEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var XMLHttpRequestUpload: {\n    prototype: XMLHttpRequestUpload;\n    new(): XMLHttpRequestUpload;\n};\n\n/** Provides the serializeToString() method to construct an XML string representing a DOM tree. */\ninterface XMLSerializer {\n    serializeToString(root: Node): string;\n}\n\ndeclare var XMLSerializer: {\n    prototype: XMLSerializer;\n    new(): XMLSerializer;\n};\n\n/** The XPathEvaluator interface allows to compile and evaluate XPath expressions. */\ninterface XPathEvaluator extends XPathEvaluatorBase {\n}\n\ndeclare var XPathEvaluator: {\n    prototype: XPathEvaluator;\n    new(): XPathEvaluator;\n};\n\ninterface XPathEvaluatorBase {\n    createExpression(expression: string, resolver?: XPathNSResolver | null): XPathExpression;\n    createNSResolver(nodeResolver: Node): XPathNSResolver;\n    evaluate(expression: string, contextNode: Node, resolver?: XPathNSResolver | null, type?: number, result?: XPathResult | null): XPathResult;\n}\n\n/** This interface is a compiled XPath expression that can be evaluated on a document or specific node to return information its DOM tree. */\ninterface XPathExpression {\n    evaluate(contextNode: Node, type?: number, result?: XPathResult | null): XPathResult;\n}\n\ndeclare var XPathExpression: {\n    prototype: XPathExpression;\n    new(): XPathExpression;\n};\n\n/** The results generated by evaluating an XPath expression within the context of a given node. */\ninterface XPathResult {\n    readonly booleanValue: boolean;\n    readonly invalidIteratorState: boolean;\n    readonly numberValue: number;\n    readonly resultType: number;\n    readonly singleNodeValue: Node | null;\n    readonly snapshotLength: number;\n    readonly stringValue: string;\n    iterateNext(): Node | null;\n    snapshotItem(index: number): Node | null;\n    readonly ANY_TYPE: number;\n    readonly ANY_UNORDERED_NODE_TYPE: number;\n    readonly BOOLEAN_TYPE: number;\n    readonly FIRST_ORDERED_NODE_TYPE: number;\n    readonly NUMBER_TYPE: number;\n    readonly ORDERED_NODE_ITERATOR_TYPE: number;\n    readonly ORDERED_NODE_SNAPSHOT_TYPE: number;\n    readonly STRING_TYPE: number;\n    readonly UNORDERED_NODE_ITERATOR_TYPE: number;\n    readonly UNORDERED_NODE_SNAPSHOT_TYPE: number;\n}\n\ndeclare var XPathResult: {\n    prototype: XPathResult;\n    new(): XPathResult;\n    readonly ANY_TYPE: number;\n    readonly ANY_UNORDERED_NODE_TYPE: number;\n    readonly BOOLEAN_TYPE: number;\n    readonly FIRST_ORDERED_NODE_TYPE: number;\n    readonly NUMBER_TYPE: number;\n    readonly ORDERED_NODE_ITERATOR_TYPE: number;\n    readonly ORDERED_NODE_SNAPSHOT_TYPE: number;\n    readonly STRING_TYPE: number;\n    readonly UNORDERED_NODE_ITERATOR_TYPE: number;\n    readonly UNORDERED_NODE_SNAPSHOT_TYPE: number;\n};\n\n/** An XSLTProcessor applies an XSLT stylesheet transformation to an XML document to produce a new XML document as output. It has methods to load the XSLT stylesheet, to manipulate <xsl:param> parameter values, and to apply the transformation to documents. */\ninterface XSLTProcessor {\n    clearParameters(): void;\n    getParameter(namespaceURI: string, localName: string): any;\n    importStylesheet(style: Node): void;\n    removeParameter(namespaceURI: string, localName: string): void;\n    reset(): void;\n    setParameter(namespaceURI: string, localName: string, value: any): void;\n    transformToDocument(source: Node): Document;\n    transformToFragment(source: Node, document: Document): DocumentFragment;\n}\n\ndeclare var XSLTProcessor: {\n    prototype: XSLTProcessor;\n    new(): XSLTProcessor;\n};\n\ninterface webkitRTCPeerConnection extends RTCPeerConnection {\n    addEventListener<K extends keyof RTCPeerConnectionEventMap>(type: K, listener: (this: webkitRTCPeerConnection, ev: RTCPeerConnectionEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\n    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\n    removeEventListener<K extends keyof RTCPeerConnectionEventMap>(type: K, listener: (this: webkitRTCPeerConnection, ev: RTCPeerConnectionEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\n    removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\n}\n\ndeclare var webkitRTCPeerConnection: {\n    prototype: webkitRTCPeerConnection;\n    new(configuration: RTCConfiguration): webkitRTCPeerConnection;\n};\n\ndeclare type EventListenerOrEventListenerObject = EventListener | EventListenerObject;\n\ninterface Console {\n    memory: any;\n    assert(condition?: boolean, ...data: any[]): void;\n    clear(): void;\n    count(label?: string): void;\n    countReset(label?: string): void;\n    debug(...data: any[]): void;\n    dir(item?: any, options?: any): void;\n    dirxml(...data: any[]): void;\n    error(...data: any[]): void;\n    exception(message?: string, ...optionalParams: any[]): void;\n    group(...data: any[]): void;\n    groupCollapsed(...data: any[]): void;\n    groupEnd(): void;\n    info(...data: any[]): void;\n    log(...data: any[]): void;\n    table(tabularData?: any, properties?: string[]): void;\n    time(label?: string): void;\n    timeEnd(label?: string): void;\n    timeLog(label?: string, ...data: any[]): void;\n    timeStamp(label?: string): void;\n    trace(...data: any[]): void;\n    warn(...data: any[]): void;\n}\n\ndeclare var console: Console;\n\n/** Holds useful CSS-related methods. No object with this interface are implemented: it contains only static methods and therefore is a utilitarian interface. */\ndeclare namespace CSS {\n    function escape(ident: string): string;\n    function supports(property: string, value: string): boolean;\n    function supports(conditionText: string): boolean;\n}\n\ndeclare namespace WebAssembly {\n    interface CompileError {\n    }\n    \n    var CompileError: {\n        prototype: CompileError;\n        new(): CompileError;\n    };\n    \n    interface Global {\n        value: any;\n        valueOf(): any;\n    }\n    \n    var Global: {\n        prototype: Global;\n        new(descriptor: GlobalDescriptor, v?: any): Global;\n    };\n    \n    interface Instance {\n        readonly exports: Exports;\n    }\n    \n    var Instance: {\n        prototype: Instance;\n        new(module: Module, importObject?: Imports): Instance;\n    };\n    \n    interface LinkError {\n    }\n    \n    var LinkError: {\n        prototype: LinkError;\n        new(): LinkError;\n    };\n    \n    interface Memory {\n        readonly buffer: ArrayBuffer;\n        grow(delta: number): number;\n    }\n    \n    var Memory: {\n        prototype: Memory;\n        new(descriptor: MemoryDescriptor): Memory;\n    };\n    \n    interface Module {\n    }\n    \n    var Module: {\n        prototype: Module;\n        new(bytes: BufferSource): Module;\n        customSections(moduleObject: Module, sectionName: string): ArrayBuffer[];\n        exports(moduleObject: Module): ModuleExportDescriptor[];\n        imports(moduleObject: Module): ModuleImportDescriptor[];\n    };\n    \n    interface RuntimeError {\n    }\n    \n    var RuntimeError: {\n        prototype: RuntimeError;\n        new(): RuntimeError;\n    };\n    \n    interface Table {\n        readonly length: number;\n        get(index: number): Function | null;\n        grow(delta: number): number;\n        set(index: number, value: Function | null): void;\n    }\n    \n    var Table: {\n        prototype: Table;\n        new(descriptor: TableDescriptor): Table;\n    };\n    \n    interface GlobalDescriptor {\n        mutable?: boolean;\n        value: ValueType;\n    }\n    \n    interface MemoryDescriptor {\n        initial: number;\n        maximum?: number;\n    }\n    \n    interface ModuleExportDescriptor {\n        kind: ImportExportKind;\n        name: string;\n    }\n    \n    interface ModuleImportDescriptor {\n        kind: ImportExportKind;\n        module: string;\n        name: string;\n    }\n    \n    interface TableDescriptor {\n        element: TableKind;\n        initial: number;\n        maximum?: number;\n    }\n    \n    interface WebAssemblyInstantiatedSource {\n        instance: Instance;\n        module: Module;\n    }\n    \n    type ImportExportKind = \"function\" | \"global\" | \"memory\" | \"table\";\n    type TableKind = \"anyfunc\";\n    type ValueType = \"f32\" | \"f64\" | \"i32\" | \"i64\";\n    type ExportValue = Function | Global | Memory | Table;\n    type Exports = Record<string, ExportValue>;\n    type ImportValue = ExportValue | number;\n    type ModuleImports = Record<string, ImportValue>;\n    type Imports = Record<string, ModuleImports>;\n    function compile(bytes: BufferSource): Promise<Module>;\n    function compileStreaming(source: Response | Promise<Response>): Promise<Module>;\n    function instantiate(bytes: BufferSource, importObject?: Imports): Promise<WebAssemblyInstantiatedSource>;\n    function instantiate(moduleObject: Module, importObject?: Imports): Promise<Instance>;\n    function instantiateStreaming(response: Response | PromiseLike<Response>, importObject?: Imports): Promise<WebAssemblyInstantiatedSource>;\n    function validate(bytes: BufferSource): boolean;\n}\n\ninterface BlobCallback {\n    (blob: Blob | null): void;\n}\n\ninterface CustomElementConstructor {\n    new (...params: any[]): HTMLElement;\n}\n\ninterface DecodeErrorCallback {\n    (error: DOMException): void;\n}\n\ninterface DecodeSuccessCallback {\n    (decodedData: AudioBuffer): void;\n}\n\ninterface EventHandlerNonNull {\n    (event: Event): any;\n}\n\ninterface ForEachCallback {\n    (keyId: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer | null, status: MediaKeyStatus): void;\n}\n\ninterface FrameRequestCallback {\n    (time: number): void;\n}\n\ninterface FunctionStringCallback {\n    (data: string): void;\n}\n\ninterface IntersectionObserverCallback {\n    (entries: IntersectionObserverEntry[], observer: IntersectionObserver): void;\n}\n\ninterface MSLaunchUriCallback {\n    (): void;\n}\n\ninterface MutationCallback {\n    (mutations: MutationRecord[], observer: MutationObserver): void;\n}\n\ninterface NavigatorUserMediaErrorCallback {\n    (error: MediaStreamError): void;\n}\n\ninterface NavigatorUserMediaSuccessCallback {\n    (stream: MediaStream): void;\n}\n\ninterface NotificationPermissionCallback {\n    (permission: NotificationPermission): void;\n}\n\ninterface OnBeforeUnloadEventHandlerNonNull {\n    (event: Event): string | null;\n}\n\ninterface OnErrorEventHandlerNonNull {\n    (event: Event | string, source?: string, lineno?: number, colno?: number, error?: Error): any;\n}\n\ninterface PerformanceObserverCallback {\n    (entries: PerformanceObserverEntryList, observer: PerformanceObserver): void;\n}\n\ninterface PositionCallback {\n    (position: GeolocationPosition): void;\n}\n\ninterface PositionErrorCallback {\n    (positionError: GeolocationPositionError): void;\n}\n\ninterface QueuingStrategySizeCallback<T = any> {\n    (chunk: T): number;\n}\n\ninterface RTCPeerConnectionErrorCallback {\n    (error: DOMException): void;\n}\n\ninterface RTCSessionDescriptionCallback {\n    (description: RTCSessionDescriptionInit): void;\n}\n\ninterface RTCStatsCallback {\n    (report: RTCStatsReport): void;\n}\n\ninterface ReadableByteStreamControllerCallback {\n    (controller: ReadableByteStreamController): void | PromiseLike<void>;\n}\n\ninterface ReadableStreamDefaultControllerCallback<R> {\n    (controller: ReadableStreamDefaultController<R>): void | PromiseLike<void>;\n}\n\ninterface ReadableStreamErrorCallback {\n    (reason: any): void | PromiseLike<void>;\n}\n\ninterface TransformStreamDefaultControllerCallback<O> {\n    (controller: TransformStreamDefaultController<O>): void | PromiseLike<void>;\n}\n\ninterface TransformStreamDefaultControllerTransformCallback<I, O> {\n    (chunk: I, controller: TransformStreamDefaultController<O>): void | PromiseLike<void>;\n}\n\ninterface VoidFunction {\n    (): void;\n}\n\ninterface WritableStreamDefaultControllerCloseCallback {\n    (): void | PromiseLike<void>;\n}\n\ninterface WritableStreamDefaultControllerStartCallback {\n    (controller: WritableStreamDefaultController): void | PromiseLike<void>;\n}\n\ninterface WritableStreamDefaultControllerWriteCallback<W> {\n    (chunk: W, controller: WritableStreamDefaultController): void | PromiseLike<void>;\n}\n\ninterface WritableStreamErrorCallback {\n    (reason: any): void | PromiseLike<void>;\n}\n\ninterface HTMLElementTagNameMap {\n    \"a\": HTMLAnchorElement;\n    \"abbr\": HTMLElement;\n    \"address\": HTMLElement;\n    \"applet\": HTMLAppletElement;\n    \"area\": HTMLAreaElement;\n    \"article\": HTMLElement;\n    \"aside\": HTMLElement;\n    \"audio\": HTMLAudioElement;\n    \"b\": HTMLElement;\n    \"base\": HTMLBaseElement;\n    \"basefont\": HTMLBaseFontElement;\n    \"bdi\": HTMLElement;\n    \"bdo\": HTMLElement;\n    \"blockquote\": HTMLQuoteElement;\n    \"body\": HTMLBodyElement;\n    \"br\": HTMLBRElement;\n    \"button\": HTMLButtonElement;\n    \"canvas\": HTMLCanvasElement;\n    \"caption\": HTMLTableCaptionElement;\n    \"cite\": HTMLElement;\n    \"code\": HTMLElement;\n    \"col\": HTMLTableColElement;\n    \"colgroup\": HTMLTableColElement;\n    \"data\": HTMLDataElement;\n    \"datalist\": HTMLDataListElement;\n    \"dd\": HTMLElement;\n    \"del\": HTMLModElement;\n    \"details\": HTMLDetailsElement;\n    \"dfn\": HTMLElement;\n    \"dialog\": HTMLDialogElement;\n    \"dir\": HTMLDirectoryElement;\n    \"div\": HTMLDivElement;\n    \"dl\": HTMLDListElement;\n    \"dt\": HTMLElement;\n    \"em\": HTMLElement;\n    \"embed\": HTMLEmbedElement;\n    \"fieldset\": HTMLFieldSetElement;\n    \"figcaption\": HTMLElement;\n    \"figure\": HTMLElement;\n    \"font\": HTMLFontElement;\n    \"footer\": HTMLElement;\n    \"form\": HTMLFormElement;\n    \"frame\": HTMLFrameElement;\n    \"frameset\": HTMLFrameSetElement;\n    \"h1\": HTMLHeadingElement;\n    \"h2\": HTMLHeadingElement;\n    \"h3\": HTMLHeadingElement;\n    \"h4\": HTMLHeadingElement;\n    \"h5\": HTMLHeadingElement;\n    \"h6\": HTMLHeadingElement;\n    \"head\": HTMLHeadElement;\n    \"header\": HTMLElement;\n    \"hgroup\": HTMLElement;\n    \"hr\": HTMLHRElement;\n    \"html\": HTMLHtmlElement;\n    \"i\": HTMLElement;\n    \"iframe\": HTMLIFrameElement;\n    \"img\": HTMLImageElement;\n    \"input\": HTMLInputElement;\n    \"ins\": HTMLModElement;\n    \"kbd\": HTMLElement;\n    \"label\": HTMLLabelElement;\n    \"legend\": HTMLLegendElement;\n    \"li\": HTMLLIElement;\n    \"link\": HTMLLinkElement;\n    \"main\": HTMLElement;\n    \"map\": HTMLMapElement;\n    \"mark\": HTMLElement;\n    \"marquee\": HTMLMarqueeElement;\n    \"menu\": HTMLMenuElement;\n    \"meta\": HTMLMetaElement;\n    \"meter\": HTMLMeterElement;\n    \"nav\": HTMLElement;\n    \"noscript\": HTMLElement;\n    \"object\": HTMLObjectElement;\n    \"ol\": HTMLOListElement;\n    \"optgroup\": HTMLOptGroupElement;\n    \"option\": HTMLOptionElement;\n    \"output\": HTMLOutputElement;\n    \"p\": HTMLParagraphElement;\n    \"param\": HTMLParamElement;\n    \"picture\": HTMLPictureElement;\n    \"pre\": HTMLPreElement;\n    \"progress\": HTMLProgressElement;\n    \"q\": HTMLQuoteElement;\n    \"rp\": HTMLElement;\n    \"rt\": HTMLElement;\n    \"ruby\": HTMLElement;\n    \"s\": HTMLElement;\n    \"samp\": HTMLElement;\n    \"script\": HTMLScriptElement;\n    \"section\": HTMLElement;\n    \"select\": HTMLSelectElement;\n    \"slot\": HTMLSlotElement;\n    \"small\": HTMLElement;\n    \"source\": HTMLSourceElement;\n    \"span\": HTMLSpanElement;\n    \"strong\": HTMLElement;\n    \"style\": HTMLStyleElement;\n    \"sub\": HTMLElement;\n    \"summary\": HTMLElement;\n    \"sup\": HTMLElement;\n    \"table\": HTMLTableElement;\n    \"tbody\": HTMLTableSectionElement;\n    \"td\": HTMLTableDataCellElement;\n    \"template\": HTMLTemplateElement;\n    \"textarea\": HTMLTextAreaElement;\n    \"tfoot\": HTMLTableSectionElement;\n    \"th\": HTMLTableHeaderCellElement;\n    \"thead\": HTMLTableSectionElement;\n    \"time\": HTMLTimeElement;\n    \"title\": HTMLTitleElement;\n    \"tr\": HTMLTableRowElement;\n    \"track\": HTMLTrackElement;\n    \"u\": HTMLElement;\n    \"ul\": HTMLUListElement;\n    \"var\": HTMLElement;\n    \"video\": HTMLVideoElement;\n    \"wbr\": HTMLElement;\n}\n\ninterface HTMLElementDeprecatedTagNameMap {\n    \"listing\": HTMLPreElement;\n    \"xmp\": HTMLPreElement;\n}\n\ninterface SVGElementTagNameMap {\n    \"a\": SVGAElement;\n    \"circle\": SVGCircleElement;\n    \"clipPath\": SVGClipPathElement;\n    \"defs\": SVGDefsElement;\n    \"desc\": SVGDescElement;\n    \"ellipse\": SVGEllipseElement;\n    \"feBlend\": SVGFEBlendElement;\n    \"feColorMatrix\": SVGFEColorMatrixElement;\n    \"feComponentTransfer\": SVGFEComponentTransferElement;\n    \"feComposite\": SVGFECompositeElement;\n    \"feConvolveMatrix\": SVGFEConvolveMatrixElement;\n    \"feDiffuseLighting\": SVGFEDiffuseLightingElement;\n    \"feDisplacementMap\": SVGFEDisplacementMapElement;\n    \"feDistantLight\": SVGFEDistantLightElement;\n    \"feFlood\": SVGFEFloodElement;\n    \"feFuncA\": SVGFEFuncAElement;\n    \"feFuncB\": SVGFEFuncBElement;\n    \"feFuncG\": SVGFEFuncGElement;\n    \"feFuncR\": SVGFEFuncRElement;\n    \"feGaussianBlur\": SVGFEGaussianBlurElement;\n    \"feImage\": SVGFEImageElement;\n    \"feMerge\": SVGFEMergeElement;\n    \"feMergeNode\": SVGFEMergeNodeElement;\n    \"feMorphology\": SVGFEMorphologyElement;\n    \"feOffset\": SVGFEOffsetElement;\n    \"fePointLight\": SVGFEPointLightElement;\n    \"feSpecularLighting\": SVGFESpecularLightingElement;\n    \"feSpotLight\": SVGFESpotLightElement;\n    \"feTile\": SVGFETileElement;\n    \"feTurbulence\": SVGFETurbulenceElement;\n    \"filter\": SVGFilterElement;\n    \"foreignObject\": SVGForeignObjectElement;\n    \"g\": SVGGElement;\n    \"image\": SVGImageElement;\n    \"line\": SVGLineElement;\n    \"linearGradient\": SVGLinearGradientElement;\n    \"marker\": SVGMarkerElement;\n    \"mask\": SVGMaskElement;\n    \"metadata\": SVGMetadataElement;\n    \"path\": SVGPathElement;\n    \"pattern\": SVGPatternElement;\n    \"polygon\": SVGPolygonElement;\n    \"polyline\": SVGPolylineElement;\n    \"radialGradient\": SVGRadialGradientElement;\n    \"rect\": SVGRectElement;\n    \"script\": SVGScriptElement;\n    \"stop\": SVGStopElement;\n    \"style\": SVGStyleElement;\n    \"svg\": SVGSVGElement;\n    \"switch\": SVGSwitchElement;\n    \"symbol\": SVGSymbolElement;\n    \"text\": SVGTextElement;\n    \"textPath\": SVGTextPathElement;\n    \"title\": SVGTitleElement;\n    \"tspan\": SVGTSpanElement;\n    \"use\": SVGUseElement;\n    \"view\": SVGViewElement;\n}\n\n/** @deprecated Directly use HTMLElementTagNameMap or SVGElementTagNameMap as appropriate, instead. */\ntype ElementTagNameMap = HTMLElementTagNameMap & Pick<SVGElementTagNameMap, Exclude<keyof SVGElementTagNameMap, keyof HTMLElementTagNameMap>>;\n\ndeclare var Audio: {\n    new(src?: string): HTMLAudioElement;\n};\ndeclare var Image: {\n    new(width?: number, height?: number): HTMLImageElement;\n};\ndeclare var Option: {\n    new(text?: string, value?: string, defaultSelected?: boolean, selected?: boolean): HTMLOptionElement;\n};\ndeclare var applicationCache: ApplicationCache;\ndeclare var clientInformation: Navigator;\ndeclare var closed: boolean;\ndeclare var customElements: CustomElementRegistry;\ndeclare var defaultStatus: string;\ndeclare var devicePixelRatio: number;\ndeclare var doNotTrack: string;\ndeclare var document: Document;\n/** @deprecated */\ndeclare var event: Event | undefined;\n/** @deprecated */\ndeclare var external: External;\ndeclare var frameElement: Element;\ndeclare var frames: Window;\ndeclare var history: History;\ndeclare var innerHeight: number;\ndeclare var innerWidth: number;\ndeclare var length: number;\ndeclare var location: Location;\ndeclare var locationbar: BarProp;\ndeclare var menubar: BarProp;\ndeclare var msContentScript: ExtensionScriptApis;\n/** @deprecated */\ndeclare const name: void;\ndeclare var navigator: Navigator;\ndeclare var offscreenBuffering: string | boolean;\ndeclare var oncompassneedscalibration: ((this: Window, ev: Event) => any) | null;\ndeclare var ondevicelight: ((this: Window, ev: DeviceLightEvent) => any) | null;\ndeclare var ondevicemotion: ((this: Window, ev: DeviceMotionEvent) => any) | null;\ndeclare var ondeviceorientation: ((this: Window, ev: DeviceOrientationEvent) => any) | null;\ndeclare var ondeviceorientationabsolute: ((this: Window, ev: DeviceOrientationEvent) => any) | null;\ndeclare var onmousewheel: ((this: Window, ev: Event) => any) | null;\ndeclare var onmsgesturechange: ((this: Window, ev: Event) => any) | null;\ndeclare var onmsgesturedoubletap: ((this: Window, ev: Event) => any) | null;\ndeclare var onmsgestureend: ((this: Window, ev: Event) => any) | null;\ndeclare var onmsgesturehold: ((this: Window, ev: Event) => any) | null;\ndeclare var onmsgesturestart: ((this: Window, ev: Event) => any) | null;\ndeclare var onmsgesturetap: ((this: Window, ev: Event) => any) | null;\ndeclare var onmsinertiastart: ((this: Window, ev: Event) => any) | null;\ndeclare var onmspointercancel: ((this: Window, ev: Event) => any) | null;\ndeclare var onmspointerdown: ((this: Window, ev: Event) => any) | null;\ndeclare var onmspointerenter: ((this: Window, ev: Event) => any) | null;\ndeclare var onmspointerleave: ((this: Window, ev: Event) => any) | null;\ndeclare var onmspointermove: ((this: Window, ev: Event) => any) | null;\ndeclare var onmspointerout: ((this: Window, ev: Event) => any) | null;\ndeclare var onmspointerover: ((this: Window, ev: Event) => any) | null;\ndeclare var onmspointerup: ((this: Window, ev: Event) => any) | null;\n/** @deprecated */\ndeclare var onorientationchange: ((this: Window, ev: Event) => any) | null;\ndeclare var onreadystatechange: ((this: Window, ev: ProgressEvent<Window>) => any) | null;\ndeclare var onvrdisplayactivate: ((this: Window, ev: Event) => any) | null;\ndeclare var onvrdisplayblur: ((this: Window, ev: Event) => any) | null;\ndeclare var onvrdisplayconnect: ((this: Window, ev: Event) => any) | null;\ndeclare var onvrdisplaydeactivate: ((this: Window, ev: Event) => any) | null;\ndeclare var onvrdisplaydisconnect: ((this: Window, ev: Event) => any) | null;\ndeclare var onvrdisplayfocus: ((this: Window, ev: Event) => any) | null;\ndeclare var onvrdisplaypointerrestricted: ((this: Window, ev: Event) => any) | null;\ndeclare var onvrdisplaypointerunrestricted: ((this: Window, ev: Event) => any) | null;\ndeclare var onvrdisplaypresentchange: ((this: Window, ev: Event) => any) | null;\ndeclare var opener: any;\n/** @deprecated */\ndeclare var orientation: string | number;\ndeclare var outerHeight: number;\ndeclare var outerWidth: number;\ndeclare var pageXOffset: number;\ndeclare var pageYOffset: number;\ndeclare var parent: Window;\ndeclare var personalbar: BarProp;\ndeclare var screen: Screen;\ndeclare var screenLeft: number;\ndeclare var screenTop: number;\ndeclare var screenX: number;\ndeclare var screenY: number;\ndeclare var scrollX: number;\ndeclare var scrollY: number;\ndeclare var scrollbars: BarProp;\ndeclare var self: Window & typeof globalThis;\ndeclare var speechSynthesis: SpeechSynthesis;\ndeclare var status: string;\ndeclare var statusbar: BarProp;\ndeclare var styleMedia: StyleMedia;\ndeclare var toolbar: BarProp;\ndeclare var top: Window;\ndeclare var visualViewport: VisualViewport;\ndeclare var window: Window & typeof globalThis;\ndeclare function alert(message?: any): void;\ndeclare function blur(): void;\n/** @deprecated */\ndeclare function captureEvents(): void;\ndeclare function close(): void;\ndeclare function confirm(message?: string): boolean;\ndeclare function departFocus(navigationReason: NavigationReason, origin: FocusNavigationOrigin): void;\ndeclare function focus(): void;\ndeclare function getComputedStyle(elt: Element, pseudoElt?: string | null): CSSStyleDeclaration;\ndeclare function getMatchedCSSRules(elt: Element, pseudoElt?: string | null): CSSRuleList;\ndeclare function getSelection(): Selection | null;\ndeclare function matchMedia(query: string): MediaQueryList;\ndeclare function moveBy(x: number, y: number): void;\ndeclare function moveTo(x: number, y: number): void;\ndeclare function msWriteProfilerMark(profilerMarkName: string): void;\ndeclare function open(url?: string, target?: string, features?: string, replace?: boolean): Window | null;\ndeclare function postMessage(message: any, targetOrigin: string, transfer?: Transferable[]): void;\ndeclare function print(): void;\ndeclare function prompt(message?: string, _default?: string): string | null;\n/** @deprecated */\ndeclare function releaseEvents(): void;\ndeclare function resizeBy(x: number, y: number): void;\ndeclare function resizeTo(width: number, height: number): void;\ndeclare function scroll(options?: ScrollToOptions): void;\ndeclare function scroll(x: number, y: number): void;\ndeclare function scrollBy(options?: ScrollToOptions): void;\ndeclare function scrollBy(x: number, y: number): void;\ndeclare function scrollTo(options?: ScrollToOptions): void;\ndeclare function scrollTo(x: number, y: number): void;\ndeclare function stop(): void;\ndeclare function webkitCancelAnimationFrame(handle: number): void;\ndeclare function webkitConvertPointFromNodeToPage(node: Node, pt: WebKitPoint): WebKitPoint;\ndeclare function webkitConvertPointFromPageToNode(node: Node, pt: WebKitPoint): WebKitPoint;\ndeclare function webkitRequestAnimationFrame(callback: FrameRequestCallback): number;\ndeclare function toString(): string;\n/**\n * Dispatches a synthetic event event to target and returns true if either event's cancelable attribute value is false or its preventDefault() method was not invoked, and false otherwise.\n */\ndeclare function dispatchEvent(event: Event): boolean;\ndeclare var sessionStorage: Storage;\ndeclare var localStorage: Storage;\n/**\n * Fires when the user aborts the download.\n * @param ev The event.\n */\ndeclare var onabort: ((this: Window, ev: UIEvent) => any) | null;\ndeclare var onanimationcancel: ((this: Window, ev: AnimationEvent) => any) | null;\ndeclare var onanimationend: ((this: Window, ev: AnimationEvent) => any) | null;\ndeclare var onanimationiteration: ((this: Window, ev: AnimationEvent) => any) | null;\ndeclare var onanimationstart: ((this: Window, ev: AnimationEvent) => any) | null;\ndeclare var onauxclick: ((this: Window, ev: MouseEvent) => any) | null;\n/**\n * Fires when the object loses the input focus.\n * @param ev The focus event.\n */\ndeclare var onblur: ((this: Window, ev: FocusEvent) => any) | null;\ndeclare var oncancel: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when playback is possible, but would require further buffering.\n * @param ev The event.\n */\ndeclare var oncanplay: ((this: Window, ev: Event) => any) | null;\ndeclare var oncanplaythrough: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when the contents of the object or selection have changed.\n * @param ev The event.\n */\ndeclare var onchange: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when the user clicks the left mouse button on the object\n * @param ev The mouse event.\n */\ndeclare var onclick: ((this: Window, ev: MouseEvent) => any) | null;\ndeclare var onclose: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when the user clicks the right mouse button in the client area, opening the context menu.\n * @param ev The mouse event.\n */\ndeclare var oncontextmenu: ((this: Window, ev: MouseEvent) => any) | null;\ndeclare var oncuechange: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when the user double-clicks the object.\n * @param ev The mouse event.\n */\ndeclare var ondblclick: ((this: Window, ev: MouseEvent) => any) | null;\n/**\n * Fires on the source object continuously during a drag operation.\n * @param ev The event.\n */\ndeclare var ondrag: ((this: Window, ev: DragEvent) => any) | null;\n/**\n * Fires on the source object when the user releases the mouse at the close of a drag operation.\n * @param ev The event.\n */\ndeclare var ondragend: ((this: Window, ev: DragEvent) => any) | null;\n/**\n * Fires on the target element when the user drags the object to a valid drop target.\n * @param ev The drag event.\n */\ndeclare var ondragenter: ((this: Window, ev: DragEvent) => any) | null;\ndeclare var ondragexit: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires on the target object when the user moves the mouse out of a valid drop target during a drag operation.\n * @param ev The drag event.\n */\ndeclare var ondragleave: ((this: Window, ev: DragEvent) => any) | null;\n/**\n * Fires on the target element continuously while the user drags the object over a valid drop target.\n * @param ev The event.\n */\ndeclare var ondragover: ((this: Window, ev: DragEvent) => any) | null;\n/**\n * Fires on the source object when the user starts to drag a text selection or selected object.\n * @param ev The event.\n */\ndeclare var ondragstart: ((this: Window, ev: DragEvent) => any) | null;\ndeclare var ondrop: ((this: Window, ev: DragEvent) => any) | null;\n/**\n * Occurs when the duration attribute is updated.\n * @param ev The event.\n */\ndeclare var ondurationchange: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when the media element is reset to its initial state.\n * @param ev The event.\n */\ndeclare var onemptied: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when the end of playback is reached.\n * @param ev The event\n */\ndeclare var onended: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when an error occurs during object loading.\n * @param ev The event.\n */\ndeclare var onerror: OnErrorEventHandler;\n/**\n * Fires when the object receives focus.\n * @param ev The event.\n */\ndeclare var onfocus: ((this: Window, ev: FocusEvent) => any) | null;\ndeclare var ongotpointercapture: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var oninput: ((this: Window, ev: Event) => any) | null;\ndeclare var oninvalid: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when the user presses a key.\n * @param ev The keyboard event\n */\ndeclare var onkeydown: ((this: Window, ev: KeyboardEvent) => any) | null;\n/**\n * Fires when the user presses an alphanumeric key.\n * @param ev The event.\n */\ndeclare var onkeypress: ((this: Window, ev: KeyboardEvent) => any) | null;\n/**\n * Fires when the user releases a key.\n * @param ev The keyboard event\n */\ndeclare var onkeyup: ((this: Window, ev: KeyboardEvent) => any) | null;\n/**\n * Fires immediately after the browser loads the object.\n * @param ev The event.\n */\ndeclare var onload: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when media data is loaded at the current playback position.\n * @param ev The event.\n */\ndeclare var onloadeddata: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when the duration and dimensions of the media have been determined.\n * @param ev The event.\n */\ndeclare var onloadedmetadata: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when Internet Explorer begins looking for media data.\n * @param ev The event.\n */\ndeclare var onloadstart: ((this: Window, ev: Event) => any) | null;\ndeclare var onlostpointercapture: ((this: Window, ev: PointerEvent) => any) | null;\n/**\n * Fires when the user clicks the object with either mouse button.\n * @param ev The mouse event.\n */\ndeclare var onmousedown: ((this: Window, ev: MouseEvent) => any) | null;\ndeclare var onmouseenter: ((this: Window, ev: MouseEvent) => any) | null;\ndeclare var onmouseleave: ((this: Window, ev: MouseEvent) => any) | null;\n/**\n * Fires when the user moves the mouse over the object.\n * @param ev The mouse event.\n */\ndeclare var onmousemove: ((this: Window, ev: MouseEvent) => any) | null;\n/**\n * Fires when the user moves the mouse pointer outside the boundaries of the object.\n * @param ev The mouse event.\n */\ndeclare var onmouseout: ((this: Window, ev: MouseEvent) => any) | null;\n/**\n * Fires when the user moves the mouse pointer into the object.\n * @param ev The mouse event.\n */\ndeclare var onmouseover: ((this: Window, ev: MouseEvent) => any) | null;\n/**\n * Fires when the user releases a mouse button while the mouse is over the object.\n * @param ev The mouse event.\n */\ndeclare var onmouseup: ((this: Window, ev: MouseEvent) => any) | null;\n/**\n * Occurs when playback is paused.\n * @param ev The event.\n */\ndeclare var onpause: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when the play method is requested.\n * @param ev The event.\n */\ndeclare var onplay: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when the audio or video has started playing.\n * @param ev The event.\n */\ndeclare var onplaying: ((this: Window, ev: Event) => any) | null;\ndeclare var onpointercancel: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var onpointerdown: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var onpointerenter: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var onpointerleave: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var onpointermove: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var onpointerout: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var onpointerover: ((this: Window, ev: PointerEvent) => any) | null;\ndeclare var onpointerup: ((this: Window, ev: PointerEvent) => any) | null;\n/**\n * Occurs to indicate progress while downloading media data.\n * @param ev The event.\n */\ndeclare var onprogress: ((this: Window, ev: ProgressEvent) => any) | null;\n/**\n * Occurs when the playback rate is increased or decreased.\n * @param ev The event.\n */\ndeclare var onratechange: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when the user resets a form.\n * @param ev The event.\n */\ndeclare var onreset: ((this: Window, ev: Event) => any) | null;\ndeclare var onresize: ((this: Window, ev: UIEvent) => any) | null;\n/**\n * Fires when the user repositions the scroll box in the scroll bar on the object.\n * @param ev The event.\n */\ndeclare var onscroll: ((this: Window, ev: Event) => any) | null;\ndeclare var onsecuritypolicyviolation: ((this: Window, ev: SecurityPolicyViolationEvent) => any) | null;\n/**\n * Occurs when the seek operation ends.\n * @param ev The event.\n */\ndeclare var onseeked: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when the current playback position is moved.\n * @param ev The event.\n */\ndeclare var onseeking: ((this: Window, ev: Event) => any) | null;\n/**\n * Fires when the current selection changes.\n * @param ev The event.\n */\ndeclare var onselect: ((this: Window, ev: Event) => any) | null;\ndeclare var onselectionchange: ((this: Window, ev: Event) => any) | null;\ndeclare var onselectstart: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when the download has stopped.\n * @param ev The event.\n */\ndeclare var onstalled: ((this: Window, ev: Event) => any) | null;\ndeclare var onsubmit: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs if the load operation has been intentionally halted.\n * @param ev The event.\n */\ndeclare var onsuspend: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs to indicate the current playback position.\n * @param ev The event.\n */\ndeclare var ontimeupdate: ((this: Window, ev: Event) => any) | null;\ndeclare var ontoggle: ((this: Window, ev: Event) => any) | null;\ndeclare var ontouchcancel: ((this: Window, ev: TouchEvent) => any) | null | undefined;\ndeclare var ontouchend: ((this: Window, ev: TouchEvent) => any) | null | undefined;\ndeclare var ontouchmove: ((this: Window, ev: TouchEvent) => any) | null | undefined;\ndeclare var ontouchstart: ((this: Window, ev: TouchEvent) => any) | null | undefined;\ndeclare var ontransitioncancel: ((this: Window, ev: TransitionEvent) => any) | null;\ndeclare var ontransitionend: ((this: Window, ev: TransitionEvent) => any) | null;\ndeclare var ontransitionrun: ((this: Window, ev: TransitionEvent) => any) | null;\ndeclare var ontransitionstart: ((this: Window, ev: TransitionEvent) => any) | null;\n/**\n * Occurs when the volume is changed, or playback is muted or unmuted.\n * @param ev The event.\n */\ndeclare var onvolumechange: ((this: Window, ev: Event) => any) | null;\n/**\n * Occurs when playback stops because the next frame of a video resource is not available.\n * @param ev The event.\n */\ndeclare var onwaiting: ((this: Window, ev: Event) => any) | null;\ndeclare var onwheel: ((this: Window, ev: WheelEvent) => any) | null;\ndeclare function cancelAnimationFrame(handle: number): void;\ndeclare function requestAnimationFrame(callback: FrameRequestCallback): number;\ndeclare var caches: CacheStorage;\ndeclare var crypto: Crypto;\ndeclare var indexedDB: IDBFactory;\ndeclare var isSecureContext: boolean;\ndeclare var origin: string;\ndeclare var performance: Performance;\ndeclare function atob(data: string): string;\ndeclare function btoa(data: string): string;\ndeclare function clearInterval(handle?: number): void;\ndeclare function clearTimeout(handle?: number): void;\ndeclare function createImageBitmap(image: ImageBitmapSource, options?: ImageBitmapOptions): Promise<ImageBitmap>;\ndeclare function createImageBitmap(image: ImageBitmapSource, sx: number, sy: number, sw: number, sh: number, options?: ImageBitmapOptions): Promise<ImageBitmap>;\ndeclare function fetch(input: RequestInfo, init?: RequestInit): Promise<Response>;\ndeclare function queueMicrotask(callback: VoidFunction): void;\ndeclare function setInterval(handler: TimerHandler, timeout?: number, ...arguments: any[]): number;\ndeclare function setTimeout(handler: TimerHandler, timeout?: number, ...arguments: any[]): number;\ndeclare var onafterprint: ((this: Window, ev: Event) => any) | null;\ndeclare var onbeforeprint: ((this: Window, ev: Event) => any) | null;\ndeclare var onbeforeunload: ((this: Window, ev: BeforeUnloadEvent) => any) | null;\ndeclare var onhashchange: ((this: Window, ev: HashChangeEvent) => any) | null;\ndeclare var onlanguagechange: ((this: Window, ev: Event) => any) | null;\ndeclare var onmessage: ((this: Window, ev: MessageEvent) => any) | null;\ndeclare var onmessageerror: ((this: Window, ev: MessageEvent) => any) | null;\ndeclare var onoffline: ((this: Window, ev: Event) => any) | null;\ndeclare var ononline: ((this: Window, ev: Event) => any) | null;\ndeclare var onpagehide: ((this: Window, ev: PageTransitionEvent) => any) | null;\ndeclare var onpageshow: ((this: Window, ev: PageTransitionEvent) => any) | null;\ndeclare var onpopstate: ((this: Window, ev: PopStateEvent) => any) | null;\ndeclare var onrejectionhandled: ((this: Window, ev: PromiseRejectionEvent) => any) | null;\ndeclare var onstorage: ((this: Window, ev: StorageEvent) => any) | null;\ndeclare var onunhandledrejection: ((this: Window, ev: PromiseRejectionEvent) => any) | null;\ndeclare var onunload: ((this: Window, ev: Event) => any) | null;\ndeclare function addEventListener<K extends keyof WindowEventMap>(type: K, listener: (this: Window, ev: WindowEventMap[K]) => any, options?: boolean | AddEventListenerOptions): void;\ndeclare function addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions): void;\ndeclare function removeEventListener<K extends keyof WindowEventMap>(type: K, listener: (this: Window, ev: WindowEventMap[K]) => any, options?: boolean | EventListenerOptions): void;\ndeclare function removeEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions): void;\ntype HeadersInit = Headers | string[][] | Record<string, string>;\ntype BodyInit = Blob | BufferSource | FormData | URLSearchParams | ReadableStream<Uint8Array> | string;\ntype RequestInfo = Request | string;\ntype BlobPart = BufferSource | Blob | string;\ntype DOMHighResTimeStamp = number;\ntype RenderingContext = CanvasRenderingContext2D | ImageBitmapRenderingContext | WebGLRenderingContext | WebGL2RenderingContext;\ntype HTMLOrSVGImageElement = HTMLImageElement | SVGImageElement;\ntype CanvasImageSource = HTMLOrSVGImageElement | HTMLVideoElement | HTMLCanvasElement | ImageBitmap | OffscreenCanvas;\ntype OffscreenRenderingContext = OffscreenCanvasRenderingContext2D | ImageBitmapRenderingContext | WebGLRenderingContext | WebGL2RenderingContext;\ntype MessageEventSource = WindowProxy | MessagePort | ServiceWorker;\ntype HTMLOrSVGScriptElement = HTMLScriptElement | SVGScriptElement;\ntype ImageBitmapSource = CanvasImageSource | Blob | ImageData;\ntype MediaProvider = MediaStream | MediaSource | Blob;\ntype OnErrorEventHandler = OnErrorEventHandlerNonNull | null;\ntype OnBeforeUnloadEventHandler = OnBeforeUnloadEventHandlerNonNull | null;\ntype TimerHandler = string | Function;\ntype ConstrainULong = number | ConstrainULongRange;\ntype ConstrainDouble = number | ConstrainDoubleRange;\ntype ConstrainBoolean = boolean | ConstrainBooleanParameters;\ntype ConstrainDOMString = string | string[] | ConstrainDOMStringParameters;\ntype PerformanceEntryList = PerformanceEntry[];\ntype ReadableStreamReadResult<T> = ReadableStreamReadValueResult<T> | ReadableStreamReadDoneResult<T>;\ntype VibratePattern = number | number[];\ntype COSEAlgorithmIdentifier = number;\ntype UvmEntry = number[];\ntype UvmEntries = UvmEntry[];\ntype AlgorithmIdentifier = string | Algorithm;\ntype HashAlgorithmIdentifier = AlgorithmIdentifier;\ntype BigInteger = Uint8Array;\ntype NamedCurve = string;\ntype GLenum = number;\ntype GLboolean = boolean;\ntype GLbitfield = number;\ntype GLint = number;\ntype GLsizei = number;\ntype GLintptr = number;\ntype GLsizeiptr = number;\ntype GLuint = number;\ntype GLfloat = number;\ntype GLclampf = number;\ntype TexImageSource = ImageBitmap | ImageData | HTMLImageElement | HTMLCanvasElement | HTMLVideoElement | OffscreenCanvas;\ntype Float32List = Float32Array | GLfloat[];\ntype Int32List = Int32Array | GLint[];\ntype GLint64 = number;\ntype GLuint64 = number;\ntype Uint32List = Uint32Array | GLuint[];\ntype BufferSource = ArrayBufferView | ArrayBuffer;\ntype DOMTimeStamp = number;\ntype LineAndPositionSetting = number | AutoKeyword;\ntype FormDataEntryValue = File | string;\ntype InsertPosition = \"beforebegin\" | \"afterbegin\" | \"beforeend\" | \"afterend\";\ntype IDBValidKey = number | string | Date | BufferSource | IDBArrayKey;\ntype MutationRecordType = \"attributes\" | \"characterData\" | \"childList\";\ntype IDBKeyPath = string;\ntype Transferable = ArrayBuffer | MessagePort | ImageBitmap | OffscreenCanvas;\ntype RTCIceGatherCandidate = RTCIceCandidateDictionary | RTCIceCandidateComplete;\ntype RTCTransport = RTCDtlsTransport | RTCSrtpSdesTransport;\n/** @deprecated */\ntype MouseWheelEvent = WheelEvent;\ntype WindowProxy = Window;\ntype AlignSetting = \"center\" | \"end\" | \"left\" | \"right\" | \"start\";\ntype AnimationPlayState = \"finished\" | \"idle\" | \"paused\" | \"running\";\ntype AppendMode = \"segments\" | \"sequence\";\ntype AttestationConveyancePreference = \"direct\" | \"enterprise\" | \"indirect\" | \"none\";\ntype AudioContextLatencyCategory = \"balanced\" | \"interactive\" | \"playback\";\ntype AudioContextState = \"closed\" | \"running\" | \"suspended\";\ntype AuthenticatorAttachment = \"cross-platform\" | \"platform\";\ntype AuthenticatorTransport = \"ble\" | \"internal\" | \"nfc\" | \"usb\";\ntype AutoKeyword = \"auto\";\ntype AutomationRate = \"a-rate\" | \"k-rate\";\ntype BinaryType = \"arraybuffer\" | \"blob\";\ntype BiquadFilterType = \"allpass\" | \"bandpass\" | \"highpass\" | \"highshelf\" | \"lowpass\" | \"lowshelf\" | \"notch\" | \"peaking\";\ntype CanPlayTypeResult = \"\" | \"maybe\" | \"probably\";\ntype CanvasDirection = \"inherit\" | \"ltr\" | \"rtl\";\ntype CanvasFillRule = \"evenodd\" | \"nonzero\";\ntype CanvasLineCap = \"butt\" | \"round\" | \"square\";\ntype CanvasLineJoin = \"bevel\" | \"miter\" | \"round\";\ntype CanvasTextAlign = \"center\" | \"end\" | \"left\" | \"right\" | \"start\";\ntype CanvasTextBaseline = \"alphabetic\" | \"bottom\" | \"hanging\" | \"ideographic\" | \"middle\" | \"top\";\ntype ChannelCountMode = \"clamped-max\" | \"explicit\" | \"max\";\ntype ChannelInterpretation = \"discrete\" | \"speakers\";\ntype ClientTypes = \"all\" | \"sharedworker\" | \"window\" | \"worker\";\ntype ColorSpaceConversion = \"default\" | \"none\";\ntype CompositeOperation = \"accumulate\" | \"add\" | \"replace\";\ntype CompositeOperationOrAuto = \"accumulate\" | \"add\" | \"auto\" | \"replace\";\ntype CredentialMediationRequirement = \"optional\" | \"required\" | \"silent\";\ntype DOMParserSupportedType = \"application/xhtml+xml\" | \"application/xml\" | \"image/svg+xml\" | \"text/html\" | \"text/xml\";\ntype DirectionSetting = \"\" | \"lr\" | \"rl\";\ntype DisplayCaptureSurfaceType = \"application\" | \"browser\" | \"monitor\" | \"window\";\ntype DistanceModelType = \"exponential\" | \"inverse\" | \"linear\";\ntype DocumentReadyState = \"complete\" | \"interactive\" | \"loading\";\ntype EndOfStreamError = \"decode\" | \"network\";\ntype EndingType = \"native\" | \"transparent\";\ntype FillMode = \"auto\" | \"backwards\" | \"both\" | \"forwards\" | \"none\";\ntype FullscreenNavigationUI = \"auto\" | \"hide\" | \"show\";\ntype GamepadHand = \"\" | \"left\" | \"right\";\ntype GamepadHapticActuatorType = \"vibration\";\ntype GamepadMappingType = \"\" | \"standard\";\ntype IDBCursorDirection = \"next\" | \"nextunique\" | \"prev\" | \"prevunique\";\ntype IDBRequestReadyState = \"done\" | \"pending\";\ntype IDBTransactionMode = \"readonly\" | \"readwrite\" | \"versionchange\";\ntype ImageOrientation = \"flipY\" | \"none\";\ntype ImageSmoothingQuality = \"high\" | \"low\" | \"medium\";\ntype IterationCompositeOperation = \"accumulate\" | \"replace\";\ntype KeyFormat = \"jwk\" | \"pkcs8\" | \"raw\" | \"spki\";\ntype KeyType = \"private\" | \"public\" | \"secret\";\ntype KeyUsage = \"decrypt\" | \"deriveBits\" | \"deriveKey\" | \"encrypt\" | \"sign\" | \"unwrapKey\" | \"verify\" | \"wrapKey\";\ntype LineAlignSetting = \"center\" | \"end\" | \"start\";\ntype ListeningState = \"active\" | \"disambiguation\" | \"inactive\";\ntype MSCredentialType = \"FIDO_2_0\";\ntype MSTransportType = \"BT\" | \"Embedded\" | \"NFC\" | \"USB\";\ntype MSWebViewPermissionState = \"allow\" | \"defer\" | \"deny\" | \"unknown\";\ntype MSWebViewPermissionType = \"geolocation\" | \"media\" | \"pointerlock\" | \"unlimitedIndexedDBQuota\" | \"webnotifications\";\ntype MediaDeviceKind = \"audioinput\" | \"audiooutput\" | \"videoinput\";\ntype MediaKeyMessageType = \"individualization-request\" | \"license-release\" | \"license-renewal\" | \"license-request\";\ntype MediaKeySessionType = \"persistent-license\" | \"temporary\";\ntype MediaKeyStatus = \"expired\" | \"internal-error\" | \"output-downscaled\" | \"output-restricted\" | \"released\" | \"status-pending\" | \"usable\";\ntype MediaKeysRequirement = \"not-allowed\" | \"optional\" | \"required\";\ntype MediaStreamTrackState = \"ended\" | \"live\";\ntype NavigationReason = \"down\" | \"left\" | \"right\" | \"up\";\ntype NavigationType = \"back_forward\" | \"navigate\" | \"prerender\" | \"reload\";\ntype NotificationDirection = \"auto\" | \"ltr\" | \"rtl\";\ntype NotificationPermission = \"default\" | \"denied\" | \"granted\";\ntype OffscreenRenderingContextId = \"2d\" | \"bitmaprenderer\" | \"webgl\" | \"webgl2\";\ntype OrientationLockType = \"any\" | \"landscape\" | \"landscape-primary\" | \"landscape-secondary\" | \"natural\" | \"portrait\" | \"portrait-primary\" | \"portrait-secondary\";\ntype OrientationType = \"landscape-primary\" | \"landscape-secondary\" | \"portrait-primary\" | \"portrait-secondary\";\ntype OscillatorType = \"custom\" | \"sawtooth\" | \"sine\" | \"square\" | \"triangle\";\ntype OverSampleType = \"2x\" | \"4x\" | \"none\";\ntype PanningModelType = \"HRTF\" | \"equalpower\";\ntype PaymentComplete = \"fail\" | \"success\" | \"unknown\";\ntype PaymentShippingType = \"delivery\" | \"pickup\" | \"shipping\";\ntype PermissionName = \"accelerometer\" | \"ambient-light-sensor\" | \"background-sync\" | \"bluetooth\" | \"camera\" | \"clipboard\" | \"device-info\" | \"geolocation\" | \"gyroscope\" | \"magnetometer\" | \"microphone\" | \"midi\" | \"notifications\" | \"persistent-storage\" | \"push\" | \"speaker\";\ntype PermissionState = \"denied\" | \"granted\" | \"prompt\";\ntype PlaybackDirection = \"alternate\" | \"alternate-reverse\" | \"normal\" | \"reverse\";\ntype PositionAlignSetting = \"auto\" | \"center\" | \"line-left\" | \"line-right\";\ntype PremultiplyAlpha = \"default\" | \"none\" | \"premultiply\";\ntype PublicKeyCredentialType = \"public-key\";\ntype PushEncryptionKeyName = \"auth\" | \"p256dh\";\ntype PushPermissionState = \"denied\" | \"granted\" | \"prompt\";\ntype RTCBundlePolicy = \"balanced\" | \"max-bundle\" | \"max-compat\";\ntype RTCDataChannelState = \"closed\" | \"closing\" | \"connecting\" | \"open\";\ntype RTCDegradationPreference = \"balanced\" | \"maintain-framerate\" | \"maintain-resolution\";\ntype RTCDtlsRole = \"auto\" | \"client\" | \"server\";\ntype RTCDtlsTransportState = \"closed\" | \"connected\" | \"connecting\" | \"failed\" | \"new\";\ntype RTCDtxStatus = \"disabled\" | \"enabled\";\ntype RTCErrorDetailType = \"data-channel-failure\" | \"dtls-failure\" | \"fingerprint-failure\" | \"hardware-encoder-error\" | \"hardware-encoder-not-available\" | \"idp-bad-script-failure\" | \"idp-execution-failure\" | \"idp-load-failure\" | \"idp-need-login\" | \"idp-timeout\" | \"idp-tls-failure\" | \"idp-token-expired\" | \"idp-token-invalid\" | \"sctp-failure\" | \"sdp-syntax-error\";\ntype RTCIceCandidateType = \"host\" | \"prflx\" | \"relay\" | \"srflx\";\ntype RTCIceComponent = \"rtcp\" | \"rtp\";\ntype RTCIceConnectionState = \"checking\" | \"closed\" | \"completed\" | \"connected\" | \"disconnected\" | \"failed\" | \"new\";\ntype RTCIceCredentialType = \"oauth\" | \"password\";\ntype RTCIceGatherPolicy = \"all\" | \"nohost\" | \"relay\";\ntype RTCIceGathererState = \"complete\" | \"gathering\" | \"new\";\ntype RTCIceGatheringState = \"complete\" | \"gathering\" | \"new\";\ntype RTCIceProtocol = \"tcp\" | \"udp\";\ntype RTCIceRole = \"controlled\" | \"controlling\" | \"unknown\";\ntype RTCIceTcpCandidateType = \"active\" | \"passive\" | \"so\";\ntype RTCIceTransportPolicy = \"all\" | \"relay\";\ntype RTCIceTransportState = \"checking\" | \"closed\" | \"completed\" | \"connected\" | \"disconnected\" | \"failed\" | \"new\";\ntype RTCPeerConnectionState = \"closed\" | \"connected\" | \"connecting\" | \"disconnected\" | \"failed\" | \"new\";\ntype RTCPriorityType = \"high\" | \"low\" | \"medium\" | \"very-low\";\ntype RTCRtcpMuxPolicy = \"negotiate\" | \"require\";\ntype RTCRtpTransceiverDirection = \"inactive\" | \"recvonly\" | \"sendonly\" | \"sendrecv\" | \"stopped\";\ntype RTCSctpTransportState = \"closed\" | \"connected\" | \"connecting\";\ntype RTCSdpType = \"answer\" | \"offer\" | \"pranswer\" | \"rollback\";\ntype RTCSignalingState = \"closed\" | \"have-local-offer\" | \"have-local-pranswer\" | \"have-remote-offer\" | \"have-remote-pranswer\" | \"stable\";\ntype RTCStatsIceCandidatePairState = \"cancelled\" | \"failed\" | \"frozen\" | \"inprogress\" | \"succeeded\" | \"waiting\";\ntype RTCStatsIceCandidateType = \"host\" | \"peerreflexive\" | \"relayed\" | \"serverreflexive\";\ntype RTCStatsType = \"candidatepair\" | \"datachannel\" | \"inboundrtp\" | \"localcandidate\" | \"outboundrtp\" | \"remotecandidate\" | \"session\" | \"track\" | \"transport\";\ntype ReadyState = \"closed\" | \"ended\" | \"open\";\ntype ReferrerPolicy = \"\" | \"no-referrer\" | \"no-referrer-when-downgrade\" | \"origin\" | \"origin-when-cross-origin\" | \"same-origin\" | \"strict-origin\" | \"strict-origin-when-cross-origin\" | \"unsafe-url\";\ntype RequestCache = \"default\" | \"force-cache\" | \"no-cache\" | \"no-store\" | \"only-if-cached\" | \"reload\";\ntype RequestCredentials = \"include\" | \"omit\" | \"same-origin\";\ntype RequestDestination = \"\" | \"audio\" | \"audioworklet\" | \"document\" | \"embed\" | \"font\" | \"image\" | \"manifest\" | \"object\" | \"paintworklet\" | \"report\" | \"script\" | \"sharedworker\" | \"style\" | \"track\" | \"video\" | \"worker\" | \"xslt\";\ntype RequestMode = \"cors\" | \"navigate\" | \"no-cors\" | \"same-origin\";\ntype RequestRedirect = \"error\" | \"follow\" | \"manual\";\ntype ResidentKeyRequirement = \"discouraged\" | \"preferred\" | \"required\";\ntype ResizeQuality = \"high\" | \"low\" | \"medium\" | \"pixelated\";\ntype ResponseType = \"basic\" | \"cors\" | \"default\" | \"error\" | \"opaque\" | \"opaqueredirect\";\ntype ScopedCredentialType = \"ScopedCred\";\ntype ScrollBehavior = \"auto\" | \"smooth\";\ntype ScrollLogicalPosition = \"center\" | \"end\" | \"nearest\" | \"start\";\ntype ScrollRestoration = \"auto\" | \"manual\";\ntype ScrollSetting = \"\" | \"up\";\ntype SelectionMode = \"end\" | \"preserve\" | \"select\" | \"start\";\ntype ServiceWorkerState = \"activated\" | \"activating\" | \"installed\" | \"installing\" | \"parsed\" | \"redundant\";\ntype ServiceWorkerUpdateViaCache = \"all\" | \"imports\" | \"none\";\ntype ShadowRootMode = \"closed\" | \"open\";\ntype SpeechSynthesisErrorCode = \"audio-busy\" | \"audio-hardware\" | \"canceled\" | \"interrupted\" | \"invalid-argument\" | \"language-unavailable\" | \"network\" | \"not-allowed\" | \"synthesis-failed\" | \"synthesis-unavailable\" | \"text-too-long\" | \"voice-unavailable\";\ntype TextTrackKind = \"captions\" | \"chapters\" | \"descriptions\" | \"metadata\" | \"subtitles\";\ntype TextTrackMode = \"disabled\" | \"hidden\" | \"showing\";\ntype TouchType = \"direct\" | \"stylus\";\ntype Transport = \"ble\" | \"nfc\" | \"usb\";\ntype UserVerificationRequirement = \"discouraged\" | \"preferred\" | \"required\";\ntype VRDisplayEventReason = \"mounted\" | \"navigation\" | \"requested\" | \"unmounted\";\ntype VideoFacingModeEnum = \"environment\" | \"left\" | \"right\" | \"user\";\ntype VisibilityState = \"hidden\" | \"visible\";\ntype WebGLPowerPreference = \"default\" | \"high-performance\" | \"low-power\";\ntype WorkerType = \"classic\" | \"module\";\ntype XMLHttpRequestResponseType = \"\" | \"arraybuffer\" | \"blob\" | \"document\" | \"json\" | \"text\";\n";
libFileMap['lib.dom.iterable.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/////////////////////////////\n/// DOM Iterable APIs\n/////////////////////////////\n\ninterface AudioParam {\n    setValueCurveAtTime(values: Iterable<number>, startTime: number, duration: number): AudioParam;\n}\n\ninterface AudioParamMap extends ReadonlyMap<string, AudioParam> {\n}\n\ninterface BaseAudioContext {\n    createIIRFilter(feedforward: Iterable<number>, feedback: Iterable<number>): IIRFilterNode;\n    createPeriodicWave(real: Iterable<number>, imag: Iterable<number>, constraints?: PeriodicWaveConstraints): PeriodicWave;\n}\n\ninterface CSSRuleList {\n    [Symbol.iterator](): IterableIterator<CSSRule>;\n}\n\ninterface CSSStyleDeclaration {\n    [Symbol.iterator](): IterableIterator<string>;\n}\n\ninterface Cache {\n    addAll(requests: Iterable<RequestInfo>): Promise<void>;\n}\n\ninterface CanvasPathDrawingStyles {\n    setLineDash(segments: Iterable<number>): void;\n}\n\ninterface ClientRectList {\n    [Symbol.iterator](): IterableIterator<ClientRect>;\n}\n\ninterface DOMRectList {\n    [Symbol.iterator](): IterableIterator<DOMRect>;\n}\n\ninterface DOMStringList {\n    [Symbol.iterator](): IterableIterator<string>;\n}\n\ninterface DOMTokenList {\n    [Symbol.iterator](): IterableIterator<string>;\n    entries(): IterableIterator<[number, string]>;\n    keys(): IterableIterator<number>;\n    values(): IterableIterator<string>;\n}\n\ninterface DataTransferItemList {\n    [Symbol.iterator](): IterableIterator<DataTransferItem>;\n}\n\ninterface FileList {\n    [Symbol.iterator](): IterableIterator<File>;\n}\n\ninterface FormData {\n    [Symbol.iterator](): IterableIterator<[string, FormDataEntryValue]>;\n    /**\n     * Returns an array of key, value pairs for every entry in the list.\n     */\n    entries(): IterableIterator<[string, FormDataEntryValue]>;\n    /**\n     * Returns a list of keys in the list.\n     */\n    keys(): IterableIterator<string>;\n    /**\n     * Returns a list of values in the list.\n     */\n    values(): IterableIterator<FormDataEntryValue>;\n}\n\ninterface HTMLAllCollection {\n    [Symbol.iterator](): IterableIterator<Element>;\n}\n\ninterface HTMLCollectionBase {\n    [Symbol.iterator](): IterableIterator<Element>;\n}\n\ninterface HTMLCollectionOf<T extends Element> {\n    [Symbol.iterator](): IterableIterator<T>;\n}\n\ninterface HTMLFormElement {\n    [Symbol.iterator](): IterableIterator<Element>;\n}\n\ninterface HTMLSelectElement {\n    [Symbol.iterator](): IterableIterator<Element>;\n}\n\ninterface Headers {\n    [Symbol.iterator](): IterableIterator<[string, string]>;\n    /**\n     * Returns an iterator allowing to go through all key/value pairs contained in this object.\n     */\n    entries(): IterableIterator<[string, string]>;\n    /**\n     * Returns an iterator allowing to go through all keys of the key/value pairs contained in this object.\n     */\n    keys(): IterableIterator<string>;\n    /**\n     * Returns an iterator allowing to go through all values of the key/value pairs contained in this object.\n     */\n    values(): IterableIterator<string>;\n}\n\ninterface IDBDatabase {\n    /**\n     * Returns a new transaction with the given mode (\"readonly\" or \"readwrite\") and scope which can be a single object store name or an array of names.\n     */\n    transaction(storeNames: string | Iterable<string>, mode?: IDBTransactionMode): IDBTransaction;\n}\n\ninterface IDBObjectStore {\n    /**\n     * Creates a new index in store with the given name, keyPath and options and returns a new IDBIndex. If the keyPath and options define constraints that cannot be satisfied with the data already in store the upgrade transaction will abort with a \"ConstraintError\" DOMException.\n     * \n     * Throws an \"InvalidStateError\" DOMException if not called within an upgrade transaction.\n     */\n    createIndex(name: string, keyPath: string | Iterable<string>, options?: IDBIndexParameters): IDBIndex;\n}\n\ninterface MediaKeyStatusMap {\n    [Symbol.iterator](): IterableIterator<[BufferSource, MediaKeyStatus]>;\n    entries(): IterableIterator<[BufferSource, MediaKeyStatus]>;\n    keys(): IterableIterator<BufferSource>;\n    values(): IterableIterator<MediaKeyStatus>;\n}\n\ninterface MediaList {\n    [Symbol.iterator](): IterableIterator<string>;\n}\n\ninterface MimeTypeArray {\n    [Symbol.iterator](): IterableIterator<MimeType>;\n}\n\ninterface NamedNodeMap {\n    [Symbol.iterator](): IterableIterator<Attr>;\n}\n\ninterface Navigator {\n    requestMediaKeySystemAccess(keySystem: string, supportedConfigurations: Iterable<MediaKeySystemConfiguration>): Promise<MediaKeySystemAccess>;\n}\n\ninterface NodeList {\n    [Symbol.iterator](): IterableIterator<Node>;\n    /**\n     * Returns an array of key, value pairs for every entry in the list.\n     */\n    entries(): IterableIterator<[number, Node]>;\n    /**\n     * Returns an list of keys in the list.\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the list.\n     */\n    values(): IterableIterator<Node>;\n}\n\ninterface NodeListOf<TNode extends Node> {\n    [Symbol.iterator](): IterableIterator<TNode>;\n    /**\n     * Returns an array of key, value pairs for every entry in the list.\n     */\n    entries(): IterableIterator<[number, TNode]>;\n    /**\n     * Returns an list of keys in the list.\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the list.\n     */\n    values(): IterableIterator<TNode>;\n}\n\ninterface Plugin {\n    [Symbol.iterator](): IterableIterator<MimeType>;\n}\n\ninterface PluginArray {\n    [Symbol.iterator](): IterableIterator<Plugin>;\n}\n\ninterface RTCRtpTransceiver {\n    setCodecPreferences(codecs: Iterable<RTCRtpCodecCapability>): void;\n}\n\ninterface RTCStatsReport extends ReadonlyMap<string, any> {\n}\n\ninterface SVGLengthList {\n    [Symbol.iterator](): IterableIterator<SVGLength>;\n}\n\ninterface SVGNumberList {\n    [Symbol.iterator](): IterableIterator<SVGNumber>;\n}\n\ninterface SVGPointList {\n    [Symbol.iterator](): IterableIterator<DOMPoint>;\n}\n\ninterface SVGStringList {\n    [Symbol.iterator](): IterableIterator<string>;\n}\n\ninterface SourceBufferList {\n    [Symbol.iterator](): IterableIterator<SourceBuffer>;\n}\n\ninterface SpeechGrammarList {\n    [Symbol.iterator](): IterableIterator<SpeechGrammar>;\n}\n\ninterface SpeechRecognitionResult {\n    [Symbol.iterator](): IterableIterator<SpeechRecognitionAlternative>;\n}\n\ninterface SpeechRecognitionResultList {\n    [Symbol.iterator](): IterableIterator<SpeechRecognitionResult>;\n}\n\ninterface StyleSheetList {\n    [Symbol.iterator](): IterableIterator<CSSStyleSheet>;\n}\n\ninterface TextTrackCueList {\n    [Symbol.iterator](): IterableIterator<TextTrackCue>;\n}\n\ninterface TextTrackList {\n    [Symbol.iterator](): IterableIterator<TextTrack>;\n}\n\ninterface TouchList {\n    [Symbol.iterator](): IterableIterator<Touch>;\n}\n\ninterface URLSearchParams {\n    [Symbol.iterator](): IterableIterator<[string, string]>;\n    /**\n     * Returns an array of key, value pairs for every entry in the search params.\n     */\n    entries(): IterableIterator<[string, string]>;\n    /**\n     * Returns a list of keys in the search params.\n     */\n    keys(): IterableIterator<string>;\n    /**\n     * Returns a list of values in the search params.\n     */\n    values(): IterableIterator<string>;\n}\n\ninterface VRDisplay {\n    requestPresent(layers: Iterable<VRLayer>): Promise<void>;\n}\n\ninterface WEBGL_draw_buffers {\n    drawBuffersWEBGL(buffers: Iterable<GLenum>): void;\n}\n\ninterface WebAuthentication {\n    makeCredential(accountInformation: Account, cryptoParameters: Iterable<ScopedCredentialParameters>, attestationChallenge: Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array | DataView | ArrayBuffer | null, options?: ScopedCredentialOptions): Promise<ScopedCredentialInfo>;\n}\n\ninterface WebGL2RenderingContextBase {\n    clearBufferfv(buffer: GLenum, drawbuffer: GLint, values: Iterable<GLfloat>, srcOffset?: GLuint): void;\n    clearBufferiv(buffer: GLenum, drawbuffer: GLint, values: Iterable<GLint>, srcOffset?: GLuint): void;\n    clearBufferuiv(buffer: GLenum, drawbuffer: GLint, values: Iterable<GLuint>, srcOffset?: GLuint): void;\n    drawBuffers(buffers: Iterable<GLenum>): void;\n    getActiveUniforms(program: WebGLProgram, uniformIndices: Iterable<GLuint>, pname: GLenum): any;\n    getUniformIndices(program: WebGLProgram, uniformNames: Iterable<string>): Iterable<GLuint> | null;\n    invalidateFramebuffer(target: GLenum, attachments: Iterable<GLenum>): void;\n    invalidateSubFramebuffer(target: GLenum, attachments: Iterable<GLenum>, x: GLint, y: GLint, width: GLsizei, height: GLsizei): void;\n    transformFeedbackVaryings(program: WebGLProgram, varyings: Iterable<string>, bufferMode: GLenum): void;\n    uniform1uiv(location: WebGLUniformLocation | null, data: Iterable<GLuint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform2uiv(location: WebGLUniformLocation | null, data: Iterable<GLuint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform3uiv(location: WebGLUniformLocation | null, data: Iterable<GLuint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform4uiv(location: WebGLUniformLocation | null, data: Iterable<GLuint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix2x3fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix2x4fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix3x2fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix3x4fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix4x2fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix4x3fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    vertexAttribI4iv(index: GLuint, values: Iterable<GLint>): void;\n    vertexAttribI4uiv(index: GLuint, values: Iterable<GLuint>): void;\n}\n\ninterface WebGL2RenderingContextOverloads {\n    uniform1fv(location: WebGLUniformLocation | null, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform1iv(location: WebGLUniformLocation | null, data: Iterable<GLint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform2fv(location: WebGLUniformLocation | null, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform2iv(location: WebGLUniformLocation | null, data: Iterable<GLint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform3fv(location: WebGLUniformLocation | null, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform3iv(location: WebGLUniformLocation | null, data: Iterable<GLint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform4fv(location: WebGLUniformLocation | null, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniform4iv(location: WebGLUniformLocation | null, data: Iterable<GLint>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix2fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix3fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n    uniformMatrix4fv(location: WebGLUniformLocation | null, transpose: GLboolean, data: Iterable<GLfloat>, srcOffset?: GLuint, srcLength?: GLuint): void;\n}\n\ninterface WebGLRenderingContextBase {\n    vertexAttrib1fv(index: GLuint, values: Iterable<GLfloat>): void;\n    vertexAttrib2fv(index: GLuint, values: Iterable<GLfloat>): void;\n    vertexAttrib3fv(index: GLuint, values: Iterable<GLfloat>): void;\n    vertexAttrib4fv(index: GLuint, values: Iterable<GLfloat>): void;\n}\n\ninterface WebGLRenderingContextOverloads {\n    uniform1fv(location: WebGLUniformLocation | null, v: Iterable<GLfloat>): void;\n    uniform1iv(location: WebGLUniformLocation | null, v: Iterable<GLint>): void;\n    uniform2fv(location: WebGLUniformLocation | null, v: Iterable<GLfloat>): void;\n    uniform2iv(location: WebGLUniformLocation | null, v: Iterable<GLint>): void;\n    uniform3fv(location: WebGLUniformLocation | null, v: Iterable<GLfloat>): void;\n    uniform3iv(location: WebGLUniformLocation | null, v: Iterable<GLint>): void;\n    uniform4fv(location: WebGLUniformLocation | null, v: Iterable<GLfloat>): void;\n    uniform4iv(location: WebGLUniformLocation | null, v: Iterable<GLint>): void;\n    uniformMatrix2fv(location: WebGLUniformLocation | null, transpose: GLboolean, value: Iterable<GLfloat>): void;\n    uniformMatrix3fv(location: WebGLUniformLocation | null, transpose: GLboolean, value: Iterable<GLfloat>): void;\n    uniformMatrix4fv(location: WebGLUniformLocation | null, transpose: GLboolean, value: Iterable<GLfloat>): void;\n}\n";
libFileMap['lib.es2015.collection.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ninterface Map<K, V> {\n    clear(): void;\n    delete(key: K): boolean;\n    forEach(callbackfn: (value: V, key: K, map: Map<K, V>) => void, thisArg?: any): void;\n    get(key: K): V | undefined;\n    has(key: K): boolean;\n    set(key: K, value: V): this;\n    readonly size: number;\n}\n\ninterface MapConstructor {\n    new(): Map<any, any>;\n    new<K, V>(entries?: readonly (readonly [K, V])[] | null): Map<K, V>;\n    readonly prototype: Map<any, any>;\n}\ndeclare var Map: MapConstructor;\n\ninterface ReadonlyMap<K, V> {\n    forEach(callbackfn: (value: V, key: K, map: ReadonlyMap<K, V>) => void, thisArg?: any): void;\n    get(key: K): V | undefined;\n    has(key: K): boolean;\n    readonly size: number;\n}\n\ninterface WeakMap<K extends object, V> {\n    delete(key: K): boolean;\n    get(key: K): V | undefined;\n    has(key: K): boolean;\n    set(key: K, value: V): this;\n}\n\ninterface WeakMapConstructor {\n    new <K extends object = object, V = any>(entries?: readonly [K, V][] | null): WeakMap<K, V>;\n    readonly prototype: WeakMap<object, any>;\n}\ndeclare var WeakMap: WeakMapConstructor;\n\ninterface Set<T> {\n    add(value: T): this;\n    clear(): void;\n    delete(value: T): boolean;\n    forEach(callbackfn: (value: T, value2: T, set: Set<T>) => void, thisArg?: any): void;\n    has(value: T): boolean;\n    readonly size: number;\n}\n\ninterface SetConstructor {\n    new <T = any>(values?: readonly T[] | null): Set<T>;\n    readonly prototype: Set<any>;\n}\ndeclare var Set: SetConstructor;\n\ninterface ReadonlySet<T> {\n    forEach(callbackfn: (value: T, value2: T, set: ReadonlySet<T>) => void, thisArg?: any): void;\n    has(value: T): boolean;\n    readonly size: number;\n}\n\ninterface WeakSet<T extends object> {\n    add(value: T): this;\n    delete(value: T): boolean;\n    has(value: T): boolean;\n}\n\ninterface WeakSetConstructor {\n    new <T extends object = object>(values?: readonly T[] | null): WeakSet<T>;\n    readonly prototype: WeakSet<object>;\n}\ndeclare var WeakSet: WeakSetConstructor;\n";
libFileMap['lib.es2015.core.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ninterface Array<T> {\n    /**\n     * Returns the value of the first element in the array where predicate is true, and undefined\n     * otherwise.\n     * @param predicate find calls predicate once for each element of the array, in ascending\n     * order, until it finds one where predicate returns true. If such an element is found, find\n     * immediately returns that element value. Otherwise, find returns undefined.\n     * @param thisArg If provided, it will be used as the this value for each invocation of\n     * predicate. If it is not provided, undefined is used instead.\n     */\n    find<S extends T>(predicate: (this: void, value: T, index: number, obj: T[]) => value is S, thisArg?: any): S | undefined;\n    find(predicate: (value: T, index: number, obj: T[]) => unknown, thisArg?: any): T | undefined;\n\n    /**\n     * Returns the index of the first element in the array where predicate is true, and -1\n     * otherwise.\n     * @param predicate find calls predicate once for each element of the array, in ascending\n     * order, until it finds one where predicate returns true. If such an element is found,\n     * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n     * @param thisArg If provided, it will be used as the this value for each invocation of\n     * predicate. If it is not provided, undefined is used instead.\n     */\n    findIndex(predicate: (value: T, index: number, obj: T[]) => unknown, thisArg?: any): number;\n\n    /**\n     * Returns the this object after filling the section identified by start and end with value\n     * @param value value to fill array section with\n     * @param start index to start filling the array at. If start is negative, it is treated as\n     * length+start where length is the length of the array.\n     * @param end index to stop filling the array at. If end is negative, it is treated as\n     * length+end.\n     */\n    fill(value: T, start?: number, end?: number): this;\n\n    /**\n     * Returns the this object after copying a section of the array identified by start and end\n     * to the same array starting at position target\n     * @param target If target is negative, it is treated as length+target where length is the\n     * length of the array.\n     * @param start If start is negative, it is treated as length+start. If end is negative, it\n     * is treated as length+end.\n     * @param end If not specified, length of the this object is used as its default value.\n     */\n    copyWithin(target: number, start: number, end?: number): this;\n}\n\ninterface ArrayConstructor {\n    /**\n     * Creates an array from an array-like object.\n     * @param arrayLike An array-like object to convert to an array.\n     */\n    from<T>(arrayLike: ArrayLike<T>): T[];\n\n    /**\n     * Creates an array from an iterable object.\n     * @param arrayLike An array-like object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from<T, U>(arrayLike: ArrayLike<T>, mapfn: (v: T, k: number) => U, thisArg?: any): U[];\n\n    /**\n     * Returns a new array from a set of elements.\n     * @param items A set of elements to include in the new array object.\n     */\n    of<T>(...items: T[]): T[];\n}\n\ninterface DateConstructor {\n    new (value: number | string | Date): Date;\n}\n\ninterface Function {\n    /**\n     * Returns the name of the function. Function names are read-only and can not be changed.\n     */\n    readonly name: string;\n}\n\ninterface Math {\n    /**\n     * Returns the number of leading zero bits in the 32-bit binary representation of a number.\n     * @param x A numeric expression.\n     */\n    clz32(x: number): number;\n\n    /**\n     * Returns the result of 32-bit multiplication of two numbers.\n     * @param x First number\n     * @param y Second number\n     */\n    imul(x: number, y: number): number;\n\n    /**\n     * Returns the sign of the x, indicating whether x is positive, negative or zero.\n     * @param x The numeric expression to test\n     */\n    sign(x: number): number;\n\n    /**\n     * Returns the base 10 logarithm of a number.\n     * @param x A numeric expression.\n     */\n    log10(x: number): number;\n\n    /**\n     * Returns the base 2 logarithm of a number.\n     * @param x A numeric expression.\n     */\n    log2(x: number): number;\n\n    /**\n     * Returns the natural logarithm of 1 + x.\n     * @param x A numeric expression.\n     */\n    log1p(x: number): number;\n\n    /**\n     * Returns the result of (e^x - 1), which is an implementation-dependent approximation to\n     * subtracting 1 from the exponential function of x (e raised to the power of x, where e\n     * is the base of the natural logarithms).\n     * @param x A numeric expression.\n     */\n    expm1(x: number): number;\n\n    /**\n     * Returns the hyperbolic cosine of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    cosh(x: number): number;\n\n    /**\n     * Returns the hyperbolic sine of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    sinh(x: number): number;\n\n    /**\n     * Returns the hyperbolic tangent of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    tanh(x: number): number;\n\n    /**\n     * Returns the inverse hyperbolic cosine of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    acosh(x: number): number;\n\n    /**\n     * Returns the inverse hyperbolic sine of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    asinh(x: number): number;\n\n    /**\n     * Returns the inverse hyperbolic tangent of a number.\n     * @param x A numeric expression that contains an angle measured in radians.\n     */\n    atanh(x: number): number;\n\n    /**\n     * Returns the square root of the sum of squares of its arguments.\n     * @param values Values to compute the square root for.\n     *     If no arguments are passed, the result is +0.\n     *     If there is only one argument, the result is the absolute value.\n     *     If any argument is +Infinity or -Infinity, the result is +Infinity.\n     *     If any argument is NaN, the result is NaN.\n     *     If all arguments are either +0 or −0, the result is +0.\n     */\n    hypot(...values: number[]): number;\n\n    /**\n     * Returns the integral part of the a numeric expression, x, removing any fractional digits.\n     * If x is already an integer, the result is x.\n     * @param x A numeric expression.\n     */\n    trunc(x: number): number;\n\n    /**\n     * Returns the nearest single precision float representation of a number.\n     * @param x A numeric expression.\n     */\n    fround(x: number): number;\n\n    /**\n     * Returns an implementation-dependent approximation to the cube root of number.\n     * @param x A numeric expression.\n     */\n    cbrt(x: number): number;\n}\n\ninterface NumberConstructor {\n    /**\n     * The value of Number.EPSILON is the difference between 1 and the smallest value greater than 1\n     * that is representable as a Number value, which is approximately:\n     * 2.2204460492503130808472633361816 x 10‍−‍16.\n     */\n    readonly EPSILON: number;\n\n    /**\n     * Returns true if passed value is finite.\n     * Unlike the global isFinite, Number.isFinite doesn't forcibly convert the parameter to a\n     * number. Only finite values of the type number, result in true.\n     * @param number A numeric value.\n     */\n    isFinite(number: unknown): boolean;\n\n    /**\n     * Returns true if the value passed is an integer, false otherwise.\n     * @param number A numeric value.\n     */\n    isInteger(number: unknown): boolean;\n\n    /**\n     * Returns a Boolean value that indicates whether a value is the reserved value NaN (not a\n     * number). Unlike the global isNaN(), Number.isNaN() doesn't forcefully convert the parameter\n     * to a number. Only values of the type number, that are also NaN, result in true.\n     * @param number A numeric value.\n     */\n    isNaN(number: unknown): boolean;\n\n    /**\n     * Returns true if the value passed is a safe integer.\n     * @param number A numeric value.\n     */\n    isSafeInteger(number: unknown): boolean;\n\n    /**\n     * The value of the largest integer n such that n and n + 1 are both exactly representable as\n     * a Number value.\n     * The value of Number.MAX_SAFE_INTEGER is 9007199254740991 2^53 − 1.\n     */\n    readonly MAX_SAFE_INTEGER: number;\n\n    /**\n     * The value of the smallest integer n such that n and n − 1 are both exactly representable as\n     * a Number value.\n     * The value of Number.MIN_SAFE_INTEGER is −9007199254740991 (−(2^53 − 1)).\n     */\n    readonly MIN_SAFE_INTEGER: number;\n\n    /**\n     * Converts a string to a floating-point number.\n     * @param string A string that contains a floating-point number.\n     */\n    parseFloat(string: string): number;\n\n    /**\n     * Converts A string to an integer.\n     * @param s A string to convert into a number.\n     * @param radix A value between 2 and 36 that specifies the base of the number in numString.\n     * If this argument is not supplied, strings with a prefix of '0x' are considered hexadecimal.\n     * All other strings are considered decimal.\n     */\n    parseInt(string: string, radix?: number): number;\n}\n\ninterface ObjectConstructor {\n    /**\n     * Copy the values of all of the enumerable own properties from one or more source objects to a\n     * target object. Returns the target object.\n     * @param target The target object to copy to.\n     * @param source The source object from which to copy properties.\n     */\n    assign<T, U>(target: T, source: U): T & U;\n\n    /**\n     * Copy the values of all of the enumerable own properties from one or more source objects to a\n     * target object. Returns the target object.\n     * @param target The target object to copy to.\n     * @param source1 The first source object from which to copy properties.\n     * @param source2 The second source object from which to copy properties.\n     */\n    assign<T, U, V>(target: T, source1: U, source2: V): T & U & V;\n\n    /**\n     * Copy the values of all of the enumerable own properties from one or more source objects to a\n     * target object. Returns the target object.\n     * @param target The target object to copy to.\n     * @param source1 The first source object from which to copy properties.\n     * @param source2 The second source object from which to copy properties.\n     * @param source3 The third source object from which to copy properties.\n     */\n    assign<T, U, V, W>(target: T, source1: U, source2: V, source3: W): T & U & V & W;\n\n    /**\n     * Copy the values of all of the enumerable own properties from one or more source objects to a\n     * target object. Returns the target object.\n     * @param target The target object to copy to.\n     * @param sources One or more source objects from which to copy properties\n     */\n    assign(target: object, ...sources: any[]): any;\n\n    /**\n     * Returns an array of all symbol properties found directly on object o.\n     * @param o Object to retrieve the symbols from.\n     */\n    getOwnPropertySymbols(o: any): symbol[];\n\n    /**\n     * Returns the names of the enumerable string properties and methods of an object.\n     * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.\n     */\n    keys(o: {}): string[];\n\n    /**\n     * Returns true if the values are the same value, false otherwise.\n     * @param value1 The first value.\n     * @param value2 The second value.\n     */\n    is(value1: any, value2: any): boolean;\n\n    /**\n     * Sets the prototype of a specified object o to object proto or null. Returns the object o.\n     * @param o The object to change its prototype.\n     * @param proto The value of the new prototype or null.\n     */\n    setPrototypeOf(o: any, proto: object | null): any;\n}\n\ninterface ReadonlyArray<T> {\n    /**\n     * Returns the value of the first element in the array where predicate is true, and undefined\n     * otherwise.\n     * @param predicate find calls predicate once for each element of the array, in ascending\n     * order, until it finds one where predicate returns true. If such an element is found, find\n     * immediately returns that element value. Otherwise, find returns undefined.\n     * @param thisArg If provided, it will be used as the this value for each invocation of\n     * predicate. If it is not provided, undefined is used instead.\n     */\n    find<S extends T>(predicate: (this: void, value: T, index: number, obj: readonly T[]) => value is S, thisArg?: any): S | undefined;\n    find(predicate: (value: T, index: number, obj: readonly T[]) => unknown, thisArg?: any): T | undefined;\n\n    /**\n     * Returns the index of the first element in the array where predicate is true, and -1\n     * otherwise.\n     * @param predicate find calls predicate once for each element of the array, in ascending\n     * order, until it finds one where predicate returns true. If such an element is found,\n     * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n     * @param thisArg If provided, it will be used as the this value for each invocation of\n     * predicate. If it is not provided, undefined is used instead.\n     */\n    findIndex(predicate: (value: T, index: number, obj: readonly T[]) => unknown, thisArg?: any): number;\n}\n\ninterface RegExp {\n    /**\n     * Returns a string indicating the flags of the regular expression in question. This field is read-only.\n     * The characters in this string are sequenced and concatenated in the following order:\n     *\n     *    - \"g\" for global\n     *    - \"i\" for ignoreCase\n     *    - \"m\" for multiline\n     *    - \"u\" for unicode\n     *    - \"y\" for sticky\n     *\n     * If no flags are set, the value is the empty string.\n     */\n    readonly flags: string;\n\n    /**\n     * Returns a Boolean value indicating the state of the sticky flag (y) used with a regular\n     * expression. Default is false. Read-only.\n     */\n    readonly sticky: boolean;\n\n    /**\n     * Returns a Boolean value indicating the state of the Unicode flag (u) used with a regular\n     * expression. Default is false. Read-only.\n     */\n    readonly unicode: boolean;\n}\n\ninterface RegExpConstructor {\n    new (pattern: RegExp | string, flags?: string): RegExp;\n    (pattern: RegExp | string, flags?: string): RegExp;\n}\n\ninterface String {\n    /**\n     * Returns a nonnegative integer Number less than 1114112 (0x110000) that is the code point\n     * value of the UTF-16 encoded code point starting at the string element at position pos in\n     * the String resulting from converting this object to a String.\n     * If there is no element at that position, the result is undefined.\n     * If a valid UTF-16 surrogate pair does not begin at pos, the result is the code unit at pos.\n     */\n    codePointAt(pos: number): number | undefined;\n\n    /**\n     * Returns true if searchString appears as a substring of the result of converting this\n     * object to a String, at one or more positions that are\n     * greater than or equal to position; otherwise, returns false.\n     * @param searchString search string\n     * @param position If position is undefined, 0 is assumed, so as to search all of the String.\n     */\n    includes(searchString: string, position?: number): boolean;\n\n    /**\n     * Returns true if the sequence of elements of searchString converted to a String is the\n     * same as the corresponding elements of this object (converted to a String) starting at\n     * endPosition – length(this). Otherwise returns false.\n     */\n    endsWith(searchString: string, endPosition?: number): boolean;\n\n    /**\n     * Returns the String value result of normalizing the string into the normalization form\n     * named by form as specified in Unicode Standard Annex #15, Unicode Normalization Forms.\n     * @param form Applicable values: \"NFC\", \"NFD\", \"NFKC\", or \"NFKD\", If not specified default\n     * is \"NFC\"\n     */\n    normalize(form: \"NFC\" | \"NFD\" | \"NFKC\" | \"NFKD\"): string;\n\n    /**\n     * Returns the String value result of normalizing the string into the normalization form\n     * named by form as specified in Unicode Standard Annex #15, Unicode Normalization Forms.\n     * @param form Applicable values: \"NFC\", \"NFD\", \"NFKC\", or \"NFKD\", If not specified default\n     * is \"NFC\"\n     */\n    normalize(form?: string): string;\n\n    /**\n     * Returns a String value that is made from count copies appended together. If count is 0,\n     * the empty string is returned.\n     * @param count number of copies to append\n     */\n    repeat(count: number): string;\n\n    /**\n     * Returns true if the sequence of elements of searchString converted to a String is the\n     * same as the corresponding elements of this object (converted to a String) starting at\n     * position. Otherwise returns false.\n     */\n    startsWith(searchString: string, position?: number): boolean;\n\n    /**\n     * Returns an `<a>` HTML anchor element and sets the name attribute to the text value\n     * @param name\n     */\n    anchor(name: string): string;\n\n    /** Returns a `<big>` HTML element */\n    big(): string;\n\n    /** Returns a `<blink>` HTML element */\n    blink(): string;\n\n    /** Returns a `<b>` HTML element */\n    bold(): string;\n\n    /** Returns a `<tt>` HTML element */\n    fixed(): string;\n\n    /** Returns a `<font>` HTML element and sets the color attribute value */\n    fontcolor(color: string): string;\n\n    /** Returns a `<font>` HTML element and sets the size attribute value */\n    fontsize(size: number): string;\n\n    /** Returns a `<font>` HTML element and sets the size attribute value */\n    fontsize(size: string): string;\n\n    /** Returns an `<i>` HTML element */\n    italics(): string;\n\n    /** Returns an `<a>` HTML element and sets the href attribute value */\n    link(url: string): string;\n\n    /** Returns a `<small>` HTML element */\n    small(): string;\n\n    /** Returns a `<strike>` HTML element */\n    strike(): string;\n\n    /** Returns a `<sub>` HTML element */\n    sub(): string;\n\n    /** Returns a `<sup>` HTML element */\n    sup(): string;\n}\n\ninterface StringConstructor {\n    /**\n     * Return the String value whose elements are, in order, the elements in the List elements.\n     * If length is 0, the empty string is returned.\n     */\n    fromCodePoint(...codePoints: number[]): string;\n\n    /**\n     * String.raw is intended for use as a tag function of a Tagged Template String. When called\n     * as such the first argument will be a well formed template call site object and the rest\n     * parameter will contain the substitution values.\n     * @param template A well-formed template string call site representation.\n     * @param substitutions A set of substitution values.\n     */\n    raw(template: TemplateStringsArray, ...substitutions: any[]): string;\n}\n";
libFileMap['lib.es2015.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es5\" />\n/// <reference lib=\"es2015.core\" />\n/// <reference lib=\"es2015.collection\" />\n/// <reference lib=\"es2015.iterable\" />\n/// <reference lib=\"es2015.generator\" />\n/// <reference lib=\"es2015.promise\" />\n/// <reference lib=\"es2015.proxy\" />\n/// <reference lib=\"es2015.reflect\" />\n/// <reference lib=\"es2015.symbol\" />\n/// <reference lib=\"es2015.symbol.wellknown\" />\n";
libFileMap['lib.es2015.generator.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2015.iterable\" />\n\ninterface Generator<T = unknown, TReturn = any, TNext = unknown> extends Iterator<T, TReturn, TNext> {\n    // NOTE: 'next' is defined using a tuple to ensure we report the correct assignability errors in all places.\n    next(...args: [] | [TNext]): IteratorResult<T, TReturn>;\n    return(value: TReturn): IteratorResult<T, TReturn>;\n    throw(e: any): IteratorResult<T, TReturn>;\n    [Symbol.iterator](): Generator<T, TReturn, TNext>;\n}\n\ninterface GeneratorFunction {\n    /**\n     * Creates a new Generator object.\n     * @param args A list of arguments the function accepts.\n     */\n    new (...args: any[]): Generator;\n    /**\n     * Creates a new Generator object.\n     * @param args A list of arguments the function accepts.\n     */\n    (...args: any[]): Generator;\n    /**\n     * The length of the arguments.\n     */\n    readonly length: number;\n    /**\n     * Returns the name of the function.\n     */\n    readonly name: string;\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: Generator;\n}\n\ninterface GeneratorFunctionConstructor {\n    /**\n     * Creates a new Generator function.\n     * @param args A list of arguments the function accepts.\n     */\n    new (...args: string[]): GeneratorFunction;\n    /**\n     * Creates a new Generator function.\n     * @param args A list of arguments the function accepts.\n     */\n    (...args: string[]): GeneratorFunction;\n    /**\n     * The length of the arguments.\n     */\n    readonly length: number;\n    /**\n     * Returns the name of the function.\n     */\n    readonly name: string;\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: GeneratorFunction;\n}\n";
libFileMap['lib.es2015.iterable.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2015.symbol\" />\n\ninterface SymbolConstructor {\n    /**\n     * A method that returns the default iterator for an object. Called by the semantics of the\n     * for-of statement.\n     */\n    readonly iterator: symbol;\n}\n\ninterface IteratorYieldResult<TYield> {\n    done?: false;\n    value: TYield;\n}\n\ninterface IteratorReturnResult<TReturn> {\n    done: true;\n    value: TReturn;\n}\n\ntype IteratorResult<T, TReturn = any> = IteratorYieldResult<T> | IteratorReturnResult<TReturn>;\n\ninterface Iterator<T, TReturn = any, TNext = undefined> {\n    // NOTE: 'next' is defined using a tuple to ensure we report the correct assignability errors in all places.\n    next(...args: [] | [TNext]): IteratorResult<T, TReturn>;\n    return?(value?: TReturn): IteratorResult<T, TReturn>;\n    throw?(e?: any): IteratorResult<T, TReturn>;\n}\n\ninterface Iterable<T> {\n    [Symbol.iterator](): Iterator<T>;\n}\n\ninterface IterableIterator<T> extends Iterator<T> {\n    [Symbol.iterator](): IterableIterator<T>;\n}\n\ninterface Array<T> {\n    /** Iterator */\n    [Symbol.iterator](): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, T]>;\n\n    /**\n     * Returns an iterable of keys in the array\n     */\n    keys(): IterableIterator<number>;\n\n    /**\n     * Returns an iterable of values in the array\n     */\n    values(): IterableIterator<T>;\n}\n\ninterface ArrayConstructor {\n    /**\n     * Creates an array from an iterable object.\n     * @param iterable An iterable object to convert to an array.\n     */\n    from<T>(iterable: Iterable<T> | ArrayLike<T>): T[];\n\n    /**\n     * Creates an array from an iterable object.\n     * @param iterable An iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from<T, U>(iterable: Iterable<T> | ArrayLike<T>, mapfn: (v: T, k: number) => U, thisArg?: any): U[];\n}\n\ninterface ReadonlyArray<T> {\n    /** Iterator of values in the array. */\n    [Symbol.iterator](): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, T]>;\n\n    /**\n     * Returns an iterable of keys in the array\n     */\n    keys(): IterableIterator<number>;\n\n    /**\n     * Returns an iterable of values in the array\n     */\n    values(): IterableIterator<T>;\n}\n\ninterface IArguments {\n    /** Iterator */\n    [Symbol.iterator](): IterableIterator<any>;\n}\n\ninterface Map<K, V> {\n    /** Returns an iterable of entries in the map. */\n    [Symbol.iterator](): IterableIterator<[K, V]>;\n\n    /**\n     * Returns an iterable of key, value pairs for every entry in the map.\n     */\n    entries(): IterableIterator<[K, V]>;\n\n    /**\n     * Returns an iterable of keys in the map\n     */\n    keys(): IterableIterator<K>;\n\n    /**\n     * Returns an iterable of values in the map\n     */\n    values(): IterableIterator<V>;\n}\n\ninterface ReadonlyMap<K, V> {\n    /** Returns an iterable of entries in the map. */\n    [Symbol.iterator](): IterableIterator<[K, V]>;\n\n    /**\n     * Returns an iterable of key, value pairs for every entry in the map.\n     */\n    entries(): IterableIterator<[K, V]>;\n\n    /**\n     * Returns an iterable of keys in the map\n     */\n    keys(): IterableIterator<K>;\n\n    /**\n     * Returns an iterable of values in the map\n     */\n    values(): IterableIterator<V>;\n}\n\ninterface MapConstructor {\n    new <K, V>(iterable: Iterable<readonly [K, V]>): Map<K, V>;\n}\n\ninterface WeakMap<K extends object, V> { }\n\ninterface WeakMapConstructor {\n    new <K extends object, V>(iterable: Iterable<[K, V]>): WeakMap<K, V>;\n}\n\ninterface Set<T> {\n    /** Iterates over values in the set. */\n    [Symbol.iterator](): IterableIterator<T>;\n    /**\n     * Returns an iterable of [v,v] pairs for every value `v` in the set.\n     */\n    entries(): IterableIterator<[T, T]>;\n    /**\n     * Despite its name, returns an iterable of the values in the set.\n     */\n    keys(): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of values in the set.\n     */\n    values(): IterableIterator<T>;\n}\n\ninterface ReadonlySet<T> {\n    /** Iterates over values in the set. */\n    [Symbol.iterator](): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of [v,v] pairs for every value `v` in the set.\n     */\n    entries(): IterableIterator<[T, T]>;\n\n    /**\n     * Despite its name, returns an iterable of the values in the set.\n     */\n    keys(): IterableIterator<T>;\n\n    /**\n     * Returns an iterable of values in the set.\n     */\n    values(): IterableIterator<T>;\n}\n\ninterface SetConstructor {\n    new <T>(iterable?: Iterable<T> | null): Set<T>;\n}\n\ninterface WeakSet<T extends object> { }\n\ninterface WeakSetConstructor {\n    new <T extends object = object>(iterable: Iterable<T>): WeakSet<T>;\n}\n\ninterface Promise<T> { }\n\ninterface PromiseConstructor {\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An iterable of Promises.\n     * @returns A new Promise.\n     */\n    all<T>(values: Iterable<T | PromiseLike<T>>): Promise<T[]>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An iterable of Promises.\n     * @returns A new Promise.\n     */\n    race<T>(values: Iterable<T>): Promise<T extends PromiseLike<infer U> ? U : T>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An iterable of Promises.\n     * @returns A new Promise.\n     */\n    race<T>(values: Iterable<T | PromiseLike<T>>): Promise<T>;\n}\n\ninterface String {\n    /** Iterator */\n    [Symbol.iterator](): IterableIterator<string>;\n}\n\ninterface Int8Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Int8ArrayConstructor {\n    new (elements: Iterable<number>): Int8Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Int8Array;\n}\n\ninterface Uint8Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Uint8ArrayConstructor {\n    new (elements: Iterable<number>): Uint8Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint8Array;\n}\n\ninterface Uint8ClampedArray {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Uint8ClampedArrayConstructor {\n    new (elements: Iterable<number>): Uint8ClampedArray;\n\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint8ClampedArray;\n}\n\ninterface Int16Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Int16ArrayConstructor {\n    new (elements: Iterable<number>): Int16Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Int16Array;\n}\n\ninterface Uint16Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Uint16ArrayConstructor {\n    new (elements: Iterable<number>): Uint16Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint16Array;\n}\n\ninterface Int32Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Int32ArrayConstructor {\n    new (elements: Iterable<number>): Int32Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Int32Array;\n}\n\ninterface Uint32Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Uint32ArrayConstructor {\n    new (elements: Iterable<number>): Uint32Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Uint32Array;\n}\n\ninterface Float32Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Float32ArrayConstructor {\n    new (elements: Iterable<number>): Float32Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Float32Array;\n}\n\ninterface Float64Array {\n    [Symbol.iterator](): IterableIterator<number>;\n    /**\n     * Returns an array of key, value pairs for every entry in the array\n     */\n    entries(): IterableIterator<[number, number]>;\n    /**\n     * Returns an list of keys in the array\n     */\n    keys(): IterableIterator<number>;\n    /**\n     * Returns an list of values in the array\n     */\n    values(): IterableIterator<number>;\n}\n\ninterface Float64ArrayConstructor {\n    new (elements: Iterable<number>): Float64Array;\n\n    /**\n     * Creates an array from an array-like or iterable object.\n     * @param arrayLike An array-like or iterable object to convert to an array.\n     * @param mapfn A mapping function to call on every element of the array.\n     * @param thisArg Value of 'this' used to invoke the mapfn.\n     */\n    from(arrayLike: Iterable<number>, mapfn?: (v: number, k: number) => number, thisArg?: any): Float64Array;\n}\n";
libFileMap['lib.es2015.promise.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ninterface PromiseConstructor {\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: Promise<any>;\n\n    /**\n     * Creates a new Promise.\n     * @param executor A callback used to initialize the promise. This callback is passed two arguments:\n     * a resolve callback used to resolve the promise with a value or the result of another promise,\n     * and a reject callback used to reject the promise with a provided reason or error.\n     */\n    new <T>(executor: (resolve: (value: T | PromiseLike<T>) => void, reject: (reason?: any) => void) => void): Promise<T>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>(values: readonly [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike<T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>, T7 | PromiseLike<T7>, T8 | PromiseLike<T8>, T9 | PromiseLike<T9>, T10 | PromiseLike<T10>]): Promise<[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3, T4, T5, T6, T7, T8, T9>(values: readonly [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike<T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>, T7 | PromiseLike<T7>, T8 | PromiseLike<T8>, T9 | PromiseLike<T9>]): Promise<[T1, T2, T3, T4, T5, T6, T7, T8, T9]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3, T4, T5, T6, T7, T8>(values: readonly [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike<T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>, T7 | PromiseLike<T7>, T8 | PromiseLike<T8>]): Promise<[T1, T2, T3, T4, T5, T6, T7, T8]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3, T4, T5, T6, T7>(values: readonly [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike<T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>, T7 | PromiseLike<T7>]): Promise<[T1, T2, T3, T4, T5, T6, T7]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3, T4, T5, T6>(values: readonly [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike<T4>, T5 | PromiseLike<T5>, T6 | PromiseLike<T6>]): Promise<[T1, T2, T3, T4, T5, T6]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3, T4, T5>(values: readonly [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike<T4>, T5 | PromiseLike<T5>]): Promise<[T1, T2, T3, T4, T5]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3, T4>(values: readonly [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>, T4 | PromiseLike<T4>]): Promise<[T1, T2, T3, T4]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2, T3>(values: readonly [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>, T3 | PromiseLike<T3>]): Promise<[T1, T2, T3]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T1, T2>(values: readonly [T1 | PromiseLike<T1>, T2 | PromiseLike<T2>]): Promise<[T1, T2]>;\n\n    /**\n     * Creates a Promise that is resolved with an array of results when all of the provided Promises\n     * resolve, or rejected when any Promise is rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    all<T>(values: readonly (T | PromiseLike<T>)[]): Promise<T[]>;\n\n    // see: lib.es2015.iterable.d.ts\n    // all<T>(values: Iterable<T | PromiseLike<T>>): Promise<T[]>;\n\n    /**\n     * Creates a Promise that is resolved or rejected when any of the provided Promises are resolved\n     * or rejected.\n     * @param values An array of Promises.\n     * @returns A new Promise.\n     */\n    race<T>(values: readonly T[]): Promise<T extends PromiseLike<infer U> ? U : T>;\n\n    // see: lib.es2015.iterable.d.ts\n    // race<T>(values: Iterable<T>): Promise<T extends PromiseLike<infer U> ? U : T>;\n\n    /**\n     * Creates a new rejected promise for the provided reason.\n     * @param reason The reason the promise was rejected.\n     * @returns A new rejected Promise.\n     */\n    reject<T = never>(reason?: any): Promise<T>;\n\n    /**\n     * Creates a new resolved promise.\n     * @returns A resolved promise.\n     */\n    resolve(): Promise<void>;\n\n    /**\n     * Creates a new resolved promise for the provided value.\n     * @param value A promise.\n     * @returns A promise whose internal state matches the provided promise.\n     */\n    resolve<T>(value: T | PromiseLike<T>): Promise<T>;\n}\n\ndeclare var Promise: PromiseConstructor;\n";
libFileMap['lib.es2015.proxy.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ninterface ProxyHandler<T extends object> {\n    getPrototypeOf? (target: T): object | null;\n    setPrototypeOf? (target: T, v: any): boolean;\n    isExtensible? (target: T): boolean;\n    preventExtensions? (target: T): boolean;\n    getOwnPropertyDescriptor? (target: T, p: PropertyKey): PropertyDescriptor | undefined;\n    has? (target: T, p: PropertyKey): boolean;\n    get? (target: T, p: PropertyKey, receiver: any): any;\n    set? (target: T, p: PropertyKey, value: any, receiver: any): boolean;\n    deleteProperty? (target: T, p: PropertyKey): boolean;\n    defineProperty? (target: T, p: PropertyKey, attributes: PropertyDescriptor): boolean;\n    ownKeys? (target: T): PropertyKey[];\n    apply? (target: T, thisArg: any, argArray?: any): any;\n    construct? (target: T, argArray: any, newTarget?: any): object;\n}\n\ninterface ProxyConstructor {\n    revocable<T extends object>(target: T, handler: ProxyHandler<T>): { proxy: T; revoke: () => void; };\n    new <T extends object>(target: T, handler: ProxyHandler<T>): T;\n}\ndeclare var Proxy: ProxyConstructor;\n";
libFileMap['lib.es2015.reflect.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ndeclare namespace Reflect {\n    function apply(target: Function, thisArgument: any, argumentsList: ArrayLike<any>): any;\n    function construct(target: Function, argumentsList: ArrayLike<any>, newTarget?: any): any;\n    function defineProperty(target: object, propertyKey: PropertyKey, attributes: PropertyDescriptor): boolean;\n    function deleteProperty(target: object, propertyKey: PropertyKey): boolean;\n    function get(target: object, propertyKey: PropertyKey, receiver?: any): any;\n    function getOwnPropertyDescriptor(target: object, propertyKey: PropertyKey): PropertyDescriptor | undefined;\n    function getPrototypeOf(target: object): object;\n    function has(target: object, propertyKey: PropertyKey): boolean;\n    function isExtensible(target: object): boolean;\n    function ownKeys(target: object): PropertyKey[];\n    function preventExtensions(target: object): boolean;\n    function set(target: object, propertyKey: PropertyKey, value: any, receiver?: any): boolean;\n    function setPrototypeOf(target: object, proto: any): boolean;\n}\n";
libFileMap['lib.es2015.symbol.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ninterface SymbolConstructor {\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: Symbol;\n\n    /**\n     * Returns a new unique Symbol value.\n     * @param  description Description of the new Symbol object.\n     */\n    (description?: string | number): symbol;\n\n    /**\n     * Returns a Symbol object from the global symbol registry matching the given key if found.\n     * Otherwise, returns a new symbol with this key.\n     * @param key key to search for.\n     */\n    for(key: string): symbol;\n\n    /**\n     * Returns a key from the global symbol registry matching the given Symbol if found.\n     * Otherwise, returns a undefined.\n     * @param sym Symbol to find the key for.\n     */\n    keyFor(sym: symbol): string | undefined;\n}\n\ndeclare var Symbol: SymbolConstructor;";
libFileMap['lib.es2015.symbol.wellknown.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2015.symbol\" />\n\ninterface SymbolConstructor {\n    /**\n     * A method that determines if a constructor object recognizes an object as one of the\n     * constructor’s instances. Called by the semantics of the instanceof operator.\n     */\n    readonly hasInstance: symbol;\n\n    /**\n     * A Boolean value that if true indicates that an object should flatten to its array elements\n     * by Array.prototype.concat.\n     */\n    readonly isConcatSpreadable: symbol;\n\n    /**\n     * A regular expression method that matches the regular expression against a string. Called\n     * by the String.prototype.match method.\n     */\n    readonly match: symbol;\n\n    /**\n     * A regular expression method that replaces matched substrings of a string. Called by the\n     * String.prototype.replace method.\n     */\n    readonly replace: symbol;\n\n    /**\n     * A regular expression method that returns the index within a string that matches the\n     * regular expression. Called by the String.prototype.search method.\n     */\n    readonly search: symbol;\n\n    /**\n     * A function valued property that is the constructor function that is used to create\n     * derived objects.\n     */\n    readonly species: symbol;\n\n    /**\n     * A regular expression method that splits a string at the indices that match the regular\n     * expression. Called by the String.prototype.split method.\n     */\n    readonly split: symbol;\n\n    /**\n     * A method that converts an object to a corresponding primitive value.\n     * Called by the ToPrimitive abstract operation.\n     */\n    readonly toPrimitive: symbol;\n\n    /**\n     * A String value that is used in the creation of the default string description of an object.\n     * Called by the built-in method Object.prototype.toString.\n     */\n    readonly toStringTag: symbol;\n\n    /**\n     * An Object whose own property names are property names that are excluded from the 'with'\n     * environment bindings of the associated objects.\n     */\n    readonly unscopables: symbol;\n}\n\ninterface Symbol {\n    /**\n     * Converts a Symbol object to a symbol.\n     */\n    [Symbol.toPrimitive](hint: string): symbol;\n\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface Array<T> {\n    /**\n     * Returns an object whose properties have the value 'true'\n     * when they will be absent when used in a 'with' statement.\n     */\n    [Symbol.unscopables](): {\n        copyWithin: boolean;\n        entries: boolean;\n        fill: boolean;\n        find: boolean;\n        findIndex: boolean;\n        keys: boolean;\n        values: boolean;\n    };\n}\n\ninterface Date {\n    /**\n     * Converts a Date object to a string.\n     */\n    [Symbol.toPrimitive](hint: \"default\"): string;\n    /**\n     * Converts a Date object to a string.\n     */\n    [Symbol.toPrimitive](hint: \"string\"): string;\n    /**\n     * Converts a Date object to a number.\n     */\n    [Symbol.toPrimitive](hint: \"number\"): number;\n    /**\n     * Converts a Date object to a string or number.\n     *\n     * @param hint The strings \"number\", \"string\", or \"default\" to specify what primitive to return.\n     *\n     * @throws {TypeError} If 'hint' was given something other than \"number\", \"string\", or \"default\".\n     * @returns A number if 'hint' was \"number\", a string if 'hint' was \"string\" or \"default\".\n     */\n    [Symbol.toPrimitive](hint: string): string | number;\n}\n\ninterface Map<K, V> {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface WeakMap<K extends object, V> {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface Set<T> {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface WeakSet<T extends object> {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface JSON {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface Function {\n    /**\n     * Determines whether the given value inherits from this function if this function was used\n     * as a constructor function.\n     *\n     * A constructor function can control which objects are recognized as its instances by\n     * 'instanceof' by overriding this method.\n     */\n    [Symbol.hasInstance](value: any): boolean;\n}\n\ninterface GeneratorFunction {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface Math {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface Promise<T> {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface PromiseConstructor {\n    readonly [Symbol.species]: PromiseConstructor;\n}\n\ninterface RegExp {\n    /**\n     * Matches a string with this regular expression, and returns an array containing the results of\n     * that search.\n     * @param string A string to search within.\n     */\n    [Symbol.match](string: string): RegExpMatchArray | null;\n\n    /**\n     * Replaces text in a string, using this regular expression.\n     * @param string A String object or string literal whose contents matching against\n     *               this regular expression will be replaced\n     * @param replaceValue A String object or string literal containing the text to replace for every\n     *                     successful match of this regular expression.\n     */\n    [Symbol.replace](string: string, replaceValue: string): string;\n\n    /**\n     * Replaces text in a string, using this regular expression.\n     * @param string A String object or string literal whose contents matching against\n     *               this regular expression will be replaced\n     * @param replacer A function that returns the replacement text.\n     */\n    [Symbol.replace](string: string, replacer: (substring: string, ...args: any[]) => string): string;\n\n    /**\n     * Finds the position beginning first substring match in a regular expression search\n     * using this regular expression.\n     *\n     * @param string The string to search within.\n     */\n    [Symbol.search](string: string): number;\n\n    /**\n     * Returns an array of substrings that were delimited by strings in the original input that\n     * match against this regular expression.\n     *\n     * If the regular expression contains capturing parentheses, then each time this\n     * regular expression matches, the results (including any undefined results) of the\n     * capturing parentheses are spliced.\n     *\n     * @param string string value to split\n     * @param limit if not undefined, the output array is truncated so that it contains no more\n     * than 'limit' elements.\n     */\n    [Symbol.split](string: string, limit?: number): string[];\n}\n\ninterface RegExpConstructor {\n    readonly [Symbol.species]: RegExpConstructor;\n}\n\ninterface String {\n    /**\n     * Matches a string or an object that supports being matched against, and returns an array\n     * containing the results of that search, or null if no matches are found.\n     * @param matcher An object that supports being matched against.\n     */\n    match(matcher: { [Symbol.match](string: string): RegExpMatchArray | null; }): RegExpMatchArray | null;\n\n    /**\n     * Replaces text in a string, using an object that supports replacement within a string.\n     * @param searchValue A object can search for and replace matches within a string.\n     * @param replaceValue A string containing the text to replace for every successful match of searchValue in this string.\n     */\n    replace(searchValue: { [Symbol.replace](string: string, replaceValue: string): string; }, replaceValue: string): string;\n\n    /**\n     * Replaces text in a string, using an object that supports replacement within a string.\n     * @param searchValue A object can search for and replace matches within a string.\n     * @param replacer A function that returns the replacement text.\n     */\n    replace(searchValue: { [Symbol.replace](string: string, replacer: (substring: string, ...args: any[]) => string): string; }, replacer: (substring: string, ...args: any[]) => string): string;\n\n    /**\n     * Finds the first substring match in a regular expression search.\n     * @param searcher An object which supports searching within a string.\n     */\n    search(searcher: { [Symbol.search](string: string): number; }): number;\n\n    /**\n     * Split a string into substrings using the specified separator and return them as an array.\n     * @param splitter An object that can split a string.\n     * @param limit A value used to limit the number of elements returned in the array.\n     */\n    split(splitter: { [Symbol.split](string: string, limit?: number): string[]; }, limit?: number): string[];\n}\n\ninterface ArrayBuffer {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface DataView {\n    readonly [Symbol.toStringTag]: string;\n}\n\ninterface Int8Array {\n    readonly [Symbol.toStringTag]: \"Int8Array\";\n}\n\ninterface Uint8Array {\n    readonly [Symbol.toStringTag]: \"Uint8Array\";\n}\n\ninterface Uint8ClampedArray {\n    readonly [Symbol.toStringTag]: \"Uint8ClampedArray\";\n}\n\ninterface Int16Array {\n    readonly [Symbol.toStringTag]: \"Int16Array\";\n}\n\ninterface Uint16Array {\n    readonly [Symbol.toStringTag]: \"Uint16Array\";\n}\n\ninterface Int32Array {\n    readonly [Symbol.toStringTag]: \"Int32Array\";\n}\n\ninterface Uint32Array {\n    readonly [Symbol.toStringTag]: \"Uint32Array\";\n}\n\ninterface Float32Array {\n    readonly [Symbol.toStringTag]: \"Float32Array\";\n}\n\ninterface Float64Array {\n    readonly [Symbol.toStringTag]: \"Float64Array\";\n}\n\ninterface ArrayConstructor {\n    readonly [Symbol.species]: ArrayConstructor;\n}\ninterface MapConstructor {\n    readonly [Symbol.species]: MapConstructor;\n}\ninterface SetConstructor {\n    readonly [Symbol.species]: SetConstructor;\n}\ninterface ArrayBufferConstructor {\n    readonly [Symbol.species]: ArrayBufferConstructor;\n}\n";
libFileMap['lib.es2016.array.include.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ninterface Array<T> {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: T, fromIndex?: number): boolean;\n}\n\ninterface ReadonlyArray<T> {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: T, fromIndex?: number): boolean;\n}\n\ninterface Int8Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Uint8Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Uint8ClampedArray {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Int16Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Uint16Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Int32Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Uint32Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Float32Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}\n\ninterface Float64Array {\n    /**\n     * Determines whether an array includes a certain element, returning true or false as appropriate.\n     * @param searchElement The element to search for.\n     * @param fromIndex The position in this array at which to begin searching for searchElement.\n     */\n    includes(searchElement: number, fromIndex?: number): boolean;\n}";
libFileMap['lib.es2016.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2015\" />\n/// <reference lib=\"es2016.array.include\" />";
libFileMap['lib.es2016.full.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2016\" />\n/// <reference lib=\"dom\" />\n/// <reference lib=\"webworker.importscripts\" />\n/// <reference lib=\"scripthost\" />\n/// <reference lib=\"dom.iterable\" />";
libFileMap['lib.es2017.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2016\" />\n/// <reference lib=\"es2017.object\" />\n/// <reference lib=\"es2017.sharedmemory\" />\n/// <reference lib=\"es2017.string\" />\n/// <reference lib=\"es2017.intl\" />\n/// <reference lib=\"es2017.typedarrays\" />\n";
libFileMap['lib.es2017.full.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2017\" />\n/// <reference lib=\"dom\" />\n/// <reference lib=\"webworker.importscripts\" />\n/// <reference lib=\"scripthost\" />\n/// <reference lib=\"dom.iterable\" />";
libFileMap['lib.es2017.intl.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ndeclare namespace Intl {\n    type DateTimeFormatPartTypes = \"day\" | \"dayPeriod\" | \"era\" | \"hour\" | \"literal\" | \"minute\" | \"month\" | \"second\" | \"timeZoneName\" | \"weekday\" | \"year\";\n\n    interface DateTimeFormatPart {\n        type: DateTimeFormatPartTypes;\n        value: string;\n    }\n\n    interface DateTimeFormat {\n        formatToParts(date?: Date | number): DateTimeFormatPart[];\n    }\n}\n";
libFileMap['lib.es2017.object.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ninterface ObjectConstructor {\n    /**\n     * Returns an array of values of the enumerable properties of an object\n     * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.\n     */\n    values<T>(o: { [s: string]: T } | ArrayLike<T>): T[];\n\n    /**\n     * Returns an array of values of the enumerable properties of an object\n     * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.\n     */\n    values(o: {}): any[];\n\n    /**\n     * Returns an array of key/values of the enumerable properties of an object\n     * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.\n     */\n    entries<T>(o: { [s: string]: T } | ArrayLike<T>): [string, T][];\n\n    /**\n     * Returns an array of key/values of the enumerable properties of an object\n     * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.\n     */\n    entries(o: {}): [string, any][];\n\n    /**\n     * Returns an object containing all own property descriptors of an object\n     * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.\n     */\n    getOwnPropertyDescriptors<T>(o: T): {[P in keyof T]: TypedPropertyDescriptor<T[P]>} & { [x: string]: PropertyDescriptor };\n}\n";
libFileMap['lib.es2017.sharedmemory.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2015.symbol\" />\n/// <reference lib=\"es2015.symbol.wellknown\" />\n\ninterface SharedArrayBuffer {\n    /**\n     * Read-only. The length of the ArrayBuffer (in bytes).\n     */\n    readonly byteLength: number;\n\n    /**\n     * Returns a section of an SharedArrayBuffer.\n     */\n    slice(begin: number, end?: number): SharedArrayBuffer;\n    readonly [Symbol.species]: SharedArrayBuffer;\n    readonly [Symbol.toStringTag]: \"SharedArrayBuffer\";\n}\n\ninterface SharedArrayBufferConstructor {\n    readonly prototype: SharedArrayBuffer;\n    new (byteLength: number): SharedArrayBuffer;\n}\ndeclare var SharedArrayBuffer: SharedArrayBufferConstructor;\n\ninterface ArrayBufferTypes {\n    SharedArrayBuffer: SharedArrayBuffer;\n}\n\ninterface Atomics {\n    /**\n     * Adds a value to the value at the given position in the array, returning the original value.\n     * Until this atomic operation completes, any other read or write operation against the array\n     * will block.\n     */\n    add(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, value: number): number;\n\n    /**\n     * Stores the bitwise AND of a value with the value at the given position in the array,\n     * returning the original value. Until this atomic operation completes, any other read or\n     * write operation against the array will block.\n     */\n    and(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, value: number): number;\n\n    /**\n     * Replaces the value at the given position in the array if the original value equals the given\n     * expected value, returning the original value. Until this atomic operation completes, any\n     * other read or write operation against the array will block.\n     */\n    compareExchange(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, expectedValue: number, replacementValue: number): number;\n\n    /**\n     * Replaces the value at the given position in the array, returning the original value. Until\n     * this atomic operation completes, any other read or write operation against the array will\n     * block.\n     */\n    exchange(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, value: number): number;\n\n    /**\n     * Returns a value indicating whether high-performance algorithms can use atomic operations\n     * (`true`) or must use locks (`false`) for the given number of bytes-per-element of a typed\n     * array.\n     */\n    isLockFree(size: number): boolean;\n\n    /**\n     * Returns the value at the given position in the array. Until this atomic operation completes,\n     * any other read or write operation against the array will block.\n     */\n    load(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number): number;\n\n    /**\n     * Stores the bitwise OR of a value with the value at the given position in the array,\n     * returning the original value. Until this atomic operation completes, any other read or write\n     * operation against the array will block.\n     */\n    or(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, value: number): number;\n\n    /**\n     * Stores a value at the given position in the array, returning the new value. Until this\n     * atomic operation completes, any other read or write operation against the array will block.\n     */\n    store(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, value: number): number;\n\n    /**\n     * Subtracts a value from the value at the given position in the array, returning the original\n     * value. Until this atomic operation completes, any other read or write operation against the\n     * array will block.\n     */\n    sub(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, value: number): number;\n\n    /**\n     * If the value at the given position in the array is equal to the provided value, the current\n     * agent is put to sleep causing execution to suspend until the timeout expires (returning\n     * `\"timed-out\"`) or until the agent is awoken (returning `\"ok\"`); otherwise, returns\n     * `\"not-equal\"`.\n     */\n    wait(typedArray: Int32Array, index: number, value: number, timeout?: number): \"ok\" | \"not-equal\" | \"timed-out\";\n\n    /**\n     * Wakes up sleeping agents that are waiting on the given index of the array, returning the\n     * number of agents that were awoken.\n     * @param typedArray A shared Int32Array.\n     * @param index The position in the typedArray to wake up on.\n     * @param count The number of sleeping agents to notify. Defaults to +Infinity.\n     */\n    notify(typedArray: Int32Array, index: number, count?: number): number;\n\n    /**\n     * Stores the bitwise XOR of a value with the value at the given position in the array,\n     * returning the original value. Until this atomic operation completes, any other read or write\n     * operation against the array will block.\n     */\n    xor(typedArray: Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array, index: number, value: number): number;\n\n    readonly [Symbol.toStringTag]: \"Atomics\";\n}\n\ndeclare var Atomics: Atomics;\n";
libFileMap['lib.es2017.string.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ninterface String {\n    /**\n     * Pads the current string with a given string (possibly repeated) so that the resulting string reaches a given length.\n     * The padding is applied from the start (left) of the current string.\n     *\n     * @param maxLength The length of the resulting string once the current string has been padded.\n     *        If this parameter is smaller than the current string's length, the current string will be returned as it is.\n     *\n     * @param fillString The string to pad the current string with.\n     *        If this string is too long, it will be truncated and the left-most part will be applied.\n     *        The default value for this parameter is \" \" (U+0020).\n     */\n    padStart(maxLength: number, fillString?: string): string;\n\n    /**\n     * Pads the current string with a given string (possibly repeated) so that the resulting string reaches a given length.\n     * The padding is applied from the end (right) of the current string.\n     *\n     * @param maxLength The length of the resulting string once the current string has been padded.\n     *        If this parameter is smaller than the current string's length, the current string will be returned as it is.\n     *\n     * @param fillString The string to pad the current string with.\n     *        If this string is too long, it will be truncated and the left-most part will be applied.\n     *        The default value for this parameter is \" \" (U+0020).\n     */\n    padEnd(maxLength: number, fillString?: string): string;\n}\n";
libFileMap['lib.es2017.typedarrays.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ninterface Int8ArrayConstructor {\n    new (): Int8Array;\n}\n\ninterface Uint8ArrayConstructor {\n    new (): Uint8Array;\n}\n\ninterface Uint8ClampedArrayConstructor {\n    new (): Uint8ClampedArray;\n}\n\ninterface Int16ArrayConstructor {\n    new (): Int16Array;\n}\n\ninterface Uint16ArrayConstructor {\n    new (): Uint16Array;\n}\n\ninterface Int32ArrayConstructor {\n    new (): Int32Array;\n}\n\ninterface Uint32ArrayConstructor {\n    new (): Uint32Array;\n}\n\ninterface Float32ArrayConstructor {\n    new (): Float32Array;\n}\n\ninterface Float64ArrayConstructor {\n    new (): Float64Array;\n}\n";
libFileMap['lib.es2018.asyncgenerator.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2018.asynciterable\" />\n\ninterface AsyncGenerator<T = unknown, TReturn = any, TNext = unknown> extends AsyncIterator<T, TReturn, TNext> {\n    // NOTE: 'next' is defined using a tuple to ensure we report the correct assignability errors in all places.\n    next(...args: [] | [TNext]): Promise<IteratorResult<T, TReturn>>;\n    return(value: TReturn | PromiseLike<TReturn>): Promise<IteratorResult<T, TReturn>>;\n    throw(e: any): Promise<IteratorResult<T, TReturn>>;\n    [Symbol.asyncIterator](): AsyncGenerator<T, TReturn, TNext>;\n}\n\ninterface AsyncGeneratorFunction {\n    /**\n     * Creates a new AsyncGenerator object.\n     * @param args A list of arguments the function accepts.\n     */\n    new (...args: any[]): AsyncGenerator;\n    /**\n     * Creates a new AsyncGenerator object.\n     * @param args A list of arguments the function accepts.\n     */\n    (...args: any[]): AsyncGenerator;\n    /**\n     * The length of the arguments.\n     */\n    readonly length: number;\n    /**\n     * Returns the name of the function.\n     */\n    readonly name: string;\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: AsyncGenerator;\n}\n\ninterface AsyncGeneratorFunctionConstructor {\n    /**\n     * Creates a new AsyncGenerator function.\n     * @param args A list of arguments the function accepts.\n     */\n    new (...args: string[]): AsyncGeneratorFunction;\n    /**\n     * Creates a new AsyncGenerator function.\n     * @param args A list of arguments the function accepts.\n     */\n    (...args: string[]): AsyncGeneratorFunction;\n    /**\n     * The length of the arguments.\n     */\n    readonly length: number;\n    /**\n     * Returns the name of the function.\n     */\n    readonly name: string;\n    /**\n     * A reference to the prototype.\n     */\n    readonly prototype: AsyncGeneratorFunction;\n}\n";
libFileMap['lib.es2018.asynciterable.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2015.symbol\" />\n/// <reference lib=\"es2015.iterable\" />\n\ninterface SymbolConstructor {\n    /**\n     * A method that returns the default async iterator for an object. Called by the semantics of\n     * the for-await-of statement.\n     */\n    readonly asyncIterator: symbol;\n}\n\ninterface AsyncIterator<T, TReturn = any, TNext = undefined> {\n    // NOTE: 'next' is defined using a tuple to ensure we report the correct assignability errors in all places.\n    next(...args: [] | [TNext]): Promise<IteratorResult<T, TReturn>>;\n    return?(value?: TReturn | PromiseLike<TReturn>): Promise<IteratorResult<T, TReturn>>;\n    throw?(e?: any): Promise<IteratorResult<T, TReturn>>;\n}\n\ninterface AsyncIterable<T> {\n    [Symbol.asyncIterator](): AsyncIterator<T>;\n}\n\ninterface AsyncIterableIterator<T> extends AsyncIterator<T> {\n    [Symbol.asyncIterator](): AsyncIterableIterator<T>;\n}";
libFileMap['lib.es2018.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2017\" />\n/// <reference lib=\"es2018.asynciterable\" />\n/// <reference lib=\"es2018.asyncgenerator\" />\n/// <reference lib=\"es2018.promise\" />\n/// <reference lib=\"es2018.regexp\" />\n/// <reference lib=\"es2018.intl\" />\n";
libFileMap['lib.es2018.full.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2018\" />\n/// <reference lib=\"dom\" />\n/// <reference lib=\"webworker.importscripts\" />\n/// <reference lib=\"scripthost\" />\n/// <reference lib=\"dom.iterable\" />";
libFileMap['lib.es2018.intl.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ndeclare namespace Intl {\n\n    // http://cldr.unicode.org/index/cldr-spec/plural-rules#TOC-Determining-Plural-Categories\n    type LDMLPluralRule = \"zero\" | \"one\" | \"two\" | \"few\" | \"many\" | \"other\";\n    type PluralRuleType = \"cardinal\" | \"ordinal\";\n\n    interface PluralRulesOptions {\n        localeMatcher?: \"lookup\" | \"best fit\";\n        type?: PluralRuleType;\n        minimumIntegerDigits?: number;\n        minimumFractionDigits?: number;\n        maximumFractionDigits?: number;\n        minimumSignificantDigits?: number;\n        maximumSignificantDigits?: number;\n    }\n\n    interface ResolvedPluralRulesOptions {\n        locale: string;\n        pluralCategories: LDMLPluralRule[];\n        type: PluralRuleType;\n        minimumIntegerDigits: number;\n        minimumFractionDigits: number;\n        maximumFractionDigits: number;\n        minimumSignificantDigits?: number;\n        maximumSignificantDigits?: number;\n    }\n\n    interface PluralRules {\n        resolvedOptions(): ResolvedPluralRulesOptions;\n        select(n: number): LDMLPluralRule;\n    }\n\n    const PluralRules: {\n        new (locales?: string | string[], options?: PluralRulesOptions): PluralRules;\n        (locales?: string | string[], options?: PluralRulesOptions): PluralRules;\n        supportedLocalesOf(\n            locales: string | string[],\n            options?: PluralRulesOptions,\n        ): string[];\n    };\n}\n";
libFileMap['lib.es2018.promise.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/**\n * Represents the completion of an asynchronous operation\n */\ninterface Promise<T> {\n    /**\n     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The\n     * resolved value cannot be modified from the callback.\n     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).\n     * @returns A Promise for the completion of the callback.\n     */\n    finally(onfinally?: (() => void) | undefined | null): Promise<T>\n}\n";
libFileMap['lib.es2018.regexp.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ninterface RegExpMatchArray {\n    groups?: {\n        [key: string]: string\n    }\n}\n\ninterface RegExpExecArray {\n    groups?: {\n        [key: string]: string\n    }\n}\n\ninterface RegExp {\n    /**\n     * Returns a Boolean value indicating the state of the dotAll flag (s) used with a regular expression.\n     * Default is false. Read-only.\n     */\n    readonly dotAll: boolean;\n}";
libFileMap['lib.es2019.array.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ntype FlatArray<Arr, Depth extends number> = {\n    \"done\": Arr,\n    \"recur\": Arr extends ReadonlyArray<infer InnerArr>\n        ? FlatArray<InnerArr, [-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20][Depth]>\n        : Arr\n}[Depth extends -1 ? \"done\" : \"recur\"];\n\ninterface ReadonlyArray<T> {\n\n    /**\n     * Calls a defined callback function on each element of an array. Then, flattens the result into\n     * a new array.\n     * This is identical to a map followed by flat with depth 1.\n     *\n     * @param callback A function that accepts up to three arguments. The flatMap method calls the\n     * callback function one time for each element in the array.\n     * @param thisArg An object to which the this keyword can refer in the callback function. If\n     * thisArg is omitted, undefined is used as the this value.\n     */\n    flatMap<U, This = undefined> (\n        callback: (this: This, value: T, index: number, array: T[]) => U | ReadonlyArray<U>,\n        thisArg?: This\n    ): U[]\n\n\n    /**\n     * Returns a new array with all sub-array elements concatenated into it recursively up to the\n     * specified depth.\n     *\n     * @param depth The maximum recursion depth\n     */\n    flat<A, D extends number = 1>(\n        this: A,\n        depth?: D\n    ): FlatArray<A, D>[]\n  }\n\ninterface Array<T> {\n\n    /**\n     * Calls a defined callback function on each element of an array. Then, flattens the result into\n     * a new array.\n     * This is identical to a map followed by flat with depth 1.\n     *\n     * @param callback A function that accepts up to three arguments. The flatMap method calls the\n     * callback function one time for each element in the array.\n     * @param thisArg An object to which the this keyword can refer in the callback function. If\n     * thisArg is omitted, undefined is used as the this value.\n     */\n    flatMap<U, This = undefined> (\n        callback: (this: This, value: T, index: number, array: T[]) => U | ReadonlyArray<U>,\n        thisArg?: This\n    ): U[]\n\n    /**\n     * Returns a new array with all sub-array elements concatenated into it recursively up to the\n     * specified depth.\n     *\n     * @param depth The maximum recursion depth\n     */\n    flat<A, D extends number = 1>(\n        this: A,\n        depth?: D\n    ): FlatArray<A, D>[]\n}\n";
libFileMap['lib.es2019.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2018\" />\n/// <reference lib=\"es2019.array\" />\n/// <reference lib=\"es2019.object\" />\n/// <reference lib=\"es2019.string\" />\n/// <reference lib=\"es2019.symbol\" />\n";
libFileMap['lib.es2019.full.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2019\" />\n/// <reference lib=\"dom\" />\n/// <reference lib=\"webworker.importscripts\" />\n/// <reference lib=\"scripthost\" />\n/// <reference lib=\"dom.iterable\" />\n";
libFileMap['lib.es2019.object.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\n/// <reference lib=\"es2015.iterable\" />\n\ninterface ObjectConstructor {\n    /**\n     * Returns an object created by key-value entries for properties and methods\n     * @param entries An iterable object that contains key-value entries for properties and methods.\n     */\n    fromEntries<T = any>(entries: Iterable<readonly [PropertyKey, T]>): { [k: string]: T };\n\n    /**\n     * Returns an object created by key-value entries for properties and methods\n     * @param entries An iterable object that contains key-value entries for properties and methods.\n     */\n    fromEntries(entries: Iterable<readonly any[]>): any;\n}\n";
libFileMap['lib.es2019.string.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ninterface String {\n    /** Removes the trailing white space and line terminator characters from a string. */\n    trimEnd(): string;\n\n    /** Removes the leading white space and line terminator characters from a string. */\n    trimStart(): string;\n\n    /** Removes the leading white space and line terminator characters from a string. */\n    trimLeft(): string;\n\n    /** Removes the trailing white space and line terminator characters from a string. */\n    trimRight(): string;\n}\n";
libFileMap['lib.es2019.symbol.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ninterface Symbol {\n    /**\n     * Expose the [[Description]] internal slot of a symbol directly.\n     */\n    readonly description: string | undefined;\n}\n";
libFileMap['lib.es2020.bigint.d.ts'] = "/*! *****************************************************************************\nCopyright (c) Microsoft Corporation. All rights reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use\nthis file except in compliance with the License. You may obtain a copy of the\nLicense at http://www.apache.org/licenses/LICENSE-2.0\n\nTHIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\nWARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\nMERCHANTABLITY OR NON-INFRINGEMENT.\n\nSee the Apache Version 2.0 License for specific language governing permissions\nand limitations under the License.\n***************************************************************************** */\n\n\n\n/// <reference no-default-lib=\"true\"/>\n\n\ninterface BigIntToLocaleStringOptions {\n    /**\n     * The locale matching algorithm to use.The default is \"best fit\". For information about this option, see the {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl#Locale_negotiation Intl page}.\n     */\n    localeMatcher?: string;\n    /**\n     * The formatting style to use , the default is \"decimal\".\n     */\n    style?: string;\n\n    numberingSystem?: string;\n    /**\n     * The unit to use in unit formatting, Possible values are core unit identifiers, defined in UTS #35, Part 2, Section 6. A subset of units from the full list was selected for use in ECMAScript. Pairs of simple units can be concatenated with \"-per-\" to make a compound unit. There is no default value; if the style is \"unit\", the unit property must be provided.\n     */\n    unit?: string;\n\n    /**\n     * The unit formatting style to use in unit formatting, the defaults is \"short\".\n     */\n    unitDisplay?: string;\n\n    /**\n     * The currency to use in currency formatting. Possible values are the ISO 4217 currency codes, such as \"USD\" for the US dollar, \"EUR\" for the euro, or \"CNY\" for the Chinese RMB — see the Current currency & funds code list. There is no default value; if the style is \"currency\", the currency property must be provided. It is only used when [[Style]] has the value \"currency\".\n     */\n    currency?: string;\n\n    /**\n     * How to display the currency in currency formatting. It is only used when [[Style]] has the value \"currency\". The default is \"symbol\".\n     *\n     * \"symbol\" to use a localized currency symbol such as €,\n     *\n     * \"code\" to use the ISO currency code,\n     *\n     * \"name\" to use a localized currency name such as \"dollar\"\n     */\n    currencyDisplay?: string;\n\n    /**\n     * Whether to use grouping separators, such as thousands separators or thousand/lakh/crore separators. The default is true.\n     */\n    useGrouping?: boolean;\n\n    /**\n     * The minimum number of integer digits to use. Possible values are from 1 to 21; the default is 1.\n     */\n    minimumIntegerDigits?: 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11 | 12 | 13 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21;\n\n    /**\n     * The minimum number of fraction digits to use. Possible values are from 0 to 20; the default for plain number and percent formatting is 0; the default for currency formatting is the number of minor unit digits provided by the {@link http://www.currency-iso.org/en/home/tables/table-a1.html ISO 4217 currency codes list} (2 if the list doesn't provide that information).\n     */\n    minimumFractionDigits?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11 | 12 | 13 | 14 | 15 | 16 | 17 | 18 | 19 | 20;\n\n    /**\n     * The maximum number of fraction digits to use. Possible values are from 0 to 20; the default for plain number formatting is the larger of minimumFractionDigits and 3; the default for currency formatting is the larger of minimumFractionDigits and the number of minor unit digits provided by the {@link http://www.currency-iso.org/en/home/tables/table-a1.html ISO 4217 currency codes list} (2 if the list doesn't provide that information); the default for percent formatting is the larger of minimumFractionDigits and 0.\n     */\n    maximumFractionDigits?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11 | 12 | 13 | 14 | 15 | 16 | 17 | 18 | 19 | 20;\n\n    /**\n     * The minimum number of significant digits to use. Possible values are from 1 to 21; the default is 1.\n     */\n    minimumSignificantDigits?: 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11 | 12 | 13 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21;\n\n    /**\n     * The maximum number of significant digits to use. Possible values are from 1 to 21; the default is 21.\n     */\n    maximumSignificantDigits?: 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11 | 12 | 13 | 14 | 15 | 16 | 17 | 18 | 19 | 20 | 21;\n\n    /**\n     * The formatting that should be displayed for the number, the defaults is \"standard\"\n     *\n     *     \"standard\" plain number formatting\n     *\n     *     \"scientific\" return the order-of-magnitude for formatted number.\n     *\n     *     \"engineering\" return the exponent of ten when divisible by three\n     *\n     *     \"compact\" string representing exponent, defaults is using the \"short\" form\n     */\n    notation?: string;\n\n    /**\n     * used only when notation is \"compact\"\n     */\n    compactDisplay?: string;\n}\n\ninterface BigInt {\n    /**\n     * Returns a string representation of an object.\n     * @param radix Specifies a radix for converting numeric values to strings.\n     */\n    toString(radix?: number): string;\n\n    /** Returns a string representation appropriate to the host environment's current locale. */\n    toLocaleString(locales?: string, options?: BigIntToLocaleStringOptions): string;\n\n    /** Returns the primitive value of the specified object. */\n    valueOf(): bigint;\n\n    readonly [Symbol.toStringTag]: \"BigInt\";\n}\n\ninterface BigIntConstructor {\n    (value?: any): bigint;\n    readonly prototype: BigInt;\n\n    /**\n     * Interprets the low bits of a BigInt as a 2's-complement signed integer.\n     * All higher bits are discarded.\n     * @param bits The number of low bits to use\n     * @param int The BigInt whose bits to extract\n     */\n    asIntN(bits: number, int: bigint): bigint;\n    /**\n     * Interprets the low bits of a BigInt as an unsigned integer.\n     * All higher bits are discarded.\n     * @param bits The number of low bits to use\n     * @param int The BigInt whose bits to extract\n     */\n    asUintN(bits: number, int: bigint): bigint;\n}\n\ndeclare var BigInt: BigIntConstructor;\n\n/**\n * A typed array of 64-bit signed integer values. The contents are initialized to 0. If the\n * requested number of bytes could not be allocated, an exception is raised.\n */\ninterface BigInt64Array {\n    /** The size in bytes of each element in the array. */\n    readonly BYTES_PER_ELEMENT: number;\n\n    /** The ArrayBuffer instance referenced by the array. */\n    readonly buffer: ArrayBufferLike;\n\n    /** The length in bytes of the array. */\n    readonly byteLength: number;\n\n    /** The offset in bytes of the array. */\n    readonly byteOffset: number;\n\n    /**\n     * Returns the this object after copying a section of the array identified by start and end\n     * to the same array starting at position target\n     * @param target If target is negative, it is treated as length+target where length is the\n     * length of the array.\n     * @param start If start is negative, it is treated as length+start. If end is negative, it\n     * is treated as length+end.\n     * @param end If not specified, length of the this object is used as its default value.\n     */\n    copyWithin(target: number, start: number, end?: number): this;\n\n    /** Yields index, value pairs for every entry in the array. */\n    entries(): IterableIterator<[number, bigint]>;\n\n    /**\n     * Determines whether all the members of an array satisfy the specified test.\n     * @param predicate A function that accepts up to three arguments. The every method calls\n     * the predicate function for each element in the array until the predicate returns false,\n     * or until the end of the array.\n     * @param thisArg An object to which the this keyword can refer in the predicate function.\n     * If thisArg is omitted, undefined is used as the this value.\n     */\n    every(predicate: (value: bigint, index: number, array: BigInt64Array) => boolean, thisArg?: any): boolean;\n\n    /**\n     * Returns the this object after filling the section identified by start and end with value\n     * @param value value to fill array section with\n     * @param start index to start filling the array at. If start is negative, it is treated as\n     * length+start where length is the length of the array.\n     * @param end index to stop filling the array at. If end is negative, it is treated as\n     * length+end.\n     */\n    fill(value: bigint, start?: number, end?: number): this;\n\n    /**\n     * Returns the elements of an array that meet the condition specified in a callback function.\n     * @param predicate A function that accepts up to three arguments. The filter method calls\n     * the predicate function one time for each element in the array.\n     * @param thisArg An object to which the this keyword can refer in the predicate function.\n     * If thisArg is omitted, undefined is used as the this value.\n     */\n    filter(predicate: (value: bigint, index: number, array: BigInt64Array) => any, thisArg?: any): BigInt64Array;\n\n    /**\n     * Returns the value of the first element in the array where predicate is true, and undefined\n     * otherwise.\n     * @param predicate find calls predicate once for each element of the array, in ascending\n     * order, until it finds one where predicate returns true. If such an element is found, find\n     * immediately returns that element value. Otherwise, find returns undefined.\n     * @param thisArg If provided, it will be used as the this value for each invocation of\n     * predicate. If it is not provided, undefined is used instead.\n     */\n    find(predicate: (value: bigint, index: number, array: BigInt64Array) => boolean, thisArg?: any): bigint | undefined;\n\n    /**\n     * Returns the index of the first element in the array where predicate is true, and -1\n     * otherwise.\n     * @param predicate find calls predicate once for each element of the array, in ascending\n     * order, until it finds one where predicate returns true. If such an element is found,\n     * findIndex immediately returns that element index. Otherwise, findIndex returns -1.\n     * @param thisArg If provided, it will be used as the this value for each invocation of\n     * predicate. If it is not provided, undefined is used instead.\n     */\n    findIndex(predicate: (value: bigint, index: number, array: BigInt64Array) => boolean, thisArg?: any): number;\n\n    /**\n     * Performs the specified action for each element in an array.\n     * @param callbackfn A function that accepts up to three arguments. forEach calls the\n     * callbackfn function one time for each element in the array.\n     * @param thisArg An object to which the this keyword can refer in the callbackfn function.\n     * If thisArg is omitted, undefined is used as the this value.\n     */\n    forEach(callbackfn: (value: bigint, index: number, array: BigInt64Array) => voi