/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
import { registerAction2 } from '../../../../platform/actions/common/actions.js';
import { registerEditorContribution } from '../../../browser/editorExtensions.js';
import { InteractiveEditorController } from './interactiveEditorWidget.js';
import * as interactiveEditorActions from './interactiveEditorActions.js';
import { IInteractiveEditorService } from '../common/interactiveEditor.js';
import { registerSingleton } from '../../../../platform/instantiation/common/extensions.js';
import { InteractiveEditorServiceImpl } from '../common/interactiveEditorServiceImpl.js';
registerSingleton(IInteractiveEditorService, InteractiveEditorServiceImpl, 1 /* InstantiationType.Delayed */);
registerEditorContribution(InteractiveEditorController.ID, InteractiveEditorController, 4 /* EditorContributionInstantiation.Lazy */);
registerAction2(interactiveEditorActions.StartSessionAction);
registerAction2(interactiveEditorActions.ToggleHistory);
registerAction2(interactiveEditorActions.MakeRequestAction);
registerAction2(interactiveEditorActions.StopRequestAction);
registerAction2(interactiveEditorActions.AcceptWithPreviewInteractiveEditorAction);
registerAction2(interactiveEditorActions.TogglePreviewMode);
registerAction2(interactiveEditorActions.CancelSessionAction);
registerAction2(interactiveEditorActions.ArrowOutUpAction);
registerAction2(interactiveEditorActions.ArrowOutDownAction);
registerAction2(interactiveEditorActions.FocusInteractiveEditor);
registerAction2(interactiveEditorActions.PreviousFromHistory);
registerAction2(interactiveEditorActions.NextFromHistory);
registerAction2(interactiveEditorActions.UndoCommand);
registerAction2(interactiveEditorActions.CopyRecordings);
