"use strict";/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.43.0(94c055bcbdd49f04a0fa15515e848542a79fb948)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
define("vs/language/css/cssWorker", ["require","require"],(require)=>{
var moduleExports=(()=>{var $n=Object.defineProperty;var ds=Object.getOwnPropertyDescriptor;var hs=Object.getOwnPropertyNames;var ps=Object.prototype.hasOwnProperty;var us=(n,e)=>{for(var t in e)$n(n,t,{get:e[t],enumerable:!0})},ms=(n,e,t,r)=>{if(e&&typeof e=="object"||typeof e=="function")for(let i of hs(e))!ps.call(n,i)&&i!==t&&$n(n,i,{get:()=>e[i],enumerable:!(r=ds(e,i))||r.enumerable});return n};var fs=n=>ms($n({},"__esModule",{value:!0}),n);var sl={};us(sl,{CSSWorker:()=>Vn,create:()=>ol});var d;(function(n){n[n.Ident=0]="Ident",n[n.AtKeyword=1]="AtKeyword",n[n.String=2]="String",n[n.BadString=3]="BadString",n[n.UnquotedString=4]="UnquotedString",n[n.Hash=5]="Hash",n[n.Num=6]="Num",n[n.Percentage=7]="Percentage",n[n.Dimension=8]="Dimension",n[n.UnicodeRange=9]="UnicodeRange",n[n.CDO=10]="CDO",n[n.CDC=11]="CDC",n[n.Colon=12]="Colon",n[n.SemiColon=13]="SemiColon",n[n.CurlyL=14]="CurlyL",n[n.CurlyR=15]="CurlyR",n[n.ParenthesisL=16]="ParenthesisL",n[n.ParenthesisR=17]="ParenthesisR",n[n.BracketL=18]="BracketL",n[n.BracketR=19]="BracketR",n[n.Whitespace=20]="Whitespace",n[n.Includes=21]="Includes",n[n.Dashmatch=22]="Dashmatch",n[n.SubstringOperator=23]="SubstringOperator",n[n.PrefixOperator=24]="PrefixOperator",n[n.SuffixOperator=25]="SuffixOperator",n[n.Delim=26]="Delim",n[n.EMS=27]="EMS",n[n.EXS=28]="EXS",n[n.Length=29]="Length",n[n.Angle=30]="Angle",n[n.Time=31]="Time",n[n.Freq=32]="Freq",n[n.Exclamation=33]="Exclamation",n[n.Resolution=34]="Resolution",n[n.Comma=35]="Comma",n[n.Charset=36]="Charset",n[n.EscapedJavaScript=37]="EscapedJavaScript",n[n.BadEscapedJavaScript=38]="BadEscapedJavaScript",n[n.Comment=39]="Comment",n[n.SingleLineComment=40]="SingleLineComment",n[n.EOF=41]="EOF",n[n.CustomToken=42]="CustomToken"})(d||(d={}));var Kr=function(){function n(e){this.source=e,this.len=e.length,this.position=0}return n.prototype.substring=function(e,t){return t===void 0&&(t=this.position),this.source.substring(e,t)},n.prototype.eos=function(){return this.len<=this.position},n.prototype.pos=function(){return this.position},n.prototype.goBackTo=function(e){this.position=e},n.prototype.goBack=function(e){this.position-=e},n.prototype.advance=function(e){this.position+=e},n.prototype.nextChar=function(){return this.source.charCodeAt(this.position++)||0},n.prototype.peekChar=function(e){return e===void 0&&(e=0),this.source.charCodeAt(this.position+e)||0},n.prototype.lookbackChar=function(e){return e===void 0&&(e=0),this.source.charCodeAt(this.position-e)||0},n.prototype.advanceIfChar=function(e){return e===this.source.charCodeAt(this.position)?(this.position++,!0):!1},n.prototype.advanceIfChars=function(e){if(this.position+e.length>this.source.length)return!1;for(var t=0;t<e.length;t++)if(this.source.charCodeAt(this.position+t)!==e[t])return!1;return this.advance(t),!0},n.prototype.advanceWhileChar=function(e){for(var t=this.position;this.position<this.len&&e(this.source.charCodeAt(this.position));)this.position++;return this.position-t},n}();var nn="a".charCodeAt(0),Gr="f".charCodeAt(0),Hr="z".charCodeAt(0),ll="u".charCodeAt(0),rn="A".charCodeAt(0),Jr="F".charCodeAt(0),Xr="Z".charCodeAt(0),kt="0".charCodeAt(0),Ct="9".charCodeAt(0),gs="~".charCodeAt(0),bs="^".charCodeAt(0),_t="=".charCodeAt(0),vs="|".charCodeAt(0),Ye="-".charCodeAt(0),Yr="_".charCodeAt(0),ys="%".charCodeAt(0),qn="*".charCodeAt(0),ri="(".charCodeAt(0),ii=")".charCodeAt(0),ws="<".charCodeAt(0),xs=">".charCodeAt(0),Ss="@".charCodeAt(0),ks="#".charCodeAt(0),Cs="$".charCodeAt(0),Kn="\\".charCodeAt(0),Qr="/".charCodeAt(0),at=`
`.charCodeAt(0),lt="\r".charCodeAt(0),Ft="\f".charCodeAt(0),Zr='"'.charCodeAt(0),ei="'".charCodeAt(0),Gn=" ".charCodeAt(0),Hn="	".charCodeAt(0),_s=";".charCodeAt(0),Fs=":".charCodeAt(0),Es="{".charCodeAt(0),Ds="}".charCodeAt(0),zs="[".charCodeAt(0),Rs="]".charCodeAt(0),Is=",".charCodeAt(0),ti=".".charCodeAt(0),ni="!".charCodeAt(0),Ms="?".charCodeAt(0),Ts="+".charCodeAt(0),_e={};_e[_s]=d.SemiColon;_e[Fs]=d.Colon;_e[Es]=d.CurlyL;_e[Ds]=d.CurlyR;_e[Rs]=d.BracketR;_e[zs]=d.BracketL;_e[ri]=d.ParenthesisL;_e[ii]=d.ParenthesisR;_e[Is]=d.Comma;var X={};X.em=d.EMS;X.ex=d.EXS;X.px=d.Length;X.cm=d.Length;X.mm=d.Length;X.in=d.Length;X.pt=d.Length;X.pc=d.Length;X.deg=d.Angle;X.rad=d.Angle;X.grad=d.Angle;X.ms=d.Time;X.s=d.Time;X.hz=d.Freq;X.khz=d.Freq;X["%"]=d.Percentage;X.fr=d.Percentage;X.dpi=d.Resolution;X.dpcm=d.Resolution;var Fe=function(){function n(){this.stream=new Kr(""),this.ignoreComment=!0,this.ignoreWhitespace=!0,this.inURL=!1}return n.prototype.setSource=function(e){this.stream=new Kr(e)},n.prototype.finishToken=function(e,t,r){return{offset:e,len:this.stream.pos()-e,type:t,text:r||this.stream.substring(e)}},n.prototype.substring=function(e,t){return this.stream.substring(e,e+t)},n.prototype.pos=function(){return this.stream.pos()},n.prototype.goBackTo=function(e){this.stream.goBackTo(e)},n.prototype.scanUnquotedString=function(){var e=this.stream.pos(),t=[];return this._unquotedString(t)?this.finishToken(e,d.UnquotedString,t.join("")):null},n.prototype.scan=function(){var e=this.trivia();if(e!==null)return e;var t=this.stream.pos();return this.stream.eos()?this.finishToken(t,d.EOF):this.scanNext(t)},n.prototype.tryScanUnicode=function(){var e=this.stream.pos();if(!this.stream.eos()&&this._unicodeRange())return this.finishToken(e,d.UnicodeRange);this.stream.goBackTo(e)},n.prototype.scanNext=function(e){if(this.stream.advanceIfChars([ws,ni,Ye,Ye]))return this.finishToken(e,d.CDO);if(this.stream.advanceIfChars([Ye,Ye,xs]))return this.finishToken(e,d.CDC);var t=[];if(this.ident(t))return this.finishToken(e,d.Ident,t.join(""));if(this.stream.advanceIfChar(Ss))if(t=["@"],this._name(t)){var r=t.join("");return r==="@charset"?this.finishToken(e,d.Charset,r):this.finishToken(e,d.AtKeyword,r)}else return this.finishToken(e,d.Delim);if(this.stream.advanceIfChar(ks))return t=["#"],this._name(t)?this.finishToken(e,d.Hash,t.join("")):this.finishToken(e,d.Delim);if(this.stream.advanceIfChar(ni))return this.finishToken(e,d.Exclamation);if(this._number()){var i=this.stream.pos();if(t=[this.stream.substring(e,i)],this.stream.advanceIfChar(ys))return this.finishToken(e,d.Percentage);if(this.ident(t)){var o=this.stream.substring(i).toLowerCase(),s=X[o];return typeof s<"u"?this.finishToken(e,s,t.join("")):this.finishToken(e,d.Dimension,t.join(""))}return this.finishToken(e,d.Num)}t=[];var a=this._string(t);return a!==null?this.finishToken(e,a,t.join("")):(a=_e[this.stream.peekChar()],typeof a<"u"?(this.stream.advance(1),this.finishToken(e,a)):this.stream.peekChar(0)===gs&&this.stream.peekChar(1)===_t?(this.stream.advance(2),this.finishToken(e,d.Includes)):this.stream.peekChar(0)===vs&&this.stream.peekChar(1)===_t?(this.stream.advance(2),this.finishToken(e,d.Dashmatch)):this.stream.peekChar(0)===qn&&this.stream.peekChar(1)===_t?(this.stream.advance(2),this.finishToken(e,d.SubstringOperator)):this.stream.peekChar(0)===bs&&this.stream.peekChar(1)===_t?(this.stream.advance(2),this.finishToken(e,d.PrefixOperator)):this.stream.peekChar(0)===Cs&&this.stream.peekChar(1)===_t?(this.stream.advance(2),this.finishToken(e,d.SuffixOperator)):(this.stream.nextChar(),this.finishToken(e,d.Delim)))},n.prototype.trivia=function(){for(;;){var e=this.stream.pos();if(this._whitespace()){if(!this.ignoreWhitespace)return this.finishToken(e,d.Whitespace)}else if(this.comment()){if(!this.ignoreComment)return this.finishToken(e,d.Comment)}else return null}},n.prototype.comment=function(){if(this.stream.advanceIfChars([Qr,qn])){var e=!1,t=!1;return this.stream.advanceWhileChar(function(r){return t&&r===Qr?(e=!0,!1):(t=r===qn,!0)}),e&&this.stream.advance(1),!0}return!1},n.prototype._number=function(){var e=0,t;return this.stream.peekChar()===ti&&(e=1),t=this.stream.peekChar(e),t>=kt&&t<=Ct?(this.stream.advance(e+1),this.stream.advanceWhileChar(function(r){return r>=kt&&r<=Ct||e===0&&r===ti}),!0):!1},n.prototype._newline=function(e){var t=this.stream.peekChar();switch(t){case lt:case Ft:case at:return this.stream.advance(1),e.push(String.fromCharCode(t)),t===lt&&this.stream.advanceIfChar(at)&&e.push(`
`),!0}return!1},n.prototype._escape=function(e,t){var r=this.stream.peekChar();if(r===Kn){this.stream.advance(1),r=this.stream.peekChar();for(var i=0;i<6&&(r>=kt&&r<=Ct||r>=nn&&r<=Gr||r>=rn&&r<=Jr);)this.stream.advance(1),r=this.stream.peekChar(),i++;if(i>0){try{var o=parseInt(this.stream.substring(this.stream.pos()-i),16);o&&e.push(String.fromCharCode(o))}catch{}return r===Gn||r===Hn?this.stream.advance(1):this._newline([]),!0}if(r!==lt&&r!==Ft&&r!==at)return this.stream.advance(1),e.push(String.fromCharCode(r)),!0;if(t)return this._newline(e)}return!1},n.prototype._stringChar=function(e,t){var r=this.stream.peekChar();return r!==0&&r!==e&&r!==Kn&&r!==lt&&r!==Ft&&r!==at?(this.stream.advance(1),t.push(String.fromCharCode(r)),!0):!1},n.prototype._string=function(e){if(this.stream.peekChar()===ei||this.stream.peekChar()===Zr){var t=this.stream.nextChar();for(e.push(String.fromCharCode(t));this._stringChar(t,e)||this._escape(e,!0););return this.stream.peekChar()===t?(this.stream.nextChar(),e.push(String.fromCharCode(t)),d.String):d.BadString}return null},n.prototype._unquotedChar=function(e){var t=this.stream.peekChar();return t!==0&&t!==Kn&&t!==ei&&t!==Zr&&t!==ri&&t!==ii&&t!==Gn&&t!==Hn&&t!==at&&t!==Ft&&t!==lt?(this.stream.advance(1),e.push(String.fromCharCode(t)),!0):!1},n.prototype._unquotedString=function(e){for(var t=!1;this._unquotedChar(e)||this._escape(e);)t=!0;return t},n.prototype._whitespace=function(){var e=this.stream.advanceWhileChar(function(t){return t===Gn||t===Hn||t===at||t===Ft||t===lt});return e>0},n.prototype._name=function(e){for(var t=!1;this._identChar(e)||this._escape(e);)t=!0;return t},n.prototype.ident=function(e){var t=this.stream.pos(),r=this._minus(e);if(r){if(this._minus(e)||this._identFirstChar(e)||this._escape(e)){for(;this._identChar(e)||this._escape(e););return!0}}else if(this._identFirstChar(e)||this._escape(e)){for(;this._identChar(e)||this._escape(e););return!0}return this.stream.goBackTo(t),!1},n.prototype._identFirstChar=function(e){var t=this.stream.peekChar();return t===Yr||t>=nn&&t<=Hr||t>=rn&&t<=Xr||t>=128&&t<=65535?(this.stream.advance(1),e.push(String.fromCharCode(t)),!0):!1},n.prototype._minus=function(e){var t=this.stream.peekChar();return t===Ye?(this.stream.advance(1),e.push(String.fromCharCode(t)),!0):!1},n.prototype._identChar=function(e){var t=this.stream.peekChar();return t===Yr||t===Ye||t>=nn&&t<=Hr||t>=rn&&t<=Xr||t>=kt&&t<=Ct||t>=128&&t<=65535?(this.stream.advance(1),e.push(String.fromCharCode(t)),!0):!1},n.prototype._unicodeRange=function(){if(this.stream.advanceIfChar(Ts)){var e=function(i){return i>=kt&&i<=Ct||i>=nn&&i<=Gr||i>=rn&&i<=Jr},t=this.stream.advanceWhileChar(e)+this.stream.advanceWhileChar(function(i){return i===Ms});if(t>=1&&t<=6)if(this.stream.advanceIfChar(Ye)){var r=this.stream.advanceWhileChar(e);if(r>=1&&r<=6)return!0}else return!0}return!1},n}();function q(n,e){if(n.length<e.length)return!1;for(var t=0;t<e.length;t++)if(n[t]!==e[t])return!1;return!0}function on(n,e){var t=n.length-e.length;return t>0?n.lastIndexOf(e)===t:t===0?n===e:!1}function oi(n,e,t){t===void 0&&(t=4);var r=Math.abs(n.length-e.length);if(r>t)return 0;var i=[],o=[],s,a;for(s=0;s<e.length+1;++s)o.push(0);for(s=0;s<n.length+1;++s)i.push(o);for(s=1;s<n.length+1;++s)for(a=1;a<e.length+1;++a)n[s-1]===e[a-1]?i[s][a]=i[s-1][a-1]+1:i[s][a]=Math.max(i[s-1][a],i[s][a-1]);return i[n.length][e.length]-Math.sqrt(r)}function Jn(n,e){return e===void 0&&(e=!0),n?n.length<140?n:n.slice(0,140)+(e?"\u2026":""):""}function si(n,e){var t=e.exec(n);return t&&t[0].length?n.substr(0,n.length-t[0].length):n}function Xn(n,e){for(var t="";e>0;)(e&1)===1&&(t+=n),n+=n,e=e>>>1;return t}var E=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,i){r.__proto__=i}||function(r,i){for(var o in i)Object.prototype.hasOwnProperty.call(i,o)&&(r[o]=i[o])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),u;(function(n){n[n.Undefined=0]="Undefined",n[n.Identifier=1]="Identifier",n[n.Stylesheet=2]="Stylesheet",n[n.Ruleset=3]="Ruleset",n[n.Selector=4]="Selector",n[n.SimpleSelector=5]="SimpleSelector",n[n.SelectorInterpolation=6]="SelectorInterpolation",n[n.SelectorCombinator=7]="SelectorCombinator",n[n.SelectorCombinatorParent=8]="SelectorCombinatorParent",n[n.SelectorCombinatorSibling=9]="SelectorCombinatorSibling",n[n.SelectorCombinatorAllSiblings=10]="SelectorCombinatorAllSiblings",n[n.SelectorCombinatorShadowPiercingDescendant=11]="SelectorCombinatorShadowPiercingDescendant",n[n.Page=12]="Page",n[n.PageBoxMarginBox=13]="PageBoxMarginBox",n[n.ClassSelector=14]="ClassSelector",n[n.IdentifierSelector=15]="IdentifierSelector",n[n.ElementNameSelector=16]="ElementNameSelector",n[n.PseudoSelector=17]="PseudoSelector",n[n.AttributeSelector=18]="AttributeSelector",n[n.Declaration=19]="Declaration",n[n.Declarations=20]="Declarations",n[n.Property=21]="Property",n[n.Expression=22]="Expression",n[n.BinaryExpression=23]="BinaryExpression",n[n.Term=24]="Term",n[n.Operator=25]="Operator",n[n.Value=26]="Value",n[n.StringLiteral=27]="StringLiteral",n[n.URILiteral=28]="URILiteral",n[n.EscapedValue=29]="EscapedValue",n[n.Function=30]="Function",n[n.NumericValue=31]="NumericValue",n[n.HexColorValue=32]="HexColorValue",n[n.RatioValue=33]="RatioValue",n[n.MixinDeclaration=34]="MixinDeclaration",n[n.MixinReference=35]="MixinReference",n[n.VariableName=36]="VariableName",n[n.VariableDeclaration=37]="VariableDeclaration",n[n.Prio=38]="Prio",n[n.Interpolation=39]="Interpolation",n[n.NestedProperties=40]="NestedProperties",n[n.ExtendsReference=41]="ExtendsReference",n[n.SelectorPlaceholder=42]="SelectorPlaceholder",n[n.Debug=43]="Debug",n[n.If=44]="If",n[n.Else=45]="Else",n[n.For=46]="For",n[n.Each=47]="Each",n[n.While=48]="While",n[n.MixinContentReference=49]="MixinContentReference",n[n.MixinContentDeclaration=50]="MixinContentDeclaration",n[n.Media=51]="Media",n[n.Keyframe=52]="Keyframe",n[n.FontFace=53]="FontFace",n[n.Import=54]="Import",n[n.Namespace=55]="Namespace",n[n.Invocation=56]="Invocation",n[n.FunctionDeclaration=57]="FunctionDeclaration",n[n.ReturnStatement=58]="ReturnStatement",n[n.MediaQuery=59]="MediaQuery",n[n.MediaCondition=60]="MediaCondition",n[n.MediaFeature=61]="MediaFeature",n[n.FunctionParameter=62]="FunctionParameter",n[n.FunctionArgument=63]="FunctionArgument",n[n.KeyframeSelector=64]="KeyframeSelector",n[n.ViewPort=65]="ViewPort",n[n.Document=66]="Document",n[n.AtApplyRule=67]="AtApplyRule",n[n.CustomPropertyDeclaration=68]="CustomPropertyDeclaration",n[n.CustomPropertySet=69]="CustomPropertySet",n[n.ListEntry=70]="ListEntry",n[n.Supports=71]="Supports",n[n.SupportsCondition=72]="SupportsCondition",n[n.NamespacePrefix=73]="NamespacePrefix",n[n.GridLine=74]="GridLine",n[n.Plugin=75]="Plugin",n[n.UnknownAtRule=76]="UnknownAtRule",n[n.Use=77]="Use",n[n.ModuleConfiguration=78]="ModuleConfiguration",n[n.Forward=79]="Forward",n[n.ForwardVisibility=80]="ForwardVisibility",n[n.Module=81]="Module",n[n.UnicodeRange=82]="UnicodeRange"})(u||(u={}));var A;(function(n){n[n.Mixin=0]="Mixin",n[n.Rule=1]="Rule",n[n.Variable=2]="Variable",n[n.Function=3]="Function",n[n.Keyframe=4]="Keyframe",n[n.Unknown=5]="Unknown",n[n.Module=6]="Module",n[n.Forward=7]="Forward",n[n.ForwardVisibility=8]="ForwardVisibility"})(A||(A={}));function sn(n,e){var t=null;return!n||e<n.offset||e>n.end?null:(n.accept(function(r){return r.offset===-1&&r.length===-1?!0:r.offset<=e&&r.end>=e?(t?r.length<=t.length&&(t=r):t=r,!0):!1}),t)}function ct(n,e){for(var t=sn(n,e),r=[];t;)r.unshift(t),t=t.parent;return r}function ai(n){var e=n.findParent(u.Declaration),t=e&&e.getValue();return t&&t.encloses(n)?e:null}var F=function(){function n(e,t,r){e===void 0&&(e=-1),t===void 0&&(t=-1),this.parent=null,this.offset=e,this.length=t,r&&(this.nodeType=r)}return Object.defineProperty(n.prototype,"end",{get:function(){return this.offset+this.length},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"type",{get:function(){return this.nodeType||u.Undefined},set:function(e){this.nodeType=e},enumerable:!1,configurable:!0}),n.prototype.getTextProvider=function(){for(var e=this;e&&!e.textProvider;)e=e.parent;return e?e.textProvider:function(){return"unknown"}},n.prototype.getText=function(){return this.getTextProvider()(this.offset,this.length)},n.prototype.matches=function(e){return this.length===e.length&&this.getTextProvider()(this.offset,this.length)===e},n.prototype.startsWith=function(e){return this.length>=e.length&&this.getTextProvider()(this.offset,e.length)===e},n.prototype.endsWith=function(e){return this.length>=e.length&&this.getTextProvider()(this.end-e.length,e.length)===e},n.prototype.accept=function(e){if(e(this)&&this.children)for(var t=0,r=this.children;t<r.length;t++){var i=r[t];i.accept(e)}},n.prototype.acceptVisitor=function(e){this.accept(e.visitNode.bind(e))},n.prototype.adoptChild=function(e,t){if(t===void 0&&(t=-1),e.parent&&e.parent.children){var r=e.parent.children.indexOf(e);r>=0&&e.parent.children.splice(r,1)}e.parent=this;var i=this.children;return i||(i=this.children=[]),t!==-1?i.splice(t,0,e):i.push(e),e},n.prototype.attachTo=function(e,t){return t===void 0&&(t=-1),e&&e.adoptChild(this,t),this},n.prototype.collectIssues=function(e){this.issues&&e.push.apply(e,this.issues)},n.prototype.addIssue=function(e){this.issues||(this.issues=[]),this.issues.push(e)},n.prototype.hasIssue=function(e){return Array.isArray(this.issues)&&this.issues.some(function(t){return t.getRule()===e})},n.prototype.isErroneous=function(e){return e===void 0&&(e=!1),this.issues&&this.issues.length>0?!0:e&&Array.isArray(this.children)&&this.children.some(function(t){return t.isErroneous(!0)})},n.prototype.setNode=function(e,t,r){return r===void 0&&(r=-1),t?(t.attachTo(this,r),this[e]=t,!0):!1},n.prototype.addChild=function(e){return e?(this.children||(this.children=[]),e.attachTo(this),this.updateOffsetAndLength(e),!0):!1},n.prototype.updateOffsetAndLength=function(e){(e.offset<this.offset||this.offset===-1)&&(this.offset=e.offset);var t=e.end;(t>this.end||this.length===-1)&&(this.length=t-this.offset)},n.prototype.hasChildren=function(){return!!this.children&&this.children.length>0},n.prototype.getChildren=function(){return this.children?this.children.slice(0):[]},n.prototype.getChild=function(e){return this.children&&e<this.children.length?this.children[e]:null},n.prototype.addChildren=function(e){for(var t=0,r=e;t<r.length;t++){var i=r[t];this.addChild(i)}},n.prototype.findFirstChildBeforeOffset=function(e){if(this.children){for(var t=null,r=this.children.length-1;r>=0;r--)if(t=this.children[r],t.offset<=e)return t}return null},n.prototype.findChildAtOffset=function(e,t){var r=this.findFirstChildBeforeOffset(e);return r&&r.end>=e?t&&r.findChildAtOffset(e,!0)||r:null},n.prototype.encloses=function(e){return this.offset<=e.offset&&this.offset+this.length>=e.offset+e.length},n.prototype.getParent=function(){for(var e=this.parent;e instanceof ee;)e=e.parent;return e},n.prototype.findParent=function(e){for(var t=this;t&&t.type!==e;)t=t.parent;return t},n.prototype.findAParent=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var r=this;r&&!e.some(function(i){return r.type===i});)r=r.parent;return r},n.prototype.setData=function(e,t){this.options||(this.options={}),this.options[e]=t},n.prototype.getData=function(e){return!this.options||!this.options.hasOwnProperty(e)?null:this.options[e]},n}();var ee=function(n){E(e,n);function e(t,r){r===void 0&&(r=-1);var i=n.call(this,-1,-1)||this;return i.attachTo(t,r),i.offset=-1,i.length=-1,i}return e}(F);var li=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.UnicodeRange},enumerable:!1,configurable:!0}),e.prototype.setRangeStart=function(t){return this.setNode("rangeStart",t)},e.prototype.getRangeStart=function(){return this.rangeStart},e.prototype.setRangeEnd=function(t){return this.setNode("rangeEnd",t)},e.prototype.getRangeEnd=function(){return this.rangeEnd},e}(F);var te=function(n){E(e,n);function e(t,r){var i=n.call(this,t,r)||this;return i.isCustomProperty=!1,i}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Identifier},enumerable:!1,configurable:!0}),e.prototype.containsInterpolation=function(){return this.hasChildren()},e}(F);var ci=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Stylesheet},enumerable:!1,configurable:!0}),e}(F);var Et=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Declarations},enumerable:!1,configurable:!0}),e}(F);var K=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return e.prototype.getDeclarations=function(){return this.declarations},e.prototype.setDeclarations=function(t){return this.setNode("declarations",t)},e}(F);var Te=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Ruleset},enumerable:!1,configurable:!0}),e.prototype.getSelectors=function(){return this.selectors||(this.selectors=new ee(this)),this.selectors},e.prototype.isNested=function(){return!!this.parent&&this.parent.findParent(u.Declarations)!==null},e}(K);var Ee=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Selector},enumerable:!1,configurable:!0}),e}(F);var De=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.SimpleSelector},enumerable:!1,configurable:!0}),e}(F);var dl=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.AtApplyRule},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(t){return this.setNode("identifier",t,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e}(F);var an=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return e}(F);var di=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.CustomPropertySet},enumerable:!1,configurable:!0}),e}(K);var ae=function(n){E(e,n);function e(t,r){var i=n.call(this,t,r)||this;return i.property=null,i}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Declaration},enumerable:!1,configurable:!0}),e.prototype.setProperty=function(t){return this.setNode("property",t)},e.prototype.getProperty=function(){return this.property},e.prototype.getFullPropertyName=function(){var t=this.property?this.property.getName():"unknown";if(this.parent instanceof Et&&this.parent.getParent()instanceof Yn){var r=this.parent.getParent().getParent();if(r instanceof e)return r.getFullPropertyName()+t}return t},e.prototype.getNonPrefixedPropertyName=function(){var t=this.getFullPropertyName();if(t&&t.charAt(0)==="-"){var r=t.indexOf("-",1);if(r!==-1)return t.substring(r+1)}return t},e.prototype.setValue=function(t){return this.setNode("value",t)},e.prototype.getValue=function(){return this.value},e.prototype.setNestedProperties=function(t){return this.setNode("nestedProperties",t)},e.prototype.getNestedProperties=function(){return this.nestedProperties},e}(an);var hi=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.CustomPropertyDeclaration},enumerable:!1,configurable:!0}),e.prototype.setPropertySet=function(t){return this.setNode("propertySet",t)},e.prototype.getPropertySet=function(){return this.propertySet},e}(ae);var dt=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Property},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(t){return this.setNode("identifier",t)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return si(this.getText(),/[_\+]+$/)},e.prototype.isCustomProperty=function(){return!!this.identifier&&this.identifier.isCustomProperty},e}(F);var Ns=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Invocation},enumerable:!1,configurable:!0}),e.prototype.getArguments=function(){return this.arguments||(this.arguments=new ee(this)),this.arguments},e}(F);var Pe=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Function},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(t){return this.setNode("identifier",t,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e}(Ns);var Be=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.FunctionParameter},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(t){return this.setNode("identifier",t,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e.prototype.setDefaultValue=function(t){return this.setNode("defaultValue",t,0)},e.prototype.getDefaultValue=function(){return this.defaultValue},e}(F);var we=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.FunctionArgument},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(t){return this.setNode("identifier",t,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e.prototype.setValue=function(t){return this.setNode("value",t,0)},e.prototype.getValue=function(){return this.value},e}(F);var pi=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.If},enumerable:!1,configurable:!0}),e.prototype.setExpression=function(t){return this.setNode("expression",t,0)},e.prototype.setElseClause=function(t){return this.setNode("elseClause",t)},e}(K);var ui=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.For},enumerable:!1,configurable:!0}),e.prototype.setVariable=function(t){return this.setNode("variable",t,0)},e}(K);var mi=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Each},enumerable:!1,configurable:!0}),e.prototype.getVariables=function(){return this.variables||(this.variables=new ee(this)),this.variables},e}(K);var fi=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.While},enumerable:!1,configurable:!0}),e}(K);var gi=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Else},enumerable:!1,configurable:!0}),e}(K);var Qe=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.FunctionDeclaration},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(t){return this.setNode("identifier",t,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e.prototype.getParameters=function(){return this.parameters||(this.parameters=new ee(this)),this.parameters},e}(K);var bi=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.ViewPort},enumerable:!1,configurable:!0}),e}(K);var ln=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.FontFace},enumerable:!1,configurable:!0}),e}(K);var Yn=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.NestedProperties},enumerable:!1,configurable:!0}),e}(K);var cn=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Keyframe},enumerable:!1,configurable:!0}),e.prototype.setKeyword=function(t){return this.setNode("keyword",t,0)},e.prototype.getKeyword=function(){return this.keyword},e.prototype.setIdentifier=function(t){return this.setNode("identifier",t,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e}(K);var Qn=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.KeyframeSelector},enumerable:!1,configurable:!0}),e}(K);var ht=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Import},enumerable:!1,configurable:!0}),e.prototype.setMedialist=function(t){return t?(t.attachTo(this),!0):!1},e}(F);var vi=function(n){E(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Use},enumerable:!1,configurable:!0}),e.prototype.getParameters=function(){return this.parameters||(this.parameters=new ee(this)),this.parameters},e.prototype.setIdentifier=function(t){return this.setNode("identifier",t,0)},e.prototype.getIdentifier=function(){return this.identifier},e}(F);var yi=function(n){E(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.ModuleConfiguration},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(t){return this.setNode("identifier",t,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e.prototype.setValue=function(t){return this.setNode("value",t,0)},e.prototype.getValue=function(){return this.value},e}(F);var wi=function(n){E(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Forward},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(t){return this.setNode("identifier",t,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getMembers=function(){return this.members||(this.members=new ee(this)),this.members},e.prototype.getParameters=function(){return this.parameters||(this.parameters=new ee(this)),this.parameters},e}(F);var xi=function(n){E(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.ForwardVisibility},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(t){return this.setNode("identifier",t,0)},e.prototype.getIdentifier=function(){return this.identifier},e}(F);var Si=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Namespace},enumerable:!1,configurable:!0}),e}(F);var dn=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Media},enumerable:!1,configurable:!0}),e}(K);var Dt=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Supports},enumerable:!1,configurable:!0}),e}(K);var ki=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Document},enumerable:!1,configurable:!0}),e}(K);var hn=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return e.prototype.getMediums=function(){return this.mediums||(this.mediums=new ee(this)),this.mediums},e}(F);var pn=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.MediaQuery},enumerable:!1,configurable:!0}),e}(F);var Ci=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.MediaCondition},enumerable:!1,configurable:!0}),e}(F);var _i=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.MediaFeature},enumerable:!1,configurable:!0}),e}(F);var Ze=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.SupportsCondition},enumerable:!1,configurable:!0}),e}(F);var Fi=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Page},enumerable:!1,configurable:!0}),e}(K);var Ei=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.PageBoxMarginBox},enumerable:!1,configurable:!0}),e}(K);var un=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Expression},enumerable:!1,configurable:!0}),e}(F);var pt=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.BinaryExpression},enumerable:!1,configurable:!0}),e.prototype.setLeft=function(t){return this.setNode("left",t)},e.prototype.getLeft=function(){return this.left},e.prototype.setRight=function(t){return this.setNode("right",t)},e.prototype.getRight=function(){return this.right},e.prototype.setOperator=function(t){return this.setNode("operator",t)},e.prototype.getOperator=function(){return this.operator},e}(F);var Di=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Term},enumerable:!1,configurable:!0}),e.prototype.setOperator=function(t){return this.setNode("operator",t)},e.prototype.getOperator=function(){return this.operator},e.prototype.setExpression=function(t){return this.setNode("expression",t)},e.prototype.getExpression=function(){return this.expression},e}(F);var zi=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.AttributeSelector},enumerable:!1,configurable:!0}),e.prototype.setNamespacePrefix=function(t){return this.setNode("namespacePrefix",t)},e.prototype.getNamespacePrefix=function(){return this.namespacePrefix},e.prototype.setIdentifier=function(t){return this.setNode("identifier",t)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.setOperator=function(t){return this.setNode("operator",t)},e.prototype.getOperator=function(){return this.operator},e.prototype.setValue=function(t){return this.setNode("value",t)},e.prototype.getValue=function(){return this.value},e}(F);var hl=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Operator},enumerable:!1,configurable:!0}),e}(F);var zt=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.HexColorValue},enumerable:!1,configurable:!0}),e}(F);var Ri=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.RatioValue},enumerable:!1,configurable:!0}),e}(F);var Os=".".charCodeAt(0),Ws="0".charCodeAt(0),Ls="9".charCodeAt(0),Rt=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.NumericValue},enumerable:!1,configurable:!0}),e.prototype.getValue=function(){for(var t=this.getText(),r=0,i,o=0,s=t.length;o<s&&(i=t.charCodeAt(o),Ws<=i&&i<=Ls||i===Os);o++)r+=1;return{value:t.substring(0,r),unit:r<t.length?t.substring(r):void 0}},e}(F);var $e=function(n){E(e,n);function e(t,r){var i=n.call(this,t,r)||this;return i.variable=null,i.value=null,i.needsSemicolon=!0,i}return Object.defineProperty(e.prototype,"type",{get:function(){return u.VariableDeclaration},enumerable:!1,configurable:!0}),e.prototype.setVariable=function(t){return t?(t.attachTo(this),this.variable=t,!0):!1},e.prototype.getVariable=function(){return this.variable},e.prototype.getName=function(){return this.variable?this.variable.getName():""},e.prototype.setValue=function(t){return t?(t.attachTo(this),this.value=t,!0):!1},e.prototype.getValue=function(){return this.value},e}(an);var It=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Interpolation},enumerable:!1,configurable:!0}),e}(F);var ut=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.VariableName},enumerable:!1,configurable:!0}),e.prototype.getName=function(){return this.getText()},e}(F);var qe=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.ExtendsReference},enumerable:!1,configurable:!0}),e.prototype.getSelectors=function(){return this.selectors||(this.selectors=new ee(this)),this.selectors},e}(F);var Ii=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.MixinContentReference},enumerable:!1,configurable:!0}),e.prototype.getArguments=function(){return this.arguments||(this.arguments=new ee(this)),this.arguments},e}(F);var Mi=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.MixinContentReference},enumerable:!1,configurable:!0}),e.prototype.getParameters=function(){return this.parameters||(this.parameters=new ee(this)),this.parameters},e}(K);var et=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.MixinReference},enumerable:!1,configurable:!0}),e.prototype.getNamespaces=function(){return this.namespaces||(this.namespaces=new ee(this)),this.namespaces},e.prototype.setIdentifier=function(t){return this.setNode("identifier",t,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e.prototype.getArguments=function(){return this.arguments||(this.arguments=new ee(this)),this.arguments},e.prototype.setContent=function(t){return this.setNode("content",t)},e.prototype.getContent=function(){return this.content},e}(F);var Ae=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.MixinDeclaration},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(t){return this.setNode("identifier",t,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e.prototype.getParameters=function(){return this.parameters||(this.parameters=new ee(this)),this.parameters},e.prototype.setGuard=function(t){return t&&(t.attachTo(this),this.guard=t),!1},e}(K);var mn=function(n){E(e,n);function e(t,r){return n.call(this,t,r)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.UnknownAtRule},enumerable:!1,configurable:!0}),e.prototype.setAtRuleName=function(t){this.atRuleName=t},e.prototype.getAtRuleName=function(){return this.atRuleName},e}(K);var Ti=function(n){E(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.ListEntry},enumerable:!1,configurable:!0}),e.prototype.setKey=function(t){return this.setNode("key",t,0)},e.prototype.setValue=function(t){return this.setNode("value",t,1)},e}(F);var Pi=function(n){E(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return e.prototype.getConditions=function(){return this.conditions||(this.conditions=new ee(this)),this.conditions},e}(F);var Ai=function(n){E(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return e.prototype.setVariable=function(t){return this.setNode("variable",t)},e}(F);var Zn=function(n){E(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return Object.defineProperty(e.prototype,"type",{get:function(){return u.Module},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(t){return this.setNode("identifier",t,0)},e.prototype.getIdentifier=function(){return this.identifier},e}(F);var ne;(function(n){n[n.Ignore=1]="Ignore",n[n.Warning=2]="Warning",n[n.Error=4]="Error"})(ne||(ne={}));var fn=function(){function n(e,t,r,i,o,s){o===void 0&&(o=e.offset),s===void 0&&(s=e.length),this.node=e,this.rule=t,this.level=r,this.message=i||t.message,this.offset=o,this.length=s}return n.prototype.getRule=function(){return this.rule},n.prototype.getLevel=function(){return this.level},n.prototype.getOffset=function(){return this.offset},n.prototype.getLength=function(){return this.length},n.prototype.getNode=function(){return this.node},n.prototype.getMessage=function(){return this.message},n}();var Ni=function(){function n(){this.entries=[]}return n.entries=function(e){var t=new n;return e.acceptVisitor(t),t.entries},n.prototype.visitNode=function(e){return e.isErroneous()&&e.collectIssues(this.entries),!0},n}();function Us(n,e){let t;return e.length===0?t=n:t=n.replace(/\{(\d+)\}/g,(r,i)=>{let o=i[0];return typeof e[o]<"u"?e[o]:r}),t}function js(n,e,...t){return Us(e,t)}function H(n){return js}var U=H(),j=function(){function n(e,t){this.id=e,this.message=t}return n}();var f={NumberExpected:new j("css-numberexpected",U("expected.number","number expected")),ConditionExpected:new j("css-conditionexpected",U("expected.condt","condition expected")),RuleOrSelectorExpected:new j("css-ruleorselectorexpected",U("expected.ruleorselector","at-rule or selector expected")),DotExpected:new j("css-dotexpected",U("expected.dot","dot expected")),ColonExpected:new j("css-colonexpected",U("expected.colon","colon expected")),SemiColonExpected:new j("css-semicolonexpected",U("expected.semicolon","semi-colon expected")),TermExpected:new j("css-termexpected",U("expected.term","term expected")),ExpressionExpected:new j("css-expressionexpected",U("expected.expression","expression expected")),OperatorExpected:new j("css-operatorexpected",U("expected.operator","operator expected")),IdentifierExpected:new j("css-identifierexpected",U("expected.ident","identifier expected")),PercentageExpected:new j("css-percentageexpected",U("expected.percentage","percentage expected")),URIOrStringExpected:new j("css-uriorstringexpected",U("expected.uriorstring","uri or string expected")),URIExpected:new j("css-uriexpected",U("expected.uri","URI expected")),VariableNameExpected:new j("css-varnameexpected",U("expected.varname","variable name expected")),VariableValueExpected:new j("css-varvalueexpected",U("expected.varvalue","variable value expected")),PropertyValueExpected:new j("css-propertyvalueexpected",U("expected.propvalue","property value expected")),LeftCurlyExpected:new j("css-lcurlyexpected",U("expected.lcurly","{ expected")),RightCurlyExpected:new j("css-rcurlyexpected",U("expected.rcurly","} expected")),LeftSquareBracketExpected:new j("css-rbracketexpected",U("expected.lsquare","[ expected")),RightSquareBracketExpected:new j("css-lbracketexpected",U("expected.rsquare","] expected")),LeftParenthesisExpected:new j("css-lparentexpected",U("expected.lparen","( expected")),RightParenthesisExpected:new j("css-rparentexpected",U("expected.rparent",") expected")),CommaExpected:new j("css-commaexpected",U("expected.comma","comma expected")),PageDirectiveOrDeclarationExpected:new j("css-pagedirordeclexpected",U("expected.pagedirordecl","page directive or declaraton expected")),UnknownAtRule:new j("css-unknownatrule",U("unknown.atrule","at-rule unknown")),UnknownKeyword:new j("css-unknownkeyword",U("unknown.keyword","unknown keyword")),SelectorExpected:new j("css-selectorexpected",U("expected.selector","selector expected")),StringLiteralExpected:new j("css-stringliteralexpected",U("expected.stringliteral","string literal expected")),WhitespaceExpected:new j("css-whitespaceexpected",U("expected.whitespace","whitespace expected")),MediaQueryExpected:new j("css-mediaqueryexpected",U("expected.mediaquery","media query expected")),IdentifierOrWildcardExpected:new j("css-idorwildcardexpected",U("expected.idorwildcard","identifier or wildcard expected")),WildcardExpected:new j("css-wildcardexpected",U("expected.wildcard","wildcard expected")),IdentifierOrVariableExpected:new j("css-idorvarexpected",U("expected.idorvar","identifier or variable expected"))};var Oi;(function(n){n.MIN_VALUE=-2147483648,n.MAX_VALUE=2147483647})(Oi||(Oi={}));var bn;(function(n){n.MIN_VALUE=0,n.MAX_VALUE=2147483647})(bn||(bn={}));var Q;(function(n){function e(r,i){return r===Number.MAX_VALUE&&(r=bn.MAX_VALUE),i===Number.MAX_VALUE&&(i=bn.MAX_VALUE),{line:r,character:i}}n.create=e;function t(r){var i=r;return v.objectLiteral(i)&&v.uinteger(i.line)&&v.uinteger(i.character)}n.is=t})(Q||(Q={}));var W;(function(n){function e(r,i,o,s){if(v.uinteger(r)&&v.uinteger(i)&&v.uinteger(o)&&v.uinteger(s))return{start:Q.create(r,i),end:Q.create(o,s)};if(Q.is(r)&&Q.is(i))return{start:r,end:i};throw new Error("Range#create called with invalid arguments["+r+", "+i+", "+o+", "+s+"]")}n.create=e;function t(r){var i=r;return v.objectLiteral(i)&&Q.is(i.start)&&Q.is(i.end)}n.is=t})(W||(W={}));var tt;(function(n){function e(r,i){return{uri:r,range:i}}n.create=e;function t(r){var i=r;return v.defined(i)&&W.is(i.range)&&(v.string(i.uri)||v.undefined(i.uri))}n.is=t})(tt||(tt={}));var Wi;(function(n){function e(r,i,o,s){return{targetUri:r,targetRange:i,targetSelectionRange:o,originSelectionRange:s}}n.create=e;function t(r){var i=r;return v.defined(i)&&W.is(i.targetRange)&&v.string(i.targetUri)&&(W.is(i.targetSelectionRange)||v.undefined(i.targetSelectionRange))&&(W.is(i.originSelectionRange)||v.undefined(i.originSelectionRange))}n.is=t})(Wi||(Wi={}));var vn;(function(n){function e(r,i,o,s){return{red:r,green:i,blue:o,alpha:s}}n.create=e;function t(r){var i=r;return v.numberRange(i.red,0,1)&&v.numberRange(i.green,0,1)&&v.numberRange(i.blue,0,1)&&v.numberRange(i.alpha,0,1)}n.is=t})(vn||(vn={}));var er;(function(n){function e(r,i){return{range:r,color:i}}n.create=e;function t(r){var i=r;return W.is(i.range)&&vn.is(i.color)}n.is=t})(er||(er={}));var tr;(function(n){function e(r,i,o){return{label:r,textEdit:i,additionalTextEdits:o}}n.create=e;function t(r){var i=r;return v.string(i.label)&&(v.undefined(i.textEdit)||T.is(i))&&(v.undefined(i.additionalTextEdits)||v.typedArray(i.additionalTextEdits,T.is))}n.is=t})(tr||(tr={}));var nr;(function(n){n.Comment="comment",n.Imports="imports",n.Region="region"})(nr||(nr={}));var rr;(function(n){function e(r,i,o,s,a){var l={startLine:r,endLine:i};return v.defined(o)&&(l.startCharacter=o),v.defined(s)&&(l.endCharacter=s),v.defined(a)&&(l.kind=a),l}n.create=e;function t(r){var i=r;return v.uinteger(i.startLine)&&v.uinteger(i.startLine)&&(v.undefined(i.startCharacter)||v.uinteger(i.startCharacter))&&(v.undefined(i.endCharacter)||v.uinteger(i.endCharacter))&&(v.undefined(i.kind)||v.string(i.kind))}n.is=t})(rr||(rr={}));var ir;(function(n){function e(r,i){return{location:r,message:i}}n.create=e;function t(r){var i=r;return v.defined(i)&&tt.is(i.location)&&v.string(i.message)}n.is=t})(ir||(ir={}));var ft;(function(n){n.Error=1,n.Warning=2,n.Information=3,n.Hint=4})(ft||(ft={}));var Li;(function(n){n.Unnecessary=1,n.Deprecated=2})(Li||(Li={}));var Ui;(function(n){function e(t){var r=t;return r!=null&&v.string(r.href)}n.is=e})(Ui||(Ui={}));var Mt;(function(n){function e(r,i,o,s,a,l){var c={range:r,message:i};return v.defined(o)&&(c.severity=o),v.defined(s)&&(c.code=s),v.defined(a)&&(c.source=a),v.defined(l)&&(c.relatedInformation=l),c}n.create=e;function t(r){var i,o=r;return v.defined(o)&&W.is(o.range)&&v.string(o.message)&&(v.number(o.severity)||v.undefined(o.severity))&&(v.integer(o.code)||v.string(o.code)||v.undefined(o.code))&&(v.undefined(o.codeDescription)||v.string((i=o.codeDescription)===null||i===void 0?void 0:i.href))&&(v.string(o.source)||v.undefined(o.source))&&(v.undefined(o.relatedInformation)||v.typedArray(o.relatedInformation,ir.is))}n.is=t})(Mt||(Mt={}));var Ge;(function(n){function e(r,i){for(var o=[],s=2;s<arguments.length;s++)o[s-2]=arguments[s];var a={title:r,command:i};return v.defined(o)&&o.length>0&&(a.arguments=o),a}n.create=e;function t(r){var i=r;return v.defined(i)&&v.string(i.title)&&v.string(i.command)}n.is=t})(Ge||(Ge={}));var T;(function(n){function e(o,s){return{range:o,newText:s}}n.replace=e;function t(o,s){return{range:{start:o,end:o},newText:s}}n.insert=t;function r(o){return{range:o,newText:""}}n.del=r;function i(o){var s=o;return v.objectLiteral(s)&&v.string(s.newText)&&W.is(s.range)}n.is=i})(T||(T={}));var mt;(function(n){function e(r,i,o){var s={label:r};return i!==void 0&&(s.needsConfirmation=i),o!==void 0&&(s.description=o),s}n.create=e;function t(r){var i=r;return i!==void 0&&v.objectLiteral(i)&&v.string(i.label)&&(v.boolean(i.needsConfirmation)||i.needsConfirmation===void 0)&&(v.string(i.description)||i.description===void 0)}n.is=t})(mt||(mt={}));var le;(function(n){function e(t){var r=t;return typeof r=="string"}n.is=e})(le||(le={}));var Ke;(function(n){function e(o,s,a){return{range:o,newText:s,annotationId:a}}n.replace=e;function t(o,s,a){return{range:{start:o,end:o},newText:s,annotationId:a}}n.insert=t;function r(o,s){return{range:o,newText:"",annotationId:s}}n.del=r;function i(o){var s=o;return T.is(s)&&(mt.is(s.annotationId)||le.is(s.annotationId))}n.is=i})(Ke||(Ke={}));var nt;(function(n){function e(r,i){return{textDocument:r,edits:i}}n.create=e;function t(r){var i=r;return v.defined(i)&&wn.is(i.textDocument)&&Array.isArray(i.edits)}n.is=t})(nt||(nt={}));var Tt;(function(n){function e(r,i,o){var s={kind:"create",uri:r};return i!==void 0&&(i.overwrite!==void 0||i.ignoreIfExists!==void 0)&&(s.options=i),o!==void 0&&(s.annotationId=o),s}n.create=e;function t(r){var i=r;return i&&i.kind==="create"&&v.string(i.uri)&&(i.options===void 0||(i.options.overwrite===void 0||v.boolean(i.options.overwrite))&&(i.options.ignoreIfExists===void 0||v.boolean(i.options.ignoreIfExists)))&&(i.annotationId===void 0||le.is(i.annotationId))}n.is=t})(Tt||(Tt={}));var Pt;(function(n){function e(r,i,o,s){var a={kind:"rename",oldUri:r,newUri:i};return o!==void 0&&(o.overwrite!==void 0||o.ignoreIfExists!==void 0)&&(a.options=o),s!==void 0&&(a.annotationId=s),a}n.create=e;function t(r){var i=r;return i&&i.kind==="rename"&&v.string(i.oldUri)&&v.string(i.newUri)&&(i.options===void 0||(i.options.overwrite===void 0||v.boolean(i.options.overwrite))&&(i.options.ignoreIfExists===void 0||v.boolean(i.options.ignoreIfExists)))&&(i.annotationId===void 0||le.is(i.annotationId))}n.is=t})(Pt||(Pt={}));var At;(function(n){function e(r,i,o){var s={kind:"delete",uri:r};return i!==void 0&&(i.recursive!==void 0||i.ignoreIfNotExists!==void 0)&&(s.options=i),o!==void 0&&(s.annotationId=o),s}n.create=e;function t(r){var i=r;return i&&i.kind==="delete"&&v.string(i.uri)&&(i.options===void 0||(i.options.recursive===void 0||v.boolean(i.options.recursive))&&(i.options.ignoreIfNotExists===void 0||v.boolean(i.options.ignoreIfNotExists)))&&(i.annotationId===void 0||le.is(i.annotationId))}n.is=t})(At||(At={}));var yn;(function(n){function e(t){var r=t;return r&&(r.changes!==void 0||r.documentChanges!==void 0)&&(r.documentChanges===void 0||r.documentChanges.every(function(i){return v.string(i.kind)?Tt.is(i)||Pt.is(i)||At.is(i):nt.is(i)}))}n.is=e})(yn||(yn={}));var gn=function(){function n(e,t){this.edits=e,this.changeAnnotations=t}return n.prototype.insert=function(e,t,r){var i,o;if(r===void 0?i=T.insert(e,t):le.is(r)?(o=r,i=Ke.insert(e,t,r)):(this.assertChangeAnnotations(this.changeAnnotations),o=this.changeAnnotations.manage(r),i=Ke.insert(e,t,o)),this.edits.push(i),o!==void 0)return o},n.prototype.replace=function(e,t,r){var i,o;if(r===void 0?i=T.replace(e,t):le.is(r)?(o=r,i=Ke.replace(e,t,r)):(this.assertChangeAnnotations(this.changeAnnotations),o=this.changeAnnotations.manage(r),i=Ke.replace(e,t,o)),this.edits.push(i),o!==void 0)return o},n.prototype.delete=function(e,t){var r,i;if(t===void 0?r=T.del(e):le.is(t)?(i=t,r=Ke.del(e,t)):(this.assertChangeAnnotations(this.changeAnnotations),i=this.changeAnnotations.manage(t),r=Ke.del(e,i)),this.edits.push(r),i!==void 0)return i},n.prototype.add=function(e){this.edits.push(e)},n.prototype.all=function(){return this.edits},n.prototype.clear=function(){this.edits.splice(0,this.edits.length)},n.prototype.assertChangeAnnotations=function(e){if(e===void 0)throw new Error("Text edit change is not configured to manage change annotations.")},n}(),ji=function(){function n(e){this._annotations=e===void 0?Object.create(null):e,this._counter=0,this._size=0}return n.prototype.all=function(){return this._annotations},Object.defineProperty(n.prototype,"size",{get:function(){return this._size},enumerable:!1,configurable:!0}),n.prototype.manage=function(e,t){var r;if(le.is(e)?r=e:(r=this.nextId(),t=e),this._annotations[r]!==void 0)throw new Error("Id "+r+" is already in use.");if(t===void 0)throw new Error("No annotation provided for id "+r);return this._annotations[r]=t,this._size++,r},n.prototype.nextId=function(){return this._counter++,this._counter.toString()},n}(),ul=function(){function n(e){var t=this;this._textEditChanges=Object.create(null),e!==void 0?(this._workspaceEdit=e,e.documentChanges?(this._changeAnnotations=new ji(e.changeAnnotations),e.changeAnnotations=this._changeAnnotations.all(),e.documentChanges.forEach(function(r){if(nt.is(r)){var i=new gn(r.edits,t._changeAnnotations);t._textEditChanges[r.textDocument.uri]=i}})):e.changes&&Object.keys(e.changes).forEach(function(r){var i=new gn(e.changes[r]);t._textEditChanges[r]=i})):this._workspaceEdit={}}return Object.defineProperty(n.prototype,"edit",{get:function(){return this.initDocumentChanges(),this._changeAnnotations!==void 0&&(this._changeAnnotations.size===0?this._workspaceEdit.changeAnnotations=void 0:this._workspaceEdit.changeAnnotations=this._changeAnnotations.all()),this._workspaceEdit},enumerable:!1,configurable:!0}),n.prototype.getTextEditChange=function(e){if(wn.is(e)){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var t={uri:e.uri,version:e.version},r=this._textEditChanges[t.uri];if(!r){var i=[],o={textDocument:t,edits:i};this._workspaceEdit.documentChanges.push(o),r=new gn(i,this._changeAnnotations),this._textEditChanges[t.uri]=r}return r}else{if(this.initChanges(),this._workspaceEdit.changes===void 0)throw new Error("Workspace edit is not configured for normal text edit changes.");var r=this._textEditChanges[e];if(!r){var i=[];this._workspaceEdit.changes[e]=i,r=new gn(i),this._textEditChanges[e]=r}return r}},n.prototype.initDocumentChanges=function(){this._workspaceEdit.documentChanges===void 0&&this._workspaceEdit.changes===void 0&&(this._changeAnnotations=new ji,this._workspaceEdit.documentChanges=[],this._workspaceEdit.changeAnnotations=this._changeAnnotations.all())},n.prototype.initChanges=function(){this._workspaceEdit.documentChanges===void 0&&this._workspaceEdit.changes===void 0&&(this._workspaceEdit.changes=Object.create(null))},n.prototype.createFile=function(e,t,r){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var i;mt.is(t)||le.is(t)?i=t:r=t;var o,s;if(i===void 0?o=Tt.create(e,r):(s=le.is(i)?i:this._changeAnnotations.manage(i),o=Tt.create(e,r,s)),this._workspaceEdit.documentChanges.push(o),s!==void 0)return s},n.prototype.renameFile=function(e,t,r,i){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var o;mt.is(r)||le.is(r)?o=r:i=r;var s,a;if(o===void 0?s=Pt.create(e,t,i):(a=le.is(o)?o:this._changeAnnotations.manage(o),s=Pt.create(e,t,i,a)),this._workspaceEdit.documentChanges.push(s),a!==void 0)return a},n.prototype.deleteFile=function(e,t,r){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var i;mt.is(t)||le.is(t)?i=t:r=t;var o,s;if(i===void 0?o=At.create(e,r):(s=le.is(i)?i:this._changeAnnotations.manage(i),o=At.create(e,r,s)),this._workspaceEdit.documentChanges.push(o),s!==void 0)return s},n}();var Vi;(function(n){function e(r){return{uri:r}}n.create=e;function t(r){var i=r;return v.defined(i)&&v.string(i.uri)}n.is=t})(Vi||(Vi={}));var Nt;(function(n){function e(r,i){return{uri:r,version:i}}n.create=e;function t(r){var i=r;return v.defined(i)&&v.string(i.uri)&&v.integer(i.version)}n.is=t})(Nt||(Nt={}));var wn;(function(n){function e(r,i){return{uri:r,version:i}}n.create=e;function t(r){var i=r;return v.defined(i)&&v.string(i.uri)&&(i.version===null||v.integer(i.version))}n.is=t})(wn||(wn={}));var Bi;(function(n){function e(r,i,o,s){return{uri:r,languageId:i,version:o,text:s}}n.create=e;function t(r){var i=r;return v.defined(i)&&v.string(i.uri)&&v.string(i.languageId)&&v.integer(i.version)&&v.string(i.text)}n.is=t})(Bi||(Bi={}));var ce;(function(n){n.PlainText="plaintext",n.Markdown="markdown"})(ce||(ce={}));(function(n){function e(t){var r=t;return r===n.PlainText||r===n.Markdown}n.is=e})(ce||(ce={}));var xn;(function(n){function e(t){var r=t;return v.objectLiteral(t)&&ce.is(r.kind)&&v.string(r.value)}n.is=e})(xn||(xn={}));var R;(function(n){n.Text=1,n.Method=2,n.Function=3,n.Constructor=4,n.Field=5,n.Variable=6,n.Class=7,n.Interface=8,n.Module=9,n.Property=10,n.Unit=11,n.Value=12,n.Enum=13,n.Keyword=14,n.Snippet=15,n.Color=16,n.File=17,n.Reference=18,n.Folder=19,n.EnumMember=20,n.Constant=21,n.Struct=22,n.Event=23,n.Operator=24,n.TypeParameter=25})(R||(R={}));var re;(function(n){n.PlainText=1,n.Snippet=2})(re||(re={}));var Ne;(function(n){n.Deprecated=1})(Ne||(Ne={}));var $i;(function(n){function e(r,i,o){return{newText:r,insert:i,replace:o}}n.create=e;function t(r){var i=r;return i&&v.string(i.newText)&&W.is(i.insert)&&W.is(i.replace)}n.is=t})($i||($i={}));var qi;(function(n){n.asIs=1,n.adjustIndentation=2})(qi||(qi={}));var or;(function(n){function e(t){return{label:t}}n.create=e})(or||(or={}));var sr;(function(n){function e(t,r){return{items:t||[],isIncomplete:!!r}}n.create=e})(sr||(sr={}));var Ot;(function(n){function e(r){return r.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")}n.fromPlainText=e;function t(r){var i=r;return v.string(i)||v.objectLiteral(i)&&v.string(i.language)&&v.string(i.value)}n.is=t})(Ot||(Ot={}));var ar;(function(n){function e(t){var r=t;return!!r&&v.objectLiteral(r)&&(xn.is(r.contents)||Ot.is(r.contents)||v.typedArray(r.contents,Ot.is))&&(t.range===void 0||W.is(t.range))}n.is=e})(ar||(ar={}));var Ki;(function(n){function e(t,r){return r?{label:t,documentation:r}:{label:t}}n.create=e})(Ki||(Ki={}));var Gi;(function(n){function e(t,r){for(var i=[],o=2;o<arguments.length;o++)i[o-2]=arguments[o];var s={label:t};return v.defined(r)&&(s.documentation=r),v.defined(i)?s.parameters=i:s.parameters=[],s}n.create=e})(Gi||(Gi={}));var He;(function(n){n.Text=1,n.Read=2,n.Write=3})(He||(He={}));var lr;(function(n){function e(t,r){var i={range:t};return v.number(r)&&(i.kind=r),i}n.create=e})(lr||(lr={}));var Oe;(function(n){n.File=1,n.Module=2,n.Namespace=3,n.Package=4,n.Class=5,n.Method=6,n.Property=7,n.Field=8,n.Constructor=9,n.Enum=10,n.Interface=11,n.Function=12,n.Variable=13,n.Constant=14,n.String=15,n.Number=16,n.Boolean=17,n.Array=18,n.Object=19,n.Key=20,n.Null=21,n.EnumMember=22,n.Struct=23,n.Event=24,n.Operator=25,n.TypeParameter=26})(Oe||(Oe={}));var Hi;(function(n){n.Deprecated=1})(Hi||(Hi={}));var cr;(function(n){function e(t,r,i,o,s){var a={name:t,kind:r,location:{uri:o,range:i}};return s&&(a.containerName=s),a}n.create=e})(cr||(cr={}));var dr;(function(n){function e(r,i,o,s,a,l){var c={name:r,detail:i,kind:o,range:s,selectionRange:a};return l!==void 0&&(c.children=l),c}n.create=e;function t(r){var i=r;return i&&v.string(i.name)&&v.number(i.kind)&&W.is(i.range)&&W.is(i.selectionRange)&&(i.detail===void 0||v.string(i.detail))&&(i.deprecated===void 0||v.boolean(i.deprecated))&&(i.children===void 0||Array.isArray(i.children))&&(i.tags===void 0||Array.isArray(i.tags))}n.is=t})(dr||(dr={}));var Wt;(function(n){n.Empty="",n.QuickFix="quickfix",n.Refactor="refactor",n.RefactorExtract="refactor.extract",n.RefactorInline="refactor.inline",n.RefactorRewrite="refactor.rewrite",n.Source="source",n.SourceOrganizeImports="source.organizeImports",n.SourceFixAll="source.fixAll"})(Wt||(Wt={}));var hr;(function(n){function e(r,i){var o={diagnostics:r};return i!=null&&(o.only=i),o}n.create=e;function t(r){var i=r;return v.defined(i)&&v.typedArray(i.diagnostics,Mt.is)&&(i.only===void 0||v.typedArray(i.only,v.string))}n.is=t})(hr||(hr={}));var Lt;(function(n){function e(r,i,o){var s={title:r},a=!0;return typeof i=="string"?(a=!1,s.kind=i):Ge.is(i)?s.command=i:s.edit=i,a&&o!==void 0&&(s.kind=o),s}n.create=e;function t(r){var i=r;return i&&v.string(i.title)&&(i.diagnostics===void 0||v.typedArray(i.diagnostics,Mt.is))&&(i.kind===void 0||v.string(i.kind))&&(i.edit!==void 0||i.command!==void 0)&&(i.command===void 0||Ge.is(i.command))&&(i.isPreferred===void 0||v.boolean(i.isPreferred))&&(i.edit===void 0||yn.is(i.edit))}n.is=t})(Lt||(Lt={}));var Ji;(function(n){function e(r,i){var o={range:r};return v.defined(i)&&(o.data=i),o}n.create=e;function t(r){var i=r;return v.defined(i)&&W.is(i.range)&&(v.undefined(i.command)||Ge.is(i.command))}n.is=t})(Ji||(Ji={}));var Xi;(function(n){function e(r,i){return{tabSize:r,insertSpaces:i}}n.create=e;function t(r){var i=r;return v.defined(i)&&v.uinteger(i.tabSize)&&v.boolean(i.insertSpaces)}n.is=t})(Xi||(Xi={}));var pr;(function(n){function e(r,i,o){return{range:r,target:i,data:o}}n.create=e;function t(r){var i=r;return v.defined(i)&&W.is(i.range)&&(v.undefined(i.target)||v.string(i.target))}n.is=t})(pr||(pr={}));var gt;(function(n){function e(r,i){return{range:r,parent:i}}n.create=e;function t(r){var i=r;return i!==void 0&&W.is(i.range)&&(i.parent===void 0||n.is(i.parent))}n.is=t})(gt||(gt={}));var Yi;(function(n){function e(o,s,a,l){return new Vs(o,s,a,l)}n.create=e;function t(o){var s=o;return!!(v.defined(s)&&v.string(s.uri)&&(v.undefined(s.languageId)||v.string(s.languageId))&&v.uinteger(s.lineCount)&&v.func(s.getText)&&v.func(s.positionAt)&&v.func(s.offsetAt))}n.is=t;function r(o,s){for(var a=o.getText(),l=i(s,function(w,x){var y=w.range.start.line-x.range.start.line;return y===0?w.range.start.character-x.range.start.character:y}),c=a.length,h=l.length-1;h>=0;h--){var p=l[h],m=o.offsetAt(p.range.start),g=o.offsetAt(p.range.end);if(g<=c)a=a.substring(0,m)+p.newText+a.substring(g,a.length);else throw new Error("Overlapping edit");c=m}return a}n.applyEdits=r;function i(o,s){if(o.length<=1)return o;var a=o.length/2|0,l=o.slice(0,a),c=o.slice(a);i(l,s),i(c,s);for(var h=0,p=0,m=0;h<l.length&&p<c.length;){var g=s(l[h],c[p]);g<=0?o[m++]=l[h++]:o[m++]=c[p++]}for(;h<l.length;)o[m++]=l[h++];for(;p<c.length;)o[m++]=c[p++];return o}})(Yi||(Yi={}));var Vs=function(){function n(e,t,r,i){this._uri=e,this._languageId=t,this._version=r,this._content=i,this._lineOffsets=void 0}return Object.defineProperty(n.prototype,"uri",{get:function(){return this._uri},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"languageId",{get:function(){return this._languageId},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"version",{get:function(){return this._version},enumerable:!1,configurable:!0}),n.prototype.getText=function(e){if(e){var t=this.offsetAt(e.start),r=this.offsetAt(e.end);return this._content.substring(t,r)}return this._content},n.prototype.update=function(e,t){this._content=e.text,this._version=t,this._lineOffsets=void 0},n.prototype.getLineOffsets=function(){if(this._lineOffsets===void 0){for(var e=[],t=this._content,r=!0,i=0;i<t.length;i++){r&&(e.push(i),r=!1);var o=t.charAt(i);r=o==="\r"||o===`
`,o==="\r"&&i+1<t.length&&t.charAt(i+1)===`
`&&i++}r&&t.length>0&&e.push(t.length),this._lineOffsets=e}return this._lineOffsets},n.prototype.positionAt=function(e){e=Math.max(Math.min(e,this._content.length),0);var t=this.getLineOffsets(),r=0,i=t.length;if(i===0)return Q.create(0,e);for(;r<i;){var o=Math.floor((r+i)/2);t[o]>e?i=o:r=o+1}var s=r-1;return Q.create(s,e-t[s])},n.prototype.offsetAt=function(e){var t=this.getLineOffsets();if(e.line>=t.length)return this._content.length;if(e.line<0)return 0;var r=t[e.line],i=e.line+1<t.length?t[e.line+1]:this._content.length;return Math.max(Math.min(r+e.character,i),r)},Object.defineProperty(n.prototype,"lineCount",{get:function(){return this.getLineOffsets().length},enumerable:!1,configurable:!0}),n}(),v;(function(n){var e=Object.prototype.toString;function t(g){return typeof g<"u"}n.defined=t;function r(g){return typeof g>"u"}n.undefined=r;function i(g){return g===!0||g===!1}n.boolean=i;function o(g){return e.call(g)==="[object String]"}n.string=o;function s(g){return e.call(g)==="[object Number]"}n.number=s;function a(g,w,x){return e.call(g)==="[object Number]"&&w<=g&&g<=x}n.numberRange=a;function l(g){return e.call(g)==="[object Number]"&&-2147483648<=g&&g<=2147483647}n.integer=l;function c(g){return e.call(g)==="[object Number]"&&0<=g&&g<=2147483647}n.uinteger=c;function h(g){return e.call(g)==="[object Function]"}n.func=h;function p(g){return g!==null&&typeof g=="object"}n.objectLiteral=p;function m(g,w){return Array.isArray(g)&&g.every(w)}n.typedArray=m})(v||(v={}));var rt=class{constructor(e,t,r,i){this._uri=e,this._languageId=t,this._version=r,this._content=i,this._lineOffsets=void 0}get uri(){return this._uri}get languageId(){return this._languageId}get version(){return this._version}getText(e){if(e){let t=this.offsetAt(e.start),r=this.offsetAt(e.end);return this._content.substring(t,r)}return this._content}update(e,t){for(let r of e)if(rt.isIncremental(r)){let i=Zi(r.range),o=this.offsetAt(i.start),s=this.offsetAt(i.end);this._content=this._content.substring(0,o)+r.text+this._content.substring(s,this._content.length);let a=Math.max(i.start.line,0),l=Math.max(i.end.line,0),c=this._lineOffsets,h=Qi(r.text,!1,o);if(l-a===h.length)for(let m=0,g=h.length;m<g;m++)c[m+a+1]=h[m];else h.length<1e4?c.splice(a+1,l-a,...h):this._lineOffsets=c=c.slice(0,a+1).concat(h,c.slice(l+1));let p=r.text.length-(s-o);if(p!==0)for(let m=a+1+h.length,g=c.length;m<g;m++)c[m]=c[m]+p}else if(rt.isFull(r))this._content=r.text,this._lineOffsets=void 0;else throw new Error("Unknown change event received");this._version=t}getLineOffsets(){return this._lineOffsets===void 0&&(this._lineOffsets=Qi(this._content,!0)),this._lineOffsets}positionAt(e){e=Math.max(Math.min(e,this._content.length),0);let t=this.getLineOffsets(),r=0,i=t.length;if(i===0)return{line:0,character:e};for(;r<i;){let s=Math.floor((r+i)/2);t[s]>e?i=s:r=s+1}let o=r-1;return{line:o,character:e-t[o]}}offsetAt(e){let t=this.getLineOffsets();if(e.line>=t.length)return this._content.length;if(e.line<0)return 0;let r=t[e.line],i=e.line+1<t.length?t[e.line+1]:this._content.length;return Math.max(Math.min(r+e.character,i),r)}get lineCount(){return this.getLineOffsets().length}static isIncremental(e){let t=e;return t!=null&&typeof t.text=="string"&&t.range!==void 0&&(t.rangeLength===void 0||typeof t.rangeLength=="number")}static isFull(e){let t=e;return t!=null&&typeof t.text=="string"&&t.range===void 0&&t.rangeLength===void 0}},Ut;(function(n){function e(i,o,s,a){return new rt(i,o,s,a)}n.create=e;function t(i,o,s){if(i instanceof rt)return i.update(o,s),i;throw new Error("TextDocument.update: document must be created by TextDocument.create")}n.update=t;function r(i,o){let s=i.getText(),a=ur(o.map(Bs),(h,p)=>{let m=h.range.start.line-p.range.start.line;return m===0?h.range.start.character-p.range.start.character:m}),l=0,c=[];for(let h of a){let p=i.offsetAt(h.range.start);if(p<l)throw new Error("Overlapping edit");p>l&&c.push(s.substring(l,p)),h.newText.length&&c.push(h.newText),l=i.offsetAt(h.range.end)}return c.push(s.substr(l)),c.join("")}n.applyEdits=r})(Ut||(Ut={}));function ur(n,e){if(n.length<=1)return n;let t=n.length/2|0,r=n.slice(0,t),i=n.slice(t);ur(r,e),ur(i,e);let o=0,s=0,a=0;for(;o<r.length&&s<i.length;)e(r[o],i[s])<=0?n[a++]=r[o++]:n[a++]=i[s++];for(;o<r.length;)n[a++]=r[o++];for(;s<i.length;)n[a++]=i[s++];return n}function Qi(n,e,t=0){let r=e?[t]:[];for(let i=0;i<n.length;i++){let o=n.charCodeAt(i);(o===13||o===10)&&(o===13&&i+1<n.length&&n.charCodeAt(i+1)===10&&i++,r.push(t+i+1))}return r}function Zi(n){let e=n.start,t=n.end;return e.line>t.line||e.line===t.line&&e.character>t.character?{start:t,end:e}:n}function Bs(n){let e=Zi(n.range);return e!==n.range?{newText:n.newText,range:e}:n}var eo;(function(n){n.LATEST={textDocument:{completion:{completionItem:{documentationFormat:[ce.Markdown,ce.PlainText]}},hover:{contentFormat:[ce.Markdown,ce.PlainText]}}}})(eo||(eo={}));var it;(function(n){n[n.Unknown=0]="Unknown",n[n.File=1]="File",n[n.Directory=2]="Directory",n[n.SymbolicLink=64]="SymbolicLink"})(it||(it={}));var to={E:"Edge",FF:"Firefox",S:"Safari",C:"Chrome",IE:"IE",O:"Opera"};function no(n){switch(n){case"experimental":return`\u26A0\uFE0F Property is experimental. Be cautious when using it.\uFE0F

`;case"nonstandard":return`\u{1F6A8}\uFE0F Property is nonstandard. Avoid using it.

`;case"obsolete":return`\u{1F6A8}\uFE0F\uFE0F\uFE0F Property is obsolete. Avoid using it.

`;default:return""}}function ze(n,e,t){var r;if(e?r={kind:"markdown",value:qs(n,t)}:r={kind:"plaintext",value:$s(n,t)},r.value!=="")return r}function Sn(n){return n=n.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&"),n.replace(/</g,"&lt;").replace(/>/g,"&gt;")}function $s(n,e){if(!n.description||n.description==="")return"";if(typeof n.description!="string")return n.description.value;var t="";if(e?.documentation!==!1){n.status&&(t+=no(n.status)),t+=n.description;var r=ro(n.browsers);r&&(t+=`
(`+r+")"),"syntax"in n&&(t+=`

Syntax: `.concat(n.syntax))}return n.references&&n.references.length>0&&e?.references!==!1&&(t.length>0&&(t+=`

`),t+=n.references.map(function(i){return"".concat(i.name,": ").concat(i.url)}).join(" | ")),t}function qs(n,e){if(!n.description||n.description==="")return"";var t="";if(e?.documentation!==!1){n.status&&(t+=no(n.status)),typeof n.description=="string"?t+=Sn(n.description):t+=n.description.kind===ce.Markdown?n.description.value:Sn(n.description.value);var r=ro(n.browsers);r&&(t+=`

(`+Sn(r)+")"),"syntax"in n&&n.syntax&&(t+=`

Syntax: `.concat(Sn(n.syntax)))}return n.references&&n.references.length>0&&e?.references!==!1&&(t.length>0&&(t+=`

`),t+=n.references.map(function(i){return"[".concat(i.name,"](").concat(i.url,")")}).join(" | ")),t}function ro(n){return n===void 0&&(n=[]),n.length===0?null:n.map(function(e){var t="",r=e.match(/([A-Z]+)(\d+)?/),i=r[1],o=r[2];return i in to&&(t+=to[i]),o&&(t+=" "+o),t}).join(", ")}var jt=H(),ao=[{func:"rgb($red, $green, $blue)",desc:jt("css.builtin.rgb","Creates a Color from red, green, and blue values.")},{func:"rgba($red, $green, $blue, $alpha)",desc:jt("css.builtin.rgba","Creates a Color from red, green, blue, and alpha values.")},{func:"hsl($hue, $saturation, $lightness)",desc:jt("css.builtin.hsl","Creates a Color from hue, saturation, and lightness values.")},{func:"hsla($hue, $saturation, $lightness, $alpha)",desc:jt("css.builtin.hsla","Creates a Color from hue, saturation, lightness, and alpha values.")},{func:"hwb($hue $white $black)",desc:jt("css.builtin.hwb","Creates a Color from hue, white and black.")}],Vt={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgrey:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",grey:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rebeccapurple:"#663399",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"},mr={currentColor:"The value of the 'color' property. The computed value of the 'currentColor' keyword is the computed value of the 'color' property. If the 'currentColor' keyword is set on the 'color' property itself, it is treated as 'color:inherit' at parse time.",transparent:"Fully transparent. This keyword can be considered a shorthand for rgba(0,0,0,0) which is its computed value."};function Je(n,e){var t=n.getText(),r=t.match(/^([-+]?[0-9]*\.?[0-9]+)(%?)$/);if(r){r[2]&&(e=100);var i=parseFloat(r[1])/e;if(i>=0&&i<=1)return i}throw new Error}function io(n){var e=n.getText(),t=e.match(/^([-+]?[0-9]*\.?[0-9]+)(deg|rad|grad|turn)?$/);if(t)switch(t[2]){case"deg":return parseFloat(e)%360;case"rad":return parseFloat(e)*180/Math.PI%360;case"grad":return parseFloat(e)*.9%360;case"turn":return parseFloat(e)*360%360;default:if(typeof t[2]>"u")return parseFloat(e)%360}throw new Error}function lo(n){var e=n.getName();return e?/^(rgb|rgba|hsl|hsla|hwb)$/gi.test(e):!1}var oo=48,Ks=57,Gs=65;var kn=97,Hs=102;function J(n){return n<oo?0:n<=Ks?n-oo:(n<kn&&(n+=kn-Gs),n>=kn&&n<=Hs?n-kn+10:0)}function so(n){if(n[0]!=="#")return null;switch(n.length){case 4:return{red:J(n.charCodeAt(1))*17/255,green:J(n.charCodeAt(2))*17/255,blue:J(n.charCodeAt(3))*17/255,alpha:1};case 5:return{red:J(n.charCodeAt(1))*17/255,green:J(n.charCodeAt(2))*17/255,blue:J(n.charCodeAt(3))*17/255,alpha:J(n.charCodeAt(4))*17/255};case 7:return{red:(J(n.charCodeAt(1))*16+J(n.charCodeAt(2)))/255,green:(J(n.charCodeAt(3))*16+J(n.charCodeAt(4)))/255,blue:(J(n.charCodeAt(5))*16+J(n.charCodeAt(6)))/255,alpha:1};case 9:return{red:(J(n.charCodeAt(1))*16+J(n.charCodeAt(2)))/255,green:(J(n.charCodeAt(3))*16+J(n.charCodeAt(4)))/255,blue:(J(n.charCodeAt(5))*16+J(n.charCodeAt(6)))/255,alpha:(J(n.charCodeAt(7))*16+J(n.charCodeAt(8)))/255}}return null}function co(n,e,t,r){if(r===void 0&&(r=1),n=n/60,e===0)return{red:t,green:t,blue:t,alpha:r};var i=function(a,l,c){for(;c<0;)c+=6;for(;c>=6;)c-=6;return c<1?(l-a)*c+a:c<3?l:c<4?(l-a)*(4-c)+a:a},o=t<=.5?t*(e+1):t+e-t*e,s=t*2-o;return{red:i(s,o,n+2),green:i(s,o,n),blue:i(s,o,n-2),alpha:r}}function fr(n){var e=n.red,t=n.green,r=n.blue,i=n.alpha,o=Math.max(e,t,r),s=Math.min(e,t,r),a=0,l=0,c=(s+o)/2,h=o-s;if(h>0){switch(l=Math.min(c<=.5?h/(2*c):h/(2-2*c),1),o){case e:a=(t-r)/h+(t<r?6:0);break;case t:a=(r-e)/h+2;break;case r:a=(e-t)/h+4;break}a*=60,a=Math.round(a)}return{h:a,s:l,l:c,a:i}}function Js(n,e,t,r){if(r===void 0&&(r=1),e+t>=1){var i=e/(e+t);return{red:i,green:i,blue:i,alpha:r}}var o=co(n,1,.5,r),s=o.red;s*=1-e-t,s+=e;var a=o.green;a*=1-e-t,a+=e;var l=o.blue;return l*=1-e-t,l+=e,{red:s,green:a,blue:l,alpha:r}}function ho(n){var e=fr(n),t=Math.min(n.red,n.green,n.blue),r=1-Math.max(n.red,n.green,n.blue);return{h:e.h,w:t,b:r,a:e.a}}function po(n){if(n.type===u.HexColorValue){var e=n.getText();return so(e)}else if(n.type===u.Function){var t=n,r=t.getName(),i=t.getArguments().getChildren();if(i.length===1){var o=i[0].getChildren();if(o.length===1&&o[0].type===u.Expression&&(i=o[0].getChildren(),i.length===3)){var s=i[2];if(s instanceof pt){var a=s.getLeft(),l=s.getRight(),c=s.getOperator();a&&l&&c&&c.matches("/")&&(i=[i[0],i[1],a,l])}}}if(!r||i.length<3||i.length>4)return null;try{var h=i.length===4?Je(i[3],1):1;if(r==="rgb"||r==="rgba")return{red:Je(i[0],255),green:Je(i[1],255),blue:Je(i[2],255),alpha:h};if(r==="hsl"||r==="hsla"){var p=io(i[0]),m=Je(i[1],100),g=Je(i[2],100);return co(p,m,g,h)}else if(r==="hwb"){var p=io(i[0]),w=Je(i[1],100),x=Je(i[2],100);return Js(p,w,x,h)}}catch{return null}}else if(n.type===u.Identifier){if(n.parent&&n.parent.type!==u.Term)return null;var y=n.parent;if(y&&y.parent&&y.parent.type===u.BinaryExpression){var D=y.parent;if(D.parent&&D.parent.type===u.ListEntry&&D.parent.key===D)return null}var M=n.getText().toLowerCase();if(M==="none")return null;var z=Vt[M];if(z)return so(z)}return null}var gr={bottom:"Computes to \u2018100%\u2019 for the vertical position if one or two values are given, otherwise specifies the bottom edge as the origin for the next offset.",center:"Computes to \u201850%\u2019 (\u2018left 50%\u2019) for the horizontal position if the horizontal position is not otherwise specified, or \u201850%\u2019 (\u2018top 50%\u2019) for the vertical position if it is.",left:"Computes to \u20180%\u2019 for the horizontal position if one or two values are given, otherwise specifies the left edge as the origin for the next offset.",right:"Computes to \u2018100%\u2019 for the horizontal position if one or two values are given, otherwise specifies the right edge as the origin for the next offset.",top:"Computes to \u20180%\u2019 for the vertical position if one or two values are given, otherwise specifies the top edge as the origin for the next offset."},br={"no-repeat":"Placed once and not repeated in this direction.",repeat:"Repeated in this direction as often as needed to cover the background painting area.","repeat-x":"Computes to \u2018repeat no-repeat\u2019.","repeat-y":"Computes to \u2018no-repeat repeat\u2019.",round:"Repeated as often as will fit within the background positioning area. If it doesn\u2019t fit a whole number of times, it is rescaled so that it does.",space:"Repeated as often as will fit within the background positioning area without being clipped and then the images are spaced out to fill the area."},vr={dashed:"A series of square-ended dashes.",dotted:"A series of round dots.",double:"Two parallel solid lines with some space between them.",groove:"Looks as if it were carved in the canvas.",hidden:"Same as \u2018none\u2019, but has different behavior in the border conflict resolution rules for border-collapsed tables.",inset:"Looks as if the content on the inside of the border is sunken into the canvas.",none:"No border. Color and width are ignored.",outset:"Looks as if the content on the inside of the border is coming out of the canvas.",ridge:"Looks as if it were coming out of the canvas.",solid:"A single line segment."},uo=["medium","thick","thin"],yr={"border-box":"The background is painted within (clipped to) the border box.","content-box":"The background is painted within (clipped to) the content box.","padding-box":"The background is painted within (clipped to) the padding box."},wr={"margin-box":"Uses the margin box as reference box.","fill-box":"Uses the object bounding box as reference box.","stroke-box":"Uses the stroke bounding box as reference box.","view-box":"Uses the nearest SVG viewport as reference box."},xr={initial:"Represents the value specified as the property\u2019s initial value.",inherit:"Represents the computed value of the property on the element\u2019s parent.",unset:"Acts as either `inherit` or `initial`, depending on whether the property is inherited or not."},Sr={"var()":"Evaluates the value of a custom variable.","calc()":"Evaluates an mathematical expression. The following operators can be used: + - * /."},kr={"url()":"Reference an image file by URL","image()":"Provide image fallbacks and annotations.","-webkit-image-set()":"Provide multiple resolutions. Remember to use unprefixed image-set() in addition.","image-set()":"Provide multiple resolutions of an image and const the UA decide which is most appropriate in a given situation.","-moz-element()":"Use an element in the document as an image. Remember to use unprefixed element() in addition.","element()":"Use an element in the document as an image.","cross-fade()":"Indicates the two images to be combined and how far along in the transition the combination is.","-webkit-gradient()":"Deprecated. Use modern linear-gradient() or radial-gradient() instead.","-webkit-linear-gradient()":"Linear gradient. Remember to use unprefixed version in addition.","-moz-linear-gradient()":"Linear gradient. Remember to use unprefixed version in addition.","-o-linear-gradient()":"Linear gradient. Remember to use unprefixed version in addition.","linear-gradient()":"A linear gradient is created by specifying a straight gradient line, and then several colors placed along that line.","-webkit-repeating-linear-gradient()":"Repeating Linear gradient. Remember to use unprefixed version in addition.","-moz-repeating-linear-gradient()":"Repeating Linear gradient. Remember to use unprefixed version in addition.","-o-repeating-linear-gradient()":"Repeating Linear gradient. Remember to use unprefixed version in addition.","repeating-linear-gradient()":"Same as linear-gradient, except the color-stops are repeated infinitely in both directions, with their positions shifted by multiples of the difference between the last specified color-stop\u2019s position and the first specified color-stop\u2019s position.","-webkit-radial-gradient()":"Radial gradient. Remember to use unprefixed version in addition.","-moz-radial-gradient()":"Radial gradient. Remember to use unprefixed version in addition.","radial-gradient()":"Colors emerge from a single point and smoothly spread outward in a circular or elliptical shape.","-webkit-repeating-radial-gradient()":"Repeating radial gradient. Remember to use unprefixed version in addition.","-moz-repeating-radial-gradient()":"Repeating radial gradient. Remember to use unprefixed version in addition.","repeating-radial-gradient()":"Same as radial-gradient, except the color-stops are repeated infinitely in both directions, with their positions shifted by multiples of the difference between the last specified color-stop\u2019s position and the first specified color-stop\u2019s position."},Cr={ease:"Equivalent to cubic-bezier(0.25, 0.1, 0.25, 1.0).","ease-in":"Equivalent to cubic-bezier(0.42, 0, 1.0, 1.0).","ease-in-out":"Equivalent to cubic-bezier(0.42, 0, 0.58, 1.0).","ease-out":"Equivalent to cubic-bezier(0, 0, 0.58, 1.0).",linear:"Equivalent to cubic-bezier(0.0, 0.0, 1.0, 1.0).","step-end":"Equivalent to steps(1, end).","step-start":"Equivalent to steps(1, start).","steps()":"The first parameter specifies the number of intervals in the function. The second parameter, which is optional, is either the value \u201Cstart\u201D or \u201Cend\u201D.","cubic-bezier()":"Specifies a cubic-bezier curve. The four values specify points P1 and P2  of the curve as (x1, y1, x2, y2).","cubic-bezier(0.6, -0.28, 0.735, 0.045)":"Ease-in Back. Overshoots.","cubic-bezier(0.68, -0.55, 0.265, 1.55)":"Ease-in-out Back. Overshoots.","cubic-bezier(0.175, 0.885, 0.32, 1.275)":"Ease-out Back. Overshoots.","cubic-bezier(0.6, 0.04, 0.98, 0.335)":"Ease-in Circular. Based on half circle.","cubic-bezier(0.785, 0.135, 0.15, 0.86)":"Ease-in-out Circular. Based on half circle.","cubic-bezier(0.075, 0.82, 0.165, 1)":"Ease-out Circular. Based on half circle.","cubic-bezier(0.55, 0.055, 0.675, 0.19)":"Ease-in Cubic. Based on power of three.","cubic-bezier(0.645, 0.045, 0.355, 1)":"Ease-in-out Cubic. Based on power of three.","cubic-bezier(0.215, 0.610, 0.355, 1)":"Ease-out Cubic. Based on power of three.","cubic-bezier(0.95, 0.05, 0.795, 0.035)":"Ease-in Exponential. Based on two to the power ten.","cubic-bezier(1, 0, 0, 1)":"Ease-in-out Exponential. Based on two to the power ten.","cubic-bezier(0.19, 1, 0.22, 1)":"Ease-out Exponential. Based on two to the power ten.","cubic-bezier(0.47, 0, 0.745, 0.715)":"Ease-in Sine.","cubic-bezier(0.445, 0.05, 0.55, 0.95)":"Ease-in-out Sine.","cubic-bezier(0.39, 0.575, 0.565, 1)":"Ease-out Sine.","cubic-bezier(0.55, 0.085, 0.68, 0.53)":"Ease-in Quadratic. Based on power of two.","cubic-bezier(0.455, 0.03, 0.515, 0.955)":"Ease-in-out Quadratic. Based on power of two.","cubic-bezier(0.25, 0.46, 0.45, 0.94)":"Ease-out Quadratic. Based on power of two.","cubic-bezier(0.895, 0.03, 0.685, 0.22)":"Ease-in Quartic. Based on power of four.","cubic-bezier(0.77, 0, 0.175, 1)":"Ease-in-out Quartic. Based on power of four.","cubic-bezier(0.165, 0.84, 0.44, 1)":"Ease-out Quartic. Based on power of four.","cubic-bezier(0.755, 0.05, 0.855, 0.06)":"Ease-in Quintic. Based on power of five.","cubic-bezier(0.86, 0, 0.07, 1)":"Ease-in-out Quintic. Based on power of five.","cubic-bezier(0.23, 1, 0.320, 1)":"Ease-out Quintic. Based on power of five."},_r={"circle()":"Defines a circle.","ellipse()":"Defines an ellipse.","inset()":"Defines an inset rectangle.","polygon()":"Defines a polygon."},Cn={length:["em","rem","ex","px","cm","mm","in","pt","pc","ch","vw","vh","vmin","vmax"],angle:["deg","rad","grad","turn"],time:["ms","s"],frequency:["Hz","kHz"],resolution:["dpi","dpcm","dppx"],percentage:["%","fr"]},mo=["a","abbr","address","area","article","aside","audio","b","base","bdi","bdo","blockquote","body","br","button","canvas","caption","cite","code","col","colgroup","data","datalist","dd","del","details","dfn","dialog","div","dl","dt","em","embed","fieldset","figcaption","figure","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","iframe","img","input","ins","kbd","keygen","label","legend","li","link","main","map","mark","menu","menuitem","meta","meter","nav","noscript","object","ol","optgroup","option","output","p","param","picture","pre","progress","q","rb","rp","rt","rtc","ruby","s","samp","script","section","select","small","source","span","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","title","tr","track","u","ul","const","video","wbr"],fo=["circle","clipPath","cursor","defs","desc","ellipse","feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feDropShadow","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feImage","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence","filter","foreignObject","g","hatch","hatchpath","image","line","linearGradient","marker","mask","mesh","meshpatch","meshrow","metadata","mpath","path","pattern","polygon","polyline","radialGradient","rect","set","solidcolor","stop","svg","switch","symbol","text","textPath","tspan","use","view"],go=["@bottom-center","@bottom-left","@bottom-left-corner","@bottom-right","@bottom-right-corner","@left-bottom","@left-middle","@left-top","@right-bottom","@right-middle","@right-top","@top-center","@top-left","@top-left-corner","@top-right","@top-right-corner"];function Bt(n){return Object.keys(n).map(function(e){return n[e]})}function he(n){return typeof n<"u"}var bo=function(n,e,t){if(t||arguments.length===2)for(var r=0,i=e.length,o;r<i;r++)(o||!(r in e))&&(o||(o=Array.prototype.slice.call(e,0,r)),o[r]=e[r]);return n.concat(o||Array.prototype.slice.call(e))},bt=function(){function n(e){e===void 0&&(e=new Fe),this.keyframeRegex=/^@(\-(webkit|ms|moz|o)\-)?keyframes$/i,this.scanner=e,this.token={type:d.EOF,offset:-1,len:0,text:""},this.prevToken=void 0}return n.prototype.peekIdent=function(e){return d.Ident===this.token.type&&e.length===this.token.text.length&&e===this.token.text.toLowerCase()},n.prototype.peekKeyword=function(e){return d.AtKeyword===this.token.type&&e.length===this.token.text.length&&e===this.token.text.toLowerCase()},n.prototype.peekDelim=function(e){return d.Delim===this.token.type&&e===this.token.text},n.prototype.peek=function(e){return e===this.token.type},n.prototype.peekOne=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];return e.indexOf(this.token.type)!==-1},n.prototype.peekRegExp=function(e,t){return e!==this.token.type?!1:t.test(this.token.text)},n.prototype.hasWhitespace=function(){return!!this.prevToken&&this.prevToken.offset+this.prevToken.len!==this.token.offset},n.prototype.consumeToken=function(){this.prevToken=this.token,this.token=this.scanner.scan()},n.prototype.acceptUnicodeRange=function(){var e=this.scanner.tryScanUnicode();return e?(this.prevToken=e,this.token=this.scanner.scan(),!0):!1},n.prototype.mark=function(){return{prev:this.prevToken,curr:this.token,pos:this.scanner.pos()}},n.prototype.restoreAtMark=function(e){this.prevToken=e.prev,this.token=e.curr,this.scanner.goBackTo(e.pos)},n.prototype.try=function(e){var t=this.mark(),r=e();return r||(this.restoreAtMark(t),null)},n.prototype.acceptOneKeyword=function(e){if(d.AtKeyword===this.token.type)for(var t=0,r=e;t<r.length;t++){var i=r[t];if(i.length===this.token.text.length&&i===this.token.text.toLowerCase())return this.consumeToken(),!0}return!1},n.prototype.accept=function(e){return e===this.token.type?(this.consumeToken(),!0):!1},n.prototype.acceptIdent=function(e){return this.peekIdent(e)?(this.consumeToken(),!0):!1},n.prototype.acceptKeyword=function(e){return this.peekKeyword(e)?(this.consumeToken(),!0):!1},n.prototype.acceptDelim=function(e){return this.peekDelim(e)?(this.consumeToken(),!0):!1},n.prototype.acceptRegexp=function(e){return e.test(this.token.text)?(this.consumeToken(),!0):!1},n.prototype._parseRegexp=function(e){var t=this.createNode(u.Identifier);do;while(this.acceptRegexp(e));return this.finish(t)},n.prototype.acceptUnquotedString=function(){var e=this.scanner.pos();this.scanner.goBackTo(this.token.offset);var t=this.scanner.scanUnquotedString();return t?(this.token=t,this.consumeToken(),!0):(this.scanner.goBackTo(e),!1)},n.prototype.resync=function(e,t){for(;;){if(e&&e.indexOf(this.token.type)!==-1)return this.consumeToken(),!0;if(t&&t.indexOf(this.token.type)!==-1)return!0;if(this.token.type===d.EOF)return!1;this.token=this.scanner.scan()}},n.prototype.createNode=function(e){return new F(this.token.offset,this.token.len,e)},n.prototype.create=function(e){return new e(this.token.offset,this.token.len)},n.prototype.finish=function(e,t,r,i){if(!(e instanceof ee)&&(t&&this.markError(e,t,r,i),this.prevToken)){var o=this.prevToken.offset+this.prevToken.len;e.length=o>e.offset?o-e.offset:0}return e},n.prototype.markError=function(e,t,r,i){this.token!==this.lastErrorToken&&(e.addIssue(new fn(e,t,ne.Error,void 0,this.token.offset,this.token.len)),this.lastErrorToken=this.token),(r||i)&&this.resync(r,i)},n.prototype.parseStylesheet=function(e){var t=e.version,r=e.getText(),i=function(o,s){if(e.version!==t)throw new Error("Underlying model has changed, AST is no longer valid");return r.substr(o,s)};return this.internalParse(r,this._parseStylesheet,i)},n.prototype.internalParse=function(e,t,r){this.scanner.setSource(e),this.token=this.scanner.scan();var i=t.bind(this)();return i&&(r?i.textProvider=r:i.textProvider=function(o,s){return e.substr(o,s)}),i},n.prototype._parseStylesheet=function(){for(var e=this.create(ci);e.addChild(this._parseStylesheetStart()););var t=!1;do{var r=!1;do{r=!1;var i=this._parseStylesheetStatement();for(i&&(e.addChild(i),r=!0,t=!1,!this.peek(d.EOF)&&this._needsSemicolonAfter(i)&&!this.accept(d.SemiColon)&&this.markError(e,f.SemiColonExpected));this.accept(d.SemiColon)||this.accept(d.CDO)||this.accept(d.CDC);)r=!0,t=!1}while(r);if(this.peek(d.EOF))break;t||(this.peek(d.AtKeyword)?this.markError(e,f.UnknownAtRule):this.markError(e,f.RuleOrSelectorExpected),t=!0),this.consumeToken()}while(!this.peek(d.EOF));return this.finish(e)},n.prototype._parseStylesheetStart=function(){return this._parseCharset()},n.prototype._parseStylesheetStatement=function(e){return e===void 0&&(e=!1),this.peek(d.AtKeyword)?this._parseStylesheetAtStatement(e):this._parseRuleset(e)},n.prototype._parseStylesheetAtStatement=function(e){return e===void 0&&(e=!1),this._parseImport()||this._parseMedia(e)||this._parsePage()||this._parseFontFace()||this._parseKeyframe()||this._parseSupports(e)||this._parseViewPort()||this._parseNamespace()||this._parseDocument()||this._parseUnknownAtRule()},n.prototype._tryParseRuleset=function(e){var t=this.mark();if(this._parseSelector(e)){for(;this.accept(d.Comma)&&this._parseSelector(e););if(this.accept(d.CurlyL))return this.restoreAtMark(t),this._parseRuleset(e)}return this.restoreAtMark(t),null},n.prototype._parseRuleset=function(e){e===void 0&&(e=!1);var t=this.create(Te),r=t.getSelectors();if(!r.addChild(this._parseSelector(e)))return null;for(;this.accept(d.Comma);)if(!r.addChild(this._parseSelector(e)))return this.finish(t,f.SelectorExpected);return this._parseBody(t,this._parseRuleSetDeclaration.bind(this))},n.prototype._parseRuleSetDeclarationAtStatement=function(){return this._parseUnknownAtRule()},n.prototype._parseRuleSetDeclaration=function(){return this.peek(d.AtKeyword)?this._parseRuleSetDeclarationAtStatement():this._parseDeclaration()},n.prototype._needsSemicolonAfter=function(e){switch(e.type){case u.Keyframe:case u.ViewPort:case u.Media:case u.Ruleset:case u.Namespace:case u.If:case u.For:case u.Each:case u.While:case u.MixinDeclaration:case u.FunctionDeclaration:case u.MixinContentDeclaration:return!1;case u.ExtendsReference:case u.MixinContentReference:case u.ReturnStatement:case u.MediaQuery:case u.Debug:case u.Import:case u.AtApplyRule:case u.CustomPropertyDeclaration:return!0;case u.VariableDeclaration:return e.needsSemicolon;case u.MixinReference:return!e.getContent();case u.Declaration:return!e.getNestedProperties()}return!1},n.prototype._parseDeclarations=function(e){var t=this.create(Et);if(!this.accept(d.CurlyL))return null;for(var r=e();t.addChild(r)&&!this.peek(d.CurlyR);){if(this._needsSemicolonAfter(r)&&!this.accept(d.SemiColon))return this.finish(t,f.SemiColonExpected,[d.SemiColon,d.CurlyR]);for(r&&this.prevToken&&this.prevToken.type===d.SemiColon&&(r.semicolonPosition=this.prevToken.offset);this.accept(d.SemiColon););r=e()}return this.accept(d.CurlyR)?this.finish(t):this.finish(t,f.RightCurlyExpected,[d.CurlyR,d.SemiColon])},n.prototype._parseBody=function(e,t){return e.setDeclarations(this._parseDeclarations(t))?this.finish(e):this.finish(e,f.LeftCurlyExpected,[d.CurlyR,d.SemiColon])},n.prototype._parseSelector=function(e){var t=this.create(Ee),r=!1;for(e&&(r=t.addChild(this._parseCombinator()));t.addChild(this._parseSimpleSelector());)r=!0,t.addChild(this._parseCombinator());return r?this.finish(t):null},n.prototype._parseDeclaration=function(e){var t=this._tryParseCustomPropertyDeclaration(e);if(t)return t;var r=this.create(ae);return r.setProperty(this._parseProperty())?this.accept(d.Colon)?(this.prevToken&&(r.colonPosition=this.prevToken.offset),r.setValue(this._parseExpr())?(r.addChild(this._parsePrio()),this.peek(d.SemiColon)&&(r.semicolonPosition=this.token.offset),this.finish(r)):this.finish(r,f.PropertyValueExpected)):this.finish(r,f.ColonExpected,[d.Colon],e||[d.SemiColon]):null},n.prototype._tryParseCustomPropertyDeclaration=function(e){if(!this.peekRegExp(d.Ident,/^--/))return null;var t=this.create(hi);if(!t.setProperty(this._parseProperty()))return null;if(!this.accept(d.Colon))return this.finish(t,f.ColonExpected,[d.Colon]);this.prevToken&&(t.colonPosition=this.prevToken.offset);var r=this.mark();if(this.peek(d.CurlyL)){var i=this.create(di),o=this._parseDeclarations(this._parseRuleSetDeclaration.bind(this));if(i.setDeclarations(o)&&!o.isErroneous(!0)&&(i.addChild(this._parsePrio()),this.peek(d.SemiColon)))return this.finish(i),t.setPropertySet(i),t.semicolonPosition=this.token.offset,this.finish(t);this.restoreAtMark(r)}var s=this._parseExpr();return s&&!s.isErroneous(!0)&&(this._parsePrio(),this.peekOne.apply(this,bo(bo([],e||[],!1),[d.SemiColon,d.EOF],!1)))?(t.setValue(s),this.peek(d.SemiColon)&&(t.semicolonPosition=this.token.offset),this.finish(t)):(this.restoreAtMark(r),t.addChild(this._parseCustomPropertyValue(e)),t.addChild(this._parsePrio()),he(t.colonPosition)&&this.token.offset===t.colonPosition+1?this.finish(t,f.PropertyValueExpected):this.finish(t))},n.prototype._parseCustomPropertyValue=function(e){var t=this;e===void 0&&(e=[d.CurlyR]);var r=this.create(F),i=function(){return s===0&&a===0&&l===0},o=function(){return e.indexOf(t.token.type)!==-1},s=0,a=0,l=0;e:for(;;){switch(this.token.type){case d.SemiColon:if(i())break e;break;case d.Exclamation:if(i())break e;break;case d.CurlyL:s++;break;case d.CurlyR:if(s--,s<0){if(o()&&a===0&&l===0)break e;return this.finish(r,f.LeftCurlyExpected)}break;case d.ParenthesisL:a++;break;case d.ParenthesisR:if(a--,a<0){if(o()&&l===0&&s===0)break e;return this.finish(r,f.LeftParenthesisExpected)}break;case d.BracketL:l++;break;case d.BracketR:if(l--,l<0)return this.finish(r,f.LeftSquareBracketExpected);break;case d.BadString:break e;case d.EOF:var c=f.RightCurlyExpected;return l>0?c=f.RightSquareBracketExpected:a>0&&(c=f.RightParenthesisExpected),this.finish(r,c)}this.consumeToken()}return this.finish(r)},n.prototype._tryToParseDeclaration=function(e){var t=this.mark();return this._parseProperty()&&this.accept(d.Colon)?(this.restoreAtMark(t),this._parseDeclaration(e)):(this.restoreAtMark(t),null)},n.prototype._parseProperty=function(){var e=this.create(dt),t=this.mark();return(this.acceptDelim("*")||this.acceptDelim("_"))&&this.hasWhitespace()?(this.restoreAtMark(t),null):e.setIdentifier(this._parsePropertyIdentifier())?this.finish(e):null},n.prototype._parsePropertyIdentifier=function(){return this._parseIdent()},n.prototype._parseCharset=function(){if(!this.peek(d.Charset))return null;var e=this.create(F);return this.consumeToken(),this.accept(d.String)?this.accept(d.SemiColon)?this.finish(e):this.finish(e,f.SemiColonExpected):this.finish(e,f.IdentifierExpected)},n.prototype._parseImport=function(){if(!this.peekKeyword("@import"))return null;var e=this.create(ht);return this.consumeToken(),!e.addChild(this._parseURILiteral())&&!e.addChild(this._parseStringLiteral())?this.finish(e,f.URIOrStringExpected):(!this.peek(d.SemiColon)&&!this.peek(d.EOF)&&e.setMedialist(this._parseMediaQueryList()),this.finish(e))},n.prototype._parseNamespace=function(){if(!this.peekKeyword("@namespace"))return null;var e=this.create(Si);return this.consumeToken(),!e.addChild(this._parseURILiteral())&&(e.addChild(this._parseIdent()),!e.addChild(this._parseURILiteral())&&!e.addChild(this._parseStringLiteral()))?this.finish(e,f.URIExpected,[d.SemiColon]):this.accept(d.SemiColon)?this.finish(e):this.finish(e,f.SemiColonExpected)},n.prototype._parseFontFace=function(){if(!this.peekKeyword("@font-face"))return null;var e=this.create(ln);return this.consumeToken(),this._parseBody(e,this._parseRuleSetDeclaration.bind(this))},n.prototype._parseViewPort=function(){if(!this.peekKeyword("@-ms-viewport")&&!this.peekKeyword("@-o-viewport")&&!this.peekKeyword("@viewport"))return null;var e=this.create(bi);return this.consumeToken(),this._parseBody(e,this._parseRuleSetDeclaration.bind(this))},n.prototype._parseKeyframe=function(){if(!this.peekRegExp(d.AtKeyword,this.keyframeRegex))return null;var e=this.create(cn),t=this.create(F);return this.consumeToken(),e.setKeyword(this.finish(t)),t.matches("@-ms-keyframes")&&this.markError(t,f.UnknownKeyword),e.setIdentifier(this._parseKeyframeIdent())?this._parseBody(e,this._parseKeyframeSelector.bind(this)):this.finish(e,f.IdentifierExpected,[d.CurlyR])},n.prototype._parseKeyframeIdent=function(){return this._parseIdent([A.Keyframe])},n.prototype._parseKeyframeSelector=function(){var e=this.create(Qn);if(!e.addChild(this._parseIdent())&&!this.accept(d.Percentage))return null;for(;this.accept(d.Comma);)if(!e.addChild(this._parseIdent())&&!this.accept(d.Percentage))return this.finish(e,f.PercentageExpected);return this._parseBody(e,this._parseRuleSetDeclaration.bind(this))},n.prototype._tryParseKeyframeSelector=function(){var e=this.create(Qn),t=this.mark();if(!e.addChild(this._parseIdent())&&!this.accept(d.Percentage))return null;for(;this.accept(d.Comma);)if(!e.addChild(this._parseIdent())&&!this.accept(d.Percentage))return this.restoreAtMark(t),null;return this.peek(d.CurlyL)?this._parseBody(e,this._parseRuleSetDeclaration.bind(this)):(this.restoreAtMark(t),null)},n.prototype._parseSupports=function(e){if(e===void 0&&(e=!1),!this.peekKeyword("@supports"))return null;var t=this.create(Dt);return this.consumeToken(),t.addChild(this._parseSupportsCondition()),this._parseBody(t,this._parseSupportsDeclaration.bind(this,e))},n.prototype._parseSupportsDeclaration=function(e){return e===void 0&&(e=!1),e?this._tryParseRuleset(!0)||this._tryToParseDeclaration()||this._parseStylesheetStatement(!0):this._parseStylesheetStatement(!1)},n.prototype._parseSupportsCondition=function(){var e=this.create(Ze);if(this.acceptIdent("not"))e.addChild(this._parseSupportsConditionInParens());else if(e.addChild(this._parseSupportsConditionInParens()),this.peekRegExp(d.Ident,/^(and|or)$/i))for(var t=this.token.text.toLowerCase();this.acceptIdent(t);)e.addChild(this._parseSupportsConditionInParens());return this.finish(e)},n.prototype._parseSupportsConditionInParens=function(){var e=this.create(Ze);if(this.accept(d.ParenthesisL))return this.prevToken&&(e.lParent=this.prevToken.offset),!e.addChild(this._tryToParseDeclaration([d.ParenthesisR]))&&!this._parseSupportsCondition()?this.finish(e,f.ConditionExpected):this.accept(d.ParenthesisR)?(this.prevToken&&(e.rParent=this.prevToken.offset),this.finish(e)):this.finish(e,f.RightParenthesisExpected,[d.ParenthesisR],[]);if(this.peek(d.Ident)){var t=this.mark();if(this.consumeToken(),!this.hasWhitespace()&&this.accept(d.ParenthesisL)){for(var r=1;this.token.type!==d.EOF&&r!==0;)this.token.type===d.ParenthesisL?r++:this.token.type===d.ParenthesisR&&r--,this.consumeToken();return this.finish(e)}else this.restoreAtMark(t)}return this.finish(e,f.LeftParenthesisExpected,[],[d.ParenthesisL])},n.prototype._parseMediaDeclaration=function(e){return e===void 0&&(e=!1),e?this._tryParseRuleset(!0)||this._tryToParseDeclaration()||this._parseStylesheetStatement(!0):this._parseStylesheetStatement(!1)},n.prototype._parseMedia=function(e){if(e===void 0&&(e=!1),!this.peekKeyword("@media"))return null;var t=this.create(dn);return this.consumeToken(),t.addChild(this._parseMediaQueryList())?this._parseBody(t,this._parseMediaDeclaration.bind(this,e)):this.finish(t,f.MediaQueryExpected)},n.prototype._parseMediaQueryList=function(){var e=this.create(hn);if(!e.addChild(this._parseMediaQuery()))return this.finish(e,f.MediaQueryExpected);for(;this.accept(d.Comma);)if(!e.addChild(this._parseMediaQuery()))return this.finish(e,f.MediaQueryExpected);return this.finish(e)},n.prototype._parseMediaQuery=function(){var e=this.create(pn),t=this.mark();if(this.acceptIdent("not"),this.peek(d.ParenthesisL))this.restoreAtMark(t),e.addChild(this._parseMediaCondition());else{if(this.acceptIdent("only"),!e.addChild(this._parseIdent()))return null;this.acceptIdent("and")&&e.addChild(this._parseMediaCondition())}return this.finish(e)},n.prototype._parseRatio=function(){var e=this.mark(),t=this.create(Ri);return this._parseNumeric()?this.acceptDelim("/")?this._parseNumeric()?this.finish(t):this.finish(t,f.NumberExpected):(this.restoreAtMark(e),null):null},n.prototype._parseMediaCondition=function(){var e=this.create(Ci);this.acceptIdent("not");for(var t=!0;t;){if(!this.accept(d.ParenthesisL))return this.finish(e,f.LeftParenthesisExpected,[],[d.CurlyL]);if(this.peek(d.ParenthesisL)||this.peekIdent("not")?e.addChild(this._parseMediaCondition()):e.addChild(this._parseMediaFeature()),!this.accept(d.ParenthesisR))return this.finish(e,f.RightParenthesisExpected,[],[d.CurlyL]);t=this.acceptIdent("and")||this.acceptIdent("or")}return this.finish(e)},n.prototype._parseMediaFeature=function(){var e=this,t=[d.ParenthesisR],r=this.create(_i),i=function(){return e.acceptDelim("<")||e.acceptDelim(">")?(e.hasWhitespace()||e.acceptDelim("="),!0):!!e.acceptDelim("=")};if(r.addChild(this._parseMediaFeatureName())){if(this.accept(d.Colon)){if(!r.addChild(this._parseMediaFeatureValue()))return this.finish(r,f.TermExpected,[],t)}else if(i()){if(!r.addChild(this._parseMediaFeatureValue()))return this.finish(r,f.TermExpected,[],t);if(i()&&!r.addChild(this._parseMediaFeatureValue()))return this.finish(r,f.TermExpected,[],t)}}else if(r.addChild(this._parseMediaFeatureValue())){if(!i())return this.finish(r,f.OperatorExpected,[],t);if(!r.addChild(this._parseMediaFeatureName()))return this.finish(r,f.IdentifierExpected,[],t);if(i()&&!r.addChild(this._parseMediaFeatureValue()))return this.finish(r,f.TermExpected,[],t)}else return this.finish(r,f.IdentifierExpected,[],t);return this.finish(r)},n.prototype._parseMediaFeatureName=function(){return this._parseIdent()},n.prototype._parseMediaFeatureValue=function(){return this._parseRatio()||this._parseTermExpression()},n.prototype._parseMedium=function(){var e=this.create(F);return e.addChild(this._parseIdent())?this.finish(e):null},n.prototype._parsePageDeclaration=function(){return this._parsePageMarginBox()||this._parseRuleSetDeclaration()},n.prototype._parsePage=function(){if(!this.peekKeyword("@page"))return null;var e=this.create(Fi);if(this.consumeToken(),e.addChild(this._parsePageSelector())){for(;this.accept(d.Comma);)if(!e.addChild(this._parsePageSelector()))return this.finish(e,f.IdentifierExpected)}return this._parseBody(e,this._parsePageDeclaration.bind(this))},n.prototype._parsePageMarginBox=function(){if(!this.peek(d.AtKeyword))return null;var e=this.create(Ei);return this.acceptOneKeyword(go)||this.markError(e,f.UnknownAtRule,[],[d.CurlyL]),this._parseBody(e,this._parseRuleSetDeclaration.bind(this))},n.prototype._parsePageSelector=function(){if(!this.peek(d.Ident)&&!this.peek(d.Colon))return null;var e=this.create(F);return e.addChild(this._parseIdent()),this.accept(d.Colon)&&!e.addChild(this._parseIdent())?this.finish(e,f.IdentifierExpected):this.finish(e)},n.prototype._parseDocument=function(){if(!this.peekKeyword("@-moz-document"))return null;var e=this.create(ki);return this.consumeToken(),this.resync([],[d.CurlyL]),this._parseBody(e,this._parseStylesheetStatement.bind(this))},n.prototype._parseUnknownAtRule=function(){if(!this.peek(d.AtKeyword))return null;var e=this.create(mn);e.addChild(this._parseUnknownAtRuleName());var t=function(){return i===0&&o===0&&s===0},r=0,i=0,o=0,s=0;e:for(;;){switch(this.token.type){case d.SemiColon:if(t())break e;break;case d.EOF:return i>0?this.finish(e,f.RightCurlyExpected):s>0?this.finish(e,f.RightSquareBracketExpected):o>0?this.finish(e,f.RightParenthesisExpected):this.finish(e);case d.CurlyL:r++,i++;break;case d.CurlyR:if(i--,r>0&&i===0){if(this.consumeToken(),s>0)return this.finish(e,f.RightSquareBracketExpected);if(o>0)return this.finish(e,f.RightParenthesisExpected);break e}if(i<0){if(o===0&&s===0)break e;return this.finish(e,f.LeftCurlyExpected)}break;case d.ParenthesisL:o++;break;case d.ParenthesisR:if(o--,o<0)return this.finish(e,f.LeftParenthesisExpected);break;case d.BracketL:s++;break;case d.BracketR:if(s--,s<0)return this.finish(e,f.LeftSquareBracketExpected);break}this.consumeToken()}return e},n.prototype._parseUnknownAtRuleName=function(){var e=this.create(F);return this.accept(d.AtKeyword)?this.finish(e):e},n.prototype._parseOperator=function(){if(this.peekDelim("/")||this.peekDelim("*")||this.peekDelim("+")||this.peekDelim("-")||this.peek(d.Dashmatch)||this.peek(d.Includes)||this.peek(d.SubstringOperator)||this.peek(d.PrefixOperator)||this.peek(d.SuffixOperator)||this.peekDelim("=")){var e=this.createNode(u.Operator);return this.consumeToken(),this.finish(e)}else return null},n.prototype._parseUnaryOperator=function(){if(!this.peekDelim("+")&&!this.peekDelim("-"))return null;var e=this.create(F);return this.consumeToken(),this.finish(e)},n.prototype._parseCombinator=function(){if(this.peekDelim(">")){var e=this.create(F);this.consumeToken();var t=this.mark();if(!this.hasWhitespace()&&this.acceptDelim(">")){if(!this.hasWhitespace()&&this.acceptDelim(">"))return e.type=u.SelectorCombinatorShadowPiercingDescendant,this.finish(e);this.restoreAtMark(t)}return e.type=u.SelectorCombinatorParent,this.finish(e)}else if(this.peekDelim("+")){var e=this.create(F);return this.consumeToken(),e.type=u.SelectorCombinatorSibling,this.finish(e)}else if(this.peekDelim("~")){var e=this.create(F);return this.consumeToken(),e.type=u.SelectorCombinatorAllSiblings,this.finish(e)}else if(this.peekDelim("/")){var e=this.create(F);this.consumeToken();var t=this.mark();if(!this.hasWhitespace()&&this.acceptIdent("deep")&&!this.hasWhitespace()&&this.acceptDelim("/"))return e.type=u.SelectorCombinatorShadowPiercingDescendant,this.finish(e);this.restoreAtMark(t)}return null},n.prototype._parseSimpleSelector=function(){var e=this.create(De),t=0;for(e.addChild(this._parseElementName())&&t++;(t===0||!this.hasWhitespace())&&e.addChild(this._parseSimpleSelectorBody());)t++;return t>0?this.finish(e):null},n.prototype._parseSimpleSelectorBody=function(){return this._parsePseudo()||this._parseHash()||this._parseClass()||this._parseAttrib()},n.prototype._parseSelectorIdent=function(){return this._parseIdent()},n.prototype._parseHash=function(){if(!this.peek(d.Hash)&&!this.peekDelim("#"))return null;var e=this.createNode(u.IdentifierSelector);if(this.acceptDelim("#")){if(this.hasWhitespace()||!e.addChild(this._parseSelectorIdent()))return this.finish(e,f.IdentifierExpected)}else this.consumeToken();return this.finish(e)},n.prototype._parseClass=function(){if(!this.peekDelim("."))return null;var e=this.createNode(u.ClassSelector);return this.consumeToken(),this.hasWhitespace()||!e.addChild(this._parseSelectorIdent())?this.finish(e,f.IdentifierExpected):this.finish(e)},n.prototype._parseElementName=function(){var e=this.mark(),t=this.createNode(u.ElementNameSelector);return t.addChild(this._parseNamespacePrefix()),!t.addChild(this._parseSelectorIdent())&&!this.acceptDelim("*")?(this.restoreAtMark(e),null):this.finish(t)},n.prototype._parseNamespacePrefix=function(){var e=this.mark(),t=this.createNode(u.NamespacePrefix);return!t.addChild(this._parseIdent())&&this.acceptDelim("*"),this.acceptDelim("|")?this.finish(t):(this.restoreAtMark(e),null)},n.prototype._parseAttrib=function(){if(!this.peek(d.BracketL))return null;var e=this.create(zi);return this.consumeToken(),e.setNamespacePrefix(this._parseNamespacePrefix()),e.setIdentifier(this._parseIdent())?(e.setOperator(this._parseOperator())&&(e.setValue(this._parseBinaryExpr()),this.acceptIdent("i"),this.acceptIdent("s")),this.accept(d.BracketR)?this.finish(e):this.finish(e,f.RightSquareBracketExpected)):this.finish(e,f.IdentifierExpected)},n.prototype._parsePseudo=function(){var e=this,t=this._tryParsePseudoIdentifier();if(t){if(!this.hasWhitespace()&&this.accept(d.ParenthesisL)){var r=function(){var i=e.create(F);if(!i.addChild(e._parseSelector(!1)))return null;for(;e.accept(d.Comma)&&i.addChild(e._parseSelector(!1)););return e.peek(d.ParenthesisR)?e.finish(i):null};if(t.addChild(this.try(r)||this._parseBinaryExpr()),!this.accept(d.ParenthesisR))return this.finish(t,f.RightParenthesisExpected)}return this.finish(t)}return null},n.prototype._tryParsePseudoIdentifier=function(){if(!this.peek(d.Colon))return null;var e=this.mark(),t=this.createNode(u.PseudoSelector);return this.consumeToken(),this.hasWhitespace()?(this.restoreAtMark(e),null):(this.accept(d.Colon),this.hasWhitespace()||!t.addChild(this._parseIdent())?this.finish(t,f.IdentifierExpected):this.finish(t))},n.prototype._tryParsePrio=function(){var e=this.mark(),t=this._parsePrio();return t||(this.restoreAtMark(e),null)},n.prototype._parsePrio=function(){if(!this.peek(d.Exclamation))return null;var e=this.createNode(u.Prio);return this.accept(d.Exclamation)&&this.acceptIdent("important")?this.finish(e):null},n.prototype._parseExpr=function(e){e===void 0&&(e=!1);var t=this.create(un);if(!t.addChild(this._parseBinaryExpr()))return null;for(;;){if(this.peek(d.Comma)){if(e)return this.finish(t);this.consumeToken()}else if(!this.hasWhitespace())break;if(!t.addChild(this._parseBinaryExpr()))break}return this.finish(t)},n.prototype._parseUnicodeRange=function(){if(!this.peekIdent("u"))return null;var e=this.create(li);return this.acceptUnicodeRange()?this.finish(e):null},n.prototype._parseNamedLine=function(){if(!this.peek(d.BracketL))return null;var e=this.createNode(u.GridLine);for(this.consumeToken();e.addChild(this._parseIdent()););return this.accept(d.BracketR)?this.finish(e):this.finish(e,f.RightSquareBracketExpected)},n.prototype._parseBinaryExpr=function(e,t){var r=this.create(pt);if(!r.setLeft(e||this._parseTerm()))return null;if(!r.setOperator(t||this._parseOperator()))return this.finish(r);if(!r.setRight(this._parseTerm()))return this.finish(r,f.TermExpected);r=this.finish(r);var i=this._parseOperator();return i&&(r=this._parseBinaryExpr(r,i)),this.finish(r)},n.prototype._parseTerm=function(){var e=this.create(Di);return e.setOperator(this._parseUnaryOperator()),e.setExpression(this._parseTermExpression())?this.finish(e):null},n.prototype._parseTermExpression=function(){return this._parseURILiteral()||this._parseUnicodeRange()||this._parseFunction()||this._parseIdent()||this._parseStringLiteral()||this._parseNumeric()||this._parseHexColor()||this._parseOperation()||this._parseNamedLine()},n.prototype._parseOperation=function(){if(!this.peek(d.ParenthesisL))return null;var e=this.create(F);return this.consumeToken(),e.addChild(this._parseExpr()),this.accept(d.ParenthesisR)?this.finish(e):this.finish(e,f.RightParenthesisExpected)},n.prototype._parseNumeric=function(){if(this.peek(d.Num)||this.peek(d.Percentage)||this.peek(d.Resolution)||this.peek(d.Length)||this.peek(d.EMS)||this.peek(d.EXS)||this.peek(d.Angle)||this.peek(d.Time)||this.peek(d.Dimension)||this.peek(d.Freq)){var e=this.create(Rt);return this.consumeToken(),this.finish(e)}return null},n.prototype._parseStringLiteral=function(){if(!this.peek(d.String)&&!this.peek(d.BadString))return null;var e=this.createNode(u.StringLiteral);return this.consumeToken(),this.finish(e)},n.prototype._parseURILiteral=function(){if(!this.peekRegExp(d.Ident,/^url(-prefix)?$/i))return null;var e=this.mark(),t=this.createNode(u.URILiteral);return this.accept(d.Ident),this.hasWhitespace()||!this.peek(d.ParenthesisL)?(this.restoreAtMark(e),null):(this.scanner.inURL=!0,this.consumeToken(),t.addChild(this._parseURLArgument()),this.scanner.inURL=!1,this.accept(d.ParenthesisR)?this.finish(t):this.finish(t,f.RightParenthesisExpected))},n.prototype._parseURLArgument=function(){var e=this.create(F);return!this.accept(d.String)&&!this.accept(d.BadString)&&!this.acceptUnquotedString()?null:this.finish(e)},n.prototype._parseIdent=function(e){if(!this.peek(d.Ident))return null;var t=this.create(te);return e&&(t.referenceTypes=e),t.isCustomProperty=this.peekRegExp(d.Ident,/^--/),this.consumeToken(),this.finish(t)},n.prototype._parseFunction=function(){var e=this.mark(),t=this.create(Pe);if(!t.setIdentifier(this._parseFunctionIdentifier()))return null;if(this.hasWhitespace()||!this.accept(d.ParenthesisL))return this.restoreAtMark(e),null;if(t.getArguments().addChild(this._parseFunctionArgument()))for(;this.accept(d.Comma)&&!this.peek(d.ParenthesisR);)t.getArguments().addChild(this._parseFunctionArgument())||this.markError(t,f.ExpressionExpected);return this.accept(d.ParenthesisR)?this.finish(t):this.finish(t,f.RightParenthesisExpected)},n.prototype._parseFunctionIdentifier=function(){if(!this.peek(d.Ident))return null;var e=this.create(te);if(e.referenceTypes=[A.Function],this.acceptIdent("progid")){if(this.accept(d.Colon))for(;this.accept(d.Ident)&&this.acceptDelim("."););return this.finish(e)}return this.consumeToken(),this.finish(e)},n.prototype._parseFunctionArgument=function(){var e=this.create(we);return e.setValue(this._parseExpr(!0))?this.finish(e):null},n.prototype._parseHexColor=function(){if(this.peekRegExp(d.Hash,/^#([A-Fa-f0-9]{3}|[A-Fa-f0-9]{4}|[A-Fa-f0-9]{6}|[A-Fa-f0-9]{8})$/g)){var e=this.create(zt);return this.consumeToken(),this.finish(e)}else return null},n}();function yo(n,e){var t=0,r=n.length;if(r===0)return 0;for(;t<r;){var i=Math.floor((t+r)/2);e(n[i])?r=i:t=i+1}return t}function Fr(n,e){return n.indexOf(e)!==-1}function $t(){for(var n=[],e=0;e<arguments.length;e++)n[e]=arguments[e];for(var t=[],r=0,i=n;r<i.length;r++)for(var o=i[r],s=0,a=o;s<a.length;s++){var l=a[s];Fr(t,l)||t.push(l)}return t}var Ys=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,i){r.__proto__=i}||function(r,i){for(var o in i)Object.prototype.hasOwnProperty.call(i,o)&&(r[o]=i[o])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),wo=function(){function n(e,t){this.offset=e,this.length=t,this.symbols=[],this.parent=null,this.children=[]}return n.prototype.addChild=function(e){this.children.push(e),e.setParent(this)},n.prototype.setParent=function(e){this.parent=e},n.prototype.findScope=function(e,t){return t===void 0&&(t=0),this.offset<=e&&this.offset+this.length>e+t||this.offset===e&&this.length===t?this.findInScope(e,t):null},n.prototype.findInScope=function(e,t){t===void 0&&(t=0);var r=e+t,i=yo(this.children,function(s){return s.offset>r});if(i===0)return this;var o=this.children[i-1];return o.offset<=e&&o.offset+o.length>=e+t?o.findInScope(e,t):this},n.prototype.addSymbol=function(e){this.symbols.push(e)},n.prototype.getSymbol=function(e,t){for(var r=0;r<this.symbols.length;r++){var i=this.symbols[r];if(i.name===e&&i.type===t)return i}return null},n.prototype.getSymbols=function(){return this.symbols},n}();var Qs=function(n){Ys(e,n);function e(){return n.call(this,0,Number.MAX_VALUE)||this}return e}(wo);var Fn=function(){function n(e,t,r,i){this.name=e,this.value=t,this.node=r,this.type=i}return n}();var Zs=function(){function n(e){this.scope=e}return n.prototype.addSymbol=function(e,t,r,i){if(e.offset!==-1){var o=this.scope.findScope(e.offset,e.length);o&&o.addSymbol(new Fn(t,r,e,i))}},n.prototype.addScope=function(e){if(e.offset!==-1){var t=this.scope.findScope(e.offset,e.length);if(t&&(t.offset!==e.offset||t.length!==e.length)){var r=new wo(e.offset,e.length);return t.addChild(r),r}return t}return null},n.prototype.addSymbolToChildScope=function(e,t,r,i,o){if(e&&e.offset!==-1){var s=this.addScope(e);s&&s.addSymbol(new Fn(r,i,t,o))}},n.prototype.visitNode=function(e){switch(e.type){case u.Keyframe:return this.addSymbol(e,e.getName(),void 0,A.Keyframe),!0;case u.CustomPropertyDeclaration:return this.visitCustomPropertyDeclarationNode(e);case u.VariableDeclaration:return this.visitVariableDeclarationNode(e);case u.Ruleset:return this.visitRuleSet(e);case u.MixinDeclaration:return this.addSymbol(e,e.getName(),void 0,A.Mixin),!0;case u.FunctionDeclaration:return this.addSymbol(e,e.getName(),void 0,A.Function),!0;case u.FunctionParameter:return this.visitFunctionParameterNode(e);case u.Declarations:return this.addScope(e),!0;case u.For:var t=e,r=t.getDeclarations();return r&&t.variable&&this.addSymbolToChildScope(r,t.variable,t.variable.getName(),void 0,A.Variable),!0;case u.Each:{var i=e,o=i.getDeclarations();if(o)for(var s=i.getVariables().getChildren(),a=0,l=s;a<l.length;a++){var c=l[a];this.addSymbolToChildScope(o,c,c.getName(),void 0,A.Variable)}return!0}}return!0},n.prototype.visitRuleSet=function(e){var t=this.scope.findScope(e.offset,e.length);if(t)for(var r=0,i=e.getSelectors().getChildren();r<i.length;r++){var o=i[r];o instanceof Ee&&o.getChildren().length===1&&t.addSymbol(new Fn(o.getChild(0).getText(),void 0,o,A.Rule))}return!0},n.prototype.visitVariableDeclarationNode=function(e){var t=e.getValue()?e.getValue().getText():void 0;return this.addSymbol(e,e.getName(),t,A.Variable),!0},n.prototype.visitFunctionParameterNode=function(e){var t=e.getParent().getDeclarations();if(t){var r=e.getDefaultValue(),i=r?r.getText():void 0;this.addSymbolToChildScope(t,e,e.getName(),i,A.Variable)}return!0},n.prototype.visitCustomPropertyDeclarationNode=function(e){var t=e.getValue()?e.getValue().getText():"";return this.addCSSVariable(e.getProperty(),e.getProperty().getName(),t,A.Variable),!0},n.prototype.addCSSVariable=function(e,t,r,i){e.offset!==-1&&this.scope.addSymbol(new Fn(t,r,e,i))},n}();var qt=function(){function n(e){this.global=new Qs,e.acceptVisitor(new Zs(this.global))}return n.prototype.findSymbolsAtOffset=function(e,t){for(var r=this.global.findScope(e,0),i=[],o={};r;){for(var s=r.getSymbols(),a=0;a<s.length;a++){var l=s[a];l.type===t&&!o[l.name]&&(i.push(l),o[l.name]=!0)}r=r.parent}return i},n.prototype.internalFindSymbol=function(e,t){var r=e;if(e.parent instanceof Be&&e.parent.getParent()instanceof K&&(r=e.parent.getParent().getDeclarations()),e.parent instanceof we&&e.parent.getParent()instanceof Pe){var i=e.parent.getParent().getIdentifier();if(i){var o=this.internalFindSymbol(i,[A.Function]);o&&(r=o.node.getDeclarations())}}if(!r)return null;for(var s=e.getText(),a=this.global.findScope(r.offset,r.length);a;){for(var l=0;l<t.length;l++){var c=t[l],h=a.getSymbol(s,c);if(h)return h}a=a.parent}return null},n.prototype.evaluateReferenceTypes=function(e){if(e instanceof te){var t=e.referenceTypes;if(t)return t;if(e.isCustomProperty)return[A.Variable];var r=ai(e);if(r){var i=r.getNonPrefixedPropertyName();if((i==="animation"||i==="animation-name")&&r.getValue()&&r.getValue().offset===e.offset)return[A.Keyframe]}}else if(e instanceof ut)return[A.Variable];var o=e.findAParent(u.Selector,u.ExtendsReference);return o?[A.Rule]:null},n.prototype.findSymbolFromNode=function(e){if(!e)return null;for(;e.type===u.Interpolation;)e=e.getParent();var t=this.evaluateReferenceTypes(e);return t?this.internalFindSymbol(e,t):null},n.prototype.matchesSymbol=function(e,t){if(!e)return!1;for(;e.type===u.Interpolation;)e=e.getParent();if(!e.matches(t.name))return!1;var r=this.evaluateReferenceTypes(e);if(!r||r.indexOf(t.type)===-1)return!1;var i=this.internalFindSymbol(e,r);return i===t},n.prototype.findSymbol=function(e,t,r){for(var i=this.global.findScope(r);i;){var o=i.getSymbol(e,t);if(o)return o;i=i.parent}return null},n}();var xo;xo=(()=>{"use strict";var n={470:r=>{function i(a){if(typeof a!="string")throw new TypeError("Path must be a string. Received "+JSON.stringify(a))}function o(a,l){for(var c,h="",p=0,m=-1,g=0,w=0;w<=a.length;++w){if(w<a.length)c=a.charCodeAt(w);else{if(c===47)break;c=47}if(c===47){if(!(m===w-1||g===1))if(m!==w-1&&g===2){if(h.length<2||p!==2||h.charCodeAt(h.length-1)!==46||h.charCodeAt(h.length-2)!==46){if(h.length>2){var x=h.lastIndexOf("/");if(x!==h.length-1){x===-1?(h="",p=0):p=(h=h.slice(0,x)).length-1-h.lastIndexOf("/"),m=w,g=0;continue}}else if(h.length===2||h.length===1){h="",p=0,m=w,g=0;continue}}l&&(h.length>0?h+="/..":h="..",p=2)}else h.length>0?h+="/"+a.slice(m+1,w):h=a.slice(m+1,w),p=w-m-1;m=w,g=0}else c===46&&g!==-1?++g:g=-1}return h}var s={resolve:function(){for(var a,l="",c=!1,h=arguments.length-1;h>=-1&&!c;h--){var p;h>=0?p=arguments[h]:(a===void 0&&(a=process.cwd()),p=a),i(p),p.length!==0&&(l=p+"/"+l,c=p.charCodeAt(0)===47)}return l=o(l,!c),c?l.length>0?"/"+l:"/":l.length>0?l:"."},normalize:function(a){if(i(a),a.length===0)return".";var l=a.charCodeAt(0)===47,c=a.charCodeAt(a.length-1)===47;return(a=o(a,!l)).length!==0||l||(a="."),a.length>0&&c&&(a+="/"),l?"/"+a:a},isAbsolute:function(a){return i(a),a.length>0&&a.charCodeAt(0)===47},join:function(){if(arguments.length===0)return".";for(var a,l=0;l<arguments.length;++l){var c=arguments[l];i(c),c.length>0&&(a===void 0?a=c:a+="/"+c)}return a===void 0?".":s.normalize(a)},relative:function(a,l){if(i(a),i(l),a===l||(a=s.resolve(a))===(l=s.resolve(l)))return"";for(var c=1;c<a.length&&a.charCodeAt(c)===47;++c);for(var h=a.length,p=h-c,m=1;m<l.length&&l.charCodeAt(m)===47;++m);for(var g=l.length-m,w=p<g?p:g,x=-1,y=0;y<=w;++y){if(y===w){if(g>w){if(l.charCodeAt(m+y)===47)return l.slice(m+y+1);if(y===0)return l.slice(m+y)}else p>w&&(a.charCodeAt(c+y)===47?x=y:y===0&&(x=0));break}var D=a.charCodeAt(c+y);if(D!==l.charCodeAt(m+y))break;D===47&&(x=y)}var M="";for(y=c+x+1;y<=h;++y)y!==h&&a.charCodeAt(y)!==47||(M.length===0?M+="..":M+="/..");return M.length>0?M+l.slice(m+x):(m+=x,l.charCodeAt(m)===47&&++m,l.slice(m))},_makeLong:function(a){return a},dirname:function(a){if(i(a),a.length===0)return".";for(var l=a.charCodeAt(0),c=l===47,h=-1,p=!0,m=a.length-1;m>=1;--m)if((l=a.charCodeAt(m))===47){if(!p){h=m;break}}else p=!1;return h===-1?c?"/":".":c&&h===1?"//":a.slice(0,h)},basename:function(a,l){if(l!==void 0&&typeof l!="string")throw new TypeError('"ext" argument must be a string');i(a);var c,h=0,p=-1,m=!0;if(l!==void 0&&l.length>0&&l.length<=a.length){if(l.length===a.length&&l===a)return"";var g=l.length-1,w=-1;for(c=a.length-1;c>=0;--c){var x=a.charCodeAt(c);if(x===47){if(!m){h=c+1;break}}else w===-1&&(m=!1,w=c+1),g>=0&&(x===l.charCodeAt(g)?--g==-1&&(p=c):(g=-1,p=w))}return h===p?p=w:p===-1&&(p=a.length),a.slice(h,p)}for(c=a.length-1;c>=0;--c)if(a.charCodeAt(c)===47){if(!m){h=c+1;break}}else p===-1&&(m=!1,p=c+1);return p===-1?"":a.slice(h,p)},extname:function(a){i(a);for(var l=-1,c=0,h=-1,p=!0,m=0,g=a.length-1;g>=0;--g){var w=a.charCodeAt(g);if(w!==47)h===-1&&(p=!1,h=g+1),w===46?l===-1?l=g:m!==1&&(m=1):l!==-1&&(m=-1);else if(!p){c=g+1;break}}return l===-1||h===-1||m===0||m===1&&l===h-1&&l===c+1?"":a.slice(l,h)},format:function(a){if(a===null||typeof a!="object")throw new TypeError('The "pathObject" argument must be of type Object. Received type '+typeof a);return function(l,c){var h=c.dir||c.root,p=c.base||(c.name||"")+(c.ext||"");return h?h===c.root?h+p:h+"/"+p:p}(0,a)},parse:function(a){i(a);var l={root:"",dir:"",base:"",ext:"",name:""};if(a.length===0)return l;var c,h=a.charCodeAt(0),p=h===47;p?(l.root="/",c=1):c=0;for(var m=-1,g=0,w=-1,x=!0,y=a.length-1,D=0;y>=c;--y)if((h=a.charCodeAt(y))!==47)w===-1&&(x=!1,w=y+1),h===46?m===-1?m=y:D!==1&&(D=1):m!==-1&&(D=-1);else if(!x){g=y+1;break}return m===-1||w===-1||D===0||D===1&&m===w-1&&m===g+1?w!==-1&&(l.base=l.name=g===0&&p?a.slice(1,w):a.slice(g,w)):(g===0&&p?(l.name=a.slice(1,m),l.base=a.slice(1,w)):(l.name=a.slice(g,m),l.base=a.slice(g,w)),l.ext=a.slice(m,w)),g>0?l.dir=a.slice(0,g-1):p&&(l.dir="/"),l},sep:"/",delimiter:":",win32:null,posix:null};s.posix=s,r.exports=s},447:(r,i,o)=>{var s;if(o.r(i),o.d(i,{URI:()=>M,Utils:()=>pe}),typeof process=="object")s=process.platform==="win32";else if(typeof navigator=="object"){var a=navigator.userAgent;s=a.indexOf("Windows")>=0}var l,c,h=(l=function(C,b){return(l=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,_){k.__proto__=_}||function(k,_){for(var N in _)Object.prototype.hasOwnProperty.call(_,N)&&(k[N]=_[N])})(C,b)},function(C,b){if(typeof b!="function"&&b!==null)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");function k(){this.constructor=C}l(C,b),C.prototype=b===null?Object.create(b):(k.prototype=b.prototype,new k)}),p=/^\w[\w\d+.-]*$/,m=/^\//,g=/^\/\//;function w(C,b){if(!C.scheme&&b)throw new Error('[UriError]: Scheme is missing: {scheme: "", authority: "'.concat(C.authority,'", path: "').concat(C.path,'", query: "').concat(C.query,'", fragment: "').concat(C.fragment,'"}'));if(C.scheme&&!p.test(C.scheme))throw new Error("[UriError]: Scheme contains illegal characters.");if(C.path){if(C.authority){if(!m.test(C.path))throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character')}else if(g.test(C.path))throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")')}}var x="",y="/",D=/^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/,M=function(){function C(b,k,_,N,O,B){B===void 0&&(B=!1),typeof b=="object"?(this.scheme=b.scheme||x,this.authority=b.authority||x,this.path=b.path||x,this.query=b.query||x,this.fragment=b.fragment||x):(this.scheme=function(Ce,se){return Ce||se?Ce:"file"}(b,B),this.authority=k||x,this.path=function(Ce,se){switch(Ce){case"https":case"http":case"file":se?se[0]!==y&&(se=y+se):se=y}return se}(this.scheme,_||x),this.query=N||x,this.fragment=O||x,w(this,B))}return C.isUri=function(b){return b instanceof C||!!b&&typeof b.authority=="string"&&typeof b.fragment=="string"&&typeof b.path=="string"&&typeof b.query=="string"&&typeof b.scheme=="string"&&typeof b.fsPath=="string"&&typeof b.with=="function"&&typeof b.toString=="function"},Object.defineProperty(C.prototype,"fsPath",{get:function(){return oe(this,!1)},enumerable:!1,configurable:!0}),C.prototype.with=function(b){if(!b)return this;var k=b.scheme,_=b.authority,N=b.path,O=b.query,B=b.fragment;return k===void 0?k=this.scheme:k===null&&(k=x),_===void 0?_=this.authority:_===null&&(_=x),N===void 0?N=this.path:N===null&&(N=x),O===void 0?O=this.query:O===null&&(O=x),B===void 0?B=this.fragment:B===null&&(B=x),k===this.scheme&&_===this.authority&&N===this.path&&O===this.query&&B===this.fragment?this:new P(k,_,N,O,B)},C.parse=function(b,k){k===void 0&&(k=!1);var _=D.exec(b);return _?new P(_[2]||x,ke(_[4]||x),ke(_[5]||x),ke(_[7]||x),ke(_[9]||x),k):new P(x,x,x,x,x)},C.file=function(b){var k=x;if(s&&(b=b.replace(/\\/g,y)),b[0]===y&&b[1]===y){var _=b.indexOf(y,2);_===-1?(k=b.substring(2),b=y):(k=b.substring(2,_),b=b.substring(_)||y)}return new P("file",k,b,x,x)},C.from=function(b){var k=new P(b.scheme,b.authority,b.path,b.query,b.fragment);return w(k,!0),k},C.prototype.toString=function(b){return b===void 0&&(b=!1),me(this,b)},C.prototype.toJSON=function(){return this},C.revive=function(b){if(b){if(b instanceof C)return b;var k=new P(b);return k._formatted=b.external,k._fsPath=b._sep===z?b.fsPath:null,k}return b},C}(),z=s?1:void 0,P=function(C){function b(){var k=C!==null&&C.apply(this,arguments)||this;return k._formatted=null,k._fsPath=null,k}return h(b,C),Object.defineProperty(b.prototype,"fsPath",{get:function(){return this._fsPath||(this._fsPath=oe(this,!1)),this._fsPath},enumerable:!1,configurable:!0}),b.prototype.toString=function(k){return k===void 0&&(k=!1),k?me(this,!0):(this._formatted||(this._formatted=me(this,!1)),this._formatted)},b.prototype.toJSON=function(){var k={$mid:1};return this._fsPath&&(k.fsPath=this._fsPath,k._sep=z),this._formatted&&(k.external=this._formatted),this.path&&(k.path=this.path),this.scheme&&(k.scheme=this.scheme),this.authority&&(k.authority=this.authority),this.query&&(k.query=this.query),this.fragment&&(k.fragment=this.fragment),k},b}(M),L=((c={})[58]="%3A",c[47]="%2F",c[63]="%3F",c[35]="%23",c[91]="%5B",c[93]="%5D",c[64]="%40",c[33]="%21",c[36]="%24",c[38]="%26",c[39]="%27",c[40]="%28",c[41]="%29",c[42]="%2A",c[43]="%2B",c[44]="%2C",c[59]="%3B",c[61]="%3D",c[32]="%20",c);function $(C,b){for(var k=void 0,_=-1,N=0;N<C.length;N++){var O=C.charCodeAt(N);if(O>=97&&O<=122||O>=65&&O<=90||O>=48&&O<=57||O===45||O===46||O===95||O===126||b&&O===47)_!==-1&&(k+=encodeURIComponent(C.substring(_,N)),_=-1),k!==void 0&&(k+=C.charAt(N));else{k===void 0&&(k=C.substr(0,N));var B=L[O];B!==void 0?(_!==-1&&(k+=encodeURIComponent(C.substring(_,N)),_=-1),k+=B):_===-1&&(_=N)}}return _!==-1&&(k+=encodeURIComponent(C.substring(_))),k!==void 0?k:C}function ue(C){for(var b=void 0,k=0;k<C.length;k++){var _=C.charCodeAt(k);_===35||_===63?(b===void 0&&(b=C.substr(0,k)),b+=L[_]):b!==void 0&&(b+=C[k])}return b!==void 0?b:C}function oe(C,b){var k;return k=C.authority&&C.path.length>1&&C.scheme==="file"?"//".concat(C.authority).concat(C.path):C.path.charCodeAt(0)===47&&(C.path.charCodeAt(1)>=65&&C.path.charCodeAt(1)<=90||C.path.charCodeAt(1)>=97&&C.path.charCodeAt(1)<=122)&&C.path.charCodeAt(2)===58?b?C.path.substr(1):C.path[1].toLowerCase()+C.path.substr(2):C.path,s&&(k=k.replace(/\//g,"\\")),k}function me(C,b){var k=b?ue:$,_="",N=C.scheme,O=C.authority,B=C.path,Ce=C.query,se=C.fragment;if(N&&(_+=N,_+=":"),(O||N==="file")&&(_+=y,_+=y),O){var ge=O.indexOf("@");if(ge!==-1){var Xe=O.substr(0,ge);O=O.substr(ge+1),(ge=Xe.indexOf(":"))===-1?_+=k(Xe,!1):(_+=k(Xe.substr(0,ge),!1),_+=":",_+=k(Xe.substr(ge+1),!1)),_+="@"}(ge=(O=O.toLowerCase()).indexOf(":"))===-1?_+=k(O,!1):(_+=k(O.substr(0,ge),!1),_+=O.substr(ge))}if(B){if(B.length>=3&&B.charCodeAt(0)===47&&B.charCodeAt(2)===58)(Me=B.charCodeAt(1))>=65&&Me<=90&&(B="/".concat(String.fromCharCode(Me+32),":").concat(B.substr(3)));else if(B.length>=2&&B.charCodeAt(1)===58){var Me;(Me=B.charCodeAt(0))>=65&&Me<=90&&(B="".concat(String.fromCharCode(Me+32),":").concat(B.substr(2)))}_+=k(B,!0)}return Ce&&(_+="?",_+=k(Ce,!1)),se&&(_+="#",_+=b?se:$(se,!1)),_}function ve(C){try{return decodeURIComponent(C)}catch{return C.length>3?C.substr(0,3)+ve(C.substr(3)):C}}var ye=/(%[0-9A-Za-z][0-9A-Za-z])+/g;function ke(C){return C.match(ye)?C.replace(ye,function(b){return ve(b)}):C}var pe,G=o(470),Ie=function(C,b,k){if(k||arguments.length===2)for(var _,N=0,O=b.length;N<O;N++)!_&&N in b||(_||(_=Array.prototype.slice.call(b,0,N)),_[N]=b[N]);return C.concat(_||Array.prototype.slice.call(b))},fe=G.posix||G;(function(C){C.joinPath=function(b){for(var k=[],_=1;_<arguments.length;_++)k[_-1]=arguments[_];return b.with({path:fe.join.apply(fe,Ie([b.path],k,!1))})},C.resolvePath=function(b){for(var k=[],_=1;_<arguments.length;_++)k[_-1]=arguments[_];var N=b.path||"/";return b.with({path:fe.resolve.apply(fe,Ie([N],k,!1))})},C.dirname=function(b){var k=fe.dirname(b.path);return k.length===1&&k.charCodeAt(0)===46?b:b.with({path:k})},C.basename=function(b){return fe.basename(b.path)},C.extname=function(b){return fe.extname(b.path)}})(pe||(pe={}))}},e={};function t(r){if(e[r])return e[r].exports;var i=e[r]={exports:{}};return n[r](i,i.exports,t),i.exports}return t.d=(r,i)=>{for(var o in i)t.o(i,o)&&!t.o(r,o)&&Object.defineProperty(r,o,{enumerable:!0,get:i[o]})},t.o=(r,i)=>Object.prototype.hasOwnProperty.call(r,i),t.r=r=>{typeof Symbol<"u"&&Symbol.toStringTag&&Object.defineProperty(r,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(r,"__esModule",{value:!0})},t(447)})();var{URI:Kt,Utils:En}=xo;var ea=function(n,e,t){if(t||arguments.length===2)for(var r=0,i=e.length,o;r<i;r++)(o||!(r in e))&&(o||(o=Array.prototype.slice.call(e,0,r)),o[r]=e[r]);return n.concat(o||Array.prototype.slice.call(e))};function Dn(n){return En.dirname(Kt.parse(n)).toString()}function Gt(n){for(var e=[],t=1;t<arguments.length;t++)e[t-1]=arguments[t];return En.joinPath.apply(En,ea([Kt.parse(n)],e,!1)).toString()}var So=function(n,e,t,r){function i(o){return o instanceof t?o:new t(function(s){s(o)})}return new(t||(t=Promise))(function(o,s){function a(h){try{c(r.next(h))}catch(p){s(p)}}function l(h){try{c(r.throw(h))}catch(p){s(p)}}function c(h){h.done?o(h.value):i(h.value).then(a,l)}c((r=r.apply(n,e||[])).next())})},ko=function(n,e){var t={label:0,sent:function(){if(o[0]&1)throw o[1];return o[1]},trys:[],ops:[]},r,i,o,s;return s={next:a(0),throw:a(1),return:a(2)},typeof Symbol=="function"&&(s[Symbol.iterator]=function(){return this}),s;function a(c){return function(h){return l([c,h])}}function l(c){if(r)throw new TypeError("Generator is already executing.");for(;t;)try{if(r=1,i&&(o=c[0]&2?i.return:c[0]?i.throw||((o=i.return)&&o.call(i),0):i.next)&&!(o=o.call(i,c[1])).done)return o;switch(i=0,o&&(c=[c[0]&2,o.value]),c[0]){case 0:case 1:o=c;break;case 4:return t.label++,{value:c[1],done:!1};case 5:t.label++,i=c[1],c=[0];continue;case 7:c=t.ops.pop(),t.trys.pop();continue;default:if(o=t.trys,!(o=o.length>0&&o[o.length-1])&&(c[0]===6||c[0]===2)){t=0;continue}if(c[0]===3&&(!o||c[1]>o[0]&&c[1]<o[3])){t.label=c[1];break}if(c[0]===6&&t.label<o[1]){t.label=o[1],o=c;break}if(o&&t.label<o[2]){t.label=o[2],t.ops.push(c);break}o[2]&&t.ops.pop(),t.trys.pop();continue}c=e.call(n,t)}catch(h){c=[6,h],i=0}finally{r=o=0}if(c[0]&5)throw c[1];return{value:c[0]?c[1]:void 0,done:!0}}},Co=function(){function n(e){this.readDirectory=e,this.literalCompletions=[],this.importCompletions=[]}return n.prototype.onCssURILiteralValue=function(e){this.literalCompletions.push(e)},n.prototype.onCssImportPath=function(e){this.importCompletions.push(e)},n.prototype.computeCompletions=function(e,t){return So(this,void 0,void 0,function(){var r,i,o,s,a,x,l,c,h,z,p,m,g,w,x,y,D,M,z;return ko(this,function(P){switch(P.label){case 0:r={items:[],isIncomplete:!1},i=0,o=this.literalCompletions,P.label=1;case 1:return i<o.length?(s=o[i],a=s.uriValue,x=Er(a),x==="."||x===".."?(r.isIncomplete=!0,[3,4]):[3,2]):[3,5];case 2:return[4,this.providePathSuggestions(a,s.position,s.range,e,t)];case 3:for(l=P.sent(),c=0,h=l;c<h.length;c++)z=h[c],r.items.push(z);P.label=4;case 4:return i++,[3,1];case 5:p=0,m=this.importCompletions,P.label=6;case 6:return p<m.length?(g=m[p],w=g.pathValue,x=Er(w),x==="."||x===".."?(r.isIncomplete=!0,[3,9]):[3,7]):[3,10];case 7:return[4,this.providePathSuggestions(w,g.position,g.range,e,t)];case 8:for(y=P.sent(),e.languageId==="scss"&&y.forEach(function(L){q(L.label,"_")&&on(L.label,".scss")&&(L.textEdit?L.textEdit.newText=L.label.slice(1,-5):L.label=L.label.slice(1,-5))}),D=0,M=y;D<M.length;D++)z=M[D],r.items.push(z);P.label=9;case 9:return p++,[3,6];case 10:return[2,r]}})})},n.prototype.providePathSuggestions=function(e,t,r,i,o){return So(this,void 0,void 0,function(){var s,a,l,c,h,p,m,g,w,x,y,D,M,z,P,L;return ko(this,function($){switch($.label){case 0:if(s=Er(e),a=q(e,"'")||q(e,'"'),l=a?s.slice(0,t.character-(r.start.character+1)):s.slice(0,t.character-r.start.character),c=i.uri,h=a?ia(r,1,-1):r,p=na(l,s,h),m=l.substring(0,l.lastIndexOf("/")+1),g=o.resolveReference(m||".",c),!g)return[3,4];$.label=1;case 1:return $.trys.push([1,3,,4]),w=[],[4,this.readDirectory(g)];case 2:for(x=$.sent(),y=0,D=x;y<D.length;y++)M=D[y],z=M[0],P=M[1],z.charCodeAt(0)!==ta&&(P===it.Directory||Gt(g,z)!==c)&&w.push(ra(z,P===it.Directory,p));return[2,w];case 3:return L=$.sent(),[3,4];case 4:return[2,[]]}})})},n}();var ta=".".charCodeAt(0);function Er(n){return q(n,"'")||q(n,'"')?n.slice(1,-1):n}function na(n,e,t){var r,i=n.lastIndexOf("/");if(i===-1)r=t;else{var o=e.slice(i+1),s=Rn(t.end,-o.length),a=o.indexOf(" "),l=void 0;a!==-1?l=Rn(s,a):l=t.end,r=W.create(s,l)}return r}function ra(n,e,t){return e?(n=n+"/",{label:zn(n),kind:R.Folder,textEdit:T.replace(t,zn(n)),command:{title:"Suggest",command:"editor.action.triggerSuggest"}}):{label:zn(n),kind:R.File,textEdit:T.replace(t,zn(n))}}function zn(n){return n.replace(/(\s|\(|\)|,|"|')/g,"\\$1")}function Rn(n,e){return Q.create(n.line,n.character+e)}function ia(n,e,t){var r=Rn(n.start,e),i=Rn(n.end,t);return W.create(r,i)}var oa=function(n,e,t,r){function i(o){return o instanceof t?o:new t(function(s){s(o)})}return new(t||(t=Promise))(function(o,s){function a(h){try{c(r.next(h))}catch(p){s(p)}}function l(h){try{c(r.throw(h))}catch(p){s(p)}}function c(h){h.done?o(h.value):i(h.value).then(a,l)}c((r=r.apply(n,e||[])).next())})},sa=function(n,e){var t={label:0,sent:function(){if(o[0]&1)throw o[1];return o[1]},trys:[],ops:[]},r,i,o,s;return s={next:a(0),throw:a(1),return:a(2)},typeof Symbol=="function"&&(s[Symbol.iterator]=function(){return this}),s;function a(c){return function(h){return l([c,h])}}function l(c){if(r)throw new TypeError("Generator is already executing.");for(;t;)try{if(r=1,i&&(o=c[0]&2?i.return:c[0]?i.throw||((o=i.return)&&o.call(i),0):i.next)&&!(o=o.call(i,c[1])).done)return o;switch(i=0,o&&(c=[c[0]&2,o.value]),c[0]){case 0:case 1:o=c;break;case 4:return t.label++,{value:c[1],done:!1};case 5:t.label++,i=c[1],c=[0];continue;case 7:c=t.ops.pop(),t.trys.pop();continue;default:if(o=t.trys,!(o=o.length>0&&o[o.length-1])&&(c[0]===6||c[0]===2)){t=0;continue}if(c[0]===3&&(!o||c[1]>o[0]&&c[1]<o[3])){t.label=c[1];break}if(c[0]===6&&t.label<o[1]){t.label=o[1],o=c;break}if(o&&t.label<o[2]){t.label=o[2],t.ops.push(c);break}o[2]&&t.ops.pop(),t.trys.pop();continue}c=e.call(n,t)}catch(h){c=[6,h],i=0}finally{r=o=0}if(c[0]&5)throw c[1];return{value:c[0]?c[1]:void 0,done:!0}}},aa=H(),We=re.Snippet,_o={title:"Suggest",command:"editor.action.triggerSuggest"},Re;(function(n){n.Enums=" ",n.Normal="d",n.VendorPrefixed="x",n.Term="y",n.Variable="z"})(Re||(Re={}));var yt=function(){function n(e,t,r){e===void 0&&(e=null),this.variablePrefix=e,this.lsOptions=t,this.cssDataManager=r,this.completionParticipants=[]}return n.prototype.configure=function(e){this.defaultSettings=e},n.prototype.getSymbolContext=function(){return this.symbolContext||(this.symbolContext=new qt(this.styleSheet)),this.symbolContext},n.prototype.setCompletionParticipants=function(e){this.completionParticipants=e||[]},n.prototype.doComplete2=function(e,t,r,i,o){return o===void 0&&(o=this.defaultSettings),oa(this,void 0,void 0,function(){var s,a,l,c;return sa(this,function(h){switch(h.label){case 0:if(!this.lsOptions.fileSystemProvider||!this.lsOptions.fileSystemProvider.readDirectory)return[2,this.doComplete(e,t,r,o)];s=new Co(this.lsOptions.fileSystemProvider.readDirectory),a=this.completionParticipants,this.completionParticipants=[s].concat(a),l=this.doComplete(e,t,r,o),h.label=1;case 1:return h.trys.push([1,,3,4]),[4,s.computeCompletions(e,i)];case 2:return c=h.sent(),[2,{isIncomplete:l.isIncomplete||c.isIncomplete,items:c.items.concat(l.items)}];case 3:return this.completionParticipants=a,[7];case 4:return[2]}})})},n.prototype.doComplete=function(e,t,r,i){this.offset=e.offsetAt(t),this.position=t,this.currentWord=ha(e,this.offset),this.defaultReplaceRange=W.create(Q.create(this.position.line,this.position.character-this.currentWord.length),this.position),this.textDocument=e,this.styleSheet=r,this.documentSettings=i;try{var o={isIncomplete:!1,items:[]};this.nodePath=ct(this.styleSheet,this.offset);for(var s=this.nodePath.length-1;s>=0;s--){var a=this.nodePath[s];if(a instanceof dt)this.getCompletionsForDeclarationProperty(a.getParent(),o);else if(a instanceof un)a.parent instanceof It?this.getVariableProposals(null,o):this.getCompletionsForExpression(a,o);else if(a instanceof De){var l=a.findAParent(u.ExtendsReference,u.Ruleset);if(l)if(l.type===u.ExtendsReference)this.getCompletionsForExtendsReference(l,a,o);else{var c=l;this.getCompletionsForSelector(c,c&&c.isNested(),o)}}else if(a instanceof we)this.getCompletionsForFunctionArgument(a,a.getParent(),o);else if(a instanceof Et)this.getCompletionsForDeclarations(a,o);else if(a instanceof $e)this.getCompletionsForVariableDeclaration(a,o);else if(a instanceof Te)this.getCompletionsForRuleSet(a,o);else if(a instanceof It)this.getCompletionsForInterpolation(a,o);else if(a instanceof Qe)this.getCompletionsForFunctionDeclaration(a,o);else if(a instanceof et)this.getCompletionsForMixinReference(a,o);else if(a instanceof Pe)this.getCompletionsForFunctionArgument(null,a,o);else if(a instanceof Dt)this.getCompletionsForSupports(a,o);else if(a instanceof Ze)this.getCompletionsForSupportsCondition(a,o);else if(a instanceof qe)this.getCompletionsForExtendsReference(a,null,o);else if(a.type===u.URILiteral)this.getCompletionForUriLiteralValue(a,o);else if(a.parent===null)this.getCompletionForTopLevel(o);else if(a.type===u.StringLiteral&&this.isImportPathParent(a.parent.type))this.getCompletionForImportPath(a,o);else continue;if(o.items.length>0||this.offset>a.offset)return this.finalize(o)}return this.getCompletionsForStylesheet(o),o.items.length===0&&this.variablePrefix&&this.currentWord.indexOf(this.variablePrefix)===0&&this.getVariableProposals(null,o),this.finalize(o)}finally{this.position=null,this.currentWord=null,this.textDocument=null,this.styleSheet=null,this.symbolContext=null,this.defaultReplaceRange=null,this.nodePath=null}},n.prototype.isImportPathParent=function(e){return e===u.Import},n.prototype.finalize=function(e){return e},n.prototype.findInNodePath=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];for(var r=this.nodePath.length-1;r>=0;r--){var i=this.nodePath[r];if(e.indexOf(i.type)!==-1)return i}return null},n.prototype.getCompletionsForDeclarationProperty=function(e,t){return this.getPropertyProposals(e,t)},n.prototype.getPropertyProposals=function(e,t){var r=this,i=this.isTriggerPropertyValueCompletionEnabled,o=this.isCompletePropertyWithSemicolonEnabled,s=this.cssDataManager.getProperties();return s.forEach(function(a){var l,c,h=!1;e?(l=r.getCompletionRange(e.getProperty()),c=a.name,he(e.colonPosition)||(c+=": ",h=!0)):(l=r.getCompletionRange(null),c=a.name+": ",h=!0),!e&&o&&(c+="$0;"),e&&!e.semicolonPosition&&o&&r.offset>=r.textDocument.offsetAt(l.end)&&(c+="$0;");var p={label:a.name,documentation:ze(a,r.doesSupportMarkdown()),tags:Ht(a)?[Ne.Deprecated]:[],textEdit:T.replace(l,c),insertTextFormat:re.Snippet,kind:R.Property};a.restrictions||(h=!1),i&&h&&(p.command=_o);var m=typeof a.relevance=="number"?Math.min(Math.max(a.relevance,0),99):50,g=(255-m).toString(16),w=q(a.name,"-")?Re.VendorPrefixed:Re.Normal;p.sortText=w+"_"+g,t.items.push(p)}),this.completionParticipants.forEach(function(a){a.onCssProperty&&a.onCssProperty({propertyName:r.currentWord,range:r.defaultReplaceRange})}),t},Object.defineProperty(n.prototype,"isTriggerPropertyValueCompletionEnabled",{get:function(){var e,t;return(t=(e=this.documentSettings)===null||e===void 0?void 0:e.triggerPropertyValueCompletion)!==null&&t!==void 0?t:!0},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"isCompletePropertyWithSemicolonEnabled",{get:function(){var e,t;return(t=(e=this.documentSettings)===null||e===void 0?void 0:e.completePropertyWithSemicolon)!==null&&t!==void 0?t:!0},enumerable:!1,configurable:!0}),n.prototype.getCompletionsForDeclarationValue=function(e,t){for(var r=this,i=e.getFullPropertyName(),o=this.cssDataManager.getProperty(i),s=e.getValue()||null;s&&s.hasChildren();)s=s.findChildAtOffset(this.offset,!1);if(this.completionParticipants.forEach(function(w){w.onCssPropertyValue&&w.onCssPropertyValue({propertyName:i,propertyValue:r.currentWord,range:r.getCompletionRange(s)})}),o){if(o.restrictions)for(var a=0,l=o.restrictions;a<l.length;a++){var c=l[a];switch(c){case"color":this.getColorProposals(o,s,t);break;case"position":this.getPositionProposals(o,s,t);break;case"repeat":this.getRepeatStyleProposals(o,s,t);break;case"line-style":this.getLineStyleProposals(o,s,t);break;case"line-width":this.getLineWidthProposals(o,s,t);break;case"geometry-box":this.getGeometryBoxProposals(o,s,t);break;case"box":this.getBoxProposals(o,s,t);break;case"image":this.getImageProposals(o,s,t);break;case"timing-function":this.getTimingFunctionProposals(o,s,t);break;case"shape":this.getBasicShapeProposals(o,s,t);break}}this.getValueEnumProposals(o,s,t),this.getCSSWideKeywordProposals(o,s,t),this.getUnitProposals(o,s,t)}else for(var h=la(this.styleSheet,e),p=0,m=h.getEntries();p<m.length;p++){var g=m[p];t.items.push({label:g,textEdit:T.replace(this.getCompletionRange(s),g),kind:R.Value})}return this.getVariableProposals(s,t),this.getTermProposals(o,s,t),t},n.prototype.getValueEnumProposals=function(e,t,r){if(e.values)for(var i=0,o=e.values;i<o.length;i++){var s=o[i],a=s.name,l=void 0;if(on(a,")")){var c=a.lastIndexOf("(");c!==-1&&(a=a.substr(0,c)+"($1)",l=We)}var h=Re.Enums;q(s.name,"-")&&(h+=Re.VendorPrefixed);var p={label:s.name,documentation:ze(s,this.doesSupportMarkdown()),tags:Ht(e)?[Ne.Deprecated]:[],textEdit:T.replace(this.getCompletionRange(t),a),sortText:h,kind:R.Value,insertTextFormat:l};r.items.push(p)}return r},n.prototype.getCSSWideKeywordProposals=function(e,t,r){for(var i in xr)r.items.push({label:i,documentation:xr[i],textEdit:T.replace(this.getCompletionRange(t),i),kind:R.Value});for(var o in Sr){var s=vt(o);r.items.push({label:o,documentation:Sr[o],textEdit:T.replace(this.getCompletionRange(t),s),kind:R.Function,insertTextFormat:We,command:q(o,"var")?_o:void 0})}return r},n.prototype.getCompletionsForInterpolation=function(e,t){return this.offset>=e.offset+2&&this.getVariableProposals(null,t),t},n.prototype.getVariableProposals=function(e,t){for(var r=this.getSymbolContext().findSymbolsAtOffset(this.offset,A.Variable),i=0,o=r;i<o.length;i++){var s=o[i],a=q(s.name,"--")?"var(".concat(s.name,")"):s.name,l={label:s.name,documentation:s.value?Jn(s.value):s.value,textEdit:T.replace(this.getCompletionRange(e),a),kind:R.Variable,sortText:Re.Variable};if(typeof l.documentation=="string"&&Fo(l.documentation)&&(l.kind=R.Color),s.node.type===u.FunctionParameter){var c=s.node.getParent();c.type===u.MixinDeclaration&&(l.detail=aa("completion.argument","argument from '{0}'",c.getName()))}t.items.push(l)}return t},n.prototype.getVariableProposalsForCSSVarFunction=function(e){var t=new Dr;this.styleSheet.acceptVisitor(new da(t,this.offset));for(var r=this.getSymbolContext().findSymbolsAtOffset(this.offset,A.Variable),i=0,o=r;i<o.length;i++){var s=o[i];if(q(s.name,"--")){var a={label:s.name,documentation:s.value?Jn(s.value):s.value,textEdit:T.replace(this.getCompletionRange(null),s.name),kind:R.Variable};typeof a.documentation=="string"&&Fo(a.documentation)&&(a.kind=R.Color),e.items.push(a)}t.remove(s.name)}for(var l=0,c=t.getEntries();l<c.length;l++){var h=c[l];if(q(h,"--")){var a={label:h,textEdit:T.replace(this.getCompletionRange(null),h),kind:R.Variable};e.items.push(a)}}return e},n.prototype.getUnitProposals=function(e,t,r){var i="0";if(this.currentWord.length>0){var o=this.currentWord.match(/^-?\d[\.\d+]*/);o&&(i=o[0],r.isIncomplete=i.length===this.currentWord.length)}else this.currentWord.length===0&&(r.isIncomplete=!0);if(t&&t.parent&&t.parent.type===u.Term&&(t=t.getParent()),e.restrictions)for(var s=0,a=e.restrictions;s<a.length;s++){var l=a[s],c=Cn[l];if(c)for(var h=0,p=c;h<p.length;h++){var m=p[h],g=i+m;r.items.push({label:g,textEdit:T.replace(this.getCompletionRange(t),g),kind:R.Unit})}}return r},n.prototype.getCompletionRange=function(e){if(e&&e.offset<=this.offset&&this.offset<=e.end){var t=e.end!==-1?this.textDocument.positionAt(e.end):this.position,r=this.textDocument.positionAt(e.offset);if(r.line===t.line)return W.create(r,t)}return this.defaultReplaceRange},n.prototype.getColorProposals=function(e,t,r){for(var i in Vt)r.items.push({label:i,documentation:Vt[i],textEdit:T.replace(this.getCompletionRange(t),i),kind:R.Color});for(var i in mr)r.items.push({label:i,documentation:mr[i],textEdit:T.replace(this.getCompletionRange(t),i),kind:R.Value});var o=new Dr;this.styleSheet.acceptVisitor(new ca(o,this.offset));for(var s=0,a=o.getEntries();s<a.length;s++){var i=a[s];r.items.push({label:i,textEdit:T.replace(this.getCompletionRange(t),i),kind:R.Color})}for(var l=function(g){var w=1,x=function(D,M){return"${"+w+++":"+M+"}"},y=g.func.replace(/\[?\$(\w+)\]?/g,x);r.items.push({label:g.func.substr(0,g.func.indexOf("(")),detail:g.func,documentation:g.desc,textEdit:T.replace(c.getCompletionRange(t),y),insertTextFormat:We,kind:R.Function})},c=this,h=0,p=ao;h<p.length;h++){var m=p[h];l(m)}return r},n.prototype.getPositionProposals=function(e,t,r){for(var i in gr)r.items.push({label:i,documentation:gr[i],textEdit:T.replace(this.getCompletionRange(t),i),kind:R.Value});return r},n.prototype.getRepeatStyleProposals=function(e,t,r){for(var i in br)r.items.push({label:i,documentation:br[i],textEdit:T.replace(this.getCompletionRange(t),i),kind:R.Value});return r},n.prototype.getLineStyleProposals=function(e,t,r){for(var i in vr)r.items.push({label:i,documentation:vr[i],textEdit:T.replace(this.getCompletionRange(t),i),kind:R.Value});return r},n.prototype.getLineWidthProposals=function(e,t,r){for(var i=0,o=uo;i<o.length;i++){var s=o[i];r.items.push({label:s,textEdit:T.replace(this.getCompletionRange(t),s),kind:R.Value})}return r},n.prototype.getGeometryBoxProposals=function(e,t,r){for(var i in wr)r.items.push({label:i,documentation:wr[i],textEdit:T.replace(this.getCompletionRange(t),i),kind:R.Value});return r},n.prototype.getBoxProposals=function(e,t,r){for(var i in yr)r.items.push({label:i,documentation:yr[i],textEdit:T.replace(this.getCompletionRange(t),i),kind:R.Value});return r},n.prototype.getImageProposals=function(e,t,r){for(var i in kr){var o=vt(i);r.items.push({label:i,documentation:kr[i],textEdit:T.replace(this.getCompletionRange(t),o),kind:R.Function,insertTextFormat:i!==o?We:void 0})}return r},n.prototype.getTimingFunctionProposals=function(e,t,r){for(var i in Cr){var o=vt(i);r.items.push({label:i,documentation:Cr[i],textEdit:T.replace(this.getCompletionRange(t),o),kind:R.Function,insertTextFormat:i!==o?We:void 0})}return r},n.prototype.getBasicShapeProposals=function(e,t,r){for(var i in _r){var o=vt(i);r.items.push({label:i,documentation:_r[i],textEdit:T.replace(this.getCompletionRange(t),o),kind:R.Function,insertTextFormat:i!==o?We:void 0})}return r},n.prototype.getCompletionsForStylesheet=function(e){var t=this.styleSheet.findFirstChildBeforeOffset(this.offset);return t?t instanceof Te?this.getCompletionsForRuleSet(t,e):t instanceof Dt?this.getCompletionsForSupports(t,e):e:this.getCompletionForTopLevel(e)},n.prototype.getCompletionForTopLevel=function(e){var t=this;return this.cssDataManager.getAtDirectives().forEach(function(r){e.items.push({label:r.name,textEdit:T.replace(t.getCompletionRange(null),r.name),documentation:ze(r,t.doesSupportMarkdown()),tags:Ht(r)?[Ne.Deprecated]:[],kind:R.Keyword})}),this.getCompletionsForSelector(null,!1,e),e},n.prototype.getCompletionsForRuleSet=function(e,t){var r=e.getDeclarations(),i=r&&r.endsWith("}")&&this.offset>=r.end;if(i)return this.getCompletionForTopLevel(t);var o=!r||this.offset<=r.offset;return o?this.getCompletionsForSelector(e,e.isNested(),t):this.getCompletionsForDeclarations(e.getDeclarations(),t)},n.prototype.getCompletionsForSelector=function(e,t,r){var i=this,o=this.findInNodePath(u.PseudoSelector,u.IdentifierSelector,u.ClassSelector,u.ElementNameSelector);!o&&this.hasCharacterAtPosition(this.offset-this.currentWord.length-1,":")&&(this.currentWord=":"+this.currentWord,this.hasCharacterAtPosition(this.offset-this.currentWord.length-1,":")&&(this.currentWord=":"+this.currentWord),this.defaultReplaceRange=W.create(Q.create(this.position.line,this.position.character-this.currentWord.length),this.position));var s=this.cssDataManager.getPseudoClasses();s.forEach(function(y){var D=vt(y.name),M={label:y.name,textEdit:T.replace(i.getCompletionRange(o),D),documentation:ze(y,i.doesSupportMarkdown()),tags:Ht(y)?[Ne.Deprecated]:[],kind:R.Function,insertTextFormat:y.name!==D?We:void 0};q(y.name,":-")&&(M.sortText=Re.VendorPrefixed),r.items.push(M)});var a=this.cssDataManager.getPseudoElements();if(a.forEach(function(y){var D=vt(y.name),M={label:y.name,textEdit:T.replace(i.getCompletionRange(o),D),documentation:ze(y,i.doesSupportMarkdown()),tags:Ht(y)?[Ne.Deprecated]:[],kind:R.Function,insertTextFormat:y.name!==D?We:void 0};q(y.name,"::-")&&(M.sortText=Re.VendorPrefixed),r.items.push(M)}),!t){for(var l=0,c=mo;l<c.length;l++){var h=c[l];r.items.push({label:h,textEdit:T.replace(this.getCompletionRange(o),h),kind:R.Keyword})}for(var p=0,m=fo;p<m.length;p++){var h=m[p];r.items.push({label:h,textEdit:T.replace(this.getCompletionRange(o),h),kind:R.Keyword})}}var g={};g[this.currentWord]=!0;var w=this.textDocument.getText();if(this.styleSheet.accept(function(y){if(y.type===u.SimpleSelector&&y.length>0){var D=w.substr(y.offset,y.length);return D.charAt(0)==="."&&!g[D]&&(g[D]=!0,r.items.push({label:D,textEdit:T.replace(i.getCompletionRange(o),D),kind:R.Keyword})),!1}return!0}),e&&e.isNested()){var x=e.getSelectors().findFirstChildBeforeOffset(this.offset);x&&e.getSelectors().getChildren().indexOf(x)===0&&this.getPropertyProposals(null,r)}return r},n.prototype.getCompletionsForDeclarations=function(e,t){if(!e||this.offset===e.offset)return t;var r=e.findFirstChildBeforeOffset(this.offset);if(!r)return this.getCompletionsForDeclarationProperty(null,t);if(r instanceof an){var i=r;if(!he(i.colonPosition)||this.offset<=i.colonPosition)return this.getCompletionsForDeclarationProperty(i,t);if(he(i.semicolonPosition)&&i.semicolonPosition<this.offset)return this.offset===i.semicolonPosition+1?t:this.getCompletionsForDeclarationProperty(null,t);if(i instanceof ae)return this.getCompletionsForDeclarationValue(i,t)}else r instanceof qe?this.getCompletionsForExtendsReference(r,null,t):this.currentWord&&this.currentWord[0]==="@"?this.getCompletionsForDeclarationProperty(null,t):r instanceof Te&&this.getCompletionsForDeclarationProperty(null,t);return t},n.prototype.getCompletionsForVariableDeclaration=function(e,t){return this.offset&&he(e.colonPosition)&&this.offset>e.colonPosition&&this.getVariableProposals(e.getValue(),t),t},n.prototype.getCompletionsForExpression=function(e,t){var r=e.getParent();if(r instanceof we)return this.getCompletionsForFunctionArgument(r,r.getParent(),t),t;var i=e.findParent(u.Declaration);if(!i)return this.getTermProposals(void 0,null,t),t;var o=e.findChildAtOffset(this.offset,!0);return o?o instanceof Rt||o instanceof te?this.getCompletionsForDeclarationValue(i,t):t:this.getCompletionsForDeclarationValue(i,t)},n.prototype.getCompletionsForFunctionArgument=function(e,t,r){var i=t.getIdentifier();return i&&i.matches("var")&&(!t.getArguments().hasChildren()||t.getArguments().getChild(0)===e)&&this.getVariableProposalsForCSSVarFunction(r),r},n.prototype.getCompletionsForFunctionDeclaration=function(e,t){var r=e.getDeclarations();return r&&this.offset>r.offset&&this.offset<r.end&&this.getTermProposals(void 0,null,t),t},n.prototype.getCompletionsForMixinReference=function(e,t){for(var r=this,i=this.getSymbolContext().findSymbolsAtOffset(this.offset,A.Mixin),o=0,s=i;o<s.length;o++){var a=s[o];a.node instanceof Ae&&t.items.push(this.makeTermProposal(a,a.node.getParameters(),null))}var l=e.getIdentifier()||null;return this.completionParticipants.forEach(function(c){c.onCssMixinReference&&c.onCssMixinReference({mixinName:r.currentWord,range:r.getCompletionRange(l)})}),t},n.prototype.getTermProposals=function(e,t,r){for(var i=this.getSymbolContext().findSymbolsAtOffset(this.offset,A.Function),o=0,s=i;o<s.length;o++){var a=s[o];a.node instanceof Qe&&r.items.push(this.makeTermProposal(a,a.node.getParameters(),t))}return r},n.prototype.makeTermProposal=function(e,t,r){var i=e.node,o=t.getChildren().map(function(a){return a instanceof Be?a.getName():a.getText()}),s=e.name+"("+o.map(function(a,l){return"${"+(l+1)+":"+a+"}"}).join(", ")+")";return{label:e.name,detail:e.name+"("+o.join(", ")+")",textEdit:T.replace(this.getCompletionRange(r),s),insertTextFormat:We,kind:R.Function,sortText:Re.Term}},n.prototype.getCompletionsForSupportsCondition=function(e,t){var r=e.findFirstChildBeforeOffset(this.offset);if(r){if(r instanceof ae)return!he(r.colonPosition)||this.offset<=r.colonPosition?this.getCompletionsForDeclarationProperty(r,t):this.getCompletionsForDeclarationValue(r,t);if(r instanceof Ze)return this.getCompletionsForSupportsCondition(r,t)}return he(e.lParent)&&this.offset>e.lParent&&(!he(e.rParent)||this.offset<=e.rParent)?this.getCompletionsForDeclarationProperty(null,t):t},n.prototype.getCompletionsForSupports=function(e,t){var r=e.getDeclarations(),i=!r||this.offset<=r.offset;if(i){var o=e.findFirstChildBeforeOffset(this.offset);return o instanceof Ze?this.getCompletionsForSupportsCondition(o,t):t}return this.getCompletionForTopLevel(t)},n.prototype.getCompletionsForExtendsReference=function(e,t,r){return r},n.prototype.getCompletionForUriLiteralValue=function(e,t){var r,i,o;if(e.hasChildren()){var a=e.getChild(0);r=a.getText(),i=this.position,o=this.getCompletionRange(a)}else{r="",i=this.position;var s=this.textDocument.positionAt(e.offset+4);o=W.create(s,s)}return this.completionParticipants.forEach(function(l){l.onCssURILiteralValue&&l.onCssURILiteralValue({uriValue:r,position:i,range:o})}),t},n.prototype.getCompletionForImportPath=function(e,t){var r=this;return this.completionParticipants.forEach(function(i){i.onCssImportPath&&i.onCssImportPath({pathValue:e.getText(),position:r.position,range:r.getCompletionRange(e)})}),t},n.prototype.hasCharacterAtPosition=function(e,t){var r=this.textDocument.getText();return e>=0&&e<r.length&&r.charAt(e)===t},n.prototype.doesSupportMarkdown=function(){var e,t,r;if(!he(this.supportsMarkdown)){if(!he(this.lsOptions.clientCapabilities))return this.supportsMarkdown=!0,this.supportsMarkdown;var i=(r=(t=(e=this.lsOptions.clientCapabilities.textDocument)===null||e===void 0?void 0:e.completion)===null||t===void 0?void 0:t.completionItem)===null||r===void 0?void 0:r.documentationFormat;this.supportsMarkdown=Array.isArray(i)&&i.indexOf(ce.Markdown)!==-1}return this.supportsMarkdown},n}();function Ht(n){return!!(n.status&&(n.status==="nonstandard"||n.status==="obsolete"))}var Dr=function(){function n(){this.entries={}}return n.prototype.add=function(e){this.entries[e]=!0},n.prototype.remove=function(e){delete this.entries[e]},n.prototype.getEntries=function(){return Object.keys(this.entries)},n}();function vt(n){return n.replace(/\(\)$/,"($1)")}function la(n,e){var t=e.getFullPropertyName(),r=new Dr;function i(a){return(a instanceof te||a instanceof Rt||a instanceof zt)&&r.add(a.getText()),!0}function o(a){var l=a.getFullPropertyName();return t===l}function s(a){if(a instanceof ae&&a!==e&&o(a)){var l=a.getValue();l&&l.accept(i)}return!0}return n.accept(s),r}var ca=function(){function n(e,t){this.entries=e,this.currentOffset=t}return n.prototype.visitNode=function(e){return(e instanceof zt||e instanceof Pe&&lo(e))&&(this.currentOffset<e.offset||e.end<this.currentOffset)&&this.entries.add(e.getText()),!0},n}(),da=function(){function n(e,t){this.entries=e,this.currentOffset=t}return n.prototype.visitNode=function(e){return e instanceof te&&e.isCustomProperty&&(this.currentOffset<e.offset||e.end<this.currentOffset)&&this.entries.add(e.getText()),!0},n}();function ha(n,e){for(var t=e-1,r=n.getText();t>=0&&` 	
\r":{[()]},*>+`.indexOf(r.charAt(t))===-1;)t--;return r.substring(t+1,e)}function Fo(n){return n.toLowerCase()in Vt||/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(n)}var zo=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,i){r.__proto__=i}||function(r,i){for(var o in i)Object.prototype.hasOwnProperty.call(i,o)&&(r[o]=i[o])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),pa=H(),Rr=function(){function n(){this.parent=null,this.children=null,this.attributes=null}return n.prototype.findAttribute=function(e){if(this.attributes)for(var t=0,r=this.attributes;t<r.length;t++){var i=r[t];if(i.name===e)return i.value}return null},n.prototype.addChild=function(e){e instanceof n&&(e.parent=this),this.children||(this.children=[]),this.children.push(e)},n.prototype.append=function(e){if(this.attributes){var t=this.attributes[this.attributes.length-1];t.value=t.value+e}},n.prototype.prepend=function(e){if(this.attributes){var t=this.attributes[0];t.value=e+t.value}},n.prototype.findRoot=function(){for(var e=this;e.parent&&!(e.parent instanceof wt);)e=e.parent;return e},n.prototype.removeChild=function(e){if(this.children){var t=this.children.indexOf(e);if(t!==-1)return this.children.splice(t,1),!0}return!1},n.prototype.addAttr=function(e,t){this.attributes||(this.attributes=[]);for(var r=0,i=this.attributes;r<i.length;r++){var o=i[r];if(o.name===e){o.value+=" "+t;return}}this.attributes.push({name:e,value:t})},n.prototype.clone=function(e){e===void 0&&(e=!0);var t=new n;if(this.attributes){t.attributes=[];for(var r=0,i=this.attributes;r<i.length;r++){var o=i[r];t.addAttr(o.name,o.value)}}if(e&&this.children){t.children=[];for(var s=0;s<this.children.length;s++)t.addChild(this.children[s].clone())}return t},n.prototype.cloneWithParent=function(){var e=this.clone(!1);if(this.parent&&!(this.parent instanceof wt)){var t=this.parent.cloneWithParent();t.addChild(e)}return e},n}();var wt=function(n){zo(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return e}(Rr);var zr=function(n){zo(e,n);function e(t){var r=n.call(this)||this;return r.addAttr("name",t),r}return e}(Rr);var Eo=function(){function n(e){this.quote=e,this.result=[]}return n.prototype.print=function(e){this.result=[],e instanceof wt?e.children&&this.doPrint(e.children,0):this.doPrint([e],0);var t=this.result.join(`
`);return[{language:"html",value:t}]},n.prototype.doPrint=function(e,t){for(var r=0,i=e;r<i.length;r++){var o=i[r];this.doPrintElement(o,t),o.children&&this.doPrint(o.children,t+1)}},n.prototype.writeLine=function(e,t){var r=new Array(e+1).join("  ");this.result.push(r+t)},n.prototype.doPrintElement=function(e,t){var r=e.findAttribute("name");if(e instanceof zr||r==="\u2026"){this.writeLine(t,r);return}var i=["<"];if(r?i.push(r):i.push("element"),e.attributes)for(var o=0,s=e.attributes;o<s.length;o++){var a=s[o];if(a.name!=="name"){i.push(" "),i.push(a.name);var l=a.value;l&&(i.push("="),i.push(Le.ensure(l,this.quote)))}}i.push(">"),this.writeLine(t,i.join(""))},n}(),Le;(function(n){function e(r,i){return i+t(r)+i}n.ensure=e;function t(r){var i=r.match(/^['"](.*)["']$/);return i?i[1]:r}n.remove=t})(Le||(Le={}));var Do=function(){function n(){this.id=0,this.attr=0,this.tag=0}return n}();function Ro(n,e){for(var t=new Rr,r=0,i=n.getChildren();r<i.length;r++){var o=i[r];switch(o.type){case u.SelectorCombinator:if(e){var s=o.getText().split("&");if(s.length===1){t.addAttr("name",s[0]);break}if(t=e.cloneWithParent(),s[0]){var a=t.findRoot();a.prepend(s[0])}for(var l=1;l<s.length;l++){if(l>1){var c=e.cloneWithParent();t.addChild(c.findRoot()),t=c}t.append(s[l])}}break;case u.SelectorPlaceholder:if(o.matches("@at-root"))return t;case u.ElementNameSelector:var h=o.getText();t.addAttr("name",h==="*"?"element":be(h));break;case u.ClassSelector:t.addAttr("class",be(o.getText().substring(1)));break;case u.IdentifierSelector:t.addAttr("id",be(o.getText().substring(1)));break;case u.MixinDeclaration:t.addAttr("class",o.getName());break;case u.PseudoSelector:t.addAttr(be(o.getText()),"");break;case u.AttributeSelector:var p=o,m=p.getIdentifier();if(m){var g=p.getValue(),w=p.getOperator(),x=void 0;if(g&&w)switch(be(w.getText())){case"|=":x="".concat(Le.remove(be(g.getText())),"-\u2026");break;case"^=":x="".concat(Le.remove(be(g.getText())),"\u2026");break;case"$=":x="\u2026".concat(Le.remove(be(g.getText())));break;case"~=":x=" \u2026 ".concat(Le.remove(be(g.getText()))," \u2026 ");break;case"*=":x="\u2026".concat(Le.remove(be(g.getText())),"\u2026");break;default:x=Le.remove(be(g.getText()));break}t.addAttr(be(m.getText()),x)}break}}return t}function be(n){var e=new Fe;e.setSource(n);var t=e.scanUnquotedString();return t?t.text:n}var Io=function(){function n(e){this.cssDataManager=e}return n.prototype.selectorToMarkedString=function(e){var t=fa(e);if(t){var r=new Eo('"').print(t);return r.push(this.selectorToSpecificityMarkedString(e)),r}else return[]},n.prototype.simpleSelectorToMarkedString=function(e){var t=Ro(e),r=new Eo('"').print(t);return r.push(this.selectorToSpecificityMarkedString(e)),r},n.prototype.isPseudoElementIdentifier=function(e){var t=e.match(/^::?([\w-]+)/);return t?!!this.cssDataManager.getPseudoElement("::"+t[1]):!1},n.prototype.selectorToSpecificityMarkedString=function(e){var t=this,r=function(o){var s=new Do;e:for(var a=0,l=o.getChildren();a<l.length;a++){var c=l[a];switch(c.type){case u.IdentifierSelector:s.id++;break;case u.ClassSelector:case u.AttributeSelector:s.attr++;break;case u.ElementNameSelector:if(c.matches("*"))break;s.tag++;break;case u.PseudoSelector:var h=c.getText();if(t.isPseudoElementIdentifier(h)){s.tag++;break}if(h.match(/^:where/i))continue e;if(h.match(/^:(not|has|is)/i)&&c.getChildren().length>0){for(var p=new Do,m=0,g=c.getChildren();m<g.length;m++){var w=g[m],x=void 0;w.type===u.Undefined?x=w.getChildren():x=[w];for(var y=0,D=w.getChildren();y<D.length;y++){var M=D[y],z=r(M);if(z.id>p.id){p=z;continue}else if(z.id<p.id)continue;if(z.attr>p.attr){p=z;continue}else if(z.attr<p.attr)continue;if(z.tag>p.tag){p=z;continue}}}s.id+=p.id,s.attr+=p.attr,s.tag+=p.tag;continue e}s.attr++;break}if(c.getChildren().length>0){var z=r(c);s.id+=z.id,s.attr+=z.attr,s.tag+=z.tag}}return s},i=r(e);return pa("specificity","[Selector Specificity](https://developer.mozilla.org/en-US/docs/Web/CSS/Specificity): ({0}, {1}, {2})",i.id,i.attr,i.tag)},n}();var ua=function(){function n(e){this.prev=null,this.element=e}return n.prototype.processSelector=function(e){var t=null;if(!(this.element instanceof wt)&&e.getChildren().some(function(h){return h.hasChildren()&&h.getChild(0).type===u.SelectorCombinator})){var r=this.element.findRoot();r.parent instanceof wt&&(t=this.element,this.element=r.parent,this.element.removeChild(r),this.prev=null)}for(var i=0,o=e.getChildren();i<o.length;i++){var s=o[i];if(s instanceof De){if(this.prev instanceof De){var a=new zr("\u2026");this.element.addChild(a),this.element=a}else this.prev&&(this.prev.matches("+")||this.prev.matches("~"))&&this.element.parent&&(this.element=this.element.parent);this.prev&&this.prev.matches("~")&&this.element.addChild(new zr("\u22EE"));var l=Ro(s,t),c=l.findRoot();this.element.addChild(c),this.element=l}(s instanceof De||s.type===u.SelectorCombinatorParent||s.type===u.SelectorCombinatorShadowPiercingDescendant||s.type===u.SelectorCombinatorSibling||s.type===u.SelectorCombinatorAllSiblings)&&(this.prev=s)}},n}();function ma(n){switch(n.type){case u.MixinDeclaration:case u.Stylesheet:return!0}return!1}function fa(n){if(n.matches("@at-root"))return null;var e=new wt,t=[],r=n.getParent();if(r instanceof Te)for(var i=r.getParent();i&&!ma(i);){if(i instanceof Te){if(i.getSelectors().matches("@at-root"))break;t.push(i)}i=i.getParent()}for(var o=new ua(e),s=t.length-1;s>=0;s--){var a=t[s].getSelectors().getChild(0);a&&o.processSelector(a)}return o.processSelector(n),e}var In=function(){function n(e,t){this.clientCapabilities=e,this.cssDataManager=t,this.selectorPrinting=new Io(t)}return n.prototype.configure=function(e){this.defaultSettings=e},n.prototype.doHover=function(e,t,r,i){i===void 0&&(i=this.defaultSettings);function o(y){return W.create(e.positionAt(y.offset),e.positionAt(y.end))}for(var s=e.offsetAt(t),a=ct(r,s),l=null,c=0;c<a.length;c++){var h=a[c];if(h instanceof Ee){l={contents:this.selectorPrinting.selectorToMarkedString(h),range:o(h)};break}if(h instanceof De){q(h.getText(),"@")||(l={contents:this.selectorPrinting.simpleSelectorToMarkedString(h),range:o(h)});break}if(h instanceof ae){var p=h.getFullPropertyName(),m=this.cssDataManager.getProperty(p);if(m){var g=ze(m,this.doesSupportMarkdown(),i);g?l={contents:g,range:o(h)}:l=null}continue}if(h instanceof mn){var w=h.getText(),m=this.cssDataManager.getAtDirective(w);if(m){var g=ze(m,this.doesSupportMarkdown(),i);g?l={contents:g,range:o(h)}:l=null}continue}if(h instanceof F&&h.type===u.PseudoSelector){var x=h.getText(),m=x.slice(0,2)==="::"?this.cssDataManager.getPseudoElement(x):this.cssDataManager.getPseudoClass(x);if(m){var g=ze(m,this.doesSupportMarkdown(),i);g?l={contents:g,range:o(h)}:l=null}continue}}return l&&(l.contents=this.convertContents(l.contents)),l},n.prototype.convertContents=function(e){return this.doesSupportMarkdown()||typeof e=="string"?e:"kind"in e?{kind:"plaintext",value:e.value}:Array.isArray(e)?e.map(function(t){return typeof t=="string"?t:t.value}):e.value},n.prototype.doesSupportMarkdown=function(){if(!he(this.supportsMarkdown)){if(!he(this.clientCapabilities))return this.supportsMarkdown=!0,this.supportsMarkdown;var e=this.clientCapabilities.textDocument&&this.clientCapabilities.textDocument.hover;this.supportsMarkdown=e&&e.contentFormat&&Array.isArray(e.contentFormat)&&e.contentFormat.indexOf(ce.Markdown)!==-1}return this.supportsMarkdown},n}();var Jt=function(n,e,t,r){function i(o){return o instanceof t?o:new t(function(s){s(o)})}return new(t||(t=Promise))(function(o,s){function a(h){try{c(r.next(h))}catch(p){s(p)}}function l(h){try{c(r.throw(h))}catch(p){s(p)}}function c(h){h.done?o(h.value):i(h.value).then(a,l)}c((r=r.apply(n,e||[])).next())})},Xt=function(n,e){var t={label:0,sent:function(){if(o[0]&1)throw o[1];return o[1]},trys:[],ops:[]},r,i,o,s;return s={next:a(0),throw:a(1),return:a(2)},typeof Symbol=="function"&&(s[Symbol.iterator]=function(){return this}),s;function a(c){return function(h){return l([c,h])}}function l(c){if(r)throw new TypeError("Generator is already executing.");for(;t;)try{if(r=1,i&&(o=c[0]&2?i.return:c[0]?i.throw||((o=i.return)&&o.call(i),0):i.next)&&!(o=o.call(i,c[1])).done)return o;switch(i=0,o&&(c=[c[0]&2,o.value]),c[0]){case 0:case 1:o=c;break;case 4:return t.label++,{value:c[1],done:!1};case 5:t.label++,i=c[1],c=[0];continue;case 7:c=t.ops.pop(),t.trys.pop();continue;default:if(o=t.trys,!(o=o.length>0&&o[o.length-1])&&(c[0]===6||c[0]===2)){t=0;continue}if(c[0]===3&&(!o||c[1]>o[0]&&c[1]<o[3])){t.label=c[1];break}if(c[0]===6&&t.label<o[1]){t.label=o[1],o=c;break}if(o&&t.label<o[2]){t.label=o[2],t.ops.push(c);break}o[2]&&t.ops.pop(),t.trys.pop();continue}c=e.call(n,t)}catch(h){c=[6,h],i=0}finally{r=o=0}if(c[0]&5)throw c[1];return{value:c[0]?c[1]:void 0,done:!0}}},Mo=H(),To=/^\w+:\/\//,Po=/^data:/,Yt=function(){function n(e,t){this.fileSystemProvider=e,this.resolveModuleReferences=t}return n.prototype.findDefinition=function(e,t,r){var i=new qt(r),o=e.offsetAt(t),s=sn(r,o);if(!s)return null;var a=i.findSymbolFromNode(s);return a?{uri:e.uri,range:st(a.node,e)}:null},n.prototype.findReferences=function(e,t,r){var i=this.findDocumentHighlights(e,t,r);return i.map(function(o){return{uri:e.uri,range:o.range}})},n.prototype.findDocumentHighlights=function(e,t,r){var i=[],o=e.offsetAt(t),s=sn(r,o);if(!s||s.type===u.Stylesheet||s.type===u.Declarations)return i;s.type===u.Identifier&&s.parent&&s.parent.type===u.ClassSelector&&(s=s.parent);var a=new qt(r),l=a.findSymbolFromNode(s),c=s.getText();return r.accept(function(h){if(l){if(a.matchesSymbol(h,l))return i.push({kind:Ao(h),range:st(h,e)}),!1}else s&&s.type===h.type&&h.matches(c)&&i.push({kind:Ao(h),range:st(h,e)});return!0}),i},n.prototype.isRawStringDocumentLinkNode=function(e){return e.type===u.Import},n.prototype.findDocumentLinks=function(e,t,r){for(var i=this.findUnresolvedLinks(e,t),o=[],s=0,a=i;s<a.length;s++){var l=a[s],c=l.link,h=c.target;if(!(!h||Po.test(h)))if(To.test(h))o.push(c);else{var p=r.resolveReference(h,e.uri);p&&(c.target=p),o.push(c)}}return o},n.prototype.findDocumentLinks2=function(e,t,r){return Jt(this,void 0,void 0,function(){var i,o,s,a,l,c,h,p;return Xt(this,function(m){switch(m.label){case 0:i=this.findUnresolvedLinks(e,t),o=[],s=0,a=i,m.label=1;case 1:return s<a.length?(l=a[s],c=l.link,h=c.target,!h||Po.test(h)?[3,5]:[3,2]):[3,6];case 2:return To.test(h)?(o.push(c),[3,5]):[3,3];case 3:return[4,this.resolveRelativeReference(h,e.uri,r,l.isRawLink)];case 4:p=m.sent(),p!==void 0&&(c.target=p,o.push(c)),m.label=5;case 5:return s++,[3,1];case 6:return[2,o]}})})},n.prototype.findUnresolvedLinks=function(e,t){var r=this,i=[],o=function(s){var a=s.getText(),l=st(s,e);if(!(l.start.line===l.end.line&&l.start.character===l.end.character)){(q(a,"'")||q(a,'"'))&&(a=a.slice(1,-1));var c=s.parent?r.isRawStringDocumentLinkNode(s.parent):!1;i.push({link:{target:a,range:l},isRawLink:c})}};return t.accept(function(s){if(s.type===u.URILiteral){var a=s.getChild(0);return a&&o(a),!1}if(s.parent&&r.isRawStringDocumentLinkNode(s.parent)){var l=s.getText();return(q(l,"'")||q(l,'"'))&&o(s),!1}return!0}),i},n.prototype.findDocumentSymbols=function(e,t){var r=[];return t.accept(function(i){var o={name:null,kind:Oe.Class,location:null},s=i;if(i instanceof Ee)return o.name=i.getText(),s=i.findAParent(u.Ruleset,u.ExtendsReference),s&&(o.location=tt.create(e.uri,st(s,e)),r.push(o)),!1;if(i instanceof $e)o.name=i.getName(),o.kind=Oe.Variable;else if(i instanceof Ae)o.name=i.getName(),o.kind=Oe.Method;else if(i instanceof Qe)o.name=i.getName(),o.kind=Oe.Function;else if(i instanceof cn)o.name=Mo("literal.keyframes","@keyframes {0}",i.getName());else if(i instanceof ln)o.name=Mo("literal.fontface","@font-face");else if(i instanceof dn){var a=i.getChild(0);a instanceof hn&&(o.name="@media "+a.getText(),o.kind=Oe.Module)}return o.name&&(o.location=tt.create(e.uri,st(s,e)),r.push(o)),!0}),r},n.prototype.findDocumentColors=function(e,t){var r=[];return t.accept(function(i){var o=ga(i,e);return o&&r.push(o),!0}),r},n.prototype.getColorPresentations=function(e,t,r,i){var o=[],s=Math.round(r.red*255),a=Math.round(r.green*255),l=Math.round(r.blue*255),c;r.alpha===1?c="rgb(".concat(s,", ").concat(a,", ").concat(l,")"):c="rgba(".concat(s,", ").concat(a,", ").concat(l,", ").concat(r.alpha,")"),o.push({label:c,textEdit:T.replace(i,c)}),r.alpha===1?c="#".concat(ot(s)).concat(ot(a)).concat(ot(l)):c="#".concat(ot(s)).concat(ot(a)).concat(ot(l)).concat(ot(Math.round(r.alpha*255))),o.push({label:c,textEdit:T.replace(i,c)});var h=fr(r);h.a===1?c="hsl(".concat(h.h,", ").concat(Math.round(h.s*100),"%, ").concat(Math.round(h.l*100),"%)"):c="hsla(".concat(h.h,", ").concat(Math.round(h.s*100),"%, ").concat(Math.round(h.l*100),"%, ").concat(h.a,")"),o.push({label:c,textEdit:T.replace(i,c)});var p=ho(r);return p.a===1?c="hwb(".concat(p.h," ").concat(Math.round(p.w*100),"% ").concat(Math.round(p.b*100),"%)"):c="hwb(".concat(p.h," ").concat(Math.round(p.w*100),"% ").concat(Math.round(p.b*100),"% / ").concat(p.a,")"),o.push({label:c,textEdit:T.replace(i,c)}),o},n.prototype.doRename=function(e,t,r,i){var o,s=this.findDocumentHighlights(e,t,i),a=s.map(function(l){return T.replace(l.range,r)});return{changes:(o={},o[e.uri]=a,o)}},n.prototype.resolveModuleReference=function(e,t,r){return Jt(this,void 0,void 0,function(){var i,o,s,a,l;return Xt(this,function(c){switch(c.label){case 0:return q(t,"file://")?(i=ba(e),o=r.resolveReference("/",t),s=Dn(t),[4,this.resolvePathToModule(i,s,o)]):[3,2];case 1:if(a=c.sent(),a)return l=e.substring(i.length+1),[2,Gt(a,l)];c.label=2;case 2:return[2,void 0]}})})},n.prototype.resolveRelativeReference=function(e,t,r,i){return Jt(this,void 0,void 0,function(){var o,s;return Xt(this,function(a){switch(a.label){case 0:return o=r.resolveReference(e,t),e[0]==="~"&&e[1]!=="/"&&this.fileSystemProvider?(e=e.substring(1),[4,this.resolveModuleReference(e,t,r)]):[3,2];case 1:return[2,a.sent()||o];case 2:return this.resolveModuleReferences?(s=o,s?[4,this.fileExists(o)]:[3,4]):[3,7];case 3:s=a.sent(),a.label=4;case 4:return s?[2,o]:[3,5];case 5:return[4,this.resolveModuleReference(e,t,r)];case 6:return[2,a.sent()||o];case 7:return[2,o]}})})},n.prototype.resolvePathToModule=function(e,t,r){return Jt(this,void 0,void 0,function(){var i;return Xt(this,function(o){switch(o.label){case 0:return i=Gt(t,"node_modules",e,"package.json"),[4,this.fileExists(i)];case 1:return o.sent()?[2,Dn(i)]:r&&t.startsWith(r)&&t.length!==r.length?[2,this.resolvePathToModule(e,Dn(t),r)]:[2,void 0]}})})},n.prototype.fileExists=function(e){return Jt(this,void 0,void 0,function(){var t,r;return Xt(this,function(i){switch(i.label){case 0:if(!this.fileSystemProvider)return[2,!1];i.label=1;case 1:return i.trys.push([1,3,,4]),[4,this.fileSystemProvider.stat(e)];case 2:return t=i.sent(),t.type===it.Unknown&&t.size===-1?[2,!1]:[2,!0];case 3:return r=i.sent(),[2,!1];case 4:return[2]}})})},n}();function ga(n,e){var t=po(n);if(t){var r=st(n,e);return{color:t,range:r}}return null}function st(n,e){return W.create(e.positionAt(n.offset),e.positionAt(n.end))}function Ao(n){if(n.type===u.Selector)return He.Write;if(n instanceof te&&n.parent&&n.parent instanceof dt&&n.isCustomProperty)return He.Write;if(n.parent)switch(n.parent.type){case u.FunctionDeclaration:case u.MixinDeclaration:case u.Keyframe:case u.VariableDeclaration:case u.FunctionParameter:return He.Write}return He.Read}function ot(n){var e=n.toString(16);return e.length!==2?"0"+e:e}function ba(n){return n[0]==="@"?n.substring(0,n.indexOf("/",n.indexOf("/")+1)):n.substring(0,n.indexOf("/"))}var Y=H(),xt=ne.Warning,No=ne.Error,Se=ne.Ignore,Z=function(){function n(e,t,r){this.id=e,this.message=t,this.defaultValue=r}return n}();var va=function(){function n(e,t,r){this.id=e,this.message=t,this.defaultValue=r}return n}();var V={AllVendorPrefixes:new Z("compatibleVendorPrefixes",Y("rule.vendorprefixes.all","When using a vendor-specific prefix make sure to also include all other vendor-specific properties"),Se),IncludeStandardPropertyWhenUsingVendorPrefix:new Z("vendorPrefix",Y("rule.standardvendorprefix.all","When using a vendor-specific prefix also include the standard property"),xt),DuplicateDeclarations:new Z("duplicateProperties",Y("rule.duplicateDeclarations","Do not use duplicate style definitions"),Se),EmptyRuleSet:new Z("emptyRules",Y("rule.emptyRuleSets","Do not use empty rulesets"),xt),ImportStatemement:new Z("importStatement",Y("rule.importDirective","Import statements do not load in parallel"),Se),BewareOfBoxModelSize:new Z("boxModel",Y("rule.bewareOfBoxModelSize","Do not use width or height when using padding or border"),Se),UniversalSelector:new Z("universalSelector",Y("rule.universalSelector","The universal selector (*) is known to be slow"),Se),ZeroWithUnit:new Z("zeroUnits",Y("rule.zeroWidthUnit","No unit for zero needed"),Se),RequiredPropertiesForFontFace:new Z("fontFaceProperties",Y("rule.fontFaceProperties","@font-face rule must define 'src' and 'font-family' properties"),xt),HexColorLength:new Z("hexColorLength",Y("rule.hexColor","Hex colors must consist of three, four, six or eight hex numbers"),No),ArgsInColorFunction:new Z("argumentsInColorFunction",Y("rule.colorFunction","Invalid number of parameters"),No),UnknownProperty:new Z("unknownProperties",Y("rule.unknownProperty","Unknown property."),xt),UnknownAtRules:new Z("unknownAtRules",Y("rule.unknownAtRules","Unknown at-rule."),xt),IEStarHack:new Z("ieHack",Y("rule.ieHack","IE hacks are only necessary when supporting IE7 and older"),Se),UnknownVendorSpecificProperty:new Z("unknownVendorSpecificProperties",Y("rule.unknownVendorSpecificProperty","Unknown vendor specific property."),Se),PropertyIgnoredDueToDisplay:new Z("propertyIgnoredDueToDisplay",Y("rule.propertyIgnoredDueToDisplay","Property is ignored due to the display."),xt),AvoidImportant:new Z("important",Y("rule.avoidImportant","Avoid using !important. It is an indication that the specificity of the entire CSS has gotten out of control and needs to be refactored."),Se),AvoidFloat:new Z("float",Y("rule.avoidFloat","Avoid using 'float'. Floats lead to fragile CSS that is easy to break if one aspect of the layout changes."),Se),AvoidIdSelector:new Z("idSelector",Y("rule.avoidIdSelector","Selectors should not contain IDs because these rules are too tightly coupled with the HTML."),Se)},Oo={ValidProperties:new va("validProperties",Y("rule.validProperties","A list of properties that are not validated against the `unknownProperties` rule."),[])},Wo=function(){function n(e){e===void 0&&(e={}),this.conf=e}return n.prototype.getRule=function(e){if(this.conf.hasOwnProperty(e.id)){var t=ya(this.conf[e.id]);if(t)return t}return e.defaultValue},n.prototype.getSetting=function(e){return this.conf[e.id]},n}();function ya(n){switch(n){case"ignore":return ne.Ignore;case"warning":return ne.Warning;case"error":return ne.Error}return null}var wa=H(),Mn=function(){function n(e){this.cssDataManager=e}return n.prototype.doCodeActions=function(e,t,r,i){return this.doCodeActions2(e,t,r,i).map(function(o){var s=o.edit&&o.edit.documentChanges&&o.edit.documentChanges[0];return Ge.create(o.title,"_css.applyCodeAction",e.uri,e.version,s&&s.edits)})},n.prototype.doCodeActions2=function(e,t,r,i){var o=[];if(r.diagnostics)for(var s=0,a=r.diagnostics;s<a.length;s++){var l=a[s];this.appendFixesForMarker(e,i,l,o)}return o},n.prototype.getFixesForUnknownProperty=function(e,t,r,i){var o=t.getName(),s=[];this.cssDataManager.getProperties().forEach(function(D){var M=oi(o,D.name);M>=o.length/2&&s.push({property:D.name,score:M})}),s.sort(function(D,M){return M.score-D.score||D.property.localeCompare(M.property)});for(var a=3,l=0,c=s;l<c.length;l++){var h=c[l],p=h.property,m=wa("css.codeaction.rename","Rename to '{0}'",p),g=T.replace(r.range,p),w=Nt.create(e.uri,e.version),x={documentChanges:[nt.create(w,[g])]},y=Lt.create(m,x,Wt.QuickFix);if(y.diagnostics=[r],i.push(y),--a<=0)return}},n.prototype.appendFixesForMarker=function(e,t,r,i){if(r.code===V.UnknownProperty.id)for(var o=e.offsetAt(r.range.start),s=e.offsetAt(r.range.end),a=ct(t,o),l=a.length-1;l>=0;l--){var c=a[l];if(c instanceof ae){var h=c.getProperty();if(h&&h.offset===o&&h.end===s){this.getFixesForUnknownProperty(e,h,r,i);return}}}},n}();var Uo=function(){function n(e){this.fullPropertyName=e.getFullPropertyName().toLowerCase(),this.node=e}return n}();function Qt(n,e,t,r){var i=n[e];i.value=t,t&&(Fr(i.properties,r)||i.properties.push(r))}function xa(n,e,t){Qt(n,"top",e,t),Qt(n,"right",e,t),Qt(n,"bottom",e,t),Qt(n,"left",e,t)}function ie(n,e,t,r){e==="top"||e==="right"||e==="bottom"||e==="left"?Qt(n,e,t,r):xa(n,t,r)}function Ir(n,e,t){switch(e.length){case 1:ie(n,void 0,e[0],t);break;case 2:ie(n,"top",e[0],t),ie(n,"bottom",e[0],t),ie(n,"right",e[1],t),ie(n,"left",e[1],t);break;case 3:ie(n,"top",e[0],t),ie(n,"right",e[1],t),ie(n,"left",e[1],t),ie(n,"bottom",e[2],t);break;case 4:ie(n,"top",e[0],t),ie(n,"right",e[1],t),ie(n,"bottom",e[2],t),ie(n,"left",e[3],t);break}}function Mr(n,e){for(var t=0,r=e;t<r.length;t++){var i=r[t];if(n.matches(i))return!0}return!1}function Zt(n,e){return e===void 0&&(e=!0),e&&Mr(n,["initial","unset"])?!1:parseFloat(n.getText())!==0}function Lo(n,e){return e===void 0&&(e=!0),n.map(function(t){return Zt(t,e)})}function Tn(n,e){return e===void 0&&(e=!0),!(Mr(n,["none","hidden"])||e&&Mr(n,["initial","unset"]))}function Sa(n,e){return e===void 0&&(e=!0),n.map(function(t){return Tn(t,e)})}function ka(n){var e=n.getChildren();if(e.length===1){var t=e[0];return Zt(t)&&Tn(t)}for(var r=0,i=e;r<i.length;r++){var o=i[r],t=o;if(!Zt(t,!1)||!Tn(t,!1))return!1}return!0}function Tr(n){for(var e={top:{value:!1,properties:[]},right:{value:!1,properties:[]},bottom:{value:!1,properties:[]},left:{value:!1,properties:[]}},t=0,r=n;t<r.length;t++){var i=r[t],o=i.node.value;if(!(typeof o>"u"))switch(i.fullPropertyName){case"box-sizing":return{top:{value:!1,properties:[]},right:{value:!1,properties:[]},bottom:{value:!1,properties:[]},left:{value:!1,properties:[]}};case"width":e.width=i;break;case"height":e.height=i;break;default:var s=i.fullPropertyName.split("-");switch(s[0]){case"border":switch(s[1]){case void 0:case"top":case"right":case"bottom":case"left":switch(s[2]){case void 0:ie(e,s[1],ka(o),i);break;case"width":ie(e,s[1],Zt(o,!1),i);break;case"style":ie(e,s[1],Tn(o,!0),i);break}break;case"width":Ir(e,Lo(o.getChildren(),!1),i);break;case"style":Ir(e,Sa(o.getChildren(),!0),i);break}break;case"padding":s.length===1?Ir(e,Lo(o.getChildren(),!0),i):ie(e,s[1],Zt(o,!0),i);break}break}}return e}var Ue=H(),jo=function(){function n(){this.data={}}return n.prototype.add=function(e,t,r){var i=this.data[e];i||(i={nodes:[],names:[]},this.data[e]=i),i.names.push(t),r&&i.nodes.push(r)},n}(),Vo=function(){function n(e,t,r){var i=this;this.cssDataManager=r,this.warnings=[],this.settings=t,this.documentText=e.getText(),this.keyframes=new jo,this.validProperties={};var o=t.getSetting(Oo.ValidProperties);Array.isArray(o)&&o.forEach(function(s){if(typeof s=="string"){var a=s.trim().toLowerCase();a.length&&(i.validProperties[a]=!0)}})}return n.entries=function(e,t,r,i,o){var s=new n(t,r,i);return e.acceptVisitor(s),s.completeValidations(),s.getEntries(o)},n.prototype.isValidPropertyDeclaration=function(e){var t=e.fullPropertyName;return this.validProperties[t]},n.prototype.fetch=function(e,t){for(var r=[],i=0,o=e;i<o.length;i++){var s=o[i];s.fullPropertyName===t&&r.push(s)}return r},n.prototype.fetchWithValue=function(e,t,r){for(var i=[],o=0,s=e;o<s.length;o++){var a=s[o];if(a.fullPropertyName===t){var l=a.node.getValue();l&&this.findValueInExpression(l,r)&&i.push(a)}}return i},n.prototype.findValueInExpression=function(e,t){var r=!1;return e.accept(function(i){return i.type===u.Identifier&&i.matches(t)&&(r=!0),!r}),r},n.prototype.getEntries=function(e){return e===void 0&&(e=ne.Warning|ne.Error),this.warnings.filter(function(t){return(t.getLevel()&e)!==0})},n.prototype.addEntry=function(e,t,r){var i=new fn(e,t,this.settings.getRule(t),r);this.warnings.push(i)},n.prototype.getMissingNames=function(e,t){for(var r=e.slice(0),i=0;i<t.length;i++){var o=r.indexOf(t[i]);o!==-1&&(r[o]=null)}for(var s=null,i=0;i<r.length;i++){var a=r[i];a&&(s===null?s=Ue("namelist.single","'{0}'",a):s=Ue("namelist.concatenated","{0}, '{1}'",s,a))}return s},n.prototype.visitNode=function(e){switch(e.type){case u.UnknownAtRule:return this.visitUnknownAtRule(e);case u.Keyframe:return this.visitKeyframe(e);case u.FontFace:return this.visitFontFace(e);case u.Ruleset:return this.visitRuleSet(e);case u.SimpleSelector:return this.visitSimpleSelector(e);case u.Function:return this.visitFunction(e);case u.NumericValue:return this.visitNumericValue(e);case u.Import:return this.visitImport(e);case u.HexColorValue:return this.visitHexColorValue(e);case u.Prio:return this.visitPrio(e);case u.IdentifierSelector:return this.visitIdentifierSelector(e)}return!0},n.prototype.completeValidations=function(){this.validateKeyframes()},n.prototype.visitUnknownAtRule=function(e){var t=e.getChild(0);if(!t)return!1;var r=this.cssDataManager.getAtDirective(t.getText());return r?!1:(this.addEntry(t,V.UnknownAtRules,"Unknown at rule ".concat(t.getText())),!0)},n.prototype.visitKeyframe=function(e){var t=e.getKeyword();if(!t)return!1;var r=t.getText();return this.keyframes.add(e.getName(),r,r!=="@keyframes"?t:null),!0},n.prototype.validateKeyframes=function(){var e=["@-webkit-keyframes","@-moz-keyframes","@-o-keyframes"];for(var t in this.keyframes.data){var r=this.keyframes.data[t].names,i=r.indexOf("@keyframes")===-1;if(!(!i&&r.length===1)){var o=this.getMissingNames(e,r);if(o||i)for(var s=0,a=this.keyframes.data[t].nodes;s<a.length;s++){var l=a[s];if(i){var c=Ue("keyframes.standardrule.missing","Always define standard rule '@keyframes' when defining keyframes.");this.addEntry(l,V.IncludeStandardPropertyWhenUsingVendorPrefix,c)}if(o){var c=Ue("keyframes.vendorspecific.missing","Always include all vendor specific rules: Missing: {0}",o);this.addEntry(l,V.AllVendorPrefixes,c)}}}}return!0},n.prototype.visitSimpleSelector=function(e){var t=this.documentText.charAt(e.offset);return e.length===1&&t==="*"&&this.addEntry(e,V.UniversalSelector),!0},n.prototype.visitIdentifierSelector=function(e){return this.addEntry(e,V.AvoidIdSelector),!0},n.prototype.visitImport=function(e){return this.addEntry(e,V.ImportStatemement),!0},n.prototype.visitRuleSet=function(e){var t=e.getDeclarations();if(!t)return!1;t.hasChildren()||this.addEntry(e.getSelectors(),V.EmptyRuleSet);for(var r=[],i=0,o=t.getChildren();i<o.length;i++){var s=o[i];s instanceof ae&&r.push(new Uo(s))}var a=Tr(r);if(a.width){var l=[];if(a.right.value&&(l=$t(l,a.right.properties)),a.left.value&&(l=$t(l,a.left.properties)),l.length!==0){for(var c=0,h=l;c<h.length;c++){var p=h[c];this.addEntry(p.node,V.BewareOfBoxModelSize)}this.addEntry(a.width.node,V.BewareOfBoxModelSize)}}if(a.height){var l=[];if(a.top.value&&(l=$t(l,a.top.properties)),a.bottom.value&&(l=$t(l,a.bottom.properties)),l.length!==0){for(var m=0,g=l;m<g.length;m++){var p=g[m];this.addEntry(p.node,V.BewareOfBoxModelSize)}this.addEntry(a.height.node,V.BewareOfBoxModelSize)}}var w=this.fetchWithValue(r,"display","inline-block");if(w.length>0)for(var x=this.fetch(r,"float"),y=0;y<x.length;y++){var D=x[y].node,M=D.getValue();M&&!M.matches("none")&&this.addEntry(D,V.PropertyIgnoredDueToDisplay,Ue("rule.propertyIgnoredDueToDisplayInlineBlock","inline-block is ignored due to the float. If 'float' has a value other than 'none', the box is floated and 'display' is treated as 'block'"))}if(w=this.fetchWithValue(r,"display","block"),w.length>0)for(var x=this.fetch(r,"vertical-align"),y=0;y<x.length;y++)this.addEntry(x[y].node,V.PropertyIgnoredDueToDisplay,Ue("rule.propertyIgnoredDueToDisplayBlock","Property is ignored due to the display. With 'display: block', vertical-align should not be used."));for(var z=this.fetch(r,"float"),y=0;y<z.length;y++){var s=z[y];this.isValidPropertyDeclaration(s)||this.addEntry(s.node,V.AvoidFloat)}for(var P=0;P<r.length;P++){var s=r[P];if(s.fullPropertyName!=="background"&&!this.validProperties[s.fullPropertyName]){var M=s.node.getValue();if(M&&this.documentText.charAt(M.offset)!=="-"){var L=this.fetch(r,s.fullPropertyName);if(L.length>1)for(var $=0;$<L.length;$++){var ue=L[$].node.getValue();ue&&this.documentText.charAt(ue.offset)!=="-"&&L[$]!==s&&this.addEntry(s.node,V.DuplicateDeclarations)}}}}var oe=e.getSelectors().matches(":export");if(!oe){for(var me=new jo,ve=!1,ye=0,ke=r;ye<ke.length;ye++){var s=ke[ye],pe=s.node;if(this.isCSSDeclaration(pe)){var G=s.fullPropertyName,Ie=G.charAt(0);if(Ie==="-"){if(G.charAt(1)!=="-"){!this.cssDataManager.isKnownProperty(G)&&!this.validProperties[G]&&this.addEntry(pe.getProperty(),V.UnknownVendorSpecificProperty);var fe=pe.getNonPrefixedPropertyName();me.add(fe,G,pe.getProperty())}}else{var C=G;(Ie==="*"||Ie==="_")&&(this.addEntry(pe.getProperty(),V.IEStarHack),G=G.substr(1)),!this.cssDataManager.isKnownProperty(C)&&!this.cssDataManager.isKnownProperty(G)&&(this.validProperties[G]||this.addEntry(pe.getProperty(),V.UnknownProperty,Ue("property.unknownproperty.detailed","Unknown property: '{0}'",pe.getFullPropertyName()))),me.add(G,G,null)}}else ve=!0}if(!ve)for(var b in me.data){var k=me.data[b],_=k.names,N=this.cssDataManager.isStandardProperty(b)&&_.indexOf(b)===-1;if(!(!N&&_.length===1)){for(var O=[],P=0,B=n.prefixes.length;P<B;P++){var Ce=n.prefixes[P];this.cssDataManager.isStandardProperty(Ce+b)&&O.push(Ce+b)}var se=this.getMissingNames(O,_);if(se||N)for(var ge=0,Xe=k.nodes;ge<Xe.length;ge++){var Me=Xe[ge];if(N){var Bn=Ue("property.standard.missing","Also define the standard property '{0}' for compatibility",b);this.addEntry(Me,V.IncludeStandardPropertyWhenUsingVendorPrefix,Bn)}if(se){var Bn=Ue("property.vendorspecific.missing","Always include all vendor specific properties: Missing: {0}",se);this.addEntry(Me,V.AllVendorPrefixes,Bn)}}}}}return!0},n.prototype.visitPrio=function(e){return this.addEntry(e,V.AvoidImportant),!0},n.prototype.visitNumericValue=function(e){var t=e.findParent(u.Function);if(t&&t.getName()==="calc")return!0;var r=e.findParent(u.Declaration);if(r){var i=r.getValue();if(i){var o=e.getValue();if(!o.unit||Cn.length.indexOf(o.unit.toLowerCase())===-1)return!0;parseFloat(o.value)===0&&!!o.unit&&!this.validProperties[r.getFullPropertyName()]&&this.addEntry(e,V.ZeroWithUnit)}}return!0},n.prototype.visitFontFace=function(e){var t=e.getDeclarations();if(!t)return!1;for(var r=!1,i=!1,o=!1,s=0,a=t.getChildren();s<a.length;s++){var l=a[s];if(this.isCSSDeclaration(l)){var c=l.getProperty().getName().toLowerCase();c==="src"&&(r=!0),c==="font-family"&&(i=!0)}else o=!0}return!o&&(!r||!i)&&this.addEntry(e,V.RequiredPropertiesForFontFace),!0},n.prototype.isCSSDeclaration=function(e){if(e instanceof ae){if(!e.getValue())return!1;var t=e.getProperty();if(!t)return!1;var r=t.getIdentifier();return!(!r||r.containsInterpolation())}return!1},n.prototype.visitHexColorValue=function(e){var t=e.length;return t!==9&&t!==7&&t!==5&&t!==4&&this.addEntry(e,V.HexColorLength),!1},n.prototype.visitFunction=function(e){var t=e.getName().toLowerCase(),r=-1,i=0;switch(t){case"rgb(":case"hsl(":r=3;break;case"rgba(":case"hsla(":r=4;break}return r!==-1&&(e.getArguments().accept(function(o){return o instanceof pt?(i+=1,!1):!0}),i!==r&&this.addEntry(e,V.ArgsInColorFunction)),!0},n.prefixes=["-ms-","-moz-","-o-","-webkit-"],n}();var Pn=function(){function n(e){this.cssDataManager=e}return n.prototype.configure=function(e){this.settings=e},n.prototype.doValidation=function(e,t,r){if(r===void 0&&(r=this.settings),r&&r.validate===!1)return[];var i=[];i.push.apply(i,Ni.entries(t)),i.push.apply(i,Vo.entries(t,e,new Wo(r&&r.lint),this.cssDataManager));var o=[];for(var s in V)o.push(V[s].id);function a(l){var c=W.create(e.positionAt(l.getOffset()),e.positionAt(l.getOffset()+l.getLength())),h=e.languageId;return{code:l.getRule().id,source:h,message:l.getMessage(),severity:l.getLevel()===ne.Warning?ft.Warning:ft.Error,range:c}}return i.filter(function(l){return l.getLevel()!==ne.Ignore}).map(a)},n}();var Ca=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,i){r.__proto__=i}||function(r,i){for(var o in i)Object.prototype.hasOwnProperty.call(i,o)&&(r[o]=i[o])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),Bo="/".charCodeAt(0),_a=`
`.charCodeAt(0),Fa="\r".charCodeAt(0),Ea="\f".charCodeAt(0),Da="$".charCodeAt(0),za="#".charCodeAt(0),Ra="{".charCodeAt(0),en="=".charCodeAt(0),Ia="!".charCodeAt(0),Ma="<".charCodeAt(0),Ta=">".charCodeAt(0),Pr=".".charCodeAt(0),yc="@".charCodeAt(0),je=d.CustomToken,An=je++,St=je++,wc=je++,Ar=je++,Nr=je++,Or=je++,Wr=je++,tn=je++,xc=je++,Nn=function(n){Ca(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return e.prototype.scanNext=function(t){if(this.stream.advanceIfChar(Da)){var r=["$"];if(this.ident(r))return this.finishToken(t,An,r.join(""));this.stream.goBackTo(t)}return this.stream.advanceIfChars([za,Ra])?this.finishToken(t,St):this.stream.advanceIfChars([en,en])?this.finishToken(t,Ar):this.stream.advanceIfChars([Ia,en])?this.finishToken(t,Nr):this.stream.advanceIfChar(Ma)?this.stream.advanceIfChar(en)?this.finishToken(t,Wr):this.finishToken(t,d.Delim):this.stream.advanceIfChar(Ta)?this.stream.advanceIfChar(en)?this.finishToken(t,Or):this.finishToken(t,d.Delim):this.stream.advanceIfChars([Pr,Pr,Pr])?this.finishToken(t,tn):n.prototype.scanNext.call(this,t)},e.prototype.comment=function(){return n.prototype.comment.call(this)?!0:!this.inURL&&this.stream.advanceIfChars([Bo,Bo])?(this.stream.advanceWhileChar(function(t){switch(t){case _a:case Fa:case Ea:return!1;default:return!0}}),!0):!1},e}(Fe);var Lr=H(),Ur=function(){function n(e,t){this.id=e,this.message=t}return n}();var On={FromExpected:new Ur("scss-fromexpected",Lr("expected.from","'from' expected")),ThroughOrToExpected:new Ur("scss-throughexpected",Lr("expected.through","'through' or 'to' expected")),InExpected:new Ur("scss-fromexpected",Lr("expected.in","'in' expected"))};var Aa=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,i){r.__proto__=i}||function(r,i){for(var o in i)Object.prototype.hasOwnProperty.call(i,o)&&(r[o]=i[o])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),$o=function(n){Aa(e,n);function e(){return n.call(this,new Nn)||this}return e.prototype._parseStylesheetStatement=function(t){return t===void 0&&(t=!1),this.peek(d.AtKeyword)?this._parseWarnAndDebug()||this._parseControlStatement()||this._parseMixinDeclaration()||this._parseMixinContent()||this._parseMixinReference()||this._parseFunctionDeclaration()||this._parseForward()||this._parseUse()||this._parseRuleset(t)||n.prototype._parseStylesheetAtStatement.call(this,t):this._parseRuleset(!0)||this._parseVariableDeclaration()},e.prototype._parseImport=function(){if(!this.peekKeyword("@import"))return null;var t=this.create(ht);if(this.consumeToken(),!t.addChild(this._parseURILiteral())&&!t.addChild(this._parseStringLiteral()))return this.finish(t,f.URIOrStringExpected);for(;this.accept(d.Comma);)if(!t.addChild(this._parseURILiteral())&&!t.addChild(this._parseStringLiteral()))return this.finish(t,f.URIOrStringExpected);return!this.peek(d.SemiColon)&&!this.peek(d.EOF)&&t.setMedialist(this._parseMediaQueryList()),this.finish(t)},e.prototype._parseVariableDeclaration=function(t){if(t===void 0&&(t=[]),!this.peek(An))return null;var r=this.create($e);if(!r.setVariable(this._parseVariable()))return null;if(!this.accept(d.Colon))return this.finish(r,f.ColonExpected);if(this.prevToken&&(r.colonPosition=this.prevToken.offset),!r.setValue(this._parseExpr()))return this.finish(r,f.VariableValueExpected,[],t);for(;this.peek(d.Exclamation);)if(!r.addChild(this._tryParsePrio())){if(this.consumeToken(),!this.peekRegExp(d.Ident,/^(default|global)$/))return this.finish(r,f.UnknownKeyword);this.consumeToken()}return this.peek(d.SemiColon)&&(r.semicolonPosition=this.token.offset),this.finish(r)},e.prototype._parseMediaCondition=function(){return this._parseInterpolation()||n.prototype._parseMediaCondition.call(this)},e.prototype._parseMediaFeatureName=function(){return this._parseModuleMember()||this._parseFunction()||this._parseIdent()||this._parseVariable()},e.prototype._parseKeyframeSelector=function(){return this._tryParseKeyframeSelector()||this._parseControlStatement(this._parseKeyframeSelector.bind(this))||this._parseVariableDeclaration()||this._parseMixinContent()},e.prototype._parseVariable=function(){if(!this.peek(An))return null;var t=this.create(ut);return this.consumeToken(),t},e.prototype._parseModuleMember=function(){var t=this.mark(),r=this.create(Zn);return r.setIdentifier(this._parseIdent([A.Module]))?this.hasWhitespace()||!this.acceptDelim(".")||this.hasWhitespace()?(this.restoreAtMark(t),null):r.addChild(this._parseVariable()||this._parseFunction())?r:this.finish(r,f.IdentifierOrVariableExpected):null},e.prototype._parseIdent=function(t){var r=this;if(!this.peek(d.Ident)&&!this.peek(St)&&!this.peekDelim("-"))return null;var i=this.create(te);i.referenceTypes=t,i.isCustomProperty=this.peekRegExp(d.Ident,/^--/);for(var o=!1,s=function(){var a=r.mark();return r.acceptDelim("-")&&(r.hasWhitespace()||r.acceptDelim("-"),r.hasWhitespace())?(r.restoreAtMark(a),null):r._parseInterpolation()};(this.accept(d.Ident)||i.addChild(s())||o&&this.acceptRegexp(/^[\w-]/))&&(o=!0,!this.hasWhitespace()););return o?this.finish(i):null},e.prototype._parseTermExpression=function(){return this._parseModuleMember()||this._parseVariable()||this._parseSelectorCombinator()||n.prototype._parseTermExpression.call(this)},e.prototype._parseInterpolation=function(){if(this.peek(St)){var t=this.create(It);return this.consumeToken(),!t.addChild(this._parseExpr())&&!this._parseSelectorCombinator()?this.accept(d.CurlyR)?this.finish(t):this.finish(t,f.ExpressionExpected):this.accept(d.CurlyR)?this.finish(t):this.finish(t,f.RightCurlyExpected)}return null},e.prototype._parseOperator=function(){if(this.peek(Ar)||this.peek(Nr)||this.peek(Or)||this.peek(Wr)||this.peekDelim(">")||this.peekDelim("<")||this.peekIdent("and")||this.peekIdent("or")||this.peekDelim("%")){var t=this.createNode(u.Operator);return this.consumeToken(),this.finish(t)}return n.prototype._parseOperator.call(this)},e.prototype._parseUnaryOperator=function(){if(this.peekIdent("not")){var t=this.create(F);return this.consumeToken(),this.finish(t)}return n.prototype._parseUnaryOperator.call(this)},e.prototype._parseRuleSetDeclaration=function(){return this.peek(d.AtKeyword)?this._parseKeyframe()||this._parseImport()||this._parseMedia(!0)||this._parseFontFace()||this._parseWarnAndDebug()||this._parseControlStatement()||this._parseFunctionDeclaration()||this._parseExtends()||this._parseMixinReference()||this._parseMixinContent()||this._parseMixinDeclaration()||this._parseRuleset(!0)||this._parseSupports(!0)||n.prototype._parseRuleSetDeclarationAtStatement.call(this):this._parseVariableDeclaration()||this._tryParseRuleset(!0)||n.prototype._parseRuleSetDeclaration.call(this)},e.prototype._parseDeclaration=function(t){var r=this._tryParseCustomPropertyDeclaration(t);if(r)return r;var i=this.create(ae);if(!i.setProperty(this._parseProperty()))return null;if(!this.accept(d.Colon))return this.finish(i,f.ColonExpected,[d.Colon],t||[d.SemiColon]);this.prevToken&&(i.colonPosition=this.prevToken.offset);var o=!1;if(i.setValue(this._parseExpr())&&(o=!0,i.addChild(this._parsePrio())),this.peek(d.CurlyL))i.setNestedProperties(this._parseNestedProperties());else if(!o)return this.finish(i,f.PropertyValueExpected);return this.peek(d.SemiColon)&&(i.semicolonPosition=this.token.offset),this.finish(i)},e.prototype._parseNestedProperties=function(){var t=this.create(Yn);return this._parseBody(t,this._parseDeclaration.bind(this))},e.prototype._parseExtends=function(){if(this.peekKeyword("@extend")){var t=this.create(qe);if(this.consumeToken(),!t.getSelectors().addChild(this._parseSimpleSelector()))return this.finish(t,f.SelectorExpected);for(;this.accept(d.Comma);)t.getSelectors().addChild(this._parseSimpleSelector());return this.accept(d.Exclamation)&&!this.acceptIdent("optional")?this.finish(t,f.UnknownKeyword):this.finish(t)}return null},e.prototype._parseSimpleSelectorBody=function(){return this._parseSelectorCombinator()||this._parseSelectorPlaceholder()||n.prototype._parseSimpleSelectorBody.call(this)},e.prototype._parseSelectorCombinator=function(){if(this.peekDelim("&")){var t=this.createNode(u.SelectorCombinator);for(this.consumeToken();!this.hasWhitespace()&&(this.acceptDelim("-")||this.accept(d.Num)||this.accept(d.Dimension)||t.addChild(this._parseIdent())||this.acceptDelim("&")););return this.finish(t)}return null},e.prototype._parseSelectorPlaceholder=function(){if(this.peekDelim("%")){var t=this.createNode(u.SelectorPlaceholder);return this.consumeToken(),this._parseIdent(),this.finish(t)}else if(this.peekKeyword("@at-root")){var t=this.createNode(u.SelectorPlaceholder);return this.consumeToken(),this.finish(t)}return null},e.prototype._parseElementName=function(){var t=this.mark(),r=n.prototype._parseElementName.call(this);return r&&!this.hasWhitespace()&&this.peek(d.ParenthesisL)?(this.restoreAtMark(t),null):r},e.prototype._tryParsePseudoIdentifier=function(){return this._parseInterpolation()||n.prototype._tryParsePseudoIdentifier.call(this)},e.prototype._parseWarnAndDebug=function(){if(!this.peekKeyword("@debug")&&!this.peekKeyword("@warn")&&!this.peekKeyword("@error"))return null;var t=this.createNode(u.Debug);return this.consumeToken(),t.addChild(this._parseExpr()),this.finish(t)},e.prototype._parseControlStatement=function(t){return t===void 0&&(t=this._parseRuleSetDeclaration.bind(this)),this.peek(d.AtKeyword)?this._parseIfStatement(t)||this._parseForStatement(t)||this._parseEachStatement(t)||this._parseWhileStatement(t):null},e.prototype._parseIfStatement=function(t){return this.peekKeyword("@if")?this._internalParseIfStatement(t):null},e.prototype._internalParseIfStatement=function(t){var r=this.create(pi);if(this.consumeToken(),!r.setExpression(this._parseExpr(!0)))return this.finish(r,f.ExpressionExpected);if(this._parseBody(r,t),this.acceptKeyword("@else")){if(this.peekIdent("if"))r.setElseClause(this._internalParseIfStatement(t));else if(this.peek(d.CurlyL)){var i=this.create(gi);this._parseBody(i,t),r.setElseClause(i)}}return this.finish(r)},e.prototype._parseForStatement=function(t){if(!this.peekKeyword("@for"))return null;var r=this.create(ui);return this.consumeToken(),r.setVariable(this._parseVariable())?this.acceptIdent("from")?r.addChild(this._parseBinaryExpr())?!this.acceptIdent("to")&&!this.acceptIdent("through")?this.finish(r,On.ThroughOrToExpected,[d.CurlyR]):r.addChild(this._parseBinaryExpr())?this._parseBody(r,t):this.finish(r,f.ExpressionExpected,[d.CurlyR]):this.finish(r,f.ExpressionExpected,[d.CurlyR]):this.finish(r,On.FromExpected,[d.CurlyR]):this.finish(r,f.VariableNameExpected,[d.CurlyR])},e.prototype._parseEachStatement=function(t){if(!this.peekKeyword("@each"))return null;var r=this.create(mi);this.consumeToken();var i=r.getVariables();if(!i.addChild(this._parseVariable()))return this.finish(r,f.VariableNameExpected,[d.CurlyR]);for(;this.accept(d.Comma);)if(!i.addChild(this._parseVariable()))return this.finish(r,f.VariableNameExpected,[d.CurlyR]);return this.finish(i),this.acceptIdent("in")?r.addChild(this._parseExpr())?this._parseBody(r,t):this.finish(r,f.ExpressionExpected,[d.CurlyR]):this.finish(r,On.InExpected,[d.CurlyR])},e.prototype._parseWhileStatement=function(t){if(!this.peekKeyword("@while"))return null;var r=this.create(fi);return this.consumeToken(),r.addChild(this._parseBinaryExpr())?this._parseBody(r,t):this.finish(r,f.ExpressionExpected,[d.CurlyR])},e.prototype._parseFunctionBodyDeclaration=function(){return this._parseVariableDeclaration()||this._parseReturnStatement()||this._parseWarnAndDebug()||this._parseControlStatement(this._parseFunctionBodyDeclaration.bind(this))},e.prototype._parseFunctionDeclaration=function(){if(!this.peekKeyword("@function"))return null;var t=this.create(Qe);if(this.consumeToken(),!t.setIdentifier(this._parseIdent([A.Function])))return this.finish(t,f.IdentifierExpected,[d.CurlyR]);if(!this.accept(d.ParenthesisL))return this.finish(t,f.LeftParenthesisExpected,[d.CurlyR]);if(t.getParameters().addChild(this._parseParameterDeclaration())){for(;this.accept(d.Comma)&&!this.peek(d.ParenthesisR);)if(!t.getParameters().addChild(this._parseParameterDeclaration()))return this.finish(t,f.VariableNameExpected)}return this.accept(d.ParenthesisR)?this._parseBody(t,this._parseFunctionBodyDeclaration.bind(this)):this.finish(t,f.RightParenthesisExpected,[d.CurlyR])},e.prototype._parseReturnStatement=function(){if(!this.peekKeyword("@return"))return null;var t=this.createNode(u.ReturnStatement);return this.consumeToken(),t.addChild(this._parseExpr())?this.finish(t):this.finish(t,f.ExpressionExpected)},e.prototype._parseMixinDeclaration=function(){if(!this.peekKeyword("@mixin"))return null;var t=this.create(Ae);if(this.consumeToken(),!t.setIdentifier(this._parseIdent([A.Mixin])))return this.finish(t,f.IdentifierExpected,[d.CurlyR]);if(this.accept(d.ParenthesisL)){if(t.getParameters().addChild(this._parseParameterDeclaration())){for(;this.accept(d.Comma)&&!this.peek(d.ParenthesisR);)if(!t.getParameters().addChild(this._parseParameterDeclaration()))return this.finish(t,f.VariableNameExpected)}if(!this.accept(d.ParenthesisR))return this.finish(t,f.RightParenthesisExpected,[d.CurlyR])}return this._parseBody(t,this._parseRuleSetDeclaration.bind(this))},e.prototype._parseParameterDeclaration=function(){var t=this.create(Be);return t.setIdentifier(this._parseVariable())?(this.accept(tn),this.accept(d.Colon)&&!t.setDefaultValue(this._parseExpr(!0))?this.finish(t,f.VariableValueExpected,[],[d.Comma,d.ParenthesisR]):this.finish(t)):null},e.prototype._parseMixinContent=function(){if(!this.peekKeyword("@content"))return null;var t=this.create(Ii);if(this.consumeToken(),this.accept(d.ParenthesisL)){if(t.getArguments().addChild(this._parseFunctionArgument())){for(;this.accept(d.Comma)&&!this.peek(d.ParenthesisR);)if(!t.getArguments().addChild(this._parseFunctionArgument()))return this.finish(t,f.ExpressionExpected)}if(!this.accept(d.ParenthesisR))return this.finish(t,f.RightParenthesisExpected)}return this.finish(t)},e.prototype._parseMixinReference=function(){if(!this.peekKeyword("@include"))return null;var t=this.create(et);this.consumeToken();var r=this._parseIdent([A.Mixin]);if(!t.setIdentifier(r))return this.finish(t,f.IdentifierExpected,[d.CurlyR]);if(!this.hasWhitespace()&&this.acceptDelim(".")&&!this.hasWhitespace()){var i=this._parseIdent([A.Mixin]);if(!i)return this.finish(t,f.IdentifierExpected,[d.CurlyR]);var o=this.create(Zn);r.referenceTypes=[A.Module],o.setIdentifier(r),t.setIdentifier(i),t.addChild(o)}if(this.accept(d.ParenthesisL)){if(t.getArguments().addChild(this._parseFunctionArgument())){for(;this.accept(d.Comma)&&!this.peek(d.ParenthesisR);)if(!t.getArguments().addChild(this._parseFunctionArgument()))return this.finish(t,f.ExpressionExpected)}if(!this.accept(d.ParenthesisR))return this.finish(t,f.RightParenthesisExpected)}return(this.peekIdent("using")||this.peek(d.CurlyL))&&t.setContent(this._parseMixinContentDeclaration()),this.finish(t)},e.prototype._parseMixinContentDeclaration=function(){var t=this.create(Mi);if(this.acceptIdent("using")){if(!this.accept(d.ParenthesisL))return this.finish(t,f.LeftParenthesisExpected,[d.CurlyL]);if(t.getParameters().addChild(this._parseParameterDeclaration())){for(;this.accept(d.Comma)&&!this.peek(d.ParenthesisR);)if(!t.getParameters().addChild(this._parseParameterDeclaration()))return this.finish(t,f.VariableNameExpected)}if(!this.accept(d.ParenthesisR))return this.finish(t,f.RightParenthesisExpected,[d.CurlyL])}return this.peek(d.CurlyL)&&this._parseBody(t,this._parseMixinReferenceBodyStatement.bind(this)),this.finish(t)},e.prototype._parseMixinReferenceBodyStatement=function(){return this._tryParseKeyframeSelector()||this._parseRuleSetDeclaration()},e.prototype._parseFunctionArgument=function(){var t=this.create(we),r=this.mark(),i=this._parseVariable();if(i)if(this.accept(d.Colon))t.setIdentifier(i);else{if(this.accept(tn))return t.setValue(i),this.finish(t);this.restoreAtMark(r)}return t.setValue(this._parseExpr(!0))?(this.accept(tn),t.addChild(this._parsePrio()),this.finish(t)):t.setValue(this._tryParsePrio())?this.finish(t):null},e.prototype._parseURLArgument=function(){var t=this.mark(),r=n.prototype._parseURLArgument.call(this);if(!r||!this.peek(d.ParenthesisR)){this.restoreAtMark(t);var i=this.create(F);return i.addChild(this._parseBinaryExpr()),this.finish(i)}return r},e.prototype._parseOperation=function(){if(!this.peek(d.ParenthesisL))return null;var t=this.create(F);for(this.consumeToken();t.addChild(this._parseListElement());)this.accept(d.Comma);return this.accept(d.ParenthesisR)?this.finish(t):this.finish(t,f.RightParenthesisExpected)},e.prototype._parseListElement=function(){var t=this.create(Ti),r=this._parseBinaryExpr();if(!r)return null;if(this.accept(d.Colon)){if(t.setKey(r),!t.setValue(this._parseBinaryExpr()))return this.finish(t,f.ExpressionExpected)}else t.setValue(r);return this.finish(t)},e.prototype._parseUse=function(){if(!this.peekKeyword("@use"))return null;var t=this.create(vi);if(this.consumeToken(),!t.addChild(this._parseStringLiteral()))return this.finish(t,f.StringLiteralExpected);if(!this.peek(d.SemiColon)&&!this.peek(d.EOF)){if(!this.peekRegExp(d.Ident,/as|with/))return this.finish(t,f.UnknownKeyword);if(this.acceptIdent("as")&&!t.setIdentifier(this._parseIdent([A.Module]))&&!this.acceptDelim("*"))return this.finish(t,f.IdentifierOrWildcardExpected);if(this.acceptIdent("with")){if(!this.accept(d.ParenthesisL))return this.finish(t,f.LeftParenthesisExpected,[d.ParenthesisR]);if(!t.getParameters().addChild(this._parseModuleConfigDeclaration()))return this.finish(t,f.VariableNameExpected);for(;this.accept(d.Comma)&&!this.peek(d.ParenthesisR);)if(!t.getParameters().addChild(this._parseModuleConfigDeclaration()))return this.finish(t,f.VariableNameExpected);if(!this.accept(d.ParenthesisR))return this.finish(t,f.RightParenthesisExpected)}}return!this.accept(d.SemiColon)&&!this.accept(d.EOF)?this.finish(t,f.SemiColonExpected):this.finish(t)},e.prototype._parseModuleConfigDeclaration=function(){var t=this.create(yi);return t.setIdentifier(this._parseVariable())?!this.accept(d.Colon)||!t.setValue(this._parseExpr(!0))?this.finish(t,f.VariableValueExpected,[],[d.Comma,d.ParenthesisR]):this.accept(d.Exclamation)&&(this.hasWhitespace()||!this.acceptIdent("default"))?this.finish(t,f.UnknownKeyword):this.finish(t):null},e.prototype._parseForward=function(){if(!this.peekKeyword("@forward"))return null;var t=this.create(wi);if(this.consumeToken(),!t.addChild(this._parseStringLiteral()))return this.finish(t,f.StringLiteralExpected);if(this.acceptIdent("with")){if(!this.accept(d.ParenthesisL))return this.finish(t,f.LeftParenthesisExpected,[d.ParenthesisR]);if(!t.getParameters().addChild(this._parseModuleConfigDeclaration()))return this.finish(t,f.VariableNameExpected);for(;this.accept(d.Comma)&&!this.peek(d.ParenthesisR);)if(!t.getParameters().addChild(this._parseModuleConfigDeclaration()))return this.finish(t,f.VariableNameExpected);if(!this.accept(d.ParenthesisR))return this.finish(t,f.RightParenthesisExpected)}if(!this.peek(d.SemiColon)&&!this.peek(d.EOF)){if(!this.peekRegExp(d.Ident,/as|hide|show/))return this.finish(t,f.UnknownKeyword);if(this.acceptIdent("as")){var r=this._parseIdent([A.Forward]);if(!t.setIdentifier(r))return this.finish(t,f.IdentifierExpected);if(this.hasWhitespace()||!this.acceptDelim("*"))return this.finish(t,f.WildcardExpected)}if((this.peekIdent("hide")||this.peekIdent("show"))&&!t.addChild(this._parseForwardVisibility()))return this.finish(t,f.IdentifierOrVariableExpected)}return!this.accept(d.SemiColon)&&!this.accept(d.EOF)?this.finish(t,f.SemiColonExpected):this.finish(t)},e.prototype._parseForwardVisibility=function(){var t=this.create(xi);for(t.setIdentifier(this._parseIdent());t.addChild(this._parseVariable()||this._parseIdent());)this.accept(d.Comma);return t.getChildren().length>1?t:null},e.prototype._parseSupportsCondition=function(){return this._parseInterpolation()||n.prototype._parseSupportsCondition.call(this)},e}(bt);var Na=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,i){r.__proto__=i}||function(r,i){for(var o in i)Object.prototype.hasOwnProperty.call(i,o)&&(r[o]=i[o])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),S=H(),Ko=function(n){Na(e,n);function e(t,r){var i=n.call(this,"$",t,r)||this;return qo(e.scssModuleLoaders),qo(e.scssModuleBuiltIns),i}return e.prototype.isImportPathParent=function(t){return t===u.Forward||t===u.Use||n.prototype.isImportPathParent.call(this,t)},e.prototype.getCompletionForImportPath=function(t,r){var i=t.getParent().type;if(i===u.Forward||i===u.Use)for(var o=0,s=e.scssModuleBuiltIns;o<s.length;o++){var a=s[o],l={label:a.label,documentation:a.documentation,textEdit:T.replace(this.getCompletionRange(t),"'".concat(a.label,"'")),kind:R.Module};r.items.push(l)}return n.prototype.getCompletionForImportPath.call(this,t,r)},e.prototype.createReplaceFunction=function(){var t=1;return function(r,i){return"\\"+i+": ${"+t+++":"+(e.variableDefaults[i]||"")+"}"}},e.prototype.createFunctionProposals=function(t,r,i,o){for(var s=0,a=t;s<a.length;s++){var l=a[s],c=l.func.replace(/\[?(\$\w+)\]?/g,this.createReplaceFunction()),h=l.func.substr(0,l.func.indexOf("(")),p={label:h,detail:l.func,documentation:l.desc,textEdit:T.replace(this.getCompletionRange(r),c),insertTextFormat:re.Snippet,kind:R.Function};i&&(p.sortText="z"),o.items.push(p)}return o},e.prototype.getCompletionsForSelector=function(t,r,i){return this.createFunctionProposals(e.selectorFuncs,null,!0,i),n.prototype.getCompletionsForSelector.call(this,t,r,i)},e.prototype.getTermProposals=function(t,r,i){var o=e.builtInFuncs;return t&&(o=o.filter(function(s){return!s.type||!t.restrictions||t.restrictions.indexOf(s.type)!==-1})),this.createFunctionProposals(o,r,!0,i),n.prototype.getTermProposals.call(this,t,r,i)},e.prototype.getColorProposals=function(t,r,i){return this.createFunctionProposals(e.colorProposals,r,!1,i),n.prototype.getColorProposals.call(this,t,r,i)},e.prototype.getCompletionsForDeclarationProperty=function(t,r){return this.getCompletionForAtDirectives(r),this.getCompletionsForSelector(null,!0,r),n.prototype.getCompletionsForDeclarationProperty.call(this,t,r)},e.prototype.getCompletionsForExtendsReference=function(t,r,i){for(var o=this.getSymbolContext().findSymbolsAtOffset(this.offset,A.Rule),s=0,a=o;s<a.length;s++){var l=a[s],c={label:l.name,textEdit:T.replace(this.getCompletionRange(r),l.name),kind:R.Function};i.items.push(c)}return i},e.prototype.getCompletionForAtDirectives=function(t){var r;return(r=t.items).push.apply(r,e.scssAtDirectives),t},e.prototype.getCompletionForTopLevel=function(t){return this.getCompletionForAtDirectives(t),this.getCompletionForModuleLoaders(t),n.prototype.getCompletionForTopLevel.call(this,t),t},e.prototype.getCompletionForModuleLoaders=function(t){var r;return(r=t.items).push.apply(r,e.scssModuleLoaders),t},e.variableDefaults={$red:"1",$green:"2",$blue:"3",$alpha:"1.0",$color:"#000000",$weight:"0.5",$hue:"0",$saturation:"0%",$lightness:"0%",$degrees:"0",$amount:"0",$string:'""',$substring:'"s"',$number:"0",$limit:"1"},e.colorProposals=[{func:"red($color)",desc:S("scss.builtin.red","Gets the red component of a color.")},{func:"green($color)",desc:S("scss.builtin.green","Gets the green component of a color.")},{func:"blue($color)",desc:S("scss.builtin.blue","Gets the blue component of a color.")},{func:"mix($color, $color, [$weight])",desc:S("scss.builtin.mix","Mixes two colors together.")},{func:"hue($color)",desc:S("scss.builtin.hue","Gets the hue component of a color.")},{func:"saturation($color)",desc:S("scss.builtin.saturation","Gets the saturation component of a color.")},{func:"lightness($color)",desc:S("scss.builtin.lightness","Gets the lightness component of a color.")},{func:"adjust-hue($color, $degrees)",desc:S("scss.builtin.adjust-hue","Changes the hue of a color.")},{func:"lighten($color, $amount)",desc:S("scss.builtin.lighten","Makes a color lighter.")},{func:"darken($color, $amount)",desc:S("scss.builtin.darken","Makes a color darker.")},{func:"saturate($color, $amount)",desc:S("scss.builtin.saturate","Makes a color more saturated.")},{func:"desaturate($color, $amount)",desc:S("scss.builtin.desaturate","Makes a color less saturated.")},{func:"grayscale($color)",desc:S("scss.builtin.grayscale","Converts a color to grayscale.")},{func:"complement($color)",desc:S("scss.builtin.complement","Returns the complement of a color.")},{func:"invert($color)",desc:S("scss.builtin.invert","Returns the inverse of a color.")},{func:"alpha($color)",desc:S("scss.builtin.alpha","Gets the opacity component of a color.")},{func:"opacity($color)",desc:"Gets the alpha component (opacity) of a color."},{func:"rgba($color, $alpha)",desc:S("scss.builtin.rgba","Changes the alpha component for a color.")},{func:"opacify($color, $amount)",desc:S("scss.builtin.opacify","Makes a color more opaque.")},{func:"fade-in($color, $amount)",desc:S("scss.builtin.fade-in","Makes a color more opaque.")},{func:"transparentize($color, $amount)",desc:S("scss.builtin.transparentize","Makes a color more transparent.")},{func:"fade-out($color, $amount)",desc:S("scss.builtin.fade-out","Makes a color more transparent.")},{func:"adjust-color($color, [$red], [$green], [$blue], [$hue], [$saturation], [$lightness], [$alpha])",desc:S("scss.builtin.adjust-color","Increases or decreases one or more components of a color.")},{func:"scale-color($color, [$red], [$green], [$blue], [$saturation], [$lightness], [$alpha])",desc:S("scss.builtin.scale-color","Fluidly scales one or more properties of a color.")},{func:"change-color($color, [$red], [$green], [$blue], [$hue], [$saturation], [$lightness], [$alpha])",desc:S("scss.builtin.change-color","Changes one or more properties of a color.")},{func:"ie-hex-str($color)",desc:S("scss.builtin.ie-hex-str","Converts a color into the format understood by IE filters.")}],e.selectorFuncs=[{func:"selector-nest($selectors\u2026)",desc:S("scss.builtin.selector-nest","Nests selector beneath one another like they would be nested in the stylesheet.")},{func:"selector-append($selectors\u2026)",desc:S("scss.builtin.selector-append","Appends selectors to one another without spaces in between.")},{func:"selector-extend($selector, $extendee, $extender)",desc:S("scss.builtin.selector-extend","Extends $extendee with $extender within $selector.")},{func:"selector-replace($selector, $original, $replacement)",desc:S("scss.builtin.selector-replace","Replaces $original with $replacement within $selector.")},{func:"selector-unify($selector1, $selector2)",desc:S("scss.builtin.selector-unify","Unifies two selectors to produce a selector that matches elements matched by both.")},{func:"is-superselector($super, $sub)",desc:S("scss.builtin.is-superselector","Returns whether $super matches all the elements $sub does, and possibly more.")},{func:"simple-selectors($selector)",desc:S("scss.builtin.simple-selectors","Returns the simple selectors that comprise a compound selector.")},{func:"selector-parse($selector)",desc:S("scss.builtin.selector-parse","Parses a selector into the format returned by &.")}],e.builtInFuncs=[{func:"unquote($string)",desc:S("scss.builtin.unquote","Removes quotes from a string.")},{func:"quote($string)",desc:S("scss.builtin.quote","Adds quotes to a string.")},{func:"str-length($string)",desc:S("scss.builtin.str-length","Returns the number of characters in a string.")},{func:"str-insert($string, $insert, $index)",desc:S("scss.builtin.str-insert","Inserts $insert into $string at $index.")},{func:"str-index($string, $substring)",desc:S("scss.builtin.str-index","Returns the index of the first occurance of $substring in $string.")},{func:"str-slice($string, $start-at, [$end-at])",desc:S("scss.builtin.str-slice","Extracts a substring from $string.")},{func:"to-upper-case($string)",desc:S("scss.builtin.to-upper-case","Converts a string to upper case.")},{func:"to-lower-case($string)",desc:S("scss.builtin.to-lower-case","Converts a string to lower case.")},{func:"percentage($number)",desc:S("scss.builtin.percentage","Converts a unitless number to a percentage."),type:"percentage"},{func:"round($number)",desc:S("scss.builtin.round","Rounds a number to the nearest whole number.")},{func:"ceil($number)",desc:S("scss.builtin.ceil","Rounds a number up to the next whole number.")},{func:"floor($number)",desc:S("scss.builtin.floor","Rounds a number down to the previous whole number.")},{func:"abs($number)",desc:S("scss.builtin.abs","Returns the absolute value of a number.")},{func:"min($numbers)",desc:S("scss.builtin.min","Finds the minimum of several numbers.")},{func:"max($numbers)",desc:S("scss.builtin.max","Finds the maximum of several numbers.")},{func:"random([$limit])",desc:S("scss.builtin.random","Returns a random number.")},{func:"length($list)",desc:S("scss.builtin.length","Returns the length of a list.")},{func:"nth($list, $n)",desc:S("scss.builtin.nth","Returns a specific item in a list.")},{func:"set-nth($list, $n, $value)",desc:S("scss.builtin.set-nth","Replaces the nth item in a list.")},{func:"join($list1, $list2, [$separator])",desc:S("scss.builtin.join","Joins together two lists into one.")},{func:"append($list1, $val, [$separator])",desc:S("scss.builtin.append","Appends a single value onto the end of a list.")},{func:"zip($lists)",desc:S("scss.builtin.zip","Combines several lists into a single multidimensional list.")},{func:"index($list, $value)",desc:S("scss.builtin.index","Returns the position of a value within a list.")},{func:"list-separator(#list)",desc:S("scss.builtin.list-separator","Returns the separator of a list.")},{func:"map-get($map, $key)",desc:S("scss.builtin.map-get","Returns the value in a map associated with a given key.")},{func:"map-merge($map1, $map2)",desc:S("scss.builtin.map-merge","Merges two maps together into a new map.")},{func:"map-remove($map, $keys)",desc:S("scss.builtin.map-remove","Returns a new map with keys removed.")},{func:"map-keys($map)",desc:S("scss.builtin.map-keys","Returns a list of all keys in a map.")},{func:"map-values($map)",desc:S("scss.builtin.map-values","Returns a list of all values in a map.")},{func:"map-has-key($map, $key)",desc:S("scss.builtin.map-has-key","Returns whether a map has a value associated with a given key.")},{func:"keywords($args)",desc:S("scss.builtin.keywords","Returns the keywords passed to a function that takes variable arguments.")},{func:"feature-exists($feature)",desc:S("scss.builtin.feature-exists","Returns whether a feature exists in the current Sass runtime.")},{func:"variable-exists($name)",desc:S("scss.builtin.variable-exists","Returns whether a variable with the given name exists in the current scope.")},{func:"global-variable-exists($name)",desc:S("scss.builtin.global-variable-exists","Returns whether a variable with the given name exists in the global scope.")},{func:"function-exists($name)",desc:S("scss.builtin.function-exists","Returns whether a function with the given name exists.")},{func:"mixin-exists($name)",desc:S("scss.builtin.mixin-exists","Returns whether a mixin with the given name exists.")},{func:"inspect($value)",desc:S("scss.builtin.inspect","Returns the string representation of a value as it would be represented in Sass.")},{func:"type-of($value)",desc:S("scss.builtin.type-of","Returns the type of a value.")},{func:"unit($number)",desc:S("scss.builtin.unit","Returns the unit(s) associated with a number.")},{func:"unitless($number)",desc:S("scss.builtin.unitless","Returns whether a number has units.")},{func:"comparable($number1, $number2)",desc:S("scss.builtin.comparable","Returns whether two numbers can be added, subtracted, or compared.")},{func:"call($name, $args\u2026)",desc:S("scss.builtin.call","Dynamically calls a Sass function.")}],e.scssAtDirectives=[{label:"@extend",documentation:S("scss.builtin.@extend","Inherits the styles of another selector."),kind:R.Keyword},{label:"@at-root",documentation:S("scss.builtin.@at-root","Causes one or more rules to be emitted at the root of the document."),kind:R.Keyword},{label:"@debug",documentation:S("scss.builtin.@debug","Prints the value of an expression to the standard error output stream. Useful for debugging complicated Sass files."),kind:R.Keyword},{label:"@warn",documentation:S("scss.builtin.@warn","Prints the value of an expression to the standard error output stream. Useful for libraries that need to warn users of deprecations or recovering from minor mixin usage mistakes. Warnings can be turned off with the `--quiet` command-line option or the `:quiet` Sass option."),kind:R.Keyword},{label:"@error",documentation:S("scss.builtin.@error","Throws the value of an expression as a fatal error with stack trace. Useful for validating arguments to mixins and functions."),kind:R.Keyword},{label:"@if",documentation:S("scss.builtin.@if","Includes the body if the expression does not evaluate to `false` or `null`."),insertText:`@if \${1:expr} {
	$0
}`,insertTextFormat:re.Snippet,kind:R.Keyword},{label:"@for",documentation:S("scss.builtin.@for","For loop that repeatedly outputs a set of styles for each `$var` in the `from/through` or `from/to` clause."),insertText:"@for \\$${1:var} from ${2:start} ${3|to,through|} ${4:end} {\n	$0\n}",insertTextFormat:re.Snippet,kind:R.Keyword},{label:"@each",documentation:S("scss.builtin.@each","Each loop that sets `$var` to each item in the list or map, then outputs the styles it contains using that value of `$var`."),insertText:"@each \\$${1:var} in ${2:list} {\n	$0\n}",insertTextFormat:re.Snippet,kind:R.Keyword},{label:"@while",documentation:S("scss.builtin.@while","While loop that takes an expression and repeatedly outputs the nested styles until the statement evaluates to `false`."),insertText:`@while \${1:condition} {
	$0
}`,insertTextFormat:re.Snippet,kind:R.Keyword},{label:"@mixin",documentation:S("scss.builtin.@mixin","Defines styles that can be re-used throughout the stylesheet with `@include`."),insertText:`@mixin \${1:name} {
	$0
}`,insertTextFormat:re.Snippet,kind:R.Keyword},{label:"@include",documentation:S("scss.builtin.@include","Includes the styles defined by another mixin into the current rule."),kind:R.Keyword},{label:"@function",documentation:S("scss.builtin.@function","Defines complex operations that can be re-used throughout stylesheets."),kind:R.Keyword}],e.scssModuleLoaders=[{label:"@use",documentation:S("scss.builtin.@use","Loads mixins, functions, and variables from other Sass stylesheets as 'modules', and combines CSS from multiple stylesheets together."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/at-rules/use"}],insertText:"@use $0;",insertTextFormat:re.Snippet,kind:R.Keyword},{label:"@forward",documentation:S("scss.builtin.@forward","Loads a Sass stylesheet and makes its mixins, functions, and variables available when this stylesheet is loaded with the @use rule."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/at-rules/forward"}],insertText:"@forward $0;",insertTextFormat:re.Snippet,kind:R.Keyword}],e.scssModuleBuiltIns=[{label:"sass:math",documentation:S("scss.builtin.sass:math","Provides functions that operate on numbers."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/modules/math"}]},{label:"sass:string",documentation:S("scss.builtin.sass:string","Makes it easy to combine, search, or split apart strings."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/modules/string"}]},{label:"sass:color",documentation:S("scss.builtin.sass:color","Generates new colors based on existing ones, making it easy to build color themes."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/modules/color"}]},{label:"sass:list",documentation:S("scss.builtin.sass:list","Lets you access and modify values in lists."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/modules/list"}]},{label:"sass:map",documentation:S("scss.builtin.sass:map","Makes it possible to look up the value associated with a key in a map, and much more."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/modules/map"}]},{label:"sass:selector",documentation:S("scss.builtin.sass:selector","Provides access to Sass\u2019s powerful selector engine."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/modules/selector"}]},{label:"sass:meta",documentation:S("scss.builtin.sass:meta","Exposes the details of Sass\u2019s inner workings."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/modules/meta"}]}],e}(yt);function qo(n){n.forEach(function(e){if(e.documentation&&e.references&&e.references.length>0){var t=typeof e.documentation=="string"?{kind:"markdown",value:e.documentation}:{kind:"markdown",value:e.documentation.value};t.value+=`

`,t.value+=e.references.map(function(r){return"[".concat(r.name,"](").concat(r.url,")")}).join(" | "),e.documentation=t}})}var Oa=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,i){r.__proto__=i}||function(r,i){for(var o in i)Object.prototype.hasOwnProperty.call(i,o)&&(r[o]=i[o])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),Go="/".charCodeAt(0),Wa=`
`.charCodeAt(0),La="\r".charCodeAt(0),Ua="\f".charCodeAt(0),jr="`".charCodeAt(0),Vr=".".charCodeAt(0),ja=d.CustomToken,Wn=ja++,Ln=function(n){Oa(e,n);function e(){return n!==null&&n.apply(this,arguments)||this}return e.prototype.scanNext=function(t){var r=this.escapedJavaScript();return r!==null?this.finishToken(t,r):this.stream.advanceIfChars([Vr,Vr,Vr])?this.finishToken(t,Wn):n.prototype.scanNext.call(this,t)},e.prototype.comment=function(){return n.prototype.comment.call(this)?!0:!this.inURL&&this.stream.advanceIfChars([Go,Go])?(this.stream.advanceWhileChar(function(t){switch(t){case Wa:case La:case Ua:return!1;default:return!0}}),!0):!1},e.prototype.escapedJavaScript=function(){var t=this.stream.peekChar();return t===jr?(this.stream.advance(1),this.stream.advanceWhileChar(function(r){return r!==jr}),this.stream.advanceIfChar(jr)?d.EscapedJavaScript:d.BadEscapedJavaScript):null},e}(Fe);var Ba=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,i){r.__proto__=i}||function(r,i){for(var o in i)Object.prototype.hasOwnProperty.call(i,o)&&(r[o]=i[o])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),Ho=function(n){Ba(e,n);function e(){return n.call(this,new Ln)||this}return e.prototype._parseStylesheetStatement=function(t){return t===void 0&&(t=!1),this.peek(d.AtKeyword)?this._parseVariableDeclaration()||this._parsePlugin()||n.prototype._parseStylesheetAtStatement.call(this,t):this._tryParseMixinDeclaration()||this._tryParseMixinReference()||this._parseFunction()||this._parseRuleset(!0)},e.prototype._parseImport=function(){if(!this.peekKeyword("@import")&&!this.peekKeyword("@import-once"))return null;var t=this.create(ht);if(this.consumeToken(),this.accept(d.ParenthesisL)){if(!this.accept(d.Ident))return this.finish(t,f.IdentifierExpected,[d.SemiColon]);do if(!this.accept(d.Comma))break;while(this.accept(d.Ident));if(!this.accept(d.ParenthesisR))return this.finish(t,f.RightParenthesisExpected,[d.SemiColon])}return!t.addChild(this._parseURILiteral())&&!t.addChild(this._parseStringLiteral())?this.finish(t,f.URIOrStringExpected,[d.SemiColon]):(!this.peek(d.SemiColon)&&!this.peek(d.EOF)&&t.setMedialist(this._parseMediaQueryList()),this.finish(t))},e.prototype._parsePlugin=function(){if(!this.peekKeyword("@plugin"))return null;var t=this.createNode(u.Plugin);return this.consumeToken(),t.addChild(this._parseStringLiteral())?this.accept(d.SemiColon)?this.finish(t):this.finish(t,f.SemiColonExpected):this.finish(t,f.StringLiteralExpected)},e.prototype._parseMediaQuery=function(){var t=n.prototype._parseMediaQuery.call(this);if(!t){var r=this.create(pn);return r.addChild(this._parseVariable())?this.finish(r):null}return t},e.prototype._parseMediaDeclaration=function(t){return t===void 0&&(t=!1),this._tryParseRuleset(t)||this._tryToParseDeclaration()||this._tryParseMixinDeclaration()||this._tryParseMixinReference()||this._parseDetachedRuleSetMixin()||this._parseStylesheetStatement(t)},e.prototype._parseMediaFeatureName=function(){return this._parseIdent()||this._parseVariable()},e.prototype._parseVariableDeclaration=function(t){t===void 0&&(t=[]);var r=this.create($e),i=this.mark();if(!r.setVariable(this._parseVariable(!0)))return null;if(this.accept(d.Colon)){if(this.prevToken&&(r.colonPosition=this.prevToken.offset),r.setValue(this._parseDetachedRuleSet()))r.needsSemicolon=!1;else if(!r.setValue(this._parseExpr()))return this.finish(r,f.VariableValueExpected,[],t);r.addChild(this._parsePrio())}else return this.restoreAtMark(i),null;return this.peek(d.SemiColon)&&(r.semicolonPosition=this.token.offset),this.finish(r)},e.prototype._parseDetachedRuleSet=function(){var t=this.mark();if(this.peekDelim("#")||this.peekDelim("."))if(this.consumeToken(),!this.hasWhitespace()&&this.accept(d.ParenthesisL)){var r=this.create(Ae);if(r.getParameters().addChild(this._parseMixinParameter()))for(;(this.accept(d.Comma)||this.accept(d.SemiColon))&&!this.peek(d.ParenthesisR);)r.getParameters().addChild(this._parseMixinParameter())||this.markError(r,f.IdentifierExpected,[],[d.ParenthesisR]);if(!this.accept(d.ParenthesisR))return this.restoreAtMark(t),null}else return this.restoreAtMark(t),null;if(!this.peek(d.CurlyL))return null;var i=this.create(K);return this._parseBody(i,this._parseDetachedRuleSetBody.bind(this)),this.finish(i)},e.prototype._parseDetachedRuleSetBody=function(){return this._tryParseKeyframeSelector()||this._parseRuleSetDeclaration()},e.prototype._addLookupChildren=function(t){if(!t.addChild(this._parseLookupValue()))return!1;for(var r=!1;this.peek(d.BracketL)&&(r=!0),!!t.addChild(this._parseLookupValue());)r=!1;return!r},e.prototype._parseLookupValue=function(){var t=this.create(F),r=this.mark();return this.accept(d.BracketL)?(t.addChild(this._parseVariable(!1,!0))||t.addChild(this._parsePropertyIdentifier()))&&this.accept(d.BracketR)||this.accept(d.BracketR)?t:(this.restoreAtMark(r),null):(this.restoreAtMark(r),null)},e.prototype._parseVariable=function(t,r){t===void 0&&(t=!1),r===void 0&&(r=!1);var i=!t&&this.peekDelim("$");if(!this.peekDelim("@")&&!i&&!this.peek(d.AtKeyword))return null;for(var o=this.create(ut),s=this.mark();this.acceptDelim("@")||!t&&this.acceptDelim("$");)if(this.hasWhitespace())return this.restoreAtMark(s),null;return!this.accept(d.AtKeyword)&&!this.accept(d.Ident)?(this.restoreAtMark(s),null):!r&&this.peek(d.BracketL)&&!this._addLookupChildren(o)?(this.restoreAtMark(s),null):o},e.prototype._parseTermExpression=function(){return this._parseVariable()||this._parseEscaped()||n.prototype._parseTermExpression.call(this)||this._tryParseMixinReference(!1)},e.prototype._parseEscaped=function(){if(this.peek(d.EscapedJavaScript)||this.peek(d.BadEscapedJavaScript)){var t=this.createNode(u.EscapedValue);return this.consumeToken(),this.finish(t)}if(this.peekDelim("~")){var t=this.createNode(u.EscapedValue);return this.consumeToken(),this.accept(d.String)||this.accept(d.EscapedJavaScript)?this.finish(t):this.finish(t,f.TermExpected)}return null},e.prototype._parseOperator=function(){var t=this._parseGuardOperator();return t||n.prototype._parseOperator.call(this)},e.prototype._parseGuardOperator=function(){if(this.peekDelim(">")){var t=this.createNode(u.Operator);return this.consumeToken(),this.acceptDelim("="),t}else if(this.peekDelim("=")){var t=this.createNode(u.Operator);return this.consumeToken(),this.acceptDelim("<"),t}else if(this.peekDelim("<")){var t=this.createNode(u.Operator);return this.consumeToken(),this.acceptDelim("="),t}return null},e.prototype._parseRuleSetDeclaration=function(){return this.peek(d.AtKeyword)?this._parseKeyframe()||this._parseMedia(!0)||this._parseImport()||this._parseSupports(!0)||this._parseDetachedRuleSetMixin()||this._parseVariableDeclaration()||n.prototype._parseRuleSetDeclarationAtStatement.call(this):this._tryParseMixinDeclaration()||this._tryParseRuleset(!0)||this._tryParseMixinReference()||this._parseFunction()||this._parseExtend()||n.prototype._parseRuleSetDeclaration.call(this)},e.prototype._parseKeyframeIdent=function(){return this._parseIdent([A.Keyframe])||this._parseVariable()},e.prototype._parseKeyframeSelector=function(){return this._parseDetachedRuleSetMixin()||n.prototype._parseKeyframeSelector.call(this)},e.prototype._parseSimpleSelectorBody=function(){return this._parseSelectorCombinator()||n.prototype._parseSimpleSelectorBody.call(this)},e.prototype._parseSelector=function(t){var r=this.create(Ee),i=!1;for(t&&(i=r.addChild(this._parseCombinator()));r.addChild(this._parseSimpleSelector());){i=!0;var o=this.mark();if(r.addChild(this._parseGuard())&&this.peek(d.CurlyL))break;this.restoreAtMark(o),r.addChild(this._parseCombinator())}return i?this.finish(r):null},e.prototype._parseSelectorCombinator=function(){if(this.peekDelim("&")){var t=this.createNode(u.SelectorCombinator);for(this.consumeToken();!this.hasWhitespace()&&(this.acceptDelim("-")||this.accept(d.Num)||this.accept(d.Dimension)||t.addChild(this._parseIdent())||this.acceptDelim("&")););return this.finish(t)}return null},e.prototype._parseSelectorIdent=function(){if(!this.peekInterpolatedIdent())return null;var t=this.createNode(u.SelectorInterpolation),r=this._acceptInterpolatedIdent(t);return r?this.finish(t):null},e.prototype._parsePropertyIdentifier=function(t){t===void 0&&(t=!1);var r=/^[\w-]+/;if(!this.peekInterpolatedIdent()&&!this.peekRegExp(this.token.type,r))return null;var i=this.mark(),o=this.create(te);o.isCustomProperty=this.acceptDelim("-")&&this.acceptDelim("-");var s=!1;return t?o.isCustomProperty?s=o.addChild(this._parseIdent()):s=o.addChild(this._parseRegexp(r)):o.isCustomProperty?s=this._acceptInterpolatedIdent(o):s=this._acceptInterpolatedIdent(o,r),s?(!t&&!this.hasWhitespace()&&(this.acceptDelim("+"),this.hasWhitespace()||this.acceptIdent("_")),this.finish(o)):(this.restoreAtMark(i),null)},e.prototype.peekInterpolatedIdent=function(){return this.peek(d.Ident)||this.peekDelim("@")||this.peekDelim("$")||this.peekDelim("-")},e.prototype._acceptInterpolatedIdent=function(t,r){for(var i=this,o=!1,s=function(){var l=i.mark();return i.acceptDelim("-")&&(i.hasWhitespace()||i.acceptDelim("-"),i.hasWhitespace())?(i.restoreAtMark(l),null):i._parseInterpolation()},a=r?function(){return i.acceptRegexp(r)}:function(){return i.accept(d.Ident)};(a()||t.addChild(this._parseInterpolation()||this.try(s)))&&(o=!0,!this.hasWhitespace()););return o},e.prototype._parseInterpolation=function(){var t=this.mark();if(this.peekDelim("@")||this.peekDelim("$")){var r=this.createNode(u.Interpolation);return this.consumeToken(),this.hasWhitespace()||!this.accept(d.CurlyL)?(this.restoreAtMark(t),null):r.addChild(this._parseIdent())?this.accept(d.CurlyR)?this.finish(r):this.finish(r,f.RightCurlyExpected):this.finish(r,f.IdentifierExpected)}return null},e.prototype._tryParseMixinDeclaration=function(){var t=this.mark(),r=this.create(Ae);if(!r.setIdentifier(this._parseMixinDeclarationIdentifier())||!this.accept(d.ParenthesisL))return this.restoreAtMark(t),null;if(r.getParameters().addChild(this._parseMixinParameter()))for(;(this.accept(d.Comma)||this.accept(d.SemiColon))&&!this.peek(d.ParenthesisR);)r.getParameters().addChild(this._parseMixinParameter())||this.markError(r,f.IdentifierExpected,[],[d.ParenthesisR]);return this.accept(d.ParenthesisR)?(r.setGuard(this._parseGuard()),this.peek(d.CurlyL)?this._parseBody(r,this._parseMixInBodyDeclaration.bind(this)):(this.restoreAtMark(t),null)):(this.restoreAtMark(t),null)},e.prototype._parseMixInBodyDeclaration=function(){return this._parseFontFace()||this._parseRuleSetDeclaration()},e.prototype._parseMixinDeclarationIdentifier=function(){var t;if(this.peekDelim("#")||this.peekDelim(".")){if(t=this.create(te),this.consumeToken(),this.hasWhitespace()||!t.addChild(this._parseIdent()))return null}else if(this.peek(d.Hash))t=this.create(te),this.consumeToken();else return null;return t.referenceTypes=[A.Mixin],this.finish(t)},e.prototype._parsePseudo=function(){if(!this.peek(d.Colon))return null;var t=this.mark(),r=this.create(qe);return this.consumeToken(),this.acceptIdent("extend")?this._completeExtends(r):(this.restoreAtMark(t),n.prototype._parsePseudo.call(this))},e.prototype._parseExtend=function(){if(!this.peekDelim("&"))return null;var t=this.mark(),r=this.create(qe);return this.consumeToken(),this.hasWhitespace()||!this.accept(d.Colon)||!this.acceptIdent("extend")?(this.restoreAtMark(t),null):this._completeExtends(r)},e.prototype._completeExtends=function(t){if(!this.accept(d.ParenthesisL))return this.finish(t,f.LeftParenthesisExpected);var r=t.getSelectors();if(!r.addChild(this._parseSelector(!0)))return this.finish(t,f.SelectorExpected);for(;this.accept(d.Comma);)if(!r.addChild(this._parseSelector(!0)))return this.finish(t,f.SelectorExpected);return this.accept(d.ParenthesisR)?this.finish(t):this.finish(t,f.RightParenthesisExpected)},e.prototype._parseDetachedRuleSetMixin=function(){if(!this.peek(d.AtKeyword))return null;var t=this.mark(),r=this.create(et);return r.addChild(this._parseVariable(!0))&&(this.hasWhitespace()||!this.accept(d.ParenthesisL))?(this.restoreAtMark(t),null):this.accept(d.ParenthesisR)?this.finish(r):this.finish(r,f.RightParenthesisExpected)},e.prototype._tryParseMixinReference=function(t){t===void 0&&(t=!0);for(var r=this.mark(),i=this.create(et),o=this._parseMixinDeclarationIdentifier();o;){this.acceptDelim(">");var s=this._parseMixinDeclarationIdentifier();if(s)i.getNamespaces().addChild(o),o=s;else break}if(!i.setIdentifier(o))return this.restoreAtMark(r),null;var a=!1;if(this.accept(d.ParenthesisL)){if(a=!0,i.getArguments().addChild(this._parseMixinArgument())){for(;(this.accept(d.Comma)||this.accept(d.SemiColon))&&!this.peek(d.ParenthesisR);)if(!i.getArguments().addChild(this._parseMixinArgument()))return this.finish(i,f.ExpressionExpected)}if(!this.accept(d.ParenthesisR))return this.finish(i,f.RightParenthesisExpected);o.referenceTypes=[A.Mixin]}else o.referenceTypes=[A.Mixin,A.Rule];return this.peek(d.BracketL)?t||this._addLookupChildren(i):i.addChild(this._parsePrio()),!a&&!this.peek(d.SemiColon)&&!this.peek(d.CurlyR)&&!this.peek(d.EOF)?(this.restoreAtMark(r),null):this.finish(i)},e.prototype._parseMixinArgument=function(){var t=this.create(we),r=this.mark(),i=this._parseVariable();return i&&(this.accept(d.Colon)?t.setIdentifier(i):this.restoreAtMark(r)),t.setValue(this._parseDetachedRuleSet()||this._parseExpr(!0))?this.finish(t):(this.restoreAtMark(r),null)},e.prototype._parseMixinParameter=function(){var t=this.create(Be);if(this.peekKeyword("@rest")){var r=this.create(F);return this.consumeToken(),this.accept(Wn)?(t.setIdentifier(this.finish(r)),this.finish(t)):this.finish(t,f.DotExpected,[],[d.Comma,d.ParenthesisR])}if(this.peek(Wn)){var i=this.create(F);return this.consumeToken(),t.setIdentifier(this.finish(i)),this.finish(t)}var o=!1;return t.setIdentifier(this._parseVariable())&&(this.accept(d.Colon),o=!0),!t.setDefaultValue(this._parseDetachedRuleSet()||this._parseExpr(!0))&&!o?null:this.finish(t)},e.prototype._parseGuard=function(){if(!this.peekIdent("when"))return null;var t=this.create(Pi);if(this.consumeToken(),t.isNegated=this.acceptIdent("not"),!t.getConditions().addChild(this._parseGuardCondition()))return this.finish(t,f.ConditionExpected);for(;this.acceptIdent("and")||this.accept(d.Comma);)if(!t.getConditions().addChild(this._parseGuardCondition()))return this.finish(t,f.ConditionExpected);return this.finish(t)},e.prototype._parseGuardCondition=function(){if(!this.peek(d.ParenthesisL))return null;var t=this.create(Ai);return this.consumeToken(),t.addChild(this._parseExpr()),this.accept(d.ParenthesisR)?this.finish(t):this.finish(t,f.RightParenthesisExpected)},e.prototype._parseFunction=function(){var t=this.mark(),r=this.create(Pe);if(!r.setIdentifier(this._parseFunctionIdentifier()))return null;if(this.hasWhitespace()||!this.accept(d.ParenthesisL))return this.restoreAtMark(t),null;if(r.getArguments().addChild(this._parseMixinArgument())){for(;(this.accept(d.Comma)||this.accept(d.SemiColon))&&!this.peek(d.ParenthesisR);)if(!r.getArguments().addChild(this._parseMixinArgument()))return this.finish(r,f.ExpressionExpected)}return this.accept(d.ParenthesisR)?this.finish(r):this.finish(r,f.RightParenthesisExpected)},e.prototype._parseFunctionIdentifier=function(){if(this.peekDelim("%")){var t=this.create(te);return t.referenceTypes=[A.Function],this.consumeToken(),this.finish(t)}return n.prototype._parseFunctionIdentifier.call(this)},e.prototype._parseURLArgument=function(){var t=this.mark(),r=n.prototype._parseURLArgument.call(this);if(!r||!this.peek(d.ParenthesisR)){this.restoreAtMark(t);var i=this.create(F);return i.addChild(this._parseBinaryExpr()),this.finish(i)}return r},e}(bt);var $a=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,i){r.__proto__=i}||function(r,i){for(var o in i)Object.prototype.hasOwnProperty.call(i,o)&&(r[o]=i[o])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),I=H(),Jo=function(n){$a(e,n);function e(t,r){return n.call(this,"@",t,r)||this}return e.prototype.createFunctionProposals=function(t,r,i,o){for(var s=0,a=t;s<a.length;s++){var l=a[s],c={label:l.name,detail:l.example,documentation:l.description,textEdit:T.replace(this.getCompletionRange(r),l.name+"($0)"),insertTextFormat:re.Snippet,kind:R.Function};i&&(c.sortText="z"),o.items.push(c)}return o},e.prototype.getTermProposals=function(t,r,i){var o=e.builtInProposals;return t&&(o=o.filter(function(s){return!s.type||!t.restrictions||t.restrictions.indexOf(s.type)!==-1})),this.createFunctionProposals(o,r,!0,i),n.prototype.getTermProposals.call(this,t,r,i)},e.prototype.getColorProposals=function(t,r,i){return this.createFunctionProposals(e.colorProposals,r,!1,i),n.prototype.getColorProposals.call(this,t,r,i)},e.prototype.getCompletionsForDeclarationProperty=function(t,r){return this.getCompletionsForSelector(null,!0,r),n.prototype.getCompletionsForDeclarationProperty.call(this,t,r)},e.builtInProposals=[{name:"if",example:"if(condition, trueValue [, falseValue]);",description:I("less.builtin.if","returns one of two values depending on a condition.")},{name:"boolean",example:"boolean(condition);",description:I("less.builtin.boolean",'"store" a boolean test for later evaluation in a guard or if().')},{name:"length",example:"length(@list);",description:I("less.builtin.length","returns the number of elements in a value list")},{name:"extract",example:"extract(@list, index);",description:I("less.builtin.extract","returns a value at the specified position in the list")},{name:"range",example:"range([start, ] end [, step]);",description:I("less.builtin.range","generate a list spanning a range of values")},{name:"each",example:"each(@list, ruleset);",description:I("less.builtin.each","bind the evaluation of a ruleset to each member of a list.")},{name:"escape",example:"escape(@string);",description:I("less.builtin.escape","URL encodes a string")},{name:"e",example:"e(@string);",description:I("less.builtin.e","escape string content")},{name:"replace",example:"replace(@string, @pattern, @replacement[, @flags]);",description:I("less.builtin.replace","string replace")},{name:"unit",example:"unit(@dimension, [@unit: '']);",description:I("less.builtin.unit","remove or change the unit of a dimension")},{name:"color",example:"color(@string);",description:I("less.builtin.color","parses a string to a color"),type:"color"},{name:"convert",example:"convert(@value, unit);",description:I("less.builtin.convert","converts numbers from one type into another")},{name:"data-uri",example:"data-uri([mimetype,] url);",description:I("less.builtin.data-uri","inlines a resource and falls back to `url()`"),type:"url"},{name:"abs",description:I("less.builtin.abs","absolute value of a number"),example:"abs(number);"},{name:"acos",description:I("less.builtin.acos","arccosine - inverse of cosine function"),example:"acos(number);"},{name:"asin",description:I("less.builtin.asin","arcsine - inverse of sine function"),example:"asin(number);"},{name:"ceil",example:"ceil(@number);",description:I("less.builtin.ceil","rounds up to an integer")},{name:"cos",description:I("less.builtin.cos","cosine function"),example:"cos(number);"},{name:"floor",description:I("less.builtin.floor","rounds down to an integer"),example:"floor(@number);"},{name:"percentage",description:I("less.builtin.percentage","converts to a %, e.g. 0.5 > 50%"),example:"percentage(@number);",type:"percentage"},{name:"round",description:I("less.builtin.round","rounds a number to a number of places"),example:"round(number, [places: 0]);"},{name:"sqrt",description:I("less.builtin.sqrt","calculates square root of a number"),example:"sqrt(number);"},{name:"sin",description:I("less.builtin.sin","sine function"),example:"sin(number);"},{name:"tan",description:I("less.builtin.tan","tangent function"),example:"tan(number);"},{name:"atan",description:I("less.builtin.atan","arctangent - inverse of tangent function"),example:"atan(number);"},{name:"pi",description:I("less.builtin.pi","returns pi"),example:"pi();"},{name:"pow",description:I("less.builtin.pow","first argument raised to the power of the second argument"),example:"pow(@base, @exponent);"},{name:"mod",description:I("less.builtin.mod","first argument modulus second argument"),example:"mod(number, number);"},{name:"min",description:I("less.builtin.min","returns the lowest of one or more values"),example:"min(@x, @y);"},{name:"max",description:I("less.builtin.max","returns the lowest of one or more values"),example:"max(@x, @y);"}],e.colorProposals=[{name:"argb",example:"argb(@color);",description:I("less.builtin.argb","creates a #AARRGGBB")},{name:"hsl",example:"hsl(@hue, @saturation, @lightness);",description:I("less.builtin.hsl","creates a color")},{name:"hsla",example:"hsla(@hue, @saturation, @lightness, @alpha);",description:I("less.builtin.hsla","creates a color")},{name:"hsv",example:"hsv(@hue, @saturation, @value);",description:I("less.builtin.hsv","creates a color")},{name:"hsva",example:"hsva(@hue, @saturation, @value, @alpha);",description:I("less.builtin.hsva","creates a color")},{name:"hue",example:"hue(@color);",description:I("less.builtin.hue","returns the `hue` channel of `@color` in the HSL space")},{name:"saturation",example:"saturation(@color);",description:I("less.builtin.saturation","returns the `saturation` channel of `@color` in the HSL space")},{name:"lightness",example:"lightness(@color);",description:I("less.builtin.lightness","returns the `lightness` channel of `@color` in the HSL space")},{name:"hsvhue",example:"hsvhue(@color);",description:I("less.builtin.hsvhue","returns the `hue` channel of `@color` in the HSV space")},{name:"hsvsaturation",example:"hsvsaturation(@color);",description:I("less.builtin.hsvsaturation","returns the `saturation` channel of `@color` in the HSV space")},{name:"hsvvalue",example:"hsvvalue(@color);",description:I("less.builtin.hsvvalue","returns the `value` channel of `@color` in the HSV space")},{name:"red",example:"red(@color);",description:I("less.builtin.red","returns the `red` channel of `@color`")},{name:"green",example:"green(@color);",description:I("less.builtin.green","returns the `green` channel of `@color`")},{name:"blue",example:"blue(@color);",description:I("less.builtin.blue","returns the `blue` channel of `@color`")},{name:"alpha",example:"alpha(@color);",description:I("less.builtin.alpha","returns the `alpha` channel of `@color`")},{name:"luma",example:"luma(@color);",description:I("less.builtin.luma","returns the `luma` value (perceptual brightness) of `@color`")},{name:"saturate",example:"saturate(@color, 10%);",description:I("less.builtin.saturate","return `@color` 10% points more saturated")},{name:"desaturate",example:"desaturate(@color, 10%);",description:I("less.builtin.desaturate","return `@color` 10% points less saturated")},{name:"lighten",example:"lighten(@color, 10%);",description:I("less.builtin.lighten","return `@color` 10% points lighter")},{name:"darken",example:"darken(@color, 10%);",description:I("less.builtin.darken","return `@color` 10% points darker")},{name:"fadein",example:"fadein(@color, 10%);",description:I("less.builtin.fadein","return `@color` 10% points less transparent")},{name:"fadeout",example:"fadeout(@color, 10%);",description:I("less.builtin.fadeout","return `@color` 10% points more transparent")},{name:"fade",example:"fade(@color, 50%);",description:I("less.builtin.fade","return `@color` with 50% transparency")},{name:"spin",example:"spin(@color, 10);",description:I("less.builtin.spin","return `@color` with a 10 degree larger in hue")},{name:"mix",example:"mix(@color1, @color2, [@weight: 50%]);",description:I("less.builtin.mix","return a mix of `@color1` and `@color2`")},{name:"greyscale",example:"greyscale(@color);",description:I("less.builtin.greyscale","returns a grey, 100% desaturated color")},{name:"contrast",example:"contrast(@color1, [@darkcolor: black], [@lightcolor: white], [@threshold: 43%]);",description:I("less.builtin.contrast","return `@darkcolor` if `@color1 is> 43% luma` otherwise return `@lightcolor`, see notes")},{name:"multiply",example:"multiply(@color1, @color2);"},{name:"screen",example:"screen(@color1, @color2);"},{name:"overlay",example:"overlay(@color1, @color2);"},{name:"softlight",example:"softlight(@color1, @color2);"},{name:"hardlight",example:"hardlight(@color1, @color2);"},{name:"difference",example:"difference(@color1, @color2);"},{name:"exclusion",example:"exclusion(@color1, @color2);"},{name:"average",example:"average(@color1, @color2);"},{name:"negation",example:"negation(@color1, @color2);"}],e}(yt);function Yo(n,e){var t=qa(n);return Ka(t,e)}function qa(n){function e(p){return n.positionAt(p.offset).line}function t(p){return n.positionAt(p.offset+p.len).line}function r(){switch(n.languageId){case"scss":return new Nn;case"less":return new Ln;default:return new Fe}}function i(p,m){var g=e(p),w=t(p);return g!==w?{startLine:g,endLine:w,kind:m}:null}var o=[],s=[],a=r();a.ignoreComment=!1,a.setSource(n.getText());for(var l=a.scan(),c=null,h=function(){switch(l.type){case d.CurlyL:case St:{s.push({line:e(l),type:"brace",isStart:!0});break}case d.CurlyR:{if(s.length!==0){var p=Xo(s,"brace");if(!p)break;var m=t(l);p.type==="brace"&&(c&&t(c)!==m&&m--,p.line!==m&&o.push({startLine:p.line,endLine:m,kind:void 0}))}break}case d.Comment:{var g=function(D){return D==="#region"?{line:e(l),type:"comment",isStart:!0}:{line:t(l),type:"comment",isStart:!1}},w=function(D){var M=D.text.match(/^\s*\/\*\s*(#region|#endregion)\b\s*(.*?)\s*\*\//);if(M)return g(M[1]);if(n.languageId==="scss"||n.languageId==="less"){var z=D.text.match(/^\s*\/\/\s*(#region|#endregion)\b\s*(.*?)\s*/);if(z)return g(z[1])}return null},x=w(l);if(x)if(x.isStart)s.push(x);else{var p=Xo(s,"comment");if(!p)break;p.type==="comment"&&p.line!==x.line&&o.push({startLine:p.line,endLine:x.line,kind:"region"})}else{var y=i(l,"comment");y&&o.push(y)}break}}c=l,l=a.scan()};l.type!==d.EOF;)h();return o}function Xo(n,e){if(n.length===0)return null;for(var t=n.length-1;t>=0;t--)if(n[t].type===e&&n[t].isStart)return n.splice(t,1)[0];return null}function Ka(n,e){var t=e&&e.rangeLimit||Number.MAX_VALUE,r=n.sort(function(s,a){var l=s.startLine-a.startLine;return l===0&&(l=s.endLine-a.endLine),l}),i=[],o=-1;return r.forEach(function(s){s.startLine<o&&o<s.endLine||(i.push(s),o=s.endLine)}),i.length<t?i:i.slice(0,t)}var Qo;(function(){"use strict";var n=[,,function(i){function o(l){this.__parent=l,this.__character_count=0,this.__indent_count=-1,this.__alignment_count=0,this.__wrap_point_index=0,this.__wrap_point_character_count=0,this.__wrap_point_indent_count=-1,this.__wrap_point_alignment_count=0,this.__items=[]}o.prototype.clone_empty=function(){var l=new o(this.__parent);return l.set_indent(this.__indent_count,this.__alignment_count),l},o.prototype.item=function(l){return l<0?this.__items[this.__items.length+l]:this.__items[l]},o.prototype.has_match=function(l){for(var c=this.__items.length-1;c>=0;c--)if(this.__items[c].match(l))return!0;return!1},o.prototype.set_indent=function(l,c){this.is_empty()&&(this.__indent_count=l||0,this.__alignment_count=c||0,this.__character_count=this.__parent.get_indent_size(this.__indent_count,this.__alignment_count))},o.prototype._set_wrap_point=function(){this.__parent.wrap_line_length&&(this.__wrap_point_index=this.__items.length,this.__wrap_point_character_count=this.__character_count,this.__wrap_point_indent_count=this.__parent.next_line.__indent_count,this.__wrap_point_alignment_count=this.__parent.next_line.__alignment_count)},o.prototype._should_wrap=function(){return this.__wrap_point_index&&this.__character_count>this.__parent.wrap_line_length&&this.__wrap_point_character_count>this.__parent.next_line.__character_count},o.prototype._allow_wrap=function(){if(this._should_wrap()){this.__parent.add_new_line();var l=this.__parent.current_line;return l.set_indent(this.__wrap_point_indent_count,this.__wrap_point_alignment_count),l.__items=this.__items.slice(this.__wrap_point_index),this.__items=this.__items.slice(0,this.__wrap_point_index),l.__character_count+=this.__character_count-this.__wrap_point_character_count,this.__character_count=this.__wrap_point_character_count,l.__items[0]===" "&&(l.__items.splice(0,1),l.__character_count-=1),!0}return!1},o.prototype.is_empty=function(){return this.__items.length===0},o.prototype.last=function(){return this.is_empty()?null:this.__items[this.__items.length-1]},o.prototype.push=function(l){this.__items.push(l);var c=l.lastIndexOf(`
`);c!==-1?this.__character_count=l.length-c:this.__character_count+=l.length},o.prototype.pop=function(){var l=null;return this.is_empty()||(l=this.__items.pop(),this.__character_count-=l.length),l},o.prototype._remove_indent=function(){this.__indent_count>0&&(this.__indent_count-=1,this.__character_count-=this.__parent.indent_size)},o.prototype._remove_wrap_indent=function(){this.__wrap_point_indent_count>0&&(this.__wrap_point_indent_count-=1)},o.prototype.trim=function(){for(;this.last()===" ";)this.__items.pop(),this.__character_count-=1},o.prototype.toString=function(){var l="";return this.is_empty()?this.__parent.indent_empty_lines&&(l=this.__parent.get_indent_string(this.__indent_count)):(l=this.__parent.get_indent_string(this.__indent_count,this.__alignment_count),l+=this.__items.join("")),l};function s(l,c){this.__cache=[""],this.__indent_size=l.indent_size,this.__indent_string=l.indent_char,l.indent_with_tabs||(this.__indent_string=new Array(l.indent_size+1).join(l.indent_char)),c=c||"",l.indent_level>0&&(c=new Array(l.indent_level+1).join(this.__indent_string)),this.__base_string=c,this.__base_string_length=c.length}s.prototype.get_indent_size=function(l,c){var h=this.__base_string_length;return c=c||0,l<0&&(h=0),h+=l*this.__indent_size,h+=c,h},s.prototype.get_indent_string=function(l,c){var h=this.__base_string;return c=c||0,l<0&&(l=0,h=""),c+=l*this.__indent_size,this.__ensure_cache(c),h+=this.__cache[c],h},s.prototype.__ensure_cache=function(l){for(;l>=this.__cache.length;)this.__add_column()},s.prototype.__add_column=function(){var l=this.__cache.length,c=0,h="";this.__indent_size&&l>=this.__indent_size&&(c=Math.floor(l/this.__indent_size),l-=c*this.__indent_size,h=new Array(c+1).join(this.__indent_string)),l&&(h+=new Array(l+1).join(" ")),this.__cache.push(h)};function a(l,c){this.__indent_cache=new s(l,c),this.raw=!1,this._end_with_newline=l.end_with_newline,this.indent_size=l.indent_size,this.wrap_line_length=l.wrap_line_length,this.indent_empty_lines=l.indent_empty_lines,this.__lines=[],this.previous_line=null,this.current_line=null,this.next_line=new o(this),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=!1,this.__add_outputline()}a.prototype.__add_outputline=function(){this.previous_line=this.current_line,this.current_line=this.next_line.clone_empty(),this.__lines.push(this.current_line)},a.prototype.get_line_number=function(){return this.__lines.length},a.prototype.get_indent_string=function(l,c){return this.__indent_cache.get_indent_string(l,c)},a.prototype.get_indent_size=function(l,c){return this.__indent_cache.get_indent_size(l,c)},a.prototype.is_empty=function(){return!this.previous_line&&this.current_line.is_empty()},a.prototype.add_new_line=function(l){return this.is_empty()||!l&&this.just_added_newline()?!1:(this.raw||this.__add_outputline(),!0)},a.prototype.get_code=function(l){this.trim(!0);var c=this.current_line.pop();c&&(c[c.length-1]===`
`&&(c=c.replace(/\n+$/g,"")),this.current_line.push(c)),this._end_with_newline&&this.__add_outputline();var h=this.__lines.join(`
`);return l!==`
`&&(h=h.replace(/[\n]/g,l)),h},a.prototype.set_wrap_point=function(){this.current_line._set_wrap_point()},a.prototype.set_indent=function(l,c){return l=l||0,c=c||0,this.next_line.set_indent(l,c),this.__lines.length>1?(this.current_line.set_indent(l,c),!0):(this.current_line.set_indent(),!1)},a.prototype.add_raw_token=function(l){for(var c=0;c<l.newlines;c++)this.__add_outputline();this.current_line.set_indent(-1),this.current_line.push(l.whitespace_before),this.current_line.push(l.text),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=!1},a.prototype.add_token=function(l){this.__add_space_before_token(),this.current_line.push(l),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=this.current_line._allow_wrap()},a.prototype.__add_space_before_token=function(){this.space_before_token&&!this.just_added_newline()&&(this.non_breaking_space||this.set_wrap_point(),this.current_line.push(" "))},a.prototype.remove_indent=function(l){for(var c=this.__lines.length;l<c;)this.__lines[l]._remove_indent(),l++;this.current_line._remove_wrap_indent()},a.prototype.trim=function(l){for(l=l===void 0?!1:l,this.current_line.trim();l&&this.__lines.length>1&&this.current_line.is_empty();)this.__lines.pop(),this.current_line=this.__lines[this.__lines.length-1],this.current_line.trim();this.previous_line=this.__lines.length>1?this.__lines[this.__lines.length-2]:null},a.prototype.just_added_newline=function(){return this.current_line.is_empty()},a.prototype.just_added_blankline=function(){return this.is_empty()||this.current_line.is_empty()&&this.previous_line.is_empty()},a.prototype.ensure_empty_line_above=function(l,c){for(var h=this.__lines.length-2;h>=0;){var p=this.__lines[h];if(p.is_empty())break;if(p.item(0).indexOf(l)!==0&&p.item(-1)!==c){this.__lines.splice(h+1,0,new o(this)),this.previous_line=this.__lines[this.__lines.length-2];break}h--}},i.exports.Output=a},,,,function(i){function o(l,c){this.raw_options=s(l,c),this.disabled=this._get_boolean("disabled"),this.eol=this._get_characters("eol","auto"),this.end_with_newline=this._get_boolean("end_with_newline"),this.indent_size=this._get_number("indent_size",4),this.indent_char=this._get_characters("indent_char"," "),this.indent_level=this._get_number("indent_level"),this.preserve_newlines=this._get_boolean("preserve_newlines",!0),this.max_preserve_newlines=this._get_number("max_preserve_newlines",32786),this.preserve_newlines||(this.max_preserve_newlines=0),this.indent_with_tabs=this._get_boolean("indent_with_tabs",this.indent_char==="	"),this.indent_with_tabs&&(this.indent_char="	",this.indent_size===1&&(this.indent_size=4)),this.wrap_line_length=this._get_number("wrap_line_length",this._get_number("max_char")),this.indent_empty_lines=this._get_boolean("indent_empty_lines"),this.templating=this._get_selection_list("templating",["auto","none","django","erb","handlebars","php","smarty"],["auto"])}o.prototype._get_array=function(l,c){var h=this.raw_options[l],p=c||[];return typeof h=="object"?h!==null&&typeof h.concat=="function"&&(p=h.concat()):typeof h=="string"&&(p=h.split(/[^a-zA-Z0-9_\/\-]+/)),p},o.prototype._get_boolean=function(l,c){var h=this.raw_options[l],p=h===void 0?!!c:!!h;return p},o.prototype._get_characters=function(l,c){var h=this.raw_options[l],p=c||"";return typeof h=="string"&&(p=h.replace(/\\r/,"\r").replace(/\\n/,`
`).replace(/\\t/,"	")),p},o.prototype._get_number=function(l,c){var h=this.raw_options[l];c=parseInt(c,10),isNaN(c)&&(c=0);var p=parseInt(h,10);return isNaN(p)&&(p=c),p},o.prototype._get_selection=function(l,c,h){var p=this._get_selection_list(l,c,h);if(p.length!==1)throw new Error("Invalid Option Value: The option '"+l+`' can only be one of the following values:
`+c+`
You passed in: '`+this.raw_options[l]+"'");return p[0]},o.prototype._get_selection_list=function(l,c,h){if(!c||c.length===0)throw new Error("Selection list cannot be empty.");if(h=h||[c[0]],!this._is_valid_selection(h,c))throw new Error("Invalid Default Value!");var p=this._get_array(l,h);if(!this._is_valid_selection(p,c))throw new Error("Invalid Option Value: The option '"+l+`' can contain only the following values:
`+c+`
You passed in: '`+this.raw_options[l]+"'");return p},o.prototype._is_valid_selection=function(l,c){return l.length&&c.length&&!l.some(function(h){return c.indexOf(h)===-1})};function s(l,c){var h={};l=a(l);var p;for(p in l)p!==c&&(h[p]=l[p]);if(c&&l[c])for(p in l[c])h[p]=l[c][p];return h}function a(l){var c={},h;for(h in l){var p=h.replace(/-/g,"_");c[p]=l[h]}return c}i.exports.Options=o,i.exports.normalizeOpts=a,i.exports.mergeOpts=s},,function(i){var o=RegExp.prototype.hasOwnProperty("sticky");function s(a){this.__input=a||"",this.__input_length=this.__input.length,this.__position=0}s.prototype.restart=function(){this.__position=0},s.prototype.back=function(){this.__position>0&&(this.__position-=1)},s.prototype.hasNext=function(){return this.__position<this.__input_length},s.prototype.next=function(){var a=null;return this.hasNext()&&(a=this.__input.charAt(this.__position),this.__position+=1),a},s.prototype.peek=function(a){var l=null;return a=a||0,a+=this.__position,a>=0&&a<this.__input_length&&(l=this.__input.charAt(a)),l},s.prototype.__match=function(a,l){a.lastIndex=l;var c=a.exec(this.__input);return c&&!(o&&a.sticky)&&c.index!==l&&(c=null),c},s.prototype.test=function(a,l){return l=l||0,l+=this.__position,l>=0&&l<this.__input_length?!!this.__match(a,l):!1},s.prototype.testChar=function(a,l){var c=this.peek(l);return a.lastIndex=0,c!==null&&a.test(c)},s.prototype.match=function(a){var l=this.__match(a,this.__position);return l?this.__position+=l[0].length:l=null,l},s.prototype.read=function(a,l,c){var h="",p;return a&&(p=this.match(a),p&&(h+=p[0])),l&&(p||!a)&&(h+=this.readUntil(l,c)),h},s.prototype.readUntil=function(a,l){var c="",h=this.__position;a.lastIndex=this.__position;var p=a.exec(this.__input);return p?(h=p.index,l&&(h+=p[0].length)):h=this.__input_length,c=this.__input.substring(this.__position,h),this.__position=h,c},s.prototype.readUntilAfter=function(a){return this.readUntil(a,!0)},s.prototype.get_regexp=function(a,l){var c=null,h="g";return l&&o&&(h="y"),typeof a=="string"&&a!==""?c=new RegExp(a,h):a&&(c=new RegExp(a.source,h)),c},s.prototype.get_literal_regexp=function(a){return RegExp(a.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&"))},s.prototype.peekUntilAfter=function(a){var l=this.__position,c=this.readUntilAfter(a);return this.__position=l,c},s.prototype.lookBack=function(a){var l=this.__position-1;return l>=a.length&&this.__input.substring(l-a.length,l).toLowerCase()===a},i.exports.InputScanner=s},,,,,function(i){function o(s,a){s=typeof s=="string"?s:s.source,a=typeof a=="string"?a:a.source,this.__directives_block_pattern=new RegExp(s+/ beautify( \w+[:]\w+)+ /.source+a,"g"),this.__directive_pattern=/ (\w+)[:](\w+)/g,this.__directives_end_ignore_pattern=new RegExp(s+/\sbeautify\signore:end\s/.source+a,"g")}o.prototype.get_directives=function(s){if(!s.match(this.__directives_block_pattern))return null;var a={};this.__directive_pattern.lastIndex=0;for(var l=this.__directive_pattern.exec(s);l;)a[l[1]]=l[2],l=this.__directive_pattern.exec(s);return a},o.prototype.readIgnored=function(s){return s.readUntilAfter(this.__directives_end_ignore_pattern)},i.exports.Directives=o},,function(i,o,s){var a=s(16).Beautifier,l=s(17).Options;function c(h,p){var m=new a(h,p);return m.beautify()}i.exports=c,i.exports.defaultOptions=function(){return new l}},function(i,o,s){var a=s(17).Options,l=s(2).Output,c=s(8).InputScanner,h=s(13).Directives,p=new h(/\/\*/,/\*\//),m=/\r\n|[\r\n]/,g=/\r\n|[\r\n]/g,w=/\s/,x=/(?:\s|\n)+/g,y=/\/\*(?:[\s\S]*?)((?:\*\/)|$)/g,D=/\/\/(?:[^\n\r\u2028\u2029]*)/g;function M(z,P){this._source_text=z||"",this._options=new a(P),this._ch=null,this._input=null,this.NESTED_AT_RULE={"@page":!0,"@font-face":!0,"@keyframes":!0,"@media":!0,"@supports":!0,"@document":!0},this.CONDITIONAL_GROUP_RULE={"@media":!0,"@supports":!0,"@document":!0}}M.prototype.eatString=function(z){var P="";for(this._ch=this._input.next();this._ch;){if(P+=this._ch,this._ch==="\\")P+=this._input.next();else if(z.indexOf(this._ch)!==-1||this._ch===`
`)break;this._ch=this._input.next()}return P},M.prototype.eatWhitespace=function(z){for(var P=w.test(this._input.peek()),L=0;w.test(this._input.peek());)this._ch=this._input.next(),z&&this._ch===`
`&&(L===0||L<this._options.max_preserve_newlines)&&(L++,this._output.add_new_line(!0));return P},M.prototype.foundNestedPseudoClass=function(){for(var z=0,P=1,L=this._input.peek(P);L;){if(L==="{")return!0;if(L==="(")z+=1;else if(L===")"){if(z===0)return!1;z-=1}else if(L===";"||L==="}")return!1;P++,L=this._input.peek(P)}return!1},M.prototype.print_string=function(z){this._output.set_indent(this._indentLevel),this._output.non_breaking_space=!0,this._output.add_token(z)},M.prototype.preserveSingleSpace=function(z){z&&(this._output.space_before_token=!0)},M.prototype.indent=function(){this._indentLevel++},M.prototype.outdent=function(){this._indentLevel>0&&this._indentLevel--},M.prototype.beautify=function(){if(this._options.disabled)return this._source_text;var z=this._source_text,P=this._options.eol;P==="auto"&&(P=`
`,z&&m.test(z||"")&&(P=z.match(m)[0])),z=z.replace(g,`
`);var L=z.match(/^[\t ]*/)[0];this._output=new l(this._options,L),this._input=new c(z),this._indentLevel=0,this._nestedLevel=0,this._ch=null;for(var $=0,ue=!1,oe=!1,me=!1,ve=!1,ye=!1,ke=this._ch,pe,G,Ie;pe=this._input.read(x),G=pe!=="",Ie=ke,this._ch=this._input.next(),this._ch==="\\"&&this._input.hasNext()&&(this._ch+=this._input.next()),ke=this._ch,this._ch;)if(this._ch==="/"&&this._input.peek()==="*"){this._output.add_new_line(),this._input.back();var fe=this._input.read(y),C=p.get_directives(fe);C&&C.ignore==="start"&&(fe+=p.readIgnored(this._input)),this.print_string(fe),this.eatWhitespace(!0),this._output.add_new_line()}else if(this._ch==="/"&&this._input.peek()==="/")this._output.space_before_token=!0,this._input.back(),this.print_string(this._input.read(D)),this.eatWhitespace(!0);else if(this._ch==="@")if(this.preserveSingleSpace(G),this._input.peek()==="{")this.print_string(this._ch+this.eatString("}"));else{this.print_string(this._ch);var b=this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);b.match(/[ :]$/)&&(b=this.eatString(": ").replace(/\s$/,""),this.print_string(b),this._output.space_before_token=!0),b=b.replace(/\s$/,""),b==="extend"?ve=!0:b==="import"&&(ye=!0),b in this.NESTED_AT_RULE?(this._nestedLevel+=1,b in this.CONDITIONAL_GROUP_RULE&&(me=!0)):!ue&&$===0&&b.indexOf(":")!==-1&&(oe=!0,this.indent())}else this._ch==="#"&&this._input.peek()==="{"?(this.preserveSingleSpace(G),this.print_string(this._ch+this.eatString("}"))):this._ch==="{"?(oe&&(oe=!1,this.outdent()),me?(me=!1,ue=this._indentLevel>=this._nestedLevel):ue=this._indentLevel>=this._nestedLevel-1,this._options.newline_between_rules&&ue&&this._output.previous_line&&this._output.previous_line.item(-1)!=="{"&&this._output.ensure_empty_line_above("/",","),this._output.space_before_token=!0,this._options.brace_style==="expand"?(this._output.add_new_line(),this.print_string(this._ch),this.indent(),this._output.set_indent(this._indentLevel)):(this.indent(),this.print_string(this._ch)),this.eatWhitespace(!0),this._output.add_new_line()):this._ch==="}"?(this.outdent(),this._output.add_new_line(),Ie==="{"&&this._output.trim(!0),ye=!1,ve=!1,oe&&(this.outdent(),oe=!1),this.print_string(this._ch),ue=!1,this._nestedLevel&&this._nestedLevel--,this.eatWhitespace(!0),this._output.add_new_line(),this._options.newline_between_rules&&!this._output.just_added_blankline()&&this._input.peek()!=="}"&&this._output.add_new_line(!0)):this._ch===":"?(ue||me)&&!(this._input.lookBack("&")||this.foundNestedPseudoClass())&&!this._input.lookBack("(")&&!ve&&$===0?(this.print_string(":"),oe||(oe=!0,this._output.space_before_token=!0,this.eatWhitespace(!0),this.indent())):(this._input.lookBack(" ")&&(this._output.space_before_token=!0),this._input.peek()===":"?(this._ch=this._input.next(),this.print_string("::")):this.print_string(":")):this._ch==='"'||this._ch==="'"?(this.preserveSingleSpace(G),this.print_string(this._ch+this.eatString(this._ch)),this.eatWhitespace(!0)):this._ch===";"?$===0?(oe&&(this.outdent(),oe=!1),ve=!1,ye=!1,this.print_string(this._ch),this.eatWhitespace(!0),this._input.peek()!=="/"&&this._output.add_new_line()):(this.print_string(this._ch),this.eatWhitespace(!0),this._output.space_before_token=!0):this._ch==="("?this._input.lookBack("url")?(this.print_string(this._ch),this.eatWhitespace(),$++,this.indent(),this._ch=this._input.next(),this._ch===")"||this._ch==='"'||this._ch==="'"?this._input.back():this._ch&&(this.print_string(this._ch+this.eatString(")")),$&&($--,this.outdent()))):(this.preserveSingleSpace(G),this.print_string(this._ch),this.eatWhitespace(),$++,this.indent()):this._ch===")"?($&&($--,this.outdent()),this.print_string(this._ch)):this._ch===","?(this.print_string(this._ch),this.eatWhitespace(!0),this._options.selector_separator_newline&&!oe&&$===0&&!ye&&!ve?this._output.add_new_line():this._output.space_before_token=!0):(this._ch===">"||this._ch==="+"||this._ch==="~")&&!oe&&$===0?this._options.space_around_combinator?(this._output.space_before_token=!0,this.print_string(this._ch),this._output.space_before_token=!0):(this.print_string(this._ch),this.eatWhitespace(),this._ch&&w.test(this._ch)&&(this._ch="")):this._ch==="]"?this.print_string(this._ch):this._ch==="["?(this.preserveSingleSpace(G),this.print_string(this._ch)):this._ch==="="?(this.eatWhitespace(),this.print_string("="),w.test(this._ch)&&(this._ch="")):this._ch==="!"&&!this._input.lookBack("\\")?(this.print_string(" "),this.print_string(this._ch)):(this.preserveSingleSpace(G),this.print_string(this._ch));var k=this._output.get_code(P);return k},i.exports.Beautifier=M},function(i,o,s){var a=s(6).Options;function l(c){a.call(this,c,"css"),this.selector_separator_newline=this._get_boolean("selector_separator_newline",!0),this.newline_between_rules=this._get_boolean("newline_between_rules",!0);var h=this._get_boolean("space_around_selector_separator");this.space_around_combinator=this._get_boolean("space_around_combinator")||h;var p=this._get_selection_list("brace_style",["collapse","expand","end-expand","none","preserve-inline"]);this.brace_style="collapse";for(var m=0;m<p.length;m++)p[m]!=="expand"?this.brace_style="collapse":this.brace_style=p[m]}l.prototype=new a,i.exports.Options=l}],e={};function t(i){var o=e[i];if(o!==void 0)return o.exports;var s=e[i]={exports:{}};return n[i](s,s.exports,t),s.exports}var r=t(15);Qo=r})();var Zo=Qo;function rs(n,e,t){var r=n.getText(),i=!0,o=0,s=!1,a=t.tabSize||4;if(e){for(var l=n.offsetAt(e.start),c=l;c>0&&ns(r,c-1);)c--;c===0||ts(r,c-1)?l=c:c<l&&(l=c+1);for(var h=n.offsetAt(e.end),p=h;p<r.length&&ns(r,p);)p++;if((p===r.length||ts(r,p))&&(h=p),e=W.create(n.positionAt(l),n.positionAt(h)),s=Ja(r,l),i=h===r.length,r=r.substring(l,h),l!==0){var m=n.offsetAt(Q.create(e.start.line,0));o=Xa(n.getText(),m,t)}s&&(r=`{
`.concat(es(r)))}else e=W.create(Q.create(0,0),n.positionAt(r.length));var g={indent_size:a,indent_char:t.insertSpaces?" ":"	",end_with_newline:i&&Ve(t,"insertFinalNewline",!1),selector_separator_newline:Ve(t,"newlineBetweenSelectors",!0),newline_between_rules:Ve(t,"newlineBetweenRules",!0),space_around_selector_separator:Ve(t,"spaceAroundSelectorSeparator",!1),brace_style:Ve(t,"braceStyle","collapse"),indent_empty_lines:Ve(t,"indentEmptyLines",!1),max_preserve_newlines:Ve(t,"maxPreserveNewLines",void 0),preserve_newlines:Ve(t,"preserveNewLines",!0),wrap_line_length:Ve(t,"wrapLineLength",void 0),eol:`
`},w=Zo(r,g);if(s&&(w=es(w.substring(2))),o>0){var x=t.insertSpaces?Xn(" ",a*o):Xn("	",o);w=w.split(`
`).join(`
`+x),e.start.character===0&&(w=x+w)}return[{range:e,newText:w}]}function es(n){return n.replace(/^\s+/,"")}var Ga="{".charCodeAt(0),Ha="}".charCodeAt(0);function Ja(n,e){for(;e>=0;){var t=n.charCodeAt(e);if(t===Ga)return!0;if(t===Ha)return!1;e--}return!1}function Ve(n,e,t){if(n&&n.hasOwnProperty(e)){var r=n[e];if(r!==null)return r}return t}function Xa(n,e,t){for(var r=e,i=0,o=t.tabSize||4;r<n.length;){var s=n.charAt(r);if(s===" ")i++;else if(s==="	")i+=o;else break;r++}return Math.floor(i/o)}function ts(n,e){return`\r
`.indexOf(n.charAt(e))!==-1}function ns(n,e){return" 	".indexOf(n.charAt(e))!==-1}var Br={version:1.1,properties:[{name:"additive-symbols",browsers:["FF33"],syntax:"[ <integer> && <symbol> ]#",relevance:50,description:"@counter-style descriptor. Specifies the symbols used by the marker-construction algorithm specified by the system descriptor. Needs to be specified if the counter system is 'additive'.",restrictions:["integer","string","image","identifier"]},{name:"align-content",values:[{name:"center",description:"Lines are packed toward the center of the flex container."},{name:"flex-end",description:"Lines are packed toward the end of the flex container."},{name:"flex-start",description:"Lines are packed toward the start of the flex container."},{name:"space-around",description:"Lines are evenly distributed in the flex container, with half-size spaces on either end."},{name:"space-between",description:"Lines are evenly distributed in the flex container."},{name:"stretch",description:"Lines stretch to take up the remaining space."}],syntax:"normal | <baseline-position> | <content-distribution> | <overflow-position>? <content-position>",relevance:62,description:"Aligns a flex container\u2019s lines within the flex container when there is extra space in the cross-axis, similar to how 'justify-content' aligns individual items within the main-axis.",restrictions:["enum"]},{name:"align-items",values:[{name:"baseline",description:"If the flex item\u2019s inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."},{name:"center",description:"The flex item\u2019s margin box is centered in the cross axis within the line."},{name:"flex-end",description:"The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."},{name:"flex-start",description:"The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."}],syntax:"normal | stretch | <baseline-position> | [ <overflow-position>? <self-position> ]",relevance:85,description:"Aligns flex items along the cross axis of the current line of the flex container.",restrictions:["enum"]},{name:"justify-items",values:[{name:"auto"},{name:"normal"},{name:"end"},{name:"start"},{name:"flex-end",description:'"Flex items are packed toward the end of the line."'},{name:"flex-start",description:'"Flex items are packed toward the start of the line."'},{name:"self-end",description:"The item is packed flush to the edge of the alignment container of the end side of the item, in the appropriate axis."},{name:"self-start",description:"The item is packed flush to the edge of the alignment container of the start side of the item, in the appropriate axis.."},{name:"center",description:"The items are packed flush to each other toward the center of the of the alignment container."},{name:"left"},{name:"right"},{name:"baseline"},{name:"first baseline"},{name:"last baseline"},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."},{name:"save"},{name:"unsave"},{name:"legacy"}],syntax:"normal | stretch | <baseline-position> | <overflow-position>? [ <self-position> | left | right ] | legacy | legacy && [ left | right | center ]",relevance:53,description:"Defines the default justify-self for all items of the box, giving them the default way of justifying each box along the appropriate axis",restrictions:["enum"]},{name:"justify-self",values:[{name:"auto"},{name:"normal"},{name:"end"},{name:"start"},{name:"flex-end",description:'"Flex items are packed toward the end of the line."'},{name:"flex-start",description:'"Flex items are packed toward the start of the line."'},{name:"self-end",description:"The item is packed flush to the edge of the alignment container of the end side of the item, in the appropriate axis."},{name:"self-start",description:"The item is packed flush to the edge of the alignment container of the start side of the item, in the appropriate axis.."},{name:"center",description:"The items are packed flush to each other toward the center of the of the alignment container."},{name:"left"},{name:"right"},{name:"baseline"},{name:"first baseline"},{name:"last baseline"},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."},{name:"save"},{name:"unsave"}],syntax:"auto | normal | stretch | <baseline-position> | <overflow-position>? [ <self-position> | left | right ]",relevance:53,description:"Defines the way of justifying a box inside its container along the appropriate axis.",restrictions:["enum"]},{name:"align-self",values:[{name:"auto",description:"Computes to the value of 'align-items' on the element\u2019s parent, or 'stretch' if the element has no parent. On absolutely positioned elements, it computes to itself."},{name:"baseline",description:"If the flex item\u2019s inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."},{name:"center",description:"The flex item\u2019s margin box is centered in the cross axis within the line."},{name:"flex-end",description:"The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."},{name:"flex-start",description:"The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."}],syntax:"auto | normal | stretch | <baseline-position> | <overflow-position>? <self-position>",relevance:72,description:"Allows the default alignment along the cross axis to be overridden for individual flex items.",restrictions:["enum"]},{name:"all",browsers:["E79","FF27","S9.1","C37","O24"],values:[],syntax:"initial | inherit | unset | revert",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/all"}],description:"Shorthand that resets all properties except 'direction' and 'unicode-bidi'.",restrictions:["enum"]},{name:"alt",browsers:["S9"],values:[],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/alt"}],description:"Provides alternative text for assistive technology to replace the generated content of a ::before or ::after element.",restrictions:["string","enum"]},{name:"animation",values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"infinite",description:"Causes the animation to repeat forever."},{name:"none",description:"No animation is performed"},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],syntax:"<single-animation>#",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation"}],description:"Shorthand property combines six of the animation properties into a single property.",restrictions:["time","timing-function","enum","identifier","number"]},{name:"animation-delay",syntax:"<time>#",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-delay"}],description:"Defines when the animation will start.",restrictions:["time"]},{name:"animation-direction",values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],syntax:"<single-animation-direction>#",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-direction"}],description:"Defines whether or not the animation should play in reverse on alternate cycles.",restrictions:["enum"]},{name:"animation-duration",syntax:"<time>#",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-duration"}],description:"Defines the length of time that an animation takes to complete one cycle.",restrictions:["time"]},{name:"animation-fill-mode",values:[{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"none",description:"There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."}],syntax:"<single-animation-fill-mode>#",relevance:63,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-fill-mode"}],description:"Defines what values are applied by the animation outside the time it is executing.",restrictions:["enum"]},{name:"animation-iteration-count",values:[{name:"infinite",description:"Causes the animation to repeat forever."}],syntax:"<single-animation-iteration-count>#",relevance:60,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-iteration-count"}],description:"Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",restrictions:["number","enum"]},{name:"animation-name",values:[{name:"none",description:"No animation is performed"}],syntax:"[ none | <keyframes-name> ]#",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-name"}],description:"Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",restrictions:["identifier","enum"]},{name:"animation-play-state",values:[{name:"paused",description:"A running animation will be paused."},{name:"running",description:"Resume playback of a paused animation."}],syntax:"<single-animation-play-state>#",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-play-state"}],description:"Defines whether the animation is running or paused.",restrictions:["enum"]},{name:"animation-timing-function",syntax:"<easing-function>#",relevance:71,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-timing-function"}],description:"Describes how the animation will progress over one cycle of its duration.",restrictions:["timing-function"]},{name:"backface-visibility",values:[{name:"hidden",description:"Back side is hidden."},{name:"visible",description:"Back side is visible."}],syntax:"visible | hidden",relevance:59,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/backface-visibility"}],description:"Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",restrictions:["enum"]},{name:"background",values:[{name:"fixed",description:"The background is fixed with regard to the viewport. In paged media where there is no viewport, a 'fixed' background is fixed with respect to the page box and therefore replicated on every page."},{name:"local",description:"The background is fixed with regard to the element's contents: if the element has a scrolling mechanism, the background scrolls with the element's contents."},{name:"none",description:"A value of 'none' counts as an image layer but draws nothing."},{name:"scroll",description:"The background is fixed with regard to the element itself and does not scroll with its contents. (It is effectively attached to the element's border.)"}],syntax:"[ <bg-layer> , ]* <final-bg-layer>",relevance:93,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background"}],description:"Shorthand property for setting most background properties at the same place in the style sheet.",restrictions:["enum","image","color","position","length","repeat","percentage","box"]},{name:"background-attachment",values:[{name:"fixed",description:"The background is fixed with regard to the viewport. In paged media where there is no viewport, a 'fixed' background is fixed with respect to the page box and therefore replicated on every page."},{name:"local",description:"The background is fixed with regard to the element\u2019s contents: if the element has a scrolling mechanism, the background scrolls with the element\u2019s contents."},{name:"scroll",description:"The background is fixed with regard to the element itself and does not scroll with its contents. (It is effectively attached to the element\u2019s border.)"}],syntax:"<attachment>#",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-attachment"}],description:"Specifies whether the background images are fixed with regard to the viewport ('fixed') or scroll along with the element ('scroll') or its contents ('local').",restrictions:["enum"]},{name:"background-blend-mode",browsers:["E79","FF30","S8","C35","O22"],values:[{name:"normal",description:"Default attribute which specifies no blending"},{name:"multiply",description:"The source color is multiplied by the destination color and replaces the destination."},{name:"screen",description:"Multiplies the complements of the backdrop and source color values, then complements the result."},{name:"overlay",description:"Multiplies or screens the colors, depending on the backdrop color value."},{name:"darken",description:"Selects the darker of the backdrop and source colors."},{name:"lighten",description:"Selects the lighter of the backdrop and source colors."},{name:"color-dodge",description:"Brightens the backdrop color to reflect the source color."},{name:"color-burn",description:"Darkens the backdrop color to reflect the source color."},{name:"hard-light",description:"Multiplies or screens the colors, depending on the source color value."},{name:"soft-light",description:"Darkens or lightens the colors, depending on the source color value."},{name:"difference",description:"Subtracts the darker of the two constituent colors from the lighter color.."},{name:"exclusion",description:"Produces an effect similar to that of the Difference mode but lower in contrast."},{name:"hue",browsers:["E79","FF30","S8","C35","O22"],description:"Creates a color with the hue of the source color and the saturation and luminosity of the backdrop color."},{name:"saturation",browsers:["E79","FF30","S8","C35","O22"],description:"Creates a color with the saturation of the source color and the hue and luminosity of the backdrop color."},{name:"color",browsers:["E79","FF30","S8","C35","O22"],description:"Creates a color with the hue and saturation of the source color and the luminosity of the backdrop color."},{name:"luminosity",browsers:["E79","FF30","S8","C35","O22"],description:"Creates a color with the luminosity of the source color and the hue and saturation of the backdrop color."}],syntax:"<blend-mode>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-blend-mode"}],description:"Defines the blending mode of each background layer.",restrictions:["enum"]},{name:"background-clip",syntax:"<box>#",relevance:69,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-clip"}],description:"Determines the background painting area.",restrictions:["box"]},{name:"background-color",syntax:"<color>",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-color"}],description:"Sets the background color of an element.",restrictions:["color"]},{name:"background-image",values:[{name:"none",description:"Counts as an image layer but draws nothing."}],syntax:"<bg-image>#",relevance:89,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-image"}],description:"Sets the background image(s) of an element.",restrictions:["image","enum"]},{name:"background-origin",syntax:"<box>#",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-origin"}],description:"For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",restrictions:["box"]},{name:"background-position",syntax:"<bg-position>#",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-position"}],description:"Specifies the initial position of the background image(s) (after any resizing) within their corresponding background positioning area.",restrictions:["position","length","percentage"]},{name:"background-position-x",values:[{name:"center",description:"Equivalent to '50%' ('left 50%') for the horizontal position if the horizontal position is not otherwise specified, or '50%' ('top 50%') for the vertical position if it is."},{name:"left",description:"Equivalent to '0%' for the horizontal position if one or two values are given, otherwise specifies the left edge as the origin for the next offset."},{name:"right",description:"Equivalent to '100%' for the horizontal position if one or two values are given, otherwise specifies the right edge as the origin for the next offset."}],status:"experimental",syntax:"[ center | [ [ left | right | x-start | x-end ]? <length-percentage>? ]! ]#",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-position-x"}],description:"If background images have been specified, this property specifies their initial position (after any resizing) within their corresponding background positioning area.",restrictions:["length","percentage"]},{name:"background-position-y",values:[{name:"bottom",description:"Equivalent to '100%' for the vertical position if one or two values are given, otherwise specifies the bottom edge as the origin for the next offset."},{name:"center",description:"Equivalent to '50%' ('left 50%') for the horizontal position if the horizontal position is not otherwise specified, or '50%' ('top 50%') for the vertical position if it is."},{name:"top",description:"Equivalent to '0%' for the vertical position if one or two values are given, otherwise specifies the top edge as the origin for the next offset."}],status:"experimental",syntax:"[ center | [ [ top | bottom | y-start | y-end ]? <length-percentage>? ]! ]#",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-position-y"}],description:"If background images have been specified, this property specifies their initial position (after any resizing) within their corresponding background positioning area.",restrictions:["length","percentage"]},{name:"background-repeat",values:[],syntax:"<repeat-style>#",relevance:85,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-repeat"}],description:"Specifies how background images are tiled after they have been sized and positioned.",restrictions:["repeat"]},{name:"background-size",values:[{name:"auto",description:"Resolved by using the image\u2019s intrinsic ratio and the size of the other dimension, or failing that, using the image\u2019s intrinsic size, or failing that, treating it as 100%."},{name:"contain",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."},{name:"cover",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."}],syntax:"<bg-size>#",relevance:85,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-size"}],description:"Specifies the size of the background images.",restrictions:["length","percentage"]},{name:"behavior",browsers:["IE6"],relevance:50,description:"IE only. Used to extend behaviors of the browser.",restrictions:["url"]},{name:"block-size",browsers:["E79","FF41","S12.1","C57","O44"],values:[{name:"auto",description:"Depends on the values of other properties."}],syntax:"<'width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/block-size"}],description:"Size of an element in the direction opposite that of the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"border",syntax:"<line-width> || <line-style> || <color>",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border"}],description:"Shorthand property for setting border width, style, and color.",restrictions:["length","line-width","line-style","color"]},{name:"border-block-end",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-end"}],description:"Logical 'border-bottom'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width","line-style","color"]},{name:"border-block-start",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-start"}],description:"Logical 'border-top'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width","line-style","color"]},{name:"border-block-end-color",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-color'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-end-color"}],description:"Logical 'border-bottom-color'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["color"]},{name:"border-block-start-color",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-color'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-start-color"}],description:"Logical 'border-top-color'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["color"]},{name:"border-block-end-style",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-end-style"}],description:"Logical 'border-bottom-style'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["line-style"]},{name:"border-block-start-style",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-start-style"}],description:"Logical 'border-top-style'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["line-style"]},{name:"border-block-end-width",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-end-width"}],description:"Logical 'border-bottom-width'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width"]},{name:"border-block-start-width",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-start-width"}],description:"Logical 'border-top-width'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width"]},{name:"border-bottom",syntax:"<line-width> || <line-style> || <color>",relevance:89,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom"}],description:"Shorthand property for setting border width, style and color.",restrictions:["length","line-width","line-style","color"]},{name:"border-bottom-color",syntax:"<'border-top-color'>",relevance:72,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-color"}],description:"Sets the color of the bottom border.",restrictions:["color"]},{name:"border-bottom-left-radius",syntax:"<length-percentage>{1,2}",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-left-radius"}],description:"Defines the radii of the bottom left outer border edge.",restrictions:["length","percentage"]},{name:"border-bottom-right-radius",syntax:"<length-percentage>{1,2}",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-right-radius"}],description:"Defines the radii of the bottom right outer border edge.",restrictions:["length","percentage"]},{name:"border-bottom-style",syntax:"<line-style>",relevance:59,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-style"}],description:"Sets the style of the bottom border.",restrictions:["line-style"]},{name:"border-bottom-width",syntax:"<line-width>",relevance:63,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-width"}],description:"Sets the thickness of the bottom border.",restrictions:["length","line-width"]},{name:"border-collapse",values:[{name:"collapse",description:"Selects the collapsing borders model."},{name:"separate",description:"Selects the separated borders border model."}],syntax:"collapse | separate",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-collapse"}],description:"Selects a table's border model.",restrictions:["enum"]},{name:"border-color",values:[],syntax:"<color>{1,4}",relevance:87,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-color"}],description:"The color of the border around all four edges of an element.",restrictions:["color"]},{name:"border-image",values:[{name:"auto",description:"If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."},{name:"fill",description:"Causes the middle part of the border-image to be preserved."},{name:"none",description:"Use the border styles."},{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."},{name:"url()"}],syntax:"<'border-image-source'> || <'border-image-slice'> [ / <'border-image-width'> | / <'border-image-width'>? / <'border-image-outset'> ]? || <'border-image-repeat'>",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image"}],description:"Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",restrictions:["length","percentage","number","url","enum"]},{name:"border-image-outset",syntax:"[ <length> | <number> ]{1,4}",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-outset"}],description:"The values specify the amount by which the border image area extends beyond the border box on the top, right, bottom, and left sides respectively. If the fourth value is absent, it is the same as the second. If the third one is also absent, it is the same as the first. If the second one is also absent, it is the same as the first. Numbers represent multiples of the corresponding border-width.",restrictions:["length","number"]},{name:"border-image-repeat",values:[{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."}],syntax:"[ stretch | repeat | round | space ]{1,2}",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-repeat"}],description:"Specifies how the images for the sides and the middle part of the border image are scaled and tiled. If the second keyword is absent, it is assumed to be the same as the first.",restrictions:["enum"]},{name:"border-image-slice",values:[{name:"fill",description:"Causes the middle part of the border-image to be preserved."}],syntax:"<number-percentage>{1,4} && fill?",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-slice"}],description:"Specifies inward offsets from the top, right, bottom, and left edges of the image, dividing it into nine regions: four corners, four edges and a middle.",restrictions:["number","percentage"]},{name:"border-image-source",values:[{name:"none",description:"Use the border styles."}],syntax:"none | <image>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-source"}],description:"Specifies an image to use instead of the border styles given by the 'border-style' properties and as an additional background layer for the element. If the value is 'none' or if the image cannot be displayed, the border styles will be used.",restrictions:["image"]},{name:"border-image-width",values:[{name:"auto",description:"The border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."}],syntax:"[ <length-percentage> | <number> | auto ]{1,4}",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-width"}],description:"The four values of 'border-image-width' specify offsets that are used to divide the border image area into nine parts. They represent inward distances from the top, right, bottom, and left sides of the area, respectively.",restrictions:["length","percentage","number"]},{name:"border-inline-end",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-end"}],description:"Logical 'border-right'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width","line-style","color"]},{name:"border-inline-start",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-start"}],description:"Logical 'border-left'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width","line-style","color"]},{name:"border-inline-end-color",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-color'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-end-color"}],description:"Logical 'border-right-color'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["color"]},{name:"border-inline-start-color",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-color'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-start-color"}],description:"Logical 'border-left-color'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["color"]},{name:"border-inline-end-style",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-end-style"}],description:"Logical 'border-right-style'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["line-style"]},{name:"border-inline-start-style",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-start-style"}],description:"Logical 'border-left-style'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["line-style"]},{name:"border-inline-end-width",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-end-width"}],description:"Logical 'border-right-width'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width"]},{name:"border-inline-start-width",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-start-width"}],description:"Logical 'border-left-width'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width"]},{name:"border-left",syntax:"<line-width> || <line-style> || <color>",relevance:83,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-left"}],description:"Shorthand property for setting border width, style and color",restrictions:["length","line-width","line-style","color"]},{name:"border-left-color",syntax:"<color>",relevance:65,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-left-color"}],description:"Sets the color of the left border.",restrictions:["color"]},{name:"border-left-style",syntax:"<line-style>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-left-style"}],description:"Sets the style of the left border.",restrictions:["line-style"]},{name:"border-left-width",syntax:"<line-width>",relevance:59,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-left-width"}],description:"Sets the thickness of the left border.",restrictions:["length","line-width"]},{name:"border-radius",syntax:"<length-percentage>{1,4} [ / <length-percentage>{1,4} ]?",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-radius"}],description:"Defines the radii of the outer border edge.",restrictions:["length","percentage"]},{name:"border-right",syntax:"<line-width> || <line-style> || <color>",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-right"}],description:"Shorthand property for setting border width, style and color",restrictions:["length","line-width","line-style","color"]},{name:"border-right-color",syntax:"<color>",relevance:65,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-right-color"}],description:"Sets the color of the right border.",restrictions:["color"]},{name:"border-right-style",syntax:"<line-style>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-right-style"}],description:"Sets the style of the right border.",restrictions:["line-style"]},{name:"border-right-width",syntax:"<line-width>",relevance:59,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-right-width"}],description:"Sets the thickness of the right border.",restrictions:["length","line-width"]},{name:"border-spacing",syntax:"<length> <length>?",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-spacing"}],description:"The lengths specify the distance that separates adjoining cell borders. If one length is specified, it gives both the horizontal and vertical spacing. If two are specified, the first gives the horizontal spacing and the second the vertical spacing. Lengths may not be negative.",restrictions:["length"]},{name:"border-style",values:[],syntax:"<line-style>{1,4}",relevance:81,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-style"}],description:"The style of the border around edges of an element.",restrictions:["line-style"]},{name:"border-top",syntax:"<line-width> || <line-style> || <color>",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top"}],description:"Shorthand property for setting border width, style and color",restrictions:["length","line-width","line-style","color"]},{name:"border-top-color",syntax:"<color>",relevance:72,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-color"}],description:"Sets the color of the top border.",restrictions:["color"]},{name:"border-top-left-radius",syntax:"<length-percentage>{1,2}",relevance:76,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-left-radius"}],description:"Defines the radii of the top left outer border edge.",restrictions:["length","percentage"]},{name:"border-top-right-radius",syntax:"<length-percentage>{1,2}",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-right-radius"}],description:"Defines the radii of the top right outer border edge.",restrictions:["length","percentage"]},{name:"border-top-style",syntax:"<line-style>",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-style"}],description:"Sets the style of the top border.",restrictions:["line-style"]},{name:"border-top-width",syntax:"<line-width>",relevance:61,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-width"}],description:"Sets the thickness of the top border.",restrictions:["length","line-width"]},{name:"border-width",values:[],syntax:"<line-width>{1,4}",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-width"}],description:"Shorthand that sets the four 'border-*-width' properties. If it has four values, they set top, right, bottom and left in that order. If left is missing, it is the same as right; if bottom is missing, it is the same as top; if right is missing, it is the same as top.",restrictions:["length","line-width"]},{name:"bottom",values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"}],syntax:"<length> | <percentage> | auto",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/bottom"}],description:"Specifies how far an absolutely positioned box's bottom margin edge is offset above the bottom edge of the box's 'containing block'.",restrictions:["length","percentage"]},{name:"box-decoration-break",browsers:["E79","FF32","S7","C22","O15"],values:[{name:"clone",description:"Each box is independently wrapped with the border and padding."},{name:"slice",description:"The effect is as though the element were rendered with no breaks present, and then sliced by the breaks afterward."}],syntax:"slice | clone",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-decoration-break"}],description:"Specifies whether individual boxes are treated as broken pieces of one continuous box, or whether each box is individually wrapped with the border and padding.",restrictions:["enum"]},{name:"box-shadow",values:[{name:"inset",description:"Changes the drop shadow from an outer shadow (one that shadows the box onto the canvas, as if it were lifted above the canvas) to an inner shadow (one that shadows the canvas onto the box, as if the box were cut out of the canvas and shifted behind it)."},{name:"none",description:"No shadow."}],syntax:"none | <shadow>#",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-shadow"}],description:"Attaches one or more drop-shadows to the box. The property is a comma-separated list of shadows, each specified by 2-4 length values, an optional color, and an optional 'inset' keyword. Omitted lengths are 0; omitted colors are a user agent chosen color.",restrictions:["length","color","enum"]},{name:"box-sizing",values:[{name:"border-box",description:"The specified width and height (and respective min/max properties) on this element determine the border box of the element."},{name:"content-box",description:"Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."}],syntax:"content-box | border-box",relevance:93,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-sizing"}],description:"Specifies the behavior of the 'width' and 'height' properties.",restrictions:["enum"]},{name:"break-after",values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the principal box."},{name:"avoid",description:"Avoid a break before/after the principal box."},{name:"avoid-column",description:"Avoid a column break before/after the principal box."},{name:"avoid-page",description:"Avoid a page break before/after the principal box."},{name:"column",description:"Always force a column break before/after the principal box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the principal box."},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],syntax:"auto | avoid | always | all | avoid-page | page | left | right | recto | verso | avoid-column | column | avoid-region | region",relevance:50,description:"Describes the page/column/region break behavior after the generated box.",restrictions:["enum"]},{name:"break-before",values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the principal box."},{name:"avoid",description:"Avoid a break before/after the principal box."},{name:"avoid-column",description:"Avoid a column break before/after the principal box."},{name:"avoid-page",description:"Avoid a page break before/after the principal box."},{name:"column",description:"Always force a column break before/after the principal box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the principal box."},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],syntax:"auto | avoid | always | all | avoid-page | page | left | right | recto | verso | avoid-column | column | avoid-region | region",relevance:50,description:"Describes the page/column/region break behavior before the generated box.",restrictions:["enum"]},{name:"break-inside",values:[{name:"auto",description:"Impose no additional breaking constraints within the box."},{name:"avoid",description:"Avoid breaks within the box."},{name:"avoid-column",description:"Avoid a column break within the box."},{name:"avoid-page",description:"Avoid a page break within the box."}],syntax:"auto | avoid | avoid-page | avoid-column | avoid-region",relevance:51,description:"Describes the page/column/region break behavior inside the principal box.",restrictions:["enum"]},{name:"caption-side",values:[{name:"bottom",description:"Positions the caption box below the table box."},{name:"top",description:"Positions the caption box above the table box."}],syntax:"top | bottom | block-start | block-end | inline-start | inline-end",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/caption-side"}],description:"Specifies the position of the caption box with respect to the table box.",restrictions:["enum"]},{name:"caret-color",browsers:["E79","FF53","S11.1","C57","O44"],values:[{name:"auto",description:"The user agent selects an appropriate color for the caret. This is generally currentcolor, but the user agent may choose a different color to ensure good visibility and contrast with the surrounding content, taking into account the value of currentcolor, the background, shadows, and other factors."}],syntax:"auto | <color>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/caret-color"}],description:"Controls the color of the text insertion indicator.",restrictions:["color","enum"]},{name:"clear",values:[{name:"both",description:"The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any right-floating and left-floating boxes that resulted from elements earlier in the source document."},{name:"left",description:"The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any left-floating boxes that resulted from elements earlier in the source document."},{name:"none",description:"No constraint on the box's position with respect to floats."},{name:"right",description:"The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any right-floating boxes that resulted from elements earlier in the source document."}],syntax:"none | left | right | both | inline-start | inline-end",relevance:85,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/clear"}],description:"Indicates which sides of an element's box(es) may not be adjacent to an earlier floating box. The 'clear' property does not consider floats inside the element itself or in other block formatting contexts.",restrictions:["enum"]},{name:"clip",values:[{name:"auto",description:"The element does not clip."},{name:"rect()",description:"Specifies offsets from the edges of the border box."}],syntax:"<shape> | auto",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/clip"}],description:"Deprecated. Use the 'clip-path' property when support allows. Defines the visible portion of an element\u2019s box.",restrictions:["enum"]},{name:"clip-path",values:[{name:"none",description:"No clipping path gets created."},{name:"url()",description:"References a <clipPath> element to create a clipping path."}],syntax:"<clip-source> | [ <basic-shape> || <geometry-box> ] | none",relevance:62,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/clip-path"}],description:"Specifies a clipping path where everything inside the path is visible and everything outside is clipped out.",restrictions:["url","shape","geometry-box","enum"]},{name:"clip-rule",browsers:["E","C5","FF3","IE10","O9","S6"],values:[{name:"evenodd",description:"Determines the \u2018insideness\u2019 of a point on the canvas by drawing a ray from that point to infinity in any direction and counting the number of path segments from the given shape that the ray crosses."},{name:"nonzero",description:"Determines the \u2018insideness\u2019 of a point on the canvas by drawing a ray from that point to infinity in any direction and then examining the places where a segment of the shape crosses the ray."}],relevance:50,description:"Indicates the algorithm which is to be used to determine what parts of the canvas are included inside the shape.",restrictions:["enum"]},{name:"color",syntax:"<color>",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/color"}],description:"Sets the color of an element's text",restrictions:["color"]},{name:"color-interpolation-filters",browsers:["E","C5","FF3","IE10","O9","S6"],values:[{name:"auto",description:"Color operations are not required to occur in a particular color space."},{name:"linearRGB",description:"Color operations should occur in the linearized RGB color space."},{name:"sRGB",description:"Color operations should occur in the sRGB color space."}],relevance:50,description:"Specifies the color space for imaging operations performed via filter effects.",restrictions:["enum"]},{name:"column-count",values:[{name:"auto",description:"Determines the number of columns by the 'column-width' property and the element width."}],syntax:"<integer> | auto",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-count"}],description:"Describes the optimal number of columns into which the content of the element will be flowed.",restrictions:["integer","enum"]},{name:"column-fill",values:[{name:"auto",description:"Fills columns sequentially."},{name:"balance",description:"Balance content equally between columns, if possible."}],syntax:"auto | balance | balance-all",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-fill"}],description:"In continuous media, this property will only be consulted if the length of columns has been constrained. Otherwise, columns will automatically be balanced.",restrictions:["enum"]},{name:"column-gap",values:[{name:"normal",description:"User agent specific and typically equivalent to 1em."}],syntax:"normal | <length-percentage>",relevance:54,description:"Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",restrictions:["length","enum"]},{name:"column-rule",syntax:"<'column-rule-width'> || <'column-rule-style'> || <'column-rule-color'>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-rule"}],description:"Shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",restrictions:["length","line-width","line-style","color"]},{name:"column-rule-color",syntax:"<color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-rule-color"}],description:"Sets the color of the column rule",restrictions:["color"]},{name:"column-rule-style",syntax:"<'border-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-rule-style"}],description:"Sets the style of the rule between columns of an element.",restrictions:["line-style"]},{name:"column-rule-width",syntax:"<'border-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-rule-width"}],description:"Sets the width of the rule between columns. Negative values are not allowed.",restrictions:["length","line-width"]},{name:"columns",values:[{name:"auto",description:"The width depends on the values of other properties."}],syntax:"<'column-width'> || <'column-count'>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/columns"}],description:"A shorthand property which sets both 'column-width' and 'column-count'.",restrictions:["length","integer","enum"]},{name:"column-span",values:[{name:"all",description:"The element spans across all columns. Content in the normal flow that appears before the element is automatically balanced across all columns before the element appear."},{name:"none",description:"The element does not span multiple columns."}],syntax:"none | all",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-span"}],description:"Describes the page/column break behavior after the generated box.",restrictions:["enum"]},{name:"column-width",values:[{name:"auto",description:"The width depends on the values of other properties."}],syntax:"<length> | auto",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-width"}],description:"Describes the width of columns in multicol elements.",restrictions:["length","enum"]},{name:"contain",browsers:["E79","FF69","S15.4","C52","O40"],values:[{name:"none",description:"Indicates that the property has no effect."},{name:"strict",description:"Turns on all forms of containment for the element."},{name:"content",description:"All containment rules except size are applied to the element."},{name:"size",description:"For properties that can have effects on more than just an element and its descendants, those effects don't escape the containing element."},{name:"layout",description:"Turns on layout containment for the element."},{name:"style",description:"Turns on style containment for the element."},{name:"paint",description:"Turns on paint containment for the element."}],syntax:"none | strict | content | [ size || layout || style || paint ]",relevance:59,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/contain"}],description:"Indicates that an element and its contents are, as much as possible, independent of the rest of the document tree.",restrictions:["enum"]},{name:"content",values:[{name:"attr()",description:"The attr(n) function returns as a string the value of attribute n for the subject of the selector."},{name:"counter(name)",description:"Counters are denoted by identifiers (see the 'counter-increment' and 'counter-reset' properties)."},{name:"icon",description:"The (pseudo-)element is replaced in its entirety by the resource referenced by its 'icon' property, and treated as a replaced element."},{name:"none",description:"On elements, this inhibits the children of the element from being rendered as children of this element, as if the element was empty. On pseudo-elements it causes the pseudo-element to have no content."},{name:"normal",description:"See http://www.w3.org/TR/css3-content/#content for computation rules."},{name:"url()"}],syntax:"normal | none | [ <content-replacement> | <content-list> ] [/ [ <string> | <counter> ]+ ]?",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/content"}],description:"Determines which page-based occurrence of a given element is applied to a counter or string value.",restrictions:["string","url"]},{name:"counter-increment",values:[{name:"none",description:"This element does not alter the value of any counters."}],syntax:"[ <counter-name> <integer>? ]+ | none",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/counter-increment"}],description:"Manipulate the value of existing counters.",restrictions:["identifier","integer"]},{name:"counter-reset",values:[{name:"none",description:"The counter is not modified."}],syntax:"[ <counter-name> <integer>? | <reversed-counter-name> <integer>? ]+ | none",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/counter-reset"}],description:"Property accepts one or more names of counters (identifiers), each one optionally followed by an integer. The integer gives the value that the counter is set to on each occurrence of the element.",restrictions:["identifier","integer"]},{name:"cursor",values:[{name:"alias",description:"Indicates an alias of/shortcut to something is to be created. Often rendered as an arrow with a small curved arrow next to it."},{name:"all-scroll",description:"Indicates that the something can be scrolled in any direction. Often rendered as arrows pointing up, down, left, and right with a dot in the middle."},{name:"auto",description:"The UA determines the cursor to display based on the current context."},{name:"cell",description:"Indicates that a cell or set of cells may be selected. Often rendered as a thick plus-sign with a dot in the middle."},{name:"col-resize",description:"Indicates that the item/column can be resized horizontally. Often rendered as arrows pointing left and right with a vertical bar separating them."},{name:"context-menu",description:"A context menu is available for the object under the cursor. Often rendered as an arrow with a small menu-like graphic next to it."},{name:"copy",description:"Indicates something is to be copied. Often rendered as an arrow with a small plus sign next to it."},{name:"crosshair",description:"A simple crosshair (e.g., short line segments resembling a '+' sign). Often used to indicate a two dimensional bitmap selection mode."},{name:"default",description:"The platform-dependent default cursor. Often rendered as an arrow."},{name:"e-resize",description:"Indicates that east edge is to be moved."},{name:"ew-resize",description:"Indicates a bidirectional east-west resize cursor."},{name:"grab",description:"Indicates that something can be grabbed."},{name:"grabbing",description:"Indicates that something is being grabbed."},{name:"help",description:"Help is available for the object under the cursor. Often rendered as a question mark or a balloon."},{name:"move",description:"Indicates something is to be moved."},{name:"-moz-grab",description:"Indicates that something can be grabbed."},{name:"-moz-grabbing",description:"Indicates that something is being grabbed."},{name:"-moz-zoom-in",description:"Indicates that something can be zoomed (magnified) in."},{name:"-moz-zoom-out",description:"Indicates that something can be zoomed (magnified) out."},{name:"ne-resize",description:"Indicates that movement starts from north-east corner."},{name:"nesw-resize",description:"Indicates a bidirectional north-east/south-west cursor."},{name:"no-drop",description:"Indicates that the dragged item cannot be dropped at the current cursor location. Often rendered as a hand or pointer with a small circle with a line through it."},{name:"none",description:"No cursor is rendered for the element."},{name:"not-allowed",description:"Indicates that the requested action will not be carried out. Often rendered as a circle with a line through it."},{name:"n-resize",description:"Indicates that north edge is to be moved."},{name:"ns-resize",description:"Indicates a bidirectional north-south cursor."},{name:"nw-resize",description:"Indicates that movement starts from north-west corner."},{name:"nwse-resize",description:"Indicates a bidirectional north-west/south-east cursor."},{name:"pointer",description:"The cursor is a pointer that indicates a link."},{name:"progress",description:"A progress indicator. The program is performing some processing, but is different from 'wait' in that the user may still interact with the program. Often rendered as a spinning beach ball, or an arrow with a watch or hourglass."},{name:"row-resize",description:"Indicates that the item/row can be resized vertically. Often rendered as arrows pointing up and down with a horizontal bar separating them."},{name:"se-resize",description:"Indicates that movement starts from south-east corner."},{name:"s-resize",description:"Indicates that south edge is to be moved."},{name:"sw-resize",description:"Indicates that movement starts from south-west corner."},{name:"text",description:"Indicates text that may be selected. Often rendered as a vertical I-beam."},{name:"vertical-text",description:"Indicates vertical-text that may be selected. Often rendered as a horizontal I-beam."},{name:"wait",description:"Indicates that the program is busy and the user should wait. Often rendered as a watch or hourglass."},{name:"-webkit-grab",description:"Indicates that something can be grabbed."},{name:"-webkit-grabbing",description:"Indicates that something is being grabbed."},{name:"-webkit-zoom-in",description:"Indicates that something can be zoomed (magnified) in."},{name:"-webkit-zoom-out",description:"Indicates that something can be zoomed (magnified) out."},{name:"w-resize",description:"Indicates that west edge is to be moved."},{name:"zoom-in",description:"Indicates that something can be zoomed (magnified) in."},{name:"zoom-out",description:"Indicates that something can be zoomed (magnified) out."}],syntax:"[ [ <url> [ <x> <y> ]? , ]* [ auto | default | none | context-menu | help | pointer | progress | wait | cell | crosshair | text | vertical-text | alias | copy | move | no-drop | not-allowed | e-resize | n-resize | ne-resize | nw-resize | s-resize | se-resize | sw-resize | w-resize | ew-resize | ns-resize | nesw-resize | nwse-resize | col-resize | row-resize | all-scroll | zoom-in | zoom-out | grab | grabbing ] ]",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/cursor"}],description:"Allows control over cursor appearance in an element",restrictions:["url","number","enum"]},{name:"direction",values:[{name:"ltr",description:"Left-to-right direction."},{name:"rtl",description:"Right-to-left direction."}],syntax:"ltr | rtl",relevance:69,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/direction"}],description:"Specifies the inline base direction or directionality of any bidi paragraph, embedding, isolate, or override established by the box. Note: for HTML content use the 'dir' attribute and 'bdo' element rather than this property.",restrictions:["enum"]},{name:"display",values:[{name:"block",description:"The element generates a block-level box"},{name:"contents",description:"The element itself does not generate any boxes, but its children and pseudo-elements still generate boxes as normal."},{name:"flex",description:"The element generates a principal flex container box and establishes a flex formatting context."},{name:"flexbox",description:"The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."},{name:"flow-root",description:"The element generates a block container box, and lays out its contents using flow layout."},{name:"grid",description:"The element generates a principal grid container box, and establishes a grid formatting context."},{name:"inline",description:"The element generates an inline-level box."},{name:"inline-block",description:"A block box, which itself is flowed as a single inline box, similar to a replaced element. The inside of an inline-block is formatted as a block box, and the box itself is formatted as an inline box."},{name:"inline-flex",description:"Inline-level flex container."},{name:"inline-flexbox",description:"Inline-level flex container. Standardized as 'inline-flex'"},{name:"inline-table",description:"Inline-level table wrapper box containing table box."},{name:"list-item",description:"One or more block boxes and one marker box."},{name:"-moz-box",description:"The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."},{name:"-moz-deck"},{name:"-moz-grid"},{name:"-moz-grid-group"},{name:"-moz-grid-line"},{name:"-moz-groupbox"},{name:"-moz-inline-box",description:"Inline-level flex container. Standardized as 'inline-flex'"},{name:"-moz-inline-grid"},{name:"-moz-inline-stack"},{name:"-moz-marker"},{name:"-moz-popup"},{name:"-moz-stack"},{name:"-ms-flexbox",description:"The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."},{name:"-ms-grid",description:"The element generates a principal grid container box, and establishes a grid formatting context."},{name:"-ms-inline-flexbox",description:"Inline-level flex container. Standardized as 'inline-flex'"},{name:"-ms-inline-grid",description:"Inline-level grid container."},{name:"none",description:"The element and its descendants generates no boxes."},{name:"ruby",description:"The element generates a principal ruby container box, and establishes a ruby formatting context."},{name:"ruby-base"},{name:"ruby-base-container"},{name:"ruby-text"},{name:"ruby-text-container"},{name:"run-in",description:"The element generates a run-in box. Run-in elements act like inlines or blocks, depending on the surrounding elements."},{name:"table",description:"The element generates a principal table wrapper box containing an additionally-generated table box, and establishes a table formatting context."},{name:"table-caption"},{name:"table-cell"},{name:"table-column"},{name:"table-column-group"},{name:"table-footer-group"},{name:"table-header-group"},{name:"table-row"},{name:"table-row-group"},{name:"-webkit-box",description:"The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."},{name:"-webkit-flex",description:"The element lays out its contents using flow layout (block-and-inline layout)."},{name:"-webkit-inline-box",description:"Inline-level flex container. Standardized as 'inline-flex'"},{name:"-webkit-inline-flex",description:"Inline-level flex container."}],syntax:"[ <display-outside> || <display-inside> ] | <display-listitem> | <display-internal> | <display-box> | <display-legacy>",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/display"}],description:"In combination with 'float' and 'position', determines the type of box or boxes that are generated for an element.",restrictions:["enum"]},{name:"empty-cells",values:[{name:"hide",description:"No borders or backgrounds are drawn around/behind empty cells."},{name:"-moz-show-background"},{name:"show",description:"Borders and backgrounds are drawn around/behind empty cells (like normal cells)."}],syntax:"show | hide",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/empty-cells"}],description:"In the separated borders model, this property controls the rendering of borders and backgrounds around cells that have no visible content.",restrictions:["enum"]},{name:"enable-background",values:[{name:"accumulate",description:"If the ancestor container element has a property of new, then all graphics elements within the current container are rendered both on the parent's background image and onto the target."},{name:"new",description:"Create a new background image canvas. All children of the current container element can access the background, and they will be rendered onto both the parent's background image canvas in addition to the target device."}],relevance:50,description:"Deprecated. Use 'isolation' property instead when support allows. Specifies how the accumulation of the background image is managed.",restrictions:["integer","length","percentage","enum"]},{name:"fallback",browsers:["FF33"],syntax:"<counter-style-name>",relevance:50,description:"@counter-style descriptor. Specifies a fallback counter style to be used when the current counter style can\u2019t create a representation for a given counter value.",restrictions:["identifier"]},{name:"fill",values:[{name:"url()",description:"A URL reference to a paint server element, which is an element that defines a paint server: \u2018hatch\u2019, \u2018linearGradient\u2019, \u2018mesh\u2019, \u2018pattern\u2019, \u2018radialGradient\u2019 and \u2018solidcolor\u2019."},{name:"none",description:"No paint is applied in this layer."}],relevance:77,description:"Paints the interior of the given graphical element.",restrictions:["color","enum","url"]},{name:"fill-opacity",relevance:52,description:"Specifies the opacity of the painting operation used to paint the interior the current object.",restrictions:["number(0-1)"]},{name:"fill-rule",values:[{name:"evenodd",description:"Determines the \u2018insideness\u2019 of a point on the canvas by drawing a ray from that point to infinity in any direction and counting the number of path segments from the given shape that the ray crosses."},{name:"nonzero",description:"Determines the \u2018insideness\u2019 of a point on the canvas by drawing a ray from that point to infinity in any direction and then examining the places where a segment of the shape crosses the ray."}],relevance:50,description:"Indicates the algorithm (or winding rule) which is to be used to determine what parts of the canvas are included inside the shape.",restrictions:["enum"]},{name:"filter",browsers:["E12","FF35","S9.1","C53","O40"],values:[{name:"none",description:"No filter effects are applied."},{name:"blur()",description:"Applies a Gaussian blur to the input image."},{name:"brightness()",description:"Applies a linear multiplier to input image, making it appear more or less bright."},{name:"contrast()",description:"Adjusts the contrast of the input."},{name:"drop-shadow()",description:"Applies a drop shadow effect to the input image."},{name:"grayscale()",description:"Converts the input image to grayscale."},{name:"hue-rotate()",description:"Applies a hue rotation on the input image. "},{name:"invert()",description:"Inverts the samples in the input image."},{name:"opacity()",description:"Applies transparency to the samples in the input image."},{name:"saturate()",description:"Saturates the input image."},{name:"sepia()",description:"Converts the input image to sepia."},{name:"url()",browsers:["E12","FF35","S9.1","C53","O40"],description:"A filter reference to a <filter> element."}],syntax:"none | <filter-function-list>",relevance:66,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/filter"}],description:"Processes an element\u2019s rendering before it is displayed in the document, by applying one or more filter effects.",restrictions:["enum","url"]},{name:"flex",values:[{name:"auto",description:"Retrieves the value of the main size property as the used 'flex-basis'."},{name:"content",description:"Indicates automatic sizing, based on the flex item\u2019s content."},{name:"none",description:"Expands to '0 0 auto'."}],syntax:"none | [ <'flex-grow'> <'flex-shrink'>? || <'flex-basis'> ]",relevance:80,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex"}],description:"Specifies the components of a flexible length: the flex grow factor and flex shrink factor, and the flex basis.",restrictions:["length","number","percentage"]},{name:"flex-basis",values:[{name:"auto",description:"Retrieves the value of the main size property as the used 'flex-basis'."},{name:"content",description:"Indicates automatic sizing, based on the flex item\u2019s content."}],syntax:"content | <'width'>",relevance:65,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-basis"}],description:"Sets the flex basis.",restrictions:["length","number","percentage"]},{name:"flex-direction",values:[{name:"column",description:"The flex container\u2019s main axis has the same orientation as the block axis of the current writing mode."},{name:"column-reverse",description:"Same as 'column', except the main-start and main-end directions are swapped."},{name:"row",description:"The flex container\u2019s main axis has the same orientation as the inline axis of the current writing mode."},{name:"row-reverse",description:"Same as 'row', except the main-start and main-end directions are swapped."}],syntax:"row | row-reverse | column | column-reverse",relevance:83,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-direction"}],description:"Specifies how flex items are placed in the flex container, by setting the direction of the flex container\u2019s main axis.",restrictions:["enum"]},{name:"flex-flow",values:[{name:"column",description:"The flex container\u2019s main axis has the same orientation as the block axis of the current writing mode."},{name:"column-reverse",description:"Same as 'column', except the main-start and main-end directions are swapped."},{name:"nowrap",description:"The flex container is single-line."},{name:"row",description:"The flex container\u2019s main axis has the same orientation as the inline axis of the current writing mode."},{name:"row-reverse",description:"Same as 'row', except the main-start and main-end directions are swapped."},{name:"wrap",description:"The flexbox is multi-line."},{name:"wrap-reverse",description:"Same as 'wrap', except the cross-start and cross-end directions are swapped."}],syntax:"<'flex-direction'> || <'flex-wrap'>",relevance:61,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-flow"}],description:"Specifies how flexbox items are placed in the flexbox.",restrictions:["enum"]},{name:"flex-grow",syntax:"<number>",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-grow"}],description:"Sets the flex grow factor. Negative numbers are invalid.",restrictions:["number"]},{name:"flex-shrink",syntax:"<number>",relevance:74,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-shrink"}],description:"Sets the flex shrink factor. Negative numbers are invalid.",restrictions:["number"]},{name:"flex-wrap",values:[{name:"nowrap",description:"The flex container is single-line."},{name:"wrap",description:"The flexbox is multi-line."},{name:"wrap-reverse",description:"Same as 'wrap', except the cross-start and cross-end directions are swapped."}],syntax:"nowrap | wrap | wrap-reverse",relevance:79,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-wrap"}],description:"Controls whether the flex container is single-line or multi-line, and the direction of the cross-axis, which determines the direction new lines are stacked in.",restrictions:["enum"]},{name:"float",values:[{name:"inline-end",description:"A keyword indicating that the element must float on the end side of its containing block. That is the right side with ltr scripts, and the left side with rtl scripts."},{name:"inline-start",description:"A keyword indicating that the element must float on the start side of its containing block. That is the left side with ltr scripts, and the right side with rtl scripts."},{name:"left",description:"The element generates a block box that is floated to the left. Content flows on the right side of the box, starting at the top (subject to the 'clear' property)."},{name:"none",description:"The box is not floated."},{name:"right",description:"Similar to 'left', except the box is floated to the right, and content flows on the left side of the box, starting at the top."}],syntax:"left | right | none | inline-start | inline-end",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/float"}],description:"Specifies how a box should be floated. It may be set for any element, but only applies to elements that generate boxes that are not absolutely positioned.",restrictions:["enum"]},{name:"flood-color",browsers:["E","C5","FF3","IE10","O9","S6"],relevance:50,description:"Indicates what color to use to flood the current filter primitive subregion.",restrictions:["color"]},{name:"flood-opacity",browsers:["E","C5","FF3","IE10","O9","S6"],relevance:50,description:"Indicates what opacity to use to flood the current filter primitive subregion.",restrictions:["number(0-1)","percentage"]},{name:"font",values:[{name:"100",description:"Thin"},{name:"200",description:"Extra Light (Ultra Light)"},{name:"300",description:"Light"},{name:"400",description:"Normal"},{name:"500",description:"Medium"},{name:"600",description:"Semi Bold (Demi Bold)"},{name:"700",description:"Bold"},{name:"800",description:"Extra Bold (Ultra Bold)"},{name:"900",description:"Black (Heavy)"},{name:"bold",description:"Same as 700"},{name:"bolder",description:"Specifies the weight of the face bolder than the inherited value."},{name:"caption",description:"The font used for captioned controls (e.g., buttons, drop-downs, etc.)."},{name:"icon",description:"The font used to label icons."},{name:"italic",description:"Selects a font that is labeled 'italic', or, if that is not available, one labeled 'oblique'."},{name:"large"},{name:"larger"},{name:"lighter",description:"Specifies the weight of the face lighter than the inherited value."},{name:"medium"},{name:"menu",description:"The font used in menus (e.g., dropdown menus and menu lists)."},{name:"message-box",description:"The font used in dialog boxes."},{name:"normal",description:"Specifies a face that is not labeled as a small-caps font."},{name:"oblique",description:"Selects a font that is labeled 'oblique'."},{name:"small"},{name:"small-caps",description:"Specifies a font that is labeled as a small-caps font. If a genuine small-caps font is not available, user agents should simulate a small-caps font."},{name:"small-caption",description:"The font used for labeling small controls."},{name:"smaller"},{name:"status-bar",description:"The font used in window status bars."},{name:"x-large"},{name:"x-small"},{name:"xx-large"},{name:"xx-small"}],syntax:"[ [ <'font-style'> || <font-variant-css21> || <'font-weight'> || <'font-stretch'> ]? <'font-size'> [ / <'line-height'> ]? <'font-family'> ] | caption | icon | menu | message-box | small-caption | status-bar",relevance:84,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font"}],description:"Shorthand property for setting 'font-style', 'font-variant', 'font-weight', 'font-size', 'line-height', and 'font-family', at the same place in the style sheet. The syntax of this property is based on a traditional typographical shorthand notation to set multiple properties related to fonts.",restrictions:["font"]},{name:"font-family",values:[{name:"-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif"},{name:"Arial, Helvetica, sans-serif"},{name:"Cambria, Cochin, Georgia, Times, 'Times New Roman', serif"},{name:"'Courier New', Courier, monospace"},{name:"cursive"},{name:"fantasy"},{name:"'Franklin Gothic Medium', 'Arial Narrow', Arial, sans-serif"},{name:"Georgia, 'Times New Roman', Times, serif"},{name:"'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif"},{name:"Impact, Haettenschweiler, 'Arial Narrow Bold', sans-serif"},{name:"'Lucida Sans', 'Lucida Sans Regular', 'Lucida Grande', 'Lucida Sans Unicode', Geneva, Verdana, sans-serif"},{name:"monospace"},{name:"sans-serif"},{name:"'Segoe UI', Tahoma, Geneva, Verdana, sans-serif"},{name:"serif"},{name:"'Times New Roman', Times, serif"},{name:"'Trebuchet MS', 'Lucida Sans Unicode', 'Lucida Grande', 'Lucida Sans', Arial, sans-serif"},{name:"Verdana, Geneva, Tahoma, sans-serif"}],syntax:"<family-name>",relevance:94,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-family"}],description:"Specifies a prioritized list of font family names or generic family names. A user agent iterates through the list of family names until it matches an available font that contains a glyph for the character to be rendered.",restrictions:["font"]},{name:"font-feature-settings",values:[{name:'"aalt"',description:"Access All Alternates."},{name:'"abvf"',description:"Above-base Forms. Required in Khmer script."},{name:'"abvm"',description:"Above-base Mark Positioning. Required in Indic scripts."},{name:'"abvs"',description:"Above-base Substitutions. Required in Indic scripts."},{name:'"afrc"',description:"Alternative Fractions."},{name:'"akhn"',description:"Akhand. Required in most Indic scripts."},{name:'"blwf"',description:"Below-base Form. Required in a number of Indic scripts."},{name:'"blwm"',description:"Below-base Mark Positioning. Required in Indic scripts."},{name:'"blws"',description:"Below-base Substitutions. Required in Indic scripts."},{name:'"calt"',description:"Contextual Alternates."},{name:'"case"',description:"Case-Sensitive Forms. Applies only to European scripts; particularly prominent in Spanish-language setting."},{name:'"ccmp"',description:"Glyph Composition/Decomposition."},{name:'"cfar"',description:"Conjunct Form After Ro. Required in Khmer scripts."},{name:'"cjct"',description:"Conjunct Forms. Required in Indic scripts that show similarity to Devanagari."},{name:'"clig"',description:"Contextual Ligatures."},{name:'"cpct"',description:"Centered CJK Punctuation. Used primarily in Chinese fonts."},{name:'"cpsp"',description:"Capital Spacing. Should not be used in connecting scripts (e.g. most Arabic)."},{name:'"cswh"',description:"Contextual Swash."},{name:'"curs"',description:"Cursive Positioning. Can be used in any cursive script."},{name:'"c2pc"',description:"Petite Capitals From Capitals. Applies only to bicameral scripts."},{name:'"c2sc"',description:"Small Capitals From Capitals. Applies only to bicameral scripts."},{name:'"dist"',description:"Distances. Required in Indic scripts."},{name:'"dlig"',description:"Discretionary ligatures."},{name:'"dnom"',description:"Denominators."},{name:'"dtls"',description:"Dotless Forms. Applied to math formula layout."},{name:'"expt"',description:"Expert Forms. Applies only to Japanese."},{name:'"falt"',description:"Final Glyph on Line Alternates. Can be used in any cursive script."},{name:'"fin2"',description:"Terminal Form #2. Used only with the Syriac script."},{name:'"fin3"',description:"Terminal Form #3. Used only with the Syriac script."},{name:'"fina"',description:"Terminal Forms. Can be used in any alphabetic script."},{name:'"flac"',description:"Flattened ascent forms. Applied to math formula layout."},{name:'"frac"',description:"Fractions."},{name:'"fwid"',description:"Full Widths. Applies to any script which can use monospaced forms."},{name:'"half"',description:"Half Forms. Required in Indic scripts that show similarity to Devanagari."},{name:'"haln"',description:"Halant Forms. Required in Indic scripts."},{name:'"halt"',description:"Alternate Half Widths. Used only in CJKV fonts."},{name:'"hist"',description:"Historical Forms."},{name:'"hkna"',description:"Horizontal Kana Alternates. Applies only to fonts that support kana (hiragana and katakana)."},{name:'"hlig"',description:"Historical Ligatures."},{name:'"hngl"',description:"Hangul. Korean only."},{name:'"hojo"',description:"Hojo Kanji Forms (JIS X 0212-1990 Kanji Forms). Used only with Kanji script."},{name:'"hwid"',description:"Half Widths. Generally used only in CJKV fonts."},{name:'"init"',description:"Initial Forms. Can be used in any alphabetic script."},{name:'"isol"',description:"Isolated Forms. Can be used in any cursive script."},{name:'"ital"',description:"Italics. Applies mostly to Latin; note that many non-Latin fonts contain Latin as well."},{name:'"jalt"',description:"Justification Alternates. Can be used in any cursive script."},{name:'"jp78"',description:"JIS78 Forms. Applies only to Japanese."},{name:'"jp83"',description:"JIS83 Forms. Applies only to Japanese."},{name:'"jp90"',description:"JIS90 Forms. Applies only to Japanese."},{name:'"jp04"',description:"JIS2004 Forms. Applies only to Japanese."},{name:'"kern"',description:"Kerning."},{name:'"lfbd"',description:"Left Bounds."},{name:'"liga"',description:"Standard Ligatures."},{name:'"ljmo"',description:"Leading Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."},{name:'"lnum"',description:"Lining Figures."},{name:'"locl"',description:"Localized Forms."},{name:'"ltra"',description:"Left-to-right glyph alternates."},{name:'"ltrm"',description:"Left-to-right mirrored forms."},{name:'"mark"',description:"Mark Positioning."},{name:'"med2"',description:"Medial Form #2. Used only with the Syriac script."},{name:'"medi"',description:"Medial Forms."},{name:'"mgrk"',description:"Mathematical Greek."},{name:'"mkmk"',description:"Mark to Mark Positioning."},{name:'"nalt"',description:"Alternate Annotation Forms."},{name:'"nlck"',description:"NLC Kanji Forms. Used only with Kanji script."},{name:'"nukt"',description:"Nukta Forms. Required in Indic scripts.."},{name:'"numr"',description:"Numerators."},{name:'"onum"',description:"Oldstyle Figures."},{name:'"opbd"',description:"Optical Bounds."},{name:'"ordn"',description:"Ordinals. Applies mostly to Latin script."},{name:'"ornm"',description:"Ornaments."},{name:'"palt"',description:"Proportional Alternate Widths. Used mostly in CJKV fonts."},{name:'"pcap"',description:"Petite Capitals."},{name:'"pkna"',description:"Proportional Kana. Generally used only in Japanese fonts."},{name:'"pnum"',description:"Proportional Figures."},{name:'"pref"',description:"Pre-base Forms. Required in Khmer and Myanmar (Burmese) scripts and southern Indic scripts that may display a pre-base form of Ra."},{name:'"pres"',description:"Pre-base Substitutions. Required in Indic scripts."},{name:'"pstf"',description:"Post-base Forms. Required in scripts of south and southeast Asia that have post-base forms for consonants eg: Gurmukhi, Malayalam, Khmer."},{name:'"psts"',description:"Post-base Substitutions."},{name:'"pwid"',description:"Proportional Widths."},{name:'"qwid"',description:"Quarter Widths. Generally used only in CJKV fonts."},{name:'"rand"',description:"Randomize."},{name:'"rclt"',description:"Required Contextual Alternates. May apply to any script, but is especially important for many styles of Arabic."},{name:'"rlig"',description:"Required Ligatures. Applies to Arabic and Syriac. May apply to some other scripts."},{name:'"rkrf"',description:"Rakar Forms. Required in Devanagari and Gujarati scripts."},{name:'"rphf"',description:"Reph Form. Required in Indic scripts. E.g. Devanagari, Kannada."},{name:'"rtbd"',description:"Right Bounds."},{name:'"rtla"',description:"Right-to-left alternates."},{name:'"rtlm"',description:"Right-to-left mirrored forms."},{name:'"ruby"',description:"Ruby Notation Forms. Applies only to Japanese."},{name:'"salt"',description:"Stylistic Alternates."},{name:'"sinf"',description:"Scientific Inferiors."},{name:'"size"',description:"Optical size."},{name:'"smcp"',description:"Small Capitals. Applies only to bicameral scripts."},{name:'"smpl"',description:"Simplified Forms. Applies only to Chinese and Japanese."},{name:'"ssty"',description:"Math script style alternates."},{name:'"stch"',description:"Stretching Glyph Decomposition."},{name:'"subs"',description:"Subscript."},{name:'"sups"',description:"Superscript."},{name:'"swsh"',description:"Swash. Does not apply to ideographic scripts."},{name:'"titl"',description:"Titling."},{name:'"tjmo"',description:"Trailing Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."},{name:'"tnam"',description:"Traditional Name Forms. Applies only to Japanese."},{name:'"tnum"',description:"Tabular Figures."},{name:'"trad"',description:"Traditional Forms. Applies only to Chinese and Japanese."},{name:'"twid"',description:"Third Widths. Generally used only in CJKV fonts."},{name:'"unic"',description:"Unicase."},{name:'"valt"',description:"Alternate Vertical Metrics. Applies only to scripts with vertical writing modes."},{name:'"vatu"',description:"Vattu Variants. Used for Indic scripts. E.g. Devanagari."},{name:'"vert"',description:"Vertical Alternates. Applies only to scripts with vertical writing modes."},{name:'"vhal"',description:"Alternate Vertical Half Metrics. Used only in CJKV fonts."},{name:'"vjmo"',description:"Vowel Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."},{name:'"vkna"',description:"Vertical Kana Alternates. Applies only to fonts that support kana (hiragana and katakana)."},{name:'"vkrn"',description:"Vertical Kerning."},{name:'"vpal"',description:"Proportional Alternate Vertical Metrics. Used mostly in CJKV fonts."},{name:'"vrt2"',description:"Vertical Alternates and Rotation. Applies only to scripts with vertical writing modes."},{name:'"zero"',description:"Slashed Zero."},{name:"normal",description:"No change in glyph substitution or positioning occurs."},{name:"off",description:"Disable feature."},{name:"on",description:"Enable feature."}],syntax:"normal | <feature-tag-value>#",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-feature-settings"}],description:"Provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",restrictions:["string","integer"]},{name:"font-kerning",browsers:["E79","FF32","S9","C33","O20"],values:[{name:"auto",description:"Specifies that kerning is applied at the discretion of the user agent."},{name:"none",description:"Specifies that kerning is not applied."},{name:"normal",description:"Specifies that kerning is applied."}],syntax:"auto | normal | none",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-kerning"}],description:"Kerning is the contextual adjustment of inter-glyph spacing. This property controls metric kerning, kerning that utilizes adjustment data contained in the font.",restrictions:["enum"]},{name:"font-language-override",browsers:["FF34"],values:[{name:"normal",description:"Implies that when rendering with OpenType fonts the language of the document is used to infer the OpenType language system, used to select language specific features when rendering."}],syntax:"normal | <string>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-language-override"}],description:"The value of 'normal' implies that when rendering with OpenType fonts the language of the document is used to infer the OpenType language system, used to select language specific features when rendering.",restrictions:["string"]},{name:"font-size",values:[{name:"large"},{name:"larger"},{name:"medium"},{name:"small"},{name:"smaller"},{name:"x-large"},{name:"x-small"},{name:"xx-large"},{name:"xx-small"}],syntax:"<absolute-size> | <relative-size> | <length-percentage>",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-size"}],description:"Indicates the desired height of glyphs from the font. For scalable fonts, the font-size is a scale factor applied to the EM unit of the font. (Note that certain glyphs may bleed outside their EM box.) For non-scalable fonts, the font-size is converted into absolute units and matched against the declared font-size of the font, using the same absolute coordinate space for both of the matched values.",restrictions:["length","percentage"]},{name:"font-size-adjust",browsers:["E79","FF40","C43","O30"],values:[{name:"none",description:"Do not preserve the font\u2019s x-height."}],syntax:"none | [ ex-height | cap-height | ch-width | ic-width | ic-height ]? [ from-font | <number> ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-size-adjust"}],description:"Preserves the readability of text when font fallback occurs by adjusting the font-size so that the x-height is the same regardless of the font used.",restrictions:["number"]},{name:"font-stretch",values:[{name:"condensed"},{name:"expanded"},{name:"extra-condensed"},{name:"extra-expanded"},{name:"narrower",description:"Indicates a narrower value relative to the width of the parent element."},{name:"normal"},{name:"semi-condensed"},{name:"semi-expanded"},{name:"ultra-condensed"},{name:"ultra-expanded"},{name:"wider",description:"Indicates a wider value relative to the width of the parent element."}],syntax:"<font-stretch-absolute>{1,2}",relevance:56,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-stretch"}],description:"Selects a normal, condensed, or expanded face from a font family.",restrictions:["enum"]},{name:"font-style",values:[{name:"italic",description:"Selects a font that is labeled as an 'italic' face, or an 'oblique' face if one is not"},{name:"normal",description:"Selects a face that is classified as 'normal'."},{name:"oblique",description:"Selects a font that is labeled as an 'oblique' face, or an 'italic' face if one is not."}],syntax:"normal | italic | oblique <angle>{0,2}",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-style"}],description:"Allows italic or oblique faces to be selected. Italic forms are generally cursive in nature while oblique faces are typically sloped versions of the regular face.",restrictions:["enum"]},{name:"font-synthesis",browsers:["E97","FF34","S9","C97","O83"],values:[{name:"none",description:"Disallow all synthetic faces."},{name:"style",description:"Allow synthetic italic faces."},{name:"weight",description:"Allow synthetic bold faces."}],syntax:"none | [ weight || style || small-caps ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-synthesis"}],description:"Controls whether user agents are allowed to synthesize bold or oblique font faces when a font family lacks bold or italic faces.",restrictions:["enum"]},{name:"font-variant",values:[{name:"normal",description:"Specifies a face that is not labeled as a small-caps font."},{name:"small-caps",description:"Specifies a font that is labeled as a small-caps font. If a genuine small-caps font is not available, user agents should simulate a small-caps font."}],syntax:"normal | none | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> || stylistic(<feature-value-name>) || historical-forms || styleset(<feature-value-name>#) || character-variant(<feature-value-name>#) || swash(<feature-value-name>) || ornaments(<feature-value-name>) || annotation(<feature-value-name>) || [ small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps ] || <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero || <east-asian-variant-values> || <east-asian-width-values> || ruby ]",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant"}],description:"Specifies variant representations of the font",restrictions:["enum"]},{name:"font-variant-alternates",browsers:["FF34","S9.1"],values:[{name:"annotation()",description:"Enables display of alternate annotation forms."},{name:"character-variant()",description:"Enables display of specific character variants."},{name:"historical-forms",description:"Enables display of historical forms."},{name:"normal",description:"None of the features are enabled."},{name:"ornaments()",description:"Enables replacement of default glyphs with ornaments, if provided in the font."},{name:"styleset()",description:"Enables display with stylistic sets."},{name:"stylistic()",description:"Enables display of stylistic alternates."},{name:"swash()",description:"Enables display of swash glyphs."}],syntax:"normal | [ stylistic( <feature-value-name> ) || historical-forms || styleset( <feature-value-name># ) || character-variant( <feature-value-name># ) || swash( <feature-value-name> ) || ornaments( <feature-value-name> ) || annotation( <feature-value-name> ) ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-alternates"}],description:"For any given character, fonts can provide a variety of alternate glyphs in addition to the default glyph for that character. This property provides control over the selection of these alternate glyphs.",restrictions:["enum"]},{name:"font-variant-caps",browsers:["E79","FF34","S9.1","C52","O39"],values:[{name:"all-petite-caps",description:"Enables display of petite capitals for both upper and lowercase letters."},{name:"all-small-caps",description:"Enables display of small capitals for both upper and lowercase letters."},{name:"normal",description:"None of the features are enabled."},{name:"petite-caps",description:"Enables display of petite capitals."},{name:"small-caps",description:"Enables display of small capitals. Small-caps glyphs typically use the form of uppercase letters but are reduced to the size of lowercase letters."},{name:"titling-caps",description:"Enables display of titling capitals."},{name:"unicase",description:"Enables display of mixture of small capitals for uppercase letters with normal lowercase letters."}],syntax:"normal | small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-caps"}],description:"Specifies control over capitalized forms.",restrictions:["enum"]},{name:"font-variant-east-asian",browsers:["E79","FF34","S9.1","C63","O50"],values:[{name:"full-width",description:"Enables rendering of full-width variants."},{name:"jis04",description:"Enables rendering of JIS04 forms."},{name:"jis78",description:"Enables rendering of JIS78 forms."},{name:"jis83",description:"Enables rendering of JIS83 forms."},{name:"jis90",description:"Enables rendering of JIS90 forms."},{name:"normal",description:"None of the features are enabled."},{name:"proportional-width",description:"Enables rendering of proportionally-spaced variants."},{name:"ruby",description:"Enables display of ruby variant glyphs."},{name:"simplified",description:"Enables rendering of simplified forms."},{name:"traditional",description:"Enables rendering of traditional forms."}],syntax:"normal | [ <east-asian-variant-values> || <east-asian-width-values> || ruby ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-east-asian"}],description:"Allows control of glyph substitute and positioning in East Asian text.",restrictions:["enum"]},{name:"font-variant-ligatures",browsers:["E79","FF34","S9.1","C34","O21"],values:[{name:"additional-ligatures",description:"Enables display of additional ligatures."},{name:"common-ligatures",description:"Enables display of common ligatures."},{name:"contextual",browsers:["E79","FF34","S9.1","C34","O21"],description:"Enables display of contextual alternates."},{name:"discretionary-ligatures",description:"Enables display of discretionary ligatures."},{name:"historical-ligatures",description:"Enables display of historical ligatures."},{name:"no-additional-ligatures",description:"Disables display of additional ligatures."},{name:"no-common-ligatures",description:"Disables display of common ligatures."},{name:"no-contextual",browsers:["E79","FF34","S9.1","C34","O21"],description:"Disables display of contextual alternates."},{name:"no-discretionary-ligatures",description:"Disables display of discretionary ligatures."},{name:"no-historical-ligatures",description:"Disables display of historical ligatures."},{name:"none",browsers:["E79","FF34","S9.1","C34","O21"],description:"Disables all ligatures."},{name:"normal",description:"Implies that the defaults set by the font are used."}],syntax:"normal | none | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> ]",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-ligatures"}],description:"Specifies control over which ligatures are enabled or disabled. A value of \u2018normal\u2019 implies that the defaults set by the font are used.",restrictions:["enum"]},{name:"font-variant-numeric",browsers:["E79","FF34","S9.1","C52","O39"],values:[{name:"diagonal-fractions",description:"Enables display of lining diagonal fractions."},{name:"lining-nums",description:"Enables display of lining numerals."},{name:"normal",description:"None of the features are enabled."},{name:"oldstyle-nums",description:"Enables display of old-style numerals."},{name:"ordinal",description:"Enables display of letter forms used with ordinal numbers."},{name:"proportional-nums",description:"Enables display of proportional numerals."},{name:"slashed-zero",description:"Enables display of slashed zeros."},{name:"stacked-fractions",description:"Enables display of lining stacked fractions."},{name:"tabular-nums",description:"Enables display of tabular numerals."}],syntax:"normal | [ <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-numeric"}],description:"Specifies control over numerical forms.",restrictions:["enum"]},{name:"font-variant-position",browsers:["FF34","S9.1"],values:[{name:"normal",description:"None of the features are enabled."},{name:"sub",description:"Enables display of subscript variants (OpenType feature: subs)."},{name:"super",description:"Enables display of superscript variants (OpenType feature: sups)."}],syntax:"normal | sub | super",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-position"}],description:"Specifies the vertical position",restrictions:["enum"]},{name:"font-weight",values:[{name:"100",description:"Thin"},{name:"200",description:"Extra Light (Ultra Light)"},{name:"300",description:"Light"},{name:"400",description:"Normal"},{name:"500",description:"Medium"},{name:"600",description:"Semi Bold (Demi Bold)"},{name:"700",description:"Bold"},{name:"800",description:"Extra Bold (Ultra Bold)"},{name:"900",description:"Black (Heavy)"},{name:"bold",description:"Same as 700"},{name:"bolder",description:"Specifies the weight of the face bolder than the inherited value."},{name:"lighter",description:"Specifies the weight of the face lighter than the inherited value."},{name:"normal",description:"Same as 400"}],syntax:"<font-weight-absolute>{1,2}",relevance:94,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-weight"}],description:"Specifies weight of glyphs in the font, their degree of blackness or stroke thickness.",restrictions:["enum"]},{name:"glyph-orientation-horizontal",relevance:50,description:"Controls glyph orientation when the inline-progression-direction is horizontal.",restrictions:["angle","number"]},{name:"glyph-orientation-vertical",values:[{name:"auto",description:"Sets the orientation based on the fullwidth or non-fullwidth characters and the most common orientation."}],relevance:50,description:"Controls glyph orientation when the inline-progression-direction is vertical.",restrictions:["angle","number","enum"]},{name:"grid-area",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item\u2019s placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item\u2019s placement such that the corresponding edge of the grid item\u2019s grid area is N lines from its opposite edge."}],syntax:"<grid-line> [ / <grid-line> ]{0,3}",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-area"}],description:"Determine a grid item\u2019s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement. Shorthand for 'grid-row-start', 'grid-column-start', 'grid-row-end', and 'grid-column-end'.",restrictions:["identifier","integer"]},{name:"grid",browsers:["E16","FF52","S10.1","C57","O44"],syntax:"<'grid-template'> | <'grid-template-rows'> / [ auto-flow && dense? ] <'grid-auto-columns'>? | [ auto-flow && dense? ] <'grid-auto-rows'>? / <'grid-template-columns'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid"}],description:"The grid CSS property is a shorthand property that sets all of the explicit grid properties ('grid-template-rows', 'grid-template-columns', and 'grid-template-areas'), and all the implicit grid properties ('grid-auto-rows', 'grid-auto-columns', and 'grid-auto-flow'), in a single declaration.",restrictions:["identifier","length","percentage","string","enum"]},{name:"grid-auto-columns",values:[{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."}],syntax:"<track-size>+",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-auto-columns"}],description:"Specifies the size of implicitly created columns.",restrictions:["length","percentage"]},{name:"grid-auto-flow",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"row",description:"The auto-placement algorithm places items by filling each row in turn, adding new rows as necessary."},{name:"column",description:"The auto-placement algorithm places items by filling each column in turn, adding new columns as necessary."},{name:"dense",description:"If specified, the auto-placement algorithm uses a \u201Cdense\u201D packing algorithm, which attempts to fill in holes earlier in the grid if smaller items come up later."}],syntax:"[ row | column ] || dense",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-auto-flow"}],description:"Controls how the auto-placement algorithm works, specifying exactly how auto-placed items get flowed into the grid.",restrictions:["enum"]},{name:"grid-auto-rows",values:[{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."}],syntax:"<track-size>+",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-auto-rows"}],description:"Specifies the size of implicitly created rows.",restrictions:["length","percentage"]},{name:"grid-column",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item\u2019s placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item\u2019s placement such that the corresponding edge of the grid item\u2019s grid area is N lines from its opposite edge."}],syntax:"<grid-line> [ / <grid-line> ]?",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-column"}],description:"Shorthand for 'grid-column-start' and 'grid-column-end'.",restrictions:["identifier","integer","enum"]},{name:"grid-column-end",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item\u2019s placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item\u2019s placement such that the corresponding edge of the grid item\u2019s grid area is N lines from its opposite edge."}],syntax:"<grid-line>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-column-end"}],description:"Determine a grid item\u2019s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",restrictions:["identifier","integer","enum"]},{name:"grid-column-gap",browsers:["FF52","C57","S10.1","O44"],status:"obsolete",syntax:"<length-percentage>",relevance:2,description:"Specifies the gutters between grid columns. Replaced by 'column-gap' property.",restrictions:["length"]},{name:"grid-column-start",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item\u2019s placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item\u2019s placement such that the corresponding edge of the grid item\u2019s grid area is N lines from its opposite edge."}],syntax:"<grid-line>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-column-start"}],description:"Determine a grid item\u2019s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",restrictions:["identifier","integer","enum"]},{name:"grid-gap",browsers:["FF52","C57","S10.1","O44"],status:"obsolete",syntax:"<'grid-row-gap'> <'grid-column-gap'>?",relevance:3,description:"Shorthand that specifies the gutters between grid columns and grid rows in one declaration. Replaced by 'gap' property.",restrictions:["length"]},{name:"grid-row",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item\u2019s placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item\u2019s placement such that the corresponding edge of the grid item\u2019s grid area is N lines from its opposite edge."}],syntax:"<grid-line> [ / <grid-line> ]?",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-row"}],description:"Shorthand for 'grid-row-start' and 'grid-row-end'.",restrictions:["identifier","integer","enum"]},{name:"grid-row-end",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item\u2019s placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item\u2019s placement such that the corresponding edge of the grid item\u2019s grid area is N lines from its opposite edge."}],syntax:"<grid-line>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-row-end"}],description:"Determine a grid item\u2019s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",restrictions:["identifier","integer","enum"]},{name:"grid-row-gap",browsers:["FF52","C57","S10.1","O44"],status:"obsolete",syntax:"<length-percentage>",relevance:1,description:"Specifies the gutters between grid rows. Replaced by 'row-gap' property.",restrictions:["length"]},{name:"grid-row-start",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item\u2019s placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item\u2019s placement such that the corresponding edge of the grid item\u2019s grid area is N lines from its opposite edge."}],syntax:"<grid-line>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-row-start"}],description:"Determine a grid item\u2019s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",restrictions:["identifier","integer","enum"]},{name:"grid-template",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"none",description:"Sets all three properties to their initial values."},{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"subgrid",description:"Sets 'grid-template-rows' and 'grid-template-columns' to 'subgrid', and 'grid-template-areas' to its initial value."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."},{name:"repeat()",description:"Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."}],syntax:"none | [ <'grid-template-rows'> / <'grid-template-columns'> ] | [ <line-names>? <string> <track-size>? <line-names>? ]+ [ / <explicit-track-list> ]?",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-template"}],description:"Shorthand for setting grid-template-columns, grid-template-rows, and grid-template-areas in a single declaration.",restrictions:["identifier","length","percentage","string","enum"]},{name:"grid-template-areas",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"none",description:"The grid container doesn\u2019t define any named grid areas."}],syntax:"none | <string>+",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-template-areas"}],description:"Specifies named grid areas, which are not associated with any particular grid item, but can be referenced from the grid-placement properties.",restrictions:["string"]},{name:"grid-template-columns",values:[{name:"none",description:"There is no explicit grid; any rows/columns will be implicitly generated."},{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"subgrid",description:"Indicates that the grid will align to its parent grid in that axis."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."},{name:"repeat()",description:"Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."}],syntax:"none | <track-list> | <auto-track-list> | subgrid <line-name-list>?",relevance:58,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-template-columns"}],description:"specifies, as a space-separated track list, the line names and track sizing functions of the grid.",restrictions:["identifier","length","percentage","enum"]},{name:"grid-template-rows",values:[{name:"none",description:"There is no explicit grid; any rows/columns will be implicitly generated."},{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"subgrid",description:"Indicates that the grid will align to its parent grid in that axis."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."},{name:"repeat()",description:"Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."}],syntax:"none | <track-list> | <auto-track-list> | subgrid <line-name-list>?",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-template-rows"}],description:"specifies, as a space-separated track list, the line names and track sizing functions of the grid.",restrictions:["identifier","length","percentage","string","enum"]},{name:"height",values:[{name:"auto",description:"The height depends on the values of other properties."},{name:"fit-content",description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"<viewport-length>{1,2}",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/height"}],description:"Specifies the height of the content area, padding area or border area (depending on 'box-sizing') of certain boxes.",restrictions:["length","percentage"]},{name:"hyphens",values:[{name:"auto",description:"Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."},{name:"manual",description:"Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"},{name:"none",description:"Words are not broken at line breaks, even if characters inside the word suggest line break points."}],syntax:"none | manual | auto",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/hyphens"}],description:"Controls whether hyphenation is allowed to create more break opportunities within a line of text.",restrictions:["enum"]},{name:"image-orientation",browsers:["E81","FF26","S13.1","C81","O67"],values:[{name:"flip",description:"After rotating by the precededing angle, the image is flipped horizontally. Defaults to 0deg if the angle is ommitted."},{name:"from-image",description:"If the image has an orientation specified in its metadata, such as EXIF, this value computes to the angle that the metadata specifies is necessary to correctly orient the image."}],syntax:"from-image | <angle> | [ <angle>? flip ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/image-orientation"}],description:"Specifies an orthogonal rotation to be applied to an image before it is laid out.",restrictions:["angle"]},{name:"image-rendering",browsers:["E79","FF3.6","S6","C13","O15"],values:[{name:"auto",description:"The image should be scaled with an algorithm that maximizes the appearance of the image."},{name:"crisp-edges",description:"The image must be scaled with an algorithm that preserves contrast and edges in the image, and which does not smooth colors or introduce blur to the image in the process."},{name:"-moz-crisp-edges",browsers:["E79","FF3.6","S6","C13","O15"]},{name:"optimizeQuality",description:"Deprecated."},{name:"optimizeSpeed",description:"Deprecated."},{name:"pixelated",description:"When scaling the image up, the 'nearest neighbor' or similar algorithm must be used, so that the image appears to be simply composed of very large pixels."}],syntax:"auto | crisp-edges | pixelated",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/image-rendering"}],description:"Provides a hint to the user-agent about what aspects of an image are most important to preserve when the image is scaled, to aid the user-agent in the choice of an appropriate scaling algorithm.",restrictions:["enum"]},{name:"ime-mode",browsers:["E12","FF3","IE5"],values:[{name:"active",description:"The input method editor is initially active; text entry is performed using it unless the user specifically dismisses it."},{name:"auto",description:"No change is made to the current input method editor state. This is the default."},{name:"disabled",description:"The input method editor is disabled and may not be activated by the user."},{name:"inactive",description:"The input method editor is initially inactive, but the user may activate it if they wish."},{name:"normal",description:"The IME state should be normal; this value can be used in a user style sheet to override the page setting."}],status:"obsolete",syntax:"auto | normal | active | inactive | disabled",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/ime-mode"}],description:"Controls the state of the input method editor for text fields.",restrictions:["enum"]},{name:"inline-size",browsers:["E79","FF41","S12.1","C57","O44"],values:[{name:"auto",description:"Depends on the values of other properties."}],syntax:"<'width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inline-size"}],description:"Size of an element in the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"isolation",browsers:["E79","FF36","S8","C41","O30"],values:[{name:"auto",description:"Elements are not isolated unless an operation is applied that causes the creation of a stacking context."},{name:"isolate",description:"In CSS will turn the element into a stacking context."}],syntax:"auto | isolate",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/isolation"}],description:"In CSS setting to 'isolate' will turn the element into a stacking context. In SVG, it defines whether an element is isolated or not.",restrictions:["enum"]},{name:"justify-content",values:[{name:"center",description:"Flex items are packed toward the center of the line."},{name:"start",description:"The items are packed flush to each other toward the start edge of the alignment container in the main axis."},{name:"end",description:"The items are packed flush to each other toward the end edge of the alignment container in the main axis."},{name:"left",description:"The items are packed flush to each other toward the left edge of the alignment container in the main axis."},{name:"right",description:"The items are packed flush to each other toward the right edge of the alignment container in the main axis."},{name:"safe",description:"If the size of the item overflows the alignment container, the item is instead aligned as if the alignment mode were start."},{name:"unsafe",description:"Regardless of the relative sizes of the item and alignment container, the given alignment value is honored."},{name:"stretch",description:"If the combined size of the alignment subjects is less than the size of the alignment container, any auto-sized alignment subjects have their size increased equally (not proportionally), while still respecting the constraints imposed by max-height/max-width (or equivalent functionality), so that the combined size exactly fills the alignment container."},{name:"space-evenly",description:"The items are evenly distributed within the alignment container along the main axis."},{name:"flex-end",description:"Flex items are packed toward the end of the line."},{name:"flex-start",description:"Flex items are packed toward the start of the line."},{name:"space-around",description:"Flex items are evenly distributed in the line, with half-size spaces on either end."},{name:"space-between",description:"Flex items are evenly distributed in the line."},{name:"baseline",description:"Specifies participation in first-baseline alignment."},{name:"first baseline",description:"Specifies participation in first-baseline alignment."},{name:"last baseline",description:"Specifies participation in last-baseline alignment."}],syntax:"normal | <content-distribution> | <overflow-position>? [ <content-position> | left | right ]",relevance:85,description:"Aligns flex items along the main axis of the current line of the flex container.",restrictions:["enum"]},{name:"kerning",values:[{name:"auto",description:"Indicates that the user agent should adjust inter-glyph spacing based on kerning tables that are included in the font that will be used."}],relevance:50,description:"Indicates whether the user agent should adjust inter-glyph spacing based on kerning tables that are included in the relevant font or instead disable auto-kerning and set inter-character spacing to a specific length.",restrictions:["length","enum"]},{name:"left",values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"}],syntax:"<length> | <percentage> | auto",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/left"}],description:"Specifies how far an absolutely positioned box's left margin edge is offset to the right of the left edge of the box's 'containing block'.",restrictions:["length","percentage"]},{name:"letter-spacing",values:[{name:"normal",description:"The spacing is the normal spacing for the current font. It is typically zero-length."}],syntax:"normal | <length>",relevance:81,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/letter-spacing"}],description:"Specifies the minimum, maximum, and optimal spacing between grapheme clusters.",restrictions:["length"]},{name:"lighting-color",browsers:["E","C5","FF3","IE10","O9","S6"],relevance:50,description:"Defines the color of the light source for filter primitives 'feDiffuseLighting' and 'feSpecularLighting'.",restrictions:["color"]},{name:"line-break",values:[{name:"auto",description:"The UA determines the set of line-breaking restrictions to use for CJK scripts, and it may vary the restrictions based on the length of the line; e.g., use a less restrictive set of line-break rules for short lines."},{name:"loose",description:"Breaks text using the least restrictive set of line-breaking rules. Typically used for short lines, such as in newspapers."},{name:"normal",description:"Breaks text using the most common set of line-breaking rules."},{name:"strict",description:"Breaks CJK scripts using a more restrictive set of line-breaking rules than 'normal'."}],syntax:"auto | loose | normal | strict | anywhere",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/line-break"}],description:"Specifies what set of line breaking restrictions are in effect within the element.",restrictions:["enum"]},{name:"line-height",values:[{name:"normal",description:"Tells user agents to set the computed value to a 'reasonable' value based on the font size of the element."}],syntax:"normal | <number> | <length> | <percentage>",relevance:93,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/line-height"}],description:"Determines the block-progression dimension of the text content area of an inline box.",restrictions:["number","length","percentage"]},{name:"list-style",values:[{name:"armenian"},{name:"circle",description:"A hollow circle."},{name:"decimal"},{name:"decimal-leading-zero"},{name:"disc",description:"A filled circle."},{name:"georgian"},{name:"inside",description:"The marker box is outside the principal block box, as described in the section on the ::marker pseudo-element below."},{name:"lower-alpha"},{name:"lower-greek"},{name:"lower-latin"},{name:"lower-roman"},{name:"none"},{name:"outside",description:"The ::marker pseudo-element is an inline element placed immediately before all ::before pseudo-elements in the principal block box, after which the element's content flows."},{name:"square",description:"A filled square."},{name:"symbols()",description:"Allows a counter style to be defined inline."},{name:"upper-alpha"},{name:"upper-latin"},{name:"upper-roman"},{name:"url()"}],syntax:"<'list-style-type'> || <'list-style-position'> || <'list-style-image'>",relevance:85,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/list-style"}],description:"Shorthand for setting 'list-style-type', 'list-style-position' and 'list-style-image'",restrictions:["image","enum","url"]},{name:"list-style-image",values:[{name:"none",description:"The default contents of the of the list item\u2019s marker are given by 'list-style-type' instead."}],syntax:"<image> | none",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/list-style-image"}],description:"Sets the image that will be used as the list item marker. When the image is available, it will replace the marker set with the 'list-style-type' marker.",restrictions:["image"]},{name:"list-style-position",values:[{name:"inside",description:"The marker box is outside the principal block box, as described in the section on the ::marker pseudo-element below."},{name:"outside",description:"The ::marker pseudo-element is an inline element placed immediately before all ::before pseudo-elements in the principal block box, after which the element's content flows."}],syntax:"inside | outside",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/list-style-position"}],description:"Specifies the position of the '::marker' pseudo-element's box in the list item.",restrictions:["enum"]},{name:"list-style-type",values:[{name:"armenian",description:"Traditional uppercase Armenian numbering."},{name:"circle",description:"A hollow circle."},{name:"decimal",description:"Western decimal numbers."},{name:"decimal-leading-zero",description:"Decimal numbers padded by initial zeros."},{name:"disc",description:"A filled circle."},{name:"georgian",description:"Traditional Georgian numbering."},{name:"lower-alpha",description:"Lowercase ASCII letters."},{name:"lower-greek",description:"Lowercase classical Greek."},{name:"lower-latin",description:"Lowercase ASCII letters."},{name:"lower-roman",description:"Lowercase ASCII Roman numerals."},{name:"none",description:"No marker"},{name:"square",description:"A filled square."},{name:"symbols()",description:"Allows a counter style to be defined inline."},{name:"upper-alpha",description:"Uppercase ASCII letters."},{name:"upper-latin",description:"Uppercase ASCII letters."},{name:"upper-roman",description:"Uppercase ASCII Roman numerals."}],syntax:"<counter-style> | <string> | none",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/list-style-type"}],description:"Used to construct the default contents of a list item\u2019s marker",restrictions:["enum","string"]},{name:"margin",values:[{name:"auto"}],syntax:"[ <length> | <percentage> | auto ]{1,4}",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits.",restrictions:["length","percentage"]},{name:"margin-block-end",browsers:["E79","FF41","S12.1","C69","O56"],values:[{name:"auto"}],syntax:"<'margin-left'>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-block-end"}],description:"Logical 'margin-bottom'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"margin-block-start",browsers:["E79","FF41","S12.1","C69","O56"],values:[{name:"auto"}],syntax:"<'margin-left'>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-block-start"}],description:"Logical 'margin-top'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"margin-bottom",values:[{name:"auto"}],syntax:"<length> | <percentage> | auto",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-bottom"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",restrictions:["length","percentage"]},{name:"margin-inline-end",browsers:["E79","FF41","S12.1","C69","O56"],values:[{name:"auto"}],syntax:"<'margin-left'>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-inline-end"}],description:"Logical 'margin-right'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"margin-inline-start",browsers:["E79","FF41","S12.1","C69","O56"],values:[{name:"auto"}],syntax:"<'margin-left'>",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-inline-start"}],description:"Logical 'margin-left'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"margin-left",values:[{name:"auto"}],syntax:"<length> | <percentage> | auto",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-left"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",restrictions:["length","percentage"]},{name:"margin-right",values:[{name:"auto"}],syntax:"<length> | <percentage> | auto",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-right"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",restrictions:["length","percentage"]},{name:"margin-top",values:[{name:"auto"}],syntax:"<length> | <percentage> | auto",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-top"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",restrictions:["length","percentage"]},{name:"marker",values:[{name:"none",description:"Indicates that no marker symbol will be drawn at the given vertex or vertices."},{name:"url()",description:"Indicates that the <marker> element referenced will be used."}],relevance:50,description:"Specifies the marker symbol that shall be used for all points on the sets the value for all vertices on the given \u2018path\u2019 element or basic shape.",restrictions:["url"]},{name:"marker-end",values:[{name:"none",description:"Indicates that no marker symbol will be drawn at the given vertex or vertices."},{name:"url()",description:"Indicates that the <marker> element referenced will be used."}],relevance:50,description:"Specifies the marker that will be drawn at the last vertices of the given markable element.",restrictions:["url"]},{name:"marker-mid",values:[{name:"none",description:"Indicates that no marker symbol will be drawn at the given vertex or vertices."},{name:"url()",description:"Indicates that the <marker> element referenced will be used."}],relevance:50,description:"Specifies the marker that will be drawn at all vertices except the first and last.",restrictions:["url"]},{name:"marker-start",values:[{name:"none",description:"Indicates that no marker symbol will be drawn at the given vertex or vertices."},{name:"url()",description:"Indicates that the <marker> element referenced will be used."}],relevance:50,description:"Specifies the marker that will be drawn at the first vertices of the given markable element.",restrictions:["url"]},{name:"mask-image",browsers:["E79","FF53","S15.4","C1","O15"],values:[{name:"none",description:"Counts as a transparent black image layer."},{name:"url()",description:"Reference to a <mask element or to a CSS image."}],syntax:"<mask-reference>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-image"}],description:"Sets the mask layer image of an element.",restrictions:["url","image","enum"]},{name:"mask-mode",browsers:["FF53","S15.4"],values:[{name:"alpha",description:"Alpha values of the mask layer image should be used as the mask values."},{name:"auto",description:"Use alpha values if 'mask-image' is an image, luminance if a <mask> element or a CSS image."},{name:"luminance",description:"Luminance values of the mask layer image should be used as the mask values."}],syntax:"<masking-mode>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-mode"}],description:"Indicates whether the mask layer image is treated as luminance mask or alpha mask.",restrictions:["url","image","enum"]},{name:"mask-origin",browsers:["E79","FF53","S15.4","C1","O15"],syntax:"<geometry-box>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-origin"}],description:"Specifies the mask positioning area.",restrictions:["geometry-box","enum"]},{name:"mask-position",browsers:["E79","FF53","S15.4","C1","O15"],syntax:"<position>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-position"}],description:"Specifies how mask layer images are positioned.",restrictions:["position","length","percentage"]},{name:"mask-repeat",browsers:["E79","FF53","S15.4","C1","O15"],syntax:"<repeat-style>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-repeat"}],description:"Specifies how mask layer images are tiled after they have been sized and positioned.",restrictions:["repeat"]},{name:"mask-size",browsers:["E79","FF53","S15.4","C4","O15"],values:[{name:"auto",description:"Resolved by using the image\u2019s intrinsic ratio and the size of the other dimension, or failing that, using the image\u2019s intrinsic size, or failing that, treating it as 100%."},{name:"contain",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."},{name:"cover",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."}],syntax:"<bg-size>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-size"}],description:"Specifies the size of the mask layer images.",restrictions:["length","percentage","enum"]},{name:"mask-type",browsers:["E79","FF35","S7","C24","O15"],values:[{name:"alpha",description:"Indicates that the alpha values of the mask should be used."},{name:"luminance",description:"Indicates that the luminance values of the mask should be used."}],syntax:"luminance | alpha",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-type"}],description:"Defines whether the content of the <mask> element is treated as as luminance mask or alpha mask.",restrictions:["enum"]},{name:"max-block-size",browsers:["E79","FF41","S12.1","C57","O44"],values:[{name:"none",description:"No limit on the width of the box."}],syntax:"<'max-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/max-block-size"}],description:"Maximum size of an element in the direction opposite that of the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"max-height",values:[{name:"none",description:"No limit on the height of the box."},{name:"fit-content",description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"<viewport-length>",relevance:85,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/max-height"}],description:"Allows authors to constrain content height to a certain range.",restrictions:["length","percentage"]},{name:"max-inline-size",browsers:["E79","FF41","S12.1","C57","O44"],values:[{name:"none",description:"No limit on the height of the box."}],syntax:"<'max-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/max-inline-size"}],description:"Maximum size of an element in the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"max-width",values:[{name:"none",description:"No limit on the width of the box."},{name:"fit-content",description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"<viewport-length>",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/max-width"}],description:"Allows authors to constrain content width to a certain range.",restrictions:["length","percentage"]},{name:"min-block-size",browsers:["E79","FF41","S12.1","C57","O44"],syntax:"<'min-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/min-block-size"}],description:"Minimal size of an element in the direction opposite that of the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"min-height",values:[{name:"auto"},{name:"fit-content",description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"<viewport-length>",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/min-height"}],description:"Allows authors to constrain content height to a certain range.",restrictions:["length","percentage"]},{name:"min-inline-size",browsers:["E79","FF41","S12.1","C57","O44"],syntax:"<'min-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/min-inline-size"}],description:"Minimal size of an element in the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"min-width",values:[{name:"auto"},{name:"fit-content",description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"<viewport-length>",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/min-width"}],description:"Allows authors to constrain content width to a certain range.",restrictions:["length","percentage"]},{name:"mix-blend-mode",browsers:["E79","FF32","S8","C41","O28"],values:[{name:"normal",description:"Default attribute which specifies no blending"},{name:"multiply",description:"The source color is multiplied by the destination color and replaces the destination."},{name:"screen",description:"Multiplies the complements of the backdrop and source color values, then complements the result."},{name:"overlay",description:"Multiplies or screens the colors, depending on the backdrop color value."},{name:"darken",description:"Selects the darker of the backdrop and source colors."},{name:"lighten",description:"Selects the lighter of the backdrop and source colors."},{name:"color-dodge",description:"Brightens the backdrop color to reflect the source color."},{name:"color-burn",description:"Darkens the backdrop color to reflect the source color."},{name:"hard-light",description:"Multiplies or screens the colors, depending on the source color value."},{name:"soft-light",description:"Darkens or lightens the colors, depending on the source color value."},{name:"difference",description:"Subtracts the darker of the two constituent colors from the lighter color.."},{name:"exclusion",description:"Produces an effect similar to that of the Difference mode but lower in contrast."},{name:"hue",browsers:["E79","FF32","S8","C41","O28"],description:"Creates a color with the hue of the source color and the saturation and luminosity of the backdrop color."},{name:"saturation",browsers:["E79","FF32","S8","C41","O28"],description:"Creates a color with the saturation of the source color and the hue and luminosity of the backdrop color."},{name:"color",browsers:["E79","FF32","S8","C41","O28"],description:"Creates a color with the hue and saturation of the source color and the luminosity of the backdrop color."},{name:"luminosity",browsers:["E79","FF32","S8","C41","O28"],description:"Creates a color with the luminosity of the source color and the hue and saturation of the backdrop color."}],syntax:"<blend-mode>",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mix-blend-mode"}],description:"Defines the formula that must be used to mix the colors with the backdrop.",restrictions:["enum"]},{name:"motion",browsers:["C46","O33"],values:[{name:"none",description:"No motion path gets created."},{name:"path()",description:"Defines an SVG path as a string, with optional 'fill-rule' as the first argument."},{name:"auto",description:"Indicates that the object is rotated by the angle of the direction of the motion path."},{name:"reverse",description:"Indicates that the object is rotated by the angle of the direction of the motion path plus 180 degrees."}],relevance:50,description:"Shorthand property for setting 'motion-path', 'motion-offset' and 'motion-rotation'.",restrictions:["url","length","percentage","angle","shape","geometry-box","enum"]},{name:"motion-offset",browsers:["C46","O33"],relevance:50,description:"A distance that describes the position along the specified motion path.",restrictions:["length","percentage"]},{name:"motion-path",browsers:["C46","O33"],values:[{name:"none",description:"No motion path gets created."},{name:"path()",description:"Defines an SVG path as a string, with optional 'fill-rule' as the first argument."}],relevance:50,description:"Specifies the motion path the element gets positioned at.",restrictions:["url","shape","geometry-box","enum"]},{name:"motion-rotation",browsers:["C46","O33"],values:[{name:"auto",description:"Indicates that the object is rotated by the angle of the direction of the motion path."},{name:"reverse",description:"Indicates that the object is rotated by the angle of the direction of the motion path plus 180 degrees."}],relevance:50,description:"Defines the direction of the element while positioning along the motion path.",restrictions:["angle"]},{name:"-moz-animation",browsers:["FF9"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"infinite",description:"Causes the animation to repeat forever."},{name:"none",description:"No animation is performed"},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Shorthand property combines six of the animation properties into a single property.",restrictions:["time","enum","timing-function","identifier","number"]},{name:"-moz-animation-delay",browsers:["FF9"],relevance:50,description:"Defines when the animation will start.",restrictions:["time"]},{name:"-moz-animation-direction",browsers:["FF9"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Defines whether or not the animation should play in reverse on alternate cycles.",restrictions:["enum"]},{name:"-moz-animation-duration",browsers:["FF9"],relevance:50,description:"Defines the length of time that an animation takes to complete one cycle.",restrictions:["time"]},{name:"-moz-animation-iteration-count",browsers:["FF9"],values:[{name:"infinite",description:"Causes the animation to repeat forever."}],relevance:50,description:"Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",restrictions:["number","enum"]},{name:"-moz-animation-name",browsers:["FF9"],values:[{name:"none",description:"No animation is performed"}],relevance:50,description:"Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",restrictions:["identifier","enum"]},{name:"-moz-animation-play-state",browsers:["FF9"],values:[{name:"paused",description:"A running animation will be paused."},{name:"running",description:"Resume playback of a paused animation."}],relevance:50,description:"Defines whether the animation is running or paused.",restrictions:["enum"]},{name:"-moz-animation-timing-function",browsers:["FF9"],relevance:50,description:"Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",restrictions:["timing-function"]},{name:"-moz-appearance",browsers:["FF1"],values:[{name:"button"},{name:"button-arrow-down"},{name:"button-arrow-next"},{name:"button-arrow-previous"},{name:"button-arrow-up"},{name:"button-bevel"},{name:"checkbox"},{name:"checkbox-container"},{name:"checkbox-label"},{name:"dialog"},{name:"groupbox"},{name:"listbox"},{name:"menuarrow"},{name:"menuimage"},{name:"menuitem"},{name:"menuitemtext"},{name:"menulist"},{name:"menulist-button"},{name:"menulist-text"},{name:"menulist-textfield"},{name:"menupopup"},{name:"menuradio"},{name:"menuseparator"},{name:"-moz-mac-unified-toolbar"},{name:"-moz-win-borderless-glass"},{name:"-moz-win-browsertabbar-toolbox"},{name:"-moz-win-communications-toolbox"},{name:"-moz-win-glass"},{name:"-moz-win-media-toolbox"},{name:"none"},{name:"progressbar"},{name:"progresschunk"},{name:"radio"},{name:"radio-container"},{name:"radio-label"},{name:"radiomenuitem"},{name:"resizer"},{name:"resizerpanel"},{name:"scrollbarbutton-down"},{name:"scrollbarbutton-left"},{name:"scrollbarbutton-right"},{name:"scrollbarbutton-up"},{name:"scrollbar-small"},{name:"scrollbartrack-horizontal"},{name:"scrollbartrack-vertical"},{name:"separator"},{name:"spinner"},{name:"spinner-downbutton"},{name:"spinner-textfield"},{name:"spinner-upbutton"},{name:"statusbar"},{name:"statusbarpanel"},{name:"tab"},{name:"tabpanels"},{name:"tab-scroll-arrow-back"},{name:"tab-scroll-arrow-forward"},{name:"textfield"},{name:"textfield-multiline"},{name:"toolbar"},{name:"toolbox"},{name:"tooltip"},{name:"treeheadercell"},{name:"treeheadersortarrow"},{name:"treeitem"},{name:"treetwistyopen"},{name:"treeview"},{name:"treewisty"},{name:"window"}],status:"nonstandard",syntax:"none | button | button-arrow-down | button-arrow-next | button-arrow-previous | button-arrow-up | button-bevel | button-focus | caret | checkbox | checkbox-container | checkbox-label | checkmenuitem | dualbutton | groupbox | listbox | listitem | menuarrow | menubar | menucheckbox | menuimage | menuitem | menuitemtext | menulist | menulist-button | menulist-text | menulist-textfield | menupopup | menuradio | menuseparator | meterbar | meterchunk | progressbar | progressbar-vertical | progresschunk | progresschunk-vertical | radio | radio-container | radio-label | radiomenuitem | range | range-thumb | resizer | resizerpanel | scale-horizontal | scalethumbend | scalethumb-horizontal | scalethumbstart | scalethumbtick | scalethumb-vertical | scale-vertical | scrollbarbutton-down | scrollbarbutton-left | scrollbarbutton-right | scrollbarbutton-up | scrollbarthumb-horizontal | scrollbarthumb-vertical | scrollbartrack-horizontal | scrollbartrack-vertical | searchfield | separator | sheet | spinner | spinner-downbutton | spinner-textfield | spinner-upbutton | splitter | statusbar | statusbarpanel | tab | tabpanel | tabpanels | tab-scroll-arrow-back | tab-scroll-arrow-forward | textfield | textfield-multiline | toolbar | toolbarbutton | toolbarbutton-dropdown | toolbargripper | toolbox | tooltip | treeheader | treeheadercell | treeheadersortarrow | treeitem | treeline | treetwisty | treetwistyopen | treeview | -moz-mac-unified-toolbar | -moz-win-borderless-glass | -moz-win-browsertabbar-toolbox | -moz-win-communicationstext | -moz-win-communications-toolbox | -moz-win-exclude-glass | -moz-win-glass | -moz-win-mediatext | -moz-win-media-toolbox | -moz-window-button-box | -moz-window-button-box-maximized | -moz-window-button-close | -moz-window-button-maximize | -moz-window-button-minimize | -moz-window-button-restore | -moz-window-frame-bottom | -moz-window-frame-left | -moz-window-frame-right | -moz-window-titlebar | -moz-window-titlebar-maximized",relevance:0,description:"Used in Gecko (Firefox) to display an element using a platform-native styling based on the operating system's theme.",restrictions:["enum"]},{name:"-moz-backface-visibility",browsers:["FF10"],values:[{name:"hidden"},{name:"visible"}],relevance:50,description:"Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",restrictions:["enum"]},{name:"-moz-background-clip",browsers:["FF1-3.6"],values:[{name:"padding"}],relevance:50,description:"Determines the background painting area.",restrictions:["box","enum"]},{name:"-moz-background-inline-policy",browsers:["FF1"],values:[{name:"bounding-box"},{name:"continuous"},{name:"each-box"}],relevance:50,description:"In Gecko-based applications like Firefox, the -moz-background-inline-policy CSS property specifies how the background image of an inline element is determined when the content of the inline element wraps onto multiple lines. The choice of position has significant effects on repetition.",restrictions:["enum"]},{name:"-moz-background-origin",browsers:["FF1"],relevance:50,description:"For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",restrictions:["box"]},{name:"-moz-border-bottom-colors",browsers:["FF1"],status:"nonstandard",syntax:"<color>+ | none",relevance:0,description:"Sets a list of colors for the bottom border.",restrictions:["color"]},{name:"-moz-border-image",browsers:["FF3.6"],values:[{name:"auto",description:"If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."},{name:"fill",description:"Causes the middle part of the border-image to be preserved."},{name:"none"},{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."},{name:"url()"}],relevance:50,description:"Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",restrictions:["length","percentage","number","url","enum"]},{name:"-moz-border-left-colors",browsers:["FF1"],status:"nonstandard",syntax:"<color>+ | none",relevance:0,description:"Sets a list of colors for the bottom border.",restrictions:["color"]},{name:"-moz-border-right-colors",browsers:["FF1"],status:"nonstandard",syntax:"<color>+ | none",relevance:0,description:"Sets a list of colors for the bottom border.",restrictions:["color"]},{name:"-moz-border-top-colors",browsers:["FF1"],status:"nonstandard",syntax:"<color>+ | none",relevance:0,description:"Ske Firefox, -moz-border-bottom-colors sets a list of colors for the bottom border.",restrictions:["color"]},{name:"-moz-box-align",browsers:["FF1"],values:[{name:"baseline",description:"If this box orientation is inline-axis or horizontal, all children are placed with their baselines aligned, and extra space placed before or after as necessary. For block flows, the baseline of the first non-empty line box located within the element is used. For tables, the baseline of the first cell is used."},{name:"center",description:"Any extra space is divided evenly, with half placed above the child and the other half placed after the child."},{name:"end",description:"For normal direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element. For reverse direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element."},{name:"start",description:"For normal direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element. For reverse direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element."},{name:"stretch",description:"The height of each child is adjusted to that of the containing block."}],relevance:50,description:"Specifies how a XUL box aligns its contents across (perpendicular to) the direction of its layout. The effect of this is only visible if there is extra space in the box.",restrictions:["enum"]},{name:"-moz-box-direction",browsers:["FF1"],values:[{name:"normal",description:"A box with a computed value of horizontal for box-orient displays its children from left to right. A box with a computed value of vertical displays its children from top to bottom."},{name:"reverse",description:"A box with a computed value of horizontal for box-orient displays its children from right to left. A box with a computed value of vertical displays its children from bottom to top."}],relevance:50,description:"Specifies whether a box lays out its contents normally (from the top or left edge), or in reverse (from the bottom or right edge).",restrictions:["enum"]},{name:"-moz-box-flex",browsers:["FF1"],relevance:50,description:"Specifies how a box grows to fill the box that contains it, in the direction of the containing box's layout.",restrictions:["number"]},{name:"-moz-box-flexgroup",browsers:["FF1"],relevance:50,description:"Flexible elements can be assigned to flex groups using the 'box-flex-group' property.",restrictions:["integer"]},{name:"-moz-box-ordinal-group",browsers:["FF1"],relevance:50,description:"Indicates the ordinal group the element belongs to. Elements with a lower ordinal group are displayed before those with a higher ordinal group.",restrictions:["integer"]},{name:"-moz-box-orient",browsers:["FF1"],values:[{name:"block-axis",description:"Elements are oriented along the box's axis."},{name:"horizontal",description:"The box displays its children from left to right in a horizontal line."},{name:"inline-axis",description:"Elements are oriented vertically."},{name:"vertical",description:"The box displays its children from stacked from top to bottom vertically."}],relevance:50,description:"In Mozilla applications, -moz-box-orient specifies whether a box lays out its contents horizontally or vertically.",restrictions:["enum"]},{name:"-moz-box-pack",browsers:["FF1"],values:[{name:"center",description:"The extra space is divided evenly, with half placed before the first child and the other half placed after the last child."},{name:"end",description:"For normal direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child. For reverse direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child."},{name:"justify",description:"The space is divided evenly in-between each child, with none of the extra space placed before the first child or after the last child. If there is only one child, treat the pack value as if it were start."},{name:"start",description:"For normal direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child. For reverse direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child."}],relevance:50,description:"Specifies how a box packs its contents in the direction of its layout. The effect of this is only visible if there is extra space in the box.",restrictions:["enum"]},{name:"-moz-box-sizing",browsers:["FF1"],values:[{name:"border-box",description:"The specified width and height (and respective min/max properties) on this element determine the border box of the element."},{name:"content-box",description:"Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."},{name:"padding-box",description:"The specified width and height (and respective min/max properties) on this element determine the padding box of the element."}],relevance:50,description:"Box Model addition in CSS3.",restrictions:["enum"]},{name:"-moz-column-count",browsers:["FF3.5"],values:[{name:"auto",description:"Determines the number of columns by the 'column-width' property and the element width."}],relevance:50,description:"Describes the optimal number of columns into which the content of the element will be flowed.",restrictions:["integer"]},{name:"-moz-column-gap",browsers:["FF3.5"],values:[{name:"normal",description:"User agent specific and typically equivalent to 1em."}],relevance:50,description:"Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",restrictions:["length"]},{name:"-moz-column-rule",browsers:["FF3.5"],relevance:50,description:"Shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",restrictions:["length","line-width","line-style","color"]},{name:"-moz-column-rule-color",browsers:["FF3.5"],relevance:50,description:"Sets the color of the column rule",restrictions:["color"]},{name:"-moz-column-rule-style",browsers:["FF3.5"],relevance:50,description:"Sets the style of the rule between columns of an element.",restrictions:["line-style"]},{name:"-moz-column-rule-width",browsers:["FF3.5"],relevance:50,description:"Sets the width of the rule between columns. Negative values are not allowed.",restrictions:["length","line-width"]},{name:"-moz-columns",browsers:["FF9"],values:[{name:"auto",description:"The width depends on the values of other properties."}],relevance:50,description:"A shorthand property which sets both 'column-width' and 'column-count'.",restrictions:["length","integer"]},{name:"-moz-column-width",browsers:["FF3.5"],values:[{name:"auto",description:"The width depends on the values of other properties."}],relevance:50,description:"This property describes the width of columns in multicol elements.",restrictions:["length"]},{name:"-moz-font-feature-settings",browsers:["FF4"],values:[{name:'"c2cs"'},{name:'"dlig"'},{name:'"kern"'},{name:'"liga"'},{name:'"lnum"'},{name:'"onum"'},{name:'"smcp"'},{name:'"swsh"'},{name:'"tnum"'},{name:"normal",description:"No change in glyph substitution or positioning occurs."},{name:"off",browsers:["FF4"]},{name:"on",browsers:["FF4"]}],relevance:50,description:"Provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",restrictions:["string","integer"]},{name:"-moz-hyphens",browsers:["FF9"],values:[{name:"auto",description:"Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."},{name:"manual",description:"Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"},{name:"none",description:"Words are not broken at line breaks, even if characters inside the word suggest line break points."}],relevance:50,description:"Controls whether hyphenation is allowed to create more break opportunities within a line of text.",restrictions:["enum"]},{name:"-moz-perspective",browsers:["FF10"],values:[{name:"none",description:"No perspective transform is applied."}],relevance:50,description:"Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",restrictions:["length"]},{name:"-moz-perspective-origin",browsers:["FF10"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-moz-text-align-last",browsers:["FF12"],values:[{name:"auto"},{name:"center",description:"The inline contents are centered within the line box."},{name:"justify",description:"The text is justified according to the method specified by the 'text-justify' property."},{name:"left",description:"The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."},{name:"right",description:"The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."}],relevance:50,description:"Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",restrictions:["enum"]},{name:"-moz-text-decoration-color",browsers:["FF6"],relevance:50,description:"Specifies the color of text decoration (underlines overlines, and line-throughs) set on the element with text-decoration-line.",restrictions:["color"]},{name:"-moz-text-decoration-line",browsers:["FF6"],values:[{name:"line-through",description:"Each line of text has a line through the middle."},{name:"none",description:"Neither produces nor inhibits text decoration."},{name:"overline",description:"Each line of text has a line above it."},{name:"underline",description:"Each line of text is underlined."}],relevance:50,description:"Specifies what line decorations, if any, are added to the element.",restrictions:["enum"]},{name:"-moz-text-decoration-style",browsers:["FF6"],values:[{name:"dashed",description:"Produces a dashed line style."},{name:"dotted",description:"Produces a dotted line."},{name:"double",description:"Produces a double line."},{name:"none",description:"Produces no line."},{name:"solid",description:"Produces a solid line."},{name:"wavy",description:"Produces a wavy line."}],relevance:50,description:"Specifies the line style for underline, line-through and overline text decoration.",restrictions:["enum"]},{name:"-moz-text-size-adjust",browsers:["FF"],values:[{name:"auto",description:"Renderers must use the default size adjustment when displaying on a small device."},{name:"none",description:"Renderers must not do size adjustment when displaying on a small device."}],relevance:50,description:"Specifies a size adjustment for displaying text content in mobile browsers.",restrictions:["enum","percentage"]},{name:"-moz-transform",browsers:["FF3.5"],values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"perspective",description:"Specifies a perspective projection matrix."},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],relevance:50,description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"-moz-transform-origin",browsers:["FF3.5"],relevance:50,description:"Establishes the origin of transformation for an element.",restrictions:["position","length","percentage"]},{name:"-moz-transition",browsers:["FF4"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Shorthand property combines four of the transition properties into a single property.",restrictions:["time","property","timing-function","enum"]},{name:"-moz-transition-delay",browsers:["FF4"],relevance:50,description:"Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",restrictions:["time"]},{name:"-moz-transition-duration",browsers:["FF4"],relevance:50,description:"Specifies how long the transition from the old value to the new value should take.",restrictions:["time"]},{name:"-moz-transition-property",browsers:["FF4"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Specifies the name of the CSS property to which the transition is applied.",restrictions:["property"]},{name:"-moz-transition-timing-function",browsers:["FF4"],relevance:50,description:"Describes how the intermediate values used during a transition will be calculated.",restrictions:["timing-function"]},{name:"-moz-user-focus",browsers:["FF1"],values:[{name:"ignore"},{name:"normal"}],status:"nonstandard",syntax:"ignore | normal | select-after | select-before | select-menu | select-same | select-all | none",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-user-focus"}],description:"Used to indicate whether the element can have focus."},{name:"-moz-user-select",browsers:["FF1.5"],values:[{name:"all"},{name:"element"},{name:"elements"},{name:"-moz-all"},{name:"-moz-none"},{name:"none"},{name:"text"},{name:"toggle"}],relevance:50,description:"Controls the appearance of selection.",restrictions:["enum"]},{name:"-ms-accelerator",browsers:["E","IE10"],values:[{name:"false",description:"The element does not contain an accelerator key sequence."},{name:"true",description:"The element contains an accelerator key sequence."}],status:"nonstandard",syntax:"false | true",relevance:0,description:"IE only. Has the ability to turn off its system underlines for accelerator keys until the ALT key is pressed",restrictions:["enum"]},{name:"-ms-behavior",browsers:["IE8"],relevance:50,description:"IE only. Used to extend behaviors of the browser",restrictions:["url"]},{name:"-ms-block-progression",browsers:["IE8"],values:[{name:"bt",description:"Bottom-to-top block flow. Layout is horizontal."},{name:"lr",description:"Left-to-right direction. The flow orientation is vertical."},{name:"rl",description:"Right-to-left direction. The flow orientation is vertical."},{name:"tb",description:"Top-to-bottom direction. The flow orientation is horizontal."}],status:"nonstandard",syntax:"tb | rl | bt | lr",relevance:0,description:"Sets the block-progression value and the flow orientation",restrictions:["enum"]},{name:"-ms-content-zoom-chaining",browsers:["E","IE10"],values:[{name:"chained",description:"The nearest zoomable parent element begins zooming when the user hits a zoom limit during a manipulation. No bounce effect is shown."},{name:"none",description:"A bounce effect is shown when the user hits a zoom limit during a manipulation."}],status:"nonstandard",syntax:"none | chained",relevance:0,description:"Specifies the zoom behavior that occurs when a user hits the zoom limit during a manipulation."},{name:"-ms-content-zooming",browsers:["E","IE10"],values:[{name:"none",description:"The element is not zoomable."},{name:"zoom",description:"The element is zoomable."}],status:"nonstandard",syntax:"none | zoom",relevance:0,description:"Specifies whether zooming is enabled.",restrictions:["enum"]},{name:"-ms-content-zoom-limit",browsers:["E","IE10"],status:"nonstandard",syntax:"<'-ms-content-zoom-limit-min'> <'-ms-content-zoom-limit-max'>",relevance:0,description:"Shorthand property for the -ms-content-zoom-limit-min and -ms-content-zoom-limit-max properties.",restrictions:["percentage"]},{name:"-ms-content-zoom-limit-max",browsers:["E","IE10"],status:"nonstandard",syntax:"<percentage>",relevance:0,description:"Specifies the maximum zoom factor.",restrictions:["percentage"]},{name:"-ms-content-zoom-limit-min",browsers:["E","IE10"],status:"nonstandard",syntax:"<percentage>",relevance:0,description:"Specifies the minimum zoom factor.",restrictions:["percentage"]},{name:"-ms-content-zoom-snap",browsers:["E","IE10"],values:[{name:"mandatory",description:"Indicates that the motion of the content after the contact is picked up is always adjusted so that it lands on a snap-point."},{name:"none",description:"Indicates that zooming is unaffected by any defined snap-points."},{name:"proximity",description:'Indicates that the motion of the content after the contact is picked up may be adjusted if the content would normally stop "close enough" to a snap-point.'},{name:"snapInterval(100%, 100%)",description:"Specifies where the snap-points will be placed."},{name:"snapList()",description:"Specifies the position of individual snap-points as a comma-separated list of zoom factors."}],status:"nonstandard",syntax:"<'-ms-content-zoom-snap-type'> || <'-ms-content-zoom-snap-points'>",relevance:0,description:"Shorthand property for the -ms-content-zoom-snap-type and -ms-content-zoom-snap-points properties."},{name:"-ms-content-zoom-snap-points",browsers:["E","IE10"],values:[{name:"snapInterval(100%, 100%)",description:"Specifies where the snap-points will be placed."},{name:"snapList()",description:"Specifies the position of individual snap-points as a comma-separated list of zoom factors."}],status:"nonstandard",syntax:"snapInterval( <percentage>, <percentage> ) | snapList( <percentage># )",relevance:0,description:"Defines where zoom snap-points are located."},{name:"-ms-content-zoom-snap-type",browsers:["E","IE10"],values:[{name:"mandatory",description:"Indicates that the motion of the content after the contact is picked up is always adjusted so that it lands on a snap-point."},{name:"none",description:"Indicates that zooming is unaffected by any defined snap-points."},{name:"proximity",description:'Indicates that the motion of the content after the contact is picked up may be adjusted if the content would normally stop "close enough" to a snap-point.'}],status:"nonstandard",syntax:"none | proximity | mandatory",relevance:0,description:"Specifies how zooming is affected by defined snap-points.",restrictions:["enum"]},{name:"-ms-filter",browsers:["IE8-9"],status:"nonstandard",syntax:"<string>",relevance:0,description:"IE only. Used to produce visual effects.",restrictions:["string"]},{name:"-ms-flex",browsers:["IE10"],values:[{name:"auto",description:"Retrieves the value of the main size property as the used 'flex-basis'."},{name:"none",description:"Expands to '0 0 auto'."}],relevance:50,description:"specifies the parameters of a flexible length: the positive and negative flexibility, and the preferred size.",restrictions:["length","number","percentage"]},{name:"-ms-flex-align",browsers:["IE10"],values:[{name:"baseline",description:"If the flex item\u2019s inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."},{name:"center",description:"The flex item\u2019s margin box is centered in the cross axis within the line."},{name:"end",description:"The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."},{name:"start",description:"The cross-start margin edge of the flexbox item is placed flush with the cross-start edge of the line."},{name:"stretch",description:"If the cross size property of the flexbox item is anything other than 'auto', this value is identical to 'start'."}],relevance:50,description:"Aligns flex items along the cross axis of the current line of the flex container.",restrictions:["enum"]},{name:"-ms-flex-direction",browsers:["IE10"],values:[{name:"column",description:"The flex container\u2019s main axis has the same orientation as the block axis of the current writing mode."},{name:"column-reverse",description:"Same as 'column', except the main-start and main-end directions are swapped."},{name:"row",description:"The flex container\u2019s main axis has the same orientation as the inline axis of the current writing mode."},{name:"row-reverse",description:"Same as 'row', except the main-start and main-end directions are swapped."}],relevance:50,description:"Specifies how flex items are placed in the flex container, by setting the direction of the flex container\u2019s main axis.",restrictions:["enum"]},{name:"-ms-flex-flow",browsers:["IE10"],values:[{name:"column",description:"The flex container\u2019s main axis has the same orientation as the block axis of the current writing mode."},{name:"column-reverse",description:"Same as 'column', except the main-start and main-end directions are swapped."},{name:"nowrap",description:"The flex container is single-line."},{name:"row",description:"The flex container\u2019s main axis has the same orientation as the inline axis of the current writing mode."},{name:"wrap",description:"The flexbox is multi-line."},{name:"wrap-reverse",description:"Same as 'wrap', except the cross-start and cross-end directions are swapped."}],relevance:50,description:"Specifies how flexbox items are placed in the flexbox.",restrictions:["enum"]},{name:"-ms-flex-item-align",browsers:["IE10"],values:[{name:"auto",description:"Computes to the value of 'align-items' on the element\u2019s parent, or 'stretch' if the element has no parent. On absolutely positioned elements, it computes to itself."},{name:"baseline",description:"If the flex item\u2019s inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."},{name:"center",description:"The flex item\u2019s margin box is centered in the cross axis within the line."},{name:"end",description:"The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."},{name:"start",description:"The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."}],relevance:50,description:"Allows the default alignment along the cross axis to be overridden for individual flex items.",restrictions:["enum"]},{name:"-ms-flex-line-pack",browsers:["IE10"],values:[{name:"center",description:"Lines are packed toward the center of the flex container."},{name:"distribute",description:"Lines are evenly distributed in the flex container, with half-size spaces on either end."},{name:"end",description:"Lines are packed toward the end of the flex container."},{name:"justify",description:"Lines are evenly distributed in the flex container."},{name:"start",description:"Lines are packed toward the start of the flex container."},{name:"stretch",description:"Lines stretch to take up the remaining space."}],relevance:50,description:"Aligns a flex container\u2019s lines within the flex container when there is extra space in the cross-axis, similar to how 'justify-content' aligns individual items within the main-axis.",restrictions:["enum"]},{name:"-ms-flex-order",browsers:["IE10"],relevance:50,description:"Controls the order in which children of a flex container appear within the flex container, by assigning them to ordinal groups.",restrictions:["integer"]},{name:"-ms-flex-pack",browsers:["IE10"],values:[{name:"center",description:"Flex items are packed toward the center of the line."},{name:"distribute",description:"Flex items are evenly distributed in the line, with half-size spaces on either end."},{name:"end",description:"Flex items are packed toward the end of the line."},{name:"justify",description:"Flex items are evenly distributed in the line."},{name:"start",description:"Flex items are packed toward the start of the line."}],relevance:50,description:"Aligns flex items along the main axis of the current line of the flex container.",restrictions:["enum"]},{name:"-ms-flex-wrap",browsers:["IE10"],values:[{name:"nowrap",description:"The flex container is single-line."},{name:"wrap",description:"The flexbox is multi-line."},{name:"wrap-reverse",description:"Same as 'wrap', except the cross-start and cross-end directions are swapped."}],relevance:50,description:"Controls whether the flex container is single-line or multi-line, and the direction of the cross-axis, which determines the direction new lines are stacked in.",restrictions:["enum"]},{name:"-ms-flow-from",browsers:["E","IE10"],values:[{name:"none",description:"The block container is not a CSS Region."}],status:"nonstandard",syntax:"[ none | <custom-ident> ]#",relevance:0,description:"Makes a block container a region and associates it with a named flow.",restrictions:["identifier"]},{name:"-ms-flow-into",browsers:["E","IE10"],values:[{name:"none",description:"The element is not moved to a named flow and normal CSS processing takes place."}],status:"nonstandard",syntax:"[ none | <custom-ident> ]#",relevance:0,description:"Places an element or its contents into a named flow.",restrictions:["identifier"]},{name:"-ms-grid-column",browsers:["E12","IE10"],values:[{name:"auto"},{name:"end"},{name:"start"}],relevance:50,description:"Used to place grid items and explicitly defined grid cells in the Grid.",restrictions:["integer","string","enum"]},{name:"-ms-grid-column-align",browsers:["E12","IE10"],values:[{name:"center",description:"Places the center of the Grid Item's margin box at the center of the Grid Item's column."},{name:"end",description:"Aligns the end edge of the Grid Item's margin box to the end edge of the Grid Item's column."},{name:"start",description:"Aligns the starting edge of the Grid Item's margin box to the starting edge of the Grid Item's column."},{name:"stretch",description:"Ensures that the Grid Item's margin box is equal to the size of the Grid Item's column."}],relevance:50,description:"Aligns the columns in a grid.",restrictions:["enum"]},{name:"-ms-grid-columns",browsers:["E","IE10"],status:"nonstandard",syntax:"none | <track-list> | <auto-track-list>",relevance:0,description:"Lays out the columns of the grid."},{name:"-ms-grid-column-span",browsers:["E12","IE10"],relevance:50,description:"Specifies the number of columns to span.",restrictions:["integer"]},{name:"-ms-grid-layer",browsers:["E","IE10"],relevance:50,description:"Grid-layer is similar in concept to z-index, but avoids overloading the meaning of the z-index property, which is applicable only to positioned elements.",restrictions:["integer"]},{name:"-ms-grid-row",browsers:["E12","IE10"],values:[{name:"auto"},{name:"end"},{name:"start"}],relevance:50,description:"grid-row is used to place grid items and explicitly defined grid cells in the Grid.",restrictions:["integer","string","enum"]},{name:"-ms-grid-row-align",browsers:["E12","IE10"],values:[{name:"center",description:"Places the center of the Grid Item's margin box at the center of the Grid Item's row."},{name:"end",description:"Aligns the end edge of the Grid Item's margin box to the end edge of the Grid Item's row."},{name:"start",description:"Aligns the starting edge of the Grid Item's margin box to the starting edge of the Grid Item's row."},{name:"stretch",description:"Ensures that the Grid Item's margin box is equal to the size of the Grid Item's row."}],relevance:50,description:"Aligns the rows in a grid.",restrictions:["enum"]},{name:"-ms-grid-rows",browsers:["E","IE10"],status:"nonstandard",syntax:"none | <track-list> | <auto-track-list>",relevance:0,description:"Lays out the columns of the grid."},{name:"-ms-grid-row-span",browsers:["E12","IE10"],relevance:50,description:"Specifies the number of rows to span.",restrictions:["integer"]},{name:"-ms-high-contrast-adjust",browsers:["E","IE10"],values:[{name:"auto",description:"Properties will be adjusted as applicable."},{name:"none",description:"No adjustments will be applied."}],status:"nonstandard",syntax:"auto | none",relevance:0,description:"Specifies if properties should be adjusted in high contrast mode.",restrictions:["enum"]},{name:"-ms-hyphenate-limit-chars",browsers:["E","IE10"],values:[{name:"auto",description:"The user agent chooses a value that adapts to the current layout."}],status:"nonstandard",syntax:"auto | <integer>{1,3}",relevance:0,description:"Specifies the minimum number of characters in a hyphenated word.",restrictions:["integer"]},{name:"-ms-hyphenate-limit-lines",browsers:["E","IE10"],values:[{name:"no-limit",description:"There is no limit."}],status:"nonstandard",syntax:"no-limit | <integer>",relevance:0,description:"Indicates the maximum number of successive hyphenated lines in an element.",restrictions:["integer"]},{name:"-ms-hyphenate-limit-zone",browsers:["E","IE10"],status:"nonstandard",syntax:"<percentage> | <length>",relevance:0,description:"Specifies the maximum amount of unfilled space (before justification) that may be left in the line box before hyphenation is triggered to pull part of a word from the next line back up into the current line.",restrictions:["percentage","length"]},{name:"-ms-hyphens",browsers:["E","IE10"],values:[{name:"auto",description:"Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."},{name:"manual",description:"Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"},{name:"none",description:"Words are not broken at line breaks, even if characters inside the word suggest line break points."}],relevance:50,description:"Controls whether hyphenation is allowed to create more break opportunities within a line of text.",restrictions:["enum"]},{name:"-ms-ime-mode",browsers:["IE10"],values:[{name:"active",description:"The input method editor is initially active; text entry is performed using it unless the user specifically dismisses it."},{name:"auto",description:"No change is made to the current input method editor state. This is the default."},{name:"disabled",description:"The input method editor is disabled and may not be activated by the user."},{name:"inactive",description:"The input method editor is initially inactive, but the user may activate it if they wish."},{name:"normal",description:"The IME state should be normal; this value can be used in a user style sheet to override the page setting."}],relevance:50,description:"Controls the state of the input method editor for text fields.",restrictions:["enum"]},{name:"-ms-interpolation-mode",browsers:["IE7"],values:[{name:"bicubic"},{name:"nearest-neighbor"}],relevance:50,description:"Gets or sets the interpolation (resampling) method used to stretch images.",restrictions:["enum"]},{name:"-ms-layout-grid",browsers:["E","IE10"],values:[{name:"char",description:"Any of the range of character values available to the -ms-layout-grid-char property."},{name:"line",description:"Any of the range of line values available to the -ms-layout-grid-line property."},{name:"mode",description:"Any of the range of mode values available to the -ms-layout-grid-mode property."},{name:"type",description:"Any of the range of type values available to the -ms-layout-grid-type property."}],relevance:50,description:"Sets or retrieves the composite document grid properties that specify the layout of text characters."},{name:"-ms-layout-grid-char",browsers:["E","IE10"],values:[{name:"auto",description:"Largest character in the font of the element is used to set the character grid."},{name:"none",description:"Default. No character grid is set."}],relevance:50,description:"Sets or retrieves the size of the character grid used for rendering the text content of an element.",restrictions:["enum","length","percentage"]},{name:"-ms-layout-grid-line",browsers:["E","IE10"],values:[{name:"auto",description:"Largest character in the font of the element is used to set the character grid."},{name:"none",description:"Default. No grid line is set."}],relevance:50,description:"Sets or retrieves the gridline value used for rendering the text content of an element.",restrictions:["length"]},{name:"-ms-layout-grid-mode",browsers:["E","IE10"],values:[{name:"both",description:"Default. Both the char and line grid modes are enabled. This setting is necessary to fully enable the layout grid on an element."},{name:"char",description:"Only a character grid is used. This is recommended for use with block-level elements, such as a blockquote, where the line grid is intended to be disabled."},{name:"line",description:"Only a line grid is used. This is recommended for use with inline elements, such as a span, to disable the horizontal grid on runs of text that act as a single entity in the grid layout."},{name:"none",description:"No grid is used."}],relevance:50,description:"Gets or sets whether the text layout grid uses two dimensions.",restrictions:["enum"]},{name:"-ms-layout-grid-type",browsers:["E","IE10"],values:[{name:"fixed",description:"Grid used for monospaced layout. All noncursive characters are treated as equal; every character is centered within a single grid space by default."},{name:"loose",description:"Default. Grid used for Japanese and Korean characters."},{name:"strict",description:"Grid used for Chinese, as well as Japanese (Genko) and Korean characters. Only the ideographs, kanas, and wide characters are snapped to the grid."}],relevance:50,description:"Sets or retrieves the type of grid used for rendering the text content of an element.",restrictions:["enum"]},{name:"-ms-line-break",browsers:["E","IE10"],values:[{name:"auto",description:"The UA determines the set of line-breaking restrictions to use for CJK scripts, and it may vary the restrictions based on the length of the line; e.g., use a less restrictive set of line-break rules for short lines."},{name:"keep-all",description:"Sequences of CJK characters can no longer break on implied break points. This option should only be used where the presence of word separator characters still creates line-breaking opportunities, as in Korean."},{name:"newspaper",description:"Breaks CJK scripts using the least restrictive set of line-breaking rules. Typically used for short lines, such as in newspapers."},{name:"normal",description:"Breaks CJK scripts using a normal set of line-breaking rules."},{name:"strict",description:"Breaks CJK scripts using a more restrictive set of line-breaking rules than 'normal'."}],relevance:50,description:"Specifies what set of line breaking restrictions are in effect within the element.",restrictions:["enum"]},{name:"-ms-overflow-style",browsers:["E","IE10"],values:[{name:"auto",description:"No preference, UA should use the first scrolling method in the list that it supports."},{name:"-ms-autohiding-scrollbar",description:"Indicates the element displays auto-hiding scrollbars during mouse interactions and panning indicators during touch and keyboard interactions."},{name:"none",description:"Indicates the element does not display scrollbars or panning indicators, even when its content overflows."},{name:"scrollbar",description:'Scrollbars are typically narrow strips inserted on one or two edges of an element and which often have arrows to click on and a "thumb" to drag up and down (or left and right) to move the contents of the element.'}],status:"nonstandard",syntax:"auto | none | scrollbar | -ms-autohiding-scrollbar",relevance:0,description:"Specify whether content is clipped when it overflows the element's content area.",restrictions:["enum"]},{name:"-ms-perspective",browsers:["IE10"],values:[{name:"none",description:"No perspective transform is applied."}],relevance:50,description:"Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",restrictions:["length"]},{name:"-ms-perspective-origin",browsers:["IE10"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-ms-perspective-origin-x",browsers:["IE10"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the X  position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-ms-perspective-origin-y",browsers:["IE10"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-ms-progress-appearance",browsers:["IE10"],values:[{name:"bar"},{name:"ring"}],relevance:50,description:"Gets or sets a value that specifies whether a progress control displays as a bar or a ring.",restrictions:["enum"]},{name:"-ms-scrollbar-3dlight-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-arrow-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the arrow elements of a scroll arrow.",restrictions:["color"]},{name:"-ms-scrollbar-base-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the main elements of a scroll bar, which include the scroll box, track, and scroll arrows.",restrictions:["color"]},{name:"-ms-scrollbar-darkshadow-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the gutter of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-face-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-highlight-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-shadow-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the bottom and right edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-track-color",browsers:["IE5"],status:"nonstandard",syntax:"<color>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-ms-scrollbar-track-color"}],description:"Determines the color of the track element of a scroll bar.",restrictions:["color"]},{name:"-ms-scroll-chaining",browsers:["E","IE10"],values:[{name:"chained"},{name:"none"}],status:"nonstandard",syntax:"chained | none",relevance:0,description:"Gets or sets a value that indicates the scrolling behavior that occurs when a user hits the content boundary during a manipulation.",restrictions:["enum","length"]},{name:"-ms-scroll-limit",browsers:["E","IE10"],values:[{name:"auto"}],status:"nonstandard",syntax:"<'-ms-scroll-limit-x-min'> <'-ms-scroll-limit-y-min'> <'-ms-scroll-limit-x-max'> <'-ms-scroll-limit-y-max'>",relevance:0,description:"Gets or sets a shorthand value that sets values for the -ms-scroll-limit-x-min, -ms-scroll-limit-y-min, -ms-scroll-limit-x-max, and -ms-scroll-limit-y-max properties.",restrictions:["length"]},{name:"-ms-scroll-limit-x-max",browsers:["E","IE10"],values:[{name:"auto"}],status:"nonstandard",syntax:"auto | <length>",relevance:0,description:"Gets or sets a value that specifies the maximum value for the scrollLeft property.",restrictions:["length"]},{name:"-ms-scroll-limit-x-min",browsers:["E","IE10"],status:"nonstandard",syntax:"<length>",relevance:0,description:"Gets or sets a value that specifies the minimum value for the scrollLeft property.",restrictions:["length"]},{name:"-ms-scroll-limit-y-max",browsers:["E","IE10"],values:[{name:"auto"}],status:"nonstandard",syntax:"auto | <length>",relevance:0,description:"Gets or sets a value that specifies the maximum value for the scrollTop property.",restrictions:["length"]},{name:"-ms-scroll-limit-y-min",browsers:["E","IE10"],status:"nonstandard",syntax:"<length>",relevance:0,description:"Gets or sets a value that specifies the minimum value for the scrollTop property.",restrictions:["length"]},{name:"-ms-scroll-rails",browsers:["E","IE10"],values:[{name:"none"},{name:"railed"}],status:"nonstandard",syntax:"none | railed",relevance:0,description:"Gets or sets a value that indicates whether or not small motions perpendicular to the primary axis of motion will result in either changes to both the scrollTop and scrollLeft properties or a change to the primary axis (for instance, either the scrollTop or scrollLeft properties will change, but not both).",restrictions:["enum","length"]},{name:"-ms-scroll-snap-points-x",browsers:["E","IE10"],values:[{name:"snapInterval(100%, 100%)"},{name:"snapList()"}],status:"nonstandard",syntax:"snapInterval( <length-percentage>, <length-percentage> ) | snapList( <length-percentage># )",relevance:0,description:"Gets or sets a value that defines where snap-points will be located along the x-axis.",restrictions:["enum"]},{name:"-ms-scroll-snap-points-y",browsers:["E","IE10"],values:[{name:"snapInterval(100%, 100%)"},{name:"snapList()"}],status:"nonstandard",syntax:"snapInterval( <length-percentage>, <length-percentage> ) | snapList( <length-percentage># )",relevance:0,description:"Gets or sets a value that defines where snap-points will be located along the y-axis.",restrictions:["enum"]},{name:"-ms-scroll-snap-type",browsers:["E","IE10"],values:[{name:"none",description:"The visual viewport of this scroll container must ignore snap points, if any, when scrolled."},{name:"mandatory",description:"The visual viewport of this scroll container is guaranteed to rest on a snap point when there are no active scrolling operations."},{name:"proximity",description:"The visual viewport of this scroll container may come to rest on a snap point at the termination of a scroll at the discretion of the UA given the parameters of the scroll."}],status:"nonstandard",syntax:"none | proximity | mandatory",relevance:0,description:"Gets or sets a value that defines what type of snap-point should be used for the current element. There are two type of snap-points, with the primary difference being whether or not the user is guaranteed to always stop on a snap-point.",restrictions:["enum"]},{name:"-ms-scroll-snap-x",browsers:["E","IE10"],values:[{name:"mandatory"},{name:"none"},{name:"proximity"},{name:"snapInterval(100%, 100%)"},{name:"snapList()"}],status:"nonstandard",syntax:"<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-x'>",relevance:0,description:"Gets or sets a shorthand value that sets values for the -ms-scroll-snap-type and -ms-scroll-snap-points-x properties.",restrictions:["enum"]},{name:"-ms-scroll-snap-y",browsers:["E","IE10"],values:[{name:"mandatory"},{name:"none"},{name:"proximity"},{name:"snapInterval(100%, 100%)"},{name:"snapList()"}],status:"nonstandard",syntax:"<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-y'>",relevance:0,description:"Gets or sets a shorthand value that sets values for the -ms-scroll-snap-type and -ms-scroll-snap-points-y properties.",restrictions:["enum"]},{name:"-ms-scroll-translation",browsers:["E","IE10"],values:[{name:"none"},{name:"vertical-to-horizontal"}],status:"nonstandard",syntax:"none | vertical-to-horizontal",relevance:0,description:"Gets or sets a value that specifies whether vertical-to-horizontal scroll wheel translation occurs on the specified element.",restrictions:["enum"]},{name:"-ms-text-align-last",browsers:["E","IE8"],values:[{name:"auto"},{name:"center",description:"The inline contents are centered within the line box."},{name:"justify",description:"The text is justified according to the method specified by the 'text-justify' property."},{name:"left",description:"The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."},{name:"right",description:"The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."}],relevance:50,description:"Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",restrictions:["enum"]},{name:"-ms-text-autospace",browsers:["E","IE8"],values:[{name:"ideograph-alpha",description:"Creates 1/4em extra spacing between runs of ideographic letters and non-ideographic letters, such as Latin-based, Cyrillic, Greek, Arabic or Hebrew."},{name:"ideograph-numeric",description:"Creates 1/4em extra spacing between runs of ideographic letters and numeric glyphs."},{name:"ideograph-parenthesis",description:"Creates extra spacing between normal (non wide) parenthesis and ideographs."},{name:"ideograph-space",description:"Extends the width of the space character while surrounded by ideographs."},{name:"none",description:"No extra space is created."},{name:"punctuation",description:"Creates extra non-breaking spacing around punctuation as required by language-specific typographic conventions."}],status:"nonstandard",syntax:"none | ideograph-alpha | ideograph-numeric | ideograph-parenthesis | ideograph-space",relevance:0,description:"Determines whether or not a full-width punctuation mark character should be trimmed if it appears at the beginning of a line, so that its 'ink' lines up with the first glyph in the line above and below.",restrictions:["enum"]},{name:"-ms-text-combine-horizontal",browsers:["E","IE11"],values:[{name:"all",description:"Attempt to typeset horizontally all consecutive characters within the box such that they take up the space of a single character within the vertical line box."},{name:"digits",description:"Attempt to typeset horizontally each maximal sequence of consecutive ASCII digits (U+0030\u2013U+0039) that has as many or fewer characters than the specified integer such that it takes up the space of a single character within the vertical line box."},{name:"none",description:"No special processing."}],relevance:50,description:"This property specifies the combination of multiple characters into the space of a single character.",restrictions:["enum","integer"]},{name:"-ms-text-justify",browsers:["E","IE8"],values:[{name:"auto",description:"The UA determines the justification algorithm to follow, based on a balance between performance and adequate presentation quality."},{name:"distribute",description:"Justification primarily changes spacing both at word separators and at grapheme cluster boundaries in all scripts except those in the connected and cursive groups. This value is sometimes used in e.g. Japanese, often with the 'text-align-last' property."},{name:"inter-cluster",description:"Justification primarily changes spacing at word separators and at grapheme cluster boundaries in clustered scripts. This value is typically used for Southeast Asian scripts such as Thai."},{name:"inter-ideograph",description:"Justification primarily changes spacing at word separators and at inter-graphemic boundaries in scripts that use no word spaces. This value is typically used for CJK languages."},{name:"inter-word",description:"Justification primarily changes spacing at word separators. This value is typically used for languages that separate words using spaces, like English or (sometimes) Korean."},{name:"kashida",description:"Justification primarily stretches Arabic and related scripts through the use of kashida or other calligraphic elongation."}],relevance:50,description:"Selects the justification algorithm used when 'text-align' is set to 'justify'. The property applies to block containers, but the UA may (but is not required to) also support it on inline elements.",restrictions:["enum"]},{name:"-ms-text-kashida-space",browsers:["E","IE10"],relevance:50,description:"Sets or retrieves the ratio of kashida expansion to white space expansion when justifying lines of text in the object.",restrictions:["percentage"]},{name:"-ms-text-overflow",browsers:["IE10"],values:[{name:"clip",description:"Clip inline content that overflows. Characters may be only partially rendered."},{name:"ellipsis",description:"Render an ellipsis character (U+2026) to represent clipped inline content."}],relevance:50,description:"Text can overflow for example when it is prevented from wrapping",restrictions:["enum"]},{name:"-ms-text-size-adjust",browsers:["E","IE10"],values:[{name:"auto",description:"Renderers must use the default size adjustment when displaying on a small device."},{name:"none",description:"Renderers must not do size adjustment when displaying on a small device."}],relevance:50,description:"Specifies a size adjustment for displaying text content in mobile browsers.",restrictions:["enum","percentage"]},{name:"-ms-text-underline-position",browsers:["E","IE10"],values:[{name:"alphabetic",description:"The underline is aligned with the alphabetic baseline. In this case the underline is likely to cross some descenders."},{name:"auto",description:"The user agent may use any algorithm to determine the underline's position. In horizontal line layout, the underline should be aligned as for alphabetic. In vertical line layout, if the language is set to Japanese or Korean, the underline should be aligned as for over."},{name:"over",description:"The underline is aligned with the 'top' (right in vertical writing) edge of the element's em-box. In this mode, an overline also switches sides."},{name:"under",description:"The underline is aligned with the 'bottom' (left in vertical writing) edge of the element's em-box. In this case the underline usually does not cross the descenders. This is sometimes called 'accounting' underline."}],relevance:50,description:"Sets the position of an underline specified on the same element: it does not affect underlines specified by ancestor elements.This property is typically used in vertical writing contexts such as in Japanese documents where it often desired to have the underline appear 'over' (to the right of) the affected run of text",restrictions:["enum"]},{name:"-ms-touch-action",browsers:["IE10"],values:[{name:"auto",description:"The element is a passive element, with several exceptions."},{name:"double-tap-zoom",description:"The element will zoom on double-tap."},{name:"manipulation",description:"The element is a manipulation-causing element."},{name:"none",description:"The element is a manipulation-blocking element."},{name:"pan-x",description:"The element permits touch-driven panning on the horizontal axis. The touch pan is performed on the nearest ancestor with horizontally scrollable content."},{name:"pan-y",description:"The element permits touch-driven panning on the vertical axis. The touch pan is performed on the nearest ancestor with vertically scrollable content."},{name:"pinch-zoom",description:"The element permits pinch-zooming. The pinch-zoom is performed on the nearest ancestor with zoomable content."}],relevance:50,description:"Gets or sets a value that indicates whether and how a given region can be manipulated by the user.",restrictions:["enum"]},{name:"-ms-touch-select",browsers:["E","IE10"],values:[{name:"grippers",description:"Grippers are always on."},{name:"none",description:"Grippers are always off."}],status:"nonstandard",syntax:"grippers | none",relevance:0,description:"Gets or sets a value that toggles the 'gripper' visual elements that enable touch text selection.",restrictions:["enum"]},{name:"-ms-transform",browsers:["IE9-9"],values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],relevance:50,description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"-ms-transform-origin",browsers:["IE9-9"],relevance:50,description:"Establishes the origin of transformation for an element.",restrictions:["position","length","percentage"]},{name:"-ms-transform-origin-x",browsers:["IE10"],relevance:50,description:"The x coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-ms-transform-origin-y",browsers:["IE10"],relevance:50,description:"The y coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-ms-transform-origin-z",browsers:["IE10"],relevance:50,description:"The z coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-ms-user-select",browsers:["E","IE10"],values:[{name:"element"},{name:"none"},{name:"text"}],status:"nonstandard",syntax:"none | element | text",relevance:0,description:"Controls the appearance of selection.",restrictions:["enum"]},{name:"-ms-word-break",browsers:["IE8"],values:[{name:"break-all",description:"Lines may break between any two grapheme clusters for non-CJK scripts."},{name:"keep-all",description:"Block characters can no longer create implied break points."},{name:"normal",description:"Breaks non-CJK scripts according to their own rules."}],relevance:50,description:"Specifies line break opportunities for non-CJK scripts.",restrictions:["enum"]},{name:"-ms-word-wrap",browsers:["IE8"],values:[{name:"break-word",description:"An unbreakable 'word' may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."},{name:"normal",description:"Lines may break only at allowed break points."}],relevance:50,description:"Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit.",restrictions:["enum"]},{name:"-ms-wrap-flow",browsers:["E","IE10"],values:[{name:"auto",description:"For floats an exclusion is created, for all other elements an exclusion is not created."},{name:"both",description:"Inline flow content can flow on all sides of the exclusion."},{name:"clear",description:"Inline flow content can only wrap on top and bottom of the exclusion and must leave the areas to the start and end edges of the exclusion box empty."},{name:"end",description:"Inline flow content can wrap on the end side of the exclusion area but must leave the area to the start edge of the exclusion area empty."},{name:"maximum",description:"Inline flow content can wrap on the side of the exclusion with the largest available space for the given line, and must leave the other side of the exclusion empty."},{name:"minimum",description:"Inline flow content can flow around the edge of the exclusion with the smallest available space within the flow content\u2019s containing block, and must leave the other edge of the exclusion empty."},{name:"start",description:"Inline flow content can wrap on the start edge of the exclusion area but must leave the area to end edge of the exclusion area empty."}],status:"nonstandard",syntax:"auto | both | start | end | maximum | clear",relevance:0,description:"An element becomes an exclusion when its 'wrap-flow' property has a computed value other than 'auto'.",restrictions:["enum"]},{name:"-ms-wrap-margin",browsers:["E","IE10"],status:"nonstandard",syntax:"<length>",relevance:0,description:"Gets or sets a value that is used to offset the inner wrap shape from other shapes.",restrictions:["length","percentage"]},{name:"-ms-wrap-through",browsers:["E","IE10"],values:[{name:"none",description:"The exclusion element does not inherit its parent node's wrapping context. Its descendants are only subject to exclusion shapes defined inside the element."},{name:"wrap",description:"The exclusion element inherits its parent node's wrapping context. Its descendant inline content wraps around exclusions defined outside the element."}],status:"nonstandard",syntax:"wrap | none",relevance:0,description:"Specifies if an element inherits its parent wrapping context. In other words if it is subject to the exclusions defined outside the element.",restrictions:["enum"]},{name:"-ms-writing-mode",browsers:["IE8"],values:[{name:"bt-lr"},{name:"bt-rl"},{name:"lr-bt"},{name:"lr-tb"},{name:"rl-bt"},{name:"rl-tb"},{name:"tb-lr"},{name:"tb-rl"}],relevance:50,description:"Shorthand property for both 'direction' and 'block-progression'.",restrictions:["enum"]},{name:"-ms-zoom",browsers:["IE8"],values:[{name:"normal"}],relevance:50,description:"Sets or retrieves the magnification scale of the object.",restrictions:["enum","integer","number","percentage"]},{name:"-ms-zoom-animation",browsers:["IE10"],values:[{name:"default"},{name:"none"}],relevance:50,description:"Gets or sets a value that indicates whether an animation is used when zooming.",restrictions:["enum"]},{name:"nav-down",browsers:["O9.5"],values:[{name:"auto",description:"The user agent automatically determines which element to navigate the focus to in response to directional navigational input."},{name:"current",description:"Indicates that the user agent should target the frame that the element is in."},{name:"root",description:"Indicates that the user agent should target the full window."}],relevance:50,description:"Provides an way to control directional focus navigation.",restrictions:["enum","identifier","string"]},{name:"nav-index",browsers:["O9.5"],values:[{name:"auto",description:"The element's sequential navigation order is assigned automatically by the user agent."}],relevance:50,description:"Provides an input-method-neutral way of specifying the sequential navigation order (also known as 'tabbing order').",restrictions:["number"]},{name:"nav-left",browsers:["O9.5"],values:[{name:"auto",description:"The user agent automatically determines which element to navigate the focus to in response to directional navigational input."},{name:"current",description:"Indicates that the user agent should target the frame that the element is in."},{name:"root",description:"Indicates that the user agent should target the full window."}],relevance:50,description:"Provides an way to control directional focus navigation.",restrictions:["enum","identifier","string"]},{name:"nav-right",browsers:["O9.5"],values:[{name:"auto",description:"The user agent automatically determines which element to navigate the focus to in response to directional navigational input."},{name:"current",description:"Indicates that the user agent should target the frame that the element is in."},{name:"root",description:"Indicates that the user agent should target the full window."}],relevance:50,description:"Provides an way to control directional focus navigation.",restrictions:["enum","identifier","string"]},{name:"nav-up",browsers:["O9.5"],values:[{name:"auto",description:"The user agent automatically determines which element to navigate the focus to in response to directional navigational input."},{name:"current",description:"Indicates that the user agent should target the frame that the element is in."},{name:"root",description:"Indicates that the user agent should target the full window."}],relevance:50,description:"Provides an way to control directional focus navigation.",restrictions:["enum","identifier","string"]},{name:"negative",browsers:["FF33"],syntax:"<symbol> <symbol>?",relevance:50,description:"@counter-style descriptor. Defines how to alter the representation when the counter value is negative.",restrictions:["image","identifier","string"]},{name:"-o-animation",browsers:["O12"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"infinite",description:"Causes the animation to repeat forever."},{name:"none",description:"No animation is performed"},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Shorthand property combines six of the animation properties into a single property.",restrictions:["time","enum","timing-function","identifier","number"]},{name:"-o-animation-delay",browsers:["O12"],relevance:50,description:"Defines when the animation will start.",restrictions:["time"]},{name:"-o-animation-direction",browsers:["O12"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Defines whether or not the animation should play in reverse on alternate cycles.",restrictions:["enum"]},{name:"-o-animation-duration",browsers:["O12"],relevance:50,description:"Defines the length of time that an animation takes to complete one cycle.",restrictions:["time"]},{name:"-o-animation-fill-mode",browsers:["O12"],values:[{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"none",description:"There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."}],relevance:50,description:"Defines what values are applied by the animation outside the time it is executing.",restrictions:["enum"]},{name:"-o-animation-iteration-count",browsers:["O12"],values:[{name:"infinite",description:"Causes the animation to repeat forever."}],relevance:50,description:"Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",restrictions:["number","enum"]},{name:"-o-animation-name",browsers:["O12"],values:[{name:"none",description:"No animation is performed"}],relevance:50,description:"Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",restrictions:["identifier","enum"]},{name:"-o-animation-play-state",browsers:["O12"],values:[{name:"paused",description:"A running animation will be paused."},{name:"running",description:"Resume playback of a paused animation."}],relevance:50,description:"Defines whether the animation is running or paused.",restrictions:["enum"]},{name:"-o-animation-timing-function",browsers:["O12"],relevance:50,description:"Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",restrictions:["timing-function"]},{name:"object-fit",browsers:["E79","FF36","S10","C32","O19"],values:[{name:"contain",description:"The replaced content is sized to maintain its aspect ratio while fitting within the element\u2019s content box: its concrete object size is resolved as a contain constraint against the element's used width and height."},{name:"cover",description:"The replaced content is sized to maintain its aspect ratio while filling the element's entire content box: its concrete object size is resolved as a cover constraint against the element\u2019s used width and height."},{name:"fill",description:"The replaced content is sized to fill the element\u2019s content box: the object's concrete object size is the element's used width and height."},{name:"none",description:"The replaced content is not resized to fit inside the element's content box"},{name:"scale-down",description:"Size the content as if \u2018none\u2019 or \u2018contain\u2019 were specified, whichever would result in a smaller concrete object size."}],syntax:"fill | contain | cover | none | scale-down",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/object-fit"}],description:"Specifies how the contents of a replaced element should be scaled relative to the box established by its used height and width.",restrictions:["enum"]},{name:"object-position",browsers:["E79","FF36","S10","C32","O19"],syntax:"<position>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/object-position"}],description:"Determines the alignment of the replaced element inside its box.",restrictions:["position","length","percentage"]},{name:"-o-border-image",browsers:["O11.6"],values:[{name:"auto",description:"If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."},{name:"fill",description:"Causes the middle part of the border-image to be preserved."},{name:"none"},{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."}],relevance:50,description:"Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",restrictions:["length","percentage","number","image","enum"]},{name:"-o-object-fit",browsers:["O10.6"],values:[{name:"contain",description:"The replaced content is sized to maintain its aspect ratio while fitting within the element\u2019s content box: its concrete object size is resolved as a contain constraint against the element's used width and height."},{name:"cover",description:"The replaced content is sized to maintain its aspect ratio while filling the element's entire content box: its concrete object size is resolved as a cover constraint against the element\u2019s used width and height."},{name:"fill",description:"The replaced content is sized to fill the element\u2019s content box: the object's concrete object size is the element's used width and height."},{name:"none",description:"The replaced content is not resized to fit inside the element's content box"},{name:"scale-down",description:"Size the content as if \u2018none\u2019 or \u2018contain\u2019 were specified, whichever would result in a smaller concrete object size."}],relevance:50,description:"Specifies how the contents of a replaced element should be scaled relative to the box established by its used height and width.",restrictions:["enum"]},{name:"-o-object-position",browsers:["O10.6"],relevance:50,description:"Determines the alignment of the replaced element inside its box.",restrictions:["position","length","percentage"]},{name:"opacity",syntax:"<alpha-value>",relevance:93,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/opacity"}],description:"Opacity of an element's text, where 1 is opaque and 0 is entirely transparent.",restrictions:["number(0-1)"]},{name:"order",syntax:"<integer>",relevance:63,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/order"}],description:"Controls the order in which children of a flex container appear within the flex container, by assigning them to ordinal groups.",restrictions:["integer"]},{name:"orphans",browsers:["E12","S1.3","C25","IE8","O9.2"],syntax:"<integer>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/orphans"}],description:"Specifies the minimum number of line boxes in a block container that must be left in a fragment before a fragmentation break.",restrictions:["integer"]},{name:"-o-table-baseline",browsers:["O9.6"],relevance:50,description:"Determines which row of a inline-table should be used as baseline of inline-table.",restrictions:["integer"]},{name:"-o-tab-size",browsers:["O10.6"],relevance:50,description:"This property determines the width of the tab character (U+0009), in space characters (U+0020), when rendered.",restrictions:["integer","length"]},{name:"-o-text-overflow",browsers:["O10"],values:[{name:"clip",description:"Clip inline content that overflows. Characters may be only partially rendered."},{name:"ellipsis",description:"Render an ellipsis character (U+2026) to represent clipped inline content."}],relevance:50,description:"Text can overflow for example when it is prevented from wrapping",restrictions:["enum"]},{name:"-o-transform",browsers:["O10.5"],values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],relevance:50,description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"-o-transform-origin",browsers:["O10.5"],relevance:50,description:"Establishes the origin of transformation for an element.",restrictions:["positon","length","percentage"]},{name:"-o-transition",browsers:["O11.5"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Shorthand property combines four of the transition properties into a single property.",restrictions:["time","property","timing-function","enum"]},{name:"-o-transition-delay",browsers:["O11.5"],relevance:50,description:"Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",restrictions:["time"]},{name:"-o-transition-duration",browsers:["O11.5"],relevance:50,description:"Specifies how long the transition from the old value to the new value should take.",restrictions:["time"]},{name:"-o-transition-property",browsers:["O11.5"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Specifies the name of the CSS property to which the transition is applied.",restrictions:["property"]},{name:"-o-transition-timing-function",browsers:["O11.5"],relevance:50,description:"Describes how the intermediate values used during a transition will be calculated.",restrictions:["timing-function"]},{name:"offset-block-end",browsers:["FF41"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."}],relevance:50,description:"Logical 'bottom'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"offset-block-start",browsers:["FF41"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."}],relevance:50,description:"Logical 'top'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"offset-inline-end",browsers:["FF41"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."}],relevance:50,description:"Logical 'right'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"offset-inline-start",browsers:["FF41"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."}],relevance:50,description:"Logical 'left'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"outline",values:[{name:"auto",description:"Permits the user agent to render a custom outline style, typically the default platform style."},{name:"invert",description:"Performs a color inversion on the pixels on the screen."}],syntax:"[ <'outline-color'> || <'outline-style'> || <'outline-width'> ]",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline"}],description:"Shorthand property for 'outline-style', 'outline-width', and 'outline-color'.",restrictions:["length","line-width","line-style","color","enum"]},{name:"outline-color",values:[{name:"invert",description:"Performs a color inversion on the pixels on the screen."}],syntax:"<color> | invert",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline-color"}],description:"The color of the outline.",restrictions:["enum","color"]},{name:"outline-offset",browsers:["E15","FF1.5","S1.2","C1","O9.5"],syntax:"<length>",relevance:69,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline-offset"}],description:"Offset the outline and draw it beyond the border edge.",restrictions:["length"]},{name:"outline-style",values:[{name:"auto",description:"Permits the user agent to render a custom outline style, typically the default platform style."}],syntax:"auto | <'border-style'>",relevance:61,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline-style"}],description:"Style of the outline.",restrictions:["line-style","enum"]},{name:"outline-width",syntax:"<line-width>",relevance:61,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline-width"}],description:"Width of the outline.",restrictions:["length","line-width"]},{name:"overflow",values:[{name:"auto",description:"The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."},{name:"hidden",description:"Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."},{name:"-moz-hidden-unscrollable",description:"Same as the standardized 'clip', except doesn\u2019t establish a block formatting context."},{name:"scroll",description:"Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."},{name:"visible",description:"Content is not clipped, i.e., it may be rendered outside the content box."}],syntax:"[ visible | hidden | clip | scroll | auto ]{1,2}",relevance:93,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow"}],description:"Shorthand for setting 'overflow-x' and 'overflow-y'.",restrictions:["enum"]},{name:"overflow-wrap",values:[{name:"break-word",description:"An otherwise unbreakable sequence of characters may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."},{name:"normal",description:"Lines may break only at allowed break points."}],syntax:"normal | break-word | anywhere",relevance:66,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-wrap"}],description:"Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit within the line box.",restrictions:["enum"]},{name:"overflow-x",values:[{name:"auto",description:"The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."},{name:"hidden",description:"Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."},{name:"scroll",description:"Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."},{name:"visible",description:"Content is not clipped, i.e., it may be rendered outside the content box."}],syntax:"visible | hidden | clip | scroll | auto",relevance:81,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-x"}],description:"Specifies the handling of overflow in the horizontal direction.",restrictions:["enum"]},{name:"overflow-y",values:[{name:"auto",description:"The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."},{name:"hidden",description:"Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."},{name:"scroll",description:"Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."},{name:"visible",description:"Content is not clipped, i.e., it may be rendered outside the content box."}],syntax:"visible | hidden | clip | scroll | auto",relevance:83,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-y"}],description:"Specifies the handling of overflow in the vertical direction.",restrictions:["enum"]},{name:"pad",browsers:["FF33"],syntax:"<integer> && <symbol>",relevance:50,description:"@counter-style descriptor. Specifies a \u201Cfixed-width\u201D counter style, where representations shorter than the pad value are padded with a particular <symbol>",restrictions:["integer","image","string","identifier"]},{name:"padding",values:[],syntax:"[ <length> | <percentage> ]{1,4}",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"padding-bottom",syntax:"<length> | <percentage>",relevance:89,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-bottom"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"padding-block-end",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'padding-left'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-block-end"}],description:"Logical 'padding-bottom'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"padding-block-start",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'padding-left'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-block-start"}],description:"Logical 'padding-top'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"padding-inline-end",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'padding-left'>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-inline-end"}],description:"Logical 'padding-right'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"padding-inline-start",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'padding-left'>",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-inline-start"}],description:"Logical 'padding-left'. Mapping depends on the parent element\u2019s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"padding-left",syntax:"<length> | <percentage>",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-left"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"padding-right",syntax:"<length> | <percentage>",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-right"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"padding-top",syntax:"<length> | <percentage>",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-top"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"page-break-after",values:[{name:"always",description:"Always force a page break after the generated box."},{name:"auto",description:"Neither force nor forbid a page break after generated box."},{name:"avoid",description:"Avoid a page break after the generated box."},{name:"left",description:"Force one or two page breaks after the generated box so that the next page is formatted as a left page."},{name:"right",description:"Force one or two page breaks after the generated box so that the next page is formatted as a right page."}],syntax:"auto | always | avoid | left | right | recto | verso",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/page-break-after"}],description:"Defines rules for page breaks after an element.",restrictions:["enum"]},{name:"page-break-before",values:[{name:"always",description:"Always force a page break before the generated box."},{name:"auto",description:"Neither force nor forbid a page break before the generated box."},{name:"avoid",description:"Avoid a page break before the generated box."},{name:"left",description:"Force one or two page breaks before the generated box so that the next page is formatted as a left page."},{name:"right",description:"Force one or two page breaks before the generated box so that the next page is formatted as a right page."}],syntax:"auto | always | avoid | left | right | recto | verso",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/page-break-before"}],description:"Defines rules for page breaks before an element.",restrictions:["enum"]},{name:"page-break-inside",values:[{name:"auto",description:"Neither force nor forbid a page break inside the generated box."},{name:"avoid",description:"Avoid a page break inside the generated box."}],syntax:"auto | avoid",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/page-break-inside"}],description:"Defines rules for page breaks inside an element.",restrictions:["enum"]},{name:"paint-order",browsers:["E17","FF60","S8","C35","O22"],values:[{name:"fill"},{name:"markers"},{name:"normal",description:"The element is painted with the standard order of painting operations: the 'fill' is painted first, then its 'stroke' and finally its markers."},{name:"stroke"}],syntax:"normal | [ fill || stroke || markers ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/paint-order"}],description:"Controls the order that the three paint operations that shapes and text are rendered with: their fill, their stroke and any markers they might have.",restrictions:["enum"]},{name:"perspective",values:[{name:"none",description:"No perspective transform is applied."}],syntax:"none | <length>",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/perspective"}],description:"Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",restrictions:["length","enum"]},{name:"perspective-origin",syntax:"<position>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/perspective-origin"}],description:"Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"pointer-events",values:[{name:"all",description:"The given element can be the target element for pointer events whenever the pointer is over either the interior or the perimeter of the element."},{name:"fill",description:"The given element can be the target element for pointer events whenever the pointer is over the interior of the element."},{name:"none",description:"The given element does not receive pointer events."},{name:"painted",description:'The given element can be the target element for pointer events when the pointer is over a "painted" area. '},{name:"stroke",description:"The given element can be the target element for pointer events whenever the pointer is over the perimeter of the element."},{name:"visible",description:"The given element can be the target element for pointer events when the \u2018visibility\u2019 property is set to visible and the pointer is over either the interior or the perimeter of the element."},{name:"visibleFill",description:"The given element can be the target element for pointer events when the \u2018visibility\u2019 property is set to visible and when the pointer is over the interior of the element."},{name:"visiblePainted",description:"The given element can be the target element for pointer events when the \u2018visibility\u2019 property is set to visible and when the pointer is over a \u2018painted\u2019 area."},{name:"visibleStroke",description:"The given element can be the target element for pointer events when the \u2018visibility\u2019 property is set to visible and when the pointer is over the perimeter of the element."}],syntax:"auto | none | visiblePainted | visibleFill | visibleStroke | visible | painted | fill | stroke | all | inherit",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/pointer-events"}],description:"Specifies under what circumstances a given element can be the target element for a pointer event.",restrictions:["enum"]},{name:"position",values:[{name:"absolute",description:"The box's position (and possibly size) is specified with the 'top', 'right', 'bottom', and 'left' properties. These properties specify offsets with respect to the box's 'containing block'."},{name:"fixed",description:"The box's position is calculated according to the 'absolute' model, but in addition, the box is fixed with respect to some reference. As with the 'absolute' model, the box's margins do not collapse with any other margins."},{name:"-ms-page",description:"The box's position is calculated according to the 'absolute' model."},{name:"relative",description:"The box's position is calculated according to the normal flow (this is called the position in normal flow). Then the box is offset relative to its normal position."},{name:"static",description:"The box is a normal box, laid out according to the normal flow. The 'top', 'right', 'bottom', and 'left' properties do not apply."},{name:"sticky",description:"The box's position is calculated according to the normal flow. Then the box is offset relative to its flow root and containing block and in all cases, including table elements, does not affect the position of any following boxes."},{name:"-webkit-sticky",description:"The box's position is calculated according to the normal flow. Then the box is offset relative to its flow root and containing block and in all cases, including table elements, does not affect the position of any following boxes."}],syntax:"static | relative | absolute | sticky | fixed",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/position"}],description:"The position CSS property sets how an element is positioned in a document. The top, right, bottom, and left properties determine the final location of positioned elements.",restrictions:["enum"]},{name:"prefix",browsers:["FF33"],syntax:"<symbol>",relevance:50,description:"@counter-style descriptor. Specifies a <symbol> that is prepended to the marker representation.",restrictions:["image","string","identifier"]},{name:"quotes",values:[{name:"none",description:"The 'open-quote' and 'close-quote' values of the 'content' property produce no quotations marks, as if they were 'no-open-quote' and 'no-close-quote' respectively."}],syntax:"none | auto | [ <string> <string> ]+",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/quotes"}],description:"Specifies quotation marks for any number of embedded quotations.",restrictions:["string"]},{name:"range",browsers:["FF33"],values:[{name:"auto",description:"The range depends on the counter system."},{name:"infinite",description:"If used as the first value in a range, it represents negative infinity; if used as the second value, it represents positive infinity."}],syntax:"[ [ <integer> | infinite ]{2} ]# | auto",relevance:50,description:"@counter-style descriptor. Defines the ranges over which the counter style is defined.",restrictions:["integer","enum"]},{name:"resize",browsers:["E79","FF4","S3","C1","O12.1"],values:[{name:"both",description:"The UA presents a bidirectional resizing mechanism to allow the user to adjust both the height and the width of the element."},{name:"horizontal",description:"The UA presents a unidirectional horizontal resizing mechanism to allow the user to adjust only the width of the element."},{name:"none",description:"The UA does not present a resizing mechanism on the element, and the user is given no direct manipulation mechanism to resize the element."},{name:"vertical",description:"The UA presents a unidirectional vertical resizing mechanism to allow the user to adjust only the height of the element."}],syntax:"none | both | horizontal | vertical | block | inline",relevance:61,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/resize"}],description:"Specifies whether or not an element is resizable by the user, and if so, along which axis/axes.",restrictions:["enum"]},{name:"right",values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"}],syntax:"<length> | <percentage> | auto",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/right"}],description:"Specifies how far an absolutely positioned box's right margin edge is offset to the left of the right edge of the box's 'containing block'.",restrictions:["length","percentage"]},{name:"ruby-align",browsers:["FF38"],values:[{name:"auto",browsers:["FF38"],description:"The user agent determines how the ruby contents are aligned. This is the initial value."},{name:"center",description:"The ruby content is centered within its box."},{name:"distribute-letter",browsers:["FF38"],description:"If the width of the ruby text is smaller than that of the base, then the ruby text contents are evenly distributed across the width of the base, with the first and last ruby text glyphs lining up with the corresponding first and last base glyphs. If the width of the ruby text is at least the width of the base, then the letters of the base are evenly distributed across the width of the ruby text."},{name:"distribute-space",browsers:["FF38"],description:"If the width of the ruby text is smaller than that of the base, then the ruby text contents are evenly distributed across the width of the base, with a certain amount of white space preceding the first and following the last character in the ruby text. That amount of white space is normally equal to half the amount of inter-character space of the ruby text."},{name:"left",description:"The ruby text content is aligned with the start edge of the base."},{name:"line-edge",browsers:["FF38"],description:"If the ruby text is not adjacent to a line edge, it is aligned as in 'auto'. If it is adjacent to a line edge, then it is still aligned as in auto, but the side of the ruby text that touches the end of the line is lined up with the corresponding edge of the base."},{name:"right",browsers:["FF38"],description:"The ruby text content is aligned with the end edge of the base."},{name:"start",browsers:["FF38"],description:"The ruby text content is aligned with the start edge of the base."},{name:"space-between",browsers:["FF38"],description:"The ruby content expands as defined for normal text justification (as defined by 'text-justify'),"},{name:"space-around",browsers:["FF38"],description:"As for 'space-between' except that there exists an extra justification opportunities whose space is distributed half before and half after the ruby content."}],status:"experimental",syntax:"start | center | space-between | space-around",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/ruby-align"}],description:"Specifies how text is distributed within the various ruby boxes when their contents do not exactly fill their respective boxes.",restrictions:["enum"]},{name:"ruby-overhang",browsers:["FF10","IE5"],values:[{name:"auto",description:"The ruby text can overhang text adjacent to the base on either side. This is the initial value."},{name:"end",description:"The ruby text can overhang the text that follows it."},{name:"none",description:"The ruby text cannot overhang any text adjacent to its base, only its own base."},{name:"start",description:"The ruby text can overhang the text that precedes it."}],relevance:50,description:"Determines whether, and on which side, ruby text is allowed to partially overhang any adjacent text in addition to its own base, when the ruby text is wider than the ruby base.",restrictions:["enum"]},{name:"ruby-position",browsers:["E84","FF38","S7","C84","O70"],values:[{name:"after",description:"The ruby text appears after the base. This is a relatively rare setting used in ideographic East Asian writing systems, most easily found in educational text."},{name:"before",description:"The ruby text appears before the base. This is the most common setting used in ideographic East Asian writing systems."},{name:"inline"},{name:"right",description:"The ruby text appears on the right of the base. Unlike 'before' and 'after', this value is not relative to the text flow direction."}],status:"experimental",syntax:"[ alternate || [ over | under ] ] | inter-character",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/ruby-position"}],description:"Used by the parent of elements with display: ruby-text to control the position of the ruby text with respect to its base.",restrictions:["enum"]},{name:"ruby-span",browsers:["FF10"],values:[{name:"attr(x)",description:"The value of attribute 'x' is a string value. The string value is evaluated as a <number> to determine the number of ruby base elements to be spanned by the annotation element."},{name:"none",description:"No spanning. The computed value is '1'."}],relevance:50,description:"Determines whether, and on which side, ruby text is allowed to partially overhang any adjacent text in addition to its own base, when the ruby text is wider than the ruby base.",restrictions:["enum"]},{name:"scrollbar-3dlight-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-3dlight-color"}],description:"Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"scrollbar-arrow-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-arrow-color"}],description:"Determines the color of the arrow elements of a scroll arrow.",restrictions:["color"]},{name:"scrollbar-base-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-base-color"}],description:"Determines the color of the main elements of a scroll bar, which include the scroll box, track, and scroll arrows.",restrictions:["color"]},{name:"scrollbar-darkshadow-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-darkshadow-color"}],description:"Determines the color of the gutter of a scroll bar.",restrictions:["color"]},{name:"scrollbar-face-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-face-color"}],description:"Determines the color of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"scrollbar-highlight-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-highlight-color"}],description:"Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"scrollbar-shadow-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-shadow-color"}],description:"Determines the color of the bottom and right edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"scrollbar-track-color",browsers:["IE6"],relevance:50,description:"Determines the color of the track element of a scroll bar.",restrictions:["color"]},{name:"scroll-behavior",browsers:["E79","FF36","S15.4","C61","O48"],values:[{name:"auto",description:"Scrolls in an instant fashion."},{name:"smooth",description:"Scrolls in a smooth fashion using a user-agent-defined timing function and time period."}],syntax:"auto | smooth",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-behavior"}],description:"Specifies the scrolling behavior for a scrolling box, when scrolling happens due to navigation or CSSOM scrolling APIs.",restrictions:["enum"]},{name:"scroll-snap-coordinate",browsers:["FF39"],values:[{name:"none",description:"Specifies that this element does not contribute a snap point."}],status:"obsolete",syntax:"none | <position>#",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-coordinate"}],description:"Defines the x and y coordinate within the element which will align with the nearest ancestor scroll container\u2019s snap-destination for the respective axis.",restrictions:["position","length","percentage","enum"]},{name:"scroll-snap-destination",browsers:["FF39"],status:"obsolete",syntax:"<position>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-destination"}],description:"Define the x and y coordinate within the scroll container\u2019s visual viewport which element snap points will align with.",restrictions:["position","length","percentage"]},{name:"scroll-snap-points-x",browsers:["FF39","S9"],values:[{name:"none",description:"No snap points are defined by this scroll container."},{name:"repeat()",description:"Defines an interval at which snap points are defined, starting from the container\u2019s relevant start edge."}],status:"obsolete",syntax:"none | repeat( <length-percentage> )",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-points-x"}],description:"Defines the positioning of snap points along the x axis of the scroll container it is applied to.",restrictions:["enum"]},{name:"scroll-snap-points-y",browsers:["FF39","S9"],values:[{name:"none",description:"No snap points are defined by this scroll container."},{name:"repeat()",description:"Defines an interval at which snap points are defined, starting from the container\u2019s relevant start edge."}],status:"obsolete",syntax:"none | repeat( <length-percentage> )",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-points-y"}],description:"Defines the positioning of snap points along the y axis of the scroll container it is applied to.",restrictions:["enum"]},{name:"scroll-snap-type",values:[{name:"none",description:"The visual viewport of this scroll container must ignore snap points, if any, when scrolled."},{name:"mandatory",description:"The visual viewport of this scroll container is guaranteed to rest on a snap point when there are no active scrolling operations."},{name:"proximity",description:"The visual viewport of this scroll container may come to rest on a snap point at the termination of a scroll at the discretion of the UA given the parameters of the scroll."}],syntax:"none | [ x | y | block | inline | both ] [ mandatory | proximity ]?",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-type"}],description:"Defines how strictly snap points are enforced on the scroll container.",restrictions:["enum"]},{name:"shape-image-threshold",browsers:["E79","FF62","S10.1","C37","O24"],syntax:"<alpha-value>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/shape-image-threshold"}],description:"Defines the alpha channel threshold used to extract the shape using an image. A value of 0.5 means that the shape will enclose all the pixels that are more than 50% opaque.",restrictions:["number"]},{name:"shape-margin",browsers:["E79","FF62","S10.1","C37","O24"],syntax:"<length-percentage>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/shape-margin"}],description:"Adds a margin to a 'shape-outside'. This defines a new shape that is the smallest contour that includes all the points that are the 'shape-margin' distance outward in the perpendicular direction from a point on the underlying shape.",restrictions:["url","length","percentage"]},{name:"shape-outside",browsers:["E79","FF62","S10.1","C37","O24"],values:[{name:"margin-box",description:"The background is painted within (clipped to) the margin box."},{name:"none",description:"The float area is unaffected."}],syntax:"none | [ <shape-box> || <basic-shape> ] | <image>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/shape-outside"}],description:"Specifies an orthogonal rotation to be applied to an image before it is laid out.",restrictions:["image","box","shape","enum"]},{name:"shape-rendering",values:[{name:"auto",description:"Suppresses aural rendering."},{name:"crispEdges",description:"Emphasize the contrast between clean edges of artwork over rendering speed and geometric precision."},{name:"geometricPrecision",description:"Emphasize geometric precision over speed and crisp edges."},{name:"optimizeSpeed",description:"Emphasize rendering speed over geometric precision and crisp edges."}],relevance:50,description:"Provides hints about what tradeoffs to make as it renders vector graphics elements such as <path> elements and basic shapes such as circles and rectangles.",restrictions:["enum"]},{name:"size",browsers:["C","O8"],syntax:"<length>{1,2} | auto | [ <page-size> || [ portrait | landscape ] ]",relevance:53,description:"The size CSS at-rule descriptor, used with the @page at-rule, defines the size and orientation of the box which is used to represent a page. Most of the time, this size corresponds to the target size of the printed page if applicable.",restrictions:["length"]},{name:"src",values:[{name:"url()",description:"Reference font by URL"},{name:"format()",description:"Optional hint describing the format of the font resource."},{name:"local()",description:"Format-specific string that identifies a locally available copy of a given font."}],syntax:"[ <url> [ format( <string># ) ]? | local( <family-name> ) ]#",relevance:87,description:"@font-face descriptor. Specifies the resource containing font data. It is required, whether the font is downloadable or locally installed.",restrictions:["enum","url","identifier"]},{name:"stop-color",relevance:51,description:"Indicates what color to use at that gradient stop.",restrictions:["color"]},{name:"stop-opacity",relevance:50,description:"Defines the opacity of a given gradient stop.",restrictions:["number(0-1)"]},{name:"stroke",values:[{name:"url()",description:"A URL reference to a paint server element, which is an element that defines a paint server: \u2018hatch\u2019, \u2018linearGradient\u2019, \u2018mesh\u2019, \u2018pattern\u2019, \u2018radialGradient\u2019 and \u2018solidcolor\u2019."},{name:"none",description:"No paint is applied in this layer."}],relevance:65,description:"Paints along the outline of the given graphical element.",restrictions:["color","enum","url"]},{name:"stroke-dasharray",values:[{name:"none",description:"Indicates that no dashing is used."}],relevance:58,description:"Controls the pattern of dashes and gaps used to stroke paths.",restrictions:["length","percentage","number","enum"]},{name:"stroke-dashoffset",relevance:59,description:"Specifies the distance into the dash pattern to start the dash.",restrictions:["percentage","length"]},{name:"stroke-linecap",values:[{name:"butt",description:"Indicates that the stroke for each subpath does not extend beyond its two endpoints."},{name:"round",description:"Indicates that at each end of each subpath, the shape representing the stroke will be extended by a half circle with a radius equal to the stroke width."},{name:"square",description:"Indicates that at the end of each subpath, the shape representing the stroke will be extended by a rectangle with the same width as the stroke width and whose length is half of the stroke width."}],relevance:53,description:"Specifies the shape to be used at the end of open subpaths when they are stroked.",restrictions:["enum"]},{name:"stroke-linejoin",values:[{name:"bevel",description:"Indicates that a bevelled corner is to be used to join path segments."},{name:"miter",description:"Indicates that a sharp corner is to be used to join path segments."},{name:"round",description:"Indicates that a round corner is to be used to join path segments."}],relevance:50,description:"Specifies the shape to be used at the corners of paths or basic shapes when they are stroked.",restrictions:["enum"]},{name:"stroke-miterlimit",relevance:51,description:"When two line segments meet at a sharp angle and miter joins have been specified for 'stroke-linejoin', it is possible for the miter to extend far beyond the thickness of the line stroking the path.",restrictions:["number"]},{name:"stroke-opacity",relevance:52,description:"Specifies the opacity of the painting operation used to stroke the current object.",restrictions:["number(0-1)"]},{name:"stroke-width",relevance:61,description:"Specifies the width of the stroke on the current object.",restrictions:["percentage","length"]},{name:"suffix",browsers:["FF33"],syntax:"<symbol>",relevance:50,description:"@counter-style descriptor. Specifies a <symbol> that is appended to the marker representation.",restrictions:["image","string","identifier"]},{name:"system",browsers:["FF33"],values:[{name:"additive",description:"Represents \u201Csign-value\u201D numbering systems, which, rather than using reusing digits in different positions to change their value, define additional digits with much larger values, so that the value of the number can be obtained by adding all the digits together."},{name:"alphabetic",description:'Interprets the list of counter symbols as digits to an alphabetic numbering system, similar to the default lower-alpha counter style, which wraps from "a", "b", "c", to "aa", "ab", "ac".'},{name:"cyclic",description:"Cycles repeatedly through its provided symbols, looping back to the beginning when it reaches the end of the list."},{name:"extends",description:"Use the algorithm of another counter style, but alter other aspects."},{name:"fixed",description:"Runs through its list of counter symbols once, then falls back."},{name:"numeric",description:`interprets the list of counter symbols as digits to a "place-value" numbering system, similar to the default 'decimal' counter style.`},{name:"symbolic",description:"Cycles repeatedly through its provided symbols, doubling, tripling, etc. the symbols on each successive pass through the list."}],syntax:"cyclic | numeric | alphabetic | symbolic | additive | [ fixed <integer>? ] | [ extends <counter-style-name> ]",relevance:50,description:"@counter-style descriptor. Specifies which algorithm will be used to construct the counter\u2019s representation based on the counter value.",restrictions:["enum","integer"]},{name:"symbols",browsers:["FF33"],syntax:"<symbol>+",relevance:50,description:"@counter-style descriptor. Specifies the symbols used by the marker-construction algorithm specified by the system descriptor.",restrictions:["image","string","identifier"]},{name:"table-layout",values:[{name:"auto",description:"Use any automatic table layout algorithm."},{name:"fixed",description:"Use the fixed table layout algorithm."}],syntax:"auto | fixed",relevance:60,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/table-layout"}],description:"Controls the algorithm used to lay out the table cells, rows, and columns.",restrictions:["enum"]},{name:"tab-size",browsers:["E79","FF91","S7","C21","O15"],syntax:"<integer> | <length>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/tab-size"}],description:"Determines the width of the tab character (U+0009), in space characters (U+0020), when rendered.",restrictions:["integer","length"]},{name:"text-align",values:[{name:"center",description:"The inline contents are centered within the line box."},{name:"end",description:"The inline contents are aligned to the end edge of the line box."},{name:"justify",description:"The text is justified according to the method specified by the 'text-justify' property."},{name:"left",description:"The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."},{name:"right",description:"The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."},{name:"start",description:"The inline contents are aligned to the start edge of the line box."}],syntax:"start | end | left | right | center | justify | match-parent",relevance:94,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-align"}],description:"Describes how inline contents of a block are horizontally aligned if the contents do not completely fill the line box.",restrictions:["string"]},{name:"text-align-last",browsers:["E12","FF49","C47","IE5.5","O34"],values:[{name:"auto",description:"Content on the affected line is aligned per 'text-align' unless 'text-align' is set to 'justify', in which case it is 'start-aligned'."},{name:"center",description:"The inline contents are centered within the line box."},{name:"justify",description:"The text is justified according to the method specified by the 'text-justify' property."},{name:"left",description:"The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."},{name:"right",description:"The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."}],syntax:"auto | start | end | left | right | center | justify",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-align-last"}],description:"Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",restrictions:["enum"]},{name:"text-anchor",values:[{name:"end",description:"The rendered characters are aligned such that the end of the resulting rendered text is at the initial current text position."},{name:"middle",description:"The rendered characters are aligned such that the geometric middle of the resulting rendered text is at the initial current text position."},{name:"start",description:"The rendered characters are aligned such that the start of the resulting rendered text is at the initial current text position."}],relevance:50,description:"Used to align (start-, middle- or end-alignment) a string of text relative to a given point.",restrictions:["enum"]},{name:"text-decoration",values:[{name:"dashed",description:"Produces a dashed line style."},{name:"dotted",description:"Produces a dotted line."},{name:"double",description:"Produces a double line."},{name:"line-through",description:"Each line of text has a line through the middle."},{name:"none",description:"Produces no line."},{name:"overline",description:"Each line of text has a line above it."},{name:"solid",description:"Produces a solid line."},{name:"underline",description:"Each line of text is underlined."},{name:"wavy",description:"Produces a wavy line."}],syntax:"<'text-decoration-line'> || <'text-decoration-style'> || <'text-decoration-color'> || <'text-decoration-thickness'>",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration"}],description:"Decorations applied to font used for an element's text.",restrictions:["enum","color"]},{name:"text-decoration-color",browsers:["E79","FF36","S12.1","C57","O44"],syntax:"<color>",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-color"}],description:"Specifies the color of text decoration (underlines overlines, and line-throughs) set on the element with text-decoration-line.",restrictions:["color"]},{name:"text-decoration-line",browsers:["E79","FF36","S12.1","C57","O44"],values:[{name:"line-through",description:"Each line of text has a line through the middle."},{name:"none",description:"Neither produces nor inhibits text decoration."},{name:"overline",description:"Each line of text has a line above it."},{name:"underline",description:"Each line of text is underlined."}],syntax:"none | [ underline || overline || line-through || blink ] | spelling-error | grammar-error",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-line"}],description:"Specifies what line decorations, if any, are added to the element.",restrictions:["enum"]},{name:"text-decoration-style",browsers:["E79","FF36","S12.1","C57","O44"],values:[{name:"dashed",description:"Produces a dashed line style."},{name:"dotted",description:"Produces a dotted line."},{name:"double",description:"Produces a double line."},{name:"none",description:"Produces no line."},{name:"solid",description:"Produces a solid line."},{name:"wavy",description:"Produces a wavy line."}],syntax:"solid | double | dotted | dashed | wavy",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-style"}],description:"Specifies the line style for underline, line-through and overline text decoration.",restrictions:["enum"]},{name:"text-indent",values:[],syntax:"<length-percentage> && hanging? && each-line?",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-indent"}],description:"Specifies the indentation applied to lines of inline content in a block. The indentation only affects the first line of inline content in the block unless the 'hanging' keyword is specified, in which case it affects all lines except the first.",restrictions:["percentage","length"]},{name:"text-justify",browsers:["E12","FF55","C32","IE11","O19"],values:[{name:"auto",description:"The UA determines the justification algorithm to follow, based on a balance between performance and adequate presentation quality."},{name:"distribute",description:"Justification primarily changes spacing both at word separators and at grapheme cluster boundaries in all scripts except those in the connected and cursive groups. This value is sometimes used in e.g. Japanese, often with the 'text-align-last' property."},{name:"distribute-all-lines"},{name:"inter-cluster",description:"Justification primarily changes spacing at word separators and at grapheme cluster boundaries in clustered scripts. This value is typically used for Southeast Asian scripts such as Thai."},{name:"inter-ideograph",description:"Justification primarily changes spacing at word separators and at inter-graphemic boundaries in scripts that use no word spaces. This value is typically used for CJK languages."},{name:"inter-word",description:"Justification primarily changes spacing at word separators. This value is typically used for languages that separate words using spaces, like English or (sometimes) Korean."},{name:"kashida",description:"Justification primarily stretches Arabic and related scripts through the use of kashida or other calligraphic elongation."},{name:"newspaper"}],syntax:"auto | inter-character | inter-word | none",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-justify"}],description:"Selects the justification algorithm used when 'text-align' is set to 'justify'. The property applies to block containers, but the UA may (but is not required to) also support it on inline elements.",restrictions:["enum"]},{name:"text-orientation",browsers:["E79","FF41","S14","C48","O35"],values:[{name:"sideways",browsers:["E79","FF41","S14","C48","O35"],description:"This value is equivalent to 'sideways-right' in 'vertical-rl' writing mode and equivalent to 'sideways-left' in 'vertical-lr' writing mode."},{name:"sideways-right",browsers:["E79","FF41","S14","C48","O35"],description:"In vertical writing modes, this causes text to be set as if in a horizontal layout, but rotated 90\xB0 clockwise."},{name:"upright",description:"In vertical writing modes, characters from horizontal-only scripts are rendered upright, i.e. in their standard horizontal orientation."}],syntax:"mixed | upright | sideways",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-orientation"}],description:"Specifies the orientation of text within a line.",restrictions:["enum"]},{name:"text-overflow",values:[{name:"clip",description:"Clip inline content that overflows. Characters may be only partially rendered."},{name:"ellipsis",description:"Render an ellipsis character (U+2026) to represent clipped inline content."}],syntax:"[ clip | ellipsis | <string> ]{1,2}",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-overflow"}],description:"Text can overflow for example when it is prevented from wrapping.",restrictions:["enum","string"]},{name:"text-rendering",browsers:["E79","FF1","S5","C4","O15"],values:[{name:"auto"},{name:"geometricPrecision",description:"Indicates that the user agent shall emphasize geometric precision over legibility and rendering speed."},{name:"optimizeLegibility",description:"Indicates that the user agent shall emphasize legibility over rendering speed and geometric precision."},{name:"optimizeSpeed",description:"Indicates that the user agent shall emphasize rendering speed over legibility and geometric precision."}],syntax:"auto | optimizeSpeed | optimizeLegibility | geometricPrecision",relevance:70,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-rendering"}],description:"The creator of SVG content might want to provide a hint to the implementation about what tradeoffs to make as it renders text. The \u2018text-rendering\u2019 property provides these hints.",restrictions:["enum"]},{name:"text-shadow",values:[{name:"none",description:"No shadow."}],syntax:"none | <shadow-t>#",relevance:74,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-shadow"}],description:"Enables shadow effects to be applied to the text of the element.",restrictions:["length","color"]},{name:"text-transform",values:[{name:"capitalize",description:"Puts the first typographic letter unit of each word in titlecase."},{name:"lowercase",description:"Puts all letters in lowercase."},{name:"none",description:"No effects."},{name:"uppercase",description:"Puts all letters in uppercase."}],syntax:"none | capitalize | uppercase | lowercase | full-width | full-size-kana",relevance:86,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-transform"}],description:"Controls capitalization effects of an element\u2019s text.",restrictions:["enum"]},{name:"text-underline-position",values:[{name:"above"},{name:"auto",description:"The user agent may use any algorithm to determine the underline\u2019s position. In horizontal line layout, the underline should be aligned as for alphabetic. In vertical line layout, if the language is set to Japanese or Korean, the underline should be aligned as for over."},{name:"below",description:"The underline is aligned with the under edge of the element\u2019s content box."}],syntax:"auto | from-font | [ under || [ left | right ] ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-underline-position"}],description:"Sets the position of an underline specified on the same element: it does not affect underlines specified by ancestor elements. This property is typically used in vertical writing contexts such as in Japanese documents where it often desired to have the underline appear 'over' (to the right of) the affected run of text",restrictions:["enum"]},{name:"top",values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"}],syntax:"<length> | <percentage> | auto",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/top"}],description:"Specifies how far an absolutely positioned box's top margin edge is offset below the top edge of the box's 'containing block'.",restrictions:["length","percentage"]},{name:"touch-action",values:[{name:"auto",description:"The user agent may determine any permitted touch behaviors for touches that begin on the element."},{name:"cross-slide-x"},{name:"cross-slide-y"},{name:"double-tap-zoom"},{name:"manipulation",description:"The user agent may consider touches that begin on the element only for the purposes of scrolling and continuous zooming."},{name:"none",description:"Touches that begin on the element must not trigger default touch behaviors."},{name:"pan-x",description:"The user agent may consider touches that begin on the element only for the purposes of horizontally scrolling the element\u2019s nearest ancestor with horizontally scrollable content."},{name:"pan-y",description:"The user agent may consider touches that begin on the element only for the purposes of vertically scrolling the element\u2019s nearest ancestor with vertically scrollable content."},{name:"pinch-zoom"}],syntax:"auto | none | [ [ pan-x | pan-left | pan-right ] || [ pan-y | pan-up | pan-down ] || pinch-zoom ] | manipulation",relevance:67,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/touch-action"}],description:"Determines whether touch input may trigger default behavior supplied by user agent.",restrictions:["enum"]},{name:"transform",values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"perspective()",description:"Specifies a perspective projection matrix."},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],syntax:"none | <transform-list>",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transform"}],description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"transform-origin",syntax:"[ <length-percentage> | left | center | right | top | bottom ] | [ [ <length-percentage> | left | center | right ] && [ <length-percentage> | top | center | bottom ] ] <length>?",relevance:77,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transform-origin"}],description:"Establishes the origin of transformation for an element.",restrictions:["position","length","percentage"]},{name:"transform-style",browsers:["E12","FF16","S9","C36","O23"],values:[{name:"flat",description:"All children of this element are rendered flattened into the 2D plane of the element."},{name:"preserve-3d",browsers:["E12","FF16","S9","C36","O23"],description:"Flattening is not performed, so children maintain their position in 3D space."}],syntax:"flat | preserve-3d",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transform-style"}],description:"Defines how nested elements are rendered in 3D space.",restrictions:["enum"]},{name:"transition",values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],syntax:"<single-transition>#",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition"}],description:"Shorthand property combines four of the transition properties into a single property.",restrictions:["time","property","timing-function","enum"]},{name:"transition-delay",syntax:"<time>#",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition-delay"}],description:"Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",restrictions:["time"]},{name:"transition-duration",syntax:"<time>#",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition-duration"}],description:"Specifies how long the transition from the old value to the new value should take.",restrictions:["time"]},{name:"transition-property",values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],syntax:"none | <single-transition-property>#",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition-property"}],description:"Specifies the name of the CSS property to which the transition is applied.",restrictions:["property"]},{name:"transition-timing-function",syntax:"<easing-function>#",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition-timing-function"}],description:"Describes how the intermediate values used during a transition will be calculated.",restrictions:["timing-function"]},{name:"unicode-bidi",values:[{name:"bidi-override",description:"Inside the element, reordering is strictly in sequence according to the 'direction' property; the implicit part of the bidirectional algorithm is ignored."},{name:"embed",description:"If the element is inline-level, this value opens an additional level of embedding with respect to the bidirectional algorithm. The direction of this embedding level is given by the 'direction' property."},{name:"isolate",description:"The contents of the element are considered to be inside a separate, independent paragraph."},{name:"isolate-override",description:"This combines the isolation behavior of 'isolate' with the directional override behavior of 'bidi-override'"},{name:"normal",description:"The element does not open an additional level of embedding with respect to the bidirectional algorithm. For inline-level elements, implicit reordering works across element boundaries."},{name:"plaintext",description:"For the purposes of the Unicode bidirectional algorithm, the base directionality of each bidi paragraph for which the element forms the containing block is determined not by the element's computed 'direction'."}],syntax:"normal | embed | isolate | bidi-override | isolate-override | plaintext",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/unicode-bidi"}],description:"The level of embedding with respect to the bidirectional algorithm.",restrictions:["enum"]},{name:"unicode-range",values:[{name:"U+26",description:"Ampersand."},{name:"U+20-24F, U+2B0-2FF, U+370-4FF, U+1E00-1EFF, U+2000-20CF, U+2100-23FF, U+2500-26FF, U+E000-F8FF, U+FB00\u2013FB4F",description:"WGL4 character set (Pan-European)."},{name:"U+20-17F, U+2B0-2FF, U+2000-206F, U+20A0-20CF, U+2100-21FF, U+2600-26FF",description:"The Multilingual European Subset No. 1. Latin. Covers ~44 languages."},{name:"U+20-2FF, U+370-4FF, U+1E00-20CF, U+2100-23FF, U+2500-26FF, U+FB00-FB4F, U+FFF0-FFFD",description:"The Multilingual European Subset No. 2. Latin, Greek, and Cyrillic. Covers ~128 language."},{name:"U+20-4FF, U+530-58F, U+10D0-10FF, U+1E00-23FF, U+2440-245F, U+2500-26FF, U+FB00-FB4F, U+FE20-FE2F, U+FFF0-FFFD",description:"The Multilingual European Subset No. 3. Covers all characters belonging to European scripts."},{name:"U+00-7F",description:"Basic Latin (ASCII)."},{name:"U+80-FF",description:"Latin-1 Supplement. Accented characters for Western European languages, common punctuation characters, multiplication and division signs."},{name:"U+100-17F",description:"Latin Extended-A. Accented characters for for Czech, Dutch, Polish, and Turkish."},{name:"U+180-24F",description:"Latin Extended-B. Croatian, Slovenian, Romanian, Non-European and historic latin, Khoisan, Pinyin, Livonian, Sinology."},{name:"U+1E00-1EFF",description:"Latin Extended Additional. Vietnamese, German captial sharp s, Medievalist, Latin general use."},{name:"U+250-2AF",description:"International Phonetic Alphabet Extensions."},{name:"U+370-3FF",description:"Greek and Coptic."},{name:"U+1F00-1FFF",description:"Greek Extended. Accented characters for polytonic Greek."},{name:"U+400-4FF",description:"Cyrillic."},{name:"U+500-52F",description:"Cyrillic Supplement. Extra letters for Komi, Khanty, Chukchi, Mordvin, Kurdish, Aleut, Chuvash, Abkhaz, Azerbaijani, and Orok."},{name:"U+00-52F, U+1E00-1FFF, U+2200\u201322FF",description:"Latin, Greek, Cyrillic, some punctuation and symbols."},{name:"U+530\u201358F",description:"Armenian."},{name:"U+590\u20135FF",description:"Hebrew."},{name:"U+600\u20136FF",description:"Arabic."},{name:"U+750\u201377F",description:"Arabic Supplement. Additional letters for African languages, Khowar, Torwali, Burushaski, and early Persian."},{name:"U+8A0\u20138FF",description:"Arabic Extended-A. Additional letters for African languages, European and Central Asian languages, Rohingya, Tamazight, Arwi, and Koranic annotation signs."},{name:"U+700\u201374F",description:"Syriac."},{name:"U+900\u201397F",description:"Devanagari."},{name:"U+980\u20139FF",description:"Bengali."},{name:"U+A00\u2013A7F",description:"Gurmukhi."},{name:"U+A80\u2013AFF",description:"Gujarati."},{name:"U+B00\u2013B7F",description:"Oriya."},{name:"U+B80\u2013BFF",description:"Tamil."},{name:"U+C00\u2013C7F",description:"Telugu."},{name:"U+C80\u2013CFF",description:"Kannada."},{name:"U+D00\u2013D7F",description:"Malayalam."},{name:"U+D80\u2013DFF",description:"Sinhala."},{name:"U+118A0\u2013118FF",description:"Warang Citi."},{name:"U+E00\u2013E7F",description:"Thai."},{name:"U+1A20\u20131AAF",description:"Tai Tham."},{name:"U+AA80\u2013AADF",description:"Tai Viet."},{name:"U+E80\u2013EFF",description:"Lao."},{name:"U+F00\u2013FFF",description:"Tibetan."},{name:"U+1000\u2013109F",description:"Myanmar (Burmese)."},{name:"U+10A0\u201310FF",description:"Georgian."},{name:"U+1200\u2013137F",description:"Ethiopic."},{name:"U+1380\u2013139F",description:"Ethiopic Supplement. Extra Syllables for Sebatbeit, and Tonal marks"},{name:"U+2D80\u20132DDF",description:"Ethiopic Extended. Extra Syllables for Me'en, Blin, and Sebatbeit."},{name:"U+AB00\u2013AB2F",description:"Ethiopic Extended-A. Extra characters for Gamo-Gofa-Dawro, Basketo, and Gumuz."},{name:"U+1780\u201317FF",description:"Khmer."},{name:"U+1800\u201318AF",description:"Mongolian."},{name:"U+1B80\u20131BBF",description:"Sundanese."},{name:"U+1CC0\u20131CCF",description:"Sundanese Supplement. Punctuation."},{name:"U+4E00\u20139FD5",description:"CJK (Chinese, Japanese, Korean) Unified Ideographs. Most common ideographs for modern Chinese and Japanese."},{name:"U+3400\u20134DB5",description:"CJK Unified Ideographs Extension A. Rare ideographs."},{name:"U+2F00\u20132FDF",description:"Kangxi Radicals."},{name:"U+2E80\u20132EFF",description:"CJK Radicals Supplement. Alternative forms of Kangxi Radicals."},{name:"U+1100\u201311FF",description:"Hangul Jamo."},{name:"U+AC00\u2013D7AF",description:"Hangul Syllables."},{name:"U+3040\u2013309F",description:"Hiragana."},{name:"U+30A0\u201330FF",description:"Katakana."},{name:"U+A5, U+4E00-9FFF, U+30??, U+FF00-FF9F",description:"Japanese Kanji, Hiragana and Katakana characters plus Yen/Yuan symbol."},{name:"U+A4D0\u2013A4FF",description:"Lisu."},{name:"U+A000\u2013A48F",description:"Yi Syllables."},{name:"U+A490\u2013A4CF",description:"Yi Radicals."},{name:"U+2000-206F",description:"General Punctuation."},{name:"U+3000\u2013303F",description:"CJK Symbols and Punctuation."},{name:"U+2070\u2013209F",description:"Superscripts and Subscripts."},{name:"U+20A0\u201320CF",description:"Currency Symbols."},{name:"U+2100\u2013214F",description:"Letterlike Symbols."},{name:"U+2150\u2013218F",description:"Number Forms."},{name:"U+2190\u201321FF",description:"Arrows."},{name:"U+2200\u201322FF",description:"Mathematical Operators."},{name:"U+2300\u201323FF",description:"Miscellaneous Technical."},{name:"U+E000-F8FF",description:"Private Use Area."},{name:"U+FB00\u2013FB4F",description:"Alphabetic Presentation Forms. Ligatures for latin, Armenian, and Hebrew."},{name:"U+FB50\u2013FDFF",description:"Arabic Presentation Forms-A. Contextual forms / ligatures for Persian, Urdu, Sindhi, Central Asian languages, etc, Arabic pedagogical symbols, word ligatures."},{name:"U+1F600\u20131F64F",description:"Emoji: Emoticons."},{name:"U+2600\u201326FF",description:"Emoji: Miscellaneous Symbols."},{name:"U+1F300\u20131F5FF",description:"Emoji: Miscellaneous Symbols and Pictographs."},{name:"U+1F900\u20131F9FF",description:"Emoji: Supplemental Symbols and Pictographs."},{name:"U+1F680\u20131F6FF",description:"Emoji: Transport and Map Symbols."}],syntax:"<unicode-range>#",relevance:73,description:"@font-face descriptor. Defines the set of Unicode codepoints that may be supported by the font face for which it is declared.",restrictions:["unicode-range"]},{name:"user-select",values:[{name:"all",description:"The content of the element must be selected atomically"},{name:"auto"},{name:"contain",description:"UAs must not allow a selection which is started in this element to be extended outside of this element."},{name:"none",description:"The UA must not allow selections to be started in this element."},{name:"text",description:"The element imposes no constraint on the selection."}],syntax:"auto | text | none | contain | all",relevance:78,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/user-select"}],description:"Controls the appearance of selection.",restrictions:["enum"]},{name:"vertical-align",values:[{name:"auto",description:"Align the dominant baseline of the parent box with the equivalent, or heuristically reconstructed, baseline of the element inline box."},{name:"baseline",description:"Align the 'alphabetic' baseline of the element with the 'alphabetic' baseline of the parent element."},{name:"bottom",description:"Align the after edge of the extended inline box with the after-edge of the line box."},{name:"middle",description:"Align the 'middle' baseline of the inline element with the middle baseline of the parent."},{name:"sub",description:"Lower the baseline of the box to the proper position for subscripts of the parent's box. (This value has no effect on the font size of the element's text.)"},{name:"super",description:"Raise the baseline of the box to the proper position for superscripts of the parent's box. (This value has no effect on the font size of the element's text.)"},{name:"text-bottom",description:"Align the bottom of the box with the after-edge of the parent element's font."},{name:"text-top",description:"Align the top of the box with the before-edge of the parent element's font."},{name:"top",description:"Align the before edge of the extended inline box with the before-edge of the line box."},{name:"-webkit-baseline-middle"}],syntax:"baseline | sub | super | text-top | text-bottom | middle | top | bottom | <percentage> | <length>",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/vertical-align"}],description:"Affects the vertical positioning of the inline boxes generated by an inline-level element inside a line box.",restrictions:["percentage","length"]},{name:"visibility",values:[{name:"collapse",description:"Table-specific. If used on elements other than rows, row groups, columns, or column groups, 'collapse' has the same meaning as 'hidden'."},{name:"hidden",description:"The generated box is invisible (fully transparent, nothing is drawn), but still affects layout."},{name:"visible",description:"The generated box is visible."}],syntax:"visible | hidden | collapse",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/visibility"}],description:"Specifies whether the boxes generated by an element are rendered. Invisible boxes still affect layout (set the \u2018display\u2019 property to \u2018none\u2019 to suppress box generation altogether).",restrictions:["enum"]},{name:"-webkit-animation",browsers:["C","S5"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"infinite",description:"Causes the animation to repeat forever."},{name:"none",description:"No animation is performed"},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Shorthand property combines six of the animation properties into a single property.",restrictions:["time","enum","timing-function","identifier","number"]},{name:"-webkit-animation-delay",browsers:["C","S5"],relevance:50,description:"Defines when the animation will start.",restrictions:["time"]},{name:"-webkit-animation-direction",browsers:["C","S5"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Defines whether or not the animation should play in reverse on alternate cycles.",restrictions:["enum"]},{name:"-webkit-animation-duration",browsers:["C","S5"],relevance:50,description:"Defines the length of time that an animation takes to complete one cycle.",restrictions:["time"]},{name:"-webkit-animation-fill-mode",browsers:["C","S5"],values:[{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"none",description:"There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."}],relevance:50,description:"Defines what values are applied by the animation outside the time it is executing.",restrictions:["enum"]},{name:"-webkit-animation-iteration-count",browsers:["C","S5"],values:[{name:"infinite",description:"Causes the animation to repeat forever."}],relevance:50,description:"Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",restrictions:["number","enum"]},{name:"-webkit-animation-name",browsers:["C","S5"],values:[{name:"none",description:"No animation is performed"}],relevance:50,description:"Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",restrictions:["identifier","enum"]},{name:"-webkit-animation-play-state",browsers:["C","S5"],values:[{name:"paused",description:"A running animation will be paused."},{name:"running",description:"Resume playback of a paused animation."}],relevance:50,description:"Defines whether the animation is running or paused.",restrictions:["enum"]},{name:"-webkit-animation-timing-function",browsers:["C","S5"],relevance:50,description:"Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",restrictions:["timing-function"]},{name:"-webkit-appearance",browsers:["C","S3"],values:[{name:"button"},{name:"button-bevel"},{name:"caps-lock-indicator"},{name:"caret"},{name:"checkbox"},{name:"default-button"},{name:"listbox"},{name:"listitem"},{name:"media-fullscreen-button"},{name:"media-mute-button"},{name:"media-play-button"},{name:"media-seek-back-button"},{name:"media-seek-forward-button"},{name:"media-slider"},{name:"media-sliderthumb"},{name:"menulist"},{name:"menulist-button"},{name:"menulist-text"},{name:"menulist-textfield"},{name:"none"},{name:"push-button"},{name:"radio"},{name:"scrollbarbutton-down"},{name:"scrollbarbutton-left"},{name:"scrollbarbutton-right"},{name:"scrollbarbutton-up"},{name:"scrollbargripper-horizontal"},{name:"scrollbargripper-vertical"},{name:"scrollbarthumb-horizontal"},{name:"scrollbarthumb-vertical"},{name:"scrollbartrack-horizontal"},{name:"scrollbartrack-vertical"},{name:"searchfield"},{name:"searchfield-cancel-button"},{name:"searchfield-decoration"},{name:"searchfield-results-button"},{name:"searchfield-results-decoration"},{name:"slider-horizontal"},{name:"sliderthumb-horizontal"},{name:"sliderthumb-vertical"},{name:"slider-vertical"},{name:"square-button"},{name:"textarea"},{name:"textfield"}],status:"nonstandard",syntax:"none | button | button-bevel | caret | checkbox | default-button | inner-spin-button | listbox | listitem | media-controls-background | media-controls-fullscreen-background | media-current-time-display | media-enter-fullscreen-button | media-exit-fullscreen-button | media-fullscreen-button | media-mute-button | media-overlay-play-button | media-play-button | media-seek-back-button | media-seek-forward-button | media-slider | media-sliderthumb | media-time-remaining-display | media-toggle-closed-captions-button | media-volume-slider | media-volume-slider-container | media-volume-sliderthumb | menulist | menulist-button | menulist-text | menulist-textfield | meter | progress-bar | progress-bar-value | push-button | radio | searchfield | searchfield-cancel-button | searchfield-decoration | searchfield-results-button | searchfield-results-decoration | slider-horizontal | slider-vertical | sliderthumb-horizontal | sliderthumb-vertical | square-button | textarea | textfield | -apple-pay-button",relevance:0,description:"Changes the appearance of buttons and other controls to resemble native controls.",restrictions:["enum"]},{name:"-webkit-backdrop-filter",browsers:["S9"],values:[{name:"none",description:"No filter effects are applied."},{name:"blur()",description:"Applies a Gaussian blur to the input image."},{name:"brightness()",description:"Applies a linear multiplier to input image, making it appear more or less bright."},{name:"contrast()",description:"Adjusts the contrast of the input."},{name:"drop-shadow()",description:"Applies a drop shadow effect to the input image."},{name:"grayscale()",description:"Converts the input image to grayscale."},{name:"hue-rotate()",description:"Applies a hue rotation on the input image. "},{name:"invert()",description:"Inverts the samples in the input image."},{name:"opacity()",description:"Applies transparency to the samples in the input image."},{name:"saturate()",description:"Saturates the input image."},{name:"sepia()",description:"Converts the input image to sepia."},{name:"url()",description:"A filter reference to a <filter> element."}],relevance:50,description:"Applies a filter effect where the first filter in the list takes the element's background image as the input image.",restrictions:["enum","url"]},{name:"-webkit-backface-visibility",browsers:["C","S5"],values:[{name:"hidden"},{name:"visible"}],relevance:50,description:"Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",restrictions:["enum"]},{name:"-webkit-background-clip",browsers:["C","S3"],relevance:50,description:"Determines the background painting area.",restrictions:["box"]},{name:"-webkit-background-composite",browsers:["C","S3"],values:[{name:"border"},{name:"padding"}],relevance:50,restrictions:["enum"]},{name:"-webkit-background-origin",browsers:["C","S3"],relevance:50,description:"For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",restrictions:["box"]},{name:"-webkit-border-image",browsers:["C","S5"],values:[{name:"auto",description:"If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."},{name:"fill",description:"Causes the middle part of the border-image to be preserved."},{name:"none"},{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."},{name:"url()"}],relevance:50,description:"Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",restrictions:["length","percentage","number","url","enum"]},{name:"-webkit-box-align",browsers:["C","S3"],values:[{name:"baseline",description:"If this box orientation is inline-axis or horizontal, all children are placed with their baselines aligned, and extra space placed before or after as necessary. For block flows, the baseline of the first non-empty line box located within the element is used. For tables, the baseline of the first cell is used."},{name:"center",description:"Any extra space is divided evenly, with half placed above the child and the other half placed after the child."},{name:"end",description:"For normal direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element. For reverse direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element."},{name:"start",description:"For normal direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element. For reverse direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element."},{name:"stretch",description:"The height of each child is adjusted to that of the containing block."}],relevance:50,description:"Specifies the alignment of nested elements within an outer flexible box element.",restrictions:["enum"]},{name:"-webkit-box-direction",browsers:["C","S3"],values:[{name:"normal",description:"A box with a computed value of horizontal for box-orient displays its children from left to right. A box with a computed value of vertical displays its children from top to bottom."},{name:"reverse",description:"A box with a computed value of horizontal for box-orient displays its children from right to left. A box with a computed value of vertical displays its children from bottom to top."}],relevance:50,description:"In webkit applications, -webkit-box-direction specifies whether a box lays out its contents normally (from the top or left edge), or in reverse (from the bottom or right edge).",restrictions:["enum"]},{name:"-webkit-box-flex",browsers:["C","S3"],relevance:50,description:"Specifies an element's flexibility.",restrictions:["number"]},{name:"-webkit-box-flex-group",browsers:["C","S3"],relevance:50,description:"Flexible elements can be assigned to flex groups using the 'box-flex-group' property.",restrictions:["integer"]},{name:"-webkit-box-ordinal-group",browsers:["C","S3"],relevance:50,description:"Indicates the ordinal group the element belongs to. Elements with a lower ordinal group are displayed before those with a higher ordinal group.",restrictions:["integer"]},{name:"-webkit-box-orient",browsers:["C","S3"],values:[{name:"block-axis",description:"Elements are oriented along the box's axis."},{name:"horizontal",description:"The box displays its children from left to right in a horizontal line."},{name:"inline-axis",description:"Elements are oriented vertically."},{name:"vertical",description:"The box displays its children from stacked from top to bottom vertically."}],relevance:50,description:"In webkit applications, -webkit-box-orient specifies whether a box lays out its contents horizontally or vertically.",restrictions:["enum"]},{name:"-webkit-box-pack",browsers:["C","S3"],values:[{name:"center",description:"The extra space is divided evenly, with half placed before the first child and the other half placed after the last child."},{name:"end",description:"For normal direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child. For reverse direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child."},{name:"justify",description:"The space is divided evenly in-between each child, with none of the extra space placed before the first child or after the last child. If there is only one child, treat the pack value as if it were start."},{name:"start",description:"For normal direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child. For reverse direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child."}],relevance:50,description:"Specifies alignment of child elements within the current element in the direction of orientation.",restrictions:["enum"]},{name:"-webkit-box-reflect",browsers:["E79","S4","C4","O15"],values:[{name:"above",description:"The reflection appears above the border box."},{name:"below",description:"The reflection appears below the border box."},{name:"left",description:"The reflection appears to the left of the border box."},{name:"right",description:"The reflection appears to the right of the border box."}],status:"nonstandard",syntax:"[ above | below | right | left ]? <length>? <image>?",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-box-reflect"}],description:"Defines a reflection of a border box."},{name:"-webkit-box-sizing",browsers:["C","S3"],values:[{name:"border-box",description:"The specified width and height (and respective min/max properties) on this element determine the border box of the element."},{name:"content-box",description:"Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."}],relevance:50,description:"Box Model addition in CSS3.",restrictions:["enum"]},{name:"-webkit-break-after",browsers:["S7"],values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the generated box."},{name:"avoid",description:"Avoid a page/column break before/after the generated box."},{name:"avoid-column",description:"Avoid a column break before/after the generated box."},{name:"avoid-page",description:"Avoid a page break before/after the generated box."},{name:"avoid-region"},{name:"column",description:"Always force a column break before/after the generated box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the generated box."},{name:"region"},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],relevance:50,description:"Describes the page/column break behavior before the generated box.",restrictions:["enum"]},{name:"-webkit-break-before",browsers:["S7"],values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the generated box."},{name:"avoid",description:"Avoid a page/column break before/after the generated box."},{name:"avoid-column",description:"Avoid a column break before/after the generated box."},{name:"avoid-page",description:"Avoid a page break before/after the generated box."},{name:"avoid-region"},{name:"column",description:"Always force a column break before/after the generated box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the generated box."},{name:"region"},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],relevance:50,description:"Describes the page/column break behavior before the generated box.",restrictions:["enum"]},{name:"-webkit-break-inside",browsers:["S7"],values:[{name:"auto",description:"Neither force nor forbid a page/column break inside the generated box."},{name:"avoid",description:"Avoid a page/column break inside the generated box."},{name:"avoid-column",description:"Avoid a column break inside the generated box."},{name:"avoid-page",description:"Avoid a page break inside the generated box."},{name:"avoid-region"}],relevance:50,description:"Describes the page/column break behavior inside the generated box.",restrictions:["enum"]},{name:"-webkit-column-break-after",browsers:["C","S3"],values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the generated box."},{name:"avoid",description:"Avoid a page/column break before/after the generated box."},{name:"avoid-column",description:"Avoid a column break before/after the generated box."},{name:"avoid-page",description:"Avoid a page break before/after the generated box."},{name:"avoid-region"},{name:"column",description:"Always force a column break before/after the generated box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the generated box."},{name:"region"},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],relevance:50,description:"Describes the page/column break behavior before the generated box.",restrictions:["enum"]},{name:"-webkit-column-break-before",browsers:["C","S3"],values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the generated box."},{name:"avoid",description:"Avoid a page/column break before/after the generated box."},{name:"avoid-column",description:"Avoid a column break before/after the generated box."},{name:"avoid-page",description:"Avoid a page break before/after the generated box."},{name:"avoid-region"},{name:"column",description:"Always force a column break before/after the generated box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the generated box."},{name:"region"},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],relevance:50,description:"Describes the page/column break behavior before the generated box.",restrictions:["enum"]},{name:"-webkit-column-break-inside",browsers:["C","S3"],values:[{name:"auto",description:"Neither force nor forbid a page/column break inside the generated box."},{name:"avoid",description:"Avoid a page/column break inside the generated box."},{name:"avoid-column",description:"Avoid a column break inside the generated box."},{name:"avoid-page",description:"Avoid a page break inside the generated box."},{name:"avoid-region"}],relevance:50,description:"Describes the page/column break behavior inside the generated box.",restrictions:["enum"]},{name:"-webkit-column-count",browsers:["C","S3"],values:[{name:"auto",description:"Determines the number of columns by the 'column-width' property and the element width."}],relevance:50,description:"Describes the optimal number of columns into which the content of the element will be flowed.",restrictions:["integer"]},{name:"-webkit-column-gap",browsers:["C","S3"],values:[{name:"normal",description:"User agent specific and typically equivalent to 1em."}],relevance:50,description:"Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",restrictions:["length"]},{name:"-webkit-column-rule",browsers:["C","S3"],relevance:50,description:"This property is a shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",restrictions:["length","line-width","line-style","color"]},{name:"-webkit-column-rule-color",browsers:["C","S3"],relevance:50,description:"Sets the color of the column rule",restrictions:["color"]},{name:"-webkit-column-rule-style",browsers:["C","S3"],relevance:50,description:"Sets the style of the rule between columns of an element.",restrictions:["line-style"]},{name:"-webkit-column-rule-width",browsers:["C","S3"],relevance:50,description:"Sets the width of the rule between columns. Negative values are not allowed.",restrictions:["length","line-width"]},{name:"-webkit-columns",browsers:["C","S3"],values:[{name:"auto",description:"The width depends on the values of other properties."}],relevance:50,description:"A shorthand property which sets both 'column-width' and 'column-count'.",restrictions:["length","integer"]},{name:"-webkit-column-span",browsers:["C","S3"],values:[{name:"all",description:"The element spans across all columns. Content in the normal flow that appears before the element is automatically balanced across all columns before the element appear."},{name:"none",description:"The element does not span multiple columns."}],relevance:50,description:"Describes the page/column break behavior after the generated box.",restrictions:["enum"]},{name:"-webkit-column-width",browsers:["C","S3"],values:[{name:"auto",description:"The width depends on the values of other properties."}],relevance:50,description:"This property describes the width of columns in multicol elements.",restrictions:["length"]},{name:"-webkit-filter",browsers:["C18","O15","S6"],values:[{name:"none",description:"No filter effects are applied."},{name:"blur()",description:"Applies a Gaussian blur to the input image."},{name:"brightness()",description:"Applies a linear multiplier to input image, making it appear more or less bright."},{name:"contrast()",description:"Adjusts the contrast of the input."},{name:"drop-shadow()",description:"Applies a drop shadow effect to the input image."},{name:"grayscale()",description:"Converts the input image to grayscale."},{name:"hue-rotate()",description:"Applies a hue rotation on the input image. "},{name:"invert()",description:"Inverts the samples in the input image."},{name:"opacity()",description:"Applies transparency to the samples in the input image."},{name:"saturate()",description:"Saturates the input image."},{name:"sepia()",description:"Converts the input image to sepia."},{name:"url()",description:"A filter reference to a <filter> element."}],relevance:50,description:"Processes an element\u2019s rendering before it is displayed in the document, by applying one or more filter effects.",restrictions:["enum","url"]},{name:"-webkit-flow-from",browsers:["S6.1"],values:[{name:"none",description:"The block container is not a CSS Region."}],relevance:50,description:"Makes a block container a region and associates it with a named flow.",restrictions:["identifier"]},{name:"-webkit-flow-into",browsers:["S6.1"],values:[{name:"none",description:"The element is not moved to a named flow and normal CSS processing takes place."}],relevance:50,description:"Places an element or its contents into a named flow.",restrictions:["identifier"]},{name:"-webkit-font-feature-settings",browsers:["C16"],values:[{name:'"c2cs"'},{name:'"dlig"'},{name:'"kern"'},{name:'"liga"'},{name:'"lnum"'},{name:'"onum"'},{name:'"smcp"'},{name:'"swsh"'},{name:'"tnum"'},{name:"normal",description:"No change in glyph substitution or positioning occurs."},{name:"off"},{name:"on"}],relevance:50,description:"This property provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",restrictions:["string","integer"]},{name:"-webkit-hyphens",browsers:["S5.1"],values:[{name:"auto",description:"Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."},{name:"manual",description:"Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"},{name:"none",description:"Words are not broken at line breaks, even if characters inside the word suggest line break points."}],relevance:50,description:"Controls whether hyphenation is allowed to create more break opportunities within a line of text.",restrictions:["enum"]},{name:"-webkit-line-break",browsers:["C","S3"],values:[{name:"after-white-space"},{name:"normal"}],relevance:50,description:"Specifies line-breaking rules for CJK (Chinese, Japanese, and Korean) text."},{name:"-webkit-margin-bottom-collapse",browsers:["C","S3"],values:[{name:"collapse"},{name:"discard"},{name:"separate"}],relevance:50,restrictions:["enum"]},{name:"-webkit-margin-collapse",browsers:["C","S3"],values:[{name:"collapse"},{name:"discard"},{name:"separate"}],relevance:50,restrictions:["enum"]},{name:"-webkit-margin-start",browsers:["C","S3"],values:[{name:"auto"}],relevance:50,restrictions:["percentage","length"]},{name:"-webkit-margin-top-collapse",browsers:["C","S3"],values:[{name:"collapse"},{name:"discard"},{name:"separate"}],relevance:50,restrictions:["enum"]},{name:"-webkit-mask-clip",browsers:["C","O15","S4"],status:"nonstandard",syntax:"[ <box> | border | padding | content | text ]#",relevance:0,description:"Determines the mask painting area, which determines the area that is affected by the mask.",restrictions:["box"]},{name:"-webkit-mask-image",browsers:["C","O15","S4"],values:[{name:"none",description:"Counts as a transparent black image layer."},{name:"url()",description:"Reference to a <mask element or to a CSS image."}],status:"nonstandard",syntax:"<mask-reference>#",relevance:0,description:"Sets the mask layer image of an element.",restrictions:["url","image","enum"]},{name:"-webkit-mask-origin",browsers:["C","O15","S4"],status:"nonstandard",syntax:"[ <box> | border | padding | content ]#",relevance:0,description:"Specifies the mask positioning area.",restrictions:["box"]},{name:"-webkit-mask-repeat",browsers:["C","O15","S4"],status:"nonstandard",syntax:"<repeat-style>#",relevance:0,description:"Specifies how mask layer images are tiled after they have been sized and positioned.",restrictions:["repeat"]},{name:"-webkit-mask-size",browsers:["C","O15","S4"],values:[{name:"auto",description:"Resolved by using the image\u2019s intrinsic ratio and the size of the other dimension, or failing that, using the image\u2019s intrinsic size, or failing that, treating it as 100%."},{name:"contain",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."},{name:"cover",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."}],status:"nonstandard",syntax:"<bg-size>#",relevance:0,description:"Specifies the size of the mask layer images.",restrictions:["length","percentage","enum"]},{name:"-webkit-nbsp-mode",browsers:["C","S3"],values:[{name:"normal"},{name:"space"}],relevance:50,description:"Defines the behavior of nonbreaking spaces within text."},{name:"-webkit-overflow-scrolling",browsers:["C","S5"],values:[{name:"auto"},{name:"touch"}],status:"nonstandard",syntax:"auto | touch",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-overflow-scrolling"}],description:"Specifies whether to use native-style scrolling in an overflow:scroll element."},{name:"-webkit-padding-start",browsers:["C","S3"],relevance:50,restrictions:["percentage","length"]},{name:"-webkit-perspective",browsers:["C","S4"],values:[{name:"none",description:"No perspective transform is applied."}],relevance:50,description:"Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",restrictions:["length"]},{name:"-webkit-perspective-origin",browsers:["C","S4"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-webkit-region-fragment",browsers:["S7"],values:[{name:"auto",description:"Content flows as it would in a regular content box."},{name:"break",description:"If the content fits within the CSS Region, then this property has no effect."}],relevance:50,description:"The 'region-fragment' property controls the behavior of the last region associated with a named flow.",restrictions:["enum"]},{name:"-webkit-tap-highlight-color",browsers:["E12","C16","O15"],status:"nonstandard",syntax:"<color>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-tap-highlight-color"}],restrictions:["color"]},{name:"-webkit-text-fill-color",browsers:["E12","FF49","S3","C1","O15"],status:"nonstandard",syntax:"<color>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-text-fill-color"}],restrictions:["color"]},{name:"-webkit-text-size-adjust",browsers:["E","C","S3"],values:[{name:"auto",description:"Renderers must use the default size adjustment when displaying on a small device."},{name:"none",description:"Renderers must not do size adjustment when displaying on a small device."}],relevance:50,description:"Specifies a size adjustment for displaying text content in mobile browsers.",restrictions:["percentage"]},{name:"-webkit-text-stroke",browsers:["E15","FF49","S3","C4","O15"],status:"nonstandard",syntax:"<length> || <color>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke"}],restrictions:["length","line-width","color","percentage"]},{name:"-webkit-text-stroke-color",browsers:["E15","FF49","S3","C1","O15"],status:"nonstandard",syntax:"<color>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke-color"}],restrictions:["color"]},{name:"-webkit-text-stroke-width",browsers:["E15","FF49","S3","C1","O15"],status:"nonstandard",syntax:"<length>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke-width"}],restrictions:["length","line-width","percentage"]},{name:"-webkit-touch-callout",browsers:["S3"],values:[{name:"none"}],status:"nonstandard",syntax:"default | none",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-touch-callout"}],restrictions:["enum"]},{name:"-webkit-transform",browsers:["C","O12","S3.1"],values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"perspective()",description:"Specifies a perspective projection matrix."},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],relevance:50,description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"-webkit-transform-origin",browsers:["C","O15","S3.1"],relevance:50,description:"Establishes the origin of transformation for an element.",restrictions:["position","length","percentage"]},{name:"-webkit-transform-origin-x",browsers:["C","S3.1"],relevance:50,description:"The x coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-webkit-transform-origin-y",browsers:["C","S3.1"],relevance:50,description:"The y coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-webkit-transform-origin-z",browsers:["C","S4"],relevance:50,description:"The z coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-webkit-transform-style",browsers:["C","S4"],values:[{name:"flat",description:"All children of this element are rendered flattened into the 2D plane of the element."}],relevance:50,description:"Defines how nested elements are rendered in 3D space.",restrictions:["enum"]},{name:"-webkit-transition",browsers:["C","O12","S5"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Shorthand property combines four of the transition properties into a single property.",restrictions:["time","property","timing-function","enum"]},{name:"-webkit-transition-delay",browsers:["C","O12","S5"],relevance:50,description:"Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",restrictions:["time"]},{name:"-webkit-transition-duration",browsers:["C","O12","S5"],relevance:50,description:"Specifies how long the transition from the old value to the new value should take.",restrictions:["time"]},{name:"-webkit-transition-property",browsers:["C","O12","S5"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Specifies the name of the CSS property to which the transition is applied.",restrictions:["property"]},{name:"-webkit-transition-timing-function",browsers:["C","O12","S5"],relevance:50,description:"Describes how the intermediate values used during a transition will be calculated.",restrictions:["timing-function"]},{name:"-webkit-user-drag",browsers:["S3"],values:[{name:"auto"},{name:"element"},{name:"none"}],relevance:50,restrictions:["enum"]},{name:"-webkit-user-modify",browsers:["C","S3"],values:[{name:"read-only"},{name:"read-write"},{name:"read-write-plaintext-only"}],status:"nonstandard",syntax:"read-only | read-write | read-write-plaintext-only",relevance:0,description:"Determines whether a user can edit the content of an element.",restrictions:["enum"]},{name:"-webkit-user-select",browsers:["C","S3"],values:[{name:"auto"},{name:"none"},{name:"text"}],relevance:50,description:"Controls the appearance of selection.",restrictions:["enum"]},{name:"widows",browsers:["E12","S1.3","C25","IE8","O9.2"],syntax:"<integer>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/widows"}],description:"Specifies the minimum number of line boxes of a block container that must be left in a fragment after a break.",restrictions:["integer"]},{name:"width",values:[{name:"auto",description:"The width depends on the values of other properties."},{name:"fit-content",description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"<viewport-length>{1,2}",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/width"}],description:"Specifies the width of the content area, padding area or border area (depending on 'box-sizing') of certain boxes.",restrictions:["length","percentage"]},{name:"will-change",browsers:["E79","FF36","S9.1","C36","O24"],values:[{name:"auto",description:"Expresses no particular intent."},{name:"contents",description:"Indicates that the author expects to animate or change something about the element\u2019s contents in the near future."},{name:"scroll-position",description:"Indicates that the author expects to animate or change the scroll position of the element in the near future."}],syntax:"auto | <animateable-feature>#",relevance:63,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/will-change"}],description:"Provides a rendering hint to the user agent, stating what kinds of changes the author expects to perform on the element.",restrictions:["enum","identifier"]},{name:"word-break",values:[{name:"break-all",description:"Lines may break between any two grapheme clusters for non-CJK scripts."},{name:"keep-all",description:"Block characters can no longer create implied break points."},{name:"normal",description:"Breaks non-CJK scripts according to their own rules."}],syntax:"normal | break-all | keep-all | break-word",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/word-break"}],description:"Specifies line break opportunities for non-CJK scripts.",restrictions:["enum"]},{name:"word-spacing",values:[{name:"normal",description:"No additional spacing is applied. Computes to zero."}],syntax:"normal | <length>",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/word-spacing"}],description:"Specifies additional spacing between \u201Cwords\u201D.",restrictions:["length","percentage"]},{name:"word-wrap",values:[{name:"break-word",description:"An otherwise unbreakable sequence of characters may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."},{name:"normal",description:"Lines may break only at allowed break points."}],syntax:"normal | break-word",relevance:78,description:"Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit.",restrictions:["enum"]},{name:"writing-mode",values:[{name:"horizontal-tb",description:"Top-to-bottom block flow direction. The writing mode is horizontal."},{name:"sideways-lr",description:"Left-to-right block flow direction. The writing mode is vertical, while the typographic mode is horizontal."},{name:"sideways-rl",description:"Right-to-left block flow direction. The writing mode is vertical, while the typographic mode is horizontal."},{name:"vertical-lr",description:"Left-to-right block flow direction. The writing mode is vertical."},{name:"vertical-rl",description:"Right-to-left block flow direction. The writing mode is vertical."}],syntax:"horizontal-tb | vertical-rl | vertical-lr | sideways-rl | sideways-lr",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/writing-mode"}],description:"This is a shorthand property for both 'direction' and 'block-progression'.",restrictions:["enum"]},{name:"z-index",values:[{name:"auto",description:"The stack level of the generated box in the current stacking context is 0. The box does not establish a new stacking context unless it is the root element."}],syntax:"auto | <integer>",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/z-index"}],description:"For a positioned box, the 'z-index' property specifies the stack level of the box in the current stacking context and whether the box establishes a local stacking context.",restrictions:["integer"]},{name:"zoom",browsers:["E12","S3.1","C1","IE5.5","O15"],values:[{name:"normal"}],syntax:"auto | <number> | <percentage>",relevance:67,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/zoom"}],description:"Non-standard. Specifies the magnification scale of the object. See 'transform: scale()' for a standards-based alternative.",restrictions:["enum","integer","number","percentage"]},{name:"-ms-ime-align",status:"nonstandard",syntax:"auto | after",relevance:0,description:"Aligns the Input Method Editor (IME) candidate window box relative to the element on which the IME composition is active."},{name:"-moz-binding",status:"nonstandard",syntax:"<url> | none",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-binding"}],description:"The -moz-binding CSS property is used by Mozilla-based applications to attach an XBL binding to a DOM element."},{name:"-moz-context-properties",status:"nonstandard",syntax:"none | [ fill | fill-opacity | stroke | stroke-opacity ]#",relevance:0,browsers:["FF55"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-context-properties"}],description:`If you reference an SVG image in a webpage (such as with the <img> element or as a background image), the SVG image can coordinate with the embedding element (its context) to have the image adopt property values set on the embedding element. To do this the embedding element needs to list the properties that are to be made available to the image by listing them as values of the -moz-context-properties property, and the image needs to opt in to using those properties by using values such as the context-fill value.

This feature is available since Firefox 55, but is only currently supported with SVG images loaded via chrome:// or resource:// URLs. To experiment with the feature in SVG on the Web it is necessary to set the svg.context-properties.content.enabled pref to true.`},{name:"-moz-float-edge",status:"nonstandard",syntax:"border-box | content-box | margin-box | padding-box",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-float-edge"}],description:"The non-standard -moz-float-edge CSS property specifies whether the height and width properties of the element include the margin, border, or padding thickness."},{name:"-moz-force-broken-image-icon",status:"nonstandard",syntax:"0 | 1",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-force-broken-image-icon"}],description:"The -moz-force-broken-image-icon extended CSS property can be used to force the broken image icon to be shown even when a broken image has an alt attribute."},{name:"-moz-image-region",status:"nonstandard",syntax:"<shape> | auto",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-image-region"}],description:"For certain XUL elements and pseudo-elements that use an image from the list-style-image property, this property specifies a region of the image that is used in place of the whole image. This allows elements to use different pieces of the same image to improve performance."},{name:"-moz-orient",status:"nonstandard",syntax:"inline | block | horizontal | vertical",relevance:0,browsers:["FF6"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-orient"}],description:"The -moz-orient CSS property specifies the orientation of the element to which it's applied."},{name:"-moz-outline-radius",status:"nonstandard",syntax:"<outline-radius>{1,4} [ / <outline-radius>{1,4} ]?",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-outline-radius"}],description:"In Mozilla applications like Firefox, the -moz-outline-radius CSS property can be used to give an element's outline rounded corners."},{name:"-moz-outline-radius-bottomleft",status:"nonstandard",syntax:"<outline-radius>",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-outline-radius-bottomleft"}],description:"In Mozilla applications, the -moz-outline-radius-bottomleft CSS property can be used to round the bottom-left corner of an element's outline."},{name:"-moz-outline-radius-bottomright",status:"nonstandard",syntax:"<outline-radius>",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-outline-radius-bottomright"}],description:"In Mozilla applications, the -moz-outline-radius-bottomright CSS property can be used to round the bottom-right corner of an element's outline."},{name:"-moz-outline-radius-topleft",status:"nonstandard",syntax:"<outline-radius>",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-outline-radius-topleft"}],description:"In Mozilla applications, the -moz-outline-radius-topleft CSS property can be used to round the top-left corner of an element's outline."},{name:"-moz-outline-radius-topright",status:"nonstandard",syntax:"<outline-radius>",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-outline-radius-topright"}],description:"In Mozilla applications, the -moz-outline-radius-topright CSS property can be used to round the top-right corner of an element's outline."},{name:"-moz-stack-sizing",status:"nonstandard",syntax:"ignore | stretch-to-fit",relevance:0,description:"-moz-stack-sizing is an extended CSS property. Normally, a stack will change its size so that all of its child elements are completely visible. For example, moving a child of the stack far to the right will widen the stack so the child remains visible."},{name:"-moz-text-blink",status:"nonstandard",syntax:"none | blink",relevance:0,description:"The -moz-text-blink non-standard Mozilla CSS extension specifies the blink mode."},{name:"-moz-user-input",status:"nonstandard",syntax:"auto | none | enabled | disabled",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-user-input"}],description:"In Mozilla applications, -moz-user-input determines if an element will accept user input."},{name:"-moz-user-modify",status:"nonstandard",syntax:"read-only | read-write | write-only",relevance:0,description:"The -moz-user-modify property has no effect. It was originally planned to determine whether or not the content of an element can be edited by a user."},{name:"-moz-window-dragging",status:"nonstandard",syntax:"drag | no-drag",relevance:0,description:"The -moz-window-dragging CSS property specifies whether a window is draggable or not. It only works in Chrome code, and only on Mac OS X."},{name:"-moz-window-shadow",status:"nonstandard",syntax:"default | menu | tooltip | sheet | none",relevance:0,description:"The -moz-window-shadow CSS property specifies whether a window will have a shadow. It only works on Mac OS X."},{name:"-webkit-border-before",status:"nonstandard",syntax:"<'border-width'> || <'border-style'> || <color>",relevance:0,browsers:["E79","S5.1","C8","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-border-before"}],description:"The -webkit-border-before CSS property is a shorthand property for setting the individual logical block start border property values in a single place in the style sheet."},{name:"-webkit-border-before-color",status:"nonstandard",syntax:"<color>",relevance:0,description:"The -webkit-border-before-color CSS property sets the color of the individual logical block start border in a single place in the style sheet."},{name:"-webkit-border-before-style",status:"nonstandard",syntax:"<'border-style'>",relevance:0,description:"The -webkit-border-before-style CSS property sets the style of the individual logical block start border in a single place in the style sheet."},{name:"-webkit-border-before-width",status:"nonstandard",syntax:"<'border-width'>",relevance:0,description:"The -webkit-border-before-width CSS property sets the width of the individual logical block start border in a single place in the style sheet."},{name:"-webkit-line-clamp",syntax:"none | <integer>",relevance:50,browsers:["E17","FF68","S5","C6","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-line-clamp"}],description:"The -webkit-line-clamp CSS property allows limiting of the contents of a block container to the specified number of lines."},{name:"-webkit-mask",status:"nonstandard",syntax:"[ <mask-reference> || <position> [ / <bg-size> ]? || <repeat-style> || [ <box> | border | padding | content | text ] || [ <box> | border | padding | content ] ]#",relevance:0,description:"The mask CSS property alters the visibility of an element by either partially or fully hiding it. This is accomplished by either masking or clipping the image at specific points."},{name:"-webkit-mask-attachment",status:"nonstandard",syntax:"<attachment>#",relevance:0,browsers:["S4","C1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-attachment"}],description:"If a -webkit-mask-image is specified, -webkit-mask-attachment determines whether the mask image's position is fixed within the viewport, or scrolls along with its containing block."},{name:"-webkit-mask-composite",status:"nonstandard",syntax:"<composite-style>#",relevance:0,browsers:["E18","FF53","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-composite"}],description:"The -webkit-mask-composite property specifies the manner in which multiple mask images applied to the same element are composited with one another. Mask images are composited in the opposite order that they are declared with the -webkit-mask-image property."},{name:"-webkit-mask-position",status:"nonstandard",syntax:"<position>#",relevance:0,description:"The mask-position CSS property sets the initial position, relative to the mask position layer defined by mask-origin, for each defined mask image."},{name:"-webkit-mask-position-x",status:"nonstandard",syntax:"[ <length-percentage> | left | center | right ]#",relevance:0,browsers:["E18","FF49","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-position-x"}],description:"The -webkit-mask-position-x CSS property sets the initial horizontal position of a mask image."},{name:"-webkit-mask-position-y",status:"nonstandard",syntax:"[ <length-percentage> | top | center | bottom ]#",relevance:0,browsers:["E18","FF49","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-position-y"}],description:"The -webkit-mask-position-y CSS property sets the initial vertical position of a mask image."},{name:"-webkit-mask-repeat-x",status:"nonstandard",syntax:"repeat | no-repeat | space | round",relevance:0,browsers:["E18","S5","C3","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-repeat-x"}],description:"The -webkit-mask-repeat-x property specifies whether and how a mask image is repeated (tiled) horizontally."},{name:"-webkit-mask-repeat-y",status:"nonstandard",syntax:"repeat | no-repeat | space | round",relevance:0,browsers:["E18","S5","C3","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-repeat-y"}],description:"The -webkit-mask-repeat-y property specifies whether and how a mask image is repeated (tiled) vertically."},{name:"accent-color",syntax:"auto | <color>",relevance:50,browsers:["E93","FF92","S15.4","C93","O79"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/accent-color"}],description:"Sets the color of the elements accent"},{name:"align-tracks",status:"experimental",syntax:"[ normal | <baseline-position> | <content-distribution> | <overflow-position>? <content-position> ]#",relevance:50,browsers:["FF77"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/align-tracks"}],description:"The align-tracks CSS property sets the alignment in the masonry axis for grid containers that have masonry in their block axis."},{name:"animation-timeline",syntax:"<single-animation-timeline>#",relevance:50,browsers:["FF97"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-timeline"}],description:"Specifies the names of one or more @scroll-timeline at-rules to describe the element's scroll animations."},{name:"appearance",status:"experimental",syntax:"none | auto | textfield | menulist-button | <compat-auto>",relevance:62,browsers:["E84","FF80","S15.4","C84","O70"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/appearance"}],description:"Changes the appearance of buttons and other controls to resemble native controls."},{name:"aspect-ratio",status:"experimental",syntax:"auto | <ratio>",relevance:52,browsers:["E88","FF89","S15","C88","O74"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/aspect-ratio"}],description:"The aspect-ratio   CSS property sets a preferred aspect ratio for the box, which will be used in the calculation of auto sizes and some other layout functions."},{name:"azimuth",status:"obsolete",syntax:"<angle> | [ [ left-side | far-left | left | center-left | center | center-right | right | far-right | right-side ] || behind ] | leftwards | rightwards",relevance:0,description:"In combination with elevation, the azimuth CSS property enables different audio sources to be positioned spatially for aural presentation. This is important in that it provides a natural way to tell several voices apart, as each can be positioned to originate at a different location on the sound stage. Stereo output produce a lateral sound stage, while binaural headphones and multi-speaker setups allow for a fully three-dimensional stage."},{name:"backdrop-filter",syntax:"none | <filter-function-list>",relevance:53,browsers:["E17","FF70","S9","C76","O63"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/backdrop-filter"}],description:"The backdrop-filter CSS property lets you apply graphical effects such as blurring or color shifting to the area behind an element. Because it applies to everything behind the element, to see the effect you must make the element or its background at least partially transparent."},{name:"border-block",syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block"}],description:"The border-block CSS property is a shorthand property for setting the individual logical block border property values in a single place in the style sheet."},{name:"border-block-color",syntax:"<'border-top-color'>{1,2}",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-color"}],description:"The border-block-color CSS property defines the color of the logical block borders of an element, which maps to a physical border color depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-color and border-bottom-color, or border-right-color and border-left-color property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-block-style",syntax:"<'border-top-style'>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-style"}],description:"The border-block-style CSS property defines the style of the logical block borders of an element, which maps to a physical border style depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-style and border-bottom-style, or border-left-style and border-right-style properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-block-width",syntax:"<'border-top-width'>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-width"}],description:"The border-block-width CSS property defines the width of the logical block borders of an element, which maps to a physical border width depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-width and border-bottom-width, or border-left-width, and border-right-width property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-end-end-radius",syntax:"<length-percentage>{1,2}",relevance:50,browsers:["E89","FF66","S15","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-end-end-radius"}],description:"The border-end-end-radius CSS property defines a logical border radius on an element, which maps to a physical border radius that depends on on the element's writing-mode, direction, and text-orientation."},{name:"border-end-start-radius",syntax:"<length-percentage>{1,2}",relevance:50,browsers:["E89","FF66","S15","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-end-start-radius"}],description:"The border-end-start-radius CSS property defines a logical border radius on an element, which maps to a physical border radius depending on the element's writing-mode, direction, and text-orientation."},{name:"border-inline",syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline"}],description:"The border-inline CSS property is a shorthand property for setting the individual logical inline border property values in a single place in the style sheet."},{name:"border-inline-color",syntax:"<'border-top-color'>{1,2}",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-color"}],description:"The border-inline-color CSS property defines the color of the logical inline borders of an element, which maps to a physical border color depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-color and border-bottom-color, or border-right-color and border-left-color property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-inline-style",syntax:"<'border-top-style'>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-style"}],description:"The border-inline-style CSS property defines the style of the logical inline borders of an element, which maps to a physical border style depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-style and border-bottom-style, or border-left-style and border-right-style properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-inline-width",syntax:"<'border-top-width'>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-width"}],description:"The border-inline-width CSS property defines the width of the logical inline borders of an element, which maps to a physical border width depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-width and border-bottom-width, or border-left-width, and border-right-width property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-start-end-radius",syntax:"<length-percentage>{1,2}",relevance:50,browsers:["E89","FF66","S15","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-start-end-radius"}],description:"The border-start-end-radius CSS property defines a logical border radius on an element, which maps to a physical border radius depending on the element's writing-mode, direction, and text-orientation."},{name:"border-start-start-radius",syntax:"<length-percentage>{1,2}",relevance:50,browsers:["E89","FF66","S15","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-start-start-radius"}],description:"The border-start-start-radius CSS property defines a logical border radius on an element, which maps to a physical border radius that depends on the element's writing-mode, direction, and text-orientation."},{name:"box-align",status:"nonstandard",syntax:"start | center | end | baseline | stretch",relevance:0,browsers:["E12","FF1","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-align"}],description:"The box-align CSS property specifies how an element aligns its contents across its layout in a perpendicular direction. The effect of the property is only visible if there is extra space in the box."},{name:"box-direction",status:"nonstandard",syntax:"normal | reverse | inherit",relevance:0,browsers:["E12","FF1","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-direction"}],description:"The box-direction CSS property specifies whether a box lays out its contents normally (from the top or left edge), or in reverse (from the bottom or right edge)."},{name:"box-flex",status:"nonstandard",syntax:"<number>",relevance:0,browsers:["E12","FF1","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-flex"}],description:"The -moz-box-flex and -webkit-box-flex CSS properties specify how a -moz-box or -webkit-box grows to fill the box that contains it, in the direction of the containing box's layout."},{name:"box-flex-group",status:"nonstandard",syntax:"<integer>",relevance:0,browsers:["S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-flex-group"}],description:"The box-flex-group CSS property assigns the flexbox's child elements to a flex group."},{name:"box-lines",status:"nonstandard",syntax:"single | multiple",relevance:0,browsers:["S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-lines"}],description:"The box-lines CSS property determines whether the box may have a single or multiple lines (rows for horizontally oriented boxes, columns for vertically oriented boxes)."},{name:"box-ordinal-group",status:"nonstandard",syntax:"<integer>",relevance:0,browsers:["E12","FF1","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-ordinal-group"}],description:"The box-ordinal-group CSS property assigns the flexbox's child elements to an ordinal group."},{name:"box-orient",status:"nonstandard",syntax:"horizontal | vertical | inline-axis | block-axis | inherit",relevance:0,browsers:["E12","FF1","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-orient"}],description:"The box-orient CSS property specifies whether an element lays out its contents horizontally or vertically."},{name:"box-pack",status:"nonstandard",syntax:"start | center | end | justify",relevance:0,browsers:["E12","FF1","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-pack"}],description:"The -moz-box-pack and -webkit-box-pack CSS properties specify how a -moz-box or -webkit-box packs its contents in the direction of its layout. The effect of this is only visible if there is extra space in the box."},{name:"print-color-adjust",syntax:"economy | exact",relevance:50,browsers:["E79","FF97","S15.4","C17","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/print-color-adjust"}],description:"Defines what optimization the user agent is allowed to do when adjusting the appearance for an output device."},{name:"color-scheme",syntax:"normal | [ light | dark | <custom-ident> ]+ && only?",relevance:52,browsers:["E81","FF96","S13","C81","O68"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/color-scheme"}],description:"The color-scheme CSS property allows an element to indicate which color schemes it can comfortably be rendered in."},{name:"content-visibility",syntax:"visible | auto | hidden",relevance:51,browsers:["E85","S15.4","C85","O71"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/content-visibility"}],description:"Controls whether or not an element renders its contents at all, along with forcing a strong set of containments, allowing user agents to potentially omit large swathes of layout and rendering work until it becomes needed."},{name:"counter-set",syntax:"[ <counter-name> <integer>? ]+ | none",relevance:50,browsers:["E85","FF68","C85","O71"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/counter-set"}],description:"The counter-set CSS property sets a CSS counter to a given value. It manipulates the value of existing counters, and will only create new counters if there isn't already a counter of the given name on the element."},{name:"font-optical-sizing",syntax:"auto | none",relevance:50,browsers:["E17","FF62","S11","C79","O66"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-optical-sizing"}],description:"The font-optical-sizing CSS property allows developers to control whether browsers render text with slightly differing visual representations to optimize viewing at different sizes, or not. This only works for fonts that have an optical size variation axis."},{name:"font-variation-settings",syntax:"normal | [ <string> <number> ]#",relevance:50,browsers:["E17","FF62","S11","C62","O49"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variation-settings"}],description:"The font-variation-settings CSS property provides low-level control over OpenType or TrueType font variations, by specifying the four letter axis names of the features you want to vary, along with their variation values."},{name:"font-smooth",status:"nonstandard",syntax:"auto | never | always | <absolute-size> | <length>",relevance:0,browsers:["E79","FF25","S4","C5","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-smooth"}],description:"The font-smooth CSS property controls the application of anti-aliasing when fonts are rendered."},{name:"forced-color-adjust",status:"experimental",syntax:"auto | none",relevance:52,browsers:["E79","C89","IE10"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/forced-color-adjust"}],description:"Allows authors to opt certain elements out of forced colors mode. This then restores the control of those values to CSS"},{name:"gap",syntax:"<'row-gap'> <'column-gap'>?",relevance:55,browsers:["E84","FF63","S14.1","C84","O70"],description:"The gap CSS property is a shorthand property for row-gap and column-gap specifying the gutters between grid rows and columns."},{name:"hanging-punctuation",syntax:"none | [ first || [ force-end | allow-end ] || last ]",relevance:50,browsers:["S10"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/hanging-punctuation"}],description:"The hanging-punctuation CSS property specifies whether a punctuation mark should hang at the start or end of a line of text. Hanging punctuation may be placed outside the line box."},{name:"hyphenate-character",syntax:"auto | <string>",relevance:50,browsers:["E79","FF98","S5.1","C6","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/hyphenate-character"}],description:"A hyphenate character used at the end of a line."},{name:"image-resolution",status:"experimental",syntax:"[ from-image || <resolution> ] && snap?",relevance:50,description:"The image-resolution property specifies the intrinsic resolution of all raster images used in or on the element. It affects both content images (e.g. replaced elements and generated content) and decorative images (such as background-image). The intrinsic resolution of an image is used to determine the image\u2019s intrinsic dimensions."},{name:"initial-letter",status:"experimental",syntax:"normal | [ <number> <integer>? ]",relevance:50,browsers:["S9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/initial-letter"}],description:"The initial-letter CSS property specifies styling for dropped, raised, and sunken initial letters."},{name:"initial-letter-align",status:"experimental",syntax:"[ auto | alphabetic | hanging | ideographic ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/initial-letter-align"}],description:"The initial-letter-align CSS property specifies the alignment of initial letters within a paragraph."},{name:"input-security",syntax:"auto | none",relevance:50,description:"Enables or disables the obscuring a sensitive test input."},{name:"inset",syntax:"<'top'>{1,4}",relevance:51,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset"}],description:"The inset CSS property defines the logical block and inline start and end offsets of an element, which map to physical offsets depending on the element's writing mode, directionality, and text orientation. It corresponds to the top and bottom, or right and left properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-block",syntax:"<'top'>{1,2}",relevance:50,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-block"}],description:"The inset-block CSS property defines the logical block start and end offsets of an element, which maps to physical offsets depending on the element's writing mode, directionality, and text orientation. It corresponds to the top and bottom, or right and left properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-block-end",syntax:"<'top'>",relevance:50,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-block-end"}],description:"The inset-block-end CSS property defines the logical block end offset of an element, which maps to a physical offset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-block-start",syntax:"<'top'>",relevance:50,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-block-start"}],description:"The inset-block-start CSS property defines the logical block start offset of an element, which maps to a physical offset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-inline",syntax:"<'top'>{1,2}",relevance:50,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-inline"}],description:"The inset-inline CSS property defines the logical block start and end offsets of an element, which maps to physical offsets depending on the element's writing mode, directionality, and text orientation. It corresponds to the top and bottom, or right and left properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-inline-end",syntax:"<'top'>",relevance:50,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-inline-end"}],description:"The inset-inline-end CSS property defines the logical inline end inset of an element, which maps to a physical inset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-inline-start",syntax:"<'top'>",relevance:50,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-inline-start"}],description:"The inset-inline-start CSS property defines the logical inline start inset of an element, which maps to a physical offset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"justify-tracks",status:"experimental",syntax:"[ normal | <content-distribution> | <overflow-position>? [ <content-position> | left | right ] ]#",relevance:50,browsers:["FF77"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/justify-tracks"}],description:"The justify-tracks CSS property sets the alignment in the masonry axis for grid containers that have masonry in their inline axis"},{name:"line-clamp",status:"experimental",syntax:"none | <integer>",relevance:50,description:"The line-clamp property allows limiting the contents of a block container to the specified number of lines; remaining content is fragmented away and neither rendered nor measured. Optionally, it also allows inserting content into the last line box to indicate the continuity of truncated/interrupted content."},{name:"line-height-step",status:"experimental",syntax:"<length>",relevance:50,browsers:["E79","C60","O47"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/line-height-step"}],description:"The line-height-step CSS property defines the step units for line box heights. When the step unit is positive, line box heights are rounded up to the closest multiple of the unit. Negative values are invalid."},{name:"margin-block",syntax:"<'margin-left'>{1,2}",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-block"}],description:"The margin-block CSS property defines the logical block start and end margins of an element, which maps to physical margins depending on the element's writing mode, directionality, and text orientation."},{name:"margin-inline",syntax:"<'margin-left'>{1,2}",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-inline"}],description:"The margin-inline CSS property defines the logical inline start and end margins of an element, which maps to physical margins depending on the element's writing mode, directionality, and text orientation."},{name:"margin-trim",status:"experimental",syntax:"none | in-flow | all",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-trim"}],description:"The margin-trim property allows the container to trim the margins of its children where they adjoin the container\u2019s edges."},{name:"mask",syntax:"<mask-layer>#",relevance:50,browsers:["E79","FF2","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask"}],description:"The mask CSS property alters the visibility of an element by either partially or fully hiding it. This is accomplished by either masking or clipping the image at specific points."},{name:"mask-border",syntax:"<'mask-border-source'> || <'mask-border-slice'> [ / <'mask-border-width'>? [ / <'mask-border-outset'> ]? ]? || <'mask-border-repeat'> || <'mask-border-mode'>",relevance:50,browsers:["E79","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border"}],description:`The mask-border CSS property lets you create a mask along the edge of an element's border.

This property is a shorthand for mask-border-source, mask-border-slice, mask-border-width, mask-border-outset, mask-border-repeat, and mask-border-mode. As with all shorthand properties, any omitted sub-values will be set to their initial value.`},{name:"mask-border-mode",syntax:"luminance | alpha",relevance:50,description:"The mask-border-mode CSS property specifies the blending mode used in a mask border."},{name:"mask-border-outset",syntax:"[ <length> | <number> ]{1,4}",relevance:50,browsers:["E79","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-outset"}],description:"The mask-border-outset CSS property specifies the distance by which an element's mask border is set out from its border box."},{name:"mask-border-repeat",syntax:"[ stretch | repeat | round | space ]{1,2}",relevance:50,browsers:["E79","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-repeat"}],description:"The mask-border-repeat CSS property defines how the edge regions of a source image are adjusted to fit the dimensions of an element's mask border."},{name:"mask-border-slice",syntax:"<number-percentage>{1,4} fill?",relevance:50,browsers:["E79","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-slice"}],description:"The mask-border-slice CSS property divides the image specified by mask-border-source into regions. These regions are used to form the components of an element's mask border."},{name:"mask-border-source",syntax:"none | <image>",relevance:50,browsers:["E79","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-source"}],description:`The mask-border-source CSS property specifies the source image used to create an element's mask border.

The mask-border-slice property is used to divide the source image into regions, which are then dynamically applied to the final mask border.`},{name:"mask-border-width",syntax:"[ <length-percentage> | <number> | auto ]{1,4}",relevance:50,browsers:["E79","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-width"}],description:"The mask-border-width CSS property specifies the width of an element's mask border."},{name:"mask-clip",syntax:"[ <geometry-box> | no-clip ]#",relevance:50,browsers:["E79","FF53","S15.4","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-clip"}],description:"The mask-clip CSS property determines the area, which is affected by a mask. The painted content of an element must be restricted to this area."},{name:"mask-composite",syntax:"<compositing-operator>#",relevance:50,browsers:["E18","FF53","S15.4"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-composite"}],description:"The mask-composite CSS property represents a compositing operation used on the current mask layer with the mask layers below it."},{name:"masonry-auto-flow",status:"experimental",syntax:"[ pack | next ] || [ definite-first | ordered ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/masonry-auto-flow"}],description:"The masonry-auto-flow CSS property modifies how items are placed when using masonry in CSS Grid Layout."},{name:"math-style",syntax:"normal | compact",relevance:50,browsers:["FF83","S14.1","C83"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/math-style"}],description:"The math-style property indicates whether MathML equations should render with normal or compact height."},{name:"max-lines",status:"experimental",syntax:"none | <integer>",relevance:50,description:"The max-liens property forces a break after a set number of lines"},{name:"offset",syntax:"[ <'offset-position'>? [ <'offset-path'> [ <'offset-distance'> || <'offset-rotate'> ]? ]? ]! [ / <'offset-anchor'> ]?",relevance:50,browsers:["E79","FF72","C55","O42"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset"}],description:"The offset CSS property is a shorthand property for animating an element along a defined path."},{name:"offset-anchor",syntax:"auto | <position>",relevance:50,browsers:["FF72"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-anchor"}],description:"Defines an anchor point of the box positioned along the path. The anchor point specifies the point of the box which is to be considered as the point that is moved along the path."},{name:"offset-distance",syntax:"<length-percentage>",relevance:50,browsers:["E79","FF72","C55","O42"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-distance"}],description:"The offset-distance CSS property specifies a position along an offset-path."},{name:"offset-path",syntax:"none | ray( [ <angle> && <size> && contain? ] ) | <path()> | <url> | [ <basic-shape> || <geometry-box> ]",relevance:50,browsers:["E79","FF72","C55","O45"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-path"}],description:`The offset-path CSS property specifies the offset path where the element gets positioned. The exact element\u2019s position on the offset path is determined by the offset-distance property. An offset path is either a specified path with one or multiple sub-paths or the geometry of a not-styled basic shape. Each shape or path must define an initial position for the computed value of "0" for offset-distance and an initial direction which specifies the rotation of the object to the initial position.

In this specification, a direction (or rotation) of 0 degrees is equivalent to the direction of the positive x-axis in the object\u2019s local coordinate system. In other words, a rotation of 0 degree points to the right side of the UA if the object and its ancestors have no transformation applied.`},{name:"offset-position",status:"experimental",syntax:"auto | <position>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-position"}],description:"Specifies the initial position of the offset path. If position is specified with static, offset-position would be ignored."},{name:"offset-rotate",syntax:"[ auto | reverse ] || <angle>",relevance:50,browsers:["E79","FF72","C56","O43"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-rotate"}],description:"The offset-rotate CSS property defines the direction of the element while positioning along the offset path."},{name:"overflow-anchor",syntax:"auto | none",relevance:52,browsers:["E79","FF66","C56","O43"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-anchor"}],description:"The overflow-anchor CSS property provides a way to opt out browser scroll anchoring behavior which adjusts scroll position to minimize content shifts."},{name:"overflow-block",syntax:"visible | hidden | clip | scroll | auto",relevance:50,browsers:["FF69"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-block"}],description:"The overflow-block CSS media feature can be used to test how the output device handles content that overflows the initial containing block along the block axis."},{name:"overflow-clip-box",status:"nonstandard",syntax:"padding-box | content-box",relevance:0,browsers:["FF29"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Mozilla/Gecko/Chrome/CSS/overflow-clip-box"}],description:"The overflow-clip-box CSS property specifies relative to which box the clipping happens when there is an overflow. It is short hand for the overflow-clip-box-inline and overflow-clip-box-block properties."},{name:"overflow-clip-margin",syntax:"<visual-box> || <length [0,\u221E]>",relevance:50,browsers:["E90","C90","O76"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-clip-margin"}],description:"The overflow-clip-margin CSS property determines how far outside its bounds an element with overflow: clip may be painted before being clipped."},{name:"overflow-inline",syntax:"visible | hidden | clip | scroll | auto",relevance:50,browsers:["FF69"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-inline"}],description:"The overflow-inline CSS media feature can be used to test how the output device handles content that overflows the initial containing block along the inline axis."},{name:"overscroll-behavior",syntax:"[ contain | none | auto ]{1,2}",relevance:50,browsers:["E18","FF59","C63","O50"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior"}],description:"The overscroll-behavior CSS property is shorthand for the overscroll-behavior-x and overscroll-behavior-y properties, which allow you to control the browser's scroll overflow behavior \u2014 what happens when the boundary of a scrolling area is reached."},{name:"overscroll-behavior-block",syntax:"contain | none | auto",relevance:50,browsers:["E79","FF73","C77","O64"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-block"}],description:"The overscroll-behavior-block CSS property sets the browser's behavior when the block direction boundary of a scrolling area is reached."},{name:"overscroll-behavior-inline",syntax:"contain | none | auto",relevance:50,browsers:["E79","FF73","C77","O64"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-inline"}],description:"The overscroll-behavior-inline CSS property sets the browser's behavior when the inline direction boundary of a scrolling area is reached."},{name:"overscroll-behavior-x",syntax:"contain | none | auto",relevance:50,browsers:["E18","FF59","C63","O50"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-x"}],description:"The overscroll-behavior-x CSS property is allows you to control the browser's scroll overflow behavior \u2014 what happens when the boundary of a scrolling area is reached \u2014 in the x axis direction."},{name:"overscroll-behavior-y",syntax:"contain | none | auto",relevance:50,browsers:["E18","FF59","C63","O50"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-y"}],description:"The overscroll-behavior-y CSS property is allows you to control the browser's scroll overflow behavior \u2014 what happens when the boundary of a scrolling area is reached \u2014 in the y axis direction."},{name:"padding-block",syntax:"<'padding-left'>{1,2}",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-block"}],description:"The padding-block CSS property defines the logical block start and end padding of an element, which maps to physical padding properties depending on the element's writing mode, directionality, and text orientation."},{name:"padding-inline",syntax:"<'padding-left'>{1,2}",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-inline"}],description:"The padding-inline CSS property defines the logical inline start and end padding of an element, which maps to physical padding properties depending on the element's writing mode, directionality, and text orientation."},{name:"place-content",syntax:"<'align-content'> <'justify-content'>?",relevance:50,browsers:["E79","FF45","S9","C59","O46"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/place-content"}],description:"The place-content CSS shorthand property sets both the align-content and justify-content properties."},{name:"place-items",syntax:"<'align-items'> <'justify-items'>?",relevance:50,browsers:["E79","FF45","S11","C59","O46"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/place-items"}],description:"The CSS place-items shorthand property sets both the align-items and justify-items properties. The first value is the align-items property value, the second the justify-items one. If the second value is not present, the first value is also used for it."},{name:"place-self",syntax:"<'align-self'> <'justify-self'>?",relevance:50,browsers:["E79","FF45","S11","C59","O46"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/place-self"}],description:"The place-self CSS property is a shorthand property sets both the align-self and justify-self properties. The first value is the align-self property value, the second the justify-self one. If the second value is not present, the first value is also used for it."},{name:"rotate",syntax:"none | <angle> | [ x | y | z | <number>{3} ] && <angle>",relevance:50,browsers:["FF72","S14.1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/rotate"}],description:"The rotate CSS property allows you to specify rotation transforms individually and independently of the transform property. This maps better to typical user interface usage, and saves having to remember the exact order of transform functions to specify in the transform value."},{name:"row-gap",syntax:"normal | <length-percentage>",relevance:51,browsers:["E84","FF63","S14.1","C84","O70"],description:"The row-gap CSS property specifies the gutter between grid rows."},{name:"ruby-merge",status:"experimental",syntax:"separate | collapse | auto",relevance:50,description:"This property controls how ruby annotation boxes should be rendered when there are more than one in a ruby container box: whether each pair should be kept separate, the annotations should be collapsed and rendered as a group, or the separation should be determined based on the space available."},{name:"scale",syntax:"none | <number>{1,3}",relevance:50,browsers:["FF72","S14.1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scale"}],description:"The scale CSS property allows you to specify scale transforms individually and independently of the transform property. This maps better to typical user interface usage, and saves having to remember the exact order of transform functions to specify in the transform value."},{name:"scrollbar-color",syntax:"auto | <color>{2}",relevance:50,browsers:["FF64"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-color"}],description:"The scrollbar-color CSS property sets the color of the scrollbar track and thumb."},{name:"scrollbar-gutter",syntax:"auto | stable && both-edges?",relevance:50,browsers:["E94","FF97","C94","O80"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-gutter"}],description:"The scrollbar-gutter CSS property allows authors to reserve space for the scrollbar, preventing unwanted layout changes as the content grows while also avoiding unnecessary visuals when scrolling isn't needed."},{name:"scrollbar-width",syntax:"auto | thin | none",relevance:50,browsers:["FF64"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-width"}],description:"The scrollbar-width property allows the author to set the maximum thickness of an element\u2019s scrollbars when they are shown. "},{name:"scroll-margin",syntax:"<length>{1,4}",relevance:50,browsers:["E79","FF90","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin"}],description:"The scroll-margin property is a shorthand property which sets all of the scroll-margin longhands, assigning values much like the margin property does for the margin-* longhands."},{name:"scroll-margin-block",syntax:"<length>{1,2}",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block"}],description:"The scroll-margin-block property is a shorthand property which sets the scroll-margin longhands in the block dimension."},{name:"scroll-margin-block-start",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block-start"}],description:"The scroll-margin-block-start property defines the margin of the scroll snap area at the start of the block dimension that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-margin-block-end",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block-end"}],description:"The scroll-margin-block-end property defines the margin of the scroll snap area at the end of the block dimension that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-margin-bottom",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-bottom"}],description:"The scroll-margin-bottom property defines the bottom margin of the scroll snap area that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-margin-inline",syntax:"<length>{1,2}",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline"}],description:"The scroll-margin-inline property is a shorthand property which sets the scroll-margin longhands in the inline dimension."},{name:"scroll-margin-inline-start",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline-start"}],description:"The scroll-margin-inline-start property defines the margin of the scroll snap area at the start of the inline dimension that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-margin-inline-end",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline-end"}],description:"The scroll-margin-inline-end property defines the margin of the scroll snap area at the end of the inline dimension that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-margin-left",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-left"}],description:"The scroll-margin-left property defines the left margin of the scroll snap area that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-margin-right",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-right"}],description:"The scroll-margin-right property defines the right margin of the scroll snap area that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-margin-top",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-top"}],description:"The scroll-margin-top property defines the top margin of the scroll snap area that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container\u2019s coordinate space), then adding the specified outsets."},{name:"scroll-padding",syntax:"[ auto | <length-percentage> ]{1,4}",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding"}],description:"The scroll-padding property is a shorthand property which sets all of the scroll-padding longhands, assigning values much like the padding property does for the padding-* longhands."},{name:"scroll-padding-block",syntax:"[ auto | <length-percentage> ]{1,2}",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block"}],description:"The scroll-padding-block property is a shorthand property which sets the scroll-padding longhands for the block dimension."},{name:"scroll-padding-block-start",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block-start"}],description:"The scroll-padding-block-start property defines offsets for the start edge in the block dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-block-end",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block-end"}],description:"The scroll-padding-block-end property defines offsets for the end edge in the block dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-bottom",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-bottom"}],description:"The scroll-padding-bottom property defines offsets for the bottom of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-inline",syntax:"[ auto | <length-percentage> ]{1,2}",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline"}],description:"The scroll-padding-inline property is a shorthand property which sets the scroll-padding longhands for the inline dimension."},{name:"scroll-padding-inline-start",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline-start"}],description:"The scroll-padding-inline-start property defines offsets for the start edge in the inline dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-inline-end",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline-end"}],description:"The scroll-padding-inline-end property defines offsets for the end edge in the inline dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-left",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-left"}],description:"The scroll-padding-left property defines offsets for the left of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-right",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-right"}],description:"The scroll-padding-right property defines offsets for the right of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-top",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-top"}],description:"The scroll-padding-top property defines offsets for the top of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-snap-align",syntax:"[ none | start | end | center ]{1,2}",relevance:52,browsers:["E79","FF68","S11","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-align"}],description:"The scroll-snap-align property specifies the box\u2019s snap position as an alignment of its snap area (as the alignment subject) within its snap container\u2019s snapport (as the alignment container). The two values specify the snapping alignment in the block axis and inline axis, respectively. If only one value is specified, the second value defaults to the same value."},{name:"scroll-snap-stop",syntax:"normal | always",relevance:50,browsers:["E79","S15","C75","O62"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-stop"}],description:'The scroll-snap-stop CSS property defines whether the scroll container is allowed to "pass over" possible snap positions.'},{name:"scroll-snap-type-x",status:"obsolete",syntax:"none | mandatory | proximity",relevance:0,browsers:["FF39","S9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-type-x"}],description:`The scroll-snap-type-x CSS property defines how strictly snap points are enforced on the horizontal axis of the scroll container in case there is one.

Specifying any precise animations or physics used to enforce those snap points is not covered by this property but instead left up to the user agent.`},{name:"scroll-snap-type-y",status:"obsolete",syntax:"none | mandatory | proximity",relevance:0,browsers:["FF39"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-type-y"}],description:`The scroll-snap-type-y CSS property defines how strictly snap points are enforced on the vertical axis of the scroll container in case there is one.

Specifying any precise animations or physics used to enforce those snap points is not covered by this property but instead left up to the user agent.`},{name:"text-combine-upright",syntax:"none | all | [ digits <integer>? ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-combine-upright"}],description:`The text-combine-upright CSS property specifies the combination of multiple characters into the space of a single character. If the combined text is wider than 1em, the user agent must fit the contents within 1em. The resulting composition is treated as a single upright glyph for layout and decoration. This property only has an effect in vertical writing modes.

This is used to produce an effect that is known as tate-ch\u016B-yoko (\u7E26\u4E2D\u6A2A) in Japanese, or as \u76F4\u66F8\u6A6B\u5411 in Chinese.`},{name:"text-decoration-skip",status:"experimental",syntax:"none | [ objects || [ spaces | [ leading-spaces || trailing-spaces ] ] || edges || box-decoration ]",relevance:52,browsers:["S12.1","C57","O44"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-skip"}],description:"The text-decoration-skip CSS property specifies what parts of the element\u2019s content any text decoration affecting the element must skip over. It controls all text decoration lines drawn by the element and also any text decoration lines drawn by its ancestors."},{name:"text-decoration-skip-ink",syntax:"auto | all | none",relevance:50,browsers:["E79","FF70","S15.4","C64","O50"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-skip-ink"}],description:"The text-decoration-skip-ink CSS property specifies how overlines and underlines are drawn when they pass over glyph ascenders and descenders."},{name:"text-decoration-thickness",syntax:"auto | from-font | <length> | <percentage> ",relevance:50,browsers:["E89","FF70","S12.1","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-thickness"}],description:"The text-decoration-thickness CSS property sets the thickness, or width, of the decoration line that is used on text in an element, such as a line-through, underline, or overline."},{name:"text-emphasis",syntax:"<'text-emphasis-style'> || <'text-emphasis-color'>",relevance:50,browsers:["E79","FF46","S7","C25","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-emphasis"}],description:"The text-emphasis CSS property is a shorthand property for setting text-emphasis-style and text-emphasis-color in one declaration. This property will apply the specified emphasis mark to each character of the element's text, except separator characters, like spaces,  and control characters."},{name:"text-emphasis-color",syntax:"<color>",relevance:50,browsers:["E79","FF46","S7","C25","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-emphasis-color"}],description:"The text-emphasis-color CSS property defines the color used to draw emphasis marks on text being rendered in the HTML document. This value can also be set and reset using the text-emphasis shorthand."},{name:"text-emphasis-position",syntax:"[ over | under ] && [ right | left ]",relevance:50,browsers:["E79","FF46","S7","C25","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-emphasis-position"}],description:"The text-emphasis-position CSS property describes where emphasis marks are drawn at. The effect of emphasis marks on the line height is the same as for ruby text: if there isn't enough place, the line height is increased."},{name:"text-emphasis-style",syntax:"none | [ [ filled | open ] || [ dot | circle | double-circle | triangle | sesame ] ] | <string>",relevance:50,browsers:["E79","FF46","S7","C25","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-emphasis-style"}],description:"The text-emphasis-style CSS property defines the type of emphasis used. It can also be set, and reset, using the text-emphasis shorthand."},{name:"text-size-adjust",status:"experimental",syntax:"none | auto | <percentage>",relevance:57,browsers:["E79","C54","O41"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-size-adjust"}],description:"The text-size-adjust CSS property controls the text inflation algorithm used on some smartphones and tablets. Other browsers will ignore this property."},{name:"text-underline-offset",syntax:"auto | <length> | <percentage> ",relevance:50,browsers:["E87","FF70","S12.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-underline-offset"}],description:"The text-underline-offset CSS property sets the offset distance of an underline text decoration line (applied using text-decoration) from its original position."},{name:"transform-box",syntax:"content-box | border-box | fill-box | stroke-box | view-box",relevance:50,browsers:["E79","FF55","S11","C64","O51"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transform-box"}],description:"The transform-box CSS property defines the layout box to which the transform and transform-origin properties relate."},{name:"translate",syntax:"none | <length-percentage> [ <length-percentage> <length>? ]?",relevance:50,browsers:["FF72","S14.1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/translate"}],description:"The translate CSS property allows you to specify translation transforms individually and independently of the transform property. This maps better to typical user interface usage, and saves having to remember the exact order of transform functions to specify in the transform value."},{name:"white-space",syntax:"normal | pre | nowrap | pre-wrap | pre-line | break-spaces",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/white-space"}],description:"Specifies how whitespace is handled in an element."},{name:"speak-as",syntax:"auto | bullets | numbers | words | spell-out | <counter-style-name>",relevance:50,description:"The speak-as descriptor specifies how a counter symbol constructed with a given @counter-style will be represented in the spoken form. For example, an author can specify a counter symbol to be either spoken as its numerical value or just represented with an audio cue."},{name:"ascent-override",status:"experimental",syntax:"normal | <percentage>",relevance:50,description:"Describes the ascent metric of a font."},{name:"descent-override",status:"experimental",syntax:"normal | <percentage>",relevance:50,description:"Describes the descent metric of a font."},{name:"font-display",status:"experimental",syntax:"[ auto | block | swap | fallback | optional ]",relevance:70,description:"The font-display descriptor determines how a font face is displayed based on whether and when it is downloaded and ready to use."},{name:"line-gap-override",status:"experimental",syntax:"normal | <percentage>",relevance:50,description:"Describes the line-gap metric of a font."},{name:"size-adjust",status:"experimental",syntax:"<percentage>",relevance:50,description:"A multiplier for glyph outlines and metrics of a font."},{name:"bleed",syntax:"auto | <length>",relevance:50,description:"The bleed CSS at-rule descriptor, used with the @page at-rule, specifies the extent of the page bleed area outside the page box. This property only has effect if crop marks are enabled using the marks property."},{name:"marks",syntax:"none | [ crop || cross ]",relevance:50,description:"The marks CSS at-rule descriptor, used with the @page at-rule, adds crop and/or cross marks to the presentation of the document. Crop marks indicate where the page should be cut. Cross marks are used to align sheets."},{name:"syntax",status:"experimental",syntax:"<string>",relevance:50,description:"Specifies the syntax of the custom property registration represented by the @property rule, controlling how the property\u2019s value is parsed at computed value time."},{name:"inherits",status:"experimental",syntax:"true | false",relevance:50,description:"Specifies the inherit flag of the custom property registration represented by the @property rule, controlling whether or not the property inherits by default."},{name:"initial-value",status:"experimental",syntax:"<string>",relevance:50,description:"Specifies the initial value of the custom property registration represented by the @property rule, controlling the property\u2019s initial value."},{name:"max-zoom",syntax:"auto | <number> | <percentage>",relevance:50,description:`The max-zoom CSS descriptor sets the maximum zoom factor of a document defined by the @viewport at-rule. The browser will not zoom in any further than this, whether automatically or at the user's request.

A zoom factor of 1.0 or 100% corresponds to no zooming. Larger values are zoomed in. Smaller values are zoomed out.`},{name:"min-zoom",syntax:"auto | <number> | <percentage>",relevance:50,description:`The min-zoom CSS descriptor sets the minimum zoom factor of a document defined by the @viewport at-rule. The browser will not zoom out any further than this, whether automatically or at the user's request.

A zoom factor of 1.0 or 100% corresponds to no zooming. Larger values are zoomed in. Smaller values are zoomed out.`},{name:"orientation",syntax:"auto | portrait | landscape",relevance:50,description:"The orientation CSS @media media feature can be used to apply styles based on the orientation of the viewport (or the page box, for paged media)."},{name:"user-zoom",syntax:"zoom | fixed",relevance:50,description:"The user-zoom CSS descriptor controls whether or not the user can change the zoom factor of a document defined by @viewport."},{name:"viewport-fit",syntax:"auto | contain | cover",relevance:50,description:"The border-block-style CSS property defines the style of the logical block borders of an element, which maps to a physical border style depending on the element's writing mode, directionality, and text orientation."}],atDirectives:[{name:"@charset",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@charset"}],description:"Defines character set of the document."},{name:"@counter-style",browsers:["E91","FF33","C91","O77"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@counter-style"}],description:"Defines a custom counter style."},{name:"@font-face",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@font-face"}],description:"Allows for linking to fonts that are automatically activated when needed. This permits authors to work around the limitation of 'web-safe' fonts, allowing for consistent rendering independent of the fonts available in a given user's environment."},{name:"@font-feature-values",browsers:["FF34","S9.1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@font-feature-values"}],description:"Defines named values for the indices used to select alternate glyphs for a given font family."},{name:"@import",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@import"}],description:"Includes content of another file."},{name:"@keyframes",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@keyframes"}],description:"Defines set of animation key frames."},{name:"@media",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@media"}],description:"Defines a stylesheet for a particular media type."},{name:"@-moz-document",browsers:["FF1.8"],description:"Gecko-specific at-rule that restricts the style rules contained within it based on the URL of the document."},{name:"@-moz-keyframes",browsers:["FF5"],description:"Defines set of animation key frames."},{name:"@-ms-viewport",browsers:["E","IE10"],description:"Specifies the size, zoom factor, and orientation of the viewport."},{name:"@namespace",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@namespace"}],description:"Declares a prefix and associates it with a namespace name."},{name:"@-o-keyframes",browsers:["O12"],description:"Defines set of animation key frames."},{name:"@-o-viewport",browsers:["O11"],description:"Specifies the size, zoom factor, and orientation of the viewport."},{name:"@page",browsers:["E12","FF19","C2","IE8","O6"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@page"}],description:"Directive defines various page parameters."},{name:"@supports",browsers:["E12","FF22","S9","C28","O12.1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@supports"}],description:"A conditional group rule whose condition tests whether the user agent supports CSS property:value pairs."},{name:"@-webkit-keyframes",browsers:["C","S4"],description:"Defines set of animation key frames."}],pseudoClasses:[{name:":active",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:active"}],description:"Applies while an element is being activated by the user. For example, between the times the user presses the mouse button and releases it."},{name:":any-link",browsers:["E79","FF50","S9","C65","O52"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:any-link"}],description:"Represents an element that acts as the source anchor of a hyperlink. Applies to both visited and unvisited links."},{name:":checked",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:checked"}],description:"Radio and checkbox elements can be toggled by the user. Some menu items are 'checked' when the user selects them. When such elements are toggled 'on' the :checked pseudo-class applies."},{name:":corner-present",browsers:["C","S5"],description:"Non-standard. Indicates whether or not a scrollbar corner is present."},{name:":decrement",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Indicates whether or not the button or track piece will decrement the view\u2019s position when used."},{name:":default",browsers:["E79","FF4","S5","C10","O10"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:default"}],description:"Applies to the one or more UI elements that are the default among a set of similar elements. Typically applies to context menu items, buttons, and select lists/menus."},{name:":disabled",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:disabled"}],description:"Represents user interface elements that are in a disabled state; such elements have a corresponding enabled state."},{name:":double-button",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Applies when both buttons are displayed together at the same end of the scrollbar."},{name:":empty",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:empty"}],description:"Represents an element that has no children at all."},{name:":enabled",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:enabled"}],description:"Represents user interface elements that are in an enabled state; such elements have a corresponding disabled state."},{name:":end",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Indicates whether the object is placed after the thumb."},{name:":first",browsers:["E12","S6","C18","IE8","O9.2"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:first"}],description:"When printing double-sided documents, the page boxes on left and right pages may be different. This can be expressed through CSS pseudo-classes defined in the  page context."},{name:":first-child",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:first-child"}],description:"Same as :nth-child(1). Represents an element that is the first child of some other element."},{name:":first-of-type",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:first-of-type"}],description:"Same as :nth-of-type(1). Represents an element that is the first sibling of its type in the list of children of its parent element."},{name:":focus",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:focus"}],description:"Applies while an element has the focus (accepts keyboard or mouse events, or other forms of input)."},{name:":fullscreen",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:fullscreen"}],description:"Matches any element that has its fullscreen flag set."},{name:":future",browsers:["S7"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:future"}],description:"Represents any element that is defined to occur entirely after a :current element."},{name:":horizontal",browsers:["C","S5"],description:"Non-standard. Applies to any scrollbar pieces that have a horizontal orientation."},{name:":host",browsers:["E79","FF63","S10","C54","O41"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:host"}],description:"When evaluated in the context of a shadow tree, matches the shadow tree\u2019s host element."},{name:":host()",browsers:["C35","O22"],description:"When evaluated in the context of a shadow tree, it matches the shadow tree\u2019s host element if the host element, in its normal context, matches the selector argument."},{name:":host-context()",browsers:["C35","O22"],description:"Tests whether there is an ancestor, outside the shadow tree, which matches a particular selector."},{name:":hover",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:hover"}],description:"Applies while the user designates an element with a pointing device, but does not necessarily activate it. For example, a visual user agent could apply this pseudo-class when the cursor (mouse pointer) hovers over a box generated by the element."},{name:":increment",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Indicates whether or not the button or track piece will increment the view\u2019s position when used."},{name:":indeterminate",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:indeterminate"}],description:"Applies to UI elements whose value is in an indeterminate state."},{name:":in-range",browsers:["E13","FF29","S5.1","C10","O11"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:in-range"}],description:"Used in conjunction with the min and max attributes, whether on a range input, a number field, or any other types that accept those attributes."},{name:":invalid",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:invalid"}],description:"An element is :valid or :invalid when it is, respectively, valid or invalid with respect to data validity semantics defined by a different specification."},{name:":lang()",browsers:["E","C","FF1","IE8","O8","S3"],description:"Represents an element that is in language specified."},{name:":last-child",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:last-child"}],description:"Same as :nth-last-child(1). Represents an element that is the last child of some other element."},{name:":last-of-type",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:last-of-type"}],description:"Same as :nth-last-of-type(1). Represents an element that is the last sibling of its type in the list of children of its parent element."},{name:":left",browsers:["E12","S5.1","C6","IE8","O9.2"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:left"}],description:"When printing double-sided documents, the page boxes on left and right pages may be different. This can be expressed through CSS pseudo-classes defined in the  page context."},{name:":link",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:link"}],description:"Applies to links that have not yet been visited."},{name:":matches()",browsers:["S9"],description:"Takes a selector list as its argument. It represents an element that is represented by its argument."},{name:":-moz-any()",browsers:["FF4"],description:"Represents an element that is represented by the selector list passed as its argument. Standardized as :matches()."},{name:":-moz-any-link",browsers:["FF1"],description:"Represents an element that acts as the source anchor of a hyperlink. Applies to both visited and unvisited links."},{name:":-moz-broken",browsers:["FF3"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:-moz-broken"}],description:"Non-standard. Matches elements representing broken images."},{name:":-moz-drag-over",browsers:["FF1"],description:"Non-standard. Matches elements when a drag-over event applies to it."},{name:":-moz-first-node",browsers:["FF1"],description:"Non-standard. Represents an element that is the first child node of some other element."},{name:":-moz-focusring",browsers:["FF4"],description:"Non-standard. Matches an element that has focus and focus ring drawing is enabled in the browser."},{name:":-moz-full-screen",browsers:["FF9"],description:"Matches any element that has its fullscreen flag set. Standardized as :fullscreen."},{name:":-moz-last-node",browsers:["FF1"],description:"Non-standard. Represents an element that is the last child node of some other element."},{name:":-moz-loading",browsers:["FF3"],description:"Non-standard. Matches elements, such as images, that haven\u2019t started loading yet."},{name:":-moz-only-whitespace",browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:-moz-only-whitespace"}],description:"The same as :empty, except that it additionally matches elements that only contain code points affected by whitespace processing. Standardized as :blank."},{name:":-moz-placeholder",browsers:["FF4"],description:"Deprecated. Represents placeholder text in an input field. Use ::-moz-placeholder for Firefox 19+."},{name:":-moz-submit-invalid",browsers:["FF88"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:-moz-submit-invalid"}],description:"Non-standard. Represents any submit button when the contents of the associated form are not valid."},{name:":-moz-suppressed",browsers:["FF3"],description:"Non-standard. Matches elements representing images that have been blocked from loading."},{name:":-moz-ui-invalid",browsers:["FF4"],description:"Non-standard. Represents any validated form element whose value isn't valid "},{name:":-moz-ui-valid",browsers:["FF4"],description:"Non-standard. Represents any validated form element whose value is valid "},{name:":-moz-user-disabled",browsers:["FF3"],description:"Non-standard. Matches elements representing images that have been disabled due to the user\u2019s preferences."},{name:":-moz-window-inactive",browsers:["FF4"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:-moz-window-inactive"}],description:"Non-standard. Matches elements in an inactive window."},{name:":-ms-fullscreen",browsers:["IE11"],description:"Matches any element that has its fullscreen flag set."},{name:":-ms-input-placeholder",browsers:["IE10"],description:"Represents placeholder text in an input field. Note: for Edge use the pseudo-element ::-ms-input-placeholder. Standardized as ::placeholder."},{name:":-ms-keyboard-active",browsers:["IE10"],description:"Windows Store apps only. Applies one or more styles to an element when it has focus and the user presses the space bar."},{name:":-ms-lang()",browsers:["E","IE10"],description:"Represents an element that is in the language specified. Accepts a comma separated list of language tokens."},{name:":no-button",browsers:["C","S5"],description:"Non-standard. Applies to track pieces. Applies when there is no button at that end of the track."},{name:":not()",browsers:["E","C","FF1","IE9","O9.5","S2"],description:"The negation pseudo-class, :not(X), is a functional notation taking a simple selector (excluding the negation pseudo-class itself) as an argument. It represents an element that is not represented by its argument."},{name:":nth-child()",browsers:["E","C","FF3.5","IE9","O9.5","S3.1"],description:"Represents an element that has an+b-1 siblings before it in the document tree, for any positive integer or zero value of n, and has a parent element."},{name:":nth-last-child()",browsers:["E","C","FF3.5","IE9","O9.5","S3.1"],description:"Represents an element that has an+b-1 siblings after it in the document tree, for any positive integer or zero value of n, and has a parent element."},{name:":nth-last-of-type()",browsers:["E","C","FF3.5","IE9","O9.5","S3.1"],description:"Represents an element that has an+b-1 siblings with the same expanded element name after it in the document tree, for any zero or positive integer value of n, and has a parent element."},{name:":nth-of-type()",browsers:["E","C","FF3.5","IE9","O9.5","S3.1"],description:"Represents an element that has an+b-1 siblings with the same expanded element name before it in the document tree, for any zero or positive integer value of n, and has a parent element."},{name:":only-child",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:only-child"}],description:"Represents an element that has a parent element and whose parent element has no other element children. Same as :first-child:last-child or :nth-child(1):nth-last-child(1), but with a lower specificity."},{name:":only-of-type",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:only-of-type"}],description:"Matches every element that is the only child of its type, of its parent. Same as :first-of-type:last-of-type or :nth-of-type(1):nth-last-of-type(1), but with a lower specificity."},{name:":optional",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:optional"}],description:"A form element is :required or :optional if a value for it is, respectively, required or optional before the form it belongs to is submitted. Elements that are not form elements are neither required nor optional."},{name:":out-of-range",browsers:["E13","FF29","S5.1","C10","O11"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:out-of-range"}],description:"Used in conjunction with the min and max attributes, whether on a range input, a number field, or any other types that accept those attributes."},{name:":past",browsers:["S7"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:past"}],description:"Represents any element that is defined to occur entirely prior to a :current element."},{name:":read-only",browsers:["E13","FF78","S4","C1","O9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:read-only"}],description:"An element whose contents are not user-alterable is :read-only. However, elements whose contents are user-alterable (such as text input fields) are considered to be in a :read-write state. In typical documents, most elements are :read-only."},{name:":read-write",browsers:["E13","FF78","S4","C1","O9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:read-write"}],description:"An element whose contents are not user-alterable is :read-only. However, elements whose contents are user-alterable (such as text input fields) are considered to be in a :read-write state. In typical documents, most elements are :read-only."},{name:":required",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:required"}],description:"A form element is :required or :optional if a value for it is, respectively, required or optional before the form it belongs to is submitted. Elements that are not form elements are neither required nor optional."},{name:":right",browsers:["E12","S5.1","C6","IE8","O9.2"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:right"}],description:"When printing double-sided documents, the page boxes on left and right pages may be different. This can be expressed through CSS pseudo-classes defined in the  page context."},{name:":root",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:root"}],description:"Represents an element that is the root of the document. In HTML 4, this is always the HTML element."},{name:":scope",browsers:["E79","FF32","S7","C27","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:scope"}],description:"Represents any element that is in the contextual reference element set."},{name:":single-button",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Applies when both buttons are displayed separately at either end of the scrollbar."},{name:":start",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Indicates whether the object is placed before the thumb."},{name:":target",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:target"}],description:"Some URIs refer to a location within a resource. This kind of URI ends with a 'number sign' (#) followed by an anchor identifier (called the fragment identifier)."},{name:":valid",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:valid"}],description:"An element is :valid or :invalid when it is, respectively, valid or invalid with respect to data validity semantics defined by a different specification."},{name:":vertical",browsers:["C","S5"],description:"Non-standard. Applies to any scrollbar pieces that have a vertical orientation."},{name:":visited",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:visited"}],description:"Applies once the link has been visited by the user."},{name:":-webkit-any()",browsers:["C","S5"],description:"Represents an element that is represented by the selector list passed as its argument. Standardized as :matches()."},{name:":-webkit-full-screen",browsers:["C","S6"],description:"Matches any element that has its fullscreen flag set. Standardized as :fullscreen."},{name:":window-inactive",browsers:["C","S3"],description:"Non-standard. Applies to all scrollbar pieces. Indicates whether or not the window containing the scrollbar is currently active."},{name:":current",status:"experimental",description:"The :current CSS pseudo-class selector is a time-dimensional pseudo-class that represents the element, or an ancestor of the element, that is currently being displayed"},{name:":blank",status:"experimental",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:blank"}],description:"The :blank CSS pseudo-class selects empty user input elements (eg. <input> or <textarea>)."},{name:":defined",status:"experimental",browsers:["E79","FF63","S10","C54","O41"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:defined"}],description:"The :defined CSS pseudo-class represents any element that has been defined. This includes any standard element built in to the browser, and custom elements that have been successfully defined (i.e. with the CustomElementRegistry.define() method)."},{name:":dir",browsers:["FF49"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:dir"}],description:"The :dir() CSS pseudo-class matches elements based on the directionality of the text contained in them."},{name:":focus-visible",browsers:["E86","FF85","S15.4","C86","O72"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:focus-visible"}],description:"The :focus-visible pseudo-class applies while an element matches the :focus pseudo-class and the UA determines via heuristics that the focus should be made evident on the element."},{name:":focus-within",browsers:["E79","FF52","S10.1","C60","O47"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:focus-within"}],description:"The :focus-within pseudo-class applies to any element for which the :focus pseudo class applies as well as to an element whose descendant in the flat tree (including non-element nodes, such as text nodes) matches the conditions for matching :focus."},{name:":has",status:"experimental",browsers:["S15.4"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:has"}],description:":The :has() CSS pseudo-class represents an element if any of the selectors passed as parameters (relative to the :scope of the given element), match at least one element."},{name:":is",status:"experimental",browsers:["E88","FF78","S14","C88","O74"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:is"}],description:"The :is() CSS pseudo-class function takes a selector list as its argument, and selects any element that can be selected by one of the selectors in that list. This is useful for writing large selectors in a more compact form."},{name:":local-link",status:"experimental",description:"The :local-link CSS pseudo-class represents an link to the same document"},{name:":nth-col",status:"experimental",description:"The :nth-col() CSS pseudo-class is designed for tables and grids. It accepts the An+B notation such as used with the :nth-child selector, using this to target every nth column. "},{name:":nth-last-col",status:"experimental",description:"The :nth-last-col() CSS pseudo-class is designed for tables and grids. It accepts the An+B notation such as used with the :nth-child selector, using this to target every nth column before it, therefore counting back from the end of the set of columns."},{name:":paused",status:"experimental",description:"The :paused CSS pseudo-class selector is a resource state pseudo-class that will match an audio, video, or similar resource that is capable of being \u201Cplayed\u201D or \u201Cpaused\u201D, when that element is \u201Cpaused\u201D."},{name:":placeholder-shown",status:"experimental",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:placeholder-shown"}],description:"The :placeholder-shown CSS pseudo-class represents any <input> or <textarea> element that is currently displaying placeholder text."},{name:":playing",status:"experimental",description:"The :playing CSS pseudo-class selector is a resource state pseudo-class that will match an audio, video, or similar resource that is capable of being \u201Cplayed\u201D or \u201Cpaused\u201D, when that element is \u201Cplaying\u201D. "},{name:":target-within",status:"experimental",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:target-within"}],description:"The :target-within CSS pseudo-class represents an element that is a target element or contains an element that is a target. A target element is a unique element with an id matching the URL's fragment."},{name:":user-invalid",status:"experimental",browsers:["FF88"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:user-invalid"}],description:"The :user-invalid CSS pseudo-class represents any validated form element whose value isn't valid based on their validation constraints, after the user has interacted with it."},{name:":user-valid",status:"experimental",browsers:["FF88"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:user-valid"}],description:"The :user-valid CSS pseudo-class represents any validated form element whose value validates correctly based on its validation constraints. However, unlike :valid it only matches once the user has interacted with it."},{name:":where",status:"experimental",browsers:["E88","FF78","S14","C88","O74"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:where"}],description:"The :where() CSS pseudo-class function takes a selector list as its argument, and selects any element that can be selected by one of the selectors in that list."},{name:":picture-in-picture",status:"experimental",description:"The :picture-in-picture CSS pseudo-class matches the element which is currently in picture-in-picture mode."}],pseudoElements:[{name:"::after",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::after"}],description:"Represents a styleable child pseudo-element immediately after the originating element\u2019s actual content."},{name:"::backdrop",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::backdrop"}],description:"Used to create a backdrop that hides the underlying document for an element in a top layer (such as an element that is displayed fullscreen)."},{name:"::before",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::before"}],description:"Represents a styleable child pseudo-element immediately before the originating element\u2019s actual content."},{name:"::content",browsers:["C35","O22"],description:"Deprecated. Matches the distribution list itself, on elements that have one. Use ::slotted for forward compatibility."},{name:"::cue",browsers:["E79","FF55","S7","C26","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::cue"}]},{name:"::cue()",browsers:["C","O16","S6"]},{name:"::cue-region",browsers:["C","O16","S6"]},{name:"::cue-region()",browsers:["C","O16","S6"]},{name:"::first-letter",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::first-letter"}],description:"Represents the first letter of an element, if it is not preceded by any other content (such as images or inline tables) on its line."},{name:"::first-line",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::first-line"}],description:"Describes the contents of the first formatted line of its originating element."},{name:"::-moz-focus-inner",browsers:["FF4"]},{name:"::-moz-focus-outer",browsers:["FF4"]},{name:"::-moz-list-bullet",browsers:["FF1"],description:"Used to style the bullet of a list element. Similar to the standardized ::marker."},{name:"::-moz-list-number",browsers:["FF1"],description:"Used to style the numbers of a list element. Similar to the standardized ::marker."},{name:"::-moz-placeholder",browsers:["FF19"],description:"Represents placeholder text in an input field"},{name:"::-moz-progress-bar",browsers:["FF9"],description:"Represents the bar portion of a progress bar."},{name:"::-moz-selection",browsers:["FF1"],description:"Represents the portion of a document that has been highlighted by the user."},{name:"::-ms-backdrop",browsers:["IE11"],description:"Used to create a backdrop that hides the underlying document for an element in a top layer (such as an element that is displayed fullscreen)."},{name:"::-ms-browse",browsers:["E","IE10"],description:"Represents the browse button of an input type=file control."},{name:"::-ms-check",browsers:["E","IE10"],description:"Represents the check of a checkbox or radio button input control."},{name:"::-ms-clear",browsers:["E","IE10"],description:"Represents the clear button of a text input control"},{name:"::-ms-expand",browsers:["E","IE10"],description:"Represents the drop-down button of a select control."},{name:"::-ms-fill",browsers:["E","IE10"],description:"Represents the bar portion of a progress bar."},{name:"::-ms-fill-lower",browsers:["E","IE10"],description:"Represents the portion of the slider track from its smallest value up to the value currently selected by the thumb. In a left-to-right layout, this is the portion of the slider track to the left of the thumb."},{name:"::-ms-fill-upper",browsers:["E","IE10"],description:"Represents the portion of the slider track from the value currently selected by the thumb up to the slider's largest value. In a left-to-right layout, this is the portion of the slider track to the right of the thumb."},{name:"::-ms-reveal",browsers:["E","IE10"],description:"Represents the password reveal button of an input type=password control."},{name:"::-ms-thumb",browsers:["E","IE10"],description:"Represents the portion of range input control (also known as a slider control) that the user drags."},{name:"::-ms-ticks-after",browsers:["E","IE10"],description:"Represents the tick marks of a slider that begin just after the thumb and continue up to the slider's largest value. In a left-to-right layout, these are the ticks to the right of the thumb."},{name:"::-ms-ticks-before",browsers:["E","IE10"],description:"Represents the tick marks of a slider that represent its smallest values up to the value currently selected by the thumb. In a left-to-right layout, these are the ticks to the left of the thumb."},{name:"::-ms-tooltip",browsers:["E","IE10"],description:"Represents the tooltip of a slider (input type=range)."},{name:"::-ms-track",browsers:["E","IE10"],description:"Represents the track of a slider."},{name:"::-ms-value",browsers:["E","IE10"],description:"Represents the content of a text or password input control, or a select control."},{name:"::selection",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::selection"}],description:"Represents the portion of a document that has been highlighted by the user."},{name:"::shadow",browsers:["C35","O22"],description:"Matches the shadow root if an element has a shadow tree."},{name:"::-webkit-file-upload-button",browsers:["C","O","S6"]},{name:"::-webkit-inner-spin-button",browsers:["E79","S5","C6","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-inner-spin-button"}]},{name:"::-webkit-input-placeholder",browsers:["C","S4"]},{name:"::-webkit-keygen-select",browsers:["C","O","S6"]},{name:"::-webkit-meter-bar",browsers:["E79","S5.1","C12","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-bar"}]},{name:"::-webkit-meter-even-less-good-value",browsers:["E79","S5.1","C12","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-even-less-good-value"}]},{name:"::-webkit-meter-optimum-value",browsers:["E79","S5.1","C12","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-optimum-value"}]},{name:"::-webkit-meter-suboptimum-value",browsers:["E79","S5.1","C12","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-suboptimum-value"}]},{name:"::-webkit-outer-spin-button",browsers:["S5","C6"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-outer-spin-button"}]},{name:"::-webkit-progress-bar",browsers:["E79","S7","C25","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-progress-bar"}]},{name:"::-webkit-progress-inner-element",browsers:["E79","S7","C23","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-progress-inner-element"}]},{name:"::-webkit-progress-value",browsers:["E79","S7","C25","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-progress-value"}]},{name:"::-webkit-resizer",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-button",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-corner",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-thumb",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-track",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-track-piece",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-search-cancel-button",browsers:["E79","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-search-cancel-button"}]},{name:"::-webkit-search-decoration",browsers:["C","S4"]},{name:"::-webkit-search-results-button",browsers:["E79","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-search-results-button"}]},{name:"::-webkit-search-results-decoration",browsers:["C","S4"]},{name:"::-webkit-slider-runnable-track",browsers:["C","O","S6"]},{name:"::-webkit-slider-thumb",browsers:["C","O","S6"]},{name:"::-webkit-textfield-decoration-container",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-arrow",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-arrow-clipper",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-heading",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-message",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-text-block",browsers:["C","O","S6"]},{name:"::target-text",status:"experimental",browsers:["E89","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::target-text"}],description:"The ::target-text CSS pseudo-element represents the text that has been scrolled to if the browser supports scroll-to-text fragments. It allows authors to choose how to highlight that section of text."},{name:"::-moz-range-progress",status:"nonstandard",browsers:["FF22"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-moz-range-progress"}],description:'The ::-moz-range-progress CSS pseudo-element is a Mozilla extension that represents the lower portion of the track (i.e., groove) in which the indicator slides in an <input> of type="range". This portion corresponds to values lower than the value currently selected by the thumb (i.e., virtual knob).'},{name:"::-moz-range-thumb",status:"nonstandard",browsers:["FF21"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-moz-range-thumb"}],description:`The ::-moz-range-thumb CSS pseudo-element is a Mozilla extension that represents the thumb (i.e., virtual knob) of an <input> of type="range". The user can move the thumb along the input's track to alter its numerical value.`},{name:"::-moz-range-track",status:"nonstandard",browsers:["FF21"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-moz-range-track"}],description:'The ::-moz-range-track CSS pseudo-element is a Mozilla extension that represents the track (i.e., groove) in which the indicator slides in an <input> of type="range".'},{name:"::-webkit-progress-inner-value",status:"nonstandard",description:`The ::-webkit-progress-value CSS pseudo-element represents the filled-in portion of the bar of a <progress> element. It is a child of the ::-webkit-progress-bar pseudo-element.

In order to let ::-webkit-progress-value take effect, -webkit-appearance needs to be set to none on the <progress> element.`},{name:"::grammar-error",status:"experimental",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::grammar-error"}],description:"The ::grammar-error CSS pseudo-element represents a text segment which the user agent has flagged as grammatically incorrect."},{name:"::marker",browsers:["E86","FF68","S11.1","C86","O72"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::marker"}],description:"The ::marker CSS pseudo-element selects the marker box of a list item, which typically contains a bullet or number. It works on any element or pseudo-element set to display: list-item, such as the <li> and <summary> elements."},{name:"::part",status:"experimental",browsers:["E79","FF72","S13.1","C73","O60"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::part"}],description:"The ::part CSS pseudo-element represents any element within a shadow tree that has a matching part attribute."},{name:"::placeholder",browsers:["E79","FF51","S10.1","C57","O44"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::placeholder"}],description:"The ::placeholder CSS pseudo-element represents the placeholder text of a form element."},{name:"::slotted",browsers:["E79","FF63","S10","C50","O37"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::slotted"}],description:"The :slotted() CSS pseudo-element represents any element that has been placed into a slot inside an HTML template."},{name:"::spelling-error",status:"experimental",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::spelling-error"}],description:"The ::spelling-error CSS pseudo-element represents a text segment which the user agent has flagged as incorrectly spelled."}]};var Un=function(){function n(e){this._properties=[],this._atDirectives=[],this._pseudoClasses=[],this._pseudoElements=[],this.addData(e)}return n.prototype.provideProperties=function(){return this._properties},n.prototype.provideAtDirectives=function(){return this._atDirectives},n.prototype.providePseudoClasses=function(){return this._pseudoClasses},n.prototype.providePseudoElements=function(){return this._pseudoElements},n.prototype.addData=function(e){if(Array.isArray(e.properties))for(var t=0,r=e.properties;t<r.length;t++){var i=r[t];Ya(i)&&this._properties.push(i)}if(Array.isArray(e.atDirectives))for(var o=0,s=e.atDirectives;o<s.length;o++){var i=s[o];Qa(i)&&this._atDirectives.push(i)}if(Array.isArray(e.pseudoClasses))for(var a=0,l=e.pseudoClasses;a<l.length;a++){var i=l[a];Za(i)&&this._pseudoClasses.push(i)}if(Array.isArray(e.pseudoElements))for(var c=0,h=e.pseudoElements;c<h.length;c++){var i=h[c];el(i)&&this._pseudoElements.push(i)}},n}();function Ya(n){return typeof n.name=="string"}function Qa(n){return typeof n.name=="string"}function Za(n){return typeof n.name=="string"}function el(n){return typeof n.name=="string"}var jn=function(){function n(e){this.dataProviders=[],this._propertySet={},this._atDirectiveSet={},this._pseudoClassSet={},this._pseudoElementSet={},this._properties=[],this._atDirectives=[],this._pseudoClasses=[],this._pseudoElements=[],this.setDataProviders(e?.useDefaultDataProvider!==!1,e?.customDataProviders||[])}return n.prototype.setDataProviders=function(e,t){var r;this.dataProviders=[],e&&this.dataProviders.push(new Un(Br)),(r=this.dataProviders).push.apply(r,t),this.collectData()},n.prototype.collectData=function(){var e=this;this._propertySet={},this._atDirectiveSet={},this._pseudoClassSet={},this._pseudoElementSet={},this.dataProviders.forEach(function(t){t.provideProperties().forEach(function(r){e._propertySet[r.name]||(e._propertySet[r.name]=r)}),t.provideAtDirectives().forEach(function(r){e._atDirectiveSet[r.name]||(e._atDirectiveSet[r.name]=r)}),t.providePseudoClasses().forEach(function(r){e._pseudoClassSet[r.name]||(e._pseudoClassSet[r.name]=r)}),t.providePseudoElements().forEach(function(r){e._pseudoElementSet[r.name]||(e._pseudoElementSet[r.name]=r)})}),this._properties=Bt(this._propertySet),this._atDirectives=Bt(this._atDirectiveSet),this._pseudoClasses=Bt(this._pseudoClassSet),this._pseudoElements=Bt(this._pseudoElementSet)},n.prototype.getProperty=function(e){return this._propertySet[e]},n.prototype.getAtDirective=function(e){return this._atDirectiveSet[e]},n.prototype.getPseudoClass=function(e){return this._pseudoClassSet[e]},n.prototype.getPseudoElement=function(e){return this._pseudoElementSet[e]},n.prototype.getProperties=function(){return this._properties},n.prototype.getAtDirectives=function(){return this._atDirectives},n.prototype.getPseudoClasses=function(){return this._pseudoClasses},n.prototype.getPseudoElements=function(){return this._pseudoElements},n.prototype.isKnownProperty=function(e){return e.toLowerCase()in this._propertySet},n.prototype.isStandardProperty=function(e){return this.isKnownProperty(e)&&(!this._propertySet[e.toLowerCase()].status||this._propertySet[e.toLowerCase()].status==="standard")},n}();function is(n,e,t){function r(o){for(var s=i(o),a=void 0,l=s.length-1;l>=0;l--)a=gt.create(W.create(n.positionAt(s[l][0]),n.positionAt(s[l][1])),a);return a||(a=gt.create(W.create(o,o))),a}return e.map(r);function i(o){var s=n.offsetAt(o),a=t.findChildAtOffset(s,!0);if(!a)return[];for(var l=[];a;){if(a.parent&&a.offset===a.parent.offset&&a.end===a.parent.end){a=a.parent;continue}a.type===u.Declarations&&s>a.offset&&s<a.end&&l.push([a.offset+1,a.end-1]),l.push([a.offset,a.end]),a=a.parent}return l}}var tl=function(){var n=function(e,t){return n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,i){r.__proto__=i}||function(r,i){for(var o in i)Object.prototype.hasOwnProperty.call(i,o)&&(r[o]=i[o])},n(e,t)};return function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");n(e,t);function r(){this.constructor=e}e.prototype=t===null?Object.create(t):(r.prototype=t.prototype,new r)}}(),nl=function(n,e,t,r){function i(o){return o instanceof t?o:new t(function(s){s(o)})}return new(t||(t=Promise))(function(o,s){function a(h){try{c(r.next(h))}catch(p){s(p)}}function l(h){try{c(r.throw(h))}catch(p){s(p)}}function c(h){h.done?o(h.value):i(h.value).then(a,l)}c((r=r.apply(n,e||[])).next())})},rl=function(n,e){var t={label:0,sent:function(){if(o[0]&1)throw o[1];return o[1]},trys:[],ops:[]},r,i,o,s;return s={next:a(0),throw:a(1),return:a(2)},typeof Symbol=="function"&&(s[Symbol.iterator]=function(){return this}),s;function a(c){return function(h){return l([c,h])}}function l(c){if(r)throw new TypeError("Generator is already executing.");for(;t;)try{if(r=1,i&&(o=c[0]&2?i.return:c[0]?i.throw||((o=i.return)&&o.call(i),0):i.next)&&!(o=o.call(i,c[1])).done)return o;switch(i=0,o&&(c=[c[0]&2,o.value]),c[0]){case 0:case 1:o=c;break;case 4:return t.label++,{value:c[1],done:!1};case 5:t.label++,i=c[1],c=[0];continue;case 7:c=t.ops.pop(),t.trys.pop();continue;default:if(o=t.trys,!(o=o.length>0&&o[o.length-1])&&(c[0]===6||c[0]===2)){t=0;continue}if(c[0]===3&&(!o||c[1]>o[0]&&c[1]<o[3])){t.label=c[1];break}if(c[0]===6&&t.label<o[1]){t.label=o[1],o=c;break}if(o&&t.label<o[2]){t.label=o[2],t.ops.push(c);break}o[2]&&t.ops.pop(),t.trys.pop();continue}c=e.call(n,t)}catch(h){c=[6,h],i=0}finally{r=o=0}if(c[0]&5)throw c[1];return{value:c[0]?c[1]:void 0,done:!0}}},os=function(n){tl(e,n);function e(t){return n.call(this,t,!0)||this}return e.prototype.isRawStringDocumentLinkNode=function(t){return n.prototype.isRawStringDocumentLinkNode.call(this,t)||t.type===u.Use||t.type===u.Forward},e.prototype.resolveRelativeReference=function(t,r,i,o){return nl(this,void 0,void 0,function(){function s(m){if(m.path!==""&&!(m.path.endsWith(".scss")||m.path.endsWith(".css"))){if(m.path.endsWith("/"))return[m.with({path:m.path+"index.scss"}).toString(),m.with({path:m.path+"_index.scss"}).toString()];var g=m.path.split("/"),w=g[g.length-1],x=m.path.slice(0,-w.length);if(w.startsWith("_"))return m.path.endsWith(".scss")?void 0:[m.with({path:m.path+".scss"}).toString()];var y=w+".scss",D=function(ue){return m.with({path:x+ue}).toString()},M=D(y),z=D("_"+y),P=D(y.slice(0,-5)+"/index.scss"),L=D(y.slice(0,-5)+"/_index.scss"),$=D(y.slice(0,-5)+".css");return[M,z,P,L,$]}}var a,l,c,h,p;return rl(this,function(m){switch(m.label){case 0:return q(t,"sass:")?[2,void 0]:[4,n.prototype.resolveRelativeReference.call(this,t,r,i,o)];case 1:if(a=m.sent(),!(this.fileSystemProvider&&a&&o))return[3,8];l=Kt.parse(a),m.label=2;case 2:if(m.trys.push([2,7,,8]),c=s(l),!c)return[3,6];h=0,m.label=3;case 3:return h<c.length?[4,this.fileExists(c[h])]:[3,6];case 4:if(m.sent())return[2,c[h]];m.label=5;case 5:return h++,[3,3];case 6:return[3,8];case 7:return p=m.sent(),[3,8];case 8:return[2,a]}})})},e}(Yt);function ss(n){return new Un(n)}function $r(n,e,t,r,i,o,s){return{configure:function(a){o.configure(a),e.configure(a?.completion),t.configure(a?.hover)},setDataProviders:s.setDataProviders.bind(s),doValidation:o.doValidation.bind(o),parseStylesheet:n.parseStylesheet.bind(n),doComplete:e.doComplete.bind(e),doComplete2:e.doComplete2.bind(e),setCompletionParticipants:e.setCompletionParticipants.bind(e),doHover:t.doHover.bind(t),format:rs,findDefinition:r.findDefinition.bind(r),findReferences:r.findReferences.bind(r),findDocumentHighlights:r.findDocumentHighlights.bind(r),findDocumentLinks:r.findDocumentLinks.bind(r),findDocumentLinks2:r.findDocumentLinks2.bind(r),findDocumentSymbols:r.findDocumentSymbols.bind(r),doCodeActions:i.doCodeActions.bind(i),doCodeActions2:i.doCodeActions2.bind(i),findDocumentColors:r.findDocumentColors.bind(r),getColorPresentations:r.getColorPresentations.bind(r),doRename:r.doRename.bind(r),getFoldingRanges:Yo,getSelectionRanges:is}}var qr={};function as(n){n===void 0&&(n=qr);var e=new jn(n);return $r(new bt,new yt(null,n,e),new In(n&&n.clientCapabilities,e),new Yt(n&&n.fileSystemProvider,!1),new Mn(e),new Pn(e),e)}function ls(n){n===void 0&&(n=qr);var e=new jn(n);return $r(new $o,new Ko(n,e),new In(n&&n.clientCapabilities,e),new os(n&&n.fileSystemProvider),new Mn(e),new Pn(e),e)}function cs(n){n===void 0&&(n=qr);var e=new jn(n);return $r(new Ho,new Jo(n,e),new In(n&&n.clientCapabilities,e),new Yt(n&&n.fileSystemProvider,!0),new Mn(e),new Pn(e),e)}var Vn=class{_ctx;_languageService;_languageSettings;_languageId;constructor(e,t){this._ctx=e,this._languageSettings=t.options,this._languageId=t.languageId;let r=t.options.data,i=r?.useDefaultDataProvider,o=[];if(r?.dataProviders)for(let a in r.dataProviders)o.push(ss(r.dataProviders[a]));let s={customDataProviders:o,useDefaultDataProvider:i};switch(this._languageId){case"css":this._languageService=as(s);break;case"less":this._languageService=cs(s);break;case"scss":this._languageService=ls(s);break;default:throw new Error("Invalid language id: "+this._languageId)}this._languageService.configure(this._languageSettings)}async doValidation(e){let t=this._getTextDocument(e);if(t){let r=this._languageService.parseStylesheet(t),i=this._languageService.doValidation(t,r);return Promise.resolve(i)}return Promise.resolve([])}async doComplete(e,t){let r=this._getTextDocument(e);if(!r)return null;let i=this._languageService.parseStylesheet(r),o=this._languageService.doComplete(r,t,i);return Promise.resolve(o)}async doHover(e,t){let r=this._getTextDocument(e);if(!r)return null;let i=this._languageService.parseStylesheet(r),o=this._languageService.doHover(r,t,i);return Promise.resolve(o)}async findDefinition(e,t){let r=this._getTextDocument(e);if(!r)return null;let i=this._languageService.parseStylesheet(r),o=this._languageService.findDefinition(r,t,i);return Promise.resolve(o)}async findReferences(e,t){let r=this._getTextDocument(e);if(!r)return[];let i=this._languageService.parseStylesheet(r),o=this._languageService.findReferences(r,t,i);return Promise.resolve(o)}async findDocumentHighlights(e,t){let r=this._getTextDocument(e);if(!r)return[];let i=this._languageService.parseStylesheet(r),o=this._languageService.findDocumentHighlights(r,t,i);return Promise.resolve(o)}async findDocumentSymbols(e){let t=this._getTextDocument(e);if(!t)return[];let r=this._languageService.parseStylesheet(t),i=this._languageService.findDocumentSymbols(t,r);return Promise.resolve(i)}async doCodeActions(e,t,r){let i=this._getTextDocument(e);if(!i)return[];let o=this._languageService.parseStylesheet(i),s=this._languageService.doCodeActions(i,t,r,o);return Promise.resolve(s)}async findDocumentColors(e){let t=this._getTextDocument(e);if(!t)return[];let r=this._languageService.parseStylesheet(t),i=this._languageService.findDocumentColors(t,r);return Promise.resolve(i)}async getColorPresentations(e,t,r){let i=this._getTextDocument(e);if(!i)return[];let o=this._languageService.parseStylesheet(i),s=this._languageService.getColorPresentations(i,o,t,r);return Promise.resolve(s)}async getFoldingRanges(e,t){let r=this._getTextDocument(e);if(!r)return[];let i=this._languageService.getFoldingRanges(r,t);return Promise.resolve(i)}async getSelectionRanges(e,t){let r=this._getTextDocument(e);if(!r)return[];let i=this._languageService.parseStylesheet(r),o=this._languageService.getSelectionRanges(r,t,i);return Promise.resolve(o)}async doRename(e,t,r){let i=this._getTextDocument(e);if(!i)return null;let o=this._languageService.parseStylesheet(i),s=this._languageService.doRename(i,t,r,o);return Promise.resolve(s)}async format(e,t,r){let i=this._getTextDocument(e);if(!i)return[];let o={...this._languageSettings.format,...r},s=this._languageService.format(i,t,o);return Promise.resolve(s)}_getTextDocument(e){let t=this._ctx.getMirrorModels();for(let r of t)if(r.uri.toString()===e)return Ut.create(e,this._languageId,r.version,r.getValue());return null}};function ol(n,e){return new Vn(n,e)}return fs(sl);})();
return moduleExports;
});
