"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.GraphQLWorker = void 0;
const graphql_language_service_1 = require("graphql-language-service");
const LanguageService_1 = require("./LanguageService");
const utils_1 = require("./utils");
class GraphQLWorker {
    constructor(ctx, createData) {
        this._ctx = ctx;
        this._languageService = new LanguageService_1.LanguageService(createData.languageConfig);
        this._formattingOptions = createData.formattingOptions;
    }
    doValidation(uri) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const documentModel = this._getTextModel(uri);
                const document = documentModel === null || documentModel === void 0 ? void 0 : documentModel.getValue();
                if (!document) {
                    return [];
                }
                const graphqlDiagnostics = this._languageService.getDiagnostics(uri, document);
                return graphqlDiagnostics.map(utils_1.toMarkerData);
            }
            catch (err) {
                console.error(err);
                return [];
            }
        });
    }
    doComplete(uri, position) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const documentModel = this._getTextModel(uri);
                const document = documentModel === null || documentModel === void 0 ? void 0 : documentModel.getValue();
                if (!document) {
                    return [];
                }
                const graphQLPosition = (0, utils_1.toGraphQLPosition)(position);
                const suggestions = this._languageService.getCompletion(uri, document, graphQLPosition);
                return suggestions.map(suggestion => (0, utils_1.toCompletion)(suggestion));
            }
            catch (err) {
                console.error(err);
                return [];
            }
        });
    }
    doHover(uri, position) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const documentModel = this._getTextModel(uri);
                const document = documentModel === null || documentModel === void 0 ? void 0 : documentModel.getValue();
                if (!document) {
                    return null;
                }
                const graphQLPosition = (0, utils_1.toGraphQLPosition)(position);
                const hover = this._languageService.getHover(uri, document, graphQLPosition);
                const location = {
                    column: graphQLPosition.character,
                    line: graphQLPosition.line,
                };
                return {
                    content: hover,
                    range: (0, utils_1.toMonacoRange)((0, graphql_language_service_1.getRange)(location, document)),
                };
            }
            catch (err) {
                console.error(err);
                return null;
            }
        });
    }
    doGetVariablesJSONSchema(uri) {
        return __awaiter(this, void 0, void 0, function* () {
            const documentModel = this._getTextModel(uri);
            const document = documentModel === null || documentModel === void 0 ? void 0 : documentModel.getValue();
            if (!documentModel || !document) {
                return null;
            }
            const jsonSchema = this._languageService.getVariablesJSONSchema(uri, document, { useMarkdownDescription: true });
            if (jsonSchema) {
                return Object.assign(Object.assign({}, jsonSchema), { $id: 'monaco://variables-schema.json', title: 'GraphQL Variables' });
            }
            return null;
        });
    }
    doFormat(uri) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const documentModel = this._getTextModel(uri);
            const document = documentModel === null || documentModel === void 0 ? void 0 : documentModel.getValue();
            if (!documentModel || !document) {
                return null;
            }
            const prettierStandalone = yield Promise.resolve().then(() => __importStar(require('prettier/standalone')));
            const prettierGraphqlParser = yield Promise.resolve().then(() => __importStar(require('prettier/parser-graphql')));
            return prettierStandalone.format(document, Object.assign({ parser: 'graphql', plugins: [prettierGraphqlParser] }, (_a = this._formattingOptions) === null || _a === void 0 ? void 0 : _a.prettierConfig));
        });
    }
    _getTextModel(uri) {
        const models = this._ctx.getMirrorModels();
        for (const model of models) {
            if (model.uri.toString() === uri) {
                return model;
            }
        }
        return null;
    }
    doUpdateSchema(schema) {
        return this._languageService.updateSchema(schema);
    }
    doUpdateSchemas(schemas) {
        return this._languageService.updateSchemas(schemas);
    }
}
exports.GraphQLWorker = GraphQLWorker;
exports.default = {
    GraphQLWorker,
};
function create(ctx, createData) {
    return new GraphQLWorker(ctx, createData);
}
exports.create = create;
//# sourceMappingURL=GraphQLWorker.js.map