"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LanguageService = void 0;
const graphql_1 = require("graphql");
const picomatch_browser_1 = __importDefault(require("picomatch-browser"));
const graphql_language_service_1 = require("graphql-language-service");
const schemaLoader_1 = require("./schemaLoader");
const schemaCache = new Map();
class LanguageService {
    constructor({ parser, schemas, parseOptions, externalFragmentDefinitions, customValidationRules, fillLeafsOnComplete, completionSettings, }) {
        var _a;
        this._parser = graphql_1.parse;
        this._schemas = [];
        this._schemaCache = schemaCache;
        this._schemaLoader = schemaLoader_1.defaultSchemaLoader;
        this._externalFragmentDefinitionNodes = null;
        this._externalFragmentDefinitionsString = null;
        this.getCompletion = (uri, documentText, position) => {
            const schema = this.getSchemaForFile(uri);
            if (!documentText || !(schema === null || schema === void 0 ? void 0 : schema.schema)) {
                return [];
            }
            return (0, graphql_language_service_1.getAutocompleteSuggestions)(schema.schema, documentText, position, undefined, this.getExternalFragmentDefinitions(), Object.assign({ uri }, this._completionSettings));
        };
        this.getDiagnostics = (uri, documentText, customRules) => {
            const schema = this.getSchemaForFile(uri);
            if (!documentText || documentText.trim().length < 2 || !(schema === null || schema === void 0 ? void 0 : schema.schema)) {
                return [];
            }
            return (0, graphql_language_service_1.getDiagnostics)(documentText, schema.schema, customRules !== null && customRules !== void 0 ? customRules : this._customValidationRules, false, this.getExternalFragmentDefinitions());
        };
        this.getHover = (uri, documentText, position, options) => {
            const schema = this.getSchemaForFile(uri);
            if (schema && documentText.length > 3) {
                return (0, graphql_language_service_1.getHoverInformation)(schema.schema, documentText, position, undefined, Object.assign({ useMarkdown: true }, options));
            }
        };
        this.getVariablesJSONSchema = (uri, documentText, options) => {
            const schema = this.getSchemaForFile(uri);
            if (schema && documentText.length > 3) {
                try {
                    const documentAST = this.parse(documentText);
                    const { variableToType } = (0, graphql_language_service_1.getOperationASTFacts)(documentAST, schema.schema);
                    if (variableToType) {
                        return (0, graphql_language_service_1.getVariablesJSONSchema)(variableToType, Object.assign(Object.assign({}, options), { scalarSchemas: schema.customScalarSchemas }));
                    }
                }
                catch (_a) { }
            }
            return null;
        };
        this._schemaLoader = schemaLoader_1.defaultSchemaLoader;
        if (schemas) {
            this._schemas = schemas;
            this._cacheSchemas();
        }
        if (parser) {
            this._parser = parser;
        }
        this._completionSettings = Object.assign(Object.assign({}, completionSettings), { fillLeafsOnComplete: (_a = completionSettings === null || completionSettings === void 0 ? void 0 : completionSettings.fillLeafsOnComplete) !== null && _a !== void 0 ? _a : fillLeafsOnComplete });
        if (parseOptions) {
            this._parseOptions = parseOptions;
        }
        if (customValidationRules) {
            this._customValidationRules = customValidationRules;
        }
        if (externalFragmentDefinitions) {
            if (Array.isArray(externalFragmentDefinitions)) {
                this._externalFragmentDefinitionNodes = externalFragmentDefinitions;
            }
            else {
                this._externalFragmentDefinitionsString = externalFragmentDefinitions;
            }
        }
    }
    _cacheSchemas() {
        for (const schema of this._schemas) {
            this._cacheSchema(schema);
        }
    }
    _cacheSchema(schemaConfig) {
        const schema = this._schemaLoader(schemaConfig, this.parse.bind(this));
        return this._schemaCache.set(schemaConfig.uri, Object.assign(Object.assign({}, schemaConfig), { schema }));
    }
    getSchemaForFile(uri) {
        if (!this._schemas.length) {
            return;
        }
        if (this._schemas.length === 1) {
            return this._schemaCache.get(this._schemas[0].uri);
        }
        const schema = this._schemas.find(schemaConfig => {
            if (!schemaConfig.fileMatch) {
                return false;
            }
            return schemaConfig.fileMatch.some(glob => {
                const isMatch = (0, picomatch_browser_1.default)(glob);
                return isMatch(uri);
            });
        });
        if (schema) {
            const cacheEntry = this._schemaCache.get(schema.uri);
            if (cacheEntry) {
                return cacheEntry;
            }
            const cache = this._cacheSchema(schema);
            return cache.get(schema.uri);
        }
    }
    getExternalFragmentDefinitions() {
        if (!this._externalFragmentDefinitionNodes &&
            this._externalFragmentDefinitionsString) {
            const definitionNodes = [];
            try {
                (0, graphql_1.visit)(this._parser(this._externalFragmentDefinitionsString), {
                    FragmentDefinition(node) {
                        definitionNodes.push(node);
                    },
                });
            }
            catch (_a) {
                throw new Error(`Failed parsing externalFragmentDefinitions string:\n${this._externalFragmentDefinitionsString}`);
            }
            this._externalFragmentDefinitionNodes = definitionNodes;
        }
        return this._externalFragmentDefinitionNodes;
    }
    updateSchemas(schemas) {
        return __awaiter(this, void 0, void 0, function* () {
            this._schemas = schemas;
            this._cacheSchemas();
        });
    }
    updateSchema(schema) {
        const schemaIndex = this._schemas.findIndex(c => c.uri === schema.uri);
        if (schemaIndex < 0) {
            console.warn('updateSchema could not find a schema in your config by that URI', schema.uri);
            return;
        }
        this._schemas[schemaIndex] = schema;
        this._cacheSchema(schema);
    }
    addSchema(schema) {
        this._schemas.push(schema);
        this._cacheSchema(schema);
    }
    parse(text, options) {
        return this._parser(text, options || this._parseOptions);
    }
}
exports.LanguageService = LanguageService;
//# sourceMappingURL=LanguageService.js.map