"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.completionSettingDefault = exports.diagnosticSettingDefault = exports.formattingDefaults = exports.modeConfigurationDefault = exports.create = exports.MonacoGraphQLAPI = void 0;
const monaco_editor_1 = require("./monaco-editor");
class MonacoGraphQLAPI {
    constructor({ languageId, schemas, modeConfiguration, formattingOptions, diagnosticSettings, completionSettings, }) {
        this._onDidChange = new monaco_editor_1.Emitter();
        this._schemas = null;
        this._schemasById = Object.create(null);
        this._languageId = languageId;
        if (schemas) {
            this.setSchemaConfig(schemas);
        }
        this._modeConfiguration = modeConfiguration;
        this._completionSettings = completionSettings;
        this._diagnosticSettings = diagnosticSettings;
        this._formattingOptions = formattingOptions;
    }
    get onDidChange() {
        return this._onDidChange.event;
    }
    get languageId() {
        return this._languageId;
    }
    get modeConfiguration() {
        return this._modeConfiguration;
    }
    get schemas() {
        return this._schemas;
    }
    schemasById() {
        return this._schemasById;
    }
    get formattingOptions() {
        return this._formattingOptions;
    }
    get diagnosticSettings() {
        return this._diagnosticSettings;
    }
    get completionSettings() {
        var _a;
        return Object.assign(Object.assign({}, this._completionSettings), { fillLeafsOnComplete: (_a = this._completionSettings.__experimental__fillLeafsOnComplete) !== null && _a !== void 0 ? _a : this._completionSettings.fillLeafsOnComplete });
    }
    get externalFragmentDefinitions() {
        return this._externalFragmentDefinitions;
    }
    setSchemaConfig(schemas) {
        this._schemas = schemas;
        this._schemasById = schemas.reduce((result, schema) => {
            result[schema.uri] = schema;
            return result;
        }, Object.create(null));
        this._onDidChange.fire(this);
    }
    setExternalFragmentDefinitions(externalFragmentDefinitions) {
        this._externalFragmentDefinitions = externalFragmentDefinitions;
    }
    setModeConfiguration(modeConfiguration) {
        this._modeConfiguration = modeConfiguration;
        this._onDidChange.fire(this);
    }
    setFormattingOptions(formattingOptions) {
        this._formattingOptions = formattingOptions;
        this._onDidChange.fire(this);
    }
    setDiagnosticSettings(diagnosticSettings) {
        this._diagnosticSettings = diagnosticSettings;
        this._onDidChange.fire(this);
    }
    setCompletionSettings(completionSettings) {
        this._completionSettings = completionSettings;
        this._onDidChange.fire(this);
    }
}
exports.MonacoGraphQLAPI = MonacoGraphQLAPI;
function create(languageId, config) {
    if (!config) {
        return new MonacoGraphQLAPI({
            languageId,
            schemas: [],
            formattingOptions: exports.formattingDefaults,
            modeConfiguration: exports.modeConfigurationDefault,
            diagnosticSettings: exports.diagnosticSettingDefault,
            completionSettings: exports.completionSettingDefault,
        });
    }
    const { schemas, formattingOptions, modeConfiguration, diagnosticSettings, completionSettings, } = config;
    return new MonacoGraphQLAPI({
        languageId,
        schemas,
        formattingOptions: Object.assign(Object.assign(Object.assign({}, exports.formattingDefaults), formattingOptions), { prettierConfig: Object.assign(Object.assign({}, exports.formattingDefaults.prettierConfig), formattingOptions === null || formattingOptions === void 0 ? void 0 : formattingOptions.prettierConfig) }),
        modeConfiguration: Object.assign(Object.assign({}, exports.modeConfigurationDefault), modeConfiguration),
        diagnosticSettings: Object.assign(Object.assign({}, exports.diagnosticSettingDefault), diagnosticSettings),
        completionSettings: Object.assign(Object.assign({}, exports.completionSettingDefault), completionSettings),
    });
}
exports.create = create;
exports.modeConfigurationDefault = {
    documentFormattingEdits: true,
    documentRangeFormattingEdits: false,
    completionItems: true,
    hovers: true,
    documentSymbols: false,
    tokens: false,
    colors: false,
    foldingRanges: false,
    diagnostics: true,
    selectionRanges: false,
};
exports.formattingDefaults = {
    prettierConfig: {
        tabWidth: 2,
    },
};
exports.diagnosticSettingDefault = {
    jsonDiagnosticSettings: {
        schemaValidation: 'error',
    },
};
exports.completionSettingDefault = {
    __experimental__fillLeafsOnComplete: false,
};
//# sourceMappingURL=api.js.map