"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupMode = void 0;
const monaco_editor_1 = require("./monaco-editor");
const workerManager_1 = require("./workerManager");
const languageFeatures = __importStar(require("./languageFeatures"));
function setupMode(defaults) {
    const disposables = [];
    const providers = [];
    const client = new workerManager_1.WorkerManager(defaults);
    disposables.push(client);
    const worker = (...uris) => {
        try {
            return client.getLanguageServiceWorker(...uris);
        }
        catch (_a) {
            throw new Error('Error fetching graphql language service worker');
        }
    };
    function registerSchemaLessProviders() {
        const { modeConfiguration, languageId } = defaults;
        if (modeConfiguration.documentFormattingEdits) {
            providers.push(monaco_editor_1.languages.registerDocumentFormattingEditProvider(languageId, new languageFeatures.DocumentFormattingAdapter(worker)));
        }
    }
    function registerAllProviders(api) {
        const { modeConfiguration, languageId } = defaults;
        disposeAll(providers);
        if (modeConfiguration.completionItems) {
            providers.push(monaco_editor_1.languages.registerCompletionItemProvider(languageId, new languageFeatures.CompletionAdapter(worker)));
        }
        if (modeConfiguration.diagnostics) {
            providers.push(new languageFeatures.DiagnosticsAdapter(api, worker));
        }
        if (modeConfiguration.hovers) {
            providers.push(monaco_editor_1.languages.registerHoverProvider(languageId, new languageFeatures.HoverAdapter(worker)));
        }
        registerSchemaLessProviders();
    }
    let { modeConfiguration, formattingOptions, diagnosticSettings, externalFragmentDefinitions, schemas, } = defaults;
    registerAllProviders(defaults);
    defaults.onDidChange(newDefaults => {
        if (newDefaults.modeConfiguration !== modeConfiguration) {
            modeConfiguration = newDefaults.modeConfiguration;
            registerAllProviders(newDefaults);
        }
        if (newDefaults.formattingOptions !== formattingOptions) {
            formattingOptions = newDefaults.formattingOptions;
            registerSchemaLessProviders();
        }
        if (newDefaults.externalFragmentDefinitions !== externalFragmentDefinitions) {
            externalFragmentDefinitions = newDefaults.externalFragmentDefinitions;
            registerAllProviders(newDefaults);
        }
        if (newDefaults.diagnosticSettings !== diagnosticSettings) {
            diagnosticSettings = newDefaults.diagnosticSettings;
            registerAllProviders(newDefaults);
        }
        if (newDefaults.schemas !== schemas) {
            schemas = newDefaults.schemas;
            registerAllProviders(newDefaults);
        }
    });
    disposables.push(asDisposable(providers));
    return asDisposable(disposables);
}
exports.setupMode = setupMode;
function asDisposable(disposables) {
    return { dispose: () => disposeAll(disposables) };
}
function disposeAll(disposables) {
    while (disposables.length) {
        disposables.pop().dispose();
    }
}
//# sourceMappingURL=graphqlMode.js.map