"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HoverAdapter = exports.DocumentFormattingAdapter = exports.CompletionAdapter = exports.toCompletion = exports.toCompletionItemKind = exports.DiagnosticsAdapter = void 0;
const monaco_editor_1 = require("./monaco-editor");
const editor_api_1 = require("monaco-editor/esm/vs/editor/editor.api");
const graphql_language_service_1 = require("graphql-language-service");
const utils_1 = require("./utils");
class DiagnosticsAdapter {
    constructor(defaults, _worker) {
        this.defaults = defaults;
        this._worker = _worker;
        this._disposables = [];
        this._listener = Object.create(null);
        this._worker = _worker;
        let onChangeTimeout;
        const onModelAdd = (model) => {
            var _a;
            const modeId = (0, utils_1.getModelLanguageId)(model);
            if (modeId !== this.defaults.languageId) {
                return;
            }
            const modelUri = model.uri.toString();
            const jsonValidationForModel = (_a = defaults.diagnosticSettings.validateVariablesJSON) === null || _a === void 0 ? void 0 : _a[modelUri];
            onChangeTimeout = setTimeout(() => {
                void this._doValidate(model.uri, modeId, jsonValidationForModel);
            }, 400);
            this._listener[modelUri] = model.onDidChangeContent(() => {
                clearTimeout(onChangeTimeout);
                onChangeTimeout = setTimeout(() => {
                    void this._doValidate(model.uri, modeId, jsonValidationForModel);
                }, 400);
            });
        };
        const onModelRemoved = (model) => {
            editor_api_1.editor.setModelMarkers(model, this.defaults.languageId, []);
            const uriStr = model.uri.toString();
            const listener = this._listener[uriStr];
            if (listener) {
                listener.dispose();
                delete this._listener[uriStr];
            }
        };
        this._disposables.push(editor_api_1.editor.onDidCreateModel(onModelAdd), {
            dispose() {
                clearTimeout(onChangeTimeout);
            },
        }, editor_api_1.editor.onWillDisposeModel(model => {
            onModelRemoved(model);
        }), editor_api_1.editor.onDidChangeModelLanguage(event => {
            onModelRemoved(event.model);
            onModelAdd(event.model);
        }), {
            dispose: () => {
                for (const listener of Object.values(this._listener)) {
                    listener.dispose();
                }
            },
        }, defaults.onDidChange(() => {
            for (const model of editor_api_1.editor.getModels()) {
                if ((0, utils_1.getModelLanguageId)(model) === this.defaults.languageId) {
                    onModelRemoved(model);
                    onModelAdd(model);
                }
            }
        }));
        for (const model of editor_api_1.editor.getModels()) {
            if ((0, utils_1.getModelLanguageId)(model) === this.defaults.languageId) {
                onModelAdd(model);
            }
        }
    }
    dispose() {
        for (const disposable of this._disposables) {
            disposable.dispose();
        }
        this._disposables = [];
    }
    _doValidate(resource, languageId, variablesUris) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const worker = yield this._worker(resource);
            if (!worker) {
                return;
            }
            const diagnostics = yield worker.doValidation(resource.toString());
            editor_api_1.editor.setModelMarkers(editor_api_1.editor.getModel(resource), languageId, diagnostics);
            if (variablesUris) {
                yield Promise.resolve().then(() => __importStar(require('monaco-editor/esm/vs/language/json/monaco.contribution.js')));
                if (!variablesUris.length) {
                    throw new Error('No variables URI strings provided to validate');
                }
                const jsonSchema = yield worker.doGetVariablesJSONSchema(resource.toString());
                if (!jsonSchema) {
                    return;
                }
                const schemaUri = monaco_editor_1.Uri.file(variablesUris[0].replace('.json', '-schema.json')).toString();
                const configResult = {
                    uri: schemaUri,
                    schema: jsonSchema,
                    fileMatch: variablesUris,
                };
                const currentSchemas = ((_a = monaco_editor_1.languages.json.jsonDefaults.diagnosticsOptions.schemas) === null || _a === void 0 ? void 0 : _a.filter(s => s.uri !== schemaUri)) || [];
                monaco_editor_1.languages.json.jsonDefaults.setDiagnosticsOptions(Object.assign(Object.assign({ schemaValidation: 'error', validate: true }, this.defaults.diagnosticSettings.jsonDiagnosticSettings), { schemas: [...currentSchemas, configResult], enableSchemaRequest: false }));
            }
        });
    }
}
exports.DiagnosticsAdapter = DiagnosticsAdapter;
const mKind = monaco_editor_1.languages.CompletionItemKind;
const kindMap = {
    [graphql_language_service_1.CompletionItemKind.Text]: mKind.Text,
    [graphql_language_service_1.CompletionItemKind.Method]: mKind.Method,
    [graphql_language_service_1.CompletionItemKind.Function]: mKind.Function,
    [graphql_language_service_1.CompletionItemKind.Constructor]: mKind.Constructor,
    [graphql_language_service_1.CompletionItemKind.Field]: mKind.Field,
    [graphql_language_service_1.CompletionItemKind.Variable]: mKind.Variable,
    [graphql_language_service_1.CompletionItemKind.Class]: mKind.Class,
    [graphql_language_service_1.CompletionItemKind.Interface]: mKind.Interface,
    [graphql_language_service_1.CompletionItemKind.Module]: mKind.Module,
    [graphql_language_service_1.CompletionItemKind.Property]: mKind.Property,
    [graphql_language_service_1.CompletionItemKind.Unit]: mKind.Unit,
    [graphql_language_service_1.CompletionItemKind.Value]: mKind.Value,
    [graphql_language_service_1.CompletionItemKind.Enum]: mKind.Enum,
    [graphql_language_service_1.CompletionItemKind.Keyword]: mKind.Keyword,
    [graphql_language_service_1.CompletionItemKind.Snippet]: mKind.Snippet,
    [graphql_language_service_1.CompletionItemKind.Color]: mKind.Color,
    [graphql_language_service_1.CompletionItemKind.File]: mKind.File,
    [graphql_language_service_1.CompletionItemKind.Reference]: mKind.Reference,
    [graphql_language_service_1.CompletionItemKind.Folder]: mKind.Folder,
    [graphql_language_service_1.CompletionItemKind.EnumMember]: mKind.EnumMember,
    [graphql_language_service_1.CompletionItemKind.Constant]: mKind.Constant,
    [graphql_language_service_1.CompletionItemKind.Struct]: mKind.Struct,
    [graphql_language_service_1.CompletionItemKind.Event]: mKind.Event,
    [graphql_language_service_1.CompletionItemKind.Operator]: mKind.Operator,
    [graphql_language_service_1.CompletionItemKind.TypeParameter]: mKind.TypeParameter,
};
function toCompletionItemKind(kind) {
    return kind in kindMap ? kindMap[kind] : mKind.Text;
}
exports.toCompletionItemKind = toCompletionItemKind;
function toCompletion(entry) {
    var _a;
    const suggestions = {
        range: entry.range,
        kind: toCompletionItemKind(entry.kind),
        label: entry.label,
        insertText: (_a = entry.insertText) !== null && _a !== void 0 ? _a : entry.label,
        insertTextRules: entry.insertText
            ? monaco_editor_1.languages.CompletionItemInsertTextRule.InsertAsSnippet
            : undefined,
        sortText: entry.sortText,
        filterText: entry.filterText,
        documentation: entry.documentation,
        detail: entry.detail,
        command: entry.command,
    };
    return suggestions;
}
exports.toCompletion = toCompletion;
class CompletionAdapter {
    constructor(_worker) {
        this._worker = _worker;
        this._worker = _worker;
    }
    get triggerCharacters() {
        return [':', '$', ' ', '(', '@'];
    }
    provideCompletionItems(model, position, _context, _token) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const worker = yield this._worker(model.uri);
                const completionItems = yield worker.doComplete(model.uri.toString(), position);
                return {
                    incomplete: true,
                    suggestions: completionItems.map(toCompletion),
                };
            }
            catch (err) {
                console.error('Error fetching completion items', err);
                return { suggestions: [] };
            }
        });
    }
}
exports.CompletionAdapter = CompletionAdapter;
class DocumentFormattingAdapter {
    constructor(_worker) {
        this._worker = _worker;
        this._worker = _worker;
    }
    provideDocumentFormattingEdits(document, _options, _token) {
        return __awaiter(this, void 0, void 0, function* () {
            const worker = yield this._worker(document.uri);
            const formatted = yield worker.doFormat(document.uri.toString());
            if (!formatted) {
                return [];
            }
            return [
                {
                    range: document.getFullModelRange(),
                    text: formatted,
                },
            ];
        });
    }
}
exports.DocumentFormattingAdapter = DocumentFormattingAdapter;
class HoverAdapter {
    constructor(_worker) {
        this._worker = _worker;
    }
    provideHover(model, position, _token) {
        return __awaiter(this, void 0, void 0, function* () {
            const resource = model.uri;
            const worker = yield this._worker(model.uri);
            const hoverItem = yield worker.doHover(resource.toString(), position);
            if (hoverItem) {
                return {
                    range: hoverItem.range,
                    contents: [{ value: hoverItem.content }],
                };
            }
            return {
                contents: [],
            };
        });
    }
    dispose() { }
}
exports.HoverAdapter = HoverAdapter;
//# sourceMappingURL=languageFeatures.js.map