"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultSchemaLoader = void 0;
const graphql_1 = require("graphql");
const defaultSchemaLoader = (schemaConfig, parser) => {
    const { schema, documentAST, introspectionJSON, introspectionJSONString, buildSchemaOptions, documentString, } = schemaConfig;
    if (schema) {
        return schema;
    }
    if (introspectionJSONString) {
        const introspectionJSONResult = JSON.parse(introspectionJSONString);
        return (0, graphql_1.buildClientSchema)(introspectionJSONResult, buildSchemaOptions);
    }
    if (documentString && parser) {
        const docAST = parser(documentString);
        return (0, graphql_1.buildASTSchema)(docAST, buildSchemaOptions);
    }
    if (introspectionJSON) {
        return (0, graphql_1.buildClientSchema)(introspectionJSON, buildSchemaOptions);
    }
    if (documentAST) {
        return (0, graphql_1.buildASTSchema)(documentAST, buildSchemaOptions);
    }
    throw new Error('No schema supplied');
};
exports.defaultSchemaLoader = defaultSchemaLoader;
//# sourceMappingURL=schemaLoader.js.map