import type * as monaco from '../monaco-editor';
import { IntrospectionQuery, DocumentNode, BuildSchemaOptions, parse, ParseOptions, GraphQLSchema, ValidationRule, FragmentDefinitionNode } from 'graphql';
import { AutocompleteSuggestionOptions, JSONSchema6 } from 'graphql-language-service';
import type { Options as PrettierConfig } from 'prettier';
export declare type SchemaConfig = {
    uri: string;
    fileMatch?: string[];
    buildSchemaOptions?: BuildSchemaOptions;
    schema?: GraphQLSchema;
    documentString?: string;
    documentAST?: DocumentNode;
    introspectionJSON?: IntrospectionQuery;
    introspectionJSONString?: string;
    customScalarSchemas?: Record<string, JSONSchema6>;
};
export declare type SchemaLoader = (schemaConfig: SchemaConfig, parser: GraphQLLanguageConfig['parser']) => GraphQLSchema;
export declare type GraphQLLanguageConfig = {
    parser?: typeof parse;
    parseOptions?: ParseOptions;
    schemaLoader?: SchemaLoader;
    schemas?: SchemaConfig[];
    externalFragmentDefinitions?: FragmentDefinitionNode[] | string;
    customValidationRules?: ValidationRule[];
    completionSettings?: Omit<CompletionSettings, 'uri'>;
    fillLeafsOnComplete?: boolean;
};
export declare type FormattingOptions = {
    prettierConfig?: PrettierConfig;
};
export interface ModeConfiguration {
    readonly documentFormattingEdits?: boolean;
    readonly documentRangeFormattingEdits?: boolean;
    readonly completionItems?: boolean;
    readonly hovers?: boolean;
    readonly documentSymbols?: boolean;
    readonly tokens?: boolean;
    readonly colors?: boolean;
    readonly foldingRanges?: boolean;
    readonly diagnostics?: boolean;
    readonly selectionRanges?: boolean;
}
export declare type DiagnosticSettings = {
    validateVariablesJSON?: Record<string, string[]>;
    jsonDiagnosticSettings?: monaco.languages.json.DiagnosticsOptions;
};
export declare type CompletionSettings = AutocompleteSuggestionOptions & {
    __experimental__fillLeafsOnComplete?: boolean;
};
export interface MonacoGraphQLInitializeConfig extends Pick<GraphQLLanguageConfig, 'schemas'> {
    completionSettings?: CompletionSettings;
    diagnosticSettings?: DiagnosticSettings;
    formattingOptions?: FormattingOptions;
    modeConfiguration?: ModeConfiguration;
}
export interface ICreateData {
    languageId: string;
    formattingOptions?: FormattingOptions;
    languageConfig: GraphQLLanguageConfig;
    diagnosticSettings: DiagnosticSettings;
}
//# sourceMappingURL=index.d.ts.map