"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStringSchema = exports.toMarkerData = exports.toMonacoSeverity = exports.toCompletion = exports.toGraphQLPosition = exports.toMonacoRange = exports.getModelLanguageId = void 0;
const graphql_1 = require("graphql");
const graphql_language_service_1 = require("graphql-language-service");
const getModelLanguageId = (model) => {
    if ('getModeId' in model) {
        return model.getModeId();
    }
    return model.getLanguageId();
};
exports.getModelLanguageId = getModelLanguageId;
function toMonacoRange(range) {
    return {
        startLineNumber: range.start.line + 1,
        startColumn: range.start.character + 1,
        endLineNumber: range.end.line + 1,
        endColumn: range.end.character + 1,
    };
}
exports.toMonacoRange = toMonacoRange;
function toGraphQLPosition(position) {
    return new graphql_language_service_1.Position(position.lineNumber - 1, position.column - 1);
}
exports.toGraphQLPosition = toGraphQLPosition;
function toCompletion(entry, range) {
    return Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign({ label: entry.label, insertText: entry.insertText, sortText: entry.sortText, filterText: entry.filterText }, (entry.documentation && {
        documentation: {
            value: entry.documentation,
        },
    })), { detail: entry.detail }), (range && { range: toMonacoRange(range) })), { kind: entry.kind }), (entry.insertTextFormat && { insertTextFormat: entry.insertTextFormat })), (entry.insertTextMode && { insertTextMode: entry.insertTextMode })), (entry.command && {
        command: Object.assign(Object.assign({}, entry.command), { id: entry.command.command }),
    })), (entry.labelDetails && { labelDetails: entry.labelDetails }));
}
exports.toCompletion = toCompletion;
function toMonacoSeverity(severity) {
    const severityMap = {
        1: 8,
        2: 4,
        3: 2,
        4: 1,
    };
    return severity ? severityMap[severity] : severityMap[2];
}
exports.toMonacoSeverity = toMonacoSeverity;
function toMarkerData(diagnostic) {
    return {
        startLineNumber: diagnostic.range.start.line + 1,
        endLineNumber: diagnostic.range.end.line + 1,
        startColumn: diagnostic.range.start.character + 1,
        endColumn: diagnostic.range.end.character,
        message: diagnostic.message,
        severity: toMonacoSeverity(diagnostic.severity),
        code: diagnostic.code || undefined,
    };
}
exports.toMarkerData = toMarkerData;
const getStringSchema = (schemaConfig) => {
    const { schema: graphQLSchema, documentAST, introspectionJSON, introspectionJSONString, documentString } = schemaConfig, rest = __rest(schemaConfig, ["schema", "documentAST", "introspectionJSON", "introspectionJSONString", "documentString"]);
    if (graphQLSchema) {
        return Object.assign(Object.assign({}, rest), { documentString: (0, graphql_1.printSchema)(graphQLSchema) });
    }
    if (introspectionJSONString) {
        return Object.assign(Object.assign({}, rest), { introspectionJSONString });
    }
    if (documentString) {
        return Object.assign(Object.assign({}, rest), { documentString });
    }
    if (introspectionJSON) {
        return Object.assign(Object.assign({}, rest), { introspectionJSONString: JSON.stringify(introspectionJSON) });
    }
    if (documentAST) {
        const schema = (0, graphql_1.buildASTSchema)(documentAST, rest.buildSchemaOptions);
        return Object.assign(Object.assign({}, rest), { documentString: (0, graphql_1.printSchema)(schema) });
    }
    throw new Error('No schema supplied');
};
exports.getStringSchema = getStringSchema;
//# sourceMappingURL=utils.js.map