import { ICreateData, SchemaConfig } from './typings';
import type * as monaco from './monaco-editor';
import { GraphQLWorkerCompletionItem } from './utils';
export declare class GraphQLWorker {
    private _ctx;
    private _languageService;
    private _formattingOptions;
    constructor(ctx: monaco.worker.IWorkerContext, createData: ICreateData);
    doValidation(uri: string): Promise<monaco.editor.IMarkerData[]>;
    doComplete(uri: string, position: monaco.Position): Promise<GraphQLWorkerCompletionItem[]>;
    doHover(uri: string, position: monaco.Position): Promise<{
        content: import("vscode-languageserver-types").MarkupContent | import("vscode-languageserver-types").MarkedString | import("vscode-languageserver-types").MarkedString[] | undefined;
        range: monaco.IRange;
    } | null>;
    doGetVariablesJSONSchema(uri: string): Promise<unknown>;
    doFormat(uri: string): Promise<string | null>;
    private _getTextModel;
    doUpdateSchema(schema: SchemaConfig): void;
    doUpdateSchemas(schemas: SchemaConfig[]): Promise<void>;
}
declare const _default: {
    GraphQLWorker: typeof GraphQLWorker;
};
export default _default;
export declare function create(ctx: monaco.worker.IWorkerContext, createData: ICreateData): GraphQLWorker;
//# sourceMappingURL=GraphQLWorker.d.ts.map