import { GraphQLSchema, ParseOptions, ValidationRule, FragmentDefinitionNode, DocumentNode, Source } from 'graphql';
import type { IPosition } from 'graphql-language-service';
import { HoverConfig, JSONSchemaOptions } from 'graphql-language-service';
import { SchemaConfig, GraphQLLanguageConfig } from './typings';
declare type SchemaCacheItem = Omit<SchemaConfig, 'schema'> & {
    schema: GraphQLSchema;
};
export declare class LanguageService {
    private _parser;
    private _schemas;
    private _schemaCache;
    private _schemaLoader;
    private _parseOptions?;
    private _customValidationRules?;
    private _externalFragmentDefinitionNodes;
    private _externalFragmentDefinitionsString;
    private _completionSettings;
    constructor({ parser, schemas, parseOptions, externalFragmentDefinitions, customValidationRules, fillLeafsOnComplete, completionSettings, }: GraphQLLanguageConfig);
    private _cacheSchemas;
    private _cacheSchema;
    getSchemaForFile(uri: string): SchemaCacheItem | undefined;
    getExternalFragmentDefinitions(): FragmentDefinitionNode[];
    updateSchemas(schemas: SchemaConfig[]): Promise<void>;
    updateSchema(schema: SchemaConfig): void;
    addSchema(schema: SchemaConfig): void;
    parse(text: string | Source, options?: ParseOptions): DocumentNode;
    getCompletion: (uri: string, documentText: string, position: IPosition) => import("graphql-language-service").CompletionItem[];
    getDiagnostics: (uri: string, documentText: string, customRules?: ValidationRule[]) => import("vscode-languageserver-types").Diagnostic[];
    getHover: (uri: string, documentText: string, position: IPosition, options?: HoverConfig) => import("vscode-languageserver-types").MarkupContent | import("vscode-languageserver-types").MarkedString | import("vscode-languageserver-types").MarkedString[] | undefined;
    getVariablesJSONSchema: (uri: string, documentText: string, options?: JSONSchemaOptions) => import("json-schema").JSONSchema6 | null;
}
export {};
//# sourceMappingURL=LanguageService.d.ts.map