import type * as monaco from './monaco-editor';
import type { FragmentDefinitionNode, GraphQLSchema } from 'graphql';
import type { CompletionSettings, DiagnosticSettings, FormattingOptions, ModeConfiguration, MonacoGraphQLInitializeConfig, SchemaConfig } from './typings';
export interface MonacoGraphQLAPIOptions extends Pick<MonacoGraphQLInitializeConfig, 'schemas'>, Pick<Required<MonacoGraphQLInitializeConfig>, 'modeConfiguration' | 'formattingOptions' | 'diagnosticSettings' | 'completionSettings'> {
    languageId: string;
}
export declare type SchemaEntry = {
    schema: GraphQLSchema;
    documentString?: string;
    introspectionJSONString?: string;
};
export declare class MonacoGraphQLAPI {
    private _onDidChange;
    private _formattingOptions;
    private _modeConfiguration;
    private _diagnosticSettings;
    private _completionSettings;
    private _schemas;
    private _schemasById;
    private _languageId;
    private _externalFragmentDefinitions;
    constructor({ languageId, schemas, modeConfiguration, formattingOptions, diagnosticSettings, completionSettings, }: MonacoGraphQLAPIOptions);
    get onDidChange(): monaco.IEvent<MonacoGraphQLAPI>;
    get languageId(): string;
    get modeConfiguration(): ModeConfiguration;
    get schemas(): SchemaConfig[] | null;
    schemasById(): Record<string, SchemaConfig>;
    get formattingOptions(): FormattingOptions;
    get diagnosticSettings(): DiagnosticSettings;
    get completionSettings(): CompletionSettings;
    get externalFragmentDefinitions(): string | FragmentDefinitionNode[] | undefined;
    setSchemaConfig(schemas: SchemaConfig[]): void;
    setExternalFragmentDefinitions(externalFragmentDefinitions: string | FragmentDefinitionNode[]): void;
    setModeConfiguration(modeConfiguration: ModeConfiguration): void;
    setFormattingOptions(formattingOptions: FormattingOptions): void;
    setDiagnosticSettings(diagnosticSettings: DiagnosticSettings): void;
    setCompletionSettings(completionSettings: CompletionSettings): void;
}
export declare function create(languageId: string, config?: MonacoGraphQLInitializeConfig): MonacoGraphQLAPI;
export declare const modeConfigurationDefault: Required<ModeConfiguration>;
export declare const formattingDefaults: FormattingOptions;
export declare const diagnosticSettingDefault: DiagnosticSettings;
export declare const completionSettingDefault: CompletionSettings;
//# sourceMappingURL=api.d.ts.map